module -- remsign
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/types.t.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/einfo.t.t"
#include "../expr/pprint.t"
#include "../expr/constr.t.t"
#include "../rename/renameutil.t"
#include "../misc/misc.t"
#include "../misc/util.t"
#include "../misc/flags.t"
#include "../type/conutil.t"		-- issuper
#include "lettrans.t"
#include "failcase.t"
#include "cutil.t"
#include "../funnos.h"
#include <Option>
#include <OK>

-- Remove class and instance declarations.
-- Also do all remaing checks of validity.

export remclass;
rec remclass e = if Curry then rc e else e
and
    rc t =
	case t in
	   (mkap f a) :  mkap (rc f) (rc a)
	|| (mklam e1 e) : mklam e1 (rc e)
	|| (mkcase e cl) : mkcase (rc e) (map rcp cl)
	|| (mkletv b e) : mkletv (rcb b) (rc e)
	|| (mkident i) : t
	|| (mkmodule i fl il el b) : mkmodule i fl il el (rcb b)
	|| (mkconst _) : t
	|| (mkconstr c el) : mkconstr c (map (rc) el)
	|| (mkcondp p c) : mkcondp (rc p) (rc c)
	|| (mklazyp p) : mklazyp (rc p)
	|| (mkinfo t e) : mkinfo t (rc e)
	|| (mkerror _) : t
	|| (mkfailmatch _) : t
	end
and
    rcb d =
	case d in
	   (mkbrec b) : mkbrec (rcb b)
	|| (mkband b1 b2) : mkband (rcb b1) (rcb b2)
	|| (mkblocal b1 b2) : mkblocal (rcb b1) (rcb b2)
	|| (mkbpat pl) : mkbpat (map rcp pl)
	|| (mkbmulti p e) : let (np,ne) = rcp (p,e) in mkbmulti np ne
	|| (mkbclass t b) : rclass t b
	|| (mkbinstance t b (Some i)) : rinst t b i
        || _ : d
	end

    -- Pick out default methods and insert missing ones
and rclass cl b =
    case classchk cl in
	None :
        let (mkid _ _ (idi_class (clsi _ iits _ _ _)) _) = clsname cl in
	-- pick out default defs, and rename them
	let ies = concmap (pickbs (mkal iits)) (listify b) in
        -- make other default methods
	let ifs = map (\(d,m,t).mkbpat [(mkident d, mkinfo (restr t) (assocdefeq eqid d ies (mfail m)))]) iits in
	andify ifs
    ||  Some msg : mkberror msg
    end

and mkal iits = map (\(dmt as (_,m,_)).(idtostr m,dmt)) iits
and pickbs al (mkbpat [(mkident i, e)]) = [convid al i e]
||  pickbs _ _ = []
and convid al i e =
    let (d,m,t) = assoc (idtostr i) al in
    (d, e)
and mfail m = tfail ("No default for "@oprid m)
-- Turn the instance declaration into a method vector.
-- t is the instance declaration, b are the bindings, vi is the method vector id (including method operator ids)
and rinst t b (vi as mkid un _ (idi_inst _ mis _) _) =
    case instchk t in
	None :
        let (mkidecl k (ci as mkid _ _ (idi_class (clsi _ iits sis _ nsup)) _) ti vs) = t in
	let bs = map ipickbs (listify b) in
	let sm = length (filter (\(s, is).length is = 1) sis) in
	let nbs = map2 (makemetbind k bs) (tail sm mis) iits in
        -- unique numbers have been reserved in rename
        case mkmvec t un vi mis in
	    No msg : mkberror msg
        ||  Yes bs : andify (bs.nbs)
        end
    ||  Some msg : mkberror msg
    end
||  rinst _ _ vi = fail ("Bad rinst "@prid vi)


-- Make a binding for a method, use binding if present else make one to the default method
and makemetbind k bs mi (d,m,t) = 
    let (Ohastype tr _) = type_of_id mi in
    mkbpat [(mkident mi, mkinfo (restr (xmkcontext k tr)) (assocdef (idtostr m) bs (mkident d)))]
and ipickbs (mkbpat [(mkident i, e)]) = (idtostr i, e)
||  ipickbs b = fail ("No match in ipickbs "@prdefg 0 b)
and xmkcontext [] t = t
||  xmkcontext ts t = mktcontype ts t

-- Build the method vector.  It's a function taking other vectors and then
-- an integer selector.  Don't typecheck this!
-- Unique numbers have been reserved by rename.
and mkmvec (id as mkidecl aas (ci as mkid _ _ (idi_class (clsi _ _ sups _ nsup)) _) _ _) u vi is = 
    let k = length aas in
    let m = mkident (mknewid "mm" (u-k-1)) in
    let vecs = map2 (\n.\(mkassert ci _).mkident (mknewid ("dict"@idtostr ci) n)) (from (u-k)) aas in
    let sis = head nsup is
    and mis = tail nsup is in
    let ses = map (bldsupdict id vecs) (head nsup sups) in
    let mpes = map2 (\i.\n.(mkconst (cint n), apl (mkident i) vecs)) mis (from nsup)
    and spes = map3 (\i.\n.\(Yes es).(mkconst (cint n), apl (mkident i) es)) sis (from 0) ses in
    findf ses isno (\(No x).No x) (Yes (mkbpat [(mkident vi, mkinfo notchk (reduce mklam (mklam m (mkcase m (spes@mpes))) vecs))]))
||  mkmvec (mkidecl _ ci _ _) _ _ _ = fail ("Bad mkmvec: "@prid ci)

and apl e l = revitlist (\a.\f.mkap f a) l e

-- Build the dictionaries for the superclasses, if possible
and bldsupdict (id as mkidecl aas ci ti vs) vecs ((si as mkid _ _ (idi_class (clsi _ _ _ insts _)) _), _) =
    let msg = prttype (idecl2type id) in
    case findit ti insts in
	None : No ("No instance for superclass "@oprid si@" in "@msg)
    ||  Some (sid as mkidecl saas _ _ svs) : -- Check that the current contxt implies the superclass context
	    let al = combine (vs, svs) in
	    let saas' = map (\(mkassert ci v).mkassert ci (assoc v al)) saas in
	    let r = mapfilter (impl1 (combine (aas, vecs))) saas' in
let rrr =
	    if length r = length saas then
		Yes (map (\(i,ns).apl i (map mkint ns)) r)
	    else
		No ("Bad instance for superclass "@oprid si@" in "@msg)
in
--trace (force ("bldsupdict for "@msg@" super="@prttype (idecl2type sid)@" vecs="@show_list pprx vecs@" is\n"@show_list (show_pair(pprx,show_list show_int)) r))
rrr
    end
and pprx e = butlast (ppr e)

and impl1 xs (mkassert ci v) = 
    case sort (\(_,l1).\(_,l2).length l1 < length l2) (mapfilter (\(mkassert xi w, i).if v=w then supsel i ci xi else None) xs) in
	[] : None
    ||  (x._) : Some x
    end
and supsel ii i j & (eqid i j) = Some (ii, [])
||  supsel ii i (j as mkid _ _ (idi_class (clsi _ _ iis _ _)) _) = 
    findf iis (\(si,ns).eqid i si) (\(_, ns).Some (ii, ns)) None

/*
and impl1 xs (mkassert ci v) =
    findf xs (\(mkassert xi w, i).v=w & (eqid ci xi | issuper ci xi)) (\(mkassert xi _, i).Some (i, supsel ci xi)) None
and supsel i j & (eqid i j) = []
||  supsel i (j as mkid _ _ (idi_class (clsi _ _ iis _ _)) _) = assocdefeq eqid i iis (fail "supsel")
*/		 

-- Find the instance decl for the type tt in a list
and findit tt ps = findf ps (\(_, t).eqid tt (ityname t)) (Some o snd) None


and rcp (p, e) = (p, rc e)

and getavars aas = map (\(mkassert _ v).v) aas

-- Check class declaration
and classchk (cd as mkcdecl aas a) =
    -- Check type variables
    if ~ allsame (getavars (a.aas)) then
	Some ("Bad type variables in class declaration: "@prttype (cdecl2type cd))
    else
	None

and vischk i = id_visibility i = Vimported & ~ inprelude (id_orignames i)

-- Check instance declaration
and instchk (id as mkidecl aas ci ti vs) =
    let sdcl = prttype (idecl2type id) in
    if vischk ci & vischk ti & ~ AllowRedef then
	Some ("Type or class must be in this module: "@sdcl)
    -- Check type variables
    else if difference (getavars aas) vs ~= [] then
	Some ("Bad type variables in instance declaration: "@sdcl)
    else if id_issyn ti then
	Some ("Type synonym in instance declaration: "@sdcl)
    else
	None
end
