module -- subst
--
-- $Header: /ufs/usr.src/local/lml/src/type/RCS/subst.m,v 97.0 90/07/07 14:42:43 augustss Exp $
--
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../Expr/Expr.t.t"
#include "../misc/flags.t"
#include "subst.t.t"
#include "unify.t"
#include "conutil.t"
#include <OK>
/*import Unify:	(Ttype->(Ttype->Subst));*/

export emptyTR, addTR, combTR, pruneTR, inst, TRtype, instTR, prTR, chkgen, addconTR, TRdict, extractcon, prunecontext, normtype;

rec
-- The list in an substitution is always ordered, highest variable first.
-- The substitution is always idempotent, ie. nothing happens when applying
-- it to itself.
    emptyTR = ok [] []
and pruneTR n (ok k t) = ok k (filter (\(a,b).a<n | TestN > 1) t) --!!! remove Test later
 || pruneTR _ s = s
and prunecontext vs (S as ok [] _) = S
||  prunecontext vs (ok aas t) = ok (filter (\(mkassert _ v).mem v vs) aas) t
||  prunecontext _ S = S
and isngtvar (mktvar v) ngs = ~ mem v ngs
||  isngtvar _ _ = false
and implies a b = ~a | b
and chkgen ts (s as ok _ ss) t1 t2 ngs = 
	if all (\(a,b).implies (mem a ts) (isngtvar b ngs)) ss then
		s
	else
		bad ["Bad restriction "@prttype t2@" of type "@prttype t1]
||  chkgen _ s _ _ _ = s
#if 1
and prTR (ok k x) = show_list (\(mkassert i v).prttype (mktcons i [mktvar v])) k @ show_list (\(a,b).(itos a)@"==>"@prttype b) x
 || prTR (bad s) = "Bad subst "@mix s ", "@"\n"
#endif
-- TRtype' is used very much, so use explicit recursion instead of Typerec
and TRcon ss k = flatcollaps (map (TRcon1 ss) k)
and TRcon1 ss (mkassert ci v) = (ci, assocdef v ss (mktvar v))
and TRcon11 v t (mkassert ci v1) = (ci, if v = v1 then t else mktvar v1)
and TRtype' ss (mktcontype k t) = zmktcontype (TRcon ss k) (TRtype' ss t)
||  TRtype' ss (mktcons i ts) = mktcons i (map (TRtype' ss) ts)
||  TRtype' ss (t as mktvar v) = assocdef v ss t
||  TRtype' ss t = fail ("Bad TRtype' "@prttype t)

and zmktcontype (No msg) _ = mkterror msg
||  zmktcontype (Yes k) t = xmkcontype k t

-- special case: substitute for one variable
and /*TRtype1 v tn (mktcontype ts t) = mktcontype (map (TRtype1 v tn) ts) (TRtype1 v tn t)
||*/  TRtype1 v tn (mktcons i ts) = mktcons i (map (TRtype1 v tn) ts)
||  TRtype1 v tn (t as mktvar v1) = if v = v1 then tn else t
||  TRtype1 v tn t = fail ("Bad TRtype1 "@prttype t)
and TRtype (ok _ ss) t = TRtype' ss t
 || TRtype _ t = t
and TRsubst s t = mapsnd (TRtype' s) t
-- special case: substitute for one variable
and TRsubst1 v t ss = mapsnd (TRtype1 v t) ss
and insTR s ss = /*trace ("insTR "@prTR (ok [] [s])@" in "@prTR (ok [] ss))*/ (insTR' s ss) 
and insTR' s [] = [s]
 || insTR' (s1 as (v1,_)) (ss as ((s2 as (v2,_)).l2)) = 
 	if (v1 > v2) then
		s1.ss
	else -- v1 < v2, because v1 = v2 is filtered out by addTR
		s2.insTR' s1 l2
-- combTR should be improved, it has horrible complexity!
and combTR (ok k a)     b = addconTR k (reduce addTR' b a)
 || combTR (S as bad a) _ = S
 || combTR _ (S as bad a) = S
and addTR' (v,t') (ok k' s') =
    let t = TRtype' s' t' in
    let s = TRsubst1 v t s' in
    case flatcollaps (map (TRcon11 v t) k') in
        Yes k :
	    case assocdef v s (mktvar 0) in
		-- not found, this is easy
		mktvar 0 : if mem v (getTvars t) then
		               badu "occurence" (mktvar v) t 
			   else 
			       ok k (insTR (v,t) s)
		-- found it, must unify.
	    || t' : case Unify t t' in
		        ok [] [] : ok k s	-- speedup only
		    || (S as ok _ _) : combTR S (ok k s)
		    || x : x		-- bad
		    end
	    end
    || No msg : bad [msg]
    end
 || addTR' _ s = s			-- bad
and addTR a s = --trace ("addTR "@prTR (ok [] [a])@" to "@prTR s)
(
combTR (ok [] [a]) s
)
-- This is used a lot, efficiency could be better.
and instTR gl u = let l = length gl in
                  let al = map2 (\g.\v.(g, mktvar v)) gl (from u) in
		  let ali = map2 (\g.\v.(g,v)) gl (from u) in
		  ((\t.case t in
			  mktcontype aas st : 
			      mktcontype (map (\(mkassert ci v).mkassert ci (assocdef v ali v)) aas) (tsubst al st)
		       ||  _ : tsubst al t
		       end), u+l)
and inst typ [] u = (typ, u)
 || inst typ gl u = let! (T, un) = instTR gl u in (T typ, un)

-- Context stuff
and addconTR [] S = S
||  addconTR _  (S as bad _) = S
||  addconTR k (ok kk ss) = 
        case TRcon ss k in
	    Yes k : ok (combcon k kk) ss
        ||  No msg : bad [msg]
	end
and TRdict S D = map (\(i,(d, t)).(i, (d, TRtype S t))) D
and extractcon vs (bad _) = []
||  extractcon vs (ok ks _) = filter (\(mkassert _ v).mem v vs) ks

-- Make type vars go from 0 and up
and normtype t =
	let tvs = getTvars t in
        let al = combine (tvs, map mktvar (from 0)) in
	TRtype' al t
end
