functor LexMLYACC(structure Tokens : Mlyacc_TOKENS
			   structure Hdr : HEADER
	                   sharing Hdr = Header) : ARG_LEXER=
   struct
    structure UserDeclarations =
      struct
(* ML-Yacc Parser Generator (c) 1989 Andrew W. Appel, David R. Tarditi

   yacc.lex: Lexer specification
 *)

structure Tokens = Tokens
type svalue = Tokens.svalue
type pos = int
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult = (svalue,pos) token

type lexarg = Hdr.inputSource
type arg = lexarg

open Tokens
val error = Hdr.error
val lineno = Hdr.lineno
val text = Hdr.text

val pcount = ref 0
val commentLevel = ref 0
val actionstart = ref 0

val eof = fn i => (if (!pcount)>0 then
			error i (!actionstart)
			      " eof encountered in action beginning here !"
		   else (); EOF(!lineno,!lineno))

val Add = fn s => (text := s::(!text))

val lookup =
   let val dict = [("%prec",PREC_TAG),("%term",TERM),
		  ("%nonterm",NONTERM), ("%eop",PERCENT_EOP),("%start",START),
		  ("%prefer",PREFER),("%subst",SUBST),
		  ("%keyword",KEYWORD),("%name",NAME),
		  ("%verbose",VERBOSE), ("%nodefault",NODEFAULT),
		  ("%value",VALUE), ("%noshift",NOSHIFT),
		  ("%header",PERCENT_HEADER),("%pure",PERCENT_PURE),
		  ("%arg",PERCENT_ARG),
		  ("%pos",PERCENT_POS)]
   in fn (s,left,right) =>
	    let fun f ((a,d)::b) = if a=s then d(left,right) else f b
	 	  | f nil = UNKNOWN(s,left,right)
	    in f dict
    	    end
   end
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\015\015\015\015\015\015\015\015\015\015\021\015\015\015\015\015\
\\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\
\\015\015\015\015\015\019\015\015\017\015\015\015\015\015\015\015\
\\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\
\\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\
\\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\
\\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\
\\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\015\
\\015"
val s3 =
"\022\022\022\022\022\022\022\022\022\066\068\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\066\022\022\022\022\046\022\044\042\022\041\022\040\038\022\022\
\\036\036\036\036\036\036\036\036\036\036\035\022\022\034\022\022\
\\022\026\026\026\026\026\026\026\026\026\026\026\026\026\026\026\
\\026\026\026\026\026\026\026\026\026\026\026\022\022\022\022\022\
\\022\026\026\026\026\026\031\026\026\026\026\026\026\026\026\029\
\\026\026\026\026\026\026\026\026\026\026\026\025\024\023\022\022\
\\022"
val s5 =
"\069\069\069\069\069\069\069\069\069\069\021\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\073\069\069\069\069\069\071\070\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069"
val s7 =
"\074\074\074\074\074\074\074\074\074\076\021\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\076\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\075\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\074\
\\074"
val s9 =
"\078\078\078\078\078\078\078\078\078\078\021\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\082\081\079\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078"
val s11 =
"\084\084\084\084\084\084\084\084\084\084\089\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\088\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\085\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084"
val s13 =
"\090\090\090\090\090\090\090\090\090\090\021\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\094\093\091\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090"
val s15 =
"\016\016\016\016\016\016\016\016\016\016\000\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\000\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016"
val s17 =
"\016\016\016\016\016\016\016\016\016\016\000\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\000\016\016\016\016\018\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\016\
\\016"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\020\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s26 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\027\000\000\000\000\000\000\028\000\
\\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\000\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\000\000\000\000\027\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\
\\000"
val s29 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\027\000\000\000\000\000\000\028\000\
\\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\000\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\000\000\000\000\027\
\\000\027\027\027\027\027\030\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\
\\000"
val s31 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\027\000\000\000\000\000\000\028\000\
\\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\000\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\000\000\000\000\027\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\032\
\\027\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\
\\000"
val s32 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\027\000\000\000\000\000\000\028\000\
\\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\000\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\000\000\000\000\027\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\033\027\027\027\027\027\027\027\027\000\000\000\000\000\
\\000"
val s36 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\037\037\037\037\037\037\037\037\037\037\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s38 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s42 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\043\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s44 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\045\000\000\000\000\000\000\000\000\
\\045\045\045\045\045\045\045\045\045\045\000\000\000\000\000\000\
\\000\045\045\045\045\045\045\045\045\045\045\045\045\045\045\045\
\\045\045\045\045\045\045\045\045\045\045\045\000\000\000\000\045\
\\000\045\045\045\045\045\045\045\045\045\045\045\045\045\045\045\
\\045\045\045\045\045\045\045\045\045\045\045\000\000\000\000\000\
\\000"
val s46 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\065\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\047\047\047\061\047\053\047\
\\047\047\048\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s47 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s48 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\049\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s49 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\050\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s50 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\051\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s51 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\052\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s53 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\047\047\047\047\047\047\054\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s54 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\047\047\047\047\047\055\047\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\056\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s56 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\057\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s57 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\058\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s58 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\047\047\047\047\047\047\059\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\060\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s61 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\062\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s62 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\063\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\047\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s63 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\047\
\\000\047\047\047\047\047\047\047\047\047\047\047\047\047\047\047\
\\047\047\047\047\064\047\047\047\047\047\047\000\000\000\000\000\
\\000"
val s66 =
"\000\000\000\000\000\000\000\000\000\067\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\067\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s69 =
"\069\069\069\069\069\069\069\069\069\069\000\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\000\069\069\069\069\069\000\000\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\069\
\\069"
val s71 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\072\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s76 =
"\000\000\000\000\000\000\000\000\000\077\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\077\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s78 =
"\078\078\078\078\078\078\078\078\078\078\000\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\000\000\000\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078"
val s79 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\080\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s82 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\083\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s84 =
"\084\084\084\084\084\084\084\084\084\084\000\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\000\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\000\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\084\
\\084"
val s85 =
"\000\000\000\000\000\000\000\000\000\087\087\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\087\000\086\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s90 =
"\090\090\090\090\090\090\090\090\090\090\000\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\000\000\000\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\090\
\\090"
val s91 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\092\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s94 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\095\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.fromList
[{fin = [], trans = s0},
{fin = [], trans = s1},
{fin = [], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [], trans = s5},
{fin = [], trans = s5},
{fin = [], trans = s7},
{fin = [], trans = s7},
{fin = [], trans = s9},
{fin = [], trans = s9},
{fin = [], trans = s11},
{fin = [], trans = s11},
{fin = [], trans = s13},
{fin = [], trans = s13},
{fin = [(N 11),(N 18)], trans = s15},
{fin = [(N 11)], trans = s15},
{fin = [(N 11),(N 18)], trans = s17},
{fin = [(N 2),(N 11)], trans = s15},
{fin = [(N 18)], trans = s19},
{fin = [(N 14)], trans = s0},
{fin = [(N 16)], trans = s0},
{fin = [(N 96)], trans = s0},
{fin = [(N 38),(N 96)], trans = s0},
{fin = [(N 89),(N 96)], trans = s0},
{fin = [(N 36),(N 96)], trans = s0},
{fin = [(N 92),(N 96)], trans = s26},
{fin = [(N 92)], trans = s26},
{fin = [(N 79)], trans = s0},
{fin = [(N 92),(N 96)], trans = s29},
{fin = [(N 28),(N 92)], trans = s26},
{fin = [(N 92),(N 96)], trans = s31},
{fin = [(N 92)], trans = s32},
{fin = [(N 32),(N 92)], trans = s26},
{fin = [(N 34),(N 96)], trans = s0},
{fin = [(N 87),(N 96)], trans = s0},
{fin = [(N 82),(N 96)], trans = s36},
{fin = [(N 82)], trans = s36},
{fin = [(N 96)], trans = s38},
{fin = [(N 45)], trans = s0},
{fin = [(N 40),(N 96)], trans = s0},
{fin = [(N 42),(N 96)], trans = s0},
{fin = [(N 94),(N 96)], trans = s42},
{fin = [(N 5)], trans = s0},
{fin = [(N 75),(N 96)], trans = s44},
{fin = [(N 75)], trans = s44},
{fin = [(N 96)], trans = s46},
{fin = [(N 72)], trans = s47},
{fin = [(N 72)], trans = s48},
{fin = [(N 72)], trans = s49},
{fin = [(N 72)], trans = s50},
{fin = [(N 72)], trans = s51},
{fin = [(N 58),(N 72)], trans = s47},
{fin = [(N 72)], trans = s53},
{fin = [(N 72)], trans = s54},
{fin = [(N 72)], trans = s55},
{fin = [(N 72)], trans = s56},
{fin = [(N 72)], trans = s57},
{fin = [(N 72)], trans = s58},
{fin = [(N 72)], trans = s59},
{fin = [(N 68),(N 72)], trans = s47},
{fin = [(N 72)], trans = s61},
{fin = [(N 72)], trans = s62},
{fin = [(N 72)], trans = s63},
{fin = [(N 51),(N 72)], trans = s47},
{fin = [(N 85)], trans = s0},
{fin = [(N 25),(N 96)], trans = s66},
{fin = [(N 25)], trans = s66},
{fin = [(N 20)], trans = s0},
{fin = [(N 105)], trans = s69},
{fin = [(N 100)], trans = s0},
{fin = [(N 98)], trans = s71},
{fin = [(N 8)], trans = s0},
{fin = [(N 102)], trans = s0},
{fin = [(N 149)], trans = s0},
{fin = [(N 147),(N 149)], trans = s0},
{fin = [(N 145),(N 149)], trans = s76},
{fin = [(N 145)], trans = s76},
{fin = [(N 116)], trans = s78},
{fin = [(N 107)], trans = s79},
{fin = [(N 110)], trans = s0},
{fin = [(N 107)], trans = s0},
{fin = [(N 107)], trans = s82},
{fin = [(N 113)], trans = s0},
{fin = [(N 136)], trans = s84},
{fin = [(N 131)], trans = s85},
{fin = [(N 139)], trans = s0},
{fin = [(N 142)], trans = s0},
{fin = [(N 129)], trans = s0},
{fin = [(N 133)], trans = s0},
{fin = [(N 127)], trans = s90},
{fin = [(N 118)], trans = s91},
{fin = [(N 121)], trans = s0},
{fin = [(N 118)], trans = s0},
{fin = [(N 118)], trans = s94},
{fin = [(N 124)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val A = STARTSTATE 3;
val CODE = STARTSTATE 5;
val COMMENT = STARTSTATE 9;
val EMPTYCOMMENT = STARTSTATE 13;
val F = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val STRING = STARTSTATE 11;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as (inputSource)) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = String.extract i0 i (!yyb)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  100 => (Ref.dec pcount;
		    if !pcount = 0 then
			 PROG (implode (rev (!text)),!lineno,!lineno)
		    else (Add yytext; continue()))
| 102 => (Add yytext; YYBEGIN STRING; continue())
| 105 => (Add yytext; continue())
| 107 => (Add yytext; continue())
| 11 => (Add yytext; continue())
| 110 => (Add yytext; Ref.dec commentLevel;
		    if !commentLevel=0
			 then BOGUS_VALUE(!lineno,!lineno)
			 else continue()
		   )
| 113 => (Add yytext; Ref.inc commentLevel; continue())
| 116 => (Add yytext; continue())
| 118 => (continue())
| 121 => (Ref.dec commentLevel;
		          if !commentLevel=0 then YYBEGIN A else ();
			  continue ())
| 124 => (Ref.inc commentLevel; continue())
| 127 => (continue())
| 129 => (Add yytext; YYBEGIN CODE; continue())
| 131 => (Add yytext; continue())
| 133 => (Add yytext; error inputSource (!lineno) "unclosed string";
 	            Ref.inc lineno; YYBEGIN CODE; continue())
| 136 => (Add yytext; continue())
| 139 => (Add yytext; continue())
| 14 => (YYBEGIN A; HEADER (implode (rev (!text)),!lineno,!lineno))
| 142 => (Add yytext;
			if String.extract 1 2 yytext="\n" then Ref.inc lineno else ();
		     	YYBEGIN F; continue())
| 145 => (Add yytext; continue())
| 147 => (Add yytext; YYBEGIN STRING; continue())
| 149 => (Add yytext; error inputSource (!lineno) "unclosed string";
		    YYBEGIN CODE; continue())
| 16 => (Add yytext; Ref.inc lineno; continue())
| 18 => (Add yytext; continue())
| 2 => (Add yytext; YYBEGIN COMMENT; commentLevel := 1;
		    continue() before YYBEGIN INITIAL)
| 20 => (Ref.inc lineno; continue ())
| 25 => (continue())
| 28 => (OF(!lineno,!lineno))
| 32 => (FOR(!lineno,!lineno))
| 34 => (EQUAL(!lineno,!lineno))
| 36 => (LBRACE(!lineno,!lineno))
| 38 => (RBRACE(!lineno,!lineno))
| 40 => (COMMA(!lineno,!lineno))
| 42 => (ASTERISK(!lineno,!lineno))
| 45 => (ARROW(!lineno,!lineno))
| 5 => (YYBEGIN EMPTYCOMMENT; commentLevel := 1; continue())
| 51 => (PREC(Hdr.LEFT,!lineno,!lineno))
| 58 => (PREC(Hdr.RIGHT,!lineno,!lineno))
| 68 => (PREC(Hdr.NONASSOC,!lineno,!lineno))
| 72 => (lookup(yytext,!lineno,!lineno))
| 75 => (TYVAR(yytext,!lineno,!lineno))
| 79 => (IDDOT(yytext,!lineno,!lineno))
| 8 => (Add yytext; YYBEGIN COMMENT; commentLevel := 1;
		    continue() before YYBEGIN CODE)
| 82 => (INT (yytext,!lineno,!lineno))
| 85 => (DELIMITER(!lineno,!lineno))
| 87 => (COLON(!lineno,!lineno))
| 89 => (BAR(!lineno,!lineno))
| 92 => (ID ((yytext,!lineno),!lineno,!lineno))
| 94 => (pcount := 1; actionstart := (!lineno);
		    text := nil; YYBEGIN CODE; continue() before YYBEGIN A)
| 96 => (UNKNOWN(yytext,!lineno,!lineno))
| 98 => (Ref.inc pcount; Add yytext; continue())
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves) else
	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := String.extract i0 l (!yyb)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = String.ord(String.nth l (!yyb))
		val NewState = if NewChar<128 then String.ord(String.nth NewChar trans) else String.ord(String.nth 128 trans)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if String.extract (!yybufpos-1) (!yypufpos) (!yyb)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end;
