#include <stdio.h>
#include <a.out.h>
#include <filehdr.h>
#include <ldfcn.h>

main(int argc, char **argv) {
    AOUTHDR header;
    struct filehdr filehdr;
    FILE *fd;
    char *file_name = argv[1];
    long text_base, text_size;
    int data_base, data_size;
    
    if((fd = fopen (file_name, "r")) == NULL) {
	printf("Cannot read the file: %s\n", file_name);
	return(1);
    }
    /* skip over the filehdr: */
    if(fread(&filehdr,1,sizeof(struct filehdr), fd) != sizeof(struct filehdr)){
	printf("File does not have a proper file header\n");
	return 1;
    }
    /* read the aouthdr: */
    if (fread (&header, 1, sizeof (AOUTHDR), fd) != sizeof (AOUTHDR)) {
	printf("File had invalid format: %s\n", file_name);
	return(1);
    }
    /* a.out preface is read into core before text segment: */
    text_base = header.text_start + sizeof(struct filehdr) + sizeof(AOUTHDR);
    text_size = header.tsize;
    data_base = header.data_start;
    data_size = header.dsize;
/*    program_break = header.bss_start + header.bsize; */
    
    printf("text_begins_at_point %x\n",text_base);
    printf("text_size %x\n",text_size);
    printf("data_begins_at_point %x\n",data_base);
    printf("data_size %x\n",data_size);
    printf("entry point %x\n",header.entry);
    printf("gp value %x\n",header.gp_value);
}
