MODULE ErrList;

(* Created at Feb. 1994 by Jerney.

   This module creates a compilerlisting (program and error
   messages) for every module in a compile-cycle. *)

IMPORT MyFile, Pkl, SIO, SF, Stdio, System, Text, FileSys, Fmt;
           
TYPE listelem=RECORD
                filename:TEXT;
                errlist:errptr;
                next:listptr;
              END;
     
     errorelem=RECORD
                 error_line:TEXT;
                 err_nu:INTEGER;
                 nexterr:errptr;
               END;

     errptr=REF errorelem;

     listptr=REF listelem;

     liste=OBJECT
             anfang:listptr;
           METHODS
             Init():=init;
             Insert(fname:TEXT):=insert;
             InsertError(errline:TEXT;errlinenr:INTEGER):=ins_err;
           END;


PROCEDURE GetFileName(errline:TEXT; VAR fname:TEXT):BOOLEAN=

(* Extracts the filename filename from the line.
   Returns TRUE ==> Error(Warning)-Message, FALSE ==> junk. *)

VAR beg_ind, end_ind: INTEGER:=-1;

BEGIN (* GetFileName *)
  beg_ind:=Text.FindChar(errline, '"', 0);
  IF beg_ind=0 THEN
    end_ind:=Text.FindChar(errline, '"', beg_ind+1);
    fname:=Text.Sub(errline, beg_ind+1, end_ind-beg_ind-1);
    RETURN(TRUE);
  ELSE
    RETURN(FALSE);
  END; (* IF *)
END GetFileName;


PROCEDURE ins_err(self:liste; errline:TEXT; errnumber:INTEGER)=

(* Inserts an error message in the error list. *)

VAR neu:=NEW(REF errorelem);
    prev, lauf:errptr;

BEGIN (* ins_err *)
  lauf:=self.anfang^.errlist;
  neu^.error_line:=errline;         
  neu^.err_nu:=errnumber;      
  IF lauf=NIL THEN
    neu^.nexterr:=NIL;
    self.anfang^.errlist:=neu;
  ELSE
    prev:=NIL;
    WHILE lauf#NIL AND lauf^.err_nu<=errnumber DO
      prev:=lauf;
      lauf:=lauf^.nexterr;
    END; (* WHILE *)
    IF lauf=self.anfang^.errlist THEN
      neu^.nexterr:=self.anfang^.errlist;
      self.anfang^.errlist:=neu;
    ELSE
      neu^.nexterr:=lauf;
      prev^.nexterr:=neu;
    END; (* IF *)
  END; (* IF *)
END ins_err;


PROCEDURE insert(self:liste; fname:TEXT)=

(* If necessary, the filename is inserted in the object self.
   If inserted ==> TRUE is returned, else FALSE. *)

VAR neu:=NEW(REF listelem);

BEGIN (* insert *)
  neu^.filename:=fname;
  neu^.errlist:=NIL;
  neu^.next:=self.anfang;
  self.anfang:=neu;
END insert;
                
PROCEDURE init(self:liste)=

(* Initializing object self. *)

BEGIN (* init *)
  self.anfang:=NIL;
END init;


PROCEDURE CreateListFile(fname:TEXT;VAR fptr:SF.Writer;fcode:INTEGER)=

(* Creates a new file for the compilerlisting. The new file is named
   filename.mls (for programm modules) or filename.ils (for 
   interface modules). *)

VAR listfname:TEXT; (* Name of the listingfile. *)

BEGIN (* CreateListFile *)
  listfname:=Text.Sub(fname,0,Text.Length(fname)-2);
  IF fcode=1 THEN
    (* Module *)
    listfname:=listfname&"mls";
  ELSIF fcode=2 THEN
    (* Interface *)
    listfname:=listfname&"ils";
  END; (* IF *)
  IF fptr#NIL THEN
    SF.CloseWrite(fptr);
    fptr:=NIL;
  END; (* IF *)
  IF SF.FileExists(listfname) THEN
    System.CallProg("del "&FileSys.ChangeSlash(listfname));
  END; (* IF *)
  fptr:=SF.OpenWrite(listfname);
END CreateListFile;


PROCEDURE GetErrNr(errline:TEXT):INTEGER=

(* Extracts the linenumber of the error from the errorline and returns it. *)

VAR dp, pot, errnu:INTEGER;

BEGIN (* GetErrNr *)
  dp:=Text.FindChar(errline, ':', 0)-1;
  pot:=1;
  errnu:=0;
  WHILE Text.GetChar(errline, dp)>='0' AND Text.GetChar(errline, dp)<='9' DO
    errnu:=errnu+(ORD(Text.GetChar(errline, dp))-ORD('0'))*pot;
    pot:=10*pot;
    DEC(dp);
  END; (* WHILE *)
  RETURN(errnu);
END GetErrNr;


PROCEDURE WriteErrs(errnu:INTEGER;VAR linenu:INTEGER;ptrlst:SF.Writer;
                    ptrprg:SF.Reader;errline:TEXT)=

(* Merges the programlines and the errormessages in the compilerlisting. *)

VAR blanks:TEXT:="";

BEGIN (* WriteErrs *)
  IF errnu=-1 THEN
    WHILE NOT SIO.End(ptrprg) DO
      SIO.PutText(Fmt.F("%04s",Fmt.Int(linenu))&" "&
                       MyFile.GetLine(ptrprg)&
                       "\r\n",ptrlst);
      SIO.Flush(ptrlst);
      INC(linenu);
    END; (* WHILE *)
  ELSE
    WHILE linenu<=errnu DO
      SIO.PutText(Fmt.F("%04s",Fmt.Int(linenu))&" "&
                       MyFile.GetLine(ptrprg)&
                       "\r\n",ptrlst);
      SIO.Flush(ptrlst);
      INC(linenu);
    END; (* WHILE *)
    IF Text.Length(errline)<73 THEN
      FOR i:=1 TO 73-Text.Length(errline) DO
        blanks:=blanks&" ";
      END; (* FOR *)
    END; (* IF *)
    SIO.PutText("**** "&blanks&errline&"\r\n",ptrlst);
    SIO.Flush(ptrlst);
  END; (* IF *)
END WriteErrs;


PROCEDURE GetSourceName(VAR sfname:TEXT; errline:TEXT):BOOLEAN=

VAR f_bl, s_bl, l_bl:INTEGER;
    f_wd, s_wd:TEXT;

BEGIN (* GetSourceName *)
  f_bl:=Text.FindChar(errline,' ',0);
  s_bl:=Text.FindChar(errline,' ',f_bl+1);
  f_wd:=Text.Sub(errline,0,f_bl);
  s_wd:=Text.Sub(errline,f_bl+1,s_bl-f_bl-1);
  IF Text.Equal(f_wd,"new") AND Text.Equal(s_wd,"source") THEN
    l_bl:=Text.FindCharR(errline,' ');
    sfname:=Text.Sub(errline,l_bl+1,Text.Length(errline)-l_bl-1);
    RETURN(TRUE);
  END; (* IF *)
  RETURN(FALSE);
END GetSourceName;


PROCEDURE substring(errline:TEXT; nl:[0..2]):BOOLEAN=

(* If warnings are errors, then TRUE is returned, otherwise
   (nl=1) TRUE is returned, if it is a real error and no warning. *)

VAR str:TEXT:="warning";
    ok:BOOLEAN:=FALSE;
    st:INTEGER;

BEGIN (* substring *)
  IF nl=2 THEN
    RETURN(TRUE);
  ELSE
    (* Searching for the keyword "warning". *)
    st:=0;
    st:=Text.FindChar(errline, Text.GetChar(str, 0), st);
    WHILE st>-1 AND NOT ok DO 
      IF Text.Compare(str,Text.Sub(errline,st,Text.Length(str)))=0 THEN
        ok:=TRUE;
      ELSE
        st:=Text.FindChar(errline, Text.GetChar(str, 0), st+1);
      END; (* IF *)
    END; (* WHILE *)
    RETURN(NOT ok);
  END; (* IF *)
END substring;


PROCEDURE mkerrlist(errfilnam:TEXT; nl:[1..2])=

(* Main procedure, which is exported. *)

VAR fptrerr:SF.Reader; (* Refers to c:\tmp\error.lst. *)
    fptrlst:SF.Writer; (* Refers to compilerlisting-file. *)
    fptrprg:SF.Reader; (* Refers to the program-file. *)
    fname, errline, sourcefilename:TEXT;
    line_nr:INTEGER;
    filelist:=NEW(liste);
    newsource:BOOLEAN;
    lauffiles:listptr;
    lauferrs:errptr;

    (* r:SF.Reader; Only used for Pkl-test.
       w:SF.Writer; *)

BEGIN (* mkerrlist *) 
  filelist.Init();
  IF SF.FileExists(errfilnam) THEN
    fptrerr:=SF.OpenRead(errfilnam);
    fptrlst:=NIL;
    fptrprg:=NIL;
    newsource:=FALSE;
    WHILE NOT SIO.End(fptrerr) DO
      (* Creating list with error messages for every module. *)
      errline:=MyFile.GetLine(fptrerr);
      newsource:=GetSourceName(sourcefilename,errline);
      IF newsource=TRUE THEN
        (* Insert sourcefilename in list. *)
        filelist.Insert(sourcefilename);
      END; (* IF *)
      IF GetFileName(errline, fname) AND Text.Equal(fname,sourcefilename) THEN
        (* IF substring(errline, nl) THEN *)
           filelist.InsertError(errline,GetErrNr(errline));
        (* END; *)
      END; (* IF *)
    END; (* WHILE *)
    SF.CloseRead(fptrerr);
         (* The following block is only a Pkl-test and usually unused.
                 w:=SF.OpenWrite("file");
                 Pkl.Write(filelist.anfang, w);
                 SF.CloseWrite(w);
                 filelist.anfang:=NIL;
                 r:=SF.OpenRead("file");
                 filelist.anfang:=Pkl.Read(r);
                 SF.CloseRead(r); *)
    lauffiles:=filelist.anfang;
    WHILE lauffiles#NIL DO
      (* Trace every program module in list. *)
      IF nl=2 OR nl=1 AND lauffiles^.errlist#NIL THEN
        fptrprg:=SF.OpenRead(lauffiles^.filename);
        IF Text.GetChar(lauffiles^.filename,Text.Length(lauffiles^.filename)-2)
           ='m' THEN
          CreateListFile(lauffiles^.filename,fptrlst,1); 
        ELSE
          CreateListFile(lauffiles^.filename,fptrlst,2); 
        END; (* IF *)
        line_nr:=1;
        lauferrs:=lauffiles^.errlist;
        WHILE lauferrs#NIL DO
          (* Trace every error for a program module. *)
          WriteErrs(lauferrs^.err_nu,line_nr,fptrlst,fptrprg,lauferrs^.error_line); 
          lauferrs:=lauferrs^.nexterr;
        END; (* WHILE *)
        WriteErrs(-1, line_nr, fptrlst, fptrprg, "");
        SF.CloseRead(fptrprg);
      END; (* IF *)
      lauffiles:=lauffiles^.next;
    END; (* WHILE *)
    IF fptrlst#NIL THEN
      SF.CloseWrite(fptrlst);
    END; (* IF *)
  ELSE
    SIO.PutText("Errorfile couldn't be opened ==> no Errorlisting created\r\n",
            Stdio.stdout);
  END; (* IF *)
END mkerrlist;


BEGIN (* ErrList *)
END ErrList.
