(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Thu Nov 19 10:26:57 MET 1992 by preschern                *)

INTERFACE DOSTextWr;

(* A DOSTextWr.T is a "transparent filter". All operations performed on the
   parent are actually performed on the child; 
   
   The argument to DOSTextWr.New is a (just opened) writer for a DOS 
   file opened in binary mode. This writer maps a Unix "text" file
   to a DOS binary file.
   LF is mapped to CR/LF.
   Note: this implementation assumes that no operations take place on the
         writer given as argument to New. All operations should be done 
         on T.
*)

IMPORT Wr;

TYPE T <: Wr.T;

PROCEDURE New (wr: Wr.T): T;

END DOSTextWr.

