(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 13:16:22 PDT 1992 by muller *)
(*      modified on Fri Nov  1 23:17:52 PST 1991 by meehan *)

INTERFACE Range;

(* A trivial utility for testing the ranges on "Sub" procedures, and
   returning 'end'. In the simple case, this is just 'start' + 'length'.

   If a procedure takes 'start' and 'length' arguments for a sequence whose
   actual length is L, then End will signal an error if start > L or if
   length # LAST(CARDINAL) [the typical default] and start + length > L.

   One of the things we want to avoid writing is
|       end := MIN (start + length, ActualLength)
   because if 'length' is the default value LAST(CARDINAL), this will
   overflow. *)

TYPE ErrorCode = {StartTooBig, EndTooBig};

EXCEPTION Error(ErrorCode);

PROCEDURE End (    start       : CARDINAL;
               VAR length      : CARDINAL;
                   actualLength: CARDINAL  ): CARDINAL RAISES {Error};
(* If 'length' = LAST(CARDINAL), then it will be set to the actual length
   of the subsequence. The value returned is the index of the end of the
   sequence. *)

END Range.




