# Generated by default/object.tt
package Paws::CodePipeline::ExecutorConfiguration;
  use Moose;
  has JobWorkerExecutorConfiguration => (is => 'ro', isa => 'Paws::CodePipeline::JobWorkerExecutorConfiguration', request_name => 'jobWorkerExecutorConfiguration', traits => ['NameInRequest']);
  has LambdaExecutorConfiguration => (is => 'ro', isa => 'Paws::CodePipeline::LambdaExecutorConfiguration', request_name => 'lambdaExecutorConfiguration', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodePipeline::ExecutorConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodePipeline::ExecutorConfiguration object:

  $service_obj->Method(Att1 => { JobWorkerExecutorConfiguration => $value, ..., LambdaExecutorConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodePipeline::ExecutorConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->JobWorkerExecutorConfiguration

=head1 DESCRIPTION

The action engine, or executor, related to the supported integration
model used to create and update the action type. The available executor
types are C<Lambda> and C<JobWorker>.

=head1 ATTRIBUTES


=head2 JobWorkerExecutorConfiguration => L<Paws::CodePipeline::JobWorkerExecutorConfiguration>

Details about the C<JobWorker> executor of the action type.


=head2 LambdaExecutorConfiguration => L<Paws::CodePipeline::LambdaExecutorConfiguration>

Details about the C<Lambda> executor of the action type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodePipeline>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

