use Test::More tests => 10;
BEGIN { use_ok('Crypt::OpenSSL::AES') };

my $key;
my $plaintext;
my $expected_enc;
my $c;

#
# test AES-256-ECB
#
$key = pack("C*",0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32
,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33);
$plaintext = pack("C*",0x41,0x42,0x43,0x44,0x41,0x42,0x43,0x44,0x41,0x42,0x43,0x44,0x41,0x42,0x43,0x44);
$expected_enc = pack("C*", 0x9b, 0xc3, 0x7f, 0x1b, 0x92, 0x93, 0xcc, 0xf9, 0x6b, 0x64, 0x00, 0xae, 0xa3, 0xc8, 0x85, 0xbb);
$c = new Crypt::OpenSSL::AES($key);

ok(($encrypted = $c->encrypt($plaintext)) eq $expected_enc, "encrypt with key length 32 (AES-256-ECB)");
ok($c->decrypt($encrypted) eq $plaintext, "decrypt with key length 32 (AES-256-ECB)");
ok($c->decrypt($c->encrypt("Hello World. 123")) eq "Hello World. 123", "Simple String Encrypted/Decrypted Successfully with key length 32 AES-256-ECB");

# echo -n "ABCDABCDABCDABCD"| openssl enc -nopad -e -aes-256-ecb -K '3031323330313233303132333031323330313233303132333031323330313233' | xxd -i
# echo -n "ABCDABCDABCDABCD"| openssl enc -nopad -e -aes-192-ecb -K '303132333031323330313233303132333031323330313233'
# echo -n "ABCDABCDABCDABCD"| openssl enc -nopad -e -aes-128-ecb -K '30313233303132333031323330313233' | xxd -i

#
# test AES-192-ECB
#
$key = pack("C*",0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33);
$plaintext = pack("C*",0x41,0x42,0x43,0x44,0x41,0x42,0x43,0x44,0x41,0x42,0x43,0x44,0x41,0x42,0x43,0x44);
$expected_enc = pack("C*", 0xd3, 0xb8, 0xa7, 0xf0, 0xaa, 0x8f, 0x62, 0xc7, 0xb8, 0x78, 0xb7, 0xb3, 0xee, 0x47, 0x6a, 0x9f);
$c = new Crypt::OpenSSL::AES($key);

ok(($encrypted = $c->encrypt($plaintext)) eq $expected_enc, "encrypt with key length 24 (AES-192-ECB)");
ok($c->decrypt($encrypted) eq $plaintext, "decrypt with key length 24 (AES-192-ECB)");
ok($c->decrypt($c->encrypt("Hello World. 123")) eq "Hello World. 123", "Simple String Encrypted/Decrypted Successfully with key length 24 AES-192-ECB");

#
# test AES-128-ECB
#
$key = pack("C*",0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33);
$plaintext = pack("C*",0x41,0x42,0x43,0x44,0x41,0x42,0x43,0x44,0x41,0x42,0x43,0x44,0x41,0x42,0x43,0x44);
$expected_enc = pack("C*", 0x6a, 0xf2, 0xaa, 0x85, 0x28, 0xfc, 0x73, 0x3c, 0xda, 0x30, 0xd4, 0x9f, 0x43, 0x5c, 0x30, 0x4e);
$c = new Crypt::OpenSSL::AES($key);

ok(($encrypted = $c->encrypt($plaintext)) eq $expected_enc, "encrypt with key length 16 (AES-128-ECB)");
ok($c->decrypt($encrypted) eq $plaintext, "decrypt with key length 16 (AES-128-ECB)");
ok($c->decrypt($c->encrypt("Hello World. 123")) eq "Hello World. 123", "Simple String Encrypted/Decrypted Successfully with key length 16 AES-128-ECB");
