use Test2::V0;

use Importer 'NewsExtractor::TextUtil' => 'reformat_dateline';

my @tests = (
    ['2020/7/18 23:33', '2020-07-18T23:33:00+08:00'],
    ['2020年7月18 23:33', '2020-07-18T23:33:00+08:00'],
    ['2020 年 7 月 18, 23:33', '2020-07-18T23:33:00+08:00'],
    ['發稿時間：2020/07/18 23:33', '2020-07-18T23:33:00+08:00'],
    ['2020/8/8 23:33', '2020-08-08T23:33:00+08:00'],
    ['2020年8月8日', '2020-08-08+08:00'],
    ['發稿時間：2020/08/08', '2020-08-08+08:00'],
);

for my $it (@tests) {
    is(reformat_dateline($it->[0], '+08:00'), $it->[1], $it->[0]);
}

done_testing;
