/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_layout_BorderLayout({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.layout.ContainerLayout","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='docClass'>Ext.layout.ContainerLayout</a><div class='subclass '><strong>Ext.layout.BorderLayout</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/BorderLayout.html#Ext-layout-BorderLayout' target='_blank'>BorderLayout.js</a></div></pre><div class='doc-contents'><p>This is a multi-pane, application-oriented UI layout style that supports multiple\nnested panels, automatic <a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-split\" rel=\"Ext.layout.BorderLayout.Region-cfg-split\" class=\"docClass\">split</a> bars between\nregions and built-in\n<a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-collapsible\" rel=\"Ext.layout.BorderLayout.Region-cfg-collapsible\" class=\"docClass\">expanding and collapsing</a> of regions.</p>\n\n\n<p>This class is intended to be extended or created via the <tt>layout:'border'</tt>\n<a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">Ext.Container.layout</a> config, and should generally not need to be created directly\nvia the new keyword.</p>\n\n\n<p>BorderLayout does not have any direct config options (other than inherited ones).\nAll configuration options available for customizing the BorderLayout are at the\n<a href=\"#!/api/Ext.layout.BorderLayout.Region\" rel=\"Ext.layout.BorderLayout.Region\" class=\"docClass\">Ext.layout.BorderLayout.Region</a> and <a href=\"#!/api/Ext.layout.BorderLayout.SplitRegion\" rel=\"Ext.layout.BorderLayout.SplitRegion\" class=\"docClass\">Ext.layout.BorderLayout.SplitRegion</a>\nlevels.</p>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>var myBorderPanel = new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.BoxComponent-cfg-width\" rel=\"Ext.BoxComponent-cfg-width\" class=\"docClass\">width</a>: 700,\n    <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 500,\n    <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Border Layout',\n    <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a>: 'border',\n    <a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a>: [{\n        <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'South Region is resizable',\n        region: 'south',     // position for region\n        <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 100,\n        <a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-split\" rel=\"Ext.layout.BorderLayout.Region-cfg-split\" class=\"docClass\">split</a>: true,         // enable resizing\n        <a href=\"#!/api/Ext.SplitBar-property-minSize\" rel=\"Ext.SplitBar-property-minSize\" class=\"docClass\">minSize</a>: 75,         // defaults to <a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-minHeight\" rel=\"Ext.layout.BorderLayout.Region-cfg-minHeight\" class=\"docClass\">50</a>\n        <a href=\"#!/api/Ext.SplitBar-property-maxSize\" rel=\"Ext.SplitBar-property-maxSize\" class=\"docClass\">maxSize</a>: 150,\n        <a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-margins\" rel=\"Ext.layout.BorderLayout.Region-cfg-margins\" class=\"docClass\">margins</a>: '0 5 5 5'\n    },{\n        // xtype: 'panel' implied by default\n        <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'West Region is collapsible',\n        region:'west',\n        <a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-margins\" rel=\"Ext.layout.BorderLayout.Region-cfg-margins\" class=\"docClass\">margins</a>: '5 0 0 5',\n        <a href=\"#!/api/Ext.BoxComponent-cfg-width\" rel=\"Ext.BoxComponent-cfg-width\" class=\"docClass\">width</a>: 200,\n        <a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-collapsible\" rel=\"Ext.layout.BorderLayout.Region-cfg-collapsible\" class=\"docClass\">collapsible</a>: true,   // make collapsible\n        <a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-cmargins\" rel=\"Ext.layout.BorderLayout.Region-cfg-cmargins\" class=\"docClass\">cmargins</a>: '5 5 0 5', // adjust top margin when collapsed\n        <a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a>: 'west-region-container',\n        <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a>: 'fit',\n        <a href=\"#!/api/Ext.Panel-cfg-unstyled\" rel=\"Ext.Panel-cfg-unstyled\" class=\"docClass\">unstyled</a>: true\n    },{\n        <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Center Region',\n        region: 'center',     // center region is required, no width/height specified\n        <a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">xtype</a>: 'container',\n        <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a>: 'fit',\n        <a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-margins\" rel=\"Ext.layout.BorderLayout.Region-cfg-margins\" class=\"docClass\">margins</a>: '5 5 0 0'\n    }]\n});\n</code></pre>\n\n\n<p><b><u>Notes</u></b>:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li>Any container using the BorderLayout <b>must</b> have a child item with <tt>region:'center'</tt>.\nThe child item in the center region will always be resized to fill the remaining space not used by\nthe other regions in the layout.</li>\n<li>Any child items with a region of <tt>west</tt> or <tt>east</tt> must have <tt>width</tt> defined\n(an integer representing the number of pixels that the region should take up).</li>\n<li>Any child items with a region of <tt>north</tt> or <tt>south</tt> must have <tt>height</tt> defined.</li>\n<li>The regions of a BorderLayout are <b>fixed at render time</b> and thereafter, its child Components may not be removed or added</b>.  To add/remove\nComponents within a BorderLayout, have them wrapped by an additional Container which is directly\nmanaged by the BorderLayout.  If the region is to be collapsible, the Container used directly\nby the BorderLayout manager should be a Panel.  In the following example a Container (an <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>)\nis added to the west region:\n<div style=\"margin-left:16px\">\n<pre><code>wrc = <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>('west-region-container');\nwrc.<a href=\"#!/api/Ext.Panel-method-removeAll\" rel=\"Ext.Panel-method-removeAll\" class=\"docClass\">removeAll</a>();\nwrc.<a href=\"#!/api/Ext.Container-event-add\" rel=\"Ext.Container-event-add\" class=\"docClass\">add</a>({\n    title: 'Added Panel',\n    html: 'Some content'\n});\nwrc.<a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a>();\n</code></pre></div>\n</li>\n<li> To reference a <a href=\"#!/api/Ext.layout.BorderLayout.Region\" rel=\"Ext.layout.BorderLayout.Region\" class=\"docClass\">Region</a>:\n<div style=\"margin-left:16px\">\n<pre><code>wr = myBorderPanel.layout.west;\n</code></pre></div>\n</li>\n</ul></div>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-extraCls' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-cfg-extraCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-cfg-extraCls' class='name expandable'>extraCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to the container. ...</div><div class='long'><p>An optional extra CSS class that will be added to the container. This can be useful for adding\ncustomized styles to the container or any of its children using standard CSS rules. See\n<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.<a href=\"#!/api/Ext.Component-cfg-ctCls\" rel=\"Ext.Component-cfg-ctCls\" class=\"docClass\">ctCls</a> also.</p>\n\n\n<p><b>Note</b>: <tt>extraCls</tt> defaults to <tt>''</tt> except for the following classes\nwhich assign a value by default:\n<div class=\"mdetail-params\"><ul>\n<li><a href=\"#!/api/Ext.layout.AbsoluteLayout\" rel=\"Ext.layout.AbsoluteLayout\" class=\"docClass\">Absolute Layout</a> : <tt>'x-abs-layout-item'</tt></li>\n<li>Box Layout : <tt>'x-box-item'</tt></li>\n<li><a href=\"#!/api/Ext.layout.ColumnLayout\" rel=\"Ext.layout.ColumnLayout\" class=\"docClass\">Column Layout</a> : <tt>'x-column'</tt></li>\n</ul></div>\nTo configure the above Classes with an extra CSS class append to the default.  For example,\nfor ColumnLayout:\n<pre><code>extraCls: 'x-column custom-class'\n</code></pre>\n</p>\n\n</div></div></div><div id='cfg-renderHidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-cfg-renderHidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-cfg-renderHidden' class='name not-expandable'>renderHidden</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True to hide each contained item on render (defaults to false).</p>\n</div><div class='long'><p>True to hide each contained item on render (defaults to false).</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-fieldTpl' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-property-fieldTpl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-property-fieldTpl' class='name expandable'>fieldTpl</a><span> : <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a></span></div><div class='description'><div class='short'>The Ext.Template used by Field rendering layout classes (such as\nExt.layout.FormLayout) to create the DOM structure o...</div><div class='long'><p>The <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a> used by Field rendering layout classes (such as\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>) to create the DOM structure of a fully wrapped,\nlabeled and styled form Field. A default Template is supplied, but this may be\noverriden to create custom field structures. The template processes values returned from\n<a href=\"#!/api/Ext.layout.FormLayout-method-getTemplateArgs\" rel=\"Ext.layout.FormLayout-method-getTemplateArgs\" class=\"docClass\">Ext.layout.FormLayout.getTemplateArgs</a>.</p>\n</div></div></div><div id='property-getLayoutTargetSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-property-getLayoutTargetSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-property-getLayoutTargetSize' class='name not-expandable'>getLayoutTargetSize</a><span> : Object</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'><p>Placeholder for the derived layouts</p>\n</div><div class='long'><p>Placeholder for the derived layouts</p>\n</div></div></div><div id='property-monitorResize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.BorderLayout'>Ext.layout.BorderLayout</span><br/><a href='source/BorderLayout.html#Ext-layout-BorderLayout-property-monitorResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.BorderLayout-property-monitorResize' class='name expandable'>monitorResize</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>true</code></p><p>Overrides: <a href='#!/api/Ext.layout.ContainerLayout-property-monitorResize' rel='Ext.layout.ContainerLayout-property-monitorResize' class='docClass'>Ext.layout.ContainerLayout.monitorResize</a></p></div></div></div><div id='property-rendered' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.BorderLayout'>Ext.layout.BorderLayout</span><br/><a href='source/BorderLayout.html#Ext-layout-BorderLayout-property-rendered' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.BorderLayout-property-rendered' class='name expandable'>rendered</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-targetCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.BorderLayout'>Ext.layout.BorderLayout</span><br/><a href='source/BorderLayout.html#Ext-layout-BorderLayout-property-targetCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.BorderLayout-property-targetCls' class='name expandable'>targetCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'x-border-layout-ct'</code></p></div></div></div><div id='property-type' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.BorderLayout'>Ext.layout.BorderLayout</span><br/><a href='source/BorderLayout.html#Ext-layout-BorderLayout-property-type' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.BorderLayout-property-type' class='name expandable'>type</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'border'</code></p><p>Overrides: <a href='#!/api/Ext.layout.ContainerLayout-property-type' rel='Ext.layout.ContainerLayout-property-type' class='docClass'>Ext.layout.ContainerLayout.type</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.layout.ContainerLayout-method-constructor' class='name expandable'>Ext.layout.BorderLayout</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-IEMeasureHack' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-IEMeasureHack' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-IEMeasureHack' class='name expandable'>IEMeasureHack</a>( <span class='pre'>target, viewFlag</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Workaround for how IE measures autoWidth elements. ...</div><div class='long'><p>Workaround for how IE measures autoWidth elements.  It prefers bottom-up measurements</p>\n\n<pre><code> whereas other browser prefer top-down.  We will hide all target child elements before we measure and\n put them back to get an accurate measurement.\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>target</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>viewFlag</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterRemove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-afterRemove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-afterRemove' class='name expandable'>afterRemove</a>( <span class='pre'>c</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-configureItem' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-configureItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-configureItem' class='name expandable'>configureItem</a>( <span class='pre'>c</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Applies extraCls and hides the item if renderHidden is true ...</div><div class='long'><p>Applies extraCls and hides the item if renderHidden is true</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.BorderLayout'>Ext.layout.BorderLayout</span><br/><a href='source/BorderLayout.html#Ext-layout-BorderLayout-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.BorderLayout-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.layout.ContainerLayout-method-destroy' rel='Ext.layout.ContainerLayout-method-destroy' class='docClass'>Ext.layout.ContainerLayout.destroy</a></p></div></div></div><div id='method-getLayoutTargetSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.BorderLayout'>Ext.layout.BorderLayout</span><br/><a href='source/BorderLayout.html#Ext-layout-BorderLayout-method-getLayoutTargetSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.BorderLayout-method-getLayoutTargetSize' class='name expandable'>getLayoutTargetSize</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getRenderedItems' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-getRenderedItems' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-getRenderedItems' class='name expandable'>getRenderedItems</a>( <span class='pre'>ct</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private. ...</div><div class='long'><p>private.\nGet all rendered items to lay out.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ct</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isValidParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-isValidParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-isValidParent' class='name expandable'>isValidParent</a>( <span class='pre'>c, target</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-layout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-layout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-layout' class='name expandable'>layout</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-onLayout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.layout.BorderLayout'>Ext.layout.BorderLayout</span><br/><a href='source/BorderLayout.html#Ext-layout-BorderLayout-method-onLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.BorderLayout-method-onLayout' class='name expandable'>onLayout</a>( <span class='pre'>ct, target</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ct</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.layout.ContainerLayout-method-onLayout' rel='Ext.layout.ContainerLayout-method-onLayout' class='docClass'>Ext.layout.ContainerLayout.onLayout</a></p></div></div></div><div id='method-onRemove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-onRemove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-onRemove' class='name expandable'>onRemove</a>( <span class='pre'>c</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onResize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-onResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-onResize' class='name expandable'>onResize</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-parseMargins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-parseMargins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-parseMargins' class='name expandable'>parseMargins</a>( <span class='pre'>v</span> ) : Object</div><div class='description'><div class='short'>Parses a number or string representing margin sizes into an object. ...</div><div class='long'><p>Parses a number or string representing margin sizes into an object. Supports CSS-style margin declarations\n(e.g. 10, \"10\", \"10 10\", \"10 10 10\" and \"10 10 10 10\" are all valid options and would return the same result)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>v</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The encoded margins</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object with margin sizes for top, right, bottom and left</p>\n</div></li></ul></div></div></div><div id='method-renderAll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-renderAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-renderAll' class='name expandable'>renderAll</a>( <span class='pre'>ct, target</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ct</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>target</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-renderItem' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-renderItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-renderItem' class='name expandable'>renderItem</a>( <span class='pre'>c, position, target</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Renders the given Component into the target Element. ...</div><div class='long'><p>Renders the given Component into the target Element. If the Component is already rendered,\nit is moved to the provided target instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The Component to render</p>\n\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The position within the target to render the item to</p>\n\n</div></li><li><span class='pre'>target</span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class='sub-desc'><p>The target Element</p>\n\n</div></li></ul></div></div></div><div id='method-runLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-runLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-runLayout' class='name expandable'>runLayout</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-setContainer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.layout.ContainerLayout' rel='Ext.layout.ContainerLayout' class='defined-in docClass'>Ext.layout.ContainerLayout</a><br/><a href='source/ContainerLayout.html#Ext-layout-ContainerLayout-method-setContainer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.layout.ContainerLayout-method-setContainer' class='name expandable'>setContainer</a>( <span class='pre'>ct</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ct</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.layout.ContainerLayout"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"BorderLayout.html#Ext-layout-BorderLayout","filename":"BorderLayout.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.layout.ContainerLayout","meta":{},"name":"fieldTpl","id":"property-fieldTpl"},{"tagname":"property","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"getLayoutTargetSize","id":"property-getLayoutTargetSize"},{"tagname":"property","owner":"Ext.layout.BorderLayout","meta":{"private":true},"name":"monitorResize","id":"property-monitorResize"},{"tagname":"property","owner":"Ext.layout.BorderLayout","meta":{"private":true},"name":"rendered","id":"property-rendered"},{"tagname":"property","owner":"Ext.layout.BorderLayout","meta":{"private":true},"name":"targetCls","id":"property-targetCls"},{"tagname":"property","owner":"Ext.layout.BorderLayout","meta":{"private":true},"name":"type","id":"property-type"}],"cfg":[{"tagname":"cfg","owner":"Ext.layout.ContainerLayout","meta":{},"name":"extraCls","id":"cfg-extraCls"},{"tagname":"cfg","owner":"Ext.layout.ContainerLayout","meta":{},"name":"renderHidden","id":"cfg-renderHidden"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"IEMeasureHack","id":"method-IEMeasureHack"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"afterRemove","id":"method-afterRemove"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"configureItem","id":"method-configureItem"},{"tagname":"method","owner":"Ext.layout.BorderLayout","meta":{"private":true},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.layout.BorderLayout","meta":{"private":true},"name":"getLayoutTargetSize","id":"method-getLayoutTargetSize"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"getRenderedItems","id":"method-getRenderedItems"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"isValidParent","id":"method-isValidParent"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"layout","id":"method-layout"},{"tagname":"method","owner":"Ext.layout.BorderLayout","meta":{"private":true},"name":"onLayout","id":"method-onLayout"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"onRemove","id":"method-onRemove"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"onResize","id":"method-onResize"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{},"name":"parseMargins","id":"method-parseMargins"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"renderAll","id":"method-renderAll"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"renderItem","id":"method-renderItem"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"runLayout","id":"method-runLayout"},{"tagname":"method","owner":"Ext.layout.ContainerLayout","meta":{"private":true},"name":"setContainer","id":"method-setContainer"}],"event":[],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.layout.BorderLayout","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.layout.BorderLayout","mixins":[],"mixedInto":[]});