use ExtUtils::MakeMaker;
use File::Spec;

my $file = File::Spec->catfile(File::Spec->curdir, "lib", "Astro", 
			       "Coords.pm");


WriteMakefile( 
               'NAME'           => 'Astro::Coords',
	       'VERSION'        => '0.10',
               'PREREQ_PM'      => { 
                                    Scalar::Util => 1.13,
				    Astro::SLA => '0.95',
				    Time::Piece => '1.02',
				    Astro::Telescope => '0.50',
                                    DateTime => '0',
				    Test::More => '0',
				   },
	       'dist'           => { COMPRESS => "gzip -9f"},
	       ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
	       ( ABSTRACT_FROM  => $file,
		 AUTHOR         => 'Tim Jenness E<lt>tjenness@cpan.orgE<gt>') : ()),
             );

