package Google::Ads::AdWords::v201206::ApiUsageInfo;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/info/v201206' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %apiUsageRecords_of :ATTR(:get<apiUsageRecords>);
my %cost_of :ATTR(:get<cost>);

__PACKAGE__->_factory(
    [ qw(        apiUsageRecords
        cost

    ) ],
    {
        'apiUsageRecords' => \%apiUsageRecords_of,
        'cost' => \%cost_of,
    },
    {
        'apiUsageRecords' => 'Google::Ads::AdWords::v201206::ApiUsageRecord',
        'cost' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'apiUsageRecords' => 'apiUsageRecords',
        'cost' => 'cost',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201206::ApiUsageInfo

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ApiUsageInfo from the namespace https://adwords.google.com/api/adwords/info/v201206.

Represents the API usage information. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * apiUsageRecords


=item * cost




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201206::ApiUsageInfo
   apiUsageRecords =>  $a_reference_to, # see Google::Ads::AdWords::v201206::ApiUsageRecord
   cost =>  $some_value, # long
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

