% -----------------------------------------------------------------------------
% perleval.erl
% -----------------------------------------------------------------------------
% Mastering programmed by YAMASHINA Hio
%
% Copyright 2007 YAMASHINA Hio
% -----------------------------------------------------------------------------
% $Id
% -----------------------------------------------------------------------------
-module(perleval).
-export([eval/1, set/2]).
-export([start/0, start/1, stop/0]).
-import(perlport, [call/2]).

% -----------------------------------------------------------------------------
% eval(String).
%
eval(String) ->
	start(),
	call([eval, String], perleval).

% -----------------------------------------------------------------------------
% set(VarName, String).
%
set(VarName, String) ->
	start(),
	call([set, VarName, String], perleval).

% -----------------------------------------------------------------------------
% start().
% start(Script).
%
start() ->
	start("perleval.pl").
start(Script) ->
  perlport:start(Script, perleval).

% -----------------------------------------------------------------------------
% stop().
%
stop() ->
	perlport:stop(perleval).

% -----------------------------------------------------------------------------
% End of Module.
% -----------------------------------------------------------------------------
