# Generated by default/object.tt
package Paws::ApiGatewayV2::VpcLink;
  use Moose;
  has CreatedDate => (is => 'ro', isa => 'Str', request_name => 'createdDate', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'securityGroupIds', traits => ['NameInRequest'], required => 1);
  has SubnetIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'subnetIds', traits => ['NameInRequest'], required => 1);
  has Tags => (is => 'ro', isa => 'Paws::ApiGatewayV2::Tags', request_name => 'tags', traits => ['NameInRequest']);
  has VpcLinkId => (is => 'ro', isa => 'Str', request_name => 'vpcLinkId', traits => ['NameInRequest'], required => 1);
  has VpcLinkStatus => (is => 'ro', isa => 'Str', request_name => 'vpcLinkStatus', traits => ['NameInRequest']);
  has VpcLinkStatusMessage => (is => 'ro', isa => 'Str', request_name => 'vpcLinkStatusMessage', traits => ['NameInRequest']);
  has VpcLinkVersion => (is => 'ro', isa => 'Str', request_name => 'vpcLinkVersion', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApiGatewayV2::VpcLink

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApiGatewayV2::VpcLink object:

  $service_obj->Method(Att1 => { CreatedDate => $value, ..., VpcLinkVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApiGatewayV2::VpcLink object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedDate

=head1 DESCRIPTION

Represents a VPC link.

=head1 ATTRIBUTES


=head2 CreatedDate => Str

The timestamp when the VPC link was created.


=head2 B<REQUIRED> Name => Str

The name of the VPC link.


=head2 B<REQUIRED> SecurityGroupIds => ArrayRef[Str|Undef]

A list of security group IDs for the VPC link.


=head2 B<REQUIRED> SubnetIds => ArrayRef[Str|Undef]

A list of subnet IDs to include in the VPC link.


=head2 Tags => L<Paws::ApiGatewayV2::Tags>

Tags for the VPC link.


=head2 B<REQUIRED> VpcLinkId => Str

The ID of the VPC link.


=head2 VpcLinkStatus => Str

The status of the VPC link.


=head2 VpcLinkStatusMessage => Str

A message summarizing the cause of the status of the VPC link.


=head2 VpcLinkVersion => Str

The version of the VPC link.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApiGatewayV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

