/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.OlympusMakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlympusMakernoteDescriptor
extends TagDescriptor<OlympusMakernoteDirectory> {
    public OlympusMakernoteDescriptor(@NotNull OlympusMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 512: {
                return this.getSpecialModeDescription();
            }
            case 513: {
                return this.getJpegQualityDescription();
            }
            case 514: {
                return this.getMacroModeDescription();
            }
            case 516: {
                return this.getDigiZoomRatioDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getDigiZoomRatioDescription() {
        Integer value = ((OlympusMakernoteDirectory)this._directory).getInteger(516);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 2: {
                return "Digital 2x Zoom";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getMacroModeDescription() {
        Integer value = ((OlympusMakernoteDirectory)this._directory).getInteger(514);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal (no macro)";
            }
            case 1: {
                return "Macro";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getJpegQualityDescription() {
        Integer value = ((OlympusMakernoteDirectory)this._directory).getInteger(513);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "SQ";
            }
            case 2: {
                return "HQ";
            }
            case 3: {
                return "SHQ";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSpecialModeDescription() {
        int[] values = ((OlympusMakernoteDirectory)this._directory).getIntArray(512);
        if (values == null) {
            return null;
        }
        if (values.length < 1) {
            return "";
        }
        StringBuilder desc = new StringBuilder();
        switch (values[0]) {
            case 0: {
                desc.append("Normal picture taking mode");
                break;
            }
            case 1: {
                desc.append("Unknown picture taking mode");
                break;
            }
            case 2: {
                desc.append("Fast picture taking mode");
                break;
            }
            case 3: {
                desc.append("Panorama picture taking mode");
                break;
            }
            default: {
                desc.append("Unknown picture taking mode");
            }
        }
        if (values.length < 2) {
            return desc.toString();
        }
        desc.append(" - ");
        switch (values[1]) {
            case 0: {
                desc.append("Unknown sequence number");
                break;
            }
            case 1: {
                desc.append("1st in a sequence");
                break;
            }
            case 2: {
                desc.append("2nd in a sequence");
                break;
            }
            case 3: {
                desc.append("3rd in a sequence");
                break;
            }
            default: {
                desc.append(values[1]);
                desc.append("th in a sequence");
            }
        }
        if (values.length < 3) {
            return desc.toString();
        }
        desc.append(" - ");
        switch (values[2]) {
            case 1: {
                desc.append("Left to right panorama direction");
                break;
            }
            case 2: {
                desc.append("Right to left panorama direction");
                break;
            }
            case 3: {
                desc.append("Bottom to top panorama direction");
                break;
            }
            case 4: {
                desc.append("Top to bottom panorama direction");
            }
        }
        return desc.toString();
    }
}

