/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.storage.Capabilities;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.netcdf.NetcdfStore;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.logging.WarningListeners;
import org.opengis.parameter.ParameterDescriptorGroup;

@Capabilities(value={Capability.READ})
public class NetcdfStoreProvider
extends DataStoreProvider {
    static final String NAME = "NetCDF";
    static final String MIME_TYPE = "application/x-netcdf";
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR = URIDataStore.Provider.descriptor("NetCDF");
    private static final String UCAR_CLASSNAME = "ucar.nc2.NetcdfFile";
    private static Class<?> netcdfFileClass;
    private static volatile Method canOpenFromPath;
    private static volatile Constructor<? extends Decoder> createFromPath;
    private static volatile Constructor<? extends Decoder> createFromUCAR;

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer byteBuffer = storageConnector.getStorageAs(ByteBuffer.class);
        if (byteBuffer != null) {
            if (byteBuffer.remaining() < 4) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            int n2 = byteBuffer.getInt(byteBuffer.position());
            if ((n2 & 0xFFFFFF00) == 1128547840) {
                bl = true;
                n = n2 & 0xFF;
                boolean bl3 = bl2 = n >= 1 && n <= 2;
            }
        }
        if (!bl2) {
            String string = storageConnector.getStorageAs(String.class);
            if (string != null) {
                NetcdfStoreProvider.ensureInitialized(false);
                Method method = canOpenFromPath;
                if (method != null) {
                    try {
                        bl2 = (Boolean)method.invoke(null, string);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw (Error)new IncompatibleClassChangeError("canOpen").initCause(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getCause();
                        if (throwable instanceof DataStoreException) {
                            throw (DataStoreException)throwable;
                        }
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        if (throwable instanceof FileNotFoundException || throwable instanceof NoSuchFileException) {
                            Logging.recoverableException(Logging.getLogger("org.apache.sis.storage.netcdf"), netcdfFileClass, "canOpen", throwable);
                            return ProbeResult.UNSUPPORTED_STORAGE;
                        }
                        throw new DataStoreException(invocationTargetException);
                    }
                }
            } else {
                for (Class<?> clazz = storageConnector.getStorage().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    if (!UCAR_CLASSNAME.equals(clazz.getName())) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl) {
            return new ProbeResult(bl2, MIME_TYPE, Version.valueOf(n));
        }
        return bl2 ? new ProbeResult(true, MIME_TYPE, null) : ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return new NetcdfStore(this, storageConnector);
    }

    static Decoder decoder(WarningListeners<DataStore> warningListeners, StorageConnector storageConnector) throws IOException, DataStoreException {
        Object object;
        Decoder decoder;
        GeometryLibrary geometryLibrary = storageConnector.getOption(OptionKey.GEOMETRY_LIBRARY);
        ChannelDataInput channelDataInput = storageConnector.getStorageAs(ChannelDataInput.class);
        if (channelDataInput != null) {
            try {
                decoder = new ChannelDecoder(channelDataInput, storageConnector.getOption(OptionKey.ENCODING), geometryLibrary, warningListeners);
                object = channelDataInput;
            }
            catch (DataStoreException dataStoreException) {
                String string = storageConnector.getStorageAs(String.class);
                if (string != null) {
                    try {
                        Decoder decoder2 = NetcdfStoreProvider.createByReflection(string, false, geometryLibrary, warningListeners);
                        String string2 = string;
                    }
                    catch (IOException | DataStoreException exception) {
                        dataStoreException.addSuppressed(exception);
                    }
                }
                throw dataStoreException;
            }
        }
        object = storageConnector.getStorage();
        decoder = NetcdfStoreProvider.createByReflection(object, true, geometryLibrary, warningListeners);
        storageConnector.closeAllExcept(object);
        return decoder;
    }

    private static Decoder createByReflection(Object object, boolean bl, GeometryLibrary geometryLibrary, WarningListeners<DataStore> warningListeners) throws IOException, DataStoreException {
        Class<Object> clazz;
        Constructor<? extends Decoder> constructor;
        NetcdfStoreProvider.ensureInitialized(true);
        if (bl) {
            constructor = createFromUCAR;
            clazz = netcdfFileClass;
        } else {
            constructor = createFromPath;
            clazz = String.class;
        }
        if (constructor == null || !clazz.isInstance(object)) {
            return null;
        }
        try {
            return constructor.newInstance(new Object[]{object, geometryLibrary, warningListeners});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof DataStoreException) {
                throw (DataStoreException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInitialized(boolean bl) {
        if (netcdfFileClass != null) return;
        Level level = null;
        Throwable throwable = null;
        Object object = NetcdfStoreProvider.class;
        synchronized (NetcdfStoreProvider.class) {
            try {
                netcdfFileClass = Class.forName(UCAR_CLASSNAME);
                canOpenFromPath = netcdfFileClass.getMethod("canOpen", String.class);
                if (canOpenFromPath.getReturnType() == Boolean.TYPE) {
                    Class<Decoder> clazz = Class.forName("org.apache.sis.internal.netcdf.ucar.DecoderWrapper").asSubclass(Decoder.class);
                    Class[] classArray = new Class[]{netcdfFileClass, GeometryLibrary.class, WarningListeners.class};
                    createFromUCAR = clazz.getConstructor(classArray);
                    classArray[0] = String.class;
                    createFromPath = clazz.getConstructor(classArray);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                level = Level.CONFIG;
            }
            catch (NoClassDefFoundError | ReflectiveOperationException throwable2) {
                level = Level.WARNING;
                throwable = throwable2;
            }
            NetcdfStoreProvider.reset();
            netcdfFileClass = Void.TYPE;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            object = Resources.forLocale(null).getLogRecord(level, (short)4);
            ((LogRecord)object).setThrown(throwable);
            ((LogRecord)object).setLoggerName("org.apache.sis.storage.netcdf");
            Logging.log(NetcdfStoreProvider.class, bl ? "open" : "probeContent", (LogRecord)object);
            return;
        }
    }

    static synchronized void reset() {
        netcdfFileClass = null;
        canOpenFromPath = null;
        createFromUCAR = null;
        createFromPath = null;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.storage.netcdf"){

            @Override
            protected void classpathChanged() {
                NetcdfStoreProvider.reset();
            }
        });
    }
}

