/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.sis.xml.FilterVersion;

final class FilteredNamespaces
implements NamespaceContext {
    private final NamespaceContext context;
    private final Map<String, String> toView;
    private final Map<String, String> toImpl;

    FilteredNamespaces(NamespaceContext namespaceContext, FilterVersion filterVersion, boolean bl) {
        this.context = namespaceContext;
        if (!bl) {
            this.toView = filterVersion.toView;
            this.toImpl = filterVersion.toImpl;
        } else {
            this.toView = filterVersion.toImpl;
            this.toImpl = filterVersion.toView;
        }
    }

    NamespaceContext inverse(FilterVersion filterVersion) {
        if (this.toView == filterVersion.toView && this.toImpl == filterVersion.toImpl) {
            return this;
        }
        return new FilteredNamespaces(this, filterVersion, true);
    }

    private String toView(String string) {
        String string2 = this.toView.get(string);
        return string2 != null ? string2 : string;
    }

    private String toImpl(String string) {
        String string2 = this.toImpl.get(string);
        return string2 != null ? string2 : string;
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.toView(this.context.getNamespaceURI(string));
    }

    @Override
    public String getPrefix(String string) {
        return this.context.getPrefix(this.toImpl(string));
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        return this.context.getPrefixes(this.toImpl(string));
    }
}

