/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch;

import java.util.Date;

class FileStarted {
    private final String resourceId;
    private final long started;

    public FileStarted(String resourceId) {
        this(resourceId, new Date().getTime());
    }

    public FileStarted(String resourceId, long started) {
        this.resourceId = resourceId;
        this.started = started;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public long getStarted() {
        return this.started;
    }

    public long getElapsedMillis() {
        long now = new Date().getTime();
        return now - this.started;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
        result = 31 * result + (int)(this.started ^ this.started >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileStarted)) {
            return false;
        }
        FileStarted other = (FileStarted)obj;
        if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
            return false;
        }
        return this.started == other.started;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FileStarted [resourceId=");
        builder.append(this.resourceId);
        builder.append(", started=");
        builder.append(this.started);
        builder.append("]");
        return builder.toString();
    }
}

