/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.swath;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import ucar.nc2.Dimension;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.ft.FeatureDatasetImpl;
import ucar.nc2.util.CancelTask;

public class SwathDatasetFactory
implements FeatureDatasetFactory {
    @Override
    public Object isMine(FeatureType wantFeatureType, NetcdfDataset ncd, Formatter errlog) throws IOException {
        if (wantFeatureType == FeatureType.SWATH && this.isSwath(ncd.getCoordinateSystems())) {
            return true;
        }
        return null;
    }

    @Override
    public FeatureDataset open(FeatureType ftype, NetcdfDataset ncd, Object analysis, CancelTask task, Formatter errlog) throws IOException {
        return new SwathDataset(ncd);
    }

    @Override
    public FeatureType[] getFeatureType() {
        return new FeatureType[]{FeatureType.SWATH};
    }

    private boolean isSwath(List<CoordinateSystem> csysList) {
        CoordinateSystem use = null;
        for (CoordinateSystem csys : csysList) {
            if (use == null) {
                use = csys;
                continue;
            }
            if (csys.getCoordinateAxes().size() <= use.getCoordinateAxes().size()) continue;
            use = csys;
        }
        if (use == null) {
            return false;
        }
        CoordinateAxis lat = use.getLatAxis();
        CoordinateAxis lon = use.getLonAxis();
        CoordinateAxis time = use.getTaxis();
        if (lat == null || lat.getRank() != 2) {
            return false;
        }
        if (lon == null || lon.getRank() != 2) {
            return false;
        }
        if (time == null) {
            return false;
        }
        if (!lat.getDimension(0).equals(lon.getDimension(0))) {
            return false;
        }
        if (!lat.getDimension(1).equals(lon.getDimension(1))) {
            return false;
        }
        HashSet<Dimension> dims = new HashSet<Dimension>(10);
        for (Dimension d : lat.getDimensions()) {
            dims.add(d);
        }
        for (Dimension d : lon.getDimensions()) {
            dims.add(d);
        }
        for (Dimension d : time.getDimensions()) {
            if (dims.contains(d)) continue;
            return false;
        }
        return true;
    }

    private static class SwathDataset
    extends FeatureDatasetImpl {
        SwathDataset(NetcdfDataset ncd) {
            super(ncd);
        }

        @Override
        public FeatureType getFeatureType() {
            return FeatureType.SWATH;
        }

        @Override
        public void calcBounds() throws IOException {
        }
    }
}

