package Text::Guess::Language::Words;
use utf8;

use strict;
use warnings;

our $words;

BEGIN {
$words = {
'a'=>['ar','az','bg','bs','ca','cs','da','de','el','en','es','et','fa','fi','fr','gl','hi','hr','hu','id','is','it','la','lt','lv','ms','nb','nl','no','pl','pt','pt_br','ro','ru','si','sk','sl','sq','sr','sv','th','tr','zh_cn','zh_tw',],
'aaa'=>['th',],
'aamulla'=>['fi',],
'aan'=>['af','nl',],
'aand'=>['af',],
'aandeel'=>['af',],
'aangesien'=>['af',],
'aanspreeklik'=>['af',],
'aanvaar'=>['af',],
'aanval'=>['af',],
'aap'=>['af',],
'aarde'=>['af','nl',],
'aardig'=>['nl',],
'aasta'=>['et',],
'aastaid'=>['et',],
'aastal'=>['et',],
'aastat'=>['et',],
'ab'=>['de','la',],
'abad'=>['id',],
'abaixo'=>['gl',],
'abajo'=>['es',],
'abans'=>['ca',],
'abba'=>['hu',],
'abban'=>['hu',],
'abbastanza'=>['it',],
'abbia'=>['it',],
'abbiamo'=>['it',],
'abend'=>['de',],
'aber'=>['de',],
'abi'=>['et','lv',],
'abia'=>['ro',],
'abikaasa'=>['et',],
'able'=>['en',],
'abogado'=>['es',],
'abord'=>['fr',],
'about'=>['en','fa','si','th',],
'abra'=>['pt_br',],
'abraham'=>['la',],
'abre'=>['es','pt',],
'abrir'=>['pt','pt_br',],
'absolument'=>['fr',],
'absolut'=>['ro','sv',],
'absolutely'=>['en',],
'absolutt'=>['nb','no',],
'absoluut'=>['af','nl',],
'abu'=>['lt',],
'abuela'=>['es',],
'abuelo'=>['es',],
'aby'=>['cs','pl','sk',],
'abych'=>['cs',],
'abychom'=>['cs',],
'abys'=>['cs',],
'abyste'=>['cs',],
'ac'=>['la',],
'acaba'=>['ca','es','tr',],
'acabar'=>['ca','pt','pt_br',],
'acabat'=>['ca',],
'acabei'=>['pt','pt_br',],
'acabo'=>['ca','es',],
'acabou'=>['pt','pt_br',],
'acabó'=>['es',],
'acara'=>['id','ms',],
'acasa'=>['ro',],
'acasă'=>['ro',],
'accepit'=>['la',],
'accident'=>['ca','en','fr','ro',],
'accidente'=>['es',],
'accidenti'=>['it',],
'acción'=>['gl',],
'accord'=>['fr',],
'accordo'=>['it',],
'acea'=>['ro',],
'aceasta'=>['ro',],
'această'=>['ro',],
'aceea'=>['ro',],
'aceeaşi'=>['ro',],
'acel'=>['ro',],
'acela'=>['ro',],
'acelaşi'=>['ro',],
'acele'=>['tr',],
'acerca'=>['es','pt',],
'acest'=>['ro',],
'acesta'=>['ro',],
'aceste'=>['ro',],
'acestea'=>['ro',],
'ach'=>['cs','de','sk',],
'acha'=>['pt','pt_br',],
'achar'=>['pt_br',],
'achas'=>['pt',],
'achei'=>['pt','pt_br',],
'acheter'=>['fr',],
'acho'=>['pt','pt_br',],
'achou'=>['pt_br',],
'acht'=>['de','nl',],
'achter'=>['nl',],
'acidente'=>['pt','pt_br',],
'acie'=>['la',],
'aciem'=>['la',],
'acil'=>['tr',],
'acis'=>['lv',],
'acolo'=>['ro',],
'aconseguir'=>['ca',],
'acontece'=>['pt','pt_br',],
'acontecendo'=>['pt_br',],
'acontecer'=>['pt','pt_br',],
'aconteceu'=>['pt','pt_br',],
'acord'=>['ca','ro',],
'acordo'=>['gl','pt','pt_br',],
'acqua'=>['it',],
'acredita'=>['pt','pt_br',],
'acreditar'=>['pt','pt_br',],
'acredito'=>['pt','pt_br',],
'across'=>['en',],
'act'=>['en',],
'actitude'=>['gl',],
'actividade'=>['gl',],
'actividades'=>['gl',],
'acto'=>['gl',],
'actual'=>['gl',],
'actually'=>['en',],
'acuerdo'=>['es',],
'acum'=>['ro',],
'acá'=>['es',],
'ací'=>['ca',],
'acòrdi'=>['ca',],
'acı'=>['tr',],
'ad'=>['da','is','it','la','si',],
'ada'=>['id','ms',],
'adakah'=>['ms',],
'adalah'=>['id','ms',],
'adam'=>['az','tr',],
'adamlar'=>['tr',],
'adamı'=>['tr',],
'adamım'=>['tr',],
'adamın'=>['tr',],
'adaptarea'=>['ro',],
'add'=>['hu',],
'addig'=>['hu',],
'addio'=>['it',],
'addosso'=>['it',],
'adelante'=>['es',],
'ademais'=>['gl',],
'además'=>['es',],
'adentro'=>['es',],
'adeo'=>['la',],
'adesso'=>['it',],
'adeus'=>['pt','pt_br',],
'adevarat'=>['ro',],
'adevăr'=>['ro',],
'adevărat'=>['ro',],
'adevărul'=>['ro',],
'adhuc'=>['la',],
'adiante'=>['gl',],
'adică'=>['ro',],
'adierazi'=>['eu',],
'adijo'=>['sl',],
'adiós'=>['es',],
'adj'=>['hu',],
'adja'=>['hu',],
'adjö'=>['sv',],
'administración'=>['gl',],
'adni'=>['hu',],
'adok'=>['hu',],
'adore'=>['fr',],
'adorea'=>['eu',],
'adoro'=>['pt','pt_br',],
'ados'=>['eu',],
'adott'=>['hu',],
'aduc'=>['ro',],
'aduce'=>['ro',],
'aduci'=>['ro',],
'aduersus'=>['la',],
'adus'=>['ro',],
'adversus'=>['la',],
'advocaat'=>['nl',],
'advogado'=>['pt','pt_br',],
'advokat'=>['da','sv',],
'adéu'=>['ca',],
'adónde'=>['es',],
'adı'=>['az','tr',],
'adım'=>['tr',],
'adın'=>['tr',],
'adına'=>['tr',],
'adını'=>['tr',],
'aeg'=>['et',],
'aega'=>['et',],
'aegypto'=>['la',],
'aeque'=>['la',],
'aer'=>['ro',],
'aereo'=>['it',],
'aetate'=>['la',],
'aetatis'=>['la',],
'aeternum'=>['la',],
'af'=>['af','da','is','nl','no',],
'afaceri'=>['ro',],
'afara'=>['ro',],
'afară'=>['ro',],
'affaire'=>['fr',],
'affaires'=>['fr',],
'affari'=>['it',],
'affedersin'=>['tr',],
'affedersiniz'=>['tr',],
'afforded'=>['hi',],
'affärer'=>['sv',],
'afgelopen'=>['nl',],
'afirmou'=>['gl',],
'afkoel'=>['af',],
'afla'=>['ro',],
'aflat'=>['ro',],
'află'=>['ro',],
'afraid'=>['en','si',],
'afrika'=>['id',],
'afsakaðu'=>['is',],
'afsakið'=>['is',],
'afspraak'=>['nl',],
'afsted'=>['da',],
'aftale'=>['da',],
'aftan'=>['is',],
'aften'=>['da','no',],
'after'=>['en','si',],
'afternoon'=>['en',],
'aftes'=>['da',],
'aftur'=>['is',],
'afuera'=>['es',],
'afwerking'=>['af',],
'afër'=>['sq',],
'ag'=>['af',],
'aga'=>['et',],
'agafa'=>['ca',],
'agafar'=>['ca',],
'again'=>['en','si','th',],
'against'=>['en',],
'agak'=>['id','ms',],
'agama'=>['id',],
'agar'=>['ms',],
'age'=>['en',],
'agen'=>['ms',],
'agency'=>['si',],
'agent'=>['ca','da','fr','nl','sv',],
'agente'=>['es','it','pt','pt_br',],
'agere'=>['la',],
'aggódj'=>['hu',],
'agian'=>['eu',],
'agintzailea'=>['eu',],
'agintzen'=>['eu',],
'agit'=>['fr',],
'agli'=>['it',],
'ago'=>['en',],
'agora'=>['gl','pt','pt_br',],
'agrada'=>['ca',],
'agradaria'=>['ca',],
'agraden'=>['ca',],
'agree'=>['en',],
'agro'=>['la',],
'agrāk'=>['lv',],
'agt'=>['af',],
'agter'=>['af',],
'agua'=>['es',],
'agure'=>['eu',],
'agureak'=>['eu',],
'agurtu'=>['eu',],
'ah'=>['bs','ca','da','de','en','es','et','fr','hr','it','ms','pt','pt_br','ro','sk','sl','sq','sr','tr',],
'aha'=>['bs','cs','hr','hu','lt','sk','sr',],
'ahal'=>['eu',],
'ahalko'=>['eu',],
'ahazten'=>['eu',],
'ahaztu'=>['eu',],
'ahbap'=>['tr',],
'ahead'=>['en',],
'ahhhh'=>['af',],
'ahhoz'=>['hu',],
'ahir'=>['ca',],
'ahli'=>['id','ms',],
'ahnung'=>['de',],
'aho'=>['eu',],
'ahogy'=>['hu',],
'ahoj'=>['cs','sk',],
'ahol'=>['hu',],
'ahora'=>['es',],
'ahí'=>['es',],
'ai'=>['af','ca','fi','fr','it','pt','pt_br','ro','sq',],
'aia'=>['ro',],
'aibă'=>['ro',],
'aici'=>['ro',],
'aicí'=>['ca',],
'aidake'=>['et',],
'aidata'=>['et',],
'aide'=>['fr',],
'aider'=>['fr',],
'aie'=>['fr',],
'aiemmin'=>['fi',],
'aigua'=>['ca',],
'aii'=>['en',],
'aika'=>['fi',],
'aikaa'=>['fi',],
'aikaan'=>['fi',],
'aikana'=>['fi',],
'aile'=>['tr',],
'aille'=>['fr',],
'ailleurs'=>['fr',],
'aime'=>['fr',],
'aimer'=>['fr',],
'aimerais'=>['fr',],
'aimes'=>['fr',],
'aimugi'=>['et',],
'aimé'=>['fr',],
'ain'=>['en',],
'aina'=>['fi',],
'ainakin'=>['fi',],
'ainda'=>['pt','pt_br',],
'ainoa'=>['fi',],
'ainsi'=>['fr',],
'ainuke'=>['et',],
'ainult'=>['et',],
'ainus'=>['et',],
'aio'=>['fi',],
'aion'=>['fi',],
'aiot'=>['fi',],
'aiotko'=>['fi',],
'air'=>['af','en','fr','id','ms','si','th',],
'aire'=>['ca','es','gl',],
'airport'=>['si',],
'ait'=>['fr','la','tr',],
'aita'=>['et','eu',],
'aitab'=>['et',],
'aitak'=>['eu',],
'aitarekin'=>['eu',],
'aitonak'=>['eu',],
'aitonarengandik'=>['eu',],
'aitonarentzat'=>['eu',],
'aitonari'=>['eu',],
'aitzakiatzat'=>['eu',],
'aitäh'=>['et',],
'aiutare'=>['it',],
'aiuto'=>['it',],
'aivan'=>['fi',],
'així'=>['ca',],
'això'=>['ca',],
'aiz'=>['lv',],
'aiziet'=>['lv',],
'aizmirsti'=>['lv',],
'aizu'=>['eu',],
'aizveries'=>['lv',],
'aišku'=>['lt',],
'aj'=>['si','sk',],
'aja'=>['et',],
'ajaa'=>['fi',],
'ajad'=>['et',],
'ajaks'=>['et',],
'ajal'=>['et',],
'ajan'=>['fi',],
'ajast'=>['et',],
'ajattele'=>['fi',],
'ajattelin'=>['fi',],
'ajatus'=>['fi',],
'ajde'=>['bs','sr',],
'ajo'=>['sq',],
'ajtót'=>['hu',],
'ajuda'=>['ca','pt','pt_br',],
'ajudar'=>['ca','pt','pt_br',],
'ajude'=>['pt_br',],
'ajung'=>['ro',],
'ajunge'=>['ro',],
'ajungem'=>['ro',],
'ajuns'=>['ro',],
'ajut'=>['ro',],
'ajuta'=>['ro',],
'ajute'=>['ro',],
'ajutor'=>['ro',],
'ajutorul'=>['ro',],
'ak'=>['id','lt','lv','sk',],
'akal'=>['id','ms',],
'akan'=>['id','ms',],
'akar'=>['hu',],
'akarja'=>['hu',],
'akarnak'=>['hu',],
'akarod'=>['hu',],
'akarok'=>['hu',],
'akarom'=>['hu',],
'akarsz'=>['hu',],
'akart'=>['hu',],
'akarta'=>['hu',],
'akartam'=>['hu',],
'akhir'=>['id','ms',],
'akhirnya'=>['id','ms',],
'aki'=>['hi','hu','si',],
'akik'=>['hu',],
'akinek'=>['hu',],
'akis'=>['lt',],
'akit'=>['hu',],
'akkor'=>['hu',],
'akkurat'=>['nb','no',],
'akmens'=>['lv',],
'ako'=>['bs','hr','sk','sr',],
'akoby'=>['sk',],
'akoma'=>['sq',],
'akta'=>['sv',],
'aku'=>['id','ms',],
'aká'=>['sk',],
'akár'=>['hu',],
'aké'=>['sk',],
'akú'=>['sk',],
'aký'=>['sk',],
'akşam'=>['tr',],
'al'=>['af','bs','ca','da','es','eu','it','nl','ro','si','tr',],
'ala'=>['fi',],
'alaba'=>['eu',],
'alabilir'=>['tr',],
'alacağım'=>['tr',],
'aladdin'=>['af',],
'alam'=>['id','ms',],
'alan'=>['fi',],
'alara'=>['ca',],
'alas'=>['fi',],
'alasan'=>['id','ms',],
'alat'=>['id','ms',],
'alati'=>['et',],
'alatt'=>['hu',],
'albo'=>['pl',],
'alcalde'=>['gl',],
'alcune'=>['it',],
'alcuni'=>['it',],
'aldatu'=>['eu',],
'alde'=>['eu',],
'aldera'=>['eu',],
'aldian'=>['eu',],
'alditik'=>['eu',],
'aldrei'=>['is',],
'aldri'=>['nb','no',],
'aldrig'=>['da','no','sv',],
'aldı'=>['tr',],
'aldım'=>['tr',],
'aldın'=>['tr',],
'ale'=>['cs','pl','ro','sk',],
'alea'=>['ro',],
'alebo'=>['sk',],
'alegro'=>['ca','es',],
'alemanian'=>['eu',],
'alene'=>['da','nb','no',],
'ales'=>['ro',],
'aleshores'=>['ca',],
'alespoň'=>['cs',],
'alex'=>['da',],
'algemene'=>['af',],
'algo'=>['es','gl','pt','pt_br',],
'alguien'=>['es',],
'algum'=>['pt','pt_br',],
'alguma'=>['pt','pt_br',],
'algumas'=>['pt','pt_br',],
'algun'=>['ca',],
'alguna'=>['ca','es',],
'algunas'=>['es',],
'algunes'=>['ca',],
'algunha'=>['gl',],
'algunhas'=>['gl',],
'algunos'=>['es',],
'alguns'=>['ca','pt','pt_br',],
'alguém'=>['pt','pt_br',],
'alguén'=>['gl',],
'algú'=>['ca',],
'algún'=>['es','gl',],
'algúns'=>['gl',],
'alhoewel'=>['af',],
'ali'=>['bs','hr','pt','pt_br','sl','sr',],
'alia'=>['la',],
'aliam'=>['la',],
'alias'=>['la',],
'alien'=>['id','th',],
'aliens'=>['th',],
'alig'=>['hu',],
'alii'=>['la',],
'aliis'=>['la',],
'alio'=>['la','lt',],
'aliorum'=>['la',],
'alios'=>['la',],
'aliqua'=>['la',],
'aliquam'=>['la',],
'aliquando'=>['la',],
'aliquem'=>['la',],
'aliquid'=>['la',],
'aliquis'=>['la',],
'aliquo'=>['la',],
'aliter'=>['la',],
'aliud'=>['la',],
'alium'=>['la',],
'alius'=>['la',],
'alive'=>['en',],
'alkaa'=>['fi',],
'alkitab'=>['id',],
'alkoi'=>['fi',],
'all'=>['da','de','en','et','fa','nb','no','si','sv','th',],
'alla'=>['et','fi','is','it','sv',],
'allah'=>['az','id','ms','tr',],
'allais'=>['fr',],
'allait'=>['fr',],
'allan'=>['is',],
'allar'=>['is',],
'alldeles'=>['sv',],
'alle'=>['af','da','de','fi','it','nb','nl','no',],
'allebei'=>['nl',],
'alleen'=>['af','nl',],
'allein'=>['de',],
'alleine'=>['de',],
'allem'=>['de',],
'allemaal'=>['nl',],
'allen'=>['de','nl',],
'allende'=>['ca',],
'aller'=>['fr',],
'allerede'=>['da','nb','no',],
'alles'=>['af','de','et','nl',],
'allez'=>['fr',],
'alligevel'=>['da',],
'allihop'=>['sv',],
'allir'=>['is',],
'allo'=>['it',],
'allons'=>['fr',],
'allora'=>['it',],
'allra'=>['is',],
'alls'=>['is','sv',],
'allt'=>['is','sv',],
'alltaf'=>['is',],
'alltid'=>['nb','no','sv',],
'allting'=>['sv',],
'alltså'=>['sv',],
'allvar'=>['sv',],
'allà'=>['ca',],
'allá'=>['es',],
'allé'=>['fr',],
'allí'=>['ca','es',],
'allò'=>['ca',],
'allô'=>['fr',],
'alma'=>['es','pt','pt_br',],
'almak'=>['tr',],
'almal'=>['af',],
'almaya'=>['tr',],
'almeno'=>['it',],
'almenys'=>['ca',],
'almost'=>['en',],
'almoço'=>['pt',],
'almáttugur'=>['is',],
'alo'=>['ro','sq','tr',],
'alone'=>['en',],
'along'=>['en','th',],
'alors'=>['fr',],
'already'=>['en',],
'alrededor'=>['es',],
'alright'=>['en','si',],
'als'=>['ca','de','nl',],
'alsjeblieft'=>['nl',],
'also'=>['de','en',],
'alsof'=>['nl',],
'alstublieft'=>['nl',],
'alt'=>['ca','da','de','et','nb','no','ro',],
'alta'=>['gl','ro',],
'altceva'=>['ro',],
'altcineva'=>['ro',],
'alte'=>['de','ro',],
'alten'=>['de',],
'alter'=>['de','la',],
'altera'=>['la',],
'alterius'=>['la',],
'altero'=>['la',],
'alterum'=>['la',],
'altfel'=>['ro',],
'altid'=>['da',],
'altijd'=>['nl',],
'alting'=>['da',],
'alto'=>['es','gl','it','pt','pt_br',],
'altra'=>['ca','it',],
'altre'=>['ca','it',],
'altres'=>['ca',],
'altri'=>['it',],
'altro'=>['it',],
'altså'=>['da','nb','no',],
'altura'=>['gl','pt',],
'altyd'=>['af',],
'altă'=>['ro',],
'altı'=>['tr',],
'altın'=>['tr',],
'altında'=>['tr',],
'aludni'=>['hu',],
'alvara'=>['is',],
'alveg'=>['is',],
'alvorlig'=>['nb','no',],
'alvöru'=>['is',],
'always'=>['en','si',],
'alwsys'=>['af',],
'alá'=>['gl','hu',],
'além'=>['pt','pt_br',],
'alí'=>['gl',],
'alô'=>['pt_br',],
'alın'=>['tr',],
'alıp'=>['tr',],
'alır'=>['tr',],
'am'=>['de','en','ro','si',],
'ama'=>['eu','pt_br','tr',],
'amable'=>['es',],
'amak'=>['eu',],
'aman'=>['id','ms','tr',],
'amanhã'=>['pt','pt_br',],
'amari'=>['eu',],
'amatasuna'=>['eu',],
'amazing'=>['th',],
'amb'=>['ca',],
'ambiente'=>['gl',],
'ambil'=>['ms',],
'ambos'=>['es','pt',],
'ameerika'=>['et',],
'amely'=>['hu',],
'america'=>['en','it','ro',],
'american'=>['en',],
'amerika'=>['id','ms','nb','nl','no','tr',],
'amerikaanse'=>['nl',],
'amerikai'=>['hu',],
'amerikan'=>['tr',],
'amerikos'=>['lt',],
'ami'=>['fr','hu',],
'amic'=>['ca',],
'amica'=>['it',],
'amice'=>['ro',],
'amici'=>['it',],
'amico'=>['it',],
'amics'=>['ca',],
'amie'=>['fr',],
'amiga'=>['es','pt','pt_br',],
'amigo'=>['es','gl','pt','pt_br',],
'amigos'=>['es','gl','pt','pt_br',],
'amiket'=>['hu',],
'amikor'=>['hu',],
'amint'=>['hu',],
'aminte'=>['ro',],
'amintesc'=>['ro',],
'aminteşti'=>['ro',],
'amire'=>['hu',],
'amis'=>['fr',],
'amit'=>['hu',],
'amiért'=>['hu',],
'amma'=>['az',],
'ammu'=>['fi',],
'amo'=>['ca','es','it','pt','pt_br',],
'amona'=>['eu',],
'amonak'=>['eu',],
'amor'=>['ca','es','gl','pt','pt_br',],
'amore'=>['it',],
'amour'=>['fr',],
'ampak'=>['sl',],
'amper'=>['af',],
'amplius'=>['la',],
'amunt'=>['ca',],
'amuzant'=>['ro',],
'amândoi'=>['ro',],
'amèrica'=>['ca',],
'américa'=>['pt',],
'amérique'=>['fr',],
'amíg'=>['hu',],
'an'=>['da','de','en','fr','id','la','nb','no','ro','si','th','tr',],
'ana'=>['az','sq','tr',],
'anaia'=>['eu',],
'anaiarentzat'=>['eu',],
'anak'=>['id','ms',],
'anakin'=>['ca',],
'anakku'=>['ms',],
'analyse'=>['si',],
'anar'=>['ca',],
'anat'=>['ca',],
'anatz'=>['ca',],
'anava'=>['ca',],
'ancak'=>['tr',],
'ancaman'=>['id',],
'ancaq'=>['az',],
'anch'=>['it',],
'anche'=>['it',],
'ancora'=>['it',],
'and'=>['bs','cs','de','en','fa','hu','lt','ms','nb','pl','ru','si','sk','th',],
'anda'=>['es','et','id','ms','pt','pt_br','tr',],
'andando'=>['it',],
'andar'=>['gl','pt','pt_br',],
'andare'=>['it',],
'andas'=>['sv',],
'andata'=>['it',],
'andate'=>['it',],
'andato'=>['it',],
'andej'=>['sq',],
'andeks'=>['et',],
'anden'=>['da','no',],
'ander'=>['af','nl',],
'andere'=>['de','nl',],
'andereak'=>['eu',],
'anderen'=>['de','nl',],
'anderes'=>['de',],
'anderledes'=>['da',],
'anders'=>['af','de','nl',],
'andet'=>['da',],
'andiamo'=>['it',],
'andis'=>['et',],
'andke'=>['et',],
'andra'=>['sv',],
'andre'=>['da','eu','nb','no',],
'andrà'=>['it',],
'andskotinn'=>['is',],
'andy'=>['ca',],
'aneh'=>['id','ms',],
'anem'=>['ca',],
'aner'=>['da','nb','no',],
'aneu'=>['ca',],
'anfang'=>['de',],
'angerufen'=>['de',],
'angin'=>['id','ms',],
'angkasa'=>['id',],
'angkatan'=>['id',],
'anglais'=>['fr',],
'angst'=>['de',],
'ani'=>['cs','pl','ro','sk',],
'anima'=>['it','la',],
'animais'=>['gl','pt',],
'animam'=>['la',],
'animi'=>['la',],
'animis'=>['la',],
'animo'=>['la',],
'animos'=>['la',],
'animum'=>['la',],
'animus'=>['la',],
'aning'=>['sv',],
'anirem'=>['ca',],
'anirà'=>['ca',],
'aniré'=>['ca',],
'aniversário'=>['pt_br',],
'anjing'=>['ms',],
'ankles'=>['si',],
'anksčiau'=>['lt',],
'anladım'=>['tr',],
'anladın'=>['tr',],
'anlamı'=>['tr',],
'anlamıyorum'=>['tr',],
'anlat'=>['tr',],
'anlaşıldı'=>['tr',],
'anlıyor'=>['tr',],
'anlıyorum'=>['tr',],
'anna'=>['et','eu','fi',],
'annab'=>['et',],
'annak'=>['hu',],
'annan'=>['et','fi','is','sv',],
'annar'=>['is',],
'annaren'=>['eu',],
'annars'=>['is','sv',],
'annat'=>['sv',],
'annað'=>['is',],
'anne'=>['tr',],
'annem'=>['tr',],
'annen'=>['nb','no','tr',],
'annerledes'=>['nb','no',],
'annet'=>['nb','no',],
'anni'=>['it','la',],
'annie'=>['ca',],
'annis'=>['la',],
'anniversaire'=>['fr',],
'anno'=>['it','la',],
'annorlunda'=>['sv',],
'annorum'=>['la',],
'annos'=>['la',],
'annum'=>['la',],
'annus'=>['la',],
'annyi'=>['hu',],
'annyira'=>['hu',],
'annyit'=>['hu',],
'annál'=>['hu',],
'année'=>['fr',],
'années'=>['fr',],
'ano'=>['cs','gl','pt','pt_br','sk',],
'anoche'=>['es',],
'anos'=>['gl','pt','pt_br',],
'another'=>['en','th',],
'anque'=>['gl',],
'anrufen'=>['de',],
'ans'=>['fr',],
'ansigt'=>['da',],
'ansikte'=>['sv',],
'ansiktet'=>['nb','no',],
'answer'=>['en',],
'ant'=>['lt',],
'antaa'=>['fi',],
'antakaa'=>['fi',],
'antar'=>['nb','sv',],
'antara'=>['id','ms',],
'ante'=>['es','gl','la',],
'antea'=>['la',],
'anteeksi'=>['fi',],
'antena'=>['id',],
'antenna'=>['th',],
'anterior'=>['gl',],
'antes'=>['es','gl','pt','pt_br',],
'antoi'=>['fi',],
'antonio'=>['gl',],
'antwoord'=>['af','nl',],
'antwort'=>['de',],
'anul'=>['ro',],
'anume'=>['ro',],
'använda'=>['sv',],
'använder'=>['sv',],
'any'=>['ca','en','si',],
'anya'=>['hu',],
'anybody'=>['en',],
'anymore'=>['en',],
'anyone'=>['en',],
'anys'=>['ca',],
'anything'=>['en','si',],
'anyu'=>['hu',],
'anyway'=>['en','si',],
'anywhere'=>['en',],
'anyád'=>['hu',],
'anyám'=>['hu',],
'análise'=>['gl',],
'anën'=>['sq',],
'ao'=>['gl','is','pt','pt_br',],
'aonde'=>['pt','pt_br',],
'aos'=>['gl','pt','pt_br',],
'ap'=>['lv',],
'apa'=>['hu','id','ms','ro',],
'apakah'=>['id','ms',],
'apanhar'=>['pt',],
'apapun'=>['id','ms',],
'aparece'=>['gl',],
'apart'=>['th',],
'ape'=>['af',],
'apenas'=>['pt','pt_br',],
'apgailestauju'=>['lt',],
'api'=>['id','ms',],
'apie'=>['lt',],
'apirana'=>['eu',],
'apiranari'=>['eu',],
'apja'=>['hu',],
'apkārt'=>['lv',],
'aplink'=>['lt',],
'apmēram'=>['lv',],
'apo'=>['sq',],
'apoi'=>['ro',],
'apoio'=>['gl',],
'aposto'=>['pt','pt_br',],
'appel'=>['fr',],
'appeler'=>['fr',],
'appelle'=>['fr',],
'appelé'=>['fr',],
'appena'=>['it',],
'appi'=>['et',],
'apple'=>['si',],
'apprendre'=>['fr',],
'appris'=>['fr',],
'aprender'=>['pt',],
'apri'=>['it',],
'aproape'=>['ro',],
'aprunāties'=>['lv',],
'après'=>['fr',],
'apsaugos'=>['lt',],
'apsolu'=>['lv',],
'aptal'=>['tr',],
'apu'=>['hu',],
'apua'=>['fi',],
'apud'=>['la',],
'apur'=>['eu',],
'apurtu'=>['eu',],
'apurtzen'=>['eu',],
'apád'=>['hu',],
'apám'=>['hu',],
'após'=>['pt','pt_br',],
'apă'=>['ro',],
'aq'=>['sq',],
'aqua'=>['la',],
'aquae'=>['la',],
'aquam'=>['la',],
'aquel'=>['gl',],
'aquela'=>['gl','pt','pt_br',],
'aquelas'=>['gl',],
'aquele'=>['pt','pt_br',],
'aqueles'=>['gl','pt','pt_br',],
'aquell'=>['ca',],
'aquella'=>['ca',],
'aquells'=>['ca',],
'aquest'=>['ca',],
'aquesta'=>['ca',],
'aqueste'=>['ca',],
'aquestes'=>['ca',],
'aquests'=>['ca',],
'aqui'=>['es','pt','pt_br',],
'aquilo'=>['gl','pt','pt_br',],
'aquí'=>['ca','es','gl',],
'aquò'=>['ca',],
'ar'=>['lt','lv','pt','pt_br','ro','sv',],
'ara'=>['ca','tr',],
'araba'=>['tr',],
'arabayı'=>['tr',],
'arada'=>['tr',],
'arah'=>['id','ms',],
'arasında'=>['az','tr',],
'arata'=>['ro',],
'arată'=>['ro',],
'arau'=>['eu',],
'arazo'=>['eu',],
'arazorik'=>['eu',],
'arba'=>['lt',],
'arbaso'=>['eu',],
'arbasoa'=>['eu',],
'arbasoak'=>['eu',],
'arbasoei'=>['eu',],
'arbasoek'=>['eu',],
'arbasoekin'=>['eu',],
'arbasoen'=>['eu',],
'arbasoengandik'=>['eu',],
'arbasoetako'=>['eu',],
'arbeid'=>['nb',],
'arbeit'=>['de',],
'arbeite'=>['de',],
'arbeiten'=>['de',],
'arbejde'=>['da',],
'arbejder'=>['da',],
'arbejdet'=>['da',],
'arbetar'=>['sv',],
'arbete'=>['sv',],
'ardhur'=>['sq',],
'are'=>['en','fa','ro','si','th',],
'aren'=>['en',],
'arg'=>['sv',],
'argal'=>['eu',],
'argent'=>['fr',],
'argi'=>['eu','lt',],
'argumente'=>['af',],
'ari'=>['eu',],
'aria'=>['it',],
'arisen'=>['si',],
'aritu'=>['eu',],
'arkadaş'=>['tr',],
'arkadaşım'=>['tr',],
'arkadaşın'=>['tr',],
'arm'=>['de','nl',],
'arma'=>['ca','es','eu','la','pt','pt_br','ro',],
'armas'=>['es','et','pt','pt_br',],
'armastan'=>['et',],
'armastus'=>['et',],
'arme'=>['de','fr','nl','ro',],
'armee'=>['de',],
'armes'=>['ca','fr',],
'armi'=>['it',],
'armis'=>['la',],
'arms'=>['af','en','si',],
'army'=>['en','th',],
'armée'=>['fr',],
'armë'=>['sq',],
'armën'=>['sq',],
'armët'=>['sq',],
'arnasteko'=>['eu',],
'aro'=>['si',],
'around'=>['en','si','th',],
'arove'=>['hi',],
'arra'=>['hu',],
'arranjar'=>['pt',],
'arredor'=>['gl',],
'arriba'=>['ca','es','gl',],
'arribar'=>['ca',],
'arribat'=>['ca',],
'arriskutsua'=>['eu',],
'arritur'=>['sq',],
'arriva'=>['it',],
'arrivando'=>['it',],
'arrivare'=>['it',],
'arrivato'=>['it',],
'arrive'=>['fr',],
'arrivederci'=>['it',],
'arriver'=>['fr',],
'arrivo'=>['it',],
'arrivé'=>['fr',],
'arrivée'=>['fr',],
'arrière'=>['fr',],
'arropa'=>['eu',],
'arrête'=>['fr',],
'arrêter'=>['fr',],
'arrêtez'=>['fr',],
'arrêté'=>['fr',],
'arról'=>['hu',],
'arsch'=>['de',],
'arschloch'=>['de',],
'arsye'=>['sq',],
'art'=>['de','en',],
'artan'=>['az',],
'arte'=>['eu','gl','la',],
'artigo'=>['gl',],
'artinya'=>['ms',],
'artık'=>['tr',],
'artıq'=>['az',],
'aru'=>['et',],
'arust'=>['et',],
'arva'=>['et',],
'arvab'=>['et',],
'arvad'=>['et',],
'arvan'=>['et',],
'arvasin'=>['et',],
'arvatavasti'=>['et',],
'arvate'=>['et',],
'arvates'=>['et',],
'arzt'=>['de',],
'arăt'=>['ro',],
'arăţi'=>['ro',],
'arī'=>['lv',],
'as'=>['af','ca','en','fa','fr','gl','hu','id','lt','pt','pt_br','ro','si','sq','th',],
'asa'=>['ro',],
'asaj'=>['sq',],
'ascolta'=>['it',],
'asculta'=>['ro',],
'ascultă'=>['ro',],
'ase'=>['fi',],
'asegurou'=>['gl',],
'asemel'=>['et',],
'asemenea'=>['ro',],
'asesino'=>['es',],
'asgje'=>['sq',],
'asgjë'=>['sq',],
'ashtu'=>['sq',],
'asi'=>['cs','es','et','sk',],
'asia'=>['fi',],
'asiaa'=>['fi',],
'asian'=>['fi',],
'asiassa'=>['fi',],
'asiat'=>['fi',],
'asing'=>['id','ms',],
'asinis'=>['lv',],
'asioita'=>['fi',],
'asja'=>['et',],
'asjad'=>['et',],
'asju'=>['et',],
'ask'=>['en',],
'askatuko'=>['eu',],
'asked'=>['en','si',],
'aski'=>['eu',],
'asking'=>['en',],
'asko'=>['eu',],
'askush'=>['sq',],
'asla'=>['tr',],
'aslında'=>['tr',],
'asmatu'=>['eu',],
'asmoa'=>['eu',],
'asnjë'=>['sq',],
'asnjëherë'=>['sq',],
'asociación'=>['gl',],
'asof'=>['af',],
'aspak'=>['sq',],
'aspaldian'=>['eu',],
'asperger'=>['si',],
'aspetta'=>['it',],
'aspettando'=>['it',],
'aspettare'=>['it',],
'aspetti'=>['it',],
'aspetto'=>['it',],
'aspoň'=>['cs','sk',],
'ass'=>['en','si',],
'assassinat'=>['ca',],
'assassino'=>['pt','pt_br',],
'assassí'=>['ca',],
'asseblief'=>['af',],
'assez'=>['fr',],
'asshole'=>['en',],
'assim'=>['pt','pt_br',],
'assolutamente'=>['it',],
'assunto'=>['pt','pt_br',],
'asszonyom'=>['hu',],
'asta'=>['ro',],
'astaga'=>['ms',],
'astea'=>['ro',],
'asteroid'=>['id',],
'astfel'=>['ro',],
'asti'=>['fi',],
'astronaut'=>['th',],
'astronom'=>['id',],
'astronomi'=>['id',],
'astronot'=>['id',],
'astăzi'=>['ro',],
'asunto'=>['es','gl',],
'asupra'=>['ro',],
'asv'=>['lv',],
'así'=>['es','gl',],
'asıl'=>['tr',],
'at'=>['da','en','fa','la','nb','no','si','sq','th','tr',],
'ata'=>['gl','sq',],
'atac'=>['ca',],
'ataque'=>['pt','pt_br',],
'atas'=>['id','ms',],
'atat'=>['ro',],
'atau'=>['id','ms',],
'atbildi'=>['lv',],
'atceries'=>['lv',],
'atceros'=>['lv',],
'atdod'=>['lv',],
'ate'=>['sq',],
'ateik'=>['lt',],
'ateina'=>['lt',],
'ateis'=>['lt',],
'ateiti'=>['lt',],
'ateljee'=>['af',],
'atenció'=>['ca',],
'atención'=>['es','gl',],
'atent'=>['ro',],
'atenção'=>['pt','pt_br',],
'atenţie'=>['ro',],
'ateratzen'=>['eu',],
'ateş'=>['tr',],
'atgal'=>['lt',],
'atgriezies'=>['lv',],
'atgriezties'=>['lv',],
'ati'=>['ro',],
'atidaryk'=>['lt',],
'atij'=>['sq',],
'atje'=>['sq',],
'atkal'=>['lv',],
'atleisk'=>['lt',],
'atleiskit'=>['lt',],
'atleiskite'=>['lt',],
'atm'=>['si',],
'atmosfer'=>['id',],
'ato'=>['sq',],
'atom'=>['id',],
'atopar'=>['gl',],
'atpakaļ'=>['lv',],
'atque'=>['la',],
'atrada'=>['lv',],
'atradu'=>['lv',],
'atrast'=>['lv',],
'através'=>['pt','pt_br',],
'atrodai'=>['lt',],
'atrodas'=>['lv',],
'atrodo'=>['lt',],
'atrás'=>['es','gl','pt','pt_br',],
'atsargiai'=>['lt',],
'atseden'=>['eu',],
'atsedena'=>['eu',],
'atsegin'=>['eu',],
'atsiprašau'=>['lt',],
'atsitiko'=>['lt',],
'att'=>['sv',],
'attack'=>['en',],
'attaque'=>['fr',],
'attend'=>['fr',],
'attendez'=>['fr',],
'attendre'=>['fr',],
'attends'=>['fr',],
'attention'=>['en','fr','si','th',],
'attento'=>['it',],
'attenzione'=>['it',],
'attimo'=>['it',],
'attól'=>['hu',],
'atunci'=>['ro',],
'aturan'=>['id',],
'atvaino'=>['lv',],
'atvainojiet'=>['lv',],
'atvainojos'=>['lv',],
'atveju'=>['lt',],
'atver'=>['lv',],
'aty'=>['sq',],
'atyre'=>['sq',],
'atzaparkatu'=>['eu',],
'atzean'=>['eu',],
'atzera'=>['eu',],
'atzerako'=>['eu',],
'atzoko'=>['eu',],
'atât'=>['ro',],
'atâta'=>['ro',],
'até'=>['gl','pt','pt_br',],
'atë'=>['sq',],
'atëherë'=>['sq',],
'atā'=>['lv',],
'atėjau'=>['lt',],
'atėjo'=>['lt',],
'au'=>['ca','et','fr','ro',],
'auch'=>['de',],
'auctor'=>['la',],
'auctores'=>['la',],
'auctoritate'=>['la',],
'aucun'=>['fr',],
'aucune'=>['fr',],
'aud'=>['ro',],
'auf'=>['de',],
'aufhören'=>['de',],
'aufs'=>['de',],
'auga'=>['gl',],
'augas'=>['gl',],
'auge'=>['de',],
'augen'=>['de',],
'augenblick'=>['de',],
'augnablik'=>['is',],
'augun'=>['is',],
'augšā'=>['lv',],
'aukeratua'=>['eu',],
'aukeratuak'=>['eu',],
'auki'=>['fi',],
'aulki'=>['eu',],
'aunque'=>['es',],
'aura'=>['fr',],
'aurai'=>['fr',],
'aurais'=>['fr',],
'aurait'=>['fr',],
'auras'=>['fr',],
'aurez'=>['fr',],
'aurkitu'=>['eu',],
'aurkituko'=>['eu',],
'aurkiturik'=>['eu',],
'aurpegia'=>['eu',],
'aurrean'=>['eu',],
'aurrera'=>['eu',],
'aurretik'=>['eu',],
'aus'=>['de','et',],
'aussi'=>['fr',],
'australia'=>['id',],
'aut'=>['la',],
'auta'=>['cs','fi','sk',],
'autant'=>['fr',],
'aute'=>['sk',],
'autem'=>['la',],
'auto'=>['bs','cs','de','es','et','fi','hr','it','nl','sk','sr','th',],
'autoa'=>['eu',],
'auton'=>['fi',],
'autor'=>['gl',],
'autosse'=>['et',],
'autour'=>['fr',],
'autre'=>['fr',],
'autres'=>['fr',],
'auttaa'=>['fi',],
'auttakaa'=>['fi',],
'aux'=>['fr',],
'auzi'=>['ro',],
'auzit'=>['ro',],
'außer'=>['de',],
'außerdem'=>['de',],
'auðvelt'=>['is',],
'auðvitað'=>['is',],
'av'=>['nb','no','sv',],
'avaa'=>['fi',],
'avaient'=>['fr',],
'avais'=>['fr',],
'avait'=>['fr',],
'avalanche'=>['si',],
'avance'=>['fr',],
'avant'=>['fr',],
'avanti'=>['it',],
'avatar'=>['si',],
'avea'=>['ro',],
'aveam'=>['ro',],
'avec'=>['fr',],
'avem'=>['ro',],
'aver'=>['it',],
'avere'=>['it',],
'avesse'=>['it',],
'avessi'=>['it',],
'avete'=>['it',],
'aveti'=>['ro',],
'aveva'=>['it',],
'avevano'=>['it',],
'avevi'=>['it',],
'avevo'=>['it',],
'avez'=>['fr',],
'aveţi'=>['ro',],
'avi'=>['si',],
'aviat'=>['ca',],
'aviez'=>['fr',],
'avion'=>['bs','fr',],
'avis'=>['fr',],
'avião'=>['pt','pt_br',],
'avió'=>['ca',],
'avión'=>['es',],
'avocat'=>['fr',],
'avoir'=>['fr',],
'avond'=>['nl',],
'avons'=>['fr',],
'avrai'=>['it',],
'avrebbe'=>['it',],
'avrei'=>['it',],
'avresti'=>['it',],
'avrà'=>['it',],
'avtale'=>['nb','no',],
'avto'=>['sl',],
'avui'=>['ca',],
'avut'=>['ro',],
'avuto'=>['it',],
'avvocato'=>['it',],
'avèm'=>['ca',],
'avètz'=>['ca',],
'aw'=>['af',],
'awak'=>['ms',],
'awakens'=>['hi',],
'awal'=>['id','ms',],
'awan'=>['id',],
'away'=>['en','si','th',],
'axat'=>['az',],
'axiña'=>['gl',],
'axola'=>['eu',],
'axtar'=>['az',],
'axtarış'=>['az',],
'axuda'=>['gl',],
'ay'=>['es','tr',],
'ayah'=>['id','ms',],
'ayahku'=>['ms',],
'ayahmu'=>['ms',],
'ayam'=>['ms',],
'aye'=>['th',],
'ayer'=>['es',],
'aynen'=>['tr',],
'aynı'=>['tr',],
'ayo'=>['ms',],
'ayodhya'=>['af',],
'ayolah'=>['ms',],
'ayrıca'=>['tr',],
'ayuda'=>['es',],
'ayudar'=>['es',],
'az'=>['az','hu','tr',],
'azi'=>['ro',],
'azkar'=>['eu',],
'azkarra'=>['eu',],
'azken'=>['eu',],
'azok'=>['hu',],
'azokat'=>['hu',],
'azon'=>['hu',],
'azonnal'=>['hu',],
'azt'=>['hu',],
'aztán'=>['hu',],
'azután'=>['hu',],
'azzal'=>['hu',],
'azért'=>['hu',],
'azóta'=>['hu',],
'azından'=>['tr',],
'azərbaycan'=>['az',],
'azərbaycanın'=>['az',],
'azəri'=>['az',],
'aç'=>['tr',],
'açò'=>['ca',],
'açık'=>['tr',],
'aí'=>['gl','pt','pt_br',],
'aínda'=>['gl',],
'að'=>['is',],
'aðeins'=>['is',],
'aðra'=>['is',],
'aðrir'=>['is',],
'año'=>['es',],
'años'=>['es',],
'aò'=>['is',],
'aõ'=>['is',],
'aún'=>['es',],
'ačiū'=>['lt',],
'aş'=>['ro',],
'aşa'=>['ro',],
'aşağı'=>['tr',],
'aşk'=>['tr',],
'aşkına'=>['tr',],
'aşteaptă'=>['ro',],
'aştept'=>['ro',],
'aşık'=>['tr',],
'aš'=>['lt',],
'aţi'=>['ro',],
'ať'=>['cs',],
'aż'=>['pl',],
'až'=>['cs','sk',],
'b'=>['az','da','fr','id','is','nb','nl','no','pl','si','sq','sv','th','tr','zh_tw',],
'ba'=>['hu','nb','no','ro',],
'baan'=>['nl',],
'baas'=>['nl',],
'baba'=>['af','sq','tr',],
'babai'=>['sq',],
'babain'=>['sq',],
'babait'=>['sq',],
'babam'=>['tr',],
'babamın'=>['tr',],
'baban'=>['tr',],
'babar'=>['af',],
'babası'=>['tr',],
'babestea'=>['eu',],
'babi'=>['sq',],
'babies'=>['si',],
'baby'=>['af','da','de','en','nb','nl','no','si','sv','th',],
'back'=>['en','fa','si','th',],
'bad'=>['af','da','en','is','sv',],
'bada'=>['eu',],
'badabil'=>['eu',],
'badago'=>['eu',],
'badai'=>['id',],
'badaki'=>['eu',],
'badakit'=>['eu',],
'badakizu'=>['eu',],
'badaude'=>['eu',],
'badaukazue'=>['eu',],
'badela'=>['eu',],
'badidazu'=>['eu',],
'badu'=>['eu',],
'baduzu'=>['eu',],
'baduzue'=>['eu',],
'bag'=>['da','en','si',],
'bagaimana'=>['id','ms',],
'bagi'=>['id','ms',],
'bagian'=>['id','ms',],
'bagno'=>['it',],
'bagoaz'=>['eu',],
'bagus'=>['id','ms',],
'bahagia'=>['ms',],
'bahan'=>['id','ms',],
'bahasa'=>['id','ms',],
'bahawa'=>['ms',],
'bahaya'=>['ms',],
'bahkan'=>['id','ms',],
'bahsediyorsun'=>['tr',],
'bahwa'=>['id','ms',],
'bai'=>['eu',],
'baie'=>['af','ro',],
'baigta'=>['lt',],
'baigėsi'=>['lt',],
'baik'=>['id','lt','ms',],
'baiklah'=>['ms',],
'bail'=>['lv',],
'bailar'=>['es',],
'bailes'=>['lv',],
'baimenduta'=>['eu',],
'baina'=>['eu',],
'baino'=>['eu',],
'bainuen'=>['eu',],
'baiscopelk'=>['si',],
'baiser'=>['fr',],
'baitzara'=>['eu',],
'baix'=>['ca',],
'baixa'=>['gl',],
'baixo'=>['gl','pt','pt_br',],
'baj'=>['hu',],
'baja'=>['es',],
'bajingan'=>['ms',],
'bajo'=>['es',],
'bajod'=>['hu',],
'bak'=>['is','nb','no','tr',],
'baka'=>['is',],
'bakalım'=>['tr',],
'bakar'=>['id',],
'bakarra'=>['eu',],
'bakarrean'=>['eu',],
'bakarrik'=>['eu',],
'bakayım'=>['tr',],
'baker'=>['th',],
'bakker'=>['af',],
'bakma'=>['tr',],
'bakoitza'=>['eu',],
'bakom'=>['sv',],
'baksana'=>['tr',],
'bakteri'=>['id',],
'bakı'=>['az',],
'bakın'=>['tr',],
'bal'=>['nl',],
'balaca'=>['az',],
'bald'=>['de',],
'bale'=>['eu',],
'baleak'=>['eu',],
'balearen'=>['eu',],
'baliagarria'=>['eu',],
'balik'=>['id','ms',],
'baliteke'=>['eu',],
'ball'=>['en','si',],
'balle'=>['fr',],
'balon'=>['id',],
'bambina'=>['it',],
'bambini'=>['it',],
'bambino'=>['it',],
'ban'=>['hu',],
'bana'=>['tr',],
'banc'=>['ca',],
'banco'=>['es','gl','pt','pt_br',],
'band'=>['nl',],
'banda'=>['ca','gl',],
'bande'=>['af','fr',],
'bang'=>['af','id','nl',],
'bange'=>['da',],
'bangga'=>['ms',],
'bangsa'=>['id',],
'bangun'=>['id','ms',],
'bangunan'=>['id',],
'banheiro'=>['pt_br',],
'banho'=>['pt',],
'bani'=>['ro',],
'banii'=>['ro',],
'banishes'=>['af',],
'bank'=>['en','id','ms','nl',],
'bankas'=>['lv',],
'bankful'=>['af',],
'bantu'=>['ms',],
'bantuan'=>['ms',],
'banville'=>['si',],
'banyak'=>['id','ms',],
'bar'=>['bs','en','hr','sr',],
'bara'=>['is','sv',],
'barang'=>['id','ms',],
'barcelona'=>['gl',],
'barco'=>['es','gl','pt','pt_br',],
'bardhë'=>['sq',],
'bardziej'=>['pl',],
'bardzo'=>['pl',],
'bare'=>['da','nb','no',],
'barem'=>['hr',],
'barkamena'=>['eu',],
'barkatu'=>['eu',],
'barn'=>['da','is','nb','no','sv',],
'barna'=>['nb','no',],
'barnen'=>['sv',],
'barnet'=>['nb','no','sv',],
'barnið'=>['is',],
'barruan'=>['eu',],
'baru'=>['id','ms',],
'barátja'=>['hu',],
'barátok'=>['hu',],
'barátom'=>['hu',],
'bas'=>['fr',],
'base'=>['ca','gl','it','th',],
'bashku'=>['sq',],
'bashkë'=>['sq',],
'basies'=>['af',],
'basit'=>['tr',],
'bassza'=>['hu',],
'bast'=>['sq',],
'basta'=>['es','it','pt_br',],
'bastante'=>['es','gl','pt','pt_br',],
'bastard'=>['en',],
'bastardo'=>['it',],
'basura'=>['es',],
'baszd'=>['hu',],
'bat'=>['eu',],
'batailaren'=>['eu',],
'batas'=>['id',],
'batean'=>['eu',],
'bateau'=>['fr',],
'batek'=>['eu',],
'baten'=>['eu',],
'baterako'=>['eu',],
'batetik'=>['eu',],
'batez'=>['eu',],
'bati'=>['eu',],
'battre'=>['fr',],
'batu'=>['id','ms',],
'batuan'=>['id',],
'batzuetan'=>['eu',],
'batzuk'=>['eu',],
'bau'=>['ms',],
'bauval'=>['id',],
'bawa'=>['ms',],
'bawah'=>['id','ms',],
'bax'=>['az',],
'bay'=>['tr',],
'bayan'=>['tr',],
'bayangkan'=>['id',],
'bayanlar'=>['tr',],
'bayi'=>['ms',],
'baylar'=>['tr',],
'bayım'=>['tr',],
'bazaitu'=>['eu',],
'bazaizu'=>['eu',],
'bazara'=>['eu',],
'bazatoz'=>['eu',],
'bazekien'=>['eu',],
'bazen'=>['eu','tr',],
'bazoaz'=>['eu',],
'bazı'=>['tr',],
'bað'=>['is',],
'baño'=>['es',],
'bağlı'=>['az','tr',],
'baş'=>['az','tr',],
'başka'=>['tr',],
'başkan'=>['tr',],
'başladı'=>['tr',],
'başlayaraq'=>['az',],
'başqa'=>['az',],
'başına'=>['tr',],
'baš'=>['bs','hr',],
'baљ'=>['bs','hr','sr',],
'bc'=>['af',],
'be'=>['af','en','eu','fa','hu','it','lt','nb','no','si','sv','th','tr',],
'bea'=>['ro',],
'bear'=>['en',],
'beat'=>['en',],
'beau'=>['fr',],
'beaucoup'=>['fr',],
'beautful'=>['af',],
'beautiful'=>['en',],
'beauty'=>['si',],
'bebas'=>['id','ms',],
'bebek'=>['tr',],
'beber'=>['es','pt','pt_br',],
'beberapa'=>['id','ms',],
'bebeğim'=>['tr',],
'bebida'=>['pt','pt_br',],
'bebé'=>['es','pt',],
'bebê'=>['pt_br',],
'because'=>['en',],
'become'=>['en',],
'bed'=>['af','en','nl',],
'bedak'=>['sl',],
'bedankt'=>['nl',],
'bede'=>['da',],
'beder'=>['da',],
'bedeutet'=>['de',],
'bedoel'=>['af','nl',],
'bedoelt'=>['nl',],
'bedre'=>['da','nb','no',],
'bedst'=>['da',],
'bedste'=>['da',],
'beelde'=>['af',],
'been'=>['en','si','th',],
'beetje'=>['nl',],
'before'=>['en',],
'begaan'=>['af',],
'begge'=>['da','nb','no',],
'begiak'=>['eu',],
'begietan'=>['eu',],
'begin'=>['af','nl','si',],
'begini'=>['ms',],
'beginnen'=>['nl',],
'begint'=>['nl',],
'begira'=>['eu',],
'begiratu'=>['eu',],
'begirune'=>['eu',],
'begirunea'=>['eu',],
'begitu'=>['id','ms',],
'begon'=>['nl',],
'begonnen'=>['nl',],
'begrepen'=>['nl',],
'begrijp'=>['nl',],
'begrijpen'=>['nl',],
'begrijpt'=>['nl',],
'begynde'=>['da',],
'begynder'=>['da',],
'begyndte'=>['da',],
'begynne'=>['nb','no',],
'begynner'=>['nb','no',],
'begynte'=>['nb','no',],
'beh'=>['it',],
'behalve'=>['nl',],
'behalwe'=>['af',],
'behandel'=>['af',],
'behar'=>['eu',],
'beharko'=>['eu',],
'beharrak'=>['eu',],
'beharreko'=>['eu',],
'behian'=>['eu',],
'behin'=>['eu',],
'behind'=>['en',],
'behoort'=>['af',],
'behöva'=>['sv',],
'behövde'=>['sv',],
'behöver'=>['sv',],
'behövs'=>['sv',],
'behøver'=>['da','no',],
'bei'=>['de',],
'beide'=>['de',],
'beiden'=>['de',],
'beidz'=>['lv',],
'beidzies'=>['lv',],
'beidzot'=>['lv',],
'beigas'=>['lv',],
'beigās'=>['lv',],
'beim'=>['de',],
'being'=>['en',],
'beint'=>['is',],
'bej'=>['sq',],
'beje'=>['lt',],
'bejt'=>['cs',],
'bekend'=>['nl',],
'bekende'=>['af',],
'bekerja'=>['id','ms',],
'beklagar'=>['sv',],
'beklager'=>['da','nb','no',],
'bekle'=>['tr',],
'bekleyin'=>['tr',],
'bekliyor'=>['tr',],
'bekommen'=>['de',],
'beku'=>['id',],
'bekymret'=>['da','nb','no',],
'bel'=>['it','nl',],
'bela'=>['pt','pt_br',],
'belajar'=>['id','ms',],
'belakang'=>['id','ms',],
'belanda'=>['id',],
'belangrijk'=>['nl',],
'belaunaldi'=>['eu',],
'beldurra'=>['eu',],
'bele'=>['hu',],
'belediging'=>['af',],
'beledigings'=>['af',],
'believe'=>['en',],
'belki'=>['tr',],
'bella'=>['ca','it','la',],
'belle'=>['fr',],
'bellen'=>['nl',],
'belli'=>['la','tr',],
'bellini'=>['hi',],
'bello'=>['it','la',],
'bellum'=>['la',],
'belo'=>['pt',],
'beloof'=>['nl',],
'beloved'=>['si',],
'belowe'=>['af',],
'beltza'=>['eu',],
'belum'=>['id','ms',],
'belül'=>['hu',],
'belőle'=>['hu',],
'belə'=>['az',],
'bem'=>['pt','pt_br',],
'ben'=>['bs','ca','da','et','fr','gl','hu','is','it','ms','nb','nl','no','ro','sk','sq','sv','tr',],
'benai'=>['lt',],
'benar'=>['id','ms',],
'benarkah'=>['ms',],
'bencana'=>['id',],
'bence'=>['tr',],
'benci'=>['ms',],
'benda'=>['id','ms',],
'bende'=>['tr',],
'benden'=>['tr',],
'bene'=>['it','la',],
'beneden'=>['nl',],
'beneficium'=>['la',],
'benetan'=>['eu',],
'beni'=>['tr',],
'benim'=>['tr',],
'benimle'=>['tr',],
'benissimo'=>['it',],
'benne'=>['hu',],
'benned'=>['hu',],
'bennem'=>['hu',],
'beno'=>['eu',],
'benoudhede'=>['af',],
'benoudheid'=>['af',],
'bent'=>['hu','lt','nl',],
'bentuk'=>['id','ms',],
'benua'=>['id',],
'benziyor'=>['tr',],
'beowulf'=>['ca',],
'ber'=>['is','nb','no','sv',],
'bera'=>['eu','is',],
'beraber'=>['tr',],
'berada'=>['id','ms',],
'berak'=>['eu',],
'berakhir'=>['id','ms',],
'berandu'=>['eu',],
'beranduago'=>['eu',],
'berani'=>['ms',],
'berapa'=>['id','ms',],
'berapi'=>['id',],
'berarekin'=>['eu',],
'berarengandik'=>['eu',],
'berarentzat'=>['eu',],
'berarti'=>['id','ms',],
'berasal'=>['id','ms',],
'berat'=>['id','ms',],
'beraz'=>['eu',],
'berbagai'=>['id',],
'berbahaya'=>['id','ms',],
'berbasis'=>['id',],
'berbat'=>['tr',],
'berbatu'=>['id',],
'berbeda'=>['id','ms',],
'berbicara'=>['id','ms',],
'berbohong'=>['ms',],
'bercanda'=>['ms',],
'berdasarkan'=>['id',],
'berdin'=>['eu',],
'berdina'=>['eu',],
'berdiri'=>['id','ms',],
'berdua'=>['ms',],
'bere'=>['eu','it','sq',],
'bereit'=>['de',],
'bereits'=>['de',],
'berevolusi'=>['id',],
'berezia'=>['eu',],
'bergabung'=>['ms',],
'bergerak'=>['id','ms',],
'berharap'=>['id','ms',],
'berharga'=>['id',],
'berhasil'=>['id','ms',],
'berhenti'=>['id','ms',],
'berhubungan'=>['id',],
'beri'=>['ms','tr',],
'berikan'=>['ms',],
'berikutnya'=>['id','ms',],
'berinteraksi'=>['id',],
'berisi'=>['id',],
'berita'=>['id','ms',],
'beritahu'=>['ms',],
'berjalan'=>['id','ms',],
'berjanji'=>['ms',],
'berjast'=>['is',],
'berkata'=>['id','ms',],
'berkembang'=>['id',],
'berlaku'=>['id',],
'berlangsung'=>['id',],
'bermain'=>['id','ms',],
'bermaksud'=>['ms',],
'bernama'=>['ms',],
'berniukai'=>['lt',],
'berniukas'=>['lt',],
'bero'=>['eu',],
'berpikir'=>['id','ms',],
'berputar'=>['id',],
'berri'=>['eu',],
'berria'=>['eu',],
'berriak'=>['eu',],
'berriaren'=>['eu',],
'berriena'=>['eu',],
'berriro'=>['eu',],
'bersalah'=>['ms',],
'bersama'=>['id','ms',],
'bersih'=>['id','ms',],
'bersumpah'=>['ms',],
'bertahan'=>['id','ms',],
'bertan'=>['eu',],
'bertanggung'=>['id',],
'bertanya'=>['id','ms',],
'bertemu'=>['id','ms',],
'berteriak'=>['ms',],
'berubah'=>['id','ms',],
'beruntung'=>['id','ms',],
'berusaha'=>['id','ms',],
'berätta'=>['sv',],
'berättade'=>['sv',],
'berättar'=>['sv',],
'berättat'=>['sv',],
'besar'=>['id','ms',],
'beschermen'=>['nl',],
'besede'=>['sl',],
'besi'=>['id',],
'besides'=>['en',],
'besig'=>['af',],
'besim'=>['sq',],
'besked'=>['da',],
'beskerm'=>['af',],
'beskjed'=>['nb','no',],
'beskytte'=>['da','nb','no',],
'beslissing'=>['af',],
'besluit'=>['af',],
'beso'=>['sq',],
'besoin'=>['fr',],
'besoj'=>['sq',],
'besok'=>['ms',],
'beson'=>['sq',],
'besonders'=>['de',],
'besser'=>['de',],
'best'=>['en','is','nb','nl','no',],
'besta'=>['is',],
'bestaan'=>['af',],
'bestaat'=>['nl',],
'beste'=>['de','eu','nb','nl','no',],
'bestemt'=>['da',],
'besten'=>['de',],
'besti'=>['is',],
'bestimmt'=>['de',],
'bestu'=>['is',],
'beszél'=>['hu',],
'beszélek'=>['hu',],
'beszélj'=>['hu',],
'beszélni'=>['hu',],
'beszélsz'=>['hu',],
'beszélt'=>['hu',],
'beszéltem'=>['hu',],
'bet'=>['en','lt','lv',],
'betaal'=>['af',],
'betaald'=>['nl',],
'betala'=>['sv',],
'betalar'=>['sv',],
'betale'=>['da','nb','no',],
'betalen'=>['nl',],
'betaler'=>['da','nb','no',],
'betapa'=>['ms',],
'beteg'=>['hu',],
'beteken'=>['af',],
'betekent'=>['nl',],
'beter'=>['af','nl',],
'beteta'=>['eu',],
'beti'=>['eu',],
'betiko'=>['eu',],
'betjent'=>['da',],
'betohem'=>['sq',],
'betra'=>['is',],
'betref'=>['af',],
'betri'=>['is',],
'bett'=>['de',],
'better'=>['en','th',],
'betul'=>['ms',],
'betur'=>['is',],
'between'=>['en',],
'betyder'=>['da','sv',],
'betyr'=>['nb','no',],
'beure'=>['ca',],
'beveel'=>['af',],
'beveik'=>['lt',],
'bevis'=>['sv',],
'bevor'=>['de',],
'bevrees'=>['af',],
'beweeg'=>['af',],
'bewegung'=>['de',],
'bewerig'=>['af',],
'bewijs'=>['nl',],
'bewijzen'=>['nl',],
'bewus'=>['af',],
'bewys'=>['af',],
'beyaz'=>['tr',],
'beyler'=>['tr',],
'bez'=>['bs','cs','hr','lv','pl','sk','sr',],
'bezahlen'=>['de',],
'bezahlt'=>['de',],
'bezala'=>['eu',],
'bezig'=>['nl',],
'beðið'=>['is',],
'beş'=>['tr',],
'bež'=>['sk',],
'beћi'=>['sr',],
'beรฏndruk'=>['af',],
'bhakta'=>['af',],
'bharat'=>['af',],
'bi'=>['bs','hr','sl','sr','tr',],
'biar'=>['ms',],
'biarkan'=>['ms',],
'biasa'=>['id','ms',],
'biasanya'=>['id','ms',],
'biaya'=>['id',],
'bicara'=>['ms',],
'bicarakan'=>['ms',],
'bid'=>['af',],
'bidali'=>['eu',],
'bidang'=>['id',],
'bide'=>['eu',],
'bidean'=>['eu',],
'bie'=>['sq',],
'bieason'=>['hi',],
'bien'=>['es','fr',],
'bientôt'=>['fr',],
'bienvenue'=>['fr',],
'bier'=>['de',],
'biers'=>['hi',],
'bietjie'=>['af',],
'bieži'=>['lv',],
'big'=>['en','id','th',],
'bigarren'=>['eu',],
'bih'=>['bs','hr','sr',],
'bihurtu'=>['eu',],
'bij'=>['nl',],
'bija'=>['lv',],
'bijau'=>['lt',],
'biji'=>['lv',],
'bijis'=>['lv',],
'bijna'=>['nl',],
'biju'=>['lv',],
'bijusi'=>['lv',],
'bijām'=>['lv',],
'bijāt'=>['lv',],
'bikia'=>['eu',],
'bikoteetan'=>['eu',],
'bil'=>['da','nb','no','sl','sv',],
'bila'=>['bs','eu','hr','ms','sl','sr',],
'bilakatu'=>['eu',],
'bilang'=>['ms',],
'bild'=>['de',],
'bilde'=>['nb',],
'bildurik'=>['eu',],
'bile'=>['bs','hr','sl','sr','tr',],
'bilemiyorum'=>['tr',],
'bilen'=>['da','nb','no','sv',],
'bilgi'=>['tr',],
'bili'=>['bs','hr','sl','sr',],
'bilir'=>['tr',],
'bilirsin'=>['tr',],
'biliyor'=>['tr',],
'biliyordum'=>['tr',],
'biliyorsun'=>['tr',],
'biliyorum'=>['tr',],
'biliyoruz'=>['tr',],
'bill'=>['ca','da','en','nb',],
'billede'=>['da',],
'billeder'=>['da',],
'billie'=>['hi',],
'billions'=>['th',],
'bilmek'=>['tr',],
'bilmem'=>['tr',],
'bilmiyor'=>['tr',],
'bilmiyordum'=>['tr',],
'bilmiyorum'=>['tr',],
'bilo'=>['bs','hr','sl','sr',],
'bilzu'=>['hi',],
'bilər'=>['az',],
'bin'=>['de','tr',],
'binatang'=>['id','ms',],
'bind'=>['af',],
'bine'=>['ro',],
'bineînţeles'=>['ro',],
'binnen'=>['nl',],
'bintang'=>['id','ms',],
'bio'=>['bs','hr','sr',],
'bir'=>['az','sq','tr',],
'bira'=>['eu',],
'birarazi'=>['eu',],
'biraz'=>['tr',],
'bird'=>['th',],
'birden'=>['tr',],
'biri'=>['az','tr',],
'biribilduko'=>['eu',],
'birine'=>['tr',],
'birini'=>['tr',],
'birinin'=>['tr',],
'birisi'=>['tr',],
'biriyle'=>['tr',],
'birkaç'=>['tr',],
'birlikte'=>['tr',],
'birnes'=>['id',],
'birou'=>['ro',],
'biroul'=>['ro',],
'birthday'=>['en','si',],
'biru'=>['id',],
'birçok'=>['tr',],
'birşey'=>['tr',],
'birşeyler'=>['tr',],
'bis'=>['de',],
'bisa'=>['id','ms',],
'bisakah'=>['ms',],
'bismo'=>['bs','hr','sr',],
'bisnis'=>['id','ms',],
'bisogna'=>['it',],
'bisogno'=>['it',],
'bisschen'=>['de',],
'bist'=>['de',],
'biste'=>['bs','hr','sr',],
'bit'=>['bs','en','hi','hr',],
'bitartean'=>['eu',],
'bitch'=>['en',],
'biti'=>['bs','hr','sl','sr',],
'bitte'=>['de',],
'bitten'=>['de',],
'bitti'=>['tr',],
'biz'=>['az','tr',],
'bizarre'=>['fr',],
'bizden'=>['tr',],
'bize'=>['tr',],
'bizi'=>['eu','tr',],
'bizim'=>['az','tr',],
'bizimle'=>['tr',],
'bizitza'=>['eu',],
'bizitzera'=>['eu',],
'bizkarrean'=>['eu',],
'bizony'=>['hu',],
'bizonyos'=>['hu',],
'biztos'=>['hu',],
'biztosan'=>['hu',],
'bið'=>['is',],
'biðja'=>['is',],
'bičiuli'=>['lt',],
'biжe'=>['sr',],
'biжu'=>['sr',],
'bjarga'=>['is',],
'bjóða'=>['is',],
'black'=>['en',],
'blackmail'=>['si',],
'blah'=>['af',],
'blakus'=>['lv',],
'blanc'=>['fr',],
'blanco'=>['es',],
'ble'=>['nb','no',],
'bleib'=>['de',],
'bleiben'=>['de',],
'bleibt'=>['de',],
'bless'=>['is',],
'blev'=>['da','no','sv',],
'blevet'=>['da',],
'bli'=>['nb','no','sv',],
'blij'=>['nl',],
'blijf'=>['nl',],
'blijft'=>['nl',],
'blijven'=>['nl',],
'blind'=>['af',],
'blir'=>['nb','no','sv',],
'blisko'=>['pl',],
'blitt'=>['nb','no',],
'bliv'=>['da',],
'blive'=>['da','no',],
'bliver'=>['da','no',],
'blivit'=>['sv',],
'blizu'=>['bs','hr','sl','sr',],
'blod'=>['da','nb','no','sv',],
'bloed'=>['af','nl',],
'bloga'=>['lt',],
'blogai'=>['lt',],
'blogas'=>['lt',],
'blogspot'=>['ms','si','ur',],
'blokeatuta'=>['eu',],
'blom'=>['af',],
'blomme'=>['af',],
'blood'=>['en','th',],
'bloodthirsty'=>['hi',],
'bloody'=>['en','th',],
'blot'=>['da',],
'blou'=>['af',],
'blow'=>['en','th',],
'bloß'=>['de',],
'blue'=>['en',],
'blues'=>['af',],
'blut'=>['de',],
'bly'=>['af',],
'blyk'=>['af',],
'blymoedige'=>['af',],
'blázen'=>['cs',],
'blázon'=>['sk',],
'blå'=>['da',],
'blízko'=>['cs','sk',],
'bng'=>['gl',],
'bnl'=>['th',],
'bo'=>['ca','da','gl','nb','no','pl','sl','sv',],
'boa'=>['gl','pt','pt_br',],
'boas'=>['pt','pt_br',],
'boat'=>['en',],
'bob'=>['da','en','fr','hu','is','nb','nl','ro','sk','sl','sq','sv','tr',],
'bobi'=>['lt','sq',],
'bobij'=>['lv',],
'boca'=>['ca','es','gl','pt','pt_br',],
'bocado'=>['pt',],
'bocca'=>['it',],
'bocs'=>['hu',],
'bocsánat'=>['hu',],
'boden'=>['de',],
'bodi'=>['sl',],
'bodo'=>['sl',],
'bodoh'=>['ms',],
'body'=>['en',],
'boek'=>['nl',],
'bog'=>['bs','da','hr','sl','sr',],
'boga'=>['bs','hr','pl','sr',],
'bogu'=>['bs','hr','sl','sr',],
'boh'=>['sk',],
'boha'=>['sk',],
'bohu'=>['cs',],
'boig'=>['ca',],
'boire'=>['fr',],
'bois'=>['fr',],
'bojim'=>['bs','hr','sl','sr',],
'bojovat'=>['cs',],
'bojovať'=>['sk',],
'bojā'=>['lv',],
'boję'=>['pl',],
'bok'=>['hr','sv','tr',],
'bol'=>['sk',],
'bola'=>['id','ms','pt','pt_br','sk',],
'boldog'=>['hu',],
'boleh'=>['ms',],
'boli'=>['bs','hr','pl','sk','sl','sr',],
'bolj'=>['sl',],
'bolje'=>['bs','hr','sl','sr',],
'bolji'=>['bs','hr','sr',],
'boljše'=>['sl',],
'bolo'=>['sk',],
'bolond'=>['hu',],
'bolí'=>['cs',],
'bom'=>['ms','pt','pt_br','sl',],
'bomo'=>['sl',],
'bon'=>['ca','fr',],
'bona'=>['ca','la',],
'bondgenote'=>['af',],
'bones'=>['ca',],
'boni'=>['la',],
'bonic'=>['ca',],
'bonica'=>['ca',],
'bonis'=>['la',],
'bonita'=>['es','pt','pt_br',],
'bonito'=>['es','pt','pt_br',],
'bonjour'=>['fr',],
'bonne'=>['fr',],
'bono'=>['la',],
'bonorum'=>['la',],
'bons'=>['ca','fr','pt','pt_br',],
'bonsoir'=>['fr',],
'bonum'=>['la',],
'boo'=>['af',],
'boog'=>['af',],
'book'=>['en','th',],
'books'=>['th',],
'boom'=>['af',],
'boon'=>['af',],
'boos'=>['nl',],
'booshede'=>['af',],
'boot'=>['de','nl',],
'bop'=>['th',],
'bor'=>['da','nb','no','sv',],
'bord'=>['da','fr','nb','no',],
'borde'=>['sv',],
'bordel'=>['fr',],
'borga'=>['is',],
'born'=>['en',],
'borrokarako'=>['eu',],
'borrokatarako'=>['eu',],
'borste'=>['af',],
'bort'=>['nb','no','sv',],
'borta'=>['sv',],
'borte'=>['nb','no',],
'borð'=>['is',],
'borða'=>['is',],
'bos'=>['af','gl','ms',],
'bose'=>['af',],
'boss'=>['de','en','et','lv','si',],
'bost'=>['eu',],
'bosta'=>['sl',],
'boste'=>['sl',],
'bota'=>['eu','sq',],
'boterea'=>['eu',],
'both'=>['en',],
'botter'=>['af',],
'botë'=>['sq',],
'botën'=>['sq',],
'botës'=>['sq',],
'bou'=>['af',],
'bouche'=>['fr',],
'bouge'=>['fr',],
'bought'=>['en',],
'boulot'=>['fr',],
'bound'=>['si',],
'bout'=>['fr',],
'bova'=>['sl',],
'boven'=>['nl',],
'box'=>['en',],
'boy'=>['en','si','th',],
'boys'=>['en',],
'boyunca'=>['tr',],
'boş'=>['tr',],
'boš'=>['sl',],
'boże'=>['pl',],
'bože'=>['bs','cs','hr','sk',],
'božiæe'=>['hi',],
'božič'=>['sl',],
'boћe'=>['bs','hr','sr',],
'bra'=>['nb','no','sv',],
'bracie'=>['pl',],
'brain'=>['th',],
'brains'=>['si',],
'branco'=>['gl','pt','pt_br',],
'brand'=>['af',],
'brandende'=>['af',],
'brandstapel'=>['af',],
'brangioji'=>['lt',],
'brangusis'=>['lt',],
'bras'=>['fr',],
'brat'=>['bs','hr','pl','sk','sl','sr',],
'brata'=>['bs','hr','pl','sl','sr',],
'brate'=>['bs','hr','sr',],
'bratr'=>['cs',],
'brauc'=>['lv',],
'braucam'=>['lv',],
'brauche'=>['de',],
'brauchen'=>['de',],
'brauchst'=>['de',],
'braucht'=>['de',],
'braukt'=>['lv',],
'brava'=>['it',],
'bravo'=>['fr','it','ro','si',],
'break'=>['en',],
'breathe'=>['si',],
'breek'=>['af',],
'brenda'=>['sq',],
'breng'=>['nl',],
'brengen'=>['nl',],
'brengsek'=>['ms',],
'brengt'=>['nl',],
'breve'=>['pt',],
'breyta'=>['is',],
'brez'=>['sl',],
'brief'=>['nl',],
'briga'=>['bs','hr','sl','sr',],
'brincando'=>['pt_br',],
'brincar'=>['pt',],
'bring'=>['de','en',],
'bringe'=>['de',],
'bringen'=>['de',],
'bringt'=>['de',],
'brini'=>['bs','hr','sr',],
'brinuti'=>['hr',],
'broadway'=>['ca',],
'brod'=>['bs','hr','sr',],
'broer'=>['af','nl',],
'broers'=>['af',],
'broj'=>['bs','hr','sr',],
'broke'=>['en',],
'broken'=>['en',],
'brolis'=>['lt',],
'broma'=>['ca',],
'broni'=>['pl',],
'brood'=>['af',],
'bror'=>['da','nb','no','sv',],
'broren'=>['nb','no',],
'brother'=>['en',],
'brought'=>['en',],
'broń'=>['pl',],
'bruder'=>['de',],
'brug'=>['af','da','no',],
'bruge'=>['da',],
'bruger'=>['da',],
'brugt'=>['da',],
'brugte'=>['da',],
'bruk'=>['nb','no',],
'brukade'=>['sv',],
'brukar'=>['sv',],
'bruke'=>['nb','no',],
'bruker'=>['nb','no',],
'brukt'=>['nb',],
'brukte'=>['nb','no',],
'brutto'=>['it',],
'bryr'=>['nb','no','sv',],
'brzmi'=>['pl',],
'brzo'=>['bs','hr','sr',],
'brzy'=>['cs',],
'brënda'=>['sq',],
'bróðir'=>['is',],
'bróður'=>['is',],
'brāli'=>['lv',],
'brālis'=>['lv',],
'brīdi'=>['lv',],
'brīnišķīgi'=>['lv',],
'brže'=>['hr',],
'brћe'=>['sr',],
'bu'=>['az','ms','tr',],
'buat'=>['ms',],
'buatan'=>['id',],
'bubbak'=>['eu',],
'buch'=>['de',],
'bucks'=>['si',],
'bucur'=>['ro',],
'bud'=>['ca',],
'budalla'=>['sq',],
'budaya'=>['id',],
'buddy'=>['en',],
'bude'=>['bs','cs','hr','sk','sr',],
'budem'=>['bs','hr','sk','sr',],
'budeme'=>['cs','sk',],
'budemo'=>['bs','sr',],
'budete'=>['cs','sk',],
'budeš'=>['bs','cs','hr','sk',],
'budeљ'=>['sr',],
'budi'=>['bs','hr','sr',],
'budou'=>['cs',],
'budu'=>['bs','cs','sr',],
'budú'=>['sk',],
'buen'=>['es',],
'buena'=>['es',],
'buenas'=>['es',],
'bueno'=>['es',],
'buenos'=>['es',],
'bugün'=>['tr',],
'building'=>['en',],
'buite'=>['af',],
'buiten'=>['nl',],
'buka'=>['ms',],
'bukan'=>['id','ms',],
'bukankah'=>['ms',],
'bukanlah'=>['ms',],
'bukatu'=>['eu',],
'bukatzeko'=>['eu',],
'bukti'=>['id','ms',],
'buku'=>['id','ms',],
'bukur'=>['sq',],
'bukura'=>['sq',],
'bulan'=>['id','ms',],
'bularrak'=>['eu',],
'buldum'=>['tr',],
'buldun'=>['tr',],
'bulmak'=>['tr',],
'bultzatuz'=>['eu',],
'bulu'=>['id',],
'bumi'=>['id','ms',],
'bumper'=>['si',],
'bun'=>['ro',],
'buna'=>['ro','tr',],
'bundan'=>['tr',],
'bune'=>['ro',],
'bung'=>['ms',],
'bunga'=>['id','ms',],
'buni'=>['ro',],
'bunlar'=>['tr',],
'bunları'=>['tr',],
'bunların'=>['tr',],
'bunu'=>['tr',],
'bunuh'=>['ms',],
'bunun'=>['tr',],
'bununla'=>['tr',],
'bună'=>['ro',],
'buon'=>['it',],
'buona'=>['it',],
'buonanotte'=>['it',],
'buongiorno'=>['it',],
'buono'=>['it',],
'burada'=>['tr',],
'buradaki'=>['tr',],
'buradan'=>['tr',],
'buradayım'=>['tr',],
'burası'=>['tr',],
'buraya'=>['tr',],
'burayı'=>['tr',],
'burda'=>['tr',],
'burde'=>['da','nb','no',],
'bureau'=>['fr',],
'burg'=>['sq',],
'burman'=>['si',],
'burri'=>['sq',],
'burrë'=>['sq',],
'burt'=>['is',],
'burtu'=>['is',],
'burua'=>['eu',],
'buruan'=>['eu',],
'buruk'=>['id','ms',],
'burung'=>['id','ms',],
'buruz'=>['eu',],
'buruzagi'=>['eu',],
'buruzagia'=>['eu',],
'buruzagiak'=>['eu',],
'buruzko'=>['eu',],
'bus'=>['lt',],
'busca'=>['es','gl',],
'buscando'=>['es',],
'buscant'=>['ca',],
'buscar'=>['ca','es','gl','pt','pt_br',],
'busean'=>['eu',],
'busez'=>['eu',],
'business'=>['en',],
'busy'=>['en',],
'but'=>['en','fa','fr','th',],
'buti'=>['lt',],
'butter'=>['si',],
'button'=>['th',],
'butuh'=>['ms',],
'butuhkan'=>['ms',],
'buurt'=>['nl',],
'buvai'=>['lt',],
'buvau'=>['lt',],
'buvo'=>['lt',],
'buvome'=>['lt',],
'buy'=>['en','th',],
'buď'=>['cs','sk',],
'by'=>['af','cs','da','en','ms','nb','no','pl','si','sk','th',],
'bybel'=>['af',],
'bych'=>['cs',],
'bychom'=>['cs',],
'bye'=>['en','ms','si',],
'byen'=>['da','nb','no',],
'byl'=>['cs',],
'byla'=>['cs',],
'byli'=>['cs','pl',],
'byliśmy'=>['pl',],
'bylo'=>['cs',],
'byly'=>['cs',],
'bym'=>['pl',],
'byrja'=>['is',],
'bys'=>['cs',],
'byssu'=>['is',],
'byssuna'=>['is',],
'byste'=>['cs',],
'byt'=>['sk',],
'być'=>['pl',],
'był'=>['pl',],
'była'=>['pl',],
'byłam'=>['pl',],
'byłaś'=>['pl',],
'byłem'=>['pl',],
'byłeś'=>['pl',],
'było'=>['pl',],
'byłoby'=>['pl',],
'były'=>['pl',],
'byś'=>['pl',],
'byť'=>['sk',],
'bár'=>['hu',],
'bárcsak'=>['hu',],
'bárki'=>['hu',],
'bármi'=>['hu',],
'bármit'=>['hu',],
'bär'=>['sv',],
'bäst'=>['sv',],
'bästa'=>['sv',],
'bättre'=>['sv',],
'båda'=>['sv',],
'båten'=>['nb',],
'bænum'=>['is',],
'bæði'=>['is',],
'bé'=>['ca',],
'bébi'=>['hu',],
'bébé'=>['fr',],
'békén'=>['hu',],
'bë'=>['sq',],
'bëhem'=>['sq',],
'bëhesh'=>['sq',],
'bëhet'=>['sq',],
'bëj'=>['sq',],
'bëja'=>['sq',],
'bëje'=>['sq',],
'bëjmë'=>['sq',],
'bëjnë'=>['sq',],
'bëjë'=>['sq',],
'bën'=>['sq',],
'bëni'=>['sq',],
'bënte'=>['sq',],
'bënë'=>['sq',],
'bëra'=>['sq',],
'bëre'=>['sq',],
'bëri'=>['sq',],
'bërë'=>['sq',],
'bësh'=>['sq',],
'bíddu'=>['is',],
'bíl'=>['is',],
'bílinn'=>['is',],
'bílnum'=>['is',],
'bíða'=>['is',],
'bíðið'=>['is',],
'bíður'=>['is',],
'bóg'=>['pl',],
'bör'=>['sv',],
'börja'=>['sv',],
'började'=>['sv',],
'början'=>['sv',],
'börjar'=>['sv',],
'börn'=>['is',],
'börnin'=>['is',],
'böse'=>['de',],
'böyle'=>['tr',],
'böylece'=>['tr',],
'böyük'=>['az',],
'bør'=>['da','nb','no',],
'børn'=>['da',],
'børnene'=>['da',],
'búa'=>['is',],
'búin'=>['is',],
'búinn'=>['is',],
'búið'=>['is',],
'büro'=>['de',],
'bütün'=>['az','tr',],
'büyük'=>['tr',],
'býr'=>['is',],
'být'=>['cs',],
'băiat'=>['ro',],
'băiatul'=>['ro',],
'băiete'=>['ro',],
'băieţi'=>['ro',],
'băieţii'=>['ro',],
'bărbat'=>['ro',],
'băut'=>['ro',],
'bądź'=>['pl',],
'bērni'=>['lv',],
'bērniem'=>['lv',],
'bērns'=>['lv',],
'bērnu'=>['lv',],
'bērnus'=>['lv',],
'bėk'=>['lt',],
'będzie'=>['pl',],
'będziecie'=>['pl',],
'będziemy'=>['pl',],
'będziesz'=>['pl',],
'będą'=>['pl',],
'będę'=>['pl',],
'během'=>['cs',],
'běž'=>['cs',],
'běžte'=>['cs',],
'bīstami'=>['lv',],
'bırak'=>['tr',],
'bırakın'=>['tr',],
'būdas'=>['lt',],
'būdu'=>['lt',],
'būk'=>['lt',],
'būna'=>['lt',],
'būs'=>['lv',],
'būsi'=>['lt','lv',],
'būsim'=>['lv',],
'būsiu'=>['lt',],
'būt'=>['lt','lv',],
'būtent'=>['lt',],
'būti'=>['lt',],
'būtu'=>['lv',],
'būtum'=>['lt',],
'būtų'=>['lt',],
'būčiau'=>['lt',],
'būšu'=>['lv',],
'bůh'=>['cs',],
'bəy'=>['az',],
'c'=>['az','en','fr','it','ro','si','th',],
'ca'=>['fr','gl','ro','sq',],
'caballeros'=>['es',],
'caballo'=>['es',],
'cabelo'=>['pt','pt_br',],
'cabeza'=>['es','gl',],
'cabeça'=>['pt','pt_br',],
'cabo'=>['gl','pt',],
'cachorro'=>['pt_br',],
'cada'=>['ca','es','gl','pt','pt_br',],
'cadangan'=>['id',],
'cadeau'=>['fr',],
'cadra'=>['gl',],
'caeli'=>['la',],
'caelo'=>['la',],
'caelum'=>['la',],
'caesar'=>['la',],
'caesarem'=>['la',],
'caesaris'=>['la',],
'cafea'=>['ro',],
'caffè'=>['it',],
'cafè'=>['ca',],
'café'=>['es','fr','gl','pt','pt_br',],
'cahaya'=>['id','ms',],
'cair'=>['id','pt','pt_br',],
'cairan'=>['id',],
'caixa'=>['gl','pt','pt_br',],
'caja'=>['es',],
'cal'=>['ca','gl',],
'cale'=>['ro',],
'calidade'=>['gl',],
'call'=>['en','si','th',],
'calla'=>['ca',],
'calle'=>['es',],
'called'=>['en','th',],
'calling'=>['en',],
'calm'=>['en',],
'calma'=>['ca','es','it','pt','pt_br',],
'calme'=>['fr',],
'calquera'=>['gl',],
'cam'=>['ro',],
'cama'=>['es','gl','pt','pt_br',],
'cambiar'=>['es',],
'cambiare'=>['it',],
'cambiato'=>['it',],
'cambio'=>['es','gl',],
'came'=>['en','th',],
'camera'=>['it','nl','ro',],
'cameră'=>['ro',],
'caminho'=>['pt','pt_br',],
'camino'=>['es',],
'camiño'=>['gl',],
'camp'=>['ca','fr',],
'campaña'=>['gl',],
'campo'=>['es','gl','it','pt','pt_br',],
'camí'=>['ca',],
'can'=>['en','fa','si','th',],
'canción'=>['es',],
'cand'=>['ro',],
'cando'=>['gl',],
'cane'=>['it',],
'canggih'=>['id',],
'canlı'=>['tr',],
'cannot'=>['en',],
'cantidade'=>['gl',],
'cantik'=>['ms',],
'canto'=>['gl',],
'canvi'=>['ca',],
'canviar'=>['ca',],
'canım'=>['tr',],
'canına'=>['tr',],
'cap'=>['ca','ro',],
'capacidade'=>['gl',],
'capaz'=>['gl','pt',],
'capaç'=>['ca',],
'capelli'=>['it',],
'capire'=>['it',],
'capisci'=>['it',],
'capisco'=>['it',],
'capitaine'=>['fr',],
'capital'=>['gl',],
'capitano'=>['it',],
'capite'=>['la',],
'capito'=>['it',],
'capità'=>['ca',],
'capitán'=>['es',],
'capitão'=>['pt','pt_br',],
'capo'=>['it',],
'captain'=>['de','en','th',],
'capul'=>['ro',],
'caput'=>['la',],
'car'=>['en','fr','si',],
'cara'=>['ca','es','gl','id','it','ms','pt','pt_br',],
'características'=>['gl',],
'carajo'=>['es',],
'caras'=>['pt_br',],
'card'=>['si',],
'cards'=>['si',],
'care'=>['en','ro','si',],
'careful'=>['en',],
'cari'=>['ms',],
'carino'=>['it',],
'cariño'=>['es',],
'carlisle'=>['hi',],
'carlos'=>['ca','gl',],
'carne'=>['es','gl','pt','pt_br',],
'caro'=>['it',],
'carrer'=>['ca',],
'carrera'=>['es',],
'carro'=>['pt','pt_br',],
'carry'=>['en','si',],
'carta'=>['ca','es','gl','pt','pt_br',],
'carte'=>['fr','ro',],
'cartea'=>['ro',],
'cartos'=>['gl',],
'carácter'=>['gl',],
'cas'=>['ca','fr',],
'casa'=>['ca','es','gl','it','pt','pt_br','ro',],
'casamento'=>['pt','pt_br',],
'casar'=>['pt','pt_br',],
'casas'=>['gl',],
'case'=>['en','gl',],
'cash'=>['si',],
'casi'=>['es',],
'caso'=>['es','gl','it','pt','pt_br',],
'casos'=>['gl',],
'castra'=>['la',],
'castris'=>['la',],
'castro'=>['gl',],
'casă'=>['ro',],
'cat'=>['ro',],
'catatan'=>['id','ms',],
'catch'=>['en',],
'catro'=>['gl',],
'caught'=>['en',],
'caur'=>['lv',],
'caure'=>['ca',],
'cauri'=>['lv',],
'causa'=>['ca','gl','it','la','pt','pt_br',],
'causae'=>['la',],
'causam'=>['la',],
'causas'=>['la',],
'cause'=>['en','fr','th',],
'causis'=>['la',],
'caut'=>['ro',],
'caută'=>['ro',],
'cauza'=>['ro',],
'cauţi'=>['ro',],
'cavab'=>['az',],
'cavablar'=>['az',],
'cavall'=>['ca',],
'cavallo'=>['it',],
'cavalo'=>['pt','pt_br',],
'cavolo'=>['it',],
'caz'=>['ro',],
'cazul'=>['ro',],
'cazzo'=>['it',],
'cała'=>['pl',],
'całe'=>['pl',],
'całkiem'=>['pl',],
'całkowicie'=>['pl',],
'cały'=>['pl',],
'całym'=>['pl',],
'całą'=>['pl',],
'cc'=>['ur',],
'cdo'=>['sq',],
'ce'=>['bs','fr','hr','it','ro','sr',],
'cea'=>['ro',],
'cealaltă'=>['ro',],
'ceci'=>['fr',],
'cecily'=>['ca',],
'cedo'=>['pt','pt_br',],
'ceea'=>['ro',],
'cehenneme'=>['tr',],
'cei'=>['ro',],
'ceilalţi'=>['ro',],
'cel'=>['ca','ro','sl',],
'cela'=>['fr',],
'cele'=>['ro',],
'celies'=>['lv',],
'celkom'=>['sk',],
'celle'=>['fr',],
'celo'=>['sl',],
'celor'=>['ro',],
'celou'=>['cs',],
'celu'=>['sr',],
'celui'=>['fr',],
'celá'=>['cs','sk',],
'celé'=>['cs','sk',],
'celú'=>['sk',],
'celý'=>['cs','sk',],
'cemo'=>['bs','sr',],
'cena'=>['es','it','pt',],
'cenderung'=>['id',],
'cento'=>['gl',],
'central'=>['gl',],
'centro'=>['es','gl','it','pt',],
'centros'=>['gl',],
'centum'=>['la',],
'cenu'=>['cs',],
'cenšos'=>['lv',],
'ceo'=>['gl','sr',],
'cepat'=>['id','ms',],
'cer'=>['ro',],
'cerca'=>['es','it',],
'cercando'=>['it',],
'cercare'=>['it',],
'cercato'=>['it',],
'cerdas'=>['id',],
'cerita'=>['id','ms',],
'ceritakan'=>['ms',],
'cert'=>['ca',],
'certa'=>['gl','pt','pt_br',],
'certain'=>['en',],
'certainly'=>['en',],
'certains'=>['fr',],
'certamente'=>['pt_br',],
'certe'=>['la',],
'certeza'=>['pt','pt_br',],
'certo'=>['gl','it','pt','pt_br',],
'certum'=>['la',],
'ceru'=>['lv',],
'cerut'=>['ro',],
'cervell'=>['ca',],
'cervello'=>['it',],
'ces'=>['fr',],
'cesta'=>['cs','sk',],
'ceste'=>['sk',],
'cestu'=>['cs','sk',],
'cesty'=>['cs','sk',],
'cestě'=>['cs',],
'cet'=>['fr',],
'cetera'=>['la',],
'ceteris'=>['la',],
'ceterum'=>['la',],
'cette'=>['fr',],
'ceux'=>['fr',],
'ceva'=>['ro',],
'cevap'=>['tr',],
'ceylon'=>['af',],
'cez'=>['sk',],
'ceļa'=>['lv',],
'ceļu'=>['lv',],
'ceļā'=>['lv',],
'ceļš'=>['lv',],
'cfare'=>['sq',],
'cfarë'=>['sq',],
'chacun'=>['fr',],
'chaipiyoji'=>['si',],
'chama'=>['pt','pt_br',],
'chamada'=>['pt',],
'chamado'=>['pt','pt_br',],
'chamar'=>['pt','pt_br',],
'chamathkaar'=>['si',],
'chamatkaar'=>['si',],
'chambre'=>['fr',],
'chame'=>['pt_br',],
'champ'=>['si',],
'chan'=>['gl',],
'chance'=>['da','de','en','fr','pt_br','th',],
'change'=>['en','fr',],
'changed'=>['en',],
'changer'=>['fr',],
'changé'=>['fr',],
'chans'=>['sv',],
'chanson'=>['fr',],
'chaque'=>['fr',],
'charge'=>['en',],
'charles'=>['si',],
'charlie'=>['bs','cs','da','de','en','es','et','fi','fr','hr','hu','is','nb','nl','no','pl','pt','pt_br','ro','si','sk','sl','sv','tr',],
'chat'=>['az',],
'chatur'=>['si',],
'chaud'=>['fr',],
'chave'=>['pt','pt_br',],
'chce'=>['cs','pl','sk',],
'chcecie'=>['pl',],
'chcel'=>['sk',],
'chcela'=>['sk',],
'chceli'=>['sk',],
'chcem'=>['sk',],
'chceme'=>['cs','sk',],
'chcemy'=>['pl',],
'chcesz'=>['pl',],
'chcete'=>['cs','sk',],
'chceš'=>['cs','sk',],
'chci'=>['cs',],
'chciał'=>['pl',],
'chciała'=>['pl',],
'chciałabym'=>['pl',],
'chciałam'=>['pl',],
'chciałbym'=>['pl',],
'chciałem'=>['pl',],
'chcieť'=>['sk',],
'chcú'=>['sk',],
'chcą'=>['pl',],
'chcę'=>['pl',],
'che'=>['gl','it',],
'cheamă'=>['ro',],
'check'=>['en','si',],
'cheer'=>['si',],
'cheers'=>['si',],
'chef'=>['da','fr','si','sv',],
'chefe'=>['pt','pt_br',],
'chefen'=>['sv',],
'chega'=>['gl','pt','pt_br',],
'chegar'=>['gl','pt','pt_br',],
'chegou'=>['gl','pt','pt_br',],
'cheio'=>['pt','pt_br',],
'chemin'=>['fr',],
'cher'=>['fr',],
'cherche'=>['fr',],
'chercher'=>['fr',],
'chestia'=>['ro',],
'cheval'=>['fr',],
'cheveux'=>['fr',],
'chez'=>['fr',],
'chi'=>['it',],
'chiama'=>['it',],
'chiamare'=>['it',],
'chiamata'=>['it',],
'chiamato'=>['it',],
'chiami'=>['it',],
'chiamo'=>['it',],
'chiar'=>['ro',],
'chiaro'=>['it',],
'chiave'=>['it',],
'chica'=>['es',],
'chicas'=>['es',],
'chico'=>['es',],
'chicos'=>['es',],
'chiedere'=>['it',],
'chiedo'=>['it',],
'chief'=>['en',],
'chien'=>['fr',],
'chiesto'=>['it',],
'child'=>['en',],
'children'=>['en',],
'childress'=>['id',],
'chill'=>['af',],
'chimry'=>['th',],
'chiunque'=>['it',],
'chiuso'=>['it',],
'chlap'=>['cs','sk',],
'chlapci'=>['cs','sk',],
'chlape'=>['cs','sk',],
'chlapec'=>['cs','sk',],
'chlapi'=>['cs','sk',],
'chlapík'=>['sk',],
'chlapče'=>['cs','sk',],
'chociaż'=>['pl',],
'chodit'=>['cs',],
'chodiť'=>['sk',],
'chodzi'=>['pl',],
'chodź'=>['pl',],
'chodźcie'=>['pl',],
'chodźmy'=>['pl',],
'choice'=>['en','th',],
'choix'=>['fr',],
'cholera'=>['pl',],
'cholery'=>['pl',],
'chose'=>['fr',],
'choses'=>['fr',],
'choć'=>['pl',],
'choď'=>['sk',],
'choďte'=>['sk',],
'christ'=>['en',],
'christi'=>['la',],
'christmas'=>['en',],
'christo'=>['la',],
'christus'=>['af',],
'chtít'=>['cs',],
'chtějí'=>['cs',],
'chtěl'=>['cs',],
'chtěla'=>['cs',],
'chtěli'=>['cs',],
'chuck'=>['th',],
'chuckles'=>['en',],
'church'=>['en',],
'chvilku'=>['cs',],
'chvíli'=>['cs',],
'chvíľku'=>['sk',],
'chvíľu'=>['sk',],
'chwila'=>['pl',],
'chwileczkę'=>['pl',],
'chwili'=>['pl',],
'chwilę'=>['pl',],
'chyba'=>['cs','pl','sk',],
'chápem'=>['sk',],
'chápu'=>['cs',],
'chão'=>['pt','pt_br',],
'chéri'=>['fr',],
'chérie'=>['fr',],
'chłopak'=>['pl',],
'chłopaki'=>['pl',],
'chłopcy'=>['pl',],
'ci'=>['fr','it','pl','ro',],
'cia'=>['lt','th',],
'ciao'=>['it',],
'ciała'=>['pl',],
'ciało'=>['pl',],
'cibo'=>['it',],
'cicero'=>['la',],
'cicho'=>['pl',],
'cidade'=>['gl','pt','pt_br',],
'cidades'=>['gl',],
'cidadáns'=>['gl',],
'ciddi'=>['tr',],
'ciebie'=>['pl',],
'ciel'=>['fr',],
'cielo'=>['es','it',],
'cierto'=>['es',],
'cieszę'=>['pl',],
'cijeli'=>['bs','hr',],
'cijelu'=>['bs','hr',],
'cik'=>['lv',],
'cila'=>['sq',],
'cilat'=>['sq',],
'cili'=>['sq',],
'cilin'=>['sq',],
'cilvēka'=>['lv',],
'cilvēki'=>['lv',],
'cilvēkiem'=>['lv',],
'cilvēks'=>['lv',],
'cilvēku'=>['lv',],
'cilvēkus'=>['lv',],
'cilën'=>['sq',],
'cilët'=>['sq',],
'cima'=>['pt','pt_br',],
'cinc'=>['ca',],
'cinci'=>['ro',],
'cincin'=>['id',],
'cinco'=>['es','gl','pt','pt_br',],
'cine'=>['gl','ro',],
'cineva'=>['ro',],
'cinq'=>['fr',],
'cinque'=>['it',],
'cinta'=>['ms',],
'circa'=>['it','la',],
'cita'=>['es','lv',],
'citas'=>['lv',],
'citi'=>['lv',],
'citiem'=>['lv',],
'citit'=>['ro',],
'cits'=>['lv',],
'città'=>['it',],
'citu'=>['lv',],
'city'=>['en',],
'citādi'=>['lv',],
'ciudad'=>['es',],
'ciudat'=>['ro',],
'ciuitas'=>['la',],
'ciuitate'=>['la',],
'ciuitatem'=>['la',],
'ciuitates'=>['la',],
'ciuitatis'=>['la',],
'ciuium'=>['la',],
'ciutat'=>['ca',],
'civil'=>['gl',],
'civitas'=>['la',],
'civitate'=>['la',],
'civitatem'=>['la',],
'civitates'=>['la',],
'civitatis'=>['la',],
'ciò'=>['it',],
'ciągle'=>['pl',],
'cię'=>['pl',],
'ciężko'=>['pl',],
'clair'=>['fr',],
'clar'=>['ca','ro',],
'claro'=>['es','gl','pt','pt_br',],
'clase'=>['es','gl',],
'class'=>['en',],
'classe'=>['ca','fr',],
'clau'=>['ca',],
'claude'=>['ca',],
'clean'=>['en',],
'clear'=>['en','th',],
'clearwater'=>['hi','si',],
'clichés'=>['hi',],
'clipă'=>['ro',],
'close'=>['en',],
'closet'=>['th',],
'clothes'=>['en',],
'club'=>['af','en',],
'co'=>['cs','gl','pl','sk','ur',],
'coa'=>['gl',],
'coas'=>['gl',],
'coba'=>['ms',],
'coche'=>['es','gl',],
'cocok'=>['id','ms',],
'coepit'=>['la',],
'coeur'=>['fr',],
'coffee'=>['en',],
'coi'=>['ca',],
'coin'=>['fr',],
'coisa'=>['pt','pt_br',],
'coisas'=>['pt','pt_br',],
'cokoliv'=>['cs',],
'cokolwiek'=>['pl',],
'col'=>['it',],
'cold'=>['en',],
'coleman'=>['ca',],
'coll'=>['ca',],
'college'=>['si',],
'collons'=>['ca',],
'colocar'=>['pt_br',],
'colonel'=>['en','fr',],
'colonnello'=>['it',],
'colpa'=>['it',],
'colpo'=>['it',],
'com'=>['ar','ca','fa','it','ms','pt','pt_br','si','sk','sq','th','ur','zh_tw',],
'coma'=>['ca','gl',],
'comandant'=>['ca',],
'comandante'=>['pt',],
'combat'=>['fr',],
'combien'=>['fr',],
'come'=>['en','fa','it','si','th',],
'comença'=>['ca',],
'començar'=>['ca',],
'comer'=>['es','pt','pt_br',],
'comes'=>['en',],
'comezou'=>['gl',],
'começa'=>['pt','pt_br',],
'começar'=>['pt','pt_br',],
'começou'=>['pt','pt_br',],
'comic'=>['th',],
'comida'=>['es','pt','pt_br',],
'comigo'=>['pt','pt_br',],
'coming'=>['en',],
'comisión'=>['gl',],
'commandant'=>['fr',],
'comme'=>['fr',],
'commence'=>['fr',],
'commencer'=>['fr',],
'commencé'=>['fr',],
'comment'=>['fr',],
'como'=>['es','gl','pt','pt_br',],
'compagnia'=>['it',],
'compagnie'=>['fr',],
'companhia'=>['pt','pt_br',],
'company'=>['en',],
'companyia'=>['ca',],
'compañía'=>['es','gl',],
'complet'=>['ro',],
'completament'=>['ca',],
'completamente'=>['es','it','pt','pt_br',],
'completely'=>['en',],
'complètement'=>['fr',],
'compostela'=>['gl',],
'comprar'=>['ca','es','pt','pt_br',],
'comprendre'=>['fr',],
'comprends'=>['fr',],
'compris'=>['fr',],
'compte'=>['ca','fr',],
'computer'=>['th',],
'comte'=>['ca',],
'comunicación'=>['gl',],
'comunidade'=>['gl',],
'comunidades'=>['gl',],
'comunque'=>['it',],
'común'=>['gl',],
'con'=>['es','fr','gl','it',],
'concello'=>['gl',],
'concrete'=>['si',],
'condicións'=>['gl',],
'conec'=>['ca',],
'conegut'=>['ca',],
'coneix'=>['ca',],
'confiance'=>['fr',],
'congreso'=>['gl',],
'conhece'=>['pt','pt_br',],
'conhecer'=>['pt','pt_br',],
'conheço'=>['pt','pt_br',],
'conmigo'=>['es',],
'connais'=>['fr',],
'connaissez'=>['fr',],
'connard'=>['fr',],
'connaît'=>['fr',],
'connaître'=>['fr',],
'connection'=>['si',],
'conneries'=>['fr',],
'connosco'=>['pt',],
'connu'=>['fr',],
'conoce'=>['es',],
'conoces'=>['es',],
'conosce'=>['it',],
'conosci'=>['it',],
'conosco'=>['it','pt_br',],
'conozco'=>['es',],
'consegue'=>['pt','pt_br',],
'consegues'=>['pt',],
'consegui'=>['pt','pt_br',],
'conseguir'=>['es','pt','pt_br',],
'conseguiu'=>['pt','pt_br',],
'conselleiro'=>['gl',],
'consellería'=>['gl',],
'consello'=>['gl',],
'considera'=>['gl',],
'consiglio'=>['it',],
'consigo'=>['pt','pt_br',],
'consilio'=>['la',],
'consilium'=>['la',],
'conspectu'=>['la',],
'constat'=>['la',],
'consul'=>['la',],
'consule'=>['la',],
'consulem'=>['la',],
'consules'=>['la',],
'consulibus'=>['la',],
'consumo'=>['gl',],
'conta'=>['gl','pt','pt_br',],
'contact'=>['nl',],
'contar'=>['gl','pt','pt_br',],
'contează'=>['ro',],
'content'=>['fr',],
'contents'=>['si',],
'contest'=>['th',],
'contigo'=>['es','pt','pt_br',],
'continua'=>['ca','it','pt','pt_br',],
'continuar'=>['ca','pt','pt_br',],
'continue'=>['fr','pt_br',],
'continuer'=>['fr',],
'continues'=>['en',],
'continuă'=>['ro',],
'conto'=>['it',],
'contoh'=>['id',],
'contou'=>['pt_br',],
'contra'=>['ca','es','gl','la','pt','pt_br',],
'contrario'=>['gl',],
'contre'=>['fr',],
'contro'=>['it',],
'control'=>['ca','en','es','gl',],
'controle'=>['nl','pt_br',],
'controllo'=>['it',],
'contrôle'=>['fr',],
'conversa'=>['pt','pt_br',],
'conversar'=>['pt','pt_br',],
'conxunto'=>['gl',],
'cony'=>['ca',],
'conèixer'=>['ca',],
'cookies'=>['si',],
'cool'=>['de','en','fr',],
'cop'=>['ca','en',],
'copak'=>['cs',],
'copii'=>['ro',],
'copiii'=>['ro',],
'copil'=>['ro',],
'copilul'=>['ro',],
'cops'=>['en',],
'cor'=>['ca','gl','la',],
'coraggio'=>['it',],
'coram'=>['la',],
'corazón'=>['es','gl',],
'coração'=>['pt','pt_br',],
'corde'=>['la',],
'corect'=>['ro',],
'coronel'=>['ca','es','pt','pt_br',],
'corpo'=>['gl','it','pt','pt_br',],
'corpora'=>['la',],
'corporal'=>['th',],
'corpore'=>['la',],
'corporis'=>['la',],
'corps'=>['fr',],
'corpus'=>['la',],
'corre'=>['ca',],
'correcte'=>['ca',],
'correcto'=>['es',],
'correr'=>['pt',],
'coruña'=>['gl',],
'cos'=>['ca','cs','gl','it',],
'cosa'=>['ca','es','it',],
'cosas'=>['es',],
'cose'=>['it',],
'coses'=>['ca',],
'cosi'=>['it',],
'costa'=>['ca','gl',],
'costas'=>['gl','pt','pt_br',],
'costat'=>['ca',],
'costumes'=>['th',],
'così'=>['it',],
'cotxe'=>['ca',],
'coucher'=>['fr',],
'could'=>['en','si','th',],
'couldn'=>['en',],
'count'=>['en',],
'country'=>['en',],
'coup'=>['fr',],
'couple'=>['en',],
'courant'=>['fr',],
'cours'=>['fr',],
'course'=>['en',],
'court'=>['en',],
'cousa'=>['gl',],
'cousas'=>['gl',],
'cover'=>['en',],
'cowen'=>['hi',],
'coñecemento'=>['gl',],
'coñecer'=>['gl',],
'coś'=>['pl',],
'což'=>['cs',],
'cože'=>['cs',],
'crack'=>['th',],
'crazy'=>['en',],
'creación'=>['gl',],
'crec'=>['ca',],
'cred'=>['ro',],
'crede'=>['it','ro',],
'credeam'=>['ro',],
'credere'=>['it',],
'credevo'=>['it',],
'credeţi'=>['ro',],
'credi'=>['it',],
'credit'=>['si',],
'credo'=>['it','la',],
'cree'=>['es',],
'creepin'=>['af',],
'creer'=>['es',],
'crees'=>['es',],
'creio'=>['pt','pt_br',],
'creo'=>['es','gl',],
'crescent'=>['th',],
'creu'=>['ca',],
'creure'=>['ca',],
'creus'=>['ca',],
'crezi'=>['ro',],
'crezut'=>['ro',],
'creí'=>['es',],
'criança'=>['pt','pt_br',],
'crianças'=>['pt','pt_br',],
'crime'=>['pt',],
'crise'=>['gl',],
'cristo'=>['it',],
'croire'=>['fr',],
'crois'=>['fr',],
'crown'=>['si',],
'crowning'=>['si',],
'croyais'=>['fr',],
'croyez'=>['fr',],
'cru'=>['fr',],
'cry'=>['en',],
'cryin'=>['af',],
'crying'=>['en',],
'crăciun'=>['ro',],
'csak'=>['hu',],
'család'=>['hu',],
'csapat'=>['hu',],
'csi'=>['si',],
'csinál'=>['hu',],
'csináld'=>['hu',],
'csinálja'=>['hu',],
'csinálni'=>['hu',],
'csinálok'=>['hu',],
'csinálsz'=>['hu',],
'csinált'=>['hu',],
'csináltam'=>['hu',],
'csodálatos'=>['hu',],
'csodás'=>['hu',],
'cu'=>['bs','hr','ro','sr',],
'cuaca'=>['id',],
'cual'=>['es',],
'cualquier'=>['es',],
'cualquiera'=>['es',],
'cuando'=>['es',],
'cuanto'=>['es',],
'cuarto'=>['es','gl',],
'cuatro'=>['es',],
'cuenta'=>['es',],
'cuerpo'=>['es',],
'cuestión'=>['gl',],
'cui'=>['it','la','ro',],
'cuidado'=>['es','pt','pt_br',],
'cuidar'=>['pt_br',],
'cuius'=>['la',],
'cukup'=>['id','ms',],
'cul'=>['ca','fr',],
'cullen'=>['hi',],
'cullenov'=>['hi',],
'culo'=>['es','it',],
'culpa'=>['ca','es','pt','pt_br',],
'cultura'=>['gl',],
'cultural'=>['gl',],
'cum'=>['la','ro',],
'cuma'=>['ms',],
'cumpleaños'=>['es',],
'cumque'=>['la',],
'cumva'=>['ro',],
'cun'=>['gl',],
'cuncta'=>['la',],
'cunctis'=>['la',],
'cunha'=>['gl',],
'cunosc'=>['ro',],
'cunoscut'=>['ro',],
'cunoşti'=>['ro',],
'cuore'=>['it',],
'cur'=>['la',],
'cura'=>['hr','it','la',],
'curând'=>['ro',],
'cut'=>['en','si',],
'cute'=>['si',],
'cuál'=>['es',],
'cuándo'=>['es',],
'cuánto'=>['es',],
'cuántos'=>['es',],
'czas'=>['pl',],
'czasami'=>['pl',],
'czasem'=>['pl',],
'czasie'=>['pl',],
'czasu'=>['pl',],
'czego'=>['pl',],
'czegoś'=>['pl',],
'czeka'=>['pl',],
'czekaj'=>['pl',],
'czekać'=>['pl',],
'czemu'=>['pl',],
'cześć'=>['pl',],
'cztery'=>['pl',],
'czuje'=>['pl',],
'czujesz'=>['pl',],
'czuję'=>['pl',],
'czy'=>['pl',],
'czym'=>['pl',],
'czymś'=>['pl',],
'czyż'=>['pl',],
'często'=>['pl',],
'część'=>['pl',],
'człowiek'=>['pl',],
'człowieka'=>['pl',],
'człowiekiem'=>['pl',],
'człowieku'=>['pl',],
'cá'=>['pt','pt_br',],
'cállate'=>['es',],
'cámara'=>['es','gl',],
'cárcel'=>['es',],
'câine'=>['ro',],
'când'=>['ro',],
'cât'=>['ro',],
'câte'=>['ro',],
'câteva'=>['ro',],
'câştigat'=>['ro',],
'cão'=>['pt',],
'céu'=>['pt','pt_br',],
'cítim'=>['sk',],
'cítiš'=>['sk',],
'cítím'=>['cs',],
'cómo'=>['es',],
'cómpre'=>['gl',],
'córka'=>['pl',],
'córrer'=>['ca',],
'cóż'=>['pl',],
'côté'=>['fr',],
'cümə'=>['az',],
'că'=>['ro',],
'căpitane'=>['ro',],
'către'=>['ro',],
'cœur'=>['fr',],
'cəmi'=>['az',],
'd'=>['da','en','et','fr','lt','lv','ms','nb','nl','no','pt','si','sv',],
'da'=>['az','bs','da','de','es','eu','gl','hr','it','nb','nl','no','pl','pt','pt_br','ro','sl','sr','tr',],
'daamid'=>['et',],
'daar'=>['af','nl',],
'daardie'=>['af',],
'daarmee'=>['nl',],
'daarna'=>['af','nl',],
'daarom'=>['af','nl',],
'daarvan'=>['af',],
'daba'=>['gl',],
'dabar'=>['lt',],
'dabei'=>['de',],
'dabil'=>['eu',],
'dabūt'=>['lv',],
'daca'=>['ro',],
'dacha'=>['eu',],
'dacht'=>['nl',],
'dachte'=>['de',],
'dacă'=>['ro',],
'dad'=>['de','en',],
'daddy'=>['af','de','en',],
'dade'=>['af',],
'dadelik'=>['af',],
'dado'=>['es',],
'dae'=>['af',],
'daerah'=>['id','ms',],
'dafür'=>['de',],
'dag'=>['af','da','is','nb','nl','no','sv',],
'daga'=>['is',],
'dagar'=>['sv',],
'dage'=>['da',],
'dagen'=>['da','nb','nl','no','sv',],
'dager'=>['nb','no',],
'daging'=>['ms',],
'daginn'=>['is',],
'dago'=>['eu',],
'dagoena'=>['eu',],
'dagoenean'=>['eu',],
'dags'=>['sv',],
'dagur'=>['is',],
'dah'=>['ms',],
'daha'=>['az','tr',],
'dai'=>['it','ro',],
'daiktas'=>['lt',],
'daiktus'=>['lt',],
'dair'=>['tr',],
'daiteke'=>['eu',],
'daj'=>['bs','hr','pl','sk','sl','sr',],
'dajmo'=>['sl',],
'dajte'=>['bs','hr','sk','sl','sr',],
'dakika'=>['tr',],
'dakit'=>['eu',],
'dakizki'=>['eu',],
'dakizkiela'=>['eu',],
'dakizkien'=>['eu',],
'dakizu'=>['eu',],
'dakle'=>['bs','hr','sr',],
'dakord'=>['sq',],
'dakort'=>['sq',],
'daktaras'=>['lt',],
'daktare'=>['lt',],
'dakter'=>['lv',],
'dal'=>['cs','it','sk','sl','sq',],
'dala'=>['cs','is','sk','sl',],
'dalam'=>['id','ms',],
'dalamnya'=>['id',],
'dale'=>['es',],
'dalej'=>['pl',],
'daleko'=>['bs','cs','hr','pl','sr',],
'daleč'=>['sl',],
'dalga'=>['tr',],
'dali'=>['bs','hr','is','sk','sl','sr',],
'dalim'=>['sq',],
'dalis'=>['lt',],
'dalje'=>['bs','hr','sr',],
'dalla'=>['it',],
'dalle'=>['it',],
'dalt'=>['ca',],
'dalykas'=>['lt',],
'dalykus'=>['lt',],
'dalykų'=>['lt',],
'dalë'=>['sq',],
'dalësh'=>['sq',],
'další'=>['cs',],
'dam'=>['pl','sl',],
'damals'=>['de',],
'dame'=>['af','bs','da','de','es','fr','hr','nb','nl','no','sl','sr',],
'damen'=>['de',],
'damer'=>['da','nb','no','sv',],
'dames'=>['nl',],
'damit'=>['de',],
'dammi'=>['it',],
'damn'=>['en','si',],
'dampak'=>['id',],
'dan'=>['af','bs','es','hr','id','ms','nl','sl','sr','sv',],
'dana'=>['bs','hr','sr',],
'danach'=>['de',],
'danas'=>['bs','hr','sr',],
'danau'=>['id',],
'dance'=>['en',],
'danes'=>['sl',],
'dangereux'=>['fr',],
'dangerous'=>['en','th',],
'dank'=>['de','nl',],
'dankbaar'=>['af',],
'danke'=>['de',],
'dann'=>['de',],
'dans'=>['fr','tr',],
'dansa'=>['sv',],
'danse'=>['da','fr','nb','no',],
'dansen'=>['nl',],
'dançar'=>['pt','pt_br',],
'dao'=>['bs','hr','sr',],
'dapat'=>['id','ms',],
'dapatkah'=>['ms',],
'dapatkan'=>['id','ms',],
'dapper'=>['af',],
'daquel'=>['gl',],
'daquela'=>['gl',],
'daqui'=>['pt','pt_br',],
'dar'=>['es','gl','lt','pt','pt_br','ro',],
'dara'=>['lv',],
'darah'=>['ms',],
'darai'=>['lt',],
'daran'=>['de',],
'darau'=>['lt',],
'darauf'=>['de',],
'darba'=>['lv',],
'darbas'=>['lt',],
'darbo'=>['lt',],
'darbs'=>['lv',],
'darbu'=>['lv',],
'darbą'=>['lt',],
'dare'=>['en','it','la','si',],
'darf'=>['de',],
'dari'=>['id','lv','ms',],
'dariku'=>['ms',],
'daripada'=>['id','ms',],
'dark'=>['en',],
'darkë'=>['sq',],
'darle'=>['es',],
'darling'=>['en',],
'daro'=>['lt',],
'darosi'=>['lt',],
'darrere'=>['ca',],
'daru'=>['lv',],
'darum'=>['de',],
'darwin'=>['id',],
'daryk'=>['lt',],
'daryti'=>['lt',],
'daré'=>['es',],
'darüber'=>['de',],
'darāt'=>['lv',],
'darīsim'=>['lv',],
'darīt'=>['lv',],
'darīšu'=>['lv',],
'das'=>['de','es','gl','pt','pt_br',],
'dasar'=>['id','ms',],
'dasarnya'=>['id',],
'dasavatar'=>['af',],
'dasharatha'=>['af',],
'dashur'=>['sq',],
'dashuri'=>['sq',],
'dass'=>['de',],
'dasz'=>['pl',],
'dat'=>['af','hr','nl','ro',],
'data'=>['id','la','ro',],
'datang'=>['id','ms',],
'date'=>['en',],
'dati'=>['bs','hr','sl','sr',],
'dato'=>['it',],
'dator'=>['eu',],
'datorrela'=>['eu',],
'datos'=>['gl',],
'datoz'=>['eu',],
'datt'=>['is',],
'datter'=>['da','nb','no',],
'dată'=>['ro',],
'dau'=>['ro',],
'daude'=>['eu',],
'dauden'=>['eu',],
'daudenean'=>['eu',],
'daudz'=>['lv',],
'daudzi'=>['lv',],
'daug'=>['lt',],
'daughter'=>['en',],
'daugiau'=>['lt',],
'dauid'=>['la',],
'dauka'=>['eu',],
'daukagu'=>['eu',],
'daukate'=>['eu',],
'daukazu'=>['eu',],
'daukazuela'=>['eu',],
'dauzka'=>['eu',],
'dauzkazu'=>['eu',],
'dauzkazula'=>['eu',],
'dauður'=>['is',],
'davant'=>['ca',],
'davanti'=>['it',],
'dave'=>['af','is',],
'david'=>['da','de','en','es','et','fi','fr','hu','is','it','la','ms','nb','nl','no','pt','pt_br','ro','sl','sv','tr',],
'davon'=>['de',],
'davvero'=>['it',],
'davė'=>['lt',],
'dawaj'=>['pl',],
'dawno'=>['pl',],
'day'=>['en','si',],
'daya'=>['id',],
'days'=>['en',],
'dazu'=>['de',],
'daß'=>['de',],
'daí'=>['pt','pt_br',],
'daño'=>['es',],
'dać'=>['pl',],
'daļa'=>['lv',],
'daļu'=>['lv',],
'dał'=>['pl',],
'dať'=>['sk',],
'dažas'=>['lv',],
'daži'=>['lv',],
'dažnai'=>['lt',],
'dažreiz'=>['lv',],
'dcera'=>['cs',],
'dcéra'=>['sk',],
'de'=>['az','ca','da','de','en','es','fr','gl','hu','la','nb','nl','no','pt','pt_br','ro','sv','th','tr','zh_tw',],
'dea'=>['ro',],
'dead'=>['en',],
'deal'=>['en',],
'dear'=>['en','si',],
'death'=>['en',],
'debate'=>['gl','si',],
'debe'=>['es','gl',],
'debemos'=>['es',],
'deben'=>['es','gl',],
'debería'=>['es','gl',],
'deberíamos'=>['es',],
'deberías'=>['es',],
'debes'=>['es',],
'debet'=>['la',],
'debido'=>['gl',],
'debo'=>['es',],
'debout'=>['fr',],
'debu'=>['id',],
'debía'=>['gl',],
'debò'=>['ca',],
'deca'=>['sr',],
'decat'=>['ro',],
'dece'=>['sr',],
'decem'=>['la',],
'deci'=>['ro',],
'decided'=>['en',],
'decidir'=>['ca',],
'decir'=>['es',],
'decirle'=>['es',],
'decirme'=>['es',],
'decirte'=>['es',],
'decisión'=>['gl',],
'deciso'=>['it',],
'decu'=>['sr',],
'decât'=>['ro',],
'decía'=>['es',],
'deda'=>['sr',],
'dedans'=>['fr',],
'dedi'=>['tr',],
'dedim'=>['tr',],
'dedin'=>['tr',],
'dedit'=>['la',],
'deed'=>['nl',],
'deel'=>['af','nl',],
'deep'=>['en',],
'defa'=>['tr',],
'defensa'=>['gl',],
'defol'=>['tr',],
'deg'=>['nb','no',],
'degene'=>['nl',],
'degli'=>['it',],
'dehogy'=>['hu',],
'dehors'=>['fr',],
'dei'=>['it','la','pt_br',],
'deia'=>['ca',],
'dein'=>['de','la',],
'deinde'=>['la',],
'deine'=>['de',],
'deinem'=>['de',],
'deinen'=>['de',],
'deiner'=>['de',],
'deitu'=>['eu',],
'deitzen'=>['eu',],
'deixa'=>['ca','gl','pt','pt_br',],
'deixar'=>['ca','gl','pt','pt_br',],
'deixat'=>['ca',],
'deixe'=>['pt','pt_br',],
'deixi'=>['ca',],
'deixou'=>['gl','pt','pt_br',],
'dej'=>['cs','sv',],
'deja'=>['es','ro',],
'dejado'=>['es',],
'dejar'=>['es',],
'deje'=>['es','sk',],
'dejligt'=>['da',],
'dejte'=>['cs',],
'dejó'=>['es',],
'dek'=>['tr',],
'dekat'=>['id','ms',],
'dekle'=>['sl',],
'dekleta'=>['sl',],
'del'=>['ca','da','es','gl','it','lt','nb','no','sl','sq','sv',],
'dela'=>['eu','gl','pt','pt_br','sl',],
'delako'=>['eu',],
'delal'=>['sl',],
'delam'=>['sl',],
'delante'=>['es',],
'delapan'=>['id',],
'delas'=>['gl',],
'delati'=>['sl',],
'delaš'=>['sl',],
'dele'=>['da','pt','pt_br',],
'deler'=>['nb',],
'deles'=>['gl','pt','pt_br',],
'delhi'=>['si',],
'deli'=>['tr',],
'dell'=>['it',],
'della'=>['it',],
'delle'=>['it',],
'dello'=>['it',],
'delo'=>['sl',],
'deloc'=>['ro',],
'dels'=>['ca',],
'deluje'=>['sl',],
'dem'=>['da','de','nb','no','sv',],
'demain'=>['fr',],
'demais'=>['gl','pt','pt_br',],
'demana'=>['ca',],
'demanar'=>['ca',],
'demande'=>['fr',],
'demander'=>['fr',],
'demandé'=>['fr',],
'demasiado'=>['es','gl','pt',],
'demek'=>['tr',],
'demi'=>['ms',],
'demikian'=>['id',],
'demonios'=>['es',],
'demontre'=>['eu',],
'demà'=>['ca',],
'demás'=>['es',],
'den'=>['cs','da','de','eu','nb','no','sv',],
'denak'=>['eu',],
'denar'=>['sl',],
'denarja'=>['sl',],
'denaro'=>['it',],
'denbora'=>['eu',],
'dende'=>['gl',],
'denean'=>['eu',],
'denen'=>['de',],
'dengan'=>['id','ms',],
'denganku'=>['ms',],
'denganmu'=>['ms',],
'dengannya'=>['ms',],
'dengar'=>['ms',],
'dengarkan'=>['ms',],
'denique'=>['la',],
'denk'=>['de','nl',],
'denkbaar'=>['af',],
'denke'=>['de',],
'denken'=>['de','nl',],
'denkst'=>['de',],
'denkt'=>['de','nl',],
'denn'=>['de',],
'denna'=>['sv',],
'denne'=>['da','nb','no',],
'dennin'=>['id',],
'denok'=>['eu',],
'dentro'=>['es','gl','it','pt','pt_br',],
'deo'=>['la','sr',],
'deorum'=>['la',],
'deos'=>['la',],
'depan'=>['id','ms',],
'departe'=>['ro',],
'departemen'=>['id',],
'depois'=>['pt','pt_br',],
'depressa'=>['pt','pt_br',],
'depuis'=>['fr',],
'der'=>['da','de','nb','no',],
'derajat'=>['id',],
'deras'=>['sv',],
'derde'=>['nl',],
'dere'=>['nb','no',],
'derecha'=>['es',],
'derecho'=>['es',],
'dereita'=>['gl',],
'dereito'=>['gl',],
'dereitos'=>['gl',],
'deres'=>['da','nb','no',],
'derfor'=>['da','nb','no',],
'deri'=>['sq',],
'derinde'=>['da',],
'deringen'=>['af',],
'derisa'=>['sq',],
'derms'=>['af',],
'dernier'=>['fr',],
'dernière'=>['fr',],
'derovre'=>['da',],
'derrière'=>['fr',],
'dersin'=>['tr',],
'derude'=>['da',],
'derën'=>['sq',],
'des'=>['ca','de','fr',],
'desa'=>['gl',],
'desain'=>['id',],
'desaparegut'=>['ca',],
'desať'=>['sk',],
'desberdina'=>['eu',],
'deschide'=>['ro',],
'descobrir'=>['pt','pt_br',],
'descomptat'=>['ca',],
'desculpa'=>['pt','pt_br',],
'desculpe'=>['pt','pt_br',],
'desde'=>['es','gl','pt','pt_br',],
'dese'=>['gl',],
'desejo'=>['pt_br',],
'desenvolvemento'=>['gl',],
'deseo'=>['es',],
'deservin'=>['af',],
'deset'=>['bs','cs','hr','sl','sr',],
'desha'=>['sq',],
'deshalb'=>['de',],
'desi'=>['bs',],
'desigur'=>['ro',],
'desilo'=>['bs','sr',],
'desiti'=>['bs',],
'desmit'=>['lv',],
'despois'=>['gl',],
'despre'=>['ro',],
'després'=>['ca',],
'después'=>['es',],
'dess'=>['sv',],
'dessa'=>['pt','pt_br','sv',],
'desse'=>['pt','pt_br',],
'dessus'=>['fr',],
'dessverre'=>['nb','no',],
'desta'=>['gl','pt','pt_br',],
'destas'=>['gl',],
'deste'=>['gl','pt','pt_br',],
'destes'=>['gl',],
'destino'=>['gl','pt_br',],
'destra'=>['it',],
'destruct'=>['th',],
'destul'=>['ro',],
'desværre'=>['da',],
'deswegen'=>['de',],
'det'=>['da','nb','no','sv',],
'dete'=>['sr',],
'detector'=>['th',],
'deti'=>['sk',],
'detik'=>['id','ms',],
'detrás'=>['es','gl',],
'detta'=>['sv',],
'dette'=>['da','nb','no',],
'detto'=>['it',],
'deu'=>['ca','gl','pt','pt_br',],
'deugde'=>['af',],
'deugsame'=>['af',],
'deum'=>['la',],
'deur'=>['af','nl',],
'deus'=>['ca','gl','la','pt','pt_br',],
'deux'=>['fr',],
'devais'=>['fr',],
'devait'=>['fr',],
'devam'=>['tr',],
'devant'=>['fr',],
'deve'=>['it','pt','pt_br',],
'devem'=>['pt','pt_br',],
'devemos'=>['pt','pt_br',],
'devenir'=>['fr',],
'devenit'=>['ro',],
'devenu'=>['fr',],
'deveria'=>['pt','pt_br',],
'deves'=>['pt',],
'devez'=>['fr',],
'devi'=>['it',],
'devia'=>['pt','pt_br',],
'devias'=>['pt',],
'devo'=>['it','pt','pt_br',],
'devoir'=>['fr',],
'devojka'=>['sr',],
'devojke'=>['sr',],
'devojku'=>['sr',],
'devono'=>['it',],
'devons'=>['fr',],
'devrais'=>['fr',],
'devrait'=>['fr',],
'devreme'=>['ro',],
'devriez'=>['fr',],
'devíamos'=>['pt',],
'devās'=>['lv',],
'dewa'=>['id','ms',],
'dewasa'=>['ms',],
'deyil'=>['az',],
'deyja'=>['is',],
'dez'=>['gl','pt','pt_br',],
'dezake'=>['eu',],
'dezatela'=>['eu',],
'deze'=>['nl',],
'dezelfde'=>['nl',],
'dečki'=>['hr',],
'dečko'=>['hr',],
'değil'=>['tr',],
'değildi'=>['tr',],
'değildir'=>['tr',],
'değilim'=>['tr',],
'değiliz'=>['tr',],
'değilsin'=>['tr',],
'deň'=>['sk',],
'dešava'=>['bs',],
'deиko'=>['sr',],
'deљava'=>['bs','sr',],
'dha'=>['sq',],
'dhe'=>['sq',],
'dhjetë'=>['sq',],
'dhobi'=>['af',],
'dhoma'=>['sq',],
'dhomë'=>['sq',],
'dhomën'=>['sq',],
'dhënë'=>['sq',],
'di'=>['es','gl','id','it','ms','nb','no','sq',],
'dia'=>['ca','id','ms','pt','pt_br',],
'diable'=>['fr',],
'diablos'=>['es',],
'diabo'=>['pt',],
'diabos'=>['pt','pt_br',],
'diabła'=>['pl',],
'diam'=>['ms',],
'diambil'=>['id',],
'diameter'=>['id',],
'dianggap'=>['id',],
'diante'=>['gl',],
'dias'=>['pt','pt_br',],
'diavolo'=>['it',],
'dibandingkan'=>['id',],
'dibangun'=>['id',],
'dibortzioa'=>['eu',],
'dibortzioari'=>['eu',],
'dibuat'=>['id','ms',],
'dibutuhkan'=>['id',],
'dic'=>['ca',],
'dica'=>['it',],
'dicam'=>['la',],
'dicat'=>['la',],
'dice'=>['es','it',],
'dicen'=>['es',],
'dicendi'=>['la',],
'dicendo'=>['it',],
'dicens'=>['la',],
'dicere'=>['la',],
'diceret'=>['la',],
'dices'=>['es',],
'diceva'=>['it',],
'dich'=>['de',],
'dicho'=>['es',],
'dicht'=>['nl',],
'dici'=>['it','la',],
'diciendo'=>['es',],
'dicimus'=>['la',],
'diciptakan'=>['id',],
'dicir'=>['gl',],
'dicit'=>['la',],
'dicitur'=>['la',],
'dick'=>['ca',],
'dicka'=>['sq',],
'dico'=>['it','la',],
'dicono'=>['it',],
'dicta'=>['la',],
'dictum'=>['la',],
'dicunt'=>['la',],
'dicuntur'=>['la',],
'dicía'=>['gl',],
'did'=>['en','fa','th',],
'didalam'=>['ms',],
'didasarkan'=>['id',],
'didazu'=>['eu',],
'didazue'=>['eu',],
'didelis'=>['lt',],
'didelė'=>['lt',],
'didn'=>['en',],
'die'=>['af','de','en','la','nl',],
'diebus'=>['la',],
'dieci'=>['it',],
'died'=>['en',],
'diegu'=>['eu',],
'diem'=>['la',],
'diemžēl'=>['lv',],
'dien'=>['eu',],
'diena'=>['lt','lv',],
'dienas'=>['lt','lv',],
'dienos'=>['lt',],
'dienst'=>['nl',],
'dient'=>['ca',],
'dienu'=>['lv',],
'dienā'=>['lv',],
'dienām'=>['lv',],
'dieną'=>['lt',],
'dienų'=>['lt',],
'diep'=>['af',],
'diere'=>['af',],
'dies'=>['ca','de','la',],
'diese'=>['de',],
'dieselfde'=>['af',],
'diesem'=>['de',],
'diesen'=>['de',],
'dieser'=>['de',],
'dieses'=>['de',],
'diete'=>['eu',],
'dietro'=>['it',],
'dieu'=>['fr',],
'dieva'=>['lv',],
'dievam'=>['lv',],
'dievas'=>['lt',],
'dieve'=>['lt',],
'dievo'=>['lt',],
'dievs'=>['lv',],
'dievui'=>['lt',],
'dievča'=>['sk',],
'dievčatá'=>['sk',],
'diez'=>['es','lv',],
'diezgan'=>['lv',],
'diezu'=>['eu',],
'dieťa'=>['sk',],
'diferent'=>['ca',],
'diferente'=>['es','pt','pt_br',],
'diferentes'=>['gl',],
'diferents'=>['ca',],
'different'=>['en',],
'difficile'=>['fr','it',],
'difficult'=>['en',],
'difícil'=>['ca','es','gl','pt','pt_br',],
'dig'=>['da','no','sv',],
'diga'=>['es','pt','pt_br',],
'digas'=>['es','pt',],
'digo'=>['es','gl','pt','pt_br',],
'digue'=>['ca',],
'digues'=>['ca',],
'digui'=>['ca',],
'diguis'=>['ca',],
'digunakan'=>['id','ms',],
'digər'=>['az',],
'dihasilkan'=>['id',],
'dija'=>['sq',],
'dije'=>['es','sq',],
'dijeron'=>['es',],
'dijete'=>['bs','hr',],
'dijiste'=>['es',],
'dijo'=>['es',],
'dikelilingi'=>['id',],
'dikembangkan'=>['id',],
'dikenal'=>['id',],
'diketahui'=>['id',],
'dikkat'=>['tr',],
'dikkatli'=>['tr',],
'dikonfirmasi'=>['id',],
'diku'=>['sq',],
'dikunjungi'=>['id',],
'dikush'=>['sq',],
'dikë'=>['sq',],
'dil'=>['sq',],
'dilakukan'=>['id','ms',],
'dile'=>['es',],
'dilerim'=>['tr',],
'diligenter'=>['la',],
'dilimizdə'=>['az',],
'dilni'=>['sq',],
'diluar'=>['ms',],
'dimana'=>['id','ms',],
'dime'=>['es',],
'dimenticato'=>['it',],
'dimineata'=>['ro',],
'dimineaţa'=>['ro',],
'dimineaţă'=>['ro',],
'dimmi'=>['it',],
'dimonis'=>['ca',],
'dimulai'=>['id','ms',],
'dimë'=>['sq',],
'din'=>['da','gl','nb','no','ro','sq','sv',],
'dina'=>['sv',],
'dine'=>['bs','da','nb','no',],
'dinero'=>['es',],
'diners'=>['ca',],
'ding'=>['af','de','nl',],
'dinge'=>['af','de',],
'dingen'=>['nl',],
'dingin'=>['id','ms',],
'dingo'=>['lt',],
'dinheiro'=>['pt','pt_br',],
'dini'=>['sq',],
'dink'=>['af','lt',],
'dinle'=>['tr',],
'dinleyin'=>['tr',],
'dinner'=>['en',],
'dins'=>['ca',],
'dinte'=>['sq',],
'dintre'=>['ro',],
'dinë'=>['sq',],
'dio'=>['bs','es','eu','hr','it',],
'diogu'=>['eu',],
'dios'=>['es',],
'diot'=>['eu',],
'diozu'=>['eu',],
'diozue'=>['eu',],
'diperkirakan'=>['id',],
'diperlukan'=>['id',],
'diqka'=>['sq',],
'dir'=>['ca','de',],
'dira'=>['eu',],
'dirai'=>['fr',],
'dirait'=>['fr',],
'dirancang'=>['id',],
'dirba'=>['lt',],
'dirbti'=>['lt',],
'dirbu'=>['lt',],
'dire'=>['ca','fr','it',],
'dirección'=>['es','gl',],
'direct'=>['ro',],
'director'=>['ca','es','gl',],
'direi'=>['it',],
'direita'=>['pt','pt_br',],
'direito'=>['pt','pt_br',],
'direkt'=>['de','sv',],
'direkte'=>['da',],
'diren'=>['eu',],
'direnak'=>['eu',],
'diri'=>['id','ms',],
'diria'=>['ca','pt_br',],
'diriku'=>['ms',],
'dirimu'=>['ms',],
'dirinya'=>['id','ms',],
'diritto'=>['it',],
'dirlo'=>['it',],
'dirmi'=>['it',],
'dirti'=>['it',],
'diré'=>['ca','es',],
'dis'=>['fr',],
'disa'=>['sq',],
'disais'=>['fr',],
'disait'=>['fr',],
'disana'=>['ms',],
'disculpe'=>['es',],
'discurso'=>['gl',],
'disebabkan'=>['id',],
'disebut'=>['id','ms',],
'disent'=>['fr',],
'dish'=>['sq',],
'disini'=>['ms',],
'disk'=>['id',],
'disparu'=>['fr',],
'dispiace'=>['it',],
'dispărut'=>['ro',],
'disse'=>['da','it','nb','no','pt','pt_br',],
'disseram'=>['pt','pt_br',],
'disseste'=>['pt',],
'disso'=>['pt','pt_br',],
'distancia'=>['gl',],
'distintas'=>['gl',],
'distintos'=>['gl',],
'disto'=>['pt','pt_br',],
'dit'=>['af','ca','da','fr','nb','nl','no','sv',],
'dita'=>['sq',],
'dite'=>['sq',],
'ditemukan'=>['id','ms',],
'dites'=>['fr',],
'dito'=>['pt',],
'ditt'=>['nb','no','sv',],
'ditu'=>['eu',],
'ditur'=>['sq',],
'ditut'=>['eu',],
'dituzu'=>['eu',],
'dituzue'=>['eu',],
'dituzun'=>['eu',],
'ditzakegu'=>['eu',],
'ditë'=>['sq',],
'ditën'=>['sq',],
'diu'=>['ca','la',],
'diuen'=>['ca',],
'dius'=>['ca',],
'divas'=>['lv',],
'diventare'=>['it',],
'diverso'=>['it',],
'divertente'=>['it',],
'divertido'=>['es',],
'divertit'=>['ca',],
'divi'=>['lv',],
'divno'=>['bs','hr','sr',],
'divus'=>['lv',],
'divxfinland'=>['fi',],
'dix'=>['fr',],
'dixerunt'=>['la',],
'dixi'=>['la',],
'diximus'=>['la',],
'dixit'=>['la',],
'dixo'=>['gl',],
'diye'=>['tr',],
'diyor'=>['tr',],
'diyorsun'=>['tr',],
'diyorum'=>['tr',],
'diz'=>['pt','pt_br',],
'dizem'=>['pt','pt_br',],
'dizendo'=>['pt','pt_br',],
'dizer'=>['pt','pt_br',],
'dizes'=>['pt',],
'dizu'=>['eu',],
'dizulako'=>['eu',],
'dizut'=>['eu',],
'dizute'=>['eu',],
'diçka'=>['sq',],
'diğer'=>['tr',],
'djali'=>['sq',],
'djalin'=>['sq',],
'djall'=>['sq',],
'djalosh'=>['sq',],
'djalë'=>['sq',],
'dje'=>['sq',],
'djeca'=>['bs','hr',],
'djece'=>['bs','hr',],
'djecu'=>['bs','hr',],
'djem'=>['sq',],
'djema'=>['sq',],
'djemtë'=>['sq',],
'djevojka'=>['bs','hr',],
'djevojke'=>['bs','hr',],
'djevojku'=>['bs','hr',],
'djur'=>['sv',],
'dl'=>['ro',],
'dla'=>['pl',],
'dlaczego'=>['pl',],
'dlatego'=>['pl',],
'dle'=>['ro',],
'dlho'=>['sk',],
'dlouho'=>['cs',],
'dna'=>['si','th','zh',],
'dna样'=>['zh',],
'dna监'=>['zh',],
'dne'=>['cs','sl',],
'dnes'=>['cs','sk',],
'dneska'=>['cs',],
'dni'=>['pl','sk','sl',],
'dnia'=>['pl',],
'dnu'=>['sk',],
'dny'=>['cs',],
'dní'=>['cs','sk',],
'do'=>['bs','cs','en','fa','gl','hr','it','pl','pt','pt_br','si','sk','sl','sq','sr','th',],
'doamna'=>['ro',],
'doamne'=>['ro',],
'doamnelor'=>['ro',],
'doamnă'=>['ro',],
'doar'=>['ro',],
'dobar'=>['bs','hr','sr',],
'dobbiamo'=>['it',],
'dober'=>['sl',],
'dobil'=>['sl',],
'dobila'=>['sl',],
'dobili'=>['bs','sl',],
'dobim'=>['sl',],
'dobio'=>['bs','hr','sr',],
'dobiti'=>['bs','hr','sl','sr',],
'dobiš'=>['sl',],
'dobra'=>['bs','hr','pl','sl','sr',],
'dobranoc'=>['pl',],
'dobre'=>['bs','hr','pl','sk','sl','sr',],
'dobrej'=>['cs',],
'dobri'=>['bs','hr','sl','sr',],
'dobro'=>['bs','hr','sl','sr',],
'dobrodošli'=>['sl',],
'dobrou'=>['cs',],
'dobry'=>['pl',],
'dobrym'=>['pl',],
'dobrze'=>['pl',],
'dobrá'=>['cs','sk',],
'dobré'=>['cs','sk',],
'dobrú'=>['sk',],
'dobrý'=>['cs','sk',],
'dobu'=>['cs',],
'doby'=>['cs',],
'dobře'=>['cs',],
'doce'=>['gl',],
'docela'=>['cs',],
'doch'=>['de',],
'dochter'=>['nl',],
'docteur'=>['fr',],
'doctor'=>['ca','en','es','ro','si',],
'doctore'=>['ro',],
'dod'=>['lv',],
'dodas'=>['lv',],
'doden'=>['nl',],
'dodies'=>['lv',],
'doe'=>['nl',],
'doel'=>['af','nl',],
'doen'=>['af','nl',],
'doente'=>['pt','pt_br',],
'does'=>['en',],
'doesn'=>['en','si','th',],
'doet'=>['nl',],
'dog'=>['da','en','sv',],
'dogaja'=>['sl',],
'događa'=>['bs','hr',],
'dogaрa'=>['hr','sr',],
'dogodilo'=>['bs','hr','sr',],
'dogoditi'=>['hr',],
'doi'=>['ro',],
'doing'=>['en','si','th',],
'dois'=>['fr','pt','pt_br',],
'doista'=>['hr',],
'doit'=>['fr',],
'doivent'=>['fr',],
'doja'=>['sq',],
'doje'=>['sq',],
'dok'=>['bs','hr','lv','sr',],
'dokler'=>['sl',],
'dokonca'=>['sk',],
'dokonce'=>['cs',],
'dokter'=>['af','ms','nl',],
'doktor'=>['bs','cs','da','de','et','hr','hu','lv','nb','no','pl','sk','sl','sq','sr','tr',],
'doktore'=>['bs','cs','hr','sr',],
'doktorn'=>['sv',],
'doktorze'=>['pl',],
'dokud'=>['cs',],
'dokąd'=>['pl',],
'dokładnie'=>['pl',],
'dol'=>['sl',],
'dolar'=>['id','ms','tr',],
'dolara'=>['bs','hr','sr',],
'dolari'=>['ro',],
'dolarjev'=>['sl',],
'dolarów'=>['pl',],
'dolarů'=>['cs',],
'dolayı'=>['tr',],
'dolaze'=>['bs','hr','sr',],
'dolazi'=>['bs','hr','sr',],
'dolazim'=>['bs','hr','sr',],
'dole'=>['bs','cs','sk','sr',],
'dolent'=>['ca',],
'dolerių'=>['lt',],
'dolgo'=>['sl',],
'dolgok'=>['hu',],
'dolgokat'=>['hu',],
'dolgom'=>['hu',],
'dolgot'=>['hu',],
'dolgozik'=>['hu',],
'dolgozni'=>['hu',],
'doli'=>['sq',],
'dolje'=>['bs','hr',],
'dollar'=>['de','nb','nl','no','sv',],
'dollari'=>['it',],
'dollaria'=>['fi',],
'dollarit'=>['et',],
'dollars'=>['da','fr',],
'dollarë'=>['sq',],
'dollár'=>['hu',],
'dolog'=>['hu',],
'dolor'=>['es',],
'dolore'=>['it','la',],
'dolu'=>['sk','tr',],
'dolárov'=>['sk',],
'dolāru'=>['lv',],
'dolů'=>['cs',],
'dom'=>['af','nl','pl','sk','sl','sv',],
'doma'=>['cs','hr','lv','sk','sl',],
'domanda'=>['it',],
'domande'=>['it',],
'domani'=>['it',],
'dome'=>['sk',],
'domi'=>['la',],
'domine'=>['la',],
'domingo'=>['gl',],
'domini'=>['la',],
'domino'=>['la',],
'dominum'=>['la',],
'dominus'=>['la',],
'domnilor'=>['ro',],
'domnul'=>['ro',],
'domnule'=>['ro',],
'domnului'=>['ro',],
'domo'=>['la',],
'domov'=>['sk','sl',],
'domu'=>['cs','pl','sk',],
'domum'=>['la',],
'domus'=>['la',],
'domā'=>['lv',],
'domājat'=>['lv',],
'domāju'=>['lv',],
'domāt'=>['lv',],
'domě'=>['cs',],
'domů'=>['cs',],
'don'=>['en','es','fa','gl','ms','si','sq','th',],
'dona'=>['ca','gl',],
'donar'=>['ca',],
'donaré'=>['ca',],
'donat'=>['ca',],
'donc'=>['fr',],
'doncs'=>['ca',],
'donde'=>['es',],
'done'=>['en',],
'donec'=>['la',],
'dones'=>['ca',],
'doni'=>['sq',],
'donkey'=>['si',],
'donna'=>['it','lv',],
'donne'=>['fr','it',],
'donner'=>['fr',],
'donné'=>['fr',],
'dont'=>['fr',],
'donte'=>['sq',],
'dood'=>['af','nl',],
'doodmaak'=>['af',],
'door'=>['en','nl',],
'dopiero'=>['pl',],
'dopo'=>['it',],
'dopóki'=>['pl',],
'dor'=>['pt','pt_br','ro',],
'doresc'=>['ro',],
'dori'=>['ro',],
'dormi'=>['ro',],
'dormir'=>['ca','es','fr','pt','pt_br',],
'dormire'=>['it',],
'dorstige'=>['af',],
'dort'=>['de',],
'dorë'=>['sq',],
'dorën'=>['sq',],
'dos'=>['ca','es','fr','gl','pt','pt_br',],
'dost'=>['cs',],
'dosta'=>['bs','hr','sr',],
'dostal'=>['cs','sk',],
'dostala'=>['cs','sk',],
'dostali'=>['cs','sk',],
'dostane'=>['cs','sk',],
'dostanem'=>['sk',],
'dostanu'=>['cs',],
'dostat'=>['cs',],
'dostać'=>['pl',],
'dostať'=>['sk',],
'dostum'=>['tr',],
'dosť'=>['sk',],
'dot'=>['sq',],
'doties'=>['lv',],
'dotter'=>['sv',],
'dottor'=>['it',],
'dottore'=>['it',],
'doua'=>['ro',],
'doucement'=>['fr',],
'doufám'=>['cs',],
'dous'=>['gl',],
'doute'=>['fr',],
'doutor'=>['pt','pt_br',],
'două'=>['ro',],
'dov'=>['it',],
'dove'=>['it',],
'dovete'=>['it',],
'doveva'=>['it',],
'dovevo'=>['it',],
'dovnitř'=>['cs',],
'dovolj'=>['sl',],
'dovoljno'=>['bs','hr','sr',],
'dovraga'=>['bs','hr',],
'dovrebbe'=>['it',],
'dovrei'=>['it',],
'dovremmo'=>['it',],
'dovresti'=>['it',],
'dovuto'=>['it',],
'down'=>['en','si',],
'doy'=>['es',],
'doći'=>['bs','hr',],
'dođe'=>['hr',],
'dođi'=>['bs','hr',],
'doğru'=>['tr',],
'doğum'=>['tr',],
'dość'=>['pl',],
'došao'=>['bs','hr',],
'došla'=>['bs','hr',],
'došli'=>['bs','hr',],
'došos'=>['lv',],
'doжi'=>['bs','sr',],
'doрavola'=>['sr',],
'doрe'=>['sr',],
'doрi'=>['bs','hr','sr',],
'doљao'=>['bs','sr',],
'doљla'=>['sr',],
'doљli'=>['sr',],
'dr'=>['bs','ca','cs','da','es','et','fr','hr','hu','id','is','lt','lv','ms','nb','nl','no','pl','pt','pt_br','ro','si','sk','sl','sq','sr','sv','tr',],
'dra'=>['af','nb','no','sv',],
'dracu'=>['ro',],
'dracului'=>['ro',],
'draga'=>['bs','hr','ro','sl','sr',],
'dragen'=>['nl',],
'dragi'=>['bs','hr','sl','sr',],
'drago'=>['bs','hr','sr',],
'dragon'=>['si',],
'dragoste'=>['ro',],
'dragostea'=>['ro',],
'dragă'=>['ro',],
'drahá'=>['cs','sk',],
'drake'=>['id',],
'dramatiese'=>['af',],
'dran'=>['de',],
'drap'=>['is',],
'drar'=>['nb','no','sv',],
'drauf'=>['de',],
'draugai'=>['lt',],
'draugas'=>['lt',],
'drauge'=>['lt',],
'draugi'=>['lv',],
'draugs'=>['lv',],
'draugu'=>['lv',],
'drauguži'=>['lt',],
'draußen'=>['de',],
'dream'=>['en',],
'dreams'=>['en',],
'dreapta'=>['ro',],
'drei'=>['de',],
'drejt'=>['sq',],
'drejtë'=>['sq',],
'drekka'=>['is',],
'dreng'=>['da',],
'drenge'=>['da',],
'drengur'=>['is',],
'drep'=>['nb','no',],
'drepa'=>['is',],
'drepe'=>['nb','no',],
'dreper'=>['nb','no',],
'drepið'=>['is',],
'drept'=>['nb','no','ro',],
'dreptate'=>['ro',],
'drepte'=>['nb','no',],
'dreptul'=>['ro',],
'drepur'=>['is',],
'dreq'=>['sq',],
'dreqi'=>['sq',],
'dreqin'=>['sq',],
'dress'=>['en',],
'dret'=>['ca',],
'dreta'=>['ca',],
'dricka'=>['sv',],
'drie'=>['nl',],
'drikke'=>['da','nb','no',],
'drikker'=>['nb',],
'drin'=>['de',],
'drink'=>['da','en','nb','no','sv',],
'drinken'=>['nl',],
'dritt'=>['nb','no',],
'drittsekk'=>['nb','no',],
'drive'=>['en',],
'driver'=>['nb','no',],
'dro'=>['nb','no',],
'drodze'=>['pl',],
'droga'=>['pl','pt','pt_br',],
'drogi'=>['pl',],
'drogę'=>['pl',],
'droit'=>['fr',],
'droite'=>['fr',],
'dromen'=>['nl',],
'dronken'=>['nl',],
'droom'=>['nl',],
'drop'=>['en',],
'drottinn'=>['is',],
'droši'=>['lv',],
'drošs'=>['lv',],
'drošībā'=>['lv',],
'drug'=>['sl',],
'druga'=>['bs','hr','sl','sr',],
'drugače'=>['sl',],
'druge'=>['bs','hr','sl','sr',],
'drugega'=>['sl',],
'drugi'=>['bs','hr','pl','sl','sr',],
'drugiej'=>['pl',],
'drugo'=>['bs','hr','sl','sr',],
'drugog'=>['bs','hr','sr',],
'drugom'=>['bs','hr','sr',],
'drugs'=>['nl',],
'drugu'=>['bs','hr','sr',],
'druhej'=>['sk',],
'druhé'=>['cs',],
'druhý'=>['cs','sk',],
'druk'=>['nl',],
'drukkie'=>['af',],
'drum'=>['ro',],
'drumul'=>['ro',],
'drunk'=>['en',],
'družina'=>['sl',],
'družino'=>['sl',],
'druљtvo'=>['sr',],
'druћe'=>['sr',],
'dryf'=>['af',],
'drzwi'=>['pl',],
'drága'=>['hu',],
'drágám'=>['hu',],
'dræbe'=>['da',],
'dræber'=>['da',],
'dræbt'=>['da',],
'dræbte'=>['da',],
'drôle'=>['fr',],
'dröm'=>['sv',],
'drøm'=>['da','nb','no',],
'drüben'=>['de',],
'drăguţ'=>['ro',],
'drăguţă'=>['ro',],
'drīkstu'=>['lv',],
'drīz'=>['lv',],
'drž'=>['cs','sk',],
'drži'=>['bs','hr','sl',],
'drћi'=>['sr',],
'du'=>['da','de','eu','fr','lt','nb','no','sv',],
'dua'=>['id','ms','sq','tr',],
'duam'=>['sq',],
'duan'=>['sq',],
'duart'=>['sq',],
'duas'=>['la','pt','pt_br',],
'duash'=>['sq',],
'dubbel'=>['af',],
'dubte'=>['ca',],
'duc'=>['ro',],
'duce'=>['ro',],
'duci'=>['ro',],
'dudan'=>['eu',],
'dude'=>['en',],
'duduk'=>['id','ms',],
'due'=>['it',],
'duela'=>['eu',],
'duen'=>['eu',],
'duena'=>['eu',],
'duenez'=>['eu',],
'dues'=>['ca',],
'dugo'=>['bs','hr','sr',],
'dugu'=>['eu',],
'duhej'=>['sq',],
'duhen'=>['sq',],
'duhet'=>['sq',],
'duhur'=>['sq',],
'duidelijk'=>['nl',],
'duidelik'=>['af',],
'duisende'=>['af',],
'duiwel'=>['af',],
'duiwels'=>['af',],
'duke'=>['sq',],
'dukesh'=>['sq',],
'duket'=>['sq',],
'duktig'=>['sv',],
'dulce'=>['es',],
'dulu'=>['ms',],
'dum'=>['da','la','nb','no','sv',],
'dumm'=>['de',],
'dumme'=>['da','nb','no',],
'dumneavoastră'=>['ro',],
'dumnezeu'=>['ro',],
'dumnezeule'=>['ro',],
'dumt'=>['nb',],
'dun'=>['gl',],
'dunha'=>['gl',],
'dunia'=>['id','ms',],
'duo'=>['la',],
'duobus'=>['la',],
'duok'=>['lt',],
'duos'=>['la',],
'duoti'=>['lt',],
'dupa'=>['ro',],
'dupe'=>['bs','sr',],
'după'=>['ro',],
'dur'=>['ca','fr','tr',],
'durant'=>['ca',],
'durante'=>['es','gl','it','pt','pt_br',],
'durch'=>['de',],
'during'=>['en',],
'duris'=>['lt',],
'duro'=>['es','it','pt_br',],
'durum'=>['tr',],
'durumda'=>['tr',],
'durumu'=>['tr',],
'durun'=>['tr',],
'durvis'=>['lv',],
'durvīm'=>['lv',],
'durys'=>['lt',],
'durų'=>['lt',],
'dus'=>['af','nl','ro',],
'dut'=>['eu',],
'dute'=>['eu',],
'duurt'=>['nl',],
'duydum'=>['tr',],
'duydun'=>['tr',],
'duyuyor'=>['tr',],
'duzu'=>['eu',],
'duzue'=>['eu',],
'duzuela'=>['eu',],
'duzula'=>['eu',],
'duzulako'=>['eu',],
'duzun'=>['eu',],
'duzunean'=>['eu',],
'dušo'=>['bs','hr',],
'dużo'=>['pl',],
'duљo'=>['bs','hr','sr',],
'dv'=>['ro',],
'dva'=>['bs','cs','hr','sk','sl','sr',],
'dvaja'=>['sk',],
'dvd'=>['th',],
'dve'=>['sk','sl','sr',],
'dveh'=>['sl',],
'dvere'=>['sk',],
'dveře'=>['cs',],
'dvi'=>['lt',],
'dviejų'=>['lt',],
'dvije'=>['bs','hr',],
'dvoch'=>['sk',],
'dvoje'=>['bs','hr','sr',],
'dvs'=>['ro',],
'dvě'=>['cs',],
'dwa'=>['pl',],
'dwaas'=>['af',],
'dwie'=>['pl',],
'dwing'=>['af',],
'dwóch'=>['pl',],
'dy'=>['sq',],
'dyr'=>['da','nb','no',],
'dyrnar'=>['is',],
'dytë'=>['sq',],
'działa'=>['pl',],
'dzieci'=>['pl',],
'dziecko'=>['pl',],
'dzieje'=>['pl',],
'dziewczyna'=>['pl',],
'dziewczyny'=>['pl',],
'dziewczynę'=>['pl',],
'dzień'=>['pl',],
'dzimšanas'=>['lv',],
'dzirdi'=>['lv',],
'dzirdējis'=>['lv',],
'dzirdēju'=>['lv',],
'dzirdēt'=>['lv',],
'dzisiaj'=>['pl',],
'dziwne'=>['pl',],
'dzięki'=>['pl',],
'dziękuję'=>['pl',],
'dziś'=>['pl',],
'dzīve'=>['lv',],
'dzīves'=>['lv',],
'dzīvi'=>['lv',],
'dzīvo'=>['lv',],
'dzīvot'=>['lv',],
'dzīvs'=>['lv',],
'dzīvē'=>['lv',],
'dzīvību'=>['lv',],
'dá'=>['cs','gl','pt','pt_br','sk',],
'dáinn'=>['is',],
'dál'=>['cs',],
'dálítið'=>['is',],
'dám'=>['cs','sk',],
'dáme'=>['cs',],
'dámy'=>['cs','sk',],
'dát'=>['cs',],
'dávaj'=>['sk',],
'dávno'=>['cs','sk',],
'dáš'=>['sk',],
'där'=>['sv',],
'därför'=>['sv',],
'då'=>['sv',],
'dålig'=>['sv',],
'dåligt'=>['sv',],
'dårlig'=>['da','nb','no',],
'dårligt'=>['da',],
'dès'=>['fr',],
'début'=>['fr',],
'décidé'=>['fr',],
'déjame'=>['es',],
'déjeuner'=>['fr',],
'déjà'=>['fr',],
'dér'=>['da',],
'désolé'=>['fr',],
'désolée'=>['fr',],
'déteste'=>['fr',],
'déu'=>['ca',],
'dê'=>['pt','pt_br',],
'dëgjo'=>['sq',],
'dëgjoj'=>['sq',],
'dëgjon'=>['sq',],
'dëgjoni'=>['sq',],
'dëgjova'=>['sq',],
'dëgjuar'=>['sq',],
'dërguar'=>['sq',],
'dëshiroj'=>['sq',],
'dëshiron'=>['sq',],
'dëshironi'=>['sq',],
'dí'=>['it',],
'día'=>['es','gl',],
'días'=>['es','gl',],
'díky'=>['cs',],
'dítě'=>['cs',],
'dîner'=>['fr',],
'dòlars'=>['ca',],
'dó'=>['is',],
'dólares'=>['es','pt','pt_br',],
'dóna'=>['ca',],
'dónde'=>['es',],
'dóttur'=>['is',],
'dół'=>['pl',],
'dôležité'=>['sk',],
'dôvod'=>['sk',],
'dö'=>['sv',],
'död'=>['sv',],
'döda'=>['sv',],
'dödade'=>['sv',],
'dödar'=>['sv',],
'dödat'=>['sv',],
'döden'=>['sv',],
'dön'=>['tr',],
'dör'=>['sv',],
'dörren'=>['sv',],
'dört'=>['tr',],
'dövlət'=>['az',],
'dø'=>['da','nb','no',],
'død'=>['da','nb','no',],
'døde'=>['da','nb','no',],
'døden'=>['da','nb','no',],
'dør'=>['da','nb','no',],
'døra'=>['nb','no',],
'døren'=>['da','nb','no',],
'dúas'=>['gl',],
'dúbida'=>['gl',],
'dúfam'=>['sk',],
'dû'=>['fr',],
'dün'=>['tr',],
'dünya'=>['az','tr',],
'dünyanın'=>['tr',],
'dürfen'=>['de',],
'dürüst'=>['tr',],
'düz'=>['az',],
'düşün'=>['tr',],
'düşündüm'=>['tr',],
'düşünüyor'=>['tr',],
'düşünüyorsun'=>['tr',],
'düşünüyorum'=>['tr',],
'dāmas'=>['lv',],
'dārgais'=>['lv',],
'dārgā'=>['lv',],
'dă'=>['ro',],
'dăm'=>['ro',],
'dēls'=>['lv',],
'dēļ'=>['lv',],
'dėi'=>['lt',],
'dėkoju'=>['lt',],
'dėkui'=>['lt',],
'dėl'=>['lt',],
'dėmesio'=>['lt',],
'děje'=>['cs',],
'děkuji'=>['cs',],
'děkuju'=>['cs',],
'dělají'=>['cs',],
'dělal'=>['cs',],
'dělat'=>['cs',],
'dělej'=>['cs',],
'dělá'=>['cs',],
'dělám'=>['cs',],
'děláte'=>['cs',],
'děláš'=>['cs',],
'děti'=>['cs',],
'dīvaini'=>['lv',],
'dışarı'=>['tr',],
'dışarıda'=>['tr',],
'dışında'=>['tr',],
'długo'=>['pl',],
'dłużej'=>['pl',],
'dňa'=>['sk',],
'dřív'=>['cs',],
'důležité'=>['cs',],
'dům'=>['cs',],
'důvod'=>['cs',],
'džeik'=>['lv',],
'džeims'=>['lv',],
'džek'=>['lv',],
'džekai'=>['lt',],
'džeks'=>['lv',],
'džiaugiuosi'=>['lt',],
'džo'=>['lt',],
'džon'=>['lv',],
'džonai'=>['lt',],
'džonas'=>['lt',],
'džordžai'=>['lt',],
'də'=>['az',],
'dəfə'=>['az',],
'dəyişdir'=>['az',],
'dћek'=>['sr',],
'e'=>['bs','ca','da','de','en','es','fi','fr','gl','hr','hu','id','is','it','la','lt','ms','nb','nl','no','pl','pt','pt_br','ro','si','sk','sl','sq','sr','sv','th','tr','zh_tw',],
'ea'=>['la','ro',],
'each'=>['en','th',],
'eadem'=>['la',],
'eam'=>['la',],
'early'=>['en',],
'earth'=>['en','th',],
'earum'=>['la',],
'eas'=>['la',],
'easy'=>['en',],
'eat'=>['en',],
'eau'=>['fr',],
'ebben'=>['hu',],
'ebből'=>['hu',],
'eben'=>['de',],
'ec'=>['sq',],
'ecce'=>['la',],
'ecco'=>['it',],
'echipa'=>['ro',],
'echt'=>['de','nl',],
'echte'=>['nl',],
'economía'=>['gl',],
'económica'=>['gl',],
'económico'=>['gl',],
'ecoute'=>['fr',],
'ecoutez'=>['fr',],
'ed'=>['it',],
'edad'=>['es',],
'edan'=>['eu',],
'edasi'=>['et',],
'edat'=>['ca',],
'eddie'=>['is',],
'eddig'=>['hu',],
'edebilir'=>['tr',],
'edecek'=>['tr',],
'edeceğim'=>['tr',],
'edel'=>['af',],
'eden'=>['sl','tr',],
'eder'=>['tr',],
'ederim'=>['tr',],
'ederto'=>['eu',],
'edes'=>['fi',],
'edessä'=>['fi',],
'edhe'=>['sq',],
'edib'=>['az',],
'edición'=>['gl',],
'edin'=>['tr',],
'edina'=>['sl',],
'edini'=>['sl',],
'edir'=>['az',],
'ediyor'=>['tr',],
'ediyorsun'=>['tr',],
'ediyorum'=>['tr',],
'edo'=>['eu',],
'edonora'=>['eu',],
'educación'=>['gl',],
'education'=>['si',],
'eduki'=>['eu',],
'edukiko'=>['eu',],
'edən'=>['az',],
'ee'=>['et',],
'eemale'=>['et',],
'een'=>['af','nl',],
'eens'=>['af','nl',],
'eensaam'=>['af',],
'eensame'=>['af',],
'eentje'=>['nl',],
'eer'=>['af','nl',],
'eerder'=>['nl',],
'eerlijk'=>['nl',],
'eerlik'=>['af',],
'eers'=>['af',],
'eerst'=>['nl',],
'eerste'=>['af','nl',],
'ees'=>['et',],
'eest'=>['et',],
'eet'=>['nl',],
'eeu'=>['af',],
'ef'=>['is',],
'efecto'=>['gl',],
'efek'=>['id',],
'efendim'=>['tr',],
'effet'=>['fr',],
'efisien'=>['id',],
'efter'=>['da','no','sv',],
'eftersom'=>['sv',],
'eftir'=>['is',],
'eg'=>['is',],
'ega'=>['et',],
'egal'=>['de',],
'egen'=>['da','nb','no','sv',],
'egentlig'=>['nb','no',],
'egentligen'=>['sv',],
'eget'=>['da','nb','no','sv',],
'egia'=>['eu',],
'egin'=>['eu',],
'eginda'=>['eu',],
'egingo'=>['eu',],
'egitea'=>['eu',],
'egiten'=>['eu',],
'egna'=>['sv',],
'egne'=>['da','nb','no',],
'ego'=>['la',],
'egon'=>['eu',],
'egongo'=>['eu',],
'egoten'=>['eu',],
'egun'=>['eu',],
'egunean'=>['eu',],
'egunero'=>['eu',],
'egunetan'=>['eu',],
'egy'=>['hu',],
'egyedül'=>['hu',],
'egyes'=>['hu',],
'egyet'=>['hu',],
'egyetlen'=>['hu',],
'egyik'=>['hu',],
'egymást'=>['hu',],
'egyre'=>['hu',],
'egyszer'=>['hu',],
'egyszerű'=>['hu',],
'egyszerűen'=>['hu',],
'egyáltalán'=>['hu',],
'egyébként'=>['hu',],
'együtt'=>['hu',],
'egész'=>['hu',],
'egészen'=>['hu',],
'egészet'=>['hu',],
'eh'=>['ca','en','es','fr','id','it','ms',],
'eher'=>['de',],
'ehhez'=>['hu',],
'ehi'=>['it',],
'ehk'=>['et',],
'ehkä'=>['fi',],
'ehrlich'=>['de',],
'ehunduta'=>['eu',],
'ei'=>['ca','es','et','fi','la','lt','lv','nb','no','pt','pt_br','ro',],
'eie'=>['af',],
'eier'=>['nb',],
'eiers'=>['af',],
'eiga'=>['is',],
'eigen'=>['nl',],
'eigenen'=>['de',],
'eigenlijk'=>['nl',],
'eigentlich'=>['de',],
'eight'=>['en',],
'eigin'=>['is',],
'eiginlega'=>['is',],
'eigið'=>['is',],
'eigum'=>['is',],
'eihän'=>['fi',],
'eik'=>['lt',],
'eikit'=>['lt',],
'eikite'=>['lt',],
'eikä'=>['fi',],
'eikö'=>['fi',],
'eikš'=>['lt',],
'eiland'=>['af',],
'eile'=>['et',],
'eilen'=>['fi',],
'eime'=>['lt',],
'ein'=>['de','is',],
'eina'=>['is','lt',],
'einam'=>['lt',],
'eind'=>['nl',],
'einde'=>['af','nl',],
'eindelijk'=>['nl',],
'eindig'=>['af',],
'eine'=>['de',],
'einem'=>['de',],
'einen'=>['de',],
'einer'=>['de',],
'eines'=>['de',],
'einfach'=>['de',],
'einhver'=>['is',],
'einhverju'=>['is',],
'einhverjum'=>['is',],
'einhvern'=>['is',],
'einhvers'=>['is',],
'eini'=>['is','lt',],
'einige'=>['de',],
'einmal'=>['de',],
'einmitt'=>['is',],
'einn'=>['is',],
'eins'=>['de','is',],
'einstein'=>['id',],
'eintlik'=>['af',],
'einu'=>['is','lt',],
'einum'=>['is',],
'einzige'=>['de',],
'eis'=>['la',],
'eisiu'=>['lt',],
'either'=>['en',],
'eiti'=>['lt',],
'eitt'=>['is',],
'eitthvað'=>['is',],
'eius'=>['la',],
'eiusdem'=>['la',],
'eivät'=>['fi',],
'ej'=>['da','lv','sq',],
'eja'=>['sq',],
'ejam'=>['lv',],
'ejani'=>['sq',],
'ejiet'=>['lv',],
'eju'=>['lv',],
'ejército'=>['es',],
'ek'=>['af',],
'ekarri'=>['eu',],
'ekarriko'=>['eu',],
'ekialdeko'=>['eu',],
'ekkert'=>['is',],
'ekki'=>['is',],
'ekonomi'=>['id',],
'eks'=>['et',],
'ekstrim'=>['id',],
'ekte'=>['nb','no',],
'ekziston'=>['sq',],
'el'=>['ca','es','gl','hu','ro','tr',],
'ela'=>['gl','pt','pt_br',],
'elab'=>['et',],
'elada'=>['et',],
'elas'=>['gl','pt','pt_br',],
'elastative'=>['si',],
'elbette'=>['tr',],
'eld'=>['sv',],
'ele'=>['pt','pt_br','ro','tr','zh_tw',],
'eleccións'=>['gl',],
'electoral'=>['gl',],
'element'=>['af',],
'elementos'=>['gl',],
'eles'=>['gl','pt','pt_br',],
'eli'=>['fi',],
'elif'=>['az',],
'elk'=>['af','nl',],
'elkaar'=>['nl',],
'elkarrekin'=>['eu',],
'elke'=>['af','nl',],
'ell'=>['ca',],
'ella'=>['ca','es',],
'ellas'=>['es',],
'elle'=>['fr',],
'ellen'=>['hu',],
'eller'=>['da','nb','no','sv',],
'ellers'=>['da','nb','no',],
'elles'=>['fr',],
'ellie'=>['id',],
'ello'=>['es',],
'ellos'=>['es',],
'ells'=>['ca',],
'ellu'=>['et',],
'ellē'=>['lv',],
'elmegyek'=>['hu',],
'elment'=>['hu',],
'elnézést'=>['hu',],
'elnök'=>['hu',],
'elossa'=>['fi',],
'els'=>['ca',],
'else'=>['en',],
'elska'=>['is',],
'elskan'=>['is',],
'elskar'=>['is',],
'elske'=>['da','nb','no',],
'elskede'=>['da',],
'elsker'=>['da','nb','no',],
'elsket'=>['nb','no',],
'első'=>['hu',],
'eltern'=>['de',],
'eltűnt'=>['hu',],
'elu'=>['et',],
'elus'=>['et',],
'elämä'=>['fi',],
'elämäni'=>['fi',],
'elää'=>['fi',],
'elég'=>['hu',],
'elő'=>['hu',],
'előbb'=>['hu',],
'előre'=>['hu',],
'először'=>['hu',],
'előtt'=>['hu',],
'elə'=>['az',],
'em'=>['ca','pt','pt_br',],
'ema'=>['et',],
'emadazue'=>['eu',],
'email'=>['ms',],
'emakume'=>['eu',],
'eman'=>['eu',],
'emanaldia'=>['eu',],
'emango'=>['eu',],
'emas'=>['id','ms',],
'ematen'=>['eu',],
'emaztea'=>['eu',],
'embaixo'=>['pt_br',],
'embargo'=>['gl',],
'ember'=>['hu',],
'emberek'=>['hu',],
'embereket'=>['hu',],
'emberi'=>['hu',],
'embert'=>['hu',],
'embora'=>['pt','pt_br',],
'emily'=>['si',],
'emin'=>['tr',],
'eminim'=>['tr',],
'emlékszel'=>['hu',],
'emlékszem'=>['hu',],
'emme'=>['et','fi',],
'emot'=>['sv',],
'empat'=>['id','ms',],
'empezar'=>['es',],
'emprego'=>['gl','pt','pt_br',],
'empresa'=>['gl',],
'empresas'=>['gl',],
'emri'=>['sq',],
'emrin'=>['sq',],
'emër'=>['sq',],
'en'=>['af','az','ca','da','es','fi','fr','gl','is','nb','nl','no','sl','sv','tr',],
'ena'=>['sl',],
'enak'=>['ms',],
'enako'=>['sl',],
'enam'=>['et','id','ms',],
'encanta'=>['es',],
'encara'=>['ca',],
'encima'=>['es',],
'encontrado'=>['es',],
'encontrar'=>['es','pt','pt_br',],
'encontrei'=>['pt','pt_br',],
'encontro'=>['gl','pt','pt_br',],
'encontrou'=>['pt_br',],
'encontré'=>['es',],
'encore'=>['fr',],
'encuentra'=>['es',],
'end'=>['da','en','et','no',],
'enda'=>['et','is','nb','no','sv',],
'endale'=>['et',],
'endast'=>['et',],
'endavant'=>['ca',],
'ende'=>['da','de','sq',],
'endelig'=>['da','nb','no',],
'endij'=>['lv',],
'endlich'=>['de',],
'endnu'=>['da',],
'endroit'=>['fr',],
'ene'=>['da','nb','nl','no',],
'enega'=>['sl',],
'enemic'=>['ca',],
'enemmän'=>['fi',],
'energi'=>['id',],
'energia'=>['ca',],
'enerxía'=>['gl',],
'eneste'=>['da','nb','no',],
'enfant'=>['fr',],
'enfants'=>['fr',],
'enfer'=>['fr',],
'enfin'=>['fr',],
'eng'=>['si',],
'enga'=>['is',],
'engan'=>['is',],
'engang'=>['da','nb','no',],
'engar'=>['is',],
'engedd'=>['hu',],
'engel'=>['af',],
'engem'=>['hu',],
'engin'=>['is',],
'engineer'=>['si',],
'engineering'=>['si',],
'enginn'=>['is',],
'english'=>['en',],
'engraçado'=>['pt','pt_br',],
'engu'=>['is',],
'enhancement'=>['si',],
'enhver'=>['da',],
'enige'=>['af','nl',],
'enigiets'=>['af',],
'enigste'=>['af',],
'enim'=>['la',],
'enjoy'=>['en','si',],
'enkel'=>['nl',],
'enkele'=>['af','nl',],
'enkelt'=>['nb','no','sv',],
'enkrat'=>['sl',],
'enkä'=>['fi',],
'enlightment'=>['si',],
'enligt'=>['sv',],
'enn'=>['is','nb','no',],
'ennast'=>['et',],
'enne'=>['et',],
'ennek'=>['hu',],
'ennen'=>['fi',],
'ennuis'=>['fr',],
'ennyi'=>['hu',],
'ennyire'=>['hu',],
'ennå'=>['nb','no',],
'ennél'=>['hu',],
'ennþá'=>['is',],
'eno'=>['sl',],
'enostavno'=>['sl',],
'enough'=>['en','si',],
'enquanto'=>['pt','pt_br',],
'enrere'=>['ca',],
'enriba'=>['gl',],
'ens'=>['af','ca','sv',],
'ensam'=>['sv',],
'enseguida'=>['es',],
'ensemble'=>['fr',],
'ensenyar'=>['ca',],
'ensi'=>['fi',],
'ensimmäinen'=>['fi',],
'ensin'=>['fi',],
'ensuite'=>['fr',],
'entenc'=>['ca',],
'entende'=>['pt_br',],
'entender'=>['gl','pt_br',],
'entendeu'=>['pt_br',],
'entendi'=>['pt_br',],
'entendido'=>['es',],
'entendo'=>['pt','pt_br',],
'entendre'=>['fr',],
'entends'=>['fr',],
'entendu'=>['fr',],
'entens'=>['ca',],
'entesos'=>['ca',],
'entiendes'=>['es',],
'entiendo'=>['es',],
'entire'=>['en',],
'entonces'=>['es',],
'entra'=>['es','it','pt',],
'entrada'=>['gl',],
'entrambi'=>['it',],
'entrar'=>['ca','es','gl','pt','pt_br',],
'entrare'=>['it',],
'entre'=>['ca','es','fr','gl','pt','pt_br',],
'entrer'=>['fr',],
'entrez'=>['fr',],
'entschuldige'=>['de',],
'entschuldigen'=>['de',],
'entschuldigung'=>['de',],
'entzun'=>['eu',],
'entzuten'=>['eu',],
'então'=>['pt','pt_br',],
'entä'=>['fi',],
'entón'=>['gl',],
'enviar'=>['ca',],
'envie'=>['fr',],
'envoie'=>['fr',],
'envoyé'=>['fr',],
'enyém'=>['hu',],
'enää'=>['fi',],
'eo'=>['la',],
'eodem'=>['la',],
'eorum'=>['la',],
'eos'=>['la',],
'episcopus'=>['la',],
'epo'=>['sq',],
'equidem'=>['la',],
'equip'=>['ca',],
'equipa'=>['pt',],
'equipe'=>['pt_br',],
'equipo'=>['es','gl',],
'equites'=>['la',],
'equitum'=>['la',],
'er'=>['da','de','is','nb','nl','no','sv',],
'era'=>['ca','es','eu','gl','it','pt','pt_br','ro','sv',],
'eraan'=>['nl',],
'erabaki'=>['eu',],
'erabili'=>['eu',],
'erabiliko'=>['eu',],
'erabiltezina'=>['eu',],
'erabiltzen'=>['eu',],
'erai'=>['ro',],
'erakusketa'=>['eu',],
'erakustaldiaren'=>['eu',],
'erakutsi'=>['eu',],
'eram'=>['pt','pt_br','ro',],
'eraman'=>['eu',],
'eramango'=>['eu',],
'eramateko'=>['eu',],
'eran'=>['es','gl',],
'erano'=>['it',],
'erant'=>['la',],
'erantzun'=>['eu',],
'erantzuna'=>['eu',],
'eras'=>['es',],
'erat'=>['la',],
'erau'=>['ro',],
'eravamo'=>['it',],
'erbij'=>['nl',],
'erde'=>['de',],
'erdha'=>['sq',],
'erdhe'=>['sq',],
'erdhi'=>['sq',],
'erditu'=>['eu',],
'erdiz'=>['eu',],
'ere'=>['af','eu',],
'eren'=>['ca',],
'eres'=>['ca','es',],
'erfitt'=>['is',],
'erg'=>['af','nl',],
'ergela'=>['eu',],
'ergens'=>['nl',],
'erger'=>['nl',],
'ergo'=>['la',],
'eri'=>['fi','it',],
'eric'=>['ca',],
'erin'=>['nl',],
'erinnere'=>['de',],
'erinnern'=>['de',],
'erit'=>['la',],
'eriti'=>['et',],
'erittäin'=>['fi',],
'erkek'=>['tr',],
'erken'=>['tr',],
'erklären'=>['de',],
'ermee'=>['nl',],
'ernest'=>['ca',],
'ernst'=>['de',],
'ero'=>['it',],
'erop'=>['nl',],
'eropa'=>['id',],
'erover'=>['nl',],
'errado'=>['pt','pt_br',],
'erratza'=>['eu',],
'erre'=>['eu','hu',],
'erreminta'=>['eu',],
'errepikatu'=>['eu',],
'errespetatu'=>['eu',],
'erretzeari'=>['eu',],
'erretzen'=>['eu',],
'erreur'=>['fr',],
'erro'=>['pt','pt_br',],
'error'=>['ca','es',],
'errua'=>['eu',],
'erruduna'=>['eu',],
'erről'=>['hu',],
'ers'=>['sv',],
'erst'=>['de',],
'erste'=>['de',],
'ersten'=>['de',],
'ert'=>['is','sv',],
'ertu'=>['is',],
'ertəsi'=>['az',],
'eru'=>['is',],
'eruit'=>['nl',],
'erum'=>['is',],
'erunt'=>['la',],
'eruð'=>['is',],
'ervan'=>['nl',],
'ervoor'=>['nl',],
'erwartet'=>['de',],
'erzählen'=>['de',],
'erzählt'=>['de',],
'eräs'=>['fi',],
'erë'=>['sq',],
'erős'=>['hu',],
'es'=>['ca','de','es','fr','gl','hu','id','la','lv','ms',],
'esa'=>['es','gl',],
'esam'=>['lt','lv',],
'esame'=>['lt',],
'esan'=>['eu',],
'esango'=>['eu',],
'esas'=>['es','gl',],
'esat'=>['lt','lv',],
'esate'=>['lt',],
'esatean'=>['eu',],
'esaten'=>['eu',],
'esattamente'=>['it',],
'esatto'=>['it',],
'escapar'=>['ca',],
'escena'=>['ca',],
'esclar'=>['ca',],
'escola'=>['ca','gl','pt','pt_br',],
'escolha'=>['pt','pt_br',],
'escolta'=>['ca',],
'escolti'=>['ca',],
'escrever'=>['pt','pt_br',],
'escritor'=>['gl',],
'escritório'=>['pt','pt_br',],
'escucha'=>['es',],
'escuela'=>['es',],
'escuta'=>['pt',],
'escute'=>['pt_br',],
'ese'=>['es','gl',],
'esercito'=>['it',],
'eseri'=>['eu',],
'eserita'=>['eu',],
'eses'=>['gl',],
'esetleg'=>['hu',],
'esforzo'=>['gl',],
'eshte'=>['sq',],
'eshtë'=>['sq',],
'esi'=>['lt','lv',],
'esiet'=>['lv',],
'esimene'=>['et',],
'esimest'=>['et',],
'eskaintzeko'=>['eu',],
'eskatu'=>['eu',],
'eskatuz'=>['eu',],
'eskatzeko'=>['eu',],
'eskerrik'=>['eu',],
'eski'=>['tr',],
'eskola'=>['eu',],
'eskolako'=>['eu',],
'eskolan'=>['eu',],
'eskolara'=>['eu',],
'eskuak'=>['eu',],
'esküszöm'=>['hu',],
'esmu'=>['lv',],
'eso'=>['es',],
'esos'=>['es',],
'esot'=>['lv',],
'espacio'=>['gl',],
'espai'=>['ca',],
'espasa'=>['ca',],
'espaço'=>['pt','pt_br',],
'españa'=>['gl',],
'españois'=>['gl',],
'español'=>['gl',],
'española'=>['gl',],
'especial'=>['ca','es','gl','pt','pt_br',],
'especialmente'=>['gl',],
'especie'=>['gl',],
'espera'=>['ca','es','gl','pt','pt_br',],
'esperando'=>['es','pt_br',],
'esperant'=>['ca',],
'esperar'=>['ca','es','pt','pt_br',],
'espere'=>['es','pt','pt_br',],
'esperem'=>['pt',],
'esperi'=>['ca',],
'espero'=>['ca','es','eu','pt','pt_br',],
'esposa'=>['es','pt','pt_br',],
'esposo'=>['es',],
'esprit'=>['fr',],
'espèce'=>['fr',],
'espère'=>['fr',],
'esquecer'=>['pt_br',],
'esquerda'=>['gl','pt','pt_br',],
'esquerra'=>['ca',],
'esqueça'=>['pt_br',],
'essa'=>['pt','pt_br',],
'essaie'=>['fr',],
'essas'=>['pt','pt_br',],
'essayer'=>['fr',],
'essayé'=>['fr',],
'esse'=>['la','pt','pt_br',],
'essen'=>['de',],
'essent'=>['la',],
'essere'=>['it',],
'esses'=>['pt','pt_br',],
'esset'=>['la',],
'est'=>['fr','la',],
'esta'=>['es','gl','pt','pt_br',],
'estaba'=>['es','gl',],
'estaban'=>['es','gl',],
'estabas'=>['es',],
'estado'=>['es','gl','pt','pt_br',],
'estados'=>['gl',],
'estamos'=>['es','gl','pt','pt_br',],
'estan'=>['ca',],
'estar'=>['ca','es','gl','pt','pt_br',],
'estarei'=>['pt_br',],
'estaria'=>['pt_br',],
'estarà'=>['ca',],
'estará'=>['es','pt','pt_br',],
'estaré'=>['es',],
'estaría'=>['es',],
'estas'=>['es','gl','pt','pt_br',],
'estat'=>['ca',],
'estats'=>['ca',],
'estava'=>['ca','pt','pt_br',],
'estavam'=>['pt','pt_br',],
'estavas'=>['pt',],
'este'=>['es','gl','hu','pt','pt_br','ro',],
'esteja'=>['pt','pt_br',],
'estem'=>['ca',],
'estes'=>['gl','pt','pt_br',],
'esteu'=>['ca',],
'esteve'=>['pt','pt_br',],
'esti'=>['ro',],
'estic'=>['ca',],
'estigui'=>['ca',],
'estimada'=>['ca',],
'estimat'=>['ca',],
'estimo'=>['ca',],
'estive'=>['pt','pt_br',],
'estiver'=>['pt','pt_br',],
'estivesse'=>['pt','pt_br',],
'estivo'=>['gl',],
'esto'=>['es',],
'estona'=>['ca',],
'estos'=>['es',],
'estou'=>['gl','pt','pt_br',],
'estoy'=>['es',],
'estrada'=>['gl','pt','pt_br',],
'estranho'=>['pt','pt_br',],
'estrany'=>['ca',],
'estudio'=>['gl',],
'estuve'=>['es',],
'estuvo'=>['es',],
'està'=>['ca',],
'estàs'=>['ca',],
'está'=>['es','gl','pt','pt_br',],
'estábamos'=>['es',],
'están'=>['es','gl',],
'estás'=>['es','gl','pt','pt_br',],
'estávamos'=>['pt','pt_br',],
'estão'=>['pt','pt_br',],
'esté'=>['es',],
'estét'=>['hu',],
'estúpido'=>['es','pt',],
'esu'=>['lt',],
'et'=>['az','ca','da','et','fi','fr','hu','id','la','nb','no','tr',],
'eta'=>['eu',],
'etc'=>['gl',],
'eteenpäin'=>['fi',],
'eten'=>['nl',],
'etenim'=>['la',],
'etiam'=>['la',],
'etkä'=>['fi',],
'etkö'=>['fi',],
'etme'=>['tr',],
'etmek'=>['tr',],
'etmeye'=>['tr',],
'etmək'=>['az',],
'eto'=>['bs','hr','sr',],
'etor'=>['eu',],
'etorri'=>['eu',],
'etorria'=>['eu',],
'etorriko'=>['eu',],
'etortzeaz'=>['eu',],
'etre'=>['fr',],
'ets'=>['ca',],
'etsaiei'=>['eu',],
'etsi'=>['fi','la',],
'etsin'=>['fi',],
'ett'=>['nb','no','sv',],
'ette'=>['et','fi',],
'ettei'=>['fi',],
'ettekö'=>['fi',],
'etten'=>['fi',],
'etter'=>['nb','no',],
'ettet'=>['fi',],
'ettevaatlik'=>['et',],
'etti'=>['tr',],
'ettim'=>['tr',],
'ettin'=>['tr',],
'että'=>['fi',],
'ettől'=>['hu',],
'etwa'=>['de',],
'etwas'=>['de',],
'etxearen'=>['eu',],
'etxera'=>['eu',],
'eu'=>['fr','gl','pt','pt_br','ro','zh_tw',],
'euch'=>['de',],
'euer'=>['de',],
'euh'=>['fr',],
'eum'=>['la',],
'eurak'=>['eu',],
'eure'=>['de',],
'eurek'=>['eu',],
'europa'=>['gl','id',],
'europea'=>['gl',],
'euros'=>['gl',],
'eusten'=>['eu',],
'eutsi'=>['eu',],
'euwels'=>['af',],
'eux'=>['fr',],
'ev'=>['tr',],
'eva'=>['th',],
'evde'=>['tr',],
'eve'=>['th','tr',],
'even'=>['en','nl','si','th',],
'evening'=>['en',],
'ever'=>['en','th',],
'everest'=>['th',],
'every'=>['en',],
'everybody'=>['en',],
'everyone'=>['en','th',],
'everything'=>['en','si','th',],
'evet'=>['tr',],
'evi'=>['tr',],
'evil'=>['en',],
'evine'=>['tr',],
'evitar'=>['gl',],
'evlat'=>['tr',],
'evo'=>['bs','hr','sr',],
'evolusi'=>['id',],
'ewig'=>['af',],
'ex'=>['af','gl','la',],
'exact'=>['fr','ro',],
'exactament'=>['ca',],
'exactamente'=>['es','pt',],
'exactement'=>['fr',],
'exactly'=>['en',],
'exakt'=>['sv',],
'exatamente'=>['pt_br',],
'excelente'=>['pt',],
'except'=>['en',],
'excuse'=>['en','si',],
'excuseer'=>['nl',],
'exemple'=>['fr',],
'exemplo'=>['gl',],
'exemplum'=>['la',],
'exercitu'=>['la',],
'exercitum'=>['la',],
'exercitus'=>['la',],
'exista'=>['ro',],
'existe'=>['es','fr','gl','pt','pt_br',],
'existen'=>['gl',],
'existencia'=>['gl',],
'existitzen'=>['eu',],
'există'=>['ro',],
'expect'=>['en',],
'experiencia'=>['gl',],
'explain'=>['en','si',],
'explicar'=>['ca','pt_br',],
'explicou'=>['gl',],
'expliquer'=>['fr',],
'expresión'=>['gl',],
'exterior'=>['gl',],
'extra'=>['la',],
'extraño'=>['es',],
'exèrcit'=>['ca',],
'exército'=>['pt','pt_br',],
'eye'=>['en',],
'eyes'=>['en',],
'ez'=>['eu','hu',],
'ezagutu'=>['eu',],
'ezagutzera'=>['eu',],
'ezaugarri'=>['eu',],
'ezazu'=>['eu',],
'ezek'=>['hu',],
'ezeket'=>['hu',],
'ezelőtt'=>['hu',],
'ezen'=>['hu',],
'ezer'=>['eu','hu',],
'ezin'=>['eu',],
'ezingo'=>['eu',],
'ezkondu'=>['eu',],
'ezkutatzen'=>['eu',],
'ezkutuan'=>['eu',],
'ezredes'=>['hu',],
'ezt'=>['hu',],
'ezta'=>['eu',],
'eztabaida'=>['eu',],
'ezzel'=>['hu',],
'ezért'=>['hu',],
'eén'=>['nl',],
'eða'=>['is',],
'eğer'=>['tr',],
'eşti'=>['ro',],
'ešte'=>['sk',],
'f'=>['az','da','is','nb','no','si','sv','th',],
'fa'=>['ca','it','nb','no',],
'fac'=>['ro',],
'faccia'=>['it',],
'facciamo'=>['it',],
'faccio'=>['it',],
'face'=>['af','en','fr','ro','si','th',],
'facelo'=>['gl',],
'facem'=>['ro',],
'facendo'=>['gl','it',],
'facer'=>['gl',],
'facere'=>['la',],
'facet'=>['pl',],
'faceta'=>['pl',],
'faceva'=>['it',],
'faceţi'=>['ro',],
'fach'=>['ca',],
'faci'=>['ca','ro',],
'faciam'=>['la',],
'faciem'=>['la',],
'facile'=>['fr','it','la',],
'facilius'=>['la',],
'facis'=>['ca',],
'facit'=>['la',],
'faciunt'=>['la',],
'fact'=>['en',],
'facta'=>['la',],
'facti'=>['la',],
'facto'=>['la','pt',],
'factum'=>['la',],
'factus'=>['la',],
'facut'=>['ro',],
'facía'=>['gl',],
'facă'=>['ro',],
'fader'=>['da','sv',],
'faen'=>['nb','no',],
'fahr'=>['de',],
'fahren'=>['de',],
'fai'=>['gl','it',],
'faig'=>['ca',],
'faim'=>['fr',],
'fair'=>['en',],
'faire'=>['fr',],
'fais'=>['fr',],
'faisait'=>['fr',],
'faisal'=>['si',],
'fait'=>['fr',],
'faites'=>['fr',],
'faji'=>['sq',],
'fajn'=>['cs','sk',],
'fakat'=>['tr',],
'fakt'=>['cs','sk','sq',],
'fakta'=>['id',],
'faktisk'=>['da','nb','no',],
'faktiskt'=>['sv',],
'fal'=>['sq',],
'fala'=>['gl','pt','pt_br',],
'falan'=>['tr',],
'falando'=>['pt','pt_br',],
'falar'=>['gl','pt','pt_br',],
'fald'=>['da',],
'falder'=>['da',],
'faldt'=>['da',],
'fale'=>['pt_br',],
'falei'=>['pt_br',],
'faleminderit'=>['sq',],
'falemnderit'=>['sq',],
'fall'=>['de','en','nb','no','sv',],
'fallait'=>['fr',],
'falleg'=>['is',],
'fallegt'=>['is',],
'fallen'=>['de',],
'fallo'=>['it',],
'falls'=>['de',],
'falni'=>['sq',],
'falo'=>['pt_br',],
'falou'=>['pt','pt_br',],
'falsch'=>['de',],
'false'=>['si',],
'falt'=>['nb','no',],
'falta'=>['ca','es','gl','pt','pt_br',],
'fama'=>['la',],
'fame'=>['it',],
'famiglia'=>['it',],
'familia'=>['es','eu','gl','ro',],
'familie'=>['da','de','nb','nl','no','ro',],
'familien'=>['da','nb','no',],
'familj'=>['sv',],
'familja'=>['sq',],
'familje'=>['sq',],
'familjen'=>['sq','sv',],
'famille'=>['fr',],
'family'=>['en',],
'fammi'=>['it',],
'família'=>['ca','pt','pt_br',],
'fan'=>['af','ca','gl','sv',],
'fand'=>['de',],
'fanden'=>['da','no',],
'fandens'=>['da',],
'fandt'=>['da',],
'fange'=>['da',],
'fangelsi'=>['is',],
'fangen'=>['de',],
'fanget'=>['da',],
'fann'=>['is',],
'fanno'=>['it',],
'fanns'=>['sv',],
'fannst'=>['is',],
'fant'=>['nb','no','sl',],
'fanta'=>['sl',],
'fantastico'=>['it',],
'fantastike'=>['sq',],
'fantastisch'=>['nl',],
'fantastisk'=>['da','nb','no',],
'fantastiskt'=>['sv',],
'fantje'=>['sl',],
'fantàstic'=>['ca',],
'fantástico'=>['pt',],
'fapt'=>['ro',],
'faptul'=>['ro',],
'far'=>['ca','da','en','it','nb','no','sv',],
'fara'=>['is','ro','sv',],
'farai'=>['it',],
'farbror'=>['sv',],
'farci'=>['it',],
'fare'=>['da','it','nb','no','sq',],
'farei'=>['pt_br',],
'farem'=>['ca',],
'faremo'=>['it',],
'faren'=>['nb','no',],
'farhan'=>['si',],
'farhanitrate'=>['si',],
'fari'=>['is',],
'faria'=>['ca','pt','pt_br',],
'farinn'=>['is',],
'farið'=>['is',],
'fark'=>['tr',],
'farklı'=>['tr',],
'farlig'=>['nb','no',],
'farlo'=>['it',],
'farmi'=>['it',],
'fars'=>['da',],
'fart'=>['da','sv',],
'farti'=>['it',],
'farvel'=>['da','nb','no',],
'farà'=>['ca','it',],
'faràs'=>['ca',],
'fará'=>['pt_br',],
'faré'=>['ca',],
'farë'=>['sq',],
'farðu'=>['is',],
'farò'=>['it',],
'fas'=>['ca',],
'fasse'=>['fr',],
'fast'=>['da','de','en','nb','no','sv',],
'fasz'=>['hu',],
'fat'=>['da','en','sq',],
'fata'=>['ro',],
'fate'=>['it',],
'father'=>['en',],
'fato'=>['pt_br',],
'fatta'=>['it',],
'fattar'=>['sv',],
'fatti'=>['it',],
'fatto'=>['it',],
'fată'=>['ro',],
'fault'=>['en',],
'faut'=>['fr',],
'faute'=>['fr',],
'faux'=>['fr',],
'favor'=>['ca','es','gl','pt','pt_br',],
'favore'=>['it',],
'faz'=>['pt','pt_br',],
'fazem'=>['pt','pt_br',],
'fazemos'=>['pt',],
'fazendo'=>['pt','pt_br',],
'fazer'=>['pt','pt_br',],
'fazes'=>['pt',],
'fazia'=>['pt',],
'fazla'=>['tr',],
'faça'=>['pt','pt_br',],
'faças'=>['pt',],
'faço'=>['pt','pt_br',],
'façon'=>['fr',],
'faðir'=>['is',],
'faţa'=>['ro',],
'faţă'=>['ro',],
'fbi'=>['si','th',],
'fbl'=>['si',],
'fear'=>['en',],
'fecerunt'=>['la',],
'fecisse'=>['la',],
'fecit'=>['la',],
'fedt'=>['da',],
'feel'=>['en',],
'feelin'=>['af',],
'feeling'=>['en',],
'feest'=>['nl',],
'feet'=>['en','si',],
'fegyvert'=>['hu',],
'fehler'=>['de',],
'fehér'=>['hu',],
'feia'=>['ca',],
'feil'=>['nb','no',],
'feina'=>['ca',],
'feira'=>['pt','pt_br',],
'feito'=>['gl','pt','pt_br',],
'feitos'=>['gl',],
'fejl'=>['da',],
'fekete'=>['hu',],
'fel'=>['hu','ro','sv',],
'felejtsd'=>['hu',],
'felesége'=>['hu',],
'feleségem'=>['hu',],
'felice'=>['it',],
'feliz'=>['es','pt','pt_br',],
'feliç'=>['ca',],
'fell'=>['en',],
'felt'=>['en',],
'felul'=>['ro',],
'felé'=>['hu',],
'fem'=>['ca','da','nb','no','sv',],
'femei'=>['ro',],
'femeia'=>['ro',],
'femeie'=>['ro',],
'femeile'=>['ro',],
'femme'=>['fr',],
'femmes'=>['fr',],
'fena'=>['tr',],
'fene'=>['hu',],
'fengið'=>['is',],
'fengsel'=>['nb','no',],
'fenomena'=>['id',],
'fenster'=>['de',],
'fent'=>['ca',],
'fenébe'=>['hu',],
'fer'=>['ca','is',],
'fera'=>['fr',],
'ferai'=>['fr',],
'ferais'=>['fr',],
'ferait'=>['fr',],
'ferdig'=>['nb','no',],
'fere'=>['la',],
'fericit'=>['ro',],
'ferm'=>['af',],
'ferma'=>['it',],
'ferme'=>['fr',],
'fermi'=>['it',],
'fermo'=>['it',],
'fernando'=>['gl',],
'fernández'=>['gl',],
'ferre'=>['la',],
'ferrol'=>['gl',],
'fertig'=>['de',],
'ferunt'=>['la',],
'ferð'=>['is',],
'fes'=>['ca',],
'fest'=>['da','de','nb','no',],
'festa'=>['ca','gl','it','pt','pt_br',],
'fet'=>['ca',],
'fete'=>['ro',],
'fetele'=>['ro',],
'feu'=>['ca','fr',],
'feuer'=>['de',],
'few'=>['en',],
'fez'=>['pt','pt_br',],
'fi'=>['ca','ro',],
'fia'=>['hu',],
'fiam'=>['hu',],
'fiat'=>['la',],
'fiatal'=>['hu',],
'fica'=>['pt','pt_br',],
'ficando'=>['pt_br',],
'ficar'=>['pt','pt_br',],
'ficará'=>['pt_br',],
'fick'=>['sv',],
'fickó'=>['hu',],
'fico'=>['pt','pt_br',],
'ficou'=>['pt','pt_br',],
'fidan'=>['az',],
'fide'=>['la',],
'fidem'=>['la',],
'fides'=>['la',],
'fie'=>['ro',],
'fiecare'=>['ro',],
'fieri'=>['la',],
'fiesta'=>['es',],
'fight'=>['en','th',],
'fighting'=>['en',],
'figli'=>['it',],
'figlia'=>['it',],
'figlio'=>['it',],
'figura'=>['gl',],
'figure'=>['en',],
'figyelj'=>['hu',],
'fii'=>['ro',],
'fiica'=>['ro',],
'fiindcă'=>['ro',],
'fijn'=>['nl',],
'fik'=>['da','no',],
'fikir'=>['tr',],
'fikk'=>['nb','no',],
'fiksi'=>['id',],
'filha'=>['pt','pt_br',],
'filho'=>['pt','pt_br',],
'filhos'=>['pt','pt_br',],
'filii'=>['la',],
'filiis'=>['la',],
'filio'=>['la',],
'filiorum'=>['la',],
'filios'=>['la',],
'filium'=>['la',],
'filius'=>['la',],
'filizofiju'=>['hi',],
'fill'=>['ca','si',],
'filla'=>['ca','gl',],
'fille'=>['fr',],
'filles'=>['fr',],
'fillim'=>['sq',],
'fillo'=>['gl',],
'fillojmë'=>['sq',],
'fillon'=>['sq',],
'fillos'=>['gl',],
'fills'=>['ca',],
'filluar'=>['sq',],
'film'=>['af','bs','cs','da','de','en','fr','hr','id','it','ms','nb','nl','no','pl','ro','sk','sl','sr','sv','tr',],
'filme'=>['pt','pt_br',],
'filmen'=>['nb','no',],
'films'=>['af',],
'fils'=>['fr',],
'fim'=>['pt','pt_br','ro',],
'fimm'=>['is',],
'fin'=>['es','fr','gl','it','nb','no','sv',],
'fina'=>['sv',],
'final'=>['ca','es','gl','pt','pt_br',],
'finalists'=>['th',],
'finally'=>['en',],
'finalmente'=>['gl','it','pt','pt_br',],
'finché'=>['it',],
'find'=>['da','en','th',],
'finde'=>['da','de',],
'finden'=>['de',],
'finder'=>['da',],
'findes'=>['da',],
'findet'=>['de',],
'fine'=>['en','it','si',],
'finem'=>['la',],
'finger'=>['de',],
'fingers'=>['si',],
'fini'=>['fr',],
'finir'=>['fr',],
'finire'=>['it',],
'finish'=>['en',],
'finished'=>['en',],
'finita'=>['it',],
'finito'=>['it',],
'finn'=>['is','nb','no',],
'finna'=>['is',],
'finnas'=>['sv',],
'finndu'=>['is',],
'finne'=>['nb','no',],
'finner'=>['nb','no',],
'finnes'=>['nb','no',],
'finns'=>['sv',],
'finnst'=>['is',],
'finnum'=>['is',],
'finnur'=>['is',],
'fino'=>['bs','it',],
'fins'=>['ca','nb','no',],
'fint'=>['da','nb','no','sv',],
'fique'=>['pt','pt_br',],
'fiquei'=>['pt','pt_br',],
'fire'=>['da','en','nb','no','th',],
'first'=>['en','th',],
'fish'=>['en',],
'fisik'=>['id',],
'fisika'=>['id',],
'fit'=>['la',],
'fiu'=>['ro',],
'fiul'=>['ro',],
'fiule'=>['ro',],
'fiunt'=>['la',],
'five'=>['en','si',],
'fix'=>['en',],
'fixa'=>['sv',],
'fixar'=>['sv',],
'fixe'=>['pt',],
'fixeron'=>['gl',],
'fixo'=>['gl',],
'fiz'=>['pt','pt_br',],
'fizemos'=>['pt_br',],
'fizeram'=>['pt','pt_br',],
'fizeste'=>['pt',],
'fiú'=>['hu',],
'fiúk'=>['hu',],
'fiţi'=>['ro',],
'fjala'=>['sq',],
'fjalë'=>['sq',],
'fjalën'=>['sq',],
'fjandans'=>['is',],
'fjandanum'=>['is',],
'fjandinn'=>['is',],
'fjols'=>['da',],
'fjárinn'=>['is',],
'fjölskyldu'=>['is',],
'flas'=>['sq',],
'flasim'=>['sq',],
'flasësh'=>['sq',],
'fleira'=>['is',],
'fleiri'=>['is',],
'fler'=>['sv',],
'flera'=>['sv',],
'flere'=>['da','nb','no',],
'fleste'=>['da',],
'flet'=>['sq',],
'flicka'=>['sv',],
'flickan'=>['sv',],
'flickor'=>['sv',],
'flics'=>['fr',],
'fliegen'=>['de',],
'flink'=>['nb','no',],
'fljótt'=>['is',],
'floor'=>['en','si',],
'flor'=>['ca',],
'flot'=>['da',],
'flott'=>['is','nb','no',],
'fluit'=>['af',],
'fly'=>['da','en','nb','no',],
'flyet'=>['nb','no',],
'flying'=>['th',],
'flyt'=>['da',],
'flytt'=>['nb',],
'flytta'=>['sv',],
'flytte'=>['nb','no',],
'flyve'=>['da',],
'foame'=>['ro',],
'foarte'=>['ro',],
'foc'=>['ca','ro',],
'fog'=>['hu',],
'fogd'=>['hu',],
'fogja'=>['hu',],
'fogjuk'=>['hu',],
'fogják'=>['hu',],
'fognak'=>['hu',],
'fogo'=>['pt','pt_br',],
'fogod'=>['hu',],
'fogok'=>['hu',],
'fogom'=>['hu',],
'fogsz'=>['hu',],
'fogunk'=>['hu',],
'foi'=>['gl','pt','pt_br',],
'fois'=>['fr',],
'fol'=>['sq',],
'folgen'=>['de',],
'folk'=>['da','nb','no','sv',],
'folkens'=>['nb',],
'folle'=>['fr',],
'follow'=>['en',],
'folosit'=>['ro',],
'folur'=>['sq',],
'folyik'=>['hu',],
'folyton'=>['hu',],
'fome'=>['pt','pt_br',],
'fomos'=>['pt','pt_br',],
'fon'=>['az',],
'fond'=>['fr',],
'fondo'=>['gl','it',],
'fondoa'=>['eu',],
'fons'=>['ca',],
'font'=>['fr',],
'fontes'=>['gl',],
'fontos'=>['hu',],
'food'=>['en','si',],
'fool'=>['en',],
'for'=>['da','en','fa','nb','no','pt','pt_br','si','th',],
'fora'=>['ca','gl','pt','pt_br',],
'foram'=>['pt','pt_br',],
'foran'=>['da','nb','no',],
'forbandede'=>['da',],
'forbi'=>['da','nb','no',],
'forca'=>['sq',],
'force'=>['en','fr',],
'fordi'=>['da','nb','no',],
'fore'=>['la',],
'foregår'=>['da','nb','no',],
'foreldrene'=>['nb',],
'forelsket'=>['nb','no',],
'forever'=>['en','si',],
'forget'=>['en',],
'forgive'=>['en',],
'forgot'=>['en',],
'forhold'=>['da','nb','no',],
'forkert'=>['da',],
'forkerte'=>['da',],
'forklare'=>['da','nb','no',],
'forks'=>['hi',],
'forlade'=>['da',],
'form'=>['si',],
'forma'=>['ca','es','gl','pt','pt_br',],
'formación'=>['gl',],
'formas'=>['gl',],
'forme'=>['fr',],
'foro'=>['la',],
'foron'=>['gl',],
'forse'=>['it',],
'forsigtig'=>['da',],
'forsiktig'=>['nb','no',],
'forstå'=>['da','nb','no',],
'forstået'=>['da',],
'forstår'=>['da','nb','no',],
'forstått'=>['nb','no',],
'forsvind'=>['da',],
'forsøger'=>['da',],
'fort'=>['ca','de','fr','nb','no','sq','sv',],
'fortalt'=>['da','nb','no',],
'fortalte'=>['da','nb','no',],
'fortasse'=>['la',],
'forte'=>['gl','it','la','pt','pt_br',],
'fortell'=>['nb','no',],
'fortelle'=>['nb','no',],
'forteller'=>['nb','no',],
'fortfarande'=>['sv',],
'fortsatt'=>['nb','no',],
'fortsett'=>['nb','no',],
'fortsette'=>['nb','no',],
'fortsetter'=>['nb',],
'fortsätt'=>['sv',],
'fortsätta'=>['sv',],
'fortsätter'=>['sv',],
'fortsæt'=>['da',],
'fortuna'=>['it','la',],
'fortunae'=>['la',],
'fortæl'=>['da',],
'fortælle'=>['da',],
'fortæller'=>['da',],
'fortë'=>['sq',],
'forumda'=>['az',],
'forward'=>['en','si',],
'forza'=>['gl','it',],
'forzas'=>['gl',],
'forældre'=>['da',],
'força'=>['ca','pt','pt_br',],
'forši'=>['lv',],
'fos'=>['ca',],
'fose'=>['gl',],
'fosil'=>['id',],
'fosse'=>['it','pt','pt_br',],
'fossi'=>['it',],
'fost'=>['ro',],
'foste'=>['pt',],
'foto'=>['ca','es','id','it','ms','nl','pt_br',],
'fotos'=>['pt_br',],
'fou'=>['fr',],
'found'=>['en','th',],
'four'=>['en',],
'fous'=>['fr',],
'fout'=>['nl',],
'foute'=>['af',],
'foutre'=>['fr',],
'fra'=>['da','it','nb','no',],
'fraga'=>['gl',],
'frage'=>['de',],
'fragen'=>['de',],
'fram'=>['is','nb','no','sv',],
'framan'=>['is',],
'framför'=>['sv',],
'francba'=>['hu',],
'francia'=>['gl',],
'francisco'=>['gl',],
'frank'=>['bs','ca','da','de','en','es','et','fi','fr','hr','hu','is','it','ms','nb','nl','no','pl','pt','pt_br','ro','sk','sl','sv','tr',],
'frantzia'=>['eu',],
'frate'=>['ro',],
'fratele'=>['ro',],
'fratello'=>['it',],
'frater'=>['la',],
'fratrem'=>['la',],
'fratres'=>['la',],
'frau'=>['de',],
'frauen'=>['de',],
'fred'=>['ca','da','nb','no','sv',],
'freddo'=>['it',],
'free'=>['en',],
'frei'=>['de',],
'frekar'=>['is',],
'frem'=>['da','nb','no',],
'fremdeles'=>['nb','no',],
'french'=>['en',],
'frente'=>['es','pt','pt_br',],
'fretta'=>['it',],
'freund'=>['de',],
'freunde'=>['de',],
'freundin'=>['de',],
'fri'=>['da','nb','no','sv',],
'fric'=>['fr',],
'frică'=>['ro',],
'friend'=>['en','si',],
'friendly'=>['th',],
'friends'=>['en',],
'frikë'=>['sq',],
'frio'=>['pt','pt_br',],
'friði'=>['is',],
'frodo'=>['lv',],
'froga'=>['eu',],
'frogatzeko'=>['eu',],
'froh'=>['de',],
'froid'=>['fr',],
'from'=>['en','fa','si','th','zh',],
'front'=>['en',],
'fronte'=>['gl','it',],
'fru'=>['da','nb','no','sv',],
'frue'=>['da','nb','no',],
'frumoasă'=>['ro',],
'frumos'=>['ro',],
'frun'=>['sv',],
'frymë'=>['sq',],
'frá'=>['is',],
'frábær'=>['is',],
'frábært'=>['is',],
'fråga'=>['sv',],
'frågade'=>['sv',],
'frågar'=>['sv',],
'frågor'=>['sv',],
'från'=>['sv',],
'frændi'=>['is',],
'frère'=>['fr',],
'fréttir'=>['is',],
'frío'=>['es','gl',],
'fröken'=>['is','sv',],
'frøken'=>['da',],
'frú'=>['is',],
'früh'=>['de',],
'früher'=>['de',],
'ftohtë'=>['sq',],
'fu'=>['it',],
'fuck'=>['da','en','ms',],
'fuckin'=>['en',],
'fucking'=>['en','ms',],
'fue'=>['es',],
'fuego'=>['es',],
'fuera'=>['es',],
'fuerant'=>['la',],
'fuerat'=>['la',],
'fuerint'=>['la',],
'fuerit'=>['la',],
'fueron'=>['es',],
'fuerte'=>['es',],
'fuerunt'=>['la',],
'fuerza'=>['es',],
'fugi'=>['ro',],
'fugir'=>['pt',],
'fui'=>['es','pt','pt_br',],
'fuisse'=>['la',],
'fuisset'=>['la',],
'fuiste'=>['es',],
'fuit'=>['la',],
'fuld'=>['da',],
'full'=>['en','nb','no','sv',],
'fun'=>['en','gl',],
'funciona'=>['ca','es',],
'función'=>['gl',],
'fund'=>['ro','sq',],
'fundet'=>['da',],
'fundi'=>['sq',],
'fundiswa'=>['th',],
'fundit'=>['sq',],
'fundið'=>['is',],
'fundo'=>['pt','pt_br',],
'fundul'=>['ro',],
'fungerar'=>['sv',],
'funkar'=>['sv',],
'funktioniert'=>['de',],
'funnet'=>['nb','no',],
'funny'=>['en',],
'funziona'=>['it',],
'fuoco'=>['it',],
'fuori'=>['it',],
'furat'=>['ro',],
'furcsa'=>['hu',],
'fut'=>['fr',],
'futur'=>['ca',],
'futura'=>['la',],
'future'=>['en',],
'futuro'=>['es','gl','it','pt','pt_br',],
'futurum'=>['la',],
'fxg'=>['si',],
'fylgja'=>['is',],
'fyndið'=>['is',],
'fyr'=>['da','nb','no',],
'fyra'=>['sv',],
'fyre'=>['da',],
'fyren'=>['da','nb','no',],
'fyrir'=>['is',],
'fyrirgefðu'=>['is',],
'fyrr'=>['is',],
'fyrst'=>['is',],
'fyrsta'=>['is',],
'fyrstu'=>['is',],
'fàcil'=>['ca',],
'fá'=>['is',],
'fácil'=>['es','pt','pt_br',],
'fáj'=>['hu',],
'fáum'=>['is',],
'fáðu'=>['is',],
'fällt'=>['de',],
'fängelse'=>['sv',],
'få'=>['da','nb','no','sv',],
'fået'=>['da',],
'får'=>['da','nb','no','sv',],
'fått'=>['nb','no','sv',],
'fæ'=>['is',],
'fængsel'=>['da',],
'fær'=>['is',],
'færdig'=>['da',],
'færi'=>['is',],
'færð'=>['is',],
'færðu'=>['is',],
'fékk'=>['is',],
'fékkstu'=>['is',],
'fél'=>['hu',],
'félagi'=>['is',],
'félek'=>['hu',],
'férfi'=>['hu',],
'fête'=>['fr',],
'fëmijë'=>['sq',],
'fëmijët'=>['sq',],
'fínt'=>['is',],
'fólk'=>['is',],
'fólki'=>['is',],
'fólkið'=>['is',],
'fór'=>['is',],
'fóra'=>['gl',],
'föld'=>['hu',],
'följ'=>['sv',],
'följa'=>['sv',],
'följer'=>['sv',],
'för'=>['sv',],
'förbi'=>['sv',],
'före'=>['sv',],
'förklara'=>['sv',],
'förlora'=>['sv',],
'förlorade'=>['sv',],
'förlåt'=>['sv',],
'förr'=>['sv',],
'förra'=>['sv',],
'förrän'=>['sv',],
'försiktig'=>['sv',],
'försiktigt'=>['sv',],
'först'=>['sv',],
'första'=>['sv',],
'förstå'=>['sv',],
'förstår'=>['sv',],
'försvinn'=>['sv',],
'försök'=>['sv',],
'försöka'=>['sv',],
'försöker'=>['sv',],
'försökte'=>['sv',],
'förum'=>['is',],
'förut'=>['sv',],
'förutom'=>['sv',],
'föräldrar'=>['sv',],
'föður'=>['is',],
'født'=>['da','nb','no',],
'føle'=>['da','nb','no',],
'føler'=>['da','nb','no',],
'føles'=>['da','nb','no',],
'følg'=>['da','nb','no',],
'følge'=>['da','nb','no',],
'følger'=>['da','nb','no',],
'før'=>['da','nb','no',],
'først'=>['da','nb','no',],
'første'=>['da','nb','no',],
'fühle'=>['de',],
'fühlen'=>['de',],
'führen'=>['de',],
'fünf'=>['de',],
'für'=>['de',],
'fă'=>['ro',],
'făcut'=>['ro',],
'fără'=>['ro',],
'főnök'=>['hu',],
'fəal'=>['az',],
'g'=>['az','bs','da','hr','is','nb','no','sl','sr',],
'ga'=>['bs','hr','nb','nl','no','sl','sr',],
'gaan'=>['af','nl',],
'gaat'=>['nl',],
'gab'=>['de',],
'gabean'=>['eu',],
'gabim'=>['sq',],
'gabuar'=>['sq',],
'gada'=>['lv',],
'gadi'=>['lv',],
'gadiem'=>['lv',],
'gadis'=>['ms',],
'gadu'=>['lv',],
'gadus'=>['lv',],
'gadā'=>['lv',],
'gadījumā'=>['lv',],
'gadžet'=>['lv',],
'gaf'=>['is','nl',],
'gagal'=>['ms',],
'gagasan'=>['id',],
'gagner'=>['fr',],
'gagné'=>['fr',],
'gaida'=>['lv',],
'gaila'=>['lt',],
'gain'=>['eu',],
'gainontzekoak'=>['eu',],
'gaire'=>['ca',],
'gairebé'=>['ca',],
'gaismas'=>['lv',],
'gaisā'=>['lv',],
'gaitezen'=>['eu',],
'gaitu'=>['eu',],
'gaituzu'=>['eu',],
'gaixorik'=>['eu',],
'gajo'=>['pt',],
'gal'=>['lt','nb','no',],
'galais'=>['lt',],
'galaksi'=>['id',],
'galam'=>['lv',],
'galaxies'=>['th',],
'galaxy'=>['th',],
'galbūt'=>['lt',],
'galdetzen'=>['eu',],
'galdu'=>['eu',],
'gale'=>['lt',],
'galega'=>['gl',],
'galegas'=>['gl',],
'galego'=>['gl',],
'galegos'=>['gl',],
'galen'=>['sv',],
'galeria'=>['eu',],
'gali'=>['lt',],
'galiba'=>['tr',],
'galicia'=>['gl',],
'galim'=>['lt',],
'galima'=>['lt',],
'galime'=>['lt',],
'galit'=>['lt',],
'galite'=>['lt',],
'galiu'=>['lt',],
'galiza'=>['gl',],
'galt'=>['da','nb','no',],
'galva'=>['lt',],
'galvas'=>['lv',],
'galvenais'=>['lv',],
'galviston'=>['hi',],
'galvojau'=>['lt',],
'galvoje'=>['lt',],
'galvoji'=>['lt',],
'galvoju'=>['lt',],
'galvos'=>['lt',],
'galvu'=>['lv',],
'galvą'=>['lt',],
'galā'=>['lv',],
'galėjo'=>['lt',],
'galėsi'=>['lt',],
'galėtum'=>['lt',],
'galėtume'=>['lt',],
'galėtų'=>['lt',],
'galėčiau'=>['lt',],
'gamall'=>['is',],
'gaman'=>['is',],
'gambar'=>['id','ms',],
'game'=>['en',],
'gamla'=>['is','sv',],
'gamle'=>['da','nb','no',],
'gamli'=>['is',],
'gammal'=>['sv',],
'gammel'=>['da','nb','no',],
'gan'=>['lv',],
'gana'=>['ca','lt','lv',],
'ganar'=>['es',],
'gandrīz'=>['lv',],
'ganes'=>['ca',],
'gang'=>['da','nb','nl','no',],
'ganga'=>['is',],
'gange'=>['da',],
'gangen'=>['nb','no',],
'ganger'=>['nb','no',],
'gangi'=>['is',],
'ganhar'=>['pt','pt_br',],
'ganska'=>['sv',],
'ganske'=>['nb','no',],
'ganz'=>['de',],
'ganze'=>['de',],
'ganzen'=>['de',],
'gar'=>['de','nb','no',],
'gara'=>['eu',],
'garaitu'=>['eu',],
'garbage'=>['th',],
'garbitzera'=>['eu',],
'garcía'=>['gl',],
'garda'=>['gl',],
'garde'=>['fr',],
'garder'=>['fr',],
'garip'=>['tr',],
'garis'=>['id','ms',],
'garota'=>['pt','pt_br',],
'garotas'=>['pt_br',],
'garoto'=>['pt_br',],
'garrantzitsu'=>['eu',],
'gars'=>['fr','lv',],
'garçon'=>['fr',],
'garām'=>['lv',],
'gas'=>['af','id',],
'gat'=>['af','is',],
'gata'=>['ro',],
'gatan'=>['sv',],
'gatavi'=>['lv',],
'gatavs'=>['lv',],
'gaten'=>['nl',],
'gati'=>['sq',],
'gatozen'=>['eu',],
'gauche'=>['fr',],
'gaude'=>['eu',],
'gaur'=>['eu',],
'gauti'=>['lt',],
'gauza'=>['eu',],
'gauzak'=>['eu',],
'gav'=>['da','sv',],
'gavai'=>['lt',],
'gavau'=>['lt',],
'gave'=>['da','en',],
'gay'=>['af',],
'gaya'=>['id',],
'gayet'=>['tr',],
'gazte'=>['eu',],
'gde'=>['bs','sr',],
'gdine'=>['bs','sr',],
'gdje'=>['bs','hr',],
'gdy'=>['pl',],
'gdyby'=>['pl',],
'gdybym'=>['pl',],
'gdybyś'=>['pl',],
'gdzie'=>['pl',],
'gdzieś'=>['pl',],
'gdč'=>['sl',],
'ge'=>['sv',],
'geagte'=>['af',],
'gebaseer'=>['af',],
'gebe'=>['de',],
'gebeld'=>['nl',],
'geben'=>['de',],
'gebeur'=>['af',],
'gebeurd'=>['nl',],
'gebeurde'=>['nl',],
'gebeuren'=>['nl',],
'gebeurt'=>['nl',],
'gebeurtenis'=>['af',],
'gebid'=>['af',],
'geboorte'=>['af',],
'gebore'=>['af',],
'geboren'=>['nl',],
'gebracht'=>['de','nl',],
'gebruik'=>['af','nl',],
'gebruiken'=>['nl',],
'gebruikt'=>['nl',],
'gece'=>['tr',],
'geceler'=>['tr',],
'gedaan'=>['nl',],
'gedacht'=>['de','nl',],
'gedachten'=>['nl',],
'gedink'=>['af',],
'gedoen'=>['af',],
'gedood'=>['af','nl',],
'gedrag'=>['af',],
'gedwaal'=>['af',],
'gee'=>['af',],
'geef'=>['nl',],
'geeft'=>['nl',],
'geel'=>['af',],
'geen'=>['af','nl',],
'geest'=>['nl',],
'gefa'=>['is',],
'gefallen'=>['de',],
'gefeliciteerd'=>['nl',],
'gefið'=>['is',],
'gefragt'=>['de',],
'gefunden'=>['de',],
'gefur'=>['is',],
'gefällt'=>['de',],
'gefängnis'=>['de',],
'gefðu'=>['is',],
'gefühl'=>['de',],
'gegaan'=>['af','nl',],
'gegangen'=>['de',],
'gegeben'=>['de',],
'gegee'=>['af',],
'gegen'=>['de',],
'gegeven'=>['nl',],
'gegn'=>['is',],
'gegnum'=>['is',],
'geh'=>['de',],
'gehad'=>['af','nl',],
'gehe'=>['de',],
'geheim'=>['nl',],
'gehen'=>['de',],
'gehiago'=>['eu',],
'gehoord'=>['nl',],
'gehou'=>['af',],
'gehst'=>['de',],
'geht'=>['de',],
'gehört'=>['de',],
'gek'=>['nl',],
'gekenmerk'=>['af',],
'gekk'=>['is',],
'geklee'=>['af',],
'geknoei'=>['af',],
'gekom'=>['af',],
'gekomen'=>['nl',],
'gekommen'=>['de',],
'gekregen'=>['nl',],
'gekroon'=>['af',],
'gel'=>['tr',],
'gelap'=>['id','ms',],
'geld'=>['de','nl',],
'geldi'=>['tr',],
'geldik'=>['tr',],
'geldim'=>['tr',],
'geldin'=>['tr',],
'geldiniz'=>['tr',],
'gelditu'=>['eu',],
'gelecek'=>['tr',],
'geleden'=>['nl',],
'geleef'=>['af',],
'geleer'=>['af',],
'geleerd'=>['nl',],
'gelei'=>['af',],
'gelen'=>['tr',],
'geliefde'=>['af',],
'gelijk'=>['nl',],
'gelin'=>['tr',],
'gelip'=>['tr',],
'gelir'=>['tr',],
'geliyor'=>['tr',],
'geliyorum'=>['tr',],
'gelmek'=>['tr',],
'gelmiş'=>['tr',],
'gelofte'=>['af',],
'gelombang'=>['id',],
'geloof'=>['nl',],
'gelooft'=>['nl',],
'geloven'=>['nl',],
'geluk'=>['af','nl',],
'gelukkig'=>['nl',],
'gelukkige'=>['af',],
'gelyk'=>['af',],
'gemaak'=>['af',],
'gemaakt'=>['nl',],
'gemacht'=>['de',],
'gemiddelde'=>['af',],
'gen'=>['id',],
'genadig'=>['af',],
'genau'=>['de',],
'genauso'=>['de',],
'geneem'=>['af',],
'genees'=>['af',],
'genera'=>['la',],
'generaal'=>['nl',],
'general'=>['ca','da','de','en','es','nb','no','pt','pt_br','sl','sv','th','tr',],
'generale'=>['it',],
'generasi'=>['id',],
'genere'=>['it','la',],
'generis'=>['la',],
'genetik'=>['id',],
'gengið'=>['is',],
'gengur'=>['is',],
'genial'=>['ca','es',],
'genitori'=>['it',],
'gennem'=>['da',],
'genoeg'=>['af','nl',],
'genoem'=>['af',],
'genom'=>['sv',],
'genomen'=>['nl',],
'genommen'=>['de',],
'genre'=>['fr',],
'gens'=>['ca','fr',],
'gent'=>['ca',],
'gente'=>['es','it','pt','pt_br',],
'gentes'=>['la',],
'gentibus'=>['la',],
'gentil'=>['fr',],
'gentile'=>['it',],
'gentium'=>['la',],
'gentlemen'=>['en',],
'genug'=>['de',],
'genuke'=>['eu',],
'genul'=>['ro',],
'genus'=>['la',],
'genç'=>['tr',],
'geologi'=>['id',],
'george'=>['ca','da','de','en','es','et','fi','fr','hr','hu','is','it','ms','nb','nl','no','pl','pt','pt_br','ro','sl','sv','tr',],
'georgia'=>['si',],
'gepaard'=>['af',],
'gepraat'=>['af',],
'geprobeerd'=>['nl',],
'geprys'=>['af',],
'ger'=>['sv',],
'gera'=>['eu','is','lt',],
'geraak'=>['af',],
'geraakt'=>['nl',],
'gerade'=>['de',],
'gerai'=>['lt',],
'gerakan'=>['id',],
'geras'=>['lt',],
'gerast'=>['is',],
'geratuko'=>['eu',],
'geratzen'=>['eu',],
'gered'=>['af','nl',],
'geregtigheid'=>['af',],
'gerek'=>['tr',],
'gereken'=>['tr',],
'gerekir'=>['tr',],
'gerekiyor'=>['tr',],
'gerektiğini'=>['tr',],
'geri'=>['is','lt','tr',],
'geriau'=>['lt',],
'geriausia'=>['lt',],
'geriausias'=>['lt',],
'gerir'=>['is',],
'gerist'=>['is',],
'gerið'=>['is',],
'germana'=>['ca',],
'germans'=>['ca',],
'germà'=>['ca',],
'gern'=>['de',],
'gerne'=>['da','de',],
'gero'=>['eu','lt',],
'geros'=>['lt',],
'gert'=>['is',],
'gertatu'=>['eu',],
'gertatzen'=>['eu',],
'gertutik'=>['eu',],
'gerum'=>['is',],
'gery'=>['af',],
'gerçek'=>['tr',],
'gerçekten'=>['tr',],
'gerçeği'=>['tr',],
'gerði'=>['is',],
'gerðir'=>['is',],
'gerðirðu'=>['is',],
'gerðist'=>['is',],
'gerðu'=>['is',],
'gesagt'=>['de',],
'geschafft'=>['de',],
'geschehen'=>['de',],
'geschichte'=>['de',],
'geschrieben'=>['de',],
'geschäft'=>['de',],
'gesehen'=>['de',],
'gesicht'=>['de',],
'gesien'=>['af',],
'geskryf'=>['af',],
'geslag'=>['af',],
'gespaar'=>['af',],
'gesprochen'=>['de',],
'gesproken'=>['nl',],
'gesteel'=>['af',],
'gesterf'=>['af',],
'gestern'=>['de',],
'gestolen'=>['nl',],
'gestorben'=>['de',],
'gestuur'=>['af',],
'gesรช'=>['af',],
'get'=>['az','en','fa','is','si','th',],
'geta'=>['is',],
'getan'=>['de',],
'getað'=>['is',],
'geti'=>['is',],
'getir'=>['tr',],
'getið'=>['is',],
'getrek'=>['af',],
'getrippel'=>['af',],
'getroffen'=>['de',],
'getrou'=>['af',],
'getrouwd'=>['nl',],
'gets'=>['en',],
'gett'=>['sv',],
'getting'=>['en','th',],
'getum'=>['is',],
'getur'=>['is',],
'geturðu'=>['is',],
'getwyfel'=>['af',],
'getötet'=>['de',],
'gevaar'=>['nl',],
'gevaarlijk'=>['nl',],
'gevaarlik'=>['af',],
'geval'=>['af','nl',],
'gevangenis'=>['nl',],
'geveg'=>['af',],
'geven'=>['nl',],
'gevind'=>['af',],
'gevlieg'=>['af',],
'gevoel'=>['af','nl',],
'gevolg'=>['af',],
'gevonden'=>['nl',],
'gevra'=>['af',],
'gevraagd'=>['nl',],
'gewankel'=>['af',],
'geweest'=>['nl',],
'geweet'=>['af',],
'geweld'=>['af',],
'geweldig'=>['af','nl',],
'geweldige'=>['nl',],
'gewesen'=>['de',],
'gewillig'=>['af',],
'gewoon'=>['nl',],
'geword'=>['af',],
'geworden'=>['de','nl',],
'gewy'=>['af',],
'gewys'=>['af',],
'gezegd'=>['nl',],
'gezicht'=>['nl',],
'gezien'=>['nl',],
'geç'=>['tr',],
'geçen'=>['tr',],
'geçti'=>['tr',],
'gi'=>['lt','nb','no',],
'gia'=>['it',],
'gib'=>['de',],
'gibi'=>['tr',],
'gibitaka'=>['hi',],
'gibt'=>['de',],
'gick'=>['sv',],
'gidaritza'=>['eu',],
'gidelim'=>['tr',],
'gider'=>['da','tr',],
'gidin'=>['tr',],
'gidip'=>['tr',],
'gidiyor'=>['tr',],
'gidiyorsun'=>['tr',],
'gidiyorum'=>['tr',],
'gidiyoruz'=>['tr',],
'gift'=>['da','nb','no','sv',],
'gifta'=>['sv',],
'giftast'=>['is',],
'gifte'=>['nb','no',],
'gigi'=>['ms',],
'gik'=>['da',],
'gikk'=>['nb','no',],
'gila'=>['ms',],
'gillade'=>['sv',],
'gillar'=>['sv',],
'ginela'=>['eu',],
'ginen'=>['eu',],
'ging'=>['de','nl',],
'gingen'=>['nl',],
'ginklą'=>['lt',],
'gintuen'=>['eu',],
'giocare'=>['it',],
'gioco'=>['it',],
'giornata'=>['it',],
'giorni'=>['it',],
'giorno'=>['it',],
'giovane'=>['it',],
'gir'=>['nb','no','tr',],
'girdi'=>['lt',],
'girdėjai'=>['lt',],
'girdėjau'=>['lt',],
'giriş'=>['az',],
'girl'=>['en','si',],
'girls'=>['en',],
'giro'=>['it',],
'gisteren'=>['nl',],
'git'=>['tr',],
'gitmek'=>['tr',],
'gitmem'=>['tr',],
'gitsin'=>['tr',],
'gitt'=>['nb','no',],
'gitti'=>['tr',],
'giuro'=>['it',],
'giusto'=>['it',],
'giv'=>['da',],
'give'=>['da','en','si','th',],
'given'=>['en',],
'giver'=>['da',],
'givet'=>['da',],
'giving'=>['en',],
'gizajoak'=>['eu',],
'gizaki'=>['eu',],
'gizli'=>['tr',],
'gizon'=>['eu',],
'gizona'=>['eu',],
'già'=>['it',],
'giù'=>['it',],
'gjak'=>['sq',],
'gjallë'=>['sq',],
'gjashtë'=>['sq',],
'gjatë'=>['sq',],
'gje'=>['sq',],
'gjej'=>['sq',],
'gjejmë'=>['sq',],
'gjelder'=>['nb','no',],
'gjendje'=>['sq',],
'gjeni'=>['sq',],
'gjennom'=>['nb','no',],
'gjerne'=>['nb','no',],
'gjesh'=>['sq',],
'gjeta'=>['sq',],
'gjetur'=>['sq',],
'gjith'=>['sq',],
'gjitha'=>['sq',],
'gjithashtu'=>['sq',],
'gjithe'=>['sq',],
'gjithmonë'=>['sq',],
'gjithnjë'=>['sq',],
'gjithsesi'=>['sq',],
'gjithçka'=>['sq',],
'gjithë'=>['sq',],
'gjithëve'=>['sq',],
'gjor'=>['nb','no',],
'gjorde'=>['da','nb','no','sv',],
'gjort'=>['da','nb','no','sv',],
'gjë'=>['sq',],
'gjëja'=>['sq',],
'gjëra'=>['sq',],
'gjërat'=>['sq',],
'gjør'=>['nb','no',],
'gjøre'=>['nb','no',],
'glad'=>['da','en','nb','no','sv',],
'glaub'=>['de',],
'glaube'=>['de',],
'glauben'=>['de',],
'glaubst'=>['de',],
'glaubt'=>['de',],
'glavni'=>['bs','hr','sl','sr',],
'glavo'=>['sl',],
'glavu'=>['bs','hr','sr',],
'gledaj'=>['bs','hr','sr',],
'gledam'=>['bs','sr',],
'gledati'=>['hr',],
'gledaљ'=>['sr',],
'glede'=>['sl',],
'gleich'=>['de',],
'glej'=>['sl',],
'glem'=>['da','nb','no',],
'glemme'=>['da','nb','no',],
'glemt'=>['da','nb','no',],
'glemte'=>['da','nb','no',],
'gleymdu'=>['is',],
'gli'=>['it',],
'glielo'=>['it',],
'glo'=>['af',],
'global'=>['id',],
'gloria'=>['la',],
'gloriam'=>['la',],
'gluži'=>['lv',],
'glöm'=>['sv',],
'glömde'=>['sv',],
'glömma'=>['sv',],
'glück'=>['de',],
'glücklich'=>['de',],
'gmteam'=>['el',],
'go'=>['en','fa','ms','pl','si','th',],
'goazen'=>['eu',],
'goberno'=>['gl',],
'gobierno'=>['es',],
'god'=>['af','bs','da','en','hr','nb','nl','no','si','sr','sv',],
'goda'=>['sv',],
'goddag'=>['da',],
'goddamn'=>['en',],
'gode'=>['af','da','nb','no',],
'godeste'=>['da',],
'godina'=>['bs','hr','sr',],
'godine'=>['bs','hr','sr',],
'godinu'=>['hr','sr',],
'godmorgen'=>['da',],
'godnat'=>['da',],
'godslastering'=>['af',],
'godt'=>['da','nb','no',],
'godzin'=>['pl',],
'godziny'=>['pl',],
'godzinę'=>['pl',],
'godīgi'=>['lv',],
'goed'=>['af','nl',],
'goede'=>['nl',],
'goedemorgen'=>['nl',],
'goeie'=>['af','nl',],
'goes'=>['en',],
'gogaikarria'=>['eu',],
'gogor'=>['eu',],
'gogorra'=>['eu',],
'gogortzat'=>['eu',],
'goian'=>['eu',],
'going'=>['en','fa','si','th',],
'goiz'=>['eu',],
'gojën'=>['sq',],
'gold'=>['en',],
'goldilocks'=>['id',],
'golfa'=>['eu',],
'golfean'=>['eu',],
'gonbidatua'=>['eu',],
'gond'=>['hu',],
'gondol'=>['hu',],
'gondolja'=>['hu',],
'gondolod'=>['hu',],
'gondolok'=>['hu',],
'gondolom'=>['hu',],
'gondolsz'=>['hu',],
'gondoltam'=>['hu',],
'gone'=>['en',],
'gonna'=>['af','en','fa','th',],
'gonosz'=>['hu',],
'gonzález'=>['gl',],
'good'=>['en','si','th',],
'goodbye'=>['en','si',],
'gooi'=>['af','nl',],
'gor'=>['eu','sl',],
'gorde'=>['eu',],
'gore'=>['bs','hr','sr',],
'gos'=>['ca',],
'gosaldu'=>['eu',],
'gosaria'=>['eu',],
'gosh'=>['af',],
'gosp'=>['hr',],
'gospa'=>['sl',],
'gospod'=>['sl',],
'gospodin'=>['bs','hr','sr',],
'gospodine'=>['bs','hr','sr',],
'gospodična'=>['sl',],
'gospodje'=>['sl',],
'gospodo'=>['bs','hr','sr',],
'gospođo'=>['hr',],
'gospoрo'=>['sr',],
'gosta'=>['pt','pt_br',],
'gostar'=>['pt',],
'gostaria'=>['pt','pt_br',],
'gostas'=>['pt',],
'gostava'=>['pt',],
'gosto'=>['pt','pt_br',],
'got'=>['en','th',],
'gotovo'=>['bs','hr','sl','sr',],
'gotowi'=>['pl',],
'gotowy'=>['pl',],
'gott'=>['de','is','sv',],
'gotta'=>['en','th',],
'gottes'=>['de',],
'gou'=>['af',],
'goue'=>['af',],
'govern'=>['ca',],
'government'=>['en',],
'governo'=>['it','pt','pt_br',],
'govori'=>['bs','hr','sl','sr',],
'govoril'=>['sl',],
'govorila'=>['sl',],
'govorim'=>['bs','hr','sl','sr',],
'govoriti'=>['hr','sl',],
'govoriš'=>['hr','sl',],
'govoriљ'=>['sr',],
'gra'=>['pl',],
'graag'=>['af','nl',],
'grabbar'=>['sv',],
'grabben'=>['sv',],
'gracias'=>['es','gl',],
'gracioso'=>['es',],
'grad'=>['bs','hr','sr',],
'grada'=>['bs','hr','sr',],
'grado'=>['it',],
'gradu'=>['bs','hr','sr',],
'grae'=>['it',],
'graeci'=>['la',],
'gran'=>['ca','es','gl','it',],
'grand'=>['fr',],
'grande'=>['es','fr','gl','it','pt','pt_br',],
'grandes'=>['es','gl','pt','pt_br',],
'grandi'=>['it',],
'grans'=>['ca',],
'grant'=>['si',],
'grapje'=>['nl',],
'grappig'=>['nl',],
'gras'=>['af',],
'gratia'=>['la',],
'gratiam'=>['la',],
'gratulerer'=>['nb','no',],
'gratulálok'=>['hu',],
'grave'=>['fr','si',],
'gravitasi'=>['id',],
'grazie'=>['it',],
'graças'=>['pt','pt_br',],
'grać'=>['pl',],
'graži'=>['lt',],
'gražu'=>['lt',],
'gražus'=>['lt',],
'gre'=>['sl',],
'great'=>['en','th',],
'gredzens'=>['lv',],
'gredzenu'=>['lv',],
'greeksubs'=>['th',],
'green'=>['en','th',],
'greier'=>['nb',],
'greit'=>['lt','nb','no',],
'greitai'=>['lt',],
'greiða'=>['is',],
'greičiau'=>['lt',],
'grem'=>['sl',],
'gremo'=>['sl',],
'greste'=>['sl',],
'greu'=>['ca','ro',],
'greva'=>['sl',],
'greşit'=>['ro',],
'greš'=>['sl',],
'grib'=>['lv',],
'gribat'=>['lv',],
'gribi'=>['lv',],
'gribu'=>['lv',],
'gribēja'=>['lv',],
'gribēju'=>['lv',],
'gribētu'=>['lv',],
'grija'=>['ro',],
'griji'=>['ro',],
'grijă'=>['ro',],
'groep'=>['nl',],
'groepsdruk'=>['af',],
'groit'=>['th',],
'grond'=>['nl',],
'groot'=>['af','nl',],
'grootste'=>['nl',],
'gros'=>['fr',],
'grosse'=>['fr',],
'grosso'=>['it',],
'grote'=>['nl',],
'ground'=>['en','si',],
'group'=>['en',],
'groupe'=>['fr',],
'grozav'=>['ro',],
'grozno'=>['sl',],
'groß'=>['de',],
'großartig'=>['de',],
'große'=>['de',],
'großen'=>['de',],
'großer'=>['de',],
'grrrrowl'=>['af',],
'grua'=>['sq',],
'gruaja'=>['sq',],
'gruan'=>['sq',],
'grund'=>['da','de','sv',],
'grunn'=>['nb','no',],
'grup'=>['ca',],
'grupo'=>['es','gl','pt','pt_br',],
'grupos'=>['gl',],
'gruppo'=>['it',],
'gryp'=>['af',],
'gràcies'=>['ca',],
'grâce'=>['fr',],
'grínast'=>['is',],
'grāmatas'=>['lv',],
'grāmatu'=>['lv',],
'grįšiu'=>['lt',],
'grįžk'=>['lt',],
'grįžti'=>['lt',],
'grūti'=>['lv',],
'guai'=>['it',],
'guanyar'=>['ca',],
'guarda'=>['it','pt','pt_br',],
'guardare'=>['it',],
'guardate'=>['it',],
'guardi'=>['it',],
'guardia'=>['it',],
'gud'=>['da','nb','no','sv',],
'gudarako'=>['eu',],
'gudariak'=>['eu',],
'guds'=>['da','nb','no','sv',],
'guerra'=>['ca','es','gl','it','pt','pt_br',],
'guerre'=>['fr',],
'guess'=>['en',],
'gueule'=>['fr',],
'gulēt'=>['lv',],
'gun'=>['en',],
'gunakan'=>['ms',],
'gunung'=>['id',],
'gura'=>['ro',],
'gure'=>['eu',],
'guru'=>['ms',],
'gurun'=>['id',],
'gurur'=>['tr',],
'gură'=>['ro',],
'gust'=>['ca',],
'gusta'=>['es',],
'gustan'=>['es',],
'gustaría'=>['es',],
'gustatu'=>['eu',],
'gustatzen'=>['eu',],
'gusto'=>['es',],
'gustukoa'=>['eu',],
'gut'=>['de',],
'gute'=>['de',],
'guten'=>['de',],
'guter'=>['de',],
'gutes'=>['de',],
'gutt'=>['nb','no',],
'gutten'=>['nb','no',],
'gutter'=>['da','nb','no',],
'guy'=>['en',],
'guyett'=>['ca',],
'guys'=>['en','ms','si','th',],
'guzti'=>['eu',],
'guztia'=>['eu',],
'guztiak'=>['eu',],
'guztietan'=>['eu',],
'guð'=>['is',],
'gyere'=>['hu',],
'gyerek'=>['hu',],
'gyerekek'=>['hu',],
'gyertek'=>['hu',],
'gyerünk'=>['hu',],
'gyilkos'=>['hu',],
'gyorsan'=>['hu',],
'gyselaar'=>['af',],
'gyvas'=>['lt',],
'gyvena'=>['lt',],
'gyvenimas'=>['lt',],
'gyvenime'=>['lt',],
'gyvenimo'=>['lt',],
'gyvenimą'=>['lt',],
'gyventi'=>['lt',],
'gyönyörű'=>['hu',],
'gând'=>['ro',],
'gândeam'=>['ro',],
'gândesc'=>['ro',],
'gândeşti'=>['ro',],
'gândit'=>['ro',],
'gäller'=>['sv',],
'gärna'=>['sv',],
'gå'=>['da','nb','no','sv',],
'gået'=>['da',],
'gång'=>['sv',],
'gången'=>['sv',],
'gånger'=>['sv',],
'går'=>['da','nb','no','sv',],
'gått'=>['nb','no','sv',],
'gær'=>['is',],
'gæti'=>['is',],
'gætir'=>['is',],
'gætum'=>['is',],
'génial'=>['fr',],
'général'=>['fr',],
'gëzohem'=>['sq',],
'gëzuar'=>['sq',],
'góry'=>['pl',],
'górze'=>['pl',],
'górę'=>['pl',],
'gówno'=>['pl',],
'góð'=>['is',],
'góða'=>['is',],
'góðan'=>['is',],
'góðu'=>['is',],
'góður'=>['is',],
'göndər'=>['az',],
'göndərən'=>['az',],
'gör'=>['sv',],
'göra'=>['sv',],
'gördüm'=>['tr',],
'gördün'=>['tr',],
'göre'=>['tr',],
'görmedim'=>['tr',],
'görmek'=>['tr',],
'görmeye'=>['tr',],
'görünüyor'=>['tr',],
'görünüyorsun'=>['tr',],
'görüyor'=>['tr',],
'görüyorum'=>['tr',],
'görüşürüz'=>['tr',],
'görə'=>['az',],
'göster'=>['tr',],
'göstər'=>['az',],
'göstərir'=>['az',],
'göz'=>['tr',],
'gør'=>['da','no',],
'gøre'=>['da','no',],
'gøy'=>['nb',],
'güle'=>['tr',],
'gün'=>['az','tr',],
'günaydın'=>['tr',],
'güneş'=>['tr',],
'günler'=>['tr',],
'günü'=>['tr',],
'günün'=>['az',],
'güvenlik'=>['tr',],
'güzel'=>['tr',],
'güç'=>['tr',],
'güçlü'=>['tr',],
'gāja'=>['lv',],
'găsesc'=>['ro',],
'găsi'=>['ro',],
'găsim'=>['ro',],
'găsit'=>['ro',],
'głowie'=>['pl',],
'głowy'=>['pl',],
'głowę'=>['pl',],
'głupi'=>['pl',],
'gəzən'=>['az',],
'h'=>['az','fr','is','no','sv',],
'ha'=>['bs','ca','da','en','es','gl','hr','hu','is','it','ms','nb','no','sk','sl','sq','sr','sv','tr',],
'haal'=>['nl',],
'haar'=>['af','nl',],
'haast'=>['nl',],
'haat'=>['af','nl',],
'hab'=>['de',],
'habe'=>['de',],
'habeat'=>['la',],
'habebat'=>['la',],
'haben'=>['de',],
'habent'=>['la',],
'habeo'=>['la',],
'haber'=>['es','tr',],
'habere'=>['la',],
'haberet'=>['la',],
'haberá'=>['gl',],
'habet'=>['la',],
'habitació'=>['ca',],
'habitación'=>['es',],
'habitude'=>['fr',],
'habla'=>['es',],
'hablando'=>['es',],
'hablar'=>['es',],
'hablas'=>['es',],
'hablo'=>['es',],
'habrá'=>['es',],
'habría'=>['es',],
'habt'=>['de',],
'habuit'=>['la',],
'había'=>['es','gl',],
'hac'=>['la',],
'hace'=>['es',],
'hacemos'=>['es',],
'hacen'=>['es',],
'hacer'=>['es',],
'hacerlo'=>['es',],
'haces'=>['es',],
'hacia'=>['es',],
'haciendo'=>['es',],
'hacía'=>['es',],
'had'=>['en','nl','si','th',],
'hadd'=>['hu',],
'hadde'=>['nb','no',],
'hadden'=>['nl',],
'hade'=>['sv',],
'hader'=>['da',],
'hadi'=>['tr',],
'hadiah'=>['ms',],
'hadnagy'=>['hu',],
'hae'=>['fi',],
'haec'=>['la',],
'haen'=>['fi',],
'hafa'=>['is',],
'hafi'=>['is',],
'hafir'=>['is',],
'hafið'=>['is',],
'haft'=>['da','is','sv',],
'hafta'=>['tr',],
'hafði'=>['is',],
'hafðu'=>['is',],
'haga'=>['es',],
'hagas'=>['es',],
'hagi'=>['ca',],
'hago'=>['es',],
'hagut'=>['ca',],
'hagués'=>['ca',],
'hagyd'=>['hu',],
'hagyj'=>['hu',],
'hagyja'=>['hu',],
'hagyjuk'=>['hu',],
'hah'=>['ms',],
'hahahahahaaa'=>['af',],
'hai'=>['gl','it','ms','ro',],
'haide'=>['ro',],
'haideţi'=>['ro',],
'haig'=>['ca',],
'haige'=>['et',],
'haiget'=>['et',],
'hain'=>['eu',],
'hair'=>['en',],
'haista'=>['fi',],
'haittaa'=>['fi',],
'hajde'=>['bs','hr','sq','sr',],
'hajdemo'=>['bs','hr','sr',],
'hak'=>['id','ms','tr',],
'hakemaan'=>['fi',],
'hakka'=>['et',],
'hakkab'=>['et',],
'hakkad'=>['et',],
'hakkama'=>['et',],
'hakkame'=>['et',],
'hakkan'=>['et',],
'hakkas'=>['et',],
'hakkında'=>['tr',],
'haklı'=>['tr',],
'haklısın'=>['tr',],
'hal'=>['id','ms',],
'hala'=>['eu','tr',],
'halb'=>['et',],
'halda'=>['is',],
'halde'=>['tr',],
'haldið'=>['is',],
'halen'=>['nl',],
'half'=>['af','en','nl',],
'hallani'=>['hu',],
'hallgass'=>['hu',],
'hallo'=>['af','da','de','et','lv','nb','nl','no',],
'hallom'=>['hu',],
'halloo'=>['et',],
'hallottam'=>['hu',],
'hallå'=>['sv',],
'halló'=>['hu','is',],
'halo'=>['bs','hr','ms','pl','sl','sr',],
'haloo'=>['fi',],
'halott'=>['hu',],
'halt'=>['de','hu',],
'halte'=>['de',],
'halten'=>['de',],
'haltu'=>['is',],
'halua'=>['fi',],
'haluaa'=>['fi',],
'haluaisi'=>['fi',],
'haluaisin'=>['fi',],
'haluamme'=>['fi',],
'haluan'=>['fi',],
'haluat'=>['fi',],
'haluatko'=>['fi',],
'haluatte'=>['fi',],
'haluavat'=>['fi',],
'halunnut'=>['fi',],
'halusi'=>['fi',],
'halusin'=>['fi',],
'halv'=>['da','nb','no',],
'halál'=>['hu',],
'haló'=>['cs','sk',],
'ham'=>['da','nb','no',],
'hamarosan'=>['hu',],
'hambre'=>['es',],
'hamingju'=>['is',],
'hammer'=>['si',],
'hampir'=>['id','ms',],
'han'=>['ca','da','es','eu','nb','no','sv',],
'hana'=>['is',],
'hanc'=>['la',],
'hand'=>['de','en','nl','sv',],
'handa'=>['is',],
'hande'=>['af',],
'handen'=>['nl',],
'handia'=>['eu',],
'handiak'=>['eu',],
'handik'=>['eu',],
'handitzen'=>['eu',],
'handlar'=>['sv',],
'handle'=>['en',],
'handler'=>['da','nb','no',],
'hands'=>['en','th',],
'hanem'=>['hu',],
'hang'=>['en',],
'hangi'=>['tr',],
'hangoa'=>['eu',],
'hangzik'=>['hu',],
'hann'=>['is',],
'hanna'=>['lv',],
'hanno'=>['it',],
'hans'=>['da','is','nb','no','sv',],
'hanuman'=>['af',],
'hanya'=>['id','ms',],
'hap'=>['sq',],
'hape'=>['sq',],
'happen'=>['en',],
'happened'=>['en',],
'happening'=>['en',],
'happens'=>['en',],
'happy'=>['en','si',],
'hapur'=>['sq',],
'haqqında'=>['az',],
'har'=>['da','eu','nb','no','sv',],
'harap'=>['ms',],
'harapan'=>['ms',],
'hard'=>['en','nl','si',],
'hardt'=>['nb','no',],
'hareket'=>['tr',],
'haremos'=>['es',],
'harfiah'=>['id',],
'hari'=>['eu','id','lt','ms',],
'hariak'=>['eu',],
'harij'=>['lv',],
'harijs'=>['lv',],
'harika'=>['tr',],
'harrass'=>['af',],
'harrian'=>['eu',],
'harrievo'=>['hi',],
'harro'=>['eu',],
'harroje'=>['sq',],
'harry'=>['ca','da','de','en','es','et','hu','is','it','ms','nb','nl','no','pt','ro','sk','sl','sv','tr',],
'hart'=>['af','de','nl',],
'hartlam'=>['af',],
'hartseer'=>['af',],
'hartu'=>['eu',],
'harus'=>['id','ms',],
'harusnya'=>['ms',],
'hará'=>['es',],
'haré'=>['es',],
'haría'=>['es',],
'has'=>['ca','en','es','eu','la','si','th',],
'haserrea'=>['eu',],
'haserretu'=>['eu',],
'haserretuko'=>['eu',],
'hasi'=>['eu',],
'hasieratik'=>['eu',],
'hasil'=>['id',],
'hasn'=>['en',],
'hasse'=>['de',],
'hast'=>['de',],
'hasta'=>['es','tr',],
'hat'=>['de','hu',],
'hata'=>['is','tr',],
'hatalmas'=>['hu',],
'hatar'=>['sv',],
'hate'=>['en',],
'hater'=>['nb','no',],
'hati'=>['id','ms',],
'hatt'=>['nb','no',],
'hatta'=>['tr',],
'hatte'=>['de',],
'hatten'=>['de',],
'hattest'=>['de',],
'hatırlıyor'=>['tr',],
'hau'=>['eu',],
'haud'=>['la',],
'hauei'=>['eu',],
'haurdun'=>['eu',],
'hauria'=>['ca',],
'hauries'=>['ca',],
'haurà'=>['ca',],
'hauríem'=>['ca',],
'haus'=>['de',],
'hause'=>['de',],
'hauska'=>['fi',],
'hauskaa'=>['fi',],
'haut'=>['fr',],
'hav'=>['da',],
'hava'=>['tr',],
'havde'=>['da','no',],
'have'=>['da','en','fa','no','si','th',],
'haven'=>['en',],
'haver'=>['ca','hu','pt','pt_br',],
'havia'=>['ca','pt','pt_br',],
'havien'=>['ca',],
'havies'=>['ca',],
'having'=>['en',],
'havíem'=>['ca',],
'hawaiiki'=>['eu',],
'hawaiikitik'=>['eu',],
'hay'=>['es','hi',],
'haya'=>['es',],
'hayal'=>['tr',],
'hayat'=>['tr',],
'hayatta'=>['tr',],
'hayatım'=>['tr',],
'hayatını'=>['tr',],
'haydi'=>['tr',],
'hayır'=>['tr',],
'haz'=>['es',],
'haza'=>['hu',],
'haziak'=>['eu',],
'hazlo'=>['es',],
'hazten'=>['eu',],
'hazır'=>['tr',],
'he'=>['ca','de','en','es','fa','fi','nl','si','th',],
'hea'=>['et',],
'head'=>['en','et','th',],
'heaks'=>['et',],
'healthy'=>['si',],
'hear'=>['en','th',],
'heard'=>['en',],
'heart'=>['en','si','th',],
'heaven'=>['en',],
'heavies'=>['hi',],
'heavy'=>['si',],
'heb'=>['nl',],
'hebat'=>['ms',],
'hebben'=>['nl',],
'hebt'=>['nl',],
'hecho'=>['es',],
'hedatu'=>['eu',],
'hedder'=>['da',],
'heeft'=>['nl',],
'heel'=>['nl',],
'heeltemal'=>['af',],
'heen'=>['nl',],
'heer'=>['nl',],
'heet'=>['nl',],
'hef'=>['is',],
'hefur'=>['is',],
'hefurðu'=>['is',],
'hefði'=>['is',],
'hefðir'=>['is',],
'hei'=>['et','fi','lv','ms','nb','no','ro',],
'heidän'=>['fi',],
'heidät'=>['fi',],
'heilige'=>['af',],
'heille'=>['fi',],
'heillä'=>['fi',],
'heim'=>['is',],
'heima'=>['is',],
'heimi'=>['is',],
'heiminum'=>['is',],
'hein'=>['fr','pt_br',],
'heiraten'=>['de',],
'heistä'=>['fi',],
'heiti'=>['is',],
'heitir'=>['is',],
'heitä'=>['fi',],
'heißen'=>['de',],
'heißt'=>['de',],
'hej'=>['bs','cs','da','hr','no','pl','sk','sl','sq','sr','sv',],
'hel'=>['nl','sv',],
'hela'=>['sv',],
'held'=>['da','is',],
'helderder'=>['af',],
'heldu'=>['eu',],
'heldur'=>['is',],
'heldurðu'=>['is',],
'hele'=>['af','cs','da','nb','nl','no',],
'helemaal'=>['nl',],
'helfen'=>['de',],
'helfte'=>['af',],
'helista'=>['et',],
'helistan'=>['et',],
'helium'=>['id',],
'hell'=>['en','si',],
'heller'=>['da','nb','no','sv',],
'hellere'=>['da',],
'hello'=>['en','hu','ms','si','th',],
'helló'=>['hu',],
'help'=>['af','en','nl','si','th',],
'helpen'=>['nl',],
'helppoa'=>['fi',],
'helpt'=>['nl',],
'helst'=>['da','nb','no','sv',],
'helt'=>['da','nb','no','sv',],
'helvede'=>['da',],
'helvete'=>['nb','no','sv',],
'helvetin'=>['fi',],
'helvetti'=>['fi',],
'helvettiin'=>['fi',],
'helvettiä'=>['fi',],
'helvítis'=>['is',],
'hely'=>['hu',],
'helyen'=>['hu',],
'helyes'=>['hu',],
'helyet'=>['hu',],
'helyzet'=>['hu',],
'hem'=>['ca','nl','sv','tr',],
'hemel'=>['af','nl',],
'hemen'=>['eu','tr',],
'hemendik'=>['eu',],
'hemi'=>['eu',],
'hemma'=>['sv',],
'hemos'=>['es',],
'hemskt'=>['sv',],
'hen'=>['da','nl','no',],
'hende'=>['da','no',],
'hendene'=>['nb','no',],
'hender'=>['nb','no',],
'hendes'=>['da',],
'hendur'=>['is',],
'hennar'=>['is',],
'henne'=>['nb','no','sv',],
'hennes'=>['nb','no','sv',],
'henni'=>['is',],
'hent'=>['da','nb','no',],
'hente'=>['da','nb','no',],
'henter'=>['da','nb','no',],
'hentikan'=>['ms',],
'henüz'=>['tr',],
'hep'=>['tr',],
'hepimiz'=>['tr',],
'hepiniz'=>['tr',],
'hepsi'=>['tr',],
'hepsini'=>['tr',],
'heq'=>['sq',],
'her'=>['da','de','en','fa','nb','no','si','th','tr',],
'hera'=>['sq',],
'heran'=>['id',],
'heraus'=>['de',],
'herbal'=>['si',],
'herbergi'=>['is',],
'here'=>['af','en','fa','si','sq','th',],
'heren'=>['nl',],
'herfra'=>['da','nb','no',],
'herhalde'=>['tr',],
'herhangi'=>['tr',],
'herif'=>['tr',],
'herinde'=>['da',],
'herinner'=>['af','nl',],
'herinneren'=>['nl',],
'herkes'=>['tr',],
'herkesin'=>['tr',],
'hermana'=>['es',],
'hermano'=>['es',],
'hermosa'=>['es',],
'hermoso'=>['es',],
'herr'=>['de','nb','no','sv',],
'herra'=>['fi','is',],
'herrar'=>['is','sv',],
'herrat'=>['fi',],
'herre'=>['da','nb','no','sv',],
'herregud'=>['nb','no','sv',],
'herren'=>['de',],
'herrer'=>['da','nb','no',],
'hertil'=>['da',],
'herum'=>['de',],
'herz'=>['de',],
'herë'=>['sq',],
'herën'=>['sq',],
'herët'=>['sq',],
'herşey'=>['tr',],
'herşeyi'=>['tr',],
'het'=>['af','nb','nl',],
'heter'=>['nb','no','sv',],
'heti'=>['fi',],
'hetk'=>['et',],
'hetkel'=>['et',],
'hetken'=>['fi',],
'hetki'=>['fi',],
'hetkinen'=>['fi',],
'hetzelfde'=>['nl',],
'heu'=>['ca',],
'heuning'=>['af',],
'heure'=>['fr',],
'heures'=>['fr',],
'heureuse'=>['fr',],
'heureux'=>['fr',],
'heute'=>['de',],
'hewan'=>['id','ms',],
'hey'=>['af','da','de','en','es','fa','is','it','lv','ms','nl','no','pt','pt_br','ro','si','sq','th','tr',],
'heyra'=>['is',],
'heyri'=>['is',],
'heyrirðu'=>['is',],
'heyrt'=>['is',],
'heyrði'=>['is',],
'heyrðu'=>['is',],
'heyəti'=>['az',],
'heç'=>['az',],
'hi'=>['ca','de','en','la','ms','si',],
'hic'=>['la',],
'hice'=>['es',],
'hicieron'=>['es',],
'hiciste'=>['es',],
'hide'=>['en',],
'hideg'=>['hu',],
'hiding'=>['th',],
'hidrogen'=>['id',],
'hidup'=>['id','ms',],
'hidupku'=>['ms',],
'hield'=>['nl',],
'hieman'=>['fi',],
'hieno'=>['fi',],
'hienoa'=>['fi',],
'hier'=>['af','de','fr','nl',],
'hierdie'=>['af',],
'hierheen'=>['nl',],
'hierher'=>['de',],
'hierusalem'=>['la',],
'high'=>['af','en',],
'hihetetlen'=>['hu',],
'hij'=>['nl',],
'hija'=>['es',],
'hijo'=>['es',],
'hijos'=>['es',],
'hil'=>['eu',],
'hilang'=>['id','ms',],
'hilda'=>['eu',],
'hildakoren'=>['eu',],
'hilf'=>['de',],
'hilfe'=>['de',],
'hilja'=>['et',],
'hiljaa'=>['fi',],
'hiljaks'=>['et',],
'hiljem'=>['et',],
'hiltzen'=>['eu',],
'him'=>['en','fa','si','th',],
'himmel'=>['de',],
'himmelen'=>['nb',],
'himself'=>['en',],
'hin'=>['de',],
'hinanden'=>['da',],
'hinc'=>['la',],
'hindichitthrapata'=>['si',],
'hingað'=>['is',],
'hingga'=>['ms',],
'hinn'=>['is',],
'hinten'=>['de',],
'hinter'=>['de',],
'hinum'=>['is',],
'hipotesis'=>['id',],
'hirira'=>['eu',],
'hirtelen'=>['hu',],
'his'=>['en','la','si','th',],
'hisk'=>['th',],
'hissediyorum'=>['tr',],
'histoire'=>['fr',],
'histori'=>['sq',],
'historia'=>['es','gl','pl','sv',],
'historie'=>['da','nb','no',],
'historien'=>['da','nb','no',],
'historii'=>['pl',],
'history'=>['en',],
'història'=>['ca',],
'história'=>['pt','pt_br',],
'hisz'=>['hu',],
'hiszed'=>['hu',],
'hiszem'=>['hu',],
'hiszen'=>['hu',],
'hiszi'=>['hu',],
'hit'=>['en','nb','no','sv',],
'hitam'=>['id','ms',],
'hitreje'=>['sl',],
'hitro'=>['sl',],
'hitt'=>['is',],
'hitta'=>['is','sv',],
'hittade'=>['sv',],
'hittar'=>['sv',],
'hittat'=>['sv',],
'hittem'=>['hu',],
'hitti'=>['is',],
'hitto'=>['fi',],
'hitz'=>['eu',],
'hitzaldi'=>['eu',],
'hive'=>['th',],
'hizo'=>['es',],
'hiç'=>['tr',],
'hiçbir'=>['tr',],
'hiša'=>['sl',],
'hiše'=>['sl',],
'hiši'=>['sl',],
'hišo'=>['sl',],
'hjarta'=>['is',],
'hjelp'=>['nb','no',],
'hjelpe'=>['nb','no',],
'hjelper'=>['nb','no',],
'hjem'=>['da','nb','no',],
'hjemme'=>['da','nb','no',],
'hjerte'=>['da','nb','no',],
'hjertet'=>['nb','no',],
'hjá'=>['is',],
'hjálp'=>['is',],
'hjálpa'=>['is',],
'hjálpað'=>['is',],
'hjálpaðu'=>['is',],
'hjälp'=>['sv',],
'hjälpa'=>['sv',],
'hjälper'=>['sv',],
'hjärta'=>['sv',],
'hjælp'=>['da',],
'hjælpe'=>['da',],
'hjælper'=>['da',],
'hlas'=>['sk',],
'hlavne'=>['sk',],
'hlavní'=>['cs',],
'hlavně'=>['cs',],
'hlavu'=>['cs','sk',],
'hlavy'=>['cs','sk',],
'hljómar'=>['is',],
'hlusta'=>['is',],
'hlustaðu'=>['is',],
'hluti'=>['is',],
'hlýtur'=>['is',],
'hm'=>['de','sk',],
'hmm'=>['en','hu','lt','ms','sk',],
'hned'=>['cs',],
'hneď'=>['sk',],
'ho'=>['ca','cs','it','si','sk',],
'hobe'=>['eu',],
'hobeto'=>['eu',],
'hoc'=>['la',],
'hoch'=>['de',],
'hodet'=>['nb','no',],
'hodi'=>['sl',],
'hodie'=>['la',],
'hodin'=>['cs',],
'hodinu'=>['cs','sk',],
'hodiny'=>['cs','sk',],
'hodně'=>['cs',],
'hodín'=>['sk',],
'hoe'=>['af','nl',],
'hoedown'=>['th',],
'hoef'=>['af','nl',],
'hoeft'=>['nl',],
'hoekom'=>['af',],
'hoeveel'=>['af','nl',],
'hoezo'=>['nl',],
'hoffe'=>['de',],
'hogy'=>['hu',],
'hogyan'=>['hu',],
'hoi'=>['nl',],
'hoia'=>['et',],
'hoida'=>['et',],
'hoidan'=>['fi',],
'hoidke'=>['et',],
'hoitaa'=>['fi',],
'hoje'=>['pt','pt_br',],
'hol'=>['de','hu',],
'hola'=>['ca','es',],
'hold'=>['da','en','nb','no','si','th',],
'holde'=>['da','nb','no',],
'holder'=>['da','nb','no',],
'holdt'=>['da','nb','no',],
'hole'=>['de',],
'holen'=>['de',],
'holka'=>['cs',],
'holky'=>['cs',],
'holmes'=>['ca',],
'holnap'=>['hu',],
'holy'=>['en',],
'hom'=>['af',],
'hombre'=>['es',],
'hombres'=>['es',],
'home'=>['af','ca','en','gl','si','th',],
'homem'=>['pt','pt_br',],
'homens'=>['pt','pt_br',],
'homes'=>['ca','gl',],
'homine'=>['la',],
'hominem'=>['la',],
'homines'=>['la',],
'homini'=>['la',],
'hominibus'=>['la',],
'hominis'=>['la',],
'hominum'=>['la',],
'homma'=>['fi',],
'homme'=>['et','fr',],
'hommes'=>['fr',],
'hommikul'=>['et',],
'hommikust'=>['et',],
'homo'=>['la',],
'hon'=>['sv',],
'hona'=>['eu',],
'hond'=>['nl',],
'honderde'=>['af',],
'honekin'=>['eu',],
'honetako'=>['eu',],
'honetan'=>['eu',],
'honetatik'=>['eu',],
'honey'=>['en',],
'honger'=>['nl',],
'honnan'=>['hu',],
'honneur'=>['fr',],
'honom'=>['sv',],
'honor'=>['ca','en','es',],
'honore'=>['la',],
'honra'=>['pt_br',],
'honte'=>['fr',],
'honum'=>['is',],
'hoo'=>['af',],
'hoofd'=>['nl',],
'hoofde'=>['af',],
'hoog'=>['af',],
'hoop'=>['af','nl',],
'hoopis'=>['et',],
'hoor'=>['af','nl',],
'hoorde'=>['nl',],
'hoort'=>['nl',],
'hope'=>['en','si',],
'hopp'=>['nb',],
'hoppa'=>['sv',],
'hoppas'=>['sv',],
'hor'=>['eu',],
'hora'=>['ca','es','gl','pt','pt_br',],
'horas'=>['es','gl','pt','pt_br',],
'hore'=>['sk',],
'horen'=>['nl',],
'hores'=>['ca',],
'horfa'=>['is',],
'hori'=>['eu',],
'horiek'=>['eu',],
'horiengana'=>['eu',],
'horietan'=>['eu',],
'horietatik'=>['eu',],
'horregatik'=>['eu',],
'horrela'=>['eu',],
'horrelako'=>['eu',],
'horren'=>['eu',],
'horretan'=>['eu',],
'horretatik'=>['eu',],
'horretaz'=>['eu',],
'horri'=>['eu',],
'horrible'=>['es',],
'horrível'=>['pt_br',],
'hors'=>['fr',],
'horse'=>['en',],
'hortik'=>['eu',],
'hortza'=>['eu',],
'hortzetan'=>['eu',],
'horum'=>['la',],
'hos'=>['da','la','nb','no','sv',],
'hospital'=>['ca','en','es','pt','pt_br',],
'hosszú'=>['hu',],
'hostem'=>['la',],
'hostes'=>['la',],
'hostibus'=>['la',],
'hostis'=>['la',],
'hostium'=>['la',],
'hot'=>['en','id',],
'hotel'=>['ca','de','en','es','ms','nl','pt','pt_br','sl',],
'hotela'=>['sl',],
'hoteli'=>['sl',],
'hotmail'=>['ar','th',],
'hotzetan'=>['eu',],
'hou'=>['af','nl',],
'houbo'=>['gl',],
'houd'=>['nl',],
'houden'=>['nl',],
'houdt'=>['nl',],
'hour'=>['en',],
'hours'=>['en',],
'house'=>['en','si',],
'houve'=>['pt','pt_br',],
'hova'=>['hu',],
'hoved'=>['da',],
'hovedet'=>['da',],
'hovno'=>['sk',],
'hovor'=>['sk',],
'hovoria'=>['sk',],
'hovoril'=>['sk',],
'hovorila'=>['sk',],
'hovoriť'=>['sk',],
'hovorí'=>['sk',],
'hovorím'=>['sk',],
'hovoríte'=>['sk',],
'hovoríš'=>['sk',],
'hová'=>['hu',],
'how'=>['en','fa','si','th',],
'howdy'=>['si',],
'howe'=>['id',],
'hoxe'=>['gl',],
'hoy'=>['es',],
'hoz'=>['hu',],
'hozd'=>['hu',],
'hozkailuan'=>['eu',],
'hozott'=>['hu',],
'hoztam'=>['hu',],
'hozzá'=>['hu',],
'hozzád'=>['hu',],
'hozzám'=>['hu',],
'hoæeš'=>['bs',],
'hoće'=>['bs','hr',],
'hoćete'=>['bs','hr',],
'hoćeš'=>['bs','hr',],
'hoću'=>['bs','hr',],
'hoče'=>['sl',],
'hočem'=>['sl',],
'hočete'=>['sl',],
'hočeš'=>['sl',],
'hoş'=>['tr',],
'hoşuma'=>['tr',],
'hoşça'=>['tr',],
'hoşçakal'=>['tr',],
'hoжe'=>['bs','sr',],
'hoжemo'=>['sr',],
'hoжete'=>['sr',],
'hoжeљ'=>['bs','hr','sr',],
'hoжu'=>['bs','hr','sr',],
'hr'=>['da','et','is','no',],
'hra'=>['sk',],
'hrano'=>['sl',],
'hratt'=>['is',],
'hrať'=>['sk',],
'hrifinn'=>['is',],
'hringdi'=>['is',],
'hringdu'=>['is',],
'hringi'=>['is',],
'hringja'=>['is',],
'hrozně'=>['cs',],
'hrát'=>['cs',],
'hrædd'=>['is',],
'hræddur'=>['is',],
'htela'=>['sr',],
'hteo'=>['sr',],
'htio'=>['bs','hr',],
'htjela'=>['bs','hr',],
'htjeli'=>['hr',],
'http'=>['pl','si','ur',],
'hubiera'=>['es',],
'hubo'=>['es',],
'hubu'=>['cs','sk',],
'hubungan'=>['id','ms',],
'huckleberry'=>['th',],
'hudiča'=>['sl',],
'hudo'=>['sl',],
'hug'=>['af','is',],
'hugmynd'=>['is',],
'hugsa'=>['is',],
'hugsaðu'=>['is',],
'huh'=>['af','en','ms',],
'hui'=>['fr',],
'huic'=>['la',],
'huidige'=>['af',],
'huil'=>['af',],
'huis'=>['af','nl',],
'huit'=>['fr',],
'huius'=>['la',],
'huiwer'=>['af',],
'hujan'=>['id','ms',],
'hukum'=>['id','ms',],
'hul'=>['af',],
'hull'=>['et',],
'hulle'=>['af',],
'hullu'=>['fi',],
'hulluks'=>['et',],
'hulp'=>['nl',],
'human'=>['en','si',],
'humaniacs'=>['th',],
'humans'=>['ca',],
'humbur'=>['sq',],
'humà'=>['ca',],
'hun'=>['da','nb','nl','no',],
'hunc'=>['la',],
'hund'=>['da','de','nb','no','sv',],
'hunden'=>['nb',],
'hundred'=>['en',],
'hungrig'=>['sv',],
'hungry'=>['en',],
'huoli'=>['fi',],
'huolta'=>['fi',],
'huomenna'=>['fi',],
'huomenta'=>['fi',],
'huono'=>['fi',],
'hur'=>['sv',],
'hurrengoan'=>['eu',],
'hurry'=>['en',],
'hurt'=>['en',],
'hurtigere'=>['da',],
'hurtigt'=>['da',],
'hus'=>['da','nb','no','sv',],
'husband'=>['en',],
'huset'=>['da','nb','no','sv',],
'husk'=>['da','nb','no',],
'huske'=>['da','nb','no',],
'husker'=>['da','nb','no',],
'hut'=>['af',],
'hutan'=>['id','ms',],
'hutsune'=>['eu',],
'huur'=>['af',],
'huvita'=>['et',],
'huvitav'=>['et',],
'huvud'=>['sv',],
'huvudet'=>['sv',],
'huygens'=>['id',],
'hva'=>['da','nb','no',],
'hvad'=>['da','no',],
'hvala'=>['bs','hr','sl','sr',],
'hvao'=>['is',],
'hvar'=>['is',],
'hvað'=>['is',],
'hvaða'=>['is',],
'hvaðan'=>['is',],
'hve'=>['is',],
'hvem'=>['da','nb','no',],
'hvenær'=>['is',],
'hver'=>['da','is','nb','no',],
'hverandre'=>['nb','no',],
'hverjir'=>['is',],
'hverju'=>['is',],
'hverjum'=>['is',],
'hvern'=>['is',],
'hvernig'=>['is',],
'hvers'=>['is',],
'hversu'=>['is',],
'hvert'=>['da','is','nb','no',],
'hvide'=>['da',],
'hvilken'=>['da','nb','no',],
'hvilket'=>['da','nb','no',],
'hvis'=>['da','nb','no',],
'hvite'=>['nb','no',],
'hvor'=>['da','nb','no',],
'hvordan'=>['da','nb','no',],
'hvorfor'=>['da','nb','no',],
'hvornår'=>['da',],
'hvort'=>['is',],
'hví'=>['is',],
'hy'=>['af',],
'hyggelig'=>['nb','no',],
'hyvin'=>['fi',],
'hyviä'=>['fi',],
'hyvä'=>['fi',],
'hyvältä'=>['fi',],
'hyvät'=>['fi',],
'hyvää'=>['fi',],
'há'=>['pt','pt_br',],
'háború'=>['hu',],
'hány'=>['hu',],
'három'=>['hu',],
'hát'=>['hu',],
'hátra'=>['hu',],
'hátt'=>['is',],
'ház'=>['hu',],
'házban'=>['hu',],
'hâlâ'=>['tr',],
'häivy'=>['fi',],
'hälsa'=>['sv',],
'hält'=>['de',],
'hämta'=>['sv',],
'hämtar'=>['sv',],
'hän'=>['fi',],
'hända'=>['sv',],
'hände'=>['de','sv',],
'händer'=>['sv',],
'händerna'=>['sv',],
'häneen'=>['fi',],
'hänelle'=>['fi',],
'hänellä'=>['fi',],
'häneltä'=>['fi',],
'hänen'=>['fi',],
'hänestä'=>['fi',],
'hänet'=>['fi',],
'hänt'=>['sv',],
'häntä'=>['fi',],
'här'=>['sv',],
'härifrån'=>['sv',],
'härra'=>['et',],
'härrased'=>['et',],
'hästi'=>['et',],
'hätte'=>['de',],
'hätten'=>['de',],
'hättest'=>['de',],
'hätänä'=>['fi',],
'hätää'=>['fi',],
'håber'=>['da',],
'håll'=>['sv',],
'hålla'=>['sv',],
'håller'=>['sv',],
'hånd'=>['da','nb','no',],
'hånden'=>['nb','no',],
'håper'=>['nb','no',],
'hår'=>['da','sv',],
'hårdt'=>['da',],
'håret'=>['nb',],
'hårt'=>['sv',],
'hæ'=>['is',],
'hægri'=>['is',],
'hægt'=>['is',],
'hænder'=>['da',],
'hænderne'=>['da',],
'hætta'=>['is',],
'hætti'=>['is',],
'hættið'=>['is',],
'hættu'=>['is',],
'hè'=>['nl',],
'hé'=>['fr','hu','nl',],
'hélt'=>['is',],
'hér'=>['is',],
'hérna'=>['is',],
'hét'=>['hu',],
'héten'=>['hu',],
'héðan'=>['is',],
'hë'=>['sq',],
'hívják'=>['hu',],
'hôpital'=>['fr',],
'hôtel'=>['fr',],
'höfum'=>['is',],
'höger'=>['sv',],
'högt'=>['sv',],
'höldum'=>['is',],
'hölgyeim'=>['hu',],
'hölgyem'=>['hu',],
'höll'=>['sv',],
'hölle'=>['de',],
'hönd'=>['is',],
'hör'=>['de','sv',],
'höra'=>['sv',],
'hörde'=>['sv',],
'höre'=>['de',],
'hören'=>['de',],
'hörst'=>['de',],
'hört'=>['de','sv',],
'hörte'=>['de',],
'højre'=>['da',],
'højt'=>['da',],
'hør'=>['da','nb','no',],
'høre'=>['da','nb','no',],
'hører'=>['da','nb','no',],
'høres'=>['nb','no',],
'hørt'=>['da','nb','no',],
'hørte'=>['da','nb','no',],
'høyre'=>['nb','no',],
'høyt'=>['nb','no',],
'hún'=>['is',],
'hús'=>['is',],
'húsinu'=>['is',],
'húsið'=>['is',],
'hülye'=>['hu',],
'hüvasti'=>['et',],
'hızlı'=>['tr',],
'həm'=>['az',],
'həmin'=>['az',],
'hər'=>['az',],
'hรช'=>['af',],
'i'=>['az','bg','bs','ca','cs','da','de','en','es','et','fa','fr','gl','hr','hu','is','it','lt','lv','ms','nb','nl','no','pl','pt','pt_br','ro','ru','si','sk','sl','sq','sr','sv','th','tr','zh_cn',],
'ia'=>['es','eu','fr','id','it','ms','pt','pt_br','ro','sq',],
'iako'=>['bs','hr','sr',],
'iam'=>['la',],
'iar'=>['ro',],
'iau'=>['ro',],
'iba'=>['es','sk',],
'ibi'=>['la',],
'ibid'=>['la',],
'ibili'=>['eu',],
'ibiltzeaz'=>['eu',],
'ibland'=>['sv',],
'ibu'=>['id','ms',],
'ibuku'=>['ms',],
'ibumu'=>['ms',],
'ice'=>['en',],
'ich'=>['de','pl','sk',],
'ici'=>['fr',],
'icq'=>['az',],
'id'=>['la',],
'idade'=>['gl','pt','pt_br',],
'idag'=>['sv',],
'ide'=>['bs','da','hr','hu','id','ms','sk','sq','sr',],
'idea'=>['ca','en','es','fi','gl','it','si',],
'ideale'=>['af',],
'ideas'=>['gl',],
'idee'=>['af','de','et','nl','ro',],
'ideea'=>['ro',],
'ideia'=>['pt','pt_br',],
'ideja'=>['bs','hr','lv','sl','sr',],
'ideje'=>['hu',],
'idem'=>['bs','hr','la','sk','sr',],
'ideme'=>['sk',],
'idemo'=>['bs','hr','sr',],
'idenë'=>['sq',],
'ideo'=>['la',],
'ideš'=>['bs','hr','sk',],
'ideљ'=>['bs','sr',],
'idi'=>['az','bs','hr','sr',],
'idioot'=>['et','nl',],
'idiootti'=>['fi',],
'idiot'=>['da','de','en','fr','nb','no','sk','sq','sv',],
'idiota'=>['ca','es','it','pt','pt_br',],
'idite'=>['bs','hr','sr',],
'idióta'=>['hu',],
'ido'=>['es',],
'idque'=>['la',],
'idu'=>['bs','hr','sr',],
'idzie'=>['pl',],
'idziemy'=>['pl',],
'idziesz'=>['pl',],
'idé'=>['da','nb','no','sv',],
'idée'=>['fr',],
'idéia'=>['pt','pt_br',],
'idú'=>['sk',],
'idę'=>['pl',],
'idő'=>['hu',],
'időben'=>['hu',],
'időt'=>['hu',],
'idź'=>['pl',],
'ie'=>['fr','nl',],
'ieder'=>['nl',],
'iedere'=>['nl',],
'iedereen'=>['nl',],
'iedod'=>['lv',],
'iedomāties'=>['lv',],
'iei'=>['ro',],
'iekšā'=>['lv',],
'iemand'=>['af','nl',],
'iemesls'=>['lv',],
'iepazīties'=>['lv',],
'iepriekš'=>['lv',],
'ieri'=>['it','ro',],
'ieroci'=>['lv',],
'ies'=>['fr','ro',],
'iesim'=>['lv',],
'iespēja'=>['lv',],
'iespējams'=>['lv',],
'iespējas'=>['lv',],
'iespēju'=>['lv',],
'iesus'=>['la',],
'iet'=>['lv',],
'iets'=>['af','nl',],
'ieu'=>['ca',],
'ieşi'=>['ro',],
'ieşit'=>['ro',],
'iešu'=>['lv',],
'if'=>['en','fa','si','th',],
'ifrån'=>['sv',],
'iga'=>['et',],
'igal'=>['et',],
'iganes'=>['et',],
'igarri'=>['eu',],
'igatahes'=>['et',],
'igaz'=>['hu',],
'igaza'=>['hu',],
'igazad'=>['hu',],
'igazat'=>['hu',],
'igazi'=>['hu',],
'igazság'=>['hu',],
'igazából'=>['hu',],
'igazán'=>['hu',],
'igen'=>['da','hu','no','sv',],
'igennem'=>['da',],
'igenom'=>['sv',],
'igerian'=>['eu',],
'igitur'=>['la',],
'igjen'=>['nb','no',],
'iglesia'=>['es',],
'ignis'=>['la',],
'ignore'=>['fr',],
'igra'=>['bs','hr','sl','sr',],
'igral'=>['sl',],
'igrati'=>['hr',],
'igreja'=>['pt_br',],
'igrexa'=>['gl',],
'igru'=>['bs',],
'igual'=>['ca','es','gl',],
'igång'=>['sv',],
'igår'=>['sv',],
'ih'=>['bs','hr','sr',],
'ihan'=>['fi',],
'ihesa'=>['eu',],
'ihia'=>['eu',],
'ihjel'=>['da',],
'ihm'=>['de',],
'ihminen'=>['fi',],
'ihmiset'=>['fi',],
'ihmisiä'=>['fi',],
'ihmisten'=>['fi',],
'ihn'=>['de',],
'ihnen'=>['de',],
'ihop'=>['sv',],
'ihr'=>['de',],
'ihre'=>['de',],
'ihrem'=>['de',],
'ihren'=>['de',],
'ihrer'=>['de',],
'ihtiyacı'=>['tr',],
'ihtiyacım'=>['tr',],
'ihtiyacımız'=>['tr',],
'ihtiyacın'=>['tr',],
'ihåg'=>['sv',],
'ii'=>['fr','hr','id','it','la','ro',],
'iial'=>['et',],
'iii'=>['hi',],
'iike'=>['en',],
'iis'=>['la',],
'iisuse'=>['ro',],
'ijudi'=>['bs','sr',],
'ik'=>['nl','sq',],
'ikad'=>['bs','hr','sr',],
'ikada'=>['bs','hr','sr',],
'ikan'=>['id','ms',],
'ikasi'=>['eu',],
'ikasiko'=>['eu',],
'ikasle'=>['eu',],
'ikasteko'=>['eu',],
'ikastekoa'=>['eu',],
'iki'=>['az','lt','sq','tr',],
'ikim'=>['sq',],
'ikinci'=>['tr',],
'ikinä'=>['fi',],
'ikka'=>['et',],
'ikkagi'=>['et',],
'ikke'=>['da','nb','no',],
'ikur'=>['sq',],
'ikusi'=>['eu',],
'ikusiko'=>['eu',],
'ikustea'=>['eu',],
'ikusteak'=>['eu',],
'ikusten'=>['eu',],
'ikustera'=>['eu',],
'ikut'=>['ms',],
'ikuti'=>['ms',],
'ikväll'=>['sv',],
'ikävä'=>['fi',],
'il'=>['az','en','fr','it','ro','th',],
'ildə'=>['az',],
'ile'=>['pl','tr',],
'ilea'=>['eu',],
'ilgai'=>['lt',],
'ilgi'=>['lv',],
'ilgili'=>['tr',],
'ili'=>['bs','hr','sr',],
'ilin'=>['az',],
'ilk'=>['az','tr',],
'illa'=>['ca','is','la','sv',],
'illalla'=>['fi',],
'illam'=>['la',],
'ille'=>['la','nb','no',],
'illi'=>['la',],
'illic'=>['la',],
'illis'=>['la',],
'illius'=>['la',],
'illo'=>['la',],
'illorum'=>['la',],
'illos'=>['la',],
'illud'=>['la',],
'illum'=>['la',],
'ilma'=>['et',],
'ilman'=>['fi',],
'ilmiah'=>['id',],
'ilmselt'=>['et',],
'ilmu'=>['id',],
'ilmuwan'=>['id',],
'iloba'=>['eu',],
'iloinen'=>['fi',],
'ils'=>['fr',],
'iltana'=>['fi',],
'iltzatuta'=>['eu',],
'iluntasunetik'=>['eu',],
'ilus'=>['et',],
'ilyen'=>['hu',],
'ilyet'=>['hu',],
'ilə'=>['az',],
'im'=>['bs','de','hr','pl','sk','sq','sr',],
'ima'=>['bs','hr','sl','sr',],
'imagine'=>['en','fr',],
'imajo'=>['sl',],
'imaju'=>['bs','hr','sr',],
'imala'=>['bs','hr','sr',],
'imali'=>['bs','hr','sr',],
'imam'=>['bs','hr','sl','sr',],
'imamo'=>['bs','hr','sl','sr',],
'imao'=>['bs','hr','sr',],
'imate'=>['bs','hr','sl','sr',],
'imati'=>['bs','hr','sr',],
'imava'=>['sl',],
'imaxe'=>['gl',],
'imaš'=>['bs','hr','sl',],
'imaљ'=>['bs','hr','sr',],
'ime'=>['bs','hr','sl','sq','sr',],
'imediat'=>['ro',],
'imediatamente'=>['pt','pt_br',],
'imel'=>['sl',],
'imela'=>['sl',],
'imeli'=>['sl',],
'imelik'=>['et',],
'imeti'=>['sl',],
'imi'=>['ro',],
'imię'=>['pl',],
'imja'=>['sq',],
'imk'=>['lt',],
'immediatament'=>['ca',],
'immer'=>['de',],
'immo'=>['la',],
'imod'=>['da',],
'imorgon'=>['sv',],
'imos'=>['gl',],
'imot'=>['nb','no',],
'imperial'=>['si',],
'imperii'=>['la',],
'imperio'=>['la',],
'imperium'=>['la',],
'importa'=>['ca','es','it','pt','pt_br',],
'importancia'=>['gl',],
'important'=>['ca','en','fr','ro',],
'importante'=>['es','gl','it','pt','pt_br',],
'importantes'=>['gl',],
'importe'=>['fr',],
'imposible'=>['es',],
'impossibile'=>['it',],
'impossible'=>['ca','en','fr',],
'impossível'=>['pt','pt_br',],
'impression'=>['fr',],
'imprinted'=>['hi',],
'imprinting'=>['hi',],
'in'=>['af','de','en','fa','it','la','ms','nl','ro','si','sl','sq','sv','th','tr',],
'inaczej'=>['pl',],
'inainte'=>['ro',],
'inak'=>['sk',],
'inanamıyorum'=>['tr',],
'inapoi'=>['ro',],
'inca'=>['ro',],
'incarnaties'=>['af',],
'incidente'=>['it',],
'incluso'=>['es','gl',],
'incredibile'=>['it',],
'increíble'=>['es',],
'incroyable'=>['fr',],
'incrível'=>['pt','pt_br',],
'ind'=>['da','no',],
'indah'=>['id','ms',],
'indarra'=>['eu',],
'indarraz'=>['eu',],
'indartsua'=>['eu',],
'indartsuak'=>['eu',],
'inde'=>['da','la',],
'inden'=>['da',],
'indenfor'=>['da',],
'inderdaad'=>['nl',],
'index'=>['si',],
'india'=>['af','si',],
'indien'=>['af',],
'indiese'=>['af',],
'indietro'=>['it',],
'individu'=>['id',],
'indiรซ'=>['af',],
'indo'=>['pt','pt_br',],
'indra'=>['af',],
'indtil'=>['da',],
'industri'=>['id',],
'industria'=>['gl',],
'inferno'=>['pt','pt_br',],
'infierno'=>['es',],
'informació'=>['ca',],
'información'=>['es','gl',],
'informasi'=>['id','ms',],
'informatie'=>['nl',],
'information'=>['en','si',],
'informazio'=>['eu',],
'informação'=>['pt',],
'informe'=>['gl',],
'inför'=>['sv',],
'inga'=>['sv',],
'ingat'=>['ms',],
'ingen'=>['da','nb','no','sv',],
'ingenting'=>['da','nb','no','sv',],
'inget'=>['sv',],
'ingewande'=>['af',],
'inggris'=>['id','ms',],
'ingin'=>['id','ms',],
'inginkan'=>['ms',],
'ini'=>['id','ms',],
'iniciativa'=>['gl',],
'inilah'=>['id','ms',],
'inima'=>['ro',],
'inimene'=>['et',],
'inimesed'=>['et',],
'inimesi'=>['et',],
'inimest'=>['et',],
'inimeste'=>['et',],
'initio'=>['la',],
'initium'=>['la',],
'iniuria'=>['la',],
'inizio'=>['it',],
'inkarnasie'=>['af',],
'inkább'=>['hu',],
'inn'=>['is','nb','no',],
'innan'=>['is','sv',],
'inne'=>['nb','no','pl','sv',],
'innego'=>['pl',],
'innen'=>['hu',],
'inni'=>['is','pl',],
'inny'=>['pl',],
'innych'=>['pl',],
'innym'=>['pl',],
'inoiz'=>['eu',],
'inom'=>['sv',],
'inoren'=>['eu',],
'inork'=>['eu',],
'inquam'=>['la',],
'inquit'=>['la',],
'inquiète'=>['fr',],
'ins'=>['de',],
'insan'=>['az','tr',],
'insanlar'=>['tr',],
'insanları'=>['tr',],
'insanların'=>['tr',],
'inside'=>['en',],
'insieme'=>['it',],
'inspector'=>['ca',],
'instant'=>['fr',],
'instead'=>['en',],
'institucións'=>['gl',],
'instituto'=>['gl',],
'instrumente'=>['af',],
'instruments'=>['si',],
'intampla'=>['ro',],
'intamplat'=>['ro',],
'inte'=>['sv',],
'inteligentzia'=>['eu',],
'intelijen'=>['id',],
'intented'=>['si',],
'intenzione'=>['it',],
'inter'=>['la',],
'interesante'=>['es',],
'interesanti'=>['lv',],
'interese'=>['gl',],
'intereses'=>['gl',],
'interesgarri'=>['eu',],
'intereson'=>['sq',],
'interessa'=>['it','pt',],
'interessant'=>['ca','nb','no',],
'interessante'=>['af','pt','pt_br',],
'interessert'=>['nb',],
'interessiert'=>['de',],
'interested'=>['en',],
'interesting'=>['en',],
'interim'=>['la',],
'interior'=>['gl',],
'internacional'=>['gl',],
'internet'=>['gl',],
'intet'=>['da','no',],
'inti'=>['id',],
'into'=>['en','si',],
'intorno'=>['it',],
'intra'=>['la','ro',],
'intrat'=>['ro',],
'intre'=>['gl','ro',],
'intressant'=>['sv',],
'introduction'=>['si',],
'intră'=>['ro',],
'intérieur'=>['fr',],
'invece'=>['it',],
'investigación'=>['gl',],
'iné'=>['sk',],
'iného'=>['sk',],
'iný'=>['sk',],
'io'=>['es','id','it',],
'ipak'=>['bs','hr','sr',],
'ipit'=>['si',],
'ipsa'=>['la',],
'ipsam'=>['la',],
'ipse'=>['la',],
'ipsi'=>['la',],
'ipsis'=>['la',],
'ipsius'=>['la',],
'ipso'=>['la',],
'ipsos'=>['la',],
'ipsum'=>['la',],
'ipurdia'=>['eu',],
'ir'=>['es','gl','lt','lv','pt','pt_br',],
'ira'=>['fr','la',],
'irabazi'=>['eu',],
'iraganeko'=>['eu',],
'irakasteko'=>['eu',],
'irakasten'=>['eu',],
'irakatsi'=>['eu',],
'irakurri'=>['eu',],
'iraungo'=>['eu',],
'irei'=>['pt_br',],
'iremos'=>['es',],
'irgendwas'=>['de',],
'irgendwie'=>['de',],
'irgendwo'=>['de',],
'irgi'=>['lt',],
'iria'=>['pt','pt_br',],
'iritzia'=>['eu',],
'irme'=>['es',],
'irmán'=>['gl',],
'irmã'=>['pt','pt_br',],
'irmão'=>['pt','pt_br',],
'iron'=>['si',],
'irteten'=>['eu',],
'irti'=>['fi',],
'irudi'=>['eu',],
'irá'=>['pt','pt_br',],
'iré'=>['es',],
'is'=>['af','en','fa','hu','la','lt','ms','nl','si','th',],
'isa'=>['et',],
'isabelle'=>['si',],
'isand'=>['et',],
'ise'=>['et','tr',],
'isegi'=>['et',],
'isha'=>['sq',],
'ishe'=>['sq',],
'ishim'=>['sq',],
'ishin'=>['sq',],
'ishte'=>['sq',],
'isiands'=>['id',],
'isildu'=>['eu',],
'isilik'=>['eu',],
'ismered'=>['hu',],
'ismerem'=>['hu',],
'ismeri'=>['hu',],
'isn'=>['en','th',],
'iso'=>['fi','gl',],
'ispod'=>['bs','hr','sr',],
'ispred'=>['bs','hr','sr',],
'israhel'=>['la',],
'issand'=>['et',],
'issi'=>['et',],
'isso'=>['pt','pt_br',],
'issy'=>['si',],
'ist'=>['de',],
'ista'=>['la',],
'istabā'=>['lv',],
'iste'=>['la','sk',],
'istedi'=>['tr',],
'istedim'=>['tr',],
'istediğim'=>['tr',],
'istediğin'=>['tr',],
'istediğini'=>['tr',],
'istegao'=>['hi',],
'istemiyor'=>['tr',],
'istemiyorum'=>['tr',],
'isten'=>['hu',],
'istenem'=>['hu',],
'ister'=>['tr',],
'isterim'=>['tr',],
'istersen'=>['tr',],
'isti'=>['bs','hr','la','sr',],
'istifadə'=>['az',],
'istifadəçilər'=>['az',],
'istina'=>['bs','hr','sr',],
'istinu'=>['bs','hr','sr',],
'istirahat'=>['ms',],
'istiyor'=>['tr',],
'istiyorsan'=>['tr',],
'istiyorsun'=>['tr',],
'istiyorsunuz'=>['tr',],
'istiyorum'=>['tr',],
'istiyoruz'=>['tr',],
'isto'=>['bs','gl','hr','la','pt','pt_br','sl','sr',],
'istorija'=>['lt',],
'istorio'=>['eu',],
'istri'=>['ms',],
'istu'=>['et','fi',],
'istum'=>['la',],
'istá'=>['sk',],
'istället'=>['sv',],
'isté'=>['sk',],
'istý'=>['sk',],
'isuse'=>['bs','hr','sr',],
'isä'=>['fi',],
'isäni'=>['fi',],
'isäsi'=>['fi',],
'isə'=>['az',],
'it'=>['af','en','fa','hu','id','lt','lv','ms','pl','si','sq','th',],
'ita'=>['la',],
'italia'=>['la',],
'italiam'=>['la',],
'itaque'=>['la',],
'item'=>['la',],
'iter'=>['la',],
'iterum'=>['la',],
'iti'=>['ro','sl',],
'its'=>['en',],
'itsasoan'=>['eu',],
'itsatsi'=>['eu',],
'itse'=>['fi',],
'itseni'=>['fi',],
'itsensä'=>['fi',],
'itsesi'=>['fi',],
'itseäsi'=>['fi',],
'itsusi'=>['eu',],
'itt'=>['hu',],
'itthon'=>['hu',],
'itu'=>['id','ms',],
'itulah'=>['id','ms',],
'itxaron'=>['eu',],
'itzuli'=>['eu',],
'itzuliko'=>['eu',],
'itzultzeko'=>['eu',],
'itzultzen'=>['eu',],
'iu'=>['sq',],
'iubesc'=>['ro',],
'iubet'=>['la',],
'iubito'=>['ro',],
'iuda'=>['la',],
'iudices'=>['la',],
'iudicio'=>['la',],
'iudicium'=>['la',],
'iure'=>['la',],
'iuris'=>['la',],
'ius'=>['la',],
'iussit'=>['la',],
'iuxta'=>['la',],
'iväg'=>['sv',],
'iya'=>['ms',],
'iyi'=>['tr',],
'iyisi'=>['tr',],
'iyiyim'=>['tr',],
'iz'=>['bs','hr','sl','sr',],
'iza'=>['bs','hr','sr',],
'izan'=>['eu',],
'izango'=>['eu',],
'izateagatik'=>['eu',],
'izatearen'=>['eu',],
'izatera'=>['eu',],
'izbeidz'=>['lv',],
'izdarīja'=>['lv',],
'izdarīji'=>['lv',],
'izdarīt'=>['lv',],
'izdevās'=>['lv',],
'izen'=>['eu',],
'izena'=>['eu',],
'izgleda'=>['bs','hr','sl','sr',],
'izgledaš'=>['bs','hr','sl',],
'izgledaљ'=>['sr',],
'izgubil'=>['sl',],
'izgubio'=>['bs','hr','sr',],
'izin'=>['tr',],
'izlazi'=>['bs','hr','sr',],
'izmantot'=>['lv',],
'izmed'=>['sl',],
'između'=>['hr',],
'izmeрu'=>['sr',],
'izpiritua'=>['eu',],
'izquierda'=>['es',],
'izskaties'=>['lv',],
'izskatās'=>['lv',],
'izvini'=>['bs','sr',],
'izvinite'=>['bs','sr',],
'izvoli'=>['sl',],
'iç'=>['tr',],
'içeri'=>['tr',],
'için'=>['tr',],
'içinde'=>['tr',],
'içine'=>['tr',],
'içki'=>['tr',],
'ići'=>['bs','hr',],
'iść'=>['pl',],
'iş'=>['tr',],
'işarə'=>['az',],
'işarədir'=>['az',],
'işe'=>['tr',],
'işi'=>['tr',],
'işim'=>['tr',],
'işin'=>['tr',],
'işini'=>['tr',],
'işler'=>['tr',],
'işte'=>['tr',],
'iš'=>['lt',],
'išeiti'=>['lt',],
'išgelbėti'=>['lt',],
'išiel'=>['sk',],
'išskyrus'=>['lt',],
'išėjo'=>['lt',],
'i̇ki'=>['tr',],
'i̇lk'=>['tr',],
'i̇nsanlar'=>['tr',],
'i̇sa'=>['tr',],
'i̇yi'=>['tr',],
'i̇yiyim'=>['tr',],
'i̇çeri'=>['tr',],
'i̇şe'=>['tr',],
'i̇şte'=>['tr',],
'iжi'=>['bs','hr','sr',],
'j'=>['da','fr','hr','it','nb','no','sv','th',],
'ja'=>['af','bs','ca','da','de','et','fi','hr','hu','is','lt','lv','nb','nl','no','pl','sk','sl','sq','sr','sv',],
'jaa'=>['et','lv',],
'jaar'=>['af','nl',],
'jack'=>['bs','ca','da','de','en','es','et','fi','fr','hr','hu','is','it','ms','nb','nl','no','pl','pt','pt_br','ro','sk','sl','sq','sv','tr',],
'jacketed'=>['si',],
'jacku'=>['cs',],
'jadi'=>['id','ms',],
'jafnvel'=>['is',],
'jag'=>['sv',],
'jaga'=>['ms',],
'jah'=>['et',],
'jaha'=>['sv',],
'jahat'=>['ms',],
'jahr'=>['de',],
'jahre'=>['de',],
'jahren'=>['de',],
'jai'=>['lt',],
'jaialdirako'=>['eu',],
'jaio'=>['eu',],
'jaiotzea'=>['eu',],
'jais'=>['lt',],
'jaj'=>['hu',],
'jak'=>['cs','pl',],
'jaka'=>['pl',],
'jakaś'=>['pl',],
'jakby'=>['pl',],
'jaki'=>['pl',],
'jakie'=>['pl',],
'jakiegoś'=>['pl',],
'jakieś'=>['pl',],
'jakim'=>['pl',],
'jakin'=>['eu',],
'jakina'=>['eu',],
'jakituria'=>['eu',],
'jakiś'=>['pl',],
'jako'=>['bs','cs','hr','pl','sr',],
'jakou'=>['cs',],
'jakoś'=>['pl',],
'jaká'=>['cs',],
'jaké'=>['cs',],
'jaký'=>['cs',],
'jaką'=>['pl',],
'jakąś'=>['pl',],
'jalan'=>['id','ms',],
'jalga'=>['et',],
'jam'=>['id','lt','ms','sq',],
'jama'=>['et',],
'jamais'=>['fr','pt_br',],
'jamen'=>['da',],
'james'=>['da','hu','nb','no','sk','sv',],
'jammer'=>['af','nl',],
'jamás'=>['es',],
'jan'=>['eu',],
'janaka'=>['af',],
'janaki'=>['af',],
'janaria'=>['eu',],
'janariarekin'=>['eu',],
'jane'=>['si','sq',],
'jangan'=>['id','ms',],
'janji'=>['ms',],
'janny'=>['si',],
'jantar'=>['pt','pt_br',],
'jantung'=>['id',],
'jantzirik'=>['eu',],
'janë'=>['sq',],
'jaoks'=>['et',],
'jap'=>['sq',],
'japannese'=>['af',],
'japësh'=>['sq',],
'jar'=>['eu',],
'jarak'=>['id',],
'jaren'=>['nl',],
'jaringan'=>['id',],
'jarraitu'=>['eu',],
'jarraitzen'=>['eu',],
'jarri'=>['eu',],
'jarriko'=>['eu',],
'jartzen'=>['eu',],
'jas'=>['lt',],
'jashte'=>['sq',],
'jashtë'=>['sq',],
'jasne'=>['pl','sk',],
'jasno'=>['bs','hr','sl','sr',],
'jasné'=>['cs','sk',],
'jasný'=>['cs',],
'jasně'=>['cs',],
'jaso'=>['eu',],
'jasper'=>['hi',],
'jaså'=>['nb','no','sv',],
'jatka'=>['fi',],
'jatkaa'=>['fi',],
'jatuh'=>['id','ms',],
'jau'=>['lt','lv',],
'jauh'=>['id','ms',],
'jauka'=>['lv',],
'jauki'=>['lv',],
'jauks'=>['lv',],
'jaun'=>['eu',],
'jauna'=>['lv',],
'jaunais'=>['lv',],
'jaunkundz'=>['lv',],
'jauno'=>['lv',],
'jauns'=>['lv',],
'jaunu'=>['lv',],
'jautiesi'=>['lt',],
'jautājums'=>['lv',],
'jautājumu'=>['lv',],
'jaučiu'=>['lt',],
'jaučiuosi'=>['lt',],
'javel'=>['da',],
'javisst'=>['sv',],
'javë'=>['sq',],
'jawab'=>['id','ms',],
'jawaban'=>['id',],
'jawabannya'=>['id',],
'jawel'=>['nl',],
'jaz'=>['sl',],
'jaèom'=>['hi',],
'jde'=>['cs',],
'jdeme'=>['cs',],
'jdeš'=>['cs',],
'jdi'=>['cs',],
'jdu'=>['cs',],
'jděte'=>['cs',],
'je'=>['bs','cs','de','fr','hr','nl','pl','sk','sl','sq','sr',],
'jean'=>['ca',],
'jebem'=>['bs',],
'jebena'=>['bs',],
'jebeni'=>['bs','hr','sr',],
'jebeno'=>['bs','hr','sr',],
'jebi'=>['bs','hr','sl','sr',],
'jebkad'=>['lv',],
'jebote'=>['hr','sr',],
'jechać'=>['pl',],
'jedan'=>['bs','hr','sr',],
'jede'=>['de',],
'jedem'=>['de',],
'jedeme'=>['cs',],
'jeden'=>['cs','de','pl','sk',],
'jeder'=>['de',],
'jedes'=>['de',],
'jedina'=>['bs','hr','sr',],
'jedini'=>['bs','hr','sr',],
'jedino'=>['bs','hr','sr',],
'jediná'=>['cs','sk',],
'jediné'=>['sk',],
'jediný'=>['cs','sk',],
'jedlo'=>['sk',],
'jedna'=>['bs','cs','hr','pl','sk','sr',],
'jednak'=>['pl',],
'jednego'=>['pl',],
'jednej'=>['pl','sk',],
'jedno'=>['bs','cs','hr','pl','sk','sr',],
'jednoducho'=>['sk',],
'jednog'=>['bs','hr','sr',],
'jednoho'=>['cs',],
'jednom'=>['bs','hr','sr',],
'jednostavno'=>['bs','hr','sr',],
'jednou'=>['cs',],
'jednu'=>['bs','cs','hr','sk','sr',],
'jednym'=>['pl',],
'jedného'=>['sk',],
'jedną'=>['pl',],
'jedva'=>['bs','hr','sr',],
'jedynie'=>['pl',],
'jedziemy'=>['pl',],
'jeesus'=>['et','fi',],
'jefe'=>['es',],
'jeg'=>['da','nb','no',],
'jego'=>['pl',],
'jeho'=>['cs','sk',],
'jei'=>['lt',],
'jeigu'=>['lt',],
'jeito'=>['pt','pt_br',],
'jej'=>['pl','sk',],
'jejich'=>['cs',],
'její'=>['cs',],
'jel'=>['bs','hr','sr',],
'jelas'=>['id','ms',],
'jelent'=>['hu',],
'jelenti'=>['hu',],
'jeli'=>['bs',],
'jem'=>['sq',],
'jemand'=>['de',],
'jemanden'=>['de',],
'jemi'=>['sq',],
'jen'=>['cs',],
'jendea'=>['eu',],
'jenderal'=>['ms',],
'jeni'=>['sq',],
'jenis'=>['id','ms',],
'jenny'=>['si',],
'jenom'=>['cs',],
'jenta'=>['nb','no',],
'jente'=>['nb','no',],
'jenter'=>['nb','no',],
'jenë'=>['sq',],
'jep'=>['sq',],
'jepang'=>['id',],
'jepi'=>['sq',],
'jepni'=>['sq',],
'jer'=>['bs','da','hr','no','sr',],
'jeres'=>['da',],
'jerman'=>['id','ms',],
'jesam'=>['bs','hr','sr',],
'jesh'=>['sq',],
'jesi'=>['bs','hr','sr',],
'jesmo'=>['bs','hr',],
'jest'=>['hr','pl',],
'jeste'=>['bs','hr','sr',],
'jestem'=>['pl',],
'jesteś'=>['pl',],
'jesteście'=>['pl',],
'jesteśmy'=>['pl',],
'jesti'=>['hr',],
'jestli'=>['cs',],
'jesu'=>['bs','hr','sr',],
'jesus'=>['da','en','nb','no','pt','pt_br','sv',],
'jeszcze'=>['pl',],
'jesús'=>['is',],
'jesť'=>['sk',],
'jet'=>['cs','id',],
'jeta'=>['sq',],
'jete'=>['sq',],
'jetoj'=>['sq',],
'jeton'=>['sq',],
'jets'=>['af',],
'jetzt'=>['de',],
'jetë'=>['sq',],
'jetën'=>['sq',],
'jetës'=>['sq',],
'jeu'=>['fr',],
'jeune'=>['fr',],
'jeunes'=>['fr',],
'jezelf'=>['nl',],
'jezu'=>['pl',],
'jezus'=>['nl','sl',],
'jeśli'=>['pl',],
'ještě'=>['cs',],
'jeżeli'=>['pl',],
'ježiši'=>['sk',],
'ježíši'=>['cs',],
'jhamak'=>['si',],
'jhoom'=>['si',],
'ji'=>['cs','lt','sl',],
'jich'=>['cs',],
'jie'=>['lt',],
'jiems'=>['lt',],
'jih'=>['sl',],
'jij'=>['nl',],
'jika'=>['id','ms',],
'jim'=>['cs','sl',],
'jimmy'=>['da','fi','nb','nl','no','sv','tr',],
'jinak'=>['cs',],
'jiné'=>['cs',],
'jiného'=>['cs',],
'jiný'=>['cs',],
'jis'=>['lt',],
'jistá'=>['cs',],
'jistý'=>['cs',],
'jistě'=>['cs',],
'jmenuje'=>['cs',],
'jméno'=>['cs',],
'jo'=>['ca','cs','da','eu','fi','lt','lv','nb','no','sl','sq','sv',],
'joan'=>['eu',],
'joango'=>['eu',],
'joateko'=>['eu',],
'job'=>['da','de','en',],
'jobb'=>['hu','nb','no','sv',],
'jobba'=>['sv',],
'jobban'=>['hu',],
'jobbar'=>['sv',],
'jobbat'=>['sv',],
'jobbe'=>['nb','no',],
'jobben'=>['nb','no',],
'jobber'=>['nb','no',],
'jobbet'=>['nb','no','sv',],
'joc'=>['ca','ro',],
'joe'=>['bs','cs','da','de','en','es','et','fi','fr','hr','hu','is','it','nb','nl','no','pl','pt','pt_br','ro','sk','sl','sv','tr',],
'joel'=>['si',],
'jog'=>['lt',],
'jogar'=>['pt','pt_br',],
'jogo'=>['pt','pt_br',],
'john'=>['bs','ca','da','de','en','es','et','fi','fr','hr','hu','is','it','ms','nb','nl','no','pl','pt','pt_br','ro','si','sk','sl','sq','sv','th','tr',],
'johne'=>['cs',],
'johnny'=>['de','nb','no','sv',],
'join'=>['en',],
'joita'=>['fi',],
'joj'=>['bs','hr','sr',],
'joka'=>['fi',],
'jokainen'=>['fi',],
'jokatzen'=>['eu',],
'jokin'=>['fi',],
'jokio'=>['lt',],
'jokios'=>['lt',],
'jokiu'=>['lt',],
'jokių'=>['lt',],
'joko'=>['fi',],
'joku'=>['fi',],
'jolastu'=>['eu',],
'joli'=>['fr',],
'jolie'=>['fr',],
'jolla'=>['fi',],
'jong'=>['nl',],
'jonge'=>['nl',],
'jongen'=>['nl',],
'jongens'=>['nl',],
'jonka'=>['fi',],
'jonkun'=>['fi',],
'jonë'=>['sq',],
'joo'=>['fi',],
'jookse'=>['et',],
'jooksul'=>['et',],
'jopa'=>['fi',],
'joprojām'=>['lv',],
'jorden'=>['da','no','sv',],
'jos'=>['bs','fi','lt','ro','sr',],
'joskus'=>['fi',],
'jossa'=>['fi',],
'jossain'=>['fi',],
'josta'=>['fi',],
'josé'=>['gl',],
'jota'=>['fi',],
'jotain'=>['fi',],
'jotakin'=>['fi',],
'jote'=>['sq',],
'joten'=>['fi',],
'jotka'=>['fi',],
'jotkut'=>['fi',],
'jotta'=>['fi',],
'jou'=>['af','nl',],
'joue'=>['fr',],
'jouer'=>['fr',],
'jour'=>['fr',],
'journée'=>['fr',],
'jours'=>['fr',],
'jouself'=>['af',],
'jouw'=>['nl',],
'joué'=>['fr',],
'jove'=>['ca',],
'jovem'=>['pt','pt_br',],
'joven'=>['es',],
'još'=>['bs','hr',],
'joљ'=>['bs','hr','sr',],
'jsem'=>['cs',],
'jseš'=>['cs',],
'jsi'=>['cs',],
'jsme'=>['cs',],
'jsou'=>['cs',],
'jste'=>['cs',],
'ju'=>['bs','et','hr','lt','sk','sl','sq','sr','sv',],
'juaj'=>['sq',],
'juan'=>['gl',],
'juba'=>['et',],
'jubel'=>['af',],
'judge'=>['en','si',],
'juego'=>['es',],
'juga'=>['id','ms',],
'jugar'=>['ca','es',],
'juhtub'=>['et',],
'juhtunud'=>['et',],
'juhtus'=>['et',],
'juhul'=>['et',],
'juist'=>['nl',],
'juiste'=>['nl',],
'jujur'=>['ms',],
'juk'=>['lt',],
'juli'=>['id',],
'julle'=>['af',],
'jullie'=>['nl',],
'jumal'=>['et',],
'jumala'=>['et','fi',],
'jumalan'=>['fi',],
'jumbo'=>['af',],
'jumis'=>['lt',],
'jumlah'=>['id',],
'jumpa'=>['ms',],
'jums'=>['lt','lv',],
'jumătate'=>['ro',],
'junge'=>['de',],
'jungen'=>['de',],
'jungs'=>['de',],
'junto'=>['es','pt_br',],
'juntos'=>['es','pt','pt_br',],
'junts'=>['ca',],
'juo'=>['lt',],
'juokinga'=>['lt',],
'juos'=>['lt',],
'jupiter'=>['id',],
'jur'=>['ro',],
'jure'=>['fr',],
'juro'=>['ca','es','pt','pt_br',],
'jus'=>['lt',],
'jush'=>['sq',],
'just'=>['ca','en','et','fa','si','sv','th',],
'juste'=>['fr',],
'justo'=>['es',],
'jusu'=>['lt',],
'juta'=>['id','ms',],
'jutaan'=>['id',],
'jutella'=>['fi',],
'jutri'=>['sl',],
'jutro'=>['bs','hr','pl','sl','sr',],
'juttu'=>['fi',],
'jutun'=>['fi',],
'juurde'=>['et',],
'juures'=>['et',],
'juuri'=>['fi',],
'juus'=>['lv',],
'juve'=>['sq',],
'juweliersware'=>['af',],
'już'=>['pl',],
'juиe'=>['sr',],
'jy'=>['af',],
'já'=>['cs','is','pt','pt_br',],
'jár'=>['hu',],
'járt'=>['hu',],
'játszani'=>['hu',],
'játék'=>['hu',],
'jäi'=>['et',],
'jäljellä'=>['fi',],
'jälkeen'=>['fi',],
'jälle'=>['et',],
'järel'=>['et',],
'järele'=>['et',],
'järgi'=>['et',],
'järgmine'=>['et',],
'jäta'=>['et',],
'jätke'=>['et',],
'jätta'=>['et',],
'jättää'=>['fi',],
'jätä'=>['fi',],
'jävel'=>['sv',],
'jävla'=>['sv',],
'jävlar'=>['sv',],
'jää'=>['et','fi',],
'jääb'=>['et',],
'jääd'=>['et',],
'jääda'=>['et',],
'jäädä'=>['fi',],
'jään'=>['et',],
'jäänud'=>['et',],
'jæja'=>['is',],
'jævla'=>['nb','no',],
'jézus'=>['hu',],
'jézusom'=>['hu',],
'jí'=>['cs',],
'jídlo'=>['cs',],
'jít'=>['cs',],
'jó'=>['hu',],
'jól'=>['hu',],
'jót'=>['hu',],
'jöjjön'=>['hu',],
'jön'=>['hu',],
'jönnek'=>['hu',],
'jönni'=>['hu',],
'jösses'=>['sv',],
'jössz'=>['hu',],
'jött'=>['hu',],
'jöttem'=>['hu',],
'jöttél'=>['hu',],
'jövök'=>['hu',],
'jövő'=>['hu',],
'jøss'=>['nb','no',],
'jú'=>['is',],
'jüs'=>['lt','lv',],
'jā'=>['lv',],
'jābūt'=>['lv',],
'jādara'=>['lv',],
'jādodas'=>['lv',],
'jāiet'=>['lv',],
'jātiek'=>['lv',],
'ją'=>['lt','pl',],
'jēzus'=>['lv',],
'jėga'=>['lt',],
'jėzau'=>['lt',],
'jį'=>['lt',],
'jūras'=>['lv',],
'jūs'=>['lt','lv',],
'jūsu'=>['lv',],
'jūsų'=>['lt',],
'jūties'=>['lv',],
'jūtos'=>['lv',],
'jūtu'=>['lv',],
'jų'=>['lt',],
'k'=>['az','bs','cs','fr','hr','is','sk','sl','sr','th',],
'ka'=>['af','bs','et','lt','lv','sq','sr',],
'kaa'=>['lv',],
'kaart'=>['nl',],
'kaasa'=>['et',],
'kabar'=>['ms',],
'kabul'=>['tr',],
'kad'=>['bs','hr','lt','lv','sr',],
'kada'=>['bs','hr','lt','sr',],
'kadang'=>['id','ms',],
'kadangi'=>['lt',],
'kadar'=>['tr',],
'kadunud'=>['et',],
'kadın'=>['tr',],
'kadınlar'=>['tr',],
'kafe'=>['sq',],
'kaffe'=>['da','nb','no','sv',],
'kaffee'=>['de',],
'kaffi'=>['is',],
'kahdeksan'=>['fi',],
'kahden'=>['fi',],
'kahe'=>['et',],
'kahju'=>['et',],
'kahretsin'=>['tr',],
'kahrolası'=>['tr',],
'kahve'=>['tr',],
'kahvia'=>['fi',],
'kai'=>['fi','lt',],
'kaiken'=>['fi',],
'kaikesta'=>['fi',],
'kaikeyi'=>['af',],
'kaikille'=>['fi',],
'kaikkea'=>['fi',],
'kaikki'=>['fi',],
'kaikkia'=>['fi',],
'kaikkien'=>['fi',],
'kaip'=>['lt',],
'kaixo'=>['eu',],
'kaj'=>['sl',],
'kajne'=>['sl',],
'kakak'=>['ms',],
'kakav'=>['bs','hr','sr',],
'kaki'=>['id','ms',],
'kako'=>['bs','hr','sl','sr',],
'kakor'=>['sl',],
'kakorkoli'=>['sl',],
'kaks'=>['et',],
'kaksi'=>['fi',],
'kakva'=>['bs','hr','sr',],
'kakve'=>['bs','hr','sr',],
'kakvo'=>['sr',],
'kakšen'=>['sl',],
'kakšna'=>['sl',],
'kakšne'=>['sl',],
'kakšno'=>['sl',],
'kal'=>['la','tr',],
'kalah'=>['ms',],
'kalan'=>['tr',],
'kalau'=>['id','ms',],
'kalba'=>['lt',],
'kalbi'=>['lt',],
'kalbu'=>['lt',],
'kalbėti'=>['lt',],
'kalde'=>['da',],
'kalder'=>['da',],
'kaldı'=>['tr',],
'kale'=>['eu',],
'kali'=>['id','ms',],
'kalian'=>['ms',],
'kalk'=>['tr',],
'kalla'=>['is','sv',],
'kallar'=>['sv',],
'kallas'=>['sv',],
'kalle'=>['nb',],
'kaller'=>['nb','no',],
'kallis'=>['et',],
'kalmak'=>['tr',],
'kaloj'=>['sq',],
'kalon'=>['sq',],
'kalt'=>['de',],
'kaltetzeko'=>['eu',],
'kaluar'=>['sq',],
'kalėdų'=>['lt',],
'kalės'=>['lt',],
'kalın'=>['tr',],
'kam'=>['cs','de','lt','lv','sk','sl','sq',],
'kamar'=>['ms',],
'kambaryje'=>['lt',],
'kambarį'=>['lt',],
'kamen'=>['de',],
'kamer'=>['af','nl',],
'kamera'=>['id','ms',],
'kami'=>['id','ms',],
'kamisetak'=>['eu',],
'kammerat'=>['da',],
'kamo'=>['hr',],
'kamoš'=>['sk',],
'kamp'=>['da','nb','no',],
'kampen'=>['da','nb','no',],
'kampf'=>['de',],
'kamu'=>['ms',],
'kamēr'=>['lv',],
'kan'=>['af','da','ms','nb','nl','no','sq','sv','tr',],
'kanan'=>['id','ms',],
'kane'=>['sq',],
'kann'=>['de','is',],
'kannski'=>['is',],
'kannst'=>['de',],
'kanoa'=>['eu',],
'kanpoan'=>['eu',],
'kanpora'=>['eu',],
'kans'=>['af','nl',],
'kanske'=>['sv',],
'kanskje'=>['nb','no',],
'kanssa'=>['fi',],
'kanssaan'=>['fi',],
'kanssani'=>['fi',],
'kanssasi'=>['fi',],
'kant'=>['nl',],
'kanta'=>['eu',],
'kantoor'=>['nl',],
'kantor'=>['ms',],
'kantua'=>['eu',],
'kanë'=>['sq',],
'kao'=>['bs','et','hr','sr',],
'kapa'=>['tr',],
'kapal'=>['id','ms',],
'kapan'=>['ms',],
'kapat'=>['tr',],
'kapcsolatban'=>['hu',],
'kape'=>['sq',],
'kapetane'=>['bs','hr','sr',],
'kapitan'=>['sl',],
'kapitanie'=>['pl',],
'kapitein'=>['nl',],
'kapiten'=>['sq',],
'kapitone'=>['lt',],
'kapitán'=>['sk',],
'kapitáne'=>['cs',],
'kapitány'=>['hu',],
'kapot'=>['nl',],
'kapott'=>['hu',],
'kaptajn'=>['da',],
'kaptam'=>['hu',],
'kaptan'=>['tr',],
'kapteeni'=>['fi',],
'kaptein'=>['lv','nb','no',],
'kapteinis'=>['lv',],
'kapten'=>['et','ms','sv',],
'kapı'=>['tr',],
'kapıyı'=>['tr',],
'kaq'=>['sq',],
'kar'=>['sl',],
'kara'=>['lv',],
'karakter'=>['af',],
'karalis'=>['lv',],
'karalius'=>['lt',],
'karang'=>['id',],
'karaoke'=>['si',],
'karar'=>['tr',],
'karas'=>['lt',],
'karbon'=>['id',],
'kardan'=>['et',],
'kardeşim'=>['tr',],
'kareletik'=>['eu',],
'karena'=>['id','ms',],
'karkoli'=>['sl',],
'karo'=>['lt',],
'karta'=>['lt',],
'kartais'=>['lt',],
'karto'=>['lt',],
'kartu'=>['lt','ms',],
'kartus'=>['lt',],
'kartą'=>['lt',],
'kartų'=>['lt',],
'karşı'=>['tr',],
'karš'=>['lv',],
'kas'=>['et','lt','lv',],
'kasih'=>['id','ms',],
'kasneje'=>['sl',],
'kasnije'=>['bs','hr','sr',],
'kasno'=>['bs','sr',],
'kast'=>['nb',],
'kasta'=>['sv',],
'kaste'=>['nb','no',],
'kaster'=>['nb',],
'kastet'=>['nb','no',],
'kasus'=>['id','ms',],
'kasutada'=>['et',],
'kata'=>['id','ms',],
'katakan'=>['id','ms',],
'katarroa'=>['eu',],
'kate'=>['is',],
'katere'=>['sl',],
'katerega'=>['sl',],
'kateri'=>['sl',],
'katero'=>['sl',],
'katram'=>['lv',],
'katrs'=>['lv',],
'katru'=>['lv',],
'katso'=>['fi',],
'katsoa'=>['fi',],
'katsokaa'=>['fi',],
'katsomaan'=>['fi',],
'katson'=>['fi',],
'katsotaan'=>['fi',],
'katër'=>['sq',],
'kau'=>['id','ms',],
'kaua'=>['et',],
'kauan'=>['fi',],
'kaufen'=>['de',],
'kaukana'=>['fi',],
'kaum'=>['de',],
'kaunis'=>['fi',],
'kaupa'=>['is',],
'kausalya'=>['af',],
'kaut'=>['lv',],
'kautta'=>['fi',],
'kaveri'=>['fi',],
'kaverit'=>['fi',],
'kavo'=>['sl',],
'kavos'=>['lt',],
'kawah'=>['id',],
'kawan'=>['ms',],
'kaya'=>['id','ms',],
'kaç'=>['tr',],
'każdego'=>['pl',],
'każdy'=>['pl',],
'każdym'=>['pl',],
'každou'=>['cs',],
'každého'=>['sk',],
'každú'=>['sk',],
'každý'=>['cs','sk',],
'kaže'=>['bs','hr','sl',],
'kažem'=>['bs','hr',],
'kažeš'=>['bs','hr',],
'kažkas'=>['lt',],
'kažkoks'=>['lt',],
'kažkur'=>['lt',],
'kažką'=>['lt',],
'kažu'=>['bs','hr',],
'kaћe'=>['bs','hr','sr',],
'kaћem'=>['bs','hr','sr',],
'kaћete'=>['sr',],
'kaћeљ'=>['bs','sr',],
'kaћi'=>['sr',],
'kaћu'=>['sr',],
'kdaj'=>['sl',],
'kde'=>['cs','sk',],
'kdo'=>['cs','sl',],
'kdy'=>['cs',],
'kdyby'=>['cs',],
'kdybych'=>['cs',],
'kdybys'=>['cs',],
'když'=>['cs',],
'ke'=>['cs','id','ms','sq',],
'keadaan'=>['ms',],
'keajaiban'=>['id',],
'keamanan'=>['ms',],
'kebanyakan'=>['id',],
'kebenaran'=>['ms',],
'keberadaan'=>['id',],
'keberatan'=>['ms',],
'kebutuhan'=>['id',],
'keby'=>['sk',],
'kecelakaan'=>['id','ms',],
'kecepatan'=>['id',],
'kecerdasan'=>['id',],
'kecil'=>['id','ms',],
'kecuali'=>['id','ms',],
'ked'=>['da','sk',],
'keda'=>['et',],
'kedagi'=>['et',],
'kedua'=>['id','ms',],
'kedves'=>['hu',],
'kedvesem'=>['hu',],
'kedy'=>['sk',],
'keegi'=>['et',],
'keep'=>['en','si','th',],
'keeping'=>['si',],
'keer'=>['af','nl',],
'keha'=>['et',],
'kehadiran'=>['id',],
'kehidupan'=>['id','ms',],
'kehilangan'=>['id','ms',],
'kein'=>['de',],
'keine'=>['de',],
'keinen'=>['de',],
'keiner'=>['de',],
'keista'=>['lt',],
'kejadian'=>['id',],
'kejahatan'=>['id','ms',],
'kekerasan'=>['id',],
'kekuasaan'=>['id',],
'kekuatan'=>['id','ms',],
'kelangkaan'=>['id',],
'kelas'=>['ms',],
'keletą'=>['lt',],
'kelias'=>['lt',],
'kelihatan'=>['ms',],
'kelimpahan'=>['id',],
'kelio'=>['lt',],
'kelis'=>['lt',],
'keliu'=>['lt',],
'kelią'=>['lt',],
'kelių'=>['lt',],
'kelkis'=>['lt',],
'kell'=>['et','hu',],
'kelle'=>['et',],
'kellega'=>['et',],
'kellegi'=>['et',],
'kellel'=>['et',],
'kellelegi'=>['et',],
'kellene'=>['hu',],
'kellett'=>['hu',],
'kello'=>['fi',],
'kelompok'=>['id',],
'keluar'=>['id','ms',],
'keluarga'=>['id','ms',],
'kem'=>['is','sq',],
'kemajuan'=>['id',],
'kemampuan'=>['id',],
'kemana'=>['ms',],
'kemari'=>['ms',],
'kemarin'=>['ms',],
'kematian'=>['id','ms',],
'kembali'=>['id','ms',],
'kemi'=>['sq',],
'kemst'=>['is',],
'kemudian'=>['id','ms',],
'kemungkinan'=>['id','ms',],
'kemur'=>['is',],
'kemény'=>['hu',],
'ken'=>['af','nl',],
'kena'=>['et','ms',],
'kenal'=>['id','ms',],
'kenapa'=>['id','ms',],
'kende'=>['da',],
'kender'=>['da',],
'kendi'=>['tr',],
'kendim'=>['tr',],
'kendime'=>['tr',],
'kendimi'=>['tr',],
'kendine'=>['tr',],
'kendini'=>['tr',],
'kendisi'=>['tr',],
'kendt'=>['da',],
'kendte'=>['da',],
'kendu'=>['eu',],
'kenen'=>['fi',],
'keni'=>['sq',],
'kenna'=>['is',],
'kenne'=>['de',],
'kennen'=>['de','nl',],
'kennst'=>['de',],
'kennt'=>['de',],
'kenraali'=>['fi',],
'kent'=>['nl',],
'kenyataannya'=>['id',],
'kepada'=>['id','ms',],
'kepala'=>['id','ms',],
'keparat'=>['ms',],
'kepentingan'=>['id',],
'kepiting'=>['id',],
'kepler'=>['id',],
'kept'=>['en',],
'keputusan'=>['id',],
'keq'=>['sq',],
'keqe'=>['sq',],
'ker'=>['sl',],
'kerajaan'=>['ms',],
'kerajinan'=>['id',],
'keras'=>['id','ms',],
'kere'=>['tr',],
'kerel'=>['nl',],
'keren'=>['ms',],
'keres'=>['hu',],
'keresel'=>['hu',],
'keresztül'=>['hu',],
'kereta'=>['ms',],
'kerja'=>['id','ms',],
'kerk'=>['nl',],
'kerl'=>['de',],
'kerran'=>['fi',],
'kerro'=>['fi',],
'kerroin'=>['fi',],
'kerron'=>['fi',],
'kerta'=>['fi',],
'kertaa'=>['fi',],
'kertoa'=>['fi',],
'kertoi'=>['fi',],
'kertonut'=>['fi',],
'kerül'=>['hu',],
'került'=>['hu',],
'kes'=>['et','tr',],
'kesalahan'=>['id','ms',],
'kesana'=>['ms',],
'keseluruhan'=>['id',],
'kesempatan'=>['id','ms',],
'kesh'=>['sq',],
'keshtu'=>['sq',],
'kesin'=>['tr',],
'kesini'=>['ms',],
'kesinlikle'=>['tr',],
'kestä'=>['fi',],
'kestää'=>['fi',],
'kete'=>['sq',],
'ketika'=>['id','ms',],
'keto'=>['sq',],
'ketten'=>['hu',],
'kettő'=>['hu',],
'ketu'=>['sq',],
'ketään'=>['fi',],
'ketë'=>['sq',],
'keuangan'=>['id',],
'keuntungan'=>['id',],
'key'=>['en',],
'keyakinan'=>['id',],
'kez'=>['tr',],
'kezkatu'=>['eu',],
'keçin'=>['az',],
'keď'=>['sk',],
'keşke'=>['tr',],
'khan'=>['si',],
'khawatir'=>['ms',],
'khusus'=>['id','ms',],
'ki'=>['az','hu','sl','sq','tr',],
'kia'=>['eu',],
'kibaszott'=>['hu',],
'kicsi'=>['hu',],
'kicsim'=>['hu',],
'kicsit'=>['hu',],
'kid'=>['en','th',],
'kidding'=>['en',],
'kids'=>['en',],
'kiedy'=>['pl',],
'kiedykolwiek'=>['pl',],
'kiedyś'=>['pl',],
'kiek'=>['lt',],
'kiekvienas'=>['lt',],
'kiekvieną'=>['lt',],
'kifelé'=>['hu',],
'kig'=>['da',],
'kigge'=>['da',],
'kigger'=>['da',],
'kiinni'=>['fi',],
'kiire'=>['et',],
'kiiremini'=>['et',],
'kiiresti'=>['et',],
'kiitoksia'=>['fi',],
'kiitos'=>['fi',],
'kijk'=>['nl',],
'kijken'=>['nl',],
'kijkt'=>['nl',],
'kik'=>['hu',],
'kilink'=>['ca',],
'kilka'=>['pl',],
'kilku'=>['pl',],
'kill'=>['en','si',],
'killar'=>['sv',],
'kille'=>['sv',],
'killed'=>['en','th',],
'killen'=>['sv',],
'killing'=>['en','si',],
'kilometer'=>['id',],
'kiltti'=>['fi',],
'kim'=>['bs','hr','pl','sr','tr',],
'kimi'=>['az',],
'kimia'=>['id',],
'kimin'=>['tr',],
'kimlər'=>['az',],
'kimse'=>['tr',],
'kimsenin'=>['tr',],
'kimseye'=>['tr',],
'kimsin'=>['tr',],
'kimś'=>['pl',],
'kind'=>['af','de','en','nl','th',],
'kindel'=>['et',],
'kinder'=>['de',],
'kinderen'=>['nl',],
'kinders'=>['af',],
'kindlasti'=>['et',],
'kindral'=>['et',],
'kinek'=>['hu',],
'king'=>['en',],
'kinni'=>['et',],
'kint'=>['hu',],
'kira'=>['id','ms',],
'kiri'=>['id','ms',],
'kirja'=>['et',],
'király'=>['hu',],
'kis'=>['hu',],
'kisah'=>['id',],
'kisasszony'=>['hu',],
'kisha'=>['sq',],
'kishe'=>['sq',],
'kishim'=>['sq',],
'kishin'=>['sq',],
'kishte'=>['sq',],
'kislány'=>['hu',],
'kiss'=>['en','si',],
'kit'=>['hu',],
'kita'=>['id','lt','ms',],
'kitaip'=>['lt',],
'kitap'=>['tr',],
'kitas'=>['lt',],
'kiti'=>['lt',],
'kito'=>['lt',],
'kitos'=>['lt',],
'kitu'=>['lt',],
'kitus'=>['lt',],
'kitą'=>['lt',],
'kitų'=>['lt',],
'kiva'=>['fi',],
'kizno'=>['th',],
'kişi'=>['tr',],
'kjaftæði'=>['is',],
'kje'=>['sl',],
'kjeft'=>['nb','no',],
'kjenner'=>['nb','no',],
'kjent'=>['nb','no',],
'kjente'=>['nb','no',],
'kjer'=>['sl',],
'kjo'=>['sq',],
'kjære'=>['nb','no',],
'kjærlighet'=>['nb','no',],
'kjøpe'=>['nb','no',],
'kjør'=>['nb','no',],
'kjøre'=>['nb','no',],
'kjører'=>['nb','no',],
'kjørte'=>['nb',],
'kki'=>['is',],
'kl'=>['da','nb','no',],
'kla'=>['af',],
'klaar'=>['nl',],
'klank'=>['af',],
'klar'=>['da','de','nb','no','sv',],
'klara'=>['sv',],
'klarade'=>['sv',],
'klarar'=>['sv',],
'klare'=>['da','nb','no',],
'klarer'=>['da','nb','no',],
'klart'=>['da','nb','no','sv',],
'klarte'=>['nb','no',],
'klasse'=>['de',],
'klau'=>['lv',],
'klausau'=>['lt',],
'klausies'=>['lv',],
'klausieties'=>['lv',],
'klausimas'=>['lt',],
'klausyk'=>['lt',],
'klein'=>['af','nl',],
'kleine'=>['de','nl',],
'kleinen'=>['de',],
'kleiner'=>['de',],
'kleines'=>['de',],
'klere'=>['af',],
'kleren'=>['nl',],
'klid'=>['cs',],
'klidně'=>['cs',],
'klingt'=>['de',],
'klink'=>['af',],
'klinkt'=>['nl',],
'kliskatu'=>['eu',],
'klockan'=>['sv',],
'klok'=>['af',],
'klokka'=>['nb','no',],
'klokken'=>['da','nb','no',],
'klomp'=>['af',],
'klootzak'=>['nl',],
'klop'=>['af',],
'klopt'=>['nl',],
'kluci'=>['cs',],
'kluk'=>['cs',],
'klukkan'=>['is',],
'kläder'=>['sv',],
'klājas'=>['lv',],
'klāt'=>['lv',],
'km'=>['hi','si',],
'kmalu'=>['sl',],
'kneg'=>['af',],
'knew'=>['en','th',],
'knockin'=>['af',],
'know'=>['en','fa','si','th',],
'known'=>['en',],
'knows'=>['en',],
'knyga'=>['lt',],
'knygą'=>['lt',],
'knægt'=>['da',],
'ko'=>['bs','lt','lv','sl','sr',],
'kobieta'=>['pl',],
'kobiety'=>['pl',],
'koca'=>['tr',],
'kocha'=>['pl',],
'kocham'=>['pl',],
'kochanie'=>['pl',],
'kochasz'=>['pl',],
'kod'=>['bs','hr','sl','sr',],
'kodel'=>['lt',],
'kodu'=>['et',],
'kodus'=>['et',],
'kodėi'=>['lt',],
'kodėl'=>['lt',],
'koer'=>['et',],
'koffie'=>['nl',],
'koga'=>['bs','hr','sl','sr',],
'kogo'=>['pl',],
'kogoś'=>['pl',],
'kogu'=>['et',],
'koha'=>['et','sq',],
'kohal'=>['et',],
'kohale'=>['et',],
'kohe'=>['et','sq',],
'koho'=>['cs','sk',],
'koht'=>['et',],
'kohta'=>['et','fi',],
'kohti'=>['fi',],
'kohtuda'=>['et',],
'kohtume'=>['et',],
'kohutav'=>['et',],
'kohvi'=>['et',],
'kohë'=>['sq',],
'kohën'=>['sq',],
'kohës'=>['sq',],
'koira'=>['fi',],
'koja'=>['bs','hr','sr',],
'koje'=>['bs','hr','sr',],
'kojeg'=>['bs','hr',],
'kojem'=>['hr',],
'koji'=>['bs','hr','sr',],
'kojoj'=>['bs','hr','sr',],
'koju'=>['bs','et','hr','sr',],
'kokia'=>['lt',],
'kokie'=>['lt',],
'kokio'=>['lt',],
'kokios'=>['lt',],
'kokią'=>['lt',],
'kokku'=>['et',],
'koko'=>['fi',],
'kokotako'=>['eu',],
'koks'=>['lt',],
'kokë'=>['sq',],
'kokën'=>['sq',],
'kokį'=>['lt',],
'kol'=>['lt',],
'kola'=>['bs','sr',],
'kolay'=>['tr',],
'kolega'=>['sl',],
'kolem'=>['cs',],
'koleś'=>['pl',],
'kolik'=>['cs',],
'koliko'=>['bs','hr','sl','sr',],
'kolla'=>['sv',],
'kolm'=>['et',],
'kolme'=>['et','fi',],
'kolonel'=>['nl',],
'kolpatzea'=>['eu',],
'kolpatzean'=>['eu',],
'kolpe'=>['eu',],
'kolski'=>['th',],
'kom'=>['af','da','is','nb','nl','no','sl','sv',],
'koma'=>['is',],
'komaan'=>['nl',],
'komaj'=>['sl',],
'komanda'=>['lt',],
'komast'=>['is',],
'kombes'=>['et',],
'komdu'=>['is',],
'kome'=>['bs','hr','sr',],
'komen'=>['nl',],
'komi'=>['is',],
'komik'=>['tr',],
'komin'=>['is',],
'kominn'=>['is',],
'komisch'=>['de',],
'komist'=>['is',],
'komið'=>['is',],
'komm'=>['de',],
'komma'=>['sv',],
'komme'=>['da','de','nb','no',],
'kommen'=>['de',],
'kommer'=>['da','nb','no','sv',],
'kommet'=>['da','nb','no',],
'kommit'=>['sv',],
'kommst'=>['de',],
'kommt'=>['de',],
'komnir'=>['is',],
'komoly'=>['hu',],
'komolyan'=>['hu',],
'kompis'=>['nb','no','sv',],
'kompleks'=>['id',],
'komputer'=>['id',],
'komst'=>['is',],
'komstu'=>['is',],
'komt'=>['nl',],
'komu'=>['is',],
'komum'=>['is',],
'komumst'=>['is',],
'kon'=>['af','nl',],
'kona'=>['is','nb','no',],
'konan'=>['is',],
'konar'=>['is',],
'konaиno'=>['sr',],
'konca'=>['sl',],
'koncu'=>['sl',],
'konden'=>['nl',],
'kondisi'=>['id',],
'kone'=>['da','nb','no',],
'konec'=>['cs','sl',],
'konečne'=>['sk',],
'konečně'=>['cs',],
'koniec'=>['pl','sk',],
'koning'=>['af','nl',],
'koninkryk'=>['af',],
'konnte'=>['de',],
'konnten'=>['de',],
'konsekuensi'=>['id',],
'konstigt'=>['sv',],
'kont'=>['nl',],
'kontak'=>['id',],
'kontakt'=>['nb','no',],
'kontor'=>['da',],
'kontoret'=>['nb','no',],
'kontrak'=>['af',],
'kontroirati'=>['hi',],
'kontrol'=>['id','tr',],
'kontrolatzen'=>['eu',],
'kontrolli'=>['et',],
'kontuz'=>['eu',],
'kontzertua'=>['eu',],
'kontzertuagatik'=>['eu',],
'kontzertura'=>['eu',],
'konu'=>['is','tr',],
'konuda'=>['tr',],
'konuna'=>['is',],
'konur'=>['is',],
'konusunda'=>['tr',],
'konuşma'=>['tr',],
'konuşmak'=>['tr',],
'končal'=>['sl',],
'končno'=>['sl',],
'koobus'=>['th',],
'kook'=>['af',],
'kooli'=>['et',],
'koos'=>['et',],
'kop'=>['af','nl',],
'kopen'=>['nl',],
'kopf'=>['de',],
'kopi'=>['ms',],
'kopā'=>['lv',],
'kopš'=>['lv',],
'kor'=>['hu',],
'kord'=>['et',],
'korda'=>['et',],
'koristi'=>['bs','sr',],
'korkunç'=>['tr',],
'koro'=>['eu',],
'koroak'=>['eu',],
'korok'=>['eu',],
'kororekin'=>['eu',],
'kororen'=>['eu',],
'kororentzat'=>['eu',],
'korori'=>['eu',],
'korra'=>['et',],
'korras'=>['et',],
'korrek'=>['af',],
'kort'=>['da','nb','no','sv',],
'korábban'=>['hu',],
'koska'=>['fi',],
'koskaan'=>['fi',],
'kosmik'=>['id',],
'kosmos'=>['id',],
'kosong'=>['ms',],
'kost'=>['nl',],
'kostakoa'=>['eu',],
'kot'=>['sl',],
'kota'=>['id','ms',],
'kotak'=>['ms',],
'kotiin'=>['fi',],
'kotona'=>['fi',],
'kotoran'=>['ms',],
'koud'=>['af','nl',],
'koukni'=>['cs',],
'kovin'=>['fi',],
'koľko'=>['sk',],
'końca'=>['pl',],
'końcu'=>['pl',],
'kracht'=>['nl',],
'krag'=>['af',],
'kragtig'=>['af',],
'kragtige'=>['af',],
'kraj'=>['bs','hr','sl','sr',],
'kraja'=>['bs','hr','sr',],
'kraju'=>['bs','hr','pl','sr',],
'kral'=>['tr',],
'kralj'=>['hr','sl','sr',],
'krank'=>['de',],
'krankenhaus'=>['de',],
'krap'=>['af',],
'krasno'=>['sl',],
'kraujo'=>['lt',],
'kreeg'=>['nl',],
'kreisi'=>['lv',],
'krejt'=>['sq',],
'kreni'=>['bs',],
'kreten'=>['sl',],
'krev'=>['cs',],
'krevet'=>['bs','hr','sr',],
'krew'=>['pl',],
'kreèuæi'=>['hi',],
'kri'=>['sl',],
'krieg'=>['de',],
'kriegen'=>['de',],
'kriegt'=>['de',],
'krig'=>['da','nb','no','sv',],
'krigen'=>['da','nb','no',],
'kriget'=>['sv',],
'krijg'=>['nl',],
'krijgen'=>['nl',],
'krijgt'=>['nl',],
'krishna'=>['af',],
'krisht'=>['sq',],
'kristal'=>['id',],
'kristen'=>['id',],
'kristus'=>['sl',],
'kriv'=>['hr','sl',],
'kromě'=>['cs',],
'kroon'=>['af',],
'krop'=>['da',],
'kropp'=>['sv',],
'kroppen'=>['nb',],
'kroz'=>['bs','hr','sr',],
'kruideniers'=>['af',],
'kruis'=>['af',],
'krv'=>['bs','hr','sk','sr',],
'krvi'=>['bs','hr',],
'krwi'=>['pl',],
'kry'=>['af',],
'král'=>['cs',],
'krát'=>['sk',],
'kterou'=>['cs',],
'která'=>['cs',],
'které'=>['cs',],
'který'=>['cs',],
'kteří'=>['cs',],
'kthehem'=>['sq',],
'kthehemi'=>['sq',],
'kthehesh'=>['sq',],
'kthehet'=>['sq',],
'kthehu'=>['sq',],
'kthyer'=>['sq',],
'kto'=>['pl','sk',],
'ktorej'=>['sk',],
'ktorá'=>['sk',],
'ktoré'=>['sk',],
'ktorého'=>['sk',],
'ktorí'=>['sk',],
'ktorú'=>['sk',],
'ktorý'=>['sk',],
'ktorých'=>['sk',],
'ktoś'=>['pl',],
'która'=>['pl',],
'które'=>['pl',],
'którego'=>['pl',],
'której'=>['pl',],
'który'=>['pl',],
'których'=>['pl',],
'którym'=>['pl',],
'którzy'=>['pl',],
'którą'=>['pl',],
'ku'=>['ms','sk','sq',],
'kuantum'=>['id',],
'kuat'=>['id','ms',],
'kubilang'=>['ms',],
'kucing'=>['ms',],
'kuda'=>['bs','hr','ms','sr',],
'kudo'=>['sq',],
'kuhu'=>['et',],
'kuhugi'=>['et',],
'kui'=>['et',],
'kuid'=>['et',],
'kuidagi'=>['et',],
'kuidas'=>['et',],
'kuigi'=>['et',],
'kuin'=>['fi',],
'kuinka'=>['fi',],
'kuitenkin'=>['fi',],
'kujdes'=>['sq',],
'kujt'=>['sq',],
'kujtohet'=>['sq',],
'kuka'=>['fi',],
'kukaan'=>['fi',],
'kukatakan'=>['ms',],
'kukira'=>['ms',],
'kul'=>['sv',],
'kulakukan'=>['ms',],
'kulit'=>['ms',],
'kullake'=>['et',],
'kult'=>['nb',],
'kulta'=>['fi',],
'kultaseni'=>['fi',],
'kuluttua'=>['fi',],
'kumohon'=>['ms',],
'kumpel'=>['de',],
'kun'=>['da','fi','nb','nl','no',],
'kuna'=>['et',],
'kunagi'=>['et',],
'kunci'=>['ms',],
'kunde'=>['sv',],
'kundze'=>['lv',],
'kundër'=>['sq',],
'kunem'=>['bs','hr','sr',],
'kung'=>['sv',],
'kungi'=>['lv',],
'kungs'=>['lv',],
'kungu'=>['lv',],
'kunhan'=>['fi',],
'kuni'=>['et',],
'kuningas'=>['et','fi',],
'kunjungan'=>['id',],
'kunna'=>['sv',],
'kunne'=>['da','nb','no',],
'kunnen'=>['nl',],
'kunnes'=>['fi',],
'kunnolla'=>['fi',],
'kunnon'=>['fi',],
'kunnossa'=>['fi',],
'kuno'=>['id',],
'kunt'=>['nl',],
'kuo'=>['lt',],
'kuolee'=>['fi',],
'kuoli'=>['fi',],
'kuolla'=>['fi',],
'kuollut'=>['fi',],
'kupikir'=>['ms',],
'kupil'=>['sl',],
'kupiti'=>['hr',],
'kupić'=>['pl',],
'kuptim'=>['sq',],
'kuptoj'=>['sq',],
'kupton'=>['sq',],
'kuptoni'=>['sq',],
'kuptova'=>['sq',],
'kupu'=>['id',],
'kur'=>['lt','lv','sq',],
'kura'=>['lv',],
'kurac'=>['bs','hr',],
'kuradi'=>['et',],
'kuradima'=>['et',],
'kuradit'=>['et',],
'kurang'=>['id','ms',],
'kuras'=>['lv',],
'kurasa'=>['ms',],
'kurat'=>['et',],
'kuri'=>['lt','lv',],
'kuria'=>['lt',],
'kurie'=>['lt',],
'kurienes'=>['lv',],
'kurieni'=>['lv',],
'kurio'=>['lt',],
'kurios'=>['lt',],
'kuris'=>['lt',],
'kuriuo'=>['lt',],
'kuriuos'=>['lt',],
'kurią'=>['lt',],
'kurių'=>['lt',],
'kurp'=>['lv',],
'kurrë'=>['sq',],
'kuru'=>['lv',],
'kurus'=>['lv',],
'kurva'=>['cs','hu','sk',],
'kurwa'=>['pl',],
'kurz'=>['de',],
'kurā'=>['lv',],
'kurį'=>['lt',],
'kurš'=>['lv',],
'kus'=>['et',],
'kush'=>['af','sq',],
'kusha'=>['af',],
'kusipää'=>['fi',],
'kuskil'=>['et',],
'kust'=>['et',],
'kusura'=>['tr',],
'kuten'=>['fi',],
'kutid'=>['et',],
'kutsu'=>['et',],
'kutt'=>['et','nb','no',],
'kutya'=>['hu',],
'kuu'=>['et',],
'kuud'=>['et',],
'kuukautta'=>['fi',],
'kuula'=>['et',],
'kuulake'=>['et',],
'kuulda'=>['et',],
'kuule'=>['et','fi',],
'kuuled'=>['et',],
'kuulemma'=>['fi',],
'kuulin'=>['fi',],
'kuulla'=>['fi',],
'kuullut'=>['fi',],
'kuulnud'=>['et',],
'kuulostaa'=>['fi',],
'kuulsid'=>['et',],
'kuulsin'=>['et',],
'kuulu'=>['fi',],
'kuuluu'=>['fi',],
'kuuntele'=>['fi',],
'kuus'=>['et',],
'kuusi'=>['fi',],
'kuće'=>['bs','hr',],
'kući'=>['bs','hr',],
'kuću'=>['bs','hr',],
'kuģa'=>['lv',],
'kuģi'=>['lv',],
'kuģis'=>['lv',],
'kuжa'=>['sr',],
'kuжe'=>['bs','sr',],
'kuжi'=>['bs','hr','sr',],
'kuжu'=>['sr',],
'kvaila'=>['lt',],
'kvailas'=>['lt',],
'kvar'=>['sv',],
'kveld'=>['nb','no',],
'kvelden'=>['nb','no',],
'kvinde'=>['da',],
'kvinder'=>['da',],
'kvinna'=>['sv',],
'kvinnan'=>['sv',],
'kvinne'=>['nb','no',],
'kvinnen'=>['nb',],
'kvinner'=>['nb','no',],
'kvinnor'=>['sv',],
'kvragu'=>['hr',],
'kväll'=>['sv',],
'kvällen'=>['sv',],
'kvôli'=>['sk',],
'kvöld'=>['is',],
'kvöldið'=>['is',],
'kvůli'=>['cs',],
'kwaad'=>['af','nl',],
'kwam'=>['nl',],
'kwamen'=>['nl',],
'kwijt'=>['nl',],
'kwynende'=>['af',],
'ky'=>['sq',],
'kyllä'=>['fi',],
'kymmenen'=>['fi',],
'kynnast'=>['is',],
'kyrr'=>['is',],
'kyse'=>['fi',],
'kyss'=>['nb','no',],
'kysy'=>['fi',],
'kysymys'=>['fi',],
'kysyä'=>['fi',],
'kámo'=>['cs','sk',],
'kä'=>['lv',],
'kädet'=>['fi',],
'käed'=>['et',],
'käes'=>['et',],
'käest'=>['et',],
'käften'=>['sv',],
'käi'=>['et',],
'käia'=>['et',],
'käib'=>['et',],
'käinud'=>['et',],
'kämpfen'=>['de',],
'kände'=>['sv',],
'känna'=>['sv',],
'känner'=>['sv',],
'känns'=>['sv',],
'kära'=>['sv',],
'kärlek'=>['sv',],
'käsi'=>['et',],
'kätte'=>['et',],
'kävi'=>['fi',],
'käy'=>['fi',],
'käydä'=>['fi',],
'käynyt'=>['fi',],
'käyttää'=>['fi',],
'käytä'=>['fi',],
'kæft'=>['da',],
'kæmpe'=>['da',],
'kære'=>['da',],
'kæreste'=>['da',],
'kærlighed'=>['da',],
'kéne'=>['hu',],
'képes'=>['hu',],
'kérdés'=>['hu',],
'kérek'=>['hu',],
'kérem'=>['hu',],
'kérlek'=>['hu',],
'kérsz'=>['hu',],
'kész'=>['hu',],
'készen'=>['hu',],
'késő'=>['hu',],
'később'=>['hu',],
'két'=>['hu',],
'kë'=>['sq',],
'këmbë'=>['sq',],
'këmbët'=>['sq',],
'kërkoj'=>['sq',],
'kërkon'=>['sq',],
'kërkuar'=>['sq',],
'kësaj'=>['sq',],
'kështu'=>['sq',],
'këta'=>['sq',],
'këtej'=>['sq',],
'këtij'=>['sq',],
'këto'=>['sq',],
'këtu'=>['sq',],
'këtyre'=>['sq',],
'këtë'=>['sq',],
'kívül'=>['hu',],
'kõige'=>['et',],
'kõigest'=>['et',],
'kõigi'=>['et',],
'kõigile'=>['et',],
'kõik'=>['et',],
'kõike'=>['et',],
'kõiki'=>['et',],
'kõlab'=>['et',],
'kõrvale'=>['et',],
'kõvasti'=>['et',],
'kölyök'=>['hu',],
'könig'=>['de',],
'können'=>['de',],
'könnt'=>['de',],
'könnte'=>['de',],
'könnten'=>['de',],
'könntest'=>['de',],
'könnyű'=>['hu',],
'köpa'=>['sv',],
'köpek'=>['tr',],
'köpte'=>['sv',],
'kör'=>['sv',],
'köra'=>['sv',],
'körde'=>['sv',],
'körper'=>['de',],
'körül'=>['hu',],
'kösz'=>['hu',],
'köszi'=>['hu',],
'köszönjük'=>['hu',],
'köszönöm'=>['hu',],
'kötü'=>['tr',],
'következő'=>['hu',],
'közben'=>['hu',],
'közel'=>['hu',],
'között'=>['hu',],
'közül'=>['hu',],
'købe'=>['da',],
'kør'=>['da',],
'køre'=>['da',],
'kører'=>['da',],
'kørte'=>['da',],
'küll'=>['et',],
'különben'=>['hu',],
'különleges'=>['hu',],
'kümme'=>['et',],
'kümmern'=>['de',],
'küsida'=>['et',],
'küsimus'=>['et',],
'küçük'=>['tr',],
'kým'=>['cs','sk',],
'kā'=>['lv',],
'kāda'=>['lv',],
'kādam'=>['lv',],
'kādas'=>['lv',],
'kādi'=>['lv',],
'kādreiz'=>['lv',],
'kāds'=>['lv',],
'kādu'=>['lv',],
'kādā'=>['lv',],
'kādēļ'=>['lv',],
'kājas'=>['lv',],
'kājām'=>['lv',],
'kāp'=>['lv',],
'kāpēc'=>['lv',],
'kārtībā'=>['lv',],
'ką'=>['lt',],
'kırmızı'=>['tr',],
'kısa'=>['tr',],
'kız'=>['tr',],
'kızlar'=>['tr',],
'kızı'=>['tr',],
'kızım'=>['tr',],
'kızın'=>['tr',],
'kļūst'=>['lv',],
'kļūt'=>['lv',],
'kľud'=>['sk',],
'kłopoty'=>['pl',],
'kūper'=>['lv',],
'kənd'=>['az',],
'kรชrel'=>['af',],
'l'=>['ar','az','bs','ca','cs','da','en','fr','hr','is','it','ms','nb','no','pl','pt_br','ro','si','sq','sr','sv','th',],
'la'=>['ca','en','es','fr','it','ms','nb','no','pt','pt_br','ro','si','sq','sv',],
'laaste'=>['af',],
'laat'=>['af','nl',],
'laatste'=>['nl',],
'laba'=>['lv',],
'labai'=>['lt',],
'labanakt'=>['lt',],
'labas'=>['lt',],
'labi'=>['lv',],
'labiau'=>['lt',],
'labiausiai'=>['lt',],
'labor'=>['gl',],
'labrīt'=>['lv',],
'labs'=>['lv',],
'labu'=>['lv',],
'laburrerako'=>['eu',],
'labā'=>['lv',],
'labāk'=>['lv',],
'labākais'=>['lv',],
'laced'=>['si',],
'lachen'=>['de','nl',],
'lad'=>['da','no',],
'lade'=>['da',],
'laden'=>['de',],
'lader'=>['da',],
'ladies'=>['en','si',],
'lado'=>['es','gl','pt','pt_br',],
'lady'=>['ca','en',],
'lae'=>['af',],
'lag'=>['af','nb',],
'lage'=>['nb','no',],
'lager'=>['nb','no',],
'laget'=>['nb','no',],
'laggiù'=>['it',],
'lagi'=>['id','is','ms',],
'lagu'=>['ms',],
'lagun'=>['eu',],
'laguna'=>['eu',],
'lagunak'=>['eu',],
'lagundu'=>['eu',],
'lagunentzako'=>['eu',],
'laguntza'=>['eu',],
'lahe'=>['et',],
'lahir'=>['id','ms',],
'lahko'=>['sl',],
'lahku'=>['et',],
'lahkuda'=>['et',],
'lahti'=>['et',],
'lai'=>['lv',],
'laika'=>['lv',],
'laikam'=>['lv',],
'laikas'=>['lt',],
'laiko'=>['lt',],
'laiks'=>['lv',],
'laiku'=>['lt','lv',],
'laikyk'=>['lt',],
'laikykis'=>['lt',],
'laikā'=>['lv',],
'laiką'=>['lt',],
'laimingas'=>['lt',],
'lain'=>['id','ms',],
'lainnya'=>['id','ms',],
'laipni'=>['lv',],
'laisse'=>['fr',],
'laisser'=>['fr',],
'laissez'=>['fr',],
'laissé'=>['fr',],
'laita'=>['fi',],
'laittaa'=>['fi',],
'laivas'=>['lt',],
'laivą'=>['lt',],
'laki'=>['id','ms',],
'lakin'=>['az',],
'lako'=>['bs','hr','sr',],
'laku'=>['bs','hr','sr',],
'lakukan'=>['id','ms',],
'lalu'=>['id','ms',],
'lama'=>['id','ms',],
'lambat'=>['id',],
'lamborghini'=>['si',],
'lamento'=>['es','pt','pt_br',],
'lampu'=>['ms',],
'lan'=>['eu',],
'lana'=>['eu',],
'land'=>['af','da','de','en','is','nb','nl','no','sv',],
'landet'=>['da','nb','no','sv',],
'landu'=>['eu',],
'landua'=>['eu',],
'lanet'=>['tr',],
'lang'=>['da','de','nb','nl','no',],
'langar'=>['is',],
'lange'=>['de','nl',],
'langer'=>['nl',],
'langit'=>['id','ms',],
'langka'=>['id',],
'langkah'=>['id','ms',],
'langs'=>['af','nl',],
'langsam'=>['de',],
'langsung'=>['id','ms',],
'langt'=>['da','is','nb','no',],
'lanjut'=>['id',],
'lank'=>['af',],
'lanka'=>['af',],
'lanpetuta'=>['eu',],
'lanskap'=>['id',],
'lantai'=>['ms',],
'lapar'=>['ms',],
'lapisan'=>['id',],
'laporan'=>['id','ms',],
'laps'=>['et',],
'lapse'=>['et',],
'lapsed'=>['et',],
'lapset'=>['fi',],
'lapsi'=>['et','fi',],
'lapsia'=>['fi',],
'lar'=>['nb','no',],
'larg'=>['sq',],
'large'=>['th',],
'largo'=>['es',],
'largohu'=>['sq',],
'lari'=>['ms',],
'lart'=>['sq',],
'lartë'=>['sq',],
'las'=>['ca','es','et','pt','pt_br','ro',],
'lasai'=>['eu',],
'lasaitasuna'=>['eu',],
'lasci'=>['it',],
'lascia'=>['it',],
'lasciami'=>['it',],
'lasciare'=>['it',],
'lasciato'=>['it',],
'lase'=>['et',],
'lasen'=>['et',],
'laske'=>['et',],
'lass'=>['de',],
'lassan'=>['hu',],
'lasse'=>['de',],
'lassen'=>['de',],
'lasst'=>['de',],
'last'=>['en','et','si',],
'lasta'=>['et',],
'laster'=>['eu',],
'lasă'=>['ro',],
'lat'=>['pl',],
'lata'=>['pl',],
'late'=>['en','si',],
'laten'=>['nl',],
'later'=>['af','en','nl',],
'laufen'=>['de',],
'laugh'=>['en',],
'laughing'=>['en',],
'laughs'=>['en',],
'lauk'=>['lt',],
'lauke'=>['lt',],
'laukia'=>['lt',],
'laukti'=>['lt',],
'laukā'=>['lv',],
'launderer'=>['af',],
'laut'=>['de','id','ms',],
'lautan'=>['id',],
'lave'=>['da',],
'lavede'=>['da',],
'laver'=>['da','no',],
'lavet'=>['da',],
'lavorare'=>['it',],
'lavoro'=>['it',],
'law'=>['en',],
'laxman'=>['af',],
'lazım'=>['tr',],
'laß'=>['de',],
'laşi'=>['ro',],
'lch'=>['de',],
'le'=>['es','fr','hu','it','ro','sl','sq',],
'lead'=>['en',],
'leah'=>['si',],
'learn'=>['en',],
'least'=>['en',],
'leave'=>['en','si',],
'leaving'=>['en',],
'leben'=>['de',],
'lebens'=>['de',],
'lebih'=>['id','ms',],
'lebo'=>['sk',],
'lebt'=>['de',],
'leci'=>['pl',],
'lecz'=>['pl',],
'ledakan'=>['id',],
'lede'=>['da',],
'leder'=>['da','nb','no',],
'ledsen'=>['sv',],
'leef'=>['af',],
'leeft'=>['nl',],
'leek'=>['nl',],
'leelas'=>['af',],
'left'=>['en','th',],
'leg'=>['nl',],
'legal'=>['pt','pt_br',],
'legalább'=>['hu',],
'legati'=>['la',],
'legatos'=>['la',],
'lege'=>['la','nb','no',],
'legem'=>['la',],
'leger'=>['nl',],
'leges'=>['la',],
'legg'=>['nb','no',],
'legge'=>['it','nb','no',],
'legger'=>['nb','no',],
'leggja'=>['is',],
'legibus'=>['la',],
'legiones'=>['la',],
'legis'=>['la',],
'legjobb'=>['hu',],
'legnagyobb'=>['hu',],
'legyek'=>['hu',],
'legyen'=>['hu',],
'legyél'=>['hu',],
'legătură'=>['ro',],
'lehenago'=>['eu',],
'lehenengo'=>['eu',],
'lehenengoa'=>['eu',],
'lehenengoak'=>['eu',],
'lehet'=>['hu',],
'lehetetlen'=>['hu',],
'lehetett'=>['hu',],
'lehetne'=>['hu',],
'lehetséges'=>['hu',],
'lehtë'=>['sq',],
'lei'=>['af','gl','it','nb','no','pt','pt_br',],
'leia'=>['et',],
'leicht'=>['de',],
'leid'=>['de',],
'leida'=>['et',],
'leider'=>['de',],
'leidsid'=>['et',],
'leidsin'=>['et',],
'leik'=>['is',],
'leika'=>['is',],
'leikur'=>['is',],
'leisk'=>['lt',],
'leisti'=>['lt',],
'leit'=>['is',],
'leita'=>['is',],
'leitt'=>['is',],
'leið'=>['is',],
'leiðinni'=>['is',],
'lejo'=>['sq',],
'lejoni'=>['sq',],
'lejos'=>['es',],
'lejā'=>['lv',],
'lekker'=>['af','nl',],
'leku'=>['eu',],
'lekua'=>['eu',],
'lelaki'=>['ms',],
'lelike'=>['af',],
'lem'=>['th',],
'lemah'=>['id',],
'lembaga'=>['id',],
'lembra'=>['pt_br',],
'lembrar'=>['pt_br',],
'lembro'=>['pt','pt_br',],
'len'=>['sk',],
'lenge'=>['nb','no',],
'lenger'=>['nb','no',],
'lengi'=>['is',],
'lengur'=>['is',],
'lengva'=>['lt',],
'lenne'=>['hu',],
'lenni'=>['hu',],
'lennie'=>['hu',],
'lennék'=>['hu',],
'leo'=>['lv',],
'lep'=>['sl','sr',],
'lepa'=>['sl','sr',],
'lepaskan'=>['ms',],
'lepiej'=>['pl',],
'lepo'=>['sl','sr',],
'lepoan'=>['eu',],
'lepšie'=>['sk',],
'lepší'=>['cs',],
'ler'=>['pt','pt_br',],
'leren'=>['nl',],
'lernen'=>['de',],
'lerro'=>['eu',],
'lerroa'=>['eu',],
'les'=>['ca','es','fr',],
'lesa'=>['is',],
'lese'=>['nb','no',],
'lesen'=>['de',],
'less'=>['en',],
'lesz'=>['hu',],
'leszek'=>['hu',],
'leszel'=>['hu',],
'lesznek'=>['hu',],
'leszünk'=>['hu',],
'let'=>['cs','da','en','fa','nl','si','sl','th',],
'leta'=>['sl','sv',],
'letalo'=>['sl',],
'letar'=>['sv',],
'leter'=>['nb','no',],
'leti'=>['sl',],
'letih'=>['sl',],
'leto'=>['sl',],
'lett'=>['hu','nb','no',],
'letter'=>['en',],
'lettera'=>['it',],
'letto'=>['it',],
'lettre'=>['fr',],
'lety'=>['cs',],
'letzte'=>['de',],
'letzten'=>['de',],
'leuk'=>['nl',],
'leuke'=>['nl',],
'leun'=>['af',],
'leur'=>['fr',],
'leurs'=>['fr',],
'leute'=>['de',],
'leuten'=>['de',],
'leva'=>['gl','pt','pt_br','sv',],
'levaba'=>['gl',],
'levande'=>['sv',],
'levar'=>['gl','pt','pt_br',],
'leve'=>['da','nb','no','pt_br',],
'leven'=>['nl',],
'levende'=>['nb','no',],
'lever'=>['da','nb','no','sv',],
'levo'=>['sl',],
'levou'=>['pt_br',],
'lewat'=>['ms',],
'lewe'=>['af',],
'lex'=>['la',],
'lexi'=>['af',],
'ley'=>['es',],
'leyfi'=>['is',],
'leyfðu'=>['is',],
'lezen'=>['nl',],
'leรซr'=>['af',],
'lf'=>['en',],
'lgen'=>['hu',],
'lhe'=>['pt','pt_br',],
'lhes'=>['pt','pt_br',],
'lhnen'=>['de',],
'lhr'=>['de',],
'lhre'=>['de',],
'lhren'=>['de',],
'lhrer'=>['de',],
'li'=>['bs','ca','cs','hr','it','sl','sr',],
'liah'=>['hi',],
'liahin'=>['hi',],
'liaukis'=>['lt',],
'liber'=>['la','ro',],
'liberdade'=>['gl',],
'libero'=>['it',],
'liberos'=>['la',],
'libertad'=>['es',],
'libre'=>['es','fr','gl',],
'libri'=>['la',],
'libris'=>['la',],
'libro'=>['es','gl','it','la',],
'libros'=>['gl',],
'liburuetatik'=>['eu',],
'lice'=>['bs','hr','sr',],
'licença'=>['pt','pt_br',],
'licet'=>['la',],
'lichaam'=>['nl',],
'licht'=>['de','nl',],
'lide'=>['da','no',],
'lidem'=>['cs',],
'lidhje'=>['sq',],
'lidhur'=>['sq',],
'lidi'=>['cs',],
'lidt'=>['da','no',],
'lidé'=>['cs',],
'lidí'=>['cs',],
'lie'=>['en',],
'liebe'=>['de',],
'lieben'=>['de',],
'lieber'=>['de',],
'liebling'=>['de',],
'liebt'=>['de',],
'liec'=>['lv',],
'lied'=>['af',],
'liedjies'=>['af',],
'lief'=>['af','nl',],
'liefde'=>['af','nl',],
'liefdesverhouding'=>['af',],
'liefhet'=>['af',],
'liefje'=>['nl',],
'lieflike'=>['af',],
'liefling'=>['af',],
'liegen'=>['de',],
'liegt'=>['de',],
'liek'=>['lv',],
'liekas'=>['lv',],
'liela'=>['lv',],
'lieliska'=>['lv',],
'lieliski'=>['lv',],
'liels'=>['lv',],
'lielu'=>['lv',],
'liet'=>['nl',],
'lieta'=>['lv',],
'lietas'=>['lv',],
'lietu'=>['lv',],
'lietām'=>['lv',],
'lieu'=>['fr',],
'lieutenant'=>['en',],
'lieve'=>['nl',],
'liever'=>['nl',],
'lieverd'=>['nl',],
'liewe'=>['af',],
'lifa'=>['is',],
'lifandi'=>['is',],
'life'=>['en','si','th',],
'lig'=>['af','da',],
'ligar'=>['pt','pt_br',],
'lige'=>['da','no',],
'ligeglad'=>['da',],
'ligesom'=>['da',],
'liggen'=>['nl',],
'ligger'=>['da','nb','no','sv',],
'light'=>['en',],
'lights'=>['si',],
'ligne'=>['fr',],
'ligner'=>['da',],
'ligt'=>['nl',],
'lihat'=>['id','ms',],
'lihatlah'=>['ms',],
'lihtne'=>['et',],
'lihtsalt'=>['et',],
'liian'=>['fi',],
'liiga'=>['et',],
'liiguta'=>['et',],
'liikaa'=>['fi',],
'liikettä'=>['fi',],
'lijepa'=>['bs','hr',],
'lijepo'=>['bs','hr',],
'lijken'=>['nl',],
'lijkt'=>['nl',],
'lijn'=>['nl',],
'lik'=>['lt',],
'lika'=>['sv',],
'like'=>['en','nb','no','si','th',],
'liked'=>['en',],
'liker'=>['nb','no',],
'likevel'=>['nb','no',],
'liko'=>['lt',],
'likte'=>['nb','no',],
'likti'=>['lt',],
'likās'=>['lv',],
'lilla'=>['sv',],
'lille'=>['da','nb','no',],
'lima'=>['id','ms',],
'limbah'=>['id',],
'lime'=>['th',],
'linda'=>['es','pt','pt_br',],
'lindo'=>['es','pt','pt_br',],
'line'=>['en',],
'linea'=>['it',],
'lingkaran'=>['id',],
'lingkungan'=>['id',],
'lingua'=>['gl','la',],
'linha'=>['pt','pt_br',],
'lini'=>['sq',],
'linişte'=>['ro',],
'link'=>['id','lt',],
'linker'=>['af',],
'links'=>['de',],
'linna'=>['et',],
'linnas'=>['et',],
'lipk'=>['lt',],
'lirateke'=>['eu',],
'lire'=>['fr',],
'lirë'=>['sq',],
'lista'=>['es','pt',],
'listen'=>['en','si',],
'listo'=>['es',],
'listos'=>['es',],
'listrik'=>['id',],
'lisää'=>['fi',],
'lit'=>['fr',],
'lita'=>['sv',],
'lite'=>['nb','no','sv',],
'liten'=>['nb','no','sv',],
'literatura'=>['gl',],
'litet'=>['sv',],
'litla'=>['is',],
'litli'=>['is',],
'litlu'=>['is',],
'litt'=>['nb','no',],
'litteras'=>['la',],
'litteris'=>['la',],
'little'=>['en','si','th',],
'litzaidake'=>['eu',],
'litzateke'=>['eu',],
'liv'=>['da','nb','no','sv',],
'live'=>['da','en','nb','no',],
'lived'=>['en',],
'lives'=>['en',],
'livet'=>['da','nb','no','sv',],
'living'=>['en',],
'livre'=>['fr','pt','pt_br',],
'livres'=>['fr',],
'livro'=>['pt','pt_br',],
'liðið'=>['is',],
'liña'=>['gl',],
'liиno'=>['sr',],
'ljubav'=>['bs','hr','sr',],
'ljubavi'=>['bs','hr','sr',],
'ljubezen'=>['sl',],
'ljubi'=>['sl',],
'ljubica'=>['sl',],
'ljubim'=>['sl',],
'ljude'=>['bs','hr','sr',],
'ljudi'=>['bs','hr','sl','sr',],
'ljudima'=>['bs','hr','sr',],
'ljudje'=>['sl',],
'ljuger'=>['sv',],
'lk'=>['nl',],
'lkke'=>['da','nb','no',],
'll'=>['fa','fr','it','si','th',],
'lladre'=>['ca',],
'llama'=>['es',],
'llamada'=>['es',],
'llamado'=>['es',],
'llamar'=>['es',],
'llamas'=>['es',],
'llamo'=>['es',],
'llarg'=>['ca',],
'llavors'=>['ca',],
'lle'=>['gl',],
'llega'=>['es',],
'llegado'=>['es',],
'llegar'=>['es',],
'llegó'=>['es',],
'llei'=>['ca',],
'lles'=>['gl',],
'llest'=>['ca',],
'lleva'=>['es',],
'llevar'=>['es',],
'llevo'=>['es',],
'llibre'=>['ca',],
'llit'=>['ca',],
'lliure'=>['ca',],
'lloc'=>['ca',],
'lloj'=>['sq',],
'lls'=>['fr',],
'lluita'=>['ca',],
'llum'=>['ca',],
'lluna'=>['ca',],
'lluny'=>['ca',],
'ln'=>['de','it','sl',],
'lngen'=>['nb','no','sv',],
'lni'=>['ms',],
'lnte'=>['sv',],
'lo'=>['ca','es','eu','it','pt','pt_br',],
'loc'=>['ro',],
'loca'=>['es','la',],
'local'=>['gl','pt','pt_br',],
'location'=>['th',],
'loci'=>['la',],
'locis'=>['la',],
'locker'=>['si',],
'loco'=>['es','la',],
'locul'=>['ro',],
'locum'=>['la',],
'locus'=>['la',],
'locutus'=>['la',],
'lod'=>['da',],
'lodhur'=>['sq',],
'lodi'=>['eu',],
'loditu'=>['eu',],
'lofa'=>['is',],
'logam'=>['id',],
'logo'=>['gl','pt','pt_br',],
'loi'=>['fr',],
'loin'=>['fr',],
'loita'=>['gl',],
'loja'=>['pt','pt_br',],
'lojë'=>['sq',],
'lokið'=>['is',],
'loll'=>['et',],
'lolli'=>['th',],
'lollipop'=>['th',],
'londres'=>['ca',],
'long'=>['en','fr',],
'longe'=>['la','pt','pt_br',],
'longer'=>['en',],
'longo'=>['gl',],
'longtemps'=>['fr',],
'lontano'=>['it',],
'lonxe'=>['gl',],
'loodan'=>['et',],
'loodgieter'=>['af',],
'loof'=>['af',],
'look'=>['en','si','th',],
'looked'=>['en',],
'looking'=>['en','th',],
'looks'=>['en',],
'loomulikult'=>['et',],
'loop'=>['af','nl',],
'loopt'=>['nl',],
'lopen'=>['nl',],
'lopeta'=>['fi',],
'lopettaa'=>['fi',],
'lopettakaa'=>['fi',],
'loppu'=>['fi',],
'loppuun'=>['fi',],
'lor'=>['ro',],
'lord'=>['en',],
'lordy'=>['af',],
'loro'=>['it',],
'lort'=>['da',],
'lortu'=>['eu',],
'lortuko'=>['eu',],
'los'=>['ca','de','es','nl','pt','pt_br',],
'lose'=>['en',],
'lost'=>['en','si',],
'lot'=>['en','nb','no',],
'lotus'=>['af',],
'lotussen'=>['af',],
'louco'=>['pt','pt_br',],
'lov'=>['da','nb','no',],
'lovar'=>['sv',],
'love'=>['af','en','ms','si','th',],
'loved'=>['en',],
'lovely'=>['en',],
'lover'=>['da','nb','no',],
'loves'=>['en',],
'lovin'=>['af',],
'lovit'=>['ro',],
'loď'=>['cs','sk',],
'loše'=>['bs','hr',],
'loљ'=>['sr',],
'loљe'=>['bs','sr',],
'lpy'=>['si',],
'lr'=>['lt',],
'ls'=>['en',],
'lshte'=>['sq',],
'lst'=>['de',],
'lt'=>['ms','si','th',],
'lts'=>['si',],
'ltt'=>['hu',],
'ltu'=>['ms',],
'lu'=>['fr',],
'lua'=>['ro',],
'luaj'=>['sq',],
'luar'=>['id','ms',],
'luas'=>['id',],
'luat'=>['ro',],
'luaţi'=>['ro',],
'lub'=>['pl',],
'luba'=>['et',],
'luban'=>['et',],
'lubang'=>['id','ms',],
'lubi'=>['pl',],
'lubisz'=>['pl',],
'lubię'=>['pl',],
'lucas'=>['ca',],
'luce'=>['it',],
'lucht'=>['nl',],
'luck'=>['en',],
'lucky'=>['en','si',],
'luckymule'=>['zh',],
'lucrez'=>['ro',],
'lucru'=>['ro',],
'lucruri'=>['ro',],
'lucrurile'=>['ro',],
'lucu'=>['ms',],
'lud'=>['bs','hr','sr',],
'ludzi'=>['pl',],
'ludzie'=>['pl',],
'luego'=>['es',],
'luft'=>['de',],
'luften'=>['da',],
'luftë'=>['sq',],
'lug'=>['af',],
'lugar'=>['es','gl','pt','pt_br',],
'lugares'=>['gl',],
'lugn'=>['sv',],
'lugna'=>['sv',],
'lugnt'=>['sv',],
'lugo'=>['gl',],
'lugu'=>['et',],
'lui'=>['fr','it','ro',],
'luis'=>['gl',],
'luister'=>['af','nl',],
'luisteren'=>['nl',],
'luk'=>['da',],
'lukeela'=>['eu',],
'lukk'=>['nb','no',],
'lukket'=>['da',],
'lukt'=>['nl',],
'lul'=>['nl',],
'lula'=>['th',],
'lume'=>['gl','ro',],
'lumea'=>['ro',],
'lumina'=>['ro',],
'lumière'=>['fr',],
'lumtur'=>['sq',],
'luna'=>['es','ro',],
'lunch'=>['en',],
'lune'=>['fr',],
'lungo'=>['it',],
'luni'=>['ro',],
'luo'=>['fi',],
'luoja'=>['fi',],
'luona'=>['fi',],
'luota'=>['fi',],
'luottaa'=>['fi',],
'lupa'=>['ms',],
'lupaan'=>['fi',],
'lupakan'=>['ms',],
'lupta'=>['ro',],
'luptă'=>['ro',],
'lurer'=>['nb','no',],
'lurra'=>['eu',],
'lurrak'=>['eu',],
'lurte'=>['nb',],
'lustfully'=>['af',],
'lustig'=>['de',],
'luta'=>['pt','pt_br',],
'lutar'=>['pt','pt_br',],
'lutem'=>['sq',],
'luulen'=>['fi',],
'luulet'=>['fi',],
'luuletko'=>['fi',],
'luulin'=>['fi',],
'luultavasti'=>['fi',],
'luv'=>['af',],
'luva'=>['af',],
'luz'=>['es','gl','pt','pt_br',],
'luzatzen'=>['eu',],
'luze'=>['eu',],
'luzea'=>['eu',],
'luzeago'=>['eu',],
'luzerako'=>['eu',],
'luís'=>['gl',],
'luăm'=>['ro',],
'lycka'=>['sv',],
'lycklig'=>['sv',],
'lyder'=>['da',],
'lyding'=>['af',],
'lyg'=>['lt',],
'lying'=>['en',],
'lyk'=>['af',],
'lykke'=>['da','nb','no',],
'lykkelig'=>['nb','no',],
'lys'=>['da','nb','no',],
'lyset'=>['da','nb','no',],
'lyssna'=>['sv',],
'lyssnar'=>['sv',],
'lyst'=>['da','nb','no',],
'lyver'=>['da','nb','no',],
'là'=>['fr','it',],
'lá'=>['pt','pt_br',],
'lány'=>['hu',],
'lányok'=>['hu',],
'lányt'=>['hu',],
'láska'=>['cs','sk',],
'lássuk'=>['hu',],
'láta'=>['is',],
'látið'=>['is',],
'látja'=>['hu',],
'látni'=>['hu',],
'látod'=>['hu',],
'látok'=>['hu',],
'látom'=>['hu',],
'látszik'=>['hu',],
'látta'=>['hu',],
'láttad'=>['hu',],
'láttam'=>['hu',],
'láttu'=>['is',],
'látum'=>['is',],
'lângă'=>['ro',],
'läbi'=>['et',],
'läget'=>['sv',],
'lägg'=>['sv',],
'lägga'=>['sv',],
'lägger'=>['sv',],
'lähde'=>['fi',],
'lähden'=>['fi',],
'lähdetään'=>['fi',],
'lähe'=>['et',],
'läheb'=>['et',],
'lähed'=>['et',],
'lähedal'=>['et',],
'lähellä'=>['fi',],
'läheme'=>['et',],
'lähen'=>['et',],
'lähevad'=>['et',],
'lähme'=>['et',],
'lähtee'=>['fi',],
'lähteä'=>['fi',],
'lähti'=>['fi',],
'lähtien'=>['fi',],
'läinud'=>['et',],
'läkare'=>['sv',],
'läks'=>['et',],
'läksid'=>['et',],
'läksime'=>['et',],
'lämna'=>['sv',],
'lämnade'=>['sv',],
'lämnar'=>['sv',],
'länge'=>['sv',],
'länger'=>['de',],
'längre'=>['sv',],
'läpi'=>['fi',],
'lär'=>['sv',],
'lära'=>['sv',],
'läsa'=>['sv',],
'lässt'=>['de',],
'lät'=>['sv',],
'lätt'=>['sv',],
'läuft'=>['de',],
'lå'=>['nb','no',],
'låg'=>['sv',],
'lång'=>['sv',],
'långt'=>['sv',],
'låt'=>['sv',],
'låta'=>['sv',],
'låter'=>['sv',],
'læg'=>['da',],
'læge'=>['da',],
'læknir'=>['is',],
'længe'=>['da',],
'længere'=>['da',],
'læra'=>['is',],
'lære'=>['da','nb','no',],
'lærer'=>['da','nb','no',],
'lært'=>['da',],
'læse'=>['da',],
'læt'=>['is',],
'lætur'=>['is',],
'légy'=>['hu',],
'lépe'=>['cs',],
'lét'=>['is',],
'lë'=>['sq',],
'lënë'=>['sq',],
'lër'=>['sq',],
'lëre'=>['sq',],
'lëviz'=>['sq',],
'lëvizni'=>['sq',],
'lì'=>['it',],
'líbí'=>['cs',],
'lícula'=>['ca',],
'líf'=>['is',],
'lífi'=>['is',],
'lífið'=>['is',],
'líka'=>['is',],
'líkar'=>['is',],
'líklega'=>['is',],
'línea'=>['es',],
'línia'=>['ca',],
'líp'=>['cs',],
'líst'=>['is',],
'líta'=>['is',],
'lítið'=>['is',],
'líto'=>['cs',],
'líttu'=>['is',],
'lítur'=>['is',],
'líður'=>['is',],
'lópez'=>['gl',],
'lõbus'=>['et',],
'lõpeta'=>['et',],
'lõpetada'=>['et',],
'lõpetage'=>['et',],
'lõpp'=>['et',],
'lõpuks'=>['et',],
'lögreglan'=>['is',],
'löysin'=>['fi',],
'löytää'=>['fi',],
'løb'=>['da',],
'løbe'=>['da',],
'løber'=>['da',],
'løgn'=>['da',],
'løp'=>['nb','no',],
'løs'=>['nb','no',],
'lütfen'=>['tr',],
'lăsa'=>['ro',],
'lăsat'=>['ro',],
'līdz'=>['lv',],
'līdzi'=>['lv',],
'lš'=>['lt',],
'lūdzu'=>['lv',],
'lūk'=>['lv',],
'm'=>['az','ca','da','de','en','es','fr','hr','is','lt','ms','nb','nl','no','ro','si','sq','sv','th',],
'ma'=>['bs','ca','da','en','et','fr','hr','hu','it','nb','nl','no','pl','ro','sk','sq','sr',],
'maa'=>['et',],
'maaf'=>['ms',],
'maafkan'=>['ms',],
'maahan'=>['fi',],
'maailm'=>['et',],
'maailma'=>['et','fi',],
'maailman'=>['fi',],
'maailmas'=>['et',],
'maak'=>['af','nl',],
'maakt'=>['nl',],
'maakte'=>['nl',],
'maan'=>['af','fi',],
'maand'=>['af','nl',],
'maande'=>['af',],
'maanden'=>['nl',],
'maar'=>['af','nl',],
'maat'=>['nl',],
'maatskappy'=>['af',],
'mabuk'=>['ms',],
'macam'=>['id','ms',],
'macchina'=>['it',],
'mach'=>['de',],
'mache'=>['de',],
'machen'=>['de',],
'machst'=>['de',],
'macht'=>['de','nl',],
'machte'=>['de',],
'macie'=>['pl',],
'mad'=>['da','en',],
'madam'=>['cs','en','sk',],
'madame'=>['fr',],
'made'=>['en',],
'madeira'=>['gl',],
'madh'=>['sq',],
'madhe'=>['sq',],
'madiera'=>['si',],
'madje'=>['sq',],
'madre'=>['es','it',],
'madrid'=>['gl',],
'maestro'=>['es','it',],
'mag'=>['af','de','nl',],
'maga'=>['hu',],
'magad'=>['hu',],
'magam'=>['hu',],
'magama'=>['et',],
'magari'=>['it',],
'magie'=>['af',],
'magis'=>['la',],
'magna'=>['la',],
'magnam'=>['la',],
'magnet'=>['id',],
'magni'=>['la',],
'magnifique'=>['fr',],
'magno'=>['la',],
'magnum'=>['la',],
'magst'=>['de',],
'magtige'=>['af',],
'maguk'=>['hu',],
'magukat'=>['hu',],
'magának'=>['hu',],
'magára'=>['hu',],
'magát'=>['hu',],
'magával'=>['hu',],
'maha'=>['et',],
'mahdollista'=>['fi',],
'mahtava'=>['fi',],
'mahtavaa'=>['fi',],
'mahu'=>['ms',],
'mai'=>['ca','de','hu','it','ro',],
'mailman'=>['af',],
'main'=>['fr','ms',],
'maine'=>['hi',],
'mains'=>['fr',],
'maintenant'=>['fr',],
'maio'=>['gl',],
'maior'=>['gl','la','pt','pt_br',],
'maiore'=>['la',],
'maiores'=>['gl','la',],
'maioría'=>['gl',],
'mais'=>['fr','gl','pt','pt_br',],
'maison'=>['fr',],
'maisto'=>['lt',],
'maitasun'=>['eu',],
'maite'=>['eu',],
'maitea'=>['eu',],
'maiteko'=>['eu',],
'maj'=>['sk',],
'maja'=>['et',],
'majas'=>['et',],
'majd'=>['hu',],
'majdnem'=>['hu',],
'majestät'=>['de',],
'majka'=>['bs','hr','sr',],
'majku'=>['sr',],
'majkëll'=>['sq',],
'major'=>['ca','en',],
'maju'=>['id','ms',],
'mají'=>['cs',],
'majú'=>['sk',],
'mają'=>['pl',],
'maka'=>['id','ms',],
'makan'=>['id','ms',],
'makanan'=>['id','ms',],
'make'=>['en','fa',],
'maken'=>['nl',],
'makes'=>['en',],
'makhluk'=>['id','ms',],
'makilaren'=>['eu',],
'makina'=>['sq',],
'making'=>['en',],
'makinë'=>['sq',],
'makinën'=>['sq',],
'makkelijk'=>['nl',],
'makker'=>['da',],
'maklik'=>['af',],
'makni'=>['hr',],
'maksaa'=>['fi',],
'maksud'=>['id','ms',],
'maksudku'=>['id','ms',],
'maksudmu'=>['ms',],
'mal'=>['ca','de','es','fr','gl','pt','pt_br','sk',],
'mala'=>['bs','ca','es','hr','la','sk','sl','sr',],
'malade'=>['fr',],
'malam'=>['id','ms',],
'malament'=>['ca',],
'malce'=>['sl',],
'maldición'=>['es',],
'maldita'=>['es',],
'maldito'=>['es','pt','pt_br',],
'male'=>['it','la',],
'maleït'=>['ca',],
'mali'=>['bs','hr','la','sk','sl','sr',],
'malia'=>['gl',],
'malis'=>['la',],
'mallkuar'=>['sq',],
'malo'=>['bs','es','hr','la','sk','sl','sr',],
'malonu'=>['lt',],
'malum'=>['la',],
'malá'=>['cs','sk',],
'malé'=>['cs','sk',],
'malý'=>['cs','sk',],
'malā'=>['lv',],
'mam'=>['nl','pl',],
'mama'=>['bs','ca','de','en','hr','hu','lt','ms','nl','pl','ro','si','sk','sl','sq','sr',],
'mamaja'=>['sq',],
'maman'=>['fr',],
'mamei'=>['ro',],
'mami'=>['cs','sk','sl','sq',],
'mamm'=>['lv',],
'mamma'=>['is','it','lv','nb','no','sv',],
'mammu'=>['lv',],
'mamo'=>['pl','sl',],
'mampu'=>['id','ms',],
'mamy'=>['pl',],
'mamá'=>['es',],
'mamã'=>['pt',],
'mamãe'=>['pt_br',],
'mamă'=>['ro',],
'man'=>['af','da','de','en','gl','id','is','lt','lv','ms','nb','nl','no','si','sv','th',],
'mana'=>['id','lv','ms',],
'manai'=>['lt','lv',],
'manam'=>['lv',],
'manas'=>['lv',],
'manau'=>['lt',],
'manca'=>['it',],
'manchmal'=>['de',],
'mand'=>['da','no',],
'mandato'=>['it',],
'manden'=>['da',],
'mandi'=>['ms',],
'mandira'=>['si',],
'mane'=>['lt',],
'maneiatu'=>['eu',],
'maneiatzeko'=>['eu',],
'maneira'=>['gl','pt','pt_br',],
'manera'=>['ca','es',],
'manes'=>['lt',],
'mange'=>['da','fr','nb','no',],
'manger'=>['fr',],
'mangiare'=>['it',],
'mangler'=>['da',],
'manhã'=>['pt','pt_br',],
'mani'=>['it','lv',],
'maniau'=>['lt',],
'manibus'=>['la',],
'maniem'=>['lv',],
'manier'=>['af','nl',],
'manim'=>['lt',],
'manimi'=>['lt',],
'manis'=>['lv','ms',],
'manj'=>['sl',],
'manje'=>['bs','hr','sr',],
'mann'=>['de','is','nb','no',],
'manna'=>['is',],
'manne'=>['af',],
'mannen'=>['nb','nl','no','sv',],
'manni'=>['is',],
'manninn'=>['is',],
'manns'=>['is',],
'mano'=>['es','it','lt','sl',],
'manos'=>['es',],
'manote'=>['lt',],
'manque'=>['fr',],
'mans'=>['af','ca','gl','lv',],
'manstu'=>['is',],
'mantentzen'=>['eu',],
'manter'=>['gl','pt','pt_br',],
'manu'=>['la','lv',],
'manuel'=>['gl',],
'manum'=>['la',],
'manuprāt'=>['lv',],
'manus'=>['la',],
'manusia'=>['id','ms',],
'many'=>['en','th',],
'manā'=>['lv',],
'manęs'=>['lt',],
'manī'=>['lv',],
'manžel'=>['cs',],
'maoriek'=>['eu',],
'mar'=>['ca','es','gl','pt','pt_br','sl',],
'marad'=>['hu',],
'maradj'=>['hu',],
'maradjon'=>['hu',],
'maradt'=>['hu',],
'marae'=>['eu',],
'maraeko'=>['eu',],
'marah'=>['ms',],
'maravilhoso'=>['pt_br',],
'maravilloso'=>['es',],
'marcha'=>['gl',],
'marche'=>['fr',],
'marcher'=>['fr',],
'marché'=>['fr',],
'marco'=>['gl',],
'mare'=>['ca','it','la','ro',],
'mareecha'=>['af',],
'marga'=>['is',],
'margar'=>['is',],
'margir'=>['is',],
'margt'=>['is',],
'mari'=>['fr','id','la','ms','ro',],
'mariage'=>['fr',],
'marido'=>['es','pt','pt_br',],
'maris'=>['la',],
'marit'=>['ca',],
'marito'=>['it',],
'mark'=>['en','is','sv',],
'marr'=>['sq',],
'marriage'=>['en',],
'married'=>['en',],
'marrim'=>['sq',],
'marrin'=>['sq',],
'marry'=>['en',],
'marrë'=>['sq',],
'marrësh'=>['sq',],
'marrëveshje'=>['sq',],
'mars'=>['id',],
'martuar'=>['sq',],
'martw'=>['pl',],
'marxa'=>['ca',],
'marxar'=>['ca',],
'mary'=>['en','tr',],
'marzo'=>['gl',],
'maría'=>['gl',],
'mas'=>['ca','es','pt','pt_br',],
'masa'=>['id','ms','ro',],
'masaila'=>['eu',],
'masalah'=>['id','ms',],
'masalahnya'=>['ms',],
'masih'=>['id','ms',],
'masina'=>['ro',],
'masing'=>['id',],
'massa'=>['ca','id','sv',],
'masse'=>['da','nb','no',],
'masser'=>['da',],
'master'=>['en','ms',],
'masuk'=>['id','ms',],
'masyarakat'=>['id',],
'masz'=>['pl',],
'masă'=>['ro',],
'mat'=>['af','is','nb','no','sv',],
'mata'=>['id','ms',],
'matahari'=>['id','ms',],
'matai'=>['lt',],
'matar'=>['ca','es','pt','pt_br',],
'matau'=>['lt',],
'matei'=>['lt',],
'mateix'=>['ca',],
'mateixa'=>['ca',],
'matematika'=>['id',],
'maten'=>['nb',],
'mater'=>['la',],
'materia'=>['gl',],
'material'=>['gl',],
'mati'=>['id','ms','sl',],
'matin'=>['fr',],
'matka'=>['cs','pl','sk',],
'matkalla'=>['fi',],
'matki'=>['pl',],
'matote'=>['lt',],
'matou'=>['pt','pt_br',],
'matrimonio'=>['it',],
'matter'=>['en','th',],
'mattina'=>['it',],
'matyti'=>['lt',],
'matí'=>['ca',],
'mató'=>['es',],
'mau'=>['ms','pt','pt_br',],
'mauvais'=>['fr',],
'mauvaise'=>['fr',],
'max'=>['da','et','ms','sv',],
'maxima'=>['la',],
'maxime'=>['la',],
'may'=>['az','en','si',],
'maya'=>['id',],
'maybe'=>['en','th',],
'mayor'=>['es',],
'maz'=>['lv',],
'maza'=>['lv',],
'mazais'=>['lv',],
'mazliet'=>['lv',],
'mazo'=>['lv',],
'mazs'=>['lv',],
'mazā'=>['lv',],
'mazāk'=>['lv',],
'maître'=>['fr',],
'maður'=>['is',],
'maðurinn'=>['is',],
'mañana'=>['es',],
'mañá'=>['gl',],
'mačiau'=>['lt',],
'mała'=>['pl',],
'małe'=>['pl',],
'mało'=>['pl',],
'mały'=>['pl',],
'maşina'=>['ro',],
'maşină'=>['ro',],
'mašina'=>['lt',],
'mašinos'=>['lt',],
'mašiną'=>['lt',],
'mašīna'=>['lv',],
'mašīnas'=>['lv',],
'mašīnu'=>['lv',],
'mašīnā'=>['lv',],
'mať'=>['sk',],
'maža'=>['lt',],
'mažas'=>['lt',],
'mažiau'=>['lt',],
'mba'=>['si',],
'mbaj'=>['sq',],
'mbaje'=>['sq',],
'mbajtur'=>['sq',],
'mban'=>['sq',],
'mbani'=>['sq',],
'mbaroi'=>['sq',],
'mbaruar'=>['sq',],
'mbase'=>['sq',],
'mbash'=>['sq',],
'mbetur'=>['sq',],
'mbi'=>['sq',],
'mbrapa'=>['sq',],
'mbreti'=>['sq',],
'mbrëmë'=>['sq',],
'mbylle'=>['sq',],
'mbyllur'=>['sq',],
'mccallum'=>['ca',],
'me'=>['bs','ca','cs','en','es','et','fa','fi','fr','gl','hr','it','la','lt','ms','nl','pl','pt','pt_br','si','sl','sq','sr','th','zh_tw',],
'mea'=>['la','ro',],
'meae'=>['la',],
'meam'=>['la',],
'mean'=>['en','th',],
'means'=>['en',],
'meant'=>['en',],
'meargă'=>['ro',],
'mec'=>['fr',],
'mecum'=>['la',],
'med'=>['da','nb','no','sl','sv',],
'medan'=>['sv',],
'meddelande'=>['sv',],
'media'=>['es','gl','id','la',],
'mediante'=>['gl',],
'medida'=>['gl',],
'medidas'=>['gl',],
'medio'=>['es','gl','la',],
'medios'=>['gl',],
'medo'=>['gl','pt','pt_br',],
'medtem'=>['sl',],
'medzi'=>['sk',],
'mee'=>['nl',],
'meel'=>['et',],
'meelde'=>['et',],
'meeldi'=>['et',],
'meeldib'=>['et',],
'meeldiv'=>['et',],
'meeldivad'=>['et',],
'meeles'=>['et',],
'meem'=>['ur',],
'meen'=>['nl',],
'meer'=>['af','nl',],
'mees'=>['et','lv',],
'meest'=>['et','nl',],
'meeste'=>['nl',],
'meester'=>['af','nl',],
'meet'=>['en','th',],
'meeting'=>['en',],
'meg'=>['hu','nb','no',],
'meget'=>['da','nb','no',],
'meghalt'=>['hu',],
'megin'=>['is',],
'megint'=>['hu',],
'meglio'=>['it',],
'megvan'=>['hu',],
'megy'=>['hu',],
'megyek'=>['hu',],
'megyünk'=>['hu',],
'mehats'=>['eu',],
'mehe'=>['et',],
'mehed'=>['et',],
'mehnaz'=>['si',],
'mehr'=>['de',],
'mei'=>['la','ro',],
'meid'=>['et','nl',],
'meiden'=>['nl',],
'meidän'=>['fi',],
'meidät'=>['fi',],
'meie'=>['et',],
'meiega'=>['et',],
'meil'=>['et',],
'meile'=>['et',],
'meille'=>['fi',],
'meilleur'=>['fr',],
'meilleure'=>['fr',],
'meillä'=>['fi',],
'meilė'=>['lt',],
'meilės'=>['lt',],
'mein'=>['de',],
'meina'=>['is',],
'meinarðu'=>['is',],
'meine'=>['de',],
'meinem'=>['de',],
'meinen'=>['de',],
'meiner'=>['de',],
'meines'=>['de',],
'meinst'=>['de',],
'meinung'=>['de',],
'meio'=>['pt','pt_br',],
'meira'=>['is',],
'meiri'=>['is',],
'meis'=>['la',],
'meisje'=>['nl',],
'meisjes'=>['nl',],
'meist'=>['et',],
'meisten'=>['de',],
'meister'=>['de',],
'meistä'=>['fi',],
'meita'=>['lv',],
'meitene'=>['lv',],
'meitenes'=>['lv',],
'meiteni'=>['lv',],
'meitä'=>['fi',],
'mej'=>['sv',],
'meja'=>['ms',],
'meje'=>['sq',],
'mejor'=>['es',],
'mejores'=>['es',],
'mekanika'=>['id',],
'mekanisme'=>['id',],
'meklē'=>['lv',],
'meklēju'=>['lv',],
'melakukan'=>['id','ms',],
'melakukannya'=>['id','ms',],
'melalui'=>['id','ms',],
'melarikan'=>['ms',],
'melawan'=>['ms',],
'mele'=>['ro',],
'meledak'=>['id',],
'meleg'=>['hu',],
'meletakkan'=>['ms',],
'melewati'=>['ms',],
'melhor'=>['pt','pt_br',],
'melhores'=>['pt','pt_br',],
'melihat'=>['id','ms',],
'melihatmu'=>['ms',],
'melihatnya'=>['id','ms',],
'melindungi'=>['ms',],
'melius'=>['la',],
'melk'=>['af',],
'melkein'=>['fi',],
'mellan'=>['sv',],
'melle'=>['la',],
'mellem'=>['da',],
'mellett'=>['hu',],
'mellom'=>['nb','no',],
'mellor'=>['gl',],
'mellores'=>['gl',],
'melyik'=>['hu',],
'memahami'=>['id','ms',],
'memakai'=>['ms',],
'memang'=>['id','ms',],
'memanggil'=>['ms',],
'membaca'=>['id','ms',],
'membangun'=>['id','ms',],
'membantu'=>['id','ms',],
'membawa'=>['id','ms',],
'membawanya'=>['ms',],
'membayangkan'=>['id',],
'membayar'=>['id','ms',],
'membeli'=>['ms',],
'membentuk'=>['id',],
'memberi'=>['id','ms',],
'memberikan'=>['id','ms',],
'memberitahu'=>['id','ms',],
'membiarkan'=>['ms',],
'membros'=>['gl',],
'membuat'=>['id','ms',],
'membuatku'=>['ms',],
'membuatmu'=>['ms',],
'membuatnya'=>['id','ms',],
'membuka'=>['id','ms',],
'membunuh'=>['ms',],
'membunuhmu'=>['ms',],
'membunuhnya'=>['ms',],
'membutuhkan'=>['id','ms',],
'memecahkan'=>['id',],
'memegang'=>['id',],
'memeriksa'=>['id','ms',],
'memerlukan'=>['ms',],
'memikirkan'=>['ms',],
'memilih'=>['id','ms',],
'memiliki'=>['id','ms',],
'meminta'=>['ms',],
'memnun'=>['tr',],
'memoria'=>['gl','la',],
'memoriam'=>['la',],
'memotong'=>['ms',],
'mempertahankan'=>['id',],
'mempertimbangkan'=>['id',],
'mempunyai'=>['ms',],
'memukul'=>['ms',],
'memulai'=>['id','ms',],
'memungkinkan'=>['id',],
'memutuskan'=>['id','ms',],
'men'=>['da','en','nb','nl','no','sv',],
'mena'=>['ca',],
'menade'=>['sv',],
'menakjubkan'=>['id',],
'menang'=>['ms',],
'menangis'=>['ms',],
'menangkap'=>['ms',],
'menar'=>['sv',],
'menarik'=>['id','ms',],
'mencapai'=>['id','ms',],
'mencari'=>['id','ms',],
'mencintai'=>['ms',],
'mencintaimu'=>['ms',],
'menciptakan'=>['id',],
'mencoba'=>['id','ms',],
'mencuri'=>['ms',],
'mend'=>['sq',],
'mendalam'=>['id',],
'mendapat'=>['id','ms',],
'mendapatkan'=>['id','ms',],
'mendapatkannya'=>['ms',],
'mendengar'=>['id','ms',],
'mendengarkan'=>['id','ms',],
'mendja'=>['sq',],
'mendjen'=>['sq',],
'mendo'=>['sq',],
'mendoj'=>['sq',],
'mendoja'=>['sq',],
'mendon'=>['sq',],
'mendoni'=>['sq',],
'mendorong'=>['id',],
'mendova'=>['sq',],
'menduar'=>['sq',],
'mendukung'=>['id',],
'mene'=>['bs','fi','hr','sl','sr',],
'menee'=>['fi',],
'meneer'=>['nl',],
'menej'=>['sk',],
'menelepon'=>['ms',],
'menembak'=>['ms',],
'menemme'=>['fi',],
'menempatkan'=>['id','ms',],
'menemukan'=>['id','ms',],
'menemukannya'=>['ms',],
'menen'=>['fi',],
'mener'=>['da','nb','no',],
'menerima'=>['id','ms',],
'menerus'=>['id',],
'menet'=>['fi',],
'meng'=>['af',],
'mengakui'=>['id',],
'mengalahkan'=>['ms',],
'mengalami'=>['ms',],
'mengambil'=>['id','ms',],
'mengapa'=>['id','ms',],
'mengatakan'=>['id','ms',],
'mengatur'=>['id',],
'menge'=>['de',],
'mengejutkan'=>['id',],
'mengembangkan'=>['id',],
'mengenai'=>['ms',],
'mengerikan'=>['ms',],
'mengerti'=>['id','ms',],
'mengetahui'=>['id','ms',],
'menggambarkan'=>['id',],
'mengganggu'=>['id','ms',],
'menggunakan'=>['id','ms',],
'menghabiskan'=>['id','ms',],
'menghancurkan'=>['id','ms',],
'menghasilkan'=>['id',],
'menghentikan'=>['ms',],
'menghilang'=>['ms',],
'mengikuti'=>['ms',],
'mengirim'=>['id','ms',],
'mengorbit'=>['id',],
'mengubah'=>['id','ms',],
'mengumpulkan'=>['id',],
'mengungkapkan'=>['id',],
'mengunjungi'=>['id',],
'meni'=>['bs','fi','hr','sl','sr',],
'menikah'=>['ms',],
'menina'=>['pt','pt_br',],
'mening'=>['da',],
'meninggal'=>['ms',],
'meninggalkan'=>['id','ms',],
'meningkat'=>['id',],
'meningkatkan'=>['id',],
'menino'=>['pt','pt_br',],
'menit'=>['id','ms',],
'menj'=>['hu',],
'menjadi'=>['id','ms',],
'menjaga'=>['id','ms',],
'menjalankan'=>['id',],
'menjar'=>['ca',],
'menjawab'=>['id',],
'menjelaskan'=>['id','ms',],
'menjen'=>['hu',],
'menjetek'=>['hu',],
'menjual'=>['ms',],
'menjëherë'=>['sq',],
'menjünk'=>['hu',],
'menkää'=>['fi',],
'menn'=>['is','nb','no',],
'mennem'=>['hu',],
'mennene'=>['nb','no',],
'menneske'=>['da','nb','no',],
'mennesker'=>['da','nb','no',],
'menni'=>['hu',],
'mennyi'=>['hu',],
'mennyire'=>['hu',],
'mennyt'=>['fi',],
'mennä'=>['fi',],
'mennään'=>['fi',],
'mennünk'=>['hu',],
'meno'=>['it','sk',],
'menoj'=>['sl',],
'menonton'=>['ms',],
'menor'=>['gl',],
'menos'=>['es','gl','pt','pt_br',],
'menossa'=>['fi',],
'mens'=>['af','da','nb','nl','no',],
'mensagem'=>['pt','pt_br',],
'mensaje'=>['es',],
'mensch'=>['de',],
'menschen'=>['de',],
'mense'=>['af',],
'mensen'=>['nl',],
'ment'=>['ca','hu',],
'mente'=>['da','es','it','nb','no','pt','pt_br',],
'mentem'=>['la',],
'mentre'=>['ca','it',],
'mentres'=>['gl',],
'menuju'=>['id','ms',],
'menulis'=>['id','ms',],
'menunggu'=>['id','ms',],
'menunjukkan'=>['id','ms',],
'menurut'=>['id','ms',],
'menurutmu'=>['ms',],
'menutup'=>['ms',],
'menyadari'=>['id','ms',],
'menyarankan'=>['id',],
'menyatakan'=>['id',],
'menyebabkan'=>['id',],
'menyelamatkan'=>['ms',],
'menyelesaikan'=>['id','ms',],
'menyenangkan'=>['ms',],
'menyerah'=>['ms',],
'menyerang'=>['id','ms',],
'menyesal'=>['ms',],
'menys'=>['ca',],
'menyukai'=>['ms',],
'menyukainya'=>['ms',],
'meo'=>['is','la',],
'meqë'=>['sq',],
'mer'=>['fr','nb','no','sv',],
'merah'=>['id','ms',],
'merak'=>['tr',],
'merasa'=>['id','ms',],
'merasakan'=>['ms',],
'mercado'=>['gl',],
'merci'=>['fr',],
'merda'=>['ca','it','pt','pt_br',],
'merde'=>['fr',],
'mere'=>['da','no',],
'mereka'=>['id','ms',],
'mereu'=>['ro',],
'merg'=>['ro',],
'mergaitė'=>['lt',],
'merge'=>['ro',],
'mergem'=>['ro',],
'mergi'=>['ro',],
'mergina'=>['lt',],
'merginos'=>['lt',],
'merhaba'=>['tr',],
'merkelig'=>['nb',],
'merr'=>['sq',],
'merre'=>['hu','sq',],
'merrni'=>['sq',],
'mers'=>['ro',],
'mersi'=>['ro',],
'mert'=>['hu',],
'merupakan'=>['id','ms',],
'merveilleux'=>['fr',],
'merwe'=>['th',],
'mes'=>['ca','es','fr','gl','lt','sq',],
'mesa'=>['es','gl','pt','pt_br',],
'mesaj'=>['az','ro','tr',],
'mesaja'=>['az',],
'mesajın'=>['az',],
'mese'=>['it',],
'mesec'=>['sr',],
'meseca'=>['sr',],
'meseci'=>['sr',],
'mesedez'=>['eu',],
'meses'=>['es','gl','pt','pt_br',],
'mesi'=>['it',],
'mesiac'=>['sk',],
'mesiacov'=>['sk',],
'mesin'=>['id','ms',],
'mesir'=>['id',],
'mesk'=>['lt',],
'meskipun'=>['id','ms',],
'mesma'=>['gl','pt','pt_br',],
'mesmo'=>['gl','pt','pt_br',],
'mesmos'=>['gl',],
'mesos'=>['ca',],
'mess'=>['en',],
'message'=>['en','fr',],
'messaggio'=>['it',],
'messieurs'=>['fr',],
'messo'=>['it',],
'messze'=>['hu',],
'mest'=>['da','nb','no','sv',],
'mesta'=>['sk','sl','sr',],
'mestari'=>['fi',],
'meste'=>['sk',],
'mester'=>['da',],
'mesto'=>['sk','sl','sr',],
'mestre'=>['pt','pt_br',],
'mestu'=>['sl','sr',],
'met'=>['af','en','fr','nl',],
'metade'=>['gl','pt','pt_br',],
'metai'=>['lt',],
'metais'=>['lt',],
'metana'=>['id',],
'metas'=>['lt',],
'meteen'=>['nl',],
'meter'=>['da','id','nb','nl','no','sv',],
'metge'=>['ca',],
'metode'=>['id',],
'metros'=>['gl',],
'mets'=>['fr',],
'mettere'=>['it',],
'metti'=>['it',],
'mettre'=>['fr',],
'metu'=>['la','lt',],
'metus'=>['lt',],
'metų'=>['lt',],
'meu'=>['ca','gl','pt','pt_br','ro',],
'meua'=>['ca',],
'meum'=>['la',],
'meurtre'=>['fr',],
'meus'=>['ca','gl','la','pt','pt_br',],
'meva'=>['ca',],
'meves'=>['ca',],
'mevrouw'=>['nl',],
'mezelf'=>['nl',],
'mezi'=>['cs',],
'mezzo'=>['it',],
'með'=>['is',],
'meðan'=>['is',],
'mi'=>['bs','ca','cs','es','hr','hu','it','la','nb','no','pl','ro','sk','sl','sq','sr','tr',],
'mia'=>['it','sq',],
'miasta'=>['pl',],
'miasto'=>['pl',],
'miatt'=>['hu',],
'miał'=>['pl',],
'miała'=>['pl',],
'miałam'=>['pl',],
'miałem'=>['pl',],
'miałeś'=>['pl',],
'mic'=>['ro',],
'mica'=>['ca',],
'mich'=>['de',],
'michael'=>['bs','da','de','en','es','et','fi','fr','hr','hu','is','it','ms','nb','nl','no','pl','pt','pt_br','ro','sk','sl','sv','tr',],
'mici'=>['ro',],
'micsoda'=>['hu',],
'mică'=>['ro',],
'mida'=>['et',],
'midagi'=>['et',],
'middag'=>['af','da','nb','no','sv',],
'middagete'=>['af',],
'middel'=>['af',],
'middle'=>['en',],
'midi'=>['fr',],
'midt'=>['nb','no',],
'midva'=>['sl',],
'mie'=>['it','ro',],
'miedo'=>['es',],
'miegoti'=>['lt',],
'miehen'=>['fi',],
'miehet'=>['fi',],
'miehiä'=>['fi',],
'miei'=>['it',],
'miejsca'=>['pl',],
'miejsce'=>['pl',],
'miejscu'=>['pl',],
'miela'=>['lt',],
'mielas'=>['lt',],
'mielasis'=>['lt',],
'mielestäni'=>['fi',],
'mieli'=>['pl',],
'mieliśmy'=>['pl',],
'mieloji'=>['lt',],
'mieltä'=>['fi',],
'mielőtt'=>['hu',],
'mientras'=>['es',],
'mierda'=>['es',],
'mieru'=>['lv',],
'mierā'=>['lv',],
'mierīgi'=>['lv',],
'mies'=>['fi',],
'miesięcy'=>['pl',],
'miesta'=>['sk',],
'miestas'=>['lt',],
'mieste'=>['lt','sk',],
'miesto'=>['lt','sk',],
'miestä'=>['fi',],
'miestą'=>['lt',],
'mieszka'=>['pl',],
'mieux'=>['fr',],
'mieć'=>['pl',],
'mieście'=>['pl',],
'miféle'=>['hu',],
'mig'=>['ca','da','is','no','sv',],
'might'=>['en',],
'migliore'=>['it',],
'miguel'=>['gl',],
'mihi'=>['la',],
'mihia'=>['eu',],
'mihin'=>['fi',],
'mii'=>['ro',],
'mij'=>['nl',],
'mijn'=>['nl',],
'mijë'=>['sq',],
'mik'=>['sq',],
'mike'=>['da','en','et','fi','hr','hu','is','nb','nl','no','pl','pt','ro','sl','sv','tr',],
'mikil'=>['is',],
'mikill'=>['is',],
'mikið'=>['is',],
'mikla'=>['is',],
'miklu'=>['is',],
'mikor'=>['hu',],
'mikroba'=>['id',],
'miks'=>['et',],
'miksei'=>['fi',],
'mikset'=>['fi',],
'miksi'=>['fi',],
'miku'=>['sq',],
'mikä'=>['fi',],
'mikään'=>['fi',],
'mil'=>['ca','es','gl','id','ms','pt','pt_br',],
'mile'=>['af',],
'miles'=>['en','th',],
'milhões'=>['pt','pt_br',],
'milia'=>['la',],
'miliar'=>['id',],
'miliaran'=>['id',],
'milijuna'=>['hr',],
'milik'=>['ms',],
'miliki'=>['id','ms',],
'milioane'=>['ro',],
'milion'=>['sq',],
'miliona'=>['bs','sr',],
'milioni'=>['it',],
'milions'=>['ca',],
'militer'=>['id',],
'milites'=>['la',],
'militum'=>['la',],
'miljoen'=>['nl',],
'miljoner'=>['sv',],
'miljonit'=>['et',],
'miljoonaa'=>['fi',],
'millal'=>['et',],
'mille'=>['et','it','la',],
'millega'=>['et',],
'milleks'=>['et',],
'milles'=>['ca','et',],
'millest'=>['et',],
'millet'=>['tr',],
'milli'=>['is',],
'milline'=>['et',],
'million'=>['en',],
'millionen'=>['de',],
'millioner'=>['da','nb','no',],
'millions'=>['fr',],
'millió'=>['hu',],
'milljónir'=>['is',],
'milloin'=>['fi',],
'millones'=>['es',],
'millor'=>['ca',],
'millóns'=>['gl',],
'miltä'=>['fi',],
'milujem'=>['sk',],
'miluji'=>['cs',],
'miluju'=>['cs',],
'milyar'=>['id',],
'milyen'=>['hu',],
'milyon'=>['tr',],
'miláčik'=>['sk',],
'miláčku'=>['cs',],
'milé'=>['sk',],
'mim'=>['pt','pt_br',],
'mimo'=>['cs','sk','sl',],
'mimpi'=>['ms',],
'min'=>['af','da','gl','nb','no','sv',],
'mina'=>['et','eu','sv',],
'mind'=>['en','et','hu','th',],
'mindannyian'=>['hu',],
'mindegy'=>['hu',],
'minden'=>['hu',],
'mindenki'=>['hu',],
'mindenkinek'=>['hu',],
'mindenkit'=>['hu',],
'mindent'=>['hu',],
'minder'=>['nl',],
'mindig'=>['hu',],
'mindjárt'=>['hu',],
'mindketten'=>['hu',],
'mindre'=>['da','nb','no','sv',],
'mindste'=>['da',],
'mine'=>['da','en','et','nb','no','ro','th',],
'minek'=>['hu',],
'minema'=>['et',],
'minge'=>['et',],
'mingeid'=>['et',],
'minggu'=>['id','ms',],
'mingi'=>['et',],
'mingit'=>['et',],
'minha'=>['pt','pt_br',],
'minhas'=>['pt','pt_br',],
'minime'=>['la',],
'minimum'=>['th',],
'ministerio'=>['gl',],
'ministro'=>['gl',],
'minket'=>['hu',],
'minkä'=>['fi',],
'minn'=>['is',],
'minna'=>['et','is',],
'minne'=>['fi',],
'minni'=>['is',],
'minns'=>['sv',],
'minste'=>['nb',],
'mint'=>['hu',],
'minta'=>['ms',],
'minte'=>['ro',],
'mintha'=>['hu',],
'mintis'=>['lt',],
'minu'=>['et',],
'minua'=>['fi',],
'minuga'=>['et',],
'minul'=>['et',],
'minulla'=>['fi',],
'minulle'=>['fi',],
'minulta'=>['fi',],
'minum'=>['ms',],
'minun'=>['fi',],
'minunat'=>['ro',],
'minus'=>['la',],
'minust'=>['et',],
'minusta'=>['fi',],
'minut'=>['ca','cs','fi','pl','ro','sl','sr',],
'minuta'=>['bs','hr','sq','sr',],
'minute'=>['en','fr','ro',],
'minuten'=>['de','nl',],
'minuter'=>['sv',],
'minutes'=>['en','fr','lt',],
'minuti'=>['et','it',],
'minutit'=>['et',],
'minuto'=>['es','it','pt','pt_br',],
'minutos'=>['es','gl','pt','pt_br',],
'minuts'=>['ca',],
'minutter'=>['da','nb','no',],
'minutuz'=>['eu',],
'minutë'=>['sq',],
'minutėlę'=>['lt',],
'minuun'=>['fi',],
'minuutin'=>['fi',],
'minuuttia'=>['fi',],
'minučių'=>['lt',],
'minä'=>['fi',],
'minähän'=>['fi',],
'minäkin'=>['fi',],
'minút'=>['sk',],
'minūtes'=>['lv',],
'minūtēm'=>['lv',],
'mio'=>['it',],
'mir'=>['de','sq',],
'mira'=>['ca','es','gl','sq',],
'mirar'=>['ca',],
'mire'=>['es','hu','sq',],
'miren'=>['es',],
'mireu'=>['ca',],
'miri'=>['ca',],
'mirip'=>['id',],
'miris'=>['lv',],
'mirklīti'=>['lv',],
'mirt'=>['lv',],
'mirti'=>['lt',],
'mirties'=>['lt',],
'mirtis'=>['lt',],
'miru'=>['bs','hr','sl','sr',],
'mirupafshim'=>['sq',],
'mirusi'=>['lv',],
'mirë'=>['sq',],
'mirė'=>['lt',],
'miręs'=>['lt',],
'miről'=>['hu',],
'mis'=>['af','es','et','fr','nl',],
'misalnya'=>['id',],
'misi'=>['id','ms',],
'misin'=>['tr',],
'misiniz'=>['tr',],
'misis'=>['lv',],
'misit'=>['la',],
'miski'=>['et',],
'miskien'=>['af',],
'misle'=>['bs','hr','sr',],
'misleæi'=>['hi',],
'misli'=>['bs','hr','sl','sr',],
'mislil'=>['sl',],
'mislila'=>['bs','hr','sl','sr',],
'mislim'=>['bs','hr','sl','sr',],
'mislio'=>['bs','hr','sr',],
'mislite'=>['bs','hr','sl','sr',],
'misliš'=>['bs','hr','sl',],
'misliљ'=>['bs','hr','sr',],
'misma'=>['es',],
'mismo'=>['es',],
'miss'=>['da','de','en','et','hu','ms','nb','nl','no','sv',],
'missa'=>['is',],
'missatge'=>['ca',],
'misschien'=>['nl',],
'missed'=>['en',],
'missen'=>['nl',],
'missing'=>['en',],
'mission'=>['fr',],
'missió'=>['ca',],
'misstag'=>['sv',],
'missti'=>['is',],
'missão'=>['pt','pt_br',],
'missä'=>['fi',],
'mist'=>['de',],
'mistake'=>['en',],
'miste'=>['nb','no',],
'mister'=>['lv','nb','no',],
'misteri'=>['id','lt',],
'misterio'=>['eu',],
'misterius'=>['id',],
'mistet'=>['da','nb','no',],
'mistä'=>['fi',],
'mistök'=>['is',],
'mit'=>['da','de','hu','no',],
'mitad'=>['es',],
'miten'=>['fi',],
'mitt'=>['is','nb','no','sv',],
'mitte'=>['et',],
'mitu'=>['et',],
'mitä'=>['fi',],
'mitäs'=>['fi',],
'mitään'=>['fi',],
'miután'=>['hu',],
'mivel'=>['hu',],
'miydi'=>['tr',],
'miyim'=>['tr',],
'miyiz'=>['tr',],
'miért'=>['hu',],
'miður'=>['is',],
'miña'=>['gl',],
'miñas'=>['gl',],
'mióta'=>['hu',],
'miúda'=>['pt',],
'miúdo'=>['pt',],
'między'=>['pl',],
'miło'=>['pl',],
'miłości'=>['pl',],
'miłość'=>['pl',],
'mišiæ'=>['hi',],
'mjaft'=>['sq',],
'mjesec'=>['bs','hr',],
'mjeseca'=>['bs','hr',],
'mjeseci'=>['bs','hr',],
'mjesta'=>['bs','hr',],
'mjesto'=>['bs','hr',],
'mjestu'=>['bs','hr',],
'mjög'=>['is',],
'mladý'=>['sk',],
'mlle'=>['fr',],
'mluvil'=>['cs',],
'mluvit'=>['cs',],
'mluví'=>['cs',],
'mluvím'=>['cs',],
'mluvíš'=>['cs',],
'mm'=>['en',],
'mme'=>['fr',],
'mmm'=>['af',],
'mmmm'=>['af',],
'mne'=>['cs','sk',],
'mnie'=>['pl',],
'mniej'=>['pl',],
'mnogo'=>['bs','hr','sr',],
'mnohem'=>['cs',],
'mnoho'=>['cs','sk',],
'mnom'=>['bs','hr','sr',],
'mnou'=>['cs','sk',],
'mnu'=>['th',],
'mną'=>['pl',],
'mně'=>['cs',],
'mo'=>['th',],
'moanin'=>['af',],
'moarte'=>['ro',],
'moartea'=>['ro',],
'mobil'=>['id','ms',],
'mobile'=>['si',],
'moc'=>['cs','sk',],
'mocht'=>['nl',],
'mod'=>['da','ro',],
'modelo'=>['gl',],
'modern'=>['id',],
'modi'=>['la',],
'modo'=>['es','gl','it','la','pt','pt_br',],
'modum'=>['la',],
'moe'=>['nl',],
'moeder'=>['nl',],
'moeg'=>['af',],
'moeilijk'=>['nl',],
'moeilik'=>['af',],
'moes'=>['af',],
'moest'=>['nl',],
'moesten'=>['nl',],
'moet'=>['af','nl',],
'moeten'=>['nl',],
'mog'=>['bs','hr','sr',],
'mogambo'=>['af',],
'mogao'=>['bs','hr','sr',],
'mogel'=>['sl',],
'mogelijk'=>['nl',],
'mogen'=>['nl',],
'moghuls'=>['af',],
'mogla'=>['bs','hr','sl','sr',],
'mogli'=>['bs','hr','pl','sr',],
'moglie'=>['it',],
'moglo'=>['bs','hr','sr',],
'mogoče'=>['sl',],
'mogu'=>['bs','hr','sr',],
'moguće'=>['hr',],
'moguжe'=>['sr',],
'mogą'=>['pl',],
'mogę'=>['pl',],
'mogła'=>['pl',],
'mogłem'=>['pl',],
'mohl'=>['cs',],
'mohla'=>['cs','sk',],
'mohli'=>['cs','sk',],
'mohlo'=>['cs','sk',],
'mohol'=>['sk',],
'mohu'=>['cs',],
'moi'=>['fr','gl','pl',],
'moich'=>['pl',],
'moim'=>['pl',],
'moins'=>['fr',],
'mois'=>['fr',],
'moita'=>['gl',],
'moitas'=>['gl',],
'moitié'=>['fr',],
'moito'=>['gl',],
'moitos'=>['gl',],
'moj'=>['bs','hr','sl','sr',],
'moja'=>['bs','hr','pl','sk','sl','sr',],
'mojbog'=>['sl',],
'moje'=>['bs','cs','hr','pl','sk','sl','sr',],
'mojega'=>['sl',],
'mojego'=>['pl',],
'mojej'=>['pl','sk',],
'mojem'=>['sl',],
'moji'=>['bs','cs','hr','sk','sl','sr',],
'mojich'=>['sk',],
'mojih'=>['bs','sl','sr',],
'mojim'=>['bs','hr','sr',],
'mojo'=>['sl',],
'mojoj'=>['bs','hr','sr',],
'mojom'=>['sk',],
'mojou'=>['sk',],
'moju'=>['bs','hr','sk','sr',],
'mojí'=>['cs',],
'moją'=>['pl',],
'moka'=>['lt',],
'moko'=>['eu',],
'mokyklos'=>['lt',],
'mokyklą'=>['lt',],
'moldatuko'=>['eu',],
'molekul'=>['id',],
'molemmat'=>['fi',],
'molim'=>['bs','hr','sr',],
'molt'=>['ca',],
'molta'=>['ca',],
'molte'=>['it',],
'moltes'=>['ca',],
'molti'=>['it',],
'molto'=>['it',],
'molts'=>['ca',],
'mom'=>['bs','de','en','hr','sr',],
'momak'=>['bs','hr','sr',],
'momci'=>['bs','hr','sr',],
'moment'=>['ca','cs','de','en','fr','nl','ro','sk','sq',],
'momento'=>['es','gl','it','pt','pt_br',],
'momentos'=>['gl',],
'momentul'=>['ro',],
'momka'=>['bs',],
'mon'=>['ca','fr','si',],
'monate'=>['de',],
'mond'=>['ca','hu','nl',],
'mondani'=>['hu',],
'mondanom'=>['hu',],
'monday'=>['th',],
'mondd'=>['hu',],
'monde'=>['fr',],
'mondja'=>['hu',],
'mondjuk'=>['hu',],
'mondják'=>['hu',],
'mondo'=>['it',],
'mondod'=>['hu',],
'mondok'=>['hu',],
'mondom'=>['hu',],
'mondott'=>['hu',],
'mondta'=>['hu',],
'mondtad'=>['hu',],
'mondtam'=>['hu',],
'mondták'=>['hu',],
'mondtál'=>['hu',],
'moneter'=>['id',],
'money'=>['en','si',],
'monsieur'=>['fr',],
'monster'=>['th',],
'monstre'=>['ca',],
'monta'=>['fi',],
'monte'=>['fr','gl','pt_br',],
'monter'=>['fr',],
'month'=>['en',],
'months'=>['en','si',],
'montre'=>['fr',],
'montrer'=>['fr',],
'moodi'=>['et',],
'mooi'=>['af','nl',],
'mooie'=>['nl',],
'mooiste'=>['af',],
'moontlik'=>['af',],
'moord'=>['nl',],
'moordenaar'=>['nl',],
'mor'=>['da','nb','no','ro','sv',],
'mora'=>['bs','hr','sl','sq','sr',],
'morajo'=>['sl',],
'moraju'=>['bs','hr',],
'moral'=>['sl',],
'morala'=>['sl',],
'morali'=>['sl',],
'moram'=>['bs','hr','sl','sr',],
'moramo'=>['bs','hr','sl','sr',],
'morao'=>['bs','hr','sr',],
'morat'=>['hr',],
'morate'=>['bs','hr','sl','sr',],
'morati'=>['bs','hr','sr',],
'morava'=>['sl',],
'moraš'=>['bs','hr','sl',],
'moraљ'=>['bs','hr','sr',],
'mord'=>['da','sv',],
'morda'=>['sl',],
'more'=>['en','la','sl','sq',],
'morem'=>['sl',],
'moremo'=>['sl',],
'moren'=>['nb','no',],
'moreš'=>['sl',],
'morgen'=>['da','de','nb','nl','no',],
'morgon'=>['sv',],
'morgun'=>['is',],
'mori'=>['ro','sq',],
'moribus'=>['la',],
'morir'=>['ca','es',],
'morire'=>['it',],
'morning'=>['en','si',],
'moro'=>['nb',],
'morrer'=>['pt','pt_br',],
'morreu'=>['pt','pt_br',],
'mors'=>['la',],
'morsomt'=>['nb','no',],
'mort'=>['ca','fr','ro',],
'morta'=>['ca','it','pt','pt_br',],
'morte'=>['fr','gl','it','la','pt','pt_br',],
'mortem'=>['la',],
'morti'=>['it',],
'mortis'=>['la',],
'morto'=>['it','pt','pt_br',],
'mortos'=>['pt','pt_br',],
'morts'=>['ca','fr',],
'mos'=>['sq',],
'most'=>['en','hu',],
'mostra'=>['gl',],
'mostrar'=>['pt','pt_br',],
'mot'=>['fr','nb','no','sv',],
'moteris'=>['lt',],
'mother'=>['en',],
'motina'=>['lt',],
'motiv'=>['ro',],
'motivo'=>['gl','it',],
'motra'=>['sq',],
'mots'=>['fr',],
'motus'=>['la',],
'mou'=>['cs',],
'mourir'=>['fr',],
'mouth'=>['en',],
'move'=>['en','th',],
'movemento'=>['gl',],
'movie'=>['en',],
'moving'=>['en',],
'mox'=>['la',],
'moyang'=>['id',],
'moyen'=>['fr',],
'mozda'=>['bs','sr',],
'mozes'=>['bs','sr',],
'mozgás'=>['hu',],
'mozo'=>['gl',],
'mozos'=>['gl',],
'moztu'=>['eu',],
'moći'=>['bs','hr',],
'moč'=>['sl',],
'močno'=>['sl',],
'moški'=>['sl',],
'może'=>['pl',],
'możecie'=>['pl',],
'możemy'=>['pl',],
'możesz'=>['pl',],
'możliwe'=>['pl',],
'można'=>['pl',],
'mož'=>['sl',],
'moža'=>['sl',],
'možda'=>['bs','hr',],
'može'=>['bs','hr',],
'možemo'=>['bs','hr',],
'možete'=>['bs','hr',],
'možeš'=>['bs','hr',],
'možno'=>['sk',],
'možnost'=>['cs','sl',],
'možnosti'=>['sl',],
'možnosť'=>['sk',],
'možná'=>['cs',],
'možné'=>['cs','sk',],
'moжi'=>['sr',],
'moћda'=>['bs','hr','sr',],
'moћe'=>['bs','hr','sr',],
'moћemo'=>['bs','hr','sr',],
'moћete'=>['bs','hr','sr',],
'moћeљ'=>['bs','hr','sr',],
'mr'=>['af','bs','da','de','en','et','fi','fr','hu','it','lv','ms','nb','nl','no','pt','si','sr','sv',],
'mrekulli'=>['sq',],
'mrekullueshme'=>['sq',],
'mrs'=>['da','hu','nb','nl','no','si','sv',],
'mrtav'=>['bs','hr','sr',],
'mrtev'=>['sl',],
'mrtva'=>['bs','hr','sl','sr',],
'mrtvi'=>['bs',],
'mrtvý'=>['cs',],
'mrzim'=>['bs','hr','sr',],
'mrzí'=>['sk',],
'mu'=>['bs','cs','et','hr','ms','pl','sk','sl','sq','sr','tr',],
'mua'=>['sq',],
'muaj'=>['sq',],
'much'=>['af','en','th',],
'mucha'=>['es',],
'muchacho'=>['es',],
'muchachos'=>['es',],
'muchas'=>['es',],
'mucho'=>['es',],
'muchos'=>['es',],
'muda'=>['id','ms',],
'mudah'=>['id','ms',],
'mudar'=>['pt','pt_br',],
'muerte'=>['es',],
'muerto'=>['es',],
'muertos'=>['es',],
'mugiarazi'=>['eu',],
'mugitu'=>['eu',],
'muhtemelen'=>['tr',],
'muhteşem'=>['tr',],
'muidu'=>['et',],
'muidugi'=>['et',],
'muista'=>['fi',],
'muistan'=>['fi',],
'muistatko'=>['fi',],
'muita'=>['fi','pt','pt_br',],
'muitas'=>['pt','pt_br',],
'muito'=>['pt','pt_br',],
'muitos'=>['pt','pt_br',],
'mujer'=>['es',],
'mujeres'=>['es',],
'muka'=>['fi','id',],
'mukaan'=>['fi',],
'mukana'=>['fi',],
'mukava'=>['fi',],
'mukavaa'=>['fi',],
'mul'=>['et',],
'mulai'=>['id','ms',],
'mulher'=>['pt','pt_br',],
'mulheres'=>['pt','pt_br',],
'mulia'=>['ms',],
'mulig'=>['nb','no',],
'muligt'=>['da',],
'mulle'=>['et',],
'muller'=>['gl',],
'mulleres'=>['gl',],
'mult'=>['ro',],
'multa'=>['la',],
'multe'=>['ro',],
'multi'=>['la',],
'multis'=>['la',],
'multitudo'=>['la',],
'multo'=>['la',],
'multos'=>['la',],
'multum'=>['la',],
'multumesc'=>['ro',],
'multă'=>['ro',],
'mulut'=>['ms',],
'mulţi'=>['ro',],
'mulţumesc'=>['ro',],
'mumis'=>['lt',],
'mums'=>['lt','lv',],
'mun'=>['fi','is',],
'munca'=>['ro',],
'muncul'=>['id','ms',],
'muncă'=>['ro',],
'mund'=>['da','de','sq',],
'mundem'=>['sq',],
'mundemi'=>['sq',],
'mundesh'=>['sq',],
'mundet'=>['sq',],
'mundi'=>['la',],
'mundial'=>['gl',],
'mundo'=>['es','gl','pt','pt_br',],
'mundu'=>['is',],
'munduko'=>['eu',],
'mundur'=>['ms','sq',],
'mundësi'=>['sq',],
'mungkin'=>['id','ms',],
'mungkinkah'=>['id',],
'munka'=>['hu',],
'munkát'=>['hu',],
'munnen'=>['nb',],
'munu'=>['is',],
'murder'=>['en',],
'muretse'=>['et',],
'muri'=>['ro',],
'murit'=>['ro',],
'muriwairen'=>['eu',],
'murió'=>['es',],
'murni'=>['id',],
'mus'=>['lt',],
'musel'=>['cs','sk',],
'muset'=>['cs',],
'musi'=>['pl',],
'musia'=>['sk',],
'musiał'=>['pl',],
'musiałem'=>['pl',],
'music'=>['en',],
'musica'=>['it',],
'musicie'=>['pl',],
'musieť'=>['sk',],
'musik'=>['da','de','id','ms','sv',],
'musim'=>['id','ms',],
'musimy'=>['pl',],
'musique'=>['fr',],
'musisz'=>['pl',],
'muslim'=>['si',],
'muss'=>['de',],
'musst'=>['de',],
'musste'=>['de',],
'must'=>['en','et','th',],
'musu'=>['lt',],
'musuh'=>['ms',],
'musun'=>['tr',],
'musunuz'=>['tr',],
'muszáj'=>['hu',],
'muszą'=>['pl',],
'muszę'=>['pl',],
'musí'=>['cs','sk',],
'musím'=>['cs','sk',],
'musíme'=>['cs','sk',],
'musíte'=>['cs','sk',],
'musíš'=>['cs','sk',],
'mut'=>['sq',],
'mutasd'=>['hu',],
'mutil'=>['eu',],
'mutila'=>['eu',],
'mutlu'=>['tr',],
'mutta'=>['fi',],
'mutter'=>['de',],
'muturra'=>['eu',],
'muu'=>['fi',],
'muud'=>['et',],
'muut'=>['fi',],
'muuta'=>['fi',],
'muutama'=>['fi',],
'muutaman'=>['fi',],
'muuten'=>['fi',],
'muuttaa'=>['fi',],
'muy'=>['es',],
'muziek'=>['nl',],
'muß'=>['de',],
'muļķības'=>['lv',],
'muž'=>['cs','sk',],
'muža'=>['sk',],
'muže'=>['cs',],
'muži'=>['cs','sk',],
'mužov'=>['sk',],
'muћ'=>['sr',],
'my'=>['af','cs','en','fa','ms','pl','si','sk','th',],
'mycket'=>['sv',],
'mye'=>['nb','no',],
'myli'=>['lt',],
'myliu'=>['lt',],
'mynd'=>['is',],
'myndi'=>['is',],
'myndir'=>['is',],
'myne'=>['af',],
'myself'=>['af','en','th',],
'myslel'=>['cs','sk',],
'myslela'=>['cs','sk',],
'myslet'=>['cs',],
'mysli'=>['cs','sk',],
'myslieť'=>['sk',],
'myslí'=>['cs','sk',],
'myslím'=>['cs','sk',],
'myslíte'=>['cs','sk',],
'myslíš'=>['cs','sk',],
'myöhemmin'=>['fi',],
'myöhässä'=>['fi',],
'myös'=>['fi',],
'myśl'=>['pl',],
'myślałam'=>['pl',],
'myślałem'=>['pl',],
'myśleć'=>['pl',],
'myśli'=>['pl',],
'myślisz'=>['pl',],
'myślę'=>['pl',],
'mà'=>['ca',],
'màquina'=>['ca',],
'má'=>['cs','is','pt','sk',],
'máis'=>['gl',],
'mál'=>['is',],
'máli'=>['is',],
'málið'=>['is',],
'mám'=>['cs','sk',],
'máma'=>['cs',],
'máme'=>['cs','sk',],
'mánuði'=>['is',],
'már'=>['hu',],
'máris'=>['hu',],
'más'=>['es','hu',],
'másik'=>['hu',],
'második'=>['hu',],
'mást'=>['hu',],
'máte'=>['cs','sk',],
'mátt'=>['is',],
'máš'=>['cs','sk',],
'mâine'=>['ro',],
'mâinile'=>['ro',],
'mâna'=>['ro',],
'mâncare'=>['ro',],
'mână'=>['ro',],
'mãe'=>['pt','pt_br',],
'mão'=>['pt','pt_br',],
'mãos'=>['pt','pt_br',],
'mä'=>['fi',],
'mädchen'=>['de',],
'mäleta'=>['et',],
'mäletad'=>['et',],
'mäletan'=>['et',],
'män'=>['sv',],
'mäng'=>['et',],
'mängida'=>['et',],
'mängu'=>['et',],
'männer'=>['de',],
'människa'=>['sv',],
'människor'=>['sv',],
'må'=>['da','nb','no','sv',],
'måde'=>['da',],
'månader'=>['sv',],
'måneder'=>['da','nb','no',],
'många'=>['sv',],
'mår'=>['sv',],
'måske'=>['da','no',],
'måste'=>['sv',],
'måte'=>['nb','no',],
'måten'=>['nb','no',],
'måtte'=>['da','nb','no',],
'mænd'=>['da',],
'mærke'=>['da',],
'mère'=>['fr',],
'mé'=>['cs',],
'médecin'=>['fr',],
'médico'=>['es','pt','pt_br',],
'még'=>['hu',],
'mégis'=>['hu',],
'mého'=>['cs',],
'mém'=>['cs',],
'mér'=>['is',],
'més'=>['ca',],
'mész'=>['hu',],
'même'=>['fr',],
'mês'=>['pt','pt_br',],
'më'=>['sq',],
'mëdha'=>['sq',],
'mëngjes'=>['sq',],
'mënyra'=>['sq',],
'mënyrë'=>['sq',],
'mësuar'=>['sq',],
'mí'=>['es',],
'mía'=>['es',],
'míg'=>['hu',],
'mín'=>['is',],
'mína'=>['is',],
'mínar'=>['is',],
'mínir'=>['is',],
'míns'=>['is',],
'mínu'=>['is',],
'mínum'=>['is',],
'mínútur'=>['is',],
'mío'=>['es',],
'místa'=>['cs',],
'místo'=>['cs',],
'místě'=>['cs',],
'mít'=>['cs',],
'mógł'=>['pl',],
'mógłby'=>['pl',],
'mógłbym'=>['pl',],
'mógłbyś'=>['pl',],
'mój'=>['pl',],
'món'=>['ca',],
'móti'=>['is',],
'mów'=>['pl',],
'mówi'=>['pl',],
'mówisz'=>['pl',],
'mówią'=>['pl',],
'mówiąc'=>['pl',],
'mówić'=>['pl',],
'mówię'=>['pl',],
'mówił'=>['pl',],
'mówiłam'=>['pl',],
'mówiłem'=>['pl',],
'mówiłeś'=>['pl',],
'móðir'=>['is',],
'móður'=>['is',],
'môj'=>['sk',],
'môjho'=>['sk',],
'môže'=>['sk',],
'môžem'=>['sk',],
'môžeme'=>['sk',],
'môžete'=>['sk',],
'môžeš'=>['sk',],
'môžu'=>['sk',],
'mõelda'=>['et',],
'mõelnud'=>['et',],
'mõista'=>['et',],
'mõistad'=>['et',],
'mõistan'=>['et',],
'mõlemad'=>['et',],
'mõnda'=>['et',],
'mõne'=>['et',],
'mõned'=>['et',],
'mõni'=>['et',],
'mõnikord'=>['et',],
'mõte'=>['et',],
'mõtle'=>['et',],
'mõtled'=>['et',],
'mõtlen'=>['et',],
'mõtlesin'=>['et',],
'mõttes'=>['et',],
'möchte'=>['de',],
'möchten'=>['de',],
'möchtest'=>['de',],
'mögen'=>['de',],
'möglich'=>['de',],
'mögött'=>['hu',],
'möjligt'=>['sv',],
'mömmu'=>['is',],
'mörg'=>['is',],
'mövzuda'=>['az',],
'mööda'=>['et',],
'møde'=>['da',],
'mødes'=>['da',],
'mødt'=>['da',],
'mødte'=>['da',],
'møte'=>['nb','no',],
'møtt'=>['nb',],
'múlt'=>['hu',],
'múlva'=>['hu',],
'música'=>['ca','es','gl','pt','pt_br',],
'mü'=>['tr',],
'müde'=>['de',],
'mükemmel'=>['tr',],
'mümkün'=>['tr',],
'müssen'=>['de',],
'müxtəlif'=>['az',],
'müzakirə'=>['az',],
'müzik'=>['tr',],
'mých'=>['cs',],
'mým'=>['cs',],
'māja'=>['lv',],
'mājas'=>['lv',],
'māju'=>['lv',],
'mājā'=>['lv',],
'mājās'=>['lv',],
'mārtij'=>['lv',],
'māsa'=>['lv',],
'māte'=>['lv',],
'māti'=>['lv',],
'mă'=>['ro',],
'măcar'=>['ro',],
'mąż'=>['pl',],
'mēs'=>['lv',],
'mėnesius'=>['lt',],
'mėšlas'=>['lt',],
'mężczyzna'=>['pl',],
'mě'=>['cs',],
'měl'=>['cs',],
'měla'=>['cs',],
'měli'=>['cs',],
'mělo'=>['cs',],
'města'=>['cs',],
'město'=>['cs',],
'městě'=>['cs',],
'měsíc'=>['cs',],
'mīlestība'=>['lv',],
'mīlestību'=>['lv',],
'mīlu'=>['lv',],
'mīļais'=>['lv',],
'mīļā'=>['lv',],
'mı'=>['tr',],
'mısın'=>['tr',],
'mısınız'=>['tr',],
'mıydı'=>['tr',],
'mňa'=>['sk',],
'mŕtvy'=>['sk',],
'mūs'=>['lv',],
'mūsu'=>['lv',],
'mūsų'=>['lt',],
'můj'=>['cs',],
'může'=>['cs',],
'můžeme'=>['cs',],
'můžete'=>['cs',],
'můžeš'=>['cs',],
'můžu'=>['cs',],
'működik'=>['hu',],
'məkanı'=>['az',],
'mən'=>['az',],
'n'=>['af','ca','da','de','fi','fr','is','it','nb','nl','no','ro','sq','sv','th','zh_tw',],
'na'=>['af','bs','cs','de','gl','hr','hu','lt','nb','nl','no','pl','pt','pt_br','si','sk','sl','sq','sr',],
'naam'=>['af','nl',],
'naar'=>['nl',],
'naartoe'=>['nl',],
'naast'=>['nl',],
'nabaga'=>['lv',],
'naby'=>['af',],
'nach'=>['de',],
'nachdem'=>['de',],
'nachricht'=>['de',],
'nacht'=>['de','nl',],
'nacional'=>['gl',],
'nad'=>['cs','et','pl','sk','sl',],
'nada'=>['es','gl','pt','pt_br',],
'nadal'=>['pl',],
'nadam'=>['bs','hr','sr',],
'nadat'=>['nl',],
'nadie'=>['es',],
'nadmoæ'=>['hi',],
'nadzieję'=>['pl',],
'nafn'=>['is',],
'nafni'=>['is',],
'nag'=>['af',],
'nagi'=>['lt',],
'nagle'=>['pl',],
'nago'=>['eu',],
'nagoela'=>['eu',],
'nagte'=>['af',],
'nagu'=>['et',],
'nagy'=>['hu',],
'nagyobb'=>['hu',],
'nagyon'=>['hu',],
'nagyszerű'=>['hu',],
'nah'=>['id','ms',],
'nahi'=>['eu',],
'nahiko'=>['eu',],
'nahikoa'=>['eu',],
'nahiz'=>['eu',],
'nahoru'=>['cs',],
'nahoře'=>['cs',],
'nai'=>['gl',],
'naiba'=>['ro',],
'naibii'=>['ro',],
'naik'=>['id','ms',],
'naimisiin'=>['fi',],
'naimisissa'=>['fi',],
'naine'=>['et',],
'nainen'=>['fi',],
'naise'=>['et',],
'naised'=>['et',],
'naisen'=>['fi',],
'naiset'=>['fi',],
'naist'=>['et',],
'naiz'=>['eu',],
'naizelako'=>['eu',],
'naizen'=>['eu',],
'naizena'=>['eu',],
'naj'=>['sl',],
'najbardziej'=>['pl',],
'najbolj'=>['sl',],
'najbolje'=>['bs','hr','sr',],
'najbolji'=>['bs','hr','sr',],
'najboljše'=>['sl',],
'najboljši'=>['sl',],
'najbrž'=>['sl',],
'najednou'=>['cs',],
'najlepszy'=>['pl',],
'najlepšie'=>['sk',],
'najlepší'=>['sk',],
'najpierw'=>['pl',],
'najprej'=>['sl',],
'najprv'=>['sk',],
'najskôr'=>['sk',],
'najti'=>['sl',],
'naju'=>['sl',],
'najít'=>['cs',],
'nak'=>['hu','ms',],
'nakon'=>['bs','hr','sr',],
'nakonec'=>['cs',],
'nakoniec'=>['sk',],
'nakti'=>['lv',],
'nakties'=>['lt',],
'nakts'=>['lv',],
'naktī'=>['lv',],
'naktį'=>['lt',],
'należy'=>['pl',],
'nalja'=>['et',],
'naljakas'=>['et',],
'nam'=>['bs','hr','la','nl','pl','sl','sr',],
'nama'=>['bs','hr','id','ms','sl','sr',],
'namai'=>['lt',],
'namaku'=>['ms',],
'namanya'=>['ms',],
'namas'=>['lt',],
'name'=>['af','de','en','sl',],
'namen'=>['de','nl',],
'namesto'=>['sl',],
'nami'=>['pl','sk','sl',],
'namie'=>['lt',],
'namn'=>['sv',],
'namo'=>['lt',],
'namorada'=>['pt',],
'namque'=>['la',],
'namun'=>['id','ms',],
'namuose'=>['lt',],
'namus'=>['lt',],
'namą'=>['lt',],
'namų'=>['lt',],
'nanti'=>['ms',],
'nao'=>['pt',],
'naozaj'=>['sk',],
'nap'=>['hu',],
'napad'=>['bs','sl',],
'napisy'=>['pl',],
'napisów'=>['pl',],
'napja'=>['hu',],
'napolje'=>['bs','sr',],
'napolju'=>['sr',],
'napon'=>['hu',],
'naposledy'=>['sk',],
'napot'=>['hu',],
'napravio'=>['bs','hr','sr',],
'napraviti'=>['bs','hr',],
'naprawdę'=>['pl',],
'napred'=>['sr',],
'naprej'=>['sl',],
'naprijed'=>['bs','hr',],
'naprosto'=>['cs',],
'napríklad'=>['sk',],
'naquel'=>['gl',],
'nar'=>['da','nb','no',],
'narator'=>['id',],
'naravno'=>['bs','hr','sr',],
'naravnost'=>['sl',],
'naredi'=>['sl',],
'naredil'=>['sl',],
'naredila'=>['sl',],
'naredili'=>['sl',],
'naredim'=>['sl',],
'narediti'=>['sl',],
'narobe'=>['sl',],
'nas'=>['bs','gl','hr','pl','pt','pt_br','sl','sr',],
'nasa'=>['af','id',],
'nascitur'=>['la',],
'naslednji'=>['sl',],
'naspäť'=>['sk',],
'nastavi'=>['bs','hr','sr',],
'nasumièno'=>['hi',],
'nasz'=>['pl',],
'nasza'=>['pl',],
'nasze'=>['pl',],
'naszego'=>['pl',],
'naszej'=>['pl',],
'naszych'=>['pl',],
'naszym'=>['pl',],
'naszą'=>['pl',],
'nasıl'=>['tr',],
'nasılsın'=>['tr',],
'nat'=>['da',],
'natal'=>['ms','pt','pt_br',],
'natale'=>['it',],
'nate'=>['sl',],
'nato'=>['sl',],
'nator'=>['eu',],
'natrag'=>['hr',],
'natt'=>['nb','no','sv',],
'natten'=>['da','nb','no','sv',],
'natuke'=>['et',],
'natura'=>['la',],
'naturae'=>['la',],
'natural'=>['gl',],
'naturam'=>['la',],
'natureza'=>['gl',],
'naturligtvis'=>['sv',],
'naturligvis'=>['da',],
'natus'=>['la',],
'natuurlijk'=>['nl',],
'natuurlik'=>['af',],
'natychmiast'=>['pl',],
'natyrisht'=>['sq',],
'natë'=>['sq',],
'natën'=>['sq',],
'natürlich'=>['de',],
'nau'=>['ca','eu',],
'nauda'=>['lv',],
'naudas'=>['lv',],
'naudu'=>['lv',],
'naues'=>['la',],
'nauja'=>['lt',],
'naujas'=>['lt',],
'naujo'=>['lt',],
'naują'=>['lt',],
'nauzu'=>['eu',],
'naučil'=>['sl',],
'nav'=>['lv',],
'navalia'=>['hi',],
'nave'=>['it',],
'naves'=>['la',],
'navidad'=>['es',],
'navn'=>['da','nb','no',],
'navnet'=>['nb','no',],
'navíc'=>['cs',],
'navždy'=>['sk',],
'nawet'=>['pl',],
'nazad'=>['bs','hr','sr',],
'nazaj'=>['sl',],
'nazvati'=>['hr',],
'nazwisko'=>['pl',],
'nazywa'=>['pl',],
'nazywam'=>['pl',],
'naći'=>['bs','hr',],
'način'=>['bs','hr','sl',],
'načrt'=>['sl',],
'naš'=>['bs','hr','sl',],
'naša'=>['bs','hr','sk','sl',],
'našao'=>['bs','hr',],
'naše'=>['bs','cs','hr','sk','sl',],
'našeho'=>['cs',],
'našej'=>['sk',],
'našel'=>['cs','sl',],
'naši'=>['cs','sl',],
'našich'=>['cs','sk',],
'našiel'=>['sk',],
'našla'=>['sk','sl',],
'našli'=>['bs','cs','hr','sk','sl',],
'našo'=>['sl',],
'našu'=>['sk',],
'naší'=>['cs',],
'naжi'=>['bs','sr',],
'naиin'=>['bs','sr',],
'naрem'=>['sr',],
'naљ'=>['bs','sr',],
'naљa'=>['sr',],
'naљao'=>['sr',],
'naљe'=>['sr',],
'naљeg'=>['sr',],
'naљli'=>['sr',],
'naљu'=>['sr',],
'nbsp'=>['ko',],
'ndaj'=>['sq',],
'ndal'=>['sq',],
'ndalo'=>['sq',],
'nder'=>['sq',],
'ndihem'=>['sq',],
'ndihesh'=>['sq',],
'ndihmo'=>['sq',],
'ndihmoj'=>['sq',],
'ndihmojë'=>['sq',],
'ndihmoni'=>['sq',],
'ndihmosh'=>['sq',],
'ndihmë'=>['sq',],
'ndjej'=>['sq',],
'ndodh'=>['sq',],
'ndodhet'=>['sq',],
'ndodhi'=>['sq',],
'ndodhur'=>['sq',],
'ndodhë'=>['sq',],
'ndonje'=>['sq',],
'ndonjë'=>['sq',],
'ndonjëherë'=>['sq',],
'ndoshta'=>['sq',],
'ndryshe'=>['sq',],
'ndryshuar'=>['sq',],
'ndërsa'=>['sq',],
'ne'=>['az','bs','ca','cs','de','fi','fr','hr','hu','it','la','lt','lv','ro','sk','sl','sq','sr','tr',],
'neanche'=>['it',],
'near'=>['en',],
'neba'=>['eu',],
'nebija'=>['lv',],
'nebiju'=>['lv',],
'neblogai'=>['lt',],
'nebo'=>['cs',],
'neboj'=>['cs','sk',],
'nebol'=>['sk',],
'nebola'=>['sk',],
'neboli'=>['sk',],
'nebolo'=>['sk',],
'nebude'=>['cs','sk',],
'nebudem'=>['sk',],
'nebudeš'=>['cs','sk',],
'nebudu'=>['cs',],
'nebun'=>['ro',],
'nebunie'=>['ro',],
'nebus'=>['lt',],
'nebuvau'=>['lt',],
'nebuvo'=>['lt',],
'nebyl'=>['cs',],
'nebyla'=>['cs',],
'nebylo'=>['cs',],
'nebėra'=>['lt',],
'nebūs'=>['lv',],
'nebūtu'=>['lv',],
'nebūtų'=>['lt',],
'nec'=>['la',],
'nece'=>['bs','sr',],
'necesario'=>['es','gl',],
'necesidade'=>['gl',],
'necesita'=>['es',],
'necesitamos'=>['es',],
'necesitas'=>['es',],
'necesito'=>['es',],
'necesse'=>['la',],
'necessita'=>['ca',],
'necessitem'=>['ca',],
'necessito'=>['ca',],
'nech'=>['cs','sk',],
'nechaj'=>['sk',],
'nechajte'=>['sk',],
'nechal'=>['cs','sk',],
'nechat'=>['cs',],
'nechať'=>['sk',],
'nechce'=>['cs','sk',],
'nechcel'=>['sk',],
'nechcem'=>['sk',],
'nechceš'=>['cs','sk',],
'nechci'=>['cs',],
'nechte'=>['cs',],
'nechtěl'=>['cs',],
'nechápu'=>['cs',],
'neck'=>['si',],
'ned'=>['da','nb','no','sv',],
'nedari'=>['lv',],
'nedaudz'=>['lv',],
'nede'=>['da','nb','no',],
'nedelje'=>['sr',],
'nedelju'=>['sr',],
'neden'=>['tr',],
'nedir'=>['tr',],
'nedomāju'=>['lv',],
'nedrīkst'=>['lv',],
'nedá'=>['sk',],
'nedēļas'=>['lv',],
'nedělej'=>['cs',],
'nee'=>['af','lv','nl',],
'need'=>['en','et','th',],
'needed'=>['en',],
'needs'=>['en',],
'neem'=>['af','nl',],
'neemt'=>['nl',],
'neer'=>['nl',],
'neera'=>['th',],
'neerdaal'=>['af',],
'neesam'=>['lv',],
'neesat'=>['lv',],
'neesi'=>['lv',],
'neesmu'=>['lv',],
'neetud'=>['et',],
'nefes'=>['tr',],
'nefret'=>['tr',],
'negali'=>['lt',],
'negalima'=>['lt',],
'negalime'=>['lt',],
'negaliu'=>['lt',],
'negalėjau'=>['lt',],
'negara'=>['id','ms',],
'negarrez'=>['eu',],
'negde'=>['sr',],
'negdje'=>['bs','hr',],
'negen'=>['nl',],
'negerai'=>['lt',],
'negi'=>['lt','th',],
'negli'=>['it',],
'nego'=>['bs','hr','sr',],
'negocio'=>['es',],
'negocios'=>['es',],
'negribi'=>['lv',],
'negribu'=>['lv',],
'negribēju'=>['lv',],
'negro'=>['es','gl',],
'negru'=>['ro',],
'negu'=>['lt',],
'negyvas'=>['lt',],
'negócio'=>['pt','pt_br',],
'negócios'=>['pt','pt_br',],
'nehaj'=>['sl',],
'nehme'=>['de',],
'nehmen'=>['de',],
'neho'=>['sk',],
'nehovor'=>['sk',],
'nehéz'=>['hu',],
'nei'=>['is','it','lt','nb','no',],
'neid'=>['et',],
'neil'=>['et',],
'neile'=>['et',],
'nein'=>['de',],
'neinn'=>['is',],
'neist'=>['et',],
'neither'=>['en',],
'neiti'=>['fi',],
'neitt'=>['is',],
'nej'=>['da','no','sk','sv',],
'nejako'=>['sk',],
'nejaká'=>['sk',],
'nejaké'=>['sk',],
'nejakú'=>['sk',],
'nejaký'=>['sk',],
'nejde'=>['cs','sk',],
'nejdřív'=>['cs',],
'nejlepší'=>['cs',],
'nejsem'=>['cs',],
'nejsi'=>['cs',],
'nejsme'=>['cs',],
'nejsou'=>['cs',],
'nejste'=>['cs',],
'největší'=>['cs',],
'nek'=>['hu',],
'neka'=>['bs','hr','sr',],
'nekad'=>['bs','lv','sr',],
'nekada'=>['bs','sr',],
'nekaj'=>['sl',],
'nekako'=>['bs','hr','sl','sr',],
'nekas'=>['lv',],
'nekateri'=>['sl',],
'nekatu'=>['eu',],
'nekatuta'=>['eu',],
'nekdo'=>['sl',],
'neke'=>['bs','hr','sr',],
'neked'=>['hu',],
'nekega'=>['sl',],
'nekem'=>['hu',],
'nekenčiu'=>['lt',],
'neki'=>['bs','hr','hu','sr',],
'nekik'=>['hu',],
'nekim'=>['bs','hr','sr',],
'nekje'=>['sl',],
'neko'=>['bs','hr','lv','sr',],
'nekog'=>['bs','hr','sr',],
'nekoga'=>['bs','hr','sl','sr',],
'nekoliko'=>['bs','hr','sr',],
'nekoč'=>['sl',],
'nektek'=>['hu',],
'neku'=>['bs','hr','sr',],
'nekur'=>['lv',],
'nekünk'=>['hu',],
'nekā'=>['lv',],
'nekāda'=>['lv',],
'nekādas'=>['lv',],
'nekādu'=>['lv',],
'nel'=>['gl','it',],
'nela'=>['gl',],
'nelabai'=>['lt',],
'nele'=>['pt','pt_br',],
'neler'=>['tr',],
'neli'=>['et',],
'neljä'=>['fi',],
'nella'=>['it',],
'nelle'=>['it',],
'nello'=>['it',],
'nem'=>['hu','pt','pt_br',],
'nema'=>['bs','hr','is','sr',],
'nemad'=>['et',],
'nemal'=>['sk',],
'nemala'=>['sk',],
'nemali'=>['sk',],
'nemam'=>['bs','hr','sr',],
'nemamo'=>['bs','hr','sr',],
'nemanau'=>['lt',],
'nematau'=>['lt',],
'nemaz'=>['lv',],
'nemačiau'=>['lt',],
'nemaš'=>['bs','hr',],
'nemaљ'=>['sr',],
'nemen'=>['nl',],
'neminem'=>['la',],
'nemlig'=>['da',],
'nemmeno'=>['it',],
'nemo'=>['la',],
'nemohl'=>['cs',],
'nemohol'=>['sk',],
'nemohu'=>['cs',],
'nemoj'=>['bs','hr','sr',],
'nemojte'=>['bs','hr','sr',],
'nemusíš'=>['cs','sk',],
'nemyslím'=>['cs','sk',],
'nemá'=>['cs','sk',],
'nemám'=>['cs','sk',],
'nemáme'=>['cs','sk',],
'nemáte'=>['cs','sk',],
'nemáš'=>['cs','sk',],
'nemôže'=>['sk',],
'nemôžem'=>['sk',],
'nemôžeme'=>['sk',],
'nemôžete'=>['sk',],
'nemôžeš'=>['sk',],
'neměl'=>['cs',],
'neměla'=>['cs',],
'neměli'=>['cs',],
'nemůže'=>['cs',],
'nemůžeme'=>['cs',],
'nemůžete'=>['cs',],
'nemůžeš'=>['cs',],
'nemůžu'=>['cs',],
'nen'=>['ca',],
'nena'=>['ca','es',],
'nende'=>['et',],
'nendega'=>['et',],
'nenek'=>['id','ms',],
'nenhum'=>['pt','pt_br',],
'nenhuma'=>['pt','pt_br',],
'nennen'=>['de',],
'neno'=>['gl',],
'nenori'=>['lt',],
'nenoriu'=>['lt',],
'nenorocit'=>['ro',],
'nenorėjau'=>['lt',],
'nenos'=>['gl',],
'nens'=>['ca',],
'není'=>['cs',],
'nepareizi'=>['lv',],
'nepatinka'=>['lt',],
'nepatīk'=>['lv',],
'nepovedal'=>['sk',],
'neque'=>['la',],
'ner'=>['sv',],
'neraka'=>['ms',],
'nerd'=>['eu',],
'nere'=>['sv',],
'nerede'=>['tr',],
'nereden'=>['tr',],
'neredeyse'=>['tr',],
'nereikia'=>['lt',],
'nereye'=>['tr',],
'nergens'=>['nl',],
'nero'=>['it',],
'nerob'=>['sk',],
'nerozumiem'=>['sk',],
'nes'=>['lt',],
'nesakyk'=>['lt',],
'nesaprotu'=>['lv',],
'nescio'=>['la',],
'nese'=>['gl','sq',],
'nesh'=>['sq',],
'nesijaudink'=>['lt',],
'neska'=>['eu',],
'neskak'=>['eu',],
'neskarentzat'=>['eu',],
'neskari'=>['eu',],
'neskoro'=>['sk',],
'neskôr'=>['sk',],
'nespēj'=>['lv',],
'nespēju'=>['lv',],
'nessa'=>['pt','pt_br',],
'nesse'=>['pt','pt_br',],
'nessun'=>['it',],
'nessuna'=>['it',],
'nessuno'=>['it',],
'nesta'=>['gl','pt','pt_br',],
'neste'=>['gl','nb','no','pt','pt_br',],
'nesten'=>['nb','no',],
'nestes'=>['gl',],
'nesto'=>['bs','sr',],
'nesu'=>['lt',],
'nesuprantu'=>['lt',],
'nesvarbu'=>['lt',],
'nesër'=>['sq',],
'net'=>['af','lt','nl','sq',],
'netgi'=>['lt',],
'neticami'=>['lv',],
'netko'=>['bs','hr',],
'netop'=>['da',],
'netrukus'=>['lt',],
'nett'=>['de',],
'nettopp'=>['nb','no',],
'neturi'=>['lt',],
'neturiu'=>['lt',],
'neu'=>['eu',],
'neue'=>['de',],
'neuen'=>['de',],
'neues'=>['de',],
'neuf'=>['fr',],
'neuk'=>['eu',],
'neurtua'=>['eu',],
'neus'=>['af',],
'neuztraucies'=>['lv',],
'nevadí'=>['cs','sk',],
'nevajadzētu'=>['lv',],
'nevajag'=>['lv',],
'nevar'=>['lv',],
'nevaram'=>['lv',],
'nevari'=>['lv',],
'nevaru'=>['lv',],
'nevarētu'=>['lv',],
'neve'=>['hu','sq',],
'nevedel'=>['sk',],
'nevem'=>['hu',],
'never'=>['en','si','th',],
'neverjetno'=>['sl',],
'neverovatno'=>['sr',],
'neverím'=>['sk',],
'nevidel'=>['sk',],
'neviděl'=>['cs',],
'nevie'=>['sk',],
'neviem'=>['sk',],
'neviena'=>['lv',],
'nevienam'=>['lv',],
'neviens'=>['lv',],
'nevienu'=>['lv',],
'nevieš'=>['sk',],
'nevis'=>['lv',],
'nevjerojatno'=>['hr',],
'nevoie'=>['ro',],
'nevojitet'=>['sq',],
'nevojë'=>['sq',],
'nevét'=>['hu',],
'neví'=>['cs',],
'nevím'=>['cs',],
'nevíš'=>['cs',],
'nevēlos'=>['lv',],
'nevěděl'=>['cs',],
'new'=>['af','bs','cs','da','de','en','et','fi','fr','hr','hu','id','is','it','ms','nb','nl','no','ro','si','sk','sl','sv','tr',],
'news'=>['en','si',],
'newton'=>['id',],
'next'=>['en','th',],
'neydi'=>['tr',],
'neye'=>['tr',],
'neyi'=>['tr',],
'neyin'=>['tr',],
'neyse'=>['tr',],
'nezina'=>['lv',],
'nezini'=>['lv',],
'nezinu'=>['lv',],
'nezināju'=>['lv',],
'neæe'=>['bs',],
'neèeš'=>['hi',],
'neće'=>['bs','hr',],
'nećemo'=>['hr',],
'nećeš'=>['bs','hr',],
'neću'=>['bs','hr',],
'neįmanoma'=>['lt',],
'neřekl'=>['cs',],
'neříkej'=>['cs',],
'nešto'=>['bs','hr',],
'než'=>['cs','sk',],
'nežinai'=>['lt',],
'nežinau'=>['lt',],
'nežino'=>['lt',],
'nežinojau'=>['lt',],
'neжe'=>['bs','hr','sr',],
'neжemo'=>['sr',],
'neжete'=>['sr',],
'neжeљ'=>['bs','sr',],
'neжu'=>['bs','hr','sr',],
'neљto'=>['bs','hr','sr',],
'nga'=>['sq',],
'ngadalë'=>['sq',],
'nggak'=>['ms',],
'ngrënë'=>['sq',],
'ni'=>['bs','ca','cs','da','es','eu','fr','hr','ms','nb','no','sl','sr','sv',],
'nic'=>['cs','pl',],
'nice'=>['en','si',],
'nich'=>['cs','pl','sk',],
'nicht'=>['de',],
'nichts'=>['de',],
'nici'=>['ro',],
'nicio'=>['ro',],
'niciodata'=>['ro',],
'niciodată'=>['ro',],
'niciun'=>['ro',],
'niczego'=>['pl',],
'niczym'=>['pl',],
'nie'=>['af','de','pl','sk',],
'niech'=>['pl',],
'niedługo'=>['pl',],
'niego'=>['pl',],
'niej'=>['pl',],
'niekad'=>['lt',],
'niekada'=>['lt',],
'niekados'=>['lt',],
'niekam'=>['lt',],
'niekas'=>['lt',],
'niekde'=>['sk',],
'niekedy'=>['sk',],
'nieko'=>['lt',],
'niekoho'=>['sk',],
'niekoľko'=>['sk',],
'niekto'=>['sk',],
'niekur'=>['lt',],
'niemals'=>['de',],
'niemand'=>['af','de','nl',],
'niemożliwe'=>['pl',],
'nien'=>['eu',],
'niente'=>['it',],
'niestety'=>['pl',],
'niet'=>['nl',],
'niets'=>['nl',],
'nietwaar'=>['nl',],
'nieuw'=>['nl',],
'nieuwe'=>['nl',],
'nieuws'=>['nl',],
'nieważne'=>['pl',],
'niečo'=>['sk',],
'nieźle'=>['pl',],
'nigana'=>['eu',],
'nigdy'=>['pl',],
'night'=>['en','th',],
'nihil'=>['la',],
'nihče'=>['sl',],
'nii'=>['et',],
'niiden'=>['fi',],
'niimoodi'=>['et',],
'niin'=>['fi',],
'niinkö'=>['fi',],
'niinpä'=>['fi',],
'niisiis'=>['et',],
'niistä'=>['fi',],
'niitä'=>['fi',],
'nije'=>['bs','hr','sr',],
'nik'=>['eu',],
'nikad'=>['bs','hr','sr',],
'nikada'=>['bs','hr','sr',],
'nikar'=>['sl',],
'nikdo'=>['cs',],
'nikdy'=>['cs','sk',],
'nikki'=>['si',],
'niko'=>['bs','sr',],
'nikoga'=>['bs','hr','sr',],
'nikogar'=>['sl',],
'nikogo'=>['pl',],
'nikoho'=>['cs','sk',],
'nikoli'=>['sl',],
'nikomu'=>['cs','pl','sk',],
'niks'=>['af','nl',],
'nikt'=>['pl',],
'nikto'=>['sk',],
'nilai'=>['id',],
'nim'=>['pl',],
'nima'=>['sl',],
'nimam'=>['sl',],
'nimamo'=>['sl',],
'nimaš'=>['sl',],
'nime'=>['et',],
'nimel'=>['et',],
'nimeni'=>['fi','ro',],
'nimensä'=>['fi',],
'nimesi'=>['fi',],
'nimi'=>['cs','et','fi','pl','sk',],
'nimic'=>['ro',],
'nimis'=>['la',],
'nimm'=>['de',],
'nimmt'=>['de',],
'nin'=>['gl',],
'nina'=>['af',],
'nincs'=>['hu',],
'nincsenek'=>['hu',],
'ning'=>['et',],
'ninguna'=>['es',],
'ningunha'=>['gl',],
'ninguém'=>['pt','pt_br',],
'ninguén'=>['gl',],
'ningú'=>['ca',],
'ningún'=>['es','gl',],
'nintzateke'=>['eu',],
'nintzen'=>['eu',],
'nintzenean'=>['eu',],
'nintzenetik'=>['eu',],
'nintzenez'=>['eu',],
'nio'=>['sv',],
'nire'=>['eu',],
'nirea'=>['eu',],
'niregana'=>['eu',],
'nirekin'=>['eu',],
'niri'=>['eu',],
'nisam'=>['bs','hr','sr',],
'nisem'=>['sl',],
'nisi'=>['bs','hr','la','sl','sr',],
'nismo'=>['bs','hr','sl','sr',],
'niso'=>['sl',],
'nisso'=>['pt','pt_br',],
'nista'=>['bs','sr',],
'niste'=>['bs','hr','ro','sl','sr',],
'nisto'=>['pt',],
'nisu'=>['bs','hr','sr',],
'nisva'=>['sl',],
'nit'=>['ca',],
'nitaz'=>['eu',],
'niti'=>['bs','hr','sl',],
'nitko'=>['bs','hr',],
'nivel'=>['gl',],
'niye'=>['tr',],
'niçin'=>['tr',],
'nièija'=>['hi',],
'nièiji'=>['hi',],
'niðri'=>['is',],
'niður'=>['is',],
'niña'=>['es',],
'niño'=>['es',],
'niños'=>['es',],
'nią'=>['pl',],
'nič'=>['sk','sl',],
'ničesar'=>['sl',],
'nişte'=>['ro',],
'ništa'=>['bs','hr',],
'niż'=>['pl',],
'niљta'=>['bs','hr','sr',],
'nje'=>['bs','hr','sl','sq','sr',],
'njega'=>['bs','hr','sl','sr',],
'njegov'=>['bs','hr','sl','sr',],
'njegova'=>['bs','hr','sl','sr',],
'njegove'=>['bs','hr','sl','sr',],
'njegovi'=>['sl',],
'njegovo'=>['bs','hr','sl','sr',],
'njegovu'=>['bs','hr','sr',],
'njeh'=>['sq',],
'njej'=>['sl',],
'njem'=>['sl',],
'njemu'=>['bs','hr','sr',],
'njen'=>['bs','sl','sr',],
'njena'=>['sl',],
'njeno'=>['sl',],
'njeri'=>['sq',],
'njeriu'=>['sq',],
'njerëz'=>['sq',],
'njerëzit'=>['sq',],
'njerëzve'=>['sq',],
'njih'=>['bs','hr','sl','sr',],
'njim'=>['bs','hr','sl','sr',],
'njima'=>['bs','hr','sr',],
'njimi'=>['sl',],
'njo'=>['sl',],
'njoh'=>['sq',],
'njohur'=>['sq',],
'njoj'=>['bs','hr','sr',],
'njom'=>['bs','hr','sr',],
'nju'=>['bs','hr','sq','sr',],
'një'=>['sq',],
'njëherë'=>['sq',],
'njëjtën'=>['sq',],
'njëri'=>['sq',],
'no'=>['af','bs','ca','cs','en','es','et','fa','fi','gl','hr','it','lv','ms','pl','pt','pt_br','si','sk','sl','th',],
'noapte'=>['ro',],
'noaptea'=>['ro',],
'noastre'=>['ro',],
'noastră'=>['ro',],
'nobene'=>['sl',],
'nobenega'=>['sl',],
'nobenih'=>['sl',],
'nobis'=>['la',],
'nobody'=>['en',],
'noc'=>['cs','pl','sk',],
'noch'=>['de',],
'noche'=>['es',],
'noches'=>['es',],
'nochmal'=>['de',],
'noci'=>['cs','sk',],
'nocoj'=>['sl',],
'nocte'=>['la',],
'nocy'=>['pl',],
'nodig'=>['af','nl',],
'noe'=>['nb','no',],
'noel'=>['tr',],
'noem'=>['nl',],
'noemen'=>['nl',],
'noen'=>['nb','no',],
'noensinne'=>['nb','no',],
'nog'=>['af','nl','sv',],
'nogal'=>['af','nl',],
'nogalināja'=>['lv',],
'nogalināt'=>['lv',],
'noge'=>['bs','hr','sl','sr',],
'nogen'=>['da','no',],
'nogensinde'=>['da',],
'noget'=>['da','no',],
'nogi'=>['pl',],
'nogle'=>['da','no',],
'noh'=>['et',],
'nohy'=>['cs','sk',],
'noi'=>['ca','it','ro',],
'noia'=>['ca',],
'noies'=>['ca',],
'noin'=>['fi',],
'noir'=>['fr',],
'nois'=>['ca',],
'noite'=>['gl','pt','pt_br',],
'noiz'=>['eu',],
'nok'=>['da','nb','no',],
'nokkra'=>['is',],
'nokkrar'=>['is',],
'nokkrum'=>['is',],
'nokkur'=>['is',],
'nokkuð'=>['is',],
'nola'=>['eu',],
'nolādēts'=>['lv',],
'nom'=>['ca','fr',],
'nombre'=>['es',],
'nome'=>['gl','it','pt','pt_br',],
'nomen'=>['la',],
'nomierinies'=>['lv',],
'nomina'=>['la',],
'nomine'=>['la',],
'nominis'=>['la',],
'nomira'=>['lv',],
'nommer'=>['af',],
'nomor'=>['ms',],
'només'=>['ca',],
'non'=>['ca','eu','fr','gl','it','la',],
'nona'=>['ms',],
'nondik'=>['eu',],
'nondum'=>['la',],
'none'=>['en',],
'nonne'=>['la',],
'nooit'=>['af','nl',],
'noor'=>['et',],
'noory'=>['id',],
'nopeasti'=>['fi',],
'nopietni'=>['lv',],
'nor'=>['eu','sl',],
'nora'=>['eu',],
'norbait'=>['eu',],
'norbaitek'=>['eu',],
'norbaiten'=>['eu',],
'nord'=>['ca',],
'noren'=>['eu',],
'nori'=>['lt',],
'norit'=>['lt',],
'norite'=>['lt',],
'noriu'=>['lt',],
'normaal'=>['nl',],
'normal'=>['ca','en','es','pt','pt_br','ro','tr',],
'normale'=>['it',],
'normalt'=>['da',],
'normální'=>['cs',],
'noro'=>['sl',],
'noroc'=>['ro',],
'nors'=>['lt',],
'norte'=>['gl','pt','pt_br',],
'northwide'=>['th',],
'norėjai'=>['lt',],
'norėjau'=>['lt',],
'norėjo'=>['lt',],
'norėtum'=>['lt',],
'norėčiau'=>['lt',],
'nos'=>['ca','es','fr','gl','hu','la','pt','pt_br',],
'nosa'=>['gl',],
'nosaltres'=>['ca',],
'nosas'=>['gl',],
'nosi'=>['bs','sr',],
'noso'=>['gl',],
'nosos'=>['gl',],
'nosotros'=>['es',],
'nossa'=>['pt','pt_br',],
'nossas'=>['pt','pt_br',],
'nosso'=>['pt','pt_br',],
'nossos'=>['pt','pt_br',],
'nost'=>['lv',],
'noster'=>['la',],
'nostra'=>['ca','it','la',],
'nostrae'=>['la',],
'nostram'=>['la',],
'nostre'=>['ca','it',],
'nostres'=>['ca',],
'nostri'=>['it','la',],
'nostris'=>['la',],
'nostro'=>['it','la',],
'nostru'=>['ro',],
'nostrum'=>['la',],
'not'=>['en','fa','si','th',],
'nota'=>['is',],
'noteikti'=>['lv',],
'noter'=>['sl',],
'nothing'=>['en','si',],
'noticias'=>['es',],
'noticis'=>['lv',],
'noticēt'=>['lv',],
'notiek'=>['lv',],
'notika'=>['lv',],
'notiks'=>['lv',],
'notre'=>['fr',],
'notri'=>['sl',],
'notte'=>['it',],
'notícias'=>['pt','pt_br',],
'notícies'=>['ca',],
'nou'=>['af','ca','nl','ro',],
'noua'=>['la','ro',],
'noui'=>['la',],
'nous'=>['fr',],
'nouse'=>['fi',],
'nouveau'=>['fr',],
'nouvelle'=>['fr',],
'nouvelles'=>['fr',],
'nouă'=>['ro',],
'nov'=>['sl',],
'nova'=>['bs','ca','gl','hr','la','pt','pt_br','sr',],
'novac'=>['bs','hr','sr',],
'novamente'=>['pt','pt_br',],
'novas'=>['gl',],
'novca'=>['bs','hr','sr',],
'novega'=>['sl',],
'novela'=>['gl',],
'novi'=>['bs','hr','la','sl','sr',],
'novia'=>['es',],
'novo'=>['gl','pt','pt_br','sl',],
'novos'=>['gl',],
'nové'=>['cs','sk',],
'nový'=>['cs','sk',],
'now'=>['en','fa','si','th',],
'nowa'=>['pl',],
'nowe'=>['pl',],
'nowego'=>['pl',],
'nowy'=>['pl',],
'nowym'=>['pl',],
'nozīmē'=>['lv',],
'noël'=>['fr',],
'noć'=>['bs','hr',],
'noći'=>['bs','hr',],
'noč'=>['sl',],
'noče'=>['sl',],
'nočem'=>['sl',],
'nočeš'=>['sl',],
'noştri'=>['ro',],
'noж'=>['bs','sr',],
'noжi'=>['sr',],
'nu'=>['da','lv','nl','no','ro','sv',],
'nuelako'=>['eu',],
'nuen'=>['eu',],
'nuestra'=>['es',],
'nuestras'=>['es',],
'nuestro'=>['es',],
'nuestros'=>['es',],
'nueva'=>['es',],
'nuevo'=>['es',],
'nuit'=>['fr',],
'nuk'=>['sq',],
'nukkumaan'=>['fi',],
'nuklir'=>['id',],
'nulla'=>['it','la',],
'nullam'=>['la',],
'nullo'=>['la',],
'nullum'=>['la',],
'nullus'=>['la',],
'num'=>['la','pt','pt_br',],
'numa'=>['pt','pt_br',],
'numai'=>['ro',],
'numara'=>['tr',],
'number'=>['en','et','si',],
'nume'=>['ro',],
'numele'=>['ro',],
'numer'=>['pl',],
'numeris'=>['lt',],
'numero'=>['fi','it','la',],
'numerum'=>['la',],
'numerus'=>['la',],
'nummer'=>['da','de','nb','nl','no','sv',],
'numquam'=>['la',],
'numquid'=>['la',],
'numéro'=>['fr',],
'numër'=>['sq',],
'numărul'=>['ro',],
'nun'=>['de','gl',],
'nunc'=>['la',],
'nunca'=>['es','gl','pt','pt_br',],
'nunha'=>['gl',],
'nuo'=>['fi','lt',],
'nuori'=>['fi',],
'nuostabi'=>['lt',],
'nuostabu'=>['lt',],
'nuostabus'=>['lt',],
'nuova'=>['it',],
'nuovo'=>['it',],
'nur'=>['de',],
'nusiramink'=>['lt',],
'nutiko'=>['lt',],
'nuus'=>['af',],
'nuwe'=>['af',],
'nuž'=>['sk',],
'nužudyti'=>['lt',],
'nužudė'=>['lt',],
'nxjerr'=>['sq',],
'ny'=>['da','nb','no','sv',],
'nya'=>['id','ms','sv',],
'nyata'=>['id','ms',],
'nydelig'=>['nb','no',],
'nye'=>['da','nb','no',],
'nyheter'=>['sv',],
'nyisd'=>['hu',],
'nyní'=>['cs',],
'nyomás'=>['hu',],
'nyonya'=>['ms',],
'nyt'=>['da','fi',],
'nytt'=>['nb','no','sv',],
'nyugalom'=>['hu',],
'nyugi'=>['hu',],
'nyugodtan'=>['hu',],
'ná'=>['is',],
'náhodou'=>['cs','sk',],
'nájsť'=>['sk',],
'nákvæmlega'=>['is',],
'nálam'=>['hu',],
'nálægt'=>['is',],
'nám'=>['cs','sk',],
'námi'=>['cs',],
'nápad'=>['cs','sk',],
'nás'=>['cs','sk',],
'náð'=>['is',],
'náði'=>['is',],
'náðu'=>['is',],
'náš'=>['cs','sk',],
'nášho'=>['sk',],
'não'=>['pt','pt_br',],
'nächste'=>['de',],
'nächsten'=>['de',],
'näe'=>['et','fi',],
'näeb'=>['et',],
'näed'=>['et',],
'näeme'=>['et',],
'näen'=>['et','fi',],
'näet'=>['fi',],
'näete'=>['et',],
'näetkö'=>['fi',],
'nägema'=>['et',],
'nägemist'=>['et',],
'nägi'=>['et',],
'nägid'=>['et',],
'nägin'=>['et',],
'nägu'=>['et',],
'näha'=>['et',],
'nähdä'=>['fi',],
'nähdään'=>['fi',],
'nähnyt'=>['fi',],
'näidata'=>['et',],
'näin'=>['fi',],
'näinud'=>['et',],
'näita'=>['et',],
'näitan'=>['et',],
'näiteks'=>['et',],
'näitä'=>['fi',],
'näkemiin'=>['fi',],
'nämä'=>['fi',],
'näo'=>['pt',],
'när'=>['sv',],
'nära'=>['sv',],
'nästa'=>['sv',],
'nästan'=>['sv',],
'näyttää'=>['fi',],
'näytä'=>['fi',],
'näytän'=>['fi',],
'näytät'=>['fi',],
'nå'=>['da','nb','no','sv',],
'någon'=>['sv',],
'någonsin'=>['sv',],
'någonting'=>['sv',],
'något'=>['sv',],
'några'=>['sv',],
'nån'=>['sv',],
'nånsin'=>['sv',],
'nånstans'=>['sv',],
'nånting'=>['sv',],
'når'=>['da','nb','no',],
'nåt'=>['sv',],
'næ'=>['is',],
'nær'=>['is','nb','no',],
'næst'=>['is',],
'næsta'=>['is',],
'næste'=>['da',],
'næsten'=>['da',],
'næstu'=>['is',],
'næstum'=>['is',],
'né'=>['is','it',],
'négy'=>['hu',],
'néha'=>['hu',],
'néhány'=>['hu',],
'nélkül'=>['hu',],
'néz'=>['hu',],
'nézd'=>['hu',],
'nézel'=>['hu',],
'nézz'=>['hu',],
'nézze'=>['hu',],
'nézzétek'=>['hu',],
'nézzük'=>['hu',],
'në'=>['sq',],
'nën'=>['sq',],
'nëna'=>['sq',],
'nënë'=>['sq',],
'nëpër'=>['sq',],
'nëse'=>['sq',],
'ní'=>['cs',],
'ním'=>['cs','sk',],
'níu'=>['is',],
'nóg'=>['is',],
'nógu'=>['is',],
'nós'=>['gl','pt','pt_br',],
'nótt'=>['is',],
'nõus'=>['et',],
'nød'=>['da',],
'nødt'=>['da','nb','no',],
'nú'=>['is',],
'númer'=>['is',],
'número'=>['ca','es','gl','pt','pt_br',],
'núna'=>['is',],
'nüüd'=>['et',],
'ný'=>['is',],
'nýja'=>['is',],
'nýtt'=>['is',],
'nāc'=>['lv',],
'nāciet'=>['lv',],
'nāk'=>['lv',],
'nāve'=>['lv',],
'nāves'=>['lv',],
'nāvi'=>['lv',],
'nē'=>['lv',],
'nė'=>['lt',],
'nėra'=>['lt',],
'ně'=>['cs',],
'něco'=>['cs',],
'něj'=>['cs',],
'nějak'=>['cs',],
'nějakou'=>['cs',],
'nějaká'=>['cs',],
'nějaké'=>['cs',],
'nějaký'=>['cs',],
'někam'=>['cs',],
'někde'=>['cs',],
'někdo'=>['cs',],
'někdy'=>['cs',],
'někoho'=>['cs',],
'několik'=>['cs',],
'něm'=>['cs',],
'nő'=>['hu',],
'nők'=>['hu',],
'nőt'=>['hu',],
'nə'=>['az',],
'nəzarətçi'=>['az',],
'nαι'=>['el',],
'o'=>['af','az','bg','bs','ca','cs','da','de','el','en','es','fr','gl','hr','it','la','lt','lv','nl','pl','pt','pt_br','ro','si','sk','sl','sq','sr','sv','th','tr','zh_tw',],
'oameni'=>['ro',],
'oamenii'=>['ro',],
'oamenilor'=>['ro',],
'oară'=>['ro',],
'ob'=>['de','la','sl',],
'oba'=>['cs','sl',],
'obaja'=>['sk',],
'obat'=>['ms',],
'obchod'=>['sk',],
'obchodzi'=>['pl',],
'oben'=>['de',],
'oberst'=>['da','nb',],
'obeèavam'=>['hi',],
'obeèavaš'=>['hi',],
'obeжavam'=>['sr',],
'obicei'=>['ro',],
'obiecuję'=>['pl',],
'obitelj'=>['hr',],
'obitelji'=>['hr',],
'obiиno'=>['sr',],
'objectiu'=>['ca',],
'objek'=>['id',],
'obljubim'=>['sl',],
'oboje'=>['bs','hr','sr',],
'obok'=>['pl',],
'obra'=>['gl',],
'obras'=>['gl',],
'obraz'=>['sl',],
'obre'=>['ca',],
'obrigada'=>['pt','pt_br',],
'obrigado'=>['pt','pt_br',],
'obstaja'=>['sl',],
'obxectivo'=>['gl',],
'obxecto'=>['gl',],
'občutek'=>['sl',],
'oca'=>['bs','hr','sr',],
'ocasión'=>['gl',],
'ocasións'=>['gl',],
'occhi'=>['it',],
'occhiata'=>['it',],
'occhio'=>['it',],
'occupe'=>['fr',],
'occuper'=>['fr',],
'och'=>['pl','sk','sv',],
'ochi'=>['ro',],
'ochii'=>['ro',],
'ocho'=>['es',],
'oci'=>['sk',],
'ocko'=>['sk',],
'också'=>['sv',],
'oculis'=>['la',],
'oculos'=>['la',],
'ocurre'=>['es',],
'oczy'=>['pl',],
'oczywiście'=>['pl',],
'od'=>['bs','cs','hr','pl','sk','sl','sr',],
'oda'=>['hu','tr',],
'odakle'=>['bs','hr','sr',],
'odată'=>['ro',],
'odavde'=>['bs','hr','sr',],
'ode'=>['cs','pl','sr',],
'odeio'=>['pt_br',],
'odejít'=>['cs',],
'odejść'=>['pl',],
'odem'=>['bs','sr',],
'odemo'=>['sr',],
'oder'=>['de',],
'odešel'=>['cs',],
'odeљ'=>['sr',],
'odgodiš'=>['hi',],
'odgovor'=>['bs','hr','sr',],
'odio'=>['es','it',],
'oditi'=>['sl',],
'odišiel'=>['sk',],
'odkar'=>['sl',],
'odkedy'=>['sk',],
'odkiaľ'=>['sk',],
'odkud'=>['cs',],
'odlazi'=>['hr','sr',],
'odlično'=>['bs','hr','sl',],
'odliиno'=>['sr',],
'odmah'=>['bs','hr','sr',],
'odo'=>['sk',],
'odola'=>['eu',],
'odoletan'=>['eu',],
'odota'=>['fi',],
'odotan'=>['fi',],
'odottaa'=>['fi',],
'odottakaa'=>['fi',],
'odpoveď'=>['sk',],
'odpri'=>['sl',],
'odsud'=>['cs',],
'odtiaľ'=>['sk',],
'odtiaľto'=>['sk',],
'odtud'=>['cs',],
'odvesti'=>['hr',],
'odísť'=>['sk',],
'odšel'=>['sl',],
'odšla'=>['sl',],
'oe'=>['af',],
'oeps'=>['af',],
'of'=>['af','en','fa','is','ms','nl','si','sk','th',],
'ofan'=>['is',],
'off'=>['en','id','ms','si','th',],
'offer'=>['en',],
'office'=>['en','si',],
'officer'=>['en','si',],
'offre'=>['fr',],
'oficial'=>['ca','es','gl','pt_br',],
'oficina'=>['ca','es',],
'oft'=>['de','is',],
'ofta'=>['sv',],
'ofte'=>['nb','no',],
'often'=>['en',],
'og'=>['da','is','nb','no',],
'ogen'=>['nl',],
'ogenj'=>['sl',],
'oggi'=>['it',],
'ogni'=>['it',],
'også'=>['da','nb','no',],
'ogóle'=>['pl',],
'oh'=>['af','bs','ca','cs','da','de','en','es','et','fa','fr','hr','hu','id','it','lt','lv','ms','nl','pl','pt','pt_br','ro','si','sk','sl','sq','sr','sv','th','tr',],
'ohea'=>['eu',],
'ohh'=>['si',],
'ohi'=>['fi',],
'ohitura'=>['eu',],
'ohne'=>['de',],
'oho'=>['lt',],
'ohorezko'=>['eu',],
'oi'=>['ca','et','lt','pt','pt_br',],
'oikea'=>['fi',],
'oikeassa'=>['fi',],
'oikeastaan'=>['fi',],
'oikeasti'=>['fi',],
'oikein'=>['fi',],
'oinak'=>['eu',],
'oito'=>['gl','pt',],
'oj'=>['sv',],
'ojca'=>['pl',],
'ojcem'=>['pl',],
'ojciec'=>['pl',],
'ojcze'=>['pl',],
'ojos'=>['es',],
'ok'=>['af','bs','cs','da','de','en','es','et','fi','fr','hr','hu','it','lt','ms','nb','nl','no','pl','pt','pt_br','ro','si','sk','sl','sq','sr','sv','th',],
'okamžite'=>['sk',],
'okamžitě'=>['cs',],
'okay'=>['cs','da','de','en','fa','it','ms','nb','no','pl','si','sk','th',],
'okazji'=>['pl',],
'oke'=>['id','ms','nl',],
'okei'=>['et','fi',],
'okej'=>['sk','sr','sv',],
'oker'=>['eu',],
'okertzen'=>['eu',],
'okkar'=>['is',],
'okkur'=>['is',],
'oko'=>['bs','hr','sr',],
'okoli'=>['sl',],
'okolo'=>['bs','sk',],
'okos'=>['hu',],
'około'=>['pl',],
'okrem'=>['sk',],
'okreæi'=>['hi',],
'oksigen'=>['id',],
'okt'=>['az',],
'okul'=>['tr',],
'oké'=>['hu','nl',],
'ol'=>['tr',],
'olabilir'=>['tr',],
'olacak'=>['tr',],
'olacaksın'=>['tr',],
'olacağım'=>['tr',],
'olacağını'=>['tr',],
'olah'=>['id',],
'olamaz'=>['tr',],
'olan'=>['az','tr',],
'olar'=>['az',],
'olarak'=>['tr',],
'olaraq'=>['az',],
'olası'=>['tr',],
'olay'=>['tr',],
'old'=>['en','th',],
'oldu'=>['tr',],
'oldukça'=>['tr',],
'oldum'=>['tr',],
'olduğu'=>['az','tr',],
'olduğum'=>['tr',],
'olduğumu'=>['tr',],
'olduğun'=>['tr',],
'olduğuna'=>['tr',],
'olduğunu'=>['az','tr',],
'ole'=>['et','fi',],
'oled'=>['et',],
'oleh'=>['id','ms',],
'olekin'=>['fi',],
'oleks'=>['et',],
'oleksid'=>['et',],
'oleksin'=>['et',],
'olema'=>['et',],
'olemaan'=>['fi',],
'olemas'=>['et',],
'olemassa'=>['fi',],
'oleme'=>['et',],
'olemme'=>['fi',],
'olen'=>['et','fi',],
'olenko'=>['fi',],
'olet'=>['fi',],
'olete'=>['et',],
'oletko'=>['fi',],
'olette'=>['fi',],
'oletteko'=>['fi',],
'olevan'=>['fi',],
'olevat'=>['et',],
'olge'=>['et',],
'olgu'=>['et',],
'olha'=>['pt','pt_br',],
'olhada'=>['pt_br',],
'olhando'=>['pt_br',],
'olhar'=>['pt','pt_br',],
'olhe'=>['pt','pt_br',],
'olhem'=>['pt',],
'olho'=>['pt','pt_br',],
'olhos'=>['pt','pt_br',],
'oli'=>['et','fi',],
'olid'=>['et',],
'olika'=>['sv',],
'oliko'=>['fi',],
'olim'=>['la',],
'olime'=>['et',],
'olimme'=>['fi',],
'olin'=>['et','fi',],
'olisi'=>['fi',],
'olisin'=>['fi',],
'olisit'=>['fi',],
'olit'=>['fi',],
'olivat'=>['fi',],
'olkaa'=>['fi',],
'olkoon'=>['fi',],
'olla'=>['et','fi',],
'ollaan'=>['fi',],
'olleet'=>['fi',],
'ollos'=>['gl',],
'ollut'=>['fi',],
'olma'=>['tr',],
'olmadan'=>['tr',],
'olmadı'=>['tr',],
'olmadığını'=>['tr',],
'olmak'=>['tr',],
'olmalı'=>['tr',],
'olmalısın'=>['tr',],
'olması'=>['tr',],
'olmasın'=>['tr',],
'olmasını'=>['tr',],
'olmaya'=>['tr',],
'olmayacak'=>['tr',],
'olmayan'=>['tr',],
'olmaz'=>['tr',],
'olmuş'=>['tr',],
'olmuşdur'=>['az',],
'olnud'=>['et',],
'olor'=>['ca',],
'olsa'=>['tr',],
'olsaydı'=>['tr',],
'olsun'=>['az','tr',],
'oltre'=>['it',],
'olub'=>['az',],
'olun'=>['tr',],
'olunur'=>['az',],
'olup'=>['tr',],
'olur'=>['az','tr',],
'olurdu'=>['tr',],
'olursa'=>['tr',],
'oluyor'=>['tr',],
'olyan'=>['hu',],
'olá'=>['pt','pt_br',],
'om'=>['af','da','nb','nl','no','ro','sv',],
'oma'=>['et','fi','nl',],
'oman'=>['fi',],
'omdat'=>['af','nl',],
'omeny'=>['lt',],
'ometi'=>['et',],
'omhoog'=>['nl',],
'omicidio'=>['it',],
'omkring'=>['da','sv',],
'omlouvám'=>['cs',],
'omne'=>['la',],
'omnem'=>['la',],
'omnes'=>['la',],
'omni'=>['la',],
'omnia'=>['la',],
'omnibus'=>['la',],
'omnino'=>['la',],
'omnis'=>['la',],
'omnium'=>['la',],
'omoare'=>['ro',],
'omong'=>['ms',],
'omor'=>['ro',],
'omorât'=>['ro',],
'omul'=>['ro',],
'omule'=>['ro',],
'on'=>['bs','ca','cs','en','et','eu','fa','fi','fr','hr','ms','pl','si','sk','sl','sr','th','tr',],
'ona'=>['az','bs','cs','eu','hr','pl','sk','sl','sr','tr',],
'onaj'=>['bs','hr','sr',],
'onbewaak'=>['af',],
'once'=>['en',],
'oncle'=>['ca','fr',],
'oncologist'=>['si',],
'onda'=>['bs','hr','sr',],
'ondan'=>['tr',],
'onde'=>['gl','pt','pt_br',],
'onder'=>['af','nl',],
'onderwyser'=>['af',],
'onderzoek'=>['nl',],
'ondje'=>['hr',],
'ondo'=>['eu',],
'ondoratu'=>['eu',],
'ondorengoaren'=>['eu',],
'ondorengorik'=>['eu',],
'ondorioak'=>['eu',],
'ondt'=>['da',],
'one'=>['bs','en','fa','hr','pl','si','sr','th',],
'onena'=>['eu',],
'ones'=>['en',],
'ongelma'=>['fi',],
'ongelmia'=>['fi',],
'ongelooflike'=>['af',],
'ongeluk'=>['nl',],
'ongeskik'=>['af',],
'ongeveer'=>['af','nl',],
'ongi'=>['et','eu',],
'oni'=>['bs','cs','hr','pl','sk','sl','sr',],
'onkel'=>['da','de','nb','no',],
'onkin'=>['fi',],
'onko'=>['fi',],
'onlangs'=>['af',],
'onlar'=>['az','tr',],
'onlara'=>['tr',],
'onlardan'=>['tr',],
'onlarla'=>['tr',],
'onları'=>['tr',],
'onların'=>['az','tr',],
'only'=>['en','th',],
'onmogelijk'=>['nl',],
'onnan'=>['hu',],
'onnea'=>['fi',],
'onneksi'=>['fi',],
'onnellinen'=>['fi',],
'ono'=>['bs','cs','hr','sk','sr',],
'onog'=>['bs','hr','sr',],
'onore'=>['it',],
'onpa'=>['fi',],
'onrein'=>['af',],
'ons'=>['af','nl',],
'ont'=>['ca','fr','sv',],
'ontbyt'=>['af',],
'onte'=>['gl',],
'ontem'=>['pt','pt_br',],
'onthou'=>['af',],
'ontmoet'=>['af','nl',],
'ontmoeten'=>['nl',],
'onu'=>['az','et','tr',],
'onun'=>['az','tr',],
'onunla'=>['tr',],
'onv'=>['af',],
'onze'=>['nl',],
'onzin'=>['nl',],
'oo'=>['et',],
'oodake'=>['et',],
'oodata'=>['et',],
'oog'=>['af','nl',],
'ooh'=>['en',],
'ooit'=>['af','nl',],
'ook'=>['af','nl',],
'oom'=>['nl',],
'oop'=>['af',],
'oopgemaak'=>['af',],
'oor'=>['af',],
'oorgebly'=>['af',],
'oorlog'=>['af','nl',],
'oorsprong'=>['af',],
'oortuig'=>['af',],
'oorweeg'=>['af',],
'oota'=>['et',],
'ootab'=>['et',],
'ootan'=>['et',],
'op'=>['af','da','nl','no',],
'open'=>['en','nl',],
'openbaar'=>['af',],
'opera'=>['la',],
'operasi'=>['id',],
'opere'=>['la',],
'opet'=>['bs','hr','sr',],
'opgestaan'=>['af',],
'opinión'=>['gl',],
'opna'=>['is',],
'opnaðu'=>['is',],
'opnieuw'=>['nl',],
'oportere'=>['la',],
'oportet'=>['la',],
'oportunidad'=>['es',],
'oportunidade'=>['pt',],
'oportunitat'=>['ca',],
'oposición'=>['gl',],
'opp'=>['nb','no',],
'oppe'=>['da','nb','no',],
'oppidum'=>['la',],
'opptatt'=>['nb','no',],
'opravdu'=>['cs',],
'opri'=>['ro',],
'oprosti'=>['bs','hr','sl','sr',],
'oprostite'=>['bs','hr','sl','sr',],
'opsanije'=>['hi',],
'opsnog'=>['hi',],
'optog'=>['af',],
'opus'=>['la',],
'opwinding'=>['af',],
'opäť'=>['sk',],
'or'=>['ca','en','fr','si','sq','th',],
'ora'=>['eu','it','pt','ro','sq',],
'orada'=>['tr',],
'oradan'=>['tr',],
'orain'=>['eu',],
'oraindik'=>['eu',],
'oraingoan'=>['eu',],
'orang'=>['id','ms',],
'orası'=>['tr',],
'oratio'=>['la',],
'oratione'=>['la',],
'oraya'=>['tr',],
'oraz'=>['pl',],
'oraş'=>['ro',],
'oraşul'=>['ro',],
'orbit'=>['id',],
'orchestrating'=>['hi',],
'ord'=>['da','nb','no','sv',],
'orde'=>['gl','nl',],
'ordem'=>['pt','pt_br',],
'orden'=>['da','es','nb','no',],
'ordens'=>['pt','pt_br',],
'order'=>['en','sv',],
'orders'=>['en','th',],
'ordine'=>['it','la','ro',],
'ordinem'=>['la',],
'ordini'=>['it',],
'ordna'=>['sv',],
'ordne'=>['da','nb','no',],
'ordnung'=>['de',],
'ordre'=>['ca','fr','nb','no',],
'ordres'=>['ca','fr',],
'ordu'=>['eu',],
'ordua'=>['eu',],
'orduan'=>['eu',],
'ordutan'=>['eu',],
'ore'=>['it','la','ro','sq',],
'org'=>['fi','pl',],
'organisme'=>['id',],
'organización'=>['gl',],
'organize'=>['si',],
'ori'=>['ro',],
'orice'=>['ro',],
'oricine'=>['ro',],
'oricum'=>['ro',],
'orion'=>['id',],
'orixe'=>['gl',],
'ormai'=>['it',],
'oro'=>['es','lt',],
'oroa'=>['sv',],
'oroitgarri'=>['eu',],
'orolig'=>['sv',],
'orospu'=>['tr',],
'orožje'=>['sl',],
'ort'=>['de',],
'ortaya'=>['tr',],
'oružje'=>['bs','hr',],
'oruћje'=>['sr',],
'orvos'=>['hu',],
'orwaardelike'=>['af',],
'orë'=>['sq',],
'orën'=>['sq',],
'orð'=>['is',],
'orðinn'=>['is',],
'orðið'=>['is',],
'oră'=>['ro',],
'os'=>['da','es','gl','la','no','pt','pt_br',],
'osa'=>['et','fi',],
'osaa'=>['fi',],
'osaba'=>['eu',],
'ose'=>['sq',],
'osebno'=>['sl',],
'oseжaj'=>['sr',],
'oseжam'=>['sr',],
'oseжaљ'=>['sr',],
'osim'=>['bs','hr','sr',],
'osjaèam'=>['hi',],
'osjeèaš'=>['hi',],
'osjećam'=>['bs','hr',],
'oska'=>['et',],
'oso'=>['eu',],
'osoa'=>['eu',],
'osoan'=>['eu',],
'osoba'=>['bs','hr','sr',],
'osobno'=>['hr',],
'ospedale'=>['it',],
'oss'=>['nb','no','sv',],
'osta'=>['et',],
'ostaa'=>['fi',],
'ostal'=>['sl',],
'ostala'=>['sl',],
'ostali'=>['bs','hr','sl','sr',],
'ostalo'=>['bs','hr','sl','sr',],
'ostani'=>['bs','hr','sl','sr',],
'ostati'=>['bs','hr','sl','sr',],
'ostatni'=>['pl',],
'ostatnie'=>['pl',],
'ostatnio'=>['pl',],
'ostatní'=>['cs',],
'ostavi'=>['bs','hr','sr',],
'ostavio'=>['bs','hr','sr',],
'ostaviti'=>['bs','hr',],
'ostres'=>['ca',],
'ot'=>['hu',],
'ota'=>['fi',],
'otac'=>['bs','hr','sr',],
'otak'=>['id','ms',],
'otan'=>['fi',],
'otca'=>['sk',],
'otce'=>['cs',],
'otec'=>['cs','sk',],
'otevři'=>['cs',],
'other'=>['en','si',],
'others'=>['en',],
'otići'=>['bs','hr',],
'otišao'=>['bs','hr',],
'otišla'=>['hr',],
'otiжi'=>['sr',],
'otiљao'=>['sr',],
'otiљla'=>['sr',],
'oto'=>['pl',],
'otra'=>['es','lv',],
'otras'=>['es',],
'otro'=>['es',],
'otroci'=>['sl',],
'otrok'=>['sl',],
'otroka'=>['sl',],
'otroke'=>['sl',],
'otroligt'=>['sv',],
'otros'=>['es',],
'otru'=>['lv',],
'otrā'=>['lv',],
'otsa'=>['et',],
'otse'=>['et',],
'otsin'=>['et',],
'ott'=>['hu',],
'ottaa'=>['fi',],
'ottakaa'=>['fi',],
'otte'=>['da',],
'otthon'=>['hu',],
'ottimo'=>['it',],
'otto'=>['it',],
'otur'=>['tr',],
'otvor'=>['sk',],
'otvori'=>['bs','hr','sr',],
'otwórz'=>['pl',],
'otázka'=>['sk',],
'otče'=>['cs',],
'ou'=>['af','fr','gl','pt','pt_br',],
'ouais'=>['fr',],
'oublie'=>['fr',],
'oublier'=>['fr',],
'oublié'=>['fr',],
'oud'=>['af','nl',],
'oude'=>['nl',],
'ouders'=>['nl',],
'ouer'=>['af',],
'oui'=>['fr','th',],
'our'=>['en','th',],
'ourense'=>['gl',],
'ouro'=>['pt','pt_br',],
'out'=>['af','en','fa','ms','si','th',],
'outnumbered'=>['hi',],
'outoa'=>['fi',],
'outra'=>['gl','pt','pt_br',],
'outras'=>['gl','pt','pt_br',],
'outro'=>['gl','pt','pt_br',],
'outros'=>['gl','pt','pt_br',],
'outside'=>['en',],
'ouve'=>['pt',],
'ouvi'=>['pt','pt_br',],
'ouvindo'=>['pt_br',],
'ouvir'=>['pt','pt_br',],
'ouviu'=>['pt','pt_br',],
'ouvre'=>['fr',],
'ouwe'=>['nl',],
'ouça'=>['pt','pt_br',],
'ova'=>['bs','hr','sr',],
'ovaj'=>['bs','hr','sr',],
'ovako'=>['bs','hr','sr',],
'ovamo'=>['bs','hr','sr',],
'ovat'=>['fi',],
'ovatko'=>['fi',],
'ovde'=>['bs','sr',],
'ovdje'=>['bs','hr',],
'ove'=>['bs','hr','sr',],
'over'=>['da','en','nb','nl','no','si','th',],
'overal'=>['nl',],
'overalt'=>['nb','no',],
'overcome'=>['si',],
'overhovedet'=>['da',],
'oveľa'=>['sk',],
'ovi'=>['bs','fi','hr','sr',],
'ovih'=>['bs','hr','sr',],
'ovim'=>['bs','hr','sr',],
'ovo'=>['bs','hr','sr',],
'ovog'=>['bs','hr','sr',],
'ovoga'=>['bs','hr','sr',],
'ovoj'=>['bs','hr','sr',],
'ovom'=>['bs','hr','sr',],
'ovome'=>['bs','hr','sr',],
'ovu'=>['bs','hr','sr',],
'ovuda'=>['bs','hr','sr',],
'owen'=>['si',],
'own'=>['en',],
'oye'=>['es',],
'oyun'=>['az','tr',],
'ozbiljno'=>['bs','hr','sr',],
'oznacza'=>['pl',],
'oído'=>['es',],
'oír'=>['es',],
'où'=>['fr',],
'oče'=>['sl',],
'očeta'=>['sl',],
'oči'=>['bs','cs','hr','sk','sl',],
'očitno'=>['sl',],
'očka'=>['sl',],
'oğlu'=>['az',],
'oğlum'=>['tr',],
'oиe'=>['sr',],
'oиi'=>['sr',],
'oรซ'=>['af',],
'p'=>['lt','si',],
'pa'=>['af','bs','ca','da','hr','lv','nb','nl','no','pl','ro','sl','sq','sr','sv',],
'paar'=>['af','de','et','nl',],
'paard'=>['nl',],
'pabaiga'=>['lt',],
'pabba'=>['is',],
'pabbi'=>['is',],
'pacar'=>['ms',],
'pace'=>['it','la','ro',],
'pacem'=>['la',],
'pad'=>['af',],
'pada'=>['id','ms',],
'padaku'=>['ms',],
'padamu'=>['ms',],
'padanya'=>['ms',],
'padarei'=>['lt',],
'padariau'=>['lt',],
'padaryk'=>['lt',],
'padarysiu'=>['lt',],
'padaryti'=>['lt',],
'padarė'=>['lt',],
'padat'=>['id',],
'padomā'=>['lv',],
'padre'=>['es','it','pt','pt_br',],
'padres'=>['es',],
'padėk'=>['lt',],
'padėkit'=>['lt',],
'padėkite'=>['lt',],
'padėti'=>['lt',],
'paene'=>['la',],
'paese'=>['it',],
'paga'=>['lv',],
'pagaidi'=>['lv',],
'pagaidiet'=>['lv',],
'pagaidām'=>['lv',],
'pagal'=>['lt',],
'pagalbos'=>['lt',],
'pagaliau'=>['lt',],
'pagan'=>['et',],
'pagar'=>['ca','es','pt','pt_br',],
'pagare'=>['it',],
'pagi'=>['ms',],
'paguaj'=>['sq',],
'paha'=>['et','fi',],
'pahlawan'=>['ms',],
'pahoillani'=>['fi',],
'pai'=>['eu','gl','pt','pt_br','ro',],
'paid'=>['en',],
'paigal'=>['et',],
'paik'=>['eu',],
'paikalla'=>['fi',],
'paikan'=>['fi',],
'paikea'=>['eu',],
'paikearen'=>['eu',],
'paikka'=>['fi',],
'paimk'=>['lt',],
'paimsiu'=>['lt',],
'paimti'=>['lt',],
'pain'=>['en',],
'painu'=>['fi',],
'paio'=>['it',],
'pairatuko'=>['eu',],
'paire'=>['ca',],
'pairen'=>['eu',],
'pais'=>['gl','pt','pt_br',],
'paistab'=>['et',],
'paitsi'=>['fi',],
'paix'=>['fr',],
'paj'=>['sq',],
'pak'=>['cs','ms','nl','sq',],
'paka'=>['eu',],
'pakai'=>['ms',],
'pakaian'=>['ms',],
'pakak'=>['eu',],
'pakalbėti'=>['lt',],
'pakankamai'=>['lt',],
'pakaren'=>['eu',],
'pakarentzat'=>['eu',],
'pakaļ'=>['lv',],
'pakeisti'=>['lt',],
'pakken'=>['nl',],
'pakko'=>['fi',],
'paklau'=>['lv',],
'paklausti'=>['lt',],
'paklausyk'=>['lt',],
'paktën'=>['sq',],
'pala'=>['lt',],
'palaa'=>['fi',],
'palabra'=>['es','gl',],
'palabras'=>['es','gl',],
'palata'=>['fi',],
'palauk'=>['lt',],
'palaukit'=>['lt',],
'palaukite'=>['lt',],
'palavra'=>['pt','pt_br',],
'palavras'=>['pt','pt_br',],
'paldies'=>['lv',],
'paleisk'=>['lt',],
'paliec'=>['lv',],
'paliek'=>['lv',],
'palik'=>['lt',],
'paliko'=>['lt',],
'palikt'=>['lv',],
'palikti'=>['lt',],
'paling'=>['id','ms',],
'paljon'=>['fi',],
'paljonko'=>['fi',],
'palju'=>['et',],
'palun'=>['et',],
'palīdzi'=>['lv',],
'palīdziet'=>['lv',],
'palīdzēt'=>['lv',],
'palīdzība'=>['lv',],
'palīdzību'=>['lv',],
'palīgā'=>['lv',],
'paman'=>['ms',],
'pamaniau'=>['lt',],
'pamatuješ'=>['cs',],
'pamatyti'=>['lt',],
'pamiętam'=>['pl',],
'pamiętasz'=>['pl',],
'pamätáš'=>['sk',],
'pan'=>['cs','pl',],
'pana'=>['cs','pl','ro',],
'panas'=>['id','ms',],
'panašaus'=>['lt',],
'panašu'=>['lt',],
'pandangan'=>['id',],
'pane'=>['cs','et','sk',],
'paneb'=>['et',],
'panele'=>['lt',],
'panem'=>['pl',],
'panen'=>['et',],
'pange'=>['et',],
'panggil'=>['ms',],
'panggilan'=>['ms',],
'pani'=>['et','pl','sk',],
'panie'=>['pl',],
'panią'=>['pl',],
'panjang'=>['id','ms',],
'panna'=>['et',],
'panno'=>['pl',],
'panowie'=>['pl',],
'pantai'=>['id','ms',],
'panu'=>['pl',],
'paní'=>['cs',],
'pao'=>['is',],
'pap'=>['nl',],
'papa'=>['de','fr','hu','it','nl','si',],
'papai'=>['pt_br',],
'papasakok'=>['lt',],
'papel'=>['es','gl','pt','pt_br',],
'paper'=>['ca','en','si',],
'pappa'=>['af','nb','no','sv',],
'paprasta'=>['lt',],
'paprastai'=>['lt',],
'papà'=>['ca','it',],
'papá'=>['es','pt',],
'par'=>['bs','da','es','fr','hr','la','lv','nb','no','sl','sr','sv',],
'para'=>['ca','es','gl','id','ms','pt','pt_br','sq','tr','zh_tw',],
'parabéns'=>['pt','pt_br',],
'parar'=>['ca','pt','pt_br',],
'paras'=>['fi',],
'parasta'=>['fi',],
'parasti'=>['lv',],
'parasysh'=>['sq',],
'parata'=>['eu',],
'paratë'=>['sq',],
'paraula'=>['ca',],
'paraules'=>['ca',],
'parayı'=>['tr',],
'parce'=>['fr',],
'parcă'=>['ro',],
'pardon'=>['fr','nl','tr',],
'pare'=>['bs','ca','eu','it','pt','pt_br','ro','sq','sr',],
'parece'=>['es','gl','pt','pt_br',],
'parecia'=>['pt_br',],
'parecía'=>['gl',],
'pareil'=>['fr',],
'pareizi'=>['lv',],
'parell'=>['ca',],
'parem'=>['et','pt',],
'paremini'=>['et',],
'paremmin'=>['fi',],
'parempi'=>['fi',],
'parents'=>['en','fr',],
'pares'=>['ca',],
'parfait'=>['fr',],
'parfois'=>['fr',],
'pari'=>['fi','sq',],
'parim'=>['et',],
'paris'=>['da','de','en','fr','nb','no','pt_br',],
'pariter'=>['la',],
'parla'=>['ca','it',],
'parlamento'=>['gl',],
'parlando'=>['it',],
'parlant'=>['ca',],
'parlar'=>['ca',],
'parlare'=>['it',],
'parlat'=>['ca',],
'parlato'=>['it',],
'parle'=>['fr',],
'parler'=>['fr',],
'parles'=>['ca','fr',],
'parlez'=>['fr',],
'parli'=>['it',],
'parlé'=>['fr',],
'parodyk'=>['lt',],
'parodysiu'=>['lt',],
'parodyti'=>['lt',],
'parola'=>['it',],
'parole'=>['it',],
'parroquia'=>['gl',],
'pars'=>['fr','la',],
'parson'=>['af',],
'part'=>['ca','en','fr','si',],
'parte'=>['es','gl','it','la','pt','pt_br','ro',],
'partea'=>['eu','ro',],
'partem'=>['la',],
'partes'=>['es','gl','la',],
'parti'=>['fr','it','tr',],
'partibus'=>['la',],
'participación'=>['gl',],
'partido'=>['gl',],
'partidos'=>['gl',],
'partie'=>['fr',],
'partikel'=>['id',],
'partim'=>['la',],
'partir'=>['ca','fr','gl','pt','pt_br',],
'partit'=>['ca',],
'partita'=>['it',],
'partout'=>['fr',],
'party'=>['de','en','th',],
'parum'=>['la',],
'parunāt'=>['lv',],
'parçası'=>['tr',],
'parë'=>['sq',],
'parādi'=>['lv',],
'parę'=>['pl',],
'pas'=>['ca','da','fr','hr','lt','nl','sq','sr',],
'pasa'=>['es','gl',],
'pasado'=>['es','gl',],
'pasakei'=>['lt',],
'pasaki'=>['lv',],
'pasakiau'=>['lt',],
'pasako'=>['eu',],
'pasakyk'=>['lt',],
'pasakysi'=>['lt',],
'pasakysiu'=>['lt',],
'pasakyti'=>['lt',],
'pasakė'=>['lt',],
'pasando'=>['es',],
'pasang'=>['id',],
'pasar'=>['es','gl',],
'pasatu'=>['eu',],
'pasatzen'=>['eu',],
'pasaule'=>['lv',],
'pasaules'=>['lv',],
'pasauli'=>['lv',],
'pasaulio'=>['lt',],
'pasaulis'=>['lt',],
'pasaulyje'=>['lt',],
'pasaulē'=>['lv',],
'pasaulį'=>['lt',],
'pase'=>['es',],
'pashë'=>['sq',],
'pasi'=>['sq',],
'pasifik'=>['id',],
'pasiimti'=>['lt',],
'pasikalbėti'=>['lt',],
'pasilikti'=>['lt',],
'pasiruošęs'=>['lt',],
'pasitrauk'=>['lt',],
'pask'=>['et',],
'paska'=>['fi',],
'paskaa'=>['fi',],
'paskambinti'=>['lt',],
'paskat'=>['fi','lv',],
'paskaties'=>['lv',],
'paskiainen'=>['fi',],
'paskubėk'=>['lt',],
'paskui'=>['lt',],
'paskutinis'=>['lt',],
'paskutinį'=>['lt',],
'paso'=>['es','gl',],
'pasos'=>['gl',],
'pasou'=>['gl',],
'pass'=>['de','en','nb','no',],
'passa'=>['ca','pt','pt_br',],
'passado'=>['pt','pt_br',],
'passant'=>['ca',],
'passar'=>['ca','pt','pt_br','sv',],
'passare'=>['it',],
'passarà'=>['ca',],
'passat'=>['ca',],
'passato'=>['it',],
'passe'=>['da','fr','nb','no',],
'passer'=>['da','fr','nb','no',],
'passi'=>['ca',],
'passieren'=>['de',],
'passiert'=>['de',],
'passo'=>['it',],
'passou'=>['pt','pt_br',],
'passt'=>['de',],
'passé'=>['fr',],
'past'=>['en',],
'pastaj'=>['sq',],
'pasti'=>['id','ms',],
'pastër'=>['sq',],
'pastāsti'=>['lv',],
'pasukan'=>['ms',],
'pasur'=>['sq',],
'pasó'=>['es',],
'pasă'=>['ro',],
'pat'=>['lt','lv','ro',],
'pateicos'=>['lv',],
'pateikt'=>['lv',],
'pateikšu'=>['lv',],
'pater'=>['la',],
'pati'=>['lt','lv',],
'patiesi'=>['lv',],
'patiesība'=>['lv',],
'patiesību'=>['lv',],
'patiesībā'=>['lv',],
'patiešām'=>['lv',],
'patika'=>['lv',],
'patiko'=>['lt',],
'patikėk'=>['lt',],
'patikėti'=>['lt',],
'patinka'=>['lt',],
'patjetër'=>['sq',],
'patootie'=>['si',],
'patre'=>['la',],
'patrem'=>['la',],
'patres'=>['la',],
'patriae'=>['la',],
'patris'=>['la',],
'patron'=>['fr','tr',],
'patru'=>['ro',],
'patrz'=>['pl',],
'pats'=>['lt','lv',],
'patys'=>['lt',],
'patīk'=>['lv',],
'patį'=>['lt',],
'patří'=>['cs',],
'pau'=>['ca',],
'paucis'=>['la',],
'paul'=>['da','en','es','fr','hu','is','nb','nl','no','pt','pt_br','ro','sv','tr',],
'paulo'=>['la',],
'paura'=>['it',],
'paus'=>['id',],
'pauvre'=>['fr',],
'pavisam'=>['lv',],
'pavyko'=>['lt',],
'pavyks'=>['lt',],
'pay'=>['en','si',],
'payer'=>['fr',],
'pays'=>['fr',],
'paz'=>['es','gl','pt','pt_br',],
'pazi'=>['bs','hr','sl','sr',],
'pazientzia'=>['eu',],
'pazzo'=>['it',],
'pazīstu'=>['lv',],
'país'=>['ca','es','gl','pt','pt_br',],
'países'=>['gl',],
'paò'=>['is',],
'pač'=>['sl',],
'paņem'=>['lv',],
'paša'=>['lv',],
'pašam'=>['lv',],
'paši'=>['lv',],
'pašlaik'=>['lv',],
'pašu'=>['lv',],
'pašā'=>['lv',],
'pažiūrėk'=>['lt',],
'pažiūrėkit'=>['lt',],
'pažiūrėti'=>['lt',],
'pažvelk'=>['lt',],
'pbc'=>['si',],
'pe'=>['ro','sq',],
'pea'=>['et',],
'peaaegu'=>['et',],
'peab'=>['et',],
'peace'=>['en',],
'pead'=>['et',],
'peaks'=>['et',],
'peaksid'=>['et',],
'peaksime'=>['et',],
'peaksin'=>['et',],
'peal'=>['et',],
'peale'=>['et',],
'pealegi'=>['et',],
'pealt'=>['et',],
'peame'=>['et',],
'pean'=>['et',],
'peanut'=>['si',],
'peate'=>['et',],
'peavad'=>['et',],
'peccato'=>['it',],
'pecunia'=>['la',],
'pecuniam'=>['la',],
'pedes'=>['la',],
'pedig'=>['hu',],
'pedir'=>['pt','pt_br',],
'pediu'=>['pt_br',],
'pedra'=>['ca','gl',],
'pedro'=>['gl',],
'peduli'=>['id','ms',],
'peepin'=>['af',],
'pegar'=>['pt','pt_br',],
'peggio'=>['it',],
'pegou'=>['pt_br',],
'pegue'=>['pt_br',],
'peguei'=>['pt_br',],
'peine'=>['fr',],
'pek'=>['tr',],
'pekala'=>['tr',],
'pekerjaan'=>['id','ms',],
'peki'=>['tr',],
'pekla'=>['sk',],
'pekne'=>['sk',],
'pekné'=>['sk',],
'pekný'=>['sk',],
'pekâlâ'=>['tr',],
'pel'=>['ca','gl',],
'pela'=>['pt','pt_br',],
'pelacur'=>['ms',],
'pelas'=>['pt','pt_br',],
'pelastaa'=>['fi',],
'pelkää'=>['fi',],
'pelo'=>['es','pt','pt_br',],
'pelos'=>['pt','pt_br',],
'pels'=>['ca',],
'peluru'=>['id',],
'película'=>['es','gl',],
'pemahaman'=>['id',],
'pembentukan'=>['id',],
'pembunuh'=>['ms',],
'pembunuhan'=>['ms',],
'pemerintah'=>['id','ms',],
'pemimpin'=>['id',],
'pen'=>['nb','no',],
'pena'=>['ca','es','pt','pt_br',],
'penampakan'=>['id',],
'penas'=>['gl',],
'pencarian'=>['id',],
'pendant'=>['fr',],
'pendapat'=>['id',],
'penelitian'=>['id',],
'penemuan'=>['id',],
'pengalaman'=>['id',],
'pengamatan'=>['id',],
'pengar'=>['sv',],
'pengarna'=>['sv',],
'penge'=>['da',],
'pengene'=>['da','nb','no',],
'penger'=>['nb','no',],
'pengetahuan'=>['id',],
'penggunaan'=>['id',],
'peniaze'=>['sk',],
'peninga'=>['is',],
'peningana'=>['is',],
'penjaga'=>['ms',],
'penjara'=>['ms',],
'penjelasan'=>['id',],
'penki'=>['lt',],
'pensa'=>['ca','it','pt','pt_br',],
'pensaba'=>['es',],
'pensais'=>['fr',],
'pensamento'=>['gl',],
'pensando'=>['es','it','pt_br',],
'pensant'=>['ca',],
'pensar'=>['ca','es','gl','pt','pt_br',],
'pensare'=>['it',],
'pensas'=>['pt',],
'pensat'=>['ca',],
'pensato'=>['it',],
'pensava'=>['ca','pt',],
'pensavo'=>['it',],
'pense'=>['fr','pt_br',],
'pensei'=>['pt','pt_br',],
'penser'=>['fr',],
'penses'=>['ca','fr',],
'pensez'=>['fr',],
'pensi'=>['it',],
'penso'=>['ca','gl','it','pt','pt_br',],
'pensé'=>['es','fr',],
'pent'=>['nb','no',],
'penting'=>['id','ms',],
'pentru'=>['ro',],
'pentsatu'=>['eu',],
'pentsatzea'=>['eu',],
'pentsatzen'=>['eu',],
'penuh'=>['id','ms',],
'peníze'=>['cs',],
'peněz'=>['cs',],
'people'=>['en',],
'peor'=>['es','gl',],
'pequena'=>['gl','pt','pt_br',],
'pequeno'=>['gl','pt','pt_br',],
'pequeña'=>['es',],
'pequeño'=>['es',],
'per'=>['af','ca','id','it','la','lt','nl','sq',],
'peradaban'=>['id',],
'peran'=>['id',],
'perang'=>['id','ms',],
'perasaan'=>['ms',],
'perbedaan'=>['id',],
'perc'=>['hu',],
'percaya'=>['id','ms',],
'percet'=>['hu',],
'perche'=>['it',],
'perchè'=>['it',],
'perché'=>['it',],
'perder'=>['es','pt','pt_br',],
'perdere'=>['it',],
'perdeu'=>['pt_br',],
'perdi'=>['pt_br',],
'perdido'=>['es',],
'perdona'=>['ca',],
'perdoni'=>['ca',],
'perdre'=>['ca','fr',],
'perdu'=>['fr',],
'perdut'=>['ca',],
'perdó'=>['ca',],
'perdón'=>['es',],
'pere'=>['et',],
'perekond'=>['et',],
'perempuan'=>['id','ms',],
'perfect'=>['en','nl','ro','th',],
'perfecte'=>['ca',],
'perfecto'=>['es',],
'perfeito'=>['pt','pt_br',],
'perfekt'=>['da','nb','no','sv',],
'perfekte'=>['af',],
'perfetto'=>['it',],
'performed'=>['th',],
'pergi'=>['id','ms',],
'pergilah'=>['ms',],
'pergunta'=>['pt','pt_br',],
'perguntar'=>['pt','pt_br',],
'perguntas'=>['pt','pt_br',],
'perhaps'=>['en',],
'perhatian'=>['id','ms',],
'periculo'=>['la',],
'periculum'=>['la',],
'periksa'=>['ms',],
'perilaku'=>['id',],
'perill'=>['ca',],
'perillós'=>['ca',],
'perintah'=>['ms',],
'periode'=>['id',],
'peristiwa'=>['id',],
'perjalanan'=>['id','ms',],
'perlu'=>['id','ms',],
'permainan'=>['ms',],
'permesso'=>['it',],
'permisi'=>['ms',],
'permiso'=>['es',],
'permite'=>['gl',],
'permukaan'=>['id',],
'permís'=>['ca',],
'pernah'=>['id','ms',],
'pernikahan'=>['ms',],
'pero'=>['es','gl',],
'perquè'=>['ca',],
'perqué'=>['ca',],
'perra'=>['es',],
'perro'=>['es',],
'persamaan'=>['id',],
'perse'=>['et',],
'persis'=>['id',],
'perso'=>['it',],
'persoa'=>['gl',],
'persoal'=>['gl',],
'persoană'=>['ro',],
'persoas'=>['gl',],
'person'=>['da','en','nb','no','sq','sv',],
'persona'=>['ca','es','it',],
'personal'=>['ca','es','ro',],
'personas'=>['es',],
'persone'=>['it',],
'persones'=>['ca',],
'personlig'=>['nb',],
'personne'=>['fr',],
'personnel'=>['th',],
'personnes'=>['fr',],
'persoon'=>['nl',],
'perspektief'=>['af',],
'persse'=>['et',],
'persze'=>['hu',],
'pertahanan'=>['id',],
'pertama'=>['id','ms',],
'pertambangan'=>['id',],
'pertanyaan'=>['id','ms',],
'pertemuan'=>['ms',],
'pertinet'=>['la',],
'perto'=>['pt','pt_br',],
'peru'=>['id',],
'perubahan'=>['id','ms',],
'perusahaan'=>['id','ms',],
'período'=>['gl',],
'però'=>['ca','it',],
'pes'=>['sk','sl',],
'pesan'=>['id','ms',],
'pesar'=>['gl',],
'pesawat'=>['id','ms',],
'pesca'=>['gl',],
'pesem'=>['sl',],
'pesetas'=>['gl',],
'peso'=>['gl',],
'pessoa'=>['pt','pt_br',],
'pessoal'=>['pt','pt_br',],
'pessoas'=>['pt','pt_br',],
'pesta'=>['ms',],
'peste'=>['ro',],
'pesë'=>['sq',],
'pet'=>['bs','hr','sl','sr',],
'pete'=>['th',],
'peter'=>['da','ms','nb','nl','no','sv','tr',],
'petit'=>['ca','fr',],
'petita'=>['ca',],
'petite'=>['fr',],
'petits'=>['fr',],
'petrecere'=>['ro',],
'petta'=>['is',],
'petunjuk'=>['id',],
'peu'=>['fr',],
'peuple'=>['fr',],
'peur'=>['fr',],
'peus'=>['ca',],
'peut'=>['fr',],
'peuvent'=>['fr',],
'peux'=>['fr',],
'pewien'=>['pl',],
'pewna'=>['pl',],
'pewnego'=>['pl',],
'pewnie'=>['pl',],
'pewno'=>['pl',],
'pezzo'=>['it',],
'peça'=>['pt_br',],
'peço'=>['pt',],
'peňazí'=>['sk',],
'phone'=>['en','si',],
'photo'=>['fr',],
'photos'=>['fr',],
'phpbb'=>['az',],
'pi'=>['sq',],
'pia'=>['si',],
'piacciono'=>['it',],
'piace'=>['it',],
'piacere'=>['it',],
'piacerebbe'=>['it',],
'pian'=>['fi',],
'piano'=>['it',],
'pic'=>['ro',],
'piccola'=>['it',],
'piccolo'=>['it',],
'picioare'=>['ro',],
'pick'=>['en','th',],
'picsába'=>['hu',],
'picture'=>['en',],
'pidanud'=>['et',],
'pidi'=>['et',],
'pidin'=>['et',],
'pidu'=>['et',],
'pidä'=>['fi',],
'pidän'=>['fi',],
'pidät'=>['fi',],
'pidätkö'=>['fi',],
'pie'=>['es','lv',],
'piece'=>['en',],
'pieci'=>['lv',],
'pied'=>['fr',],
'pieder'=>['lv',],
'piedi'=>['it',],
'piedod'=>['lv',],
'piedodiet'=>['lv',],
'pieds'=>['fr',],
'piekfyn'=>['af',],
'piemēram'=>['lv',],
'pieni'=>['fi',],
'pieniądze'=>['pl',],
'pieniędzy'=>['pl',],
'pieno'=>['it',],
'piensa'=>['es',],
'piensas'=>['es',],
'pienso'=>['es',],
'pierde'=>['ro',],
'pierdut'=>['ro',],
'pierwsza'=>['pl',],
'pierwsze'=>['pl',],
'pierwszy'=>['pl',],
'pies'=>['es',],
'pietiek'=>['lv',],
'pietiekami'=>['lv',],
'pietiks'=>['lv',],
'pietų'=>['lt',],
'pig'=>['is',],
'pige'=>['da',],
'pigen'=>['da',],
'piger'=>['da',],
'pihta'=>['et',],
'piisavalt'=>['et',],
'pijačo'=>['sl',],
'pije'=>['sq',],
'pijn'=>['nl',],
'pikali'=>['et',],
'pikir'=>['id','ms',],
'pikiran'=>['id','ms',],
'pikirkan'=>['ms',],
'pikk'=>['et',],
'pikku'=>['fi',],
'pikë'=>['sq',],
'pikërisht'=>['sq',],
'pilihan'=>['ms',],
'pillanat'=>['hu',],
'pilnībā'=>['lv',],
'pilnīgi'=>['lv',],
'pilo'=>['eu',],
'pilsētā'=>['lv',],
'pindah'=>['ms',],
'pinigai'=>['lt',],
'pinigus'=>['lt',],
'pinigų'=>['lt',],
'pinjaman'=>['id',],
'pintar'=>['ms',],
'pintu'=>['ms',],
'pior'=>['pt','pt_br',],
'piramida'=>['id',],
'pire'=>['fr',],
'piring'=>['id',],
'pirma'=>['lt',],
'pirmais'=>['lv',],
'pirmas'=>['lt',],
'pirmo'=>['lv',],
'pirms'=>['lv',],
'pirmyn'=>['lt',],
'pirmā'=>['lv',],
'pirmą'=>['lt',],
'pirë'=>['sq',],
'pis'=>['da',],
'pislik'=>['tr',],
'piso'=>['es',],
'pistol'=>['da','ms',],
'pistola'=>['it',],
'pistolen'=>['nb','no',],
'pistool'=>['nl',],
'pisut'=>['et',],
'pitam'=>['bs','hr','sr',],
'pitanja'=>['bs','hr','sr',],
'pitanje'=>['bs','hr','sr',],
'pitanju'=>['bs','sr',],
'pitao'=>['bs','hr','sr',],
'pitati'=>['hr',],
'piti'=>['fi',],
'pitjor'=>['ca',],
'pitkä'=>['fi',],
'pitkään'=>['fi',],
'pitäisi'=>['fi',],
'pitäkää'=>['fi',],
'pitänyt'=>['fi',],
'pitää'=>['fi',],
'piu'=>['it',],
'piuttosto'=>['it',],
'pizza'=>['si',],
'pièce'=>['fr',],
'più'=>['it',],
'piće'=>['hr',],
'piękna'=>['pl',],
'piękne'=>['pl',],
'pięć'=>['pl',],
'piše'=>['sl',],
'pištolj'=>['bs','hr',],
'pištolo'=>['sl',],
'piжe'=>['sr',],
'piљe'=>['sr',],
'piљtolj'=>['sr',],
'pjesa'=>['sq',],
'pjesë'=>['sq',],
'pjesën'=>['sq',],
'pl'=>['pl',],
'pla'=>['af','ca',],
'plaan'=>['et',],
'plaas'=>['af',],
'plaats'=>['nl',],
'plac'=>['ro',],
'place'=>['en','fr','ro',],
'placer'=>['es',],
'placet'=>['la',],
'plads'=>['da',],
'plaer'=>['ca',],
'plaisir'=>['fr',],
'plako'=>['sq',],
'plan'=>['af','bs','ca','da','de','en','es','fr','gl','hr','nb','nl','no','pl','ro','sq','sr','sv',],
'planas'=>['lt',],
'plane'=>['en','la',],
'planet'=>['id','ms','sv','th',],
'planeta'=>['ca',],
'plano'=>['gl','pt','pt_br',],
'plans'=>['ca',],
'plass'=>['nb','no',],
'platiti'=>['hr',],
'plats'=>['sv',],
'platz'=>['de',],
'plau'=>['ca',],
'play'=>['en',],
'playing'=>['en',],
'plaît'=>['fr',],
'plačal'=>['sl',],
'ple'=>['ca',],
'pleacă'=>['ro',],
'please'=>['en','fa','si',],
'pleasure'=>['en',],
'plebis'=>['la',],
'plec'=>['ro',],
'pleca'=>['ro',],
'plecat'=>['ro',],
'plece'=>['ro',],
'pleci'=>['ro',],
'plecăm'=>['ro',],
'pleeeaaase'=>['af',],
'plein'=>['fr',],
'plek'=>['af','nl',],
'plerumque'=>['la',],
'plezier'=>['nl',],
'plig'=>['af',],
'plower'=>['si',],
'pludselig'=>['da',],
'plura'=>['la',],
'plures'=>['la',],
'pluribus'=>['la',],
'plurimum'=>['la',],
'plus'=>['fr','la','ro',],
'plusieurs'=>['fr',],
'plutselig'=>['nb',],
'plutôt'=>['fr',],
'plán'=>['cs','sk',],
'plötzlich'=>['de',],
'plāns'=>['lv',],
'plăcea'=>['ro',],
'plăcere'=>['ro',],
'plăcut'=>['ro',],
'pm'=>['az',],
'po'=>['bs','cs','hr','it','lt','pl','sk','sl','sq','sr',],
'poate'=>['ro',],
'poble'=>['ca',],
'pobo'=>['gl',],
'poboación'=>['gl',],
'pobre'=>['ca','es','pt','pt_br',],
'poc'=>['ca',],
'pocit'=>['cs','sk',],
'poco'=>['es','it',],
'poczekaj'=>['pl',],
'początku'=>['pl',],
'pod'=>['bs','cs','hr','pl','sk','sl','sr',],
'podcjeniti'=>['hi',],
'podczas'=>['pl',],
'pode'=>['gl','pt','pt_br',],
'podem'=>['ca','pt','pt_br',],
'podemos'=>['es','gl','pt','pt_br',],
'poden'=>['ca','gl',],
'poder'=>['ca','es','gl','pt','pt_br',],
'poderia'=>['pt','pt_br',],
'poderá'=>['pt_br',],
'podería'=>['gl',],
'podes'=>['pt',],
'podeu'=>['ca',],
'podia'=>['ca','pt','pt_br',],
'podle'=>['cs',],
'podo'=>['gl',],
'podoba'=>['pl',],
'podria'=>['ca',],
'podries'=>['ca',],
'podría'=>['es',],
'podríamos'=>['es',],
'podrías'=>['es',],
'podríem'=>['ca',],
'podía'=>['es','gl',],
'podívat'=>['cs',],
'podívej'=>['cs',],
'podívejte'=>['cs',],
'podľa'=>['sk',],
'poeg'=>['et',],
'poftim'=>['ro',],
'pogadać'=>['pl',],
'pogaðati'=>['hi',],
'pogledaj'=>['bs','hr','sr',],
'pogledajte'=>['bs','hr','sr',],
'poglej'=>['sl',],
'poglejte'=>['sl',],
'pogut'=>['ca',],
'pogués'=>['ca',],
'pohiti'=>['sl',],
'pohode'=>['sk',],
'pohodě'=>['cs',],
'pohon'=>['id','ms',],
'pohyb'=>['cs','sk',],
'poi'=>['it',],
'poida'=>['gl',],
'poika'=>['fi',],
'poikani'=>['fi',],
'point'=>['en','fr',],
'pois'=>['fi','gl','pt','pt_br',],
'poisid'=>['et',],
'poiss'=>['et',],
'poissa'=>['fi',],
'poja'=>['et',],
'pojan'=>['fi',],
'pojat'=>['fi',],
'pojdi'=>['sl',],
'pojdimo'=>['sl',],
'pojdite'=>['sl',],
'pojdiva'=>['sl',],
'pojkar'=>['sv',],
'pojke'=>['sv',],
'pojken'=>['sv',],
'pojma'=>['bs','hr','sl','sr',],
'pojď'=>['cs',],
'pojďme'=>['cs',],
'pojďte'=>['cs',],
'pojęcia'=>['pl',],
'pokazal'=>['sl',],
'pokazati'=>['hr',],
'pokazać'=>['pl',],
'pokaż'=>['pl',],
'pokaži'=>['sl',],
'pokiaľ'=>['sk',],
'pokker'=>['nb','no',],
'poklical'=>['sl',],
'pokliči'=>['sl',],
'pokoj'=>['cs','sk',],
'pokoji'=>['cs',],
'pokoju'=>['pl',],
'pokud'=>['cs',],
'pokušavam'=>['hr',],
'pokuљao'=>['sr',],
'pokuљavam'=>['sr',],
'pokój'=>['pl',],
'pol'=>['sk','sl',],
'pola'=>['bs','gl','hr','id','sr',],
'polako'=>['bs','hr','sr',],
'polas'=>['gl',],
'pole'=>['et',],
'poleg'=>['sl',],
'polegi'=>['et',],
'poleks'=>['et',],
'polic'=>['sq',],
'police'=>['en','fr',],
'policia'=>['ca','sq',],
'policial'=>['pt_br',],
'policie'=>['cs',],
'policii'=>['cs',],
'policija'=>['bs','hr','lt','lv','sl','sr',],
'policijo'=>['sl',],
'policijos'=>['lt',],
'policiju'=>['bs','hr',],
'policja'=>['pl',],
'policji'=>['pl',],
'policía'=>['es','gl',],
'poliisi'=>['fi',],
'polis'=>['sv','tr',],
'polisen'=>['sv',],
'polisi'=>['ms',],
'polita'=>['eu',],
'politekin'=>['eu',],
'politie'=>['nl',],
'politiet'=>['da','nb','no',],
'politsei'=>['et',],
'polizei'=>['de',],
'polizia'=>['it',],
'poliţia'=>['ro',],
'polnud'=>['et',],
'polo'=>['gl',],
'polos'=>['gl',],
'polícia'=>['pt','pt_br','sk',],
'política'=>['gl',],
'políticas'=>['gl',],
'político'=>['gl',],
'políticos'=>['gl',],
'pomaga'=>['sl',],
'pomagaj'=>['sl',],
'pomagal'=>['sl',],
'pomagam'=>['sl',],
'pomagati'=>['sl',],
'pomalu'=>['cs',],
'pomaly'=>['sk',],
'pomembno'=>['sl',],
'pomeni'=>['sl',],
'pomiri'=>['sl',],
'pomo'=>['fi',],
'pomoc'=>['cs','pl','sk',],
'pomoci'=>['cs',],
'pomoct'=>['cs',],
'pomocy'=>['pl',],
'pomognem'=>['bs','sr',],
'pomozi'=>['bs','hr','sr',],
'pomoć'=>['bs','hr',],
'pomoći'=>['bs','hr',],
'pomoč'=>['sl',],
'pomoże'=>['pl',],
'pomoж'=>['bs','sr',],
'pomoжi'=>['bs','hr','sr',],
'pomysł'=>['pl',],
'pomyślałem'=>['pl',],
'pomóc'=>['pl',],
'pomóż'=>['pl',],
'pomôcť'=>['sk',],
'pomôž'=>['sk',],
'ponad'=>['pl',],
'ponai'=>['lt',],
'ponas'=>['lt',],
'pone'=>['lt',],
'ponekad'=>['bs','hr','sr',],
'poner'=>['es',],
'ponia'=>['lt',],
'ponieważ'=>['pl',],
'ponios'=>['lt',],
'ponovno'=>['hr','sl',],
'ponovo'=>['bs','hr','sr',],
'pont'=>['hu',],
'pontevedra'=>['gl',],
'ponto'=>['pt','pt_br',],
'pontosan'=>['hu',],
'pooja'=>['af',],
'pool'=>['et',],
'poole'=>['et',],
'poolt'=>['et',],
'poor'=>['en',],
'popatrz'=>['pl',],
'popolnoma'=>['sl',],
'poprvé'=>['cs',],
'popular'=>['gl',],
'populi'=>['la',],
'populo'=>['la',],
'populum'=>['la',],
'populus'=>['la',],
'poput'=>['bs','hr','sr',],
'por'=>['ca','es','gl','pt','pt_br','sq','zh_tw',],
'pora'=>['lt',],
'pored'=>['bs','hr','sr',],
'pores'=>['hi',],
'poriadku'=>['sk',],
'poriadne'=>['sk',],
'porodica'=>['bs','sr',],
'porodicu'=>['bs','sr',],
'porourangi'=>['eu',],
'porozmawiać'=>['pl',],
'porozprávať'=>['sk',],
'poročila'=>['sl',],
'porque'=>['es','gl','pt','pt_br',],
'porquê'=>['pt','pt_br',],
'porra'=>['pt','pt_br',],
'porro'=>['la',],
'porta'=>['ca','gl','it','pt','pt_br',],
'portanto'=>['pt',],
'portar'=>['ca',],
'portare'=>['it',],
'portat'=>['ca',],
'portato'=>['it',],
'porte'=>['fr',],
'porter'=>['fr',],
'portes'=>['ca',],
'porti'=>['it',],
'porto'=>['ca','gl','it',],
'portugal'=>['gl',],
'poruku'=>['bs','hr','sr',],
'porządku'=>['pl',],
'porą'=>['lt',],
'pos'=>['af',],
'posa'=>['ca',],
'posao'=>['bs','hr','sr',],
'posar'=>['ca',],
'posat'=>['ca',],
'posebno'=>['bs','hr','sr',],
'posel'=>['sl',],
'poshtë'=>['sq',],
'posibil'=>['ro',],
'posibilidade'=>['gl',],
'posibilidades'=>['gl',],
'posible'=>['es','gl',],
'posición'=>['gl',],
'posisi'=>['id','ms',],
'posição'=>['pt',],
'poskusi'=>['sl',],
'posla'=>['bs','hr','sr',],
'poslal'=>['cs','sl',],
'poslao'=>['bs','hr','sr',],
'posle'=>['sr',],
'poslednji'=>['sr',],
'posledné'=>['sk',],
'poslední'=>['cs',],
'posledný'=>['sk',],
'poslije'=>['bs','hr',],
'posljednji'=>['hr',],
'poslouchej'=>['cs',],
'poslouchejte'=>['cs',],
'poslu'=>['bs','hr','sr',],
'poslušaj'=>['sl',],
'poslušajte'=>['sl',],
'possa'=>['it','pt','pt_br',],
'posse'=>['la',],
'possent'=>['la',],
'posset'=>['la',],
'possiamo'=>['it',],
'possibile'=>['it',],
'possible'=>['ca','en','fr',],
'possint'=>['la',],
'possit'=>['la',],
'posso'=>['it','pt','pt_br',],
'possono'=>['it',],
'possum'=>['la',],
'possumus'=>['la',],
'possunt'=>['la',],
'possível'=>['pt','pt_br',],
'post'=>['la',],
'postal'=>['sl',],
'postaletako'=>['eu',],
'postao'=>['bs','hr','sr',],
'postati'=>['hr',],
'poste'=>['fr',],
'postea'=>['la',],
'posteljo'=>['sl',],
'posto'=>['gl','it',],
'postoje'=>['bs','hr','sr',],
'postoji'=>['bs','hr','sr',],
'postquam'=>['la',],
'postremo'=>['la',],
'posłuchaj'=>['pl',],
'pot'=>['ca','ro','sl',],
'pote'=>['fr',],
'potem'=>['pl','sl',],
'potensi'=>['id',],
'poter'=>['it','lv',],
'poterat'=>['la',],
'potere'=>['it',],
'potest'=>['la',],
'potestate'=>['la',],
'potestatem'=>['la',],
'potete'=>['it',],
'poteva'=>['it',],
'pothuajse'=>['sq',],
'poti'=>['ro','sl',],
'potius'=>['la',],
'potom'=>['cs','sk',],
'potongan'=>['id',],
'potpuno'=>['bs','hr','sr',],
'potreban'=>['sr',],
'potrebbe'=>['it',],
'potrebna'=>['sr',],
'potrebno'=>['bs','hr','sl','sr',],
'potrebovať'=>['sk',],
'potrebuje'=>['sk','sl',],
'potrebujem'=>['sk','sl',],
'potrebujeme'=>['sk',],
'potrebujemo'=>['sl',],
'potrebuješ'=>['sk','sl',],
'potrei'=>['it',],
'potremmo'=>['it',],
'potresti'=>['it',],
'potrzebuje'=>['pl',],
'potrzebujemy'=>['pl',],
'potrzebujesz'=>['pl',],
'potrzebuję'=>['pl',],
'pots'=>['ca',],
'potser'=>['ca',],
'potuit'=>['la',],
'potuto'=>['it',],
'potřebovat'=>['cs',],
'potřebuje'=>['cs',],
'potřebujeme'=>['cs',],
'potřebuješ'=>['cs',],
'potřebuji'=>['cs',],
'potřebuju'=>['cs',],
'pouco'=>['gl','pt','pt_br',],
'poucos'=>['gl',],
'pour'=>['fr',],
'pourquoi'=>['fr',],
'pourra'=>['fr',],
'pourrais'=>['fr',],
'pourrait'=>['fr',],
'pourtant'=>['fr',],
'pouvais'=>['fr',],
'pouvait'=>['fr',],
'pouvez'=>['fr',],
'pouvoir'=>['fr',],
'pouze'=>['cs',],
'povedal'=>['sk','sl',],
'povedala'=>['sk','sl',],
'povedali'=>['sk',],
'povedati'=>['sl',],
'povedať'=>['sk',],
'povedz'=>['sk',],
'povedzte'=>['sk',],
'povej'=>['sl',],
'povejte'=>['sl',],
'povem'=>['sl',],
'poveste'=>['ro',],
'povestea'=>['ro',],
'poveš'=>['sl',],
'poviem'=>['sk',],
'povieš'=>['sk',],
'povo'=>['pt','pt_br',],
'povsod'=>['sl',],
'poważnie'=>['pl',],
'power'=>['en',],
'powie'=>['pl',],
'powiedz'=>['pl',],
'powiedział'=>['pl',],
'powiedziała'=>['pl',],
'powiedziałam'=>['pl',],
'powiedziałem'=>['pl',],
'powiedziałeś'=>['pl',],
'powiedzieć'=>['pl',],
'powiem'=>['pl',],
'powiesz'=>['pl',],
'powinien'=>['pl',],
'powinienem'=>['pl',],
'powinieneś'=>['pl',],
'powinnam'=>['pl',],
'powinnaś'=>['pl',],
'powinniśmy'=>['pl',],
'powinno'=>['pl',],
'powodu'=>['pl',],
'powodzenia'=>['pl',],
'powrotem'=>['pl',],
'poza'=>['pl',],
'pozabi'=>['sl',],
'pozabil'=>['sl',],
'pozdravljeni'=>['sl',],
'pozdě'=>['cs',],
'později'=>['cs',],
'poziv'=>['bs','hr','sr',],
'pozna'=>['sl',],
'poznajem'=>['hr','sr',],
'poznam'=>['sl',],
'poznać'=>['pl',],
'poznaš'=>['sl',],
'pozneje'=>['sl',],
'poznám'=>['sk',],
'poznáte'=>['sk',],
'poznáš'=>['sk',],
'pozor'=>['cs','sk',],
'pozri'=>['sk',],
'pozrieť'=>['sk',],
'pozrime'=>['sk',],
'pozrite'=>['sk',],
'poztasunik'=>['eu',],
'pozwolić'=>['pl',],
'pozwól'=>['pl',],
'poèistite'=>['hi',],
'poñer'=>['gl',],
'počakaj'=>['sl',],
'počakajte'=>['sl',],
'počas'=>['sk',],
'počasi'=>['sl',],
'počkaj'=>['sk',],
'počkajte'=>['sk',],
'počkat'=>['cs',],
'počkať'=>['sk',],
'počkej'=>['cs',],
'počkejte'=>['cs',],
'počneš'=>['sl',],
'počuj'=>['sk',],
'počuješ'=>['sk',],
'počul'=>['sk',],
'počula'=>['sk',],
'počuli'=>['sk',],
'počutim'=>['sl',],
'počuť'=>['sk',],
'počúvaj'=>['sk',],
'počúvajte'=>['sk',],
'poď'=>['sk',],
'poďme'=>['sk',],
'poďte'=>['sk',],
'pořád'=>['cs',],
'pořádku'=>['cs',],
'pořádně'=>['cs',],
'poţi'=>['ro',],
'požuri'=>['hr',],
'poиeo'=>['sr',],
'poљto'=>['sr',],
'poћuri'=>['sr',],
'pp'=>['gl',],
'pr'=>['et',],
'pra'=>['gl','pt','pt_br','sq',],
'praat'=>['af','nl',],
'praca'=>['pl',],
'prachtig'=>['nl',],
'prachy'=>['cs','sk',],
'pracovat'=>['cs',],
'pracovať'=>['sk',],
'pracować'=>['pl',],
'pracuje'=>['pl',],
'pracuję'=>['pl',],
'pracy'=>['pl',],
'pracę'=>['pl',],
'pradesh'=>['af',],
'pradėjo'=>['lt',],
'pradėti'=>['lt',],
'praecipue'=>['la',],
'praegu'=>['et',],
'praesertim'=>['la',],
'praesidio'=>['la',],
'praeter'=>['la',],
'praeterea'=>['la',],
'praetor'=>['la',],
'pragtig'=>['af',],
'pragtige'=>['af',],
'prajurit'=>['ms',],
'praka'=>['eu',],
'prakeikimas'=>['lt',],
'prakeiktas'=>['lt',],
'prandaj'=>['sq',],
'pranë'=>['sq',],
'prap'=>['sq',],
'prapa'=>['sq',],
'prapë'=>['sq',],
'prasideda'=>['lt',],
'prasidėjo'=>['lt',],
'prata'=>['sv',],
'pratade'=>['sv',],
'pratar'=>['sv',],
'prate'=>['nb','no',],
'praten'=>['nl',],
'prav'=>['sl',],
'prava'=>['bs','hr','sl','sr',],
'pravda'=>['cs','sk',],
'pravdepodobne'=>['sk',],
'pravdu'=>['cs','sk',],
'pravi'=>['bs','hr','sl','sr',],
'pravijo'=>['sl',],
'pravila'=>['bs','hr','sr',],
'pravim'=>['sl',],
'praviš'=>['sl',],
'pravkar'=>['sl',],
'pravo'=>['bs','hr','sl','sr',],
'pravu'=>['bs','hr','sr',],
'pravzaprav'=>['sl',],
'prawa'=>['pl',],
'prawda'=>['pl',],
'prawdopodobnie'=>['pl',],
'prawdziwe'=>['pl',],
'prawdziwy'=>['pl',],
'prawdę'=>['pl',],
'prawie'=>['pl',],
'prawo'=>['pl',],
'praza'=>['gl',],
'prazer'=>['pt','pt_br',],
'prazo'=>['gl',],
'praėjo'=>['lt',],
'prašau'=>['lt',],
'prašom'=>['lt',],
'prdel'=>['cs',],
'prdele'=>['cs',],
'pre'=>['sk','sr',],
'prea'=>['ro',],
'precej'=>['sl',],
'precies'=>['nl',],
'preciosa'=>['ca',],
'precious'=>['ca',],
'precis'=>['sv',],
'precisa'=>['pt','pt_br',],
'precisam'=>['pt_br',],
'precisamente'=>['gl',],
'precisamos'=>['pt','pt_br',],
'precisar'=>['pt','pt_br',],
'precisas'=>['pt',],
'preciso'=>['pt','pt_br',],
'pred'=>['bs','hr','sk','sl','sr',],
'preden'=>['sl',],
'predomišljamo'=>['hi',],
'predomišljaš'=>['hi',],
'predsa'=>['sk',],
'predsednik'=>['sl',],
'predstaviť'=>['sk',],
'predtým'=>['sk',],
'prego'=>['it',],
'pregunta'=>['ca','es','gl',],
'preguntas'=>['es',],
'preguntes'=>['ca',],
'pregătit'=>['ro',],
'preili'=>['et',],
'prej'=>['sl','sq',],
'prek'=>['sq',],
'prekleti'=>['sl',],
'prekleto'=>['sl',],
'preko'=>['bs','hr','sl','sr',],
'prema'=>['bs','hr','sr',],
'premier'=>['fr',],
'premio'=>['gl',],
'première'=>['fr',],
'premtoj'=>['sq',],
'prend'=>['fr',],
'prende'=>['it',],
'prendere'=>['it',],
'prendi'=>['it',],
'prendo'=>['it',],
'prendre'=>['ca','fr',],
'prends'=>['fr',],
'prenez'=>['fr',],
'prensa'=>['gl',],
'preoccuparti'=>['it',],
'preocupe'=>['pt','pt_br',],
'preocupes'=>['es','pt',],
'preparat'=>['ca',],
'prepričan'=>['sl',],
'prepričana'=>['sl',],
'preprosto'=>['sl',],
'prepáč'=>['sk',],
'prepáčte'=>['sk',],
'prerajulisation'=>['si',],
'pres'=>['ca','sq',],
'presencia'=>['gl',],
'present'=>['en',],
'presente'=>['gl','pt','pt_br',],
'presiden'=>['id','ms',],
'president'=>['ca','en','et','nl',],
'presidente'=>['es','gl','it','pt','pt_br',],
'presidentti'=>['fi',],
'presies'=>['af',],
'presim'=>['sq',],
'presne'=>['sk',],
'preso'=>['it','pt','pt_br',],
'presque'=>['fr',],
'pressa'=>['ca',],
'prest'=>['eu',],
'prestani'=>['bs','hr','sr',],
'prestaň'=>['sk',],
'prestaňte'=>['sk',],
'presto'=>['it',],
'presó'=>['ca',],
'pret'=>['af','lv','sq',],
'pretjeruješ'=>['hi',],
'preto'=>['gl','sk',],
'pretože'=>['sk',],
'pretpostavljam'=>['bs','hr','sr',],
'pretty'=>['af','en',],
'preuzimaš'=>['hi',],
'preveč'=>['sl',],
'previše'=>['bs','hr',],
'previљe'=>['bs','sr',],
'prezo'=>['gl',],
'preč'=>['sk',],
'prečo'=>['sk',],
'pri'=>['sk','sl',],
'pria'=>['id','ms',],
'priamo'=>['sk',],
'priatelia'=>['sk',],
'priateľ'=>['sk',],
'pribadi'=>['id','ms',],
'pribilegioak'=>['eu',],
'pride'=>['sl',],
'pridem'=>['sl',],
'prideš'=>['sl',],
'pridi'=>['sl',],
'pridite'=>['sl',],
'prie'=>['fr','lt',],
'priecājos'=>['lv',],
'prieks'=>['lv',],
'priekš'=>['lv',],
'priekšu'=>['lv',],
'priekšā'=>['lv',],
'prieten'=>['ro',],
'prietena'=>['ro',],
'prietene'=>['ro',],
'prieteni'=>['ro',],
'prietenii'=>['ro',],
'prietenul'=>['ro',],
'prieš'=>['lt',],
'prigione'=>['it',],
'prihaja'=>['sl',],
'prijatelj'=>['bs','hr','sl','sr',],
'prijatelja'=>['bs','hr','sl','sr',],
'prijatelji'=>['bs','hr','sl','sr',],
'prijatelju'=>['bs','hr','sr',],
'prije'=>['bs','hr',],
'prijs'=>['nl',],
'priklauso'=>['lt',],
'priliku'=>['hr',],
'prilično'=>['hr',],
'priliиno'=>['sr',],
'priložnost'=>['sl',],
'prima'=>['it','la','nl','ro',],
'primata'=>['id',],
'primeira'=>['gl','pt','pt_br',],
'primeiras'=>['gl',],
'primeiro'=>['gl','pt','pt_br',],
'primeiros'=>['gl',],
'primer'=>['ca','es','sl',],
'primera'=>['ca','es',],
'primero'=>['es',],
'primeru'=>['sl',],
'primis'=>['la',],
'primit'=>['ro',],
'primo'=>['it','la',],
'primul'=>['ro',],
'primum'=>['la',],
'primus'=>['la',],
'prin'=>['ro',],
'princeps'=>['la',],
'princese'=>['lv',],
'principais'=>['gl',],
'principal'=>['gl',],
'principes'=>['la',],
'principi'=>['ca',],
'principio'=>['es','gl',],
'prindërit'=>['sq',],
'prinesel'=>['sl',],
'prins'=>['af','ro',],
'pripravený'=>['sk',],
'pripravljen'=>['sl',],
'pripravljena'=>['sl',],
'pripravljeni'=>['sl',],
'pris'=>['da','fr','nb','no',],
'prisa'=>['es',],
'prisahám'=>['sk',],
'prisiekiu'=>['lt',],
'prisimeni'=>['lt',],
'prisni'=>['sq',],
'prison'=>['en','fr',],
'prisão'=>['pt','pt_br',],
'prit'=>['sq',],
'priti'=>['sl',],
'pritur'=>['sq',],
'prius'=>['la','si',],
'priveşte'=>['ro',],
'prix'=>['fr',],
'priča'=>['bs','hr',],
'pričati'=>['hr',],
'pričaš'=>['bs','hr',],
'prišel'=>['sl',],
'prišiel'=>['sk',],
'prišla'=>['sk','sl',],
'prišli'=>['sk','sl',],
'prišlo'=>['sl',],
'priиa'=>['sr',],
'priиam'=>['sr',],
'priиaљ'=>['sr',],
'priиu'=>['sr',],
'pro'=>['cs','la','lt','pt_br',],
'probabil'=>['ro',],
'probabilmente'=>['it',],
'probablement'=>['ca',],
'probablemente'=>['es',],
'probably'=>['en',],
'probeer'=>['af','nl',],
'probeerde'=>['nl',],
'probeert'=>['nl',],
'proberen'=>['nl',],
'probleem'=>['af','et','nl',],
'probleeme'=>['et',],
'problem'=>['bs','da','de','en','hr','nb','no','pl','sl','sq','sr','sv',],
'problema'=>['bs','ca','es','gl','hr','it','lt','pt','pt_br','ro','sr',],
'problemas'=>['es','gl','pt','pt_br',],
'probleme'=>['af','de','ro','sq',],
'problemen'=>['nl',],
'problemer'=>['da','nb','no',],
'problemes'=>['ca',],
'problemet'=>['da','nb','no','sv',],
'problemi'=>['it','sq',],
'problems'=>['en',],
'problemy'=>['pl',],
'problemă'=>['ro',],
'problemų'=>['lt',],
'problème'=>['fr',],
'problèmes'=>['fr',],
'problém'=>['cs','sk',],
'probléma'=>['hu',],
'problémy'=>['cs','sk',],
'problēma'=>['lv',],
'problēmas'=>['lv',],
'proboha'=>['cs',],
'proceso'=>['gl',],
'prochaine'=>['fr',],
'procul'=>['la',],
'procura'=>['pt',],
'procurando'=>['pt_br',],
'procurar'=>['pt','pt_br',],
'producción'=>['gl',],
'products'=>['si',],
'produk'=>['id',],
'produksi'=>['id',],
'proelio'=>['la',],
'profecto'=>['la',],
'profectus'=>['la',],
'profesor'=>['es','gl',],
'professeur'=>['fr',],
'professor'=>['ca','en','pt','pt_br','th',],
'profeta'=>['eu',],
'program'=>['id',],
'programa'=>['ca','es','gl','pt',],
'prokletstvo'=>['bs','hr','sr',],
'prom'=>['lv',],
'prometo'=>['pt_br',],
'promijeniti'=>['hr',],
'promis'=>['fr',],
'promise'=>['en',],
'promit'=>['ro',],
'promiň'=>['cs',],
'promiňte'=>['cs',],
'promjeniš'=>['hi',],
'promluvit'=>['cs',],
'pronaći'=>['hr',],
'pronta'=>['it',],
'pronti'=>['it',],
'pronto'=>['es','it','pt','pt_br',],
'proovi'=>['et',],
'prop'=>['ca',],
'propatiš'=>['hi',],
'prope'=>['la',],
'propia'=>['es','gl',],
'propio'=>['es','gl',],
'propios'=>['gl',],
'propos'=>['fr',],
'proposta'=>['gl',],
'propre'=>['fr',],
'proprio'=>['it',],
'propter'=>['la',],
'propterea'=>['la',],
'proses'=>['af','id',],
'prosim'=>['sl',],
'prossima'=>['it',],
'prossimo'=>['it',],
'prost'=>['ro',],
'proste'=>['pl','sk',],
'prosto'=>['pl',],
'prostor'=>['sl',],
'prostu'=>['pl',],
'prostě'=>['cs',],
'proszę'=>['pl',],
'prosím'=>['cs','sk',],
'protams'=>['lv',],
'proti'=>['cs','sk','sl',],
'protiv'=>['bs','hr','sr',],
'protiviš'=>['hi',],
'proto'=>['cs','lt',],
'protože'=>['cs',],
'prou'=>['ca',],
'proua'=>['et',],
'proud'=>['en',],
'prouincia'=>['la',],
'prouinciam'=>['la',],
'prova'=>['ca','it','pt',],
'provar'=>['ca',],
'provare'=>['it',],
'provato'=>['it',],
'provavelmente'=>['pt','pt_br',],
'prove'=>['it',],
'provincia'=>['gl','la',],
'provinciam'=>['la',],
'proxecto'=>['gl',],
'proxectos'=>['gl',],
'proyek'=>['id',],
'proč'=>['cs',],
'proљle'=>['sr',],
'prueba'=>['es',],
'prva'=>['bs','hr','sl','sr',],
'prvi'=>['bs','hr','sl','sr',],
'prvič'=>['sl',],
'první'=>['cs',],
'prvo'=>['bs','hr','sl','sr',],
'prvá'=>['sk',],
'prvé'=>['sk',],
'prvý'=>['sk',],
'pryč'=>['cs',],
'przecież'=>['pl',],
'przeciwko'=>['pl',],
'przed'=>['pl',],
'przepraszam'=>['pl',],
'przestań'=>['pl',],
'przez'=>['pl',],
'przy'=>['pl',],
'przyjaciel'=>['pl',],
'przyjaciół'=>['pl',],
'przyjdzie'=>['pl',],
'przykro'=>['pl',],
'przykład'=>['pl',],
'przynajmniej'=>['pl',],
'przyszedł'=>['pl',],
'práca'=>['sk',],
'práce'=>['cs','sk',],
'práci'=>['cs','sk',],
'práctica'=>['gl',],
'prácu'=>['sk',],
'práve'=>['sk',],
'právo'=>['cs',],
'právě'=>['cs',],
'præcis'=>['da',],
'præsident'=>['da',],
'près'=>['fr',],
'présent'=>['fr',],
'président'=>['fr',],
'prêt'=>['fr',],
'prête'=>['fr',],
'prêts'=>['fr',],
'príbeh'=>['sk',],
'príde'=>['sk',],
'príliš'=>['sk',],
'príncep'=>['ca',],
'prípad'=>['sk',],
'prípade'=>['sk',],
'prísť'=>['sk',],
'própria'=>['pt','pt_br',],
'próprio'=>['pt','pt_br',],
'próxima'=>['es','pt','pt_br',],
'próximo'=>['gl','pt','pt_br',],
'prøv'=>['da','nb','no',],
'prøvd'=>['nb',],
'prøvde'=>['nb','no',],
'prøve'=>['da','nb','no',],
'prøvede'=>['da',],
'prøver'=>['da','nb','no',],
'prøvet'=>['da',],
'prý'=>['cs',],
'prātu'=>['lv',],
'prātā'=>['lv',],
'psa'=>['sl',],
'pse'=>['sq',],
'psoe'=>['gl',],
'pu'=>['fr',],
'pubblico'=>['it',],
'public'=>['en',],
'publica'=>['la',],
'publicae'=>['la',],
'publicam'=>['la',],
'puc'=>['ca',],
'pude'=>['es',],
'pudesse'=>['pt_br',],
'pudo'=>['es',],
'pueblo'=>['es',],
'pueda'=>['es',],
'puede'=>['es',],
'pueden'=>['es',],
'puedes'=>['es',],
'puedo'=>['es',],
'puerta'=>['es',],
'pues'=>['es',],
'puesto'=>['es',],
'pugui'=>['ca',],
'puhas'=>['et',],
'puhu'=>['fi',],
'puhua'=>['fi',],
'puhun'=>['fi',],
'puhut'=>['fi',],
'puhuu'=>['fi',],
'pui'=>['ro',],
'puido'=>['gl',],
'puika'=>['lv',],
'puiki'=>['lt',],
'puikiai'=>['lt',],
'puiku'=>['lt',],
'puikus'=>['lt',],
'puing'=>['id',],
'puis'=>['fr',],
'puisis'=>['lv',],
'puisse'=>['fr',],
'puiši'=>['lv',],
'pukul'=>['ms',],
'pulang'=>['ms',],
'pulau'=>['id',],
'pull'=>['en',],
'pulsar'=>['id',],
'puluh'=>['ms',],
'pun'=>['id','ms','ro',],
'puna'=>['sq',],
'punca'=>['sl',],
'puncak'=>['id',],
'punch'=>['si',],
'pune'=>['ro','sq',],
'puno'=>['bs','hr','sr',],
'punoj'=>['sq',],
'punon'=>['sq',],
'punt'=>['af','ca','nl',],
'puntan'=>['eu',],
'punto'=>['es','gl','it',],
'puntos'=>['gl',],
'punuar'=>['sq',],
'punya'=>['id','ms',],
'punë'=>['sq',],
'punën'=>['sq',],
'puoi'=>['it',],
'puolella'=>['fi',],
'puolesta'=>['fi',],
'puoli'=>['fi',],
'pur'=>['ro',],
'pure'=>['af','it',],
'pus'=>['ro',],
'pusat'=>['id','ms',],
'pushpakh'=>['af',],
'pushpakha'=>['af',],
'pusi'=>['lv',],
'pusti'=>['bs','hr','sl','sr',],
'pustil'=>['sl',],
'pustila'=>['sl',],
'pustite'=>['bs','hr','sl','sr',],
'pustiti'=>['hr',],
'pusē'=>['lv',],
'pusės'=>['lt',],
'pusę'=>['lt',],
'put'=>['bs','en','hr','sr',],
'puta'=>['bs','ca','es','hr','pt','pt_br','sr',],
'putain'=>['fr',],
'putant'=>['la',],
'pute'=>['fr',],
'putea'=>['ro',],
'puteam'=>['ro',],
'putem'=>['ro',],
'puterea'=>['ro',],
'puternic'=>['ro',],
'puteţi'=>['ro',],
'putih'=>['ms',],
'putin'=>['ro',],
'puto'=>['la',],
'putri'=>['ms',],
'puttana'=>['it',],
'putu'=>['bs','hr','sr',],
'putut'=>['ro',],
'putzu'=>['eu',],
'può'=>['it',],
'puţin'=>['ro',],
'pví'=>['is',],
'pyes'=>['sq',],
'pyetje'=>['sq',],
'pyjamas'=>['si',],
'pyn'=>['af',],
'pynlik'=>['af',],
'pysty'=>['fi',],
'pysy'=>['fi',],
'pysykää'=>['fi',],
'pysyä'=>['fi',],
'pytanie'=>['pl',],
'pyydän'=>['fi',],
'pyytää'=>['fi',],
'pá'=>['is',],
'pán'=>['sk',],
'pána'=>['sk',],
'páni'=>['cs','sk',],
'pánové'=>['cs',],
'pár'=>['cs','hu','sk',],
'pára'=>['pt',],
'párty'=>['sk',],
'páči'=>['sk',],
'pâ'=>['sv',],
'până'=>['ro',],
'päev'=>['et',],
'päeva'=>['et',],
'päeval'=>['et',],
'pähe'=>['et',],
'päin'=>['fi',],
'päivä'=>['fi',],
'päivän'=>['fi',],
'päivänä'=>['fi',],
'päivää'=>['fi',],
'pärast'=>['et',],
'päris'=>['et',],
'päriselt'=>['et',],
'pää'=>['fi',],
'päälle'=>['fi',],
'päällä'=>['fi',],
'pääse'=>['fi',],
'pääsi'=>['fi',],
'päässä'=>['fi',],
'päästa'=>['et',],
'päästä'=>['fi',],
'päť'=>['sk',],
'på'=>['da','nb','no','sv',],
'pænt'=>['da',],
'père'=>['fr',],
'pé'=>['gl','pt','pt_br',],
'például'=>['hu',],
'pénz'=>['hu',],
'pénzt'=>['hu',],
'pér'=>['is',],
'pérez'=>['gl',],
'pés'=>['pt','pt_br',],
'pëlqejnë'=>['sq',],
'pëlqen'=>['sq',],
'për'=>['sq',],
'përdor'=>['sq',],
'përktheu'=>['sq',],
'përmes'=>['sq',],
'përpara'=>['sq',],
'përse'=>['sq',],
'përshëndetje'=>['sq',],
'përsëri'=>['sq',],
'përveç'=>['sq',],
'pójdę'=>['pl',],
'pójść'=>['pl',],
'pół'=>['pl',],
'później'=>['pl',],
'późno'=>['pl',],
'pôjdem'=>['sk',],
'pôjdeme'=>['sk',],
'pôjdeš'=>['sk',],
'pôr'=>['pt',],
'pú'=>['is',],
'pública'=>['gl',],
'público'=>['gl',],
'püha'=>['et',],
'püsti'=>['et',],
'pār'=>['lv',],
'pāri'=>['lv',],
'pāris'=>['lv',],
'pārliecināts'=>['lv',],
'pārāk'=>['lv',],
'pārējie'=>['lv',],
'păi'=>['ro',],
'pământ'=>['ro',],
'părinţii'=>['ro',],
'pēc'=>['lv',],
'pēdējais'=>['lv',],
'pēdējo'=>['lv',],
'pēdējā'=>['lv',],
'pēkšņi'=>['lv',],
'pěkný'=>['cs',],
'pěkně'=>['cs',],
'pět'=>['cs',],
'pīter'=>['lv',],
'přece'=>['cs',],
'před'=>['cs',],
'představit'=>['cs',],
'předtím'=>['cs',],
'přes'=>['cs',],
'přesně'=>['cs',],
'přestaň'=>['cs',],
'při'=>['cs',],
'přijde'=>['cs',],
'přijít'=>['cs',],
'přišel'=>['cs',],
'přišla'=>['cs',],
'přišli'=>['cs',],
'přátelé'=>['cs',],
'příběh'=>['cs',],
'příliš'=>['cs',],
'přímo'=>['cs',],
'případ'=>['cs',],
'případě'=>['cs',],
'přísahám'=>['cs',],
'přítel'=>['cs',],
'půjde'=>['cs',],
'půjdeme'=>['cs',],
'půjdu'=>['cs',],
'půl'=>['cs',],
'qartë'=>['sq',],
'qarşı'=>['az',],
'qayıt'=>['az',],
'qc'=>['th',],
'qe'=>['sq',],
'qejf'=>['sq',],
'qen'=>['sq',],
'qenka'=>['sq',],
'qenë'=>['sq',],
'qepe'=>['sq',],
'qesharake'=>['sq',],
'qetë'=>['sq',],
'qetësohu'=>['sq',],
'qeydiyyatlı'=>['az',],
'qfar'=>['sq',],
'qoftë'=>['sq',],
'qonaq'=>['az',],
'qu'=>['ca',],
'qua'=>['it','la',],
'quadam'=>['la',],
'quae'=>['la',],
'quaedam'=>['la',],
'quaeque'=>['la',],
'quajnë'=>['sq',],
'qual'=>['ca','it','pt','pt_br',],
'qualche'=>['it',],
'qualcosa'=>['it',],
'qualcuno'=>['it',],
'quale'=>['it',],
'quali'=>['it',],
'qualis'=>['la',],
'qualquer'=>['pt','pt_br',],
'qualsevol'=>['ca',],
'qualsiasi'=>['it',],
'qualunque'=>['it',],
'quam'=>['la',],
'quamquam'=>['la',],
'quamuis'=>['la',],
'quan'=>['ca',],
'quand'=>['fr',],
'quando'=>['it','la','pt','pt_br',],
'quant'=>['ca',],
'quanta'=>['la',],
'quante'=>['it',],
'quantes'=>['ca',],
'quanti'=>['it',],
'quanto'=>['it','la','pt','pt_br',],
'quantos'=>['pt','pt_br',],
'quants'=>['ca',],
'quantum'=>['la',],
'quare'=>['la',],
'quarto'=>['pt','pt_br',],
'quarum'=>['la',],
'quas'=>['la',],
'quase'=>['pt','pt_br',],
'quasi'=>['it','la',],
'quatre'=>['ca','fr',],
'quatro'=>['pt','pt_br',],
'quattro'=>['it',],
'quattuor'=>['la',],
'que'=>['ca','es','fr','gl','pt','pt_br','zh_tw',],
'queda'=>['ca','es','gl',],
'quedar'=>['ca',],
'quedat'=>['ca',],
'queden'=>['ca',],
'quedou'=>['gl',],
'queen'=>['en',],
'quei'=>['it',],
'quel'=>['fr','it',],
'quelcom'=>['ca',],
'quell'=>['it',],
'quella'=>['it',],
'quelle'=>['fr','it',],
'quelli'=>['it',],
'quello'=>['it',],
'quelque'=>['fr',],
'quelques'=>['fr',],
'quem'=>['la','pt','pt_br',],
'quemadmodum'=>['la',],
'quen'=>['gl',],
'quente'=>['pt','pt_br',],
'quer'=>['pt','pt_br',],
'quere'=>['gl',],
'querem'=>['pt','pt_br',],
'queremos'=>['es','pt','pt_br',],
'querer'=>['pt','pt_br',],
'queres'=>['gl','pt',],
'queria'=>['pt','pt_br',],
'querida'=>['es','pt','pt_br',],
'querido'=>['es','pt','pt_br',],
'quero'=>['gl','pt','pt_br',],
'quería'=>['es','gl',],
'quest'=>['it',],
'questa'=>['it',],
'queste'=>['it',],
'questi'=>['it',],
'question'=>['en','fr',],
'questions'=>['en','fr',],
'questo'=>['it',],
'questão'=>['pt','pt_br',],
'quhet'=>['sq',],
'qui'=>['ca','fr','it','la',],
'quia'=>['la',],
'quibus'=>['la',],
'quibusdam'=>['la',],
'quick'=>['en',],
'quickly'=>['en',],
'quicquam'=>['la',],
'quicquid'=>['la',],
'quid'=>['la',],
'quidam'=>['la',],
'quidem'=>['la',],
'quidquid'=>['la',],
'quien'=>['es',],
'quiera'=>['es',],
'quieras'=>['es',],
'quiere'=>['es',],
'quieren'=>['es',],
'quieres'=>['es',],
'quiero'=>['es',],
'quiet'=>['en',],
'quil'=>['hi','si',],
'quileute'=>['hi',],
'quilov'=>['hi',],
'quin'=>['ca','la',],
'quina'=>['ca',],
'quindi'=>['it',],
'quinque'=>['la',],
'quins'=>['ca',],
'quippe'=>['la',],
'quis'=>['la','pt','pt_br',],
'quiser'=>['pt','pt_br',],
'quiseres'=>['pt',],
'quisiera'=>['es',],
'quisquam'=>['la',],
'quisque'=>['la',],
'quit'=>['en',],
'quite'=>['en',],
'quitter'=>['fr',],
'quixo'=>['gl',],
'quizais'=>['gl',],
'quizá'=>['es',],
'quizás'=>['es',],
'quién'=>['es',],
'quo'=>['la',],
'quod'=>['la',],
'quodam'=>['la',],
'quoi'=>['fr',],
'quomodo'=>['la',],
'quondam'=>['la',],
'quoniam'=>['la',],
'quoque'=>['la',],
'quorum'=>['la',],
'quos'=>['la',],
'què'=>['ca',],
'qué'=>['ca','es','gl',],
'quédate'=>['es',],
'quê'=>['pt','pt_br',],
'qytet'=>['sq',],
'qyteti'=>['sq',],
'që'=>['sq',],
'qëndro'=>['sq',],
'qënë'=>['sq',],
'qüestió'=>['ca',],
'qızışan'=>['az',],
'qəbul'=>['az',],
'qədər'=>['az',],
'r'=>['az','da','is','nb','no','si','sv',],
'ra'=>['hu','sq',],
'raad'=>['nl',],
'raak'=>['af','nl',],
'raar'=>['nl',],
'rabim'=>['sl',],
'racja'=>['pl',],
'rację'=>['pl',],
'raczej'=>['pl',],
'rad'=>['sl',],
'rada'=>['sk','sl',],
'radau'=>['lt',],
'rade'=>['bs','hr','sr',],
'radi'=>['bs','hr','sk','sl','sr',],
'radiasi'=>['id',],
'radim'=>['bs','hr','sr',],
'radimo'=>['bs','hr','sr',],
'radio'=>['az','bs','en','fr','gl','hr','id','it','sr',],
'radite'=>['bs','hr','sr',],
'raditi'=>['bs','hr','sr',],
'radiš'=>['bs','hr',],
'radiљ'=>['bs','hr','sr',],
'rady'=>['pl',],
'radę'=>['pl',],
'raději'=>['cs',],
'radšej'=>['sk',],
'radši'=>['cs',],
'ragae'=>['it',],
'ragazza'=>['it',],
'ragazze'=>['it',],
'ragazzi'=>['it',],
'ragazzo'=>['it',],
'ragione'=>['it',],
'raha'=>['et',],
'rahaa'=>['fi',],
'rahasia'=>['id','ms',],
'rahat'=>['fi','ro','tr',],
'rahatsız'=>['tr',],
'rahu'=>['et',],
'rahule'=>['et',],
'rahulikult'=>['et',],
'rahune'=>['et',],
'rahvas'=>['et',],
'raio'=>['pt',],
'raios'=>['pt',],
'raisk'=>['et',],
'raison'=>['fr',],
'raj'=>['si',],
'raja'=>['ms',],
'raje'=>['sl',],
'rajta'=>['hu',],
'raju'=>['si',],
'rakas'=>['fi',],
'rakastaa'=>['fi',],
'rakastan'=>['fi',],
'raken'=>['nl',],
'raksasa'=>['id',],
'rakshasa'=>['af',],
'rakshasas'=>['af',],
'rakt'=>['sv',],
'ram'=>['af',],
'rama'=>['af',],
'ramayana'=>['af',],
'rambut'=>['ms',],
'ramiai'=>['lt',],
'ramón'=>['gl',],
'ran'=>['en',],
'rangt'=>['is',],
'ranije'=>['bs','hr','sr',],
'ranik'=>['hi',],
'ranka'=>['lt',],
'rankas'=>['lt',],
'rankos'=>['lt',],
'ranką'=>['lt',],
'rano'=>['pl',],
'rany'=>['pl',],
'rapariga'=>['pt',],
'rapaz'=>['gl','pt','pt_br',],
'rapazes'=>['pt','pt_br',],
'rappelle'=>['fr',],
'rapport'=>['fr',],
'rapporto'=>['it',],
'raring'=>['sv',],
'raro'=>['es',],
'rart'=>['da','nb','no',],
'ras'=>['id',],
'rasa'=>['id','ms',],
'rasanya'=>['ms',],
'raske'=>['et',],
'raskidali'=>['hi',],
'raskt'=>['nb',],
'rast'=>['sq',],
'rasti'=>['lt',],
'rat'=>['bs','hr','si','sr',],
'rather'=>['en',],
'rathod'=>['si',],
'ratio'=>['la',],
'ratione'=>['la',],
'rationem'=>['la',],
'rato'=>['es',],
'ratusan'=>['id',],
'rau'=>['ro',],
'rauhaan'=>['fi',],
'rauhallisesti'=>['fi',],
'rauhoitu'=>['fi',],
'raus'=>['de',],
'ravan'=>['af',],
'ravana'=>['af',],
'ravno'=>['sl',],
'rawiri'=>['eu',],
'rawirik'=>['eu',],
'raz'=>['pl','sk',],
'razem'=>['pl',],
'razen'=>['sl',],
'razgovaram'=>['sr',],
'razgovarati'=>['bs','hr',],
'razie'=>['pl',],
'razlog'=>['bs','hr','sl','sr',],
'razloga'=>['bs','hr','sr',],
'razu'=>['pl',],
'razumem'=>['sl','sr',],
'razumeš'=>['sl',],
'razumeљ'=>['sr',],
'razumijem'=>['bs','hr',],
'razumiješ'=>['bs','hr',],
'razy'=>['pl',],
'razão'=>['pt','pt_br',],
'razón'=>['es','gl',],
'raó'=>['ca',],
'rağmen'=>['tr',],
're'=>['en','hu','it','la','lv','sq',],
'read'=>['en',],
'ready'=>['en',],
'real'=>['ca','en','es','gl','pt','pt_br',],
'realidad'=>['es',],
'realidade'=>['gl','pt',],
'realitat'=>['ca',],
'realizar'=>['gl',],
'really'=>['en','th',],
'realment'=>['ca',],
'realmente'=>['es','gl','pt','pt_br',],
'realtà'=>['it',],
'reason'=>['en',],
'rebus'=>['la',],
'rebut'=>['ca',],
'recht'=>['de','nl',],
'reci'=>['bs','hr','sl','sr',],
'recite'=>['bs','hr','sr',],
'record'=>['en','si',],
'recorda'=>['ca',],
'recordes'=>['ca',],
'recordo'=>['ca',],
'recte'=>['la',],
'recuerda'=>['es',],
'recuerdas'=>['es',],
'recuerdo'=>['es',],
'recursos'=>['gl',],
'red'=>['af','bs','en','hr','nl','sr','th',],
'reda'=>['sv',],
'redan'=>['sv',],
'redd'=>['nb','no',],
'redde'=>['da','nb','no',],
'redden'=>['nl',],
'reddet'=>['nb','no',],
'redding'=>['af',],
'rede'=>['af','de','gl',],
'reden'=>['de','nl',],
'redest'=>['de',],
'redo'=>['sv',],
'redu'=>['bs','hr','sl','sr',],
'redz'=>['lv',],
'redzat'=>['lv',],
'redzi'=>['lv',],
'redzu'=>['lv',],
'redzēji'=>['lv',],
'redzējis'=>['lv',],
'redzēju'=>['lv',],
'redzēt'=>['lv',],
'referencia'=>['gl',],
'refert'=>['la',],
'reg'=>['af',],
'regalo'=>['es',],
'regarde'=>['fr',],
'regarder'=>['fr',],
'regardez'=>['fr',],
'rege'=>['la',],
'regel'=>['nl',],
'regele'=>['ro',],
'regels'=>['nl',],
'regem'=>['la',],
'reges'=>['la',],
'reggel'=>['hu',],
'reggelt'=>['hu',],
'regi'=>['la',],
'regime'=>['th',],
'regis'=>['la',],
'regni'=>['la',],
'regno'=>['la',],
'regnum'=>['la',],
'regresar'=>['es',],
'regs'=>['af',],
'regte'=>['af',],
'regtig'=>['af',],
'regula'=>['ro',],
'regulă'=>['ro',],
'regverdig'=>['af',],
'rehman'=>['si',],
'rei'=>['ca','gl','la','pt','pt_br',],
'reicht'=>['de',],
'reikalas'=>['lt',],
'reikia'=>['lt',],
'reikėjo'=>['lt',],
'reikės'=>['lt',],
'reikėtų'=>['lt',],
'reilly'=>['hi',],
'rein'=>['de',],
'reina'=>['ca',],
'reine'=>['af',],
'reinheid'=>['af',],
'reiputa'=>['eu',],
'reis'=>['af','nl',],
'reise'=>['de','nb','no',],
'reiser'=>['nb','no',],
'reiz'=>['lv',],
'reizes'=>['lv',],
'reizi'=>['lv',],
'reiškia'=>['lt',],
'reja'=>['sq',],
'rejse'=>['da',],
'rejser'=>['da',],
'rekao'=>['bs','hr','sr',],
'rekel'=>['sl',],
'rekeninge'=>['af',],
'rekla'=>['bs','hr','sl','sr',],
'rekli'=>['bs','hr','sl','sr',],
'relación'=>['gl',],
'relacións'=>['gl',],
'relax'=>['en','si',],
'relação'=>['pt',],
'reliqua'=>['la',],
'relv'=>['et',],
'relva'=>['et',],
'rem'=>['la',],
'remarkable'=>['th',],
'remek'=>['hu',],
'remember'=>['en',],
'remélem'=>['hu',],
'rencana'=>['ms',],
'rencontrer'=>['fr',],
'rencontré'=>['fr',],
'rend'=>['fr',],
'rendah'=>['id',],
'rendben'=>['hu',],
'rendre'=>['fr',],
'rendőrség'=>['hu',],
'rengeteg'=>['hu',],
'rennen'=>['nl',],
'rent'=>['da',],
'rentre'=>['fr',],
'rentrer'=>['fr',],
'repede'=>['ro',],
'repente'=>['la',],
'report'=>['en',],
'reporter'=>['th',],
'reputasie'=>['af',],
'rerum'=>['la',],
'res'=>['ca','la','sl',],
'resa'=>['sv',],
'resnici'=>['sl',],
'resnico'=>['sl',],
'resnično'=>['sl',],
'resno'=>['sl',],
'respect'=>['en',],
'respecto'=>['gl',],
'respeito'=>['pt','pt_br',],
'respek'=>['af',],
'respondit'=>['la',],
'resposta'=>['ca','gl','pt','pt_br',],
'respuesta'=>['es',],
'ressemble'=>['fr',],
'rest'=>['de','en','nl',],
'resta'=>['ca','it',],
'restare'=>['it',],
'reste'=>['fr',],
'resten'=>['da','nb','no','sv',],
'rester'=>['fr',],
'restez'=>['fr',],
'resto'=>['es','gl','it','pt','pt_br',],
'restul'=>['ro',],
'resulta'=>['gl',],
'resultado'=>['gl',],
'resultados'=>['gl',],
'ret'=>['da',],
'retard'=>['fr',],
'retour'=>['fr',],
'retourner'=>['fr',],
'retrouver'=>['fr',],
'rett'=>['nb','no',],
'rette'=>['da','nb','no',],
'retten'=>['de',],
'return'=>['en',],
'reunió'=>['ca',],
'reunión'=>['gl',],
'reuşit'=>['ro',],
'revedere'=>['ro',],
'revenir'=>['fr',],
'reviens'=>['fr',],
'revoir'=>['fr',],
'rex'=>['la',],
'rey'=>['es',],
'reyna'=>['is',],
'reyndar'=>['is',],
'reyndi'=>['is',],
'reyndu'=>['is',],
'reyni'=>['is',],
'reynir'=>['is',],
'reynt'=>['is',],
'reæi'=>['bs',],
'reçu'=>['fr',],
'reći'=>['bs','hr',],
'reče'=>['sl',],
'rečem'=>['sl',],
'reči'=>['sl',],
'rešil'=>['sl',],
'reжi'=>['bs','hr','sr',],
'reи'=>['sr',],
'reиi'=>['sr',],
'reรซl'=>['af',],
'reรซn'=>['af',],
'reรซnboog'=>['af',],
'reรซndruppels'=>['af',],
'rhea'=>['id',],
'ri'=>['sq',],
'riba'=>['gl',],
'ribu'=>['id',],
'ribuan'=>['id',],
'ricevuto'=>['it',],
'rich'=>['en',],
'richtig'=>['de',],
'richtige'=>['de',],
'rick'=>['af',],
'ricorda'=>['it',],
'ricordi'=>['it',],
'ricordo'=>['it',],
'ride'=>['en',],
'ridjimiraril'=>['ca',],
'rien'=>['fr',],
'riesco'=>['it',],
'right'=>['da','en','fa','si','th',],
'rigtig'=>['da',],
'rigtige'=>['da',],
'rigtigt'=>['da',],
'riittää'=>['fi',],
'rij'=>['nl',],
'rijden'=>['nl',],
'rijeæi'=>['hi',],
'riječ'=>['hr',],
'riječi'=>['hr',],
'rijk'=>['nl',],
'riktig'=>['nb','no','sv',],
'riktiga'=>['sv',],
'riktigt'=>['sv',],
'rimtai'=>['lt',],
'ring'=>['af','da','en','nb','no','sv',],
'ringa'=>['sv',],
'ringde'=>['sv',],
'ringe'=>['da','nb','no',],
'ringede'=>['da',],
'ringer'=>['da','nb','no','sv',],
'ringi'=>['et',],
'ringte'=>['nb','no',],
'rio'=>['pt','pt_br',],
'rire'=>['fr',],
'risco'=>['gl',],
'rispetto'=>['it',],
'risposta'=>['it',],
'risque'=>['fr',],
'rit'=>['sl',],
'ritardo'=>['it',],
'riti'=>['sk',],
'rituele'=>['af',],
'riu'=>['ca',],
'river'=>['en',],
'rivier'=>['af',],
'rizvan'=>['si',],
'ro'=>['da','nb','no','ro',],
'road'=>['en',],
'roba'=>['ca','it',],
'robar'=>['ca',],
'robi'=>['pl',],
'robia'=>['sk',],
'robil'=>['sk',],
'robimy'=>['pl',],
'robisz'=>['pl',],
'robią'=>['pl',],
'robić'=>['pl',],
'robię'=>['pl',],
'robiť'=>['sk',],
'robota'=>['pl',],
'roboty'=>['pl',],
'robí'=>['sk',],
'robím'=>['sk',],
'robíte'=>['sk',],
'robíš'=>['sk',],
'rock'=>['en','th',],
'rodina'=>['cs','sk',],
'rodinu'=>['cs','sk',],
'rodiny'=>['sk',],
'rodiče'=>['cs',],
'rodičia'=>['sk',],
'rodríguez'=>['gl',],
'rodzice'=>['pl',],
'rodzina'=>['pl',],
'rodziny'=>['pl',],
'roemryke'=>['af',],
'rog'=>['ro',],
'rogue'=>['si',],
'rohadt'=>['hu',],
'rohkem'=>['et',],
'roi'=>['fr',],
'rok'=>['cs','pl','sk',],
'rokas'=>['lv',],
'roke'=>['sl',],
'rokmi'=>['sk',],
'roko'=>['sl',],
'rokov'=>['sk',],
'roku'=>['lv','pl','sk',],
'roky'=>['cs','sk',],
'rokās'=>['lv',],
'rolig'=>['da','nb','no',],
'roligt'=>['da','sv',],
'roll'=>['sv',],
'rolle'=>['nb','no',],
'rom'=>['nb','no',],
'romae'=>['la',],
'romam'=>['la',],
'romani'=>['la',],
'romanis'=>['la',],
'romano'=>['la',],
'romanorum'=>['la',],
'romanos'=>['la',],
'romanum'=>['la',],
'romanus'=>['la',],
'rommet'=>['nb','no',],
'rond'=>['af','nl',],
'ronde'=>['af',],
'rondom'=>['af',],
'rooidag'=>['af',],
'room'=>['en','si',],
'root'=>['si',],
'ropa'=>['es',],
'rosa'=>['gl',],
'rosalie'=>['hi',],
'rossz'=>['hu',],
'rosszul'=>['hu',],
'rost'=>['ro',],
'rosto'=>['pt_br',],
'rostro'=>['gl',],
'rot'=>['nl',],
'rouge'=>['fr',],
'round'=>['en',],
'roupa'=>['pt','pt_br',],
'roupas'=>['pt_br',],
'route'=>['fr',],
'rouva'=>['fi',],
'rover'=>['th',],
'rovnako'=>['sk',],
'rovno'=>['sk',],
'royce'=>['hi','si',],
'roze'=>['lv',],
'rozmawiać'=>['pl',],
'rozprávať'=>['sk',],
'rozumiem'=>['pl','sk',],
'rozumiesz'=>['pl',],
'rozumieš'=>['sk',],
'rozumím'=>['cs',],
'rozumíš'=>['cs',],
'rregull'=>['sq',],
'rreth'=>['sq',],
'rrezik'=>['sq',],
'rri'=>['sq',],
'rritur'=>['sq',],
'rruga'=>['sq',],
'rrugë'=>['sq',],
'rrugën'=>['sq',],
'rrugës'=>['sq',],
'rs'=>['si',],
'rua'=>['pt','pt_br',],
'ruang'=>['id','ms',],
'ruangan'=>['ms',],
'ruce'=>['cs',],
'rue'=>['fr',],
'ruf'=>['de',],
'rufe'=>['de',],
'rufen'=>['de',],
'rug'=>['af','nl',],
'ruhe'=>['de',],
'ruhig'=>['de',],
'ruim'=>['pt_br',],
'ruimte'=>['nl',],
'ruke'=>['bs','hr','sr',],
'rukou'=>['cs',],
'ruku'=>['bs','cs','hr','sk','sr',],
'ruky'=>['sk',],
'rum'=>['de','sv',],
'rumah'=>['id','ms',],
'rumit'=>['id',],
'rummet'=>['sv',],
'rumore'=>['it',],
'run'=>['en','si','th',],
'runa'=>['lv',],
'rundt'=>['da','nb','no',],
'running'=>['en',],
'runt'=>['sv',],
'runter'=>['de',],
'runtuh'=>['id',],
'runā'=>['lv',],
'runāju'=>['lv',],
'runāt'=>['lv',],
'ruokaa'=>['fi',],
'rural'=>['gl',],
'rursus'=>['la',],
'rust'=>['nl',],
'rustig'=>['nl',],
'ruszaj'=>['pl',],
'ruszać'=>['pl',],
'ruttu'=>['et',],
'ry'=>['af',],
'rychle'=>['cs',],
'ryger'=>['da',],
'ryggen'=>['nb',],
'rytas'=>['lt',],
'ryte'=>['lt',],
'ryto'=>['lt',],
'rytoj'=>['lt',],
'rzecz'=>['pl',],
'rzeczy'=>['pl',],
'ràdio'=>['ca',],
'ràpid'=>['ca',],
'rá'=>['hu',],
'rád'=>['cs','hu','sk',],
'ráda'=>['cs',],
'rádi'=>['cs',],
'rám'=>['hu',],
'ránk'=>['hu',],
'ráno'=>['cs','sk',],
'rápido'=>['es','pt','pt_br',],
'räcker'=>['sv',],
'rädd'=>['sv',],
'rädda'=>['sv',],
'räddade'=>['sv',],
'rätt'=>['sv',],
'rätta'=>['sv',],
'räägi'=>['et',],
'räägib'=>['et',],
'räägid'=>['et',],
'räägime'=>['et',],
'räägin'=>['et',],
'rääkida'=>['et',],
'rääkima'=>['et',],
'rääkinud'=>['et',],
'rääkis'=>['et',],
'rääkisin'=>['et',],
'råd'=>['da','nb','no','sv',],
'ræva'=>['nb','no',],
'ræða'=>['is',],
'rég'=>['hu',],
'régen'=>['hu',],
'régi'=>['hu',],
'réponse'=>['fr',],
'része'=>['hu',],
'rétt'=>['is',],
'rétta'=>['is',],
'réttu'=>['is',],
'réussi'=>['fr',],
'rêve'=>['fr',],
'rëndësi'=>['sq',],
'rëndësishme'=>['sq',],
'rënë'=>['sq',],
'río'=>['es','gl',],
'rób'=>['pl',],
'róla'=>['hu',],
'rólad'=>['hu',],
'rólam'=>['hu',],
'rólegur'=>['is',],
'również'=>['pl',],
'rögtön'=>['hu',],
'rör'=>['sv',],
'röra'=>['sv',],
'rør'=>['da','nb','no',],
'røv'=>['da',],
'røven'=>['da',],
'røvhul'=>['da',],
'rúa'=>['gl',],
'rúas'=>['gl',],
'rüber'=>['de',],
'rýchlo'=>['sk',],
'rămas'=>['ro',],
'rămâi'=>['ro',],
'rămâne'=>['ro',],
'rău'=>['ro',],
'război'=>['ro',],
'rėjau'=>['lt',],
'ręce'=>['pl',],
'rękę'=>['pl',],
'rīt'=>['lv',],
'rīta'=>['lv',],
'rо'=>['mk',],
's'=>['az','bs','ca','cs','da','de','en','es','et','fr','hr','hu','id','is','it','lt','ms','nb','nl','no','pt','ro','si','sk','sl','sq','sr','sv','th','tr',],
'sa'=>['bs','ca','da','et','fr','hr','it','nb','no','ro','sk','sq','sr','sv',],
'saa'=>['et','fi',],
'saab'=>['et',],
'saad'=>['et',],
'saada'=>['et','fi',],
'saak'=>['af',],
'saaks'=>['et',],
'saaksid'=>['et',],
'saaksin'=>['et',],
'saam'=>['af',],
'saama'=>['et',],
'saame'=>['et',],
'saamme'=>['fi',],
'saan'=>['et','fi',],
'saanko'=>['fi',],
'saanud'=>['et',],
'saanut'=>['fi',],
'saat'=>['az','fi','id','ms','tr',],
'saate'=>['et',],
'saatnya'=>['ms',],
'saattaa'=>['fi',],
'saatte'=>['fi',],
'saavad'=>['et',],
'saavat'=>['fi',],
'sabah'=>['tr',],
'sabe'=>['es','gl','pt','pt_br',],
'sabem'=>['ca','pt','pt_br',],
'sabemos'=>['es','pt','pt_br',],
'saben'=>['ca','es',],
'saber'=>['ca','es','gl','pt','pt_br',],
'sabes'=>['es','gl','pt',],
'sabia'=>['ca','pt','pt_br',],
'sabo'=>['sl',],
'sabía'=>['es','gl',],
'sac'=>['fr',],
'sacco'=>['it',],
'sache'=>['de',],
'sachen'=>['de',],
'sad'=>['bs','da','en','hr','sr',],
'sada'=>['bs','hr','sr',],
'sadece'=>['tr',],
'sadni'=>['sk',],
'saepe'=>['la',],
'saepius'=>['la',],
'safe'=>['en',],
'sag'=>['af','da','de',],
'sagde'=>['da','no',],
'sage'=>['de',],
'sagen'=>['da','de',],
'sagst'=>['de',],
'sagt'=>['da','de','is','nb','no','sv',],
'sagte'=>['de',],
'sagten'=>['de',],
'sagði'=>['is',],
'sagðir'=>['is',],
'sagðirðu'=>['is',],
'sagðist'=>['is',],
'sah'=>['de',],
'sahip'=>['tr',],
'sai'=>['et','fi','it','pt','pt_br',],
'saia'=>['pt','pt_br',],
'saiam'=>['pt',],
'saiatu'=>['eu',],
'said'=>['en','et','th',],
'saime'=>['et',],
'saimme'=>['fi',],
'sain'=>['et','fi',],
'sair'=>['pt','pt_br',],
'sairas'=>['fi',],
'sais'=>['fr',],
'saisi'=>['fi',],
'sait'=>['fi','fr',],
'saiu'=>['pt','pt_br',],
'saj'=>['sl','sq',],
'saja'=>['id','ms',],
'sajnos'=>['hu',],
'sajnálom'=>['hu',],
'saját'=>['hu',],
'sak'=>['af','nb','no','sv',],
'saka'=>['lv',],
'sakai'=>['lt',],
'sakant'=>['lt',],
'sakau'=>['lt',],
'sake'=>['en',],
'sakei'=>['lt',],
'saken'=>['nb','no','sv',],
'saker'=>['sv',],
'saki'=>['lv',],
'sakiau'=>['lt',],
'sakim'=>['hi',],
'sakin'=>['tr',],
'sakit'=>['ms',],
'sakna'=>['is',],
'saknar'=>['sv',],
'sako'=>['lt',],
'sakona'=>['eu',],
'sakot'=>['lv',],
'sakra'=>['cs','sk',],
'sakratua'=>['eu',],
'sakratuekin'=>['eu',],
'saktë'=>['sq',],
'saku'=>['lv',],
'sakyk'=>['lt',],
'sakyti'=>['lt',],
'sakė'=>['lt',],
'sakın'=>['tr',],
'sal'=>['af','es',],
'sala'=>['ca','gl','pt','pt_br',],
'salah'=>['id','ms',],
'salak'=>['tr',],
'sale'=>['es','fr','ro',],
'saling'=>['ms',],
'salir'=>['es',],
'salle'=>['fr',],
'salud'=>['es',],
'salut'=>['fr','ro',],
'salutem'=>['la',],
'salvar'=>['ca','pt','pt_br',],
'salvat'=>['ro',],
'salve'=>['it',],
'salvo'=>['es',],
'sam'=>['bs','da','de','en','es','et','fi','fr','hr','hu','is','it','ms','nb','nl','no','pl','pt','pt_br','ro','si','sk','sl','sr','sv','tr',],
'sama'=>['bs','cs','et','fi','hr','id','is','ms','pl','sk','sl','sr',],
'samaa'=>['fi',],
'samalla'=>['fi',],
'saman'=>['is',],
'samas'=>['et',],
'samband'=>['is',],
'sambandi'=>['is',],
'same'=>['en',],
'sameer'=>['si',],
'samego'=>['pl',],
'samen'=>['nl',],
'sami'=>['bs','cs','hr','pl','sl','sr',],
'samma'=>['sv',],
'samme'=>['da','nb','no',],
'sammen'=>['da','nb','no',],
'samnom'=>['sr',],
'samo'=>['bs','hr','pl','sl','sr',],
'samochodu'=>['pl',],
'samochód'=>['pl',],
'samoin'=>['fi',],
'samozrejme'=>['sk',],
'samozřejmě'=>['cs',],
'sampah'=>['ms',],
'sampai'=>['id','ms',],
'samt'=>['is',],
'samtal'=>['sv',],
'samuti'=>['et',],
'samym'=>['pl',],
'san'=>['bs','es','gl','hr','it','sr',],
'sana'=>['id','ms','tr',],
'sandheden'=>['da',],
'sandt'=>['da',],
'sane'=>['la',],
'sang'=>['ca','da','fr','ms',],
'sangat'=>['id','ms',],
'sangre'=>['es',],
'sangue'=>['gl','it','pt','pt_br',],
'sanguine'=>['la',],
'sanguinem'=>['la',],
'saniye'=>['tr',],
'sanje'=>['sl',],
'sanki'=>['tr',],
'sanmıyorum'=>['tr',],
'sannarlega'=>['is',],
'sannheten'=>['nb','no',],
'sanningen'=>['sv',],
'sannleikann'=>['is',],
'sanno'=>['it',],
'sano'=>['fi',],
'sanoa'=>['fi',],
'sanoi'=>['fi',],
'sanoin'=>['fi',],
'sanoit'=>['fi',],
'sanon'=>['fi',],
'sanonut'=>['fi',],
'sanoo'=>['fi',],
'sanot'=>['fi',],
'sanotaan'=>['fi',],
'sans'=>['fr',],
'sant'=>['nb','no','sv',],
'santa'=>['gl',],
'santiago'=>['gl',],
'santo'=>['it',],
'sanyasi'=>['af',],
'sanırım'=>['tr',],
'sanıyordum'=>['tr',],
'sanıyorsun'=>['tr',],
'sap'=>['ca',],
'sapere'=>['it',],
'saperlo'=>['it',],
'sapete'=>['it',],
'sapeva'=>['it',],
'sapevo'=>['it',],
'sapientia'=>['la',],
'sapnis'=>['lv',],
'sapo'=>['sq',],
'sappiamo'=>['it',],
'sappige'=>['af',],
'saprast'=>['lv',],
'saprati'=>['lv',],
'sapratu'=>['lv',],
'saproti'=>['lv',],
'saprotu'=>['lv',],
'saps'=>['ca',],
'saputo'=>['it',],
'sara'=>['lt',],
'sarai'=>['it',],
'saranno'=>['it',],
'sarebbe'=>['it',],
'sarei'=>['it',],
'saremo'=>['it',],
'sargento'=>['es','pt','pt_br',],
'sartu'=>['eu',],
'sarà'=>['it',],
'sarò'=>['it',],
'sasikume'=>['eu',],
'sasodīts'=>['lv',],
'sasoian'=>['eu',],
'sastanak'=>['bs','hr','sr',],
'sasvim'=>['sr',],
'sat'=>['bs','da','hr','sr',],
'sata'=>['bs','hr','sr',],
'satan'=>['da',],
'satans'=>['da',],
'satelit'=>['id',],
'sati'=>['bs','hr','sr',],
'satikt'=>['lv',],
'satis'=>['la',],
'satt'=>['is','nb','no','sv',],
'satte'=>['nb','no','sv',],
'sattlu'=>['hi',],
'sattuu'=>['fi',],
'satu'=>['id','ms',],
'satunya'=>['id','ms',],
'saturnus'=>['id',],
'sau'=>['lt','ro',],
'sauc'=>['lv',],
'sauca'=>['lv',],
'saucer'=>['th',],
'saudara'=>['ms',],
'sauf'=>['fr',],
'sauver'=>['fr',],
'sava'=>['lv',],
'savais'=>['fr',],
'savait'=>['fr',],
'savaites'=>['lt',],
'savaitę'=>['lt',],
'savas'=>['lv',],
'savaş'=>['tr',],
'save'=>['en','lt',],
'saved'=>['en',],
'savez'=>['fr',],
'saviem'=>['lv',],
'savimi'=>['lt',],
'savner'=>['nb','no',],
'savo'=>['lt',],
'savoir'=>['fr',],
'savu'=>['lv',],
'savus'=>['lv',],
'savā'=>['lv',],
'savām'=>['lv',],
'savęs'=>['lt',],
'saw'=>['en',],
'say'=>['en','si',],
'saya'=>['id','ms',],
'sayang'=>['ms',],
'saying'=>['en',],
'says'=>['en',],
'sayt'=>['az',],
'saytı'=>['az',],
'sayın'=>['tr',],
'saçma'=>['tr',],
'saída'=>['gl',],
'saír'=>['gl',],
'saúde'=>['gl','pt_br',],
'sağ'=>['tr',],
'sağol'=>['tr',],
'saиekaj'=>['sr',],
'sbagliato'=>['it',],
'sbohem'=>['cs',],
'scared'=>['en','si',],
'scarletti'=>['si',],
'scelta'=>['it',],
'scena'=>['it',],
'scene'=>['af',],
'schaffen'=>['de',],
'schat'=>['nl',],
'schatje'=>['nl',],
'schatz'=>['de',],
'schau'=>['de',],
'schauen'=>['de',],
'scheint'=>['de',],
'scheiß'=>['de',],
'scheiße'=>['de',],
'schelen'=>['nl',],
'scheming'=>['af',],
'schicken'=>['de',],
'schiet'=>['nl',],
'schieten'=>['nl',],
'schießen'=>['de',],
'schiff'=>['de',],
'schimb'=>['ro',],
'schimba'=>['ro',],
'schimbat'=>['ro',],
'schip'=>['nl',],
'schlafen'=>['de',],
'schlecht'=>['de',],
'schlimm'=>['de',],
'schlüssel'=>['de',],
'schnell'=>['de',],
'schneller'=>['de',],
'schon'=>['de',],
'school'=>['en','nl',],
'schreiben'=>['de',],
'schrijven'=>['nl',],
'schuld'=>['de','nl',],
'schuldig'=>['nl',],
'schule'=>['de',],
'schwer'=>['de',],
'schwester'=>['de',],
'schön'=>['de',],
'schöne'=>['de',],
'scilicet'=>['la',],
'scio'=>['la',],
'scire'=>['la',],
'scoperto'=>['it',],
'screaming'=>['en',],
'scrie'=>['ro',],
'scripsit'=>['la',],
'scriptum'=>['la',],
'scris'=>['ro',],
'scritto'=>['it',],
'scumpo'=>['ro',],
'scuola'=>['it',],
'scusa'=>['it',],
'scusami'=>['it',],
'scusate'=>['it',],
'scusi'=>['it',],
'scuze'=>['ro',],
'scène'=>['fr',],
'se'=>['af','bs','ca','cs','da','es','fi','fr','gl','hr','hu','it','la','nb','no','pt','pt_br','ro','sl','sq','sr','sv','zh_tw',],
'sea'=>['en','es',],
'seal'=>['et',],
'sealt'=>['et',],
'seama'=>['ro',],
'sean'=>['es',],
'seara'=>['ro',],
'seară'=>['ro',],
'seas'=>['es',],
'seat'=>['en',],
'seba'=>['sk',],
'sebabnya'=>['ms',],
'sebagai'=>['id','ms',],
'sebagainya'=>['id',],
'sebagian'=>['id','ms',],
'sebaiknya'=>['ms',],
'sebanyak'=>['id',],
'sebe'=>['bs','cs','hr','sk','sl','sr',],
'sebelah'=>['ms',],
'sebelum'=>['id','ms',],
'sebelumnya'=>['id','ms',],
'sebenarnya'=>['id','ms',],
'sebentar'=>['ms',],
'seberapa'=>['id','ms',],
'sebi'=>['bs','hr','sl','sr',],
'sebiènija'=>['hi',],
'sebou'=>['cs','sk',],
'sebuah'=>['id','ms',],
'sebut'=>['id',],
'secara'=>['id','ms',],
'sechs'=>['de',],
'second'=>['en',],
'seconde'=>['fr',],
'seconden'=>['nl',],
'secondo'=>['it',],
'secours'=>['fr',],
'secret'=>['ca','en','fr','ro',],
'secretario'=>['gl',],
'secreto'=>['es',],
'sector'=>['gl',],
'secum'=>['la',],
'secunde'=>['ro',],
'secundum'=>['la',],
'security'=>['en',],
'sed'=>['la',],
'seda'=>['et',],
'sedaj'=>['sl',],
'sedam'=>['bs','hr','sr',],
'sedan'=>['sv',],
'sedang'=>['id','ms',],
'sedem'=>['sl',],
'sederhana'=>['id',],
'sedi'=>['sl','sr',],
'sedikit'=>['id','ms',],
'sedm'=>['cs',],
'sedmice'=>['bs',],
'see'=>['af','en','et','si',],
'seega'=>['et',],
'seeing'=>['en',],
'seele'=>['de',],
'seem'=>['en',],
'seems'=>['en',],
'seen'=>['en','si','th',],
'seer'=>['af',],
'sees'=>['et',],
'sefer'=>['tr',],
'seg'=>['nb','no',],
'segala'=>['id','ms',],
'segalanya'=>['id','ms',],
'segera'=>['id','ms',],
'seggfej'=>['hu',],
'segi'=>['is',],
'segir'=>['is',],
'segirðu'=>['is',],
'segja'=>['is',],
'segon'=>['ca',],
'segons'=>['ca',],
'segreto'=>['it',],
'segue'=>['gl',],
'segueix'=>['ca',],
'seguida'=>['ca',],
'seguinte'=>['gl',],
'seguir'=>['ca','es','gl','pt','pt_br',],
'segunda'=>['gl','pt','pt_br',],
'segundo'=>['es','gl','pt','pt_br',],
'segundos'=>['pt',],
'segur'=>['ca','eu',],
'segura'=>['ca','es',],
'segurança'=>['pt','pt_br',],
'seguretat'=>['ca',],
'seguridad'=>['es',],
'seguridade'=>['gl',],
'seguro'=>['es','gl','pt','pt_br',],
'seguruenik'=>['eu',],
'segít'=>['hu',],
'segíteni'=>['hu',],
'segíthetek'=>['hu',],
'segíts'=>['hu',],
'segítség'=>['hu',],
'segðu'=>['is',],
'seharusnya'=>['ms',],
'sehe'=>['de',],
'sehen'=>['de',],
'sehingga'=>['id','ms',],
'sehr'=>['de',],
'seht'=>['de',],
'sehän'=>['fi',],
'sei'=>['de','gl','it','pt','pt_br',],
'seid'=>['de',],
'seien'=>['de',],
'seigneur'=>['fr',],
'sein'=>['de',],
'seine'=>['de',],
'seinem'=>['de',],
'seinen'=>['de',],
'seiner'=>['de',],
'seinna'=>['is',],
'seint'=>['is',],
'seis'=>['es','fi','gl','pt','pt_br',],
'seit'=>['de',],
'seite'=>['de',],
'seitsemän'=>['fi',],
'seja'=>['pt','pt_br',],
'sejak'=>['id','ms',],
'sejarah'=>['id','ms',],
'sejauh'=>['id','ms',],
'seju'=>['lv',],
'sejumlah'=>['id',],
'sekali'=>['id','ms',],
'sekarang'=>['id','ms',],
'sekasi'=>['lt',],
'seker'=>['af',],
'sekerlik'=>['af',],
'sekitar'=>['id','ms',],
'sekitarnya'=>['id',],
'sekiz'=>['tr',],
'seko'=>['lv',],
'sekolah'=>['ms',],
'sekonda'=>['sq',],
'seks'=>['af','da','ms','nb','nl','no','sq','tr',],
'seksi'=>['sq',],
'sekunden'=>['de',],
'sekunder'=>['da','nb','no','sv',],
'sekundi'=>['bs',],
'sekä'=>['fi',],
'sekúndur'=>['is',],
'sel'=>['et','id',],
'selain'=>['id','ms',],
'selalu'=>['id','ms',],
'selam'=>['tr',],
'selama'=>['id','ms',],
'selamanya'=>['ms',],
'selamat'=>['id','ms',],
'selanjutnya'=>['id',],
'selatan'=>['id','ms',],
'selber'=>['de',],
'selbst'=>['de',],
'selesai'=>['ms',],
'self'=>['af',],
'selfoon'=>['af',],
'selfs'=>['af',],
'selge'=>['et','nb',],
'selja'=>['is',],
'sell'=>['en',],
'sellainen'=>['fi',],
'sellaista'=>['fi',],
'selle'=>['et',],
'sellega'=>['et',],
'selleks'=>['et',],
'sellel'=>['et',],
'sellele'=>['et',],
'sellepärast'=>['et',],
'selles'=>['et',],
'sellest'=>['et',],
'selline'=>['et',],
'sellise'=>['et',],
'sellist'=>['et',],
'selon'=>['fr',],
'seluruh'=>['id','ms',],
'selv'=>['da','nb','no',],
'selvfølgelig'=>['da','nb','no',],
'selvsagt'=>['nb','no',],
'selvä'=>['fi',],
'selvää'=>['fi',],
'sem'=>['cs','hu','is','lv','pt','pt_br','sk','sl','sr',],
'semacam'=>['id','ms',],
'semaine'=>['fr',],
'semaines'=>['fr',],
'semakin'=>['id','ms',],
'semana'=>['es','gl','pt','pt_br',],
'semanas'=>['es','pt','pt_br',],
'sembla'=>['ca',],
'semble'=>['fr',],
'sembra'=>['it',],
'seme'=>['eu',],
'semea'=>['eu',],
'semearen'=>['eu',],
'semeari'=>['eu',],
'semeetatik'=>['eu',],
'semel'=>['la',],
'semellante'=>['gl',],
'semen'=>['la',],
'sementara'=>['id','ms',],
'semesta'=>['id',],
'semmi'=>['hu',],
'semmit'=>['hu',],
'semoga'=>['ms',],
'semper'=>['la',],
'semplice'=>['it',],
'sempre'=>['ca','gl','it','pt','pt_br',],
'sempurna'=>['id','ms',],
'semu'=>['et',],
'semua'=>['id','ms',],
'semuanya'=>['id','ms',],
'semut'=>['id',],
'sen'=>['cs','fi','gl','lv','sk','sv','tr',],
'sena'=>['af',],
'senang'=>['id','ms',],
'senare'=>['sv',],
'senas'=>['lt',],
'senaste'=>['sv',],
'senatu'=>['la',],
'senatum'=>['la',],
'senatus'=>['la',],
'sence'=>['tr',],
'send'=>['da','en','nb','no',],
'senda'=>['is',],
'sende'=>['da','nb','no','tr',],
'senden'=>['tr',],
'sender'=>['da','nb','no',],
'sendi'=>['is',],
'sendiri'=>['id','ms',],
'sendirian'=>['id','ms',],
'sendo'=>['gl','pt','pt_br',],
'sendt'=>['da','nb','no',],
'sendte'=>['da','nb','no',],
'senere'=>['da','nb','no',],
'seng'=>['da',],
'senhor'=>['pt','pt_br',],
'senhora'=>['pt','pt_br',],
'senhoras'=>['pt','pt_br',],
'senhores'=>['pt','pt_br',],
'senhorita'=>['pt_br',],
'seni'=>['lt','tr',],
'seniai'=>['lt',],
'senin'=>['tr',],
'seninle'=>['tr',],
'senjata'=>['id','ms',],
'senki'=>['hu',],
'senkin'=>['fi',],
'senkinek'=>['hu',],
'senkit'=>['hu',],
'sens'=>['fr',],
'sense'=>['ca','en','si',],
'sensin'=>['tr',],
'senso'=>['it',],
'sensus'=>['la',],
'sent'=>['ca','da','en','nb','no','sv',],
'sente'=>['it','pt','pt_br',],
'sententia'=>['la',],
'sententiam'=>['la',],
'senti'=>['eu','it',],
'sentido'=>['es','gl','pt','pt_br',],
'sentir'=>['ca','es','pt','pt_br',],
'sentire'=>['it',],
'sentit'=>['ca',],
'sentito'=>['it',],
'sentitu'=>['eu',],
'sentitzen'=>['eu',],
'sento'=>['ca','it',],
'sents'=>['ca',],
'sentään'=>['fi',],
'senyal'=>['ca',],
'senyor'=>['ca',],
'senyora'=>['ca',],
'senyoreta'=>['ca',],
'senyors'=>['ca',],
'senza'=>['it',],
'senón'=>['gl',],
'seorang'=>['id','ms',],
'seotud'=>['et',],
'sepanjang'=>['id','ms',],
'sepatu'=>['ms',],
'sepenuhnya'=>['id',],
'seperti'=>['id','ms',],
'sepertinya'=>['ms',],
'sepotong'=>['id',],
'sepse'=>['sq',],
'sept'=>['fr',],
'septem'=>['la',],
'sepuluh'=>['id','ms',],
'sequer'=>['pt',],
'sequera'=>['gl',],
'sequitur'=>['la',],
'seqüència'=>['ca',],
'ser'=>['ca','da','es','gl','lv','nb','no','pt','pt_br','sr','sv',],
'sera'=>['fr','it',],
'serai'=>['fr',],
'serais'=>['fr',],
'serait'=>['fr',],
'serangan'=>['id','ms',],
'serangga'=>['id',],
'seras'=>['fr',],
'serca'=>['pl',],
'serce'=>['pl',],
'sere'=>['lt',],
'serez'=>['fr',],
'seria'=>['ca','pt','pt_br',],
'serie'=>['gl',],
'serieus'=>['nl',],
'serikat'=>['id',],
'sering'=>['id','ms',],
'serio'=>['es','it','pl',],
'serios'=>['ro',],
'serious'=>['en',],
'seriozisht'=>['sq',],
'seriskog'=>['hi',],
'serius'=>['ms',],
'sermo'=>['la',],
'sermone'=>['la',],
'seront'=>['fr',],
'sersan'=>['ms',],
'sert'=>['tr',],
'serve'=>['it',],
'servei'=>['ca',],
'service'=>['en','fr',],
'servicio'=>['es','gl',],
'servicios'=>['gl',],
'servir'=>['ca',],
'servizio'=>['it',],
'serviço'=>['pt','pt_br',],
'servono'=>['it',],
'serà'=>['ca',],
'será'=>['es','gl','pt','pt_br',],
'serán'=>['gl',],
'serão'=>['pt_br',],
'seré'=>['ca',],
'sería'=>['es','gl',],
'ses'=>['cs','da','fr','nb','no','sv','tr',],
'sesa'=>['sq',],
'sese'=>['la',],
'seseorang'=>['id','ms',],
'sesini'=>['tr',],
'sessiz'=>['tr',],
'sesso'=>['it',],
'sest'=>['et',],
'sestra'=>['bs','cs','hr','sk','sl','sr',],
'sestu'=>['is',],
'sesuatu'=>['id','ms',],
'set'=>['ca','da','en',],
'sete'=>['gl','pt','pt_br',],
'setelah'=>['id','ms',],
'setengah'=>['id','ms',],
'seth'=>['si',],
'seti'=>['id',],
'setiap'=>['id','ms',],
'setidaknya'=>['id','ms',],
'setja'=>['is',],
'setmana'=>['ca',],
'setmanes'=>['ca',],
'sett'=>['nb','no','sv',],
'sette'=>['it','nb','no',],
'setter'=>['nb','no',],
'settimana'=>['it',],
'settimane'=>['it',],
'settu'=>['is',],
'setuju'=>['id','ms',],
'setz'=>['de',],
'setzen'=>['de',],
'seu'=>['ca','gl','la','pt','pt_br',],
'seua'=>['ca',],
'seul'=>['fr',],
'seule'=>['fr',],
'seulement'=>['fr',],
'seun'=>['af',],
'seuns'=>['af',],
'seuntjie'=>['af',],
'seuraa'=>['fi',],
'seuraava'=>['fi',],
'seus'=>['ca','gl','pt','pt_br',],
'sev'=>['lv',],
'seva'=>['ca',],
'sevdalısı'=>['az',],
'seveda'=>['sl',],
'seven'=>['en',],
'seves'=>['ca',],
'sevgi'=>['az',],
'sevgili'=>['tr',],
'sevi'=>['lv',],
'sevindim'=>['tr',],
'sevis'=>['lv',],
'seviyor'=>['tr',],
'seviyorum'=>['tr',],
'sex'=>['da','de','en','is','la','nb','no','ro','sk','sv',],
'sexa'=>['gl',],
'sexan'=>['gl',],
'sexo'=>['es','pt','pt_br',],
'señor'=>['es','gl',],
'señora'=>['es','gl',],
'señorita'=>['es',],
'seš'=>['cs',],
'seжam'=>['sr',],
'seжaљ'=>['sr',],
'sfârşit'=>['ro',],
'sgu'=>['da',],
'sh'=>['zh_tw',],
'shaka'=>['sq',],
'shall'=>['en','si',],
'shatrughan'=>['af',],
'shawshank'=>['si',],
'she'=>['en','fa','hi','si','th',],
'shef'=>['sq',],
'sheh'=>['sq',],
'sheikin'=>['af',],
'sheiks'=>['af',],
'sheit'=>['lv',],
'shihemi'=>['sq',],
'shihni'=>['sq',],
'shiko'=>['sq',],
'shikoj'=>['sq',],
'shikoje'=>['sq',],
'shikon'=>['sq',],
'shikoni'=>['sq',],
'shikosh'=>['sq',],
'ship'=>['en','th',],
'shit'=>['en','nl',],
'shiva'=>['af',],
'shkak'=>['sq',],
'shko'=>['sq',],
'shkoi'=>['sq',],
'shkoj'=>['sq',],
'shkojme'=>['sq',],
'shkojmë'=>['sq',],
'shkojnë'=>['sq',],
'shkojë'=>['sq',],
'shkollë'=>['sq',],
'shkon'=>['sq',],
'shkoni'=>['sq',],
'shkosh'=>['sq',],
'shkuar'=>['sq',],
'shkëlqyeshëm'=>['sq',],
'shoh'=>['sq',],
'shohim'=>['sq',],
'shohësh'=>['sq',],
'shok'=>['sq',],
'shoku'=>['sq',],
'shokë'=>['sq',],
'shokët'=>['sq',],
'shoot'=>['en','th',],
'short'=>['en',],
'shot'=>['en',],
'should'=>['en','th',],
'shouldn'=>['en',],
'show'=>['en','nl','pt_br',],
'shpejt'=>['sq',],
'shpejti'=>['sq',],
'shpejtë'=>['sq',],
'shpirt'=>['sq',],
'shpresoj'=>['sq',],
'shqetëso'=>['sq',],
'shtatë'=>['sq',],
'shtepi'=>['sq',],
'shtëpi'=>['sq',],
'shtëpia'=>['sq',],
'shtëpinë'=>['sq',],
'shum'=>['sq',],
'shume'=>['sq',],
'shumë'=>['sq',],
'shut'=>['en','si',],
'shutup'=>['hi',],
'shvatam'=>['sr',],
'shvatio'=>['hr','sr',],
'si'=>['bs','ca','cs','es','fr','gl','hr','it','la','ms','nb','no','pt','pt_br','ro','sk','sl','sq','sr',],
'sia'=>['it',],
'sial'=>['ms',],
'sialan'=>['ms',],
'siamo'=>['it',],
'siang'=>['ms',],
'siano'=>['it',],
'siap'=>['id','ms',],
'siapa'=>['id','ms',],
'siapapun'=>['ms',],
'sibi'=>['la',],
'sibuk'=>['ms',],
'sic'=>['la',],
'sicer'=>['sl',],
'sich'=>['de',],
'sicher'=>['de',],
'sicherheit'=>['de',],
'sick'=>['en','th',],
'sicura'=>['it',],
'sicurezza'=>['it',],
'sicuro'=>['it',],
'sicut'=>['la',],
'sid'=>['da',],
'sida'=>['sv',],
'sidan'=>['sv',],
'sidde'=>['da',],
'sidder'=>['da',],
'side'=>['da','en','nb','no',],
'siden'=>['da','nb','no',],
'sido'=>['es','pt','pt_br',],
'sidst'=>['da',],
'sidste'=>['da',],
'sie'=>['de','pl',],
'sieben'=>['de',],
'siebie'=>['pl',],
'siediti'=>['it',],
'sieh'=>['de',],
'siehst'=>['de',],
'sieht'=>['de',],
'siek'=>['af',],
'siellä'=>['fi',],
'sieltä'=>['fi',],
'siempre'=>['es',],
'sien'=>['af',],
'siendo'=>['es',],
'siente'=>['es',],
'sientes'=>['es',],
'siento'=>['es',],
'sier'=>['nb','no',],
'siess'=>['hu',],
'siete'=>['es','it',],
'sieva'=>['lv',],
'sieviete'=>['lv',],
'sievietes'=>['lv',],
'sievieti'=>['lv',],
'sievu'=>['lv',],
'sifat'=>['id',],
'sig'=>['af','da','is','it','no','sv',],
'sigara'=>['tr',],
'sige'=>['da','no',],
'siger'=>['da','no',],
'sighin'=>['af',],
'sighs'=>['en',],
'sign'=>['en',],
'signa'=>['la',],
'significa'=>['ca','es','it','pt','pt_br',],
'signor'=>['it',],
'signora'=>['it',],
'signore'=>['it',],
'signori'=>['it',],
'signorina'=>['it',],
'signum'=>['la',],
'sigue'=>['es',],
'sigui'=>['ca',],
'siguiente'=>['es',],
'siguis'=>['ca',],
'sigur'=>['ro',],
'siguran'=>['bs','hr','sr',],
'siguranţă'=>['ro',],
'siguri'=>['sq',],
'sigurisht'=>['sq',],
'sigurna'=>['bs','hr','sr',],
'sigurni'=>['hr',],
'sigurno'=>['bs','hr','sr',],
'sigurt'=>['sq',],
'sigurtë'=>['sq',],
'sigură'=>['ro',],
'sigut'=>['ca',],
'sih'=>['ms',],
'siia'=>['et',],
'siihen'=>['fi',],
'siin'=>['et',],
'siinä'=>['fi',],
'siis'=>['et','fi',],
'siiski'=>['et',],
'siit'=>['et',],
'siitä'=>['fi',],
'sikerült'=>['hu',],
'sikke'=>['da',],
'sikker'=>['da','nb','no',],
'sikkerhed'=>['da',],
'sikkert'=>['da','nb','no',],
'siklus'=>['id',],
'sikre'=>['da',],
'siksi'=>['fi',],
'siktir'=>['tr',],
'sikur'=>['sq',],
'sil'=>['az',],
'silah'=>['tr',],
'silahkan'=>['ms',],
'silahı'=>['tr',],
'silakan'=>['ms',],
'silence'=>['fr',],
'silenci'=>['ca',],
'silencio'=>['es','gl',],
'silenzio'=>['it',],
'sille'=>['fi',],
'silloin'=>['fi',],
'sillä'=>['fi',],
'silma'=>['et',],
'silmad'=>['et',],
'silmas'=>['et',],
'silti'=>['fi',],
'siltä'=>['fi',],
'sim'=>['pt','pt_br',],
'sime'=>['sq',],
'simile'=>['la',],
'similis'=>['la',],
'similiter'=>['la',],
'simple'=>['en','fr',],
'simplement'=>['ca','fr',],
'simplemente'=>['es',],
'simples'=>['pt','pt_br',],
'simplesmente'=>['pt','pt_br',],
'simplu'=>['ro',],
'simt'=>['ro',],
'simul'=>['la',],
'simţi'=>['ro',],
'simţit'=>['ro',],
'sin'=>['bs','da','es','hr','la','nb','no','sl','sr','sv',],
'sina'=>['bs','et','hr','sl','sr','sv',],
'sinal'=>['pt','pt_br',],
'sinalou'=>['gl',],
'sinar'=>['id',],
'since'=>['en',],
'sincer'=>['ro',],
'sincs'=>['hu',],
'sind'=>['de','et',],
'sinds'=>['nl',],
'sine'=>['bs','da','hr','la','nb','no','sr',],
'sing'=>['af','en','th',],
'singin'=>['af',],
'singkat'=>['id',],
'single'=>['en',],
'singulis'=>['la',],
'singur'=>['ro',],
'singura'=>['ro',],
'singurul'=>['ro',],
'singură'=>['ro',],
'sinhala'=>['si',],
'sinhalasub'=>['si',],
'sini'=>['id','ms',],
'sinistra'=>['it',],
'sink'=>['af',],
'sinn'=>['de','is',],
'sinna'=>['et',],
'sinne'=>['fi',],
'sinni'=>['is',],
'sinnum'=>['is',],
'sino'=>['es',],
'sinon'=>['fr',],
'sinoć'=>['hr',],
'sinoči'=>['sl',],
'sinoж'=>['sr',],
'sint'=>['la','nb','no',],
'sinto'=>['pt','pt_br',],
'sinu'=>['et',],
'sinua'=>['fi',],
'sinuga'=>['et',],
'sinulla'=>['fi',],
'sinulle'=>['fi',],
'sinulta'=>['fi',],
'sinun'=>['fi',],
'sinust'=>['et',],
'sinusta'=>['fi',],
'sinut'=>['fi',],
'sinuun'=>['fi',],
'sinyal'=>['id',],
'sinä'=>['fi',],
'sinähän'=>['fi',],
'sinäkin'=>['fi',],
'sinó'=>['ca',],
'siostra'=>['pl',],
'sipas'=>['sq',],
'siquiera'=>['es',],
'sir'=>['da','de','en','et','fi','hr','ms','nb','nl','no','pl','si','sv','th',],
'sirdi'=>['lv',],
'sirds'=>['lv',],
'sis'=>['ca','cs','la',],
'sisa'=>['id',],
'sisi'=>['id','ms',],
'sisplau'=>['ca',],
'sisse'=>['et',],
'sist'=>['nb','no',],
'sista'=>['sv',],
'siste'=>['nb','no',],
'sistem'=>['bs','id','ms',],
'sistema'=>['es','gl','it','lt','pt','pt_br',],
'sister'=>['en',],
'sisälle'=>['fi',],
'sisällä'=>['fi',],
'sisään'=>['fi',],
'sit'=>['af','da','en','la',],
'sita'=>['af',],
'sitaaaaaa'=>['af',],
'sitio'=>['es','gl',],
'sitja'=>['is',],
'sitt'=>['is','nb','no','sv',],
'sitta'=>['sv',],
'sitte'=>['nb','no',],
'sitten'=>['fi',],
'sitter'=>['nb','no','sv',],
'sitting'=>['en',],
'situ'=>['ms',],
'situació'=>['ca',],
'situación'=>['es','gl',],
'situation'=>['en','fr',],
'situazione'=>['it',],
'situação'=>['pt','pt_br',],
'situs'=>['id',],
'sitzen'=>['de',],
'sitzt'=>['de',],
'sitä'=>['fi',],
'siue'=>['la',],
'sive'=>['la',],
'six'=>['en','fr',],
'siyah'=>['tr',],
'siz'=>['tr',],
'size'=>['tr',],
'sizi'=>['tr',],
'sizin'=>['tr',],
'sizinle'=>['tr',],
'siás'=>['ca',],
'siç'=>['sq',],
'siéntate'=>['es',],
'się'=>['pl',],
'sjajno'=>['bs','hr','sr',],
'sjanse'=>['nb','no',],
'sjansen'=>['nb',],
'sjedi'=>['bs',],
'sjedni'=>['hr',],
'sjef'=>['nb','no',],
'sjefen'=>['nb','no',],
'sjekk'=>['nb','no',],
'sjekke'=>['nb',],
'sjell'=>['sq',],
'sjellë'=>['sq',],
'sjeèam'=>['hi',],
'sjeèaš'=>['hi',],
'sjećam'=>['hr',],
'sjećaš'=>['bs','hr',],
'sjov'=>['da',],
'sjovt'=>['da',],
'sju'=>['nb','no','sv',],
'sjuk'=>['sv',],
'sjukhuset'=>['sv',],
'sjá'=>['is',],
'sjáið'=>['is',],
'sjálfur'=>['is',],
'sjáum'=>['is',],
'sjáumst'=>['is',],
'sjáðu'=>['is',],
'själv'=>['sv',],
'själva'=>['sv',],
'självklart'=>['sv',],
'sjö'=>['is',],
'ska'=>['sv',],
'skada'=>['sv',],
'skade'=>['da','nb','no',],
'skadet'=>['nb',],
'skadu'=>['af',],
'skaffa'=>['sv',],
'skaffe'=>['nb','no',],
'skai'=>['da','nb','no',],
'skaidrs'=>['lv',],
'skaista'=>['lv',],
'skaisti'=>['lv',],
'skal'=>['da','is','nb','no',],
'skala'=>['id',],
'skall'=>['sv',],
'skaltu'=>['is',],
'skamba'=>['lt',],
'skarbie'=>['pl',],
'skat'=>['da',],
'skaties'=>['lv',],
'skatieties'=>['lv',],
'skatt'=>['nb','no',],
'skauda'=>['lt',],
'skaut'=>['is',],
'ske'=>['da',],
'skend'=>['af',],
'skep'=>['af',],
'skeptis'=>['id',],
'sker'=>['da',],
'sket'=>['da',],
'skete'=>['da',],
'skicka'=>['sv',],
'skickade'=>['sv',],
'skickar'=>['sv',],
'skid'=>['da',],
'skide'=>['da',],
'skiff'=>['th',],
'skikkelig'=>['nb','no',],
'skil'=>['is',],
'skilið'=>['is',],
'skilja'=>['is',],
'skilur'=>['is',],
'skilurðu'=>['is',],
'skipta'=>['is',],
'skipti'=>['is',],
'skiptir'=>['is',],
'skit'=>['sv',],
'skiten'=>['sv',],
'skitsnack'=>['sv',],
'skje'=>['nb','no',],
'skjedd'=>['nb','no',],
'skjedde'=>['nb','no',],
'skjer'=>['nb','no',],
'skjut'=>['sv',],
'skjuta'=>['sv',],
'skjuter'=>['sv',],
'skjóta'=>['is',],
'skjønner'=>['nb','no',],
'skjøt'=>['nb','no',],
'sko'=>['is',],
'skojar'=>['sv',],
'skolan'=>['sv',],
'skolas'=>['lv',],
'skole'=>['da',],
'skolen'=>['da','nb','no',],
'skolā'=>['lv',],
'skoonheid'=>['af',],
'skoraj'=>['sl',],
'skoro'=>['bs','cs','hr','pl','sk','sr',],
'skouer'=>['af',],
'skozi'=>['sl',],
'skrbi'=>['sl',],
'skreniti'=>['hi',],
'skrev'=>['da','nb','no','sv',],
'skrevet'=>['da','nb',],
'skrid'=>['da',],
'skrien'=>['lv',],
'skrifa'=>['is',],
'skriva'=>['sv',],
'skrive'=>['da','nb','no',],
'skriver'=>['da','nb','no','sv',],
'skryf'=>['af',],
'skudt'=>['da',],
'skuldgevoelens'=>['af',],
'skull'=>['sv',],
'skulle'=>['da','nb','no','sv',],
'skulum'=>['is',],
'skupaj'=>['sl',],
'skurke'=>['af',],
'skutečně'=>['cs',],
'skutočne'=>['sk',],
'skutočnosti'=>['sk',],
'skutt'=>['nb','no',],
'skvelé'=>['sk',],
'skvelý'=>['sk',],
'skvěle'=>['cs',],
'skvělé'=>['cs',],
'skvělý'=>['cs',],
'sky'=>['si',],
'skyd'=>['da',],
'skydda'=>['sv',],
'skyde'=>['da',],
'skyder'=>['da',],
'skyld'=>['da','nb','no',],
'skylder'=>['da','nb','no',],
'skyldi'=>['is',],
'skyldig'=>['sv',],
'skynd'=>['da','nb','no',],
'skynda'=>['sv',],
'skyt'=>['nb','no',],
'skyte'=>['nb','no',],
'skyter'=>['nb','no',],
'skål'=>['nb','no',],
'skôr'=>['sk',],
'sköt'=>['sv',],
'skød'=>['da',],
'skør'=>['da',],
'skús'=>['sk',],
'skąd'=>['pl',],
'sla'=>['nl',],
'slaaf'=>['af',],
'slaan'=>['nl',],
'slaap'=>['af','nl',],
'slabo'=>['sl',],
'slag'=>['af',],
'slags'=>['da','nb','no',],
'slagter'=>['af',],
'slap'=>['da',],
'slapen'=>['nl',],
'slapp'=>['nb','no',],
'slecht'=>['nl',],
'slechte'=>['nl',],
'slechts'=>['nl',],
'sledeжi'=>['sr',],
'sledi'=>['sl',],
'sleep'=>['en',],
'sleepin'=>['af',],
'sleepover'=>['si',],
'sleg'=>['af',],
'slegs'=>['af',],
'slegte'=>['af',],
'slemt'=>['da',],
'slepkava'=>['lv',],
'sleppa'=>['is',],
'slepptu'=>['is',],
'slet'=>['da',],
'sleutel'=>['af','nl',],
'slečna'=>['sk',],
'slečno'=>['cs',],
'slik'=>['nb','no',],
'slikt'=>['nb',],
'slikti'=>['lv',],
'slim'=>['nl',],
'slip'=>['da',],
'slipp'=>['nb','no',],
'slippe'=>['da','nb','no',],
'slipper'=>['nb','no',],
'slišal'=>['sl',],
'slišala'=>['sl',],
'slišali'=>['sl',],
'slišati'=>['sl',],
'sliši'=>['sl',],
'slišim'=>['sl',],
'slišiš'=>['sl',],
'slo'=>['nb','no',],
'slog'=>['da','sv',],
'slot'=>['af',],
'slova'=>['cs',],
'slovo'=>['cs','sk',],
'slová'=>['sk',],
'slow'=>['en',],
'sluit'=>['af',],
'slujba'=>['ro',],
'slut'=>['da','sv',],
'sluta'=>['sv',],
'slutar'=>['sv',],
'slutet'=>['sv',],
'slutt'=>['nb','no',],
'slutte'=>['nb','no',],
'slučaj'=>['hr',],
'slučaju'=>['hr',],
'slušaj'=>['bs','hr',],
'slušajte'=>['hr',],
'službo'=>['sl',],
'sluиaj'=>['sr',],
'sluиaju'=>['sr',],
'sluљaj'=>['bs','hr','sr',],
'sluљajte'=>['sr',],
'slyšel'=>['cs',],
'slyšela'=>['cs',],
'slyšet'=>['cs',],
'slyšíš'=>['cs',],
'släpp'=>['sv',],
'slå'=>['da','nb','no','sv',],
'slået'=>['da',],
'slår'=>['da','nb','no','sv',],
'slås'=>['da',],
'slåss'=>['nb','no','sv',],
'slæmt'=>['is',],
'slíkt'=>['is',],
'smagu'=>['lt',],
'small'=>['en',],
'smart'=>['en','nb','no','sv',],
'sme'=>['sk',],
'smell'=>['en',],
'smem'=>['sl',],
'smettila'=>['it',],
'smeš'=>['sl',],
'smešno'=>['sl',],
'smeљno'=>['sr',],
'smid'=>['da',],
'smieklīgi'=>['lv',],
'smijem'=>['hr',],
'smiješno'=>['hr',],
'smiri'=>['bs','hr','sr',],
'smo'=>['bs','hr','sl','sr',],
'smoke'=>['en',],
'smrt'=>['bs','cs','hr','sl','sr',],
'smrti'=>['bs','cs','hr','sk','sl','sr',],
'smrzavaš'=>['hi',],
'smrť'=>['sk',],
'sms'=>['si',],
'smuk'=>['da',],
'smukke'=>['da',],
'smukt'=>['da',],
'smule'=>['da',],
'smysl'=>['cs',],
'smá'=>['is',],
'små'=>['da','nb','no','sv',],
'snaakse'=>['af',],
'snabbt'=>['sv',],
'snacka'=>['sv',],
'snackar'=>['sv',],
'snad'=>['cs',],
'snakk'=>['nb','no',],
'snakke'=>['da','nb','no',],
'snakker'=>['da','nb','no',],
'snakket'=>['nb','no',],
'snap'=>['nl',],
'snart'=>['da','nb','no','sv',],
'snažím'=>['cs','sk',],
'snel'=>['nl',],
'sneller'=>['nl',],
'snikken'=>['af',],
'snill'=>['nb','no',],
'snu'=>['nb','no',],
'snygg'=>['sv',],
'snyggt'=>['sv',],
'snáď'=>['sk',],
'snäll'=>['sv',],
'snälla'=>['sv',],
'snúa'=>['is',],
'snýst'=>['is',],
'so'=>['af','de','en','fa','it','si','sk','sl','th',],
'soa'=>['gl',],
'soal'=>['ms',],
'sob'=>['pt','pt_br',],
'soba'=>['sr',],
'sobald'=>['de',],
'sobi'=>['bs','hr','sl','sr',],
'sobib'=>['et',],
'sobie'=>['pl',],
'sobo'=>['sl',],
'sobom'=>['bs','hr','sr',],
'sobre'=>['ca','es','gl','pt','pt_br',],
'sobu'=>['bs','hr','sr',],
'sobą'=>['pl',],
'sobě'=>['cs',],
'soc'=>['ca',],
'sociais'=>['gl',],
'social'=>['gl',],
'socialista'=>['gl',],
'sociedade'=>['gl',],
'socorro'=>['pt_br',],
'sodat'=>['af',],
'soen'=>['af',],
'soet'=>['af',],
'soetste'=>['af',],
'soeur'=>['fr',],
'sofa'=>['is',],
'sofort'=>['de',],
'sogar'=>['de',],
'sogno'=>['it',],
'soha'=>['hu',],
'sohasem'=>['hu',],
'sohn'=>['de',],
'soi'=>['ca',],
'soilik'=>['eu',],
'soir'=>['fr',],
'soirée'=>['fr',],
'sois'=>['fr',],
'soit'=>['fr',],
'soita'=>['fi',],
'soitan'=>['fi',],
'soittaa'=>['fi',],
'sok'=>['hu',],
'soka'=>['eu',],
'sokak'=>['eu',],
'sokat'=>['hu',],
'sokkal'=>['hu',],
'sokáig'=>['hu',],
'sol'=>['ca','es','gl','pt','pt_br',],
'sola'=>['ca','es','it','la',],
'solange'=>['de',],
'solche'=>['de',],
'soldat'=>['ca',],
'soldi'=>['it',],
'soldiers'=>['th',],
'sole'=>['it',],
'soleil'=>['fr',],
'solet'=>['la',],
'soli'=>['it',],
'solis'=>['la',],
'solito'=>['it',],
'soll'=>['de',],
'sollen'=>['de',],
'sollst'=>['de',],
'sollte'=>['de',],
'sollten'=>['de',],
'solltest'=>['de',],
'solo'=>['es','it',],
'sols'=>['ca',],
'soltanto'=>['it',],
'solución'=>['gl',],
'solum'=>['la',],
'solus'=>['la',],
'som'=>['ca','da','nb','no','sk','sv',],
'some'=>['en',],
'somebody'=>['en',],
'somente'=>['pt_br',],
'someone'=>['en',],
'something'=>['en','si','th',],
'sometimes'=>['en','si',],
'somewhere'=>['en',],
'sommes'=>['fr',],
'sommige'=>['af','nl',],
'somni'=>['ca',],
'somos'=>['es','gl','pt','pt_br',],
'soms'=>['af','nl',],
'son'=>['af','az','ca','en','es','fr','gl','sv','tr',],
'sonde'=>['af',],
'sonder'=>['af',],
'sondern'=>['de',],
'song'=>['en',],
'sonho'=>['pt','pt_br',],
'sonne'=>['de',],
'sono'=>['it',],
'sonra'=>['az','tr',],
'sonraki'=>['tr',],
'sonst'=>['de',],
'sonsuza'=>['tr',],
'sont'=>['fr',],
'sonte'=>['sq',],
'sonu'=>['tr',],
'sonunda'=>['tr',],
'sonur'=>['is',],
'soon'=>['en',],
'soort'=>['af','nl',],
'soorte'=>['af',],
'soos'=>['af',],
'soovid'=>['et',],
'soovin'=>['et',],
'soovite'=>['et',],
'sopar'=>['ca',],
'sopii'=>['fi',],
'sopra'=>['it',],
'sora'=>['ro',],
'sorella'=>['it',],
'sorg'=>['af',],
'sorge'=>['af','de',],
'sorgen'=>['de',],
'sorpresa'=>['ca','eu','it',],
'sorry'=>['en','nl','si','th',],
'sors'=>['fr',],
'sort'=>['ca','da','en','fr',],
'sorte'=>['da','fr','gl','pt','pt_br',],
'sortez'=>['fr',],
'sorti'=>['fr',],
'sortie'=>['fr',],
'sortir'=>['ca','fr',],
'soru'=>['tr',],
'sorun'=>['tr',],
'sose'=>['hu',],
'sosem'=>['hu',],
'sosial'=>['id',],
'sot'=>['sq',],
'sota'=>['ca',],
'sotto'=>['it',],
'sou'=>['af','ca','pt','pt_br',],
'soube'=>['pt','pt_br',],
'soul'=>['en',],
'sound'=>['en',],
'sounds'=>['en',],
'sous'=>['fr',],
'south'=>['en',],
'souvent'=>['fr',],
'souviens'=>['fr',],
'sov'=>['nb','no','sv',],
'sova'=>['sv',],
'sove'=>['da','nb','no',],
'sover'=>['da','nb','no','sv',],
'sovint'=>['ca',],
'sovražim'=>['sl',],
'soy'=>['es',],
'soyez'=>['fr',],
'sozinha'=>['pt','pt_br',],
'sozinho'=>['pt','pt_br',],
'soğuk'=>['tr',],
'soţia'=>['ro',],
'soţul'=>['ro',],
'space'=>['th',],
'spate'=>['ro',],
'spatele'=>['ro',],
'spavati'=>['hr',],
'spaß'=>['de',],
'spać'=>['pl',],
'spať'=>['sk',],
'spe'=>['la',],
'speak'=>['en',],
'speaking'=>['en',],
'special'=>['en','ro','si',],
'speciale'=>['it',],
'specie'=>['it',],
'speciellt'=>['sv',],
'species'=>['la',],
'speel'=>['af',],
'speelt'=>['nl',],
'spel'=>['af','nl','sv',],
'spela'=>['sv',],
'spelar'=>['sv',],
'spelen'=>['nl',],
'spem'=>['la',],
'spend'=>['en',],
'spent'=>['th',],
'sper'=>['ro',],
'speriat'=>['ro',],
'spero'=>['it',],
'spes'=>['la',],
'spesie'=>['af',],
'spesielt'=>['nb','no',],
'spesies'=>['id',],
'spesso'=>['it',],
'spet'=>['sl',],
'spiace'=>['it',],
'spiel'=>['de',],
'spielen'=>['de',],
'spielt'=>['de',],
'spijt'=>['nl',],
'spil'=>['da',],
'spila'=>['is',],
'spill'=>['nb','no',],
'spille'=>['da','nb','no',],
'spiller'=>['da','nb','no',],
'spiritu'=>['la',],
'spiritum'=>['la',],
'spiritus'=>['la',],
'spise'=>['da','nb','no',],
'spiser'=>['da','nb','no',],
'spital'=>['ro','sq',],
'sploh'=>['sl',],
'spock'=>['ca',],
'spodaj'=>['sl',],
'spokojnie'=>['pl',],
'spokoju'=>['pl',],
'spokój'=>['pl',],
'spoločnosť'=>['sk',],
'spolu'=>['cs','sk',],
'spomnim'=>['sl',],
'spomniš'=>['sl',],
'sponte'=>['la',],
'spor'=>['da',],
'sporočilo'=>['sl',],
'sposób'=>['pl',],
'spotièem'=>['hi',],
'spotkanie'=>['pl',],
'spotkać'=>['pl',],
'spoustu'=>['cs',],
'spoznal'=>['sl',],
'spoznala'=>['sl',],
'spravi'=>['sl',],
'spravil'=>['sk',],
'spraviť'=>['sk',],
'sprawa'=>['pl',],
'sprawdzić'=>['pl',],
'sprawie'=>['pl',],
'sprawy'=>['pl',],
'sprawę'=>['pl',],
'spre'=>['ro',],
'sprechen'=>['de',],
'spreek'=>['nl',],
'spreken'=>['nl',],
'spreman'=>['bs','hr','sr',],
'spremna'=>['bs','hr','sr',],
'spremni'=>['bs','hr','sr',],
'spricht'=>['de',],
'spring'=>['af','sv',],
'správne'=>['sk',],
'správně'=>['cs',],
'správy'=>['sk',],
'spróbuj'=>['pl',],
'sprø'=>['nb','no',],
'spui'=>['ro',],
'spullen'=>['nl',],
'spun'=>['ro',],
'spune'=>['ro',],
'spunem'=>['ro',],
'spuneţi'=>['ro',],
'spună'=>['ro',],
'spurgte'=>['da',],
'spurte'=>['nb','no',],
'spus'=>['ro',],
'spusti'=>['bs','sl',],
'spyrja'=>['is',],
'spyte'=>['af',],
'spát'=>['cs',],
'spät'=>['de',],
'später'=>['de',],
'späť'=>['sk',],
'spíš'=>['cs',],
'spójrz'=>['pl',],
'spôsob'=>['sk',],
'spør'=>['nb','no',],
'spørge'=>['da',],
'spørger'=>['da',],
'spørgsmål'=>['da',],
'spørre'=>['nb','no',],
'spørsmål'=>['nb','no',],
'spēj'=>['lv',],
'spēku'=>['lv',],
'spēle'=>['lv',],
'spēles'=>['lv',],
'spēli'=>['lv',],
'spēlē'=>['lv',],
'spēlēt'=>['lv',],
'squadra'=>['it',],
'sr'=>['ca','es','pt','pt_br',],
'sra'=>['ca','es','pt','pt_br',],
'srandu'=>['sk',],
'sranja'=>['bs','hr','sr',],
'sranje'=>['bs','hr','sl','sr',],
'srce'=>['bs','hr','sl','sr',],
'srdce'=>['cs','sk',],
'srediti'=>['hr',],
'sretan'=>['bs','hr',],
'sretna'=>['hr',],
'sretno'=>['hr',],
'srečen'=>['sl',],
'srečno'=>['sl',],
'srečo'=>['sl',],
'sreжan'=>['sr',],
'sreжe'=>['sr',],
'sri'=>['af',],
'srta'=>['ca','es','pt_br',],
'srác'=>['hu',],
'srácok'=>['hu',],
'srček'=>['sl',],
'sta'=>['bs','it','nl','ro','sl','sr',],
'staan'=>['af','nl',],
'staar'=>['af',],
'staat'=>['af','nl',],
'stad'=>['nl',],
'staden'=>['sv',],
'stadig'=>['da','no',],
'stadt'=>['de',],
'stai'=>['it','ro',],
'stakkars'=>['nb',],
'stalno'=>['bs','hr','sr',],
'stalo'=>['cs','lt','sk',],
'stam'=>['af',],
'stan'=>['hr','sv',],
'stand'=>['de','en',],
'standa'=>['is',],
'standing'=>['en',],
'stane'=>['cs','sk',],
'stani'=>['bs','hr','sr',],
'stanie'=>['pl',],
'stanna'=>['sv',],
'stannar'=>['sv',],
'stanno'=>['it',],
'stanotte'=>['it',],
'stans'=>['nb',],
'stanza'=>['it',],
'stap'=>['nl',],
'star'=>['en','si','sl','th',],
'stara'=>['bs','hr','sl',],
'starb'=>['de',],
'stare'=>['it','ro',],
'starf'=>['is',],
'stari'=>['bs','hr','sl','sr',],
'stark'=>['de','sv',],
'starosti'=>['cs',],
'starp'=>['lv',],
'stars'=>['th',],
'start'=>['en',],
'starte'=>['da',],
'started'=>['en',],
'starter'=>['da',],
'starts'=>['si',],
'stary'=>['pl',],
'stará'=>['cs','sk',],
'starý'=>['cs','sk',],
'stasera'=>['it',],
'stasiun'=>['id',],
'stat'=>['ro',],
'stata'=>['it',],
'state'=>['en','it',],
'stati'=>['it',],
'statim'=>['la',],
'station'=>['en',],
'stato'=>['it',],
'stattu'=>['is',],
'stau'=>['ro',],
'stava'=>['it',],
'stavi'=>['bs','hr','sr',],
'stavljm'=>['hi',],
'stavo'=>['it',],
'stay'=>['en','si',],
'stað'=>['is',],
'staðar'=>['is',],
'staðinn'=>['is',],
'staður'=>['is',],
'stać'=>['pl',],
'stačí'=>['cs','sk',],
'stało'=>['pl',],
'staţi'=>['ro',],
'stať'=>['sk',],
'ste'=>['bs','hr','sk','sl','sr',],
'stea'=>['ro',],
'sted'=>['da','nb','no',],
'steder'=>['da','nb','no',],
'stedet'=>['da','nb','no',],
'steeds'=>['af','nl',],
'steek'=>['nl',],
'steel'=>['af',],
'steenkool'=>['af',],
'steh'=>['de',],
'stehen'=>['de',],
'steht'=>['de',],
'stejně'=>['cs',],
'stel'=>['nl',],
'stelle'=>['de',],
'stellen'=>['de','nl',],
'stelpa'=>['is',],
'stem'=>['nl',],
'stemme'=>['da',],
'stemmer'=>['nb','no',],
'stendur'=>['is',],
'step'=>['en',],
'sterben'=>['de',],
'sterf'=>['af',],
'sterk'=>['nb','nl',],
'sterre'=>['af',],
'stert'=>['af',],
'sterte'=>['af',],
'sterven'=>['nl',],
'sterwe'=>['af',],
'stessa'=>['it',],
'stesso'=>['it',],
'stia'=>['it',],
'stiamo'=>['it',],
'stick'=>['en','sv','th',],
'sticka'=>['sv',],
'sticker'=>['sv',],
'stie'=>['ro',],
'stigao'=>['sr',],
'stii'=>['ro',],
'stikk'=>['nb','no',],
'stikke'=>['nb','no',],
'stikker'=>['nb','no',],
'stil'=>['da','nl',],
'still'=>['de','en','th',],
'stille'=>['af','da','nb','no',],
'stimme'=>['de',],
'stimmt'=>['de',],
'stiu'=>['ro',],
'stjórn'=>['is',],
'sto'=>['bs','hr','it','nb','no','sr',],
'stod'=>['da','sv',],
'stoel'=>['af',],
'stoj'=>['sl',],
'stojí'=>['cs','sk',],
'stok'=>['lt',],
'stole'=>['da','nb','no',],
'stoler'=>['nb','no',],
'stolt'=>['da','nb','no','sv',],
'stolz'=>['de',],
'stom'=>['nl',],
'stomme'=>['nl',],
'stond'=>['nl',],
'stone'=>['th',],
'stop'=>['da','en','nl','si',],
'stopp'=>['nb','no','sv',],
'stoppa'=>['sv',],
'stoppe'=>['da','nb','no',],
'stopped'=>['en',],
'stoppen'=>['nl',],
'stopper'=>['da',],
'stor'=>['da','nb','no','sv',],
'stora'=>['sv',],
'store'=>['da','nb','no',],
'storia'=>['it',],
'storie'=>['af',],
'stories'=>['af',],
'storil'=>['sl',],
'storila'=>['sl',],
'storiti'=>['sl',],
'stort'=>['da','nb','no','sv',],
'storte'=>['af',],
'story'=>['en',],
'stovi'=>['lt',],
'straat'=>['nl',],
'strach'=>['cs','sk',],
'strada'=>['it',],
'strah'=>['sl',],
'straight'=>['en',],
'straks'=>['da','nb','nl','no',],
'strale'=>['af',],
'stran'=>['sl',],
'strand'=>['af',],
'strane'=>['bs','hr','sk','sr',],
'strange'=>['en',],
'strani'=>['bs','sl',],
'strano'=>['it',],
'straně'=>['cs',],
'strasznie'=>['pl',],
'stratil'=>['sk',],
'strax'=>['is','sv',],
'straße'=>['de',],
'strašne'=>['sk',],
'strašně'=>['cs',],
'straљno'=>['sr',],
'street'=>['en',],
'stretnúť'=>['sk',],
'stric'=>['sl',],
'strik'=>['af',],
'string'=>['id',],
'striped'=>['si',],
'strong'=>['en',],
'stronie'=>['pl',],
'strony'=>['pl',],
'stronzo'=>['it',],
'stronę'=>['pl',],
'struktur'=>['id',],
'struktuur'=>['af',],
'strákar'=>['is',],
'strákur'=>['is',],
'strýko'=>['sk',],
'strādā'=>['lv',],
'strādāju'=>['lv',],
'studied'=>['th',],
'studio'=>['la',],
'stuff'=>['en','th',],
'stuk'=>['nl',],
'stund'=>['is','nb','no','sv',],
'stundas'=>['lv',],
'stunde'=>['de',],
'stunden'=>['de',],
'stundum'=>['is',],
'stupid'=>['en','th',],
'stupido'=>['it',],
'sturen'=>['nl',],
'stuur'=>['af','nl',],
'stvar'=>['bs','hr','sl','sr',],
'stvari'=>['bs','hr','sl','sr',],
'stvarno'=>['bs','hr','sr',],
'stykke'=>['da',],
'stykker'=>['da',],
'stále'=>['cs','sk',],
'stát'=>['cs',],
'ställa'=>['sv',],
'ställe'=>['sv',],
'stället'=>['sv',],
'stämmer'=>['sv',],
'stäng'=>['sv',],
'stå'=>['da','nb','no','sv',],
'står'=>['da','nb','no','sv',],
'stærk'=>['da',],
'stój'=>['pl',],
'stór'=>['is',],
'större'=>['sv',],
'största'=>['sv',],
'større'=>['da','nb','no',],
'største'=>['da','nb','no',],
'stück'=>['de',],
'stāsts'=>['lv',],
'stāstu'=>['lv',],
'stă'=>['ro',],
'stąd'=>['pl',],
'su'=>['bs','es','et','fr','hr','it','lt','sk','sr','tr',],
'sua'=>['it','la','pt','pt_br',],
'suae'=>['la',],
'suam'=>['la',],
'suami'=>['ms',],
'suara'=>['id','ms',],
'suas'=>['la','pt','pt_br',],
'suasana'=>['id',],
'suatu'=>['id','ms',],
'sub'=>['la','ms','ro','th',],
'subito'=>['it',],
'subs'=>['si',],
'subtitle'=>['si','th',],
'subtitled'=>['si','th',],
'subtitles'=>['th',],
'succede'=>['it',],
'succedendo'=>['it',],
'succes'=>['nl',],
'successo'=>['it',],
'sucede'=>['es',],
'such'=>['en',],
'suche'=>['de',],
'suchen'=>['de',],
'sud'=>['ca','fr',],
'sudah'=>['id','ms',],
'sue'=>['it',],
'suelo'=>['es',],
'suena'=>['es',],
'suerte'=>['es',],
'sueño'=>['es',],
'suffer'=>['si',],
'suffit'=>['fr',],
'suficient'=>['ro',],
'suficiente'=>['es','pt','pt_br',],
'sugriv'=>['af',],
'suhas'=>['si',],
'suhtes'=>['et',],
'suhu'=>['id',],
'sui'=>['it','la',],
'suis'=>['fr','la',],
'suite'=>['fr',],
'suivre'=>['fr',],
'suiwer'=>['af',],
'sujet'=>['fr',],
'suka'=>['ms',],
'sukalde'=>['eu',],
'sul'=>['et','it','pt','pt_br',],
'sulit'=>['id','ms',],
'sulke'=>['af',],
'sulla'=>['it',],
'sulle'=>['et','it',],
'sulten'=>['da','nb','no',],
'sum'=>['la',],
'sumber'=>['id',],
'sumeria'=>['id',],
'sumir'=>['is',],
'sumitra'=>['af',],
'summa'=>['la',],
'summarize'=>['si',],
'summo'=>['la',],
'summum'=>['la',],
'sumus'=>['la',],
'sun'=>['en','fi','ro',],
'suna'=>['ro',],
'sunat'=>['ro',],
'sungai'=>['id','ms',],
'sungguh'=>['ms',],
'sunku'=>['lt',],
'sunnier'=>['hi',],
'sunrise'=>['th',],
'sunrisevampire'=>['th',],
'suns'=>['lv',],
'sunt'=>['la','ro',],
'suntem'=>['ro',],
'sunteti'=>['ro',],
'sunteţi'=>['ro',],
'sună'=>['ro',],
'suo'=>['it','la',],
'suoi'=>['it',],
'suoraan'=>['fi',],
'suorum'=>['la',],
'suos'=>['la',],
'super'=>['bs','cs','de','fr','hr','id','la','pl','ro','sk','sl','sr',],
'superior'=>['gl',],
'supone'=>['es',],
'supongo'=>['es',],
'suposo'=>['ca',],
'suppose'=>['en','fr',],
'supposed'=>['en','th',],
'supra'=>['la',],
'supranti'=>['lt',],
'suprantu'=>['lt',],
'suprasti'=>['lt',],
'supratai'=>['lt',],
'supratau'=>['lt',],
'supuesto'=>['es',],
'supón'=>['gl',],
'sur'=>['da','fr',],
'surasti'=>['lt',],
'surat'=>['ms',],
'sure'=>['en','si',],
'suri'=>['et',],
'surma'=>['et',],
'surnud'=>['et',],
'surphanaka'=>['af',],
'surpresa'=>['pt','pt_br',],
'surprise'=>['en','fr',],
'surt'=>['ca',],
'surtout'=>['fr',],
'suruphanaka'=>['af',],
'surut'=>['id',],
'surya'=>['id',],
'sus'=>['es','ro',],
'susipažinti'=>['lt',],
'susitikti'=>['lt',],
'suster'=>['af',],
'sutra'=>['bs','hr','sr',],
'suu'=>['et',],
'suuda'=>['et',],
'suudad'=>['et',],
'suum'=>['la',],
'suur'=>['et',],
'suure'=>['et',],
'suured'=>['et',],
'suurepärane'=>['et',],
'suuri'=>['fi',],
'suurt'=>['et',],
'suutnud'=>['et',],
'suzdržavaj'=>['hi',],
'sužinoti'=>['lt',],
'sva'=>['bs','hr','sl','sr',],
'svakako'=>['hr','sr',],
'svaki'=>['bs','hr','sr',],
'svako'=>['bs','sr',],
'svakog'=>['bs','hr','sr',],
'svakom'=>['bs','sr',],
'svar'=>['da','nb','no','sv',],
'svara'=>['is','sv',],
'svarbiausia'=>['lt',],
'svarbu'=>['lt',],
'svart'=>['nb','no','sv',],
'svarta'=>['sv',],
'svarte'=>['nb','no',],
'svarīgi'=>['lv',],
'svaðajte'=>['hi',],
'sve'=>['bs','hr','sr',],
'svega'=>['bs','hr','sr',],
'sveika'=>['lt','lv',],
'sveikas'=>['lt',],
'sveiki'=>['lt','lv',],
'sveikinu'=>['lt',],
'sveiks'=>['lv',],
'svet'=>['sk','sl','sr',],
'sveta'=>['sk','sl','sr',],
'svete'=>['sk',],
'svetlo'=>['sk',],
'svetu'=>['sl','sr',],
'svi'=>['bs','hr','sr',],
'svih'=>['bs','hr','sr',],
'svijet'=>['bs','hr',],
'svijeta'=>['bs','hr',],
'svijetu'=>['bs','hr',],
'svim'=>['bs','hr','sr',],
'svima'=>['bs','hr','sr',],
'svin'=>['da',],
'sviđa'=>['bs','hr',],
'sviрa'=>['bs','sr',],
'svo'=>['is',],
'svog'=>['bs','hr','sr',],
'svoj'=>['bs','hr','sk','sl','sr',],
'svoje'=>['bs','cs','hr','sk','sl','sr',],
'svojega'=>['sl',],
'svojej'=>['sk',],
'svojho'=>['sk',],
'svoji'=>['cs','sl',],
'svojich'=>['sk',],
'svojih'=>['sl',],
'svojim'=>['bs','hr','sl','sr',],
'svojo'=>['sl',],
'svojoj'=>['bs','hr','sr',],
'svojom'=>['sk',],
'svoju'=>['bs','hr','sk','sr',],
'svolítið'=>['is',],
'svom'=>['bs','hr','sr',],
'svona'=>['is',],
'svou'=>['cs',],
'svuda'=>['bs','sr',],
'svårt'=>['sv',],
'svært'=>['da','nb','no',],
'své'=>['cs',],
'svého'=>['cs',],
'svém'=>['cs',],
'svých'=>['cs',],
'svým'=>['cs',],
'svēto'=>['lv',],
'svět'=>['cs',],
'světa'=>['cs',],
'světě'=>['cs',],
'svůj'=>['cs',],
'swaar'=>['af',],
'swaarkry'=>['af',],
'swanger'=>['af',],
'swear'=>['en',],
'sweet'=>['en',],
'sweetie'=>['af',],
'swoich'=>['pl',],
'swoim'=>['pl',],
'swoje'=>['pl',],
'swojego'=>['pl',],
'swojej'=>['pl',],
'swoją'=>['pl',],
'swój'=>['pl',],
'sy'=>['af','sq',],
'sydney'=>['ca',],
'syg'=>['da',],
'syk'=>['nb','no',],
'sykehuset'=>['nb',],
'syn'=>['cs','pl','sk',],
'syna'=>['cs','pl','sk',],
'synd'=>['nb','no','sv',],
'syndrome'=>['si',],
'synes'=>['da','nb','no',],
'syns'=>['nb','no',],
'syntes'=>['da',],
'synu'=>['pl',],
'system'=>['en',],
'syster'=>['sv',],
'systir'=>['is',],
'sytë'=>['sq',],
'syv'=>['da',],
'syy'=>['fi',],
'syytä'=>['fi',],
'syö'=>['fi',],
'syödä'=>['fi',],
'szabad'=>['hu',],
'szansę'=>['pl',],
'szar'=>['hu',],
'szart'=>['hu',],
'szczęście'=>['pl',],
'szefie'=>['pl',],
'szegény'=>['hu',],
'szemét'=>['hu',],
'szent'=>['hu',],
'szerelem'=>['hu',],
'szerelmes'=>['hu',],
'szerencsét'=>['hu',],
'szeret'=>['hu',],
'szereted'=>['hu',],
'szeretem'=>['hu',],
'szereti'=>['hu',],
'szeretlek'=>['hu',],
'szeretne'=>['hu',],
'szeretnék'=>['hu',],
'szeretnél'=>['hu',],
'szeretném'=>['hu',],
'szerint'=>['hu',],
'szerinted'=>['hu',],
'szerintem'=>['hu',],
'sześć'=>['pl',],
'szia'=>['hu',],
'szkoda'=>['pl',],
'szkole'=>['pl',],
'szkoły'=>['pl',],
'szybciej'=>['pl',],
'szybko'=>['pl',],
'szállj'=>['hu',],
'számomra'=>['hu',],
'számára'=>['hu',],
'számít'=>['hu',],
'szép'=>['hu',],
'szépen'=>['hu',],
'szét'=>['hu',],
'szívem'=>['hu',],
'szívesen'=>['hu',],
'szó'=>['hu',],
'szól'=>['hu',],
'szót'=>['hu',],
'szóval'=>['hu',],
'szörnyű'=>['hu',],
'szükség'=>['hu',],
'szüksége'=>['hu',],
'szükséged'=>['hu',],
'szükségem'=>['hu',],
'szükségünk'=>['hu',],
'sá'=>['is',],
'sám'=>['cs','sk',],
'sástu'=>['is',],
'sânge'=>['ro',],
'são'=>['pt','pt_br',],
'sä'=>['fi',],
'säg'=>['sv',],
'säga'=>['sv',],
'säger'=>['sv',],
'sägs'=>['sv',],
'säker'=>['sv',],
'säkert'=>['sv',],
'sälja'=>['sv',],
'särskilt'=>['sv',],
'sätt'=>['sv',],
'sätta'=>['sv',],
'sätter'=>['sv',],
'sättet'=>['sv',],
'så'=>['da','nb','no','sv',],
'sådan'=>['da','no',],
'såg'=>['sv',],
'sån'=>['sv',],
'såna'=>['sv',],
'sånn'=>['nb','no',],
'sånt'=>['nb','no','sv',],
'sækja'=>['is',],
'sæl'=>['is',],
'sæll'=>['is',],
'særlig'=>['nb','no',],
'sæt'=>['da',],
'sæti'=>['is',],
'sætte'=>['da',],
'sætter'=>['da',],
'sé'=>['ca','es','is',],
'século'=>['gl',],
'sécurité'=>['fr',],
'sér'=>['is',],
'sérieux'=>['fr',],
'sério'=>['pt','pt_br',],
'sért'=>['is',],
'sérð'=>['is',],
'sérðu'=>['is',],
'séu'=>['is',],
'séð'=>['is',],
'së'=>['sq',],
'sëmurë'=>['sq',],
'sërish'=>['sq',],
'sì'=>['it',],
'sí'=>['ca','es',],
'sín'=>['is',],
'sína'=>['is',],
'sínum'=>['is',],
'sítio'=>['pt',],
'síðan'=>['is',],
'síðar'=>['is',],
'síðasta'=>['is',],
'síðustu'=>['is',],
'sînt'=>['ro',],
'só'=>['gl','pt','pt_br',],
'sóc'=>['ca',],
'sólo'=>['es',],
'són'=>['ca',],
'sõber'=>['et',],
'sõbrad'=>['et',],
'sõda'=>['et',],
'sõna'=>['et',],
'söker'=>['sv',],
'sömu'=>['is',],
'sönder'=>['sv',],
'söt'=>['sv',],
'sötét'=>['hu',],
'söyle'=>['tr',],
'söyledi'=>['tr',],
'söyledim'=>['tr',],
'söyledin'=>['tr',],
'söyleme'=>['tr',],
'söylemek'=>['tr',],
'söylemiştim'=>['tr',],
'söyleyeyim'=>['tr',],
'söylüyor'=>['tr',],
'söylüyorsun'=>['tr',],
'söylüyorum'=>['tr',],
'söz'=>['tr',],
'söör'=>['et',],
'sød'=>['da',],
'søde'=>['da',],
'søn'=>['da',],
'sønn'=>['nb','no',],
'sønnen'=>['nb','no',],
'søster'=>['da','nb','no',],
'søt'=>['nb','no',],
'sú'=>['is','sk',],
'súa'=>['gl',],
'súas'=>['gl',],
'sûr'=>['fr',],
'sûre'=>['fr',],
'sûrement'=>['fr',],
'süda'=>['et',],
'süre'=>['tr',],
'sürekli'=>['tr',],
'sürü'=>['tr',],
'süü'=>['et',],
'süüa'=>['et',],
'sýna'=>['is',],
'sýndu'=>['is',],
'sāk'=>['lv',],
'sāka'=>['lv',],
'sāp'=>['lv',],
'sāra'=>['lv',],
'să'=>['ro',],
'săptămâna'=>['ro',],
'săptămâni'=>['ro',],
'săptămână'=>['ro',],
'său'=>['ro',],
'są'=>['pl',],
'sądzisz'=>['pl',],
'sądzę'=>['pl',],
'sėkmės'=>['lt',],
'sīkais'=>['lv',],
'sıcak'=>['tr',],
'sık'=>['tr',],
'sıkı'=>['tr',],
'sıra'=>['tr',],
'sıraya'=>['az',],
'sľubujem'=>['sk',],
'słowa'=>['pl',],
'słowo'=>['pl',],
'słuchaj'=>['pl',],
'słucham'=>['pl',],
'słyszałem'=>['pl',],
'słyszałeś'=>['pl',],
'słyszysz'=>['pl',],
'sœur'=>['fr',],
'sūnau'=>['lt',],
'sūnus'=>['lt',],
'səhifə'=>['az',],
'səhifəsi'=>['az',],
'sรช'=>['af',],
't'=>['ar','az','ca','da','de','en','fi','fr','hu','id','nb','nl','no','ro','si','sq','sv','th','zh_tw',],
'ta'=>['bs','ca','cs','et','fr','hr','lt','nb','no','pl','ro','sk','sl','sq','sr','sv',],
'taa'=>['lv','pl',],
'taas'=>['fi',],
'taber'=>['da',],
'tabi'=>['tr',],
'tabii'=>['tr',],
'table'=>['en','fr','si',],
'tabo'=>['sl',],
'tabrakan'=>['id',],
'taci'=>['ro',],
'tack'=>['sv',],
'tacka'=>['sv',],
'tad'=>['lt','lv',],
'tada'=>['bs','hr','lt','sr',],
'tadi'=>['ms',],
'tady'=>['cs',],
'tafel'=>['nl',],
'tag'=>['da','de','no','sv',],
'taga'=>['et',],
'tagad'=>['lv',],
'tagasi'=>['et',],
'tage'=>['da','de','no',],
'tagen'=>['de',],
'tager'=>['da','no',],
'tages'=>['de',],
'taget'=>['da',],
'tagit'=>['sv',],
'taha'=>['et','si',],
'tahab'=>['et',],
'tahad'=>['et',],
'tahaks'=>['et',],
'tahaksin'=>['et',],
'tahame'=>['et',],
'tahan'=>['et','ms',],
'tahansa'=>['fi',],
'tahate'=>['et',],
'tahavad'=>['et',],
'tahle'=>['cs',],
'tahmin'=>['tr',],
'tahtis'=>['et',],
'tahtnud'=>['et',],
'tahtsid'=>['et',],
'tahtsin'=>['et',],
'tahu'=>['id','ms',],
'tahun'=>['id','ms',],
'tai'=>['fi','lt','lv','ro',],
'taiaha'=>['eu',],
'taiaharekin'=>['eu',],
'taida'=>['fi',],
'taigi'=>['lt',],
'taip'=>['lt',],
'taisnība'=>['lv',],
'taitaa'=>['fi',],
'taj'=>['bs','hr','sr',],
'tajemství'=>['cs',],
'tajā'=>['lv',],
'tak'=>['cs','da','id','lv','ms','nb','no','pl','sk','sl',],
'taka'=>['is','pl',],
'takaisin'=>['fi',],
'takana'=>['fi',],
'takav'=>['bs','hr','sr',],
'takbokke'=>['af',],
'take'=>['en','fa','si','th',],
'takega'=>['sl',],
'taken'=>['en','th',],
'takes'=>['en',],
'takhle'=>['cs',],
'taki'=>['pl',],
'takia'=>['fi',],
'takich'=>['pl',],
'takie'=>['pl',],
'takiego'=>['pl',],
'takiej'=>['pl',],
'takim'=>['pl','sq',],
'taking'=>['en','th',],
'takip'=>['tr',],
'takið'=>['is',],
'takk'=>['is','nb','no',],
'takkan'=>['ms',],
'takmer'=>['sk',],
'tako'=>['bs','hr','sl','sr',],
'takohemi'=>['sq',],
'takoj'=>['sl',],
'takole'=>['sl',],
'takovou'=>['cs',],
'taková'=>['cs',],
'takové'=>['cs',],
'takového'=>['cs',],
'takový'=>['cs',],
'također'=>['hr',],
'takoрe'=>['sr',],
'takrat'=>['sl',],
'taksi'=>['lt',],
'takto'=>['sk',],
'taktu'=>['is',],
'takuar'=>['sq',],
'takut'=>['id','ms',],
'taky'=>['cs',],
'taká'=>['sk',],
'také'=>['cs','sk',],
'takú'=>['sk',],
'taký'=>['sk',],
'taką'=>['pl',],
'także'=>['pl',],
'takže'=>['cs','sk',],
'tal'=>['ca','da','es','et','gl','pt','pt_br',],
'tala'=>['is','sv',],
'talar'=>['is','sv',],
'talað'=>['is',],
'talaði'=>['is',],
'talaðu'=>['is',],
'tale'=>['da','no','ro','sl',],
'taler'=>['da',],
'talk'=>['en','th',],
'talked'=>['en',],
'talking'=>['en',],
'talle'=>['et',],
'tallesh'=>['sq',],
'talo'=>['fi',],
'talon'=>['fi',],
'talt'=>['da',],
'talte'=>['da',],
'talvez'=>['pt','pt_br',],
'találkoztunk'=>['hu',],
'találkozunk'=>['hu',],
'találtam'=>['hu',],
'talán'=>['hu',],
'tam'=>['cs','la','lt','lv','pl','sk','sl','tr',],
'tamaak'=>['si',],
'tamam'=>['sq','tr',],
'tamamen'=>['tr',],
'también'=>['es',],
'també'=>['ca',],
'também'=>['pt','pt_br',],
'tame'=>['lt',],
'tamen'=>['la',],
'tamhle'=>['cs',],
'tamo'=>['bs','hr','sr',],
'tampak'=>['id','ms',],
'tampaknya'=>['id','ms',],
'tampoc'=>['ca',],
'tampoco'=>['es',],
'tampouco'=>['gl',],
'tamquam'=>['la',],
'tamén'=>['gl',],
'tan'=>['ca','es','gl',],
'tanah'=>['id','ms',],
'tanaman'=>['id',],
'tanda'=>['id','ms',],
'tandarts'=>['af',],
'tandem'=>['la',],
'tane'=>['tr',],
'tangan'=>['id','ms',],
'tanganmu'=>['ms',],
'tanggal'=>['id',],
'tani'=>['sq',],
'tank'=>['si',],
'tanpa'=>['id','ms',],
'tanquam'=>['la',],
'tanrı'=>['tr',],
'tanrım'=>['tr',],
'tant'=>['ca','fr',],
'tanta'=>['ca','gl','la',],
'tantangan'=>['id',],
'tante'=>['it',],
'tanti'=>['it',],
'tanto'=>['es','gl','it','la','pt','pt_br',],
'tantos'=>['gl',],
'tantum'=>['la',],
'tanya'=>['ms',],
'tanzen'=>['de',],
'tanë'=>['sq',],
'tanıyor'=>['tr',],
'tapa'=>['et','fi',],
'tapahtui'=>['fi',],
'tapahtunut'=>['fi',],
'tapahtuu'=>['fi',],
'tapan'=>['et','fi',],
'tapauksessa'=>['fi',],
'tapi'=>['id','ms',],
'tapo'=>['lt',],
'tappa'=>['et',],
'tappaa'=>['fi',],
'tappis'=>['et',],
'tappoi'=>['fi',],
'tapsid'=>['et',],
'tapti'=>['lt',],
'tapu'=>['eu',],
'tar'=>['nb','no','sv',],
'tarafa'=>['tr',],
'taraftan'=>['tr',],
'tarafından'=>['tr',],
'tard'=>['ca','fr',],
'tarda'=>['ca',],
'tarde'=>['es','gl','pt','pt_br',],
'tardi'=>['it',],
'tare'=>['ro',],
'tarik'=>['ms',],
'tarix'=>['az',],
'tarkoitan'=>['fi',],
'tarkoitat'=>['fi',],
'tarkoittaa'=>['fi',],
'tarp'=>['lt',],
'tarpeeksi'=>['fi',],
'tarsi'=>['lt',],
'tart'=>['hu',],
'tartani'=>['hu',],
'tartok'=>['hu',],
'tartsd'=>['hu',],
'tarvitse'=>['fi',],
'tarvitsee'=>['fi',],
'tarvitsemme'=>['fi',],
'tarvitsen'=>['fi',],
'tarvitset'=>['fi',],
'tas'=>['lt','lv',],
'tasa'=>['et',],
'tash'=>['sq',],
'tashmë'=>['sq',],
'tat'=>['de',],
'tata'=>['bs','hr','id','pl','ro','sr',],
'tati'=>['cs','ro',],
'tatlı'=>['tr',],
'tatlım'=>['tr',],
'tato'=>['cs','pl',],
'tatt'=>['nb','no',],
'tată'=>['ro',],
'tatăl'=>['ro',],
'tau'=>['lt','ms','ro',],
'taula'=>['ca',],
'tava'=>['lv',],
'tavaliselt'=>['et',],
'tavalla'=>['fi',],
'tavas'=>['lv',],
'tavata'=>['fi',],
'tave'=>['lt',],
'taves'=>['lt',],
'tavi'=>['lv',],
'tavim'=>['lt',],
'tavimi'=>['lt',],
'tavo'=>['lt',],
'tavs'=>['lv',],
'tavu'=>['lv',],
'tavā'=>['lv',],
'tavęs'=>['lt',],
'tačiau'=>['lt',],
'taču'=>['lv',],
'taиno'=>['sr',],
'tchau'=>['pt_br',],
'tdk'=>['ms',],
'te'=>['af','bs','ca','es','et','fi','fr','gl','hr','hu','it','la','lv','nl','pl','pt','pt_br','ro','sl','sq','sr',],
'tea'=>['en','et',],
'teab'=>['et',],
'teach'=>['en','si',],
'teacher'=>['en',],
'tead'=>['et',],
'teada'=>['et',],
'teadma'=>['et',],
'teadnud'=>['et',],
'teadsid'=>['et',],
'teadsin'=>['et',],
'team'=>['de','en','nl',],
'teame'=>['et',],
'teamă'=>['ro',],
'tean'=>['et',],
'teate'=>['et',],
'teatro'=>['gl',],
'teavad'=>['et',],
'teba'=>['sk',],
'tebe'=>['bs','cs','hr','sk','sl','sr',],
'tebi'=>['bs','hr','sl','sr',],
'teboj'=>['sl',],
'tebou'=>['cs','sk',],
'tech'=>['si',],
'tecum'=>['la',],
'teda'=>['cs','et','sk',],
'tedd'=>['hu',],
'teden'=>['sl',],
'tedy'=>['cs',],
'tee'=>['et','fi',],
'teeb'=>['et',],
'teed'=>['et',],
'teeks'=>['et',],
'teel'=>['et',],
'teeme'=>['et',],
'teemme'=>['fi',],
'teen'=>['et','fi',],
'teet'=>['fi',],
'teete'=>['et',],
'teette'=>['fi',],
'teevad'=>['et',],
'tega'=>['sl',],
'tegelikult'=>['et',],
'tegema'=>['et',],
'tegemist'=>['et',],
'tegen'=>['nl',],
'tegi'=>['et',],
'tegid'=>['et',],
'tegin'=>['et',],
'tegnap'=>['hu',],
'tego'=>['pl',],
'tegu'=>['lt',],
'tegul'=>['lt',],
'tegye'=>['hu',],
'teh'=>['sl',],
'teha'=>['et',],
'tehdä'=>['fi',],
'tehdään'=>['fi',],
'tehke'=>['et',],
'tehlikeli'=>['tr',],
'tehnyt'=>['fi',],
'tehtud'=>['et',],
'tehty'=>['fi',],
'tehtävä'=>['fi',],
'tehát'=>['hu',],
'teica'=>['lv',],
'teici'=>['lv',],
'teicu'=>['lv',],
'teid'=>['et',],
'teidän'=>['fi',],
'teidät'=>['fi',],
'teie'=>['et',],
'teiega'=>['et',],
'teikt'=>['lv',],
'teil'=>['de','et',],
'teile'=>['et',],
'teille'=>['fi',],
'teillä'=>['fi',],
'tein'=>['fi',],
'teine'=>['et',],
'teinud'=>['et',],
'teise'=>['et',],
'teised'=>['et',],
'teisingai'=>['lt',],
'teist'=>['et',],
'teistä'=>['fi',],
'teisus'=>['lt',],
'teit'=>['fi',],
'teitä'=>['fi',],
'tej'=>['pl','sk','sl',],
'teje'=>['sq',],
'tejto'=>['sk',],
'tek'=>['bs','hr','is','sq','sr','tr',],
'tekanan'=>['id',],
'tekee'=>['fi',],
'tekemään'=>['fi',],
'teken'=>['nl',],
'tekevät'=>['fi',],
'teki'=>['fi',],
'tekisi'=>['fi',],
'tekið'=>['is',],
'teknik'=>['id',],
'teknis'=>['id',],
'teknologi'=>['id',],
'tekrar'=>['tr',],
'teks'=>['id','lt',],
'tekstityksen'=>['fi',],
'tekur'=>['is',],
'tel'=>['fr',],
'telah'=>['id','ms',],
'tele'=>['hu',],
'telefon'=>['bs','cs','da','de','hr','pl','ro','sl','sq','sr','sv','tr',],
'telefone'=>['pt','pt_br',],
'telefonen'=>['da','nb','no',],
'telefono'=>['it','lt',],
'telefonul'=>['ro',],
'telefoon'=>['nl',],
'telefón'=>['sk',],
'telepon'=>['ms',],
'teleskop'=>['id',],
'televisión'=>['gl',],
'teljes'=>['hu',],
'teljesen'=>['hu',],
'tell'=>['en','th',],
'tellement'=>['fr',],
'tellin'=>['af',],
'telling'=>['en','th',],
'telo'=>['sk','sr',],
'telèfon'=>['ca',],
'teléfono'=>['es',],
'tem'=>['pt','pt_br','sl',],
'tema'=>['et','gl',],
'temaga'=>['et',],
'teman'=>['id','ms',],
'temanku'=>['ms',],
'temast'=>['et',],
'temat'=>['pl',],
'tembak'=>['ms',],
'tembakan'=>['ms',],
'temi'=>['sl',],
'temiz'=>['tr',],
'temo'=>['es',],
'temos'=>['gl','pt','pt_br',],
'tempat'=>['id','ms',],
'tempel'=>['af',],
'tempi'=>['it',],
'templum'=>['la',],
'tempo'=>['gl','it','pt','pt_br',],
'tempora'=>['la',],
'tempore'=>['la',],
'temporibus'=>['la',],
'temporis'=>['la',],
'temporum'=>['la',],
'tempos'=>['gl','pt',],
'temps'=>['ca','fr',],
'tempus'=>['la',],
'temu'=>['pl','sl',],
'temukan'=>['id','ms',],
'ten'=>['af','cs','en','es','gl','lt','nl','pl','sk',],
'tenaga'=>['id',],
'tenang'=>['ms',],
'tende'=>['sq',],
'tendremos'=>['es',],
'tendrá'=>['es',],
'tendrás'=>['es',],
'tendré'=>['es',],
'tenemos'=>['es',],
'tenen'=>['ca',],
'tenente'=>['it','pt','pt_br',],
'tener'=>['es',],
'tenez'=>['fr',],
'tenga'=>['es',],
'tengah'=>['id','ms',],
'tengas'=>['es',],
'tenggelam'=>['id',],
'tengkorak'=>['id',],
'tengo'=>['es',],
'tenha'=>['pt','pt_br',],
'tenhle'=>['cs',],
'tenho'=>['pt','pt_br',],
'tenia'=>['ca',],
'tenido'=>['es',],
'teniente'=>['es',],
'tenim'=>['ca',],
'tenir'=>['ca','fr',],
'teniu'=>['ca',],
'tenk'=>['nb','no',],
'tenke'=>['nb','no',],
'tenker'=>['nb','no',],
'tenkt'=>['nb','no',],
'tenkte'=>['nb','no',],
'tenminste'=>['nl',],
'tenni'=>['hu',],
'tens'=>['ca','pt','pt_br',],
'tentando'=>['pt_br',],
'tentang'=>['id','ms',],
'tentar'=>['pt','pt_br',],
'tentara'=>['ms',],
'tente'=>['eu','pt_br',],
'tento'=>['cs','sk',],
'tentu'=>['id','ms',],
'tenía'=>['es',],
'tenías'=>['es',],
'teníem'=>['ca',],
'teori'=>['id',],
'tepat'=>['id','lv','ms',],
'tepër'=>['sq',],
'ter'=>['af','gl','nl','pt','pt_br','sl',],
'terakhir'=>['id','ms',],
'terako'=>['eu',],
'teraz'=>['pl','sk',],
'terbaik'=>['id','ms',],
'terbang'=>['id','ms',],
'terbentuk'=>['id',],
'terbesar'=>['id','ms',],
'terbuat'=>['id',],
'terbuka'=>['id','ms',],
'terceiro'=>['gl',],
'tercih'=>['tr',],
'terdekat'=>['id',],
'tere'=>['et',],
'teremos'=>['pt_br',],
'terhadap'=>['id','ms',],
'terhitung'=>['id',],
'teria'=>['pt','pt_br',],
'terima'=>['id','ms',],
'terimakasih'=>['ms',],
'terjadi'=>['id','ms',],
'terk'=>['tr',],
'terkait'=>['id',],
'terlalu'=>['id','ms',],
'terlambat'=>['ms',],
'terletak'=>['id',],
'terlihat'=>['id','ms',],
'terluka'=>['ms',],
'termasuk'=>['id',],
'terme'=>['af',],
'terminado'=>['es',],
'terminar'=>['pt_br',],
'terminat'=>['ro',],
'terminé'=>['fr',],
'termină'=>['ro',],
'természetesen'=>['hu',],
'terpisah'=>['id',],
'terra'=>['ca','gl','it','la','pt','pt_br',],
'terrae'=>['la',],
'terram'=>['la',],
'terrarum'=>['la',],
'terras'=>['gl',],
'terre'=>['fr',],
'terribile'=>['it',],
'terrible'=>['ca','en','es',],
'territorio'=>['gl',],
'terrível'=>['pt_br',],
'tersebut'=>['id','ms',],
'tersedia'=>['id',],
'tersisa'=>['id',],
'tertarik'=>['ms',],
'tertawa'=>['ms',],
'tertentu'=>['id',],
'tertinggi'=>['id',],
'tertium'=>['la',],
'tertutup'=>['id',],
'terug'=>['af','nl',],
'terus'=>['id','ms',],
'terutama'=>['id',],
'terve'=>['et','fi',],
'tervetuloa'=>['fi',],
'terwijl'=>['nl',],
'terwyl'=>['af',],
'terá'=>['gl','pt','pt_br',],
'tería'=>['gl',],
'tes'=>['fr','gl',],
'teslim'=>['tr',],
'tesoro'=>['it',],
'tessék'=>['hu',],
'testa'=>['it',],
'tesz'=>['hu',],
'teszi'=>['hu',],
'tetap'=>['id','ms',],
'tetapi'=>['id','ms',],
'tetralna'=>['hi',],
'tetszik'=>['hu',],
'tett'=>['hu',],
'tette'=>['hu',],
'tettem'=>['hu',],
'teu'=>['ca','gl','pt','pt_br',],
'teua'=>['ca',],
'teufel'=>['de',],
'teus'=>['ca','pt',],
'tev'=>['lv',],
'teva'=>['ca',],
'teve'=>['pt','pt_br',],
'teves'=>['ca',],
'tevi'=>['lv',],
'tevis'=>['lv',],
'tevī'=>['lv',],
'texto'=>['gl',],
'teña'=>['gl',],
'teñen'=>['gl',],
'teño'=>['gl',],
'teď'=>['cs',],
'teşekkür'=>['tr',],
'teşekkürler'=>['tr',],
'teško'=>['bs','hr',],
'też'=>['pl',],
'težave'=>['sl',],
'težko'=>['sl',],
'teљko'=>['sr',],
'tha'=>['sq',],
'thai'=>['th',],
'thaisubtitle'=>['th',],
'than'=>['en','th',],
'thank'=>['en','si',],
'thanks'=>['en','si','th',],
'thash'=>['sq',],
'thashë'=>['sq',],
'that'=>['en','fa','ms','si','th',],
'the'=>['ar','bg','bs','cs','da','de','en','es','fa','fi','fr','hr','hu','id','it','ko','lt','lv','ms','nb','nl','no','pl','pt','pt_br','ro','ru','si','sk','sl','sq','sr','sv','th','tr','zh_cn',],
'their'=>['en','th',],
'them'=>['en','si','sq','th',],
'themi'=>['sq',],
'then'=>['en','th',],
'there'=>['en','fa','si','th',],
'these'=>['en','th',],
'they'=>['af','en','fa','si','th',],
'thing'=>['en','th',],
'things'=>['en',],
'think'=>['en','th',],
'thinking'=>['en','th',],
'thinks'=>['en',],
'third'=>['en',],
'this'=>['en','fa','si','th',],
'thjesht'=>['sq',],
'thjeshtë'=>['sq',],
'thoja'=>['sq',],
'thomas'=>['th',],
'thoni'=>['sq',],
'thonë'=>['sq',],
'those'=>['en',],
'thoshte'=>['sq',],
'thotë'=>['sq',],
'though'=>['en',],
'thought'=>['en',],
'thousand'=>['en',],
'three'=>['en','th',],
'through'=>['en','th',],
'throw'=>['en',],
'thua'=>['sq',],
'thuaj'=>['sq',],
'thuash'=>['sq',],
'thuis'=>['nl',],
'thënë'=>['sq',],
'thërras'=>['sq',],
'ti'=>['bs','cs','da','es','gl','hr','hu','it','nb','no','pt','pt_br','ro','sk','sl','sq','sr',],
'tiba'=>['id','ms',],
'tibi'=>['la',],
'ticho'=>['cs','sk',],
'tici'=>['lv',],
'tickin'=>['af',],
'ticu'=>['lv',],
'tid'=>['da','nb','no','sv',],
'tidak'=>['id','ms',],
'tidakkah'=>['ms',],
'tide'=>['nb','no',],
'tiden'=>['da','nb','no','sv',],
'tidigare'=>['sv',],
'tidlig'=>['nb','no',],
'tidligere'=>['da','nb','no',],
'tidligt'=>['da',],
'tidspunkt'=>['da',],
'tidur'=>['id','ms',],
'tie'=>['lt','lv','sk',],
'tiedä'=>['fi',],
'tiedämme'=>['fi',],
'tiedän'=>['fi',],
'tiedät'=>['fi',],
'tiedäthän'=>['fi',],
'tiedätkö'=>['fi',],
'tiek'=>['lt','lv',],
'tiem'=>['lv',],
'tiempo'=>['es',],
'tien'=>['nl',],
'tienda'=>['es',],
'tiene'=>['es',],
'tienen'=>['es',],
'tienes'=>['es',],
'tieni'=>['it',],
'tiennyt'=>['fi',],
'tiens'=>['fr',],
'tierra'=>['es',],
'tiesa'=>['lt','lv',],
'tiesiai'=>['lt',],
'tiesin'=>['fi',],
'tiesiog'=>['lt',],
'tiesą'=>['lt',],
'tiesības'=>['lv',],
'tiesų'=>['lt',],
'tietenkin'=>['fi',],
'tieto'=>['sk',],
'tietysti'=>['fi',],
'tietää'=>['fi',],
'tieši'=>['lv',],
'tiešām'=>['lv',],
'tiež'=>['sk',],
'tiga'=>['id','ms',],
'tih'=>['bs','hr','sr',],
'tiho'=>['sl',],
'tii'=>['da','nb','no',],
'tiii'=>['sv',],
'tij'=>['sq',],
'tijd'=>['nl',],
'tijdens'=>['nl',],
'tijelo'=>['bs','hr',],
'tik'=>['lt','lv',],
'tika'=>['lv',],
'tikai'=>['lv',],
'tiki'=>['lt',],
'tikiu'=>['lt',],
'tikiuosi'=>['lt',],
'tikko'=>['lv',],
'tikpat'=>['lv',],
'tikra'=>['lt',],
'tikrai'=>['lt',],
'tikras'=>['lt',],
'tikriausiai'=>['lt',],
'tikrųjų'=>['lt',],
'tiks'=>['lv',],
'tiksimies'=>['lv',],
'tiksliai'=>['lt',],
'tikt'=>['lv',],
'til'=>['af','da','is','nb','no',],
'tilanne'=>['fi',],
'tilbage'=>['da','no',],
'tilbake'=>['nb','no',],
'tilbúin'=>['is',],
'tilbúinn'=>['is',],
'tilbúnir'=>['is',],
'tilgi'=>['nb',],
'till'=>['en','sv',],
'tillbaka'=>['sv',],
'tillräckligt'=>['sv',],
'tills'=>['sv',],
'tillsammans'=>['sv',],
'tillykke'=>['da',],
'tillë'=>['sq',],
'tim'=>['bs','hr','id','ms','sq','sr',],
'timata'=>['eu',],
'time'=>['da','en','fa','hr','nb','no','si','sq','th',],
'timer'=>['da','nb','no',],
'times'=>['en',],
'timmar'=>['sv',],
'timme'=>['sv',],
'timp'=>['ro',],
'timpul'=>['ro',],
'tinc'=>['ca',],
'tindakan'=>['id',],
'tine'=>['ro',],
'ting'=>['da','nb','no',],
'tingene'=>['da','nb','no',],
'tinggal'=>['id','ms',],
'tinggalkan'=>['ms',],
'tinggi'=>['id','ms',],
'tingkat'=>['id',],
'tingui'=>['ca',],
'tingut'=>['ca',],
'tinha'=>['pt','pt_br',],
'tinham'=>['pt','pt_br',],
'tinhas'=>['pt',],
'tinka'=>['lt',],
'tio'=>['ca','pt','pt_br','sv',],
'tip'=>['bs','hr','ro','sl','sr',],
'tipa'=>['hr',],
'tipe'=>['af','ca',],
'tipi'=>['sq',],
'tipis'=>['id',],
'tipo'=>['es','eu','gl','it','pt','pt_br',],
'tipos'=>['es','pt',],
'tipul'=>['ro',],
'tipus'=>['ca',],
'tira'=>['eu',],
'tirar'=>['pt','pt_br',],
'tire'=>['fr','pt_br',],
'tired'=>['en',],
'tirer'=>['fr',],
'tiro'=>['pt',],
'tisch'=>['de',],
'tisoč'=>['sl',],
'tista'=>['sl',],
'tiste'=>['sl',],
'tistega'=>['sl',],
'tisti'=>['sl',],
'tisto'=>['sl',],
'tiszta'=>['hu',],
'tisíc'=>['cs',],
'titan'=>['id',],
'titeket'=>['hu',],
'titik'=>['id','ms',],
'titra'=>['sq',],
'titrashqip'=>['sq',],
'titrimi'=>['sq',],
'titta'=>['sv',],
'tittar'=>['sv',],
'titulky'=>['cs','sk',],
'tive'=>['pt','pt_br',],
'tiver'=>['pt_br',],
'tivesse'=>['pt','pt_br',],
'tivo'=>['gl',],
'tizio'=>['it',],
'tiéd'=>['hu',],
'tiña'=>['gl',],
'tiñan'=>['gl',],
'tja'=>['da','de','sl','sv',],
'tjedan'=>['hr',],
'tjedna'=>['hr',],
'tjej'=>['sv',],
'tjejen'=>['sv',],
'tjejer'=>['sv',],
'tjeks'=>['af',],
'tjeneste'=>['da','nb','no',],
'tjera'=>['sq',],
'tjerë'=>['sq',],
'tjerët'=>['sq',],
'tjeta'=>['sq',],
'tjeter'=>['sq',],
'tjetrin'=>['sq',],
'tjetër'=>['sq',],
'tjänst'=>['sv',],
'tk'=>['si',],
'tko'=>['bs','hr',],
'tla'=>['sl',],
'tmerrshme'=>['sq',],
'tn'=>['ms',],
'to'=>['bs','cs','da','de','en','fa','hr','hu','lt','lv','ms','nb','no','pl','si','sk','sl','sq','sr','th','zh_cn',],
'toata'=>['ro',],
'toate'=>['ro',],
'toată'=>['ro',],
'tobie'=>['pl',],
'tobom'=>['bs','hr','sr',],
'tobą'=>['pl',],
'tobě'=>['cs',],
'toca'=>['ca',],
'tocar'=>['ca','pt','pt_br',],
'toch'=>['nl',],
'tochter'=>['de',],
'tocmai'=>['ro',],
'tod'=>['de','sl',],
'toda'=>['es','gl','pt','pt_br','sl',],
'todas'=>['es','gl','pt','pt_br',],
'todavía'=>['es',],
'today'=>['en',],
'todella'=>['fi',],
'todellakin'=>['fi',],
'todo'=>['es','gl','pt','pt_br',],
'todos'=>['es','gl','pt','pt_br',],
'todėl'=>['lt',],
'toe'=>['af','nl',],
'toegewyde'=>['af',],
'toekomst'=>['nl',],
'toen'=>['nl',],
'toestand'=>['af',],
'toevallig'=>['af',],
'toewyding'=>['af',],
'tog'=>['af','bs','da','hr','no','sr','sv',],
'toga'=>['bs','hr','sr',],
'toget'=>['nb',],
'together'=>['en',],
'tohi'=>['et',],
'tohle'=>['cs',],
'toho'=>['cs','sk',],
'tohoto'=>['cs',],
'tohto'=>['sk',],
'tohtori'=>['fi',],
'toi'=>['fr',],
'toimi'=>['fi',],
'toimii'=>['fi',],
'toimub'=>['et',],
'toinen'=>['fi',],
'toisen'=>['fi',],
'toista'=>['fi',],
'toivon'=>['fi',],
'toivottavasti'=>['fi',],
'toj'=>['bs','hr','sr',],
'tok'=>['nb','no',],
'toki'=>['fi',],
'tokia'=>['lt',],
'tokie'=>['lt',],
'tokio'=>['lt',],
'tokios'=>['lt',],
'tokiu'=>['lt',],
'tokią'=>['lt',],
'tokių'=>['lt',],
'toko'=>['ms',],
'tokom'=>['bs',],
'tokrat'=>['sl',],
'toks'=>['lt',],
'tokë'=>['sq',],
'tokį'=>['lt',],
'told'=>['en','si',],
'tole'=>['sl',],
'toli'=>['lt',],
'toliau'=>['lt',],
'tolik'=>['cs',],
'toliko'=>['bs','hr','sl','sr',],
'toll'=>['de',],
'tolong'=>['ms',],
'tom'=>['bs','cs','da','de','en','es','et','fi','fr','hr','hu','is','it','nb','nl','no','pl','pt','pt_br','ro','sk','sl','sr','sv','tr',],
'toma'=>['es','pt',],
'tomar'=>['es','gl','pt','pt_br',],
'tombe'=>['fr',],
'tomber'=>['fr',],
'tome'=>['bs','hr','pt_br','sr',],
'tomhle'=>['cs',],
'tomorrow'=>['en',],
'tomto'=>['cs','sk',],
'tomu'=>['cs','sk',],
'tomēr'=>['lv',],
'ton'=>['ca','fr','id',],
'tona'=>['sq',],
'toneelstuk'=>['af',],
'tonight'=>['en',],
'tonto'=>['es',],
'tonë'=>['sq',],
'too'=>['en','et','si','th',],
'took'=>['en',],
'toon'=>['et',],
'top'=>['en','si',],
'toppen'=>['sv',],
'toque'=>['pt_br',],
'tore'=>['et',],
'torec'=>['he',],
'torej'=>['sl',],
'torna'=>['ca','it',],
'tornar'=>['ca',],
'tornare'=>['it',],
'tornarà'=>['ca',],
'tornaré'=>['ca',],
'tornat'=>['ca',],
'tornato'=>['it',],
'tornem'=>['ca',],
'torni'=>['ca',],
'torno'=>['ca','it',],
'tos'=>['lt','lv',],
'tosi'=>['fi',],
'tosiaan'=>['fi',],
'tot'=>['af','ca','de','la','nl','ro',],
'tota'=>['ca','la',],
'total'=>['de','gl','id',],
'totalment'=>['ca',],
'totalmente'=>['es','pt_br',],
'totam'=>['la',],
'totdat'=>['nl',],
'totdeauna'=>['ro',],
'totes'=>['ca',],
'tothom'=>['ca',],
'toti'=>['ro',],
'totius'=>['la',],
'toto'=>['cs','la','sk',],
'tots'=>['ca',],
'totta'=>['fi',],
'totul'=>['ro',],
'totum'=>['la',],
'totuus'=>['fi',],
'totuşi'=>['ro',],
'tou'=>['cs','sk',],
'touch'=>['en','si',],
'touche'=>['fr',],
'tough'=>['en',],
'toujours'=>['fr',],
'tour'=>['fr',],
'tous'=>['fr',],
'tout'=>['fr',],
'toute'=>['fr',],
'toutes'=>['fr',],
'tovább'=>['hu',],
'town'=>['en',],
'točno'=>['bs','hr','sl',],
'toľko'=>['sk',],
'toţi'=>['ro',],
'toţii'=>['ro',],
'tra'=>['it',],
'trabajando'=>['es',],
'trabajar'=>['es',],
'trabajo'=>['es',],
'trabalha'=>['pt_br',],
'trabalhando'=>['pt_br',],
'trabalhar'=>['pt','pt_br',],
'trabalho'=>['pt','pt_br',],
'traballadores'=>['gl',],
'traballar'=>['gl',],
'traballo'=>['gl',],
'traballos'=>['gl',],
'tracta'=>['ca',],
'traducerea'=>['ro',],
'traduzione'=>['it',],
'trae'=>['es',],
'traff'=>['nb','no',],
'trage'=>['ro',],
'tragen'=>['de',],
'train'=>['en','fr',],
'traje'=>['es',],
'traks'=>['lv',],
'trane'=>['af',],
'tranquil'=>['ca',],
'tranquille'=>['fr',],
'tranquillo'=>['it',],
'tranquilo'=>['es',],
'transformeer'=>['af',],
'translate'=>['th',],
'translation'=>['si',],
'tras'=>['es','gl',],
'trata'=>['es','gl',],
'tratando'=>['es',],
'tratar'=>['pt',],
'tratatzen'=>['eu',],
'trato'=>['es',],
'tratta'=>['it',],
'traum'=>['de',],
'travail'=>['fr',],
'travaille'=>['fr',],
'travailler'=>['fr',],
'travlt'=>['da',],
'través'=>['es','gl',],
'trazer'=>['pt','pt_br',],
'tražim'=>['hr',],
'traћi'=>['sr',],
'traћim'=>['sr',],
'traћio'=>['sr',],
'tre'=>['da','it','nb','no','sq','sv',],
'treaba'=>['ro',],
'treabă'=>['ro',],
'treba'=>['bs','hr','sk','sl','sr',],
'trebaju'=>['bs','hr',],
'trebala'=>['bs','hr','sr',],
'trebali'=>['bs','hr','sr',],
'treball'=>['ca',],
'treballar'=>['ca',],
'trebalo'=>['bs','hr','sr',],
'trebam'=>['bs','hr',],
'trebamo'=>['bs','hr',],
'trebao'=>['bs','hr','sr',],
'trebaš'=>['bs','hr',],
'trebea'=>['eu',],
'trebui'=>['ro',],
'trebuia'=>['ro',],
'trebuie'=>['ro',],
'trebuit'=>['ro',],
'trece'=>['ro',],
'treci'=>['ro',],
'trecut'=>['ro',],
'trecută'=>['ro',],
'tredje'=>['sv',],
'tree'=>['af',],
'treffe'=>['nb','no',],
'treffen'=>['de',],
'treffers'=>['af',],
'trego'=>['sq',],
'tregoj'=>['sq',],
'tregon'=>['sq',],
'tregoni'=>['sq',],
'treguar'=>['sq',],
'trei'=>['ro',],
'trein'=>['af',],
'trek'=>['af','nl',],
'trekk'=>['nb',],
'trekken'=>['nl',],
'trem'=>['pt_br',],
'tren'=>['ca','es',],
'trenger'=>['nb','no',],
'trengte'=>['nb','no',],
'treno'=>['it',],
'trenutak'=>['bs','hr','sr',],
'trenutek'=>['sl',],
'trenutno'=>['bs','sl',],
'tres'=>['ca','es','gl','la',],
'tret'=>['ca',],
'treure'=>['ca',],
'trevlig'=>['sv',],
'trevligt'=>['sv',],
'tri'=>['bs','hr','sk','sl','sr',],
'tria'=>['la',],
'tribus'=>['la',],
'tried'=>['en',],
'triginta'=>['la',],
'trimis'=>['ro',],
'trinken'=>['de',],
'trip'=>['en',],
'tris'=>['lt',],
'triste'=>['es','fr','pt_br',],
'trivandrum'=>['af',],
'tro'=>['da','nb','no','sv',],
'troba'=>['ca',],
'trobar'=>['ca',],
'trobat'=>['ca',],
'trobes'=>['ca',],
'trobo'=>['ca',],
'trocha'=>['sk',],
'trochu'=>['cs','sk',],
'trochę'=>['pl',],
'trodde'=>['nb','no','sv',],
'troede'=>['da',],
'trois'=>['fr',],
'trop'=>['fr',],
'troppo'=>['it',],
'tror'=>['da','nb','no','sv',],
'trots'=>['nl',],
'trotzdem'=>['de',],
'trou'=>['af','fr',],
'trouble'=>['en',],
'trouve'=>['fr',],
'trouver'=>['fr',],
'trouvé'=>['fr',],
'trouwen'=>['nl',],
'trouwens'=>['nl',],
'trouxe'=>['pt','pt_br',],
'trova'=>['it',],
'trovare'=>['it',],
'trovato'=>['it',],
'trovo'=>['it',],
'trošku'=>['sk',],
'truc'=>['fr',],
'truca'=>['ca',],
'trucar'=>['ca',],
'trucs'=>['fr',],
'trudno'=>['pl',],
'true'=>['en','si',],
'trukuak'=>['eu',],
'trupin'=>['sq',],
'truputį'=>['lt',],
'trust'=>['en',],
'truth'=>['en',],
'try'=>['en',],
'trying'=>['en',],
'trys'=>['lt',],
'trzeba'=>['pl',],
'trzech'=>['pl',],
'trzy'=>['pl',],
'trzymaj'=>['pl',],
'trzymać'=>['pl',],
'trás'=>['pt','pt_br',],
'trátase'=>['gl',],
'träffa'=>['sv',],
'träffade'=>['sv',],
'träffas'=>['sv',],
'träffat'=>['sv',],
'træk'=>['da',],
'træt'=>['da',],
'très'=>['fr',],
'três'=>['pt','pt_br',],
'trött'=>['sv',],
'trúa'=>['is',],
'trúi'=>['is',],
'trīs'=>['lv',],
'tsoukalos'=>['id',],
'tta'=>['is',],
'tu'=>['bs','ca','cs','de','es','fr','hr','it','la','lt','lv','ms','pl','pt','pt_br','ro','sk','sl','sq','sr',],
'tua'=>['id','it','la','ms','pt','pt_br','sq',],
'tuae'=>['la',],
'tuaj'=>['sq',],
'tuaja'=>['sq',],
'tuam'=>['la',],
'tuan'=>['ms',],
'tuas'=>['la','pt',],
'tubli'=>['et',],
'tubuh'=>['id','ms',],
'tud'=>['hu',],
'tudi'=>['sl',],
'tudja'=>['hu',],
'tudjuk'=>['hu',],
'tudják'=>['hu',],
'tudjátok'=>['hu',],
'tudnak'=>['hu',],
'tudni'=>['hu',],
'tudo'=>['pt','pt_br',],
'tudod'=>['hu',],
'tudok'=>['hu',],
'tudom'=>['hu',],
'tudsz'=>['hu',],
'tudta'=>['hu',],
'tudtad'=>['hu',],
'tudtam'=>['hu',],
'tudunk'=>['hu',],
'tudy'=>['cs',],
'tue'=>['de','fr','it',],
'tuer'=>['fr',],
'tugas'=>['ms',],
'tuhaf'=>['tr',],
'tuhan'=>['id','ms',],
'tuhle'=>['cs',],
'tui'=>['la',],
'tuis'=>['af','la',],
'tuit'=>['af',],
'tujuan'=>['id','ms',],
'tujuh'=>['id','ms',],
'tukaj'=>['sl',],
'tulang'=>['id',],
'tule'=>['et','fi',],
'tuleb'=>['et',],
'tuled'=>['et',],
'tulee'=>['fi',],
'tulema'=>['et',],
'tulemast'=>['et',],
'tulen'=>['et','fi',],
'tulet'=>['fi',],
'tulevad'=>['et',],
'tulevat'=>['fi',],
'tulge'=>['et',],
'tuli'=>['et','fi',],
'tulid'=>['et',],
'tulin'=>['et','fi',],
'tulisi'=>['fi',],
'tulit'=>['fi','la',],
'tulkaa'=>['fi',],
'tulla'=>['et','fi',],
'tullut'=>['fi',],
'tulnud'=>['et',],
'tulossa'=>['fi',],
'tum'=>['la','si',],
'tumbuh'=>['id','ms',],
'tun'=>['de',],
'tunc'=>['la',],
'tundi'=>['et',],
'tundma'=>['et',],
'tundub'=>['et',],
'tung'=>['sq',],
'tunggal'=>['id',],
'tunggu'=>['ms',],
'tunjukkan'=>['ms',],
'tunne'=>['et','fi',],
'tunned'=>['et',],
'tunnen'=>['et','fi',],
'tunni'=>['et',],
'tunnin'=>['fi',],
'tuntia'=>['fi',],
'tuntuu'=>['fi',],
'tuo'=>['fi','it','la','lt',],
'tuoi'=>['it',],
'tuoj'=>['lt',],
'tuojau'=>['lt',],
'tuolla'=>['fi',],
'tuomet'=>['lt',],
'tuon'=>['fi',],
'tuonne'=>['fi',],
'tuos'=>['lt',],
'tuossa'=>['fi',],
'tuosta'=>['fi',],
'tuota'=>['fi',],
'tur'=>['da','lv','nb','no','sv',],
'turbūt'=>['lt',],
'turi'=>['lt',],
'turies'=>['lv',],
'turim'=>['lt',],
'turime'=>['lt',],
'turit'=>['lt',],
'turite'=>['lt',],
'turiu'=>['lt',],
'turn'=>['en','si',],
'turned'=>['en',],
'turp'=>['lv',],
'turpa'=>['fi',],
'turpini'=>['lv',],
'turun'=>['id','ms',],
'turvassa'=>['fi',],
'turėjau'=>['lt',],
'turėjo'=>['lt',],
'turėti'=>['lt',],
'turėtum'=>['lt',],
'turėtume'=>['lt',],
'turėtų'=>['lt',],
'turėčiau'=>['lt',],
'tus'=>['es',],
'tusen'=>['nb','no',],
'tuskin'=>['fi',],
'tussen'=>['nl',],
'tust'=>['de',],
'tut'=>['de','tr',],
'tutaj'=>['pl',],
'tuto'=>['cs',],
'tutta'=>['it',],
'tutte'=>['it',],
'tutti'=>['it',],
'tutto'=>['it',],
'tutup'=>['ms',],
'tuturor'=>['ro',],
'tuua'=>['et',],
'tuum'=>['la',],
'tuurlijk'=>['nl',],
'tuus'=>['la',],
'tuve'=>['es',],
'tuvo'=>['es',],
'tuvojas'=>['lv',],
'tuvu'=>['lv',],
'tuvāk'=>['lv',],
'tuya'=>['es',],
'tuyo'=>['es',],
'tué'=>['fr',],
'tv'=>['da','en','it','ms','nb','nl','no','pt_br','si','sv','ur',],
'tvarkoj'=>['lt',],
'tveimur'=>['is',],
'tveir'=>['is',],
'tvo'=>['is',],
'tvog'=>['bs','hr','sr',],
'tvoj'=>['bs','hr','sk','sl','sr',],
'tvoja'=>['bs','hr','sk','sl','sr',],
'tvoje'=>['bs','cs','hr','sk','sl','sr',],
'tvojega'=>['sl',],
'tvojej'=>['sk',],
'tvojho'=>['sk',],
'tvoji'=>['bs','sl','sr',],
'tvojich'=>['sk',],
'tvojih'=>['sl',],
'tvojim'=>['bs','hr','sr',],
'tvojo'=>['sl',],
'tvojoj'=>['bs','sr',],
'tvojom'=>['sk',],
'tvoju'=>['bs','hr','sk','sr',],
'tvom'=>['bs','hr','sr',],
'tvou'=>['cs',],
'tvungen'=>['sv',],
'tvá'=>['cs',],
'tvár'=>['sk',],
'två'=>['sv',],
'tvær'=>['is',],
'tvé'=>['cs',],
'tvého'=>['cs',],
'tvö'=>['is',],
'tvůj'=>['cs',],
'twarz'=>['pl',],
'twee'=>['af','nl',],
'tweede'=>['nl',],
'two'=>['en','th',],
'twoich'=>['pl',],
'twoim'=>['pl',],
'twoja'=>['pl',],
'twoje'=>['pl',],
'twojego'=>['pl',],
'twojej'=>['pl',],
'twoją'=>['pl',],
'twyfel'=>['af',],
'twyfelagtige'=>['af',],
'twój'=>['pl',],
'txapela'=>['eu',],
'txapelketaz'=>['eu',],
'txarto'=>['eu',],
'ty'=>['cs','pl','sk','sq',],
'tych'=>['pl',],
'tycker'=>['sv',],
'tyckte'=>['sv',],
'tyd'=>['af',],
'tydzień'=>['pl',],
'tygodniu'=>['pl',],
'tyhle'=>['cs',],
'tyhmä'=>['fi',],
'tyle'=>['pl',],
'tylko'=>['pl',],
'tym'=>['pl',],
'tymi'=>['pl',],
'typ'=>['de','sv',],
'type'=>['fr',],
'typen'=>['de',],
'tyre'=>['sq',],
'tys'=>['cs',],
'tysięcy'=>['pl',],
'tyst'=>['sv',],
'tyto'=>['cs',],
'tyttö'=>['fi',],
'tytön'=>['fi',],
'tytöt'=>['fi',],
'tyvärr'=>['sv',],
'tyyppi'=>['fi',],
'työtä'=>['fi',],
'tyłu'=>['pl',],
'tá'=>['pt','pt_br','sk',],
'tábornok'=>['hu',],
'támhle'=>['cs',],
'táta'=>['cs',],
'táto'=>['sk',],
'távol'=>['hu',],
'târziu'=>['ro',],
'tão'=>['pt','pt_br',],
'tähelepanu'=>['et',],
'tähendab'=>['et',],
'tähtis'=>['et',],
'tähän'=>['fi',],
'täielikult'=>['et',],
'täiesti'=>['et',],
'täis'=>['et',],
'tällä'=>['fi',],
'tämä'=>['fi',],
'tämän'=>['fi',],
'täna'=>['et',],
'tänan'=>['et',],
'tänk'=>['sv',],
'tänka'=>['sv',],
'tänker'=>['sv',],
'tänkt'=>['sv',],
'tänkte'=>['sv',],
'tänne'=>['fi',],
'tänu'=>['et',],
'tänä'=>['fi',],
'tänään'=>['fi',],
'täpselt'=>['et',],
'tärkeää'=>['fi',],
'tässä'=>['fi',],
'tästä'=>['fi',],
'tätä'=>['fi',],
'täydellinen'=>['fi',],
'täynnä'=>['fi',],
'täysin'=>['fi',],
'täytyy'=>['fi',],
'täällä'=>['fi',],
'täältä'=>['fi',],
'tækifæri'=>['is',],
'tænk'=>['da',],
'tænke'=>['da',],
'tænker'=>['da',],
'tænkt'=>['da',],
'tænkte'=>['da',],
'tæt'=>['da',],
'té'=>['ca','cs',],
'téged'=>['hu',],
'téhle'=>['cs',],
'télé'=>['fr',],
'téléphone'=>['fr',],
'tényleg'=>['hu',],
'této'=>['cs',],
'têm'=>['pt','pt_br',],
'tête'=>['fr',],
'të'=>['sq',],
'tënd'=>['sq',],
'tënde'=>['sq',],
'tërë'=>['sq',],
'tí'=>['sk',],
'tía'=>['es',],
'tím'=>['cs',],
'tíma'=>['is',],
'tímann'=>['is',],
'tími'=>['is',],
'tío'=>['es',],
'título'=>['gl',],
'tíu'=>['is',],
'tíz'=>['hu',],
'tódalas'=>['gl',],
'tódolos'=>['gl',],
'tók'=>['is',],
'tókst'=>['is',],
'tôt'=>['fr',],
'tõeline'=>['et',],
'tõesti'=>['et',],
'tõmba'=>['et',],
'tõsi'=>['et',],
'tõsiselt'=>['et',],
'tõuse'=>['et',],
'több'=>['hu',],
'többet'=>['hu',],
'többi'=>['hu',],
'többé'=>['hu',],
'töihin'=>['fi',],
'töissä'=>['fi',],
'töitä'=>['fi',],
'tökum'=>['is',],
'tökéletes'=>['hu',],
'történik'=>['hu',],
'történt'=>['hu',],
'töten'=>['de',],
'töö'=>['et',],
'tööd'=>['et',],
'tööle'=>['et',],
'töötab'=>['et',],
'tøj'=>['da',],
'tør'=>['da',],
'tú'=>['ca','es','sk',],
'túa'=>['gl',],
'túl'=>['hu',],
'túto'=>['sk',],
'tüdruk'=>['et',],
'tüdrukud'=>['et',],
'tüm'=>['tr',],
'tür'=>['de','tr',],
'türk'=>['az',],
'tütar'=>['et',],
'tüüp'=>['et',],
'tý'=>['cs',],
'tých'=>['sk',],
'týchto'=>['sk',],
'týden'=>['cs',],
'tým'=>['cs','sk',],
'tými'=>['sk',],
'týmto'=>['sk',],
'týždeň'=>['sk',],
'tā'=>['lv',],
'tāda'=>['lv',],
'tādas'=>['lv',],
'tādi'=>['lv',],
'tāds'=>['lv',],
'tādu'=>['lv',],
'tādā'=>['lv',],
'tādēļ'=>['lv',],
'tālu'=>['lv',],
'tālāk'=>['lv',],
'tām'=>['lv',],
'tāpat'=>['lv',],
'tāpēc'=>['lv',],
'tās'=>['lv',],
'tātad'=>['lv',],
'tăi'=>['ro',],
'tău'=>['ro',],
'tą'=>['lt','pl',],
'tēt'=>['lv',],
'tēti'=>['lv',],
'tētis'=>['lv',],
'tēva'=>['lv',],
'tēvoci'=>['lv',],
'tēvs'=>['lv',],
'tēvu'=>['lv',],
'tėti'=>['lt',],
'tėtis'=>['lt',],
'tėvai'=>['lt',],
'tėvas'=>['lt',],
'tėve'=>['lt',],
'tėvo'=>['lt',],
'tę'=>['pl',],
'tędy'=>['pl',],
'tě'=>['cs',],
'těch'=>['cs',],
'tělo'=>['cs',],
'těžké'=>['cs',],
'tıpkı'=>['tr',],
'tłumaczenie'=>['pl',],
'tőle'=>['hu',],
'tőled'=>['hu',],
'tőlem'=>['hu',],
'třeba'=>['cs',],
'tři'=>['cs',],
'tūlīt'=>['lv',],
'tűnik'=>['hu',],
'tűnt'=>['hu',],
'tűz'=>['hu',],
'tų'=>['lt',],
'tərəfindən'=>['az',],
'tι'=>['el',],
'tο'=>['el',],
'u'=>['af','az','bs','cs','hr','is','nl','pl','si','sk','sl','sq','sr','th',],
'ua'=>['sq',],
'ualde'=>['la',],
'uale'=>['la',],
'uang'=>['id','ms',],
'uanset'=>['da',],
'uansett'=>['nb','no',],
'ubi'=>['la',],
'ubije'=>['sr',],
'ubil'=>['sl',],
'ubila'=>['sl',],
'ubili'=>['sl',],
'ubio'=>['bs','hr','sr',],
'ubit'=>['hr',],
'ubiti'=>['bs','hr','sl','sr',],
'ubojica'=>['hr',],
'uccidere'=>['it',],
'ucciso'=>['it',],
'ucide'=>['ro',],
'ucis'=>['ro',],
'ud'=>['da','es','no',],
'uda'=>['pl',],
'udaješ'=>['hi',],
'udara'=>['id','ms',],
'udarajuæi'=>['hi',],
'udało'=>['pl',],
'ude'=>['da',],
'uden'=>['da',],
'udenfor'=>['da',],
'uds'=>['es',],
'udělal'=>['cs',],
'udělala'=>['cs',],
'udělali'=>['cs',],
'udělat'=>['cs',],
'udělej'=>['cs',],
'udělám'=>['cs',],
'uděláme'=>['cs',],
'ue'=>['gl',],
'uehementer'=>['la',],
'uel'=>['la',],
'uelim'=>['la',],
'uelle'=>['la',],
'uellet'=>['la',],
'uelut'=>['la',],
'uenerunt'=>['la',],
'uenire'=>['la',],
'uenit'=>['la',],
'uera'=>['la',],
'uerba'=>['la',],
'uerbis'=>['la',],
'uerborum'=>['la',],
'uerbum'=>['la',],
'uere'=>['la',],
'uero'=>['la',],
'uerum'=>['la',],
'uestra'=>['la',],
'uestrum'=>['la',],
'ueteres'=>['la',],
'ufak'=>['tr',],
'ufficio'=>['it',],
'ufo'=>['id',],
'uganuæe'=>['hi',],
'uge'=>['da',],
'uger'=>['da',],
'uguni'=>['lv',],
'ugyan'=>['hu',],
'ugyanaz'=>['hu',],
'ugye'=>['hu',],
'uh'=>['af','bs','cs','en','hr','it','lv','ms','nl','pt_br','ro','sk','sl','sq','sr',],
'uhhhh'=>['af',],
'uhr'=>['de',],
'ui'=>['la',],
'uia'=>['la',],
'uiam'=>['la',],
'uictoria'=>['la',],
'uide'=>['la',],
'uideatur'=>['la',],
'uidebatur'=>['la',],
'uidentur'=>['la',],
'uideo'=>['la',],
'uidere'=>['la',],
'uideretur'=>['la',],
'uideri'=>['la',],
'uidetur'=>['la',],
'uidit'=>['la',],
'uiginti'=>['la',],
'uim'=>['la',],
'uino'=>['la',],
'uir'=>['la',],
'uires'=>['la',],
'uiri'=>['la',],
'uiribus'=>['la',],
'uiris'=>['la',],
'uiro'=>['la',],
'uiros'=>['la',],
'uirtus'=>['la',],
'uirtute'=>['la',],
'uirtutem'=>['la',],
'uirtutis'=>['la',],
'uirum'=>['la',],
'uis'=>['la',],
'uisum'=>['la',],
'uit'=>['af','nl','ro',],
'uita'=>['la','ro',],
'uitae'=>['la',],
'uitam'=>['la',],
'uitat'=>['ro',],
'uitdaging'=>['af',],
'uite'=>['ro',],
'uiteindelik'=>['af',],
'uitgawes'=>['af',],
'uitgebreide'=>['af',],
'uitia'=>['la',],
'uitkom'=>['af',],
'uitskel'=>['af',],
'uitsluitlike'=>['af',],
'uitvoering'=>['af',],
'uită'=>['ro',],
'uiuere'=>['la',],
'uix'=>['la',],
'uiţi'=>['ro',],
'ujutro'=>['bs','hr',],
'ujë'=>['sq',],
'ukaž'=>['cs',],
'uke'=>['nb','no',],
'uker'=>['nb','no',],
'uklidni'=>['cs',],
'uko'=>['eu',],
'uks'=>['et',],
'ukse'=>['et',],
'ukuran'=>['id',],
'ukázať'=>['sk',],
'ukáž'=>['sk',],
'ul'=>['ro',],
'ulang'=>['id','ms',],
'ulazi'=>['bs','sr',],
'ulicy'=>['pl',],
'ulkona'=>['fi',],
'ulla'=>['la',],
'ullo'=>['la',],
'ulls'=>['ca',],
'ulos'=>['fi',],
'ultima'=>['it','ro',],
'ultimo'=>['it',],
'ultimul'=>['ro',],
'ultra'=>['la',],
'ulu'=>['sq',],
'ulur'=>['sq',],
'um'=>['af','bs','de','en','is','ms','pt','pt_br','zh_tw',],
'uma'=>['pt','pt_br','zh_tw',],
'umakni'=>['sl',],
'umarım'=>['tr',],
'umas'=>['pt','pt_br',],
'umat'=>['id',],
'umbes'=>['et',],
'umbringen'=>['de',],
'ume'=>['eu',],
'umea'=>['eu',],
'umearen'=>['eu',],
'umesto'=>['sr',],
'umgebracht'=>['de',],
'umjesto'=>['bs','hr',],
'umquam'=>['la',],
'umreti'=>['sr',],
'umrijeti'=>['bs','hr',],
'umrl'=>['sl',],
'umrla'=>['sl',],
'umro'=>['bs','hr','sr',],
'umrzeć'=>['pl',],
'umukni'=>['sr',],
'umulig'=>['nb','no',],
'umuligt'=>['da',],
'umum'=>['id',],
'umurumda'=>['tr',],
'un'=>['ca','es','fr','gl','it','lv','ro','sq',],
'una'=>['ca','es','it','la','ro',],
'unam'=>['la',],
'unas'=>['es',],
'uncle'=>['en',],
'unconditional'=>['af',],
'und'=>['de',],
'undan'=>['is','sv',],
'unde'=>['la','ro',],
'under'=>['da','en','nb','no','sv',],
'underbar'=>['sv',],
'underbart'=>['sv',],
'understand'=>['en','si',],
'understanding'=>['si',],
'undeva'=>['ro',],
'undique'=>['la',],
'undir'=>['is',],
'undrar'=>['sv',],
'undskyld'=>['da','no',],
'undskylde'=>['da',],
'une'=>['eu','fr','sq',],
'unea'=>['eu',],
'unei'=>['ro',],
'unele'=>['ro',],
'uneori'=>['ro',],
'unes'=>['ca',],
'ung'=>['da','nb','no','sv',],
'unge'=>['da','nb','no',],
'ungefär'=>['sv',],
'ungfrú'=>['is',],
'unglaublich'=>['de',],
'unha'=>['gl',],
'unhas'=>['gl',],
'unica'=>['it',],
'unico'=>['it',],
'unidos'=>['gl',],
'unii'=>['ro',],
'unik'=>['id',],
'units'=>['ca',],
'uniuersa'=>['la',],
'unius'=>['la',],
'universa'=>['la',],
'universe'=>['th',],
'universidad'=>['es',],
'universidade'=>['gl',],
'unión'=>['gl',],
'unless'=>['en','th',],
'unmöglich'=>['de',],
'unna'=>['nb','no',],
'unnið'=>['is',],
'unnskyld'=>['nb','no',],
'uno'=>['es','it','la',],
'unohda'=>['fi',],
'unos'=>['es',],
'uns'=>['ca','de','gl','pt','pt_br',],
'unser'=>['de',],
'unsere'=>['de',],
'unserem'=>['de',],
'unseren'=>['de',],
'unserer'=>['de',],
'unten'=>['de',],
'unter'=>['de',],
'until'=>['en',],
'untuk'=>['id','ms',],
'untukku'=>['ms',],
'untukmu'=>['ms',],
'unu'=>['ro',],
'unui'=>['ro',],
'unul'=>['ro',],
'unum'=>['la',],
'unus'=>['la',],
'unusta'=>['et',],
'unutma'=>['tr',],
'unutra'=>['bs','hr','sr',],
'unë'=>['sq',],
'uobis'=>['la',],
'uocant'=>['la',],
'uocatur'=>['la',],
'uoce'=>['la',],
'uocem'=>['la',],
'uoluit'=>['la',],
'uolunt'=>['la',],
'uoluntate'=>['la',],
'uomini'=>['it',],
'uomo'=>['it',],
'uopće'=>['hr',],
'uopљte'=>['sr',],
'uos'=>['la',],
'uox'=>['la',],
'uoèljivi'=>['hi',],
'up'=>['af','en','fa','id','ms','si','th',],
'upadaš'=>['hi',],
'upam'=>['sl',],
'upon'=>['en',],
'upp'=>['is','sv',],
'uppe'=>['sv',],
'uppfattat'=>['sv',],
'uppi'=>['is',],
'upravo'=>['bs','hr','sr',],
'upset'=>['th',],
'upuštaš'=>['hi',],
'ur'=>['eu','is','sl','sv',],
'ura'=>['sl',],
'uradi'=>['bs','sr',],
'uradila'=>['bs','sr',],
'uradili'=>['bs','sr',],
'uradim'=>['bs','sr',],
'uradimo'=>['bs','sr',],
'uradio'=>['bs','sr',],
'uraditi'=>['bs','sr',],
'uradiљ'=>['sr',],
'uraim'=>['hu',],
'uram'=>['hu',],
'urbe'=>['la',],
'urbem'=>['la',],
'urbis'=>['la',],
'urdhëro'=>['sq',],
'ure'=>['sl',],
'uredu'=>['bs','hr','sr',],
'urime'=>['sq',],
'urma'=>['ro',],
'urmă'=>['ro',],
'uro'=>['sl',],
'urob'=>['sk',],
'urobil'=>['sk',],
'urobila'=>['sk',],
'urobili'=>['sk',],
'urobiť'=>['sk',],
'urobím'=>['sk',],
'urobíme'=>['sk',],
'urrej'=>['sq',],
'urrun'=>['eu',],
'urrundu'=>['eu',],
'ursäkt'=>['sv',],
'ursäkta'=>['sv',],
'urteetan'=>['eu',],
'urăsc'=>['ro',],
'určite'=>['sk',],
'určitě'=>['cs',],
'us'=>['af','ca','en','th',],
'usa'=>['sv',],
'usar'=>['es','pt','pt_br',],
'usare'=>['it',],
'uscire'=>['it',],
'use'=>['en',],
'used'=>['en',],
'usein'=>['fi',],
'ushqim'=>['sq',],
'usia'=>['id',],
'usko'=>['fi',],
'uskoa'=>['fi',],
'uskomatonta'=>['fi',],
'uskon'=>['fi',],
'uskoro'=>['bs','hr','sr',],
'uskuda'=>['et',],
'uskumatu'=>['et',],
'uso'=>['gl',],
'uspelo'=>['sl',],
'uspeo'=>['sr',],
'uspio'=>['hr',],
'uspokój'=>['pl',],
'usque'=>['la',],
'usr'=>['th',],
'usreèiti'=>['hi',],
'usta'=>['bs','hr','sr',],
'ustavi'=>['sl',],
'uste'=>['eu',],
'usted'=>['es',],
'ustedes'=>['es',],
'usteltzen'=>['eu',],
'ustvari'=>['bs',],
'usu'=>['et','la',],
'usum'=>['la',],
'usun'=>['et',],
'usus'=>['la',],
'ut'=>['la','nb','no','sv',],
'utama'=>['id','ms',],
'utan'=>['is','sv',],
'utanför'=>['sv',],
'utang'=>['id',],
'utara'=>['id','ms',],
'utat'=>['hu',],
'utbənin'=>['az',],
'ute'=>['nb','no','sv',],
'uten'=>['nb','no',],
'utenfor'=>['nb','no',],
'uti'=>['la',],
'utihni'=>['sl',],
'utique'=>['la',],
'utk'=>['ms',],
'utolsó'=>['hu',],
'utraque'=>['la',],
'utrolig'=>['nb','no',],
'utroligt'=>['da',],
'utrum'=>['la',],
'utrumque'=>['la',],
'uttar'=>['af',],
'utu'=>['eu',],
'utzi'=>['eu',],
'utziko'=>['eu',],
'után'=>['hu',],
'utána'=>['hu',],
'uudelleen'=>['fi',],
'uuden'=>['fi',],
'uudestaan'=>['fi',],
'uue'=>['et',],
'uuesti'=>['et',],
'uult'=>['la',],
'uur'=>['af','nl',],
'uus'=>['et',],
'uusi'=>['fi',],
'uut'=>['et',],
'uutta'=>['fi',],
'uvek'=>['sr',],
'uveriť'=>['sk',],
'uvidíme'=>['cs','sk',],
'uvijek'=>['bs','hr',],
'uvjek'=>['bs',],
'uvnitř'=>['cs',],
'uw'=>['nl',],
'uwaga'=>['pl',],
'uwagę'=>['pl',],
'uważaj'=>['pl',],
'uwierzyć'=>['pl',],
'uxorem'=>['la',],
'uygun'=>['tr',],
'uyo'=>['th',],
'uyuşturucu'=>['tr',],
'uz'=>['bs','hr','lv','sk','sr',],
'uzak'=>['tr',],
'uzeo'=>['bs','hr','sr',],
'uzeti'=>['bs','hr',],
'uzmanies'=>['lv',],
'uzmanību'=>['lv',],
'uzmanīgi'=>['lv',],
'uzmi'=>['bs','hr','sr',],
'uzreiz'=>['lv',],
'uztea'=>['eu',],
'uzten'=>['eu',],
'uzun'=>['tr',],
'učinio'=>['hr',],
'učiniti'=>['hr',],
'uşa'=>['ro',],
'uşor'=>['ro',],
'už'=>['cs','lt','sk',],
'užsičiaupk'=>['lt',],
'užteks'=>['lt',],
'uиinio'=>['sr',],
'uиiniti'=>['hr','sr',],
'v'=>['az','cs','is','nb','no','si','sk','sl','th',],
'va'=>['ca','es','fr','it','lt','ro','sv',],
'vaadake'=>['et',],
'vaadata'=>['et',],
'vaak'=>['nl',],
'vaan'=>['fi',],
'vaar'=>['af',],
'vaarwel'=>['af',],
'vaata'=>['et',],
'vaatama'=>['et',],
'vaatame'=>['et',],
'vaatan'=>['et',],
'vaba'=>['et',],
'vabanda'=>['et',],
'vabandage'=>['et',],
'vabandan'=>['et',],
'vabandust'=>['et',],
'vacker'=>['sv',],
'vackert'=>['sv',],
'vad'=>['ro','sv',],
'vada'=>['it',],
'vader'=>['af','nl',],
'vadina'=>['lt',],
'vadinasi'=>['lt',],
'vado'=>['it',],
'vadå'=>['sv',],
'vadă'=>['ro',],
'vagi'=>['ca',],
'vagy'=>['hu',],
'vagyis'=>['hu',],
'vagyok'=>['hu',],
'vagytok'=>['hu',],
'vagyunk'=>['hu',],
'vahel'=>['et',],
'vahele'=>['et',],
'vahet'=>['et',],
'vahish'=>['af',],
'vai'=>['fi','gl','it','lv','pt','pt_br',],
'vaia'=>['gl',],
'vaid'=>['et',],
'vaidehi'=>['af',],
'vaig'=>['ca',],
'vaikai'=>['lt',],
'vaikas'=>['lt',],
'vaike'=>['lt',],
'vaikea'=>['fi',],
'vaikeaa'=>['fi',],
'vaikinai'=>['lt',],
'vaikinas'=>['lt',],
'vaikka'=>['fi',],
'vaiko'=>['lt',],
'vaikus'=>['lt',],
'vaikuttaa'=>['fi',],
'vaiką'=>['lt',],
'vaikų'=>['lt',],
'vaimoni'=>['fi',],
'vain'=>['fi',],
'vaina'=>['lv',],
'vairs'=>['lv',],
'vairāk'=>['lv',],
'vais'=>['fr','pt',],
'vait'=>['et',],
'vaivaa'=>['fi',],
'vaixell'=>['ca',],
'vaja'=>['ca','et',],
'vajab'=>['et',],
'vajad'=>['et',],
'vajadzēja'=>['lv',],
'vajadzēs'=>['lv',],
'vajadzētu'=>['lv',],
'vajadzīga'=>['lv',],
'vajadzīgs'=>['lv',],
'vajag'=>['lv',],
'vajame'=>['et',],
'vajan'=>['et',],
'vajon'=>['hu',],
'vaju'=>['sl',],
'vajza'=>['sq',],
'vajzat'=>['sq',],
'vajzë'=>['sq',],
'vajzën'=>['sq',],
'vakante'=>['af',],
'vakar'=>['lt','lv',],
'vakaras'=>['lt',],
'vakarą'=>['lt',],
'vakit'=>['tr',],
'vakke'=>['af',],
'vakker'=>['nb','no',],
'vakkert'=>['nb',],
'vakna'=>['sv',],
'val'=>['af','ca','hu','nl','sv',],
'valaha'=>['hu',],
'valahogy'=>['hu',],
'valahol'=>['hu',],
'valaki'=>['hu',],
'valakinek'=>['hu',],
'valakit'=>['hu',],
'valami'=>['hu',],
'valamit'=>['hu',],
'valandas'=>['lt',],
'valandos'=>['lt',],
'valandą'=>['lt',],
'valandų'=>['lt',],
'valde'=>['la',],
'vale'=>['es','et','it','la','pt','pt_br',],
'valedictorian'=>['hi',],
'valesti'=>['et',],
'valg'=>['da','nb','no',],
'valge'=>['et',],
'valgyti'=>['lt',],
'valjda'=>['bs','hr','sr',],
'valkyrie'=>['si',],
'vallen'=>['nl',],
'valmiina'=>['fi',],
'valmiki'=>['af',],
'valmis'=>['et','fi',],
'valor'=>['gl',],
'valsts'=>['lv',],
'valt'=>['nl',],
'való'=>['hu',],
'valóban'=>['hu',],
'valójában'=>['hu',],
'valószínűleg'=>['hu',],
'vam'=>['bs','ca','hr','sl','sr',],
'vama'=>['bs','hr','sl','sr',],
'vami'=>['sk','sl',],
'vamos'=>['es','pt','pt_br',],
'vampire'=>['th',],
'van'=>['af','bs','ca','es','gl','hr','hu','nl','sr','th',],
'vana'=>['et',],
'vanaf'=>['nl',],
'vanar'=>['af',],
'vanars'=>['af',],
'vanavond'=>['nl',],
'vand'=>['da',],
'vandaag'=>['nl',],
'vandaan'=>['nl',],
'vandag'=>['af',],
'vandamál'=>['is',],
'vandens'=>['lt',],
'vandet'=>['da',],
'vanemad'=>['et',],
'vang'=>['af',],
'vanha'=>['fi',],
'vani'=>['bs','hr',],
'vanlig'=>['nb','no',],
'vann'=>['is','nb','no',],
'vannak'=>['hu',],
'vannet'=>['nb','no',],
'vanno'=>['it',],
'vanoggend'=>['af',],
'vanskelig'=>['nb','no',],
'vant'=>['nb','no',],
'vantar'=>['is',],
'vanuit'=>['nl',],
'vapen'=>['sv',],
'var'=>['az','da','is','lv','nb','no','sv','tr',],
'vara'=>['sv',],
'varam'=>['lv',],
'varandra'=>['sv',],
'varat'=>['lv',],
'varbūt'=>['lv',],
'vardas'=>['lt',],
'vardu'=>['lt',],
'vardą'=>['lt',],
'vardı'=>['tr',],
'vardır'=>['tr',],
'vare'=>['nb','no',],
'varem'=>['et',],
'varför'=>['sv',],
'vari'=>['lv',],
'varias'=>['gl',],
'varios'=>['gl',],
'varit'=>['sv',],
'varje'=>['sv',],
'varla'=>['is',],
'varlega'=>['is',],
'varma'=>['fi',],
'varmaan'=>['fi',],
'varmasti'=>['fi',],
'varmış'=>['tr',],
'varo'=>['fi',],
'varom'=>['lt',],
'varovainen'=>['fi',],
'varsa'=>['tr',],
'varst'=>['is',],
'varsti'=>['et',],
'varstu'=>['is',],
'varsågod'=>['sv',],
'vart'=>['sv',],
'varten'=>['fi',],
'varu'=>['lv',],
'varyk'=>['lt',],
'varð'=>['is',],
'varēja'=>['lv',],
'varēsi'=>['lv',],
'varētu'=>['lv',],
'vas'=>['bs','ca','es','fr','hr','sl','sr',],
'vast'=>['nl',],
'vasta'=>['fi',],
'vastaa'=>['fi',],
'vastaan'=>['fi',],
'vastu'=>['et',],
'vater'=>['de',],
'vatn'=>['is',],
'vatten'=>['sv',],
'vattene'=>['it',],
'vattnet'=>['sv',],
'vau'=>['ca',],
'vauhtia'=>['fi',],
'vaut'=>['fr',],
'vaxt'=>['az',],
'vaxtlar'=>['az',],
'vay'=>['tr',],
'vaya'=>['es',],
'vayas'=>['es',],
'vazhdo'=>['sq',],
'vazut'=>['ro',],
'vaļā'=>['lv',],
'vaš'=>['bs','hr','sl',],
'vaša'=>['bs','hr','sk','sl',],
'vaše'=>['bs','cs','hr','sk','sl',],
'vašeho'=>['cs',],
'vašej'=>['sk',],
'vaši'=>['cs','sl',],
'vašo'=>['sl',],
'vašu'=>['hr','sk',],
'vaší'=>['cs',],
'važiuojam'=>['lt',],
'važiuok'=>['lt',],
'važiuoti'=>['lt',],
'važno'=>['bs','hr','sl',],
'vaљ'=>['bs','sr',],
'vaљa'=>['sr',],
'vaљe'=>['bs','sr',],
'vaљu'=>['sr',],
'vaћi'=>['sr',],
'vaћno'=>['sr',],
'vdekje'=>['sq',],
'vdekur'=>['sq',],
'vdes'=>['sq',],
'vdiq'=>['sq',],
've'=>['ca','cs','es','gl','it','si','sl','th','tr',],
'vec'=>['bs','sk','sr',],
'vecais'=>['lv',],
'vecchia'=>['it',],
'vecchio'=>['it',],
'veces'=>['es','gl',],
'vechi'=>['ro',],
'vechten'=>['nl',],
'veci'=>['sk',],
'veciños'=>['gl',],
'vecka'=>['sv',],
'veckan'=>['sv',],
'veckor'=>['sv',],
'vecs'=>['lv',],
'vecí'=>['sk',],
'vecāki'=>['lv',],
'vecīt'=>['lv',],
'ved'=>['da','lv','nb','no',],
'vedd'=>['hu',],
'vede'=>['cs','it',],
'vedea'=>['ro',],
'vedel'=>['sk','sl',],
'vedela'=>['sk','sl',],
'vedeli'=>['sk','sl',],
'vedem'=>['ro',],
'vedere'=>['it',],
'vederti'=>['it',],
'vedeti'=>['sl',],
'vedeţi'=>['ro',],
'vedi'=>['it',],
'vediamo'=>['it',],
'vedieť'=>['sk',],
'vedle'=>['cs',],
'vedno'=>['sl',],
'vedo'=>['it','sl',],
'veel'=>['af','et','nl',],
'veena'=>['af',],
'veg'=>['af',],
'vegada'=>['ca',],
'vegades'=>['ca',],
'vegna'=>['is',],
'vegter'=>['af',],
'vehementer'=>['la',],
'vei'=>['nb','no','ro',],
'veicas'=>['lv',],
'veidi'=>['et',],
'veids'=>['lv',],
'veidā'=>['lv',],
'veidą'=>['lt',],
'veien'=>['nb','no',],
'veig'=>['ca',],
'veiki'=>['lt',],
'veikia'=>['lt',],
'veilig'=>['nl',],
'veio'=>['pt','pt_br',],
'veire'=>['ca',],
'veist'=>['is',],
'veistu'=>['is',],
'veit'=>['is',],
'vej'=>['da',],
'veja'=>['pt','pt_br',],
'vejen'=>['da',],
'vejo'=>['pt','pt_br',],
'vejret'=>['da',],
'vekk'=>['nb','no',],
'vel'=>['af','da','is','la','nb','no',],
'veldig'=>['nb','no',],
'vele'=>['hu',],
'veled'=>['hu',],
'velem'=>['hu',],
'velha'=>['pt','pt_br',],
'velho'=>['pt','pt_br',],
'veli'=>['fi',],
'velice'=>['cs',],
'velik'=>['sl',],
'velika'=>['bs','hr','sl','sr',],
'velike'=>['bs','hr','sr',],
'veliki'=>['bs','hr','sl','sr',],
'veliko'=>['sl',],
'veliku'=>['bs','hr',],
'velim'=>['la',],
'veljeni'=>['fi',],
'velkaa'=>['fi',],
'velkominn'=>['is',],
'velkommen'=>['da','nb','no',],
'velkou'=>['cs',],
'velká'=>['cs',],
'velké'=>['cs',],
'velký'=>['cs',],
'vell'=>['ca',],
'vella'=>['gl',],
'velle'=>['la',],
'vellet'=>['la',],
'vello'=>['gl',],
'velmi'=>['cs',],
'velna'=>['lv',],
'velniai'=>['lt',],
'velnias'=>['lt',],
'velniop'=>['lt',],
'velnių'=>['lt',],
'velns'=>['lv',],
'veloce'=>['it',],
'velut'=>['la',],
'velük'=>['hu',],
'velünk'=>['hu',],
'vem'=>['cs','pt','pt_br','sl','sv',],
'veman'=>['af',],
'vemanum'=>['af',],
'vemo'=>['sl',],
'vemos'=>['es',],
'ven'=>['ca','cs','da','es','gl','sl',],
'vend'=>['et','sq',],
'vendar'=>['sl',],
'vende'=>['da',],
'vender'=>['da',],
'vendi'=>['sq',],
'vendin'=>['sq',],
'vendo'=>['pt_br',],
'vendos'=>['sq',],
'vendosur'=>['sq',],
'venerunt'=>['la',],
'venez'=>['fr',],
'venga'=>['es','it',],
'vengo'=>['it',],
'vengono'=>['it',],
'venha'=>['pt','pt_br',],
'venham'=>['pt','pt_br',],
'veni'=>['ro',],
'venido'=>['es',],
'venir'=>['ca','es','fr',],
'venire'=>['it','la',],
'venit'=>['la','ro',],
'venite'=>['it',],
'veniu'=>['ca',],
'veniţi'=>['ro',],
'venku'=>['cs',],
'venlig'=>['da',],
'venn'=>['nb','no',],
'vennen'=>['nb','no',],
'vennene'=>['nb',],
'venner'=>['da','nb','no',],
'venni'=>['hu',],
'venstre'=>['da','nb','no',],
'vent'=>['da','nb','nl','no',],
'vente'=>['da','nb','no',],
'venter'=>['af','da','nb','no',],
'ventet'=>['nb','no',],
'vento'=>['gl',],
'venu'=>['fr',],
'venue'=>['fr',],
'venus'=>['id',],
'venuta'=>['it',],
'venuto'=>['it',],
'veo'=>['es',],
'veoma'=>['bs','hr','sr',],
'ver'=>['af','es','gl','nl','pt','pt_br','sk','tr',],
'vera'=>['is','it','la',],
'veral'=>['af',],
'veramente'=>['it',],
'veranderd'=>['nl',],
'veranderen'=>['nl',],
'veras'=>['es',],
'verba'=>['la',],
'verbaas'=>['af',],
'verban'=>['af',],
'verbis'=>['la',],
'verborum'=>['la',],
'verbrand'=>['af',],
'verbum'=>['la',],
'verby'=>['af',],
'verdad'=>['es',],
'verdade'=>['gl','pt','pt_br',],
'verdadeiro'=>['pt','pt_br',],
'verdadero'=>['es',],
'verdammt'=>['de',],
'verdammte'=>['de',],
'verden'=>['da','nb','no',],
'verdens'=>['nb','no',],
'verder'=>['nl',],
'verdi'=>['tr',],
'verdien'=>['af',],
'verdim'=>['tr',],
'verdomde'=>['nl',],
'verdomme'=>['nl',],
'verdra'=>['af',],
'verdt'=>['nb','no',],
'verdwyn'=>['af',],
'vere'=>['la',],
'vereceğim'=>['tr',],
'vergadering'=>['af',],
'vergeet'=>['af','nl',],
'vergessen'=>['de',],
'vergeten'=>['nl',],
'vergewe'=>['af',],
'vergiss'=>['de',],
'verhaal'=>['nl',],
'verheerlik'=>['af',],
'verheiratet'=>['de',],
'verhoor'=>['af',],
'verin'=>['tr',],
'verir'=>['tr',],
'veritat'=>['ca',],
'verità'=>['it',],
'veriyorum'=>['tr',],
'verið'=>['is',],
'veriť'=>['sk',],
'verjamem'=>['sl',],
'verjeti'=>['sl',],
'verjetno'=>['sl',],
'verk'=>['is',],
'verkar'=>['sv',],
'verkaufen'=>['de',],
'verkeerd'=>['af','nl',],
'verkeerde'=>['nl',],
'verkligen'=>['sv',],
'verkopen'=>['nl',],
'verkrag'=>['af',],
'verlaat'=>['af',],
'verlassen'=>['de',],
'verlaten'=>['nl',],
'verlede'=>['af',],
'verleng'=>['af',],
'verletzt'=>['de',],
'verliefd'=>['nl',],
'verlieren'=>['de',],
'verliezen'=>['nl',],
'verlo'=>['es',],
'verloop'=>['af',],
'verloor'=>['af',],
'verloorder'=>['af',],
'verloren'=>['de','nl',],
'vermek'=>['tr',],
'vermoedelik'=>['af',],
'vermoedens'=>['af',],
'vermoeide'=>['af',],
'vermoor'=>['af',],
'vermoord'=>['nl',],
'vermoorden'=>['nl',],
'verniet'=>['af',],
'vero'=>['it','la',],
'veronderstel'=>['af',],
'verovatno'=>['sr',],
'verpakking'=>['af',],
'verpersoonliking'=>['af',],
'verrassing'=>['af',],
'verre'=>['fr','nb','no',],
'verrückt'=>['de',],
'vers'=>['fr',],
'versamel'=>['af',],
'verschwinden'=>['de',],
'verskil'=>['af',],
'verskriklike'=>['af',],
'verslaan'=>['af',],
'verso'=>['it',],
'verstaan'=>['af',],
'verstanden'=>['de',],
'verstehe'=>['de',],
'verstehen'=>['de',],
'verstehst'=>['de',],
'versuch'=>['de',],
'versuche'=>['de',],
'versuchen'=>['de',],
'versucht'=>['de',],
'verswak'=>['af',],
'verta'=>['fi',],
'verte'=>['es',],
'vertel'=>['af','nl',],
'verteld'=>['nl',],
'vertelde'=>['nl',],
'vertellen'=>['nl',],
'vertet'=>['sq',],
'vertete'=>['sq',],
'vertrauen'=>['de',],
'vertrekken'=>['nl',],
'vertrou'=>['af',],
'vertrouw'=>['nl',],
'vertrouwen'=>['nl',],
'vertu'=>['is',],
'veruj'=>['sr',],
'verujem'=>['sr',],
'verujeљ'=>['sr',],
'verum'=>['la',],
'vervolg'=>['af',],
'verwacht'=>['nl',],
'verwag'=>['af',],
'verwarrend'=>['af',],
'verwerp'=>['af',],
'very'=>['en','si',],
'verycd'=>['zh',],
'verzeihung'=>['de',],
'verán'=>['gl',],
'verás'=>['es',],
'verím'=>['sk',],
'verð'=>['is',],
'verða'=>['is',],
'verði'=>['is',],
'verðið'=>['is',],
'verðum'=>['is',],
'verður'=>['is',],
'ves'=>['ca','es','sl',],
'vesel'=>['sl',],
'veseli'=>['sl',],
'vesh'=>['sq',],
'veshur'=>['sq',],
'veste'=>['sl',],
'vesti'=>['sr',],
'vestido'=>['es','pt',],
'vestit'=>['ca',],
'vestiti'=>['it',],
'vestito'=>['it',],
'vestra'=>['la',],
'vestrum'=>['la',],
'veszélyes'=>['hu',],
'vet'=>['nb','no','sq','sv',],
'veta'=>['sv',],
'vete'=>['es','sq',],
'vetem'=>['sq',],
'veten'=>['sq',],
'veteres'=>['la',],
'vetes'=>['sq',],
'vetme'=>['sq',],
'vetmi'=>['sq',],
'vetmja'=>['sq',],
'vett'=>['et',],
'vettem'=>['hu',],
'vettä'=>['fi',],
'vetë'=>['sq',],
'vetëm'=>['sq',],
'veu'=>['ca',],
'veulent'=>['fr',],
'veure'=>['ca',],
'veurem'=>['ca',],
'veus'=>['ca',],
'veut'=>['fr',],
'veux'=>['fr',],
'veya'=>['tr',],
'vez'=>['es','gl','pt','pt_br',],
'veze'=>['bs','hr','sr',],
'vezes'=>['pt','pt_br',],
'vezi'=>['bs','hr','ro','sr',],
'vezmi'=>['cs','sk',],
'vezmu'=>['cs',],
'veæ'=>['bs',],
'veçantë'=>['sq',],
'već'=>['bs','hr',],
'več'=>['sl',],
'večer'=>['cs','hr','sk','sl',],
'večeras'=>['bs','hr',],
'večerjo'=>['sl',],
'večeru'=>['sk',],
'večeři'=>['cs',],
'veď'=>['sk',],
'veľa'=>['sk',],
'veľká'=>['sk',],
'veľké'=>['sk',],
'veľký'=>['sk',],
'veľmi'=>['sk',],
'veš'=>['sl',],
'veţi'=>['ro',],
'veж'=>['bs','hr','sr',],
'veиe'=>['sr',],
'veиeras'=>['bs','sr',],
'veиeru'=>['sr',],
'vfr'=>['si',],
'vi'=>['bs','da','es','hr','is','it','la','nb','no','pt','pt_br','sl','sr','sv',],
'via'=>['it','la','nl',],
'viac'=>['sk',],
'viagem'=>['pt','pt_br',],
'viaggio'=>['it',],
'viaje'=>['es',],
'viam'=>['la',],
'viata'=>['ro',],
'viatge'=>['ca',],
'viaxe'=>['gl',],
'viaţa'=>['ro',],
'viaţă'=>['ro',],
'vicces'=>['hu',],
'vicino'=>['it',],
'victoria'=>['la','si',],
'vid'=>['is','sv',],
'vida'=>['ca','es','gl','pt','pt_br',],
'vidare'=>['sv',],
'vidd'=>['hu',],
'viddi'=>['az',],
'vide'=>['da','la',],
'videatur'=>['la',],
'videbatur'=>['la',],
'videl'=>['sk','sl',],
'videla'=>['sk','sl','sr',],
'videli'=>['sk','sl','sr',],
'videntur'=>['la',],
'video'=>['la','sr',],
'videre'=>['da','la','nb','no',],
'videretur'=>['la',],
'videri'=>['la',],
'videti'=>['sl','sr',],
'videtur'=>['la',],
'vidi'=>['bs','hr','sl','sr',],
'vidieť'=>['sk',],
'vidim'=>['bs','hr','sl','sr',],
'vidimo'=>['bs','hr','sl','sr',],
'vidio'=>['bs','hr',],
'vidit'=>['la',],
'vidite'=>['bs','hr','sl','sr',],
'vidiva'=>['sl',],
'vidiš'=>['bs','hr','sl',],
'vidiљ'=>['bs','hr','sr',],
'vidjela'=>['bs','hr',],
'vidjeli'=>['bs','hr',],
'vidjet'=>['hr',],
'vidjeti'=>['bs','hr',],
'vidste'=>['da',],
'viduje'=>['lt',],
'vidva'=>['sl',],
'vidím'=>['cs','sk',],
'vidíte'=>['cs','sk',],
'vidíš'=>['cs','sk',],
'viděl'=>['cs',],
'viděla'=>['cs',],
'viděli'=>['cs',],
'vidět'=>['cs',],
'vidų'=>['lt',],
'vie'=>['fi','fr','sk',],
'viedä'=>['fi',],
'viegli'=>['lv',],
'vieille'=>['fr',],
'vieja'=>['es',],
'viejo'=>['es',],
'viel'=>['de','nl',],
'viele'=>['de',],
'vielen'=>['de',],
'vielleicht'=>['de',],
'vielä'=>['fi',],
'viem'=>['sk',],
'vieme'=>['sk',],
'vien'=>['fi','lt','lv',],
'viena'=>['lt','lv',],
'vienalga'=>['lv',],
'vienam'=>['lt','lv',],
'vienas'=>['lt',],
'viene'=>['es','it',],
'vienen'=>['es',],
'vieni'=>['it',],
'vienintelis'=>['lt',],
'vienintelė'=>['lt',],
'vienkārši'=>['lv',],
'vienmēr'=>['lv',],
'vieno'=>['lt',],
'vienos'=>['lt',],
'viens'=>['fr','lv',],
'vient'=>['fr',],
'vienu'=>['lt','lv',],
'vienā'=>['lv',],
'vieną'=>['lt',],
'vienīgais'=>['lv',],
'vienīgi'=>['lv',],
'vienīgā'=>['lv',],
'vier'=>['de','nl',],
'vieta'=>['lt','lv',],
'vietas'=>['lv',],
'viete'=>['sk',],
'vietoj'=>['lt',],
'vietoje'=>['lt',],
'vietos'=>['lt',],
'vietu'=>['lv',],
'vietā'=>['lv',],
'vietą'=>['lt',],
'vieux'=>['fr',],
'vieš'=>['sk',],
'viešpatie'=>['lt',],
'viga'=>['et',],
'viginti'=>['la',],
'vigo'=>['gl',],
'vigtigt'=>['da',],
'vigyázz'=>['hu',],
'vihaan'=>['fi',],
'vihainen'=>['fi',],
'vihkan'=>['et',],
'vii'=>['da','et','nb','no','ro',],
'viia'=>['et',],
'viikkoa'=>['fi',],
'viikolla'=>['fi',],
'viikon'=>['fi',],
'viimane'=>['et',],
'viime'=>['fi',],
'viimeinen'=>['fi',],
'viin'=>['et',],
'viis'=>['et',],
'viisi'=>['fi',],
'viitoare'=>['ro',],
'viitsi'=>['fi',],
'vij'=>['sq',],
'vijesti'=>['hr',],
'vijf'=>['nl',],
'vijnë'=>['sq',],
'vijë'=>['sq',],
'viktig'=>['nb','no',],
'viktigt'=>['sv',],
'viku'=>['is',],
'vil'=>['da','is','nb','no',],
'vila'=>['gl',],
'vild'=>['da',],
'vildi'=>['is',],
'vildir'=>['is',],
'vildt'=>['da',],
'vilja'=>['is','sv',],
'viljið'=>['is',],
'viljum'=>['is',],
'vilka'=>['sv',],
'vilken'=>['sv',],
'vilket'=>['sv',],
'vill'=>['is','sv',],
'ville'=>['da','fr','nb','no','sv',],
'villians'=>['af',],
'vilt'=>['is',],
'viltu'=>['is',],
'világ'=>['hu',],
'világon'=>['hu',],
'világos'=>['hu',],
'vim'=>['la','pt','pt_br',],
'vin'=>['is','ro',],
'vina'=>['ro',],
'vinc'=>['ca',],
'vind'=>['af','nl',],
'vinde'=>['da',],
'vinden'=>['nl',],
'vinder'=>['da',],
'vindo'=>['pt','pt_br',],
'vindt'=>['nl',],
'vine'=>['ca','es','ro',],
'vinga'=>['ca',],
'vingui'=>['ca',],
'vingut'=>['ca',],
'vini'=>['is','sq',],
'vinir'=>['is',],
'vinja'=>['lv',],
'vinji'=>['lv',],
'vinjsh'=>['lv',],
'vinju'=>['lv',],
'vinna'=>['is','sv',],
'vinne'=>['nb','no',],
'vinner'=>['nb','no','sv',],
'vinnige'=>['af',],
'vinnu'=>['is',],
'vinnur'=>['is',],
'vino'=>['es','la','ro',],
'vinstri'=>['is',],
'vinte'=>['gl',],
'vinur'=>['is',],
'vină'=>['ro',],
'vio'=>['es','is',],
'violencia'=>['gl',],
'vir'=>['af','la','pt','pt_br',],
'vires'=>['la',],
'viri'=>['la',],
'viribus'=>['la',],
'viris'=>['la',],
'virkar'=>['is',],
'virkelig'=>['da','nb','no',],
'virker'=>['da','nb','no',],
'virkilega'=>['is',],
'viro'=>['la',],
'viros'=>['la',],
'virs'=>['lv',],
'virtus'=>['la',],
'virtute'=>['la',],
'virtutem'=>['la',],
'virtutis'=>['la',],
'virum'=>['la',],
'virus'=>['si',],
'virði'=>['is',],
'virðist'=>['is',],
'virš'=>['lt',],
'vis'=>['da','la','lt','lv','nb','no',],
'visa'=>['lt','lv','sv',],
'visada'=>['lt',],
'visage'=>['fr',],
'visai'=>['lt',],
'visar'=>['sv',],
'visas'=>['lt','lv',],
'vise'=>['bs','da','nb','no','sr',],
'viser'=>['da','nb','no',],
'vish'=>['sq',],
'vishnu'=>['af',],
'visi'=>['lt','lv',],
'visiem'=>['lv',],
'visiems'=>['lt',],
'vision'=>['si',],
'visit'=>['en',],
'visita'=>['gl',],
'visite'=>['fr',],
'visiškai'=>['lt',],
'viska'=>['et','lt',],
'viskas'=>['lt',],
'visko'=>['lt',],
'viską'=>['lt',],
'vismaz'=>['lv',],
'viso'=>['lt',],
'visos'=>['lt',],
'vispirms'=>['lv',],
'vispār'=>['lv',],
'viss'=>['is','lv',],
'vissa'=>['sv',],
'vissi'=>['is',],
'visst'=>['nb','no','sv',],
'visste'=>['nb','no','sv',],
'vissza'=>['hu',],
'vist'=>['ca','da','et',],
'vista'=>['ca','es','gl','it','pt','pt_br',],
'viste'=>['es','pt',],
'visto'=>['es','it','pt','pt_br',],
'visu'=>['lv',],
'visum'=>['la',],
'visur'=>['lt','lv',],
'visus'=>['lt','lv',],
'viszlát'=>['hu',],
'viszont'=>['hu',],
'visā'=>['lv',],
'visām'=>['lv',],
'visą'=>['lt',],
'visų'=>['lt',],
'vit'=>['fr','sq',],
'vita'=>['is','it','la','sv',],
'vitae'=>['la',],
'vitajte'=>['sk',],
'vitam'=>['la',],
'vite'=>['fr','nb','no','sq',],
'vitia'=>['la',],
'vitin'=>['sq',],
'vitið'=>['is',],
'vittu'=>['fi',],
'vitum'=>['is',],
'vitun'=>['fi',],
'viu'=>['ca','gl','pt','pt_br',],
'viuere'=>['la',],
'viure'=>['ca',],
'viva'=>['pt','pt_br',],
'vivant'=>['fr',],
'vive'=>['es',],
'viver'=>['pt','pt_br',],
'vivere'=>['it',],
'vivir'=>['es','gl',],
'vivo'=>['es','it','pt','pt_br',],
'vivre'=>['fr',],
'vix'=>['la',],
'vizet'=>['hu',],
'við'=>['is',],
'viña'=>['gl',],
'viño'=>['gl',],
'viò'=>['is',],
'viõ'=>['is',],
'viņa'=>['lv',],
'viņai'=>['lv',],
'viņam'=>['lv',],
'viņas'=>['lv',],
'viņi'=>['lv',],
'viņiem'=>['lv',],
'viņu'=>['lv',],
'viņus'=>['lv',],
'viņš'=>['lv',],
'više'=>['bs','hr',],
'viљe'=>['bs','hr','sr',],
'vjedhur'=>['sq',],
'vjen'=>['sq',],
'vjenèanicu'=>['hi',],
'vjerojatno'=>['hr',],
'vjerovati'=>['bs','hr',],
'vjerovatno'=>['bs',],
'vjeruj'=>['bs','hr',],
'vjerujem'=>['bs','hr',],
'vjet'=>['sq',],
'vjetër'=>['sq',],
'vjeæa'=>['hi',],
'vjeç'=>['sq',],
'vlastne'=>['sk',],
'vlastní'=>['cs',],
'vlastně'=>['cs',],
'vlasy'=>['cs','sk',],
'vlieg'=>['af',],
'vliegen'=>['nl',],
'vliegtuig'=>['af','nl',],
'vlieรซnde'=>['af',],
'vlucht'=>['nl',],
'vnútri'=>['sk',],
'vo'=>['sk',],
'voastră'=>['ro',],
'vobis'=>['la',],
'vocant'=>['la',],
'vocatur'=>['la',],
'voce'=>['it','la','pt_br',],
'vocem'=>['la',],
'você'=>['pt','pt_br',],
'vocês'=>['pt','pt_br',],
'vode'=>['bs','hr','sl','sr',],
'vodi'=>['bs','hr','sl','sr',],
'vodo'=>['sl',],
'vodu'=>['bs','cs',],
'vody'=>['cs',],
'voel'=>['af','nl',],
'voelde'=>['nl',],
'voelen'=>['nl',],
'voelt'=>['nl',],
'voglia'=>['it',],
'vogliamo'=>['it',],
'voglio'=>['it',],
'vogliono'=>['it',],
'vogël'=>['sq',],
'voi'=>['fi','it','ro',],
'voiam'=>['ro',],
'voice'=>['en',],
'voici'=>['fr',],
'voie'=>['fr','ro',],
'voilà'=>['fr',],
'voimme'=>['fi',],
'voin'=>['fi',],
'voinko'=>['fi',],
'voinut'=>['fi',],
'voir'=>['fr',],
'vois'=>['fr',],
'voisi'=>['fi',],
'voisimme'=>['fi',],
'voisin'=>['fi',],
'voisit'=>['fi',],
'voisitko'=>['fi',],
'voit'=>['fi','fr',],
'voitko'=>['fi',],
'voittaa'=>['fi',],
'voitte'=>['fi',],
'voiture'=>['fr',],
'voivat'=>['fi',],
'voix'=>['fr',],
'vol'=>['ca','nl',],
'volal'=>['sk',],
'voldria'=>['ca',],
'vole'=>['bs',],
'volela'=>['sr',],
'volem'=>['ca',],
'volen'=>['ca',],
'voleo'=>['sr',],
'volete'=>['it',],
'voleu'=>['ca',],
'voleva'=>['it',],
'volevo'=>['it',],
'volg'=>['nl',],
'volgen'=>['nl',],
'volgende'=>['af','nl',],
'volgens'=>['nl',],
'voli'=>['bs','hr','sr',],
'volia'=>['ca',],
'volim'=>['bs','hr','sr',],
'volio'=>['bs','hr',],
'volituri'=>['hi',],
'voliš'=>['bs','hr',],
'voliљ'=>['sr',],
'voljela'=>['bs','hr',],
'voljo'=>['sl',],
'voll'=>['de',],
'voller'=>['de',],
'volmaakte'=>['af',],
'volna'=>['hu',],
'vols'=>['ca',],
'volt'=>['hu',],
'volta'=>['gl','it','pt','pt_br',],
'voltak'=>['hu',],
'voltam'=>['hu',],
'voltar'=>['pt','pt_br',],
'volte'=>['it','pt_br',],
'voltirima'=>['hi',],
'volto'=>['pt','pt_br',],
'voltooi'=>['af',],
'voltou'=>['pt','pt_br',],
'voltunk'=>['hu',],
'voltura'=>['hi',],
'volturi'=>['hi','si',],
'voltál'=>['hu',],
'voluit'=>['la',],
'volunt'=>['la',],
'voluntate'=>['la',],
'voluto'=>['it',],
'volver'=>['es','gl',],
'volveu'=>['gl',],
'volá'=>['sk',],
'volám'=>['sk',],
'volé'=>['fr',],
'vom'=>['de','ro',],
'von'=>['de','is','sk',],
'vona'=>['is',],
'vonandi'=>['is',],
'vond'=>['nl',],
'vondt'=>['nb','no',],
'vonku'=>['sk',],
'vont'=>['fr',],
'vontade'=>['gl','pt','pt_br',],
'vonë'=>['sq',],
'voor'=>['af','nl',],
'vooral'=>['nl',],
'voorbij'=>['nl',],
'voordat'=>['af','nl',],
'voorstellen'=>['nl',],
'vooruit'=>['nl',],
'voorzichtig'=>['nl',],
'vor'=>['de','ro',],
'vorba'=>['ro',],
'vorbei'=>['de',],
'vorbesc'=>['ro',],
'vorbeşte'=>['ro',],
'vorbeşti'=>['ro',],
'vorbi'=>['ro',],
'vorbim'=>['ro',],
'vorbit'=>['ro',],
'vore'=>['da','sv',],
'vores'=>['da','no',],
'vorher'=>['de',],
'vorige'=>['af','nl',],
'vorrei'=>['it',],
'vors'=>['af',],
'vorsicht'=>['de',],
'vorsichtig'=>['de',],
'vorstellen'=>['de',],
'voru'=>['is',],
'vorum'=>['is',],
'vos'=>['ca','fr','gl','la','lt','pt',],
'vosaltres'=>['ca',],
'vosotros'=>['es',],
'vossa'=>['pt',],
'vosso'=>['pt',],
'vostede'=>['gl',],
'vostra'=>['ca','it',],
'vostres'=>['ca',],
'vostri'=>['it',],
'vostro'=>['it',],
'vostru'=>['ro',],
'vostè'=>['ca',],
'vostès'=>['ca',],
'vosté'=>['ca',],
'votre'=>['fr',],
'vou'=>['gl','pt','pt_br',],
'voudrais'=>['fr',],
'voulais'=>['fr',],
'voulait'=>['fr',],
'voulez'=>['fr',],
'voulu'=>['fr',],
'vous'=>['fr',],
'vox'=>['la',],
'voy'=>['es',],
'voyage'=>['fr',],
'voyager'=>['id',],
'voyez'=>['fr',],
'voyons'=>['fr',],
'voz'=>['es','gl','pt','pt_br',],
'vozitit'=>['hi',],
'vošca'=>['hi',],
'voรซl'=>['af',],
'vprašal'=>['sl',],
'vprašanje'=>['sl',],
'vra'=>['af',],
'vraag'=>['af','nl',],
'vraagt'=>['nl',],
'vraga'=>['bs','hr','sl',],
'vragen'=>['nl',],
'vrai'=>['fr',],
'vraie'=>['fr',],
'vraiment'=>['fr',],
'vrapo'=>['sq',],
'vrarë'=>['sq',],
'vras'=>['sq',],
'vrasin'=>['sq',],
'vrasje'=>['sq',],
'vrata'=>['bs','hr','sl','sr',],
'vrati'=>['bs','hr','sr',],
'vratim'=>['bs','sr',],
'vratio'=>['bs','hr','sr',],
'vratit'=>['hr',],
'vratiti'=>['bs','hr','sr',],
'vrau'=>['sq',],
'vravel'=>['sk',],
'vraèao'=>['hi',],
'vrať'=>['cs',],
'vraжam'=>['sr',],
'vrea'=>['ro',],
'vreau'=>['ro',],
'vred'=>['da',],
'vredu'=>['sl',],
'vreemd'=>['af','nl',],
'vreeslik'=>['af',],
'vrei'=>['ro',],
'vrem'=>['ro',],
'vreme'=>['ro','sr',],
'vremea'=>['ro',],
'vremena'=>['bs','hr','sr',],
'vreo'=>['ro',],
'vreodată'=>['ro',],
'vreselijk'=>['nl',],
'vreugde'=>['af',],
'vreun'=>['ro',],
'vreţi'=>['ro',],
'vriend'=>['nl',],
'vrienden'=>['nl',],
'vriendin'=>['af','nl',],
'vrij'=>['nl',],
'vrijeme'=>['bs','hr',],
'vrlo'=>['bs','hr','sr',],
'vrnem'=>['sl',],
'vrni'=>['sl',],
'vrnil'=>['sl',],
'vrnila'=>['sl',],
'vrniti'=>['sl',],
'vroeg'=>['nl',],
'vroeger'=>['nl',],
'vroiam'=>['ro',],
'vrolikheid'=>['af',],
'vrou'=>['af',],
'vroue'=>['af',],
'vroulike'=>['af',],
'vrouw'=>['nl',],
'vrouwen'=>['nl',],
'vrsta'=>['bs',],
'vrsti'=>['sl',],
'vrut'=>['ro',],
'vry'=>['af',],
'vrátil'=>['cs','sk',],
'vrátim'=>['sk',],
'vrátit'=>['cs',],
'vrátiť'=>['sk',],
'vrátí'=>['cs',],
'vrátím'=>['cs',],
'vráť'=>['sk',],
'vsa'=>['sl',],
'vsaj'=>['sl',],
'vsak'=>['sl',],
'vsako'=>['sl',],
'vse'=>['sl',],
'vseeno'=>['sl',],
'vsega'=>['sl',],
'vseh'=>['sl',],
'vsem'=>['sl',],
'vsi'=>['sl',],
'vso'=>['sl',],
'vstani'=>['sl',],
'vtedy'=>['sk',],
'vu'=>['fr',],
'vue'=>['fr',],
'vuelta'=>['es',],
'vuelto'=>['es',],
'vuelve'=>['es',],
'vuit'=>['ca',],
'vul'=>['af',],
'vulgui'=>['ca',],
'vulguis'=>['ca',],
'vull'=>['ca',],
'vult'=>['la',],
'vuoden'=>['fi',],
'vuoi'=>['it',],
'vuoksi'=>['fi',],
'vuol'=>['it',],
'vuole'=>['it',],
'vuonna'=>['fi',],
'vuotias'=>['fi',],
'vuotta'=>['fi',],
'vure'=>['af',],
'vuur'=>['nl',],
'vuèiji'=>['hi',],
'vy'=>['cs','sk',],
'vyand'=>['af',],
'vyksta'=>['lt',],
'vypadni'=>['cs','sk',],
'vypadá'=>['cs',],
'vypadáš'=>['cs',],
'vyrai'=>['lt',],
'vyras'=>['lt',],
'vyrukas'=>['lt',],
'vyrų'=>['lt',],
'vyzerá'=>['sk',],
'vyzeráš'=>['sk',],
'vzal'=>['cs','sk',],
'vzel'=>['sl',],
'vzela'=>['sl',],
'vzemi'=>['sl',],
'vziať'=>['sk',],
'vzít'=>['cs',],
'vá'=>['is','pt','pt_br',],
'vám'=>['cs','sk',],
'vámi'=>['cs',],
'vámonos'=>['es',],
'vár'=>['hu',],
'várj'=>['hu',],
'várjon'=>['hu',],
'város'=>['hu',],
'városban'=>['hu',],
'vás'=>['cs','sk',],
'vázquez'=>['gl',],
'váš'=>['cs','sk',],
'vášho'=>['sk',],
'vážne'=>['sk',],
'vážně'=>['cs',],
'vão'=>['pt','pt_br',],
'väg'=>['sv',],
'väga'=>['et',],
'vägen'=>['sv',],
'vähem'=>['et',],
'vähemalt'=>['et',],
'vähän'=>['fi',],
'väike'=>['et',],
'väl'=>['sv',],
'väldigt'=>['sv',],
'välillä'=>['fi',],
'välitä'=>['fi',],
'väliä'=>['fi',],
'välja'=>['et',],
'väljas'=>['et',],
'välkommen'=>['sv',],
'vän'=>['sv',],
'vänner'=>['sv',],
'vänster'=>['sv',],
'vänta'=>['sv',],
'väntar'=>['sv',],
'värk'=>['et',],
'värld'=>['sv',],
'världen'=>['sv',],
'världens'=>['sv',],
'värre'=>['sv',],
'väsinud'=>['et',],
'väärin'=>['fi',],
'väärt'=>['et',],
'väärässä'=>['fi',],
'våben'=>['da',],
'våpen'=>['nb','no',],
'vår'=>['nb','no','sv',],
'våra'=>['sv',],
'våre'=>['nb','no',],
'vårt'=>['nb','no','sv',],
'væk'=>['da','no',],
'vær'=>['da','nb','no',],
'værd'=>['da',],
'være'=>['da','nb','no',],
'værelse'=>['da',],
'været'=>['da','no',],
'væri'=>['is',],
'værir'=>['is',],
'værre'=>['da',],
'værsgo'=>['da',],
'vært'=>['nb','no',],
'væru'=>['is',],
'vége'=>['hu',],
'véget'=>['hu',],
'végig'=>['hu',],
'végre'=>['hu',],
'végén'=>['hu',],
'végül'=>['hu',],
'vén'=>['gl',],
'vérité'=>['fr',],
'vés'=>['ca',],
'vê'=>['pt','pt_br',],
'vês'=>['pt',],
'vë'=>['sq',],
'vëlla'=>['sq',],
'vëllai'=>['sq',],
'vënë'=>['sq',],
'vërtet'=>['sq',],
'vërteta'=>['sq',],
'vërtetë'=>['sq',],
'vërtetën'=>['sq',],
'vështirë'=>['sq',],
'ví'=>['cs',],
'vía'=>['gl',],
'víc'=>['cs',],
'více'=>['cs',],
'vím'=>['cs',],
'víme'=>['cs',],
'víst'=>['is',],
'víte'=>['cs',],
'víz'=>['hu',],
'víš'=>['cs',],
'vòli'=>['ca',],
'vôbec'=>['sk',],
'või'=>['et',],
'võib'=>['et',],
'võibolla'=>['et',],
'võid'=>['et',],
'võiks'=>['et',],
'võiksid'=>['et',],
'võiksin'=>['et',],
'võimalik'=>['et',],
'võimalus'=>['et',],
'võime'=>['et',],
'võin'=>['et',],
'võinud'=>['et',],
'võite'=>['et',],
'võivad'=>['et',],
'võta'=>['et',],
'võtab'=>['et',],
'võtad'=>['et',],
'võtaks'=>['et',],
'võtame'=>['et',],
'võtan'=>['et',],
'võtke'=>['et',],
'võtma'=>['et',],
'võtsid'=>['et',],
'võtta'=>['et',],
'võttis'=>['et',],
'völlig'=>['de',],
'výborne'=>['sk',],
'výborně'=>['cs',],
'vārds'=>['lv',],
'vārdu'=>['lv',],
'vārdus'=>['lv',],
'vārdā'=>['lv',],
'vă'=>['ro',],
'văd'=>['ro',],
'văzut'=>['ro',],
'včasih'=>['sl',],
'včera'=>['cs','sk',],
'včeraj'=>['sl',],
'vďaka'=>['sk',],
'vēl'=>['lv',],
'vēlas'=>['lv',],
'vēlaties'=>['lv',],
'vēlies'=>['lv',],
'vēlos'=>['lv',],
'vēlreiz'=>['lv',],
'vēlu'=>['lv',],
'vēlāk'=>['lv',],
'vēlētos'=>['lv',],
'vērts'=>['lv',],
'vėl'=>['lt',],
'vėliau'=>['lt',],
'věc'=>['cs',],
'věci'=>['cs',],
'věcí'=>['cs',],
'věděl'=>['cs',],
'věděla'=>['cs',],
'vědět'=>['cs',],
'větší'=>['cs',],
'vězení'=>['cs',],
'věřit'=>['cs',],
'věřím'=>['cs',],
'vīri'=>['lv',],
'vīrietis'=>['lv',],
'vīrs'=>['lv',],
'vīru'=>['lv',],
'všade'=>['sk',],
'však'=>['cs','sk',],
'vše'=>['cs',],
'všech'=>['cs',],
'všechno'=>['cs',],
'všechny'=>['cs',],
'všem'=>['cs',],
'všetci'=>['sk',],
'všetko'=>['sk',],
'všetky'=>['sk',],
'všetkých'=>['sk',],
'všetkým'=>['sk',],
'všeč'=>['sl',],
'všichni'=>['cs',],
'všude'=>['cs',],
'vůbec'=>['cs',],
'vždy'=>['cs','sk',],
'vždycky'=>['cs',],
'vždyť'=>['cs',],
'və'=>['az',],
'vα'=>['el',],
'w'=>['pl','zh_tw',],
'wa'=>['af',],
'waar'=>['af','nl',],
'waard'=>['nl',],
'waarheid'=>['nl',],
'waarom'=>['af','nl',],
'waarschijnlijk'=>['nl',],
'waarskuwing'=>['af',],
'waarskynlik'=>['af',],
'wacht'=>['nl',],
'wachten'=>['nl',],
'wafer'=>['si',],
'wafers'=>['si',],
'waffe'=>['de',],
'waffen'=>['de',],
'wag'=>['af',],
'wagen'=>['de','nl',],
'wahl'=>['de',],
'wahr'=>['de',],
'wahrheit'=>['de',],
'wahrscheinlich'=>['de',],
'wait'=>['en','th',],
'waitin'=>['af',],
'waiting'=>['en',],
'wajah'=>['ms',],
'waka'=>['eu',],
'wake'=>['en',],
'wakker'=>['nl',],
'waktu'=>['id','ms',],
'waktunya'=>['ms',],
'walczyć'=>['pl',],
'walk'=>['en',],
'wall'=>['en','th',],
'walmart'=>['si',],
'wam'=>['pl',],
'wami'=>['pl',],
'wanita'=>['id','ms',],
'wann'=>['de',],
'wanna'=>['en',],
'wanneer'=>['af','nl',],
'want'=>['af','en','fa','nl','si','th',],
'wanted'=>['en',],
'wants'=>['en','th',],
'wapen'=>['nl',],
'wapens'=>['af','nl',],
'war'=>['de','en',],
'waren'=>['de','nl',],
'warm'=>['af',],
'warna'=>['id',],
'warrior'=>['af',],
'warriors'=>['af',],
'warry'=>['hi',],
'warst'=>['de',],
'warte'=>['de',],
'warten'=>['de',],
'wartet'=>['de',],
'warum'=>['de',],
'was'=>['af','de','en','fa','nl','pl','si','th',],
'wasalagesatahan'=>['si',],
'washerman'=>['af',],
'wasn'=>['en',],
'wasser'=>['de',],
'waste'=>['si',],
'wasza'=>['pl',],
'wat'=>['af','nl',],
'watch'=>['en',],
'watching'=>['en',],
'water'=>['en','nl','si',],
'waterfall'=>['si',],
'watter'=>['af',],
'way'=>['en','th',],
'ważne'=>['pl',],
'wcale'=>['pl',],
'wciąż'=>['pl',],
'wcześniej'=>['pl',],
'wczoraj'=>['pl',],
'we'=>['en','fa','ms','nl','pl','si','th',],
'wear'=>['en',],
'wedding'=>['en',],
'weds'=>['si',],
'wedstrijd'=>['nl',],
'według'=>['pl',],
'week'=>['af','en','nl',],
'weeks'=>['en',],
'ween'=>['af',],
'weepin'=>['af',],
'weer'=>['af','nl',],
'weerlig'=>['af',],
'weermag'=>['af',],
'wees'=>['af','nl',],
'weet'=>['af','nl',],
'weg'=>['af','de','nl',],
'wegen'=>['de',],
'wegwezen'=>['nl',],
'weh'=>['de',],
'wehi'=>['eu',],
'weighed'=>['si',],
'weil'=>['de',],
'weinig'=>['nl',],
'weird'=>['en',],
'weiss'=>['de',],
'weisst'=>['de',],
'weit'=>['de',],
'weiter'=>['de',],
'weiß'=>['de',],
'weißt'=>['de',],
'wejść'=>['pl',],
'weken'=>['nl',],
'wel'=>['af','nl',],
'welche'=>['de',],
'welcher'=>['de',],
'welcome'=>['en','si','th',],
'welk'=>['nl',],
'welke'=>['nl',],
'welkom'=>['nl',],
'well'=>['en','id','ms','si','th',],
'welt'=>['de',],
'wem'=>['de',],
'wen'=>['de',],
'wenig'=>['de',],
'weniger'=>['de',],
'wenigstens'=>['de',],
'wenn'=>['de',],
'wens'=>['af',],
'went'=>['en','th',],
'wer'=>['de',],
'werd'=>['de','nl',],
'werde'=>['de',],
'werden'=>['de','nl',],
'werdet'=>['de',],
'were'=>['en','th',],
'wereld'=>['nl',],
'weren'=>['en',],
'werk'=>['nl',],
'werken'=>['nl',],
'werklik'=>['af',],
'werkt'=>['nl',],
'wert'=>['de',],
'wet'=>['nl',],
'weten'=>['nl',],
'wezmę'=>['pl',],
'weź'=>['pl',],
'what'=>['af','en','fa','ms','si','th',],
'whatever'=>['en',],
'when'=>['en','fa','si','th',],
'where'=>['af','en','si','th',],
'whether'=>['en',],
'which'=>['en',],
'while'=>['en',],
'white'=>['en',],
'whitireia'=>['eu',],
'who'=>['en','fa','si','th',],
'whoa'=>['en','ms',],
'whole'=>['en','th',],
'why'=>['en','si','th',],
'wiadomość'=>['pl',],
'wichtig'=>['de',],
'widzenia'=>['pl',],
'widział'=>['pl',],
'widziałam'=>['pl',],
'widziałem'=>['pl',],
'widziałeś'=>['pl',],
'widzieć'=>['pl',],
'widzisz'=>['pl',],
'widzę'=>['pl',],
'wie'=>['af','de','nl','pl',],
'wiecie'=>['pl',],
'wieczorem'=>['pl',],
'wieczór'=>['pl',],
'wieder'=>['de',],
'wiedersehen'=>['de',],
'wiedział'=>['pl',],
'wiedziałam'=>['pl',],
'wiedziałem'=>['pl',],
'wiedzieć'=>['pl',],
'wiedzą'=>['pl',],
'wieku'=>['pl',],
'wiele'=>['pl',],
'wielki'=>['pl',],
'wielkie'=>['pl',],
'wielu'=>['pl',],
'wiem'=>['pl',],
'wiemy'=>['pl',],
'wierzę'=>['pl',],
'wieso'=>['de',],
'wiesz'=>['pl',],
'wife'=>['en',],
'wij'=>['nl',],
'wikus'=>['th',],
'wil'=>['af','nl',],
'wilayah'=>['id',],
'wilde'=>['nl',],
'wilden'=>['nl',],
'wilhemina'=>['si',],
'will'=>['de','en','fa','si','th',],
'willen'=>['nl',],
'willkommen'=>['de',],
'willst'=>['de',],
'wilt'=>['hi','nl',],
'win'=>['en',],
'wina'=>['pl',],
'wind'=>['af','en',],
'window'=>['en',],
'wine'=>['en',],
'winnen'=>['nl',],
'wir'=>['de',],
'wird'=>['de',],
'wirklich'=>['de',],
'wirst'=>['de',],
'wish'=>['en',],
'wishing'=>['th',],
'wissen'=>['de',],
'wist'=>['nl',],
'witaj'=>['pl',],
'witam'=>['pl',],
'with'=>['en','fa','si','th',],
'withlock'=>['hi',],
'without'=>['en','th',],
'więc'=>['pl',],
'więcej'=>['pl',],
'większość'=>['pl',],
'wkrótce'=>['pl',],
'wo'=>['de',],
'woche'=>['de',],
'wochen'=>['de',],
'wody'=>['pl',],
'woestyne'=>['af',],
'woher'=>['de',],
'wohin'=>['de',],
'wohl'=>['de',],
'wohnung'=>['de',],
'wollen'=>['de',],
'wollt'=>['de',],
'wollte'=>['de',],
'wollten'=>['de',],
'wolltest'=>['de',],
'wolno'=>['pl',],
'woman'=>['en',],
'women'=>['en',],
'won'=>['en','si',],
'wonder'=>['af','en',],
'wonderful'=>['en',],
'wonen'=>['nl',],
'woon'=>['af',],
'woonstel'=>['af',],
'woont'=>['nl',],
'woord'=>['af','nl',],
'woorden'=>['nl',],
'woow'=>['si',],
'word'=>['af','en','nl',],
'worden'=>['de','nl',],
'words'=>['en',],
'wordt'=>['nl',],
'work'=>['en','si',],
'worked'=>['en',],
'working'=>['en','th',],
'works'=>['en',],
'world'=>['en','th',],
'worried'=>['en',],
'worry'=>['en','si',],
'worryin'=>['af',],
'worse'=>['en',],
'wort'=>['de',],
'worte'=>['de',],
'worth'=>['en',],
'worthing'=>['ca',],
'wou'=>['af','nl',],
'would'=>['en','si',],
'wouldn'=>['en',],
'wovon'=>['de',],
'wow'=>['da','en','ms',],
'wozu'=>['de',],
'wraak'=>['af',],
'wracaj'=>['pl',],
'wracam'=>['pl',],
'wrapped'=>['si',],
'write'=>['en',],
'wrong'=>['en','si',],
'wrote'=>['en',],
'wróci'=>['pl',],
'wrócić'=>['pl',],
'wrócę'=>['pl',],
'wspaniale'=>['pl',],
'wspólnego'=>['pl',],
'wstawaj'=>['pl',],
'wszyscy'=>['pl',],
'wszystkich'=>['pl',],
'wszystkie'=>['pl',],
'wszystkiego'=>['pl',],
'wszystkim'=>['pl',],
'wszystko'=>['pl',],
'wszędzie'=>['pl',],
'wtedy'=>['pl',],
'wunderbar'=>['de',],
'wurde'=>['de',],
'wurden'=>['de',],
'wusste'=>['de',],
'www'=>['ar','el','fi','he','it','nl','pl','ro','si','sk','sq','sv','th',],
'wy'=>['pl',],
'wybacz'=>['pl',],
'wyd'=>['af',],
'wydaje'=>['pl',],
'wygląda'=>['pl',],
'wyglądasz'=>['pl',],
'wyjść'=>['pl',],
'wypadek'=>['pl',],
'wys'=>['af',],
'wyse'=>['af',],
'wystarczająco'=>['pl',],
'wystarczy'=>['pl',],
'wziąć'=>['pl',],
'während'=>['de',],
'wär'=>['de',],
'wäre'=>['de',],
'wären'=>['de',],
'wärst'=>['de',],
'würde'=>['de',],
'würden'=>['de',],
'würdest'=>['de',],
'właściwie'=>['pl',],
'właśnie'=>['pl',],
'włosy'=>['pl',],
'wรชreld'=>['af',],
'x'=>['bn','th',],
'xa'=>['gl',],
'xaneiro'=>['gl',],
'xbox'=>['si',],
'xdb'=>['th',],
'xdbคv'=>['th',],
'xdc'=>['th',],
'xdcกaฅdฉiถฉกh'=>['th',],
'xdcกh'=>['th',],
'xdcคf'=>['th',],
'xdcฆn'=>['th',],
'xdcงไงa'=>['th',],
'xdcฉiกpจuฏsดต'=>['th',],
'xdcฐs'=>['th',],
'xdcใ'=>['th',],
'xdcไแ'=>['th',],
'xdcๆ'=>['th',],
'xdd'=>['th',],
'xddฆbงaชบจฎธฬ'=>['th',],
'xddรd'=>['th',],
'xddแ'=>['th',],
'xde'=>['th',],
'xdeกi'=>['th',],
'xdeฅl'=>['th',],
'xdeงa'=>['th',],
'xdeปk'=>['th',],
'xeb'=>['sq',],
'xefe'=>['gl',],
'xeito'=>['gl',],
'xente'=>['gl',],
'xeral'=>['gl',],
'xestión'=>['gl',],
'xfc'=>['th',],
'xfcใ'=>['th',],
'xfd'=>['th',],
'xfdกi'=>['th',],
'xfdคkณjกi'=>['th',],
'xfdฅอ'=>['th',],
'xfdชบ'=>['th',],
'xfdชบกi'=>['th',],
'xfdใๅ'=>['th',],
'xfe'=>['th',],
'xhek'=>['sq',],
'xhon'=>['sq',],
'xogo'=>['gl',],
'xosé'=>['gl',],
'xunta'=>['gl',],
'xunto'=>['gl',],
'xustiza'=>['gl',],
'xusto'=>['gl',],
'xí'=>['ca',],
'xətdə'=>['az',],
'y'=>['en','es','fr','zh_tw',],
'ya'=>['az','en','es','id','ms','si','tr',],
'yaa'=>['si',],
'yah'=>['id','ms',],
'yakin'=>['id','ms',],
'yakın'=>['tr',],
'yakında'=>['tr',],
'yalan'=>['tr',],
'yalnız'=>['tr',],
'yalnızca'=>['tr',],
'yan'=>['az',],
'yang'=>['id','ms',],
'yani'=>['tr',],
'yanlış'=>['tr',],
'yanına'=>['tr',],
'yanında'=>['tr',],
'yap'=>['tr',],
'yapabilirim'=>['tr',],
'yapacak'=>['tr',],
'yapacaksın'=>['tr',],
'yapacağım'=>['tr',],
'yapacağız'=>['tr',],
'yapalım'=>['tr',],
'yapamam'=>['tr',],
'yapar'=>['tr',],
'yaparım'=>['tr',],
'yapma'=>['tr',],
'yapmak'=>['tr',],
'yapmam'=>['tr',],
'yapmaya'=>['tr',],
'yaptı'=>['tr',],
'yaptım'=>['tr',],
'yaptın'=>['tr',],
'yaptığı'=>['tr',],
'yaptığını'=>['tr',],
'yapıyor'=>['tr',],
'yapıyorsun'=>['tr',],
'yapıyorum'=>['tr',],
'yardım'=>['tr',],
'yardımcı'=>['tr',],
'yarın'=>['tr',],
'yavaş'=>['tr',],
'yaxşı'=>['az',],
'yazdı'=>['az',],
'yaşlı'=>['tr',],
'yaşında'=>['tr',],
'yaşıyor'=>['tr',],
'yeah'=>['da','de','en','fa','id','ms','si','sk','th',],
'year'=>['en',],
'years'=>['en',],
'yedi'=>['tr',],
'yemek'=>['tr',],
'yemeği'=>['tr',],
'yemin'=>['tr',],
'yeni'=>['az','tr',],
'yeniden'=>['tr',],
'yer'=>['az','tr',],
'yerde'=>['tr',],
'yere'=>['tr',],
'yeri'=>['tr',],
'yerinde'=>['tr',],
'yerine'=>['tr',],
'yerini'=>['tr',],
'yes'=>['en','fa','si','th',],
'yesterday'=>['en',],
'yesus'=>['ms',],
'yet'=>['en',],
'yeter'=>['tr',],
'yeterince'=>['tr',],
'yeterli'=>['tr',],
'yeux'=>['fr',],
'yfir'=>['is',],
'yg'=>['ms',],
'yhden'=>['fi',],
'yhdessä'=>['fi',],
'yhteen'=>['fi',],
'yhtä'=>['fi',],
'yhtään'=>['fi',],
'yhä'=>['fi',],
'yine'=>['tr',],
'ykkar'=>['is',],
'ykkur'=>['is',],
'yksi'=>['fi',],
'yksin'=>['fi',],
'yleensä'=>['fi',],
'yli'=>['fi',],
'ylös'=>['fi',],
'ymmärrä'=>['fi',],
'ymmärrän'=>['fi',],
'ymmärrätkö'=>['fi',],
'ymmärtää'=>['fi',],
'ympäri'=>['fi',],
'ynë'=>['sq',],
'yo'=>['en','es','id','tr',],
'yok'=>['tr',],
'yoksa'=>['tr',],
'yoktu'=>['tr',],
'yoktur'=>['tr',],
'yol'=>['tr',],
'yola'=>['tr',],
'yolu'=>['tr',],
'yolunda'=>['tr',],
'york'=>['af','ca','da','de','en','es','fr','is','it','ms','nb','nl','no','ro','sv','tr',],
'you'=>['bs','cs','de','en','fa','hr','hu','lt','lv','ms','nb','pl','si','sk','th','zh_cn',],
'youjust'=>['hi',],
'young'=>['en','th',],
'your'=>['en','fa','si','th',],
'yours'=>['en','si',],
'yourself'=>['en',],
'yox'=>['az',],
'yoxdur'=>['az',],
'ypač'=>['lt',],
'yra'=>['lt',],
'yritin'=>['fi',],
'yrittää'=>['fi',],
'yritä'=>['fi',],
'yritän'=>['fi',],
'yrði'=>['is',],
'ys'=>['af',],
'ystäviä'=>['fi',],
'ystävä'=>['fi',],
'ystäväni'=>['fi',],
'yt'=>['sq',],
'yukarı'=>['tr',],
'yup'=>['af',],
'yðar'=>['is',],
'yönä'=>['fi',],
'yötä'=>['fi',],
'yüksek'=>['tr',],
'yürü'=>['tr',],
'yüz'=>['tr',],
'yüzbaşı'=>['tr',],
'yüzden'=>['tr',],
'yüzünden'=>['tr',],
'yıl'=>['tr',],
'yıldır'=>['tr',],
'z'=>['az','cs','nl','pl','sk','sl','sq',],
'za'=>['bs','cs','hr','pl','sk','sl','sr',],
'zaak'=>['nl',],
'zabaltzen'=>['eu',],
'zabavno'=>['sl',],
'zabavo'=>['sl',],
'zabawne'=>['pl',],
'zabierz'=>['pl',],
'zabijem'=>['sk',],
'zabiju'=>['cs',],
'zabiję'=>['pl',],
'zabil'=>['cs','sk',],
'zabić'=>['pl',],
'zabił'=>['pl',],
'zabiť'=>['sk',],
'zaboravi'=>['bs','hr','sr',],
'zaboravio'=>['bs','hr','sr',],
'zabortegi'=>['eu',],
'zabrać'=>['pl',],
'zabudni'=>['sk',],
'zabudol'=>['sk',],
'zabít'=>['cs',],
'zacjelit'=>['hi',],
'zaczekaj'=>['pl',],
'zaczyna'=>['pl',],
'zacząć'=>['pl',],
'zadaj'=>['sl',],
'zadnja'=>['sl',],
'zadnje'=>['sl',],
'zadnji'=>['hr','sl',],
'zadnjič'=>['sl',],
'zadzwonić'=>['pl',],
'zadzwonię'=>['pl',],
'zag'=>['nl',],
'zagotovo'=>['sl',],
'zahar'=>['eu',],
'zaharra'=>['eu',],
'zaharrak'=>['eu',],
'zaharraren'=>['eu',],
'zaharretan'=>['eu',],
'zahlen'=>['de',],
'zaigu'=>['eu',],
'zain'=>['eu',],
'zainetan'=>['eu',],
'zaintzen'=>['eu',],
'zaista'=>['bs','hr','sr',],
'zait'=>['eu',],
'zaitez'=>['eu',],
'zaitu'=>['eu',],
'zaitut'=>['eu',],
'zaizkigun'=>['eu',],
'zaizue'=>['eu',],
'zajedno'=>['bs','hr','sr',],
'zajtra'=>['sk',],
'zak'=>['nl',],
'zakaj'=>['sl',],
'zaken'=>['nl',],
'zakila'=>['eu',],
'zakilei'=>['eu',],
'zakon'=>['sl',],
'zal'=>['nl',],
'zaldizkoaren'=>['eu',],
'zaleðeni'=>['hi',],
'zależy'=>['pl',],
'zaman'=>['az','tr',],
'zamanda'=>['tr',],
'zamandır'=>['tr',],
'zamanlar'=>['tr',],
'zamanı'=>['tr',],
'zame'=>['sl',],
'zamknij'=>['pl',],
'zanim'=>['pl',],
'zanima'=>['hr','sl',],
'zanj'=>['sl',],
'zapamitit'=>['hi',],
'zapomnij'=>['pl',],
'zapomněl'=>['cs',],
'zapravo'=>['bs','hr','sr',],
'zar'=>['bs','hr','sr',],
'zara'=>['eu',],
'zaradi'=>['sl',],
'zarar'=>['tr',],
'zaraz'=>['pl',],
'zarela'=>['eu',],
'zares'=>['sl',],
'zarete'=>['eu',],
'zaretela'=>['eu',],
'zas'=>['cs',],
'zase'=>['cs','sk','sl',],
'zastavit'=>['cs',],
'zastaviť'=>['sk',],
'zasto'=>['bs','sr',],
'zat'=>['nl',],
'zate'=>['sl',],
'zaten'=>['tr',],
'zati'=>['eu',],
'zatiaľ'=>['sk',],
'zato'=>['bs','hr','sl','sr',],
'zatoz'=>['eu',],
'zatraceně'=>['cs',],
'zatrzymać'=>['pl',],
'zatzaizkie'=>['eu',],
'zatím'=>['cs',],
'zaude'=>['eu',],
'zaudenean'=>['eu',],
'zauvek'=>['sr',],
'zauvijek'=>['hr',],
'zavallı'=>['tr',],
'zavolaj'=>['sk',],
'zavolat'=>['cs',],
'zavolať'=>['sk',],
'zavolej'=>['cs',],
'zavolám'=>['cs','sk',],
'zavuæi'=>['hi',],
'zawsze'=>['pl',],
'začal'=>['cs','sk',],
'začať'=>['sk',],
'začel'=>['sl',],
'začela'=>['sl',],
'začína'=>['sk',],
'začíná'=>['cs',],
'začít'=>['cs',],
'zaštititmo'=>['hi',],
'zašto'=>['bs','hr',],
'zaљto'=>['bs','hr','sr',],
'zbilja'=>['hr',],
'zbog'=>['bs','hr','sr',],
'zbogom'=>['hr','sr',],
'zbohom'=>['sk',],
'zbrane'=>['sk',],
'zbraně'=>['cs',],
'zbraň'=>['cs','sk',],
'zbyt'=>['pl',],
'zbytek'=>['cs',],
'zdaj'=>['sl',],
'zde'=>['cs',],
'zdi'=>['sl',],
'zdjęcia'=>['pl',],
'zdjęcie'=>['pl',],
'zdravo'=>['bs','hr','sl','sr',],
'zdravím'=>['cs','sk',],
'zdá'=>['cs','sk',],
'ze'=>['cs','nl','pl','sk',],
'zece'=>['ro',],
'zee'=>['nl','si',],
'zeer'=>['nl',],
'zeg'=>['nl',],
'zeggen'=>['nl',],
'zegoen'=>['eu',],
'zegt'=>['nl',],
'zehar'=>['eu',],
'zehatz'=>['eu',],
'zehn'=>['de',],
'zei'=>['nl',],
'zeig'=>['de',],
'zeigen'=>['de',],
'zein'=>['eu',],
'zeit'=>['de',],
'zeker'=>['nl',],
'zelako'=>['eu',],
'zelf'=>['nl',],
'zelfs'=>['nl',],
'zelim'=>['bs',],
'zelo'=>['sl',],
'zelta'=>['lv',],
'zem'=>['lv','sk',],
'zemes'=>['lv',],
'zemi'=>['cs','lv','sk',],
'zemlja'=>['bs','hr','sr',],
'zemlje'=>['bs','hr','sr',],
'zemlji'=>['bs','hr','sr',],
'zemlju'=>['bs','hr','sr',],
'zemra'=>['sq',],
'zemër'=>['sq',],
'zemē'=>['lv',],
'země'=>['cs',],
'zemřel'=>['cs',],
'zen'=>['eu',],
'zenbait'=>['eu',],
'zenbat'=>['eu',],
'zenbaterako'=>['eu',],
'zenean'=>['eu',],
'zengin'=>['tr',],
'zenidan'=>['eu',],
'zenioke'=>['eu',],
'zenion'=>['eu',],
'zenuen'=>['eu',],
'zenuenik'=>['eu',],
'zenuke'=>['eu',],
'zeptat'=>['cs',],
'zer'=>['eu',],
'zeraman'=>['eu',],
'zerbait'=>['eu',],
'zerbaiten'=>['eu',],
'zergatik'=>['eu',],
'zertarako'=>['eu',],
'zertaz'=>['eu',],
'zes'=>['nl',],
'zet'=>['nl',],
'zetten'=>['nl',],
'zeuden'=>['eu',],
'zeug'=>['de',],
'zeukala'=>['eu',],
'zeuzkan'=>['eu',],
'zeven'=>['nl',],
'zewnątrz'=>['pl',],
'zgadza'=>['pl',],
'zgjuar'=>['sq',],
'zgleda'=>['sl',],
'zgodba'=>['sl',],
'zgodbo'=>['sl',],
'zgodi'=>['sl',],
'zgodilo'=>['sl',],
'zgoraj'=>['sl',],
'zi'=>['ro','sq',],
'zic'=>['ro',],
'zice'=>['ro',],
'zich'=>['nl',],
'zichzelf'=>['nl',],
'zici'=>['ro',],
'zidaten'=>['eu',],
'zie'=>['nl',],
'zieh'=>['de',],
'ziehen'=>['de',],
'ziek'=>['nl',],
'ziekenhuis'=>['nl',],
'ziel'=>['nl',],
'ziemi'=>['pl',],
'ziemlich'=>['de',],
'zien'=>['eu','nl',],
'ziens'=>['nl',],
'ziet'=>['nl',],
'zij'=>['nl',],
'zijn'=>['nl',],
'zile'=>['ro',],
'zilegi'=>['eu',],
'zimmer'=>['de',],
'zin'=>['nl',],
'zina'=>['lv',],
'zinela'=>['eu',],
'zinen'=>['eu',],
'zini'=>['lv',],
'ziniet'=>['lv',],
'zintudan'=>['eu',],
'zinu'=>['lv',],
'zināju'=>['lv',],
'zinām'=>['lv',],
'zināms'=>['lv',],
'zināt'=>['lv',],
'zio'=>['it',],
'zioten'=>['eu',],
'ziren'=>['eu',],
'zis'=>['ro',],
'zit'=>['nl',],
'zitten'=>['nl',],
'zitto'=>['it',],
'zituen'=>['eu',],
'zitzaizun'=>['eu',],
'ziua'=>['ro',],
'ziņas'=>['lv',],
'ziņu'=>['lv',],
'zjarr'=>['sq',],
'zjutraj'=>['sl',],
'zkus'=>['cs',],
'zlatko'=>['sk',],
'zlato'=>['cs','sk',],
'zle'=>['sk',],
'zlé'=>['sk',],
'zlý'=>['sk',],
'zmeniť'=>['sk',],
'zmienić'=>['pl',],
'zmysel'=>['sk',],
'zna'=>['bs','hr','pl','sr',],
'znaci'=>['sr',],
'znaczy'=>['pl',],
'znaju'=>['bs','hr','sr',],
'znak'=>['bs',],
'znala'=>['bs','hr','sr',],
'znalazłem'=>['pl',],
'znaleźć'=>['pl',],
'znali'=>['hr',],
'znam'=>['bs','hr','pl','sl','sr',],
'znamená'=>['cs','sk',],
'znamo'=>['bs','hr','sr',],
'znao'=>['bs','hr','sr',],
'znas'=>['bs','sr',],
'znasz'=>['pl',],
'znate'=>['bs','hr','sr',],
'znati'=>['bs','hr','sr',],
'znać'=>['pl',],
'znači'=>['bs','hr',],
'znaš'=>['bs','hr','sl',],
'znaиi'=>['bs','hr','sr',],
'znaљ'=>['bs','hr','sr',],
'znie'=>['sk',],
'znj'=>['sq',],
'znova'=>['sk',],
'znovu'=>['cs','sk',],
'znowu'=>['pl',],
'znám'=>['cs',],
'znáte'=>['cs',],
'znáš'=>['cs',],
'zní'=>['cs',],
'znów'=>['pl',],
'zo'=>['nl','sk',],
'zoals'=>['nl',],
'zoaz'=>['eu',],
'zoazen'=>['eu',],
'zobacz'=>['pl',],
'zobaczenia'=>['pl',],
'zobaczymy'=>['pl',],
'zobaczyć'=>['pl',],
'zober'=>['sk',],
'zobrať'=>['sk',],
'zodat'=>['nl',],
'zodra'=>['nl',],
'zoek'=>['nl',],
'zoeken'=>['nl',],
'zoiets'=>['nl',],
'zolang'=>['nl',],
'zomaar'=>['nl',],
'zombie'=>['th',],
'zomrel'=>['sk',],
'zomrieť'=>['sk',],
'zona'=>['ca','gl','id','ro',],
'zonas'=>['gl',],
'zonder'=>['nl',],
'zonja'=>['sq',],
'zonjë'=>['sq',],
'zoon'=>['nl',],
'zor'=>['tr',],
'zoragarria'=>['eu',],
'zorg'=>['nl',],
'zorgen'=>['nl',],
'zorionak'=>['eu',],
'zoriontsua'=>['eu',],
'zoroa'=>['eu',],
'zorunda'=>['tr',],
'zorundayım'=>['tr',],
'zostanie'=>['pl',],
'zostaw'=>['pl',],
'zostawić'=>['pl',],
'zostać'=>['pl',],
'został'=>['pl',],
'została'=>['pl',],
'zostało'=>['pl',],
'zostały'=>['pl',],
'zostań'=>['pl',],
'zostaň'=>['sk',],
'zostať'=>['sk',],
'zot'=>['sq',],
'zoteri'=>['sq',],
'zoti'=>['sq',],
'zotin'=>['sq',],
'zotit'=>['sq',],
'zotëri'=>['sq',],
'zotërinj'=>['sq',],
'zou'=>['nl',],
'zouden'=>['nl',],
'zove'=>['bs','hr','sr',],
'zoveel'=>['nl',],
'zovem'=>['bs','hr','sr',],
'zover'=>['nl',],
'zoveљ'=>['sr',],
'zovi'=>['bs','sr',],
'zprávy'=>['cs',],
'zpátky'=>['cs',],
'zpět'=>['cs',],
'způsob'=>['cs',],
'zraven'=>['sl',],
'zrobi'=>['pl',],
'zrobimy'=>['pl',],
'zrobisz'=>['pl',],
'zrobić'=>['pl',],
'zrobię'=>['pl',],
'zrobił'=>['pl',],
'zrobiłem'=>['pl',],
'zrobiłeś'=>['pl',],
'zrovna'=>['cs',],
'zrób'=>['pl',],
'ztratil'=>['cs',],
'zu'=>['de','eu',],
'zubi'=>['eu',],
'zuen'=>['eu',],
'zuentzako'=>['eu',],
'zuerst'=>['de',],
'zuetako'=>['eu',],
'zug'=>['de',],
'zugandik'=>['eu',],
'zuk'=>['eu',],
'zukunft'=>['de',],
'zullen'=>['nl',],
'zulotik'=>['eu',],
'zult'=>['nl',],
'zum'=>['de',],
'zunaj'=>['sl',],
'zupełnie'=>['pl',],
'zur'=>['de',],
'zure'=>['eu',],
'zurekin'=>['eu',],
'zuretzat'=>['eu',],
'zuri'=>['eu',],
'zurück'=>['de',],
'zus'=>['nl',],
'zusammen'=>['de',],
'zuster'=>['nl',],
'zutela'=>['eu',],
'zuten'=>['eu',],
'zuzena'=>['eu',],
'zuzenduko'=>['eu',],
'zuzenean'=>['eu',],
'zuzentzeko'=>['eu',],
'zvao'=>['bs','hr','sr',],
'zvečer'=>['sl',],
'zvláštní'=>['cs',],
'zvuæi'=>['hi',],
'zvuèati'=>['hi',],
'zvuči'=>['hr',],
'zvuиi'=>['sr',],
'zvēru'=>['lv',],
'zwaar'=>['nl',],
'zwar'=>['de',],
'zwarte'=>['nl',],
'zweer'=>['nl',],
'zwei'=>['de',],
'zwischen'=>['de',],
'záleží'=>['cs','sk',],
'zë'=>['sq',],
'zënë'=>['sq',],
'zítra'=>['cs',],
'zēni'=>['lv',],
'zēns'=>['lv',],
'złe'=>['pl',],
'złego'=>['pl',],
'zły'=>['pl',],
'zůstat'=>['cs',],
'zůstaň'=>['cs',],
'à'=>['fr','is','pt','pt_br',],
'ànima'=>['ca',],
'às'=>['pt','pt_br',],
'á'=>['fr','gl','hu','is','pt',],
'áfram'=>['is',],
'água'=>['pt','pt_br',],
'ágætt'=>['is',],
'áhuga'=>['is',],
'áhyggjur'=>['is',],
'áll'=>['hu',],
'állj'=>['hu',],
'ám'=>['hu',],
'ámbito'=>['gl',],
'án'=>['is',],
'áno'=>['sk',],
'ár'=>['is',],
'ára'=>['is',],
'árum'=>['is',],
'ás'=>['gl',],
'ást'=>['is',],
'ástin'=>['is',],
'át'=>['hu',],
'átt'=>['is',],
'átta'=>['is',],
'átti'=>['is',],
'áttu'=>['is',],
'áður'=>['is',],
'â'=>['fr',],
'âge'=>['fr',],
'âme'=>['fr',],
'ä'=>['is',],
'äh'=>['de',],
'äiti'=>['fi',],
'äitini'=>['fi',],
'äitisi'=>['fi',],
'äkki'=>['et',],
'äkkiä'=>['fi',],
'älkää'=>['fi',],
'älska'=>['sv',],
'älskade'=>['sv',],
'älskar'=>['sv',],
'älskling'=>['sv',],
'älä'=>['fi',],
'än'=>['sv',],
'ända'=>['sv',],
'ändern'=>['de',],
'ändå'=>['sv',],
'ännu'=>['sv',],
'äntligen'=>['sv',],
'är'=>['sv',],
'ära'=>['et',],
'ärge'=>['et',],
'ärger'=>['de',],
'äri'=>['et',],
'äta'=>['sv',],
'äter'=>['sv',],
'även'=>['sv',],
'å'=>['nb','no','sv',],
'åben'=>['da',],
'åbne'=>['da',],
'åh'=>['da','nb','no','sv',],
'åka'=>['sv',],
'åker'=>['sv',],
'åkte'=>['sv',],
'åpne'=>['nb','no',],
'år'=>['da','nb','no','sv',],
'åt'=>['sv',],
'åtminstone'=>['sv',],
'åtta'=>['sv',],
'åtte'=>['nb','no',],
'æe'=>['bs','hr',],
'æemo'=>['bs','hr',],
'æeš'=>['bs','hr',],
'ægte'=>['da',],
'ændre'=>['da',],
'ære'=>['da','nb','no',],
'ærlig'=>['nb','no',],
'ærligt'=>['da',],
'ætla'=>['is',],
'ætlar'=>['is',],
'ætlarðu'=>['is',],
'ætlaði'=>['is',],
'ætli'=>['is',],
'ætlum'=>['is',],
'ætti'=>['is',],
'ættir'=>['is',],
'ættum'=>['is',],
'æu'=>['bs','hr',],
'ça'=>['fr',],
'çabuk'=>['tr',],
'çalışıyor'=>['tr',],
'çalışıyorsun'=>['tr',],
'çalışıyorum'=>['tr',],
'çap'=>['az',],
'çdo'=>['sq',],
'çek'=>['tr',],
'çekil'=>['tr',],
'çeneni'=>['tr',],
'çeviri'=>['tr',],
'çfar'=>['sq',],
'çfarë'=>['sq',],
'çfarëdo'=>['sq',],
'çka'=>['sq',],
'çmendur'=>['sq',],
'çocuk'=>['tr',],
'çocuklar'=>['tr',],
'çocukları'=>['tr',],
'çocuğu'=>['tr',],
'çok'=>['tr',],
'çox'=>['az',],
'çoğu'=>['tr',],
'çuditshme'=>['sq',],
'çështje'=>['sq',],
'çò'=>['ca',],
'çünkü'=>['tr',],
'çık'=>['tr',],
'çıkar'=>['tr',],
'çıktı'=>['tr',],
'çərəzlərini'=>['az',],
'è'=>['it',],
'èednost'=>['hi',],
'èg'=>['is',],
'èopora'=>['hi',],
'èoporom'=>['hi',],
'èoporu'=>['hi',],
'èovjeèe'=>['bs',],
'èsser'=>['ca',],
'é'=>['gl','it','pt','pt_br',],
'école'=>['fr',],
'écoute'=>['fr',],
'écoutez'=>['fr',],
'écrire'=>['fr',],
'écrit'=>['fr',],
'édes'=>['hu',],
'édesem'=>['hu',],
'ég'=>['hu','is',],
'éhes'=>['hu',],
'éix'=>['ca',],
'éjjel'=>['hu',],
'éjszaka'=>['hu',],
'éjszakát'=>['hu',],
'éjt'=>['hu',],
'él'=>['es','hu',],
'élet'=>['hu',],
'életben'=>['hu',],
'életem'=>['hu',],
'életet'=>['hu',],
'élni'=>['hu',],
'én'=>['da','hu','nb','no',],
'época'=>['gl',],
'épp'=>['hu',],
'éppen'=>['hu',],
'équipe'=>['fr',],
'ér'=>['hu',],
'érdekel'=>['hu',],
'érdekes'=>['hu',],
'éreztem'=>['hu',],
'ért'=>['hu',],
'érte'=>['hu',],
'érted'=>['hu',],
'értelme'=>['hu',],
'értem'=>['hu',],
'értettem'=>['hu',],
'érti'=>['hu',],
'érzed'=>['hu',],
'érzem'=>['hu',],
'érzés'=>['hu',],
'és'=>['ca','hu','pt',],
'ésa'=>['es',],
'ése'=>['es',],
'ésta'=>['es',],
'éste'=>['es',],
'étaient'=>['fr',],
'étais'=>['fr',],
'était'=>['fr',],
'état'=>['fr',],
'étiez'=>['fr',],
'étrange'=>['fr',],
'été'=>['fr',],
'év'=>['hu',],
'éve'=>['hu',],
'éves'=>['hu',],
'évvel'=>['hu',],
'éxito'=>['gl',],
'één'=>['nl',],
'êtes'=>['fr',],
'être'=>['fr',],
'ë'=>['sq',],
'është'=>['sq',],
'í'=>['is',],
'ía'=>['gl',],
'ían'=>['gl',],
'így'=>['hu',],
'ísť'=>['sk',],
'îi'=>['ro',],
'îl'=>['ro',],
'îmi'=>['ro',],
'împotriva'=>['ro',],
'împreună'=>['ro',],
'în'=>['ro',],
'înainte'=>['ro',],
'înapoi'=>['ro',],
'încearcă'=>['ro',],
'începe'=>['ro',],
'început'=>['ro',],
'încerc'=>['ro',],
'încerca'=>['ro',],
'încercat'=>['ro',],
'încerci'=>['ro',],
'închisoare'=>['ro',],
'încredere'=>['ro',],
'încât'=>['ro',],
'încă'=>['ro',],
'înseamnă'=>['ro',],
'însă'=>['ro',],
'întoarce'=>['ro',],
'întorc'=>['ro',],
'întors'=>['ro',],
'întotdeauna'=>['ro',],
'între'=>['ro',],
'întreb'=>['ro',],
'întrebare'=>['ro',],
'întrebat'=>['ro',],
'întrebări'=>['ro',],
'întâi'=>['ro',],
'întâlnire'=>['ro',],
'întâlnit'=>['ro',],
'întâmpla'=>['ro',],
'întâmplat'=>['ro',],
'întâmplă'=>['ro',],
'învăţat'=>['ro',],
'înăuntru'=>['ro',],
'înţeleg'=>['ro',],
'înţelegi'=>['ro',],
'înţeles'=>['ro',],
'îti'=>['ro',],
'îşi'=>['ro',],
'îţi'=>['ro',],
'òc'=>['ca',],
'òm'=>['ca',],
'ó'=>['cs','gl','hu','is','sk',],
'óh'=>['hu',],
'ókei'=>['is',],
'óptimo'=>['pt',],
'óra'=>['hu',],
'ós'=>['gl',],
'óta'=>['hu',],
'ótimo'=>['pt','pt_br',],
'ótrúlegt'=>['is',],
'óttast'=>['is',],
'óvart'=>['is',],
'óvatosan'=>['hu',],
'õde'=>['et',],
'õhku'=>['et',],
'õhtu'=>['et',],
'õhtul'=>['et',],
'õige'=>['et',],
'õigus'=>['et',],
'õnne'=>['et',],
'õnnelik'=>['et',],
'ö'=>['is',],
'öelda'=>['et',],
'öelge'=>['et',],
'öelnud'=>['et',],
'ögon'=>['sv',],
'ögonblick'=>['sv',],
'ögonen'=>['sv',],
'öl'=>['sv',],
'öldü'=>['tr',],
'öldürmek'=>['tr',],
'öll'=>['is',],
'öllu'=>['is',],
'öllum'=>['is',],
'ölni'=>['hu',],
'ölçüsünü'=>['az',],
'ölü'=>['tr',],
'ölüm'=>['tr',],
'ön'=>['hu',],
'önce'=>['tr',],
'önemli'=>['tr',],
'önnek'=>['hu',],
'önnur'=>['is',],
'önskar'=>['sv',],
'önt'=>['hu',],
'önünde'=>['tr',],
'öppna'=>['sv',],
'öreg'=>['hu',],
'örugglega'=>['is',],
'örülök'=>['hu',],
'össze'=>['hu',],
'összes'=>['hu',],
'öt'=>['hu',],
'ötlet'=>['hu',],
'över'=>['sv',],
'överallt'=>['sv',],
'öyle'=>['tr',],
'öyleyse'=>['tr',],
'öz'=>['az',],
'özel'=>['tr',],
'özellikle'=>['tr',],
'özür'=>['tr',],
'öðru'=>['is',],
'öðrum'=>['is',],
'öö'=>['et',],
'ööd'=>['et',],
'öösel'=>['et',],
'ø'=>['da','nb','no',],
'ødelagt'=>['nb',],
'ødelegge'=>['nb',],
'øh'=>['da',],
'øje'=>['da',],
'øjeblik'=>['da',],
'øjne'=>['da',],
'øjnene'=>['da',],
'øl'=>['da','nb','no',],
'ønske'=>['da','nb','no',],
'ønsker'=>['da','nb','no',],
'ønsket'=>['nb','no',],
'øye'=>['nb','no',],
'øyeblikk'=>['nb','no',],
'øyne'=>['nb',],
'øynene'=>['nb','no',],
'ú'=>['is',],
'úgy'=>['hu',],
'úgyhogy'=>['hu',],
'új'=>['hu',],
'újabb'=>['hu',],
'újra'=>['hu',],
'últim'=>['ca',],
'última'=>['ca','es','gl','pt','pt_br',],
'último'=>['es','gl','pt','pt_br',],
'últimos'=>['gl',],
'únic'=>['ca',],
'única'=>['ca','es','gl','pt','pt_br',],
'único'=>['es','gl','pt','pt_br',],
'úplne'=>['sk',],
'úplně'=>['cs',],
'úr'=>['hu','is',],
'út'=>['hu','is',],
'úti'=>['is',],
'úton'=>['hu',],
'úžasné'=>['sk',],
'über'=>['de',],
'überall'=>['de',],
'überhaupt'=>['de',],
'üdv'=>['hu',],
'ügy'=>['hu',],
'ühe'=>['et',],
'ühel'=>['et',],
'üht'=>['et',],
'ühte'=>['et',],
'ühtegi'=>['et',],
'üks'=>['et',],
'üksi'=>['et',],
'ükskõik'=>['et',],
'üldse'=>['et',],
'üle'=>['et',],
'ülejäänud'=>['et',],
'üles'=>['et',],
'üleval'=>['et',],
'ülj'=>['hu',],
'ümber'=>['et',],
'ümumi'=>['az',],
'üsna'=>['et',],
'üstünde'=>['tr',],
'üstüne'=>['tr',],
'ütle'=>['et',],
'ütleb'=>['et',],
'ütled'=>['et',],
'ütlema'=>['et',],
'ütlen'=>['et',],
'ütles'=>['et',],
'ütlesid'=>['et',],
'ütlesin'=>['et',],
'üzere'=>['tr',],
'üzerinde'=>['tr',],
'üzerine'=>['tr',],
'üzgünüm'=>['tr',],
'üzv'=>['az',],
'üç'=>['tr',],
'üçün'=>['az',],
'þ'=>['is',],
'þakka'=>['is',],
'þangað'=>['is',],
'þann'=>['is',],
'þannig'=>['is',],
'þar'=>['is',],
'þarf'=>['is',],
'þarfnast'=>['is',],
'þarft'=>['is',],
'þarftu'=>['is',],
'þarna'=>['is',],
'þau'=>['is',],
'það'=>['is',],
'þegar'=>['is',],
'þegiðu'=>['is',],
'þeim'=>['is',],
'þeir'=>['is',],
'þeirra'=>['is',],
'þekki'=>['is',],
'þekkir'=>['is',],
'þennan'=>['is',],
'þess'=>['is',],
'þessa'=>['is',],
'þessar'=>['is',],
'þessari'=>['is',],
'þessi'=>['is',],
'þessir'=>['is',],
'þessu'=>['is',],
'þessum'=>['is',],
'þetta'=>['is',],
'þig'=>['is',],
'þinn'=>['is',],
'þinni'=>['is',],
'þitt'=>['is',],
'þið'=>['is',],
'þremur'=>['is',],
'þrjá'=>['is',],
'þrjár'=>['is',],
'þrjú'=>['is',],
'þrír'=>['is',],
'þurfa'=>['is',],
'þurfti'=>['is',],
'þurfum'=>['is',],
'því'=>['is',],
'þykir'=>['is',],
'þá'=>['is',],
'þátt'=>['is',],
'þær'=>['is',],
'þér'=>['is',],
'þín'=>['is',],
'þína'=>['is',],
'þínar'=>['is',],
'þínir'=>['is',],
'þínu'=>['is',],
'þínum'=>['is',],
'þó'=>['is',],
'þótt'=>['is',],
'þú'=>['is',],
'þúsund'=>['is',],
'þýðir'=>['is',],
'ārā'=>['lv',],
'ātri'=>['lv',],
'ātrāk'=>['lv',],
'ăia'=>['ro',],
'ăla'=>['ro',],
'ăsta'=>['ro',],
'ăştia'=>['ro',],
'ćao'=>['bs',],
'će'=>['bs','hr',],
'ćemo'=>['bs','hr',],
'ćete'=>['bs','hr',],
'ćeš'=>['bs','hr',],
'ću'=>['bs','hr',],
'čak'=>['bs','hr',],
'čaka'=>['sl',],
'čakaj'=>['sl',],
'čakať'=>['sk',],
'čaká'=>['sk',],
'čas'=>['cs','sk','sl',],
'časa'=>['sl',],
'čase'=>['sk',],
'často'=>['cs','sk',],
'času'=>['cs','sk','sl',],
'časť'=>['sk',],
'čau'=>['cs','lv','sk',],
'če'=>['sl',],
'čega'=>['bs','hr',],
'čeho'=>['cs',],
'čekaj'=>['bs','hr',],
'čekat'=>['cs',],
'čeká'=>['cs',],
'čem'=>['cs','sl',],
'čemu'=>['bs','cs','hr',],
'čeprav'=>['sl',],
'čerta'=>['sk',],
'čertu'=>['cs',],
'česa'=>['sl',],
'četiri'=>['hr',],
'četri'=>['lv',],
'čez'=>['sl',],
'či'=>['sk',],
'čia'=>['lt',],
'čim'=>['hr','sl',],
'čini'=>['bs','hr',],
'čionai'=>['lt',],
'čisto'=>['sl',],
'človek'=>['sk','sl',],
'človeka'=>['sk','sl',],
'človeče'=>['sk',],
'člověk'=>['cs',],
'člověka'=>['cs',],
'člověče'=>['cs',],
'čo'=>['sk',],
'čoho'=>['sk',],
'čokoľvek'=>['sk',],
'čom'=>['sk',],
'čoskoro'=>['sk',],
'čovjek'=>['bs','hr',],
'čovjeka'=>['bs','hr',],
'čovječe'=>['bs','hr',],
'čože'=>['sk',],
'čtyři'=>['cs',],
'čudno'=>['hr','sl',],
'čudovito'=>['sl',],
'čujem'=>['hr',],
'čuješ'=>['hr',],
'čula'=>['hr',],
'čuo'=>['bs','hr',],
'čuti'=>['hr',],
'část'=>['cs',],
'čím'=>['cs','sk',],
'číslo'=>['cs','sk',],
'čārlij'=>['lv',],
'ďakujem'=>['sk',],
'ďalej'=>['sk',],
'ďaleko'=>['sk',],
'ďalšie'=>['sk',],
'ďalší'=>['sk',],
'ģimene'=>['lv',],
'ģimenes'=>['lv',],
'īpaši'=>['lv',],
'īstais'=>['lv',],
'īsti'=>['lv',],
'īsts'=>['lv',],
'į'=>['lt',],
'įdomu'=>['lt',],
'įsitikinęs'=>['lt',],
'įvyko'=>['lt',],
'ı'=>['az',],
'ļaudis'=>['lv',],
'ļauj'=>['lv',],
'ļaujiet'=>['lv',],
'ļoti'=>['lv',],
'ľudia'=>['sk',],
'ľudí'=>['sk',],
'ľuďom'=>['sk',],
'ľúto'=>['sk',],
'łatwo'=>['pl',],
'ņem'=>['lv',],
'ňom'=>['sk',],
'ňou'=>['sk',],
'ňu'=>['sk',],
'ő'=>['hu',],
'ők'=>['hu',],
'őket'=>['hu',],
'őrült'=>['hu',],
'őt'=>['hu',],
'řekl'=>['cs',],
'řekla'=>['cs',],
'řekni'=>['cs',],
'řeknu'=>['cs',],
'řekněte'=>['cs',],
'říct'=>['cs',],
'říkají'=>['cs',],
'říkal'=>['cs',],
'říkala'=>['cs',],
'říkat'=>['cs',],
'říká'=>['cs',],
'říkám'=>['cs',],
'říkáš'=>['cs',],
'śmierci'=>['pl',],
'śmierć'=>['pl',],
'środka'=>['pl',],
'środku'=>['pl',],
'świat'=>['pl',],
'świata'=>['pl',],
'świecie'=>['pl',],
'świetnie'=>['pl',],
'şaka'=>['tr',],
'şans'=>['tr',],
'şansă'=>['ro',],
'şarkı'=>['tr',],
'şase'=>['ro',],
'şcoală'=>['ro',],
'şeful'=>['ro',],
'şehir'=>['tr',],
'şekilde'=>['tr',],
'şey'=>['tr',],
'şeyden'=>['tr',],
'şeye'=>['tr',],
'şeyi'=>['tr',],
'şeyin'=>['tr',],
'şeyler'=>['tr',],
'şeyleri'=>['tr',],
'şi'=>['ro',],
'şimdi'=>['tr',],
'şti'=>['ro',],
'ştiam'=>['ro',],
'ştie'=>['ro',],
'ştii'=>['ro',],
'ştim'=>['ro',],
'ştiu'=>['ro',],
'ştiut'=>['ro',],
'ştiţi'=>['ro',],
'şu'=>['tr',],
'şuna'=>['tr',],
'şunu'=>['tr',],
'şöyle'=>['tr',],
'şəkil'=>['az',],
'şənbə'=>['az',],
'šai'=>['lv',],
'šajā'=>['lv',],
'šalia'=>['lt',],
'šanci'=>['cs',],
'šancu'=>['sk',],
'šanse'=>['bs','hr',],
'šaty'=>['cs','sk',],
'šaunu'=>['lt',],
'še'=>['sl',],
'šef'=>['sl',],
'šeima'=>['lt',],
'šeimos'=>['lt',],
'šeit'=>['lv',],
'šejienes'=>['lv',],
'šejieni'=>['lv',],
'šel'=>['cs','sl',],
'šele'=>['sl',],
'šest'=>['cs','hr','sl',],
'šesť'=>['sk',],
'ši'=>['lt',],
'šiaip'=>['lt',],
'šiame'=>['lt',],
'šiandien'=>['lt',],
'šie'=>['lt','lv',],
'šiek'=>['lt',],
'šiel'=>['sk',],
'šiem'=>['lv',],
'šim'=>['lv',],
'šio'=>['lt',],
'šioje'=>['lt',],
'šiol'=>['lt',],
'šios'=>['lt',],
'širdies'=>['lt',],
'širdis'=>['lt',],
'šis'=>['lt','lv',],
'šita'=>['lt',],
'šitaip'=>['lt',],
'šitas'=>['lt',],
'šito'=>['lt',],
'šitą'=>['lt',],
'šiuo'=>['lt',],
'šiuos'=>['lt',],
'šią'=>['lt',],
'šių'=>['lt',],
'škoda'=>['sl',],
'škole'=>['cs','sk',],
'školy'=>['cs','sk',],
'šla'=>['cs','sl',],
'šli'=>['sl',],
'šlo'=>['cs','sl',],
'šo'=>['lv',],
'šobrīd'=>['lv',],
'šodien'=>['lv',],
'šoli'=>['sl',],
'šolo'=>['sl',],
'šonakt'=>['lv',],
'šoreiz'=>['lv',],
'šos'=>['lv',],
'šovakar'=>['lv',],
'špatné'=>['cs',],
'špatný'=>['cs',],
'špatně'=>['cs',],
'šrek'=>['lv',],
'šta'=>['bs','hr','sl','sr',],
'štai'=>['lt',],
'številka'=>['sl',],
'številko'=>['sl',],
'štiri'=>['sl',],
'što'=>['bs','hr','sl',],
'štyri'=>['sk',],
'štěstí'=>['cs',],
'šurp'=>['lv',],
'šéfe'=>['cs',],
'šādi'=>['lv',],
'šī'=>['lv',],
'šīm'=>['lv',],
'šīs'=>['lv',],
'šį'=>['lt',],
'šįvakar'=>['lt',],
'šķiet'=>['lv',],
'šťastia'=>['sk',],
'šťastie'=>['sk',],
'šťastný'=>['sk',],
'šūdas'=>['lt',],
'ţi'=>['ro',],
'ţie'=>['ro',],
'ţii'=>['ro',],
'ţin'=>['ro',],
'ţine'=>['ro',],
'ťa'=>['sk',],
'ťažké'=>['sk',],
'ūdeni'=>['lv',],
'ūdens'=>['lv',],
'źle'=>['pl',],
'żaden'=>['pl',],
'żadnego'=>['pl',],
'żadnej'=>['pl',],
'żadnych'=>['pl',],
'że'=>['pl',],
'żeby'=>['pl',],
'żebym'=>['pl',],
'żebyś'=>['pl',],
'żona'=>['pl',],
'żonę'=>['pl',],
'życia'=>['pl',],
'życie'=>['pl',],
'życiu'=>['pl',],
'żyje'=>['pl',],
'żyć'=>['pl',],
'žaidimas'=>['lt',],
'žaisti'=>['lt',],
'žal'=>['sl',],
'žao'=>['bs','hr',],
'že'=>['cs','sk','sl',],
'žele'=>['bs','hr',],
'želel'=>['sl',],
'želela'=>['sl',],
'želi'=>['bs','hr','sl',],
'želim'=>['bs','hr','sl',],
'želimo'=>['hr',],
'želio'=>['bs','hr',],
'želite'=>['bs','hr','sl',],
'želiš'=>['bs','hr','sl',],
'žemyn'=>['lt',],
'žemės'=>['lt',],
'žena'=>['bs','cs','hr','sk','sl',],
'žene'=>['bs','hr',],
'ženo'=>['sl',],
'ženska'=>['sl',],
'ženske'=>['sl',],
'žensko'=>['sl',],
'ženu'=>['bs','cs','hr','sk',],
'ženy'=>['cs','sk',],
'žes'=>['cs',],
'žiaden'=>['sk',],
'žiadna'=>['sk',],
'žiadne'=>['sk',],
'žiadnu'=>['sk',],
'žiadny'=>['sk',],
'žije'=>['cs','sk',],
'žinai'=>['lt',],
'žinau'=>['lt',],
'žino'=>['lt',],
'žinojau'=>['lt',],
'žinoma'=>['lt',],
'žinot'=>['lt',],
'žinote'=>['lt',],
'žinoti'=>['lt',],
'živ'=>['sl',],
'živeti'=>['sl',],
'živi'=>['bs','hr','sl',],
'živijo'=>['sl',],
'živjeti'=>['hr',],
'živjo'=>['sl',],
'življenja'=>['sl',],
'življenje'=>['sl',],
'življenju'=>['sl',],
'život'=>['bs','cs','hr','sk',],
'života'=>['bs','cs','hr','sk',],
'živote'=>['sk',],
'životu'=>['bs','hr',],
'životě'=>['cs',],
'žiť'=>['sk',],
'žiūri'=>['lt',],
'žiūrėk'=>['lt',],
'žiūrėti'=>['lt',],
'žmogau'=>['lt',],
'žmogaus'=>['lt',],
'žmogus'=>['lt',],
'žmogų'=>['lt',],
'žmona'=>['lt',],
'žmones'=>['lt',],
'žmonių'=>['lt',],
'žmoną'=>['lt',],
'žmonėms'=>['lt',],
'žmonės'=>['lt',],
'žuvo'=>['lt',],
'žádnou'=>['cs',],
'žádná'=>['cs',],
'žádné'=>['cs',],
'žádný'=>['cs',],
'žít'=>['cs',],
'žēl'=>['lv',],
'ən'=>['az',],
'əsas'=>['az',],
'ətraflı'=>['az',],
'άδεια'=>['el',],
'άκου'=>['el',],
'άκουσα'=>['el',],
'άκουσες'=>['el',],
'άκρη'=>['el',],
'άλλα'=>['el',],
'άλλες'=>['el',],
'άλλη'=>['el',],
'άλλο'=>['el',],
'άλλοι'=>['el',],
'άλλον'=>['el',],
'άλλος'=>['el',],
'άλλους'=>['el',],
'άνδρες'=>['el',],
'άνθρωπο'=>['el',],
'άνθρωποι'=>['el',],
'άνθρωπος'=>['el',],
'άντρα'=>['el',],
'άντρας'=>['el',],
'άντρες'=>['el',],
'άρεσε'=>['el',],
'άσε'=>['el',],
'άσχημα'=>['el',],
'άτομο'=>['el',],
'άφησε'=>['el',],
'έγινε'=>['el',],
'έδωσε'=>['el',],
'έι'=>['el',],
'έκανα'=>['el',],
'έκαναν'=>['el',],
'έκανε'=>['el',],
'έκανες'=>['el',],
'έλα'=>['el',],
'έλεγα'=>['el',],
'έλεγε'=>['el',],
'έλεγχο'=>['el',],
'έμαθα'=>['el',],
'ένα'=>['el',],
'έναν'=>['el',],
'ένας'=>['el',],
'έξι'=>['el',],
'έξω'=>['el',],
'έπεσε'=>['el',],
'έπρεπε'=>['el',],
'έρθει'=>['el',],
'έρθεις'=>['el',],
'έρθω'=>['el',],
'έρχεται'=>['el',],
'έρχομαι'=>['el',],
'έρχονται'=>['el',],
'έτοιμη'=>['el',],
'έτοιμοι'=>['el',],
'έτοιμος'=>['el',],
'έτσι'=>['el',],
'έφυγε'=>['el',],
'έχασα'=>['el',],
'έχει'=>['el',],
'έχεις'=>['el',],
'έχετε'=>['el',],
'έχουμε'=>['el',],
'έχουν'=>['el',],
'έχω'=>['el',],
'ή'=>['el',],
'ήδη'=>['el',],
'ήθελα'=>['el',],
'ήθελε'=>['el',],
'ήθελες'=>['el',],
'ήμασταν'=>['el',],
'ήμουν'=>['el',],
'ήξερα'=>['el',],
'ήξερε'=>['el',],
'ήξερες'=>['el',],
'ήρθα'=>['el',],
'ήρθατε'=>['el',],
'ήρθε'=>['el',],
'ήρθες'=>['el',],
'ήσουν'=>['el',],
'ήταν'=>['el',],
'ίδια'=>['el',],
'ίδιο'=>['el',],
'ίδιος'=>['el',],
'ίσως'=>['el',],
'α'=>['el',],
'αέρα'=>['el',],
'αίμα'=>['el',],
'αγάπη'=>['el',],
'αγαπάς'=>['el',],
'αγαπώ'=>['el',],
'αγόρι'=>['el',],
'αδελφή'=>['el',],
'αδερφή'=>['el',],
'αδερφός'=>['el',],
'αεροπλάνο'=>['el',],
'ακούγεται'=>['el',],
'ακούς'=>['el',],
'ακούσει'=>['el',],
'ακούστε'=>['el',],
'ακούω'=>['el',],
'ακριβώς'=>['el',],
'ακόμα'=>['el',],
'ακόμη'=>['el',],
'αλήθεια'=>['el',],
'αλλά'=>['el',],
'αλλάξει'=>['el',],
'αλλα'=>['el',],
'αλλιώς'=>['el',],
'αμάξι'=>['el',],
'αμέσως'=>['el',],
'αμερική'=>['el',],
'αν'=>['el',],
'ανάγκη'=>['el',],
'ανάμεσα'=>['el',],
'ανησυχείς'=>['el',],
'ανθρώπους'=>['el',],
'αντίο'=>['el',],
'αξίζει'=>['el',],
'απ'=>['el',],
'απλά'=>['el',],
'απλώς'=>['el',],
'απο'=>['el',],
'αποστολή'=>['el',],
'από'=>['el',],
'απόψε'=>['el',],
'αρέσει'=>['el',],
'αρέσουν'=>['el',],
'αργά'=>['el',],
'αργότερα'=>['el',],
'αριστερά'=>['el',],
'αρκετά'=>['el',],
'αρχή'=>['el',],
'ας'=>['el',],
'αστείο'=>['el',],
'αστυνομία'=>['el',],
'ασφάλεια'=>['el',],
'ατύχημα'=>['el',],
'αυτά'=>['el',],
'αυτές'=>['el',],
'αυτή'=>['el',],
'αυτήν'=>['el',],
'αυτη'=>['el',],
'αυτο'=>['el',],
'αυτοί'=>['el',],
'αυτοκίνητο'=>['el',],
'αυτού'=>['el',],
'αυτούς'=>['el',],
'αυτό'=>['el',],
'αυτόν'=>['el',],
'αυτός'=>['el',],
'αφήσεις'=>['el',],
'αφήστε'=>['el',],
'αφήσω'=>['el',],
'αφεντικό'=>['el',],
'αφού'=>['el',],
'αύριο'=>['el',],
'βάλε'=>['el',],
'βάλω'=>['el',],
'βέβαια'=>['el',],
'βασικά'=>['el',],
'βασιλιάς'=>['el',],
'βγάλω'=>['el',],
'βγει'=>['el',],
'βγες'=>['el',],
'βδομάδα'=>['el',],
'βιβλίο'=>['el',],
'βλέπεις'=>['el',],
'βλέπετε'=>['el',],
'βλέπω'=>['el',],
'βοήθεια'=>['el',],
'βοηθήσει'=>['el',],
'βοηθήσεις'=>['el',],
'βοηθήσω'=>['el',],
'βράδυ'=>['el',],
'βρήκα'=>['el',],
'βρήκαμε'=>['el',],
'βρήκε'=>['el',],
'βρήκες'=>['el',],
'βρίσκεται'=>['el',],
'βρει'=>['el',],
'βρεις'=>['el',],
'βρες'=>['el',],
'βρούμε'=>['el',],
'βρω'=>['el',],
'γάμο'=>['el',],
'γίνει'=>['el',],
'γίνεις'=>['el',],
'γίνεται'=>['el',],
'γίνω'=>['el',],
'γαμώτο'=>['el',],
'γειά'=>['el',],
'γεια'=>['el',],
'γη'=>['el',],
'γι'=>['el',],
'για'=>['el',],
'γιαγιά'=>['el',],
'γιατί'=>['el',],
'γιατι'=>['el',],
'γιατρέ'=>['el',],
'γιατρός'=>['el',],
'γιο'=>['el',],
'γιος'=>['el',],
'γλυκιά'=>['el',],
'γνωρίζω'=>['el',],
'γνώμη'=>['el',],
'γονείς'=>['el',],
'γράμμα'=>['el',],
'γρήγορα'=>['el',],
'γραμμή'=>['el',],
'γραφείο'=>['el',],
'γυναίκα'=>['el',],
'γυναίκες'=>['el',],
'γυρίσω'=>['el',],
'γύρνα'=>['el',],
'γύρω'=>['el',],
'δέκα'=>['el',],
'δίκιο'=>['el',],
'δίνει'=>['el',],
'δίνω'=>['el',],
'δίπλα'=>['el',],
'δε'=>['el',],
'δεv'=>['el',],
'δείξω'=>['el',],
'δείπνο'=>['el',],
'δείτε'=>['el',],
'δείχνει'=>['el',],
'δει'=>['el',],
'δεις'=>['el',],
'δεν'=>['el',],
'δεξιά'=>['el',],
'δες'=>['el',],
'δεσποινίς'=>['el',],
'δηλαδή'=>['el',],
'διάολο'=>['el',],
'δικά'=>['el',],
'δική'=>['el',],
'δικό'=>['el',],
'δικός'=>['el',],
'δις'=>['el',],
'δολάρια'=>['el',],
'δουλειά'=>['el',],
'δουλειές'=>['el',],
'δουλεύει'=>['el',],
'δουλεύεις'=>['el',],
'δουλεύω'=>['el',],
'δούμε'=>['el',],
'δρ'=>['el',],
'δρόμο'=>['el',],
'δυνατά'=>['el',],
'δυο'=>['el',],
'δω'=>['el',],
'δωμάτιο'=>['el',],
'δύναμη'=>['el',],
'δύο'=>['el',],
'δύσκολο'=>['el',],
'δώρο'=>['el',],
'δώσε'=>['el',],
'δώσει'=>['el',],
'δώσεις'=>['el',],
'δώσω'=>['el',],
'ε'=>['el',],
'εάν'=>['el',],
'είvαι'=>['el',],
'είδα'=>['el',],
'είδε'=>['el',],
'είδες'=>['el',],
'είδους'=>['el',],
'είμαι'=>['el',],
'είμαστε'=>['el',],
'είναι'=>['el',],
'είπα'=>['el',],
'είπαν'=>['el',],
'είπε'=>['el',],
'είπες'=>['el',],
'είσαι'=>['el',],
'είστε'=>['el',],
'είχα'=>['el',],
'είχαμε'=>['el',],
'είχαν'=>['el',],
'είχε'=>['el',],
'είχες'=>['el',],
'εαυτό'=>['el',],
'εβδομάδα'=>['el',],
'εγω'=>['el',],
'εγώ'=>['el',],
'εδω'=>['el',],
'εδώ'=>['el',],
'ει'=>['el',],
'ειμαι'=>['el',],
'ειναι'=>['el',],
'εισαι'=>['el',],
'εκ'=>['el',],
'εκατομμύρια'=>['el',],
'εκεί'=>['el',],
'εκείνη'=>['el',],
'εκείνο'=>['el',],
'εκείνος'=>['el',],
'εκει'=>['el',],
'εκτός'=>['el',],
'ελάτε'=>['el',],
'ελα'=>['el',],
'ελπίζω'=>['el',],
'εμάς'=>['el',],
'εμένα'=>['el',],
'εμείς'=>['el',],
'εμπρός'=>['el',],
'εν'=>['el',],
'ενα'=>['el',],
'εναντίον'=>['el',],
'ενας'=>['el',],
'ενδιαφέρον'=>['el',],
'εννοείς'=>['el',],
'εννοώ'=>['el',],
'εντάξει'=>['el',],
'ενταξει'=>['el',],
'εντελώς'=>['el',],
'ενός'=>['el',],
'ενώ'=>['el',],
'επάνω'=>['el',],
'επίσης'=>['el',],
'επειδή'=>['el',],
'επιλογή'=>['el',],
'επιτέλους'=>['el',],
'επόμενη'=>['el',],
'ερωτήσεις'=>['el',],
'ερώτηση'=>['el',],
'εσάς'=>['el',],
'εσένα'=>['el',],
'εσείς'=>['el',],
'εσυ'=>['el',],
'εσύ'=>['el',],
'ετσι'=>['el',],
'ευκαιρία'=>['el',],
'ευχαριστούμε'=>['el',],
'ευχαριστώ'=>['el',],
'εχει'=>['el',],
'εχεις'=>['el',],
'εχουμε'=>['el',],
'εχω'=>['el',],
'εύκολο'=>['el',],
'ζει'=>['el',],
'ζωή'=>['el',],
'ζωής'=>['el',],
'ζωντανός'=>['el',],
'η'=>['el',],
'ημέρα'=>['el',],
'ηρέμησε'=>['el',],
'ησυχία'=>['el',],
'ηταν'=>['el',],
'θάλασσα'=>['el',],
'θάνατο'=>['el',],
'θέλει'=>['el',],
'θέλεις'=>['el',],
'θέλετε'=>['el',],
'θέλουμε'=>['el',],
'θέλουν'=>['el',],
'θέλω'=>['el',],
'θέμα'=>['el',],
'θέση'=>['el',],
'θα'=>['el',],
'θεέ'=>['el',],
'θελω'=>['el',],
'θεού'=>['el',],
'θες'=>['el',],
'θεό'=>['el',],
'θεός'=>['el',],
'θυμάμαι'=>['el',],
'θυμάσαι'=>['el',],
'ιδέα'=>['el',],
'ιστορία'=>['el',],
'ισως'=>['el',],
'κ'=>['el',],
'κάθαρμα'=>['el',],
'κάθε'=>['el',],
'κάναμε'=>['el',],
'κάνε'=>['el',],
'κάνει'=>['el',],
'κάνεις'=>['el',],
'κάνετε'=>['el',],
'κάνουμε'=>['el',],
'κάνουν'=>['el',],
'κάντε'=>['el',],
'κάνω'=>['el',],
'κάποια'=>['el',],
'κάποιες'=>['el',],
'κάποιο'=>['el',],
'κάποιοι'=>['el',],
'κάποιον'=>['el',],
'κάποιος'=>['el',],
'κάποτε'=>['el',],
'κάπου'=>['el',],
'κάπως'=>['el',],
'κάτι'=>['el',],
'κάτσε'=>['el',],
'κάτω'=>['el',],
'κέντρο'=>['el',],
'κα'=>['el',],
'καθόλου'=>['el',],
'καθώς'=>['el',],
'και'=>['el',],
'καιρό'=>['el',],
'καιρός'=>['el',],
'κακό'=>['el',],
'καλά'=>['el',],
'καλή'=>['el',],
'καλα'=>['el',],
'καλημέρα'=>['el',],
'καληνύχτα'=>['el',],
'καλησπέρα'=>['el',],
'καλό'=>['el',],
'καλός'=>['el',],
'καλύτερα'=>['el',],
'καλύτερη'=>['el',],
'καλύτερο'=>['el',],
'καλύτερος'=>['el',],
'καλώς'=>['el',],
'καμία'=>['el',],
'καμιά'=>['el',],
'καν'=>['el',],
'κανένα'=>['el',],
'κανέναν'=>['el',],
'κανένας'=>['el',],
'κανείς'=>['el',],
'κανεις'=>['el',],
'καρδιά'=>['el',],
'κατά'=>['el',],
'κατάλαβα'=>['el',],
'κατάλαβες'=>['el',],
'κατάσταση'=>['el',],
'καταλαβαίνεις'=>['el',],
'καταλαβαίνω'=>['el',],
'κατι'=>['el',],
'καφέ'=>['el',],
'κε'=>['el',],
'κεφάλι'=>['el',],
'κι'=>['el',],
'κλειδί'=>['el',],
'κοίτα'=>['el',],
'κοιτάξτε'=>['el',],
'κοιτάς'=>['el',],
'κομμάτι'=>['el',],
'κοντά'=>['el',],
'κοπέλα'=>['el',],
'κορίτσι'=>['el',],
'κορίτσια'=>['el',],
'κου'=>['el',],
'κράτα'=>['el',],
'κρίμα'=>['el',],
'κρεβάτι'=>['el',],
'κυρία'=>['el',],
'κυρίες'=>['el',],
'κυριε'=>['el',],
'κόρη'=>['el',],
'κόσμο'=>['el',],
'κόσμος'=>['el',],
'κόσμου'=>['el',],
'κύριε'=>['el',],
'κύριο'=>['el',],
'κύριοι'=>['el',],
'κύριος'=>['el',],
'κώλο'=>['el',],
'λάθος'=>['el',],
'λέγεται'=>['el',],
'λέει'=>['el',],
'λέμε'=>['el',],
'λένε'=>['el',],
'λέξη'=>['el',],
'λέτε'=>['el',],
'λέω'=>['el',],
'λίγα'=>['el',],
'λίγη'=>['el',],
'λίγο'=>['el',],
'λείπει'=>['el',],
'λεπτά'=>['el',],
'λεπτό'=>['el',],
'λες'=>['el',],
'λεφτά'=>['el',],
'λοιπόν'=>['el',],
'λυπάμαι'=>['el',],
'λόγια'=>['el',],
'λόγο'=>['el',],
'λόγος'=>['el',],
'μ'=>['el',],
'μoυ'=>['el',],
'μάθει'=>['el',],
'μάθεις'=>['el',],
'μάθω'=>['el',],
'μάικλ'=>['el',],
'μάλιστα'=>['el',],
'μάλλον'=>['el',],
'μάνα'=>['el',],
'μάτια'=>['el',],
'μάχη'=>['el',],
'μέλλον'=>['el',],
'μένα'=>['el',],
'μένει'=>['el',],
'μέρα'=>['el',],
'μέρες'=>['el',],
'μέρος'=>['el',],
'μέσα'=>['el',],
'μέση'=>['el',],
'μέτρα'=>['el',],
'μέχρι'=>['el',],
'μήνα'=>['el',],
'μήνες'=>['el',],
'μήνυμα'=>['el',],
'μήπως'=>['el',],
'μία'=>['el',],
'μα'=>['el',],
'μαγαζί'=>['el',],
'μαζί'=>['el',],
'μαζι'=>['el',],
'μακάρι'=>['el',],
'μακριά'=>['el',],
'μαλάκα'=>['el',],
'μαλακίες'=>['el',],
'μαλλιά'=>['el',],
'μαμά'=>['el',],
'μας'=>['el',],
'ματιά'=>['el',],
'με'=>['el',],
'μείνε'=>['el',],
'μείνει'=>['el',],
'μείνεις'=>['el',],
'μείνετε'=>['el',],
'μείνω'=>['el',],
'μεγάλη'=>['el',],
'μεγάλο'=>['el',],
'μεγάλος'=>['el',],
'μερικά'=>['el',],
'μερικές'=>['el',],
'μετά'=>['el',],
'μεταξύ'=>['el',],
'μη'=>['el',],
'μην'=>['el',],
'μητέρα'=>['el',],
'μηχανή'=>['el',],
'μια'=>['el',],
'μιας'=>['el',],
'μικρέ'=>['el',],
'μικρή'=>['el',],
'μικρό'=>['el',],
'μικρός'=>['el',],
'μιλάει'=>['el',],
'μιλάμε'=>['el',],
'μιλάς'=>['el',],
'μιλάω'=>['el',],
'μιλήσει'=>['el',],
'μιλήσεις'=>['el',],
'μιλήσουμε'=>['el',],
'μιλήσω'=>['el',],
'μισό'=>['el',],
'μισώ'=>['el',],
'μοιάζει'=>['el',],
'μονο'=>['el',],
'μου'=>['el',],
'μουσική'=>['el',],
'μπάνιο'=>['el',],
'μπαμπά'=>['el',],
'μπαμπάς'=>['el',],
'μπες'=>['el',],
'μπορεί'=>['el',],
'μπορείς'=>['el',],
'μπορείτε'=>['el',],
'μπορούμε'=>['el',],
'μπορούν'=>['el',],
'μπορούσα'=>['el',],
'μπορούσαμε'=>['el',],
'μπορούσε'=>['el',],
'μπορούσες'=>['el',],
'μπορώ'=>['el',],
'μπράβο'=>['el',],
'μπροστά'=>['el',],
'μυαλό'=>['el',],
'μυστικό'=>['el',],
'μωρό'=>['el',],
'μόλις'=>['el',],
'μόνη'=>['el',],
'μόνο'=>['el',],
'μόνος'=>['el',],
'ν'=>['el',],
'νέα'=>['el',],
'νέο'=>['el',],
'να'=>['el',],
'ναί'=>['el',],
'ναι'=>['el',],
'νεκρός'=>['el',],
'νερό'=>['el',],
'νιώθεις'=>['el',],
'νιώθω'=>['el',],
'νοιάζει'=>['el',],
'νομίζεις'=>['el',],
'νομίζω'=>['el',],
'νοσοκομείο'=>['el',],
'νούμερο'=>['el',],
'ντε'=>['el',],
'νωρίς'=>['el',],
'νόημα'=>['el',],
'νόμιζα'=>['el',],
'νύχτα'=>['el',],
'ξέρει'=>['el',],
'ξέρεις'=>['el',],
'ξέρετε'=>['el',],
'ξέρουμε'=>['el',],
'ξέρουν'=>['el',],
'ξέρω'=>['el',],
'ξέχνα'=>['el',],
'ξανά'=>['el',],
'ξαφνικά'=>['el',],
'ξενοδοχείο'=>['el',],
'ξερεις'=>['el',],
'ξερω'=>['el',],
'ο'=>['el',],
'οι'=>['el',],
'οικογένειά'=>['el',],
'οικογένεια'=>['el',],
'οκ'=>['el',],
'ολα'=>['el',],
'ολοι'=>['el',],
'ομάδα'=>['el',],
'οποία'=>['el',],
'οποίο'=>['el',],
'οπως'=>['el',],
'οπότε'=>['el',],
'ορίστε'=>['el',],
'ορκίζομαι'=>['el',],
'οταν'=>['el',],
'οτι'=>['el',],
'οτιδήποτε'=>['el',],
'οχι'=>['el',],
'ούτε'=>['el',],
'π'=>['el',],
'πάει'=>['el',],
'πάλι'=>['el',],
'πάμε'=>['el',],
'πάνε'=>['el',],
'πάντα'=>['el',],
'πάντως'=>['el',],
'πάνω'=>['el',],
'πάρα'=>['el',],
'πάρε'=>['el',],
'πάρει'=>['el',],
'πάρεις'=>['el',],
'πάρουμε'=>['el',],
'πάρτε'=>['el',],
'πάρτι'=>['el',],
'πάρω'=>['el',],
'πάτε'=>['el',],
'πάω'=>['el',],
'πέθανε'=>['el',],
'πέντε'=>['el',],
'πέρα'=>['el',],
'πέρασε'=>['el',],
'πήγα'=>['el',],
'πήγαινε'=>['el',],
'πήγε'=>['el',],
'πήρα'=>['el',],
'πήρε'=>['el',],
'πήρες'=>['el',],
'πίσω'=>['el',],
'παίζει'=>['el',],
'παίζεις'=>['el',],
'παίρνει'=>['el',],
'παίρνεις'=>['el',],
'παίρνω'=>['el',],
'παιδί'=>['el',],
'παιδιά'=>['el',],
'παιχνίδι'=>['el',],
'παλιά'=>['el',],
'παλιό'=>['el',],
'παντού'=>['el',],
'παρά'=>['el',],
'παράξενο'=>['el',],
'παρέα'=>['el',],
'παρακαλώ'=>['el',],
'παραπάνω'=>['el',],
'πας'=>['el',],
'πατέρα'=>['el',],
'πατέρας'=>['el',],
'πείτε'=>['el',],
'πεθάνει'=>['el',],
'πεθάνεις'=>['el',],
'πεθάνω'=>['el',],
'πει'=>['el',],
'πειράζει'=>['el',],
'πεις'=>['el',],
'περάσει'=>['el',],
'περίεργο'=>['el',],
'περίμενα'=>['el',],
'περίμενε'=>['el',],
'περίπου'=>['el',],
'περίπτωση'=>['el',],
'περιμένει'=>['el',],
'περιμένεις'=>['el',],
'περιμένετε'=>['el',],
'περιμένουμε'=>['el',],
'περιμένω'=>['el',],
'περιοχή'=>['el',],
'περισσότερα'=>['el',],
'περισσότερο'=>['el',],
'πες'=>['el',],
'πηγαίνετε'=>['el',],
'πια'=>['el',],
'πιο'=>['el',],
'πιστεύεις'=>['el',],
'πιστεύω'=>['el',],
'πλάκα'=>['el',],
'πλέον'=>['el',],
'πλευρά'=>['el',],
'πληροφορίες'=>['el',],
'πλοίο'=>['el',],
'ποια'=>['el',],
'ποιο'=>['el',],
'ποιον'=>['el',],
'ποιος'=>['el',],
'ποιό'=>['el',],
'ποιός'=>['el',],
'πολλά'=>['el',],
'πολλές'=>['el',],
'πολλοί'=>['el',],
'πολυ'=>['el',],
'πολύ'=>['el',],
'ποτέ'=>['el',],
'ποτε'=>['el',],
'ποτό'=>['el',],
'που'=>['el',],
'πουθενά'=>['el',],
'πού'=>['el',],
'πούμε'=>['el',],
'πράγμα'=>['el',],
'πράγματα'=>['el',],
'πρέπει'=>['el',],
'πραγματικά'=>['el',],
'πραγματικότητα'=>['el',],
'πρεπει'=>['el',],
'πριν'=>['el',],
'προβλήματα'=>['el',],
'προς'=>['el',],
'προσέχεις'=>['el',],
'προσοχή'=>['el',],
'προσπάθησε'=>['el',],
'προσπαθώ'=>['el',],
'προφανώς'=>['el',],
'πρωί'=>['el',],
'πρόβλημα'=>['el',],
'πρόκειται'=>['el',],
'πρόσεχε'=>['el',],
'πρόσωπο'=>['el',],
'πρώτα'=>['el',],
'πρώτη'=>['el',],
'πρώτο'=>['el',],
'πρώτος'=>['el',],
'πτώμα'=>['el',],
'πω'=>['el',],
'πως'=>['el',],
'πόδι'=>['el',],
'πόδια'=>['el',],
'πόλεμο'=>['el',],
'πόλη'=>['el',],
'πόρτα'=>['el',],
'πόσα'=>['el',],
'πόσο'=>['el',],
'πότε'=>['el',],
'πώς'=>['el',],
'ραντεβού'=>['el',],
'ρε'=>['el',],
'ρούχα'=>['el',],
'ρωτήσω'=>['el',],
'σ'=>['el',],
'σoυ'=>['el',],
'σάρα'=>['el',],
'σένα'=>['el',],
'σήκω'=>['el',],
'σήμερα'=>['el',],
'σίγουρα'=>['el',],
'σίγουρη'=>['el',],
'σίγουρος'=>['el',],
'σα'=>['el',],
'σαμ'=>['el',],
'σαν'=>['el',],
'σας'=>['el',],
'σε'=>['el',],
'σειρά'=>['el',],
'σεξ'=>['el',],
'σημαίνει'=>['el',],
'σημαντικό'=>['el',],
'σημασία'=>['el',],
'σημείο'=>['el',],
'σιγά'=>['el',],
'σκάσε'=>['el',],
'σκάφος'=>['el',],
'σκέφτεσαι'=>['el',],
'σκέφτηκα'=>['el',],
'σκέφτομαι'=>['el',],
'σκέψου'=>['el',],
'σκατά'=>['el',],
'σκεφτόμουν'=>['el',],
'σκοτώσει'=>['el',],
'σκοτώσεις'=>['el',],
'σκοτώσω'=>['el',],
'σκότωσε'=>['el',],
'σοβαρά'=>['el',],
'σου'=>['el',],
'σπίτι'=>['el',],
'στα'=>['el',],
'σταμάτα'=>['el',],
'σταματήστε'=>['el',],
'στη'=>['el',],
'στην'=>['el',],
'στιγμή'=>['el',],
'στις'=>['el',],
'στο'=>['el',],
'στοιχεία'=>['el',],
'στον'=>['el',],
'στους'=>['el',],
'στόμα'=>['el',],
'συγγνώμη'=>['el',],
'συγνώμη'=>['el',],
'συγχαρητήρια'=>['el',],
'συγχωρείς'=>['el',],
'συγχωρείτε'=>['el',],
'συμβαίνει'=>['el',],
'συμβεί'=>['el',],
'συμφωνία'=>['el',],
'συνέβη'=>['el',],
'συνέχεια'=>['el',],
'συνέχισε'=>['el',],
'συνήθως'=>['el',],
'συχνά'=>['el',],
'σχέδιο'=>['el',],
'σχέση'=>['el',],
'σχεδόν'=>['el',],
'σχετικά'=>['el',],
'σχολείο'=>['el',],
'σωστά'=>['el',],
'σωστό'=>['el',],
'σύντομα'=>['el',],
'σύστημα'=>['el',],
'σώμα'=>['el',],
'τ'=>['el',],
'τo'=>['el',],
'τέλεια'=>['el',],
'τέλειο'=>['el',],
'τέλος'=>['el',],
'τέσσερα'=>['el',],
'τέτοια'=>['el',],
'τέτοιο'=>['el',],
'τί'=>['el',],
'τίποτα'=>['el',],
'τίποτε'=>['el',],
'τα'=>['el',],
'ταινία'=>['el',],
'ταξίδι'=>['el',],
'τελείως'=>['el',],
'τελείωσε'=>['el',],
'τελειώσει'=>['el',],
'τελευταία'=>['el',],
'τελευταίο'=>['el',],
'τελικά'=>['el',],
'τζακ'=>['el',],
'τζο'=>['el',],
'τζον'=>['el',],
'τη'=>['el',],
'τηλέφωνο'=>['el',],
'τηλεόραση'=>['el',],
'την'=>['el',],
'της'=>['el',],
'τι'=>['el',],
'τιμή'=>['el',],
'τις'=>['el',],
'τμήμα'=>['el',],
'το'=>['el',],
'τομ'=>['el',],
'τον'=>['el',],
'του'=>['el',],
'τουλάχιστον'=>['el',],
'τους'=>['el',],
'τού'=>['el',],
'τρέχει'=>['el',],
'τρία'=>['el',],
'τραγούδι'=>['el',],
'τραπέζι'=>['el',],
'τρεις'=>['el',],
'τρελός'=>['el',],
'τρόπο'=>['el',],
'τρόπος'=>['el',],
'τσάρλι'=>['el',],
'των'=>['el',],
'τωρα'=>['el',],
'τόσα'=>['el',],
'τόσο'=>['el',],
'τότε'=>['el',],
'τύπο'=>['el',],
'τύπος'=>['el',],
'τύχη'=>['el',],
'τώρα'=>['el',],
'υπάρχει'=>['el',],
'υπάρχουν'=>['el',],
'υπέροχα'=>['el',],
'υπέροχη'=>['el',],
'υπέροχο'=>['el',],
'υπήρχε'=>['el',],
'υποθέτω'=>['el',],
'υποτίθεται'=>['el',],
'υπό'=>['el',],
'υπόθεση'=>['el',],
'υπόσχομαι'=>['el',],
'υόρκη'=>['el',],
'φέρε'=>['el',],
'φέρω'=>['el',],
'φίλε'=>['el',],
'φίλη'=>['el',],
'φίλο'=>['el',],
'φίλοι'=>['el',],
'φίλος'=>['el',],
'φίλους'=>['el',],
'φαίνεσαι'=>['el',],
'φαίνεται'=>['el',],
'φαγητό'=>['el',],
'φεύγω'=>['el',],
'φοβάμαι'=>['el',],
'φοβάσαι'=>['el',],
'φορά'=>['el',],
'φορές'=>['el',],
'φρανκ'=>['el',],
'φτάνει'=>['el',],
'φυλακή'=>['el',],
'φυσικά'=>['el',],
'φωνή'=>['el',],
'φως'=>['el',],
'φωτιά'=>['el',],
'φωτογραφία'=>['el',],
'φωτογραφίες'=>['el',],
'φύγε'=>['el',],
'φύγει'=>['el',],
'φύγεις'=>['el',],
'φύγετε'=>['el',],
'φύγουμε'=>['el',],
'φύγω'=>['el',],
'χάλια'=>['el',],
'χάρη'=>['el',],
'χάρηκα'=>['el',],
'χέρι'=>['el',],
'χέρια'=>['el',],
'χαίρομαι'=>['el',],
'χαρά'=>['el',],
'χθες'=>['el',],
'χιλιάδες'=>['el',],
'χρήματα'=>['el',],
'χρειάζεσαι'=>['el',],
'χρειάζεται'=>['el',],
'χρειάζομαι'=>['el',],
'χρειαζόμαστε'=>['el',],
'χριστέ'=>['el',],
'χριστούγεννα'=>['el',],
'χρονών'=>['el',],
'χρόνια'=>['el',],
'χρόνο'=>['el',],
'χρόνος'=>['el',],
'χωρίς'=>['el',],
'χώρα'=>['el',],
'ψέματα'=>['el',],
'ψηλά'=>['el',],
'ψυχή'=>['el',],
'ω'=>['el',],
'ωραία'=>['el',],
'ωραίο'=>['el',],
'ως'=>['el',],
'ό'=>['el',],
'όλα'=>['el',],
'όλες'=>['el',],
'όλη'=>['el',],
'όλο'=>['el',],
'όλοι'=>['el',],
'όλους'=>['el',],
'όμορφη'=>['el',],
'όμορφο'=>['el',],
'όμως'=>['el',],
'όνειρο'=>['el',],
'όνομά'=>['el',],
'όνομα'=>['el',],
'όπλα'=>['el',],
'όπλο'=>['el',],
'όπου'=>['el',],
'όπως'=>['el',],
'όσα'=>['el',],
'όσο'=>['el',],
'όταν'=>['el',],
'ότι'=>['el',],
'όχι'=>['el',],
'ύπνο'=>['el',],
'ώρα'=>['el',],
'ώρες'=>['el',],
'ώστε'=>['el',],
'а'=>['be','bg','ko','mk','ru',],
'аб'=>['be',],
'абсолютно'=>['bg','ru',],
'абяцаў'=>['be',],
'авион'=>['mk',],
'ага'=>['ru',],
'агент'=>['be','kk','mk',],
'агентам'=>['be',],
'агентті'=>['kk',],
'агенттің'=>['kk',],
'агенті'=>['kk',],
'агентін'=>['kk',],
'агентінің'=>['kk',],
'агентіңіздің'=>['kk',],
'ад'=>['be','kk',],
'адам'=>['kk',],
'адамда'=>['kk',],
'адамдар'=>['kk',],
'адамдарды'=>['kk',],
'адамдарым'=>['kk',],
'адамдарға'=>['kk',],
'адамның'=>['kk',],
'адамға'=>['kk',],
'адаслалі'=>['be',],
'адвокат'=>['mk',],
'аддам'=>['be',],
'адзін'=>['be',],
'адзінае'=>['be',],
'адзіныя'=>['be',],
'адказнасць'=>['be',],
'адказныя'=>['be',],
'адкуль'=>['be',],
'адмова'=>['be',],
'аднаўленне'=>['be',],
'адну'=>['be',],
'адпаведныя'=>['be',],
'адпраў'=>['be',],
'адразу'=>['be',],
'адрымаў'=>['be',],
'адсюль'=>['be',],
'адчасу'=>['be',],
'ажыць'=>['be',],
'аз'=>['bg','kk',],
'азабын'=>['kk',],
'ай'=>['kk',],
'аймағы'=>['kk',],
'айналып'=>['kk',],
'айналыспаймын'=>['kk',],
'айналысқанмын'=>['kk',],
'айнер'=>['kk',],
'айс'=>['be',],
'айт'=>['kk',],
'айта'=>['kk',],
'айтады'=>['kk',],
'айтамыз'=>['kk',],
'айтамын'=>['kk',],
'айтарым'=>['kk',],
'айтасыз'=>['kk',],
'айтпа'=>['kk',],
'айтпадың'=>['kk',],
'айтпаймын'=>['kk',],
'айтпайсың'=>['kk',],
'айтты'=>['kk',],
'айттың'=>['kk',],
'айттыңыз'=>['kk',],
'айтшы'=>['kk',],
'айтып'=>['kk',],
'айтыңыз'=>['kk',],
'айтқаны'=>['kk',],
'айтқанымды'=>['kk',],
'ако'=>['bg','mk',],
'актывацыя'=>['be',],
'акіяма'=>['be',],
'ал'=>['kk',],
'ала'=>['kk',],
'аламыз'=>['kk',],
'аламын'=>['kk',],
'аласыз'=>['kk',],
'алатын'=>['kk',],
'алатыныңды'=>['kk',],
'алаңдата'=>['kk',],
'алдап'=>['kk',],
'алдақашан'=>['kk',],
'алдында'=>['kk',],
'алдық'=>['kk',],
'алдыңыз'=>['kk',],
'але'=>['be',],
'алекс'=>['mk',],
'али'=>['sr',],
'алло'=>['ru',],
'алмадым'=>['kk',],
'алмай'=>['kk',],
'алмаймыз'=>['kk',],
'алмаймын'=>['kk',],
'алмайсың'=>['kk',],
'алмасам'=>['kk',],
'алмасуы'=>['kk',],
'ало'=>['bg','mk',],
'алты'=>['kk',],
'алу'=>['kk',],
'алып'=>['kk',],
'алыс'=>['kk',],
'алыған'=>['kk',],
'альянс'=>['be',],
'ама'=>['bg','mk',],
'амаль'=>['be',],
'аман'=>['kk',],
'америка'=>['bg','mk',],
'ами'=>['bg',],
'анализ'=>['kk',],
'ангельскаю'=>['be',],
'анчоўсамі'=>['be',],
'анық'=>['kk',],
'ані'=>['be',],
'анічога'=>['be',],
'апасын'=>['kk',],
'апгрэйд'=>['be',],
'аперацыі'=>['be',],
'апошні'=>['be',],
'арада'=>['kk',],
'араласпай'=>['kk',],
'арасынада'=>['kk',],
'арнайы'=>['kk',],
'арналған'=>['kk',],
'артымда'=>['kk',],
'артқа'=>['kk',],
'арыгінал'=>['be',],
'арылу'=>['kk',],
'арэнберг'=>['be',],
'арқасында'=>['kk',],
'астатнія'=>['be',],
'асықпаңдар'=>['kk',],
'атаққа'=>['kk',],
'атрады'=>['be',],
'атрымаеце'=>['be',],
'атрымаеш'=>['be',],
'атрымалася'=>['be',],
'атрымальнікам'=>['be',],
'атрымалі'=>['be',],
'атрымаць'=>['be',],
'атрымаю'=>['be',],
'атрымаў'=>['be',],
'атқарады'=>['kk',],
'ауру'=>['kk',],
'ауруды'=>['kk',],
'аурумен'=>['kk',],
'ауруханасы'=>['kk',],
'ауруы'=>['kk',],
'ауруымен'=>['kk',],
'ауруына'=>['kk',],
'ауруының'=>['kk',],
'ауф'=>['kk',],
'ауырады'=>['kk',],
'ауырып'=>['kk',],
'ауыстыруға'=>['kk',],
'ах'=>['ko','mk','ru',],
'ахова'=>['be',],
'ахоўваюць'=>['be',],
'ацепромазин'=>['kk',],
'аян'=>['kk',],
'ајде'=>['mk',],
'ағылшынша'=>['kk',],
'ақ'=>['kk',],
'ақпарат'=>['kk',],
'ақылдастым'=>['kk',],
'б'=>['be','ru',],
'ба'=>['kk',],
'баба'=>['bg',],
'бадди'=>['kk',],
'базу'=>['be',],
'байланыс'=>['kk',],
'байланысты'=>['kk',],
'байланыстырасыз'=>['kk',],
'баксаў'=>['be',],
'бала'=>['kk',],
'баламен'=>['kk',],
'баланы'=>['kk',],
'баланың'=>['kk',],
'балаға'=>['kk',],
'бар'=>['kk',],
'бара'=>['kk','mk',],
'барабара'=>['be',],
'барады'=>['kk',],
'барам'=>['mk',],
'баратын'=>['kk',],
'бараш'=>['mk',],
'барем'=>['mk',],
'барлығы'=>['kk',],
'барлығын'=>['kk',],
'барлық'=>['kk',],
'барсін'=>['kk',],
'бас'=>['kk',],
'бассейн'=>['kk',],
'бассейнге'=>['kk',],
'бассейні'=>['kk',],
'бастады'=>['kk',],
'басына'=>['kk',],
'басқа'=>['kk',],
'басқарып'=>['kk',],
'батыс'=>['kk',],
'бацькоў'=>['be',],
'бачыш'=>['be',],
'бачыў'=>['be',],
'баш'=>['mk',],
'башка'=>['be',],
'башке'=>['be',],
'баща'=>['bg',],
'бақыттымын'=>['kk',],
'бе'=>['bg','kk','mk',],
'беа'=>['mk',],
'бебе'=>['mk',],
'бев'=>['mk',],
'бевме'=>['mk',],
'бегај'=>['mk',],
'без'=>['be','bg','mk','ru',],
'безопасности'=>['ru',],
'бейшара'=>['kk',],
'белгісіз'=>['kk',],
'бен'=>['bg','kk','mk',],
'бер'=>['kk',],
'берген'=>['kk',],
'бердің'=>['kk',],
'береді'=>['kk',],
'беремін'=>['kk',],
'бересіз'=>['kk',],
'берсін'=>['kk',],
'беруің'=>['kk',],
'бері'=>['kk',],
'бетін'=>['kk',],
'беше'=>['bg','mk',],
'би'=>['bg','mk',],
'бива'=>['bg',],
'бидам'=>['mk',],
'бидат'=>['mk',],
'биде'=>['mk',],
'бидеме'=>['mk',],
'бидете'=>['mk',],
'бидеш'=>['mk',],
'бидејќи'=>['mk',],
'биди'=>['mk',],
'бизнес'=>['bg',],
'бизнис'=>['mk',],
'бил'=>['bg','mk',],
'била'=>['bg','mk',],
'биле'=>['mk',],
'били'=>['bg',],
'било'=>['bg','mk',],
'бих'=>['bg',],
'бихте'=>['bg',],
'благодарам'=>['mk',],
'благодарю'=>['ru',],
'благодаря'=>['bg',],
'близо'=>['bg',],
'блин'=>['ru',],
'блиску'=>['mk',],
'бо'=>['be',],
'боб'=>['bg','mk',],
'бог'=>['bg','mk','ru',],
'бога'=>['bg','mk','ru',],
'боггз'=>['kk',],
'боже'=>['bg','mk','ru',],
'бойы'=>['kk',],
'бойынша'=>['kk',],
'бола'=>['kk',],
'болады'=>['kk',],
'болар'=>['kk',],
'болатын'=>['kk',],
'болатынмын'=>['kk',],
'болды'=>['kk',],
'болдым'=>['kk',],
'болдық'=>['kk',],
'более'=>['ru',],
'болей'=>['be',],
'боли'=>['bg','mk',],
'болмайды'=>['kk',],
'болмаса'=>['kk',],
'болмаған'=>['kk',],
'болмысы'=>['kk',],
'болница'=>['mk',],
'болницата'=>['bg',],
'болса'=>['kk',],
'болсам'=>['kk',],
'болсаң'=>['kk',],
'болу'=>['kk',],
'болуы'=>['kk',],
'болып'=>['kk',],
'болыпты'=>['kk',],
'боль'=>['ru',],
'больно'=>['ru',],
'больш'=>['be',],
'большая'=>['ru',],
'больше'=>['ru',],
'большое'=>['ru',],
'большой'=>['ru',],
'болған'=>['kk',],
'болғаным'=>['kk',],
'борба'=>['mk',],
'бос'=>['kk',],
'босатыңдар'=>['kk',],
'босқа'=>['kk',],
'боюсь'=>['ru',],
'боўн'=>['be',],
'браво'=>['bg',],
'бракман'=>['kk',],
'браняваныя'=>['be',],
'браслет'=>['kk',],
'брат'=>['bg','mk','ru',],
'братко'=>['bg',],
'брзо'=>['mk',],
'брод'=>['mk',],
'бродот'=>['mk',],
'брось'=>['ru',],
'број'=>['mk',],
'брыды'=>['be',],
'будем'=>['ru',],
'будет'=>['ru',],
'будете'=>['ru',],
'будешь'=>['ru',],
'будзе'=>['be',],
'будзем'=>['be',],
'будзеце'=>['be',],
'будзеш'=>['be',],
'будто'=>['ru',],
'буду'=>['be','ru',],
'будут'=>['ru',],
'будуць'=>['be',],
'будь'=>['ru',],
'бунтары'=>['be',],
'буферы'=>['be',],
'бъда'=>['bg',],
'бъдат'=>['bg',],
'бъде'=>['bg',],
'бъдем'=>['bg',],
'бъдете'=>['bg',],
'бъдеш'=>['bg',],
'бъди'=>['bg',],
'бързо'=>['bg',],
'бы'=>['be','ko','ru',],
'бывает'=>['ru',],
'был'=>['ru',],
'была'=>['be','ru',],
'были'=>['ru',],
'было'=>['be','ko','ru',],
'быстрее'=>['ru',],
'быстро'=>['ru',],
'быть'=>['ko','ru',],
'быць'=>['be',],
'быў'=>['be',],
'бэннан'=>['kk',],
'бэннанды'=>['kk',],
'бэннанмен'=>['kk',],
'бэннанның'=>['kk',],
'бягай'=>['bg',],
'бягом'=>['be',],
'бяруць'=>['be',],
'бях'=>['bg',],
'бяха'=>['bg',],
'бяхме'=>['bg',],
'бі'=>['be',],
'біз'=>['kk',],
'бізге'=>['kk',],
'бізде'=>['kk',],
'бізді'=>['kk',],
'біздің'=>['kk',],
'бізнэс'=>['be',],
'білгенге'=>['kk',],
'білдің'=>['kk',],
'біледі'=>['kk',],
'білемін'=>['kk',],
'білесіз'=>['kk',],
'білесің'=>['kk',],
'білмейміз'=>['kk',],
'білмеймін'=>['kk',],
'біліктілігім'=>['kk',],
'біліктілігіңізге'=>['kk',],
'білімді'=>['kk',],
'бір'=>['kk',],
'бірақ'=>['kk',],
'бірге'=>['kk',],
'біргемін'=>['kk',],
'бірдей'=>['kk',],
'бірдеңе'=>['kk',],
'біреу'=>['kk',],
'бірнеше'=>['kk',],
'бірнәрсе'=>['kk',],
'біртүрлі'=>['kk',],
'біріне'=>['kk',],
'бүгін'=>['kk',],
'бұл'=>['kk',],
'бұнымен'=>['kk',],
'бұрында'=>['kk',],
'бөксесін'=>['kk',],
'бөксесінен'=>['kk',],
'бөлмесіне'=>['kk',],
'бөлшектері'=>['kk',],
'бөлім'=>['kk',],
'в'=>['bg','ko','mk','ru',],
'вады'=>['be',],
'важи'=>['mk',],
'важно'=>['bg','mk','ru',],
'вака'=>['mk',],
'валэндаецца'=>['be',],
'вам'=>['be','ko','ru',],
'вами'=>['ru',],
'ваму'=>['mk',],
'вамі'=>['be',],
'вандраваць'=>['be',],
'ванная'=>['be',],
'вас'=>['be','bg','ko','mk','ru',],
'ватиканға'=>['kk',],
'ваш'=>['be','ko','ru',],
'ваша'=>['be','bg','ko','mk','ru',],
'вашай'=>['be',],
'вашата'=>['bg','mk',],
'ваше'=>['bg','ko','ru',],
'вашего'=>['ru',],
'вашей'=>['ru',],
'вашето'=>['mk',],
'ваши'=>['ru',],
'вашингтон'=>['kk',],
'вашиот'=>['mk',],
'вашите'=>['bg','mk',],
'ваших'=>['ru',],
'вашу'=>['be','ru',],
'вашую'=>['be',],
'ваяры'=>['be',],
'вдруг'=>['ru',],
'ве'=>['mk',],
'вегас'=>['be',],
'ведаеш'=>['be',],
'ведаць'=>['be',],
'ведаю'=>['be',],
'веднага'=>['bg',],
'веднаш'=>['mk',],
'веднъж'=>['bg',],
'ведь'=>['ko','ru',],
'везці'=>['be',],
'велам'=>['mk',],
'велат'=>['mk',],
'веленанге'=>['kk',],
'вели'=>['mk',],
'велиш'=>['mk',],
'вельмі'=>['be',],
'верная'=>['be',],
'верно'=>['ko','ru',],
'вернулся'=>['ru',],
'вернусь'=>['ru',],
'вернуть'=>['ru',],
'вернуться'=>['ru',],
'вероятно'=>['bg',],
'веројатно'=>['mk',],
'верува'=>['mk',],
'верувам'=>['mk',],
'веруваш'=>['mk',],
'верувај'=>['mk',],
'верю'=>['ru',],
'вести'=>['mk','ru',],
'весці'=>['be',],
'весь'=>['ru',],
'ветувам'=>['mk',],
'вецер'=>['be',],
'вечара'=>['be',],
'вече'=>['bg',],
'вечер'=>['bg','ko','mk','ru',],
'вечера'=>['mk',],
'вечерва'=>['mk',],
'вечером'=>['ru',],
'вечеря'=>['bg',],
'вещи'=>['ru',],
'вещь'=>['ru',],
'веќе'=>['mk',],
'взе'=>['bg',],
'взема'=>['bg',],
'вземе'=>['bg',],
'вземем'=>['bg',],
'вземете'=>['bg',],
'вземеш'=>['bg',],
'вземи'=>['bg',],
'взех'=>['bg',],
'взял'=>['ru',],
'взять'=>['ru',],
'ви'=>['bg','mk',],
'вид'=>['bg','mk',],
'видам'=>['mk',],
'виде'=>['mk',],
'видел'=>['mk','ru',],
'видела'=>['ru',],
'видели'=>['ru',],
'видете'=>['mk',],
'видеть'=>['ru',],
'види'=>['bg','mk',],
'видим'=>['bg',],
'видиме'=>['mk',],
'видите'=>['bg','mk','ru',],
'видиш'=>['bg','mk',],
'видишь'=>['ru',],
'видов'=>['mk',],
'виду'=>['ru',],
'видя'=>['bg',],
'видял'=>['bg',],
'видях'=>['bg',],
'вие'=>['bg','mk',],
'виж'=>['bg',],
'вижда'=>['bg',],
'виждал'=>['bg',],
'виждам'=>['bg',],
'виждате'=>['bg',],
'виждаш'=>['bg',],
'вижте'=>['bg',],
'вижу'=>['ko','ru',],
'вика'=>['mk',],
'викаат'=>['mk',],
'викам'=>['mk',],
'викаш'=>['mk',],
'вина'=>['ru',],
'винаги'=>['bg',],
'виновен'=>['bg',],
'вирджиния'=>['kk',],
'вистина'=>['mk',],
'вистината'=>['mk',],
'вистинска'=>['mk',],
'вистински'=>['mk',],
'вкъщи'=>['bg',],
'влезе'=>['mk',],
'влези'=>['mk',],
'влизай'=>['bg',],
'вместе'=>['ru',],
'вместо'=>['bg','ru',],
'внатре'=>['mk',],
'вниз'=>['ru',],
'внимавай'=>['bg',],
'внимавај'=>['mk',],
'внимание'=>['bg','mk','ru',],
'внимателно'=>['bg',],
'внутри'=>['ru',],
'во'=>['ko','mk','ru',],
'вода'=>['bg','mk',],
'водата'=>['bg','mk',],
'води'=>['bg','mk',],
'воды'=>['ru',],
'воже'=>['ko',],
'вози'=>['mk',],
'возможно'=>['ru',],
'возьми'=>['ru',],
'возьму'=>['ru',],
'война'=>['bg','ko','ru',],
'войната'=>['bg',],
'войны'=>['ru',],
'вокруг'=>['ru',],
'волнуйся'=>['ru',],
'вольны'=>['be',],
'вольше'=>['ko',],
'вон'=>['ru',],
'вообще'=>['ru',],
'воопшто'=>['mk',],
'вопрос'=>['ru',],
'вопросы'=>['ru',],
'вось'=>['be',],
'вот'=>['ko','ru',],
'војна'=>['mk',],
'вперед'=>['ru',],
'врата'=>['bg','mk',],
'вратам'=>['mk',],
'вратата'=>['bg','mk',],
'врати'=>['mk',],
'вратиме'=>['mk',],
'вратиш'=>['mk',],
'враќам'=>['mk',],
'време'=>['bg','mk',],
'времени'=>['ru',],
'времето'=>['bg','mk',],
'время'=>['ko','ru',],
'врз'=>['mk',],
'вроде'=>['ru',],
'врска'=>['mk',],
'връзка'=>['bg',],
'връщам'=>['bg',],
'все'=>['bg','ko','ru',],
'всегда'=>['ko','ru',],
'всего'=>['ko','ru',],
'всей'=>['ru',],
'всеки'=>['bg',],
'всем'=>['ru',],
'всему'=>['ru',],
'всех'=>['ru',],
'всички'=>['bg',],
'всичките'=>['bg',],
'всичко'=>['bg',],
'всушност'=>['mk',],
'всъщност'=>['bg',],
'всю'=>['ru',],
'вся'=>['ru',],
'всяка'=>['bg',],
'всяко'=>['bg',],
'всё'=>['ru',],
'второй'=>['ru',],
'вудет'=>['ko',],
'вучоныя'=>['be',],
'вчера'=>['bg','mk','ru',],
'във'=>['bg',],
'възможно'=>['bg',],
'възможност'=>['bg',],
'въпреки'=>['bg',],
'въпрос'=>['bg',],
'въпроса'=>['bg',],
'въпроси'=>['bg',],
'върви'=>['bg',],
'вървим'=>['bg',],
'върна'=>['bg',],
'върне'=>['bg',],
'върнем'=>['bg',],
'върнеш'=>['bg',],
'върни'=>['bg',],
'върху'=>['bg',],
'вътре'=>['bg',],
'вы'=>['be','ko','ru',],
'выбару'=>['be',],
'выглядит'=>['ru',],
'выглядишь'=>['ru',],
'выдаленне'=>['be',],
'выдатна'=>['be',],
'вызначаны'=>['be',],
'вызываецца'=>['be',],
'выйсці'=>['be',],
'выйти'=>['ru',],
'выйшлі'=>['be',],
'выкрадзена'=>['be',],
'выл'=>['ko',],
'выла'=>['ko',],
'вылекавайся'=>['be',],
'вылекаваў'=>['be',],
'выло'=>['ko',],
'выпадак'=>['be',],
'выпадку'=>['be',],
'выпить'=>['ru',],
'выратаваць'=>['be',],
'вырашыць'=>['be',],
'вытворчасць'=>['be',],
'выть'=>['ko',],
'выхад'=>['be',],
'выцягну'=>['be',],
'выцягнуць'=>['be',],
'выява'=>['be',],
'выяву'=>['be',],
'вэк'=>['be',],
'вэстэрн'=>['be',],
'вядзі'=>['be',],
'вязе'=>['be',],
'вярвам'=>['bg',],
'вярваш'=>['bg',],
'вярно'=>['bg',],
'вярнуцца'=>['be',],
'вярнуць'=>['be',],
'вярнуў'=>['be',],
'вяршыні'=>['be',],
'вікторыя'=>['be',],
'вільяма'=>['be',],
'вінен'=>['be',],
'вірус'=>['be',],
'вітаем'=>['be',],
'г'=>['bg','mk',],
'гадзін'=>['be',],
'гадзіну'=>['be',],
'газот'=>['mk',],
'галаве'=>['be',],
'галаву'=>['be',],
'галавы'=>['be',],
'гамбург'=>['be',],
'гандляр'=>['be',],
'ганны'=>['be',],
'ганьбу'=>['be',],
'гарады'=>['be',],
'гаражы'=>['kk',],
'гарри'=>['ru',],
'гатель'=>['be',],
'гатэль'=>['be',],
'гајле'=>['mk',],
'где'=>['ko','ru',],
'гексозаминдас'=>['kk',],
'генры'=>['be',],
'ги'=>['bg','mk',],
'гилврайт'=>['ko',],
'глабальная'=>['be',],
'глава'=>['mk',],
'главата'=>['bg','mk',],
'главное'=>['ru',],
'глаз'=>['ru',],
'глаза'=>['ko','ru',],
'гледа'=>['mk',],
'гледай'=>['bg',],
'гледам'=>['bg','mk',],
'гледаме'=>['mk',],
'гледате'=>['mk',],
'гледаш'=>['bg','mk',],
'гледај'=>['mk',],
'глупак'=>['bg',],
'глупости'=>['bg','mk',],
'гляджу'=>['be',],
'глядзі'=>['be',],
'го'=>['bg','mk','ru',],
'говори'=>['bg','ko','ru',],
'говорил'=>['ru',],
'говорила'=>['ru',],
'говорили'=>['ru',],
'говорим'=>['bg',],
'говорит'=>['ru',],
'говорите'=>['bg','ru',],
'говорить'=>['ru',],
'говориш'=>['bg',],
'говоришь'=>['ru',],
'говорю'=>['ru',],
'говоря'=>['bg','ru',],
'говорят'=>['ru',],
'год'=>['be','ru',],
'года'=>['ru',],
'годзе'=>['be',],
'година'=>['bg','mk',],
'години'=>['bg','mk',],
'году'=>['be','ru',],
'голем'=>['mk',],
'голема'=>['mk',],
'големи'=>['bg','mk',],
'големиот'=>['mk',],
'големо'=>['mk',],
'голову'=>['ru',],
'голос'=>['ru',],
'голям'=>['bg',],
'голяма'=>['bg',],
'голямата'=>['bg',],
'голямо'=>['bg',],
'гонка'=>['be',],
'горад'=>['be',],
'горадзе'=>['be',],
'горе'=>['bg','mk',],
'город'=>['ru',],
'города'=>['ru',],
'городе'=>['ru',],
'господ'=>['bg','mk',],
'господа'=>['bg','mk','ru',],
'господе'=>['mk',],
'господи'=>['bg','ru',],
'господин'=>['bg','ru',],
'господине'=>['bg','mk',],
'госпожо'=>['bg',],
'готов'=>['bg','ru',],
'готова'=>['bg','ru',],
'готови'=>['bg',],
'готово'=>['bg','mk',],
'готовы'=>['ru',],
'гофман'=>['be',],
'град'=>['bg','mk',],
'града'=>['bg',],
'градот'=>['mk',],
'градусаў'=>['be',],
'грешка'=>['bg','mk',],
'грижа'=>['bg','mk',],
'грижи'=>['mk',],
'грошаў'=>['be',],
'грошы'=>['be',],
'грукачы'=>['be',],
'група'=>['bg',],
'гэдак'=>['be',],
'гэй'=>['be',],
'гэта'=>['be',],
'гэтага'=>['be',],
'гэткім'=>['be',],
'гэтую'=>['be',],
'гэты'=>['be',],
'гэтым'=>['be',],
'гібсана'=>['be',],
'гігабайт'=>['be',],
'гігабайтаў'=>['be',],
'да'=>['be','bg','kk','ko','mk','ru','sr',],
'дабяруся'=>['be',],
'дава'=>['bg',],
'давай'=>['be','bg','ru',],
'давайте'=>['ru',],
'давно'=>['ru',],
'давярся'=>['be',],
'дадам'=>['mk',],
'даде'=>['bg','mk',],
'дадеш'=>['mk',],
'дадзеных'=>['be',],
'дадзеныя'=>['be',],
'даже'=>['bg','ko','ru',],
'дазволены'=>['be',],
'дазволіла'=>['be',],
'дай'=>['be','bg','ru',],
'дайте'=>['bg','ru',],
'дакладна'=>['be',],
'дакота'=>['kk',],
'дал'=>['ru',],
'далей'=>['be',],
'далеко'=>['ru',],
'далеку'=>['mk',],
'далеч'=>['bg',],
'дали'=>['bg','mk',],
'дальше'=>['ru',],
'дам'=>['bg','ru',],
'дами'=>['bg','mk',],
'дамовіцца'=>['be',],
'дан'=>['kk',],
'дана'=>['kk',],
'даны'=>['be',],
'дапамагчы'=>['be',],
'дапамажы'=>['be',],
'дапамогай'=>['be',],
'дапаможа'=>['be',],
'дарвін'=>['be',],
'даручаюць'=>['be',],
'даставіць'=>['be',],
'дастала'=>['be',],
'дастатковая'=>['be',],
'даступна'=>['be',],
'дасць'=>['be',],
'дасягальны'=>['be',],
'дата'=>['be',],
'дать'=>['ru',],
'дачакаецеся'=>['be',],
'дашліце'=>['be',],
'дашчэнт'=>['be',],
'дашчэнту'=>['be',],
'дај'=>['mk',],
'дајте'=>['mk',],
'два'=>['bg','mk','ru',],
'двайным'=>['be',],
'двама'=>['bg',],
'двамата'=>['bg',],
'двајца'=>['mk',],
'двајцата'=>['mk',],
'две'=>['bg','mk','ru',],
'дверь'=>['ru',],
'двете'=>['bg','mk',],
'двое'=>['ru',],
'двойчы'=>['be',],
'двух'=>['ru',],
'де'=>['bg','kk',],
'деверелл'=>['ko',],
'девочка'=>['ru',],
'девочки'=>['ru',],
'девојка'=>['mk',],
'девојката'=>['mk',],
'девојки'=>['mk',],
'девојче'=>['mk',],
'девушка'=>['ru',],
'деген'=>['kk',],
'дегеннің'=>['kk',],
'дегенің'=>['kk',],
'дедо'=>['mk',],
'деді'=>['kk',],
'дедім'=>['kk',],
'дедіңіз'=>['kk',],
'дейвид'=>['bg',],
'дейді'=>['kk',],
'деймін'=>['kk',],
'действительно'=>['ru',],
'дейсіз'=>['kk',],
'дейсің'=>['kk',],
'дейтін'=>['kk',],
'дека'=>['mk',],
'дел'=>['mk',],
'дела'=>['ru',],
'делает'=>['ru',],
'делаете'=>['ru',],
'делаешь'=>['ru',],
'делай'=>['ru',],
'делал'=>['ru',],
'делать'=>['ko','ru',],
'делаю'=>['ru',],
'делают'=>['ru',],
'деле'=>['ru',],
'дело'=>['ko','ru',],
'делік'=>['kk',],
'дем'=>['kk',],
'ден'=>['bg','mk',],
'дена'=>['mk',],
'дене'=>['kk',],
'денег'=>['ru',],
'денеге'=>['kk',],
'денес'=>['mk',],
'денеска'=>['mk',],
'денот'=>['mk',],
'день'=>['ru',],
'деньги'=>['ru',],
'деня'=>['bg',],
'деп'=>['kk',],
'держи'=>['ru',],
'держись'=>['ru',],
'дерьмо'=>['ru',],
'десет'=>['bg','mk',],
'десять'=>['ru',],
'дете'=>['bg','mk',],
'детей'=>['ru',],
'детето'=>['bg','mk',],
'дети'=>['ru',],
'детка'=>['ru',],
'деца'=>['bg','mk',],
'децата'=>['bg','mk',],
'дечки'=>['mk',],
'дечко'=>['mk',],
'дејвид'=>['mk',],
'деңгейін'=>['kk',],
'джак'=>['bg',],
'джек'=>['ru',],
'джеральд'=>['kk',],
'джими'=>['bg',],
'джо'=>['bg','kk','ru',],
'джозеф'=>['kk',],
'джон'=>['bg','ru',],
'джонс'=>['be',],
'джонса'=>['be',],
'джоні'=>['be',],
'джордж'=>['bg',],
'джыпіэль'=>['be',],
'джэй'=>['be',],
'джэйн'=>['be',],
'джэні'=>['be',],
'джэфры'=>['be',],
'дзве'=>['be',],
'дзе'=>['be',],
'дзеецца'=>['be',],
'дзеля'=>['be',],
'дзесятай'=>['be',],
'дзесятую'=>['be',],
'дзядзька'=>['be',],
'дзякуем'=>['be',],
'дзякуй'=>['be',],
'дзяржаў'=>['be',],
'дзярмо'=>['be',],
'дзярмом'=>['be',],
'дзяцінствам'=>['be',],
'дзіна'=>['be',],
'дзіця'=>['be',],
'дин'=>['mk',],
'дине'=>['mk',],
'для'=>['be','ko','ru',],
'дней'=>['ru',],
'днем'=>['ko',],
'днес'=>['bg',],
'дни'=>['bg',],
'дня'=>['ru',],
'дні'=>['be',],
'до'=>['bg','ko','mk','ru',],
'доаѓа'=>['mk',],
'доаѓаат'=>['mk',],
'доаѓам'=>['mk',],
'доаѓаш'=>['mk',],
'добар'=>['mk',],
'доби'=>['mk',],
'добив'=>['mk',],
'добиеш'=>['mk',],
'добијам'=>['mk',],
'добра'=>['be','bg','mk',],
'добрага'=>['be',],
'добрай'=>['be',],
'добре'=>['bg',],
'добри'=>['bg','mk',],
'добрите'=>['bg',],
'добро'=>['bg','mk','ru',],
'доброе'=>['ru',],
'доброто'=>['bg',],
'добрый'=>['ko','ru',],
'добър'=>['bg',],
'довечера'=>['bg',],
'довиждане'=>['bg',],
'доволно'=>['mk',],
'довольно'=>['ru',],
'договор'=>['mk',],
'додека'=>['mk',],
'дозволам'=>['mk',],
'дозволи'=>['mk',],
'дойда'=>['bg',],
'дойде'=>['bg',],
'дойдеш'=>['bg',],
'дойдзе'=>['be',],
'дойдох'=>['bg',],
'докато'=>['bg',],
'доктар'=>['be',],
'доктара'=>['be',],
'доктарам'=>['be',],
'доктор'=>['bg','kk','mk','ru',],
'докторе'=>['bg','mk',],
'долара'=>['bg',],
'долари'=>['mk',],
'долго'=>['mk','ru',],
'доле'=>['mk',],
'должен'=>['ko','ru',],
'должна'=>['ru',],
'должно'=>['ru',],
'должны'=>['ru',],
'долларов'=>['ru',],
'долу'=>['bg','mk',],
'дольф'=>['be',],
'дом'=>['be','bg','ko','mk','ru',],
'дома'=>['bg','mk','ru',],
'доме'=>['ru',],
'домой'=>['ko','ru',],
'дон'=>['be',],
'донесам'=>['mk',],
'донесе'=>['mk',],
'донеси'=>['mk',],
'донор'=>['kk',],
'допаѓа'=>['mk',],
'дори'=>['bg',],
'дорогая'=>['ru',],
'дорогой'=>['ko','ru',],
'досега'=>['bg',],
'доста'=>['bg','mk',],
'достаточно'=>['ru',],
'достатъчно'=>['bg',],
'доступ'=>['be',],
'дочь'=>['ru',],
'дошли'=>['bg',],
'дошъл'=>['bg',],
'дојдам'=>['mk',],
'дојде'=>['mk',],
'дојдете'=>['mk',],
'дојдеш'=>['mk',],
'дојди'=>['mk',],
'дојдов'=>['mk',],
'др'=>['mk',],
'драга'=>['mk',],
'драмми'=>['kk',],
'држи'=>['mk',],
'друг'=>['bg','mk','ru',],
'друга'=>['bg','mk','ru',],
'другар'=>['mk',],
'другата'=>['bg','mk',],
'други'=>['bg','mk',],
'другие'=>['ru',],
'другите'=>['bg','mk',],
'других'=>['ru',],
'друго'=>['bg','mk',],
'другого'=>['ru',],
'другое'=>['ru',],
'другой'=>['ru',],
'другом'=>['ru',],
'другото'=>['bg',],
'дружа'=>['be',],
'друзей'=>['ru',],
'друзья'=>['ru',],
'дръж'=>['bg',],
'дублёр'=>['be',],
'дублёра'=>['be',],
'дума'=>['bg',],
'думает'=>['ru',],
'думаете'=>['ru',],
'думаешь'=>['ko','ru',],
'думал'=>['ru',],
'думала'=>['ru',],
'думать'=>['ru',],
'думаю'=>['ko','ru',],
'думаў'=>['be',],
'думи'=>['bg',],
'дупа'=>['be',],
'дупу'=>['be',],
'дупы'=>['be',],
'дури'=>['mk',],
'дуры'=>['be',],
'душа'=>['be',],
'души'=>['bg',],
'душо'=>['mk',],
'дълго'=>['bg',],
'държа'=>['bg',],
'държи'=>['bg',],
'държиш'=>['bg',],
'дъщеря'=>['bg',],
'ды'=>['be',],
'дэмакратычных'=>['be',],
'дэманстрантамі'=>['be',],
'дэманстрацыя'=>['be',],
'дэніс'=>['be',],
'дэсармю'=>['be',],
'дэтэктар'=>['be',],
'дяволите'=>['bg',],
'дядо'=>['bg',],
'дядя'=>['ru',],
'діни'=>['kk',],
'дің'=>['kk',],
'дұрыс'=>['kk',],
'дәл'=>['kk',],
'дәлел'=>['kk',],
'дәлелдемесі'=>['kk',],
'дәлеліміз'=>['kk',],
'дәрежелі'=>['kk',],
'дәрі'=>['kk',],
'дәрігердің'=>['kk',],
'дәрігерлердің'=>['kk',],
'дәрігерісіз'=>['kk',],
'е'=>['bg','mk','ru',],
'ебам'=>['mk',],
'ебено'=>['mk',],
'еби'=>['mk',],
'еве'=>['mk',],
'егер'=>['kk',],
'его'=>['ko','ru',],
'едва'=>['bg',],
'еден'=>['mk',],
'еди'=>['mk',],
'един'=>['bg',],
'единствениот'=>['mk',],
'единственный'=>['ru',],
'една'=>['bg','mk',],
'еднаш'=>['mk',],
'едно'=>['bg','mk',],
'едноставно'=>['mk',],
'еду'=>['ru',],
'еді'=>['kk',],
'едік'=>['kk',],
'едім'=>['kk',],
'едің'=>['kk',],
'едіңіз'=>['kk',],
'ее'=>['ko','ru',],
'езу'=>['be',],
'езуса'=>['be',],
'ей'=>['bg','ko','ru',],
'екен'=>['kk',],
'екендігі'=>['kk',],
'екенін'=>['kk',],
'екеніңізді'=>['kk',],
'екеуміз'=>['kk',],
'екеуінде'=>['kk',],
'екеуің'=>['kk',],
'екі'=>['kk',],
'екінші'=>['kk',],
'ела'=>['bg',],
'елате'=>['bg',],
'еледің'=>['kk',],
'елес'=>['kk',],
'елшісі'=>['kk',],
'ем'=>['kk',],
'емдеген'=>['kk',],
'емдеу'=>['kk',],
'емді'=>['kk',],
'емес'=>['kk',],
'емеспін'=>['kk',],
'ему'=>['ko','ru',],
'емхана'=>['kk',],
'емі'=>['kk',],
'енді'=>['kk',],
'ене'=>['mk',],
'ер'=>['kk',],
'еркімен'=>['kk',],
'если'=>['ko','ru',],
'ести'=>['kk',],
'естиді'=>['kk',],
'есть'=>['ko','ru',],
'естідім'=>['kk',],
'естімесе'=>['kk',],
'естіп'=>['kk',],
'ете'=>['mk',],
'еткім'=>['kk',],
'ето'=>['bg',],
'етпес'=>['kk',],
'ехать'=>['ru',],
'ешкім'=>['kk',],
'ешкімге'=>['kk',],
'ешкіммен'=>['kk',],
'ештеңе'=>['kk',],
'ешқандай'=>['kk',],
'еще'=>['ko','ru',],
'ещё'=>['ru',],
'её'=>['ru',],
'еј'=>['mk',],
'ең'=>['kk',],
'ж'=>['be','ko','ru',],
'жao'=>['sr',],
'жe'=>['bs','hr','sr',],
'жemo'=>['bs','hr','sr',],
'жete'=>['bs','hr','sr',],
'жeљ'=>['bs','hr','sr',],
'жu'=>['bs','hr','sr',],
'жа'=>['bg',],
'жабылмақ'=>['kk',],
'жадае'=>['be',],
'жадаеце'=>['be',],
'жадаеш'=>['be',],
'жадаю'=>['be',],
'жадаюць'=>['be',],
'жадаў'=>['be',],
'жазып'=>['kk',],
'жайында'=>['kk',],
'жал'=>['mk',],
'жалам'=>['mk',],
'жаль'=>['ru',],
'жан'=>['be','ko',],
'жануар'=>['kk',],
'жарайды'=>['kk',],
'жас'=>['kk',],
'жасадың'=>['kk',],
'жасайтын'=>['kk',],
'жасалған'=>['kk',],
'жасап'=>['kk',],
'жасы'=>['kk',],
'жатақхана'=>['kk',],
'жатпайды'=>['kk',],
'жатып'=>['kk',],
'жатыр'=>['kk',],
'жатырмын'=>['kk',],
'жатырсыз'=>['kk',],
'жатырсың'=>['kk',],
'жатысым'=>['kk',],
'жатыңдар'=>['kk',],
'жатқан'=>['kk',],
'жатқыным'=>['kk',],
'жауабыңды'=>['kk',],
'жауап'=>['kk',],
'жахліва'=>['be',],
'жағдай'=>['kk',],
'жақсы'=>['kk',],
'жақсымын'=>['kk',],
'жақтарыңды'=>['kk',],
'жақын'=>['kk',],
'жақындамаңдар'=>['kk',],
'жаңалықтардан'=>['kk',],
'ждать'=>['ru',],
'же'=>['ko','ru',],
'жек'=>['kk',],
'жеккөрінішті'=>['kk',],
'жексенбі'=>['kk',],
'жена'=>['bg','mk','ru',],
'жената'=>['bg','mk',],
'жени'=>['bg','mk',],
'жените'=>['bg',],
'женщин'=>['ru',],
'женщина'=>['ru',],
'женщины'=>['ru',],
'жер'=>['kk',],
'жерге'=>['kk',],
'жерде'=>['kk',],
'жерден'=>['kk',],
'жерді'=>['kk',],
'жеткізгеніңе'=>['kk',],
'жеткізе'=>['kk',],
'жеткіземін'=>['kk',],
'жеті'=>['kk',],
'жеңілтек'=>['kk',],
'жив'=>['bg','mk',],
'живеам'=>['mk',],
'живее'=>['bg','mk',],
'живееш'=>['bg','mk',],
'живея'=>['bg',],
'живот'=>['bg','mk',],
'живота'=>['bg',],
'животот'=>['mk',],
'животът'=>['bg',],
'жизни'=>['ru',],
'жизнь'=>['ko','ru',],
'жиналу'=>['kk',],
'жить'=>['ru',],
'жо'=>['bg',],
'жолы'=>['kk',],
'жориды'=>['kk',],
'жоғалып'=>['kk',],
'жоғалған'=>['kk',],
'жоғалғаннан'=>['kk',],
'жоғалғаныңа'=>['kk',],
'жоқ'=>['kk',],
'жоқпын'=>['kk',],
'жоққа'=>['kk',],
'жывымі'=>['be',],
'жыл'=>['kk',],
'жылдар'=>['kk',],
'жыццё'=>['be',],
'жыўцом'=>['be',],
'жіберген'=>['kk',],
'жібереді'=>['kk',],
'жігіт'=>['kk',],
'жігіттер'=>['kk',],
'жүздеген'=>['kk',],
'жүк'=>['kk',],
'жүр'=>['kk',],
'жүргенімізді'=>['kk',],
'жүргеніңіз'=>['kk',],
'жүрмін'=>['kk',],
'жүрсе'=>['kk',],
'жүріңдер'=>['kk',],
'жұлынып'=>['kk',],
'жұлынған'=>['kk',],
'жұмыс'=>['kk',],
'жұмысты'=>['kk',],
'жұмысшысы'=>['kk',],
'жұмысы'=>['kk',],
'жұмысым'=>['kk',],
'жұмысымды'=>['kk',],
'жұмысын'=>['kk',],
'жұмысыңыз'=>['kk',],
'жұрт'=>['kk',],
'және'=>['kk',],
'з'=>['be',],
'за'=>['be','bg','ko','mk','ru','sr',],
'заб'=>['be',],
'забава'=>['mk',],
'забавата'=>['mk',],
'забавно'=>['bg','mk',],
'забаронены'=>['be',],
'заборави'=>['mk',],
'забрави'=>['bg',],
'забраць'=>['be',],
'забудь'=>['ru',],
'забыл'=>['ru',],
'забіць'=>['be',],
'завезці'=>['be',],
'завинаги'=>['bg',],
'заврши'=>['mk',],
'завтра'=>['ru',],
'загружаецца'=>['be',],
'загрузка'=>['be',],
'загрузім'=>['be',],
'загрузіце'=>['be',],
'загрузіць'=>['be',],
'зад'=>['bg','mk',],
'заданне'=>['be',],
'задник'=>['bg',],
'задника'=>['bg',],
'задоволство'=>['mk',],
'заедно'=>['bg','mk',],
'займаецца'=>['be',],
'займацца'=>['be',],
'залежыць'=>['be',],
'замарожаную'=>['be',],
'замбуе'=>['be',],
'замечательно'=>['ru',],
'замина'=>['mk',],
'замолчи'=>['mk',],
'заняцца'=>['be',],
'запознав'=>['mk',],
'започва'=>['bg',],
'започна'=>['bg',],
'запхнулі'=>['be',],
'запіс'=>['be',],
'зар'=>['mk',],
'зарабляю'=>['be',],
'заради'=>['bg','mk',],
'зараз'=>['be',],
'зарем'=>['mk',],
'засекогаш'=>['mk',],
'засталося'=>['be',],
'застани'=>['mk',],
'зат'=>['kk',],
'затвор'=>['mk',],
'затвора'=>['bg',],
'затем'=>['ru',],
'заткнись'=>['ru',],
'затоа'=>['mk',],
'затова'=>['bg',],
'затрымлівае'=>['be',],
'заттардың'=>['kk',],
'затты'=>['kk',],
'затқа'=>['kk',],
'зафіксавана'=>['be',],
'захаваць'=>['be',],
'заходзце'=>['be',],
'захоплівае'=>['be',],
'зачем'=>['ko','ru',],
'зачыніліся'=>['be',],
'зашто'=>['mk',],
'защо'=>['bg',],
'защото'=>['bg',],
'заўжды'=>['be',],
'заўтра'=>['be',],
'заңсыз'=>['kk',],
'збегчы'=>['be',],
'збогум'=>['mk',],
'збор'=>['mk',],
'зборови'=>['mk',],
'зборува'=>['mk',],
'зборувам'=>['mk',],
'зборуваме'=>['mk',],
'зборуваш'=>['mk',],
'зборувај'=>['mk',],
'збіраемся'=>['be',],
'званая'=>['be',],
'звучи'=>['bg','mk',],
'звучит'=>['ru',],
'звычайна'=>['be',],
'звярніцеся'=>['be',],
'згода'=>['be',],
'згодны'=>['be',],
'згубленую'=>['be',],
'згубім'=>['be',],
'згубіў'=>['be',],
'здарылася'=>['be',],
'здарэнняў'=>['be',],
'здесь'=>['ko','ru',],
'здольны'=>['be',],
'здорово'=>['ru',],
'здохну'=>['be',],
'здравей'=>['bg',],
'здравейте'=>['bg',],
'здраво'=>['mk',],
'здравствуйте'=>['ru',],
'здраднікі'=>['be',],
'здрасти'=>['bg',],
'земам'=>['mk',],
'земеме'=>['mk',],
'земете'=>['mk',],
'земеш'=>['mk',],
'земи'=>['mk',],
'земле'=>['ru',],
'земята'=>['bg',],
'земја'=>['mk',],
'земјата'=>['mk',],
'зерттедіңіз'=>['kk',],
'зле'=>['bg',],
'змогуць'=>['be',],
'знаат'=>['mk',],
'знае'=>['bg','mk',],
'знаев'=>['mk',],
'знаем'=>['bg','ru',],
'знаеме'=>['mk',],
'знает'=>['ru',],
'знаете'=>['bg','ko','mk','ru',],
'знаех'=>['bg',],
'знаеш'=>['bg','mk',],
'знаеше'=>['bg','mk',],
'знаешь'=>['ko','ru',],
'знайдзі'=>['be',],
'знайсці'=>['be',],
'знайшоў'=>['be',],
'знак'=>['mk',],
'знакамітасці'=>['be',],
'знал'=>['ru',],
'знала'=>['ko','ru',],
'знали'=>['ru',],
'знам'=>['bg','mk',],
'знать'=>['ru',],
'значение'=>['bg',],
'значи'=>['bg','mk',],
'значит'=>['ru',],
'значна'=>['be',],
'знаю'=>['ko','ru',],
'знают'=>['ru',],
'зная'=>['bg',],
'знаят'=>['bg',],
'знойдзен'=>['be',],
'знойдзена'=>['be',],
'зноў'=>['be',],
'зноўку'=>['be',],
'знішчылі'=>['be',],
'знішчыце'=>['be',],
'зовут'=>['ru',],
'зомбі'=>['be',],
'зоодүкен'=>['kk',],
'зошто'=>['mk',],
'зраблю'=>['be',],
'зрабіць'=>['be',],
'зрабіў'=>['be',],
'зразумей'=>['be',],
'зразумела'=>['be',],
'зразумелі'=>['be',],
'зразумеў'=>['be',],
'зусім'=>['be',],
'и'=>['bg','ko','mk','ru','sr',],
'иak'=>['bs','hr','sr',],
'иega'=>['sr',],
'иeka'=>['sr',],
'иekaj'=>['bs','hr','sr',],
'иekajte'=>['sr',],
'иemu'=>['bs','hr','sr',],
'иetiri'=>['sr',],
'иim'=>['sr',],
'иini'=>['bs','sr',],
'иovek'=>['sr',],
'иoveka'=>['sr',],
'иoveиe'=>['sr',],
'иovjek'=>['bs','hr',],
'иovjeиe'=>['bs','hr',],
'иudno'=>['sr',],
'иujem'=>['sr',],
'иujeљ'=>['sr',],
'иula'=>['sr',],
'иuli'=>['sr',],
'иuo'=>['bs','sr',],
'иако'=>['mk',],
'игра'=>['bg','mk','ru',],
'играта'=>['bg',],
'играть'=>['ru',],
'играш'=>['mk',],
'идва'=>['bg',],
'идвам'=>['bg',],
'идват'=>['bg',],
'идваш'=>['bg',],
'идем'=>['ru',],
'идет'=>['ru',],
'идея'=>['bg','ru',],
'идеја'=>['mk',],
'иди'=>['ru',],
'идиот'=>['bg','ru',],
'идите'=>['ru',],
'идти'=>['ru',],
'иду'=>['ru',],
'идём'=>['ru',],
'идёт'=>['ru',],
'ие'=>['kk',],
'из'=>['ko','ru',],
'избор'=>['bg','mk',],
'известно'=>['ru',],
'извинете'=>['bg','mk',],
'извини'=>['mk','ru',],
'извините'=>['ko','ru',],
'извинувам'=>['mk',],
'извинявай'=>['bg',],
'извън'=>['bg',],
'изгледа'=>['mk',],
'изгледаш'=>['mk',],
'изглежда'=>['bg',],
'изглеждаш'=>['bg',],
'излегувај'=>['mk',],
'излезе'=>['bg','mk',],
'изобщо'=>['bg',],
'или'=>['bg','ko','mk','ru',],
'им'=>['bg','mk','ru',],
'има'=>['bg','mk',],
'имаат'=>['mk',],
'имав'=>['mk',],
'имавме'=>['mk',],
'имал'=>['bg','mk',],
'имало'=>['bg',],
'имам'=>['bg','mk',],
'имаме'=>['bg','mk',],
'имат'=>['bg',],
'имате'=>['bg','mk',],
'имах'=>['bg',],
'имаш'=>['bg','mk',],
'имаше'=>['bg','mk',],
'име'=>['bg','mk',],
'имеет'=>['ru',],
'имеешь'=>['ru',],
'имени'=>['ru',],
'именно'=>['ru',],
'името'=>['bg','mk',],
'иметь'=>['ru',],
'имею'=>['ru',],
'имя'=>['ru',],
'иначе'=>['bg','ru',],
'ине'=>['kk',],
'иногда'=>['ru',],
'интересно'=>['bg','ru',],
'интересува'=>['bg',],
'информация'=>['bg',],
'ирэн'=>['ko',],
'иска'=>['bg',],
'искал'=>['bg',],
'искала'=>['bg',],
'искам'=>['bg',],
'искаме'=>['bg',],
'искат'=>['bg',],
'искате'=>['bg',],
'исках'=>['bg',],
'искаш'=>['bg',],
'искаше'=>['bg',],
'истина'=>['bg',],
'истината'=>['bg',],
'истински'=>['bg',],
'исто'=>['mk',],
'истории'=>['ru',],
'историю'=>['ru',],
'история'=>['bg','ru',],
'историята'=>['bg',],
'истото'=>['mk',],
'исусе'=>['mk',],
'итак'=>['ru',],
'италии'=>['ko',],
'итни'=>['kk',],
'итнимін'=>['kk',],
'иттер'=>['kk',],
'иттердің'=>['kk',],
'их'=>['ko','ru',],
'иә'=>['kk',],
'й'=>['be','bg',],
'йорк'=>['bg',],
'к'=>['ko','mk','ru',],
'ка'=>['ru',],
'каб'=>['be',],
'кавалак'=>['be',],
'каго'=>['be',],
'каде'=>['mk',],
'кадры'=>['be',],
'кажа'=>['bg','mk',],
'кажав'=>['mk',],
'кажам'=>['mk',],
'кажаш'=>['be',],
'каждый'=>['ru',],
'каже'=>['bg','mk',],
'кажем'=>['bg',],
'кажете'=>['bg','mk',],
'кажется'=>['ko','ru',],
'кажеш'=>['bg','mk',],
'кажи'=>['bg','mk',],
'кажу'=>['be',],
'кажува'=>['mk',],
'кажувам'=>['mk',],
'кажы'=>['be',],
'каза'=>['bg',],
'казал'=>['bg',],
'казах'=>['bg',],
'казаха'=>['bg',],
'казаў'=>['be',],
'казва'=>['bg',],
'казвай'=>['bg',],
'казвам'=>['bg',],
'казват'=>['bg',],
'казваш'=>['bg',],
'как'=>['bg','ko','ru',],
'какая'=>['ru',],
'каква'=>['bg','mk',],
'какви'=>['bg','mk',],
'какво'=>['bg','mk',],
'каквото'=>['bg',],
'какие'=>['ru',],
'како'=>['mk',],
'каков'=>['mk',],
'какого'=>['ru',],
'какое'=>['ru',],
'какой'=>['ko','ru',],
'както'=>['bg',],
'какъв'=>['bg',],
'калі'=>['be',],
'камеры'=>['be',],
'кампанія'=>['be',],
'каму'=>['be',],
'камунікэйшанс'=>['be',],
'кантроль'=>['be',],
'капетане'=>['mk',],
'капитан'=>['bg','ru',],
'капитане'=>['bg',],
'капіталізму'=>['be',],
'кара'=>['bg',],
'караш'=>['bg',],
'карл'=>['be',],
'кармодзі'=>['be',],
'карпарацыяў'=>['be',],
'картаны'=>['kk',],
'картины'=>['ko',],
'картка'=>['be',],
'карысць'=>['be',],
'като'=>['bg',],
'католик'=>['kk',],
'кафе'=>['bg','mk',],
'каштоўную'=>['be',],
'кај'=>['mk',],
'квіток'=>['be',],
'ке'=>['mk',],
'кеану'=>['be',],
'кевин'=>['mk',],
'кезде'=>['kk',],
'кездесетін'=>['kk',],
'кездескен'=>['kk',],
'кезінде'=>['kk',],
'кейін'=>['kk',],
'келген'=>['kk',],
'келгеніңізге'=>['kk',],
'келгеніңізді'=>['kk',],
'келді'=>['kk',],
'келдім'=>['kk',],
'келдіңіз'=>['kk',],
'келе'=>['kk',],
'келеді'=>['kk',],
'келесі'=>['kk',],
'келмеді'=>['kk',],
'келмейді'=>['kk',],
'келсе'=>['kk',],
'келіп'=>['kk',],
'келістім'=>['kk',],
'келіхам'=>['be',],
'кем'=>['ru',],
'керегі'=>['kk',],
'керек'=>['kk',],
'керекпін'=>['kk',],
'керемет'=>['kk',],
'кесіп'=>['kk',],
'кетемін'=>['kk',],
'кеткен'=>['kk',],
'кеткені'=>['kk',],
'кеткеніңе'=>['kk',],
'кеткір'=>['kk',],
'кетті'=>['kk',],
'кеттік'=>['kk',],
'кетіпсің'=>['kk',],
'кеш'=>['kk',],
'кешріңіз'=>['kk',],
'кешір'=>['kk',],
'кешіреміз'=>['kk',],
'кешірмек'=>['kk',],
'кешірім'=>['kk',],
'кешіріңіз'=>['kk',],
'кеңес'=>['kk',],
'кладзіся'=>['be',],
'клайд'=>['kk',],
'класе'=>['be',],
'ключа'=>['be',],
'ключом'=>['be',],
'клюшань'=>['be',],
'кляйн'=>['be',],
'клянусь'=>['ru',],
'клічуць'=>['be',],
'книга'=>['bg','mk',],
'книги'=>['ko',],
'ко'=>['ko','ru',],
'кога'=>['bg','mk',],
'когато'=>['bg',],
'когда'=>['ko','ru',],
'кого'=>['bg','mk','ru',],
'когото'=>['bg',],
'код'=>['be',],
'кода'=>['be',],
'кодаў'=>['be',],
'кое'=>['bg','mk',],
'което'=>['bg',],
'кои'=>['bg','mk',],
'които'=>['bg',],
'кой'=>['bg',],
'който'=>['bg',],
'кола'=>['bg','mk',],
'колата'=>['bg','mk',],
'коледа'=>['bg',],
'колко'=>['bg',],
'колкото'=>['bg',],
'колку'=>['mk',],
'колнам'=>['mk',],
'колумбия'=>['kk',],
'колькасці'=>['be',],
'колькі'=>['be',],
'колісь'=>['be',],
'комнате'=>['ru',],
'комнату'=>['ru',],
'комплексті'=>['kk',],
'кому'=>['ru',],
'кон'=>['mk',],
'конец'=>['ko','ru',],
'конечно'=>['ko','mk','ru',],
'контрола'=>['mk',],
'конца'=>['ru',],
'конце'=>['ru',],
'копеле'=>['bg',],
'копиле'=>['mk',],
'копію'=>['be',],
'копіі'=>['be',],
'корабль'=>['ru',],
'косіць'=>['be',],
'которая'=>['ru',],
'которого'=>['ru',],
'которое'=>['ru',],
'которой'=>['ru',],
'которую'=>['ru',],
'которые'=>['ru',],
'который'=>['ru',],
'которых'=>['ru',],
'кофе'=>['ru',],
'кошт'=>['be',],
'коя'=>['bg',],
'която'=>['bg',],
'кој'=>['mk',],
'која'=>['mk',],
'край'=>['bg',],
'крайней'=>['ru',],
'крака'=>['bg',],
'краката'=>['bg',],
'крал'=>['mk',],
'кралот'=>['mk',],
'красива'=>['bg',],
'красивая'=>['ru',],
'края'=>['bg',],
'крај'=>['mk',],
'крајот'=>['mk',],
'крв'=>['mk',],
'кревет'=>['mk',],
'криссман'=>['kk',],
'кристиан'=>['kk',],
'крови'=>['ru',],
'кровь'=>['ru',],
'кроме'=>['ru',],
'кръв'=>['bg',],
'крыагеннай'=>['be',],
'кстати'=>['ru',],
'кто'=>['ko','ru',],
'куда'=>['ko','ru',],
'куды'=>['be',],
'кул'=>['mk',],
'купить'=>['ru',],
'кур'=>['be',],
'курва'=>['be',],
'кусок'=>['be',],
'куче'=>['bg','mk',],
'кучи'=>['bg',],
'кучка'=>['bg',],
'кучкин'=>['mk',],
'куќа'=>['mk',],
'куќата'=>['mk',],
'кшталту'=>['be',],
'къде'=>['bg',],
'където'=>['bg',],
'към'=>['bg',],
'късмет'=>['bg',],
'късно'=>['bg',],
'къща'=>['bg',],
'къщата'=>['bg',],
'къщи'=>['bg',],
'кіберпрасторы'=>['be',],
'кіер'=>['be',],
'кім'=>['be','kk',],
'кімге'=>['kk',],
'кімсіз'=>['kk',],
'кінакампаніі'=>['be',],
'кінь'=>['be',],
'кінәлерді'=>['kk',],
'кінәлі'=>['kk',],
'кірме'=>['kk',],
'кірсін'=>['kk',],
'кіріңіз'=>['kk',],
'кісі'=>['kk',],
'кісіге'=>['kk',],
'кісілер'=>['kk',],
'кісілерге'=>['kk',],
'кісіні'=>['kk',],
'кітайскіх'=>['be',],
'кітана'=>['be',],
'кішкене'=>['kk',],
'күдік'=>['kk',],
'күдіктенсең'=>['kk',],
'күдікті'=>['kk',],
'күдіктінің'=>['kk',],
'күндей'=>['kk',],
'күні'=>['kk',],
'күнәсінен'=>['kk',],
'күресіп'=>['kk',],
'күт'=>['kk',],
'күтпеген'=>['kk',],
'күтіп'=>['kk',],
'кәне'=>['kk',],
'көбіне'=>['kk',],
'көздерім'=>['kk',],
'көмегің'=>['kk',],
'көмек'=>['kk',],
'көмектесе'=>['kk',],
'көмектесемін'=>['kk',],
'көмектессең'=>['kk',],
'көмектесіңдер'=>['kk',],
'көрген'=>['kk',],
'көрдім'=>['kk',],
'көрдіңіз'=>['kk',],
'көре'=>['kk',],
'көрейік'=>['kk',],
'көреміз'=>['kk',],
'көресіз'=>['kk',],
'көрсете'=>['kk',],
'көрсететінімді'=>['kk',],
'көрсеткім'=>['kk',],
'көрсеттің'=>['kk',],
'көруге'=>['kk',],
'көршісімен'=>['kk',],
'көрінеді'=>['kk',],
'көрінетін'=>['kk',],
'көріп'=>['kk',],
'көріпкелдігі'=>['kk',],
'көтеріңдер'=>['kk',],
'көңілдеріңді'=>['kk',],
'лабораториясы'=>['kk',],
'ладно'=>['ru',],
'лантас'=>['be',],
'лас'=>['be',],
'ласка'=>['be',],
'латэкаў'=>['be',],
'латэкі'=>['be',],
'легко'=>['ru',],
'леглото'=>['bg',],
'легчы'=>['be',],
'ледзь'=>['be',],
'леди'=>['ko','ru',],
'лека'=>['bg',],
'лекавання'=>['be',],
'лекавыя'=>['be',],
'лекамі'=>['be',],
'лекі'=>['be',],
'леле'=>['mk',],
'лепш'=>['be',],
'лепшага'=>['be',],
'лесно'=>['bg','mk',],
'лет'=>['ru',],
'ли'=>['bg','kk','ko','mk','ru','sr',],
'либо'=>['ru',],
'лизосомды'=>['kk',],
'лизосомын'=>['kk',],
'линија'=>['mk',],
'липидті'=>['kk',],
'лице'=>['bg','mk',],
'лицето'=>['bg','mk',],
'лицо'=>['ru',],
'личи'=>['mk',],
'лично'=>['bg','mk',],
'личност'=>['mk',],
'лишь'=>['ko','ru',],
'лоджык'=>['be',],
'лонга'=>['be',],
'лонгі'=>['be',],
'лондон'=>['ko',],
'лотти'=>['ko',],
'лош'=>['bg','mk',],
'лоша'=>['mk',],
'лоши'=>['mk',],
'лошо'=>['bg','mk',],
'луд'=>['bg','mk',],
'лудо'=>['mk',],
'лундгрэн'=>['be',],
'лухты'=>['be',],
'лучше'=>['ko','ru',],
'лучший'=>['ru',],
'луѓе'=>['mk',],
'луѓето'=>['mk',],
'лысы'=>['be',],
'льдом'=>['be',],
'любви'=>['ru',],
'любит'=>['ru',],
'любишь'=>['ru',],
'люблю'=>['ru',],
'любов'=>['bg',],
'любовта'=>['bg',],
'любовь'=>['ru',],
'любой'=>['ru',],
'любым'=>['be',],
'любыя'=>['be',],
'лювлю'=>['ko',],
'людей'=>['ru',],
'людзей'=>['be',],
'людзям'=>['be',],
'людзі'=>['be',],
'люди'=>['ru',],
'людям'=>['ru',],
'лютер'=>['kk',],
'ля'=>['be',],
'лёгкі'=>['be',],
'лёд'=>['be',],
'ліхаманка'=>['be',],
'лічыльнік'=>['be',],
'лічыш'=>['be',],
'м'=>['be',],
'ма'=>['kk',],
'мабыць'=>['be',],
'магу'=>['be',],
'магчымасць'=>['be',],
'магчымасьць'=>['be',],
'мадам'=>['ko','ru',],
'мае'=>['be',],
'маем'=>['be',],
'маеце'=>['be',],
'маеш'=>['be',],
'маж'=>['mk',],
'мазалайтын'=>['kk',],
'мазақ'=>['kk',],
'мазгах'=>['be',],
'май'=>['bg',],
'майк'=>['bg',],
'майка'=>['bg',],
'майкла'=>['be',],
'майкъл'=>['bg',],
'майната'=>['bg',],
'макларен'=>['kk',],
'макс'=>['mk',],
'мал'=>['mk',],
'мала'=>['mk',],
'малдер'=>['kk',],
'малдерді'=>['kk',],
'малдермен'=>['kk',],
'малдерсіз'=>['kk',],
'маленький'=>['ru',],
'мали'=>['mk',],
'малка'=>['bg',],
'малки'=>['bg',],
'малко'=>['bg',],
'малку'=>['mk',],
'мало'=>['mk','ru',],
'малък'=>['bg',],
'малыш'=>['ru',],
'мальчик'=>['ru',],
'мам'=>['ru',],
'мама'=>['bg','mk','ru',],
'мамандар'=>['kk',],
'мамка'=>['bg',],
'мамо'=>['bg','mk',],
'мантаж'=>['be',],
'мария'=>['kk',],
'мароні'=>['be',],
'маста'=>['be',],
'матери'=>['ru',],
'материаландырған'=>['kk',],
'материалдар'=>['kk',],
'матывах'=>['be',],
'мать'=>['ru',],
'махай'=>['bg',],
'махни'=>['bg',],
'машина'=>['kk','ru',],
'машинаны'=>['kk',],
'машинасы'=>['kk',],
'машинаға'=>['kk',],
'машине'=>['ru',],
'машину'=>['ru',],
'машины'=>['ru',],
'маю'=>['be',],
'мая'=>['be',],
'маёй'=>['be',],
'маіх'=>['be',],
'мајк'=>['mk',],
'мајка'=>['mk',],
'мајкл'=>['mk',],
'маған'=>['kk',],
'мақсат'=>['kk',],
'маңызды'=>['kk',],
'ме'=>['bg','kk','mk','sr',],
'медиқалық'=>['kk',],
'медыйныя'=>['be',],
'медычнай'=>['be',],
'меер'=>['be',],
'между'=>['bg','ru',],
'мелі'=>['be',],
'мен'=>['bg','kk',],
'менде'=>['kk',],
'мене'=>['mk',],
'меннен'=>['kk',],
'меньше'=>['ru',],
'меня'=>['ko','ru',],
'мені'=>['kk',],
'менімен'=>['kk',],
'менің'=>['kk',],
'меніңше'=>['kk',],
'мере'=>['ru',],
'мери'=>['bg','mk',],
'мерси'=>['bg',],
'месец'=>['bg','mk',],
'месеца'=>['bg',],
'месеци'=>['mk',],
'места'=>['bg','mk','ru',],
'месте'=>['ru',],
'место'=>['mk','ru',],
'местото'=>['mk',],
'месца'=>['be',],
'месцы'=>['be',],
'месье'=>['ru',],
'месяц'=>['ru',],
'месяцев'=>['ru',],
'мехіка'=>['be',],
'мець'=>['be',],
'меѓу'=>['mk',],
'ми'=>['bg','kk','mk','sr',],
'мидан'=>['kk',],
'мидағы'=>['kk',],
'мидың'=>['kk',],
'мила'=>['bg','mk',],
'милая'=>['ru',],
'мили'=>['bg',],
'милиона'=>['bg',],
'милиони'=>['mk',],
'миллионов'=>['ru',],
'мило'=>['mk','ru',],
'милый'=>['ru',],
'мина'=>['bg',],
'миналата'=>['bg',],
'минатата'=>['mk',],
'минут'=>['ru',],
'минута'=>['bg','mk',],
'минути'=>['bg','mk',],
'минутку'=>['ru',],
'минуту'=>['ru',],
'мир'=>['mk','ru',],
'мира'=>['bg','ru',],
'мире'=>['ru',],
'мислам'=>['mk',],
'мислат'=>['mk',],
'мислев'=>['mk',],
'мислех'=>['bg',],
'мислеше'=>['mk',],
'мисли'=>['bg','mk',],
'мислите'=>['bg','mk',],
'мислиш'=>['bg','mk',],
'мисля'=>['bg',],
'мисс'=>['ko','ru',],
'миссис'=>['ru',],
'мистер'=>['ko','ru',],
'млекакормячае'=>['be',],
'млъквай'=>['bg',],
'млъкни'=>['bg',],
'мм'=>['ko',],
'мне'=>['be','ko','ru',],
'мнемонік'=>['be',],
'мнемонікам'=>['be',],
'многие'=>['ru',],
'много'=>['bg','ko','ru',],
'многу'=>['mk',],
'мной'=>['ko','ru',],
'мова'=>['be',],
'мог'=>['be','ru',],
'мога'=>['bg',],
'могат'=>['bg',],
'могла'=>['ru',],
'могли'=>['ru',],
'могу'=>['ko','ru',],
'могут'=>['ru',],
'могуць'=>['be',],
'могъл'=>['bg',],
'модуль'=>['be',],
'мое'=>['bg','mk','ru',],
'моего'=>['ko','ru',],
'моей'=>['ko','ru',],
'моем'=>['ru',],
'моему'=>['ru',],
'моето'=>['bg','mk',],
'можа'=>['be',],
'можам'=>['mk',],
'можат'=>['mk',],
'можаш'=>['be',],
'може'=>['bg','mk',],
'можеби'=>['mk',],
'можев'=>['mk',],
'можел'=>['mk',],
'можеле'=>['mk',],
'можем'=>['bg','ru',],
'можеме'=>['mk',],
'может'=>['ko','ru',],
'можете'=>['bg','mk','ru',],
'можех'=>['bg',],
'можеш'=>['bg','mk',],
'можеше'=>['bg','mk',],
'можешь'=>['ru',],
'можно'=>['ko','mk','ru',],
'мозг'=>['be',],
'мои'=>['ko','mk','ru',],
'моим'=>['ru',],
'моите'=>['bg','mk',],
'моих'=>['ko','ru',],
'мой'=>['be','bg','ko','ru',],
'молам'=>['mk',],
'молодец'=>['ru',],
'моля'=>['bg',],
'момент'=>['bg','mk','ru',],
'момента'=>['bg',],
'момиче'=>['bg',],
'момичета'=>['bg',],
'момичето'=>['bg',],
'момци'=>['mk',],
'момче'=>['bg','mk',],
'момчета'=>['bg',],
'момчетата'=>['bg',],
'момчето'=>['bg','mk',],
'моника'=>['kk',],
'мониканы'=>['kk',],
'мора'=>['mk',],
'морав'=>['mk',],
'морам'=>['mk',],
'мораме'=>['mk',],
'морате'=>['mk',],
'мораш'=>['mk',],
'моцна'=>['be',],
'мою'=>['ko','ru',],
'моя'=>['bg','ko','ru',],
'моят'=>['bg',],
'моята'=>['bg',],
'моё'=>['ru',],
'мој'=>['mk',],
'моја'=>['mk',],
'мојата'=>['mk',],
'мојот'=>['mk',],
'моќ'=>['mk',],
'мразам'=>['mk',],
'мразя'=>['bg',],
'мрдај'=>['mk',],
'мртви'=>['mk',],
'мртов'=>['mk',],
'мсье'=>['ko',],
'му'=>['bg','mk',],
'муж'=>['ru',],
'мужик'=>['ru',],
'мужчина'=>['ru',],
'музика'=>['bg',],
'музыка'=>['be',],
'мульцінацыянальных'=>['be',],
'мъж'=>['bg',],
'мъже'=>['bg',],
'мърдай'=>['bg',],
'мъртъв'=>['bg',],
'мы'=>['be','ko','ru',],
'мына'=>['kk',],
'мынаны'=>['kk',],
'мынау'=>['kk',],
'мэта'=>['be',],
'мяне'=>['be',],
'мяртвы'=>['be',],
'място'=>['bg',],
'мястото'=>['bg',],
'мільёны'=>['be',],
'мінейтін'=>['kk',],
'містэр'=>['be',],
'мүмкін'=>['kk',],
'мүмкіндігі'=>['kk',],
'мүшелерін'=>['kk',],
'мүшесін'=>['kk',],
'мұз'=>['kk',],
'мұмкін'=>['kk',],
'н'=>['bg','mk',],
'нe'=>['mk','ru',],
'на'=>['be','bg','ko','mk','ru','sr',],
'набяры'=>['be',],
'наваму'=>['mk',],
'нават'=>['be',],
'наверное'=>['ru',],
'навистина'=>['mk',],
'навошта'=>['be',],
'навсякъде'=>['bg',],
'навън'=>['bg',],
'навіны'=>['be',],
'над'=>['bg','mk','ru',],
'надалей'=>['be',],
'надвор'=>['mk',],
'надевам'=>['mk',],
'надеюсь'=>['ru',],
'надо'=>['ko','ru',],
'надявам'=>['bg',],
'назад'=>['be','bg','mk','ru',],
'назаўжды'=>['be',],
'наистина'=>['bg',],
'найти'=>['ru',],
'найхутчэй'=>['be',],
'наконец'=>['ru',],
'наконт'=>['be',],
'накрая'=>['bg',],
'накіраваўся'=>['be',],
'накіроўваецца'=>['be',],
'нали'=>['bg',],
'нам'=>['be','ko','ru',],
'намери'=>['bg',],
'намерим'=>['bg',],
'намерих'=>['bg',],
'намериш'=>['bg',],
'намеря'=>['bg',],
'нами'=>['ru',],
'наоколо'=>['bg',],
'наоколу'=>['mk',],
'направам'=>['mk',],
'направи'=>['bg','mk',],
'направив'=>['mk',],
'направил'=>['bg','mk',],
'направим'=>['bg',],
'направиме'=>['mk',],
'направих'=>['bg',],
'направиш'=>['bg','mk',],
'направо'=>['bg',],
'направя'=>['bg',],
'напред'=>['bg','mk',],
'например'=>['bg','ru',],
'напълно'=>['bg',],
'напэўна'=>['be',],
'наред'=>['bg',],
'нас'=>['be','bg','ko','mk','ru',],
'насам'=>['bg',],
'насамрэч'=>['be',],
'насекаде'=>['mk',],
'насколько'=>['ru',],
'насколькі'=>['be',],
'наскоро'=>['mk',],
'настолько'=>['ru',],
'настоящий'=>['ru',],
'наступны'=>['be',],
'наступіў'=>['be',],
'насчет'=>['ru',],
'научи'=>['bg','mk',],
'находится'=>['ru',],
'націсніце'=>['be',],
'начал'=>['ru',],
'начала'=>['ru',],
'начать'=>['ru',],
'начин'=>['bg','mk',],
'наш'=>['ru',],
'наша'=>['ru',],
'нашае'=>['be',],
'нашата'=>['bg','mk',],
'наше'=>['ru',],
'нашего'=>['ru',],
'нашей'=>['ru',],
'нашел'=>['ru',],
'нашето'=>['bg','mk',],
'наши'=>['ru',],
'нашиот'=>['mk',],
'нашите'=>['bg','mk',],
'наших'=>['ru',],
'нашия'=>['bg',],
'нашият'=>['bg',],
'нашла'=>['ru',],
'нашли'=>['ru',],
'нашпігавалі'=>['be',],
'нашу'=>['ru',],
'најдам'=>['mk',],
'најде'=>['mk',],
'најдеме'=>['mk',],
'најдеш'=>['mk',],
'најди'=>['mk',],
'најдобар'=>['mk',],
'најдобриот'=>['mk',],
'најдобро'=>['mk',],
'најдов'=>['mk',],
'нда'=>['kk',],
'не'=>['be','bg','kk','ko','mk','ru','sr',],
'неа'=>['mk',],
'неадкладна'=>['be',],
'небяспечна'=>['be',],
'небяспечная'=>['be',],
'невероятно'=>['bg',],
'неверојатно'=>['mk',],
'невинсон'=>['ko',],
'невозможно'=>['ru',],
'неврологпен'=>['kk',],
'невъзможно'=>['bg',],
'невылечная'=>['be',],
'невядомы'=>['be',],
'невялічкай'=>['be',],
'неге'=>['kk',],
'него'=>['bg','mk','ru',],
'неговата'=>['bg','mk',],
'неговиот'=>['mk',],
'неговите'=>['mk',],
'неговото'=>['mk',],
'недасягальны'=>['be',],
'недей'=>['bg',],
'недела'=>['mk',],
'недели'=>['mk','ru',],
'неделю'=>['ru',],
'нее'=>['ko','ru',],
'незадаволены'=>['be',],
'незнам'=>['mk',],
'ней'=>['ru',],
'нека'=>['bg','mk',],
'некаде'=>['mk',],
'некако'=>['mk',],
'некогаш'=>['mk',],
'некого'=>['mk',],
'некое'=>['mk',],
'некои'=>['mk',],
'неколку'=>['mk',],
'некоторые'=>['ru',],
'некој'=>['mk',],
'некоја'=>['mk',],
'нели'=>['mk',],
'нельзя'=>['ru',],
'нем'=>['ru',],
'нема'=>['mk',],
'немагчыма'=>['be',],
'немам'=>['mk',],
'немаме'=>['mk',],
'немаш'=>['mk',],
'немаше'=>['mk',],
'немаўлят'=>['be',],
'немедленно'=>['ru',],
'немене'=>['kk',],
'немесе'=>['kk',],
'немного'=>['ru',],
'немој'=>['mk',],
'нему'=>['ru',],
'немістер'=>['kk',],
'ненавижу'=>['ru',],
'непаладкі'=>['be',],
'неплохо'=>['ru',],
'нервовай'=>['be',],
'несколько'=>['ru',],
'несреќа'=>['mk',],
'нет'=>['ko','ru',],
'неужели'=>['ru',],
'нечего'=>['ru',],
'нешта'=>['mk',],
'нешто'=>['mk',],
'неща'=>['bg',],
'нещата'=>['bg',],
'нещо'=>['bg',],
'нея'=>['bg',],
'неяк'=>['be',],
'неё'=>['ru',],
'нејзината'=>['mk',],
'нејзиниот'=>['mk',],
'ни'=>['bg','ko','mk','ru',],
'нибудь'=>['ko','ru',],
'нив'=>['mk',],
'нивните'=>['mk',],
'ние'=>['bg','mk',],
'низ'=>['mk',],
'никаде'=>['mk',],
'никаква'=>['mk',],
'никакви'=>['bg',],
'никаких'=>['ru',],
'никакого'=>['ru',],
'никакой'=>['ru',],
'никакъв'=>['bg',],
'никога'=>['bg',],
'никогаш'=>['mk',],
'никогда'=>['ko','ru',],
'никого'=>['bg','mk','ru',],
'никой'=>['bg',],
'никому'=>['ru',],
'никој'=>['mk',],
'никто'=>['ru',],
'ним'=>['ru',],
'нима'=>['bg',],
'ними'=>['ru',],
'нито'=>['bg',],
'ниту'=>['mk',],
'них'=>['ru',],
'ничего'=>['ko','ru',],
'ништо'=>['mk',],
'нищо'=>['bg',],
'није'=>['sr',],
'но'=>['bg','ko','mk','ru',],
'нов'=>['bg','mk',],
'нова'=>['bg','mk',],
'новае'=>['be',],
'новая'=>['be',],
'нови'=>['bg','mk',],
'новини'=>['bg',],
'ново'=>['bg','mk',],
'новости'=>['ru',],
'новый'=>['ru',],
'новых'=>['be',],
'ноги'=>['ru',],
'номер'=>['bg','ko','ru',],
'номера'=>['bg',],
'нора'=>['ko',],
'норли'=>['ko',],
'нормально'=>['ru',],
'норы'=>['be',],
'носам'=>['mk',],
'носи'=>['bg','mk',],
'носиш'=>['mk',],
'нося'=>['bg',],
'ночи'=>['ko','ru',],
'ночь'=>['ru',],
'ночью'=>['ru',],
'нощ'=>['bg',],
'нощта'=>['bg',],
'ноќ'=>['mk',],
'нравится'=>['ru',],
'ну'=>['be','ko','ru',],
'нужда'=>['bg',],
'нужен'=>['ru',],
'нужна'=>['ru',],
'нужно'=>['bg','ko','ru',],
'нужны'=>['ru',],
'нуля'=>['be',],
'нумар'=>['be',],
'нью'=>['be',],
'ньюарк'=>['be',],
'ньюарке'=>['be',],
'ньюарку'=>['be',],
'нэрвавацца'=>['be',],
'нэрвовай'=>['be',],
'нэрвовую'=>['be',],
'нэт'=>['be',],
'ню'=>['bg',],
'ня'=>['be',],
'нябачнасці'=>['be',],
'нябёсы'=>['be',],
'някаква'=>['bg',],
'някакви'=>['bg',],
'някакъв'=>['bg',],
'някога'=>['bg',],
'някого'=>['bg',],
'някои'=>['bg',],
'някой'=>['bg',],
'няколко'=>['bg',],
'някоя'=>['bg',],
'някъде'=>['bg',],
'няма'=>['be','bg',],
'нямам'=>['bg',],
'нямаме'=>['bg',],
'нямаш'=>['bg',],
'нямаше'=>['bg',],
'няшчасных'=>['be',],
'няўжо'=>['be',],
'ніколі'=>['be',],
'ніла'=>['be',],
'нічога'=>['be',],
'нәсіпқұмарларға'=>['kk',],
'нәтижелерді'=>['kk',],
'нәтижелері'=>['kk',],
'нәтижесін'=>['kk',],
'о'=>['be','bg','ko','mk','ru',],
'об'=>['ru',],
'оба'=>['ru',],
'обади'=>['bg',],
'обадя'=>['bg',],
'обаче'=>['bg',],
'обещавам'=>['bg',],
'обещаю'=>['ru',],
'обидувам'=>['mk',],
'обикновено'=>['bg',],
'обича'=>['bg',],
'обичам'=>['bg',],
'обичаш'=>['bg',],
'обично'=>['mk',],
'обо'=>['ru',],
'образом'=>['ru',],
'обратно'=>['bg','ru',],
'общо'=>['bg',],
'обычно'=>['ru',],
'обязательно'=>['ru',],
'ова'=>['mk',],
'оваа'=>['mk',],
'овде'=>['mk',],
'овие'=>['mk',],
'овој'=>['mk',],
'оган'=>['mk',],
'огонь'=>['ru',],
'огън'=>['bg',],
'од'=>['mk',],
'одам'=>['mk',],
'одан'=>['kk',],
'одат'=>['mk',],
'одете'=>['mk',],
'оди'=>['mk',],
'одиме'=>['mk',],
'один'=>['ko','ru',],
'одите'=>['mk',],
'одиш'=>['mk',],
'одлична'=>['mk',],
'одлично'=>['mk',],
'одна'=>['ru',],
'однажды'=>['ru',],
'одним'=>['ru',],
'одно'=>['ru',],
'одного'=>['ru',],
'одной'=>['ru',],
'одну'=>['ko','ru',],
'одовде'=>['mk',],
'означава'=>['bg',],
'ой'=>['kk','ru',],
'ойладым'=>['kk',],
'ойлаймыз'=>['kk',],
'ойлаймын'=>['kk',],
'ойлайсың'=>['kk',],
'ойландым'=>['kk',],
'ойландың'=>['kk',],
'ойлап'=>['kk',],
'ойыңды'=>['kk',],
'ок'=>['bg','mk','ru',],
'около'=>['bg','ru',],
'околу'=>['mk',],
'ол'=>['kk',],
'олай'=>['kk',],
'олар'=>['kk',],
'олардан'=>['kk',],
'оларды'=>['kk',],
'олардың'=>['kk',],
'оларға'=>['kk',],
'он'=>['kk','ko','mk','ru',],
'она'=>['ko','mk','ru',],
'онаа'=>['mk',],
'онази'=>['bg',],
'онда'=>['kk',],
'ондай'=>['kk',],
'онези'=>['bg',],
'онзи'=>['bg',],
'они'=>['ko','ru',],
'оние'=>['mk',],
'оно'=>['ru',],
'онова'=>['bg',],
'оној'=>['mk',],
'оны'=>['kk',],
'онымен'=>['kk',],
'оның'=>['kk',],
'ооған'=>['kk',],
'опита'=>['bg',],
'опитай'=>['bg',],
'опитвам'=>['bg',],
'оправи'=>['bg',],
'оправя'=>['bg',],
'определено'=>['bg',],
'опять'=>['ru',],
'оралуын'=>['kk',],
'ордеріміз'=>['kk',],
'орнын'=>['kk',],
'орнына'=>['kk',],
'орнында'=>['kk',],
'оружие'=>['ru',],
'оружје'=>['mk',],
'оружјето'=>['mk',],
'оръжие'=>['bg',],
'освен'=>['bg','mk',],
'особенно'=>['ru',],
'особено'=>['bg',],
'остава'=>['bg',],
'оставам'=>['mk',],
'оставете'=>['bg',],
'остави'=>['bg','mk',],
'оставил'=>['ru',],
'оставить'=>['ru',],
'оставь'=>['ru',],
'оставя'=>['bg',],
'осталось'=>['ru',],
'остана'=>['bg',],
'останалите'=>['bg',],
'останам'=>['mk',],
'останатите'=>['mk',],
'остане'=>['bg','mk',],
'останете'=>['mk',],
'останеш'=>['bg','mk',],
'остани'=>['mk',],
'остановить'=>['ru',],
'остаться'=>['ru',],
'осторожно'=>['ru',],
'осы'=>['kk',],
'осында'=>['kk',],
'осындағы'=>['kk',],
'осыны'=>['kk',],
'от'=>['bg','ko','ru',],
'ответ'=>['ru',],
'отвори'=>['bg','mk',],
'отдавна'=>['bg',],
'отец'=>['ru',],
'отзад'=>['bg',],
'отива'=>['bg',],
'отивам'=>['bg',],
'отиваме'=>['bg',],
'отиваш'=>['bg',],
'отида'=>['bg',],
'отиде'=>['bg','mk',],
'отидем'=>['bg',],
'отидеш'=>['bg',],
'откако'=>['mk',],
'откакто'=>['bg',],
'отколкото'=>['bg',],
'отколку'=>['mk',],
'откуда'=>['ru',],
'откъде'=>['bg',],
'отлично'=>['ru',],
'отново'=>['bg',],
'отношения'=>['ru',],
'отсюда'=>['ru',],
'оттуда'=>['ru',],
'оттук'=>['bg',],
'отца'=>['ru',],
'отыр'=>['kk',],
'отырмасаң'=>['kk',],
'отырмын'=>['kk',],
'отырып'=>['kk',],
'отырған'=>['kk',],
'отырғаным'=>['kk',],
'ох'=>['bg','ko','mk','ru',],
'очевидно'=>['bg',],
'очень'=>['ko','ru',],
'очи'=>['bg','mk',],
'очигледно'=>['mk',],
'очите'=>['bg','mk',],
'още'=>['bg',],
'ояттырады'=>['kk',],
'оған'=>['kk',],
'оқиғалар'=>['kk',],
'оқиғаларды'=>['kk',],
'оқиғалармен'=>['kk',],
'оқиғаларға'=>['kk',],
'па'=>['be','kk','mk',],
'пабачыш'=>['be',],
'пабудзіць'=>['be',],
'паведамленняў'=>['be',],
'паведамлю'=>['be',],
'паведаміць'=>['be',],
'паверыш'=>['be',],
'павук'=>['be',],
'павука'=>['be',],
'павысілі'=>['be',],
'павінен'=>['be',],
'павінна'=>['be',],
'пагледзем'=>['be',],
'паглядзі'=>['be',],
'пагналі'=>['be',],
'пад'=>['be',],
'падабаюцца'=>['be',],
'падай'=>['be',],
'падвойшчыка'=>['be',],
'падобны'=>['be',],
'падрыхтавацца'=>['be',],
'падымай'=>['be',],
'паехаў'=>['be',],
'пажадае'=>['be',],
'пажадаеце'=>['be',],
'пазбавіцца'=>['be',],
'пази'=>['bg','mk',],
'пазіцыяй'=>['be',],
'пайда'=>['kk',],
'пак'=>['bg','mk',],
'пакуль'=>['be',],
'пакутлівая'=>['be',],
'пакінце'=>['be',],
'палове'=>['be',],
'палову'=>['be',],
'паловы'=>['be',],
'паліцыянтаў'=>['be',],
'памерці'=>['be',],
'памрэш'=>['be',],
'памярла'=>['be',],
'памятаеш'=>['be',],
'памятаю'=>['be',],
'памяць'=>['be',],
'памяці'=>['be',],
'папа'=>['ru',],
'папаны'=>['kk',],
'папярэджанне'=>['be',],
'парадзілі'=>['be',],
'паранормалды'=>['kk',],
'парень'=>['ru',],
'пари'=>['bg','mk',],
'парите'=>['bg','mk',],
'парни'=>['ru',],
'парня'=>['ru',],
'пароль'=>['be',],
'пару'=>['ru',],
'паслухай'=>['be',],
'пасля'=>['be',],
'паспрабую'=>['be',],
'пастаноўшчык'=>['be',],
'пасіфік'=>['be',],
'пат'=>['mk',],
'пати'=>['mk',],
'патот'=>['mk',],
'патрабуецца'=>['be',],
'патрабуюць'=>['be',],
'патрэбна'=>['be',],
'патрэбны'=>['be',],
'патурбаваць'=>['be',],
'патшалардың'=>['kk',],
'пациентім'=>['kk',],
'пацукі'=>['be',],
'пачалі'=>['be',],
'пачатак'=>['be',],
'пачнем'=>['be',],
'пачнеццца'=>['be',],
'пашанцуе'=>['be',],
'пашпарт'=>['be',],
'пашукаць'=>['be',],
'пашырэння'=>['be',],
'пе'=>['kk',],
'педофил'=>['kk',],
'пекін'=>['be',],
'пекіне'=>['be',],
'пекіну'=>['be',],
'пемакс'=>['be',],
'пен'=>['kk',],
'перавезці'=>['be',],
'перавышайце'=>['be',],
'перагружаны'=>['be',],
'перадача'=>['be',],
'пераклад'=>['be',],
'пераменным'=>['be',],
'перамовы'=>['be',],
'ператварыць'=>['be',],
'первый'=>['ru',],
'пердольным'=>['be',],
'перед'=>['ru',],
'перестань'=>['ru',],
'першага'=>['be',],
'першым'=>['be',],
'першыню'=>['be',],
'песна'=>['mk',],
'пет'=>['bg','mk',],
'пиво'=>['mk',],
'пистолет'=>['ru',],
'письмо'=>['ru',],
'питам'=>['bg',],
'питер'=>['mk',],
'пич'=>['bg',],
'пише'=>['bg',],
'пиштол'=>['mk',],
'пиштолот'=>['mk',],
'пишува'=>['mk',],
'план'=>['bg','mk','ru',],
'планеталықтар'=>['kk',],
'планот'=>['mk',],
'плашам'=>['mk',],
'плашиш'=>['mk',],
'плохо'=>['ru',],
'плошчу'=>['be',],
'плюс'=>['be',],
'по'=>['bg','ko','mk','ru',],
'победи'=>['mk',],
'побрзај'=>['mk',],
'побрзо'=>['mk',],
'побързай'=>['bg',],
'повезло'=>['ru',],
'поверить'=>['ru',],
'повече'=>['bg',],
'повечето'=>['bg',],
'повеќе'=>['mk',],
'повторно'=>['mk',],
'повярвам'=>['bg',],
'погледнете'=>['mk',],
'погледни'=>['bg','mk',],
'поговорим'=>['bg','ru',],
'поговорить'=>['ru',],
'погоди'=>['ru',],
'погрешно'=>['mk',],
'под'=>['bg','ko','mk','ru',],
'подарок'=>['ru',],
'подарък'=>['bg',],
'подготвен'=>['mk',],
'подобро'=>['mk',],
'подожди'=>['ru',],
'подождите'=>['ru',],
'подоцна'=>['mk',],
'подумал'=>['ru',],
'подумать'=>['ru',],
'поехали'=>['ru',],
'пожаловать'=>['ru',],
'пожалуйста'=>['ko','ru',],
'позади'=>['mk',],
'позвольте'=>['ru',],
'позвонить'=>['ru',],
'поздно'=>['ru',],
'позже'=>['ru',],
'познавам'=>['bg','mk',],
'познаваш'=>['bg',],
'пойдем'=>['ru',],
'пойдзем'=>['be',],
'пойду'=>['ru',],
'пойдём'=>['ru',],
'пойти'=>['ru',],
'пока'=>['ko','ru',],
'покажа'=>['bg',],
'покажам'=>['mk',],
'покажи'=>['bg','mk',],
'показать'=>['ru',],
'покрај'=>['mk',],
'пол'=>['mk','ru',],
'полагаю'=>['ru',],
'полека'=>['mk',],
'полицаец'=>['mk',],
'полицай'=>['bg',],
'полицейлік'=>['kk',],
'полицейліксіз'=>['kk',],
'полиции'=>['ru',],
'полиция'=>['kk','ru',],
'полицията'=>['bg',],
'полиција'=>['mk',],
'полицијата'=>['mk',],
'полностью'=>['ru',],
'половина'=>['mk',],
'получи'=>['bg',],
'получил'=>['ru',],
'получить'=>['ru',],
'помалку'=>['mk',],
'помеѓу'=>['mk',],
'помина'=>['mk',],
'помисли'=>['bg',],
'помислих'=>['bg',],
'помниш'=>['bg',],
'помнишь'=>['ru',],
'помню'=>['ru',],
'помня'=>['bg',],
'помоги'=>['ru',],
'помогите'=>['ru',],
'помогна'=>['bg',],
'помогнам'=>['mk',],
'помогне'=>['bg','mk',],
'помогнете'=>['bg','mk',],
'помогнеш'=>['bg','mk',],
'помогни'=>['bg','mk',],
'поможет'=>['ru',],
'помочь'=>['ko','ru',],
'помош'=>['mk',],
'помощ'=>['bg',],
'помощь'=>['ru',],
'поне'=>['bg',],
'понекогаш'=>['mk',],
'понимаете'=>['ru',],
'понимаешь'=>['ru',],
'понимаю'=>['ko','ru',],
'понякога'=>['bg',],
'понял'=>['ru',],
'поняла'=>['ru',],
'понятно'=>['ru',],
'понять'=>['ru',],
'пор'=>['ru',],
'пора'=>['ru',],
'поради'=>['mk',],
'порака'=>['mk',],
'порано'=>['mk',],
'портрет'=>['ko',],
'порядке'=>['ru',],
'посебно'=>['mk',],
'после'=>['bg','ko','mk','ru',],
'последен'=>['mk',],
'последната'=>['bg',],
'последнее'=>['ru',],
'последние'=>['ru',],
'последний'=>['ru',],
'последниот'=>['mk',],
'последните'=>['bg',],
'послушай'=>['ru',],
'послушайте'=>['ru',],
'посмотреть'=>['ru',],
'посмотри'=>['ru',],
'посмотрим'=>['ru',],
'посмотрите'=>['ru',],
'поспехам'=>['be',],
'постои'=>['mk',],
'постоянно'=>['bg','ru',],
'постојано'=>['mk',],
'потерял'=>['ru',],
'потоа'=>['mk',],
'потом'=>['ru',],
'потому'=>['ko','ru',],
'потреба'=>['mk',],
'потребно'=>['mk',],
'похоже'=>['ru',],
'почакай'=>['bg',],
'почекај'=>['mk',],
'почему'=>['ko','ru',],
'почеток'=>['mk',],
'почти'=>['bg','ru',],
'пошел'=>['ru',],
'пошли'=>['ru',],
'пошуках'=>['be',],
'пошёл'=>['ru',],
'поэтому'=>['ru',],
'појави'=>['mk',],
'поўнае'=>['be',],
'пра'=>['be',],
'прабач'=>['be',],
'прабачце'=>['be',],
'праблема'=>['be',],
'праблемаў'=>['be',],
'прав'=>['bg','ru',],
'права'=>['be','bg','ru',],
'правам'=>['mk',],
'прават'=>['mk',],
'правда'=>['ko','ru',],
'правду'=>['ru',],
'прави'=>['bg','mk',],
'правилно'=>['bg',],
'правильно'=>['ru',],
'правим'=>['bg',],
'правиме'=>['mk',],
'правите'=>['bg','mk',],
'правиш'=>['bg','mk',],
'право'=>['bg','mk','ru',],
'правя'=>['bg',],
'правят'=>['bg',],
'прагляду'=>['be',],
'прадакшнс'=>['be',],
'прадзюсар'=>['be',],
'прадзюсер'=>['be',],
'прадзюсеры'=>['be',],
'прадстаўляюць'=>['be',],
'праз'=>['be',],
'прасілі'=>['be',],
'прати'=>['mk',],
'працаваць'=>['be',],
'працечка'=>['be',],
'працу'=>['be',],
'працуем'=>['be',],
'працую'=>['be',],
'працуюць'=>['be',],
'працуючых'=>['be',],
'працы'=>['be',],
'працягвай'=>['be',],
'працягласці'=>['be',],
'прашам'=>['mk',],
'прашања'=>['mk',],
'прашање'=>['mk',],
'прашувам'=>['mk',],
'праінфармаваў'=>['be',],
'прв'=>['mk',],
'прва'=>['mk',],
'првата'=>['mk',],
'првиот'=>['mk',],
'прво'=>['mk',],
'превод'=>['bg','mk',],
'пред'=>['bg','mk',],
'предвид'=>['bg',],
'преди'=>['bg',],
'предполагам'=>['bg',],
'представа'=>['bg',],
'представить'=>['ru',],
'представя'=>['bg',],
'прежде'=>['ru',],
'през'=>['bg',],
'президент'=>['ru',],
'прекалено'=>['bg',],
'прекрасен'=>['mk',],
'прекрасна'=>['mk',],
'прекрасно'=>['bg','mk','ru',],
'прекрати'=>['ru',],
'преку'=>['mk',],
'премногу'=>['mk',],
'престани'=>['bg','mk',],
'претпоставувам'=>['mk',],
'при'=>['bg','ru',],
'привет'=>['ru',],
'придется'=>['ru',],
'придётся'=>['ru',],
'приехал'=>['ru',],
'приказна'=>['mk',],
'прилича'=>['bg',],
'пример'=>['mk',],
'принстон'=>['kk',],
'притеснявай'=>['bg',],
'причина'=>['bg','mk',],
'пришел'=>['ru',],
'пришла'=>['ru',],
'пришли'=>['ru',],
'пришлось'=>['ru',],
'приятел'=>['bg',],
'приятели'=>['bg',],
'приятелите'=>['bg',],
'приятелка'=>['bg',],
'приятель'=>['ru',],
'приятелю'=>['bg',],
'приятно'=>['bg','ko','ru',],
'пријател'=>['mk',],
'пријателе'=>['mk',],
'пријатели'=>['mk',],
'про'=>['ru',],
'проблем'=>['bg','mk','ru',],
'проблема'=>['bg','ru',],
'проблеми'=>['bg','mk',],
'проблемот'=>['mk',],
'проблемы'=>['ru',],
'продолжи'=>['mk',],
'продължавай'=>['bg',],
'произошло'=>['ru',],
'происходит'=>['ru',],
'проклетство'=>['mk',],
'промени'=>['bg',],
'проста'=>['be',],
'прости'=>['ko','mk','ru',],
'простите'=>['ko','ru',],
'просто'=>['bg','ko','ru',],
'прота'=>['be',],
'против'=>['bg','mk','ru',],
'профессор'=>['ru',],
'прошло'=>['ru',],
'прошу'=>['ko','ru',],
'прощения'=>['ko','ru',],
'пры'=>['be',],
'прыбіральня'=>['be',],
'прыватным'=>['be',],
'прызначаюць'=>['be',],
'прыйшоў'=>['be',],
'прылада'=>['be',],
'прыладу'=>['be',],
'прылады'=>['be',],
'прымальніку'=>['be',],
'прыняты'=>['be',],
'прычына'=>['be',],
'прычыны'=>['be',],
'прямо'=>['ru',],
'пука'=>['bg',],
'пуснете'=>['bg',],
'пусни'=>['bg',],
'пусть'=>['ko','ru',],
'пути'=>['ru',],
'путь'=>['ru',],
'пушти'=>['mk',],
'пък'=>['bg',],
'първата'=>['bg',],
'първи'=>['bg',],
'първия'=>['bg',],
'първо'=>['bg',],
'път'=>['bg',],
'пъти'=>['bg',],
'пътя'=>['bg',],
'пытался'=>['ru',],
'пытанне'=>['be',],
'пытаюсь'=>['ru',],
'пэўна'=>['be',],
'пярэрвана'=>['be',],
'пять'=>['ru',],
'піраты'=>['be',],
'пітэр'=>['be',],
'р'=>['bg','mk','ru',],
'рavola'=>['sr',],
'раблю'=>['be',],
'работа'=>['bg','mk','ru',],
'работает'=>['ru',],
'работам'=>['mk',],
'работата'=>['bg','mk',],
'работать'=>['ru',],
'работаю'=>['ru',],
'работе'=>['ru',],
'работи'=>['bg','mk',],
'работите'=>['mk',],
'работиш'=>['bg','mk',],
'работу'=>['ru',],
'работы'=>['ru',],
'работя'=>['bg',],
'рабі'=>['be',],
'рабіце'=>['be',],
'рабіць'=>['be',],
'равно'=>['ru',],
'рад'=>['ru',],
'рада'=>['ru',],
'радвам'=>['bg',],
'ради'=>['ru',],
'раз'=>['be','ko','ru',],
'разам'=>['be',],
'разбера'=>['bg',],
'разбере'=>['bg',],
'разбереш'=>['bg',],
'разбира'=>['bg','mk',],
'разбирам'=>['bg','mk',],
'разбирате'=>['bg',],
'разбираш'=>['bg','mk',],
'разбра'=>['bg',],
'разбрах'=>['bg',],
'разбуди'=>['mk',],
'разве'=>['ru',],
'развітваецца'=>['be',],
'разговарам'=>['mk',],
'разговараме'=>['mk',],
'разгрузкі'=>['be',],
'разгрузцы'=>['be',],
'разгрузіць'=>['be',],
'разкарай'=>['bg',],
'разлика'=>['mk',],
'различни'=>['bg',],
'размаўлялі'=>['be',],
'разумеется'=>['ko',],
'разумееш'=>['be',],
'рака'=>['mk',],
'раката'=>['mk',],
'ральфі'=>['be',],
'раней'=>['be',],
'ранка'=>['be',],
'ранку'=>['be',],
'рано'=>['bg','ru',],
'раньше'=>['ru',],
'раніцы'=>['be',],
'расплаціцца'=>['be',],
'рассказать'=>['ru',],
'рахмет'=>['kk',],
'раце'=>['mk',],
'рацете'=>['mk',],
'ребенка'=>['ru',],
'ребенок'=>['ru',],
'ребята'=>['ru',],
'ред'=>['bg','mk',],
'реков'=>['mk',],
'рекол'=>['mk',],
'речам'=>['mk',],
'рече'=>['mk',],
'решение'=>['ru',],
'решил'=>['ru',],
'ричмонд'=>['kk',],
'роберт'=>['be',],
'роберта'=>['be',],
'робяць'=>['be',],
'робіш'=>['be',],
'роденден'=>['mk',],
'родзіс'=>['be',],
'родители'=>['mk','ru',],
'родителите'=>['bg',],
'рождения'=>['ru',],
'ролі'=>['be',],
'ролінз'=>['be',],
'роман'=>['ko',],
'рональд'=>['be',],
'роўна'=>['be',],
'руках'=>['ru',],
'руки'=>['ru',],
'руку'=>['be','ru',],
'рухацца'=>['be',],
'руху'=>['be',],
'руінах'=>['be',],
'ръка'=>['bg',],
'ръката'=>['bg',],
'ръце'=>['bg',],
'ръцете'=>['bg',],
'рыба'=>['be',],
'рыюць'=>['be',],
'рыўз'=>['be',],
'рэжысёр'=>['be',],
'рэйс'=>['be',],
'рэк'=>['be',],
'рядом'=>['ru',],
'с'=>['bg','ko','ru',],
'са'=>['be','bg','sr',],
'сабе'=>['be',],
'садись'=>['ru',],
'сака'=>['mk',],
'сакаат'=>['mk',],
'сакав'=>['mk',],
'сакал'=>['mk',],
'сакала'=>['mk',],
'сакам'=>['mk',],
'сакаме'=>['mk',],
'сакате'=>['mk',],
'сакаш'=>['mk',],
'сакаше'=>['mk',],
'салынған'=>['kk',],
'сам'=>['be','bg','mk','ru','sr',],
'сама'=>['bg','mk','ru',],
'самалёт'=>['be',],
'самая'=>['ru',],
'сами'=>['bg','ru',],
'самиот'=>['mk',],
'само'=>['bg','mk',],
'самого'=>['ru',],
'самое'=>['ru',],
'самом'=>['ru',],
'самую'=>['be',],
'самый'=>['ru',],
'самыя'=>['be',],
'самі'=>['be',],
'санаймыз'=>['kk',],
'санайсыз'=>['kk',],
'сандхофф'=>['kk',],
'сандырақ'=>['kk',],
'сандырақтап'=>['kk',],
'сандыраққа'=>['kk',],
'сандэрс'=>['be',],
'санкцыянавана'=>['be',],
'сапраўдныя'=>['be',],
'сапраўды'=>['be',],
'сапсуюцца'=>['be',],
'сара'=>['bg',],
'саған'=>['kk',],
'сағатта'=>['kk',],
'сағаттан'=>['kk',],
'сақтайсыз'=>['kk',],
'сақтап'=>['kk',],
'сақтығын'=>['kk',],
'свае'=>['be',],
'свайго'=>['be',],
'сваю'=>['be',],
'сваё'=>['be',],
'сваёй'=>['be',],
'свет'=>['mk','ru',],
'света'=>['bg',],
'светот'=>['mk',],
'свидания'=>['ru',],
'свое'=>['ru',],
'своего'=>['ru',],
'своей'=>['ru',],
'своето'=>['mk',],
'свои'=>['ko','ru',],
'своим'=>['ru',],
'своими'=>['ru',],
'своите'=>['mk',],
'своих'=>['ru',],
'свой'=>['ko','ru',],
'свою'=>['ru',],
'своя'=>['bg',],
'своё'=>['ru',],
'својата'=>['mk',],
'својот'=>['mk',],
'свърши'=>['bg',],
'связи'=>['ru',],
'свят'=>['bg',],
'святар'=>['be',],
'сделаем'=>['ru',],
'сделай'=>['ru',],
'сделал'=>['ru',],
'сделала'=>['ru',],
'сделали'=>['ru',],
'сделать'=>['ko','ru',],
'сделаю'=>['ru',],
'се'=>['bg','mk','ru','sr',],
'себе'=>['bg','mk','ru',],
'себебі'=>['kk',],
'себеси'=>['mk',],
'себя'=>['ko','ru',],
'севя'=>['ko',],
'сега'=>['bg','mk',],
'сегодня'=>['ko','ru',],
'седи'=>['mk',],
'седмица'=>['bg',],
'седмици'=>['bg',],
'седни'=>['bg','mk',],
'сезім'=>['kk',],
'сезімсіз'=>['kk',],
'сезімталдықты'=>['kk',],
'сезіміңіз'=>['kk',],
'сезіп'=>['kk',],
'сейчас'=>['ko','ru',],
'секако'=>['mk',],
'секогаш'=>['mk',],
'секој'=>['mk',],
'секоја'=>['mk',],
'секс'=>['bg','mk',],
'секунда'=>['bg','mk',],
'секунди'=>['bg','mk',],
'секунду'=>['ru',],
'сем'=>['mk',],
'семейство'=>['bg',],
'семейството'=>['bg',],
'семејство'=>['mk',],
'семь'=>['ru',],
'семьи'=>['ru',],
'семья'=>['ru',],
'сен'=>['kk',],
'сенбеймін'=>['kk',],
'сенбеуіміз'=>['kk',],
'сенгім'=>['kk',],
'сендер'=>['kk',],
'сендердің'=>['kk',],
'сендірудің'=>['kk',],
'сенеді'=>['kk',],
'сенемін'=>['kk',],
'сенер'=>['kk',],
'сенесіз'=>['kk',],
'сенетіп'=>['kk',],
'сеннен'=>['kk',],
'сені'=>['kk',],
'сенікі'=>['kk',],
'сенімділікте'=>['kk',],
'сенімен'=>['kk',],
'сеніміңізге'=>['kk',],
'сеніп'=>['kk',],
'сенің'=>['kk',],
'сепак'=>['mk',],
'сер'=>['mk',],
'серверу'=>['be',],
'сердце'=>['ru',],
'сериозно'=>['bg','mk',],
'серьезно'=>['ru',],
'сестра'=>['bg','mk','ru',],
'сетку'=>['be',],
'сето'=>['mk',],
'сеуште'=>['mk',],
'сеќавам'=>['mk',],
'сеќаваш'=>['mk',],
'си'=>['bg','mk','sr',],
'сигурен'=>['bg','mk',],
'сигурна'=>['bg','mk',],
'сигурно'=>['bg','mk',],
'сигурност'=>['bg',],
'сила'=>['bg','mk',],
'силно'=>['bg',],
'сильно'=>['ru',],
'син'=>['bg','mk',],
'сина'=>['bg',],
'сине'=>['mk',],
'синко'=>['bg','mk',],
'синоќа'=>['mk',],
'синът'=>['bg',],
'сирек'=>['kk',],
'систем'=>['mk',],
'сите'=>['mk',],
'сих'=>['ru',],
'сияқты'=>['kk',],
'сияқтымын'=>['kk',],
'скажешь'=>['ru',],
'скажи'=>['ru',],
'скажите'=>['ru',],
'скажу'=>['be','ru',],
'скажы'=>['be',],
'сказал'=>['ko','ru',],
'сказала'=>['ru',],
'сказали'=>['ru',],
'сказалі'=>['be',],
'сказать'=>['ru',],
'сказаць'=>['be',],
'сказаў'=>['be',],
'скалли'=>['kk',],
'скарыстаюся'=>['be',],
'скиннер'=>['kk',],
'сколько'=>['ru',],
'скончаны'=>['be',],
'скорее'=>['ru',],
'скоро'=>['bg','mk','ru',],
'скъпа'=>['bg',],
'скъпи'=>['bg',],
'слатко'=>['mk',],
'след'=>['bg',],
'следващата'=>['bg',],
'следващия'=>['bg',],
'следи'=>['mk',],
'следниот'=>['mk',],
'следует'=>['ru',],
'следующий'=>['ru',],
'слика'=>['mk',],
'слично'=>['mk',],
'слишком'=>['ko','ru',],
'слова'=>['ru',],
'слово'=>['ru',],
'словы'=>['be',],
'сложи'=>['bg',],
'слухай'=>['be',],
'слухалку'=>['be',],
'слухаю'=>['be',],
'случае'=>['ru',],
'случай'=>['bg','ru',],
'случај'=>['mk',],
'случва'=>['bg',],
'случи'=>['bg','mk',],
'случило'=>['bg','mk',],
'случилось'=>['ru',],
'случува'=>['mk',],
'слушай'=>['bg','ru',],
'слушайте'=>['ru',],
'слушам'=>['bg','mk',],
'слушаш'=>['mk',],
'слушај'=>['mk',],
'слушајте'=>['mk',],
'слушна'=>['mk',],
'слушнав'=>['mk',],
'слушни'=>['mk',],
'слышал'=>['ru',],
'слышала'=>['ru',],
'слышишь'=>['ru',],
'слышу'=>['ru',],
'сме'=>['bg','mk',],
'смееш'=>['mk',],
'смерти'=>['ru',],
'смерть'=>['ru',],
'смецце'=>['be',],
'смешно'=>['bg','mk','ru',],
'смири'=>['mk',],
'смисъл'=>['bg',],
'смог'=>['ru',],
'смогу'=>['ru',],
'сможем'=>['ru',],
'сможет'=>['ru',],
'сможешь'=>['ru',],
'смотреть'=>['ru',],
'смотри'=>['ru',],
'смотрите'=>['ru',],
'смрт'=>['mk',],
'смртта'=>['mk',],
'смърт'=>['bg',],
'смъртта'=>['bg',],
'смысле'=>['ko','ru',],
'смяротнанебяспечная'=>['be',],
'сміт'=>['be',],
'сначала'=>['ru',],
'снова'=>['ru',],
'снощи'=>['bg',],
'снс'=>['be',],
'со'=>['ko','mk','ru',],
'соба'=>['mk',],
'собата'=>['mk',],
'собираешься'=>['ru',],
'собираюсь'=>['ru',],
'собой'=>['ru',],
'совершенно'=>['ru',],
'совршено'=>['mk',],
'совсем'=>['ko','ru',],
'сол'=>['kk',],
'солай'=>['kk',],
'сомерсет'=>['kk',],
'сон'=>['mk','ru',],
'сонда'=>['kk',],
'сондай'=>['kk',],
'соны'=>['kk',],
'сосема'=>['mk',],
'состанок'=>['mk',],
'соған'=>['kk',],
'соңғы'=>['kk',],
'спадарожнікавыя'=>['be',],
'спазняецца'=>['be',],
'спазняйся'=>['be',],
'спазніліся'=>['be',],
'спазніўся'=>['be',],
'спаси'=>['bg','mk',],
'спасибо'=>['ko','ru',],
'спасиво'=>['ko',],
'спасти'=>['ru',],
'спать'=>['ru',],
'спачатку'=>['be',],
'спачування'=>['be',],
'спокойно'=>['bg','ru',],
'спокойной'=>['ru',],
'спомням'=>['bg',],
'според'=>['bg','mk',],
'спосаб'=>['be',],
'способ'=>['ru',],
'споўнена'=>['be',],
'справа'=>['be',],
'спре'=>['bg',],
'спремен'=>['mk',],
'спрете'=>['bg',],
'спри'=>['bg',],
'спросить'=>['ru',],
'спушти'=>['mk',],
'сразу'=>['ru',],
'срање'=>['mk',],
'средам'=>['mk',],
'среди'=>['mk','ru',],
'среща'=>['bg',],
'срещу'=>['bg',],
'среќа'=>['mk',],
'среќен'=>['mk',],
'среќна'=>['mk',],
'сродкі'=>['be',],
'срце'=>['mk',],
'срцето'=>['mk',],
'става'=>['bg',],
'ставай'=>['bg',],
'ставам'=>['mk',],
'стави'=>['mk',],
'стагоддзе'=>['be',],
'стал'=>['ru',],
'стала'=>['ru',],
'стали'=>['ru',],
'стало'=>['ru',],
'стамаңдар'=>['kk',],
'стана'=>['bg','mk',],
'станало'=>['bg',],
'стане'=>['be','bg',],
'станет'=>['ru',],
'станува'=>['mk',],
'стар'=>['bg','mk',],
'старый'=>['ru',],
'старых'=>['be',],
'стать'=>['ru',],
'стафан'=>['be',],
'стая'=>['bg',],
'стаята'=>['bg',],
'стварно'=>['mk',],
'сте'=>['bg','mk',],
'стига'=>['bg',],
'стоит'=>['ko','ru',],
'стой'=>['bg','ru',],
'столько'=>['ru',],
'стомы'=>['be',],
'сторам'=>['mk',],
'стори'=>['mk',],
'сторону'=>['ru',],
'стороны'=>['ru',],
'стој'=>['mk',],
'страв'=>['mk',],
'страйк'=>['be',],
'страна'=>['bg','mk',],
'страната'=>['bg',],
'странно'=>['bg','ru',],
'страх'=>['bg',],
'страхотно'=>['bg',],
'страце'=>['be',],
'страціць'=>['be',],
'страшно'=>['ru',],
'струва'=>['bg',],
'су'=>['sr',],
'сувязь'=>['be',],
'сувязі'=>['be',],
'сукава'=>['be',],
'сум'=>['mk',],
'сумна'=>['be',],
'сумны'=>['be',],
'сумняваюся'=>['be',],
'супакойся'=>['be',],
'супакоюся'=>['be',],
'супер'=>['bg','mk',],
'супервізійны'=>['be',],
'супольна'=>['be',],
'супраць'=>['be',],
'супрацьстаяць'=>['be',],
'супыніліся'=>['be',],
'супэр'=>['be',],
'сусвет'=>['be',],
'сусветныя'=>['be',],
'сустрэцца'=>['be',],
'сустрэчу'=>['be',],
'сутрин'=>['bg',],
'сутринта'=>['bg',],
'сутыкненнях'=>['be',],
'существует'=>['ru',],
'схаджу'=>['be',],
'схапіць'=>['be',],
'сховішчамі'=>['be',],
'сценах'=>['be',],
'сцэнар'=>['be',],
'събуди'=>['bg',],
'съвсем'=>['bg',],
'съжалявам'=>['bg',],
'съм'=>['bg',],
'съобщение'=>['bg',],
'съпруга'=>['bg',],
'сър'=>['bg',],
'сърце'=>['bg',],
'сърцето'=>['bg',],
'със'=>['bg',],
'също'=>['bg',],
'същото'=>['bg',],
'сыйлығым'=>['kk',],
'сын'=>['ru',],
'сына'=>['ru',],
'сынок'=>['ru',],
'сырам'=>['be',],
'сэм'=>['ru',],
'сэр'=>['be','ru',],
'сюда'=>['ru',],
'сюды'=>['be',],
'сябе'=>['be',],
'сябра'=>['be',],
'сядай'=>['be',],
'сядзіць'=>['be',],
'сякаш'=>['bg',],
'сіз'=>['kk',],
'сізбен'=>['kk',],
'сізге'=>['kk',],
'сізде'=>['kk',],
'сізді'=>['kk',],
'сіздің'=>['kk',],
'сілах'=>['be',],
'сілікона'=>['be',],
'сінаптычная'=>['be',],
'сіндзі'=>['be',],
'сіндром'=>['be',],
'сіндромам'=>['be',],
'сістэмай'=>['be',],
'сістэму'=>['be',],
'сістэмы'=>['be',],
'сітуацыі'=>['be',],
'сүйер'=>['kk',],
'сүйрей'=>['kk',],
'сүю'=>['kk',],
'сұмырай'=>['kk',],
'сұрайын'=>['kk',],
'сұрап'=>['kk',],
'сұрау'=>['kk',],
'сұрағанын'=>['kk',],
'сұрағы'=>['kk',],
'сұрақ'=>['kk',],
'сәлем'=>['kk',],
'сөзіне'=>['kk',],
'сөйлейсіз'=>['kk',],
'сөйлесуге'=>['kk',],
'т'=>['mk',],
'та'=>['bg','ru',],
'таа'=>['mk',],
'таба'=>['kk',],
'табады'=>['kk',],
'табасыз'=>['kk',],
'табатындарың'=>['kk',],
'табе'=>['be',],
'табой'=>['be',],
'табуымыз'=>['kk',],
'табылады'=>['kk',],
'табылатын'=>['kk',],
'табылды'=>['kk',],
'табылған'=>['kk',],
'тавар'=>['be',],
'таго'=>['be',],
'тады'=>['be',],
'тази'=>['bg',],
'тайыз'=>['kk',],
'так'=>['be','ko','ru',],
'така'=>['bg','mk',],
'такава'=>['bg',],
'такахасі'=>['be',],
'такая'=>['ru',],
'таква'=>['mk',],
'такви'=>['mk',],
'такво'=>['mk',],
'также'=>['ru',],
'таки'=>['ru',],
'такива'=>['bg',],
'такие'=>['ru',],
'таким'=>['ru',],
'таких'=>['ru',],
'таков'=>['mk',],
'такова'=>['bg',],
'такого'=>['ru',],
'такое'=>['ko','ru',],
'такой'=>['ko','ru',],
'таком'=>['ru',],
'таксама'=>['be',],
'таксісту'=>['be',],
'такую'=>['ru',],
'такъв'=>['bg',],
'такэсі'=>['be',],
'такі'=>['be',],
'такія'=>['be',],
'талшықты'=>['kk',],
'талқыладым'=>['kk',],
'там'=>['be','bg','ko','ru',],
'таму'=>['be','mk',],
'танисыз'=>['kk',],
'танней'=>['be',],
'танысайын'=>['kk',],
'таныспын'=>['kk',],
'таппай'=>['kk',],
'тапсырамыз'=>['kk',],
'таптым'=>['kk',],
'таптық'=>['kk',],
'таптыңыз'=>['kk',],
'тапчан'=>['be',],
'таралуы'=>['kk',],
'таста'=>['kk',],
'тастадым'=>['kk',],
'тастайды'=>['kk',],
'тастама'=>['kk',],
'тастаңыз'=>['kk',],
'тате'=>['bg',],
'татко'=>['bg','mk',],
'тато'=>['mk',],
'тауып'=>['kk',],
'тауьымыз'=>['kk',],
'тая'=>['bg',],
'тајна'=>['mk',],
'тағы'=>['kk',],
'тағылған'=>['kk',],
'твае'=>['be',],
'твайго'=>['be',],
'тварыцца'=>['be',],
'тваю'=>['be',],
'твая'=>['be',],
'тваёй'=>['be',],
'твое'=>['mk','ru',],
'твоего'=>['ru',],
'твоей'=>['ru',],
'твоему'=>['ru',],
'твоето'=>['bg','mk',],
'твои'=>['ko','ru',],
'твоим'=>['ru',],
'твоите'=>['bg','mk',],
'твоих'=>['ru',],
'твой'=>['be','bg','ko','ru',],
'твору'=>['be',],
'твою'=>['ru',],
'твоя'=>['bg','ru',],
'твоят'=>['bg',],
'твоята'=>['bg',],
'твоё'=>['ru',],
'твој'=>['mk',],
'твоја'=>['mk',],
'твојата'=>['mk',],
'твојот'=>['mk',],
'твърде'=>['bg',],
'твід'=>['be',],
'те'=>['bg','mk','ru',],
'теб'=>['bg',],
'тебе'=>['ko','mk','ru',],
'тебя'=>['ko','ru',],
'теве'=>['ko',],
'тевя'=>['ko',],
'тез'=>['kk',],
'тези'=>['bg',],
'тек'=>['kk',],
'тексеру'=>['kk',],
'тексеруге'=>['kk',],
'тексеруім'=>['kk',],
'тексеріп'=>['kk',],
'телефон'=>['kk','mk','ru',],
'телефона'=>['bg',],
'телефонот'=>['mk',],
'тело'=>['mk','ru',],
'телото'=>['mk',],
'тем'=>['ru',],
'тео'=>['ko',],
'теперь'=>['ko','ru',],
'терапия'=>['kk',],
'терең'=>['kk',],
'тех'=>['ru',],
'тешко'=>['mk',],
'ти'=>['bg','mk','ru','sr',],
'тие'=>['mk',],
'тим'=>['mk',],
'тип'=>['bg','mk',],
'типа'=>['ru',],
'типот'=>['mk',],
'тихо'=>['bg','ru',],
'тиым'=>['kk',],
'тия'=>['bg',],
'тиісіп'=>['kk',],
'то'=>['be','bg','ko','ru','sr',],
'тоа'=>['mk',],
'тобой'=>['ru',],
'това'=>['bg',],
'тогава'=>['bg',],
'тогаш'=>['mk',],
'тогда'=>['ko','ru',],
'того'=>['ru',],
'тое'=>['be',],
'тоже'=>['ko','ru',],
'този'=>['bg',],
'той'=>['be','bg','ru',],
'токму'=>['mk',],
'току'=>['bg',],
'токіё'=>['be',],
'толкова'=>['bg',],
'толку'=>['mk',],
'толығымен'=>['kk',],
'только'=>['ko','ru',],
'толькі'=>['be',],
'том'=>['bg','mk','ru',],
'томи'=>['mk',],
'тому'=>['ru',],
'тон'=>['be',],
'тони'=>['mk',],
'тот'=>['ru',],
'точно'=>['bg','ko','mk','ru',],
'тоя'=>['bg',],
'тој'=>['mk',],
'тоқта'=>['kk',],
'тоқтай'=>['kk',],
'тоқтайды'=>['kk',],
'тоқтама'=>['kk',],
'тоқтамай'=>['kk',],
'тоқтаңдар'=>['kk',],
'транквилизатор'=>['kk',],
'трапіць'=>['be',],
'тргнете'=>['mk',],
'тргни'=>['mk',],
'треба'=>['mk',],
'требаат'=>['mk',],
'требало'=>['mk',],
'требаше'=>['mk',],
'тревожи'=>['bg',],
'три'=>['bg','mk','ru',],
'трудно'=>['bg','ru',],
'тръгвай'=>['bg',],
'тръгвам'=>['bg',],
'тръгваме'=>['bg',],
'тръгна'=>['bg',],
'тры'=>['be',],
'трымае'=>['be',],
'трымаеш'=>['be',],
'трымай'=>['be',],
'трэба'=>['be',],
'трэйсі'=>['be',],
'трэцюю'=>['be',],
'трябва'=>['bg',],
'трябвало'=>['bg',],
'трябват'=>['bg',],
'трябваше'=>['bg',],
'ту'=>['ru',],
'туда'=>['ru',],
'туды'=>['be',],
'тук'=>['bg',],
'тука'=>['bg','mk',],
'туку'=>['mk',],
'туралы'=>['kk',],
'туралымаған'=>['kk',],
'турбаваць'=>['be',],
'турбуйся'=>['be',],
'турбую'=>['be',],
'тут'=>['be','ko','ru',],
'тъй'=>['bg',],
'тъкмо'=>['bg',],
'търси'=>['bg',],
'търся'=>['bg',],
'ты'=>['be','ko','ru',],
'тым'=>['be',],
'тыныш'=>['kk',],
'тып'=>['be',],
'тысяч'=>['ru',],
'тысячаў'=>['be',],
'тых'=>['be',],
'тыңдағысы'=>['kk',],
'тьi'=>['ru',],
'тэлевізар'=>['be',],
'тэлевізара'=>['be',],
'тэмпература'=>['be',],
'тэрмінова'=>['be',],
'тэхнічныя'=>['be',],
'тя'=>['bg',],
'тялото'=>['bg',],
'тях'=>['bg',],
'тіке'=>['kk',],
'тілді'=>['kk',],
'тілмен'=>['kk',],
'тіпті'=>['kk',],
'тірі'=>['kk',],
'тірімін'=>['kk',],
'түн'=>['kk',],
'түнде'=>['kk',],
'түрмеде'=>['kk',],
'түрімен'=>['kk',],
'түсінбедім'=>['kk',],
'түсінемін'=>['kk',],
'түсініксіз'=>['kk',],
'түсінікті'=>['kk',],
'түсір'=>['kk',],
'тұр'=>['kk',],
'тұрады'=>['kk',],
'тұрмын'=>['kk',],
'тұрсыз'=>['kk',],
'тұрыңдар'=>['kk',],
'тұрыңыз'=>['kk',],
'тұрған'=>['kk',],
'тұрғаным'=>['kk',],
'тәлтіректеттің'=>['kk',],
'тәурат'=>['kk',],
'төбелес'=>['kk',],
'төмен'=>['kk',],
'төсегіне'=>['kk',],
'төсегінен'=>['kk',],
'у'=>['be','bg','kk','ko','mk','ru','sr',],
'уақытта'=>['kk',],
'уақытты'=>['kk',],
'уақытымызды'=>['kk',],
'убав'=>['mk',],
'убава'=>['mk',],
'убаво'=>['mk',],
'уби'=>['bg','mk',],
'убие'=>['bg','mk',],
'убиец'=>['mk',],
'убиеш'=>['bg','mk',],
'убил'=>['bg','mk','ru',],
'убили'=>['ru',],
'убиство'=>['mk',],
'убить'=>['ru',],
'убия'=>['bg',],
'убиј'=>['mk',],
'убијам'=>['mk',],
'убијат'=>['mk',],
'ублюдок'=>['ru',],
'убью'=>['ru',],
'увага'=>['be',],
'уваход'=>['be',],
'уверен'=>['ru',],
'уверена'=>['ru',],
'увидел'=>['ru',],
'увидеть'=>['ru',],
'увидимся'=>['ru',],
'угодно'=>['ru',],
'уда'=>['be',],
'удар'=>['mk',],
'удари'=>['bg',],
'удачи'=>['ru',],
'удзельнічаюць'=>['be',],
'удоволствие'=>['bg',],
'удри'=>['mk',],
'уж'=>['ko','ru',],
'ужасно'=>['bg','ru',],
'уже'=>['ko','ru',],
'ужо'=>['be',],
'узвышаюцца'=>['be',],
'узнал'=>['ru',],
'узнать'=>['ru',],
'уйти'=>['ru',],
'уладамі'=>['be',],
'уладарства'=>['be',],
'уладаў'=>['be',],
'уласнага'=>['be',],
'уласцівасці'=>['be',],
'улица'=>['mk',],
'улицата'=>['bg',],
'улице'=>['ru',],
'ума'=>['ru',],
'умер'=>['ru',],
'умереть'=>['ru',],
'умерла'=>['ru',],
'умра'=>['bg',],
'умре'=>['bg','mk',],
'усе'=>['be',],
'усеагульная'=>['be',],
'услуга'=>['mk',],
'успеа'=>['mk',],
'успее'=>['mk',],
'успокой'=>['bg',],
'успокойся'=>['ru',],
'устата'=>['bg',],
'устаўце'=>['be',],
'усю'=>['be',],
'усё'=>['be',],
'усім'=>['be',],
'утре'=>['bg','mk',],
'утро'=>['bg','mk','ru',],
'утром'=>['ru',],
'уходи'=>['ru',],
'училиште'=>['mk',],
'училище'=>['bg',],
'уште'=>['mk',],
'файна'=>['be',],
'факс'=>['be',],
'факсе'=>['be',],
'фала'=>['mk',],
'фамилија'=>['mk',],
'фанмакому'=>['be',],
'фармаком'=>['be',],
'фармакомаўскага'=>['be',],
'фармакому'=>['be',],
'фати'=>['mk',],
'фбр'=>['kk',],
'ферменттер'=>['kk',],
'ферметтердің'=>['kk',],
'филм'=>['bg','mk',],
'фильм'=>['ru',],
'фино'=>['mk',],
'фитцпатрик'=>['kk',],
'флоце'=>['be',],
'фокс'=>['kk',],
'франк'=>['bg',],
'франсуа'=>['be',],
'френк'=>['mk',],
'фрли'=>['mk',],
'фрэнкс'=>['be',],
'фільм'=>['be',],
'ха'=>['ko','mk',],
'хабар'=>['kk',],
'хабарлассаңыз'=>['kk',],
'хабарласты'=>['kk',],
'хадзем'=>['be',],
'хадзі'=>['be',],
'хайде'=>['bg',],
'хакеры'=>['be',],
'хакнуць'=>['be',],
'халера'=>['be',],
'халеры'=>['be',],
'хамера'=>['be',],
'хапіць'=>['be',],
'хареса'=>['bg',],
'харесва'=>['bg',],
'харесвам'=>['bg',],
'хари'=>['bg','mk',],
'хат'=>['kk',],
'хаус'=>['ko',],
'хаця'=>['be',],
'хачу'=>['be',],
'хватит'=>['ru',],
'хей'=>['bg',],
'хер'=>['be',],
'хиляди'=>['bg',],
'хлапе'=>['bg',],
'хлопцы'=>['be',],
'хлопча'=>['be',],
'хм'=>['ko',],
'хмарачосы'=>['be',],
'ходя'=>['bg',],
'хора'=>['bg',],
'хората'=>['bg',],
'хорошая'=>['ru',],
'хорошие'=>['ru',],
'хороший'=>['ru',],
'хорошо'=>['ko','ru',],
'хотел'=>['ru',],
'хотела'=>['ko','ru',],
'хотели'=>['ru',],
'хотелось'=>['ko','ru',],
'хотим'=>['ru',],
'хотите'=>['ko','ru',],
'хоть'=>['ko','ru',],
'хотя'=>['ru',],
'хотят'=>['ru',],
'хочаш'=>['be',],
'хочет'=>['ko','ru',],
'хочется'=>['ru',],
'хочешь'=>['ko','ru',],
'хочу'=>['ko','ru',],
'храна'=>['bg','mk',],
'хто'=>['be',],
'хтось'=>['be',],
'хубав'=>['bg',],
'хубава'=>['bg',],
'хубаво'=>['bg',],
'хуже'=>['ru',],
'хутка'=>['be',],
'хутчэй'=>['be',],
'хірургі'=>['be',],
'це'=>['bg',],
'цел'=>['mk',],
'цела'=>['mk',],
'целата'=>['mk',],
'целиот'=>['mk',],
'целия'=>['bg',],
'цело'=>['mk',],
'целосно'=>['mk',],
'цыклуй'=>['be',],
'цэнтральнага'=>['be',],
'цэнтральным'=>['be',],
'цюрыхе'=>['be',],
'цябе'=>['be',],
'цяжка'=>['be',],
'цял'=>['bg',],
'цяла'=>['bg',],
'цялата'=>['bg',],
'цялото'=>['bg',],
'цяпер'=>['be',],
'цяперашні'=>['be',],
'ці'=>['be',],
'цікавіць'=>['be',],
'чаго'=>['be',],
'чак'=>['bg',],
'чака'=>['bg',],
'чакае'=>['be',],
'чакай'=>['be','bg',],
'чакайте'=>['bg',],
'чакам'=>['bg',],
'чакаюць'=>['be',],
'чалавек'=>['be',],
'чалавека'=>['be',],
'чалавеча'=>['be',],
'чалавечая'=>['be',],
'чаму'=>['be',],
'чао'=>['bg','mk',],
'чапай'=>['be',],
'чарли'=>['bg','mk','ru',],
'час'=>['be','bg','mk','ru',],
'часа'=>['bg','mk','ru',],
'часов'=>['ru',],
'часот'=>['mk',],
'част'=>['bg',],
'частку'=>['be',],
'часто'=>['ru',],
'часть'=>['ru',],
'часу'=>['be',],
'че'=>['bg',],
'чего'=>['ko','ru',],
'чека'=>['mk',],
'чекам'=>['mk',],
'чекај'=>['mk',],
'чекајте'=>['mk',],
'человек'=>['ru',],
'человека'=>['ru',],
'человеком'=>['ru',],
'чем'=>['ko','ru',],
'чему'=>['ru',],
'через'=>['ko','ru',],
'черт'=>['ru',],
'чест'=>['bg','mk',],
'честно'=>['bg','ru',],
'често'=>['bg',],
'честь'=>['ru',],
'четири'=>['bg','mk',],
'четыре'=>['ru',],
'чини'=>['mk',],
'чичо'=>['bg',],
'човек'=>['bg','mk',],
'човека'=>['bg',],
'човекот'=>['mk',],
'човеку'=>['mk',],
'човекът'=>['bg',],
'човече'=>['bg','mk',],
'чорная'=>['be',],
'что'=>['ko','ru',],
'чтоб'=>['ru',],
'чтобы'=>['ru',],
'чтовы'=>['ko',],
'чу'=>['bg',],
'чувак'=>['ru',],
'чувал'=>['bg',],
'чувам'=>['bg',],
'чуваш'=>['bg',],
'чувствам'=>['bg',],
'чувстваш'=>['bg',],
'чувствувам'=>['mk',],
'чувствуваш'=>['mk',],
'чувствую'=>['ru',],
'чудесно'=>['bg',],
'чудно'=>['mk',],
'чуеш'=>['be',],
'чуй'=>['bg',],
'чума'=>['be',],
'чуть'=>['ru',],
'чух'=>['bg',],
'чым'=>['be',],
'чыста'=>['be',],
'чём'=>['ru',],
'чёрт'=>['ru',],
'ш'=>['kk',],
'шабуылдаған'=>['kk',],
'шанец'=>['be',],
'шанс'=>['bg','ru',],
'шанса'=>['mk',],
'шанси'=>['mk',],
'шартым'=>['kk',],
'шаршадым'=>['kk',],
'шақырдыңыз'=>['kk',],
'шақырттым'=>['kk',],
'шақырым'=>['kk',],
'шақырып'=>['kk',],
'швейцарыю'=>['be',],
'ше'=>['kk',],
'шегін'=>['kk',],
'шест'=>['bg','mk',],
'шесть'=>['ru',],
'шефе'=>['bg','mk',],
'шешім'=>['kk',],
'школе'=>['ru',],
'школо'=>['mk',],
'школу'=>['ru',],
'шмат'=>['be',],
'шнауз'=>['kk',],
'шоу'=>['ru',],
'шта'=>['sr',],
'штаты'=>['kk',],
'штета'=>['mk',],
'што'=>['be','mk','sr',],
'штом'=>['mk',],
'штось'=>['be',],
'штотуку'=>['mk',],
'шын'=>['kk',],
'шындығында'=>['kk',],
'шынымен'=>['kk',],
'шығар'=>['kk',],
'шығармай'=>['kk',],
'шығарсыз'=>['kk',],
'шығарсың'=>['kk',],
'шығару'=>['kk',],
'шығарып'=>['kk',],
'шығып'=>['kk',],
'шықпады'=>['kk',],
'шықпай'=>['kk',],
'шықпайды'=>['kk',],
'шықпаңдар'=>['kk',],
'шыққан'=>['kk',],
'шэбы'=>['be',],
'ші'=>['kk',],
'шіркеу'=>['kk',],
'шіркеуге'=>['kk',],
'щастлив'=>['bg',],
'ще'=>['bg',],
'щеше'=>['bg',],
'що'=>['bg',],
'щом'=>['bg',],
'щях'=>['bg',],
'э'=>['ko','ru',],
'эй'=>['ru',],
'эйр'=>['be',],
'экстасенсорлы'=>['kk',],
'экстрасенс'=>['kk',],
'экстрасенстермен'=>['kk',],
'экстрасенстің'=>['kk',],
'элітным'=>['be',],
'энджел'=>['ko',],
'эпідэмія'=>['be',],
'эсми'=>['ko',],
'эта'=>['ru',],
'эти'=>['ru',],
'этим'=>['ru',],
'этих'=>['ru',],
'это'=>['ko','ru',],
'этого'=>['ru',],
'этой'=>['ru',],
'этом'=>['ru',],
'этому'=>['ru',],
'этот'=>['ko','ru',],
'эту'=>['ko','ru',],
'я'=>['be','bg','ko','ru',],
'является'=>['ru',],
'явно'=>['bg',],
'яго'=>['be',],
'яднаюцца'=>['be',],
'яе'=>['be',],
'як'=>['be',],
'якая'=>['be',],
'якудзы'=>['be',],
'якую'=>['be',],
'якуюсь'=>['be',],
'які'=>['be',],
'якія'=>['be',],
'яму'=>['be',],
'яна'=>['be',],
'яны'=>['be',],
'японская'=>['be',],
'ясна'=>['be',],
'ясно'=>['bg','ru',],
'ятаў'=>['be',],
'яшчэ'=>['be',],
'ёй'=>['be',],
'ён'=>['be',],
'ёсць'=>['be',],
'ёў'=>['be',],
'ѓа'=>['mk',],
'ѓаволите'=>['mk',],
'ѓо'=>['mk',],
'і'=>['be',],
'ідзе'=>['be',],
'ідэнтыфікаваць'=>['be',],
'із'=>['kk',],
'іздегендей'=>['kk',],
'іздеп'=>['kk',],
'іздері'=>['kk',],
'іздеу'=>['kk',],
'іздеумен'=>['kk',],
'ізі'=>['kk',],
'ім'=>['be',],
'імплантант'=>['be',],
'імплантантамі'=>['be',],
'імплантанту'=>['be',],
'імплантанты'=>['be',],
'імя'=>['be',],
'імі'=>['be',],
'іміграцыйны'=>['be',],
'індастрыс'=>['be',],
'інсталявана'=>['be',],
'інтэрнэт'=>['be',],
'інфармацыйныя'=>['be',],
'інфармацыю'=>['be',],
'інфармацыя'=>['be',],
'інфармацыяй'=>['be',],
'інфармацыі'=>['be',],
'інфу'=>['be',],
'іншага'=>['be',],
'ісая'=>['be',],
'істегені'=>['kk',],
'істедіңіз'=>['kk',],
'істемеймін'=>['kk',],
'істеп'=>['kk',],
'істі'=>['kk',],
'ісці'=>['be',],
'ісік'=>['kk',],
'ісімен'=>['kk',],
'ісінде'=>['kk',],
'іх'=>['be',],
'ішке'=>['kk',],
'ішкі'=>['kk',],
'іште'=>['kk',],
'ішінде'=>['kk',],
'ја'=>['mk','sr',],
'јавам'=>['mk',],
'јави'=>['mk',],
'јас'=>['mk',],
'јасно'=>['mk',],
'је'=>['ru','sr',],
'љanse'=>['sr',],
'љest'=>['sr',],
'љkolu'=>['sr',],
'љta'=>['bs','hr','sr',],
'љto'=>['bs','hr','sr',],
'љубов'=>['mk',],
'љубовта'=>['mk',],
'њујорк'=>['mk',],
'ћao'=>['bs','hr','sr',],
'ћele'=>['sr',],
'ћelela'=>['sr',],
'ћeleo'=>['sr',],
'ћeli'=>['bs','hr','sr',],
'ћelim'=>['bs','hr','sr',],
'ћelimo'=>['sr',],
'ћelite'=>['sr',],
'ћeliљ'=>['bs','hr','sr',],
'ћena'=>['bs','hr','sr',],
'ћene'=>['sr',],
'ћenu'=>['sr',],
'ћiv'=>['sr',],
'ћivi'=>['sr',],
'ћivim'=>['sr',],
'ћivot'=>['bs','hr','sr',],
'ћivota'=>['sr',],
'ћivotu'=>['sr',],
'ќе'=>['mk',],
'ќерка'=>['mk',],
'ў'=>['be',],
'ўвазе'=>['be',],
'ўжо'=>['be',],
'ўласны'=>['be',],
'ўмяшчальнасць'=>['be',],
'ўсе'=>['be',],
'ўсю'=>['be',],
'ўсё'=>['be',],
'ўшчэнт'=>['be',],
'ўяўляеш'=>['be',],
'џек'=>['mk',],
'џејк'=>['mk',],
'џими'=>['mk',],
'џо'=>['mk',],
'џон'=>['mk',],
'џони'=>['mk',],
'џорџ'=>['mk',],
'ғана'=>['kk',],
'ғой'=>['kk',],
'ғылым'=>['kk',],
'қабылдауын'=>['kk',],
'қазір'=>['kk',],
'қай'=>['kk',],
'қайда'=>['kk',],
'қайдан'=>['kk',],
'қайсы'=>['kk',],
'қайта'=>['kk',],
'қайтамыз'=>['kk',],
'қала'=>['kk',],
'қалай'=>['kk',],
'қалайсыз'=>['kk',],
'қалайсың'=>['kk',],
'қалды'=>['kk',],
'қалдым'=>['kk',],
'қалмайды'=>['kk',],
'қалу'=>['kk',],
'қалған'=>['kk',],
'қалғысы'=>['kk',],
'қамап'=>['kk',],
'қан'=>['kk',],
'қандай'=>['kk',],
'қанмен'=>['kk',],
'қанша'=>['kk',],
'қарай'=>['kk',],
'қарайын'=>['kk',],
'қарап'=>['kk',],
'қараңдар'=>['kk',],
'қарда'=>['kk',],
'қарсы'=>['kk',],
'қарындасыңызды'=>['kk',],
'қарған'=>['kk',],
'қатардан'=>['kk',],
'қатарды'=>['kk',],
'қатты'=>['kk',],
'қаттылығы'=>['kk',],
'қатысы'=>['kk',],
'қаша'=>['kk',],
'қашан'=>['kk',],
'қашып'=>['kk',],
'қиын'=>['kk',],
'қию'=>['kk',],
'қой'=>['kk',],
'қойдым'=>['kk',],
'қойыңдар'=>['kk',],
'қойған'=>['kk',],
'қол'=>['kk',],
'қолда'=>['kk',],
'қолдана'=>['kk',],
'қолдарыңды'=>['kk',],
'қолдауға'=>['kk',],
'қолды'=>['kk',],
'қолы'=>['kk',],
'қолымнан'=>['kk',],
'қолында'=>['kk',],
'қолыңнан'=>['kk',],
'қорықпа'=>['kk',],
'қорқып'=>['kk',],
'қош'=>['kk',],
'қояйын'=>['kk',],
'қуаныштымын'=>['kk',],
'қуанған'=>['kk',],
'қуып'=>['kk',],
'қыз'=>['kk',],
'қызды'=>['kk',],
'қызмет'=>['kk',],
'қызға'=>['kk',],
'қылды'=>['kk',],
'қылмыс'=>['kk',],
'қылмыскерлерді'=>['kk',],
'қылмыспен'=>['kk',],
'қылмысқа'=>['kk',],
'қынжылып'=>['kk',],
'құбыжық'=>['kk',],
'құдай'=>['kk',],
'құдайдан'=>['kk',],
'құдайды'=>['kk',],
'құдайдың'=>['kk',],
'құдайға'=>['kk',],
'құлатып'=>['kk',],
'құпия'=>['kk',],
'құралдарында'=>['kk',],
'құрып'=>['kk',],
'құтылғаныма'=>['kk',],
'құтылғанына'=>['kk',],
'құтқаруыңыз'=>['kk',],
'ү'=>['kk',],
'үйге'=>['kk',],
'үйде'=>['kk',],
'үйреніп'=>['kk',],
'үйіне'=>['kk',],
'үйінен'=>['kk',],
'үлкен'=>['kk',],
'үргенін'=>['kk',],
'үстінде'=>['kk',],
'үшін'=>['kk',],
'ұ'=>['kk',],
'ұзарту'=>['kk',],
'ұйықтай'=>['kk',],
'ұйықтамай'=>['kk',],
'ұйықтап'=>['kk',],
'ұйықтаған'=>['kk',],
'ұмыттыру'=>['kk',],
'ұмытып'=>['kk',],
'ұнамаймын'=>['kk',],
'ұрлаған'=>['kk',],
'ұсақ'=>['kk',],
'ұстаған'=>['kk',],
'ұстағысы'=>['kk',],
'ұстаңдар'=>['kk',],
'ұшақ'=>['kk',],
'ұқсайды'=>['kk',],
'ұқсас'=>['kk',],
'әй'=>['kk',],
'әйел'=>['kk',],
'әйелдер'=>['kk',],
'әйнек'=>['kk',],
'әкей'=>['kk',],
'әкейге'=>['kk',],
'әкейдің'=>['kk',],
'әкеймен'=>['kk',],
'әкелгені'=>['kk',],
'әкелді'=>['kk',],
'әкелдіңдер'=>['kk',],
'әкеліңдер'=>['kk',],
'әлде'=>['kk',],
'әлі'=>['kk',],
'әр'=>['kk',],
'әрекет'=>['kk',],
'әртүрлі'=>['kk',],
'әрі'=>['kk',],
'әрқашан'=>['kk',],
'әулие'=>['kk',],
'әңгіме'=>['kk',],
'өз'=>['kk',],
'өздері'=>['kk',],
'өзім'=>['kk',],
'өзімнің'=>['kk',],
'өзінің'=>['kk',],
'өзіңді'=>['kk',],
'өзіңіз'=>['kk',],
'өлең'=>['kk',],
'өлі'=>['kk',],
'өлім'=>['kk',],
'өлімге'=>['kk',],
'өлімнен'=>['kk',],
'өліп'=>['kk',],
'өмірге'=>['kk',],
'өмірі'=>['kk',],
'өмірімнің'=>['kk',],
'өмірін'=>['kk',],
'өсиеті'=>['kk',],
'өте'=>['kk',],
'өткізгім'=>['kk',],
'өткізіп'=>['kk',],
'өтінемін'=>['kk',],
'өтірік'=>['kk',],
'өтірікші'=>['kk',],
'א'=>['he',],
'אַבֿרהם'=>['yi',],
'אַוודאי'=>['yi',],
'אַוועק'=>['yi',],
'אַזאַ'=>['yi',],
'אַזוי'=>['yi',],
'אַזעלכע'=>['yi',],
'אַלט'=>['yi',],
'אַלטע'=>['yi',],
'אַלטער'=>['yi',],
'אַליין'=>['yi',],
'אַלע'=>['yi',],
'אַלעמען'=>['yi',],
'אַלץ'=>['yi',],
'אַמאָל'=>['yi',],
'אַמעריקאַנער'=>['yi',],
'אַמעריקע'=>['yi',],
'אַן'=>['yi',],
'אַנדער'=>['yi',],
'אַנדערן'=>['yi',],
'אַנדערע'=>['yi',],
'אַנדערש'=>['yi',],
'אַפֿילו'=>['yi',],
'אַקטיאָרן'=>['yi',],
'אַרבעט'=>['yi',],
'אַרבעטן'=>['yi',],
'אַרבעטער'=>['yi',],
'אַרויס'=>['yi',],
'אַרום'=>['yi',],
'אַרטיקל'=>['yi',],
'אַרמיי'=>['yi',],
'אַרײַן'=>['yi',],
'אָבער'=>['yi',],
'אָדער'=>['yi',],
'אָט'=>['yi',],
'אָלמערט'=>['yi',],
'אָן'=>['yi',],
'אָנגעהויבן'=>['yi',],
'אָנגענומען'=>['yi',],
'אָנגעשריבן'=>['yi',],
'אָנהייב'=>['yi',],
'אָפּ'=>['yi',],
'אָפֿט'=>['yi',],
'אָרט'=>['yi',],
'אבא'=>['he',],
'אבי'=>['he',],
'אביך'=>['he',],
'אבל'=>['he',],
'אגיד'=>['he',],
'אדון'=>['he',],
'אדוני'=>['he',],
'אדירים'=>['he',],
'אדם'=>['he',],
'אה'=>['he',],
'אהבה'=>['he',],
'אהבתי'=>['he',],
'אהוד'=>['yi',],
'אהיה'=>['he',],
'או'=>['he',],
'אוהב'=>['he',],
'אוהבים'=>['he',],
'אוהבת'=>['he',],
'אוי'=>['he',],
'אויב'=>['yi',],
'אויגן'=>['yi',],
'אויך'=>['yi',],
'אויס'=>['yi',],
'אויסשטעלונג'=>['yi',],
'אויפֿן'=>['yi',],
'אוכל'=>['he',],
'אולי'=>['he',],
'אומר'=>['he',],
'אומרים'=>['he',],
'אומרת'=>['he',],
'אונדז'=>['yi',],
'אונדזער'=>['yi',],
'אונדזערע'=>['yi',],
'אונטער'=>['yi',],
'אונטערן'=>['yi',],
'אוניווערסיטעט'=>['yi',],
'אופֿן'=>['yi',],
'אופן'=>['he',],
'אוקיי'=>['he',],
'אוקראַיִנע'=>['yi',],
'אותה'=>['he',],
'אותו'=>['he',],
'אותי'=>['he',],
'אותך'=>['he',],
'אותם'=>['he',],
'אותן'=>['he',],
'אותנו'=>['he',],
'אז'=>['he',],
'אחד'=>['he',],
'אחורה'=>['he',],
'אחזור'=>['he',],
'אחי'=>['he',],
'אחר'=>['he',],
'אחרי'=>['he',],
'אחרים'=>['he',],
'אחרת'=>['he',],
'אחת'=>['he',],
'אי'=>['he','yi',],
'איבער'=>['yi',],
'אידיוט'=>['he',],
'איזה'=>['he',],
'איזו'=>['he',],
'איי'=>['he',],
'אייגענע'=>['yi',],
'אייגענעם'=>['yi',],
'איידער'=>['yi',],
'איין'=>['yi',],
'אייניקע'=>['yi',],
'איינע'=>['yi',],
'איינעם'=>['yi',],
'איינער'=>['yi',],
'אייראָפּע'=>['yi',],
'איך'=>['he','yi',],
'איכפת'=>['he',],
'אים'=>['yi',],
'אימא'=>['he',],
'אין'=>['he',],
'אינו'=>['he',],
'איני'=>['he',],
'אינך'=>['he',],
'אינני'=>['he',],
'אינעם'=>['yi',],
'איפה'=>['he',],
'איצט'=>['yi',],
'איר'=>['yi',],
'איראַן'=>['yi',],
'אירע'=>['yi',],
'איש'=>['he',],
'אישה'=>['he',],
'איתה'=>['he',],
'איתו'=>['he',],
'איתי'=>['he',],
'איתך'=>['he',],
'איתם'=>['he',],
'איתנו'=>['he',],
'אך'=>['he',],
'אכן'=>['he',],
'אכפת'=>['he',],
'אל'=>['he',],
'אלא'=>['he',],
'אלה'=>['he',],
'אלו'=>['he',],
'אלוהים'=>['he',],
'אלי'=>['he',],
'אליה'=>['he',],
'אליו'=>['he',],
'אליי'=>['he',],
'אלייך'=>['he',],
'אליך'=>['he',],
'אלינו'=>['he',],
'אלך'=>['he',],
'אלף'=>['he',],
'אם'=>['he',],
'אמא'=>['he',],
'אמור'=>['he',],
'אמיתי'=>['he',],
'אמר'=>['he',],
'אמרה'=>['he',],
'אמרו'=>['he',],
'אמרת'=>['he',],
'אמרתי'=>['he',],
'אמת'=>['yi',],
'אן'=>['he',],
'אנא'=>['he',],
'אנג'=>['he',],
'אנו'=>['he',],
'אנחנו'=>['he',],
'אני'=>['he',],
'אנשים'=>['he',],
'אסור'=>['he',],
'אעשה'=>['he',],
'אף'=>['he',],
'אפֿשר'=>['yi',],
'אפילו'=>['he',],
'אפשר'=>['he',],
'אפשרי'=>['he',],
'אצל'=>['he',],
'אקח'=>['he',],
'אראה'=>['he',],
'ארבע'=>['he',],
'ארוחת'=>['he',],
'ארלי'=>['he',],
'ארץ־ישׂראל'=>['yi',],
'אש'=>['he',],
'אשר'=>['he',],
'את'=>['he',],
'אתה'=>['he',],
'אתכם'=>['he',],
'אתם'=>['he',],
'אתמול'=>['he',],
'אתן'=>['he',],
'אײַך'=>['yi',],
'אײַער'=>['yi',],
'ב'=>['he',],
'בא'=>['he',],
'באַוויזן'=>['yi',],
'באַוועגונג'=>['yi',],
'באַזונדערס'=>['yi',],
'באַטראַכט'=>['yi',],
'באַלד'=>['yi',],
'באַמערקט'=>['yi',],
'באַפֿעלקערונג'=>['yi',],
'באַציִונגען'=>['yi',],
'באַקאַנט'=>['yi',],
'באַקאַנטע'=>['yi',],
'באַקומען'=>['yi',],
'באַשלאָסן'=>['yi',],
'באה'=>['he',],
'באופן'=>['he',],
'באותו'=>['he',],
'באמת'=>['he',],
'באתי'=>['he',],
'בבוקר'=>['he',],
'בבית'=>['he',],
'בבקשה'=>['he',],
'בגלל'=>['he',],
'בדיוק'=>['he',],
'בדרך'=>['he',],
'בה'=>['he',],
'בהחלט'=>['he',],
'בהם'=>['he',],
'בהצלחה'=>['he',],
'בו'=>['he',],
'בוא'=>['he',],
'בואו'=>['he',],
'בואי'=>['he',],
'בוודאי'=>['he',],
'בוך'=>['yi',],
'בוקר'=>['he',],
'בזה'=>['he',],
'בזמן'=>['he',],
'בחדר'=>['he',],
'בחוץ'=>['he',],
'בחור'=>['he',],
'בחורה'=>['he',],
'בחורים'=>['he',],
'בחזרה'=>['he',],
'בחיי'=>['he',],
'בחייך'=>['he',],
'בחיים'=>['he',],
'בטוח'=>['he',],
'בטוחה'=>['he',],
'בטח'=>['he',],
'בי'=>['he',],
'ביום'=>['he',],
'ביותר'=>['he',],
'ביז'=>['yi',],
'ביזן'=>['yi',],
'ביחד'=>['he',],
'ביי'=>['he',],
'ביידע'=>['yi',],
'ביכער'=>['yi',],
'בילד'=>['yi',],
'בילדער'=>['yi',],
'בין'=>['he','yi',],
'ביסל'=>['yi',],
'בית'=>['he',],
'בך'=>['he',],
'בכּלל'=>['yi',],
'בכך'=>['he',],
'בכל'=>['he',],
'בכלל'=>['he',],
'בלויז'=>['yi',],
'בלי'=>['he',],
'בלילה'=>['he',],
'בלתי'=>['he',],
'בלײַבט'=>['yi',],
'בלײַבן'=>['yi',],
'במה'=>['he',],
'במיוחד'=>['he',],
'במצב'=>['he',],
'במקום'=>['he',],
'במקרה'=>['he',],
'במשך'=>['he','yi',],
'בן'=>['he',],
'בנאדם'=>['he',],
'בנו'=>['he',],
'בנוגע'=>['he',],
'בנות'=>['he',],
'בני'=>['he',],
'בסדר'=>['he',],
'בסוף'=>['he',],
'בעבר'=>['he',],
'בעוד'=>['he',],
'בעולם'=>['he',],
'בעיה'=>['he',],
'בעיות'=>['he',],
'בעיר'=>['he',],
'בעל'=>['he',],
'בעלי'=>['he',],
'בעסער'=>['yi',],
'בעצמי'=>['he',],
'בעצמך'=>['he',],
'בערך'=>['he',],
'בעת'=>['yi',],
'בפֿרט'=>['yi',],
'בפנים'=>['he',],
'בפעם'=>['he',],
'בצד'=>['he',],
'בצורה'=>['he',],
'בקרוב'=>['he',],
'בקשר'=>['he',],
'בראש'=>['he',],
'ברגע'=>['he',],
'ברור'=>['he',],
'ברידער'=>['yi',],
'בריוו'=>['yi',],
'ברענגען'=>['yi',],
'ברצינות'=>['he',],
'בשביל'=>['he',],
'בשבילי'=>['he',],
'בשבילך'=>['he',],
'בשם'=>['he',],
'בשעה'=>['he',],
'בשקט'=>['he',],
'בת'=>['he',],
'בתוך'=>['he',],
'בתור'=>['he',],
'בײַ'=>['yi',],
'בײַם'=>['yi',],
'ג'=>['he',],
'גאַנץ'=>['yi',],
'גאַנצן'=>['yi',],
'גאַנצע'=>['yi',],
'גאַנצער'=>['yi',],
'גאַס'=>['yi',],
'גאָט'=>['yi',],
'גאָר'=>['yi',],
'גאָרנישט'=>['yi',],
'גבר'=>['he',],
'גברים'=>['he',],
'גברת'=>['he',],
'גברתי'=>['he',],
'גדול'=>['he',],
'גדולה'=>['he',],
'גוט'=>['yi',],
'גוטע'=>['yi',],
'גופֿא'=>['yi',],
'גורל'=>['yi',],
'גורם'=>['he',],
'גיט'=>['yi',],
'גייט'=>['yi',],
'גיין'=>['yi',],
'גלײַך'=>['yi',],
'גם'=>['he',],
'גמור'=>['he',],
'געאַרבעט'=>['yi',],
'געבוירן'=>['yi',],
'געבליבן'=>['yi',],
'געבן'=>['yi',],
'געבראַכט'=>['yi',],
'געגאַנגען'=>['yi',],
'געגעבן'=>['yi',],
'געדאַנק'=>['yi',],
'געדאַרפֿט'=>['yi',],
'געהאַט'=>['yi',],
'געהאַלטן'=>['yi',],
'געהערט'=>['yi',],
'געוואָלט'=>['yi',],
'געוואָרן'=>['yi',],
'געוווּסט'=>['yi',],
'געוויסע'=>['yi',],
'געווען'=>['yi',],
'געזאָגט'=>['yi',],
'געזעלשאַפֿט'=>['yi',],
'געזען'=>['yi',],
'געטאָ'=>['yi',],
'געטאָן'=>['yi',],
'געלאָזט'=>['yi',],
'געלט'=>['yi',],
'געלעבט'=>['yi',],
'געלערנט'=>['yi',],
'געמאַכט'=>['yi',],
'גענוג'=>['yi',],
'גענומען'=>['yi',],
'געענטפֿערט'=>['yi',],
'געפֿונען'=>['yi',],
'געפֿינט'=>['yi',],
'געפֿינען'=>['yi',],
'געפֿירט'=>['yi',],
'געקאָנט'=>['yi',],
'געקומען'=>['yi',],
'געקוקט'=>['yi',],
'געקענט'=>['yi',],
'גערעדט'=>['yi',],
'געשאַפֿן'=>['yi',],
'געשטאַנען'=>['yi',],
'געשטאָרבן'=>['yi',],
'געשטעלט'=>['yi',],
'געשיכטע'=>['yi',],
'געשען'=>['yi',],
'געשפּילט'=>['yi',],
'געשריבן'=>['yi',],
'גרויס'=>['yi',],
'גרויסן'=>['yi',],
'גרויסע'=>['yi',],
'גרויסער'=>['yi',],
'גרוע'=>['he',],
'גרופּע'=>['yi',],
'גרייט'=>['yi',],
'דאַן'=>['yi',],
'דאַנק'=>['yi',],
'דאַרף'=>['yi',],
'דאַרפֿן'=>['yi',],
'דאָ'=>['yi',],
'דאָזיקן'=>['yi',],
'דאָזיקע'=>['yi',],
'דאָזיקער'=>['yi',],
'דאָך'=>['yi',],
'דאָס'=>['yi',],
'דאָרט'=>['yi',],
'דאָרטן'=>['yi',],
'דבר'=>['he',],
'דברים'=>['he',],
'דו'=>['yi',],
'דוד'=>['he','yi',],
'דווקא'=>['yi',],
'דולר'=>['he',],
'דוקטור'=>['he',],
'דור'=>['yi',],
'דורות'=>['yi',],
'דורך'=>['yi',],
'די'=>['he',],
'דיכטער'=>['yi',],
'דין'=>['he',],
'דיר'=>['yi',],
'דם'=>['he',],
'דעמאָלט'=>['yi',],
'דערבײַ'=>['yi',],
'דערווײַל'=>['yi',],
'דעריבער'=>['yi',],
'דערמאָנט'=>['yi',],
'דערמאָנען'=>['yi',],
'דערמיט'=>['yi',],
'דערנאָך'=>['yi',],
'דערפֿאַר'=>['yi',],
'דערצו'=>['yi',],
'דערציילט'=>['yi',],
'דערציילן'=>['yi',],
'דערקלערט'=>['yi',],
'דעתך'=>['he',],
'דקה'=>['he',],
'דקות'=>['he',],
'דרך'=>['he',],
'דרײַ'=>['yi',],
'דײַטשלאַנד'=>['yi',],
'דײַטשן'=>['yi',],
'דײַן'=>['yi',],
'ד״ר'=>['yi',],
'ה'=>['he',],
'הא'=>['he',],
'האַלט'=>['yi',],
'האַלטן'=>['yi',],
'האַנט'=>['yi',],
'האַרץ'=>['yi',],
'האָב'=>['yi',],
'האדם'=>['he',],
'האחרון'=>['he',],
'האחרונה'=>['he',],
'האיש'=>['he',],
'האישה'=>['he',],
'האל'=>['he',],
'האלה'=>['he',],
'האלו'=>['he',],
'האם'=>['he',],
'האמת'=>['he',],
'האנשים'=>['he',],
'האקדח'=>['he',],
'הארי'=>['he',],
'הארץ'=>['he',],
'הבא'=>['he',],
'הבאה'=>['he',],
'הבוקר'=>['he',],
'הבחור'=>['he',],
'הבחורה'=>['he',],
'הבית'=>['he',],
'הביתה'=>['he',],
'הבן'=>['he',],
'הבנתי'=>['he',],
'הבעיה'=>['he',],
'הגדול'=>['he',],
'הגיע'=>['he',],
'הגם'=>['yi',],
'הדבר'=>['he',],
'הדברים'=>['he',],
'הדלת'=>['he',],
'הדרך'=>['he',],
'ההוא'=>['he',],
'הו'=>['he',],
'הוא'=>['he',],
'הוד'=>['he',],
'הויז'=>['yi',],
'הולך'=>['he',],
'הולכים'=>['he',],
'הולכת'=>['he',],
'הז'=>['he',],
'הזאת'=>['he',],
'הזדמנות'=>['he',],
'הזה'=>['he',],
'הזו'=>['he',],
'הזמן'=>['he',],
'החבר'=>['he',],
'החברה'=>['he',],
'החדש'=>['he',],
'החוצה'=>['he',],
'החיים'=>['he',],
'החרא'=>['he',],
'הטוב'=>['he',],
'הטלפון'=>['he',],
'הי'=>['he',],
'היא'=>['he',],
'היד'=>['he',],
'הידיים'=>['he',],
'היה'=>['he',],
'היו'=>['he',],
'היום'=>['he',],
'היחיד'=>['he',],
'היחידה'=>['he',],
'היי'=>['he',],
'הייבט'=>['yi',],
'היים'=>['yi',],
'היינו'=>['he',],
'הייסט'=>['yi',],
'היית'=>['he',],
'הייתה'=>['he',],
'הייתי'=>['he',],
'היכן'=>['he',],
'הילד'=>['he',],
'הילדים'=>['he',],
'היתה'=>['he',],
'הכבוד'=>['he',],
'הכול'=>['he',],
'הכי'=>['he',],
'הכל'=>['he',],
'הכסף'=>['he',],
'הלא'=>['he',],
'הלו'=>['he',],
'הלוואי'=>['he',],
'הלילה'=>['he',],
'הלך'=>['he',],
'הללו'=>['he',],
'הם'=>['he',],
'המון'=>['he',],
'המים'=>['he',],
'המכונית'=>['he',],
'המפקד'=>['he',],
'המצב'=>['he',],
'המקום'=>['he',],
'המשחק'=>['he',],
'המשטרה'=>['he',],
'המשפחה'=>['he',],
'הן'=>['he',],
'הנה'=>['he',],
'הנשיא'=>['he',],
'הסיבה'=>['he',],
'הסיפור'=>['he',],
'הספר'=>['he',],
'העבודה'=>['he',],
'העולם'=>['he',],
'העיר'=>['he',],
'העלפֿן'=>['yi',],
'הענט'=>['yi',],
'העניין'=>['he',],
'הערב'=>['he',],
'הערן'=>['yi',],
'הפה'=>['he',],
'הפנים'=>['he',],
'הפעם'=>['he',],
'הצילו'=>['he',],
'הקטן'=>['he',],
'הקטנה'=>['he',],
'הראש'=>['he',],
'הראשון'=>['he',],
'הראשונה'=>['he',],
'הרבה'=>['he',],
'הרגע'=>['he',],
'השם'=>['he',],
'השנה'=>['he',],
'השני'=>['he',],
'התחת'=>['he',],
'התיק'=>['he',],
'התכוונתי'=>['he',],
'הײַנט'=>['yi',],
'הײַנטיקע'=>['yi',],
'ו'=>['he',],
'ואז'=>['he',],
'ואל'=>['he',],
'ואם'=>['he',],
'ואנחנו'=>['he',],
'ואני'=>['he',],
'ואת'=>['he',],
'ואתה'=>['he',],
'ובכן'=>['he',],
'וגם'=>['he',],
'והוא'=>['he',],
'והיא'=>['he',],
'והם'=>['he',],
'וואַסער'=>['yi',],
'וואַרשע'=>['yi',],
'וואָך'=>['yi',],
'וואָלט'=>['yi',],
'וואָלטן'=>['yi',],
'וואָרט'=>['yi',],
'וואו'=>['he',],
'וווּ'=>['yi',],
'ווידער'=>['yi',],
'ווייניק'=>['yi',],
'ווייניקער'=>['yi',],
'ווייסט'=>['yi',],
'וויכטיק'=>['yi',],
'וויכטיקע'=>['yi',],
'וויל'=>['yi',],
'ווילן'=>['yi',],
'וויסן'=>['yi',],
'וויפֿל'=>['yi',],
'וועג'=>['yi',],
'וועגן'=>['yi',],
'וועט'=>['yi',],
'וועל'=>['yi',],
'וועלט'=>['yi',],
'וועלט־מלחמה'=>['yi',],
'וועלכן'=>['yi',],
'וועלכע'=>['yi',],
'וועלכער'=>['yi',],
'וועלן'=>['yi',],
'וועמען'=>['yi',],
'ווען'=>['yi',],
'ווער'=>['yi',],
'ווערט'=>['yi',],
'ווערטער'=>['yi',],
'ווערן'=>['yi',],
'ווערק'=>['yi',],
'ווײַזט'=>['yi',],
'ווײַזן'=>['yi',],
'ווײַט'=>['yi',],
'ווײַטער'=>['yi',],
'ווײַל'=>['yi',],
'וזה'=>['he',],
'ויש'=>['he',],
'וכל'=>['he',],
'ולא'=>['he',],
'ומה'=>['he',],
'ון'=>['he',],
'ועכשיו'=>['he',],
'זאַך'=>['yi',],
'זאַכן'=>['yi',],
'זאָגט'=>['yi',],
'זאָגן'=>['yi',],
'זאָל'=>['yi',],
'זאָלן'=>['yi',],
'זאת'=>['he',],
'זה'=>['he',],
'זהו'=>['he',],
'זו'=>['he',],
'זוז'=>['he',],
'זוכר'=>['he',],
'זוכרת'=>['he',],
'זון'=>['yi',],
'זונה'=>['he',],
'זי'=>['yi',],
'זיבן'=>['yi',],
'זיי'=>['yi',],
'זייער'=>['yi',],
'זייערע'=>['yi',],
'זיכער'=>['yi',],
'זין'=>['he',],
'זינט'=>['yi',],
'זמן'=>['he',],
'זעט'=>['yi',],
'זעלבן'=>['yi',],
'זעלבע'=>['yi',],
'זעלבער'=>['yi',],
'זען'=>['yi',],
'זענען'=>['yi',],
'זקוק'=>['he',],
'זשורנאַל'=>['yi',],
'זײַט'=>['yi',],
'זײַנע'=>['yi',],
'זײַנען'=>['yi',],
'ח'=>['he',],
'חבל'=>['he',],
'חבר'=>['he',],
'חברה'=>['he',],
'חברים'=>['he',],
'חג'=>['he',],
'חדר'=>['he',],
'חדש'=>['he',],
'חדשה'=>['he',],
'חדשות'=>['he',],
'חדשים'=>['yi',],
'חודש'=>['yi',],
'חודשים'=>['he',],
'חוזר'=>['he',],
'חולה'=>['he',],
'חוץ'=>['he',],
'חורבן'=>['yi',],
'חושב'=>['he',],
'חושבים'=>['he',],
'חושבת'=>['he',],
'חזק'=>['he',],
'חזרה'=>['he',],
'חי'=>['he',],
'חיי'=>['he',],
'חייב'=>['he',],
'חייבים'=>['he',],
'חייבת'=>['he',],
'חיים'=>['he','yi',],
'חכה'=>['he',],
'חכו'=>['he',],
'חכי'=>['he',],
'חלק'=>['he',],
'חם'=>['he',],
'חמש'=>['he',],
'חן'=>['he',],
'חסר'=>['he',],
'חצי'=>['he',],
'חרא'=>['he',],
'חשבת'=>['he',],
'חשבתי'=>['he',],
'חשוב'=>['he',],
'חתונה'=>['yi',],
'חתיכת'=>['he',],
'טאַטע'=>['yi',],
'טאַקע'=>['yi',],
'טאָג'=>['yi',],
'טאָכטער'=>['yi',],
'טאָן'=>['yi',],
'טוב'=>['he',],
'טובה'=>['he',],
'טובים'=>['he',],
'טוט'=>['yi',],
'טויזנט'=>['yi',],
'טויזנטער'=>['yi',],
'טויט'=>['yi',],
'טום'=>['he',],
'טייל'=>['yi',],
'טיפש'=>['he',],
'טעאַטער'=>['yi',],
'טעג'=>['yi',],
'טעות'=>['he',],
'טעמע'=>['yi',],
'י'=>['he',],
'יאָ'=>['yi',],
'יאָר'=>['yi',],
'יאָרהונדערט'=>['yi',],
'יאָרן'=>['yi',],
'יד'=>['he',],
'ידי'=>['he',],
'ידע'=>['he',],
'ידעת'=>['he',],
'ידעתי'=>['he',],
'יהיה'=>['he',],
'יהיו'=>['he',],
'יוגנט'=>['yi',],
'יודע'=>['he',],
'יודעים'=>['he',],
'יודעת'=>['he',],
'יום'=>['he',],
'יונגע'=>['yi',],
'יוסף'=>['yi',],
'יופי'=>['he',],
'יוצא'=>['he',],
'יורק'=>['he',],
'יותר'=>['he',],
'יחד'=>['he',],
'ייִד'=>['yi',],
'ייִדיש'=>['yi',],
'ייִדישן'=>['yi',],
'ייִדישע'=>['yi',],
'ייִדישער'=>['yi',],
'ייִדישקייט'=>['yi',],
'ייִדן'=>['yi',],
'יין'=>['he',],
'יכול'=>['he',],
'יכולה'=>['he',],
'יכולים'=>['he',],
'יכולת'=>['he',],
'יכולתי'=>['he',],
'ילד'=>['he',],
'ילדה'=>['he',],
'ילדים'=>['he',],
'ים'=>['he',],
'ימי'=>['he',],
'ימים'=>['he',],
'ינא'=>['he',],
'יעדן'=>['yi',],
'יעדע'=>['yi',],
'יעדעס'=>['yi',],
'יעדער'=>['yi',],
'יענע'=>['yi',],
'יענעם'=>['yi',],
'יענער'=>['yi',],
'יעקבֿ'=>['yi',],
'יעשה'=>['he',],
'יפה'=>['he',],
'יצא'=>['he',],
'יצחק'=>['yi',],
'יקירתי'=>['he',],
'יקרה'=>['he',],
'ירושלים'=>['yi',],
'יש'=>['he',],
'ישׂראל'=>['yi',],
'ישׂראלדיקע'=>['yi',],
'ישנה'=>['he',],
'ישר'=>['he',],
'כ'=>['he',],
'כּדי'=>['yi',],
'כּמעט'=>['yi',],
'כאָטש'=>['yi',],
'כאילו'=>['he',],
'כאלה'=>['he',],
'כאן'=>['he',],
'כאשר'=>['he',],
'כבוד'=>['he',],
'כבר'=>['he',],
'כדאי'=>['he',],
'כדור'=>['he',],
'כדי'=>['he',],
'כה'=>['he',],
'כוח'=>['he',],
'כולכם'=>['he',],
'כולם'=>['he',],
'כולנו'=>['he',],
'כזאת'=>['he',],
'כזה'=>['he',],
'כי'=>['he',],
'כיף'=>['he',],
'כיצד'=>['he',],
'כך'=>['he',],
'ככה'=>['he',],
'ככל'=>['he',],
'כל'=>['he',],
'כלב'=>['he',],
'כלבה'=>['he',],
'כלום'=>['he',],
'כלומר'=>['he',],
'כלל'=>['he',],
'כמה'=>['he',],
'כמו'=>['he',],
'כמובן'=>['he',],
'כמוך'=>['he',],
'כמעט'=>['he',],
'כן'=>['he',],
'כנראה'=>['he',],
'כסף'=>['he',],
'כעת'=>['he',],
'כפי'=>['he',],
'כרגע'=>['he',],
'כשאני'=>['he',],
'כשאתה'=>['he',],
'כשהוא'=>['he',],
'ל'=>['he',],
'לא'=>['he',],
'לאַנג'=>['yi',],
'לאַנד'=>['yi',],
'לאָזט'=>['yi',],
'לאָזן'=>['yi',],
'לאחר'=>['he',],
'לאט'=>['he',],
'לאכול'=>['he',],
'לאן'=>['he',],
'לאנשים'=>['he',],
'לב'=>['he',],
'לבד'=>['he',],
'לבדוק'=>['he',],
'לבוא'=>['he',],
'לבחור'=>['he',],
'לבית'=>['he',],
'לבן'=>['he',],
'לברוח'=>['he',],
'לגבי'=>['he',],
'לגמרי'=>['he',],
'לגרום'=>['he',],
'לדאוג'=>['he',],
'לדבר'=>['he',],
'לדעת'=>['he',],
'לה'=>['he',],
'להאמין'=>['he',],
'להביא'=>['he',],
'להבין'=>['he',],
'להגיד'=>['he',],
'להגיע'=>['he',],
'להוציא'=>['he',],
'להיות'=>['he',],
'להיכנס'=>['he',],
'להישאר'=>['he',],
'להכיר'=>['he',],
'להם'=>['he',],
'להמשיך'=>['he',],
'להפסיק'=>['he',],
'להציל'=>['he',],
'להראות'=>['he',],
'להרגיש'=>['he',],
'להרוג'=>['he',],
'להשיג'=>['he',],
'להשתמש'=>['he',],
'להתחיל'=>['he',],
'להתקשר'=>['he',],
'להתראות'=>['he',],
'לו'=>['he',],
'לויט'=>['yi',],
'לומר'=>['he',],
'לוקח'=>['he',],
'לזה'=>['he',],
'לזוז'=>['he',],
'לחזור'=>['he',],
'לחיות'=>['he',],
'לחכות'=>['he',],
'לחפש'=>['he',],
'לחשוב'=>['he',],
'לטפל'=>['he',],
'לי'=>['he',],
'ליב'=>['yi',],
'ליבע'=>['yi',],
'ליד'=>['he','yi',],
'לידער'=>['yi',],
'ליטעראַטור'=>['yi',],
'לייענען'=>['yi',],
'לייענער'=>['yi',],
'ליכט'=>['yi',],
'לילה'=>['he',],
'לישון'=>['he',],
'לך'=>['he',],
'לכאן'=>['he',],
'לכו'=>['he',],
'לכולם'=>['he',],
'לכי'=>['he',],
'לכך'=>['he',],
'לכל'=>['he',],
'לכם'=>['he',],
'לכן'=>['he',],
'ללא'=>['he',],
'ללכת'=>['he',],
'ללמוד'=>['he',],
'למה'=>['he',],
'למות'=>['he',],
'למטה'=>['he',],
'למי'=>['he',],
'למישהו'=>['he',],
'למעלה'=>['he',],
'למען'=>['he',],
'למעשה'=>['he',],
'למצוא'=>['he',],
'למקום'=>['he',],
'למרות'=>['he',],
'למשל'=>['yi',],
'לנו'=>['he',],
'לנסות'=>['he',],
'לנצח'=>['he',],
'לספר'=>['he',],
'לעבוד'=>['he',],
'לעבודה'=>['he',],
'לעבור'=>['he',],
'לעבן'=>['yi',],
'לעולם'=>['he',],
'לעזאזל'=>['he',],
'לעזוב'=>['he',],
'לעזור'=>['he',],
'לענדער'=>['yi',],
'לעצור'=>['he',],
'לעצטן'=>['yi',],
'לעצטנס'=>['yi',],
'לעצטע'=>['yi',],
'לעצמי'=>['he',],
'לעצמך'=>['he',],
'לערנען'=>['yi',],
'לערער'=>['yi',],
'לעשות'=>['he',],
'לפגוש'=>['he',],
'לפה'=>['he',],
'לפחות'=>['he',],
'לפי'=>['he',],
'לפני'=>['he',],
'לפעמים'=>['he',],
'לצאת'=>['he',],
'לקבל'=>['he',],
'לקח'=>['he',],
'לקחת'=>['he',],
'לקנות'=>['he',],
'לקרוא'=>['he',],
'לקרות'=>['he',],
'לראות'=>['he',],
'לרגע'=>['he',],
'לשאול'=>['he',],
'לשבת'=>['he',],
'לשון'=>['yi',],
'לשחק'=>['he',],
'לשים'=>['he',],
'לשלם'=>['he',],
'לשם'=>['he',],
'לשמוע'=>['he',],
'לשמור'=>['he',],
'לשתות'=>['he',],
'לתוך'=>['he',],
'לתפוס'=>['he',],
'לתת'=>['he',],
'מ'=>['he',],
'מאַכט'=>['yi',],
'מאַכן'=>['yi',],
'מאַמע'=>['yi',],
'מאַן'=>['yi',],
'מאָל'=>['yi',],
'מאָסקווע'=>['yi',],
'מאָסקווער'=>['yi',],
'מאד'=>['he',],
'מאוד'=>['he',],
'מאוחר'=>['he',],
'מאז'=>['he',],
'מאחורי'=>['he',],
'מאיפה'=>['he',],
'מאיר'=>['yi',],
'מאיתנו'=>['he',],
'מאמין'=>['he',],
'מאמינה'=>['he',],
'מאשר'=>['he',],
'מבטיח'=>['he',],
'מבין'=>['he',],
'מבינה'=>['he',],
'מבקש'=>['he',],
'מגיע'=>['he',],
'מגניב'=>['he',],
'מדבר'=>['he',],
'מדברים'=>['he',],
'מדברת'=>['he',],
'מדהים'=>['he',],
'מדוע'=>['he',],
'מדי'=>['he',],
'מדינה'=>['yi',],
'מדינת־ישׂראל'=>['yi',],
'מה'=>['he',],
'מהם'=>['he',],
'מהר'=>['he',],
'מוז'=>['yi',],
'מוזיק'=>['yi',],
'מוזר'=>['he',],
'מוכן'=>['he',],
'מוכנה'=>['he',],
'מוכנים'=>['he',],
'מול'=>['he',],
'מוצא'=>['he',],
'מוקדם'=>['he',],
'מורא'=>['yi',],
'מושג'=>['he',],
'מושלם'=>['he',],
'מותק'=>['he',],
'מזה'=>['he',],
'מזל'=>['he',],
'מחבר'=>['yi',],
'מחדש'=>['he',],
'מחוץ'=>['he',],
'מחכה'=>['he',],
'מחפש'=>['he',],
'מחר'=>['he',],
'מטורף'=>['he',],
'מי'=>['he',],
'מיד'=>['he',],
'מידי'=>['he',],
'מידע'=>['he',],
'מיוחד'=>['he',],
'מיזרח'=>['yi',],
'מיטן'=>['yi',],
'מיינונג'=>['yi',],
'מיינט'=>['yi',],
'מייק'=>['he',],
'מייקל'=>['he',],
'מיך'=>['yi',],
'מילה'=>['he',],
'מיליאָן'=>['yi',],
'מיליון'=>['he',],
'מים'=>['he',],
'מין'=>['he','yi',],
'מיניסטער'=>['yi',],
'מיר'=>['yi',],
'מישהו'=>['he',],
'מישהי'=>['he',],
'מכאן'=>['he',],
'מכיוון'=>['he',],
'מכיר'=>['he',],
'מכירה'=>['he',],
'מכל'=>['he',],
'מלא'=>['he',],
'מלחמה'=>['yi',],
'ממה'=>['he',],
'ממך'=>['he',],
'ממנה'=>['he',],
'ממנו'=>['he',],
'ממני'=>['he',],
'ממש'=>['he','yi',],
'מן'=>['he',],
'מניח'=>['he',],
'מנסה'=>['he',],
'מסוגל'=>['he',],
'מספיק'=>['he',],
'מספר'=>['he',],
'מע'=>['yi',],
'מעבר'=>['he',],
'מעגלעך'=>['yi',],
'מעולה'=>['he',],
'מעולם'=>['he',],
'מעט'=>['he',],
'מעל'=>['he',],
'מעמד'=>['he',],
'מען'=>['yi',],
'מענטש'=>['yi',],
'מענטשן'=>['yi',],
'מעניין'=>['he',],
'מער'=>['yi',],
'מעשׂה'=>['yi',],
'מפה'=>['he',],
'מפני'=>['he',],
'מצאתי'=>['he',],
'מצב'=>['he',],
'מצבֿ'=>['yi',],
'מצוות'=>['he',],
'מצוין'=>['he',],
'מצחיק'=>['he',],
'מצטער'=>['he',],
'מצטערת'=>['he',],
'מקבל'=>['he',],
'מקווה'=>['he',],
'מקום'=>['he',],
'מקרה'=>['he',],
'מר'=>['he',],
'מרגיש'=>['he',],
'מרגישה'=>['he',],
'משה'=>['yi',],
'משהו'=>['he',],
'משוגע'=>['he',],
'משחק'=>['he',],
'משך'=>['yi',],
'משם'=>['he',],
'משנה'=>['he',],
'משפּחה'=>['yi',],
'משפחה'=>['he',],
'מת'=>['he',],
'מתה'=>['he',],
'מתוק'=>['he',],
'מתוקה'=>['he',],
'מתחיל'=>['he',],
'מתחת'=>['he',],
'מתי'=>['he',],
'מתים'=>['he',],
'מתכוון'=>['he',],
'מתכוונת'=>['he',],
'מײַן'=>['yi',],
'מײַנע'=>['yi',],
'נאַכט'=>['yi',],
'נאָך'=>['yi',],
'נאָכן'=>['yi',],
'נאָמען'=>['yi',],
'נאָר'=>['yi',],
'נגד'=>['he',],
'נגמר'=>['he',],
'נהדר'=>['he',],
'נהיה'=>['he',],
'נו'=>['he',],
'נוכל'=>['he',],
'נוסף'=>['he',],
'נורא'=>['he',],
'נותן'=>['he',],
'נזוז'=>['he',],
'נחמד'=>['he',],
'ניו־יאָרק'=>['yi',],
'ניט'=>['yi',],
'ניסיתי'=>['he',],
'נישטאָ'=>['yi',],
'ניתן'=>['he',],
'נכון'=>['he',],
'נכנס'=>['he',],
'נלך'=>['he',],
'נמצא'=>['he',],
'נמצאת'=>['he',],
'נעים'=>['he',],
'נעמט'=>['yi',],
'נעמען'=>['yi',],
'נעשה'=>['he',],
'נפלא'=>['he',],
'נראה'=>['he',],
'נראית'=>['he',],
'נשאר'=>['he',],
'נשים'=>['he',],
'נשמה'=>['yi',],
'נשמע'=>['he',],
'נתן'=>['he',],
'נתראה'=>['he',],
'נײַע'=>['yi',],
'נײַעם'=>['yi',],
'נײַער'=>['yi',],
'ס'=>['he',],
'סאַמע'=>['yi',],
'סאָוועטישע'=>['yi',],
'סאָוועטישער'=>['yi',],
'סאָלדאַטן'=>['yi',],
'סוג'=>['he',],
'סוף'=>['he','yi',],
'סטודענטן'=>['yi',],
'סי'=>['he',],
'סיבה'=>['he',],
'סיכוי'=>['he',],
'סיפור'=>['he',],
'סיריע'=>['yi',],
'סך'=>['yi',],
'סלח'=>['he',],
'סליחה'=>['he',],
'סעפּטעמבער'=>['yi',],
'ספק'=>['he',],
'ספר'=>['he',],
'סתם'=>['he',],
'סײַ'=>['yi',],
'ס׳איז'=>['yi',],
'ס׳רובֿ'=>['yi',],
'עבודה'=>['he',],
'עבור'=>['he',],
'עבר'=>['he',],
'עד'=>['he',],
'עדיין'=>['he',],
'עדיף'=>['he',],
'עובד'=>['he',],
'עובדת'=>['he',],
'עוד'=>['he',],
'עולה'=>['he',],
'עולם'=>['yi',],
'עומד'=>['he',],
'עושה'=>['he',],
'עושים'=>['he',],
'עזוב'=>['he',],
'עזרה'=>['he',],
'עטלעכע'=>['yi',],
'עיקר'=>['yi',],
'עכשיו'=>['he',],
'על'=>['he',],
'עלטער'=>['yi',],
'עלטערן'=>['yi',],
'עלי'=>['he',],
'עליה'=>['he',],
'עליהם'=>['he',],
'עליו'=>['he',],
'עליי'=>['he',],
'עלייך'=>['he',],
'עליך'=>['he',],
'עלינו'=>['he',],
'עם'=>['he',],
'ענגליש'=>['yi',],
'ענטפֿער'=>['yi',],
'עניין'=>['he',],
'ענין'=>['yi',],
'עס'=>['yi',],
'עסן'=>['yi',],
'עפּעס'=>['yi',],
'עצור'=>['he',],
'עצמו'=>['he',],
'עצמי'=>['he',],
'עצמך'=>['he',],
'ערב'=>['he',],
'ערד'=>['yi',],
'ערשט'=>['yi',],
'ערשטן'=>['yi',],
'ערשטע'=>['yi',],
'ערשטער'=>['yi',],
'עשה'=>['he',],
'עשינו'=>['he',],
'עשית'=>['he',],
'עשיתי'=>['he',],
'עשר'=>['he',],
'פּאַלעסטינער'=>['yi',],
'פּאַרטיי'=>['yi',],
'פּאָליטיק'=>['yi',],
'פּאָליטישע'=>['yi',],
'פּאָר'=>['yi',],
'פּוילן'=>['yi',],
'פּונקט'=>['yi',],
'פּיעסע'=>['yi',],
'פּנים'=>['yi',],
'פּרעזידענט'=>['yi',],
'פּרעמיער'=>['yi',],
'פּרץ'=>['yi',],
'פּרשה'=>['yi',],
'פֿאַל'=>['yi',],
'פֿאַר'=>['yi',],
'פֿאַראַן'=>['yi',],
'פֿאַראייניקטע'=>['yi',],
'פֿאַרבונדן'=>['yi',],
'פֿאַרבליבן'=>['yi',],
'פֿאַרגעסן'=>['yi',],
'פֿאַרלאָזן'=>['yi',],
'פֿאַרמאָגט'=>['yi',],
'פֿאַרן'=>['yi',],
'פֿאַרענדיקט'=>['yi',],
'פֿאַרשטאַנען'=>['yi',],
'פֿאַרשטייט'=>['yi',],
'פֿאַרשטיין'=>['yi',],
'פֿאַרשידענע'=>['yi',],
'פֿאַרשיידענע'=>['yi',],
'פֿאָטער'=>['yi',],
'פֿאָלק'=>['yi',],
'פֿאָר'=>['yi',],
'פֿאָרגעקומען'=>['yi',],
'פֿאָרווערטס'=>['yi',],
'פֿאָרן'=>['yi',],
'פֿאָרשטעלונג'=>['yi',],
'פֿול'=>['yi',],
'פֿונעם'=>['yi',],
'פֿיל'=>['yi',],
'פֿילם'=>['yi',],
'פֿינף'=>['yi',],
'פֿיר'=>['yi',],
'פֿירט'=>['yi',],
'פֿירן'=>['yi',],
'פֿירער'=>['yi',],
'פֿלעגט'=>['yi',],
'פֿלעגן'=>['yi',],
'פֿראַגע'=>['yi',],
'פֿרוי'=>['yi',],
'פֿרויען'=>['yi',],
'פֿריִער'=>['yi',],
'פֿרײַנד'=>['yi',],
'פה'=>['he',],
'פול'=>['he',],
'פחות'=>['he',],
'פי'=>['he',],
'פנים'=>['he',],
'פנימה'=>['he',],
'פעם'=>['he',],
'פעמים'=>['he',],
'פרנק'=>['he',],
'פשוט'=>['he',],
'צא'=>['he',],
'צאָל'=>['yi',],
'צודק'=>['he',],
'צוויי'=>['yi',],
'צווייטן'=>['yi',],
'צווייטע'=>['yi',],
'צווייטער'=>['yi',],
'צווישן'=>['yi',],
'צוות'=>['he',],
'צוזאַמען'=>['yi',],
'צוחק'=>['he',],
'צוליב'=>['yi',],
'צום'=>['yi',],
'צוריק'=>['yi',],
'צי'=>['yi',],
'ציל'=>['yi',],
'צעיר'=>['he',],
'צענדליקער'=>['yi',],
'צענטער'=>['yi',],
'צריך'=>['he',],
'צריכה'=>['he',],
'צריכים'=>['he',],
'צײַט'=>['yi',],
'צײַטונג'=>['yi',],
'צײַטן'=>['yi',],
'קאָן'=>['yi',],
'קאָנפֿערענץ'=>['yi',],
'קאָפּ'=>['yi',],
'קדימה'=>['he',],
'קהילה'=>['yi',],
'קודם'=>['he',],
'קולטור'=>['yi',],
'קומט'=>['yi',],
'קומען'=>['yi',],
'קונסט'=>['yi',],
'קורא'=>['he',],
'קוראים'=>['he',],
'קורה'=>['he',],
'קח'=>['he',],
'קחי'=>['he',],
'קטן'=>['he',],
'קטנה'=>['he',],
'קיבלתי'=>['he',],
'קיין'=>['yi',],
'קיינער'=>['yi',],
'קינד'=>['yi',],
'קינדער'=>['yi',],
'קינסטלער'=>['yi',],
'קל'=>['he',],
'קלאָר'=>['yi',],
'קליינע'=>['yi',],
'קעגן'=>['yi',],
'קען'=>['yi',],
'קענען'=>['yi',],
'קפה'=>['he',],
'קפטן'=>['he',],
'קצת'=>['he',],
'קר'=>['he',],
'קרבנות'=>['yi',],
'קרה'=>['he',],
'קרוב'=>['he',],
'קשה'=>['he',],
'קשור'=>['he',],
'קשר'=>['he',],
'ר'=>['he',],
'ראָלע'=>['yi',],
'ראָמאַן'=>['yi',],
'ראה'=>['he',],
'ראית'=>['he',],
'ראיתי'=>['he',],
'ראש'=>['he',],
'ראשון'=>['he',],
'רב'=>['he',],
'רבה'=>['he',],
'רבי'=>['yi',],
'רגע'=>['he',],
'רד'=>['he',],
'רואה'=>['he',],
'רואים'=>['he',],
'רוח'=>['he',],
'רוסיש'=>['yi',],
'רוסישע'=>['yi',],
'רוסישער'=>['yi',],
'רוסלאַנד'=>['yi',],
'רופֿט'=>['yi',],
'רוצה'=>['he',],
'רוצים'=>['he',],
'רחוק'=>['he',],
'רייד'=>['yi',],
'רייטשעל'=>['yi',],
'רע'=>['he',],
'רעגירונג'=>['yi',],
'רעדט'=>['yi',],
'רעדן'=>['yi',],
'רעיון'=>['he',],
'רצה'=>['he',],
'רציני'=>['he',],
'רציתי'=>['he',],
'רק'=>['he',],
'ש'=>['he',],
'שאַפֿן'=>['yi',],
'שאוכל'=>['he',],
'שאולי'=>['he',],
'שאין'=>['he',],
'שאלה'=>['he',],
'שאלות'=>['he',],
'שאם'=>['he',],
'שאמרתי'=>['he',],
'שאנו'=>['he',],
'שאנחנו'=>['he',],
'שאני'=>['he',],
'שאת'=>['he',],
'שאתה'=>['he',],
'שאתם'=>['he',],
'שב'=>['he',],
'שבו'=>['he',],
'שבוע'=>['he',],
'שבת'=>['yi',],
'שהוא'=>['he',],
'שהיא'=>['he',],
'שהיה'=>['he',],
'שהייתי'=>['he',],
'שהם'=>['he',],
'שוב'=>['he',],
'שווה'=>['he',],
'שוועסטער'=>['yi',],
'שווער'=>['yi',],
'שוטר'=>['he',],
'שוין'=>['yi',],
'שול'=>['yi',],
'שום'=>['he','yi',],
'שומע'=>['he',],
'שונא'=>['he',],
'שונה'=>['he',],
'שזה'=>['he',],
'שזו'=>['he',],
'שטאַטן'=>['yi',],
'שטאַרק'=>['yi',],
'שטאָט'=>['yi',],
'שטויות'=>['he',],
'שטייט'=>['yi',],
'שטעט'=>['yi',],
'שטעטל'=>['yi',],
'שטעלט'=>['yi',],
'שטעלן'=>['yi',],
'שטענדיק'=>['yi',],
'שיהיה'=>['he',],
'שיל'=>['yi',],
'שים'=>['he',],
'שיש'=>['he',],
'שכל'=>['he',],
'שכן'=>['he',],
'של'=>['he',],
'שלא'=>['he',],
'שלה'=>['he',],
'שלהם'=>['he',],
'שלו'=>['he',],
'שלום'=>['he','yi',],
'שלומך'=>['he',],
'שלוש'=>['he',],
'שלושה'=>['he',],
'שלי'=>['he',],
'שלך'=>['he',],
'שלכם'=>['he',],
'שלנו'=>['he',],
'שם'=>['he',],
'שמה'=>['he',],
'שמו'=>['he',],
'שמח'=>['he',],
'שמחה'=>['he',],
'שמי'=>['he',],
'שמישהו'=>['he',],
'שמך'=>['he',],
'שמעת'=>['he',],
'שמעתי'=>['he',],
'שנה'=>['he',],
'שני'=>['he',],
'שניות'=>['he',],
'שניכם'=>['he',],
'שנים'=>['he',],
'שעה'=>['he',],
'שעות'=>['he',],
'שפּילט'=>['yi',],
'שפּילן'=>['yi',],
'שפּעטער'=>['yi',],
'שפּראַך'=>['yi',],
'שצריך'=>['he',],
'שקט'=>['he',],
'שקרה'=>['he',],
'שרה'=>['he',],
'שרײַבט'=>['yi',],
'שרײַבן'=>['yi',],
'שרײַבער'=>['yi',],
'שש'=>['he',],
'שתוק'=>['he',],
'שתי'=>['he',],
'שתיים'=>['he',],
'שײַכות'=>['yi',],
'תּורה'=>['yi',],
'תּמיד'=>['yi',],
'תּקופֿה'=>['yi',],
'תא'=>['he',],
'תביא'=>['he',],
'תגיד'=>['he',],
'תגידי'=>['he',],
'תדאג'=>['he',],
'תדאגי'=>['he',],
'תהיה'=>['he',],
'תהיי'=>['he',],
'תודה'=>['he',],
'תוך'=>['he',],
'תוכל'=>['he',],
'תוכלי'=>['he',],
'תורגם'=>['he',],
'תוריד'=>['he',],
'תחזור'=>['he',],
'תחשוב'=>['he',],
'תחת'=>['he',],
'תירגע'=>['he',],
'תלך'=>['he',],
'תמיד'=>['he',],
'תמשיך'=>['he',],
'תן'=>['he',],
'תנו'=>['he',],
'תני'=>['he',],
'תסתכל'=>['he',],
'תעשה'=>['he',],
'תעשי'=>['he',],
'תפסיק'=>['he',],
'תקשיב'=>['he',],
'תקשיבי'=>['he',],
'תראה'=>['he',],
'תראו'=>['he',],
'תראי'=>['he',],
'תרצה'=>['he',],
'آ'=>['ur',],
'آؤ'=>['ur',],
'آئی'=>['ur',],
'آئیں'=>['ur',],
'آئیے'=>['ur',],
'آئے'=>['ur',],
'آب'=>['fa',],
'آتا'=>['ur',],
'آتش'=>['fa',],
'آتی'=>['ur',],
'آج'=>['ur',],
'آخر'=>['ar','fa',],
'آخرين'=>['fa',],
'آخری'=>['ur',],
'آداب'=>['ur',],
'آدم'=>['fa',],
'آدمی'=>['ur',],
'آدمیوں'=>['ur',],
'آرام'=>['ur',],
'آره'=>['fa',],
'آروم'=>['fa',],
'آرہا'=>['ur',],
'آزاد'=>['fa','ur',],
'آسان'=>['ur',],
'آسف'=>['ar',],
'آسفة'=>['ar',],
'آفیسر'=>['ur',],
'آقا'=>['fa',],
'آقاي'=>['fa',],
'آقای'=>['fa',],
'آماده'=>['fa',],
'آمد'=>['ur',],
'آمدید'=>['ur',],
'آن'=>['fa',],
'آنجا'=>['fa',],
'آنسة'=>['ar',],
'آنها'=>['fa',],
'آنے'=>['ur',],
'آه'=>['ar','fa',],
'آواز'=>['ur',],
'آوازیں'=>['ur',],
'آيا'=>['fa',],
'آينده'=>['fa',],
'آپ'=>['ur',],
'آپکو'=>['ur',],
'آپکی'=>['ur',],
'آپکے'=>['ur',],
'آگے'=>['ur',],
'آیا'=>['ur',],
'أبحث'=>['ar',],
'أبدا'=>['ar',],
'أبى'=>['ar',],
'أبي'=>['ar',],
'أتحدث'=>['ar',],
'أتذكر'=>['ar',],
'أتريد'=>['ar',],
'أتعرف'=>['ar',],
'أتعلم'=>['ar',],
'أتمنى'=>['ar',],
'أتيت'=>['ar',],
'أثناء'=>['ar',],
'أجل'=>['ar',],
'أحاول'=>['ar',],
'أحب'=>['ar',],
'أحبك'=>['ar',],
'أحتاج'=>['ar',],
'أحد'=>['ar',],
'أحدهم'=>['ar',],
'أحصل'=>['ar',],
'أحضر'=>['ar',],
'أحمق'=>['ar',],
'أخبرتك'=>['ar',],
'أخبرك'=>['ar',],
'أخبرني'=>['ar',],
'أخذ'=>['ar',],
'أخر'=>['ar',],
'أخرج'=>['ar',],
'أخرى'=>['ar',],
'أخي'=>['ar',],
'أدري'=>['ar',],
'أذهب'=>['ar',],
'أراك'=>['ar',],
'أربعة'=>['ar',],
'أرجوك'=>['ar',],
'أردت'=>['ar',],
'أرى'=>['ar',],
'أريد'=>['ar',],
'أريدك'=>['ar',],
'أستطيع'=>['ar',],
'أسرع'=>['ar',],
'أسف'=>['ar',],
'أسفل'=>['ar',],
'أسمع'=>['ar',],
'أشعر'=>['ar',],
'أشياء'=>['ar',],
'أصبح'=>['ar',],
'أصبحت'=>['ar',],
'أصدق'=>['ar',],
'أصدقاء'=>['ar',],
'أطفال'=>['ar',],
'أطلق'=>['ar',],
'أظن'=>['ar',],
'أعتقد'=>['ar',],
'أعرف'=>['ar',],
'أعطني'=>['ar',],
'أعلم'=>['ar',],
'أعمل'=>['ar',],
'أعني'=>['ar',],
'أعود'=>['ar',],
'أفضل'=>['ar',],
'أفعل'=>['ar',],
'أفكر'=>['ar',],
'أفهم'=>['ar',],
'أقصد'=>['ar',],
'أقل'=>['ar',],
'أقول'=>['ar',],
'أقوم'=>['ar',],
'أكبر'=>['ar',],
'أكثر'=>['ar',],
'أكن'=>['ar',],
'أكون'=>['ar',],
'ألا'=>['ar',],
'ألف'=>['ar',],
'ألم'=>['ar',],
'أليس'=>['ar',],
'أم'=>['ar',],
'أمام'=>['ar',],
'أمر'=>['ar',],
'أمس'=>['ar',],
'أمك'=>['ar',],
'أمى'=>['ar',],
'أمي'=>['ar',],
'أن'=>['ar',],
'أنا'=>['ar',],
'أنت'=>['ar',],
'أنتظر'=>['ar',],
'أنتم'=>['ar',],
'أنتي'=>['ar',],
'أنظر'=>['ar',],
'أنك'=>['ar',],
'أننا'=>['ar',],
'أننى'=>['ar',],
'أنني'=>['ar',],
'أنه'=>['ar',],
'أنها'=>['ar',],
'أنهم'=>['ar',],
'أني'=>['ar',],
'أهذا'=>['ar',],
'أو'=>['ar',],
'أود'=>['ar',],
'أول'=>['ar',],
'أولئك'=>['ar',],
'أوه'=>['ar',],
'أى'=>['ar',],
'أي'=>['ar',],
'أيام'=>['ar',],
'أية'=>['ar',],
'أيتها'=>['ar',],
'أيضا'=>['ar',],
'أين'=>['ar',],
'أيها'=>['ar',],
'إثنان'=>['ar',],
'إذا'=>['ar',],
'إذن'=>['ar',],
'إذهب'=>['ar',],
'إلا'=>['ar',],
'إلهى'=>['ar',],
'إلهي'=>['ar',],
'إلى'=>['ar',],
'إلي'=>['ar',],
'إليك'=>['ar',],
'إليه'=>['ar',],
'إليها'=>['ar',],
'إن'=>['ar',],
'إنتظر'=>['ar',],
'إنك'=>['ar',],
'إننا'=>['ar',],
'إنني'=>['ar',],
'إنه'=>['ar',],
'إنها'=>['ar',],
'إنهم'=>['ar',],
'إني'=>['ar',],
'اب'=>['ur',],
'ابتعد'=>['ar',],
'ابدا'=>['ar',],
'ابن'=>['ar',],
'ابي'=>['ar',],
'ابھی'=>['ur',],
'ات'=>['fa',],
'اتاق'=>['fa',],
'اتصل'=>['ar',],
'اتفاق'=>['fa',],
'اتفاقي'=>['fa',],
'اتنا'=>['ur',],
'اتنی'=>['ur',],
'اتنے'=>['ur',],
'اجازت'=>['ur',],
'اجازه'=>['fa',],
'اجتماعات'=>['ur',],
'اجل'=>['ar',],
'احب'=>['ar',],
'احتياج'=>['fa',],
'احتیاط'=>['ur',],
'احد'=>['ar',],
'احساس'=>['fa',],
'احمق'=>['fa',],
'اخر'=>['ar',],
'اخرج'=>['ar',],
'اخرى'=>['ar',],
'ادامه'=>['fa',],
'ادوارد'=>['fa',],
'ادویات'=>['ur',],
'ادھر'=>['ur',],
'اذا'=>['ar',],
'اذن'=>['ar',],
'اذهب'=>['ar',],
'ار'=>['fa',],
'ارباب'=>['fa',],
'ارتش'=>['fa',],
'ارجوك'=>['ar',],
'اردو'=>['ur',],
'اره'=>['fa',],
'اريد'=>['ar',],
'ارے'=>['ur',],
'از'=>['fa','ur',],
'ازت'=>['fa',],
'ازدواج'=>['fa',],
'ازش'=>['fa',],
'ازم'=>['fa',],
'اس'=>['ur',],
'است'=>['fa',],
'استاد'=>['fa',],
'استراحت'=>['fa',],
'استطيع'=>['ar',],
'استعمال'=>['ur',],
'استفاده'=>['fa',],
'اسف'=>['ar',],
'اسلئے'=>['ur',],
'اسلحه'=>['fa',],
'اسلحہ'=>['ur',],
'اسم'=>['ar','fa',],
'اسمع'=>['ar',],
'اسمك'=>['ar',],
'اسمه'=>['ar',],
'اسمي'=>['ar',],
'اسپیکر'=>['ur',],
'اسکا'=>['ur',],
'اسکی'=>['ur',],
'اسکیپر'=>['fa',],
'اسی'=>['ur',],
'اسے'=>['ur',],
'اش'=>['fa',],
'اشتباه'=>['fa',],
'اشعر'=>['ar',],
'اصل'=>['ur',],
'اصلا'=>['fa',],
'اطلاعات'=>['ur',],
'اعتبار'=>['ur',],
'اعتقاد'=>['fa',],
'اعتقد'=>['ar',],
'اعتقدت'=>['ar',],
'اعتماد'=>['fa','ur',],
'اعرف'=>['ar',],
'اعلان'=>['ur',],
'اعلم'=>['ar',],
'افتاد'=>['fa',],
'افتاده'=>['fa',],
'افتخار'=>['fa',],
'افراد'=>['fa',],
'افسر'=>['ur',],
'افضل'=>['ar',],
'افعل'=>['ar',],
'اقول'=>['ar',],
'اكثر'=>['ar',],
'اكون'=>['ar',],
'الآخر'=>['ar',],
'الآن'=>['ar',],
'الأحمق'=>['ar',],
'الأخرى'=>['ar',],
'الأخيرة'=>['ar',],
'الأرض'=>['ar',],
'الأسبوع'=>['ar',],
'الأشخاص'=>['ar',],
'الأشياء'=>['ar',],
'الأطفال'=>['ar',],
'الأفضل'=>['ar',],
'الأقل'=>['ar',],
'الأمر'=>['ar',],
'الأمور'=>['ar',],
'الأن'=>['ar',],
'الأول'=>['ar',],
'الأولى'=>['ar',],
'الأيام'=>['ar',],
'الإطلاق'=>['ar',],
'الا'=>['ar',],
'الاشياء'=>['ar',],
'الاقوامی'=>['ur',],
'الامر'=>['ar',],
'الان'=>['ar','fa',],
'الباب'=>['ar',],
'البته'=>['fa',],
'البحر'=>['ar',],
'البداية'=>['ar',],
'البعض'=>['ar',],
'البقاء'=>['ar',],
'البيت'=>['ar',],
'التحدث'=>['ar',],
'الترجمة'=>['ar',],
'التفكير'=>['ar',],
'التى'=>['ar',],
'التي'=>['ar',],
'الثانية'=>['ar',],
'الجانب'=>['ar',],
'الجحيم'=>['ar',],
'الجديد'=>['ar',],
'الجديدة'=>['ar',],
'الجميع'=>['ar',],
'الجنس'=>['ar',],
'الجيد'=>['ar',],
'الجيش'=>['ar',],
'الحال'=>['ar','ur',],
'الحب'=>['ar',],
'الحديث'=>['ar',],
'الحرب'=>['ar',],
'الحصول'=>['ar',],
'الحظ'=>['ar',],
'الحقيقة'=>['ar',],
'الحياة'=>['ar',],
'الخارج'=>['ar',],
'الخاص'=>['ar',],
'الخاصة'=>['ar',],
'الخروج'=>['ar',],
'الخير'=>['ar',],
'الداخل'=>['ar',],
'الدخول'=>['ar',],
'الذهاب'=>['ar',],
'الذى'=>['ar',],
'الذي'=>['ar',],
'الذين'=>['ar',],
'الرئيس'=>['ar',],
'الرب'=>['ar',],
'الرجال'=>['ar',],
'الرجل'=>['ar',],
'الزواج'=>['ar',],
'الساعة'=>['ar',],
'السبب'=>['ar',],
'السجن'=>['ar',],
'السلامة'=>['ar',],
'السماء'=>['ar',],
'السيارة'=>['ar',],
'السيد'=>['ar',],
'السيدة'=>['ar',],
'الشئ'=>['ar',],
'الشارع'=>['ar',],
'الشخص'=>['ar',],
'الشرطة'=>['ar',],
'الشمس'=>['ar',],
'الشيء'=>['ar',],
'الصباح'=>['ar',],
'الصغير'=>['ar',],
'الصغيرة'=>['ar',],
'الطائرة'=>['ar',],
'الطبيب'=>['ar',],
'الطريق'=>['ar',],
'الطريقة'=>['ar',],
'الطعام'=>['ar',],
'الطفل'=>['ar',],
'العالم'=>['ar',],
'العام'=>['ar',],
'العاهرة'=>['ar',],
'العجوز'=>['ar',],
'العديد'=>['ar',],
'العشاء'=>['ar',],
'العمل'=>['ar',],
'العودة'=>['ar',],
'الغرفة'=>['ar',],
'الـ'=>['ar',],
'الفتاة'=>['ar',],
'الفتى'=>['ar',],
'الفتيات'=>['ar',],
'القائد'=>['ar',],
'القادم'=>['ar',],
'القادمة'=>['ar',],
'القيام'=>['ar',],
'الكبير'=>['ar',],
'الكتاب'=>['ar',],
'الكثير'=>['ar',],
'الكلام'=>['ar',],
'الكلب'=>['ar',],
'اللعبة'=>['ar',],
'اللعنة'=>['ar',],
'اللعنه'=>['ar',],
'اللعين'=>['ar',],
'اللعينة'=>['ar',],
'اللقاء'=>['ar',],
'الله'=>['ar',],
'الليل'=>['ar',],
'الليلة'=>['ar',],
'الماء'=>['ar',],
'الماضي'=>['ar',],
'الماضية'=>['ar',],
'المال'=>['ar',],
'المحتمل'=>['ar',],
'المدرسة'=>['ar',],
'المدينة'=>['ar',],
'المرأة'=>['ar',],
'المرة'=>['ar',],
'المزيد'=>['ar',],
'المساعدة'=>['ar',],
'المسيح'=>['ar',],
'المشكلة'=>['ar',],
'المفترض'=>['ar',],
'المكان'=>['ar',],
'الملك'=>['ar',],
'الممكن'=>['ar',],
'المناسب'=>['ar',],
'المنزل'=>['ar',],
'المنطقة'=>['ar',],
'الموت'=>['ar','ur',],
'الموضوع'=>['ar',],
'النار'=>['ar',],
'الناس'=>['ar',],
'النساء'=>['ar',],
'النقود'=>['ar',],
'النهاية'=>['ar',],
'النوع'=>['ar',],
'النوم'=>['ar',],
'الهاتف'=>['ar',],
'الهراء'=>['ar',],
'الهواء'=>['ar',],
'الهي'=>['ar',],
'الواقع'=>['ar',],
'الوحيد'=>['ar',],
'الوحيدة'=>['ar',],
'الوضع'=>['ar',],
'الوغد'=>['ar',],
'الوقت'=>['ar',],
'الى'=>['ar',],
'الي'=>['ar',],
'اليس'=>['ar',],
'اليوم'=>['ar',],
'الٹ'=>['ur',],
'ام'=>['ar','fa',],
'اما'=>['fa',],
'امتحان'=>['fa',],
'امرأة'=>['ar',],
'امروز'=>['fa',],
'امریکہ'=>['ur',],
'امریکی'=>['ur',],
'امشب'=>['fa',],
'امن'=>['ur',],
'امي'=>['ar',],
'اميد'=>['fa',],
'اميدوارم'=>['fa',],
'امپراتور'=>['fa',],
'امید'=>['ur',],
'امیلیہ'=>['ur',],
'امیگریشن'=>['ur',],
'ان'=>['ar','ur',],
'انا'=>['ar','ur',],
'انت'=>['ar',],
'انتخاب'=>['fa',],
'انتظار'=>['fa','ur',],
'انتظر'=>['ar',],
'انتظري'=>['ar',],
'انتم'=>['ar',],
'انتهى'=>['ar',],
'انجام'=>['fa',],
'انجامش'=>['fa',],
'اند'=>['fa',],
'اندازه'=>['fa',],
'اندر'=>['ur',],
'اندي'=>['fa',],
'انسان'=>['fa','ur',],
'انسانیت'=>['ur',],
'انصاف'=>['ur',],
'انظر'=>['ar',],
'انظري'=>['ar',],
'انعام'=>['ur',],
'انك'=>['ar',],
'اننا'=>['ar',],
'اننى'=>['ar',],
'انني'=>['ar',],
'انه'=>['ar',],
'انها'=>['ar',],
'انهم'=>['ar',],
'اني'=>['ar',],
'انگار'=>['fa',],
'انگریزی'=>['ur',],
'انہوں'=>['ur',],
'انہیں'=>['ur',],
'او'=>['ar','fa',],
'اور'=>['ur',],
'اورات'=>['ur',],
'اوقات'=>['ur',],
'اول'=>['fa',],
'اولين'=>['fa',],
'اومد'=>['fa',],
'اومدم'=>['fa',],
'اومده'=>['fa',],
'اومدي'=>['fa',],
'اون'=>['fa',],
'اونا'=>['fa',],
'اونجا'=>['fa',],
'اونم'=>['fa',],
'اونها'=>['fa',],
'اونو'=>['fa',],
'اونٹ'=>['ur',],
'اوه'=>['ar','fa',],
'اوپر'=>['ur',],
'اوکے'=>['ur',],
'اوہ'=>['ur',],
'اى'=>['ar',],
'اي'=>['ar','fa',],
'ايضا'=>['ar',],
'اين'=>['ar','fa',],
'اينا'=>['fa',],
'اينجا'=>['fa',],
'اينجاست'=>['fa',],
'اينجام'=>['fa',],
'اينجوري'=>['fa',],
'اينطور'=>['fa',],
'اينطوري'=>['fa',],
'اينقدر'=>['fa',],
'اينكه'=>['fa',],
'اينه'=>['fa',],
'اينها'=>['fa',],
'اينو'=>['fa',],
'اينکارو'=>['fa',],
'اينکه'=>['fa',],
'ايها'=>['ar',],
'اٹھا'=>['ur',],
'اٹھائیں'=>['ur',],
'اپنا'=>['ur',],
'اپنی'=>['ur',],
'اپنے'=>['ur',],
'اچھا'=>['ur',],
'اچھی'=>['ur',],
'اچھے'=>['ur',],
'اڈے'=>['ur',],
'اگر'=>['fa','ur',],
'اگلے'=>['ur',],
'اگه'=>['fa',],
'اہم'=>['ur',],
'ای'=>['fa',],
'ایسا'=>['ur',],
'ایسی'=>['ur',],
'ایسے'=>['ur',],
'ایف'=>['ur',],
'این'=>['fa',],
'اینجا'=>['fa',],
'اینریکے'=>['ur',],
'ایپل'=>['ur',],
'ایچ'=>['ur',],
'ایک'=>['ur',],
'اے'=>['ur',],
'بأس'=>['ar',],
'بأن'=>['ar',],
'بأنك'=>['ar',],
'بأنني'=>['ar',],
'بأنه'=>['ar',],
'بأني'=>['ar',],
'بأي'=>['ar',],
'با'=>['fa',],
'بائیں'=>['ur',],
'بابا'=>['fa',],
'بات'=>['ur',],
'باتیں'=>['ur',],
'بادشاہ'=>['ur',],
'بار'=>['fa','ur',],
'بارہ'=>['ur',],
'بارے'=>['ur',],
'باز'=>['fa',],
'بازي'=>['fa',],
'بازی'=>['ur',],
'باش'=>['fa',],
'باشد'=>['fa',],
'باشم'=>['fa',],
'باشن'=>['fa',],
'باشند'=>['fa',],
'باشه'=>['fa',],
'باشي'=>['fa',],
'باشيد'=>['fa',],
'باشيم'=>['fa',],
'باشين'=>['fa',],
'باعث'=>['fa',],
'باقي'=>['fa',],
'بالا'=>['fa',],
'بالاخره'=>['fa',],
'بالتأكيد'=>['ar',],
'بالخارج'=>['ar',],
'بالداخل'=>['ar',],
'بالضبط'=>['ar',],
'بالطبع'=>['ar',],
'بالفعل'=>['ar',],
'بالنسبة'=>['ar',],
'بالکل'=>['ur',],
'باهات'=>['fa',],
'باهاش'=>['fa',],
'باور'=>['fa',],
'بايد'=>['fa',],
'باپ'=>['ur',],
'باہر'=>['ur',],
'باید'=>['fa',],
'ببخشيد'=>['fa',],
'ببر'=>['fa',],
'ببعض'=>['ar',],
'ببين'=>['fa',],
'ببينم'=>['fa',],
'ببيني'=>['fa',],
'بتا'=>['ur',],
'بتاؤ'=>['ur',],
'بتاؤں'=>['ur',],
'بتانا'=>['ur',],
'بتانے'=>['ur',],
'بتایا'=>['ur',],
'بتلك'=>['ar',],
'بتونم'=>['fa',],
'بحاجة'=>['ar',],
'بحران'=>['ur',],
'بحق'=>['ar',],
'بخاطر'=>['fa',],
'بخصوص'=>['ar',],
'بخير'=>['ar','fa',],
'بخیر'=>['ur',],
'بد'=>['ar','fa','ur',],
'بدأ'=>['ar',],
'بدأت'=>['ar',],
'بدست'=>['fa',],
'بدل'=>['ur',],
'بدلے'=>['ur',],
'بدم'=>['fa',],
'بدن'=>['fa',],
'بده'=>['fa',],
'بدون'=>['ar','fa',],
'بدونم'=>['fa',],
'بدوني'=>['fa',],
'بدي'=>['fa',],
'بديد'=>['fa',],
'بديم'=>['fa',],
'بدين'=>['fa',],
'بدھ'=>['ur',],
'بذار'=>['fa',],
'بذلك'=>['ar',],
'بر'=>['fa',],
'برائے'=>['ur',],
'برابر'=>['fa',],
'برات'=>['fa',],
'برادر'=>['fa',],
'براش'=>['fa',],
'برام'=>['fa',],
'براي'=>['fa',],
'برايه'=>['fa',],
'برای'=>['fa',],
'برم'=>['fa',],
'برنامه'=>['fa',],
'بره'=>['fa',],
'برو'=>['fa',],
'بري'=>['fa',],
'بريد'=>['fa',],
'بريم'=>['fa',],
'برين'=>['fa',],
'برگر'=>['ur',],
'برگرد'=>['fa',],
'بری'=>['ur',],
'بزار'=>['fa',],
'بزدل'=>['ur',],
'بزرگ'=>['fa',],
'بزرگي'=>['fa',],
'بزن'=>['fa',],
'بزنم'=>['fa',],
'بزنه'=>['fa',],
'بزني'=>['fa',],
'بس'=>['fa','ur',],
'بسبب'=>['ar',],
'بسته'=>['fa',],
'بسرعة'=>['ar',],
'بسه'=>['fa',],
'بسيار'=>['fa',],
'بشأن'=>['ar',],
'بشكل'=>['ar',],
'بشم'=>['fa',],
'بشه'=>['fa',],
'بشي'=>['fa',],
'بشيء'=>['ar',],
'بشيم'=>['fa',],
'بشين'=>['fa',],
'بضعة'=>['ar',],
'بطريقة'=>['ar',],
'بعد'=>['ar','fa','ur',],
'بعدش'=>['fa',],
'بعدي'=>['fa',],
'بعض'=>['ar','ur',],
'بعضنا'=>['ar',],
'بعضي'=>['fa',],
'بعيدا'=>['ar',],
'بغیر'=>['ur',],
'بـ'=>['ar',],
'بقایا'=>['ur',],
'بقيه'=>['fa',],
'بك'=>['ar',],
'بكل'=>['ar',],
'بكم'=>['ar',],
'بل'=>['ar',],
'بلا'=>['ar','ur',],
'بلاؤ'=>['ur',],
'بلغارین'=>['ur',],
'بلند'=>['fa','ur',],
'بله'=>['fa',],
'بلکہ'=>['ur',],
'بما'=>['ar',],
'بمباری'=>['ur',],
'بمون'=>['fa',],
'بن'=>['fa','ur',],
'بنا'=>['ar','ur',],
'بنائیں'=>['ur',],
'بنابراين'=>['fa',],
'بناتے'=>['ur',],
'بند'=>['ur',],
'بندی'=>['ur',],
'بنفسك'=>['ar',],
'بنیاد'=>['ur',],
'به'=>['ar','fa',],
'بها'=>['ar',],
'بهت'=>['fa',],
'بهتر'=>['fa',],
'بهتره'=>['fa',],
'بهترين'=>['fa',],
'بهتون'=>['fa',],
'بهذا'=>['ar',],
'بهذه'=>['ar',],
'بهش'=>['fa',],
'بهشون'=>['fa',],
'بهم'=>['ar','fa',],
'بواسطة'=>['ar',],
'بوب'=>['ar',],
'بوتھ'=>['ur',],
'بود'=>['fa',],
'بودم'=>['fa',],
'بودن'=>['fa',],
'بودند'=>['fa',],
'بوده'=>['fa',],
'بودي'=>['fa',],
'بوديم'=>['fa',],
'بول'=>['ar','ur',],
'بولتے'=>['ur',],
'بى'=>['ar',],
'بي'=>['ar','fa',],
'بيا'=>['fa',],
'بياد'=>['fa',],
'بيار'=>['fa',],
'بيام'=>['fa',],
'بياين'=>['fa',],
'بيت'=>['ar',],
'بيتر'=>['ar',],
'بيدار'=>['fa',],
'بيرون'=>['fa',],
'بيست'=>['fa',],
'بيش'=>['fa',],
'بيشتر'=>['fa',],
'بيشتري'=>['fa',],
'بيل'=>['ar',],
'بين'=>['ar','fa',],
'بينما'=>['ar',],
'بيننا'=>['ar',],
'بيني'=>['fa',],
'بچ'=>['ur',],
'بچا'=>['ur',],
'بچائی'=>['ur',],
'بچه'=>['fa',],
'بچوں'=>['ur',],
'بچے'=>['ur',],
'بڑا'=>['ur',],
'بڑی'=>['ur',],
'بکری'=>['ur',],
'بکنم'=>['fa',],
'بکنه'=>['fa',],
'بکني'=>['fa',],
'بکواس'=>['ur',],
'بگ'=>['ur',],
'بگم'=>['fa',],
'بگو'=>['fa',],
'بگي'=>['fa',],
'بگير'=>['fa',],
'بگيرم'=>['fa',],
'بگيره'=>['fa',],
'بگيري'=>['fa',],
'بگيريم'=>['fa',],
'بھائی'=>['ur',],
'بھائیوں'=>['ur',],
'بھاگ'=>['ur',],
'بھاگنے'=>['ur',],
'بھاگو'=>['ur',],
'بھر'=>['ur',],
'بھول'=>['ur',],
'بھگتنا'=>['ur',],
'بھی'=>['ur',],
'بھیج'=>['ur',],
'بھیجا'=>['ur',],
'بھیجنا'=>['ur',],
'بہادری'=>['ur',],
'بہت'=>['ur',],
'بہتر'=>['ur',],
'بہترین'=>['ur',],
'بی'=>['ur',],
'بیا'=>['fa',],
'بیج'=>['ur',],
'بیرون'=>['fa',],
'بیس'=>['ur',],
'بین'=>['ur',],
'بینی'=>['ur',],
'بیوی'=>['ur',],
'بیٹھ'=>['ur',],
'بیٹھو'=>['ur',],
'بیٹے'=>['ur',],
'بیپر'=>['ur',],
'بیچارا'=>['ur',],
'بیگ'=>['ur',],
'بے'=>['ur',],
'تأتي'=>['ar',],
'تأخذ'=>['ar',],
'تا'=>['fa','ur',],
'تاج'=>['ur',],
'تاخیر'=>['ur',],
'تاریخ'=>['ur',],
'تازه'=>['fa',],
'تاکہ'=>['ur',],
'تاہم'=>['ur',],
'تبا'=>['ar',],
'تباہ'=>['ur',],
'تبدو'=>['ar',],
'تبديل'=>['fa',],
'تبدين'=>['ar',],
'تبقى'=>['ar',],
'تتحدث'=>['ar',],
'تتكلم'=>['ar',],
'تجویز'=>['ur',],
'تحاول'=>['ar',],
'تحب'=>['ar',],
'تحت'=>['ar','fa',],
'تحتاج'=>['ar',],
'تحدث'=>['ar',],
'تحرك'=>['ar',],
'تحصل'=>['ar',],
'تحفہ'=>['ur',],
'تحمل'=>['ar','fa',],
'تخبرني'=>['ar',],
'تختہ'=>['ur',],
'تذكر'=>['ar',],
'تذهب'=>['ar',],
'تر'=>['fa','ur',],
'ترجمة'=>['ar',],
'ترجمه'=>['fa',],
'ترجمہ'=>['ur',],
'ترى'=>['ar',],
'تريد'=>['ar',],
'تريدين'=>['ar',],
'تريسي'=>['fa',],
'ترين'=>['fa',],
'ترک'=>['fa',],
'ترین'=>['ur',],
'تستطيع'=>['ar',],
'تشارلي'=>['ar',],
'تشریف'=>['ur',],
'تشعر'=>['ar',],
'تصبح'=>['ar',],
'تصميم'=>['fa',],
'تصور'=>['fa',],
'تصویر'=>['ur',],
'تظن'=>['ar',],
'تعال'=>['ar',],
'تعالى'=>['ar',],
'تعالي'=>['ar',],
'تعتقد'=>['ar',],
'تعتقدين'=>['ar',],
'تعرف'=>['ar',],
'تعرفين'=>['ar',],
'تعلم'=>['ar',],
'تعلمين'=>['ar',],
'تعمل'=>['ar',],
'تعني'=>['ar',],
'تعود'=>['ar',],
'تعيش'=>['ar',],
'تغيير'=>['fa',],
'تفریح'=>['ur',],
'تفضل'=>['ar',],
'تفعل'=>['ar',],
'تفعله'=>['ar',],
'تفعلين'=>['ar',],
'تفكر'=>['ar',],
'تفنگ'=>['fa',],
'تفهم'=>['ar',],
'تقدیر'=>['ur',],
'تقلق'=>['ar',],
'تقول'=>['ar',],
'تقوم'=>['ar',],
'تكن'=>['ar',],
'تكون'=>['ar',],
'تكوني'=>['ar',],
'تلاش'=>['ur',],
'تلاشی'=>['ur',],
'تلك'=>['ar',],
'تلوار'=>['ur',],
'تم'=>['ar','ur',],
'تماس'=>['fa',],
'تمام'=>['fa','ur',],
'تماما'=>['ar',],
'تمت'=>['ar',],
'تموم'=>['fa',],
'تمومش'=>['fa',],
'تمہارا'=>['ur',],
'تمہاری'=>['ur',],
'تمہارے'=>['ur',],
'تمہیں'=>['ur',],
'تنخواہ'=>['ur',],
'تنظر'=>['ar',],
'تنها'=>['fa',],
'تنہا'=>['ur',],
'تو'=>['fa','ur',],
'توئه'=>['fa',],
'توجد'=>['ar',],
'توجه'=>['fa',],
'تورو'=>['fa',],
'توسط'=>['fa',],
'توقف'=>['ar',],
'توم'=>['ar',],
'تونستم'=>['fa',],
'تونم'=>['fa',],
'تونه'=>['fa',],
'توني'=>['fa',],
'تونيم'=>['fa',],
'توي'=>['fa',],
'توپ'=>['fa',],
'توڑ'=>['ur',],
'توی'=>['fa',],
'تيراندازي'=>['fa',],
'تيم'=>['fa',],
'تک'=>['ur',],
'تکون'=>['fa',],
'تھا'=>['ur',],
'تھرمین'=>['ur',],
'تھوڑا'=>['ur',],
'تھوڑی'=>['ur',],
'تھی'=>['ur',],
'تھیں'=>['ur',],
'تھے'=>['ur',],
'تہمینہ'=>['ur',],
'تیار'=>['ur',],
'تیاری'=>['ur',],
'تین'=>['ur',],
'ثابت'=>['ur',],
'ثانية'=>['ar',],
'ثانيه'=>['fa',],
'ثبوت'=>['ur',],
'ثلاث'=>['ar',],
'ثلاثة'=>['ar',],
'ثم'=>['ar',],
'جئت'=>['ar',],
'جا'=>['fa','ur',],
'جاء'=>['ar',],
'جاؤ'=>['ur',],
'جاؤں'=>['ur',],
'جائیں'=>['ur',],
'جائے'=>['ur',],
'جاتا'=>['ur',],
'جاتی'=>['ur',],
'جاتے'=>['ur',],
'جاری'=>['ur',],
'جاز'=>['ur',],
'جاسوس'=>['ur',],
'جاك'=>['ar',],
'جالب'=>['fa',],
'جام'=>['ur',],
'جان'=>['fa','ur',],
'جانا'=>['ur',],
'جانب'=>['ur',],
'جانتا'=>['ur',],
'جانتی'=>['ur',],
'جانتے'=>['ur',],
'جاننا'=>['ur',],
'جانے'=>['ur',],
'جاهز'=>['ar',],
'جاي'=>['fa',],
'جايي'=>['fa',],
'جب'=>['ur',],
'جبکہ'=>['ur',],
'جج'=>['ur',],
'جدا'=>['ar','fa',],
'جديد'=>['ar','fa',],
'جديدة'=>['ar',],
'جرم'=>['ur',],
'جزء'=>['ar',],
'جس'=>['ur',],
'جشن'=>['fa',],
'جلد'=>['ur',],
'جلدی'=>['ur',],
'جلو'=>['fa',],
'جلوي'=>['fa',],
'جمع'=>['fa',],
'جميع'=>['ar',],
'جميعا'=>['ar',],
'جميل'=>['ar',],
'جميلة'=>['ar',],
'جن'=>['fa',],
'جناب'=>['ur',],
'جنازے'=>['ur',],
'جنوبی'=>['ur',],
'جنگ'=>['fa','ur',],
'جنگل'=>['fa',],
'جنگلی'=>['ur',],
'جنہیں'=>['ur',],
'جهنم'=>['fa',],
'جو'=>['ar','ur',],
'جواب'=>['fa','ur',],
'جواز'=>['ur',],
'جوان'=>['fa','ur',],
'جوتے'=>['ur',],
'جور'=>['fa',],
'جورج'=>['ar',],
'جوري'=>['fa',],
'جوزفین'=>['ur',],
'جون'=>['ar','fa',],
'جي'=>['ar',],
'جيد'=>['ar',],
'جيدا'=>['ar',],
'جيدة'=>['ar',],
'جين'=>['ar',],
'جگہ'=>['ur',],
'جھوٹ'=>['ur',],
'جہاز'=>['ur',],
'جہاں'=>['ur',],
'جی'=>['ur',],
'جیسا'=>['ur',],
'جیسے'=>['ur',],
'جیل'=>['ur',],
'حاصل'=>['ur',],
'حاضر'=>['fa',],
'حافظ'=>['ur',],
'حال'=>['ar','fa',],
'حالا'=>['fa',],
'حالة'=>['ar',],
'حالت'=>['fa',],
'حالك'=>['ar',],
'حان'=>['ar',],
'حاول'=>['ar',],
'حاولت'=>['ar',],
'حبيبتي'=>['ar',],
'حتما'=>['fa',],
'حتى'=>['ar',],
'حتي'=>['ar','fa',],
'حدث'=>['ar',],
'حرف'=>['fa',],
'حرومزاده'=>['fa',],
'حرکت'=>['fa',],
'حس'=>['fa',],
'حساب'=>['fa',],
'حسن'=>['ar',],
'حسنا'=>['ar',],
'حسنسن'=>['ur',],
'حصل'=>['ar',],
'حصلت'=>['ar',],
'حصہ'=>['ur',],
'حضور'=>['ur',],
'حفاظت'=>['ur',],
'حفلة'=>['ar',],
'حق'=>['ar','fa','ur',],
'حقا'=>['ar',],
'حقيقة'=>['ar',],
'حقيقت'=>['fa',],
'حقيقي'=>['ar',],
'حل'=>['ur',],
'حلقه'=>['fa',],
'حمله'=>['fa',],
'حملہ'=>['ur',],
'حملے'=>['ur',],
'حوالات'=>['ur',],
'حول'=>['ar',],
'حياة'=>['ar',],
'حياتك'=>['ar',],
'حياتي'=>['ar',],
'حيث'=>['ar',],
'حين'=>['ar',],
'حينما'=>['ar',],
'حيوانات'=>['fa',],
'حکم'=>['ur',],
'حکومت'=>['ur',],
'حیران'=>['ur',],
'خائف'=>['ar',],
'خارج'=>['ar','fa',],
'خاطر'=>['fa',],
'خالی'=>['ur',],
'خاموش'=>['ur',],
'خاندان'=>['ur',],
'خانم'=>['fa',],
'خانه'=>['fa',],
'خانواده'=>['fa',],
'خانہ'=>['ur',],
'خب'=>['fa',],
'خبر'=>['fa','ur',],
'خبردار'=>['ur',],
'خبریں'=>['ur',],
'ختم'=>['ur',],
'خدا'=>['fa','ur',],
'خداؤں'=>['ur',],
'خداحافظ'=>['fa',],
'خداي'=>['fa',],
'خدایا'=>['ur',],
'خدمت'=>['fa',],
'خذ'=>['ar',],
'خراب'=>['fa',],
'خرس'=>['fa',],
'خرید'=>['ur',],
'خریداری'=>['ur',],
'خسته'=>['fa',],
'خصوصی'=>['ur',],
'خط'=>['fa',],
'خطأ'=>['ar',],
'خطر'=>['ar','fa',],
'خطرہ'=>['ur',],
'خفه'=>['fa',],
'خفیہ'=>['ur',],
'خلاف'=>['ur',],
'خلال'=>['ar',],
'خلف'=>['ar',],
'خمس'=>['ar',],
'خمسة'=>['ar',],
'خنجر'=>['ur',],
'خواب'=>['fa',],
'خواد'=>['fa',],
'خواست'=>['fa',],
'خواستم'=>['fa',],
'خوام'=>['fa',],
'خواهد'=>['fa',],
'خواهش'=>['fa',],
'خواهم'=>['fa',],
'خواهند'=>['fa',],
'خواهي'=>['fa',],
'خواي'=>['fa',],
'خواہ'=>['ur',],
'خوب'=>['fa',],
'خوبصورت'=>['ur',],
'خوبم'=>['fa',],
'خوبه'=>['fa',],
'خوبي'=>['fa',],
'خوبيه'=>['fa',],
'خود'=>['fa','ur',],
'خودت'=>['fa',],
'خودتو'=>['fa',],
'خودتون'=>['fa',],
'خودش'=>['fa',],
'خودم'=>['fa',],
'خودمون'=>['fa',],
'خوراک'=>['ur',],
'خورده'=>['fa',],
'خورشيد'=>['fa',],
'خوش'=>['fa','ur',],
'خوشحال'=>['fa',],
'خوشحالم'=>['fa',],
'خوشم'=>['fa',],
'خوشی'=>['ur',],
'خوف'=>['ur',],
'خوفزدہ'=>['ur',],
'خون'=>['fa','ur',],
'خونه'=>['fa',],
'خيال'=>['fa',],
'خيلي'=>['fa',],
'خیال'=>['ur',],
'خیر'=>['ur',],
'خیلی'=>['fa',],
'دائما'=>['ar',],
'داخل'=>['ar','fa','ur',],
'داخلے'=>['ur',],
'داد'=>['fa',],
'دادم'=>['fa',],
'دادن'=>['fa',],
'داده'=>['fa',],
'دادي'=>['fa',],
'دار'=>['fa',],
'دارد'=>['fa',],
'دارم'=>['fa',],
'دارن'=>['fa',],
'دارند'=>['fa',],
'داره'=>['fa',],
'داري'=>['fa',],
'داريد'=>['fa',],
'داريم'=>['fa',],
'دارين'=>['fa',],
'داریم'=>['fa',],
'داستان'=>['fa','ur',],
'داشت'=>['fa',],
'داشتم'=>['fa',],
'داشته'=>['fa',],
'داشتي'=>['fa',],
'دختر'=>['fa',],
'در'=>['fa',],
'دراصل'=>['ur',],
'دراڑ'=>['ur',],
'درباره'=>['fa',],
'درجہ'=>['ur',],
'درد'=>['fa',],
'درست'=>['fa','ur',],
'درسته'=>['fa',],
'درمیان'=>['ur',],
'دروازوں'=>['ur',],
'دروازے'=>['ur',],
'دروغ'=>['fa',],
'درک'=>['fa',],
'دس'=>['ur',],
'دست'=>['fa',],
'دستاویز'=>['ur',],
'دستخط'=>['ur',],
'دستور'=>['fa',],
'دستے'=>['ur',],
'دشمن'=>['fa',],
'دشمنوں'=>['ur',],
'دعنا'=>['ar',],
'دعني'=>['ar',],
'دعونا'=>['ar',],
'دعيني'=>['ar',],
'دفاع'=>['fa',],
'دفعه'=>['fa',],
'دفعہ'=>['ur',],
'دقائق'=>['ar',],
'دقيقا'=>['fa',],
'دقيقة'=>['ar',],
'دقيقه'=>['fa',],
'دكتور'=>['ar',],
'دل'=>['ur',],
'دلار'=>['fa',],
'دلم'=>['fa',],
'دليل'=>['fa',],
'دم'=>['fa',],
'دن'=>['fa','ur',],
'دنبال'=>['fa',],
'دنوں'=>['ur',],
'دنيا'=>['fa',],
'دنياي'=>['fa',],
'دنیا'=>['ur',],
'ده'=>['fa',],
'دهد'=>['fa',],
'دو'=>['fa','ur',],
'دوائی'=>['ur',],
'دوائیاں'=>['ur',],
'دوباره'=>['fa',],
'دوبارہ'=>['ur',],
'دوتا'=>['fa',],
'دور'=>['fa','ur',],
'دوران'=>['ur',],
'دوست'=>['fa','ur',],
'دوستت'=>['fa',],
'دوسری'=>['ur',],
'دوشیزه'=>['fa',],
'دولار'=>['ar',],
'دون'=>['ar',],
'دونم'=>['fa',],
'دونه'=>['fa',],
'دونوں'=>['ur',],
'دوني'=>['fa',],
'دوڑ'=>['ur',],
'دوں'=>['ur',],
'دي'=>['ar','fa',],
'ديدم'=>['fa',],
'ديده'=>['fa',],
'ديدي'=>['fa',],
'دير'=>['fa',],
'ديوانه'=>['fa',],
'ديوونه'=>['fa',],
'ديويد'=>['fa',],
'ديگر'=>['fa',],
'ديگري'=>['fa',],
'ديگه'=>['fa',],
'دکتر'=>['fa',],
'دکھاؤ'=>['ur',],
'دکھاؤں'=>['ur',],
'دکھایا'=>['ur',],
'دھوکا'=>['ur',],
'دھوکہ'=>['ur',],
'دھکا'=>['ur',],
'دی'=>['ur',],
'دیئے'=>['ur',],
'دیا'=>['ur',],
'دیتا'=>['ur',],
'دیتی'=>['ur',],
'دیتے'=>['ur',],
'دیجئے'=>['ur',],
'دیر'=>['ur',],
'دینا'=>['ur',],
'دینے'=>['ur',],
'دیوار'=>['ur',],
'دیواروں'=>['ur',],
'دیکھ'=>['ur',],
'دیکھا'=>['ur',],
'دیکھتی'=>['ur',],
'دیکھتے'=>['ur',],
'دیکھنا'=>['ur',],
'دیکھنے'=>['ur',],
'دیکھو'=>['ur',],
'دیکھیں'=>['ur',],
'دیکھے'=>['ur',],
'دیگه'=>['fa',],
'دیں'=>['ur',],
'دے'=>['ur',],
'ذا'=>['ar',],
'ذات'=>['ar',],
'ذاهب'=>['ar',],
'ذرا'=>['ur',],
'ذلك'=>['ar',],
'ذمہ'=>['ur',],
'ذهب'=>['ar',],
'ذهبت'=>['ar',],
'ذو'=>['ar',],
'ذہن'=>['ur',],
'رأسك'=>['ar',],
'رأيت'=>['ar',],
'رأيك'=>['ar',],
'رؤية'=>['ar',],
'رئيس'=>['ar','fa',],
'را'=>['fa',],
'رائع'=>['ar',],
'رائعة'=>['ar',],
'رابطے'=>['ur',],
'رات'=>['ur',],
'راجع'=>['fa',],
'راحت'=>['fa',],
'راز'=>['ur',],
'راست'=>['fa',],
'راستہ'=>['ur',],
'راستے'=>['ur',],
'راماڈہ'=>['ur',],
'راه'=>['fa',],
'راهي'=>['fa',],
'راہنمائی'=>['ur',],
'ربما'=>['ar',],
'رجاء'=>['ar',],
'رجال'=>['ar',],
'رجل'=>['ar',],
'رحم'=>['ur',],
'رد'=>['fa',],
'رسالة'=>['ar',],
'رسيد'=>['fa',],
'رفاق'=>['ar',],
'رفت'=>['fa',],
'رفتار'=>['fa',],
'رفتن'=>['fa',],
'رفته'=>['fa',],
'رفيق'=>['fa',],
'رقم'=>['ar',],
'رنگ'=>['ur',],
'رها'=>['fa',],
'رو'=>['fa',],
'روایت'=>['ur',],
'روح'=>['fa',],
'روز'=>['fa','ur',],
'روزي'=>['fa',],
'روسی'=>['ur',],
'روش'=>['fa',],
'روشن'=>['fa',],
'روي'=>['fa',],
'روک'=>['ur',],
'روکنا'=>['ur',],
'روکنے'=>['ur',],
'رک'=>['ur',],
'رکو'=>['ur',],
'رکھ'=>['ur',],
'رکھا'=>['ur',],
'رکھتے'=>['ur',],
'رکھنا'=>['ur',],
'رکھنے'=>['ur',],
'رکھو'=>['ur',],
'رکھوں'=>['ur',],
'رکھیں'=>['ur',],
'رکیں'=>['ur',],
'رہ'=>['ur',],
'رہا'=>['ur',],
'رہتا'=>['ur',],
'رہتی'=>['ur',],
'رہتے'=>['ur',],
'رہنا'=>['ur',],
'رہنے'=>['ur',],
'رہو'=>['ur',],
'رہی'=>['ur',],
'رہیں'=>['ur',],
'رہے'=>['ur',],
'ریت'=>['ur',],
'ریٹائر'=>['ur',],
'زال'=>['ar',],
'زانٹی'=>['ur',],
'زبان'=>['fa','ur',],
'زخمی'=>['ur',],
'زد'=>['fa',],
'زدن'=>['fa',],
'زده'=>['fa',],
'زلت'=>['ar',],
'زمان'=>['fa',],
'زماني'=>['fa',],
'زمين'=>['fa',],
'زمین'=>['ur',],
'زن'=>['fa',],
'زندان'=>['fa',],
'زنده'=>['fa',],
'زندگي'=>['fa',],
'زندگی'=>['ur',],
'زندہ'=>['ur',],
'زنم'=>['fa',],
'زنگ'=>['fa',],
'زوجتك'=>['ar',],
'زوجتي'=>['ar',],
'زود'=>['fa',],
'زياد'=>['fa',],
'زيادي'=>['fa',],
'زير'=>['fa',],
'زہر'=>['ur',],
'زیادہ'=>['ur',],
'سأذهب'=>['ar',],
'سأعود'=>['ar',],
'سأفعل'=>['ar',],
'سأكون'=>['ar',],
'سؤال'=>['ar',],
'سا'=>['ur',],
'سات'=>['ur',],
'ساتھ'=>['ur',],
'ساحل'=>['fa',],
'سارا'=>['ur',],
'ساردين'=>['fa',],
'ساری'=>['ur',],
'سارے'=>['ur',],
'ساس'=>['ur',],
'ساعات'=>['ar',],
'ساعة'=>['ar',],
'ساعت'=>['fa',],
'سال'=>['fa','ur',],
'ساله'=>['fa',],
'سام'=>['ar','ur',],
'سامنے'=>['ur',],
'سب'=>['ur',],
'سبب'=>['ar',],
'سبز'=>['ur',],
'ست'=>['fa',],
'ستاره'=>['fa',],
'ستة'=>['ar',],
'ستفعل'=>['ar',],
'ستكون'=>['ar',],
'سخت'=>['fa',],
'سر'=>['fa','ur',],
'سرباز'=>['fa',],
'سرحدوں'=>['ur',],
'سرزمين'=>['fa',],
'سرورم'=>['fa',],
'سري'=>['fa',],
'سريع'=>['fa',],
'سرپرستوں'=>['ur',],
'سعي'=>['fa',],
'سعيد'=>['ar',],
'سعيدة'=>['ar',],
'سفر'=>['fa','ur',],
'سفيد'=>['fa',],
'سلام'=>['fa',],
'سلطنت'=>['ur',],
'سمت'=>['fa',],
'سمجھ'=>['ur',],
'سمجھتا'=>['ur',],
'سمجھے'=>['ur',],
'سمعت'=>['ar',],
'سن'=>['ur',],
'سنبھال'=>['ur',],
'سنة'=>['ar',],
'سنذهب'=>['ar',],
'سنكون'=>['ar',],
'سنو'=>['ur',],
'سنوات'=>['ar',],
'سنگ'=>['fa',],
'سنی'=>['ur',],
'سه'=>['fa',],
'سو'=>['ur',],
'سوائے'=>['ur',],
'سوال'=>['fa','ur',],
'سودا'=>['ur',],
'سوف'=>['ar',],
'سوموار'=>['ur',],
'سونے'=>['ur',],
'سوى'=>['ar',],
'سوچ'=>['ur',],
'سيء'=>['ar',],
'سيئة'=>['ar',],
'سيارة'=>['ar',],
'سياه'=>['fa',],
'سيحدث'=>['ar',],
'سيد'=>['ar',],
'سيدة'=>['ar',],
'سيدتي'=>['ar',],
'سيدى'=>['ar',],
'سيدي'=>['ar',],
'سيكون'=>['ar',],
'سٹیٹ'=>['ur',],
'سپاہی'=>['ur',],
'سچ'=>['ur',],
'سچا'=>['ur',],
'سکا'=>['ur',],
'سکتا'=>['ur',],
'سکتی'=>['ur',],
'سکتے'=>['ur',],
'سکو'=>['ur',],
'سکوں'=>['ur',],
'سکیں'=>['ur',],
'سکے'=>['ur',],
'سی'=>['ur',],
'سیاسی'=>['ur',],
'سیب'=>['ur',],
'سیر'=>['ur',],
'سیکشن'=>['ur',],
'سے'=>['ur',],
'شئ'=>['ar',],
'شادی'=>['ur',],
'شارامن'=>['ur',],
'شام'=>['ur',],
'شامل'=>['ur',],
'شان'=>['fa',],
'شانس'=>['fa',],
'شاه'=>['fa',],
'شايد'=>['fa',],
'شاید'=>['ur',],
'شب'=>['fa',],
'شباب'=>['ar',],
'شبيه'=>['fa',],
'شتر'=>['ur',],
'شخص'=>['ar','ur',],
'شد'=>['fa',],
'شدم'=>['fa',],
'شدن'=>['fa',],
'شدند'=>['fa',],
'شده'=>['fa',],
'شدي'=>['fa',],
'شديم'=>['fa',],
'شدہ'=>['ur',],
'شرط'=>['fa',],
'شرطة'=>['ar',],
'شركة'=>['ar',],
'شروع'=>['fa','ur',],
'شش'=>['fa',],
'شكرا'=>['ar',],
'شليک'=>['fa',],
'شم'=>['fa',],
'شما'=>['fa',],
'شماره'=>['fa',],
'شمشير'=>['fa',],
'شنيدم'=>['fa',],
'شه'=>['fa',],
'شهر'=>['fa',],
'شو'=>['fa','ur',],
'شود'=>['fa',],
'شوند'=>['fa',],
'شىء'=>['ar',],
'شيء'=>['ar',],
'شيئ'=>['ar',],
'شيئا'=>['ar',],
'شيطان'=>['fa',],
'شک'=>['ur',],
'شکار'=>['fa',],
'شکریہ'=>['ur',],
'شکست'=>['fa',],
'شہر'=>['ur',],
'شہری'=>['ur',],
'شہزادہ'=>['ur',],
'شہزادی'=>['ur',],
'شہزادے'=>['ur',],
'شیخ'=>['ur',],
'شیر'=>['ur',],
'صاحب'=>['ur',],
'صاف'=>['ur',],
'صباح'=>['ar',],
'صبح'=>['fa','ur',],
'صبر'=>['fa',],
'صحبت'=>['fa',],
'صحيح'=>['ar',],
'صحیح'=>['ur',],
'صدا'=>['fa',],
'صداي'=>['fa',],
'صدر'=>['ur',],
'صديق'=>['ar',],
'صديقك'=>['ar',],
'صديقي'=>['ar',],
'صرف'=>['ur',],
'صعب'=>['ar',],
'صغير'=>['ar',],
'صغيرة'=>['ar',],
'صفحه'=>['fa',],
'صوت'=>['ar',],
'صورة'=>['ar',],
'صورت'=>['fa',],
'ضد'=>['ar',],
'ضرور'=>['ur',],
'ضرورت'=>['ur',],
'ضروری'=>['ur',],
'ضع'=>['ar',],
'طاس'=>['ur',],
'طاقت'=>['ur',],
'طاقتور'=>['ur',],
'طرح'=>['ur',],
'طرف'=>['fa','ur',],
'طريق'=>['ar',],
'طريقة'=>['ar',],
'طریقہ'=>['ur',],
'طفل'=>['ar',],
'طلب'=>['ar',],
'طلبت'=>['ar',],
'طوال'=>['ar',],
'طور'=>['fa','ur',],
'طوري'=>['fa',],
'طوفان'=>['ur',],
'طول'=>['fa',],
'طولاني'=>['fa',],
'طويل'=>['ar',],
'طويلة'=>['ar',],
'ظننت'=>['ar',],
'عائلة'=>['ar',],
'عاشق'=>['fa',],
'عالم'=>['ar',],
'عالي'=>['fa',],
'عاليه'=>['fa',],
'عالیہ'=>['ur',],
'عام'=>['ar','ur',],
'عبادت'=>['ur',],
'عبر'=>['ar',],
'عجله'=>['fa',],
'عجیب'=>['ur',],
'عدد'=>['ar',],
'عدم'=>['ar',],
'عرصہ'=>['ur',],
'عرض'=>['ar',],
'عرفت'=>['ar',],
'عزت'=>['ur',],
'عزيزتي'=>['ar',],
'عزيزم'=>['fa',],
'عزيزي'=>['ar',],
'عشر'=>['ar',],
'عشرة'=>['ar',],
'عشق'=>['fa',],
'عظيم'=>['ar',],
'عظیم'=>['ur',],
'عقب'=>['fa',],
'علاقة'=>['ar',],
'علاقه'=>['fa',],
'علاوہ'=>['ur',],
'علم'=>['ar',],
'على'=>['ar',],
'علي'=>['ar',],
'عليك'=>['ar',],
'عليكم'=>['ar',],
'علينا'=>['ar',],
'عليه'=>['ar',],
'عليها'=>['ar',],
'عليهم'=>['ar',],
'عما'=>['ar',],
'عمارت'=>['ur',],
'عمدہ'=>['ur',],
'عمل'=>['ar','fa',],
'عملية'=>['ar',],
'عن'=>['ar',],
'عند'=>['ar',],
'عندك'=>['ar',],
'عندما'=>['ar',],
'عندي'=>['ar',],
'عنك'=>['ar',],
'عنه'=>['ar',],
'عنها'=>['ar',],
'عنوان'=>['fa',],
'عني'=>['ar',],
'عوام'=>['ur',],
'عوامی'=>['ur',],
'عورت'=>['ur',],
'عوض'=>['fa',],
'عيد'=>['ar',],
'عین'=>['ur',],
'غدا'=>['ar',],
'غدار'=>['ur',],
'غداری'=>['ur',],
'غذا'=>['fa',],
'غرفة'=>['ar',],
'غريب'=>['ar',],
'غسل'=>['ur',],
'غلاموں'=>['ur',],
'غلط'=>['ur',],
'غور'=>['ur',],
'غير'=>['ar','fa',],
'غیر'=>['ur',],
'ـ'=>['ar','fa',],
'ــ'=>['ar',],
'فأنا'=>['ar',],
'فارس'=>['ur',],
'فارسی'=>['ur',],
'فارم'=>['ur',],
'فتاة'=>['ar',],
'فتح'=>['ur',],
'فترة'=>['ar',],
'فتى'=>['ar',],
'فحسب'=>['ar',],
'فخر'=>['ur',],
'فرار'=>['fa',],
'فراموش'=>['fa',],
'فرانك'=>['ar',],
'فردا'=>['fa',],
'فرش'=>['ur',],
'فرصة'=>['ar',],
'فرصت'=>['fa',],
'فرض'=>['ur',],
'فرق'=>['ur',],
'فرمائیے'=>['ur',],
'فريق'=>['ar',],
'فرینک'=>['ur',],
'فضلك'=>['ar',],
'فضول'=>['ur',],
'فعل'=>['ar',],
'فعلا'=>['ar',],
'فعلت'=>['ar',],
'فعلته'=>['ar',],
'فعله'=>['ar',],
'فقد'=>['ar',],
'فقدت'=>['ar',],
'فقط'=>['ar','fa',],
'فكر'=>['fa',],
'فكرة'=>['ar',],
'فهمت'=>['ar',],
'فهو'=>['ar',],
'فوج'=>['ur',],
'فوق'=>['ar','fa',],
'فون'=>['ur',],
'فى'=>['ar',],
'في'=>['ar',],
'فيل'=>['fa',],
'فيلم'=>['fa',],
'فيما'=>['ar',],
'فيه'=>['ar',],
'فيها'=>['ar',],
'فٹس'=>['ur',],
'فکر'=>['fa',],
'فی'=>['ur',],
'فیصلہ'=>['ur',],
'فیلڈ'=>['ur',],
'قائم'=>['ur',],
'قابل'=>['fa','ur',],
'قابو'=>['ur',],
'قاتل'=>['ur',],
'قادم'=>['ar',],
'قال'=>['ar',],
'قالت'=>['ar',],
'قام'=>['ar',],
'قانون'=>['fa','ur',],
'قبل'=>['ar','fa',],
'قبلا'=>['fa',],
'قبول'=>['fa','ur',],
'قتل'=>['ar','ur',],
'قتلت'=>['ar',],
'قد'=>['ar',],
'قدرت'=>['fa',],
'قدم'=>['fa','ur',],
'قديمي'=>['fa',],
'قرار'=>['fa',],
'قراره'=>['fa',],
'قربان'=>['fa',],
'قرمز'=>['fa',],
'قريبا'=>['ar',],
'قریب'=>['ur',],
'قسم'=>['fa','ur',],
'قسمت'=>['ur',],
'قسمتی'=>['ur',],
'قصة'=>['ar',],
'قضيه'=>['fa',],
'قطعة'=>['ar',],
'قل'=>['ar',],
'قلت'=>['ar',],
'قليلا'=>['ar',],
'قم'=>['ar',],
'قمت'=>['ar',],
'قوانین'=>['ur',],
'قول'=>['fa',],
'قوي'=>['fa',],
'قیام'=>['ur',],
'قیمت'=>['ur',],
'كار'=>['fa',],
'كاري'=>['fa',],
'كان'=>['ar',],
'كانت'=>['ar',],
'كانوا'=>['ar',],
'كبير'=>['ar',],
'كبيرة'=>['ar',],
'كتاب'=>['fa',],
'كثير'=>['ar',],
'كثيرا'=>['ar',],
'كجا'=>['fa',],
'كذلك'=>['ar',],
'كرة'=>['ar',],
'كرد'=>['fa',],
'كردم'=>['fa',],
'كردن'=>['fa',],
'كرده'=>['fa',],
'كردي'=>['fa',],
'كسي'=>['fa',],
'كل'=>['ar',],
'كلا'=>['ar',],
'كلمة'=>['ar',],
'كلنا'=>['ar',],
'كله'=>['ar',],
'كلها'=>['ar',],
'كم'=>['ar',],
'كما'=>['ar',],
'كمك'=>['fa',],
'كن'=>['ar','fa',],
'كنا'=>['ar',],
'كنت'=>['ar',],
'كنم'=>['fa',],
'كنه'=>['fa',],
'كني'=>['fa',],
'كنيد'=>['fa',],
'كنيم'=>['fa',],
'كه'=>['fa',],
'كهذا'=>['ar',],
'كي'=>['ar','fa',],
'كيف'=>['ar',],
'لأجل'=>['ar',],
'لأن'=>['ar',],
'لأنك'=>['ar',],
'لأنني'=>['ar',],
'لأنه'=>['ar',],
'لأني'=>['ar',],
'لئے'=>['ur',],
'لا'=>['ar',],
'لاؤ'=>['ur',],
'لاؤنج'=>['ur',],
'لاؤڈ'=>['ur',],
'لابد'=>['ar',],
'لاتا'=>['ur',],
'لازم'=>['fa',],
'لام'=>['ur',],
'لانے'=>['ur',],
'لباس'=>['fa','ur',],
'لحظة'=>['ar',],
'لحظه'=>['fa',],
'لدى'=>['ar',],
'لدي'=>['ar',],
'لديك'=>['ar',],
'لدينا'=>['ar',],
'لديه'=>['ar',],
'لديها'=>['ar',],
'لديهم'=>['ar',],
'لذا'=>['ar',],
'لذت'=>['fa',],
'لذلك'=>['ar',],
'لست'=>['ar',],
'لسنا'=>['ar',],
'لطف'=>['ur',],
'لطفا'=>['fa',],
'لطيف'=>['ar',],
'لعبة'=>['ar',],
'لعنت'=>['fa',],
'لعنتي'=>['fa',],
'لـ'=>['ar',],
'لقد'=>['ar',],
'لك'=>['ar',],
'لكل'=>['ar',],
'لكم'=>['ar',],
'لكن'=>['ar',],
'لكنك'=>['ar',],
'لكنني'=>['ar',],
'لكنه'=>['ar',],
'لكنها'=>['ar',],
'لكني'=>['ar',],
'لكى'=>['ar',],
'لكي'=>['ar',],
'للتو'=>['ar',],
'للعمل'=>['ar',],
'للغاية'=>['ar',],
'للمنزل'=>['ar',],
'لم'=>['ar',],
'لما'=>['ar',],
'لماذا'=>['ar',],
'لمحہ'=>['ur',],
'لمدة'=>['ar',],
'لن'=>['ar',],
'لنا'=>['ar',],
'لنذهب'=>['ar',],
'له'=>['ar',],
'لها'=>['ar',],
'لهذا'=>['ar',],
'لهذه'=>['ar',],
'لهم'=>['ar',],
'لو'=>['ar','ur',],
'لوگ'=>['ur',],
'لوگوں'=>['ur',],
'لوں'=>['ur',],
'لى'=>['ar',],
'لي'=>['ar',],
'ليس'=>['ar',],
'ليست'=>['ar',],
'ليلة'=>['ar',],
'لڑائی'=>['ur',],
'لڑکا'=>['ur',],
'لڑکی'=>['ur',],
'لڑکے'=>['ur',],
'لکھا'=>['ur',],
'لگ'=>['ur',],
'لگا'=>['ur',],
'لگائی'=>['ur',],
'لگایا'=>['ur',],
'لگتا'=>['ur',],
'لگتی'=>['ur',],
'لگتے'=>['ur',],
'لہجہ'=>['ur',],
'لی'=>['ur',],
'لیا'=>['ur',],
'لیتے'=>['ur',],
'لینا'=>['ur',],
'لینے'=>['ur',],
'لیکن'=>['ur',],
'لیگزنگٹن'=>['ur',],
'لیں'=>['ur',],
'لے'=>['ur',],
'م'=>['fa',],
'ما'=>['ar','fa',],
'مات'=>['ar',],
'مادر'=>['fa',],
'مادرت'=>['fa',],
'مادرم'=>['fa',],
'ماذا'=>['ar',],
'مار'=>['ur',],
'مارا'=>['ur',],
'مارنا'=>['ur',],
'مارنے'=>['ur',],
'ماري'=>['ar',],
'مازال'=>['ar',],
'ماست'=>['fa',],
'ماشين'=>['fa',],
'ماكس'=>['ar',],
'مال'=>['fa',],
'مالذي'=>['ar',],
'مامان'=>['fa',],
'ماه'=>['fa',],
'ماهي'=>['fa',],
'مايك'=>['ar',],
'مايكل'=>['ar',],
'مايل'=>['fa',],
'ماہ'=>['ur',],
'مبارزه'=>['fa',],
'مبارک'=>['ur',],
'مباشرة'=>['ar',],
'مت'=>['ur',],
'متأسفم'=>['fa',],
'متأكد'=>['ar',],
'متأكدة'=>['ar',],
'متاثر'=>['ur',],
'متاسفم'=>['fa',],
'مترجم'=>['ur',],
'متشکرم'=>['fa',],
'متوجه'=>['fa',],
'متى'=>['ar',],
'مثال'=>['ur',],
'مثل'=>['ar','fa',],
'مثلك'=>['ar',],
'مثير'=>['ar',],
'مجبور'=>['fa',],
'مجرد'=>['ar',],
'مجموعة'=>['ar',],
'مجنون'=>['ar',],
'مجھ'=>['ur',],
'مجھے'=>['ur',],
'محافظ'=>['ur',],
'محافظت'=>['fa',],
'محبت'=>['ur',],
'محترم'=>['ur',],
'محفوظ'=>['ur',],
'محل'=>['ur',],
'مختلف'=>['ar','ur',],
'مدت'=>['fa',],
'مدد'=>['ur',],
'مدرسه'=>['fa',],
'مدى'=>['ar',],
'مدينة'=>['ar',],
'مذاق'=>['ur',],
'مر'=>['ur',],
'مراقب'=>['fa',],
'مراقبت'=>['fa',],
'مرة'=>['ar',],
'مرحبا'=>['ar',],
'مرد'=>['fa','ur',],
'مردم'=>['fa',],
'مرده'=>['fa',],
'مردوں'=>['ur',],
'مردي'=>['fa',],
'مره'=>['ar',],
'مرگ'=>['fa',],
'مزہ'=>['ur',],
'مزید'=>['ur',],
'مس'=>['ur',],
'مسئلہ'=>['ur',],
'مسئلے'=>['ur',],
'مساء'=>['ar',],
'مسابقه'=>['fa',],
'مساعدة'=>['ar',],
'مساعدتك'=>['ar',],
'مسافر'=>['ur',],
'مستحيل'=>['ar',],
'مستعد'=>['ar',],
'مستقبل'=>['ur',],
'مسيح'=>['fa',],
'مسٹر'=>['ur',],
'مشاكل'=>['ar',],
'مشرقی'=>['ur',],
'مشكلة'=>['ar',],
'مشورہ'=>['ur',],
'مشکل'=>['fa','ur',],
'مشکلي'=>['fa',],
'مشکوک'=>['ur',],
'مضبوط'=>['ur',],
'مضحك'=>['ar',],
'مطابق'=>['ur',],
'مطلب'=>['ur',],
'مطمئن'=>['fa',],
'مطمئنم'=>['fa',],
'مع'=>['ar',],
'معائنے'=>['ur',],
'معاف'=>['ur',],
'معاملہ'=>['ur',],
'معبد'=>['ur',],
'معذرت'=>['ur',],
'معرفة'=>['ar',],
'معك'=>['ar',],
'معلوم'=>['ur',],
'معمول'=>['ur',],
'معنا'=>['ar',],
'معه'=>['ar',],
'معها'=>['ar',],
'معهم'=>['ar',],
'معى'=>['ar',],
'معي'=>['ar',],
'مفت'=>['ur',],
'مقابل'=>['ar','fa',],
'مقام'=>['ur',],
'مقدس'=>['ur',],
'مقدمہ'=>['ur',],
'مقدمے'=>['ur',],
'مقصد'=>['ur',],
'مكان'=>['ar',],
'مكتب'=>['ar',],
'مل'=>['ur',],
'ملا'=>['ur',],
'ملاقات'=>['fa',],
'ملتی'=>['ur',],
'ملرائے'=>['ur',],
'ملنا'=>['ur',],
'ملنے'=>['ur',],
'مليون'=>['ar',],
'ملک'=>['ur',],
'ملی'=>['ur',],
'ملے'=>['ur',],
'مما'=>['ar',],
'ممباکہ'=>['ur',],
'ممتاز'=>['ar',],
'ممكن'=>['ar',],
'ممنون'=>['fa',],
'ممنونم'=>['fa',],
'ممکن'=>['fa',],
'ممکنه'=>['fa',],
'من'=>['ar','fa',],
'منا'=>['ar',],
'منتظر'=>['fa',],
'منذ'=>['ar',],
'منزل'=>['ar','ur',],
'منسوخ'=>['ur',],
'منظورت'=>['fa',],
'منظورم'=>['fa',],
'منك'=>['ar',],
'منكم'=>['ar',],
'منم'=>['fa',],
'منه'=>['ar','fa',],
'منها'=>['ar',],
'منهم'=>['ar',],
'منو'=>['fa',],
'منى'=>['ar',],
'مني'=>['ar',],
'منٹ'=>['ur',],
'منگل'=>['ur',],
'مهم'=>['ar','fa',],
'مهما'=>['ar',],
'مواظب'=>['fa',],
'موت'=>['ur',],
'موجود'=>['ar','ur',],
'مورد'=>['fa',],
'موضوع'=>['fa',],
'موفق'=>['fa',],
'موقع'=>['fa','ur',],
'مون'=>['fa',],
'مونده'=>['fa',],
'مونگ'=>['ur',],
'مي'=>['fa',],
'مياد'=>['fa',],
'ميام'=>['fa',],
'ميان'=>['fa',],
'ميت'=>['ar',],
'ميتونم'=>['fa',],
'ميتونه'=>['fa',],
'ميتوني'=>['fa',],
'ميتونيم'=>['fa',],
'ميخواد'=>['fa',],
'ميخوام'=>['fa',],
'ميخواي'=>['fa',],
'ميدم'=>['fa',],
'ميده'=>['fa',],
'ميدونم'=>['fa',],
'ميدوني'=>['fa',],
'ميدي'=>['fa',],
'ميرم'=>['fa',],
'ميره'=>['fa',],
'ميري'=>['fa',],
'ميريم'=>['fa',],
'ميشم'=>['fa',],
'ميشه'=>['fa',],
'ميشي'=>['fa',],
'ميكنم'=>['fa',],
'ميكنه'=>['fa',],
'ميكني'=>['fa',],
'ميلاد'=>['ar',],
'ميکنم'=>['fa',],
'ميکنه'=>['fa',],
'ميکني'=>['fa',],
'ميکنيم'=>['fa',],
'ميگم'=>['fa',],
'ميگن'=>['fa',],
'ميگه'=>['fa',],
'ميگي'=>['fa',],
'مچھلی'=>['ur',],
'مگه'=>['fa',],
'مہر'=>['ur',],
'مہربانی'=>['ur',],
'مہینہ'=>['ur',],
'مہینے'=>['ur',],
'می'=>['fa',],
'میاد'=>['fa',],
'میخوام'=>['fa',],
'میرا'=>['ur',],
'میری'=>['ur',],
'میرے'=>['ur',],
'میزبان'=>['ur',],
'میشه'=>['fa',],
'میم'=>['ur',],
'مین'=>['ur',],
'میں'=>['ur',],
'نئی'=>['ur',],
'نئے'=>['ur',],
'نا'=>['ur',],
'نائب'=>['ur',],
'نابود'=>['fa',],
'ناراحت'=>['fa',],
'نام'=>['ur',],
'ناممکن'=>['ur',],
'نامه'=>['fa',],
'ناورسکی'=>['ur',],
'ناں'=>['ur',],
'نباش'=>['fa',],
'نباشه'=>['fa',],
'نبايد'=>['fa',],
'نبود'=>['fa',],
'نتائج'=>['ur',],
'نتحدث'=>['ar',],
'نجات'=>['fa',],
'نحتاج'=>['ar',],
'نحن'=>['ar',],
'نحو'=>['ar',],
'ندارم'=>['fa',],
'نداره'=>['fa',],
'نداري'=>['fa',],
'نداريم'=>['fa',],
'نداشتم'=>['fa',],
'نذاف'=>['ur',],
'نذهب'=>['ar',],
'نرم'=>['ur',],
'نرى'=>['ar',],
'نريد'=>['ar',],
'نزديک'=>['fa',],
'نستطيع'=>['ar',],
'نسيت'=>['ar',],
'نشان'=>['ur',],
'نشانہ'=>['ur',],
'نشده'=>['fa',],
'نشون'=>['fa',],
'نصف'=>['ar',],
'نظام'=>['ur',],
'نظر'=>['fa','ur',],
'نظرة'=>['ar',],
'نعرف'=>['ar',],
'نعم'=>['ar',],
'نفر'=>['fa',],
'نفس'=>['ar','fa',],
'نفسك'=>['ar',],
'نفسه'=>['ar',],
'نفسي'=>['ar',],
'نفعل'=>['ar',],
'نقب'=>['ur',],
'نقشه'=>['fa',],
'نقوم'=>['ar',],
'نكن'=>['fa',],
'نكون'=>['ar',],
'نمبر'=>['ur',],
'نمي'=>['fa',],
'نمياد'=>['fa',],
'نميتونم'=>['fa',],
'نميتوني'=>['fa',],
'نميخوام'=>['fa',],
'نميدونم'=>['fa',],
'نميشه'=>['fa',],
'نمی'=>['fa',],
'نه'=>['fa',],
'نهاية'=>['ar',],
'نو'=>['ur',],
'نوشته'=>['fa',],
'نوع'=>['ar',],
'نوکری'=>['ur',],
'نياز'=>['fa',],
'نيروي'=>['fa',],
'نيست'=>['fa',],
'نيستم'=>['fa',],
'نيستي'=>['fa',],
'نيويورك'=>['ar',],
'نپولین'=>['ur',],
'نکال'=>['ur',],
'نکردم'=>['fa',],
'نکرده'=>['fa',],
'نکل'=>['ur',],
'نکن'=>['fa',],
'نکنم'=>['fa',],
'نگاه'=>['fa',],
'نگران'=>['fa',],
'نگه'=>['fa',],
'نہ'=>['ur',],
'نہلے'=>['ur',],
'نہیں'=>['ur',],
'نیا'=>['ur',],
'نیست'=>['fa',],
'نیلا'=>['ur',],
'نیو'=>['ur',],
'نیویارک'=>['ur',],
'نیچے'=>['ur',],
'نے'=>['ur',],
'ه'=>['fa',],
'هؤلاء'=>['ar',],
'ها'=>['ar','fa',],
'هاري'=>['ar',],
'هاي'=>['fa',],
'هايي'=>['fa',],
'های'=>['fa',],
'هدف'=>['fa',],
'هذا'=>['ar',],
'هذة'=>['ar',],
'هذه'=>['ar',],
'هر'=>['fa',],
'هراء'=>['ar',],
'هري'=>['fa',],
'هرگز'=>['fa',],
'هزار'=>['fa',],
'هست'=>['fa',],
'هستش'=>['fa',],
'هستم'=>['fa',],
'هستن'=>['fa',],
'هستند'=>['fa',],
'هستي'=>['fa',],
'هستيد'=>['fa',],
'هستيم'=>['fa',],
'هفت'=>['fa',],
'هفته'=>['fa',],
'هكذا'=>['ar',],
'هل'=>['ar',],
'هلا'=>['ar',],
'هم'=>['ar','fa',],
'همديگه'=>['fa',],
'همراه'=>['fa',],
'همش'=>['fa',],
'همه'=>['fa',],
'همون'=>['fa',],
'هميشه'=>['fa',],
'همين'=>['fa',],
'همينطور'=>['fa',],
'همينه'=>['fa',],
'همچين'=>['fa',],
'همیشه'=>['fa',],
'همین'=>['fa',],
'هنا'=>['ar',],
'هناك'=>['ar',],
'هنالك'=>['ar',],
'هنوز'=>['fa',],
'هو'=>['ar',],
'هوا'=>['fa',],
'هى'=>['ar',],
'هي'=>['ar','fa',],
'هيا'=>['ar',],
'هيه'=>['ar',],
'هيچ'=>['fa',],
'هيچوقت'=>['fa',],
'هيچي'=>['fa',],
'هیچ'=>['fa',],
'و'=>['ar','fa','ur',],
'وأنا'=>['ar',],
'وأنت'=>['ar',],
'واحد'=>['ar','ur',],
'واحدة'=>['ar',],
'وارد'=>['fa',],
'وارن'=>['ur',],
'واسه'=>['fa',],
'واشنگٹن'=>['ur',],
'واضح'=>['ar','ur',],
'واقع'=>['fa',],
'واقعا'=>['fa',],
'واقعي'=>['fa',],
'واقعی'=>['ur',],
'والآن'=>['ar',],
'والا'=>['ur',],
'والد'=>['ur',],
'والدك'=>['ar',],
'والدي'=>['ar',],
'والدین'=>['ur',],
'والوں'=>['ur',],
'والی'=>['ur',],
'والے'=>['ur',],
'وانا'=>['ar',],
'وانت'=>['ar',],
'واي'=>['fa',],
'واپس'=>['ur',],
'واپسی'=>['ur',],
'وبعد'=>['ar',],
'وجدت'=>['ar',],
'وجود'=>['ar','fa',],
'وجہ'=>['ur',],
'وسوف'=>['ar',],
'وشك'=>['ar',],
'وصلت'=>['ar',],
'وصول'=>['ur',],
'وضع'=>['ar',],
'وعدہ'=>['ur',],
'وعندما'=>['ar',],
'وفي'=>['ar',],
'وقت'=>['ar','fa','ur',],
'وقتشه'=>['fa',],
'وقته'=>['fa',],
'وقتي'=>['fa',],
'وقتی'=>['fa',],
'وقد'=>['ar',],
'وكان'=>['ar',],
'وكل'=>['ar',],
'ولا'=>['ar',],
'ولد'=>['ar',],
'ولكن'=>['ar',],
'ولكنه'=>['ar',],
'ولكني'=>['ar',],
'ولم'=>['ar',],
'ولن'=>['ar',],
'ولي'=>['fa',],
'وليس'=>['ar',],
'ولی'=>['fa',],
'وما'=>['ar',],
'وماذا'=>['ar',],
'ومن'=>['ar',],
'ونحن'=>['ar',],
'وهذا'=>['ar',],
'وهذه'=>['ar',],
'وهو'=>['ar',],
'وهي'=>['ar',],
'وودهاس'=>['fa',],
'وکٹر'=>['ur',],
'وہ'=>['ur',],
'وہاں'=>['ur',],
'وہی'=>['ur',],
'وہیں'=>['ur',],
'ویزہ'=>['ur',],
'ویسے'=>['ur',],
'ي'=>['fa',],
'يأتي'=>['ar',],
'يا'=>['ar','fa',],
'ياد'=>['fa',],
'يادت'=>['fa',],
'يارجل'=>['ar',],
'يالا'=>['fa',],
'يبدو'=>['ar',],
'يتم'=>['ar',],
'يجب'=>['ar',],
'يجري'=>['ar',],
'يحاول'=>['ar',],
'يحب'=>['ar',],
'يحتاج'=>['ar',],
'يحدث'=>['ar',],
'يحصل'=>['ar',],
'يخ'=>['fa',],
'يذهب'=>['ar',],
'يرام'=>['ar',],
'يريد'=>['ar',],
'يريدون'=>['ar',],
'يستطيع'=>['ar',],
'يعد'=>['ar',],
'يعرف'=>['ar',],
'يعلم'=>['ar',],
'يعمل'=>['ar',],
'يعني'=>['ar','fa',],
'يعود'=>['ar',],
'يفعل'=>['ar',],
'يقول'=>['ar',],
'يقولون'=>['ar',],
'يقوم'=>['ar',],
'يك'=>['fa',],
'يكفي'=>['ar',],
'يكن'=>['ar',],
'يكون'=>['ar',],
'يكي'=>['fa',],
'يمكن'=>['ar',],
'يمكنك'=>['ar',],
'يمكننا'=>['ar',],
'يمكننى'=>['ar',],
'يمكنني'=>['ar',],
'يمكنه'=>['ar',],
'ينبغي'=>['ar',],
'يه'=>['fa',],
'يهم'=>['ar',],
'يوجد'=>['ar',],
'يوم'=>['ar',],
'يک'=>['fa',],
'يکم'=>['fa',],
'يکي'=>['fa',],
'ٹائیٹلز'=>['ur',],
'ٹرانزٹ'=>['ur',],
'ٹرمینل'=>['ur',],
'ٹورس'=>['ur',],
'ٹوکن'=>['ur',],
'ٹکٹ'=>['ur',],
'ٹھہریں'=>['ur',],
'ٹھیک'=>['ur',],
'ٹھیکیدار'=>['ur',],
'ٹیلی'=>['ur',],
'ٹیلیفون'=>['ur',],
'ٹیکس'=>['ur',],
'ٹیکسی'=>['ur',],
'پا'=>['fa',],
'پادشاه'=>['fa',],
'پاس'=>['ur',],
'پاسپورٹ'=>['ur',],
'پانچ'=>['ur',],
'پانی'=>['ur',],
'پايان'=>['fa',],
'پايين'=>['fa',],
'پاگل'=>['ur',],
'پتا'=>['ur',],
'پتھر'=>['ur',],
'پدر'=>['fa',],
'پدرت'=>['fa',],
'پدرم'=>['fa',],
'پر'=>['fa','ur',],
'پراسرار'=>['ur',],
'پرواز'=>['fa','ur',],
'پریشان'=>['ur',],
'پس'=>['fa',],
'پسر'=>['fa',],
'پسند'=>['ur',],
'پسندیدہ'=>['ur',],
'پشت'=>['fa',],
'پل'=>['ur',],
'پليس'=>['fa',],
'پلٹ'=>['ur',],
'پلیز'=>['ur',],
'پناہ'=>['ur',],
'پنج'=>['fa',],
'پندرہ'=>['ur',],
'پورا'=>['ur',],
'پوری'=>['ur',],
'پوست'=>['fa',],
'پول'=>['fa',],
'پولیس'=>['ur',],
'پيدا'=>['fa',],
'پيداش'=>['fa',],
'پيش'=>['fa',],
'پيشنهاد'=>['fa',],
'پچھلی'=>['ur',],
'پچھلے'=>['ur',],
'پڑتا'=>['ur',],
'پڑیں'=>['ur',],
'پڑے'=>['ur',],
'پکڑ'=>['ur',],
'پکڑنے'=>['ur',],
'پکڑو'=>['ur',],
'پھاٹک'=>['ur',],
'پھر'=>['ur',],
'پہ'=>['ur',],
'پہلے'=>['ur',],
'پہنچ'=>['ur',],
'پہنچے'=>['ur',],
'پی'=>['ur',],
'پیار'=>['ur',],
'پیاری'=>['ur',],
'پیدا'=>['ur',],
'پیسے'=>['ur',],
'پیش'=>['ur',],
'پیلی'=>['ur',],
'پینا'=>['ur',],
'پیچھا'=>['ur',],
'پیچھے'=>['ur',],
'چار'=>['ur',],
'چاقو'=>['ur',],
'چال'=>['ur',],
'چالیس'=>['ur',],
'چاہئے'=>['ur',],
'چاہتا'=>['ur',],
'چاہتی'=>['ur',],
'چاہتے'=>['ur',],
'چاہوں'=>['ur',],
'چاہیئے'=>['ur',],
'چاہیے'=>['ur',],
'چاہے'=>['ur',],
'چرا'=>['fa',],
'چشم'=>['fa',],
'چطور'=>['fa',],
'چطوره'=>['fa',],
'چطوري'=>['fa',],
'چقدر'=>['fa',],
'چل'=>['ur',],
'چلا'=>['ur',],
'چلتے'=>['ur',],
'چلنا'=>['ur',],
'چلنے'=>['ur',],
'چلو'=>['ur',],
'چلیں'=>['ur',],
'چلے'=>['ur',],
'چند'=>['fa',],
'چنين'=>['fa',],
'چه'=>['fa',],
'چهار'=>['fa',],
'چون'=>['fa',],
'چونکہ'=>['ur',],
'چي'=>['fa',],
'چيز'=>['fa',],
'چيزايي'=>['fa',],
'چيزهايي'=>['fa',],
'چيزي'=>['fa',],
'چيزيه'=>['fa',],
'چيكار'=>['fa',],
'چيه'=>['fa',],
'چيکار'=>['fa',],
'چپس'=>['ur',],
'چچا'=>['ur',],
'چکا'=>['ur',],
'چکار'=>['fa',],
'چکی'=>['ur',],
'چکے'=>['ur',],
'چھ'=>['ur',],
'چھری'=>['ur',],
'چھوٹا'=>['ur',],
'چھوٹی'=>['ur',],
'چھوٹے'=>['ur',],
'چھوڑ'=>['ur',],
'چھپایا'=>['ur',],
'چی'=>['fa',],
'چیر'=>['ur',],
'چیز'=>['fa','ur',],
'چیزی'=>['fa',],
'چیزیں'=>['ur',],
'چین'=>['ur',],
'چیه'=>['fa',],
'ڈالر'=>['ur',],
'ڈبے'=>['ur',],
'ڈرتا'=>['ur',],
'ڈکسن'=>['ur',],
'ڈھونڈ'=>['ur',],
'ڈیپارٹمنٹ'=>['ur',],
'ژنرال'=>['fa',],
'کا'=>['ur',],
'کار'=>['fa','ur',],
'کارت'=>['fa',],
'کارو'=>['fa',],
'کاروبار'=>['ur',],
'کاري'=>['fa',],
'کارڈ'=>['ur',],
'کارکوژیہ'=>['ur',],
'کاش'=>['ur',],
'کاغذ'=>['ur',],
'کاغذات'=>['ur',],
'کافي'=>['fa',],
'کافيه'=>['fa',],
'کافی'=>['ur',],
'کام'=>['ur',],
'کامل'=>['fa',],
'کاملا'=>['fa',],
'کب'=>['ur',],
'کبھی'=>['ur',],
'کتاب'=>['fa',],
'کتنا'=>['ur',],
'کتنے'=>['ur',],
'کجا'=>['fa',],
'کجاست'=>['fa',],
'کدوم'=>['fa',],
'کر'=>['ur',],
'کرا'=>['ur',],
'کراکوژین'=>['ur',],
'کراکوژیہ'=>['ur',],
'کرتا'=>['ur',],
'کرتی'=>['ur',],
'کرتے'=>['ur',],
'کرد'=>['fa',],
'کردم'=>['fa',],
'کردن'=>['fa',],
'کردند'=>['fa',],
'کرده'=>['fa',],
'کردو'=>['ur',],
'کردي'=>['fa',],
'کرديم'=>['fa',],
'کرنا'=>['ur',],
'کرنی'=>['ur',],
'کرنے'=>['ur',],
'کرو'=>['ur',],
'کروں'=>['ur',],
'کرکے'=>['ur',],
'کریں'=>['ur',],
'کرے'=>['ur',],
'کس'=>['fa','ur',],
'کسي'=>['fa',],
'کسی'=>['fa','ur',],
'کشتن'=>['fa',],
'کشته'=>['fa',],
'کشی'=>['ur',],
'کل'=>['fa','ur',],
'کم'=>['fa','ur',],
'کمال'=>['ur',],
'کمرے'=>['ur',],
'کمشنر'=>['ur',],
'کمي'=>['fa',],
'کمک'=>['fa',],
'کمی'=>['ur',],
'کن'=>['fa',],
'کنار'=>['fa',],
'کند'=>['fa',],
'کنم'=>['fa',],
'کنن'=>['fa',],
'کنند'=>['fa',],
'کننده'=>['fa',],
'کنه'=>['fa',],
'کني'=>['fa',],
'کنيد'=>['fa',],
'کنيم'=>['fa',],
'کنين'=>['fa',],
'کنگ'=>['ur',],
'کنی'=>['fa',],
'کنید'=>['fa',],
'کنیم'=>['fa',],
'کنین'=>['fa',],
'که'=>['fa',],
'کو'=>['ur',],
'کوئی'=>['ur',],
'کوشش'=>['ur',],
'کون'=>['ur',],
'کوڑا'=>['ur',],
'کوژیہ'=>['ur',],
'کي'=>['fa',],
'کيه'=>['fa',],
'کچھ'=>['ur',],
'کھا'=>['ur',],
'کھانا'=>['ur',],
'کھانے'=>['ur',],
'کھول'=>['ur',],
'کھڑے'=>['ur',],
'کھیل'=>['ur',],
'کہ'=>['ur',],
'کہا'=>['ur',],
'کہانی'=>['ur',],
'کہانیاں'=>['ur',],
'کہاں'=>['ur',],
'کہتا'=>['ur',],
'کہتی'=>['ur',],
'کہتے'=>['ur',],
'کہنا'=>['ur',],
'کہنے'=>['ur',],
'کہوں'=>['ur',],
'کہہ'=>['ur',],
'کہیں'=>['ur',],
'کی'=>['fa','ur',],
'کیا'=>['ur',],
'کیجئے'=>['ur',],
'کیسا'=>['ur',],
'کیسے'=>['ur',],
'کیلئے'=>['ur',],
'کیمرہ'=>['ur',],
'کیونکہ'=>['ur',],
'کیوں'=>['ur',],
'کیٹس'=>['ur',],
'کے'=>['ur',],
'گئی'=>['ur',],
'گئے'=>['ur',],
'گا'=>['ur',],
'گارسیو'=>['ur',],
'گذشته'=>['fa',],
'گرفت'=>['fa',],
'گرفتم'=>['fa',],
'گرفتن'=>['fa',],
'گرفته'=>['fa',],
'گرم'=>['fa',],
'گروه'=>['fa',],
'گفت'=>['fa',],
'گفتم'=>['fa',],
'گفتن'=>['fa',],
'گفته'=>['fa',],
'گفتي'=>['fa',],
'گلی'=>['ur',],
'گلیوں'=>['ur',],
'گم'=>['fa',],
'گوش'=>['fa',],
'گولسن'=>['ur',],
'گولیاں'=>['ur',],
'گير'=>['fa',],
'گپتا'=>['ur',],
'گھر'=>['ur',],
'گھنٹے'=>['ur',],
'گھوڑا'=>['ur',],
'گھوڑے'=>['ur',],
'گھڑی'=>['ur',],
'گی'=>['ur',],
'گیا'=>['ur',],
'گیلا'=>['ur',],
'گے'=>['ur',],
'ہائے'=>['ur',],
'ہاتھ'=>['ur',],
'ہاں'=>['ur',],
'ہتھیار'=>['ur',],
'ہجوم'=>['ur',],
'ہر'=>['ur',],
'ہرنی'=>['ur',],
'ہزاروں'=>['ur',],
'ہفتہ'=>['ur',],
'ہفتے'=>['ur',],
'ہلکا'=>['ur',],
'ہم'=>['ur',],
'ہمارا'=>['ur',],
'ہماری'=>['ur',],
'ہمارے'=>['ur',],
'ہمت'=>['ur',],
'ہمیشہ'=>['ur',],
'ہمیں'=>['ur',],
'ہو'=>['ur',],
'ہوئی'=>['ur',],
'ہوئے'=>['ur',],
'ہوا'=>['ur',],
'ہوائی'=>['ur',],
'ہوتا'=>['ur',],
'ہوتی'=>['ur',],
'ہوتے'=>['ur',],
'ہونا'=>['ur',],
'ہونے'=>['ur',],
'ہوگا'=>['ur',],
'ہوگی'=>['ur',],
'ہوں'=>['ur',],
'ہٹ'=>['ur',],
'ہٹو'=>['ur',],
'ہی'=>['ur',],
'ہیرا'=>['ur',],
'ہیری'=>['ur',],
'ہیلو'=>['ur',],
'ہیں'=>['ur',],
'ہے'=>['ur',],
'ی'=>['fa',],
'یا'=>['fa','ur',],
'یاد'=>['ur',],
'یار'=>['ur',],
'یارک'=>['ur',],
'یعنی'=>['ur',],
'یقین'=>['ur',],
'یه'=>['fa',],
'یک'=>['fa',],
'یکی'=>['fa',],
'یہ'=>['ur',],
'یہاں'=>['ur',],
'یہی'=>['ur',],
'یہیں'=>['ur',],
'अगर'=>['hi',],
'अटक'=>['hi',],
'अपहरण'=>['hi',],
'अब'=>['hi',],
'अलग'=>['hi',],
'अवसर'=>['hi',],
'असहज'=>['hi',],
'आ'=>['hi',],
'आए'=>['hi',],
'आओ'=>['hi',],
'आग'=>['hi',],
'आगमन'=>['hi',],
'आज'=>['hi',],
'आप'=>['hi',],
'आह'=>['hi',],
'इन'=>['hi',],
'इस'=>['hi',],
'उन'=>['hi',],
'उस'=>['hi',],
'ऊपर'=>['hi',],
'ए'=>['hi',],
'एक'=>['hi',],
'ओर'=>['hi',],
'ओह'=>['hi',],
'और'=>['hi',],
'औरत'=>['hi',],
'कई'=>['hi',],
'कदम'=>['hi',],
'कब'=>['hi',],
'कम'=>['hi',],
'कर'=>['hi',],
'कल'=>['hi',],
'कसकर'=>['hi',],
'कसम'=>['hi',],
'कह'=>['hi',],
'गए'=>['hi',],
'गरम'=>['hi',],
'गलत'=>['hi',],
'गहन'=>['hi',],
'घर'=>['hi',],
'जगह'=>['hi',],
'जब'=>['hi',],
'टन'=>['hi',],
'डर'=>['hi',],
'तक'=>['hi',],
'तब'=>['hi',],
'तय'=>['hi',],
'तरह'=>['hi',],
'तहत'=>['hi',],
'थक'=>['hi',],
'दर'=>['hi',],
'न'=>['hi',],
'नए'=>['hi',],
'नफरत'=>['hi',],
'नरक'=>['hi',],
'नरम'=>['hi',],
'पदक'=>['hi',],
'पर'=>['hi',],
'पहन'=>['hi',],
'बगल'=>['hi',],
'बच'=>['hi',],
'बदतर'=>['hi',],
'बदल'=>['hi',],
'बन'=>['hi',],
'बस'=>['hi',],
'बहन'=>['hi',],
'भय'=>['hi',],
'मई'=>['hi',],
'मत'=>['hi',],
'मतलब'=>['hi',],
'मदद'=>['hi',],
'मन'=>['hi',],
'मर'=>['hi',],
'यह'=>['hi',],
'रह'=>['hi',],
'लग'=>['hi',],
'लगभग'=>['hi',],
'वजह'=>['hi',],
'वन'=>['hi',],
'वह'=>['hi',],
'शक'=>['hi',],
'शहर'=>['hi',],
'सच'=>['hi',],
'सफल'=>['hi',],
'सब'=>['hi',],
'समझ'=>['hi',],
'समय'=>['hi',],
'सहमत'=>['hi',],
'हम'=>['hi',],
'हर'=>['hi',],
'हल'=>['hi',],
'অপহরন'=>['bn',],
'আচরন'=>['bn',],
'আজ'=>['bn',],
'আজব'=>['bn',],
'আট'=>['bn',],
'আদম'=>['bn',],
'আর'=>['bn',],
'আরও'=>['bn',],
'আসন'=>['bn',],
'আহ'=>['bn',],
'আহত'=>['bn',],
'উপর'=>['bn',],
'এ'=>['bn',],
'এই'=>['bn',],
'এইসব'=>['bn',],
'এক'=>['bn',],
'একই'=>['bn',],
'একজন'=>['bn',],
'একজনই'=>['bn',],
'একজনও'=>['bn',],
'একদম'=>['bn',],
'একমত'=>['bn',],
'একশ'=>['bn',],
'একসময়'=>['bn',],
'এখন'=>['bn',],
'এখনই'=>['bn',],
'এখনও'=>['bn',],
'এড'=>['bn',],
'এত'=>['bn',],
'এমন'=>['bn',],
'এমনই'=>['bn',],
'এর'=>['bn',],
'এরকম'=>['bn',],
'এরপর'=>['bn',],
'এসব'=>['bn',],
'ও'=>['bn',],
'ওই'=>['bn',],
'ওর'=>['bn',],
'ওহ'=>['bn',],
'কখন'=>['bn',],
'কখনও'=>['bn',],
'কখনওই'=>['bn',],
'কত'=>['bn',],
'কতজন'=>['bn',],
'কবর'=>['bn',],
'কম'=>['bn',],
'কর'=>['bn',],
'খবর'=>['bn',],
'খরচ'=>['bn',],
'গত'=>['bn',],
'গন'=>['bn',],
'গরম'=>['bn',],
'ঘর'=>['bn',],
'চল'=>['bn',],
'ছয়'=>['bn',],
'জগৎ'=>['bn',],
'জন'=>['bn',],
'তখন'=>['bn',],
'তখনও'=>['bn',],
'ততই'=>['bn',],
'দমন'=>['bn',],
'দশম'=>['bn',],
'ধর'=>['bn',],
'নই'=>['bn',],
'নও'=>['bn',],
'নজর'=>['bn',],
'নন'=>['bn',],
'নবম'=>['bn',],
'নয়'=>['bn',],
'পথ'=>['bn',],
'পথও'=>['bn',],
'পন'=>['bn',],
'পর'=>['bn',],
'বছর'=>['bn',],
'বড়'=>['bn',],
'বন'=>['bn',],
'বয়স'=>['bn',],
'ভয়'=>['bn',],
'মত'=>['bn',],
'মরণপণ'=>['bn',],
'যখন'=>['bn',],
'যত'=>['bn',],
'সব'=>['bn',],
'সবসময়ই'=>['bn',],
'সময়'=>['bn',],
'হও'=>['bn',],
'হত'=>['bn',],
'হয়'=>['bn',],
'අගය'=>['si',],
'අඩපන'=>['si',],
'අණ'=>['si',],
'අඬ'=>['si',],
'අත'=>['si',],
'අතඇරල'=>['si',],
'අතකට'=>['si',],
'අතට'=>['si',],
'අතද'=>['si',],
'අතන'=>['si',],
'අතනට'=>['si',],
'අතර'=>['si',],
'අතරට'=>['si',],
'අද'=>['si',],
'අදට'=>['si',],
'අදහන'=>['si',],
'අදහස'=>['si',],
'අදහසට'=>['si',],
'අප'=>['si',],
'අපට'=>['si',],
'අපව'=>['si',],
'අමතක'=>['si',],
'අමතකද'=>['si',],
'අමතර'=>['si',],
'අමන'=>['si',],
'අය'=>['si',],
'අයට'=>['si',],
'අයව'=>['si',],
'අර'=>['si',],
'අරක'=>['si',],
'අරය'=>['si',],
'අල'=>['si',],
'අවට'=>['si',],
'අවනත'=>['si',],
'අවම'=>['si',],
'අවසර'=>['si',],
'අවසරද'=>['si',],
'අවසරපත'=>['si',],
'අවසරය'=>['si',],
'අසරණ'=>['si',],
'අහ'=>['si',],
'අහකට'=>['si',],
'අහන'=>['si',],
'අහනව'=>['si',],
'අහල'=>['si',],
'අහස'=>['si',],
'අහසට'=>['si',],
'ආ'=>['si',],
'ආආ'=>['si',],
'ආකර'=>['si',],
'ආකරය'=>['si',],
'ආකරයට'=>['si',],
'ආගම'=>['si',],
'ආදර'=>['si',],
'ආදරය'=>['si',],
'ආය'=>['si',],
'ආයතන'=>['si',],
'ආයතනයට'=>['si',],
'ආව'=>['si',],
'ආවට'=>['si',],
'ආවද'=>['si',],
'ආවම'=>['si',],
'ආවරණය'=>['si',],
'ආවරන'=>['si',],
'ආවහම'=>['si',],
'ආස'=>['si',],
'ආසන'=>['si',],
'ආසම'=>['si',],
'ඇග'=>['si',],
'ඇගට'=>['si',],
'ඇගටම'=>['si',],
'ඇඟ'=>['si',],
'ඇඟට'=>['si',],
'ඇට'=>['si',],
'ඇණ'=>['si',],
'ඇත'=>['si',],
'ඇද'=>['si',],
'ඇදල'=>['si',],
'ඇඳ'=>['si',],
'ඇඳට'=>['si',],
'ඇඳල'=>['si',],
'ඇය'=>['si',],
'ඇයට'=>['si',],
'ඇයම'=>['si',],
'ඇයව'=>['si',],
'ඇරල'=>['si',],
'ඇස'=>['si',],
'ඇහකට'=>['si',],
'ඈ'=>['si',],
'ඈට'=>['si',],
'ඈත'=>['si',],
'ඈතට'=>['si',],
'ඈව'=>['si',],
'ඉකමණට'=>['si',],
'ඉඩ'=>['si',],
'ඉද'=>['si',],
'ඉදල'=>['si',],
'ඉදලද'=>['si',],
'ඉඳ'=>['si',],
'ඉඳල'=>['si',],
'ඉඳලද'=>['si',],
'ඉඳලම'=>['si',],
'ඉර'=>['si',],
'ඉරණම'=>['si',],
'ඉරනම'=>['si',],
'ඉරල'=>['si',],
'ඉව'=>['si',],
'ඉවතට'=>['si',],
'ඉවර'=>['si',],
'ඉවරද'=>['si',],
'ඉවසල'=>['si',],
'ඉහල'=>['si',],
'ඉහලට'=>['si',],
'ඉහලටම'=>['si',],
'ඊ'=>['si',],
'ඊට'=>['si',],
'ඊතල'=>['si',],
'ඊලග'=>['si',],
'ඊලගට'=>['si',],
'ඊලඟ'=>['si',],
'ඊලඟට'=>['si',],
'ඊළඟ'=>['si',],
'ඊළඟට'=>['si',],
'උ'=>['si',],
'උඩ'=>['si',],
'උඩට'=>['si',],
'උඩද'=>['si',],
'උඩහ'=>['si',],
'උණ'=>['si',],
'උදය'=>['si',],
'උන'=>['si',],
'උප'=>['si',],
'උපකරණ'=>['si',],
'උබ'=>['si',],
'උබට'=>['si',],
'උබලට'=>['si',],
'උබව'=>['si',],
'උඹ'=>['si',],
'උඹට'=>['si',],
'උඹටම'=>['si',],
'උඹද'=>['si',],
'උඹබ'=>['si',],
'උඹම'=>['si',],
'උඹල'=>['si',],
'උඹලට'=>['si',],
'උඹලව'=>['si',],
'උඹව'=>['si',],
'උයන'=>['si',],
'උයනව'=>['si',],
'උයමන'=>['si',],
'උස'=>['si',],
'ඌ'=>['si',],
'ඌට'=>['si',],
'ඌම'=>['si',],
'ඌව'=>['si',],
'එ'=>['si',],
'එක'=>['si',],
'එකක'=>['si',],
'එකකට'=>['si',],
'එකග'=>['si',],
'එකඟ'=>['si',],
'එකට'=>['si',],
'එකටද'=>['si',],
'එකටම'=>['si',],
'එකද'=>['si',],
'එකම'=>['si',],
'එකවර'=>['si',],
'එත'=>['si',],
'එතන'=>['si',],
'එතනට'=>['si',],
'එන'=>['si',],
'එනබව'=>['si',],
'එනව'=>['si',],
'එනවද'=>['si',],
'එප'=>['si',],
'එම'=>['si',],
'එය'=>['si',],
'එයට'=>['si',],
'එල'=>['si',],
'එවල'=>['si',],
'ඒ'=>['si',],
'ඒක'=>['si',],
'ඒකක'=>['si',],
'ඒකකය'=>['si',],
'ඒකට'=>['si',],
'ඒකටම'=>['si',],
'ඒකද'=>['si',],
'ඒකම'=>['si',],
'ඒකව'=>['si',],
'ඒත'=>['si',],
'ඒව'=>['si',],
'ඒවට'=>['si',],
'ඒවද'=>['si',],
'ඔ'=>['si',],
'ඔක'=>['si',],
'ඔතන'=>['si',],
'ඔතනම'=>['si',],
'ඔතල'=>['si',],
'ඔන'=>['si',],
'ඔබ'=>['si',],
'ඔබට'=>['si',],
'ඔබද'=>['si',],
'ඔබල'=>['si',],
'ඔබලට'=>['si',],
'ඔබලව'=>['si',],
'ඔබව'=>['si',],
'ඔම'=>['si',],
'ඔමට'=>['si',],
'ඔය'=>['si',],
'ඕ'=>['si',],
'ඕක'=>['si',],
'ඕකට'=>['si',],
'ඕන'=>['si',],
'ඕනද'=>['si',],
'ඕනම'=>['si',],
'ඕනවට'=>['si',],
'ඕව'=>['si',],
'ඕවට'=>['si',],
'ක'=>['si',],
'කට'=>['si',],
'කටට'=>['si',],
'කටහඬ'=>['si',],
'කඩ'=>['si',],
'කඩන'=>['si',],
'කඩනවද'=>['si',],
'කණට'=>['si',],
'කන'=>['si',],
'කනව'=>['si',],
'කනවද'=>['si',],
'කපනව'=>['si',],
'කපල'=>['si',],
'කම'=>['si',],
'කමකට'=>['si',],
'කමට'=>['si',],
'කර'=>['si',],
'කරකර'=>['si',],
'කරදර'=>['si',],
'කරන'=>['si',],
'කරනඑක'=>['si',],
'කරනව'=>['si',],
'කරනවට'=>['si',],
'කරනවද'=>['si',],
'කරල'=>['si',],
'කරවන'=>['si',],
'කල'=>['si',],
'කලබල'=>['si',],
'කවද'=>['si',],
'කවදද'=>['si',],
'කවම'=>['si',],
'කසන'=>['si',],
'කසල'=>['si',],
'කහ'=>['si',],
'කළ'=>['si',],
'කළබල'=>['si',],
'කළහම'=>['si',],
'ග'=>['si',],
'ගග'=>['si',],
'ගගට'=>['si',],
'ගඟ'=>['si',],
'ගඟට'=>['si',],
'ගණන'=>['si',],
'ගත'=>['si',],
'ගද'=>['si',],
'ගනන'=>['si',],
'ගඳ'=>['si',],
'ගඳට'=>['si',],
'ගම'=>['si',],
'ගමක'=>['si',],
'ගමට'=>['si',],
'ගමන'=>['si',],
'ගල'=>['si',],
'ගලන'=>['si',],
'ගලවල'=>['si',],
'ගහ'=>['si',],
'ගහකට'=>['si',],
'ගහන'=>['si',],
'ගහනව'=>['si',],
'ගහල'=>['si',],
'ජ'=>['si',],
'ජජජ'=>['si',],
'ජය'=>['si',],
'ජල'=>['si',],
'ජලය'=>['si',],
'ට'=>['si',],
'ටම'=>['si',],
'ණය'=>['si',],
'ණයද'=>['si',],
'තද'=>['si',],
'තදබදය'=>['si',],
'තදබල'=>['si',],
'තම'=>['si',],
'තමරට'=>['si',],
'තඹ'=>['si',],
'තරග'=>['si',],
'තරගය'=>['si',],
'තරඟ'=>['si',],
'තරඟය'=>['si',],
'තරණය'=>['si',],
'තරම'=>['si',],
'තරමට'=>['si',],
'තරමටම'=>['si',],
'තරහ'=>['si',],
'තව'=>['si',],
'තවම'=>['si',],
'තහනම'=>['si',],
'ද'=>['si',],
'දඩ'=>['si',],
'දඩයමට'=>['si',],
'දණ'=>['si',],
'දතක'=>['si',],
'දදයට'=>['si',],
'දබරය'=>['si',],
'දර'=>['si',],
'දවස'=>['si',],
'දවසක'=>['si',],
'දවසකට'=>['si',],
'දවසට'=>['si',],
'දවසම'=>['si',],
'දස'=>['si',],
'දහ'=>['si',],
'දහය'=>['si',],
'ධ'=>['si',],
'න'=>['si',],
'නගර'=>['si',],
'නගරය'=>['si',],
'නගරයට'=>['si',],
'නඟරය'=>['si',],
'නඟරයම'=>['si',],
'නතර'=>['si',],
'නම'=>['si',],
'නමද'=>['si',],
'නමය'=>['si',],
'නරක'=>['si',],
'නරකට'=>['si',],
'නරකම'=>['si',],
'නව'=>['si',],
'නහය'=>['si',],
'නහයකට'=>['si',],
'නහර'=>['si',],
'නළ'=>['si',],
'ප'=>['si',],
'පකඩ'=>['si',],
'පඩ'=>['si',],
'පණ'=>['si',],
'පත'=>['si',],
'පථයටද'=>['si',],
'පදවන'=>['si',],
'පමණ'=>['si',],
'පය'=>['si',],
'පර'=>['si',],
'පරණ'=>['si',],
'පරන'=>['si',],
'පල'=>['si',],
'පලකට'=>['si',],
'පලස'=>['si',],
'පව'=>['si',],
'පස'=>['si',],
'පසට'=>['si',],
'පහ'=>['si',],
'පහකට'=>['si',],
'පහට'=>['si',],
'පහත'=>['si',],
'පහන'=>['si',],
'පහර'=>['si',],
'පහල'=>['si',],
'පහලට'=>['si',],
'පහව'=>['si',],
'පහළ'=>['si',],
'බ'=>['si',],
'බඩ'=>['si',],
'බඩට'=>['si',],
'බය'=>['si',],
'බයද'=>['si',],
'බර'=>['si',],
'බරපතල'=>['si',],
'බල'=>['si',],
'බලතලවල'=>['si',],
'බලන'=>['si',],
'බලනව'=>['si',],
'බලනවද'=>['si',],
'බලය'=>['si',],
'බලල'=>['si',],
'බව'=>['si',],
'බවට'=>['si',],
'භය'=>['si',],
'ම'=>['si',],
'මකර'=>['si',],
'මග'=>['si',],
'මඟ'=>['si',],
'මට'=>['si',],
'මටද'=>['si',],
'මටම'=>['si',],
'මඩ'=>['si',],
'මත'=>['si',],
'මතක'=>['si',],
'මතකද'=>['si',],
'මතකය'=>['si',],
'මතකයට'=>['si',],
'මතට'=>['si',],
'මතය'=>['si',],
'මනස'=>['si',],
'මනසට'=>['si',],
'මබ'=>['si',],
'මම'=>['si',],
'මමද'=>['si',],
'මමම'=>['si',],
'මර'=>['si',],
'මරණ'=>['si',],
'මරණය'=>['si',],
'මරණයට'=>['si',],
'මරන'=>['si',],
'මරනය'=>['si',],
'මරනව'=>['si',],
'මරනවද'=>['si',],
'මරල'=>['si',],
'මල'=>['si',],
'මව'=>['si',],
'මහ'=>['si',],
'මහජන'=>['si',],
'මහත'=>['si',],
'මහපට'=>['si',],
'මහල'=>['si',],
'මහලට'=>['si',],
'මළ'=>['si',],
'යකඩ'=>['si',],
'යට'=>['si',],
'යටට'=>['si',],
'යන'=>['si',],
'යනඑක'=>['si',],
'යනව'=>['si',],
'යනවට'=>['si',],
'යනවද'=>['si',],
'යවන'=>['si',],
'යවනව'=>['si',],
'රජ'=>['si',],
'රජකමට'=>['si',],
'රජය'=>['si',],
'රජයට'=>['si',],
'රට'=>['si',],
'රටට'=>['si',],
'රටවල'=>['si',],
'රණ'=>['si',],
'රථ'=>['si',],
'රථය'=>['si',],
'රථයද'=>['si',],
'රවනව'=>['si',],
'රස'=>['si',],
'රසය'=>['si',],
'රහස'=>['si',],
'රහසද'=>['si',],
'ල'=>['si',],
'ලග'=>['si',],
'ලගට'=>['si',],
'ලගම'=>['si',],
'ලඟ'=>['si',],
'ලඟට'=>['si',],
'ලඟද'=>['si',],
'ලඟම'=>['si',],
'ලට'=>['si',],
'ලබන'=>['si',],
'ලමයට'=>['si',],
'ව'=>['si',],
'වග'=>['si',],
'වචන'=>['si',],
'වචනය'=>['si',],
'වට'=>['si',],
'වටය'=>['si',],
'වද'=>['si',],
'වධ'=>['si',],
'වන'=>['si',],
'වඳ'=>['si',],
'වමට'=>['si',],
'වයරයට'=>['si',],
'වයස'=>['si',],
'වයසක'=>['si',],
'වයසට'=>['si',],
'වර'=>['si',],
'වරද'=>['si',],
'වරම'=>['si',],
'වල'=>['si',],
'වලට'=>['si',],
'වලද'=>['si',],
'වලය'=>['si',],
'වස'=>['si',],
'වසර'=>['si',],
'වසරකම'=>['si',],
'වහ'=>['si',],
'වහනව'=>['si',],
'වහල'=>['si',],
'ශත'=>['si',],
'ස'=>['si',],
'සටන'=>['si',],
'සටනකට'=>['si',],
'සටනට'=>['si',],
'සද'=>['si',],
'සදහටම'=>['si',],
'සම'=>['si',],
'සමග'=>['si',],
'සමගම'=>['si',],
'සමඟ'=>['si',],
'සමඟම'=>['si',],
'සමහර'=>['si',],
'සරල'=>['si',],
'සරලව'=>['si',],
'සහ'=>['si',],
'සහය'=>['si',],
'හඩ'=>['si',],
'හඩට'=>['si',],
'හඬ'=>['si',],
'හතර'=>['si',],
'හතරකට'=>['si',],
'හතරට'=>['si',],
'හතරම'=>['si',],
'හද'=>['si',],
'හදට'=>['si',],
'හදන'=>['si',],
'හදනව'=>['si',],
'හදනවද'=>['si',],
'හදල'=>['si',],
'හදවත'=>['si',],
'හදවතට'=>['si',],
'හදවතම'=>['si',],
'හම'=>['si',],
'හමන'=>['si',],
'හය'=>['si',],
'හරවන'=>['si',],
'හරවල'=>['si',],
'හරහ'=>['si',],
'හරහට'=>['si',],
'හවස'=>['si',],
'හවසට'=>['si',],
'ළගට'=>['si',],
'ළඟ'=>['si',],
'ළඟට'=>['si',],
'ළමය'=>['si',],
'ළමයට'=>['si',],
'ළමයව'=>['si',],
'ก'=>['th',],
'กh'=>['th',],
'กi'=>['th',],
'กช'=>['th',],
'กฏของ'=>['th',],
'กม'=>['th',],
'กลาร'=>['th',],
'กได'=>['th',],
'ขวบ'=>['th',],
'ขอ'=>['th',],
'ของ'=>['th',],
'ของนาย'=>['th',],
'ของประเทศ'=>['th',],
'ของผม'=>['th',],
'ของเธอ'=>['th',],
'ขอดาบ'=>['th',],
'ขอทาง'=>['th',],
'ขอบอก'=>['th',],
'ขอบใจ'=>['th',],
'ขอบใจนะ'=>['th',],
'ขอบใจมาก'=>['th',],
'ขอยำ'=>['th',],
'ขอโทษ'=>['th',],
'ขอโทษนะ'=>['th',],
'ขอโทษนะคะ'=>['th',],
'ขานาย'=>['th',],
'ขาผม'=>['th',],
'ขโมย'=>['th',],
'ค'=>['th',],
'คf'=>['th',],
'คkคh'=>['th',],
'คu'=>['th',],
'คuจฎฅxจำกi'=>['th',],
'คฃ'=>['th',],
'คฃฐ'=>['th',],
'คน'=>['th',],
'คนสวย'=>['th',],
'คนเอง'=>['th',],
'คนไข'=>['th',],
'คม'=>['th',],
'ความตาย'=>['th',],
'คะ'=>['th',],
'คาบานาตวน'=>['th',],
'คาราบาล'=>['th',],
'คาวบอย'=>['th',],
'คำถาม'=>['th',],
'คำวา'=>['th',],
'ฆ'=>['th',],
'ฆn'=>['th',],
'ฆnกaฆn'=>['th',],
'ฆnคf'=>['th',],
'ฆnงa'=>['th',],
'ฆธ'=>['th',],
'ฆา'=>['th',],
'งaกh'=>['th',],
'งaค'=>['th',],
'งาน'=>['th',],
'งเลย'=>['th',],
'จงหายไป'=>['th',],
'จฉ'=>['th',],
'จฎ'=>['th',],
'จฎงa'=>['th',],
'จนท'=>['th',],
'จบ'=>['th',],
'จบค'=>['th',],
'จอรจ'=>['th',],
'จอรช'=>['th',],
'จอรน'=>['th',],
'จอหน'=>['th',],
'จะ'=>['th',],
'จา'=>['th',],
'จาก'=>['th',],
'จากผม'=>['th',],
'จากเขต'=>['th',],
'จำ'=>['th',],
'ฉ'=>['th',],
'ฉาฌฐ'=>['th',],
'ชจชจ'=>['th',],
'ชจชจกi'=>['th',],
'ชบ'=>['th',],
'ชม'=>['th',],
'ชวยดวย'=>['th',],
'ชะ'=>['th',],
'ซาน'=>['th',],
'ซาราห'=>['th',],
'ฌo'=>['th',],
'ฌoชบ'=>['th',],
'ฌฐ'=>['th',],
'ญำ'=>['th',],
'ญำซฤคlฆบคf'=>['th',],
'ฐ'=>['th',],
'ฐอ'=>['th',],
'ฑqจฎธฬบuฅxฅhกi'=>['th',],
'ฒผ'=>['th',],
'ณ'=>['th',],
'ดร'=>['th',],
'ดว'=>['th',],
'ดวย'=>['th',],
'ดอก'=>['th',],
'ดาดา'=>['th',],
'ดาบ'=>['th',],
'ตกลง'=>['th',],
'ตกลงนะ'=>['th',],
'ตกลงไหม'=>['th',],
'ตรงไหน'=>['th',],
'ตลอดไป'=>['th',],
'ตองสำเรจ'=>['th',],
'ตอน'=>['th',],
'ตอนแรก'=>['th',],
'ตอบมา'=>['th',],
'ตามผมมา'=>['th',],
'ตามมา'=>['th',],
'ตามสบาย'=>['th',],
'ตามสบายนะ'=>['th',],
'ตามหมอมา'=>['th',],
'ตามหา'=>['th',],
'ตามใจ'=>['th',],
'ตาย'=>['th',],
'ตำรวจ'=>['th',],
'ถ'=>['th',],
'ถนน'=>['th',],
'ถอย'=>['th',],
'ถอยไป'=>['th',],
'ถอยไปซะ'=>['th',],
'ถามทำไม'=>['th',],
'ถโ'=>['th',],
'ท'=>['th',],
'ทดสอบ'=>['th',],
'ทนหนอย'=>['th',],
'ทหาร'=>['th',],
'ทหารยาม'=>['th',],
'ทอม'=>['th',],
'ทะเล'=>['th',],
'ทางออก'=>['th',],
'ทาน'=>['th',],
'ทานคะ'=>['th',],
'ทานนายพล'=>['th',],
'ทานแม'=>['th',],
'ทาโร'=>['th',],
'ทำความสะอาด'=>['th',],
'ทำงาน'=>['th',],
'ทำทาน'=>['th',],
'ทำอะไร'=>['th',],
'ทำอะไรนะ'=>['th',],
'ทำเลย'=>['th',],
'ทำไม'=>['th',],
'ทำไมละ'=>['th',],
'ทำไมวะ'=>['th',],
'ทำไมหละ'=>['th',],
'ทำไมเหรอ'=>['th',],
'ธรรมดา'=>['th',],
'ธฬ'=>['th',],
'น'=>['th',],
'นm'=>['th',],
'นmงa'=>['th',],
'นกกา'=>['th',],
'นอมม'=>['th',],
'นอยส'=>['th',],
'นะ'=>['th',],
'นากาโนะ'=>['th',],
'นาย'=>['th',],
'นายจะไปไหน'=>['th',],
'นายตองการอะไร'=>['th',],
'นายทหาร'=>['th',],
'นายพล'=>['th',],
'นายอำเภอ'=>['th',],
'นายเปน'=>['th',],
'บ'=>['th',],
'บj'=>['th',],
'บก'=>['th',],
'บรรยายไทยโดย'=>['th',],
'บราโว'=>['th',],
'บอก'=>['th',],
'บอกผม'=>['th',],
'บอกมา'=>['th',],
'บอกวา'=>['th',],
'บอส'=>['th',],
'บาย'=>['th',],
'บาเอย'=>['th',],
'ป'=>['th',],
'ประมาณ'=>['th',],
'ประหลาด'=>['th',],
'ประเทศของเรา'=>['th',],
'ปลอยเธอไป'=>['th',],
'ปอบ'=>['th',],
'ปานดำ'=>['th',],
'ปาวลาส'=>['th',],
'ผ'=>['th',],
'ผkกaงaจsจฦงaกh'=>['th',],
'ผบ'=>['th',],
'ผม'=>['th',],
'ผมขอ'=>['th',],
'ผมขอโทษ'=>['th',],
'ผมทราบ'=>['th',],
'ผมทำได'=>['th',],
'ผมมาจาก'=>['th',],
'ผมวา'=>['th',],
'ผมเกรงวา'=>['th',],
'ผมเปนหมอ'=>['th',],
'ผมเหนดวย'=>['th',],
'ผมเอง'=>['th',],
'ผมโอเค'=>['th',],
'ผมไม'=>['th',],
'ผมไมเปนไร'=>['th',],
'ผลคะแนน'=>['th',],
'ผห'=>['th',],
'พยาบาล'=>['th',],
'พยายาม'=>['th',],
'พรม'=>['th',],
'พรรคพวก'=>['th',],
'พระเจา'=>['th',],
'พระเจาชวย'=>['th',],
'พวก'=>['th',],
'พวกนาย'=>['th',],
'พวกเขา'=>['th',],
'พวกเขาบอกวา'=>['th',],
'พวกเรา'=>['th',],
'พวกเราไป'=>['th',],
'พอ'=>['th',],
'พอละ'=>['th',],
'พอเถอะ'=>['th',],
'พอแลว'=>['th',],
'พาเวล'=>['th',],
'ฟาย'=>['th',],
'ภายใน'=>['th',],
'ม'=>['th',],
'มกราคม'=>['th',],
'มม'=>['th',],
'มยมย'=>['th',],
'มองอะไร'=>['th',],
'มอสโคว'=>['th',],
'มา'=>['th',],
'มาก'=>['th',],
'มากมาย'=>['th',],
'มากอส'=>['th',],
'มาจากไหน'=>['th',],
'มาดาม'=>['th',],
'มายากล'=>['th',],
'มารค'=>['th',],
'มาเถอะ'=>['th',],
'มาเรว'=>['th',],
'มาเลย'=>['th',],
'มาโกะ'=>['th',],
'มาโกะไป'=>['th',],
'มาๆ'=>['th',],
'ย'=>['th',],
'ยฒฎฆคpฉj'=>['th',],
'ยอด'=>['th',],
'ยานอวกาศ'=>['th',],
'ยามาโมโต'=>['th',],
'ร'=>['th',],
'รถ'=>['th',],
'รปภ'=>['th',],
'รอ'=>['th',],
'รอกอน'=>['th',],
'รอคอย'=>['th',],
'รอบ'=>['th',],
'รอยบอล'=>['th',],
'รอส'=>['th',],
'ระยะ'=>['th',],
'ระยำ'=>['th',],
'ระยำเอย'=>['th',],
'ราย'=>['th',],
'ราเชล'=>['th',],
'ฤ'=>['th',],
'ฤลอ'=>['th',],
'ฤๅ'=>['th',],
'ลงมาเลย'=>['th',],
'ลงไป'=>['th',],
'ลอง'=>['th',],
'ลอนดอน'=>['th',],
'ละ'=>['th',],
'ลางทำลาย'=>['th',],
'ลำ'=>['th',],
'ว'=>['th',],
'วา'=>['th',],
'วางเปลา'=>['th',],
'วาน'=>['th',],
'วานเดอเมอร'=>['th',],
'วาว'=>['th',],
'วาไง'=>['th',],
'ศแ'=>['th',],
'ษ'=>['th',],
'ส'=>['th',],
'สด'=>['th',],
'สบายมาก'=>['th',],
'สปอค'=>['th',],
'สวย'=>['th',],
'สวยมาก'=>['th',],
'สห'=>['th',],
'สหาย'=>['th',],
'สอง'=>['th',],
'สาม'=>['th',],
'สามารถ'=>['th',],
'สาว'=>['th',],
'สเกล'=>['th',],
'สเตฟ'=>['th',],
'สเปลแมน'=>['th',],
'ห'=>['th',],
'หก'=>['th',],
'หมวด'=>['th',],
'หมอ'=>['th',],
'หมอบ'=>['th',],
'หมอบลง'=>['th',],
'หมายความวา'=>['th',],
'หรอ'=>['th',],
'หรอก'=>['th',],
'หรอกนะ'=>['th',],
'หลบ'=>['th',],
'หลบไป'=>['th',],
'หลบไปๆ'=>['th',],
'หลา'=>['th',],
'หะ'=>['th',],
'หา'=>['th',],
'หายไปไหนมา'=>['th',],
'หาเอย'=>['th',],
'ฬล'=>['th',],
'ฬแ'=>['th',],
'ฬๅ'=>['th',],
'อ'=>['th',],
'อนาคต'=>['th',],
'อนาคตของผม'=>['th',],
'อม'=>['th',],
'อยา'=>['th',],
'อยาก'=>['th',],
'อยางนอย'=>['th',],
'อยางแรก'=>['th',],
'อวกาศ'=>['th',],
'ออ'=>['th',],
'ออกมา'=>['th',],
'ออกไป'=>['th',],
'ออกไปซะ'=>['th',],
'ออกไปเลย'=>['th',],
'ออฟ'=>['th',],
'อฯฬฯ'=>['th',],
'อฯฬฯำ'=>['th',],
'อะเหรอ'=>['th',],
'อะไร'=>['th',],
'อะไรคะ'=>['th',],
'อะไรนะ'=>['th',],
'อะไรวะ'=>['th',],
'อะไรเหรอ'=>['th',],
'อา'=>['th',],
'อาจจะ'=>['th',],
'อาชญากรรม'=>['th',],
'อาหารแมว'=>['th',],
'อาา'=>['th',],
'อาเมน'=>['th',],
'อแ'=>['th',],
'อแมนดา'=>['th',],
'ฮ'=>['th',],
'ฮง'=>['th',],
'ฮะ'=>['th',],
'ฮานาโกะ'=>['th',],
'ฯ'=>['th',],
'ะ'=>['th',],
'ำ'=>['th',],
'ำษสมรฯ'=>['th',],
'ำแ'=>['th',],
'ำๅ'=>['th',],
'เกม'=>['th',],
'เกมสจบแลว'=>['th',],
'เกรซ'=>['th',],
'เกลน'=>['th',],
'เกวน'=>['th',],
'เขต'=>['th',],
'เขา'=>['th',],
'เขามา'=>['th',],
'เขามาเลย'=>['th',],
'เขาเปนใคร'=>['th',],
'เขาใจ'=>['th',],
'เขาใจแลว'=>['th',],
'เขาไปขางใน'=>['th',],
'เค'=>['th',],
'เคน'=>['th',],
'เคมเปไต'=>['th',],
'เคมไป'=>['th',],
'เคย'=>['th',],
'เครเมอ'=>['th',],
'เจ'=>['th',],
'เจค'=>['th',],
'เจน'=>['th',],
'เจมส'=>['th',],
'เจานาย'=>['th',],
'เจเจ'=>['th',],
'เชคอฟ'=>['th',],
'เซ'=>['th',],
'เดกนอย'=>['th',],
'เดฟ'=>['th',],
'เดล'=>['th',],
'เดอ'=>['th',],
'เดอะ'=>['th',],
'เทรดสโตน'=>['th',],
'เทรน'=>['th',],
'เธอ'=>['th',],
'เนล'=>['th',],
'เบน'=>['th',],
'เบลน'=>['th',],
'เปนอะไร'=>['th',],
'เปนไงบาง'=>['th',],
'เปนไปไมได'=>['th',],
'เปลา'=>['th',],
'เพรซแมน'=>['th',],
'เพราะ'=>['th',],
'เพราะผม'=>['th',],
'เพราะวา'=>['th',],
'เพเลโกโตส'=>['th',],
'เมกะทรอน'=>['th',],
'เมตร'=>['th',],
'เมตรแลว'=>['th',],
'เย'=>['th',],
'เยนไว'=>['th',],
'เยล'=>['th',],
'เรงหนอย'=>['th',],
'เรว'=>['th',],
'เรวเขา'=>['th',],
'เรอะ'=>['th',],
'เรา'=>['th',],
'เราตองไปแลว'=>['th',],
'เราพบ'=>['th',],
'เรามา'=>['th',],
'เราเคย'=>['th',],
'เราเจอแลว'=>['th',],
'เลม'=>['th',],
'เลย'=>['th',],
'เลยนะ'=>['th',],
'เวด'=>['th',],
'เวร'=>['th',],
'เวรกรรม'=>['th',],
'เวลา'=>['th',],
'เวลาประมาณ'=>['th',],
'เห'=>['th',],
'เหนไหม'=>['th',],
'เหรอ'=>['th',],
'เหลวไหล'=>['th',],
'เหอ'=>['th',],
'เหอะ'=>['th',],
'เอง'=>['th',],
'เอซรา'=>['th',],
'เอนเตอรไพรส'=>['th',],
'เอสเชอสตราเซ'=>['th',],
'เออ'=>['th',],
'เออๆ'=>['th',],
'เอา'=>['th',],
'เอาละ'=>['th',],
'เอาละนะ'=>['th',],
'เอาหละ'=>['th',],
'เอาเถอะ'=>['th',],
'เอาเลย'=>['th',],
'เอาไป'=>['th',],
'เอาไปซะ'=>['th',],
'เอาไปเลย'=>['th',],
'เอเมน'=>['th',],
'เฮ'=>['th',],
'เฮย'=>['th',],
'เฮยพวก'=>['th',],
'เฮลโล'=>['th',],
'เฮลโหล'=>['th',],
'เฮอะ'=>['th',],
'เฮเลนา'=>['th',],
'แ'=>['th',],
'แก'=>['th',],
'แกะรอย'=>['th',],
'แกเปนใคร'=>['th',],
'แขก'=>['th',],
'แขน'=>['th',],
'แคมพอส'=>['th',],
'แครอล'=>['th',],
'แควก'=>['th',],
'แซม'=>['th',],
'แดช'=>['th',],
'แดน'=>['th',],
'แต'=>['th',],
'แตทวา'=>['th',],
'แตผมทำได'=>['th',],
'แตวา'=>['th',],
'แถว'=>['th',],
'แถวตรง'=>['th',],
'แทม'=>['th',],
'แนนอน'=>['th',],
'แนะ'=>['th',],
'แบบ'=>['th',],
'แปลไทยโดย'=>['th',],
'แพท'=>['th',],
'แพม'=>['th',],
'แม'=>['th',],
'แมคคอย'=>['th',],
'แมคเอลรอย'=>['th',],
'แมนเดล'=>['th',],
'แรมโบ'=>['th',],
'แลว'=>['th',],
'แลวก'=>['th',],
'แลวละ'=>['th',],
'แลวเราจะทำอะไรตอไป'=>['th',],
'แลวไง'=>['th',],
'และ'=>['th',],
'และสอง'=>['th',],
'และสาม'=>['th',],
'แวน'=>['th',],
'แวนโค'=>['th',],
'แหม'=>['th',],
'แหวะ'=>['th',],
'แฮคแมน'=>['th',],
'โ'=>['th',],
'โกหก'=>['th',],
'โจแฮนนา'=>['th',],
'โชคชะตา'=>['th',],
'โซน'=>['th',],
'โซแลนโด'=>['th',],
'โดดเลย'=>['th',],
'โดย'=>['th',],
'โดโลเรส'=>['th',],
'โถ'=>['th',],
'โทรหา'=>['th',],
'โทรหาเธอซะ'=>['th',],
'โทษนะ'=>['th',],
'โทษนะคะ'=>['th',],
'โธเอย'=>['th',],
'โบนส'=>['th',],
'โปรดทราบ'=>['th',],
'โม'=>['th',],
'โมง'=>['th',],
'โมงเชา'=>['th',],
'โมโจ'=>['th',],
'โมโตยามา'=>['th',],
'โย'=>['th',],
'โรบอล'=>['th',],
'โรเวอร'=>['th',],
'โลก'=>['th',],
'โว'=>['th',],
'โอ'=>['th',],
'โอซาวา'=>['th',],
'โอพระเจา'=>['th',],
'โอย'=>['th',],
'โอว'=>['th',],
'โอเค'=>['th',],
'โอเคนะ'=>['th',],
'โอเคๆ'=>['th',],
'โอเช'=>['th',],
'โอโตยะ'=>['th',],
'โฮ'=>['th',],
'ใคร'=>['th',],
'ใครวะ'=>['th',],
'ใครเหรอ'=>['th',],
'ใครโทรมา'=>['th',],
'ใครๆ'=>['th',],
'ใจเยน'=>['th',],
'ใจเยนๆ'=>['th',],
'ใช'=>['th',],
'ใชแลว'=>['th',],
'ใชไหม'=>['th',],
'ใชๆ'=>['th',],
'ใน'=>['th',],
'ในเขต'=>['th',],
'ใบ'=>['th',],
'ใแ'=>['th',],
'ไ'=>['th',],
'ไง'=>['th',],
'ไงนะ'=>['th',],
'ไชโย'=>['th',],
'ไซมอน'=>['th',],
'ไซโกะ'=>['th',],
'ได'=>['th',],
'ไดคะ'=>['th',],
'ไดเลย'=>['th',],
'ไดโปรด'=>['th',],
'ไดโปรดเถอะ'=>['th',],
'ไต'=>['th',],
'ไบรอน'=>['th',],
'ไป'=>['th',],
'ไปซะ'=>['th',],
'ไปตายซะ'=>['th',],
'ไปเถอะ'=>['th',],
'ไปเรว'=>['th',],
'ไปเลย'=>['th',],
'ไปไกลๆ'=>['th',],
'ไปไดแลว'=>['th',],
'ไปไหน'=>['th',],
'ไปๆๆๆ'=>['th',],
'ไพค'=>['th',],
'ไม'=>['th',],
'ไมคะ'=>['th',],
'ไมชนะกแพ'=>['th',],
'ไมตองหวง'=>['th',],
'ไมนะ'=>['th',],
'ไมล'=>['th',],
'ไมหรอก'=>['th',],
'ไมเปนไร'=>['th',],
'ไมเปนไรนะ'=>['th',],
'ไมเอานา'=>['th',],
'ไมใช'=>['th',],
'ไมๆ'=>['th',],
'ไหน'=>['th',],
'ไหม'=>['th',],
'ไหว'=>['th',],
'ไอบา'=>['th',],
'ไอบาเอย'=>['th',],
'ไอสารเลว'=>['th',],
'ไอแวน'=>['th',],
'ไฮ'=>['th',],
'ไฮโดรเจน'=>['th',],
'ไๅ'=>['th',],
'ๅ'=>['th',],
'ๆ'=>['th',],
'აგება'=>['ka',],
'აგრეთვე'=>['ka',],
'ადამიანი'=>['ka',],
'ადასტურებს'=>['ka',],
'ადგენს'=>['ka',],
'ადგილი'=>['ka',],
'ადგილობრივი'=>['ka',],
'ადგილსამყოფელი'=>['ka',],
'ადრე'=>['ka',],
'აზრი'=>['ka',],
'აკეთებს'=>['ka',],
'აკრძალვა'=>['ka',],
'ალბათ'=>['ka',],
'ამ'=>['ka',],
'ამავე'=>['ka',],
'ამბობს'=>['ka',],
'ამგვარი'=>['ka',],
'ამდენი'=>['ka',],
'ამომრჩეველი'=>['ka',],
'ამოქმედება'=>['ka',],
'ამოღება'=>['ka',],
'ამოცანა'=>['ka',],
'ამჟამად'=>['ka',],
'ამტკიცებს'=>['ka',],
'ან'=>['ka',],
'ანაზღაურება'=>['ka',],
'ანგარიში'=>['ka',],
'ანდა'=>['ka',],
'ანდერძი'=>['ka',],
'ანუ'=>['ka',],
'აპირებს'=>['ka',],
'არ'=>['ka',],
'არა'=>['ka',],
'არავინ'=>['ka',],
'არავის'=>['ka',],
'არამედ'=>['ka',],
'არანაკლები'=>['ka',],
'არასახელმწიფო'=>['ka',],
'არასახელშეკრულებო'=>['ka',],
'არასრულწლოვანი'=>['ka',],
'არასწორი'=>['ka',],
'არაფერი'=>['ka',],
'არეალი'=>['ka',],
'არიან'=>['ka',],
'არის'=>['ka',],
'არმქონე'=>['ka',],
'არსებითი'=>['ka',],
'არსებობა'=>['ka',],
'არსებული'=>['ka',],
'არჩევა'=>['ka',],
'არჩევნები'=>['ka',],
'არჩეული'=>['ka',],
'არცერთი'=>['ka',],
'ასაკი'=>['ka',],
'ასახვა'=>['ka',],
'ასე'=>['ka',],
'ასლი'=>['ka',],
'ასრულებს'=>['ka',],
'ატარებს'=>['ka',],
'ატაროს'=>['ka',],
'აუნაზღაურებს'=>['ka',],
'აუცილებლობა'=>['ka',],
'აქ'=>['ka',],
'აქედან'=>['ka',],
'აქვს'=>['ka',],
'აღარ'=>['ka',],
'აღდგენა'=>['ka',],
'აღება'=>['ka',],
'აღემატება'=>['ka',],
'აღზრდა'=>['ka',],
'აღიარება'=>['ka',],
'აღკვეთა'=>['ka',],
'აღმასრულებელი'=>['ka',],
'აღმოფხვრა'=>['ka',],
'აღმოჩენა'=>['ka',],
'აღნიშვნა'=>['ka',],
'აღრიცხვა'=>['ka',],
'აღსრულება'=>['ka',],
'აღძვრა'=>['ka',],
'აღწერა'=>['ka',],
'აყვანა'=>['ka',],
'აშკარა'=>['ka',],
'აცილება'=>['ka',],
'აცნობა'=>['ka',],
'აცხადებს'=>['ka',],
'აძლევს'=>['ka',],
'აწარმოებს'=>['ka',],
'აწერს'=>['ka',],
'ახალგაზრდა'=>['ka',],
'ახალი'=>['ka',],
'ახდენს'=>['ka',],
'ახლა'=>['ka',],
'ახორციელებს'=>['ka',],
'ბავშვი'=>['ka',],
'ბათილი'=>['ka',],
'ბარათი'=>['ka',],
'ბატონი'=>['ka',],
'ბევრი'=>['ka',],
'ბიბლიოთეკა'=>['ka',],
'ბინა'=>['ka',],
'ბოლო'=>['ka',],
'ბრალდება'=>['ka',],
'ბრალი'=>['ka',],
'ბრძანება'=>['ka',],
'ბრძანებულება'=>['ka',],
'ბრძოლა'=>['ka',],
'ბუნებრივი'=>['ka',],
'გაანგარიშება'=>['ka',],
'გააჩნია'=>['ka',],
'გაგება'=>['ka',],
'გაგზავნა'=>['ka',],
'გაგრძელება'=>['ka',],
'გადადება'=>['ka',],
'გადაზიდვა'=>['ka',],
'გადამზადება'=>['ka',],
'გადამხდელი'=>['ka',],
'გადარჩენა'=>['ka',],
'გადასახადი'=>['ka',],
'გადასახდელი'=>['ka',],
'გადასვლა'=>['ka',],
'გადატანა'=>['ka',],
'გადაყენება'=>['ka',],
'გადაყვანა'=>['ka',],
'გადაშენება'=>['ka',],
'გადაცემა'=>['ka',],
'გადაცილება'=>['ka',],
'გადაწყვეტა'=>['ka',],
'გადაწყვეტილება'=>['ka',],
'გადახდა'=>['ka',],
'გაერთიანება'=>['ka',],
'გავლა'=>['ka',],
'გავლენა'=>['ka',],
'გავრცელება'=>['ka',],
'გაზი'=>['ka',],
'გაზრდა'=>['ka',],
'გათავისუფლება'=>['ka',],
'გათვალისწინება'=>['ka',],
'გაკეთება'=>['ka',],
'გამართვა'=>['ka',],
'გამარჯვება'=>['ka',],
'გამგებელი'=>['ka',],
'გამოანგარიშება'=>['ka',],
'გამოვლენა'=>['ka',],
'გამოთვლა'=>['ka',],
'გამოთქმა'=>['ka',],
'გამომდინარე'=>['ka',],
'გამორიცხვა'=>['ka',],
'გამოსვლა'=>['ka',],
'გამოტანა'=>['ka',],
'გამოქვეყნება'=>['ka',],
'გამოქვითვა'=>['ka',],
'გამოყენება'=>['ka',],
'გამოყოფა'=>['ka',],
'გამოცდა'=>['ka',],
'გამოცემა'=>['ka',],
'გამოცხადება'=>['ka',],
'გამოწვევა'=>['ka',],
'გამოხატვა'=>['ka',],
'გამრავლება'=>['ka',],
'განათლება'=>['ka',],
'განვითარება'=>['ka',],
'განზრახვა'=>['ka',],
'განთავისუფლება'=>['ka',],
'განთავსება'=>['ka',],
'განკარგვა'=>['ka',],
'განკარგულება'=>['ka',],
'განკუთვნება'=>['ka',],
'განლაგება'=>['ka',],
'განმავლობა'=>['ka',],
'განმარტება'=>['ka',],
'განმეორება'=>['ka',],
'განსაზღვრა'=>['ka',],
'განსაზღვრება'=>['ka',],
'განსაკუთრება'=>['ka',],
'განსხვავება'=>['ka',],
'განუცხადა'=>['ka',],
'განქორწინება'=>['ka',],
'განცხადება'=>['ka',],
'განხილვა'=>['ka',],
'განხორციელება'=>['ka',],
'გარდა'=>['ka',],
'გარდამავალი'=>['ka',],
'გარდაცვალება'=>['ka',],
'გარევა'=>['ka',],
'გარეთ'=>['ka',],
'გარემო'=>['ka',],
'გარემოება'=>['ka',],
'გარეშე'=>['ka',],
'გარიგება'=>['ka',],
'გარკვევა'=>['ka',],
'გასაჩივრება'=>['ka',],
'გასვლა'=>['ka',],
'გასხვისება'=>['ka',],
'გატარება'=>['ka',],
'გაუმჯობესება'=>['ka',],
'გაუქმება'=>['ka',],
'გაფორმება'=>['ka',],
'გაფრთხილება'=>['ka',],
'გაფრქვევა'=>['ka',],
'გაყვანა'=>['ka',],
'გაყიდვა'=>['ka',],
'გაყოფა'=>['ka',],
'გაცემა'=>['ka',],
'გაცნობა'=>['ka',],
'გაწევა'=>['ka',],
'გაწეული'=>['ka',],
'გახდა'=>['ka',],
'გახსნა'=>['ka',],
'გეგმა'=>['ka',],
'გვარი'=>['ka',],
'გზა'=>['ka',],
'გირავნობა'=>['ka',],
'გრძელი'=>['ka',],
'გულისხმობა'=>['ka',],
'გუნდი'=>['ka',],
'და'=>['ka',],
'დაახლოება'=>['ka',],
'დაბადება'=>['ka',],
'დაბეგვრა'=>['ka',],
'დაბინძურება'=>['ka',],
'დაბრუნება'=>['ka',],
'დაგეგმვა'=>['ka',],
'დადასტურება'=>['ka',],
'დადგენა'=>['ka',],
'დადგენილება'=>['ka',],
'დადება'=>['ka',],
'დადებითი'=>['ka',],
'დავა'=>['ka',],
'დავალება'=>['ka',],
'დაზარალება'=>['ka',],
'დაზიანება'=>['ka',],
'დაზღვევა'=>['ka',],
'დათვალიერება'=>['ka',],
'დათმობა'=>['ka',],
'დაინტერესება'=>['ka',],
'დაკავება'=>['ka',],
'დაკავშირება'=>['ka',],
'დაკარგვა'=>['ka',],
'დაკვირვება'=>['ka',],
'დაკისრება'=>['ka',],
'დაკმაყოფილება'=>['ka',],
'დამატება'=>['ka',],
'დამზადება'=>['ka',],
'დამთავრება'=>['ka',],
'დამოკიდებულება'=>['ka',],
'დამოუკიდებლობა'=>['ka',],
'დამოწმება'=>['ka',],
'დამსახურება'=>['ka',],
'დამტკიცება'=>['ka',],
'დანაშაული'=>['ka',],
'დანიშვნა'=>['ka',],
'დანიშნულება'=>['ka',],
'დაპირება'=>['ka',],
'დართვა'=>['ka',],
'დარიცხვა'=>['ka',],
'დარღვევა'=>['ka',],
'დარჩენა'=>['ka',],
'დარწმუნება'=>['ka',],
'დასაბუთება'=>['ka',],
'დასაქმება'=>['ka',],
'დასახელება'=>['ka',],
'დასკვნა'=>['ka',],
'დასმა'=>['ka',],
'დასრულება'=>['ka',],
'დატვირთვა'=>['ka',],
'დატოვება'=>['ka',],
'დაფარვა'=>['ka',],
'დაფინასება'=>['ka',],
'დაფუძნება'=>['ka',],
'დაქვემდებარება'=>['ka',],
'დაქირავება'=>['ka',],
'დაქორწინება'=>['ka',],
'დაღუპვა'=>['ka',],
'დაყოვნება'=>['ka',],
'დაშვება'=>['ka',],
'დაცვა'=>['ka',],
'დაწესება'=>['ka',],
'დაწესებულება'=>['ka',],
'დაწყება'=>['ka',],
'დაჭერა'=>['ka',],
'დახმარება'=>['ka',],
'დგომა'=>['ka',],
'დებულება'=>['ka',],
'დევნა'=>['ka',],
'დევნილი'=>['ka',],
'დიდი'=>['ka',],
'დონე'=>['ka',],
'დრო'=>['ka',],
'დღე'=>['ka',],
'ეკისრება'=>['ka',],
'ეკუთვნის'=>['ka',],
'ემიგრაცია'=>['ka',],
'ენა'=>['ka',],
'ერთ'=>['ka',],
'ერთად'=>['ka',],
'ერთეული'=>['ka',],
'ერთი'=>['ka',],
'ერთიანი'=>['ka',],
'ერთმანეთი'=>['ka',],
'ერთობლივი'=>['ka',],
'ერთხელ'=>['ka',],
'ერი'=>['ka',],
'ეროვნული'=>['ka',],
'ეს'=>['ka',],
'ეუთო'=>['ka',],
'ექვემდებარება'=>['ka',],
'ექნება'=>['ka',],
'ეძლევა'=>['ka',],
'ეწევა'=>['ka',],
'ეწინააღმდეგება'=>['ka',],
'ეჭვი'=>['ka',],
'ეხება'=>['ka',],
'ვადა'=>['ka',],
'ვალდებულება'=>['ka',],
'ვალდებული'=>['ka',],
'ვალი'=>['ka',],
'ვარ'=>['ka',],
'ვართ'=>['ka',],
'ვაჭრობა'=>['ka',],
'ველი'=>['ka',],
'ვერა'=>['ka',],
'ვთქვათ'=>['ka',],
'ვიდრე'=>['ka',],
'ვითარება'=>['ka',],
'ვინ'=>['ka',],
'ვინაობა'=>['ka',],
'ვის'=>['ka',],
'ვრცელდება'=>['ka',],
'ვფიქრობ'=>['ka',],
'ზედამხედველობა'=>['ka',],
'ზედაპირული'=>['ka',],
'ზედმეტი'=>['ka',],
'ზედნადები'=>['ka',],
'ზემოქმედება'=>['ka',],
'ზეწოლა'=>['ka',],
'ზიანი'=>['ka',],
'ზოგადი'=>['ka',],
'ზოგი'=>['ka',],
'ზოგიერთი'=>['ka',],
'ზომა'=>['ka',],
'ზონა'=>['ka',],
'ზრდა'=>['ka',],
'ზუსტი'=>['ka',],
'ზღვა'=>['ka',],
'ზღვრული'=>['ka',],
'თავად'=>['ka',],
'თავდაცვა'=>['ka',],
'თავდები'=>['ka',],
'თავი'=>['ka',],
'თავიდან'=>['ka',],
'თავის'=>['ka',],
'თავისი'=>['ka',],
'თავისუფლება'=>['ka',],
'თავმჯდომარე'=>['ka',],
'თამაში'=>['ka',],
'თან'=>['ka',],
'თანაბარი'=>['ka',],
'თანამდებობა'=>['ka',],
'თანამეგობრობა'=>['ka',],
'თანამშრომელი'=>['ka',],
'თანამშრომლობა'=>['ka',],
'თანახმა'=>['ka',],
'თანხა'=>['ka',],
'თანხმობა'=>['ka',],
'თაობა'=>['ka',],
'თარიღი'=>['ka',],
'თბილისი'=>['ka',],
'თემა'=>['ka',],
'თვალსაზრისი'=>['ka',],
'თვე'=>['ka',],
'თვით'=>['ka',],
'თვითმმართველობა'=>['ka',],
'თვითონ'=>['ka',],
'თითოეული'=>['ka',],
'თითქმის'=>['ka',],
'თუ'=>['ka',],
'თუკი'=>['ka',],
'თუმცა'=>['ka',],
'თქვენ'=>['ka',],
'თქმა'=>['ka',],
'თხოვნა'=>['ka',],
'იარაღი'=>['ka',],
'იგი'=>['ka',],
'იგივე'=>['ka',],
'ითვალისწინებს'=>['ka',],
'ითვლება'=>['ka',],
'ითქვა'=>['ka',],
'ითხოვს'=>['ka',],
'იმ'=>['ka',],
'იმავე'=>['ka',],
'იმაზე'=>['ka',],
'იმან'=>['ka',],
'იმას'=>['ka',],
'იმედი'=>['ka',],
'იმით'=>['ka',],
'იმის'=>['ka',],
'იმიტომ'=>['ka',],
'იმყოფება'=>['ka',],
'ირჩევა'=>['ka',],
'ის'=>['ka',],
'ისარგებლა'=>['ka',],
'ისე'=>['ka',],
'ისეთი'=>['ka',],
'ისიც'=>['ka',],
'იტყვის'=>['ka',],
'იქ'=>['ka',],
'იქმნება'=>['ka',],
'იქნა'=>['ka',],
'იქნება'=>['ka',],
'იქცა'=>['ka',],
'იღებს'=>['ka',],
'იყო'=>['ka',],
'იცი'=>['ka',],
'იცის'=>['ka',],
'იძულება'=>['ka',],
'იწვევს'=>['ka',],
'იწყებს'=>['ka',],
'იხდის'=>['ka',],
'იჯარა'=>['ka',],
'კავშირი'=>['ka',],
'კანონი'=>['ka',],
'კანონიერი'=>['ka',],
'კანონმდებლობა'=>['ka',],
'კანონპროექტი'=>['ka',],
'კანონქვემდებარე'=>['ka',],
'კარგი'=>['ka',],
'კარი'=>['ka',],
'კაცი'=>['ka',],
'კეთილსინდისიერი'=>['ka',],
'კენჭისყრა'=>['ka',],
'კერძო'=>['ka',],
'კერძოდ'=>['ka',],
'კვირა'=>['ka',],
'კვლავ'=>['ka',],
'კვლევა'=>['ka',],
'კვლევითი'=>['ka',],
'კი'=>['ka',],
'კიდევ'=>['ka',],
'კითხვა'=>['ka',],
'კრება'=>['ka',],
'კუთვნილი'=>['ka',],
'ლარი'=>['ka',],
'მაგალითი'=>['ka',],
'მაგრამ'=>['ka',],
'მავნე'=>['ka',],
'მათი'=>['ka',],
'მაინც'=>['ka',],
'მამკვიდრებელი'=>['ka',],
'მან'=>['ka',],
'მანამ'=>['ka',],
'მანძილი'=>['ka',],
'მართალი'=>['ka',],
'მართვა'=>['ka',],
'მართლა'=>['ka',],
'მარტო'=>['ka',],
'მარჩენალი'=>['ka',],
'მას'=>['ka',],
'მასალა'=>['ka',],
'მასობრივი'=>['ka',],
'მასწავლებელი'=>['ka',],
'მაღალი'=>['ka',],
'მაშინ'=>['ka',],
'მაჩვენებელი'=>['ka',],
'მდგომარეობა'=>['ka',],
'მდგრადი'=>['ka',],
'მდებარე'=>['ka',],
'მდივანი'=>['ka',],
'მე'=>['ka',],
'მეზობელი'=>['ka',],
'მეთაური'=>['ka',],
'მემკვიდრე'=>['ka',],
'მემკვიდრეობა'=>['ka',],
'მეორე'=>['ka',],
'მერი'=>['ka',],
'მესაკუთრე'=>['ka',],
'მეტი'=>['ka',],
'მეურვე'=>['ka',],
'მეურვეობა'=>['ka',],
'მეურნეობა'=>['ka',],
'მეუღლე'=>['ka',],
'მეშვეობით'=>['ka',],
'მეცნიერება'=>['ka',],
'მეცნიერი'=>['ka',],
'მზა'=>['ka',],
'მზრუნველობა'=>['ka',],
'მზღვეველი'=>['ka',],
'მთავარი'=>['ka',],
'მთავრობა'=>['ka',],
'მთელი'=>['ka',],
'მთლიანი'=>['ka',],
'მიაჩნია'=>['ka',],
'მიეკუთვნება'=>['ka',],
'მიერ'=>['ka',],
'მიეცა'=>['ka',],
'მიზანი'=>['ka',],
'მიზეზი'=>['ka',],
'მითითება'=>['ka',],
'მიიჩნევა'=>['ka',],
'მიკუთვნება'=>['ka',],
'მიმართ'=>['ka',],
'მიმართვა'=>['ka',],
'მიმართულება'=>['ka',],
'მიმდინარეობა'=>['ka',],
'მიმღები'=>['ka',],
'მინდა'=>['ka',],
'მინიჭება'=>['ka',],
'მის'=>['ka',],
'მისამართი'=>['ka',],
'მისაღები'=>['ka',],
'მისი'=>['ka',],
'მისცა'=>['ka',],
'მიუთითა'=>['ka',],
'მიუღებელი'=>['ka',],
'მიღება'=>['ka',],
'მიღწევა'=>['ka',],
'მიყენება'=>['ka',],
'მიცემა'=>['ka',],
'მიწა'=>['ka',],
'მიწისქვეშა'=>['ka',],
'მიწოდება'=>['ka',],
'მიხედვით'=>['ka',],
'მკითხველი'=>['ka',],
'მმართველი'=>['ka',],
'მნიშვენელობა'=>['ka',],
'მოადგილე'=>['ka',],
'მოანდერძე'=>['ka',],
'მოახდინა'=>['ka',],
'მოგება'=>['ka',],
'მოგვარება'=>['ka',],
'მოგზაურობა'=>['ka',],
'მოვალე'=>['ka',],
'მოვალეობა'=>['ka',],
'მოვლენა'=>['ka',],
'მოთხოვნა'=>['ka',],
'მოითხოვა'=>['ka',],
'მოიცავს'=>['ka',],
'მოიჯარე'=>['ka',],
'მომავალი'=>['ka',],
'მომდევნო'=>['ka',],
'მომზადება'=>['ka',],
'მომსახურება'=>['ka',],
'მომხდარი'=>['ka',],
'მონაკვეთი'=>['ka',],
'მონაცემი'=>['ka',],
'მონაწილე'=>['ka',],
'მოპოვება'=>['ka',],
'მოსალოდნელი'=>['ka',],
'მოსამართლე'=>['ka',],
'მოსარგებლე'=>['ka',],
'მოსახლეობა'=>['ka',],
'მოსთხოვა'=>['ka',],
'მოსწავლე'=>['ka',],
'მოქალაქე'=>['ka',],
'მოქმედება'=>['ka',],
'მოშლა'=>['ka',],
'მოცემული'=>['ka',],
'მოძრავი'=>['ka',],
'მოძრაობა'=>['ka',],
'მოწვევა'=>['ka',],
'მოწმობა'=>['ka',],
'მოწყობა'=>['ka',],
'მოწყობილობა'=>['ka',],
'მოხდა'=>['ka',],
'მოხელე'=>['ka',],
'მოჰყვა'=>['ka',],
'მსგავსი'=>['ka',],
'მსოფლიო'=>['ka',],
'მტკიცება'=>['ka',],
'მუდმივი'=>['ka',],
'მუშაკი'=>['ka',],
'მუშაობა'=>['ka',],
'მუხლი'=>['ka',],
'მფლობელი'=>['ka',],
'მქონე'=>['ka',],
'მყიდველი'=>['ka',],
'მყოფი'=>['ka',],
'მშენებლობა'=>['ka',],
'მშვილებელი'=>['ka',],
'მშობელი'=>['ka',],
'მცენარე'=>['ka',],
'მცირე'=>['ka',],
'მცხოვრები'=>['ka',],
'მძიმე'=>['ka',],
'მხარდაჭერა'=>['ka',],
'მხარე'=>['ka',],
'მხარი'=>['ka',],
'მხოლოდ'=>['ka',],
'მხრივ'=>['ka',],
'ნაბიჯი'=>['ka',],
'ნაგებობა'=>['ka',],
'ნავთობი'=>['ka',],
'ნათესავი'=>['ka',],
'ნაკვეთი'=>['ka',],
'ნაკლები'=>['ka',],
'ნაკლი'=>['ka',],
'ნამდვილი'=>['ka',],
'ნაცვლად'=>['ka',],
'ნაწარმოები'=>['ka',],
'ნაწილი'=>['ka',],
'ნახევარი'=>['ka',],
'ნება'=>['ka',],
'ნებაყოფლობით'=>['ka',],
'ნებისმიერი'=>['ka',],
'ნივთი'=>['ka',],
'ნივთიერება'=>['ka',],
'ნიშანი'=>['ka',],
'ნიშნავს'=>['ka',],
'ნუსხა'=>['ka',],
'ოდენობა'=>['ka',],
'ოლქი'=>['ka',],
'ომი'=>['ka',],
'ოპიზა'=>['ka',],
'ორგანიზაცია'=>['ka',],
'ორგანო'=>['ka',],
'ორგანული'=>['ka',],
'ორი'=>['ka',],
'ოქმი'=>['ka',],
'ოჯახი'=>['ka',],
'პასუხი'=>['ka',],
'პასუხისმგებელი'=>['ka',],
'პასუხისმგებლობა'=>['ka',],
'პატიმარი'=>['ka',],
'პირადი'=>['ka',],
'პირადობის'=>['ka',],
'პირდაპირი'=>['ka',],
'პირველი'=>['ka',],
'პირი'=>['ka',],
'პირობა'=>['ka',],
'პიროვნება'=>['ka',],
'რა'=>['ka',],
'რად'=>['ka',],
'რათა'=>['ka',],
'რაიმე'=>['ka',],
'რამაც'=>['ka',],
'რამდენი'=>['ka',],
'რამე'=>['ka',],
'რაოდენობა'=>['ka',],
'რას'=>['ka',],
'რატომ'=>['ka',],
'რაღაც'=>['ka',],
'რაც'=>['ka',],
'რიგი'=>['ka',],
'რისი'=>['ka',],
'რიცხვი'=>['ka',],
'როგორ'=>['ka',],
'რომ'=>['ka',],
'რომელი'=>['ka',],
'რომც'=>['ka',],
'როცა'=>['ka',],
'რუსული'=>['ka',],
'რჩება'=>['ka',],
'რწმუნებული'=>['ka',],
'სаგარეო'=>['ka',],
'საათი'=>['ka',],
'საანგარიშო'=>['ka',],
'საანდერძო'=>['ka',],
'საახალწლო'=>['ka',],
'საბაზრო'=>['ka',],
'საბაჟო'=>['ka',],
'საბინადრო'=>['ka',],
'საბოლოო'=>['ka',],
'საბუთი'=>['ka',],
'საბჭო'=>['ka',],
'საგადასახადო'=>['ka',],
'საგანი'=>['ka',],
'საგანმანათლებლო'=>['ka',],
'სად'=>['ka',],
'სადაზღვევო'=>['ka',],
'საერთაშორისო'=>['ka',],
'საერთო'=>['ka',],
'სავარაუდო'=>['ka',],
'სავაჭრო'=>['ka',],
'საზოგადოება'=>['ka',],
'საზოგადოებრივი'=>['ka',],
'საზღაური'=>['ka',],
'საზღვარგარეთი'=>['ka',],
'საზღვარი'=>['ka',],
'სათანადო'=>['ka',],
'საკანონმდებლო'=>['ka',],
'საკითხი'=>['ka',],
'საკმაო'=>['ka',],
'საკმარისი'=>['ka',],
'საკონტროლო'=>['ka',],
'საკრებულო'=>['ka',],
'საკუთარი'=>['ka',],
'საკუთრება'=>['ka',],
'სამართალდამცველი'=>['ka',],
'სამართალდარღვევა'=>['ka',],
'სამართალი'=>['ka',],
'სამართლებრივი'=>['ka',],
'სამედიცინო'=>['ka',],
'სამეურნეო'=>['ka',],
'სამეცნიერო'=>['ka',],
'სამეწარმეო'=>['ka',],
'სამკვიდრო'=>['ka',],
'სამონადირეო'=>['ka',],
'სამოქალაქო'=>['ka',],
'სამსახურეობრივი'=>['ka',],
'სამსახური'=>['ka',],
'სამუშაო'=>['ka',],
'სამყარო'=>['ka',],
'სამშვიდობო'=>['ka',],
'სამწუხარო'=>['ka',],
'სამხედრო'=>['ka',],
'სამხრეთი'=>['ka',],
'საოლქო'=>['ka',],
'სარგებელი'=>['ka',],
'სარგებლობა'=>['ka',],
'სარჩელი'=>['ka',],
'სარჩო'=>['ka',],
'სასამართლო'=>['ka',],
'სასარგებლო'=>['ka',],
'სასაქონლო'=>['ka',],
'სასმელი'=>['ka',],
'სასოფლო'=>['ka',],
'სასწავლებელი'=>['ka',],
'სასწავლო'=>['ka',],
'სასჯელაღსრულებითი'=>['ka',],
'საუბარი'=>['ka',],
'საუკეთესო'=>['ka',],
'საფასური'=>['ka',],
'საფრთხე'=>['ka',],
'საფუძველი'=>['ka',],
'საქმე'=>['ka',],
'საქმიანობა'=>['ka',],
'საქონელ'=>['ka',],
'საქონელი'=>['ka',],
'საქონლის'=>['ka',],
'საშუალება'=>['ka',],
'საშუალო'=>['ka',],
'საჩივარი'=>['ka',],
'საწარმო'=>['ka',],
'საწინააღმეგო'=>['ka',],
'საჭირო'=>['ka',],
'საჭიროება'=>['ka',],
'სახალხო'=>['ka',],
'სახე'=>['ka',],
'სახელი'=>['ka',],
'სახელმწიფო'=>['ka',],
'სახელობის'=>['ka',],
'სახელწოდება'=>['ka',],
'სახეობა'=>['ka',],
'სახლი'=>['ka',],
'სახსრები'=>['ka',],
'საჯარო'=>['ka',],
'საჯაროდ'=>['ka',],
'სესხი'=>['ka',],
'სიკვდილი'=>['ka',],
'სისტემა'=>['ka',],
'სისხლი'=>['ka',],
'სიტყვა'=>['ka',],
'სიცოცხლე'=>['ka',],
'სკოლა'=>['ka',],
'სოფელი'=>['ka',],
'სოციალური'=>['ka',],
'სრული'=>['ka',],
'სუბიექტი'=>['ka',],
'სულ'=>['ka',],
'სურვილი'=>['ka',],
'სწავლა'=>['ka',],
'სწავლება'=>['ka',],
'სწორი'=>['ka',],
'სჭირდება'=>['ka',],
'სხდომა'=>['ka',],
'სხვა'=>['ka',],
'ტარდება'=>['ka',],
'ტერიტორია'=>['ka',],
'ტვირთი'=>['ka',],
'ტყე'=>['ka',],
'უარი'=>['ka',],
'უარყოფა'=>['ka',],
'უბანი'=>['ka',],
'უგვიანესი'=>['ka',],
'უზენაესი'=>['ka',],
'უზრუნველყოფა'=>['ka',],
'უკან'=>['ka',],
'უკანასკნელი'=>['ka',],
'უკანონო'=>['ka',],
'უკვე'=>['ka',],
'უმაღლესი'=>['ka',],
'უმეტესი'=>['ka',],
'უმრავლესობა'=>['ka',],
'უნდა'=>['ka',],
'ურთიერთობა'=>['ka',],
'უსაფრთხოება'=>['ka',],
'უფლება'=>['ka',],
'უფრო'=>['ka',],
'უფროსი'=>['ka',],
'უშიშროება'=>['ka',],
'უშუალოდ'=>['ka',],
'უცხო'=>['ka',],
'უცხოეთი'=>['ka',],
'უცხოელი'=>['ka',],
'უცხოური'=>['ka',],
'უძრავი'=>['ka',],
'უწყება'=>['ka',],
'უხეში'=>['ka',],
'ფარგლები'=>['ka',],
'ფასი'=>['ka',],
'ფიქრი'=>['ka',],
'ფიქრობს'=>['ka',],
'ფლობა'=>['ka',],
'ფული'=>['ka',],
'ფუნქცია'=>['ka',],
'ქალაქი'=>['ka',],
'ქალი'=>['ka',],
'ქაღალდი'=>['ka',],
'ქვეპუნქტი'=>['ka',],
'ქვეყანა'=>['ka',],
'ქირავნობა'=>['ka',],
'ქმედება'=>['ka',],
'ქმედითუნარიანი'=>['ka',],
'ქმედითუუნარო'=>['ka',],
'ქმნის'=>['ka',],
'ქონება'=>['ka',],
'ქონებრივი'=>['ka',],
'ქორწინება'=>['ka',],
'ქულა'=>['ka',],
'ქურდი'=>['ka',],
'ქურდული'=>['ka',],
'ქუჩა'=>['ka',],
'ღია'=>['ka',],
'ღირებულება'=>['ka',],
'ღირსება'=>['ka',],
'ღონისძიება'=>['ka',],
'ყადაღა'=>['ka',],
'ყველა'=>['ka',],
'ყველაფერი'=>['ka',],
'ყოველგვარი'=>['ka',],
'ყოველი'=>['ka',],
'ყოველწლიური'=>['ka',],
'ყოფნა'=>['ka',],
'ყუთი'=>['ka',],
'ყურადსაღები'=>['ka',],
'ყურადღება'=>['ka',],
'ყურება'=>['ka',],
'ყური'=>['ka',],
'შედარება'=>['ka',],
'შედგა'=>['ka',],
'შედგენა'=>['ka',],
'შედეგი'=>['ka',],
'შედის'=>['ka',],
'შევსება'=>['ka',],
'შეზღუდვა'=>['ka',],
'შეთანხმება'=>['ka',],
'შეიარაღებული'=>['ka',],
'შეიცავს'=>['ka',],
'შეიძლება'=>['ka',],
'შემადგენელი'=>['ka',],
'შემდგომი'=>['ka',],
'შემდეგ'=>['ka',],
'შემთხვევა'=>['ka',],
'შემკვეთი'=>['ka',],
'შემნახველი'=>['ka',],
'შემოსავალი'=>['ka',],
'შემოსული'=>['ka',],
'შემოღება'=>['ka',],
'შემოწმება'=>['ka',],
'შემსრულებელი'=>['ka',],
'შემუშავება'=>['ka',],
'შემცირება'=>['ka',],
'შენ'=>['ka',],
'შენარჩუნება'=>['ka',],
'შენატანი'=>['ka',],
'შენახვა'=>['ka',],
'შენობა'=>['ka',],
'შესაბამისი'=>['ka',],
'შესაბამისობა'=>['ka',],
'შესაგებელი'=>['ka',],
'შესასრულებელი'=>['ka',],
'შესატანი'=>['ka',],
'შესაძლებლობა'=>['ka',],
'შესაძლო'=>['ka',],
'შესახებ'=>['ka',],
'შესვლა'=>['ka',],
'შესრულება'=>['ka',],
'შესყიდვა'=>['ka',],
'შეტანა'=>['ka',],
'შეტყობინება'=>['ka',],
'შეუსრულებლობა'=>['ka',],
'შეუძლებელი'=>['ka',],
'შეფასება'=>['ka',],
'შექმნა'=>['ka',],
'შეღავათი'=>['ka',],
'შეჩერება'=>['ka',],
'შეცდომა'=>['ka',],
'შეცვლა'=>['ka',],
'შეძენა'=>['ka',],
'შეძლება'=>['ka',],
'შეწყვეტა'=>['ka',],
'შეწყობა'=>['ka',],
'შეხება'=>['ka',],
'შეხვედრა'=>['ka',],
'შვილი'=>['ka',],
'შიდა'=>['ka',],
'შინაარსი'=>['ka',],
'შინაგანი'=>['ka',],
'შორის'=>['ka',],
'შრომა'=>['ka',],
'შუამდგომლობა'=>['ka',],
'ჩაბარება'=>['ka',],
'ჩადება'=>['ka',],
'ჩათვლა'=>['ka',],
'ჩამონათვალი'=>['ka',],
'ჩამორთმევა'=>['ka',],
'ჩამოსვლა'=>['ka',],
'ჩამოყალიბება'=>['ka',],
'ჩანაწერი'=>['ka',],
'ჩანს'=>['ka',],
'ჩართვა'=>['ka',],
'ჩარიცხვა'=>['ka',],
'ჩატარება'=>['ka',],
'ჩაწერა'=>['ka',],
'ჩემი'=>['ka',],
'ჩვენ'=>['ka',],
'ჩვეული'=>['ka',],
'ჩრდილოეთი'=>['ka',],
'ცალკე'=>['ka',],
'ცდილობს'=>['ka',],
'ცვლა'=>['ka',],
'ციხე'=>['ka',],
'ცნება'=>['ka',],
'ცნობა'=>['ka',],
'ცნობილი'=>['ka',],
'ცოტა'=>['ka',],
'ცოცხალი'=>['ka',],
'ცუდი'=>['ka',],
'ცხოველი'=>['ka',],
'ცხოვრება'=>['ka',],
'ძალა'=>['ka',],
'ძალადაკარგული'=>['ka',],
'ძალიან'=>['ka',],
'ძველი'=>['ka',],
'ძირითადი'=>['ka',],
'ძმა'=>['ka',],
'წარადგინა'=>['ka',],
'წარდგენა'=>['ka',],
'წარდგინება'=>['ka',],
'წარმატებული'=>['ka',],
'წარმოადგენს'=>['ka',],
'წარმოდგენა'=>['ka',],
'წარმოება'=>['ka',],
'წარმოიდგენს'=>['ka',],
'წარმოიშვა'=>['ka',],
'წარმომადგენელი'=>['ka',],
'წარმოშობა'=>['ka',],
'წარუდგინა'=>['ka',],
'წევრი'=>['ka',],
'წელი'=>['ka',],
'წერილი'=>['ka',],
'წესდება'=>['ka',],
'წესი'=>['ka',],
'წესრიგი'=>['ka',],
'წიგნი'=>['ka',],
'წინ'=>['ka',],
'წინააღმდეგი'=>['ka',],
'წინადადება'=>['ka',],
'წინასწარი'=>['ka',],
'წინაშე'=>['ka',],
'წლიური'=>['ka',],
'წყალი'=>['ka',],
'წყალმოსარგებლე'=>['ka',],
'წყალსარგებლობა'=>['ka',],
'წყარო'=>['ka',],
'წყდება'=>['ka',],
'წყვეტენ'=>['ka',],
'ხალხი'=>['ka',],
'ხანგრძლივი'=>['ka',],
'ხანდაზმულობა'=>['ka',],
'ხანი'=>['ka',],
'ხარისხი'=>['ka',],
'ხარჯი'=>['ka',],
'ხასიათი'=>['ka',],
'ხდება'=>['ka',],
'ხელახლა'=>['ka',],
'ხელი'=>['ka',],
'ხელისუფალი'=>['ka',],
'ხელმოწერა'=>['ka',],
'ხელმძღვანელი'=>['ka',],
'ხელფასი'=>['ka',],
'ხელშეკრულება'=>['ka',],
'ხმა'=>['ka',],
'ხნის'=>['ka',],
'ხოლო'=>['ka',],
'ხომ'=>['ka',],
'ხორციელდება'=>['ka',],
'ხშირი'=>['ka',],
'ჯამი'=>['ka',],
'ჯანმრთელობა'=>['ka',],
'ჯარი'=>['ka',],
'ჯარიმა'=>['ka',],
'ჯგუფი'=>['ka',],
'ჯერ'=>['ka',],
'ჯერჯერობით'=>['ka',],
'ჰაერი'=>['ka',],
'一'=>['zh','zh_cn','zh_tw',],
'一下'=>['zh','zh_cn','zh_tw',],
'一些'=>['zh','zh_cn','zh_tw',],
'一件'=>['zh','zh_cn','zh_tw',],
'一個'=>['zh_tw',],
'一分'=>['zh',],
'一切'=>['zh_cn','zh_tw',],
'一名'=>['zh',],
'一夜'=>['zh',],
'一天'=>['zh_cn','zh_tw',],
'一定'=>['zh','zh_cn','zh_tw',],
'一杯'=>['zh',],
'一樣'=>['zh_tw',],
'一次'=>['zh','zh_cn','zh_tw',],
'一直'=>['zh','zh_cn','zh_tw',],
'一種'=>['zh_tw',],
'一起'=>['zh','zh_cn','zh_tw',],
'一點'=>['zh_tw',],
'丁'=>['zh_cn',],
'万'=>['zh_cn',],
'丈夫'=>['zh_cn','zh_tw',],
'三'=>['zh_cn','zh_tw',],
'三個'=>['zh_tw',],
'三天'=>['zh',],
'上'=>['zh','zh_cn','zh_tw',],
'上了'=>['zh_cn',],
'上帝'=>['zh','zh_cn','zh_tw',],
'上床'=>['zh',],
'上次'=>['zh',],
'上班'=>['zh',],
'上面'=>['zh_tw',],
'下'=>['zh_cn','zh_tw',],
'下一'=>['zh',],
'下來'=>['zh_tw',],
'下午'=>['zh',],
'下去'=>['zh_cn','zh_tw',],
'下班'=>['zh',],
'不'=>['zh','zh_cn','zh_tw',],
'不了'=>['zh_cn','zh_tw',],
'不再'=>['zh_cn','zh_tw',],
'不准'=>['zh',],
'不到'=>['zh','zh_cn','zh_tw',],
'不去'=>['zh',],
'不受'=>['zh',],
'不可'=>['zh_tw',],
'不可能'=>['zh','zh_cn','zh_tw',],
'不合理'=>['zh',],
'不同'=>['zh_cn','zh_tw',],
'不哭'=>['zh',],
'不喜'=>['zh','zh_cn',],
'不喜歡'=>['zh_tw',],
'不在'=>['zh','zh_cn','zh_tw',],
'不在乎'=>['zh',],
'不太'=>['zh','zh_tw',],
'不好'=>['zh_cn','zh_tw',],
'不想'=>['zh','zh_cn','zh_tw',],
'不懂'=>['zh',],
'不明白'=>['zh_cn',],
'不是'=>['zh','zh_cn','zh_tw',],
'不會'=>['zh_tw',],
'不然'=>['zh',],
'不用'=>['zh_cn','zh_tw',],
'不相信'=>['zh',],
'不知道'=>['zh','zh_cn','zh_tw',],
'不管'=>['zh_cn','zh_tw',],
'不能'=>['zh','zh_cn','zh_tw',],
'不行'=>['zh','zh_cn','zh_tw',],
'不要'=>['zh','zh_cn','zh_tw',],
'不起'=>['zh','zh_cn',],
'不過'=>['zh_tw',],
'不錯'=>['zh_tw',],
'不需要'=>['zh_cn','zh_tw',],
'与'=>['zh','zh_cn',],
'专门'=>['zh',],
'且'=>['zh_cn',],
'世'=>['zh_cn',],
'世界'=>['zh','zh_cn','zh_tw',],
'业'=>['zh_cn',],
'业务员'=>['zh',],
'东'=>['zh','zh_cn',],
'丝'=>['zh_cn',],
'丢'=>['zh','zh_cn',],
'两'=>['zh','zh_cn',],
'两个'=>['zh','zh_cn',],
'严'=>['zh_cn',],
'並'=>['zh_tw',],
'个'=>['zh','zh_cn',],
'个无'=>['zh',],
'个电话给'=>['zh',],
'个问题'=>['zh',],
'中'=>['zh','zh_cn','zh_tw',],
'丹'=>['zh_cn','zh_tw',],
'为'=>['zh','zh_cn',],
'主'=>['zh','zh_cn','zh_tw',],
'丽'=>['zh_cn',],
'举'=>['zh',],
'久'=>['zh',],
'么'=>['zh','zh_cn','zh_tw',],
'义'=>['zh_cn',],
'之'=>['zh','zh_cn','zh_tw',],
'之前'=>['zh_cn','zh_tw',],
'之后'=>['zh_cn',],
'之後'=>['zh_tw',],
'之間'=>['zh_tw',],
'乐'=>['zh_cn',],
'乐观'=>['zh',],
'乔'=>['zh','zh_cn',],
'乖'=>['zh',],
'也'=>['zh','zh_cn','zh_tw',],
'也許'=>['zh_tw',],
'书'=>['zh','zh_cn',],
'买'=>['zh_cn',],
'买单'=>['zh',],
'乱'=>['zh_cn',],
'了'=>['zh','zh_cn','zh_tw',],
'了吧'=>['zh_cn','zh_tw',],
'了解'=>['zh','zh_cn','zh_tw',],
'争权'=>['zh',],
'事'=>['zh','zh_cn','zh_tw',],
'事實'=>['zh_tw',],
'事實上'=>['zh_tw',],
'事情'=>['zh_cn','zh_tw',],
'二'=>['zh_cn','zh_tw',],
'于'=>['zh','zh_cn','zh_tw',],
'五'=>['zh_cn','zh_tw',],
'亚'=>['zh','zh_cn',],
'亚当'=>['zh',],
'些'=>['zh','zh_cn','zh_tw',],
'亞'=>['zh_tw',],
'交'=>['zh','zh_cn',],
'产'=>['zh_cn',],
'亲'=>['zh','zh_cn',],
'亲爱'=>['zh','zh_cn',],
'人'=>['zh','zh_cn','zh_tw',],
'人們'=>['zh_tw',],
'人性'=>['zh',],
'人犯'=>['zh',],
'人生'=>['zh',],
'什'=>['zh','zh_cn','zh_tw',],
'什麼'=>['zh_tw',],
'什麼事'=>['zh_tw',],
'今'=>['zh',],
'今天'=>['zh','zh_cn','zh_tw',],
'今日'=>['zh',],
'今晚'=>['zh','zh_cn','zh_tw',],
'仍然'=>['zh',],
'从'=>['zh','zh_cn',],
'从来'=>['zh',],
'他'=>['zh','zh_cn','zh_tw',],
'他人'=>['zh',],
'他們'=>['zh_tw',],
'他們的'=>['zh_tw',],
'他的'=>['zh','zh_cn','zh_tw',],
'付'=>['zh_cn',],
'代'=>['zh_cn',],
'代表'=>['zh_tw',],
'令人'=>['zh',],
'以'=>['zh','zh_cn','zh_tw',],
'以前'=>['zh','zh_cn','zh_tw',],
'以后'=>['zh_cn',],
'以為'=>['zh_tw',],
'们'=>['zh','zh_cn',],
'们会'=>['zh','zh_cn',],
'们会处'=>['zh',],
'们俩个'=>['zh',],
'们应该'=>['zh',],
'们来'=>['zh_cn',],
'们没'=>['zh_cn',],
'们现'=>['zh_cn',],
'们说'=>['zh_cn',],
'们还'=>['zh_cn',],
'们这'=>['zh_cn',],
'们长'=>['zh',],
'件'=>['zh_cn','zh_tw',],
'价'=>['zh_cn',],
'任'=>['zh_cn',],
'任何'=>['zh','zh_cn','zh_tw',],
'任何人'=>['zh_tw',],
'任務'=>['zh_tw',],
'份'=>['zh',],
'企'=>['zh',],
'伊'=>['zh_cn','zh_tw',],
'休息'=>['zh_tw',],
'众'=>['zh',],
'伙'=>['zh','zh_cn','zh_tw',],
'伙計'=>['zh_tw',],
'会'=>['zh','zh_cn',],
'会办'=>['zh',],
'会发'=>['zh',],
'会变'=>['zh',],
'会尽'=>['zh',],
'会杀'=>['zh',],
'会来'=>['zh',],
'会爱'=>['zh',],
'会签'=>['zh',],
'会让'=>['zh','zh_cn',],
'传'=>['zh','zh_cn',],
'传统'=>['zh',],
'伤'=>['zh','zh_cn',],
'伤吗'=>['zh',],
'伦'=>['zh_cn',],
'伯'=>['zh_cn','zh_tw',],
'但'=>['zh','zh_cn','zh_tw',],
'但如'=>['zh',],
'但是'=>['zh_cn','zh_tw',],
'位'=>['zh','zh_cn',],
'低'=>['zh',],
'住'=>['zh','zh_cn','zh_tw',],
'住在'=>['zh','zh_cn','zh_tw',],
'住址'=>['zh',],
'体'=>['zh','zh_cn',],
'何'=>['zh','zh_cn',],
'何不'=>['zh',],
'佛'=>['zh_cn','zh_tw',],
'作'=>['zh_cn','zh_tw',],
'作家'=>['zh',],
'你'=>['zh','zh_cn','zh_tw',],
'你們'=>['zh_tw',],
'你們的'=>['zh_tw',],
'你好'=>['zh_cn','zh_tw',],
'你的'=>['zh','zh_cn','zh_tw',],
'你自己'=>['zh_cn','zh_tw',],
'使'=>['zh_cn','zh_tw',],
'來'=>['zh_tw',],
'來吧'=>['zh_tw',],
'來自'=>['zh_tw',],
'來說'=>['zh_tw',],
'侵入'=>['zh',],
'便'=>['zh_cn',],
'係'=>['zh_tw',],
'俄'=>['zh_cn',],
'保'=>['zh','zh_cn','zh_tw',],
'保佑'=>['zh',],
'保持'=>['zh_cn','zh_tw',],
'保護'=>['zh_tw',],
'信'=>['zh_cn','zh_tw',],
'修女'=>['zh',],
'修正'=>['zh',],
'倆'=>['zh_tw',],
'個'=>['zh_tw',],
'個人'=>['zh_tw',],
'們'=>['zh_tw',],
'倒'=>['zh_cn',],
'候'=>['zh','zh_cn',],
'借用'=>['zh',],
'倫'=>['zh_tw',],
'假'=>['zh_cn',],
'偉大'=>['zh_tw',],
'做'=>['zh','zh_cn','zh_tw',],
'做了'=>['zh_cn','zh_tw',],
'做到'=>['zh_tw',],
'做成'=>['zh',],
'停'=>['zh_cn','zh_tw',],
'停下'=>['zh_cn',],
'偷了'=>['zh',],
'偷看'=>['zh',],
'傑'=>['zh_tw',],
'傢'=>['zh_tw',],
'傷害'=>['zh_tw',],
'像'=>['zh','zh_cn','zh_tw',],
'像是'=>['zh','zh_cn','zh_tw',],
'儿'=>['zh','zh_cn','zh_tw',],
'兄弟'=>['zh','zh_cn','zh_tw',],
'先'=>['zh','zh_cn','zh_tw',],
'先生'=>['zh','zh_cn','zh_tw',],
'光'=>['zh','zh_cn',],
'光是'=>['zh',],
'克'=>['zh','zh_cn','zh_tw',],
'兒'=>['zh_tw',],
'兒子'=>['zh_tw',],
'入'=>['zh','zh_cn',],
'內'=>['zh_tw',],
'全'=>['zh_cn','zh_tw',],
'全部'=>['zh_cn','zh_tw',],
'兩'=>['zh_tw',],
'兩個'=>['zh_tw',],
'公'=>['zh','zh_cn',],
'公分'=>['zh',],
'公司'=>['zh_cn','zh_tw',],
'六'=>['zh','zh_cn',],
'兰'=>['zh_cn',],
'关'=>['zh','zh_cn',],
'兴'=>['zh_cn',],
'其'=>['zh','zh_cn',],
'其中'=>['zh',],
'其他'=>['zh','zh_cn','zh_tw',],
'其他人'=>['zh','zh_tw',],
'其實'=>['zh_tw',],
'兹'=>['zh',],
'养'=>['zh',],
'内'=>['zh','zh_cn',],
'再'=>['zh','zh_cn','zh_tw',],
'再來'=>['zh_tw',],
'再看'=>['zh',],
'再見'=>['zh_tw',],
'再說'=>['zh_tw',],
'冒'=>['zh',],
'写'=>['zh','zh_cn',],
'写书'=>['zh',],
'写关'=>['zh',],
'写这'=>['zh',],
'军'=>['zh','zh_cn',],
'冠'=>['zh',],
'决'=>['zh','zh_cn',],
'况'=>['zh_cn',],
'冷'=>['zh_cn',],
'冷靜'=>['zh_tw',],
'准'=>['zh','zh_cn',],
'几'=>['zh','zh_cn','zh_tw',],
'凯'=>['zh','zh_cn',],
'凱'=>['zh_tw',],
'凶手'=>['zh',],
'出'=>['zh','zh_cn','zh_tw',],
'出來'=>['zh_tw',],
'出去'=>['zh','zh_cn','zh_tw',],
'出現'=>['zh_tw',],
'击'=>['zh','zh_cn',],
'分'=>['zh','zh_cn','zh_tw',],
'分尸'=>['zh',],
'分居'=>['zh',],
'分手'=>['zh',],
'分鐘'=>['zh_tw',],
'切'=>['zh_cn',],
'划'=>['zh','zh_cn',],
'则'=>['zh_cn',],
'刚'=>['zh_cn',],
'刚毁'=>['zh',],
'判'=>['zh',],
'別'=>['zh_tw',],
'別人'=>['zh_tw',],
'別的'=>['zh_tw',],
'利'=>['zh','zh_cn','zh_tw',],
'别'=>['zh','zh_cn',],
'别担'=>['zh_cn',],
'别这样'=>['zh',],
'到'=>['zh','zh_cn','zh_tw',],
'到了'=>['zh_cn','zh_tw',],
'到底'=>['zh_cn','zh_tw',],
'到有'=>['zh',],
'制作'=>['zh',],
'前'=>['zh','zh_cn','zh_tw',],
'剛'=>['zh_tw',],
'剛剛'=>['zh_tw',],
'剛才'=>['zh_tw',],
'副教授'=>['zh',],
'割破'=>['zh',],
'力'=>['zh','zh_cn','zh_tw',],
'办'=>['zh','zh_cn',],
'加'=>['zh_cn','zh_tw',],
'加入'=>['zh',],
'务'=>['zh_cn',],
'动'=>['zh','zh_cn',],
'助'=>['zh','zh_cn',],
'助理'=>['zh',],
'努力'=>['zh_tw',],
'勒'=>['zh_cn','zh_tw',],
'動'=>['zh_tw',],
'包'=>['zh_cn','zh_tw',],
'化'=>['zh_cn',],
'区'=>['zh','zh_cn',],
'医'=>['zh_cn',],
'區'=>['zh_tw',],
'千'=>['zh','zh_cn',],
'午夜'=>['zh',],
'半'=>['zh_cn',],
'华'=>['zh_cn',],
'单'=>['zh','zh_cn',],
'卖'=>['zh_cn',],
'南'=>['zh_tw',],
'博'=>['zh_tw',],
'博士'=>['zh_cn','zh_tw',],
'卡'=>['zh','zh_cn','zh_tw',],
'卧'=>['zh',],
'卫'=>['zh_cn',],
'卫说'=>['zh',],
'危'=>['zh_cn',],
'危險'=>['zh_tw',],
'却'=>['zh_cn',],
'卵'=>['zh',],
'卻'=>['zh_tw',],
'厂'=>['zh',],
'压'=>['zh_cn',],
'原'=>['zh_cn',],
'原因'=>['zh','zh_cn','zh_tw',],
'去'=>['zh','zh_cn','zh_tw',],
'去了'=>['zh_cn','zh_tw',],
'去年'=>['zh',],
'去看'=>['zh','zh_cn','zh_tw',],
'参'=>['zh_cn',],
'參加'=>['zh_tw',],
'又'=>['zh','zh_cn','zh_tw',],
'及'=>['zh',],
'双'=>['zh',],
'反'=>['zh','zh_cn',],
'发'=>['zh','zh_cn',],
'发现'=>['zh','zh_cn',],
'发过'=>['zh',],
'取'=>['zh_cn',],
'受'=>['zh','zh_cn',],
'受害人'=>['zh',],
'受害者'=>['zh',],
'受理'=>['zh',],
'变'=>['zh','zh_cn',],
'口'=>['zh_cn',],
'另一'=>['zh','zh_cn',],
'另一個'=>['zh_tw',],
'只'=>['zh','zh_cn','zh_tw',],
'叫'=>['zh','zh_cn','zh_tw',],
'可'=>['zh_cn','zh_tw',],
'可不'=>['zh_cn','zh_tw',],
'可以'=>['zh','zh_cn','zh_tw',],
'可怕'=>['zh',],
'可惜'=>['zh',],
'可愛'=>['zh_tw',],
'可是'=>['zh_cn','zh_tw',],
'可能'=>['zh','zh_cn','zh_tw',],
'台'=>['zh_cn',],
'史'=>['zh_cn','zh_tw',],
'号'=>['zh_cn',],
'吃'=>['zh','zh_cn','zh_tw',],
'吃早餐'=>['zh',],
'各位'=>['zh','zh_cn','zh_tw',],
'合'=>['zh_cn',],
'合作'=>['zh',],
'吉'=>['zh','zh_cn','zh_tw',],
'同'=>['zh','zh_cn',],
'同一'=>['zh',],
'同意'=>['zh_tw',],
'同理'=>['zh',],
'名'=>['zh','zh_cn','zh_tw',],
'名字'=>['zh','zh_cn','zh_tw',],
'后'=>['zh','zh_cn','zh_tw',],
'后跟'=>['zh',],
'后面'=>['zh_cn',],
'向'=>['zh_cn','zh_tw',],
'吓'=>['zh_cn',],
'吗'=>['zh','zh_cn',],
'否'=>['zh_cn',],
'否則'=>['zh_tw',],
'吧'=>['zh','zh_cn','zh_tw',],
'听'=>['zh','zh_cn','zh_tw',],
'吵'=>['zh',],
'吵架'=>['zh',],
'吻合'=>['zh',],
'呀'=>['zh_cn','zh_tw',],
'呃'=>['zh_cn','zh_tw',],
'告'=>['zh','zh_cn',],
'告訴'=>['zh_tw',],
'员'=>['zh_cn',],
'呢'=>['zh','zh_cn','zh_tw',],
'周'=>['zh_cn',],
'周末'=>['zh',],
'周知'=>['zh',],
'命'=>['zh_cn',],
'和'=>['zh','zh_cn','zh_tw',],
'咖啡'=>['zh_cn',],
'咱'=>['zh_cn',],
'咱們'=>['zh_tw',],
'咸'=>['zh',],
'哀'=>['zh',],
'品'=>['zh_cn',],
'哇'=>['zh_cn','zh_tw',],
'哈'=>['zh_cn','zh_tw',],
'响'=>['zh',],
'員'=>['zh_tw',],
'哥'=>['zh','zh_cn','zh_tw',],
'哦'=>['zh_cn','zh_tw',],
'哪'=>['zh','zh_cn','zh_tw',],
'哪兒'=>['zh_tw',],
'哪裡'=>['zh_tw',],
'哭了'=>['zh',],
'唯一'=>['zh','zh_cn','zh_tw',],
'啊'=>['zh','zh_cn','zh_tw',],
'問'=>['zh_tw',],
'問題'=>['zh_tw',],
'啥'=>['zh_cn',],
'啦'=>['zh_cn','zh_tw',],
'喂'=>['zh','zh_cn','zh_tw',],
'善待'=>['zh',],
'喔'=>['zh','zh_cn','zh_tw',],
'喜'=>['zh','zh_cn',],
'喜歡'=>['zh_tw',],
'喝'=>['zh','zh_cn','zh_tw',],
'喬'=>['zh_tw',],
'喬治'=>['zh_tw',],
'嗎'=>['zh_tw',],
'嗨'=>['zh','zh_cn','zh_tw',],
'嗯'=>['zh_cn','zh_tw',],
'嘛'=>['zh','zh_cn','zh_tw',],
'嘴'=>['zh_cn',],
'嘿'=>['zh','zh_cn','zh_tw',],
'噢'=>['zh_cn','zh_tw',],
'器'=>['zh_cn',],
'囉'=>['zh_tw',],
'四'=>['zh','zh_cn',],
'回'=>['zh','zh_cn','zh_tw',],
'回事'=>['zh','zh_cn','zh_tw',],
'回來'=>['zh_tw',],
'回到'=>['zh','zh_cn','zh_tw',],
'回去'=>['zh','zh_cn','zh_tw',],
'回家'=>['zh','zh_cn','zh_tw',],
'回答'=>['zh_tw',],
'因'=>['zh','zh_cn','zh_tw',],
'因為'=>['zh_tw',],
'园'=>['zh','zh_cn',],
'国'=>['zh_cn',],
'国动'=>['zh',],
'图'=>['zh_cn',],
'國家'=>['zh_tw',],
'圣'=>['zh_cn',],
'在'=>['zh','zh_cn','zh_tw',],
'在一起'=>['zh','zh_cn','zh_tw',],
'在做'=>['zh_cn','zh_tw',],
'在哪'=>['zh','zh_cn','zh_tw',],
'在哪裡'=>['zh_tw',],
'在家'=>['zh',],
'在說'=>['zh_tw',],
'在這裡'=>['zh_tw',],
'地'=>['zh','zh_cn','zh_tw',],
'地址'=>['zh',],
'地方'=>['zh','zh_cn','zh_tw',],
'场'=>['zh','zh_cn',],
'坏'=>['zh_cn',],
'坐'=>['zh_cn','zh_tw',],
'坐好'=>['zh',],
'坐牢'=>['zh',],
'块'=>['zh_cn',],
'坦'=>['zh_tw',],
'垃圾箱'=>['zh',],
'埃'=>['zh_cn',],
'城'=>['zh_cn','zh_tw',],
'城市'=>['zh_cn','zh_tw',],
'基'=>['zh_cn','zh_tw',],
'場'=>['zh_tw',],
'塊'=>['zh_tw',],
'塔'=>['zh_cn','zh_tw',],
'塞'=>['zh_cn','zh_tw',],
'境'=>['zh',],
'墙'=>['zh',],
'墨'=>['zh_tw',],
'士'=>['zh','zh_cn','zh_tw',],
'声'=>['zh','zh_cn',],
'处'=>['zh','zh_cn',],
'备'=>['zh_cn',],
'复'=>['zh','zh_cn',],
'外'=>['zh_cn',],
'外面'=>['zh','zh_cn','zh_tw',],
'多'=>['zh','zh_cn','zh_tw',],
'多久'=>['zh','zh_cn','zh_tw',],
'多了'=>['zh',],
'多大'=>['zh',],
'多少'=>['zh_cn','zh_tw',],
'多重'=>['zh',],
'够'=>['zh','zh_cn',],
'夠'=>['zh_tw',],
'夠了'=>['zh_tw',],
'夢'=>['zh_tw',],
'夥'=>['zh_tw',],
'大'=>['zh','zh_cn','zh_tw',],
'大人'=>['zh_tw',],
'大哥'=>['zh',],
'大多'=>['zh',],
'大家'=>['zh_cn','zh_tw',],
'天'=>['zh','zh_cn','zh_tw',],
'天使'=>['zh',],
'天哪'=>['zh_cn','zh_tw',],
'天啊'=>['zh','zh_cn','zh_tw',],
'太'=>['zh','zh_cn','zh_tw',],
'太多'=>['zh','zh_cn','zh_tw',],
'太太'=>['zh','zh_cn','zh_tw',],
'太晚'=>['zh',],
'太棒'=>['zh_cn','zh_tw',],
'太空人'=>['zh',],
'太空船'=>['zh',],
'夫'=>['zh_cn','zh_tw',],
'夫人'=>['zh_cn','zh_tw',],
'失'=>['zh_cn',],
'失去'=>['zh_cn','zh_tw',],
'头'=>['zh','zh_cn',],
'头条'=>['zh',],
'头见'=>['zh',],
'夹'=>['zh',],
'奇'=>['zh_cn','zh_tw',],
'奇怪'=>['zh_cn','zh_tw',],
'奥'=>['zh_cn',],
'奧'=>['zh_tw',],
'女'=>['zh_cn','zh_tw',],
'女人'=>['zh','zh_cn','zh_tw',],
'女兒'=>['zh_tw',],
'女士'=>['zh','zh_cn','zh_tw',],
'女孩'=>['zh','zh_cn','zh_tw',],
'她'=>['zh','zh_cn','zh_tw',],
'她們'=>['zh_tw',],
'她的'=>['zh','zh_cn','zh_tw',],
'好'=>['zh','zh_cn','zh_tw',],
'好了'=>['zh','zh_cn','zh_tw',],
'好人'=>['zh',],
'好像'=>['zh_cn','zh_tw',],
'好吧'=>['zh','zh_cn','zh_tw',],
'好啊'=>['zh_cn','zh_tw',],
'好啦'=>['zh',],
'好嗎'=>['zh_tw',],
'好多'=>['zh',],
'好好'=>['zh','zh_cn','zh_tw',],
'好玩'=>['zh',],
'好的'=>['zh','zh_cn','zh_tw',],
'如何'=>['zh','zh_cn','zh_tw',],
'如果'=>['zh','zh_cn','zh_tw',],
'如此'=>['zh_cn','zh_tw',],
'妈'=>['zh','zh_cn',],
'妈妈'=>['zh_cn',],
'妮'=>['zh_cn','zh_tw',],
'妳'=>['zh_cn','zh_tw',],
'妻子'=>['zh_cn','zh_tw',],
'姆'=>['zh','zh_cn','zh_tw',],
'始'=>['zh','zh_cn',],
'姓名'=>['zh',],
'威'=>['zh_cn','zh_tw',],
'娘'=>['zh',],
'娜'=>['zh','zh_cn','zh_tw',],
'婚'=>['zh','zh_cn',],
'媒'=>['zh',],
'媽'=>['zh_tw',],
'媽媽'=>['zh_tw',],
'媽的'=>['zh_tw',],
'嫌犯'=>['zh',],
'子'=>['zh','zh_cn','zh_tw',],
'字'=>['zh_cn',],
'字幕'=>['zh','zh_cn','zh_tw',],
'存在'=>['zh','zh_tw',],
'孤'=>['zh',],
'学'=>['zh','zh_cn',],
'孩子'=>['zh','zh_cn','zh_tw',],
'孩子們'=>['zh_tw',],
'學校'=>['zh_tw',],
'它'=>['zh','zh_cn','zh_tw',],
'它們'=>['zh_tw',],
'它的'=>['zh_cn','zh_tw',],
'守'=>['zh',],
'安'=>['zh','zh_cn','zh_tw',],
'安全'=>['zh','zh_cn','zh_tw',],
'完'=>['zh_cn',],
'完全'=>['zh_cn','zh_tw',],
'完成'=>['zh_cn','zh_tw',],
'完美'=>['zh_tw',],
'官'=>['zh','zh_cn',],
'定'=>['zh','zh_cn','zh_tw',],
'定性'=>['zh',],
'宝'=>['zh',],
'宝宝'=>['zh',],
'宝贝'=>['zh_cn',],
'实'=>['zh','zh_cn',],
'客'=>['zh_cn',],
'室'=>['zh','zh_cn',],
'害'=>['zh','zh_cn',],
'害了'=>['zh',],
'害怕'=>['zh_cn','zh_tw',],
'家'=>['zh','zh_cn','zh_tw',],
'家人'=>['zh',],
'家伙'=>['zh','zh_cn',],
'家庭'=>['zh',],
'容易'=>['zh_tw',],
'寄'=>['zh',],
'密'=>['zh_cn',],
'察'=>['zh',],
'寫'=>['zh_tw',],
'寶貝'=>['zh_tw',],
'对'=>['zh','zh_cn',],
'寻'=>['zh_cn',],
'导'=>['zh',],
'射'=>['zh_cn',],
'将'=>['zh','zh_cn',],
'将会'=>['zh',],
'将会杀'=>['zh',],
'将铲'=>['zh',],
'將'=>['zh_tw',],
'將軍'=>['zh_tw',],
'對'=>['zh_tw',],
'對不起'=>['zh_tw',],
'對了'=>['zh_tw',],
'對嗎'=>['zh_tw',],
'小'=>['zh','zh_cn','zh_tw',],
'小姐'=>['zh','zh_cn','zh_tw',],
'小子'=>['zh','zh_cn','zh_tw',],
'小孩'=>['zh','zh_cn','zh_tw',],
'小心'=>['zh_cn','zh_tw',],
'小時'=>['zh_tw',],
'小男孩'=>['zh',],
'少'=>['zh','zh_cn',],
'尔'=>['zh','zh_cn',],
'就'=>['zh','zh_cn','zh_tw',],
'就是'=>['zh','zh_cn','zh_tw',],
'就跑'=>['zh',],
'尸'=>['zh',],
'尼'=>['zh_cn','zh_tw',],
'尽'=>['zh','zh_cn',],
'局'=>['zh','zh_cn',],
'屁股'=>['zh_tw',],
'居'=>['zh',],
'屈'=>['zh',],
'屍'=>['zh_tw',],
'屑'=>['zh_cn',],
'展'=>['zh',],
'山'=>['zh_cn','zh_tw',],
'山姆'=>['zh',],
'岆'=>['zh_tw',],
'州'=>['zh_cn','zh_tw',],
'州立'=>['zh',],
'工'=>['zh','zh_cn',],
'工作'=>['zh','zh_cn','zh_tw',],
'左'=>['zh',],
'差'=>['zh_cn',],
'己'=>['zh',],
'已'=>['zh','zh_cn','zh_tw',],
'已經'=>['zh_tw',],
'巴'=>['zh','zh_cn','zh_tw',],
'巴士'=>['zh',],
'市'=>['zh_cn',],
'市中心'=>['zh',],
'布'=>['zh','zh_cn','zh_tw',],
'师'=>['zh','zh_cn',],
'希'=>['zh','zh_cn','zh_tw',],
'希望'=>['zh','zh_cn','zh_tw',],
'希特勒'=>['zh',],
'帕'=>['zh_cn','zh_tw',],
'带'=>['zh','zh_cn',],
'带枪'=>['zh',],
'带绿'=>['zh',],
'帮'=>['zh','zh_cn',],
'帮点'=>['zh',],
'帶'=>['zh_tw',],
'帶來'=>['zh_tw',],
'帶著'=>['zh_tw',],
'常'=>['zh_cn',],
'帽'=>['zh',],
'幫'=>['zh_tw',],
'幫你'=>['zh_tw',],
'幫助'=>['zh_tw',],
'幫忙'=>['zh_tw',],
'幫我'=>['zh_tw',],
'干'=>['zh','zh_cn','zh_tw',],
'干得好'=>['zh',],
'年'=>['zh','zh_cn','zh_tw',],
'年后'=>['zh',],
'并'=>['zh','zh_cn','zh_tw',],
'幸'=>['zh','zh_cn',],
'幹'=>['zh_tw',],
'床上'=>['zh',],
'库'=>['zh',],
'应'=>['zh','zh_cn',],
'应该'=>['zh','zh_cn',],
'应该缴'=>['zh',],
'底'=>['zh',],
'店'=>['zh_cn',],
'度'=>['zh','zh_cn',],
'康'=>['zh_tw',],
'建'=>['zh_cn',],
'建筑'=>['zh',],
'建造'=>['zh',],
'开'=>['zh','zh_cn',],
'开这'=>['zh_cn',],
'异'=>['zh','zh_cn',],
'弄'=>['zh_cn','zh_tw',],
'弄糟'=>['zh',],
'引人'=>['zh',],
'弗'=>['zh_cn','zh_tw',],
'张'=>['zh_cn',],
'張'=>['zh_tw',],
'強'=>['zh_tw',],
'弹'=>['zh_cn',],
'强'=>['zh','zh_cn',],
'强调'=>['zh',],
'当'=>['zh','zh_cn',],
'影'=>['zh','zh_cn',],
'往'=>['zh_cn',],
'待'=>['zh_cn',],
'待在'=>['zh',],
'很'=>['zh','zh_cn','zh_tw',],
'很多'=>['zh_cn','zh_tw',],
'很好'=>['zh','zh_cn','zh_tw',],
'很忙'=>['zh',],
'很快'=>['zh_cn','zh_tw',],
'很感'=>['zh',],
'很糟'=>['zh',],
'很高'=>['zh','zh_cn',],
'很高興'=>['zh_tw',],
'律'=>['zh','zh_cn',],
'後'=>['zh_tw',],
'得'=>['zh','zh_cn','zh_tw',],
'得了'=>['zh_cn',],
'得到'=>['zh_cn','zh_tw',],
'從'=>['zh_tw',],
'從來'=>['zh_tw',],
'德'=>['zh_cn','zh_tw',],
'心'=>['zh','zh_cn','zh_tw',],
'必'=>['zh','zh_cn',],
'必須'=>['zh_tw',],
'忍不住'=>['zh',],
'忍受'=>['zh',],
'志'=>['zh',],
'忘'=>['zh_cn',],
'忘了'=>['zh','zh_cn','zh_tw',],
'忙'=>['zh','zh_cn','zh_tw',],
'快'=>['zh','zh_cn','zh_tw',],
'快樂'=>['zh_tw',],
'快走'=>['zh','zh_cn','zh_tw',],
'快點'=>['zh_tw',],
'念'=>['zh_cn',],
'怀'=>['zh_cn',],
'怎'=>['zh','zh_cn','zh_tw',],
'怎樣'=>['zh_tw',],
'怎麼'=>['zh_tw',],
'怎麼了'=>['zh_tw',],
'怎麼樣'=>['zh_tw',],
'怎麼辦'=>['zh_tw',],
'怕'=>['zh_cn','zh_tw',],
'思'=>['zh_cn',],
'急'=>['zh_cn',],
'急事'=>['zh',],
'性'=>['zh','zh_cn',],
'怪'=>['zh_cn',],
'总'=>['zh','zh_cn',],
'恐怖'=>['zh_tw',],
'恩'=>['zh','zh_cn','zh_tw',],
'恶'=>['zh','zh_cn',],
'您'=>['zh_cn','zh_tw',],
'悲'=>['zh',],
'情'=>['zh_cn','zh_tw',],
'情況'=>['zh_tw',],
'惊'=>['zh_cn',],
'惨'=>['zh',],
'想'=>['zh','zh_cn','zh_tw',],
'想做'=>['zh',],
'想到'=>['zh_cn',],
'想想'=>['zh_tw',],
'想我'=>['zh_cn','zh_tw',],
'想知道'=>['zh_cn','zh_tw',],
'想要'=>['zh','zh_cn','zh_tw',],
'意'=>['zh_cn','zh_tw',],
'意思'=>['zh','zh_cn','zh_tw',],
'愛'=>['zh_tw',],
'感'=>['zh','zh_cn',],
'感到'=>['zh_cn','zh_tw',],
'感受'=>['zh',],
'感覺'=>['zh_tw',],
'感謝'=>['zh_tw',],
'愿'=>['zh','zh_cn','zh_tw',],
'懂'=>['zh_cn','zh_tw',],
'懈'=>['zh_cn',],
'應該'=>['zh_tw',],
'戏'=>['zh_cn',],
'成'=>['zh','zh_cn','zh_tw',],
'成功'=>['zh_cn','zh_tw',],
'成為'=>['zh_tw',],
'成立'=>['zh',],
'我'=>['zh','zh_cn','zh_tw',],
'我們'=>['zh_tw',],
'我喜'=>['zh_cn','zh_tw',],
'我媽'=>['zh_tw',],
'我家'=>['zh',],
'我爸'=>['zh_tw',],
'我的'=>['zh','zh_cn','zh_tw',],
'我自己'=>['zh_cn','zh_tw',],
'戒'=>['zh',],
'或'=>['zh','zh_cn','zh_tw',],
'或者'=>['zh_cn','zh_tw',],
'或許'=>['zh_tw',],
'战'=>['zh_cn',],
'戰爭'=>['zh_tw',],
'戲'=>['zh_tw',],
'戴'=>['zh','zh_cn','zh_tw',],
'户'=>['zh',],
'房'=>['zh_cn',],
'房子'=>['zh_cn','zh_tw',],
'房間'=>['zh_tw',],
'所'=>['zh','zh_cn','zh_tw',],
'所以'=>['zh','zh_cn','zh_tw',],
'所有'=>['zh','zh_cn','zh_tw',],
'所有人'=>['zh_cn','zh_tw',],
'扂'=>['zh_tw',],
'手'=>['zh','zh_cn','zh_tw',],
'才'=>['zh','zh_cn','zh_tw',],
'才是'=>['zh_cn','zh_tw',],
'才能'=>['zh_cn','zh_tw',],
'打'=>['zh','zh_cn','zh_tw',],
'打了'=>['zh',],
'打破'=>['zh',],
'打算'=>['zh_cn','zh_tw',],
'打開'=>['zh_tw',],
'打電話'=>['zh_tw',],
'托'=>['zh_cn','zh_tw',],
'扣押'=>['zh',],
'扰'=>['zh','zh_cn',],
'找'=>['zh','zh_cn','zh_tw',],
'找人'=>['zh',],
'找他'=>['zh',],
'找出'=>['zh',],
'找到'=>['zh','zh_cn','zh_tw',],
'找到了'=>['zh_tw',],
'承'=>['zh_cn',],
'把'=>['zh','zh_cn','zh_tw',],
'把手'=>['zh',],
'抓'=>['zh_cn',],
'抓住'=>['zh_cn','zh_tw',],
'护'=>['zh','zh_cn',],
'护协会'=>['zh',],
'护车'=>['zh',],
'报'=>['zh','zh_cn',],
'报导'=>['zh',],
'抱怨'=>['zh',],
'抱歉'=>['zh','zh_cn','zh_tw',],
'担'=>['zh','zh_cn',],
'拉'=>['zh','zh_cn','zh_tw',],
'拍'=>['zh','zh_cn','zh_tw',],
'拜'=>['zh_tw',],
'拜托'=>['zh','zh_cn',],
'拿'=>['zh','zh_cn','zh_tw',],
'拿到'=>['zh','zh_tw',],
'拿著'=>['zh_tw',],
'持'=>['zh_cn',],
'持有'=>['zh',],
'指'=>['zh','zh_cn',],
'挤'=>['zh',],
'挥'=>['zh_cn',],
'挺'=>['zh','zh_tw',],
'捏造'=>['zh',],
'捞针'=>['zh',],
'换'=>['zh','zh_cn',],
'据'=>['zh','zh_cn',],
'掉'=>['zh_cn','zh_tw',],
'排'=>['zh',],
'探'=>['zh','zh_cn',],
'探望'=>['zh',],
'接'=>['zh','zh_cn','zh_tw',],
'接受'=>['zh','zh_cn','zh_tw',],
'控制'=>['zh_cn','zh_tw',],
'推'=>['zh','zh_cn',],
'描述'=>['zh',],
'提'=>['zh_cn','zh_tw',],
'插手'=>['zh',],
'換'=>['zh_tw',],
'揭'=>['zh',],
'搞'=>['zh','zh_cn','zh_tw',],
'搞清'=>['zh',],
'撒'=>['zh_cn',],
'撞'=>['zh',],
'撞了'=>['zh',],
'擁有'=>['zh_tw',],
'操'=>['zh_cn','zh_tw',],
'擔心'=>['zh_tw',],
'收'=>['zh_cn',],
'收到'=>['zh_cn','zh_tw',],
'改'=>['zh','zh_cn',],
'改變'=>['zh_tw',],
'攻'=>['zh_cn',],
'放'=>['zh','zh_cn','zh_tw',],
'放上'=>['zh',],
'放下'=>['zh','zh_cn','zh_tw',],
'放在'=>['zh','zh_cn','zh_tw',],
'政府'=>['zh','zh_tw',],
'故'=>['zh',],
'故事'=>['zh','zh_cn','zh_tw',],
'救'=>['zh','zh_cn','zh_tw',],
'教'=>['zh','zh_cn','zh_tw',],
'敢'=>['zh','zh_cn','zh_tw',],
'敬'=>['zh',],
'数'=>['zh','zh_cn',],
'数学'=>['zh',],
'整'=>['zh_cn',],
'整個'=>['zh_tw',],
'整天'=>['zh',],
'文'=>['zh_cn','zh_tw',],
'文章'=>['zh',],
'斗'=>['zh_cn',],
'料'=>['zh','zh_cn',],
'斜'=>['zh_cn',],
'断'=>['zh_cn',],
'斯'=>['zh','zh_cn','zh_tw',],
'新'=>['zh','zh_cn','zh_tw',],
'新的'=>['zh','zh_cn','zh_tw',],
'方'=>['zh','zh_cn',],
'方式'=>['zh','zh_tw',],
'方法'=>['zh_tw',],
'无'=>['zh','zh_cn',],
'无线电频'=>['zh',],
'日'=>['zh','zh_cn','zh_tw',],
'日期'=>['zh',],
'早'=>['zh','zh_cn','zh_tw',],
'早上'=>['zh','zh_cn','zh_tw',],
'早到'=>['zh',],
'早在'=>['zh',],
'早就'=>['zh',],
'早餐'=>['zh',],
'时'=>['zh','zh_cn',],
'时间'=>['zh','zh_cn',],
'明'=>['zh','zh_cn','zh_tw',],
'明天'=>['zh_cn','zh_tw',],
'明白'=>['zh_cn','zh_tw',],
'昏迷'=>['zh',],
'星'=>['zh_cn',],
'星期'=>['zh',],
'昨晚'=>['zh','zh_cn','zh_tw',],
'是'=>['zh','zh_cn','zh_tw',],
'是不是'=>['zh_cn','zh_tw',],
'是否'=>['zh_cn','zh_tw',],
'是嗎'=>['zh_tw',],
'是的'=>['zh','zh_cn','zh_tw',],
'显'=>['zh_cn',],
'時'=>['zh_tw',],
'時候'=>['zh_tw',],
'時間'=>['zh_tw',],
'晚'=>['zh','zh_cn',],
'晚上'=>['zh','zh_cn','zh_tw',],
'晚安'=>['zh','zh_cn','zh_tw',],
'普'=>['zh_cn','zh_tw',],
'更'=>['zh','zh_cn','zh_tw',],
'更好'=>['zh_tw',],
'書'=>['zh_tw',],
'曼'=>['zh','zh_cn','zh_tw',],
'曾'=>['zh_cn','zh_tw',],
'曾經'=>['zh_tw',],
'替'=>['zh_cn','zh_tw',],
'最'=>['zh_cn','zh_tw',],
'最后'=>['zh','zh_cn',],
'最好'=>['zh','zh_cn','zh_tw',],
'最後'=>['zh_tw',],
'最近'=>['zh_cn','zh_tw',],
'會'=>['zh_tw',],
'月'=>['zh','zh_cn','zh_tw',],
'有'=>['zh','zh_cn','zh_tw',],
'有了'=>['zh','zh_cn',],
'有些'=>['zh','zh_cn','zh_tw',],
'有人'=>['zh','zh_cn','zh_tw',],
'有可能'=>['zh',],
'有沒有'=>['zh_tw',],
'有用'=>['zh',],
'有由'=>['zh',],
'有趣'=>['zh_cn','zh_tw',],
'有關'=>['zh_tw',],
'有點'=>['zh_tw',],
'朋友'=>['zh','zh_cn','zh_tw',],
'服'=>['zh_cn',],
'未'=>['zh','zh_cn',],
'未來'=>['zh_tw',],
'本'=>['zh','zh_cn','zh_tw',],
'本來'=>['zh_tw',],
'术'=>['zh_cn',],
'机'=>['zh','zh_cn',],
'杀'=>['zh','zh_cn',],
'杀两个'=>['zh',],
'杂'=>['zh','zh_cn',],
'权'=>['zh','zh_cn',],
'束'=>['zh','zh_cn',],
'条'=>['zh_cn',],
'来'=>['zh','zh_cn',],
'来说'=>['zh','zh_cn',],
'来这'=>['zh_cn',],
'杯'=>['zh','zh_cn','zh_tw',],
'杰'=>['zh_cn',],
'杰克'=>['zh_cn',],
'東'=>['zh_tw',],
'東西'=>['zh_tw',],
'松'=>['zh','zh_cn','zh_tw',],
'极'=>['zh','zh_cn',],
'林'=>['zh_cn','zh_tw',],
'果'=>['zh','zh_cn',],
'果是'=>['zh',],
'枪'=>['zh','zh_cn',],
'架'=>['zh',],
'某'=>['zh_cn',],
'某人'=>['zh',],
'查'=>['zh','zh_cn','zh_tw',],
'柯'=>['zh_tw',],
'标'=>['zh','zh_cn',],
'树'=>['zh',],
'校'=>['zh_cn',],
'样'=>['zh','zh_cn',],
'根'=>['zh_cn','zh_tw',],
'根本'=>['zh','zh_cn','zh_tw',],
'格'=>['zh_cn','zh_tw',],
'桀'=>['zh',],
'案'=>['zh','zh_cn',],
'案件'=>['zh',],
'案子'=>['zh',],
'梅'=>['zh_cn','zh_tw',],
'條'=>['zh_tw',],
'梦'=>['zh_cn',],
'械'=>['zh_cn',],
'检'=>['zh','zh_cn',],
'棒'=>['zh','zh_cn','zh_tw',],
'森'=>['zh','zh_cn','zh_tw',],
'楚'=>['zh',],
'楼'=>['zh','zh_cn',],
'槍'=>['zh_tw',],
'樣'=>['zh_tw',],
'機'=>['zh_tw',],
'機會'=>['zh_tw',],
'橡'=>['zh',],
'欠'=>['zh',],
'次'=>['zh','zh_cn','zh_tw',],
'欢'=>['zh','zh_cn',],
'欢将'=>['zh',],
'欧'=>['zh_cn',],
'歌'=>['zh_cn','zh_tw',],
'歡'=>['zh_tw',],
'歡迎'=>['zh_tw',],
'正'=>['zh','zh_cn','zh_tw',],
'正在'=>['zh_cn','zh_tw',],
'正常'=>['zh_cn','zh_tw',],
'此'=>['zh_cn',],
'武器'=>['zh_cn','zh_tw',],
'歲'=>['zh_tw',],
'死'=>['zh','zh_cn','zh_tw',],
'死了'=>['zh','zh_cn','zh_tw',],
'死亡'=>['zh',],
'殺'=>['zh_tw',],
'毁'=>['zh_cn',],
'母'=>['zh','zh_cn',],
'母親'=>['zh_tw',],
'每'=>['zh','zh_cn',],
'每個'=>['zh_tw',],
'每個人'=>['zh_tw',],
'每天'=>['zh_tw',],
'每次'=>['zh',],
'比'=>['zh','zh_cn','zh_tw',],
'比賽'=>['zh_tw',],
'毫'=>['zh',],
'气'=>['zh','zh_cn',],
'水'=>['zh_cn','zh_tw',],
'永'=>['zh_cn',],
'永遠'=>['zh_tw',],
'求'=>['zh_cn','zh_tw',],
'汉'=>['zh_cn',],
'汤'=>['zh_cn',],
'決定'=>['zh_tw',],
'沒'=>['zh_tw',],
'沒事'=>['zh_tw',],
'沒人'=>['zh_tw',],
'沒什麼'=>['zh_tw',],
'沒問題'=>['zh_tw',],
'沒有'=>['zh_tw',],
'沒錯'=>['zh_tw',],
'沒關'=>['zh_tw',],
'沙'=>['zh_cn',],
'没'=>['zh','zh_cn',],
'没关'=>['zh_cn',],
'没错'=>['zh_cn',],
'没问题'=>['zh_cn',],
'治'=>['zh_cn',],
'法'=>['zh','zh_cn','zh_tw',],
'波'=>['zh_cn','zh_tw',],
'注'=>['zh',],
'注意'=>['zh','zh_cn','zh_tw',],
'注意到'=>['zh',],
'注目'=>['zh',],
'泰'=>['zh_tw',],
'泻'=>['zh_cn',],
'洛'=>['zh_cn','zh_tw',],
'活'=>['zh','zh_cn','zh_tw',],
'活著'=>['zh_tw',],
'派'=>['zh_cn','zh_tw',],
'测'=>['zh',],
'浴室'=>['zh',],
'海'=>['zh','zh_cn',],
'消失'=>['zh',],
'消失了'=>['zh',],
'消息'=>['zh','zh_cn','zh_tw',],
'混蛋'=>['zh','zh_cn','zh_tw',],
'清楚'=>['zh_cn','zh_tw',],
'温'=>['zh_cn',],
'游'=>['zh_cn',],
'湯'=>['zh_tw',],
'源'=>['zh',],
'準'=>['zh_tw',],
'準備'=>['zh_tw',],
'滚'=>['zh','zh_cn',],
'满'=>['zh_cn',],
'滾'=>['zh_tw',],
'漂亮'=>['zh','zh_cn','zh_tw',],
'演'=>['zh_cn',],
'漢'=>['zh_tw',],
'漫'=>['zh',],
'火'=>['zh_cn',],
'灵'=>['zh_cn',],
'炸'=>['zh_cn',],
'点'=>['zh','zh_cn',],
'点处'=>['zh',],
'点稳'=>['zh',],
'点见'=>['zh',],
'為'=>['zh_tw',],
'為了'=>['zh_tw',],
'為什麼'=>['zh_tw',],
'為何'=>['zh_tw',],
'烟'=>['zh_cn',],
'烦'=>['zh','zh_cn',],
'热'=>['zh_cn',],
'热门'=>['zh',],
'無法'=>['zh_tw',],
'然'=>['zh','zh_cn',],
'然后'=>['zh','zh_cn','zh_tw',],
'然後'=>['zh_tw',],
'照'=>['zh_cn',],
'照片'=>['zh','zh_cn','zh_tw',],
'照顧'=>['zh_tw',],
'熟'=>['zh',],
'爱'=>['zh_cn',],
'父'=>['zh','zh_cn',],
'父母'=>['zh_cn',],
'父親'=>['zh_tw',],
'爸'=>['zh_cn','zh_tw',],
'爸爸'=>['zh','zh_cn','zh_tw',],
'爾'=>['zh_tw',],
'物'=>['zh','zh_cn',],
'特'=>['zh','zh_cn','zh_tw',],
'特別'=>['zh_tw',],
'犯案'=>['zh',],
'犯法'=>['zh',],
'犯罪'=>['zh',],
'狂'=>['zh','zh_cn',],
'狗'=>['zh','zh_cn','zh_tw',],
'独'=>['zh','zh_cn',],
'狮鹫'=>['zh',],
'猜'=>['zh','zh_cn','zh_tw',],
'猫'=>['zh',],
'獺'=>['zh_tw',],
'王'=>['zh_cn',],
'玛'=>['zh_cn',],
'玩'=>['zh','zh_cn','zh_tw',],
'玩笑'=>['zh_cn',],
'环'=>['zh',],
'现'=>['zh','zh_cn',],
'珍'=>['zh_tw',],
'班'=>['zh_cn','zh_tw',],
'現在'=>['zh_tw',],
'球'=>['zh_cn','zh_tw',],
'理'=>['zh','zh_cn','zh_tw',],
'琪'=>['zh',],
'琳'=>['zh',],
'瑞'=>['zh_cn','zh_tw',],
'瑟'=>['zh_tw',],
'瑪'=>['zh_tw',],
'瓊'=>['zh_tw',],
'瓣'=>['zh_tw',],
'瓦'=>['zh_cn','zh_tw',],
'甚至'=>['zh','zh_cn','zh_tw',],
'甚麼'=>['zh_tw',],
'生'=>['zh','zh_cn','zh_tw',],
'生了'=>['zh','zh_cn',],
'生命'=>['zh_cn','zh_tw',],
'生活'=>['zh','zh_cn','zh_tw',],
'生的'=>['zh','zh_cn',],
'用'=>['zh','zh_cn','zh_tw',],
'由'=>['zh','zh_cn','zh_tw',],
'电'=>['zh_cn',],
'电脑'=>['zh',],
'电话'=>['zh','zh_cn',],
'电话号码'=>['zh',],
'电话报'=>['zh',],
'男'=>['zh','zh_tw',],
'男人'=>['zh_cn','zh_tw',],
'男子'=>['zh',],
'男孩'=>['zh','zh_cn','zh_tw',],
'男的'=>['zh',],
'画'=>['zh_cn',],
'留'=>['zh','zh_cn',],
'留下'=>['zh','zh_cn','zh_tw',],
'留言'=>['zh',],
'畫'=>['zh_tw',],
'當'=>['zh_tw',],
'當時'=>['zh_tw',],
'當然'=>['zh_tw',],
'疆'=>['zh_tw',],
'疇'=>['zh_tw',],
'疑'=>['zh_cn',],
'疯'=>['zh','zh_cn',],
'瘋了'=>['zh_tw',],
'瘋狂'=>['zh_tw',],
'癒'=>['zh_tw',],
'登'=>['zh','zh_cn','zh_tw',],
'發'=>['zh_tw',],
'發現'=>['zh_tw',],
'發生'=>['zh_tw',],
'發生了'=>['zh_tw',],
'白'=>['zh_cn','zh_tw',],
'白人'=>['zh',],
'的'=>['zh','zh_cn','zh_tw',],
'的時候'=>['zh_tw',],
'的話'=>['zh_tw',],
'皮'=>['zh_cn','zh_tw',],
'皮毛'=>['zh',],
'监视'=>['zh',],
'目'=>['zh','zh_cn',],
'目標'=>['zh_tw',],
'直'=>['zh_cn',],
'直到'=>['zh_cn','zh_tw',],
'相'=>['zh','zh_cn',],
'相信'=>['zh','zh_cn','zh_tw',],
'看'=>['zh','zh_cn','zh_tw',],
'看來'=>['zh_tw',],
'看出'=>['zh',],
'看到'=>['zh','zh_cn','zh_tw',],
'看吧'=>['zh',],
'看看'=>['zh','zh_cn','zh_tw',],
'看著'=>['zh_tw',],
'看見'=>['zh_tw',],
'看起來'=>['zh_tw',],
'看過'=>['zh_tw',],
'真'=>['zh','zh_cn','zh_tw',],
'真不'=>['zh','zh_cn','zh_tw',],
'真人'=>['zh',],
'真好'=>['zh_tw',],
'真是'=>['zh','zh_cn','zh_tw',],
'真正'=>['zh_cn','zh_tw',],
'真的'=>['zh','zh_cn','zh_tw',],
'眼'=>['zh_cn',],
'眼熟'=>['zh',],
'眼睛'=>['zh_cn','zh_tw',],
'着'=>['zh','zh_cn',],
'着写'=>['zh',],
'睡'=>['zh','zh_cn',],
'睡覺'=>['zh_tw',],
'瞭'=>['zh_tw',],
'矛'=>['zh_tw',],
'知'=>['zh_cn',],
'知道'=>['zh','zh_cn','zh_tw',],
'石'=>['zh_cn',],
'研究'=>['zh',],
'破'=>['zh_cn',],
'确'=>['zh','zh_cn',],
'碰'=>['zh','zh_cn','zh_tw',],
'確定'=>['zh_tw',],
'確實'=>['zh_tw',],
'礼'=>['zh_cn',],
'社'=>['zh',],
'社工'=>['zh',],
'祝你'=>['zh',],
'神'=>['zh_cn','zh_tw',],
'票'=>['zh_cn',],
'福'=>['zh_cn','zh_tw',],
'离'=>['zh','zh_cn',],
'私'=>['zh',],
'私人'=>['zh',],
'种'=>['zh','zh_cn',],
'科'=>['zh','zh_cn','zh_tw',],
'秒'=>['zh',],
'秘密'=>['zh_cn','zh_tw',],
'稳'=>['zh',],
'穩'=>['zh_tw',],
'空'=>['zh','zh_cn',],
'穿'=>['zh_cn','zh_tw',],
'穿越'=>['zh',],
'窗'=>['zh',],
'站'=>['zh','zh_cn',],
'童'=>['zh',],
'笑'=>['zh_cn','zh_tw',],
'笔录'=>['zh',],
'笔电吗'=>['zh',],
'笔记录'=>['zh',],
'第'=>['zh_tw',],
'第一'=>['zh_cn','zh_tw',],
'第一手'=>['zh',],
'第一次'=>['zh','zh_cn','zh_tw',],
'等'=>['zh','zh_cn','zh_tw',],
'等了'=>['zh',],
'等嘟'=>['zh',],
'等等'=>['zh','zh_cn','zh_tw',],
'答'=>['zh_cn',],
'答應'=>['zh_tw',],
'答案'=>['zh',],
'简'=>['zh_cn',],
'算'=>['zh','zh_cn','zh_tw',],
'算了'=>['zh',],
'算是'=>['zh',],
'管'=>['zh_cn','zh_tw',],
'箱'=>['zh',],
'篇'=>['zh',],
'簡單'=>['zh_tw',],
'籀'=>['zh_tw',],
'米'=>['zh_cn','zh_tw',],
'类'=>['zh_cn',],
'类为动'=>['zh',],
'精彩'=>['zh',],
'精神'=>['zh_tw',],
'糟糕'=>['zh',],
'系'=>['zh','zh_cn',],
'約翰'=>['zh_tw',],
'紅'=>['zh_tw',],
'納'=>['zh_tw',],
'紐約'=>['zh_tw',],
'索'=>['zh_cn',],
'紧'=>['zh','zh_cn',],
'組'=>['zh_tw',],
'結婚'=>['zh_tw',],
'結束'=>['zh_tw',],
'結果'=>['zh_tw',],
'絕對'=>['zh_tw',],
'給'=>['zh_tw',],
'絲'=>['zh_tw',],
'維'=>['zh_tw',],
'總是'=>['zh_tw',],
'總統'=>['zh_tw',],
'繪'=>['zh_tw',],
'繭'=>['zh_tw',],
'繳'=>['zh_tw',],
'繹'=>['zh_tw',],
'繼續'=>['zh_tw',],
'纠'=>['zh',],
'红'=>['zh_cn',],
'约'=>['zh','zh_cn',],
'级'=>['zh_cn',],
'纳'=>['zh_cn',],
'纸'=>['zh',],
'纹'=>['zh',],
'线'=>['zh_cn',],
'组'=>['zh','zh_cn',],
'组织'=>['zh',],
'细节'=>['zh',],
'终'=>['zh_cn',],
'经'=>['zh','zh_cn',],
'经验'=>['zh',],
'结'=>['zh','zh_cn',],
'给'=>['zh','zh_cn',],
'给贝'=>['zh',],
'绝'=>['zh_cn',],
'绝对'=>['zh',],
'统'=>['zh_cn',],
'继续'=>['zh_cn',],
'续'=>['zh',],
'维'=>['zh','zh_cn',],
'维尔'=>['zh',],
'缴'=>['zh',],
'网'=>['zh','zh_cn',],
'罗'=>['zh_cn',],
'罢'=>['zh',],
'罪犯'=>['zh',],
'羅'=>['zh_tw',],
'美'=>['zh','zh_cn','zh_tw',],
'美元'=>['zh_tw',],
'美國'=>['zh_tw',],
'翰'=>['zh_cn',],
'翻'=>['zh_cn',],
'翻身'=>['zh',],
'老'=>['zh','zh_cn','zh_tw',],
'老兄'=>['zh','zh_cn','zh_tw',],
'老友'=>['zh',],
'老天'=>['zh_cn',],
'老婆'=>['zh','zh_tw',],
'老爸'=>['zh_tw',],
'考'=>['zh_cn',],
'者'=>['zh','zh_cn','zh_tw',],
'而'=>['zh','zh_cn','zh_tw',],
'而且'=>['zh','zh_cn','zh_tw',],
'而已'=>['zh_cn','zh_tw',],
'耶'=>['zh_cn','zh_tw',],
'职'=>['zh',],
'联'=>['zh','zh_cn',],
'联络'=>['zh',],
'聪'=>['zh_cn',],
'聰明'=>['zh_tw',],
'聲'=>['zh_tw',],
'聲音'=>['zh_tw',],
'聽'=>['zh_tw',],
'聽到'=>['zh_tw',],
'聽著'=>['zh_tw',],
'聽說'=>['zh_tw',],
'肮'=>['zh',],
'肯'=>['zh_tw',],
'肯定'=>['zh','zh_cn','zh_tw',],
'胁'=>['zh_cn',],
'背叛'=>['zh',],
'胜'=>['zh_cn',],
'胡'=>['zh_cn',],
'能'=>['zh','zh_cn','zh_tw',],
'能不能'=>['zh_cn','zh_tw',],
'能力'=>['zh',],
'能夠'=>['zh_tw',],
'脏'=>['zh',],
'脑'=>['zh_cn',],
'脚'=>['zh_cn',],
'脱'=>['zh_cn',],
'脸'=>['zh','zh_cn',],
'腔'=>['zh_tw',],
'膩'=>['zh_tw',],
'臉'=>['zh_tw',],
'自'=>['zh','zh_cn',],
'自己'=>['zh_cn','zh_tw',],
'自己的'=>['zh_cn','zh_tw',],
'自由'=>['zh_cn','zh_tw',],
'至少'=>['zh','zh_cn','zh_tw',],
'與'=>['zh_tw',],
'舞'=>['zh_cn',],
'船'=>['zh_cn','zh_tw',],
'色'=>['zh_cn',],
'艾'=>['zh','zh_cn','zh_tw',],
'节'=>['zh_cn',],
'芯'=>['zh_cn',],
'花'=>['zh_cn','zh_tw',],
'苏'=>['zh_cn',],
'英'=>['zh_cn',],
'英雄'=>['zh',],
'茅'=>['zh_tw',],
'茲'=>['zh_tw',],
'草率'=>['zh',],
'药'=>['zh_cn',],
'莉'=>['zh','zh_cn','zh_tw',],
'莎'=>['zh','zh_cn','zh_tw',],
'莫'=>['zh_cn','zh_tw',],
'莱'=>['zh_cn',],
'莱顿'=>['zh',],
'获'=>['zh',],
'菕'=>['zh_tw',],
'華'=>['zh_tw',],
'菲'=>['zh_cn','zh_tw',],
'萊'=>['zh_tw',],
'萨'=>['zh_cn',],
'萬'=>['zh_tw',],
'著'=>['zh_tw',],
'著作'=>['zh',],
'蒂'=>['zh_cn','zh_tw',],
'蒙'=>['zh_cn','zh_tw',],
'蓋'=>['zh_tw',],
'薩'=>['zh_tw',],
'薪'=>['zh_cn',],
'薪水'=>['zh',],
'蘇'=>['zh_tw',],
'蘭'=>['zh_tw',],
'虐'=>['zh',],
'處理'=>['zh_tw',],
'號'=>['zh_tw',],
'虽'=>['zh_cn',],
'蛋'=>['zh_cn','zh_tw',],
'蟹'=>['zh_cn',],
'血'=>['zh','zh_cn','zh_tw',],
'行'=>['zh','zh_cn','zh_tw',],
'行了'=>['zh_cn',],
'行動'=>['zh_tw',],
'街'=>['zh',],
'衣服'=>['zh','zh_cn','zh_tw',],
'表'=>['zh_cn',],
'衷'=>['zh',],
'被'=>['zh','zh_cn','zh_tw',],
'被指'=>['zh',],
'装'=>['zh_cn',],
'裏'=>['zh_tw',],
'裡'=>['zh_tw',],
'裡面'=>['zh_tw',],
'褉'=>['zh_cn',],
'褋'=>['zh_cn',],
'褌'=>['zh_cn',],
'褍'=>['zh_cn',],
'褕'=>['zh_cn',],
'褬'=>['zh_cn',],
'西'=>['zh','zh_cn','zh_tw',],
'要'=>['zh','zh_cn','zh_tw',],
'要找'=>['zh',],
'要是'=>['zh_cn','zh_tw',],
'要求'=>['zh_cn','zh_tw',],
'見'=>['zh_tw',],
'見到'=>['zh_tw',],
'見過'=>['zh_tw',],
'親愛的'=>['zh_tw',],
'覺得'=>['zh_tw',],
'见'=>['zh','zh_cn',],
'见过'=>['zh_cn',],
'规'=>['zh_cn',],
'觉'=>['zh','zh_cn',],
'解'=>['zh','zh_cn','zh_tw',],
'解決'=>['zh_tw',],
'解釋'=>['zh_tw',],
'言'=>['zh_cn',],
'計'=>['zh_tw',],
'計劃'=>['zh_tw',],
'討厭'=>['zh_tw',],
'託'=>['zh_tw',],
'記住'=>['zh_tw',],
'記得'=>['zh_tw',],
'話'=>['zh_tw',],
'該'=>['zh_tw',],
'該死'=>['zh_tw',],
'詹'=>['zh',],
'認為'=>['zh_tw',],
'認識'=>['zh_tw',],
'誓'=>['zh',],
'說'=>['zh_tw',],
'說了'=>['zh_tw',],
'說得'=>['zh_tw',],
'說的'=>['zh_tw',],
'說話'=>['zh_tw',],
'說過'=>['zh_tw',],
'誰'=>['zh_tw',],
'調查'=>['zh_tw',],
'談'=>['zh_tw',],
'談談'=>['zh_tw',],
'請'=>['zh_tw',],
'請你'=>['zh_tw',],
'諾'=>['zh_tw',],
'講'=>['zh_tw',],
'謝'=>['zh_tw',],
'謝謝'=>['zh_tw',],
'謝謝你'=>['zh_tw',],
'證'=>['zh_tw',],
'警'=>['zh','zh_cn',],
'警告'=>['zh',],
'警察'=>['zh','zh_cn','zh_tw',],
'警局'=>['zh',],
'變得'=>['zh_tw',],
'變成'=>['zh_tw',],
'讓'=>['zh_tw',],
'计'=>['zh','zh_cn',],
'计书'=>['zh',],
'认'=>['zh','zh_cn',],
'认为'=>['zh','zh_cn',],
'认识'=>['zh','zh_cn',],
'讨厌'=>['zh',],
'让'=>['zh','zh_cn',],
'让贝'=>['zh',],
'议'=>['zh_cn',],
'记'=>['zh','zh_cn',],
'记吗'=>['zh',],
'记录'=>['zh',],
'讲'=>['zh_cn',],
'许'=>['zh','zh_cn',],
'许为'=>['zh',],
'许这'=>['zh',],
'访'=>['zh',],
'访时认识'=>['zh',],
'访杀'=>['zh',],
'访记'=>['zh',],
'访问'=>['zh',],
'访问吗'=>['zh',],
'访问结'=>['zh',],
'证'=>['zh','zh_cn',],
'证会'=>['zh',],
'评'=>['zh',],
'识'=>['zh_cn',],
'诉'=>['zh','zh_cn',],
'试着'=>['zh',],
'话'=>['zh','zh_cn',],
'该'=>['zh','zh_cn',],
'语'=>['zh','zh_cn',],
'说'=>['zh','zh_cn',],
'说话'=>['zh','zh_cn',],
'说过'=>['zh','zh_cn',],
'请'=>['zh','zh_cn',],
'请还'=>['zh',],
'诺'=>['zh_cn',],
'谁'=>['zh','zh_cn',],
'谁会这样对'=>['zh',],
'谁来'=>['zh',],
'调'=>['zh','zh_cn',],
'谈'=>['zh','zh_cn',],
'谈谈'=>['zh',],
'谈过'=>['zh',],
'谋'=>['zh',],
'谋杀'=>['zh',],
'谐'=>['zh_cn',],
'谢'=>['zh','zh_cn',],
'谢谢'=>['zh','zh_cn',],
'象'=>['zh','zh_cn',],
'貝'=>['zh_tw',],
'買'=>['zh_tw',],
'費'=>['zh_tw',],
'賽'=>['zh_tw',],
'贏'=>['zh_tw',],
'贝'=>['zh','zh_cn',],
'负责'=>['zh',],
'责'=>['zh',],
'败'=>['zh_cn',],
'费'=>['zh','zh_cn',],
'贺尔'=>['zh',],
'资'=>['zh','zh_cn',],
'赌'=>['zh',],
'赛'=>['zh_cn',],
'赢'=>['zh_cn',],
'走'=>['zh','zh_cn','zh_tw',],
'走了'=>['zh','zh_cn','zh_tw',],
'走吧'=>['zh_cn','zh_tw',],
'赶'=>['zh','zh_cn',],
'起'=>['zh','zh_cn','zh_tw',],
'起來'=>['zh_tw',],
'超'=>['zh_cn',],
'越'=>['zh_cn',],
'趣'=>['zh_cn',],
'足'=>['zh_cn',],
'趴下'=>['zh',],
'跑'=>['zh_cn','zh_tw',],
'跑去'=>['zh',],
'跟'=>['zh','zh_cn','zh_tw',],
'跟著'=>['zh_tw',],
'路'=>['zh','zh_cn','zh_tw',],
'路易斯'=>['zh',],
'跳'=>['zh_cn','zh_tw',],
'踪'=>['zh','zh_cn',],
'身'=>['zh','zh_cn',],
'身上'=>['zh_cn','zh_tw',],
'身份'=>['zh',],
'身體'=>['zh_tw',],
'身高'=>['zh',],
'車'=>['zh_tw',],
'车'=>['zh_cn',],
'转'=>['zh_cn',],
'轻'=>['zh','zh_cn',],
'较'=>['zh',],
'辜'=>['zh',],
'辦公室'=>['zh_tw',],
'辦法'=>['zh_tw',],
'边'=>['zh','zh_cn',],
'达'=>['zh_cn',],
'过'=>['zh','zh_cn',],
'过来'=>['zh','zh_cn',],
'迎'=>['zh','zh_cn',],
'运'=>['zh','zh_cn',],
'还'=>['zh','zh_cn',],
'还没'=>['zh','zh_cn',],
'这'=>['zh','zh_cn',],
'这个'=>['zh','zh_cn',],
'这样'=>['zh','zh_cn',],
'这样书'=>['zh',],
'这样对'=>['zh',],
'进'=>['zh','zh_cn',],
'进来'=>['zh','zh_cn',],
'远'=>['zh','zh_cn',],
'违'=>['zh',],
'连'=>['zh_cn',],
'连续杀'=>['zh',],
'迟'=>['zh_cn',],
'迪'=>['zh_cn','zh_tw',],
'迹'=>['zh',],
'追'=>['zh','zh_cn',],
'送'=>['zh','zh_cn','zh_tw',],
'送去'=>['zh',],
'送回'=>['zh',],
'适'=>['zh_cn',],
'选'=>['zh_cn',],
'选择'=>['zh_cn',],
'逐出'=>['zh',],
'這'=>['zh_tw',],
'這些'=>['zh_tw',],
'這件'=>['zh_tw',],
'這位'=>['zh_tw',],
'這個'=>['zh_tw',],
'這兒'=>['zh_tw',],
'這樣'=>['zh_tw',],
'這次'=>['zh_tw',],
'這種'=>['zh_tw',],
'這裡'=>['zh_tw',],
'這邊'=>['zh_tw',],
'這麼'=>['zh_tw',],
'通'=>['zh_cn',],
'通過'=>['zh_tw',],
'造成'=>['zh',],
'連'=>['zh_tw',],
'逮'=>['zh',],
'週'=>['zh_tw',],
'進'=>['zh_tw',],
'進來'=>['zh_tw',],
'進入'=>['zh_tw',],
'進去'=>['zh_tw',],
'進行'=>['zh_tw',],
'遇害'=>['zh',],
'遊'=>['zh_tw',],
'過'=>['zh_tw',],
'過來'=>['zh_tw',],
'過去'=>['zh_tw',],
'道'=>['zh_cn','zh_tw',],
'道上'=>['zh',],
'道德'=>['zh',],
'達'=>['zh_tw',],
'選擇'=>['zh_tw',],
'還'=>['zh_tw',],
'還不'=>['zh_tw',],
'還在'=>['zh_tw',],
'還好'=>['zh_tw',],
'還是'=>['zh_tw',],
'還有'=>['zh_tw',],
'還沒'=>['zh_tw',],
'還要'=>['zh_tw',],
'邊'=>['zh_tw',],
'那'=>['zh','zh_cn','zh_tw',],
'那些'=>['zh','zh_cn','zh_tw',],
'那件'=>['zh',],
'那份'=>['zh',],
'那個'=>['zh_tw',],
'那兒'=>['zh_tw',],
'那家'=>['zh',],
'那樣'=>['zh_tw',],
'那種'=>['zh_tw',],
'那裡'=>['zh_tw',],
'那麼'=>['zh_tw',],
'邦'=>['zh',],
'邪'=>['zh','zh_cn',],
'郎'=>['zh',],
'部'=>['zh_cn','zh_tw',],
'部分'=>['zh',],
'都'=>['zh','zh_cn','zh_tw',],
'都不'=>['zh_cn','zh_tw',],
'都會'=>['zh_tw',],
'都行'=>['zh',],
'都跟'=>['zh',],
'酒'=>['zh_cn','zh_tw',],
'酒吧'=>['zh',],
'酷'=>['zh','zh_cn',],
'醫生'=>['zh_tw',],
'醫院'=>['zh_tw',],
'采'=>['zh',],
'释'=>['zh_cn',],
'里'=>['zh','zh_cn','zh_tw',],
'重'=>['zh','zh_cn',],
'重新'=>['zh',],
'重要的'=>['zh',],
'量'=>['zh_cn',],
'金'=>['zh_cn','zh_tw',],
'銀行'=>['zh_tw',],
'錢'=>['zh_tw',],
'錯'=>['zh_tw',],
'鐘'=>['zh_tw',],
'针对'=>['zh',],
'钟'=>['zh','zh_cn',],
'钱'=>['zh_cn',],
'锁'=>['zh',],
'锌'=>['zh_cn',],
'错'=>['zh','zh_cn',],
'错误'=>['zh',],
'長'=>['zh_tw',],
'長官'=>['zh_tw',],
'长'=>['zh','zh_cn',],
'門'=>['zh_tw',],
'閉嘴'=>['zh_tw',],
'開'=>['zh_tw',],
'開始'=>['zh_tw',],
'開心'=>['zh_tw',],
'開槍'=>['zh_tw',],
'開玩笑'=>['zh_tw',],
'關'=>['zh_tw',],
'關於'=>['zh_tw',],
'门'=>['zh','zh_cn',],
'闭'=>['zh_cn',],
'问'=>['zh','zh_cn',],
'问题'=>['zh','zh_cn',],
'间'=>['zh_cn',],
'闹'=>['zh',],
'闻'=>['zh_cn',],
'队'=>['zh_cn',],
'阻止'=>['zh','zh_tw',],
'阿'=>['zh_cn','zh_tw',],
'阿姨'=>['zh',],
'院'=>['zh','zh_cn',],
'除了'=>['zh_cn','zh_tw',],
'除非'=>['zh',],
'险'=>['zh_cn',],
'陪'=>['zh',],
'隊'=>['zh_tw',],
'随'=>['zh','zh_cn',],
'随时'=>['zh',],
'随时随'=>['zh',],
'隐'=>['zh',],
'隨便'=>['zh_tw',],
'难'=>['zh','zh_cn',],
'难过'=>['zh',],
'雖然'=>['zh_tw',],
'離'=>['zh_tw',],
'離開'=>['zh_tw',],
'難'=>['zh_tw',],
'難道'=>['zh_tw',],
'雷'=>['zh','zh_cn','zh_tw',],
'電影'=>['zh_tw',],
'電話'=>['zh_tw',],
'需要'=>['zh','zh_cn','zh_tw',],
'霉'=>['zh_tw',],
'霍'=>['zh_cn',],
'静'=>['zh_cn',],
'非常'=>['zh','zh_cn','zh_tw',],
'非法'=>['zh',],
'靠'=>['zh','zh_cn','zh_tw',],
'靠近'=>['zh',],
'面'=>['zh','zh_cn','zh_tw',],
'音'=>['zh_cn',],
'音信'=>['zh',],
'音樂'=>['zh_tw',],
'頓'=>['zh_tw',],
'頭'=>['zh_tw',],
'願意'=>['zh_tw',],
'類'=>['zh_tw',],
'顺变'=>['zh',],
'须'=>['zh','zh_cn',],
'须亲'=>['zh',],
'顾'=>['zh_cn',],
'顿'=>['zh_cn',],
'领'=>['zh_cn',],
'风'=>['zh_cn',],
'飛'=>['zh_tw',],
'飛機'=>['zh_tw',],
'飞'=>['zh_cn',],
'食物'=>['zh',],
'饭'=>['zh_cn',],
'馆'=>['zh_cn',],
'馬'=>['zh_tw',],
'馬上'=>['zh_tw',],
'马'=>['zh','zh_cn',],
'骗'=>['zh_cn',],
'體'=>['zh_tw',],
'高'=>['zh','zh_cn','zh_tw',],
'高興'=>['zh_tw',],
'髮'=>['zh_tw',],
'鬃'=>['zh_tw',],
'鬥'=>['zh_tw',],
'鬼'=>['zh_cn','zh_tw',],
'魔'=>['zh',],
'魚'=>['zh_tw',],
'魯'=>['zh_tw',],
'鱼'=>['zh',],
'鲁'=>['zh','zh_cn',],
'鸡'=>['zh_cn',],
'鹅'=>['zh',],
'麗'=>['zh_tw',],
'麥'=>['zh_tw',],
'麥克'=>['zh_tw',],
'麦'=>['zh_cn',],
'麻'=>['zh','zh_cn',],
'麻煩'=>['zh_tw',],
'麼'=>['zh_tw',],
'麽'=>['zh_cn','zh_tw',],
'黏'=>['zh',],
'黑'=>['zh_cn','zh_tw',],
'黑暗'=>['zh',],
'點'=>['zh_tw',],
'齐'=>['zh',],
'가'=>['ko',],
'가고'=>['ko',],
'가너'=>['ko',],
'가는'=>['ko',],
'가면'=>['ko',],
'가서'=>['ko',],
'가야'=>['ko',],
'가요'=>['ko',],
'가자'=>['ko',],
'가장'=>['ko',],
'가족과'=>['ko',],
'가족이'=>['ko',],
'가지'=>['ko',],
'가지고'=>['ko',],
'간다'=>['ko',],
'간호사'=>['ko',],
'갈'=>['ko',],
'갈거야'=>['ko',],
'감사합니다'=>['ko',],
'갑자기'=>['ko',],
'갔다'=>['ko',],
'갔어'=>['ko',],
'갖고'=>['ko',],
'같다'=>['ko',],
'같습니다'=>['ko',],
'같아'=>['ko',],
'같아요'=>['ko',],
'같은'=>['ko',],
'같은데'=>['ko',],
'같이'=>['ko',],
'걍'=>['ko',],
'거'=>['ko',],
'거기'=>['ko',],
'거기서'=>['ko',],
'거기에'=>['ko',],
'거라'=>['ko',],
'거라고'=>['ko',],
'거야'=>['ko',],
'거에요'=>['ko',],
'거예요'=>['ko',],
'거의'=>['ko',],
'거죠'=>['ko',],
'거지'=>['ko',],
'걱정'=>['ko',],
'건'=>['ko',],
'걸'=>['ko',],
'겁니다'=>['ko',],
'것'=>['ko',],
'것도'=>['ko',],
'것을'=>['ko',],
'것입니다'=>['ko',],
'것처럼'=>['ko',],
'게'=>['ko',],
'게다가'=>['ko',],
'겠어'=>['ko',],
'결혼'=>['ko',],
'결혼식'=>['ko',],
'경찰이'=>['ko',],
'계속'=>['ko',],
'고마워'=>['ko',],
'고마워요'=>['ko',],
'고맙습니다'=>['ko',],
'곧'=>['ko',],
'괜찮'=>['ko',],
'괜찮아'=>['ko',],
'괜찮아요'=>['ko',],
'괜찮을거야'=>['ko',],
'귀하의'=>['ko',],
'그'=>['ko',],
'그가'=>['ko',],
'그거'=>['ko',],
'그건'=>['ko',],
'그걸'=>['ko',],
'그것'=>['ko',],
'그것도'=>['ko',],
'그것에'=>['ko',],
'그것은'=>['ko',],
'그것을'=>['ko',],
'그것이'=>['ko',],
'그게'=>['ko',],
'그냥'=>['ko',],
'그녀가'=>['ko',],
'그녀는'=>['ko',],
'그녀를'=>['ko',],
'그녀의'=>['ko',],
'그는'=>['ko',],
'그들은'=>['ko',],
'그들이'=>['ko',],
'그래'=>['ko',],
'그래도'=>['ko',],
'그래서'=>['ko',],
'그래요'=>['ko',],
'그러니까'=>['ko',],
'그런'=>['ko',],
'그런데'=>['ko',],
'그럴'=>['ko',],
'그럼'=>['ko',],
'그럼요'=>['ko',],
'그렇게'=>['ko',],
'그렇지'=>['ko',],
'그를'=>['ko',],
'그리'=>['ko',],
'그리고'=>['ko',],
'그만'=>['ko',],
'그에게'=>['ko',],
'그의'=>['ko',],
'근데'=>['ko',],
'글쎄'=>['ko',],
'기다려'=>['ko',],
'기다리고'=>['ko',],
'기도를'=>['ko',],
'기분'=>['ko',],
'기분이'=>['ko',],
'기억'=>['ko',],
'기억이'=>['ko',],
'꼭'=>['ko',],
'꽤'=>['ko',],
'나'=>['ko',],
'나가'=>['ko',],
'나는'=>['ko',],
'나도'=>['ko',],
'나랑'=>['ko',],
'나를'=>['ko',],
'나쁜'=>['ko',],
'나야'=>['ko',],
'나에게'=>['ko',],
'나와'=>['ko',],
'나중에'=>['ko',],
'나한테'=>['ko',],
'난'=>['ko',],
'날'=>['ko',],
'남자'=>['ko',],
'남자가'=>['ko',],
'내'=>['ko',],
'내가'=>['ko',],
'내게'=>['ko',],
'내내'=>['ko',],
'내려'=>['ko',],
'내일'=>['ko',],
'너'=>['ko',],
'너도'=>['ko',],
'너무'=>['ko',],
'너희'=>['ko',],
'넌'=>['ko',],
'널'=>['ko',],
'넣어'=>['ko',],
'네'=>['ko',],
'네가'=>['ko',],
'네요'=>['ko',],
'네이트'=>['ko',],
'년'=>['ko',],
'놈'=>['ko',],
'누가'=>['ko',],
'누구'=>['ko',],
'누구야'=>['ko',],
'누군가가'=>['ko',],
'눈을'=>['ko',],
'는'=>['ko',],
'니'=>['ko',],
'니가'=>['ko',],
'니들'=>['ko',],
'닉'=>['ko',],
'다'=>['ko',],
'다들'=>['ko',],
'다른'=>['ko',],
'다시'=>['ko',],
'다예요'=>['ko',],
'다음'=>['ko',],
'다음에'=>['ko',],
'닥쳐'=>['ko',],
'단지'=>['ko',],
'달림플'=>['ko',],
'당신'=>['ko',],
'당신과'=>['ko',],
'당신도'=>['ko',],
'당신에게'=>['ko',],
'당신은'=>['ko',],
'당신을'=>['ko',],
'당신의'=>['ko',],
'당신이'=>['ko',],
'당장'=>['ko',],
'대령'=>['ko',],
'대령님'=>['ko',],
'대령이'=>['ko',],
'대신'=>['ko',],
'대체'=>['ko',],
'대한'=>['ko',],
'대해'=>['ko',],
'대해서'=>['ko',],
'더'=>['ko',],
'더그'=>['ko',],
'더그는'=>['ko',],
'더이상'=>['ko',],
'데'=>['ko',],
'데려'=>['ko',],
'도대체'=>['ko',],
'도와'=>['ko',],
'도움이'=>['ko',],
'돈'=>['ko',],
'돈을'=>['ko',],
'돈이'=>['ko',],
'돌아'=>['ko',],
'동생이'=>['ko',],
'동안'=>['ko',],
'돼'=>['ko',],
'돼요'=>['ko',],
'됐어'=>['ko',],
'됐어요'=>['ko',],
'되는'=>['ko',],
'된'=>['ko',],
'될'=>['ko',],
'될거야'=>['ko',],
'됩니다'=>['ko',],
'두'=>['ko',],
'두드리는'=>['ko',],
'둘'=>['ko',],
'둘이'=>['ko',],
'드릴까요'=>['ko',],
'들고'=>['ko',],
'들어'=>['ko',],
'들어가'=>['ko',],
'들어봐'=>['ko',],
'들었어요'=>['ko',],
'듯'=>['ko',],
'딱'=>['ko',],
'딴'=>['ko',],
'때'=>['ko',],
'때문에'=>['ko',],
'땐'=>['ko',],
'떠나'=>['ko',],
'떨어져'=>['ko',],
'또'=>['ko',],
'또는'=>['ko',],
'또한'=>['ko',],
'똥'=>['ko',],
'뜻'=>['ko',],
'라고'=>['ko',],
'라마'=>['ko',],
'램'=>['ko',],
'러셀'=>['ko',],
'레이'=>['ko',],
'루이자'=>['ko',],
'를'=>['ko',],
'마'=>['ko',],
'마세요'=>['ko',],
'마십시오'=>['ko',],
'마약'=>['ko',],
'마음을'=>['ko',],
'마음이'=>['ko',],
'마이크'=>['ko',],
'마지막'=>['ko',],
'마치'=>['ko',],
'막'=>['ko',],
'만약'=>['ko',],
'만요'=>['ko',],
'많은'=>['ko',],
'많이'=>['ko',],
'말'=>['ko',],
'말고'=>['ko',],
'말도'=>['ko',],
'말씀을'=>['ko',],
'말아요'=>['ko',],
'말야'=>['ko',],
'말은'=>['ko',],
'말을'=>['ko',],
'말이'=>['ko',],
'말이야'=>['ko',],
'말이죠'=>['ko',],
'말이지'=>['ko',],
'말입니다'=>['ko',],
'말하는'=>['ko',],
'말하지'=>['ko',],
'말할'=>['ko',],
'말해'=>['ko',],
'말했다'=>['ko',],
'맘이'=>['ko',],
'맙소사'=>['ko',],
'망할'=>['ko',],
'맞습니다'=>['ko',],
'맞아'=>['ko',],
'맞아요'=>['ko',],
'맞죠'=>['ko',],
'맞지'=>['ko',],
'매우'=>['ko',],
'매일'=>['ko',],
'머스그로브'=>['ko',],
'먹고'=>['ko',],
'먼저'=>['ko',],
'멋진'=>['ko',],
'몇'=>['ko',],
'모두'=>['ko',],
'모두가'=>['ko',],
'모두들'=>['ko',],
'모든'=>['ko',],
'모르겠어'=>['ko',],
'모르겠어요'=>['ko',],
'몰라'=>['ko',],
'몰라요'=>['ko',],
'몸'=>['ko',],
'못'=>['ko',],
'무슨'=>['ko',],
'무엇을'=>['ko',],
'무엇입니까'=>['ko',],
'문'=>['ko',],
'문을'=>['ko',],
'문제가'=>['ko',],
'물론'=>['ko',],
'뭐'=>['ko',],
'뭐가'=>['ko',],
'뭐라'=>['ko',],
'뭐라고'=>['ko',],
'뭐야'=>['ko',],
'뭐요'=>['ko',],
'뭔'=>['ko',],
'뭔가'=>['ko',],
'뭔가를'=>['ko',],
'뭔데'=>['ko',],
'뭘'=>['ko',],
'미안'=>['ko',],
'미안해'=>['ko',],
'미친'=>['ko',],
'믿을'=>['ko',],
'및'=>['ko',],
'바랍니다'=>['ko',],
'바로'=>['ko',],
'바보'=>['ko',],
'바비'=>['ko',],
'바스에'=>['ko',],
'밖으로'=>['ko',],
'받고'=>['ko',],
'받을'=>['ko',],
'밤'=>['ko',],
'밤에'=>['ko',],
'방'=>['ko',],
'방금'=>['ko',],
'방법'=>['ko',],
'방법이'=>['ko',],
'버려'=>['ko',],
'번'=>['ko',],
'벌써'=>['ko',],
'벤윅'=>['ko',],
'별거'=>['ko',],
'별로'=>['ko',],
'보고'=>['ko',],
'보면'=>['ko',],
'보여'=>['ko',],
'보자'=>['ko',],
'보지'=>['ko',],
'본'=>['ko',],
'볼'=>['ko',],
'봐'=>['ko',],
'봐요'=>['ko',],
'봤어'=>['ko',],
'부인'=>['ko',],
'분'=>['ko',],
'분명히'=>['ko',],
'분이'=>['ko',],
'빌어먹을'=>['ko',],
'빌어주소서'=>['ko',],
'빨리'=>['ko',],
'사람'=>['ko',],
'사람들은'=>['ko',],
'사람들을'=>['ko',],
'사람들이'=>['ko',],
'사람은'=>['ko',],
'사람을'=>['ko',],
'사람의'=>['ko',],
'사람이'=>['ko',],
'사람이야'=>['ko',],
'사랑'=>['ko',],
'사랑해'=>['ko',],
'사실'=>['ko',],
'사용'=>['ko',],
'살'=>['ko',],
'살고'=>['ko',],
'삶이'=>['ko',],
'상관'=>['ko',],
'새'=>['ko',],
'새로운'=>['ko',],
'생각'=>['ko',],
'생각은'=>['ko',],
'생각이'=>['ko',],
'생각하고'=>['ko',],
'생각하는'=>['ko',],
'생각하지'=>['ko',],
'생각해'=>['ko',],
'서'=>['ko',],
'서둘러'=>['ko',],
'서로'=>['ko',],
'선생님'=>['ko',],
'세'=>['ko',],
'세리나'=>['ko',],
'세상에'=>['ko',],
'셋'=>['ko',],
'소리'=>['ko',],
'손'=>['ko',],
'손을'=>['ko',],
'솔직히'=>['ko',],
'수'=>['ko',],
'수가'=>['ko',],
'수도'=>['ko',],
'수없습니다'=>['ko',],
'수있는'=>['ko',],
'수있습니다'=>['ko',],
'스튜'=>['ko',],
'시간'=>['ko',],
'시간을'=>['ko',],
'시간이'=>['ko',],
'시타'=>['ko',],
'신경'=>['ko',],
'실례합니다'=>['ko',],
'싫어'=>['ko',],
'심장'=>['ko',],
'심지어'=>['ko',],
'싶어'=>['ko',],
'싶어요'=>['ko',],
'싶은'=>['ko',],
'싶지'=>['ko',],
'씨'=>['ko',],
'씨발'=>['ko',],
'아'=>['ko',],
'아기'=>['ko',],
'아기를'=>['ko',],
'아냐'=>['ko',],
'아뇨'=>['ko',],
'아는'=>['ko',],
'아니'=>['ko',],
'아니라'=>['ko',],
'아니면'=>['ko',],
'아니야'=>['ko',],
'아니에요'=>['ko',],
'아니오'=>['ko',],
'아닌'=>['ko',],
'아들'=>['ko',],
'아름다운'=>['ko',],
'아마'=>['ko',],
'아마도'=>['ko',],
'아무'=>['ko',],
'아무것도'=>['ko',],
'아무도'=>['ko',],
'아버지'=>['ko',],
'아빠'=>['ko',],
'아빠가'=>['ko',],
'아요'=>['ko',],
'아이고'=>['ko',],
'아주'=>['ko',],
'아직'=>['ko',],
'아직도'=>['ko',],
'아침'=>['ko',],
'아침에'=>['ko',],
'안'=>['ko',],
'안녕'=>['ko',],
'안녕하세요'=>['ko',],
'안돼'=>['ko',],
'안돼요'=>['ko',],
'안에'=>['ko',],
'안으로'=>['ko',],
'않고'=>['ko',],
'않는'=>['ko',],
'않습니다'=>['ko',],
'않아'=>['ko',],
'않아요'=>['ko',],
'않았다'=>['ko',],
'않았어'=>['ko',],
'않으면'=>['ko',],
'않을'=>['ko',],
'않을거야'=>['ko',],
'알고'=>['ko',],
'알다시피'=>['ko',],
'알아'=>['ko',],
'알아서'=>['ko',],
'알아요'=>['ko',],
'알았어'=>['ko',],
'알았어요'=>['ko',],
'알았지'=>['ko',],
'알지'=>['ko',],
'앤'=>['ko',],
'앤디'=>['ko',],
'앤은'=>['ko',],
'앨런'=>['ko',],
'약'=>['ko',],
'얘기'=>['ko',],
'얘기를'=>['ko',],
'얘들아'=>['ko',],
'얘야'=>['ko',],
'어'=>['ko',],
'어느'=>['ko',],
'어디'=>['ko',],
'어디로'=>['ko',],
'어디서'=>['ko',],
'어디에'=>['ko',],
'어때'=>['ko',],
'어때요'=>['ko',],
'어떤'=>['ko',],
'어떻게'=>['ko',],
'어서'=>['ko',],
'어제'=>['ko',],
'어젯밤'=>['ko',],
'어젯밤에'=>['ko',],
'어쨌든'=>['ko',],
'어쩌면'=>['ko',],
'어찌'=>['ko',],
'언니'=>['ko',],
'언제'=>['ko',],
'얻을'=>['ko',],
'얼굴이'=>['ko',],
'얼마나'=>['ko',],
'엄마'=>['ko',],
'엄마가'=>['ko',],
'엄마와'=>['ko',],
'없고'=>['ko',],
'없는'=>['ko',],
'없다'=>['ko',],
'없다고'=>['ko',],
'없습니다'=>['ko',],
'없어'=>['ko',],
'없어요'=>['ko',],
'없을'=>['ko',],
'없이'=>['ko',],
'없지'=>['ko',],
'었어'=>['ko',],
'에'=>['ko',],
'엘리엇'=>['ko',],
'엘리엇씨'=>['ko',],
'엘리엇양'=>['ko',],
'여기'=>['ko',],
'여기서'=>['ko',],
'여기에'=>['ko',],
'여긴'=>['ko',],
'여길'=>['ko',],
'여러분'=>['ko',],
'여보'=>['ko',],
'여사님'=>['ko',],
'여자'=>['ko',],
'여자가'=>['ko',],
'여자를'=>['ko',],
'여전히'=>['ko',],
'영원히'=>['ko',],
'예'=>['ko',],
'예요'=>['ko',],
'오'=>['ko',],
'오는'=>['ko',],
'오늘'=>['ko',],
'오늘은'=>['ko',],
'오래'=>['ko',],
'오면'=>['ko',],
'온'=>['ko',],
'올'=>['ko',],
'와'=>['ko',],
'와서'=>['ko',],
'완벽한'=>['ko',],
'완전히'=>['ko',],
'왔다'=>['ko',],
'왔어요'=>['ko',],
'왜'=>['ko',],
'왜냐면'=>['ko',],
'왜냐하면'=>['ko',],
'우리'=>['ko',],
'우리가'=>['ko',],
'우리는'=>['ko',],
'우리를'=>['ko',],
'우리의'=>['ko',],
'우린'=>['ko',],
'우릴'=>['ko',],
'운전'=>['ko',],
'웃음'=>['ko',],
'원하는'=>['ko',],
'월터경'=>['ko',],
'웬트워스'=>['ko',],
'위하여'=>['ko',],
'위해'=>['ko',],
'위해서'=>['ko',],
'음'=>['ko',],
'음악'=>['ko',],
'응'=>['ko',],
'의'=>['ko',],
'의사'=>['ko',],
'의사가'=>['ko',],
'의해'=>['ko',],
'이'=>['ko',],
'이거'=>['ko',],
'이건'=>['ko',],
'이걸'=>['ko',],
'이것은'=>['ko',],
'이게'=>['ko',],
'이는'=>['ko',],
'이러한'=>['ko',],
'이런'=>['ko',],
'이렇게'=>['ko',],
'이름은'=>['ko',],
'이름을'=>['ko',],
'이름이'=>['ko',],
'이리'=>['ko',],
'이미'=>['ko',],
'이번'=>['ko',],
'이봐'=>['ko',],
'이상'=>['ko',],
'이상한'=>['ko',],
'이야기'=>['ko',],
'이제'=>['ko',],
'이젠'=>['ko',],
'이죠'=>['ko',],
'일'=>['ko',],
'일은'=>['ko',],
'일을'=>['ko',],
'일이'=>['ko',],
'일이야'=>['ko',],
'일이에요'=>['ko',],
'임마'=>['ko',],
'있고'=>['ko',],
'있나'=>['ko',],
'있나요'=>['ko',],
'있는'=>['ko',],
'있는데'=>['ko',],
'있는지'=>['ko',],
'있니'=>['ko',],
'있다'=>['ko',],
'있다고'=>['ko',],
'있다면'=>['ko',],
'있소'=>['ko',],
'있습니다'=>['ko',],
'있어'=>['ko',],
'있어요'=>['ko',],
'있었'=>['ko',],
'있었는데'=>['ko',],
'있었어'=>['ko',],
'있었어요'=>['ko',],
'있으면'=>['ko',],
'있을'=>['ko',],
'있을까요'=>['ko',],
'있잖아'=>['ko',],
'있죠'=>['ko',],
'있지'=>['ko',],
'자'=>['ko',],
'자기'=>['ko',],
'자동차'=>['ko',],
'자신을'=>['ko',],
'자신의'=>['ko',],
'작은'=>['ko',],
'잘'=>['ko',],
'잘못'=>['ko',],
'잠깐'=>['ko',],
'잠시'=>['ko',],
'잡아'=>['ko',],
'저'=>['ko',],
'저기'=>['ko',],
'저녁'=>['ko',],
'저는'=>['ko',],
'저도'=>['ko',],
'저를'=>['ko',],
'저리'=>['ko',],
'저희'=>['ko',],
'저희를'=>['ko',],
'적'=>['ko',],
'적어도'=>['ko',],
'적이'=>['ko',],
'전'=>['ko',],
'전부'=>['ko',],
'전에'=>['ko',],
'전자'=>['ko',],
'전혀'=>['ko',],
'전화'=>['ko',],
'전화를'=>['ko',],
'절대'=>['ko',],
'젊은'=>['ko',],
'정말'=>['ko',],
'정말로'=>['ko',],
'정말요'=>['ko',],
'제'=>['ko',],
'제가'=>['ko',],
'제니'=>['ko',],
'제대로'=>['ko',],
'제발'=>['ko',],
'젠장'=>['ko',],
'조금'=>['ko',],
'존나'=>['ko',],
'좀'=>['ko',],
'좋다'=>['ko',],
'좋아'=>['ko',],
'좋아요'=>['ko',],
'좋아하는'=>['ko',],
'좋아하지'=>['ko',],
'좋은'=>['ko',],
'좋은거야'=>['ko',],
'좋을'=>['ko',],
'죄송'=>['ko',],
'죄송합니다'=>['ko',],
'주님'=>['ko',],
'죽여'=>['ko',],
'죽을'=>['ko',],
'줄'=>['ko',],
'줄게'=>['ko',],
'중'=>['ko',],
'중에'=>['ko',],
'줘'=>['ko',],
'지금'=>['ko',],
'지금까지'=>['ko',],
'지금은'=>['ko',],
'지난'=>['ko',],
'직접'=>['ko',],
'진심으로'=>['ko',],
'진정해'=>['ko',],
'진짜'=>['ko',],
'짐'=>['ko',],
'집에'=>['ko',],
'집에서'=>['ko',],
'집을'=>['ko',],
'짓을'=>['ko',],
'차'=>['ko',],
'차를'=>['ko',],
'차에'=>['ko',],
'찰리'=>['ko',],
'찰스'=>['ko',],
'참'=>['ko',],
'찾고'=>['ko',],
'찾아'=>['ko',],
'찾을'=>['ko',],
'척'=>['ko',],
'총'=>['ko',],
'총을'=>['ko',],
'친구'=>['ko',],
'친구가'=>['ko',],
'친구는'=>['ko',],
'친구들'=>['ko',],
'크로포트'=>['ko',],
'크리스'=>['ko',],
'큰'=>['ko',],
'텐데'=>['ko',],
'통해'=>['ko',],
'파티'=>['ko',],
'프레드릭'=>['ko',],
'필'=>['ko',],
'필요'=>['ko',],
'필요합니다'=>['ko',],
'하고'=>['ko',],
'하나'=>['ko',],
'하나의'=>['ko',],
'하느님'=>['ko',],
'하는'=>['ko',],
'하는데'=>['ko',],
'하면'=>['ko',],
'하셨죠'=>['ko',],
'하죠'=>['ko',],
'하지'=>['ko',],
'하지만'=>['ko',],
'한'=>['ko',],
'한번'=>['ko',],
'한참'=>['ko',],
'할'=>['ko',],
'할거야'=>['ko',],
'함께'=>['ko',],
'합니다'=>['ko',],
'항상'=>['ko',],
'해'=>['ko',],
'해나'=>['ko',],
'해서'=>['ko',],
'해야'=>['ko',],
'해요'=>['ko',],
'핸슨'=>['ko',],
'했는데'=>['ko',],
'했어'=>['ko',],
'했어요'=>['ko',],
'했잖아'=>['ko',],
'했지'=>['ko',],
'행크'=>['ko',],
'허나'=>['ko',],
'허면'=>['ko',],
'형제'=>['ko',],
'호랑이'=>['ko',],
'혹시'=>['ko',],
'혼자'=>['ko',],
'확실히'=>['ko',],
'후'=>['ko',],
'후에'=>['ko',],
'흠'=>['ko',],
};
}

sub words {
  return $words;
}

1;

