# WebService::Fastly::PopApi

## Load the API package
```perl
use WebService::Fastly::Object::PopApi;
```

All URIs are relative to *https://api.fastly.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**list_pops**](PopApi.md#list_pops) | **GET** /datacenters | List Fastly POPs


# **list_pops**
> ARRAY[Pop] list_pops()

List Fastly POPs

Get a list of all Fastly POPs.

### Example
```perl
use Data::Dumper;
use WebService::Fastly::PopApi;
my $api_instance = WebService::Fastly::PopApi->new(

    # Configure API key authorization: token
    api_key => {'Fastly-Key' => 'YOUR_API_KEY'},
    # uncomment below to setup prefix (e.g. Bearer) for API key, if needed
    #api_key_prefix => {'Fastly-Key' => 'Bearer'},
);


eval {
    my $result = $api_instance->list_pops();
    print Dumper($result);
};
if ($@) {
    warn "Exception when calling PopApi->list_pops: $@\n";
}
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**ARRAY[Pop]**](Pop.md)

### Authorization

[token](../README.md#token)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

