# Generated by default/object.tt
package Paws::Macie2::SessionContext;
  use Moose;
  has Attributes => (is => 'ro', isa => 'Paws::Macie2::SessionContextAttributes', request_name => 'attributes', traits => ['NameInRequest']);
  has SessionIssuer => (is => 'ro', isa => 'Paws::Macie2::SessionIssuer', request_name => 'sessionIssuer', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::SessionContext

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::SessionContext object:

  $service_obj->Method(Att1 => { Attributes => $value, ..., SessionIssuer => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::SessionContext object:

  $result = $service_obj->Method(...);
  $result->Att1->Attributes

=head1 DESCRIPTION

Provides information about a session that was created for an entity
that performed an action by using temporary security credentials.

=head1 ATTRIBUTES


=head2 Attributes => L<Paws::Macie2::SessionContextAttributes>

The date and time when the credentials were issued, and whether the
credentials were authenticated with a multi-factor authentication (MFA)
device.


=head2 SessionIssuer => L<Paws::Macie2::SessionIssuer>

The source and type of credentials that were issued to the entity.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

