######################################################################
#
# 3132_cp932_by_utf8_RoundTrip.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x04",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x05",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x06",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x07",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x08",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x09",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x0A",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x0B",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x14",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x15",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x16",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x17",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x18",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x1A",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x1B",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x1C",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x20",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x21",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x22",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x23",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\x24",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x25",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x26",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x27",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x28",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x29",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x2A",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x2B",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x2C",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x2D",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x2E",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x2F",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\x30",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\x31",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\x32",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\x33",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\x34",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\x35",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\x36",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\x37",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\x38",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\x39",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x3A",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x3B",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x3C",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x3D",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x3E",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x3F",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x40",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\x41",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\x42",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\x43",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\x44",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\x45",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\x46",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\x47",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\x48",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\x49",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\x4A",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\x4B",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\x4C",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\x4D",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\x4E",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\x4F",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\x50",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\x51",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\x52",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\x53",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\x54",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\x55",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\x56",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\x57",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\x58",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\x59",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\x5A",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x5B",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5C",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x5D",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x5E",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x5F",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\x60",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x61",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x62",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x63",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x64",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x65",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x66",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x67",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x68",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x69",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x6A",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\x6B",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x6C",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x6D",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x6E",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x6F",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x70",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x71",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x72",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x73",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x74",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x75",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x76",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\x77",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\x78",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\x79",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\x7A",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\x7B",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x7C",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\x7D",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\x7E",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x7F",'cp932','utf8',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\xEF\xBD\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1"],
        ["\xEF\xBD\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2"],
        ["\xEF\xBD\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3"],
        ["\xEF\xBD\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4"],
        ["\xEF\xBD\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5"],
        ["\xEF\xBD\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6"],
        ["\xEF\xBD\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7"],
        ["\xEF\xBD\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xA8"],
        ["\xEF\xBD\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xA9"],
        ["\xEF\xBD\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xAA"],
        ["\xEF\xBD\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xAB"],
        ["\xEF\xBD\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xAC"],
        ["\xEF\xBD\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xAD"],
        ["\xEF\xBD\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xAE"],
        ["\xEF\xBD\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xAF"],
        ["\xEF\xBD\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0"],
        ["\xEF\xBD\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1"],
        ["\xEF\xBD\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2"],
        ["\xEF\xBD\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3"],
        ["\xEF\xBD\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4"],
        ["\xEF\xBD\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5"],
        ["\xEF\xBD\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6"],
        ["\xEF\xBD\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7"],
        ["\xEF\xBD\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8"],
        ["\xEF\xBD\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9"],
        ["\xEF\xBD\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA"],
        ["\xEF\xBD\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB"],
        ["\xEF\xBD\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC"],
        ["\xEF\xBD\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD"],
        ["\xEF\xBD\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE"],
        ["\xEF\xBD\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF"],
        ["\xEF\xBE\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0"],
        ["\xEF\xBE\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1"],
        ["\xEF\xBE\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2"],
        ["\xEF\xBE\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3"],
        ["\xEF\xBE\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4"],
        ["\xEF\xBE\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5"],
        ["\xEF\xBE\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6"],
        ["\xEF\xBE\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7"],
        ["\xEF\xBE\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8"],
        ["\xEF\xBE\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9"],
        ["\xEF\xBE\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA"],
        ["\xEF\xBE\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB"],
        ["\xEF\xBE\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC"],
        ["\xEF\xBE\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD"],
        ["\xEF\xBE\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE"],
        ["\xEF\xBE\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF"],
        ["\xEF\xBE\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0"],
        ["\xEF\xBE\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1"],
        ["\xEF\xBE\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2"],
        ["\xEF\xBE\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3"],
        ["\xEF\xBE\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4"],
        ["\xEF\xBE\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5"],
        ["\xEF\xBE\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6"],
        ["\xEF\xBE\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7"],
        ["\xEF\xBE\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8"],
        ["\xEF\xBE\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9"],
        ["\xEF\xBE\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA"],
        ["\xEF\xBE\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB"],
        ["\xEF\xBE\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC"],
        ["\xEF\xBE\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD"],
        ["\xEF\xBE\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE"],
        ["\xEF\xBE\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF"],
        ["\xE3\x80\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x40"],
        ["\xE3\x80\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x41"],
        ["\xE3\x80\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x42"],
        ["\xEF\xBC\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x43"],
        ["\xEF\xBC\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x44"],
        ["\xE3\x83\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x45"],
        ["\xEF\xBC\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x46"],
        ["\xEF\xBC\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x47"],
        ["\xEF\xBC\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x48"],
        ["\xEF\xBC\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x49"],
        ["\xE3\x82\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4A"],
        ["\xE3\x82\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4B"],
        ["\xC2\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4C"],
        ["\xEF\xBD\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4D"],
        ["\xC2\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4E"],
        ["\xEF\xBC\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x4F"],
        ["\xEF\xBF\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x50"],
        ["\xEF\xBC\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x51"],
        ["\xE3\x83\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x52"],
        ["\xE3\x83\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x53"],
        ["\xE3\x82\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x54"],
        ["\xE3\x82\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x55"],
        ["\xE3\x80\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x56"],
        ["\xE4\xBB\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x57"],
        ["\xE3\x80\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x58"],
        ["\xE3\x80\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x59"],
        ["\xE3\x80\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5A"],
        ["\xE3\x83\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5B"],
        ["\xE2\x80\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5C"],
        ["\xE2\x80\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5D"],
        ["\xEF\xBC\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5E"],
        ["\xEF\xBC\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5F"],
        ["\xE3\x80\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x60"],
        ["\xE2\x88\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x61"],
        ["\xEF\xBD\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x62"],
        ["\xE2\x80\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x63"],
        ["\xE2\x80\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x64"],
        ["\xE2\x80\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x65"],
        ["\xE2\x80\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x66"],
        ["\xE2\x80\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x67"],
        ["\xE2\x80\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x68"],
        ["\xEF\xBC\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x69"],
        ["\xEF\xBC\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6A"],
        ["\xE3\x80\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6B"],
        ["\xE3\x80\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6C"],
        ["\xEF\xBC\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6D"],
        ["\xEF\xBC\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6E"],
        ["\xEF\xBD\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x6F"],
        ["\xEF\xBD\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x70"],
        ["\xE3\x80\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x71"],
        ["\xE3\x80\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x72"],
        ["\xE3\x80\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x73"],
        ["\xE3\x80\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x74"],
        ["\xE3\x80\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x75"],
        ["\xE3\x80\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x76"],
        ["\xE3\x80\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x77"],
        ["\xE3\x80\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x78"],
        ["\xE3\x80\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x79"],
        ["\xE3\x80\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7A"],
        ["\xEF\xBC\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7B"],
        ["\xEF\xBC\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7C"],
        ["\xC2\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7D"],
        ["\xC3\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7E"],
        ["\xC3\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x80"],
        ["\xEF\xBC\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x81"],
        ["\xE2\x89\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x82"],
        ["\xEF\xBC\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x83"],
        ["\xEF\xBC\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x84"],
        ["\xE2\x89\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x85"],
        ["\xE2\x89\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x86"],
        ["\xE2\x88\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x87"],
        ["\xE2\x88\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x88"],
        ["\xE2\x99\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x89"],
        ["\xE2\x99\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8A"],
        ["\xC2\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8B"],
        ["\xE2\x80\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8C"],
        ["\xE2\x80\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8D"],
        ["\xE2\x84\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8E"],
        ["\xEF\xBF\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x8F"],
        ["\xEF\xBC\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x90"],
        ["\xEF\xBF\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x91"],
        ["\xEF\xBF\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x92"],
        ["\xEF\xBC\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x93"],
        ["\xEF\xBC\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x94"],
        ["\xEF\xBC\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x95"],
        ["\xEF\xBC\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x96"],
        ["\xEF\xBC\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x97"],
        ["\xC2\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x98"],
        ["\xE2\x98\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x99"],
        ["\xE2\x98\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9A"],
        ["\xE2\x97\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9B"],
        ["\xE2\x97\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9C"],
        ["\xE2\x97\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9D"],
        ["\xE2\x97\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9E"],
        ["\xE2\x97\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x9F"],
        ["\xE2\x96\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA0"],
        ["\xE2\x96\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA1"],
        ["\xE2\x96\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA2"],
        ["\xE2\x96\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA3"],
        ["\xE2\x96\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA4"],
        ["\xE2\x96\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA5"],
        ["\xE2\x80\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA6"],
        ["\xE3\x80\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA7"],
        ["\xE2\x86\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA8"],
        ["\xE2\x86\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xA9"],
        ["\xE2\x86\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAA"],
        ["\xE2\x86\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAB"],
        ["\xE3\x80\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\xE2\x88\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB8"],
        ["\xE2\x88\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xB9"],
        ["\xE2\x8A\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBA"],
        ["\xE2\x8A\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBB"],
        ["\xE2\x8A\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBC"],
        ["\xE2\x8A\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBD"],
        ["\xE2\x88\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBE"],
        ["\xE2\x88\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xBF"],
        ["\xE2\x88\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC8"],
        ["\xE2\x88\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xC9"],
        ["\xEF\xBF\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCA"],
        ["\xE2\x87\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCB"],
        ["\xE2\x87\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCC"],
        ["\xE2\x88\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCD"],
        ["\xE2\x88\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCE"],
        ["\xE2\x88\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDA"],
        ["\xE2\x8A\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDB"],
        ["\xE2\x8C\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDC"],
        ["\xE2\x88\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDD"],
        ["\xE2\x88\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDE"],
        ["\xE2\x89\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xDF"],
        ["\xE2\x89\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE0"],
        ["\xE2\x89\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE1"],
        ["\xE2\x89\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE2"],
        ["\xE2\x88\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE3"],
        ["\xE2\x88\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE4"],
        ["\xE2\x88\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE5"],
        ["\xE2\x88\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE6"],
        ["\xE2\x88\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE7"],
        ["\xE2\x88\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xE8"],
        ["\xE2\x84\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF0"],
        ["\xE2\x80\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF1"],
        ["\xE2\x99\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF2"],
        ["\xE2\x99\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF3"],
        ["\xE2\x99\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF4"],
        ["\xE2\x80\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF5"],
        ["\xE2\x80\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF6"],
        ["\xC2\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xF7"],
        ["\xE2\x97\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xFC"],
        ["\xEF\xBC\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x4F"],
        ["\xEF\xBC\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x50"],
        ["\xEF\xBC\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x51"],
        ["\xEF\xBC\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],
        ["\xEF\xBC\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x53"],
        ["\xEF\xBC\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x54"],
        ["\xEF\xBC\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x55"],
        ["\xEF\xBC\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x56"],
        ["\xEF\xBC\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x57"],
        ["\xEF\xBC\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x58"],
        ["\xEF\xBC\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x60"],
        ["\xEF\xBC\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x61"],
        ["\xEF\xBC\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x62"],
        ["\xEF\xBC\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x63"],
        ["\xEF\xBC\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x64"],
        ["\xEF\xBC\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x65"],
        ["\xEF\xBC\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x66"],
        ["\xEF\xBC\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x67"],
        ["\xEF\xBC\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x68"],
        ["\xEF\xBC\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x69"],
        ["\xEF\xBC\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6A"],
        ["\xEF\xBC\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6B"],
        ["\xEF\xBC\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6C"],
        ["\xEF\xBC\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6D"],
        ["\xEF\xBC\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6E"],
        ["\xEF\xBC\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x6F"],
        ["\xEF\xBC\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x70"],
        ["\xEF\xBC\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x71"],
        ["\xEF\xBC\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x72"],
        ["\xEF\xBC\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x73"],
        ["\xEF\xBC\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x74"],
        ["\xEF\xBC\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x75"],
        ["\xEF\xBC\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x76"],
        ["\xEF\xBC\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x77"],
        ["\xEF\xBC\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x78"],
        ["\xEF\xBC\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x79"],
        ["\xEF\xBD\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x81"],
        ["\xEF\xBD\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x82"],
        ["\xEF\xBD\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x83"],
        ["\xEF\xBD\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x84"],
        ["\xEF\xBD\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x85"],
        ["\xEF\xBD\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x86"],
        ["\xEF\xBD\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x87"],
        ["\xEF\xBD\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x88"],
        ["\xEF\xBD\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x89"],
        ["\xEF\xBD\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8A"],
        ["\xEF\xBD\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8B"],
        ["\xEF\xBD\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8C"],
        ["\xEF\xBD\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8D"],
        ["\xEF\xBD\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8E"],
        ["\xEF\xBD\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x8F"],
        ["\xEF\xBD\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x90"],
        ["\xEF\xBD\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x91"],
        ["\xEF\xBD\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x92"],
        ["\xEF\xBD\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],
        ["\xEF\xBD\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x94"],
        ["\xEF\xBD\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x95"],
        ["\xEF\xBD\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x96"],
        ["\xEF\xBD\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x97"],
        ["\xEF\xBD\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x98"],
        ["\xEF\xBD\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x99"],
        ["\xEF\xBD\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x9A"],
        ["\xE3\x81\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\x9F"],
        ["\xE3\x81\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA0"],
        ["\xE3\x81\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA1"],
        ["\xE3\x81\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],
        ["\xE3\x81\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],
        ["\xE3\x81\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA4"],
        ["\xE3\x81\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA5"],
        ["\xE3\x81\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA6"],
        ["\xE3\x81\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA7"],
        ["\xE3\x81\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],
        ["\xE3\x81\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xA9"],
        ["\xE3\x81\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAA"],
        ["\xE3\x81\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAB"],
        ["\xE3\x81\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],
        ["\xE3\x81\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAD"],
        ["\xE3\x81\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAE"],
        ["\xE3\x81\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xAF"],
        ["\xE3\x81\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB0"],
        ["\xE3\x81\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB1"],
        ["\xE3\x81\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB2"],
        ["\xE3\x81\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],
        ["\xE3\x81\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB4"],
        ["\xE3\x81\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB5"],
        ["\xE3\x81\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB6"],
        ["\xE3\x81\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB7"],
        ["\xE3\x81\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB8"],
        ["\xE3\x81\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],
        ["\xE3\x81\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBA"],
        ["\xE3\x81\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],
        ["\xE3\x81\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBC"],
        ["\xE3\x81\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBD"],
        ["\xE3\x81\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBE"],
        ["\xE3\x81\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xBF"],
        ["\xE3\x81\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC0"],
        ["\xE3\x81\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC1"],
        ["\xE3\x81\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC2"],
        ["\xE3\x81\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC3"],
        ["\xE3\x81\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC4"],
        ["\xE3\x81\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC5"],
        ["\xE3\x81\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC6"],
        ["\xE3\x81\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC7"],
        ["\xE3\x81\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC8"],
        ["\xE3\x81\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xC9"],
        ["\xE3\x81\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCA"],
        ["\xE3\x81\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCB"],
        ["\xE3\x81\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],
        ["\xE3\x81\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCD"],
        ["\xE3\x81\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCE"],
        ["\xE3\x81\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xCF"],
        ["\xE3\x81\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD0"],
        ["\xE3\x81\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD1"],
        ["\xE3\x81\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD2"],
        ["\xE3\x81\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD3"],
        ["\xE3\x81\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD4"],
        ["\xE3\x81\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD5"],
        ["\xE3\x81\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD6"],
        ["\xE3\x81\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD7"],
        ["\xE3\x81\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD8"],
        ["\xE3\x81\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xD9"],
        ["\xE3\x81\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDA"],
        ["\xE3\x81\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDB"],
        ["\xE3\x81\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDC"],
        ["\xE3\x81\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDD"],
        ["\xE3\x82\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDE"],
        ["\xE3\x82\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xDF"],
        ["\xE3\x82\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE0"],
        ["\xE3\x82\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE1"],
        ["\xE3\x82\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE2"],
        ["\xE3\x82\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE3"],
        ["\xE3\x82\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE4"],
        ["\xE3\x82\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE5"],
        ["\xE3\x82\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE6"],
        ["\xE3\x82\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE7"],
        ["\xE3\x82\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE8"],
        ["\xE3\x82\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xE9"],
        ["\xE3\x82\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEA"],
        ["\xE3\x82\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],
        ["\xE3\x82\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],
        ["\xE3\x82\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xED"],
        ["\xE3\x82\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEE"],
        ["\xE3\x82\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xEF"],
        ["\xE3\x82\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF0"],
        ["\xE3\x82\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x82\xF1"],
        ["\xE3\x82\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x40"],
        ["\xE3\x82\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x41"],
        ["\xE3\x82\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x42"],
        ["\xE3\x82\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x43"],
        ["\xE3\x82\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x44"],
        ["\xE3\x82\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x45"],
        ["\xE3\x82\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x46"],
        ["\xE3\x82\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x47"],
        ["\xE3\x82\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x48"],
        ["\xE3\x82\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x49"],
        ["\xE3\x82\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4A"],
        ["\xE3\x82\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4B"],
        ["\xE3\x82\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4C"],
        ["\xE3\x82\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4D"],
        ["\xE3\x82\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4E"],
        ["\xE3\x82\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x4F"],
        ["\xE3\x82\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x50"],
        ["\xE3\x82\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x51"],
        ["\xE3\x82\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x52"],
        ["\xE3\x82\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x53"],
        ["\xE3\x82\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x54"],
        ["\xE3\x82\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x55"],
        ["\xE3\x82\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x56"],
        ["\xE3\x82\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x57"],
        ["\xE3\x82\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x58"],
        ["\xE3\x82\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x59"],
        ["\xE3\x82\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5A"],
        ["\xE3\x82\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5B"],
        ["\xE3\x82\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5C"],
        ["\xE3\x82\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5D"],
        ["\xE3\x82\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5E"],
        ["\xE3\x83\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x5F"],
        ["\xE3\x83\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x60"],
        ["\xE3\x83\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x61"],
        ["\xE3\x83\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x62"],
        ["\xE3\x83\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x63"],
        ["\xE3\x83\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x64"],
        ["\xE3\x83\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x65"],
        ["\xE3\x83\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x66"],
        ["\xE3\x83\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x67"],
        ["\xE3\x83\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x68"],
        ["\xE3\x83\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x69"],
        ["\xE3\x83\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6A"],
        ["\xE3\x83\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6B"],
        ["\xE3\x83\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6C"],
        ["\xE3\x83\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6D"],
        ["\xE3\x83\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6E"],
        ["\xE3\x83\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x6F"],
        ["\xE3\x83\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x70"],
        ["\xE3\x83\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x71"],
        ["\xE3\x83\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x72"],
        ["\xE3\x83\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x73"],
        ["\xE3\x83\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x74"],
        ["\xE3\x83\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x75"],
        ["\xE3\x83\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x76"],
        ["\xE3\x83\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x77"],
        ["\xE3\x83\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x78"],
        ["\xE3\x83\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x79"],
        ["\xE3\x83\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7A"],
        ["\xE3\x83\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7B"],
        ["\xE3\x83\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7C"],
        ["\xE3\x83\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7D"],
        ["\xE3\x83\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x7E"],
        ["\xE3\x83\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x80"],
        ["\xE3\x83\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x81"],
        ["\xE3\x83\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],
        ["\xE3\x83\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x83"],
        ["\xE3\x83\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x84"],
        ["\xE3\x83\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x85"],
        ["\xE3\x83\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x86"],
        ["\xE3\x83\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x87"],
        ["\xE3\x83\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x88"],
        ["\xE3\x83\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x89"],
        ["\xE3\x83\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8A"],
        ["\xE3\x83\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8B"],
        ["\xE3\x83\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8C"],
        ["\xE3\x83\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8D"],
        ["\xE3\x83\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8E"],
        ["\xE3\x83\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x8F"],
        ["\xE3\x83\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x90"],
        ["\xE3\x83\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x91"],
        ["\xE3\x83\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x92"],
        ["\xE3\x83\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x93"],
        ["\xE3\x83\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x94"],
        ["\xE3\x83\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x95"],
        ["\xE3\x83\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x96"],
        ["\xCE\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\x9F"],
        ["\xCE\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA0"],
        ["\xCE\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA1"],
        ["\xCE\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA2"],
        ["\xCE\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA3"],
        ["\xCE\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA4"],
        ["\xCE\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA5"],
        ["\xCE\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA6"],
        ["\xCE\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA7"],
        ["\xCE\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA8"],
        ["\xCE\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xA9"],
        ["\xCE\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAA"],
        ["\xCE\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAB"],
        ["\xCE\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAC"],
        ["\xCE\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAD"],
        ["\xCE\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAE"],
        ["\xCE\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xAF"],
        ["\xCE\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB0"],
        ["\xCE\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB1"],
        ["\xCE\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB2"],
        ["\xCE\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB3"],
        ["\xCE\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB4"],
        ["\xCE\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB5"],
        ["\xCE\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xB6"],
        ["\xCE\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xBF"],
        ["\xCE\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC0"],
        ["\xCE\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC1"],
        ["\xCE\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC2"],
        ["\xCE\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC3"],
        ["\xCE\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC4"],
        ["\xCE\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC5"],
        ["\xCE\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC6"],
        ["\xCE\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC7"],
        ["\xCE\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC8"],
        ["\xCE\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xC9"],
        ["\xCE\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCA"],
        ["\xCE\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCB"],
        ["\xCE\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCC"],
        ["\xCE\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCD"],
        ["\xCF\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCE"],
        ["\xCF\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xCF"],
        ["\xCF\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD0"],
        ["\xCF\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD1"],
        ["\xCF\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD2"],
        ["\xCF\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD3"],
        ["\xCF\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD4"],
        ["\xCF\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD5"],
        ["\xCF\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x83\xD6"],
        ["\xD0\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x40"],
        ["\xD0\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x41"],
        ["\xD0\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x42"],
        ["\xD0\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x43"],
        ["\xD0\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x44"],
        ["\xD0\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x45"],
        ["\xD0\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x46"],
        ["\xD0\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x47"],
        ["\xD0\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],
        ["\xD0\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x49"],
        ["\xD0\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4A"],
        ["\xD0\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4B"],
        ["\xD0\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4C"],
        ["\xD0\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4D"],
        ["\xD0\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4E"],
        ["\xD0\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x4F"],
        ["\xD0\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x50"],
        ["\xD0\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x51"],
        ["\xD0\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x52"],
        ["\xD0\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x53"],
        ["\xD0\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x54"],
        ["\xD0\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x55"],
        ["\xD0\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x56"],
        ["\xD0\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x57"],
        ["\xD0\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x58"],
        ["\xD0\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x59"],
        ["\xD0\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5A"],
        ["\xD0\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5B"],
        ["\xD0\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5C"],
        ["\xD0\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5D"],
        ["\xD0\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5E"],
        ["\xD0\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x5F"],
        ["\xD0\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x60"],
        ["\xD0\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x70"],
        ["\xD0\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x71"],
        ["\xD0\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x72"],
        ["\xD0\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x73"],
        ["\xD0\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x74"],
        ["\xD0\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x75"],
        ["\xD1\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x76"],
        ["\xD0\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x77"],
        ["\xD0\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x78"],
        ["\xD0\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x79"],
        ["\xD0\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7A"],
        ["\xD0\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7B"],
        ["\xD0\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7C"],
        ["\xD0\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7D"],
        ["\xD0\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x7E"],
        ["\xD0\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x80"],
        ["\xD0\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x81"],
        ["\xD1\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x82"],
        ["\xD1\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x83"],
        ["\xD1\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x84"],
        ["\xD1\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x85"],
        ["\xD1\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x86"],
        ["\xD1\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x87"],
        ["\xD1\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x88"],
        ["\xD1\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x89"],
        ["\xD1\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8A"],
        ["\xD1\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8B"],
        ["\xD1\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8C"],
        ["\xD1\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8D"],
        ["\xD1\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8E"],
        ["\xD1\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x8F"],
        ["\xD1\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x90"],
        ["\xD1\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x91"],
        ["\xE2\x94\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\x9F"],
        ["\xE2\x94\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA0"],
        ["\xE2\x94\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA1"],
        ["\xE2\x94\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA2"],
        ["\xE2\x94\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA3"],
        ["\xE2\x94\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA4"],
        ["\xE2\x94\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA5"],
        ["\xE2\x94\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA6"],
        ["\xE2\x94\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA7"],
        ["\xE2\x94\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA8"],
        ["\xE2\x94\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xA9"],
        ["\xE2\x94\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAA"],
        ["\xE2\x94\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAB"],
        ["\xE2\x94\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAC"],
        ["\xE2\x94\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAD"],
        ["\xE2\x94\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAE"],
        ["\xE2\x94\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xAF"],
        ["\xE2\x94\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB0"],
        ["\xE2\x94\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB1"],
        ["\xE2\x94\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB2"],
        ["\xE2\x94\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB3"],
        ["\xE2\x95\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB4"],
        ["\xE2\x94\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB5"],
        ["\xE2\x94\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB6"],
        ["\xE2\x94\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB7"],
        ["\xE2\x94\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB8"],
        ["\xE2\x94\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xB9"],
        ["\xE2\x94\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBA"],
        ["\xE2\x94\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBB"],
        ["\xE2\x94\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBC"],
        ["\xE2\x94\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBD"],
        ["\xE2\x95\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x84\xBE"],
        ["\xE2\x91\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x40"],
        ["\xE2\x91\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x41"],
        ["\xE2\x91\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x42"],
        ["\xE2\x91\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x43"],
        ["\xE2\x91\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x44"],
        ["\xE2\x91\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x45"],
        ["\xE2\x91\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x46"],
        ["\xE2\x91\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x47"],
        ["\xE2\x91\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x48"],
        ["\xE2\x91\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x49"],
        ["\xE2\x91\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4A"],
        ["\xE2\x91\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4B"],
        ["\xE2\x91\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4C"],
        ["\xE2\x91\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4D"],
        ["\xE2\x91\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4E"],
        ["\xE2\x91\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x4F"],
        ["\xE2\x91\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x50"],
        ["\xE2\x91\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x51"],
        ["\xE2\x91\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x52"],
        ["\xE2\x91\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x53"],
        ["\xE2\x85\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x54"],
        ["\xE2\x85\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x55"],
        ["\xE2\x85\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x56"],
        ["\xE2\x85\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x57"],
        ["\xE2\x85\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x58"],
        ["\xE2\x85\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x59"],
        ["\xE2\x85\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5A"],
        ["\xE2\x85\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5B"],
        ["\xE2\x85\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5C"],
        ["\xE2\x85\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5D"],
        ["\xE3\x8D\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x5F"],
        ["\xE3\x8C\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x60"],
        ["\xE3\x8C\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x61"],
        ["\xE3\x8D\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x62"],
        ["\xE3\x8C\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x63"],
        ["\xE3\x8C\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x64"],
        ["\xE3\x8C\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x65"],
        ["\xE3\x8C\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x66"],
        ["\xE3\x8D\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x67"],
        ["\xE3\x8D\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x68"],
        ["\xE3\x8C\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x69"],
        ["\xE3\x8C\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6A"],
        ["\xE3\x8C\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6B"],
        ["\xE3\x8C\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6C"],
        ["\xE3\x8D\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6D"],
        ["\xE3\x8C\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6E"],
        ["\xE3\x8E\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x6F"],
        ["\xE3\x8E\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x70"],
        ["\xE3\x8E\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x71"],
        ["\xE3\x8E\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x72"],
        ["\xE3\x8E\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x73"],
        ["\xE3\x8F\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x74"],
        ["\xE3\x8E\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x75"],
        ["\xE3\x8D\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x7E"],
        ["\xE3\x80\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x80"],
        ["\xE3\x80\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x81"],
        ["\xE2\x84\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x82"],
        ["\xE3\x8F\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x83"],
        ["\xE2\x84\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x84"],
        ["\xE3\x8A\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x85"],
        ["\xE3\x8A\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x86"],
        ["\xE3\x8A\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x87"],
        ["\xE3\x8A\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x88"],
        ["\xE3\x8A\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x89"],
        ["\xE3\x88\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8A"],
        ["\xE3\x88\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8B"],
        ["\xE3\x88\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8C"],
        ["\xE3\x8D\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8D"],
        ["\xE3\x8D\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8E"],
        ["\xE3\x8D\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x8F"],
        ["\xE2\x88\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x93"],
        ["\xE2\x88\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x94"],
        ["\xE2\x88\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x98"],
        ["\xE2\x8A\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x87\x99"],
        ["\xE4\xBA\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\x9F"],
        ["\xE5\x94\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA0"],
        ["\xE5\xA8\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA1"],
        ["\xE9\x98\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA2"],
        ["\xE5\x93\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA3"],
        ["\xE6\x84\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA4"],
        ["\xE6\x8C\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA5"],
        ["\xE5\xA7\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA6"],
        ["\xE9\x80\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA7"],
        ["\xE8\x91\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA8"],
        ["\xE8\x8C\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xA9"],
        ["\xE7\xA9\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAA"],
        ["\xE6\x82\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAB"],
        ["\xE6\x8F\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAC"],
        ["\xE6\xB8\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAD"],
        ["\xE6\x97\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAE"],
        ["\xE8\x91\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xAF"],
        ["\xE8\x8A\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB0"],
        ["\xE9\xAF\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB1"],
        ["\xE6\xA2\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB2"],
        ["\xE5\x9C\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB3"],
        ["\xE6\x96\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB4"],
        ["\xE6\x89\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB5"],
        ["\xE5\xAE\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB6"],
        ["\xE5\xA7\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB7"],
        ["\xE8\x99\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB8"],
        ["\xE9\xA3\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xB9"],
        ["\xE7\xB5\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBA"],
        ["\xE7\xB6\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBB"],
        ["\xE9\xAE\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBC"],
        ["\xE6\x88\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBD"],
        ["\xE7\xB2\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBE"],
        ["\xE8\xA2\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xBF"],
        ["\xE5\xAE\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC0"],
        ["\xE5\xBA\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC1"],
        ["\xE6\x8C\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC2"],
        ["\xE6\x9A\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC3"],
        ["\xE6\xA1\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC4"],
        ["\xE9\x97\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC5"],
        ["\xE9\x9E\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC6"],
        ["\xE6\x9D\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC7"],
        ["\xE4\xBB\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC8"],
        ["\xE4\xBC\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xC9"],
        ["\xE4\xBD\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCA"],
        ["\xE4\xBE\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCB"],
        ["\xE5\x81\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCC"],
        ["\xE5\x9B\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCD"],
        ["\xE5\xA4\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCE"],
        ["\xE5\xA7\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xCF"],
        ["\xE5\xA8\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD0"],
        ["\xE5\xB0\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD1"],
        ["\xE6\x83\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD2"],
        ["\xE6\x84\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD3"],
        ["\xE6\x85\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD4"],
        ["\xE6\x98\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD5"],
        ["\xE6\xA4\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD6"],
        ["\xE7\x82\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD7"],
        ["\xE7\x95\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD8"],
        ["\xE7\x95\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xD9"],
        ["\xE7\xA7\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDA"],
        ["\xE7\xB6\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDB"],
        ["\xE7\xB7\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDC"],
        ["\xE8\x83\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDD"],
        ["\xE8\x90\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDE"],
        ["\xE8\xA1\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xDF"],
        ["\xE8\xAC\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE0"],
        ["\xE9\x81\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE1"],
        ["\xE9\x81\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE2"],
        ["\xE5\x8C\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE3"],
        ["\xE4\xBA\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE4"],
        ["\xE4\xBA\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE5"],
        ["\xE5\x9F\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE6"],
        ["\xE8\x82\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE7"],
        ["\xE9\x83\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE8"],
        ["\xE7\xA3\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xE9"],
        ["\xE4\xB8\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEA"],
        ["\xE5\xA3\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEB"],
        ["\xE6\xBA\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEC"],
        ["\xE9\x80\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xED"],
        ["\xE7\xA8\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEE"],
        ["\xE8\x8C\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xEF"],
        ["\xE8\x8A\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF0"],
        ["\xE9\xB0\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF1"],
        ["\xE5\x85\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF2"],
        ["\xE5\x8D\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF3"],
        ["\xE5\x92\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF4"],
        ["\xE5\x93\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF5"],
        ["\xE5\x9B\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF6"],
        ["\xE5\xA7\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF7"],
        ["\xE5\xBC\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF8"],
        ["\xE9\xA3\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xF9"],
        ["\xE6\xB7\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xFA"],
        ["\xE8\x83\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xFB"],
        ["\xE8\x94\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x88\xFC"],
        ["\xE9\x99\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x40"],
        ["\xE9\x99\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x41"],
        ["\xE9\x9A\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x42"],
        ["\xE9\x9F\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x43"],
        ["\xE5\x90\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x44"],
        ["\xE5\x8F\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x45"],
        ["\xE5\xAE\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x46"],
        ["\xE7\x83\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x47"],
        ["\xE7\xBE\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x48"],
        ["\xE8\xBF\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x49"],
        ["\xE9\x9B\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4A"],
        ["\xE5\x8D\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4B"],
        ["\xE9\xB5\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4C"],
        ["\xE7\xAA\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4D"],
        ["\xE4\xB8\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4E"],
        ["\xE7\xA2\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x4F"],
        ["\xE8\x87\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x50"],
        ["\xE6\xB8\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x51"],
        ["\xE5\x98\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x52"],
        ["\xE5\x94\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x53"],
        ["\xE6\xAC\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x54"],
        ["\xE8\x94\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x55"],
        ["\xE9\xB0\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x56"],
        ["\xE5\xA7\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x57"],
        ["\xE5\x8E\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x58"],
        ["\xE6\xB5\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x59"],
        ["\xE7\x93\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5A"],
        ["\xE9\x96\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5B"],
        ["\xE5\x99\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5C"],
        ["\xE4\xBA\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5D"],
        ["\xE9\x81\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5E"],
        ["\xE9\x9B\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x5F"],
        ["\xE8\x8D\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x60"],
        ["\xE9\xA4\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x61"],
        ["\xE5\x8F\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x62"],
        ["\xE5\x96\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x63"],
        ["\xE5\xAC\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x64"],
        ["\xE5\xBD\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x65"],
        ["\xE6\x98\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x66"],
        ["\xE6\x9B\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x67"],
        ["\xE6\xA0\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x68"],
        ["\xE6\xB0\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x69"],
        ["\xE6\xB3\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6A"],
        ["\xE6\xB4\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6B"],
        ["\xE7\x91\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6C"],
        ["\xE7\x9B\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6D"],
        ["\xE7\xA9\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6E"],
        ["\xE9\xA0\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x6F"],
        ["\xE8\x8B\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x70"],
        ["\xE8\xA1\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x71"],
        ["\xE8\xA9\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x72"],
        ["\xE9\x8B\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x73"],
        ["\xE6\xB6\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x74"],
        ["\xE7\x96\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x75"],
        ["\xE7\x9B\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x76"],
        ["\xE9\xA7\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x77"],
        ["\xE6\x82\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x78"],
        ["\xE8\xAC\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x79"],
        ["\xE8\xB6\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7A"],
        ["\xE9\x96\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7B"],
        ["\xE6\xA6\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7C"],
        ["\xE5\x8E\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7D"],
        ["\xE5\x86\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x7E"],
        ["\xE5\x9C\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x80"],
        ["\xE5\xA0\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x81"],
        ["\xE5\xA5\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x82"],
        ["\xE5\xAE\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x83"],
        ["\xE5\xBB\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x84"],
        ["\xE6\x80\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x85"],
        ["\xE6\x8E\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x86"],
        ["\xE6\x8F\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x87"],
        ["\xE6\xB2\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x88"],
        ["\xE6\xBC\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x89"],
        ["\xE7\x82\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8A"],
        ["\xE7\x84\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8B"],
        ["\xE7\x85\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8C"],
        ["\xE7\x87\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8D"],
        ["\xE7\x8C\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8E"],
        ["\xE7\xB8\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x8F"],
        ["\xE8\x89\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x90"],
        ["\xE8\x8B\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x91"],
        ["\xE8\x96\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x92"],
        ["\xE9\x81\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x93"],
        ["\xE9\x89\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x94"],
        ["\xE9\xB4\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x95"],
        ["\xE5\xA1\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x96"],
        ["\xE6\x96\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x97"],
        ["\xE6\xB1\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x98"],
        ["\xE7\x94\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x99"],
        ["\xE5\x87\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9A"],
        ["\xE5\xA4\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9B"],
        ["\xE5\xA5\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9C"],
        ["\xE5\xBE\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9D"],
        ["\xE5\xBF\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9E"],
        ["\xE6\x8A\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\x9F"],
        ["\xE6\x97\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA0"],
        ["\xE6\xA8\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA1"],
        ["\xE6\xAC\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA2"],
        ["\xE6\xAE\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA3"],
        ["\xE7\x8E\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA4"],
        ["\xE7\xBF\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA5"],
        ["\xE8\xA5\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA6"],
        ["\xE9\xB4\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA7"],
        ["\xE9\xB4\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA8"],
        ["\xE9\xBB\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xA9"],
        ["\xE5\xB2\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAA"],
        ["\xE6\xB2\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAB"],
        ["\xE8\x8D\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAC"],
        ["\xE5\x84\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAD"],
        ["\xE5\xB1\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAE"],
        ["\xE6\x86\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xAF"],
        ["\xE8\x87\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB0"],
        ["\xE6\xA1\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB1"],
        ["\xE7\x89\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB2"],
        ["\xE4\xB9\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB3"],
        ["\xE4\xBF\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB4"],
        ["\xE5\x8D\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB5"],
        ["\xE6\x81\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB6"],
        ["\xE6\xB8\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB7"],
        ["\xE7\xA9\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB8"],
        ["\xE9\x9F\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xB9"],
        ["\xE4\xB8\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBA"],
        ["\xE5\x8C\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBB"],
        ["\xE4\xBB\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBC"],
        ["\xE4\xBD\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBD"],
        ["\xE4\xBC\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBE"],
        ["\xE4\xBE\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xBF"],
        ["\xE4\xBD\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC0"],
        ["\xE5\x8A\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC1"],
        ["\xE5\x8F\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC2"],
        ["\xE5\x98\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC3"],
        ["\xE5\xA4\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC4"],
        ["\xE5\xAB\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC5"],
        ["\xE5\xAE\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC6"],
        ["\xE5\xAF\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC7"],
        ["\xE7\xA7\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC8"],
        ["\xE6\x9A\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xC9"],
        ["\xE6\x9E\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCA"],
        ["\xE6\x9E\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCB"],
        ["\xE6\xAD\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCC"],
        ["\xE6\xB2\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCD"],
        ["\xE7\x81\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCE"],
        ["\xE7\x8F\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xCF"],
        ["\xE7\xA6\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD0"],
        ["\xE7\xA6\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD1"],
        ["\xE7\xA8\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD2"],
        ["\xE7\xAE\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD3"],
        ["\xE8\x8A\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD4"],
        ["\xE8\x8B\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD5"],
        ["\xE8\x8C\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD6"],
        ["\xE8\x8D\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD7"],
        ["\xE8\x8F\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD8"],
        ["\xE8\x8F\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xD9"],
        ["\xE8\x9D\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDA"],
        ["\xE8\xAA\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDB"],
        ["\xE5\x98\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDC"],
        ["\xE8\xB2\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDD"],
        ["\xE8\xBF\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDE"],
        ["\xE9\x81\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xDF"],
        ["\xE9\x9C\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE0"],
        ["\xE8\x9A\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE1"],
        ["\xE4\xBF\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE2"],
        ["\xE5\xB3\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE3"],
        ["\xE6\x88\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE4"],
        ["\xE7\x89\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE5"],
        ["\xE7\x94\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE6"],
        ["\xE8\x87\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE7"],
        ["\xE8\x8A\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE8"],
        ["\xE8\x9B\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xE9"],
        ["\xE8\xB3\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEA"],
        ["\xE9\x9B\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEB"],
        ["\xE9\xA4\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEC"],
        ["\xE9\xA7\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xED"],
        ["\xE4\xBB\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEE"],
        ["\xE4\xBC\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xEF"],
        ["\xE8\xA7\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF0"],
        ["\xE5\x9B\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF1"],
        ["\xE5\xA1\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF2"],
        ["\xE5\xA3\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF3"],
        ["\xE5\xBB\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF4"],
        ["\xE5\xBF\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF5"],
        ["\xE6\x80\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF6"],
        ["\xE6\x82\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF7"],
        ["\xE6\x81\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF8"],
        ["\xE6\x87\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xF9"],
        ["\xE6\x88\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xFA"],
        ["\xE6\x8B\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xFB"],
        ["\xE6\x94\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x89\xFC"],
        ["\xE9\xAD\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x40"],
        ["\xE6\x99\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x41"],
        ["\xE6\xA2\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x42"],
        ["\xE6\xB5\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x43"],
        ["\xE7\x81\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x44"],
        ["\xE7\x95\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x45"],
        ["\xE7\x9A\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x46"],
        ["\xE7\xB5\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x47"],
        ["\xE8\x8A\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x48"],
        ["\xE8\x9F\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x49"],
        ["\xE9\x96\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4A"],
        ["\xE9\x9A\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4B"],
        ["\xE8\xB2\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4C"],
        ["\xE5\x87\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4D"],
        ["\xE5\x8A\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4E"],
        ["\xE5\xA4\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x4F"],
        ["\xE5\x92\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x50"],
        ["\xE5\xAE\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x51"],
        ["\xE5\xB4\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x52"],
        ["\xE6\x85\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x53"],
        ["\xE6\xA6\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x54"],
        ["\xE6\xB6\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x55"],
        ["\xE7\xA2\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x56"],
        ["\xE8\x93\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x57"],
        ["\xE8\xA1\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x58"],
        ["\xE8\xA9\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x59"],
        ["\xE9\x8E\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5A"],
        ["\xE9\xAA\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5B"],
        ["\xE6\xB5\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5C"],
        ["\xE9\xA6\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5D"],
        ["\xE8\x9B\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5E"],
        ["\xE5\x9E\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x5F"],
        ["\xE6\x9F\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x60"],
        ["\xE8\x9B\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x61"],
        ["\xE9\x88\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x62"],
        ["\xE5\x8A\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x63"],
        ["\xE5\x9A\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x64"],
        ["\xE5\x90\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x65"],
        ["\xE5\xBB\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x66"],
        ["\xE6\x8B\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x67"],
        ["\xE6\x92\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x68"],
        ["\xE6\xA0\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x69"],
        ["\xE6\xA0\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6A"],
        ["\xE6\xAE\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6B"],
        ["\xE7\x8D\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6C"],
        ["\xE7\xA2\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6D"],
        ["\xE7\xA9\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6E"],
        ["\xE8\xA6\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x6F"],
        ["\xE8\xA7\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x70"],
        ["\xE8\xB5\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x71"],
        ["\xE8\xBC\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x72"],
        ["\xE9\x83\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x73"],
        ["\xE9\x96\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x74"],
        ["\xE9\x9A\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x75"],
        ["\xE9\x9D\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x76"],
        ["\xE5\xAD\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x77"],
        ["\xE5\xB2\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x78"],
        ["\xE6\xA5\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x79"],
        ["\xE9\xA1\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7A"],
        ["\xE9\xA1\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7B"],
        ["\xE6\x8E\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7C"],
        ["\xE7\xAC\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7D"],
        ["\xE6\xA8\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x7E"],
        ["\xE6\xA9\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x80"],
        ["\xE6\xA2\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x81"],
        ["\xE9\xB0\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x82"],
        ["\xE6\xBD\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x83"],
        ["\xE5\x89\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x84"],
        ["\xE5\x96\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x85"],
        ["\xE6\x81\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x86"],
        ["\xE6\x8B\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x87"],
        ["\xE6\xB4\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x88"],
        ["\xE6\xB8\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x89"],
        ["\xE6\xBB\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8A"],
        ["\xE8\x91\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8B"],
        ["\xE8\xA4\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8C"],
        ["\xE8\xBD\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8D"],
        ["\xE4\xB8\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8E"],
        ["\xE9\xB0\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x8F"],
        ["\xE5\x8F\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x90"],
        ["\xE6\xA4\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x91"],
        ["\xE6\xA8\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x92"],
        ["\xE9\x9E\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x93"],
        ["\xE6\xA0\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x94"],
        ["\xE5\x85\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x95"],
        ["\xE7\xAB\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x96"],
        ["\xE8\x92\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x97"],
        ["\xE9\x87\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],
        ["\xE9\x8E\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x99"],
        ["\xE5\x99\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9A"],
        ["\xE9\xB4\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9B"],
        ["\xE6\xA0\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9C"],
        ["\xE8\x8C\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9D"],
        ["\xE8\x90\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9E"],
        ["\xE7\xB2\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\x9F"],
        ["\xE5\x88\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA0"],
        ["\xE8\x8B\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA1"],
        ["\xE7\x93\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA2"],
        ["\xE4\xB9\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA3"],
        ["\xE4\xBE\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA4"],
        ["\xE5\x86\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA5"],
        ["\xE5\xAF\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA6"],
        ["\xE5\x88\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA7"],
        ["\xE5\x8B\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA8"],
        ["\xE5\x8B\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xA9"],
        ["\xE5\xB7\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAA"],
        ["\xE5\x96\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAB"],
        ["\xE5\xA0\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAC"],
        ["\xE5\xA7\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAD"],
        ["\xE5\xAE\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAE"],
        ["\xE5\xAE\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xAF"],
        ["\xE5\xAF\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB0"],
        ["\xE5\xB9\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB1"],
        ["\xE5\xB9\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB2"],
        ["\xE6\x82\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB3"],
        ["\xE6\x84\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB4"],
        ["\xE6\x85\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB5"],
        ["\xE6\x86\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB6"],
        ["\xE6\x8F\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB7"],
        ["\xE6\x95\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB8"],
        ["\xE6\x9F\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xB9"],
        ["\xE6\xA1\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],
        ["\xE6\xA3\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBB"],
        ["\xE6\xAC\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBC"],
        ["\xE6\xAD\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBD"],
        ["\xE6\xB1\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBE"],
        ["\xE6\xBC\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xBF"],
        ["\xE6\xBE\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC0"],
        ["\xE6\xBD\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC1"],
        ["\xE7\x92\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC2"],
        ["\xE7\x94\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC3"],
        ["\xE7\x9B\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC4"],
        ["\xE7\x9C\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC5"],
        ["\xE7\xAB\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC6"],
        ["\xE7\xAE\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC7"],
        ["\xE7\xB0\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC8"],
        ["\xE7\xB7\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xC9"],
        ["\xE7\xBC\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCA"],
        ["\xE7\xBF\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCB"],
        ["\xE8\x82\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCC"],
        ["\xE8\x89\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCD"],
        ["\xE8\x8E\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCE"],
        ["\xE8\xA6\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xCF"],
        ["\xE8\xAB\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD0"],
        ["\xE8\xB2\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD1"],
        ["\xE9\x82\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD2"],
        ["\xE9\x91\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD3"],
        ["\xE9\x96\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD4"],
        ["\xE9\x96\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD5"],
        ["\xE9\x96\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD6"],
        ["\xE9\x99\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD7"],
        ["\xE9\x9F\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD8"],
        ["\xE9\xA4\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xD9"],
        ["\xE8\x88\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDA"],
        ["\xE4\xB8\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDB"],
        ["\xE5\x90\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDC"],
        ["\xE5\xB2\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDD"],
        ["\xE5\xB7\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDE"],
        ["\xE7\x8E\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xDF"],
        ["\xE7\x99\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE0"],
        ["\xE7\x9C\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE1"],
        ["\xE5\xB2\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE2"],
        ["\xE7\xBF\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE3"],
        ["\xE8\xB4\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE4"],
        ["\xE9\x9B\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE5"],
        ["\xE9\xA0\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE6"],
        ["\xE9\xA1\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE7"],
        ["\xE9\xA1\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE8"],
        ["\xE4\xBC\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xE9"],
        ["\xE4\xBC\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEA"],
        ["\xE5\x8D\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEB"],
        ["\xE5\x96\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEC"],
        ["\xE5\x99\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xED"],
        ["\xE5\x9F\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEE"],
        ["\xE5\xA5\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xEF"],
        ["\xE5\xAC\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF0"],
        ["\xE5\xAF\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF1"],
        ["\xE5\xB2\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF2"],
        ["\xE5\xB8\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF3"],
        ["\xE5\xB9\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF4"],
        ["\xE5\xBF\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF5"],
        ["\xE6\x8F\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF6"],
        ["\xE6\x9C\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF7"],
        ["\xE6\x97\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF8"],
        ["\xE6\x97\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xF9"],
        ["\xE6\x9C\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xFA"],
        ["\xE6\xA3\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xFB"],
        ["\xE6\xA3\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8A\xFC"],
        ["\xE6\xA9\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x40"],
        ["\xE5\xB8\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x41"],
        ["\xE6\xAF\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x42"],
        ["\xE6\xB0\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x43"],
        ["\xE6\xB1\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x44"],
        ["\xE7\x95\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x45"],
        ["\xE7\xA5\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x46"],
        ["\xE5\xAD\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x47"],
        ["\xE7\xA8\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x48"],
        ["\xE7\xB4\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x49"],
        ["\xE5\xBE\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4A"],
        ["\xE8\xA6\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4B"],
        ["\xE8\xA8\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4C"],
        ["\xE8\xB2\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4D"],
        ["\xE8\xB5\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4E"],
        ["\xE8\xBB\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x4F"],
        ["\xE8\xBC\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x50"],
        ["\xE9\xA3\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x51"],
        ["\xE9\xA8\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x52"],
        ["\xE9\xAC\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x53"],
        ["\xE4\xBA\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x54"],
        ["\xE5\x81\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x55"],
        ["\xE5\x84\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x56"],
        ["\xE5\xA6\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x57"],
        ["\xE5\xAE\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x58"],
        ["\xE6\x88\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x59"],
        ["\xE6\x8A\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5A"],
        ["\xE6\x93\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5B"],
        ["\xE6\xAC\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5C"],
        ["\xE7\x8A\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5D"],
        ["\xE7\x96\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5E"],
        ["\xE7\xA5\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x5F"],
        ["\xE7\xBE\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x60"],
        ["\xE8\x9F\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x61"],
        ["\xE8\xAA\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x62"],
        ["\xE8\xAD\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x63"],
        ["\xE6\x8E\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x64"],
        ["\xE8\x8F\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x65"],
        ["\xE9\x9E\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x66"],
        ["\xE5\x90\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x67"],
        ["\xE5\x90\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x68"],
        ["\xE5\x96\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x69"],
        ["\xE6\xA1\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6A"],
        ["\xE6\xA9\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6B"],
        ["\xE8\xA9\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6C"],
        ["\xE7\xA0\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6D"],
        ["\xE6\x9D\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6E"],
        ["\xE9\xBB\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x6F"],
        ["\xE5\x8D\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x70"],
        ["\xE5\xAE\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x71"],
        ["\xE8\x84\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x72"],
        ["\xE8\x99\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x73"],
        ["\xE9\x80\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x74"],
        ["\xE4\xB8\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x75"],
        ["\xE4\xB9\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x76"],
        ["\xE4\xBB\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x77"],
        ["\xE4\xBC\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x78"],
        ["\xE5\x8F\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x79"],
        ["\xE5\x90\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7A"],
        ["\xE5\xAE\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7B"],
        ["\xE5\xBC\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7C"],
        ["\xE6\x80\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7D"],
        ["\xE6\x95\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x7E"],
        ["\xE6\x9C\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x80"],
        ["\xE6\xB1\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x81"],
        ["\xE6\xB1\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x82"],
        ["\xE6\xB3\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x83"],
        ["\xE7\x81\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x84"],
        ["\xE7\x90\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x85"],
        ["\xE7\xA9\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x86"],
        ["\xE7\xAA\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x87"],
        ["\xE7\xAC\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x88"],
        ["\xE7\xB4\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x89"],
        ["\xE7\xB3\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8A"],
        ["\xE7\xB5\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8B"],
        ["\xE6\x97\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8C"],
        ["\xE7\x89\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8D"],
        ["\xE5\x8E\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8E"],
        ["\xE5\xB1\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x8F"],
        ["\xE5\xB7\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x90"],
        ["\xE6\x8B\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x91"],
        ["\xE6\x8B\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x92"],
        ["\xE6\x8C\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x93"],
        ["\xE6\xB8\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x94"],
        ["\xE8\x99\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x95"],
        ["\xE8\xA8\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x96"],
        ["\xE8\xB7\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x97"],
        ["\xE9\x8B\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x98"],
        ["\xE6\xBC\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x99"],
        ["\xE7\xA6\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9A"],
        ["\xE9\xAD\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9B"],
        ["\xE4\xBA\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9C"],
        ["\xE4\xBA\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9D"],
        ["\xE4\xBA\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9E"],
        ["\xE4\xBE\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\x9F"],
        ["\xE4\xBE\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA0"],
        ["\xE5\x83\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA1"],
        ["\xE5\x85\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA2"],
        ["\xE7\xAB\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA3"],
        ["\xE5\x85\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA4"],
        ["\xE5\x87\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA5"],
        ["\xE5\x8D\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA6"],
        ["\xE5\x8C\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA7"],
        ["\xE5\x8D\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA8"],
        ["\xE5\x8F\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xA9"],
        ["\xE5\x96\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAA"],
        ["\xE5\xA2\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAB"],
        ["\xE5\xB3\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAC"],
        ["\xE5\xBC\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAD"],
        ["\xE5\xBD\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAE"],
        ["\xE6\x80\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xAF"],
        ["\xE6\x81\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB0"],
        ["\xE6\x81\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB1"],
        ["\xE6\x8C\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB2"],
        ["\xE6\x95\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB3"],
        ["\xE6\xA9\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB4"],
        ["\xE6\xB3\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB5"],
        ["\xE7\x8B\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB6"],
        ["\xE7\x8B\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB7"],
        ["\xE7\x9F\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB8"],
        ["\xE8\x83\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xB9"],
        ["\xE8\x84\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBA"],
        ["\xE8\x88\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBB"],
        ["\xE8\x95\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBC"],
        ["\xE9\x83\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBD"],
        ["\xE9\x8F\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBE"],
        ["\xE9\x9F\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xBF"],
        ["\xE9\xA5\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC0"],
        ["\xE9\xA9\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC1"],
        ["\xE4\xBB\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC2"],
        ["\xE5\x87\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC3"],
        ["\xE5\xB0\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC4"],
        ["\xE6\x9A\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC5"],
        ["\xE6\xA5\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC6"],
        ["\xE5\xB1\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC7"],
        ["\xE6\x9B\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC8"],
        ["\xE6\xA5\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xC9"],
        ["\xE7\x8E\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCA"],
        ["\xE6\xA1\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCB"],
        ["\xE7\xB2\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCC"],
        ["\xE5\x83\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCD"],
        ["\xE5\x8B\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCE"],
        ["\xE5\x9D\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xCF"],
        ["\xE5\xB7\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD0"],
        ["\xE9\x8C\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD1"],
        ["\xE6\x96\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD2"],
        ["\xE6\xAC\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD3"],
        ["\xE6\xAC\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD4"],
        ["\xE7\x90\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD5"],
        ["\xE7\xA6\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD6"],
        ["\xE7\xA6\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD7"],
        ["\xE7\xAD\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD8"],
        ["\xE7\xB7\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xD9"],
        ["\xE8\x8A\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDA"],
        ["\xE8\x8F\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDB"],
        ["\xE8\xA1\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDC"],
        ["\xE8\xA5\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDD"],
        ["\xE8\xAC\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDE"],
        ["\xE8\xBF\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xDF"],
        ["\xE9\x87\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE0"],
        ["\xE5\x90\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE1"],
        ["\xE9\x8A\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE2"],
        ["\xE4\xB9\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE3"],
        ["\xE5\x80\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE4"],
        ["\xE5\x8F\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE5"],
        ["\xE5\x8C\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE6"],
        ["\xE7\x8B\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE7"],
        ["\xE7\x8E\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE8"],
        ["\xE7\x9F\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xE9"],
        ["\xE8\x8B\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEA"],
        ["\xE8\xBA\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEB"],
        ["\xE9\xA7\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEC"],
        ["\xE9\xA7\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xED"],
        ["\xE9\xA7\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEE"],
        ["\xE5\x85\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xEF"],
        ["\xE6\x84\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF0"],
        ["\xE8\x99\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF1"],
        ["\xE5\x96\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF2"],
        ["\xE7\xA9\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF3"],
        ["\xE5\x81\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF4"],
        ["\xE5\xAF\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF5"],
        ["\xE9\x81\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF6"],
        ["\xE9\x9A\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF7"],
        ["\xE4\xB8\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF8"],
        ["\xE6\xAB\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xF9"],
        ["\xE9\x87\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xFA"],
        ["\xE5\xB1\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xFB"],
        ["\xE5\xB1\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8B\xFC"],
        ["\xE6\x8E\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x40"],
        ["\xE7\xAA\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x41"],
        ["\xE6\xB2\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x42"],
        ["\xE9\x9D\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x43"],
        ["\xE8\xBD\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x44"],
        ["\xE7\xAA\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x45"],
        ["\xE7\x86\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x46"],
        ["\xE9\x9A\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x47"],
        ["\xE7\xB2\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x48"],
        ["\xE6\xA0\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x49"],
        ["\xE7\xB9\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4A"],
        ["\xE6\xA1\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4B"],
        ["\xE9\x8D\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4C"],
        ["\xE5\x8B\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4D"],
        ["\xE5\x90\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4E"],
        ["\xE8\x96\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x4F"],
        ["\xE8\xA8\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x50"],
        ["\xE7\xBE\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x51"],
        ["\xE8\xBB\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x52"],
        ["\xE9\x83\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x53"],
        ["\xE5\x8D\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x54"],
        ["\xE8\xA2\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x55"],
        ["\xE7\xA5\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x56"],
        ["\xE4\xBF\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x57"],
        ["\xE5\x82\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x58"],
        ["\xE5\x88\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x59"],
        ["\xE5\x85\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5A"],
        ["\xE5\x95\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5B"],
        ["\xE5\x9C\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5C"],
        ["\xE7\x8F\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5D"],
        ["\xE5\x9E\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5E"],
        ["\xE5\xA5\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x5F"],
        ["\xE5\xBD\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x60"],
        ["\xE5\xBE\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x61"],
        ["\xE6\x81\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x62"],
        ["\xE6\x85\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x63"],
        ["\xE6\x85\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x64"],
        ["\xE6\x86\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x65"],
        ["\xE6\x8E\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x66"],
        ["\xE6\x90\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x67"],
        ["\xE6\x95\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x68"],
        ["\xE6\x99\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x69"],
        ["\xE6\xA1\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6A"],
        ["\xE6\xB8\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6B"],
        ["\xE7\x95\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6C"],
        ["\xE7\xA8\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6D"],
        ["\xE7\xB3\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6E"],
        ["\xE7\xB5\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x6F"],
        ["\xE7\xB6\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x70"],
        ["\xE7\xB9\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x71"],
        ["\xE7\xBD\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x72"],
        ["\xE8\x8C\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x73"],
        ["\xE8\x8D\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x74"],
        ["\xE8\x9B\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x75"],
        ["\xE8\xA8\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x76"],
        ["\xE8\xA9\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x77"],
        ["\xE8\xAD\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x78"],
        ["\xE8\xBB\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x79"],
        ["\xE9\xA0\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7A"],
        ["\xE9\xB6\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7B"],
        ["\xE8\x8A\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7C"],
        ["\xE8\xBF\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7D"],
        ["\xE9\xAF\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x7E"],
        ["\xE5\x8A\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x80"],
        ["\xE6\x88\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x81"],
        ["\xE6\x92\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x82"],
        ["\xE6\xBF\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x83"],
        ["\xE9\x9A\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x84"],
        ["\xE6\xA1\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x85"],
        ["\xE5\x82\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x86"],
        ["\xE6\xAC\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x87"],
        ["\xE6\xB1\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x88"],
        ["\xE6\xBD\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x89"],
        ["\xE7\xA9\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8A"],
        ["\xE7\xB5\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8B"],
        ["\xE8\xA1\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8C"],
        ["\xE8\xA8\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8D"],
        ["\xE6\x9C\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8E"],
        ["\xE4\xBB\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x8F"],
        ["\xE5\x80\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x90"],
        ["\xE5\x80\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x91"],
        ["\xE5\x81\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x92"],
        ["\xE5\x85\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x93"],
        ["\xE5\x88\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x94"],
        ["\xE5\x89\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x95"],
        ["\xE5\x96\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x96"],
        ["\xE5\x9C\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x97"],
        ["\xE5\xA0\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x98"],
        ["\xE5\xAB\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x99"],
        ["\xE5\xBB\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9A"],
        ["\xE6\x86\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9B"],
        ["\xE6\x87\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9C"],
        ["\xE6\x8B\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9D"],
        ["\xE6\x8D\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9E"],
        ["\xE6\xA4\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\x9F"],
        ["\xE6\xA8\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA0"],
        ["\xE7\x89\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA1"],
        ["\xE7\x8A\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA2"],
        ["\xE7\x8C\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA3"],
        ["\xE7\xA0\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA4"],
        ["\xE7\xA1\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA5"],
        ["\xE7\xB5\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA6"],
        ["\xE7\x9C\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA7"],
        ["\xE8\x82\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA8"],
        ["\xE8\xA6\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xA9"],
        ["\xE8\xAC\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAA"],
        ["\xE8\xB3\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAB"],
        ["\xE8\xBB\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAC"],
        ["\xE9\x81\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAD"],
        ["\xE9\x8D\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAE"],
        ["\xE9\x99\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xAF"],
        ["\xE9\xA1\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB0"],
        ["\xE9\xA8\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB1"],
        ["\xE9\xB9\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB2"],
        ["\xE5\x85\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB3"],
        ["\xE5\x8E\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB4"],
        ["\xE5\x8E\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB5"],
        ["\xE5\xB9\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB6"],
        ["\xE5\xBC\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB7"],
        ["\xE6\xB8\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB8"],
        ["\xE6\xBA\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xB9"],
        ["\xE7\x8E\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBA"],
        ["\xE7\x8F\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBB"],
        ["\xE7\xB5\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBC"],
        ["\xE8\x88\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBD"],
        ["\xE8\xA8\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBE"],
        ["\xE8\xAB\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xBF"],
        ["\xE9\x99\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC0"],
        ["\xE4\xB9\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC1"],
        ["\xE5\x80\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC2"],
        ["\xE5\x8F\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC3"],
        ["\xE5\x91\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC4"],
        ["\xE5\x9B\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC5"],
        ["\xE5\xA7\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC6"],
        ["\xE5\xAD\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC7"],
        ["\xE5\xB7\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC8"],
        ["\xE5\xBA\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xC9"],
        ["\xE5\xBC\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCA"],
        ["\xE6\x88\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCB"],
        ["\xE6\x95\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCC"],
        ["\xE6\x9E\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCD"],
        ["\xE6\xB9\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCE"],
        ["\xE7\x8B\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xCF"],
        ["\xE7\xB3\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD0"],
        ["\xE8\xA2\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD1"],
        ["\xE8\x82\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD2"],
        ["\xE8\x83\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD3"],
        ["\xE8\x8F\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD4"],
        ["\xE8\x99\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD5"],
        ["\xE8\xAA\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD6"],
        ["\xE8\xB7\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD7"],
        ["\xE9\x88\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD8"],
        ["\xE9\x9B\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xD9"],
        ["\xE9\xA1\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDA"],
        ["\xE9\xBC\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDB"],
        ["\xE4\xBA\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDC"],
        ["\xE4\xBA\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDD"],
        ["\xE4\xBC\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDE"],
        ["\xE5\x8D\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xDF"],
        ["\xE5\x91\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE0"],
        ["\xE5\x90\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE1"],
        ["\xE5\xA8\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE2"],
        ["\xE5\xBE\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE3"],
        ["\xE5\xBE\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE4"],
        ["\xE6\x82\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE5"],
        ["\xE6\xA2\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE6"],
        ["\xE6\xAA\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE7"],
        ["\xE7\x91\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE8"],
        ["\xE7\xA2\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xE9"],
        ["\xE8\xAA\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEA"],
        ["\xE8\xAA\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEB"],
        ["\xE8\xAD\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEC"],
        ["\xE9\x86\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xED"],
        ["\xE4\xB9\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEE"],
        ["\xE9\xAF\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xEF"],
        ["\xE4\xBA\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF0"],
        ["\xE4\xBD\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF1"],
        ["\xE4\xBE\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF2"],
        ["\xE5\x80\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF3"],
        ["\xE5\x80\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF4"],
        ["\xE5\x85\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF5"],
        ["\xE5\x85\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF6"],
        ["\xE5\x8A\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF7"],
        ["\xE5\x8A\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF8"],
        ["\xE5\x8B\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xF9"],
        ["\xE5\x8E\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xFA"],
        ["\xE5\x8F\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xFB"],
        ["\xE5\x90\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8C\xFC"],
        ["\xE5\x90\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x40"],
        ["\xE5\x96\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x41"],
        ["\xE5\x9D\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x42"],
        ["\xE5\x9E\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x43"],
        ["\xE5\xA5\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x44"],
        ["\xE5\xAD\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x45"],
        ["\xE5\xAD\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x46"],
        ["\xE5\xAE\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x47"],
        ["\xE5\xB7\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x48"],
        ["\xE5\xB7\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x49"],
        ["\xE5\xB7\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4A"],
        ["\xE5\xB9\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4B"],
        ["\xE5\xBA\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4C"],
        ["\xE5\xBA\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4D"],
        ["\xE5\xBA\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4E"],
        ["\xE5\xBC\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x4F"],
        ["\xE6\x81\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x50"],
        ["\xE6\x85\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x51"],
        ["\xE6\x8A\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x52"],
        ["\xE6\x8B\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x53"],
        ["\xE6\x8E\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x54"],
        ["\xE6\x94\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x55"],
        ["\xE6\x98\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x56"],
        ["\xE6\x99\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x57"],
        ["\xE6\x9B\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x58"],
        ["\xE6\x9D\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x59"],
        ["\xE6\xA0\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5A"],
        ["\xE6\xA2\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5B"],
        ["\xE6\xA7\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5C"],
        ["\xE6\xB1\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5D"],
        ["\xE6\xB4\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5E"],
        ["\xE6\xB5\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x5F"],
        ["\xE6\xB8\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x60"],
        ["\xE6\xBA\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x61"],
        ["\xE7\x94\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x62"],
        ["\xE7\x9A\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x63"],
        ["\xE7\xA1\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x64"],
        ["\xE7\xA8\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x65"],
        ["\xE7\xB3\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x66"],
        ["\xE7\xB4\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x67"],
        ["\xE7\xB4\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x68"],
        ["\xE7\xB5\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x69"],
        ["\xE7\xB6\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6A"],
        ["\xE8\x80\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6B"],
        ["\xE8\x80\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6C"],
        ["\xE8\x82\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6D"],
        ["\xE8\x82\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6E"],
        ["\xE8\x85\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x6F"],
        ["\xE8\x86\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x70"],
        ["\xE8\x88\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x71"],
        ["\xE8\x8D\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x72"],
        ["\xE8\xA1\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x73"],
        ["\xE8\xA1\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x74"],
        ["\xE8\xAC\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x75"],
        ["\xE8\xB2\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x76"],
        ["\xE8\xB3\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x77"],
        ["\xE9\x83\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x78"],
        ["\xE9\x85\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x79"],
        ["\xE9\x89\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7A"],
        ["\xE7\xA0\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7B"],
        ["\xE9\x8B\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7C"],
        ["\xE9\x96\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7D"],
        ["\xE9\x99\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x7E"],
        ["\xE9\xA0\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x80"],
        ["\xE9\xA6\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x81"],
        ["\xE9\xAB\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x82"],
        ["\xE9\xB4\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x83"],
        ["\xE5\x89\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x84"],
        ["\xE5\x8A\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x85"],
        ["\xE5\x8F\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x86"],
        ["\xE5\x90\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x87"],
        ["\xE5\xA3\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x88"],
        ["\xE6\x8B\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x89"],
        ["\xE6\xBF\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8A"],
        ["\xE8\xB1\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8B"],
        ["\xE8\xBD\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8C"],
        ["\xE9\xBA\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8D"],
        ["\xE5\x85\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8E"],
        ["\xE5\x88\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x8F"],
        ["\xE5\x91\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x90"],
        ["\xE5\x9B\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x91"],
        ["\xE7\xA9\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x92"],
        ["\xE9\x85\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x93"],
        ["\xE9\xB5\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x94"],
        ["\xE9\xBB\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x95"],
        ["\xE7\x8D\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x96"],
        ["\xE6\xBC\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x97"],
        ["\xE8\x85\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x98"],
        ["\xE7\x94\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x99"],
        ["\xE5\xBF\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9A"],
        ["\xE6\x83\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9B"],
        ["\xE9\xAA\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9C"],
        ["\xE7\x8B\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9D"],
        ["\xE8\xBE\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9E"],
        ["\xE6\xAD\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\x9F"],
        ["\xE9\xA0\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA0"],
        ["\xE4\xBB\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA1"],
        ["\xE5\x9B\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA2"],
        ["\xE5\x9D\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA3"],
        ["\xE5\xA2\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA4"],
        ["\xE5\xA9\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA5"],
        ["\xE6\x81\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA6"],
        ["\xE6\x87\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA7"],
        ["\xE6\x98\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA8"],
        ["\xE6\x98\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xA9"],
        ["\xE6\xA0\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAA"],
        ["\xE6\xA2\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAB"],
        ["\xE6\xB7\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAC"],
        ["\xE7\x97\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAD"],
        ["\xE7\xB4\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAE"],
        ["\xE8\x89\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xAF"],
        ["\xE9\xAD\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB0"],
        ["\xE4\xBA\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB1"],
        ["\xE4\xBD\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB2"],
        ["\xE5\x8F\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB3"],
        ["\xE5\x94\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB4"],
        ["\xE5\xB5\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB5"],
        ["\xE5\xB7\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB6"],
        ["\xE5\xB7\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB7"],
        ["\xE6\x9F\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB8"],
        ["\xE6\xB2\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xB9"],
        ["\xE7\x91\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBA"],
        ["\xE7\xA0\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBB"],
        ["\xE8\xA9\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBC"],
        ["\xE9\x8E\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBD"],
        ["\xE8\xA3\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBE"],
        ["\xE5\x9D\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xBF"],
        ["\xE5\xBA\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC0"],
        ["\xE6\x8C\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC1"],
        ["\xE5\x82\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC2"],
        ["\xE5\x82\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC3"],
        ["\xE5\x86\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC4"],
        ["\xE6\x9C\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC5"],
        ["\xE5\x93\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC6"],
        ["\xE5\xA1\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC7"],
        ["\xE5\xA6\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC8"],
        ["\xE5\xAE\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xC9"],
        ["\xE5\xBD\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCA"],
        ["\xE6\x89\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCB"],
        ["\xE6\x8E\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCC"],
        ["\xE6\xA0\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCD"],
        ["\xE6\xAD\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCE"],
        ["\xE6\xB8\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xCF"],
        ["\xE7\x81\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD0"],
        ["\xE9\x87\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD1"],
        ["\xE7\x8A\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD2"],
        ["\xE7\xA0\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD3"],
        ["\xE7\xA0\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD4"],
        ["\xE7\xA5\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD5"],
        ["\xE6\x96\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD6"],
        ["\xE7\xB4\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD7"],
        ["\xE8\x8F\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD8"],
        ["\xE8\xA3\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xD9"],
        ["\xE8\xBC\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDA"],
        ["\xE9\x9A\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDB"],
        ["\xE5\x89\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDC"],
        ["\xE5\x9C\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDD"],
        ["\xE6\x9D\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDE"],
        ["\xE7\xBD\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xDF"],
        ["\xE8\xB2\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE0"],
        ["\xE5\x86\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE1"],
        ["\xE5\x9D\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE2"],
        ["\xE9\x98\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE3"],
        ["\xE5\xA0\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE4"],
        ["\xE6\xA6\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE5"],
        ["\xE8\x82\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE6"],
        ["\xE5\x92\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE7"],
        ["\xE5\xB4\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE8"],
        ["\xE5\x9F\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xE9"],
        ["\xE7\xA2\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEA"],
        ["\xE9\xB7\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEB"],
        ["\xE4\xBD\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEC"],
        ["\xE5\x89\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xED"],
        ["\xE5\x92\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEE"],
        ["\xE6\x90\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xEF"],
        ["\xE6\x98\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF0"],
        ["\xE6\x9C\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF1"],
        ["\xE6\x9F\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF2"],
        ["\xE7\xAA\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF3"],
        ["\xE7\xAD\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF4"],
        ["\xE7\xB4\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF5"],
        ["\xE9\x8C\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF6"],
        ["\xE6\xA1\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF7"],
        ["\xE9\xAE\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF8"],
        ["\xE7\xAC\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xF9"],
        ["\xE5\x8C\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xFA"],
        ["\xE5\x86\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xFB"],
        ["\xE5\x88\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8D\xFC"],
        ["\xE5\xAF\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x40"],
        ["\xE6\x8B\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x41"],
        ["\xE6\x92\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x42"],
        ["\xE6\x93\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x43"],
        ["\xE6\x9C\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x44"],
        ["\xE6\xAE\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x45"],
        ["\xE8\x96\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x46"],
        ["\xE9\x9B\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x47"],
        ["\xE7\x9A\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x48"],
        ["\xE9\xAF\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x49"],
        ["\xE6\x8D\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4A"],
        ["\xE9\x8C\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4B"],
        ["\xE9\xAE\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4C"],
        ["\xE7\x9A\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4D"],
        ["\xE6\x99\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4E"],
        ["\xE4\xB8\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x4F"],
        ["\xE5\x82\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x50"],
        ["\xE5\x8F\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x51"],
        ["\xE5\xB1\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x52"],
        ["\xE6\x83\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x53"],
        ["\xE6\x92\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x54"],
        ["\xE6\x95\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x55"],
        ["\xE6\xA1\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x56"],
        ["\xE7\x87\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x57"],
        ["\xE7\x8F\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x58"],
        ["\xE7\x94\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x59"],
        ["\xE7\xAE\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5A"],
        ["\xE7\xBA\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5B"],
        ["\xE8\x9A\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5C"],
        ["\xE8\xAE\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5D"],
        ["\xE8\xB3\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5E"],
        ["\xE9\x85\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x5F"],
        ["\xE9\xA4\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x60"],
        ["\xE6\x96\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x61"],
        ["\xE6\x9A\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x62"],
        ["\xE6\xAE\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x63"],
        ["\xE4\xBB\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x64"],
        ["\xE4\xBB\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x65"],
        ["\xE4\xBC\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x66"],
        ["\xE4\xBD\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x67"],
        ["\xE5\x88\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x68"],
        ["\xE5\x8F\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x69"],
        ["\xE5\x8F\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6A"],
        ["\xE5\x97\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6B"],
        ["\xE5\x9B\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6C"],
        ["\xE5\xA3\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6D"],
        ["\xE5\xA7\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6E"],
        ["\xE5\xA7\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x6F"],
        ["\xE5\xA7\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x70"],
        ["\xE5\xAD\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x71"],
        ["\xE5\xB1\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x72"],
        ["\xE5\xB8\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x73"],
        ["\xE5\xB8\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x74"],
        ["\xE5\xBF\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x75"],
        ["\xE6\x80\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x76"],
        ["\xE6\x8C\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x77"],
        ["\xE6\x94\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x78"],
        ["\xE5\xAD\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x79"],
        ["\xE6\x96\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7A"],
        ["\xE6\x96\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7B"],
        ["\xE6\x97\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7C"],
        ["\xE6\x9E\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7D"],
        ["\xE6\xAD\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x7E"],
        ["\xE6\xAD\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x80"],
        ["\xE6\xB0\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x81"],
        ["\xE7\x8D\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x82"],
        ["\xE7\xA5\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x83"],
        ["\xE7\xA7\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x84"],
        ["\xE7\xB3\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x85"],
        ["\xE7\xB4\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\xE7\xB4\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x87"],
        ["\xE8\x82\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x88"],
        ["\xE8\x84\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x89"],
        ["\xE8\x87\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8A"],
        ["\xE8\xA6\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8B"],
        ["\xE8\xA9\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8C"],
        ["\xE8\xA9\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8D"],
        ["\xE8\xA9\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8E"],
        ["\xE8\xAA\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x8F"],
        ["\xE8\xAB\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],
        ["\xE8\xB3\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x91"],
        ["\xE8\xB3\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x92"],
        ["\xE9\x9B\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x93"],
        ["\xE9\xA3\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x94"],
        ["\xE6\xAD\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x95"],
        ["\xE4\xBA\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x96"],
        ["\xE4\xBC\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x97"],
        ["\xE4\xBE\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x98"],
        ["\xE5\x85\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x99"],
        ["\xE5\xAD\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9A"],
        ["\xE5\xAF\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9B"],
        ["\xE6\x85\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9C"],
        ["\xE6\x8C\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9D"],
        ["\xE6\x99\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9E"],
        ["\xE6\xAC\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\x9F"],
        ["\xE6\xBB\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA0"],
        ["\xE6\xB2\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA1"],
        ["\xE7\x88\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA2"],
        ["\xE7\x92\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA3"],
        ["\xE7\x97\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA4"],
        ["\xE7\xA3\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA5"],
        ["\xE7\xA4\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA6"],
        ["\xE8\x80\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA7"],
        ["\xE8\x80\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA8"],
        ["\xE8\x87\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xA9"],
        ["\xE8\x92\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],
        ["\xE8\xBE\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAB"],
        ["\xE6\xB1\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAC"],
        ["\xE9\xB9\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAD"],
        ["\xE5\xBC\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAE"],
        ["\xE8\xAD\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xAF"],
        ["\xE9\xB4\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB0"],
        ["\xE7\xAB\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB1"],
        ["\xE8\xBB\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB2"],
        ["\xE5\xAE\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB3"],
        ["\xE9\x9B\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB4"],
        ["\xE4\xB8\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB5"],
        ["\xE5\x8F\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB6"],
        ["\xE5\x9F\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB7"],
        ["\xE5\xA4\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB8"],
        ["\xE5\xAB\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xB9"],
        ["\xE5\xAE\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBA"],
        ["\xE6\x82\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBB"],
        ["\xE6\xB9\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBC"],
        ["\xE6\xBC\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBD"],
        ["\xE7\x96\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBE"],
        ["\xE8\xB3\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xBF"],
        ["\xE5\xAE\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC0"],
        ["\xE8\x94\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC1"],
        ["\xE7\xAF\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC2"],
        ["\xE5\x81\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC3"],
        ["\xE6\x9F\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC4"],
        ["\xE8\x8A\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC5"],
        ["\xE5\xB1\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC6"],
        ["\xE8\x95\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC7"],
        ["\xE7\xB8\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC8"],
        ["\xE8\x88\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xC9"],
        ["\xE5\x86\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCA"],
        ["\xE5\xB0\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCB"],
        ["\xE6\x8D\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCC"],
        ["\xE8\xB5\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCD"],
        ["\xE6\x96\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCE"],
        ["\xE7\x85\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xCF"],
        ["\xE7\xA4\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD0"],
        ["\xE7\xB4\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD1"],
        ["\xE8\x80\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD2"],
        ["\xE8\xAC\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD3"],
        ["\xE8\xBB\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD4"],
        ["\xE9\x81\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD5"],
        ["\xE8\x9B\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD6"],
        ["\xE9\x82\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD7"],
        ["\xE5\x80\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD8"],
        ["\xE5\x8B\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xD9"],
        ["\xE5\xB0\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDA"],
        ["\xE6\x9D\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDB"],
        ["\xE7\x81\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDC"],
        ["\xE7\x88\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDD"],
        ["\xE9\x85\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDE"],
        ["\xE9\x87\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xDF"],
        ["\xE9\x8C\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE0"],
        ["\xE8\x8B\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE1"],
        ["\xE5\xAF\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE2"],
        ["\xE5\xBC\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE3"],
        ["\xE6\x83\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE4"],
        ["\xE4\xB8\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE5"],
        ["\xE5\x8F\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE6"],
        ["\xE5\xAE\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE7"],
        ["\xE6\x89\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE8"],
        ["\xE6\x9C\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xE9"],
        ["\xE6\xAE\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEA"],
        ["\xE7\x8B\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEB"],
        ["\xE7\x8F\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEC"],
        ["\xE7\xA8\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xED"],
        ["\xE8\x85\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEE"],
        ["\xE8\xB6\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xEF"],
        ["\xE9\x85\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF0"],
        ["\xE9\xA6\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF1"],
        ["\xE5\x84\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF2"],
        ["\xE5\x8F\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF3"],
        ["\xE5\x91\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF4"],
        ["\xE5\xAF\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF5"],
        ["\xE6\x8E\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF6"],
        ["\xE6\xA8\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF7"],
        ["\xE7\xB6\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF8"],
        ["\xE9\x9C\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xF9"],
        ["\xE5\x9B\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xFA"],
        ["\xE5\x8F\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xFB"],
        ["\xE5\x91\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8E\xFC"],
        ["\xE5\xAE\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x40"],
        ["\xE5\xB0\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x41"],
        ["\xE5\xB7\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x42"],
        ["\xE4\xBF\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x43"],
        ["\xE6\x84\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x44"],
        ["\xE6\x8B\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x45"],
        ["\xE6\xB4\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x46"],
        ["\xE7\xA7\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x47"],
        ["\xE7\xA7\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x48"],
        ["\xE7\xB5\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x49"],
        ["\xE7\xB9\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4A"],
        ["\xE7\xBF\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4B"],
        ["\xE8\x87\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4C"],
        ["\xE8\x88\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4D"],
        ["\xE8\x92\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4E"],
        ["\xE8\xA1\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x4F"],
        ["\xE8\xA5\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x50"],
        ["\xE8\xAE\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x51"],
        ["\xE8\xB9\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x52"],
        ["\xE8\xBC\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x53"],
        ["\xE9\x80\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x54"],
        ["\xE9\x85\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x55"],
        ["\xE9\x85\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x56"],
        ["\xE9\x9B\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x57"],
        ["\xE9\x86\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x58"],
        ["\xE4\xBB\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x59"],
        ["\xE4\xBD\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5A"],
        ["\xE5\x85\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5B"],
        ["\xE5\x8D\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5C"],
        ["\xE5\xBE\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5D"],
        ["\xE6\x88\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5E"],
        ["\xE6\x9F\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x5F"],
        ["\xE6\xB1\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x60"],
        ["\xE6\xB8\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x61"],
        ["\xE7\x8D\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x62"],
        ["\xE7\xB8\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x63"],
        ["\xE9\x87\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x64"],
        ["\xE9\x8A\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x65"],
        ["\xE5\x8F\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x66"],
        ["\xE5\xA4\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x67"],
        ["\xE5\xAE\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x68"],
        ["\xE6\xB7\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x69"],
        ["\xE7\xA5\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6A"],
        ["\xE7\xB8\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6B"],
        ["\xE7\xB2\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6C"],
        ["\xE5\xA1\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6D"],
        ["\xE7\x86\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6E"],
        ["\xE5\x87\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x6F"],
        ["\xE8\xA1\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x70"],
        ["\xE8\xBF\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x71"],
        ["\xE4\xBF\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x72"],
        ["\xE5\xB3\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x73"],
        ["\xE6\x98\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x74"],
        ["\xE7\x9E\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x75"],
        ["\xE7\xAB\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x76"],
        ["\xE8\x88\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x77"],
        ["\xE9\xA7\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x78"],
        ["\xE5\x87\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x79"],
        ["\xE5\xBE\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7A"],
        ["\xE6\x97\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7B"],
        ["\xE6\xA5\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7C"],
        ["\xE6\xAE\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7D"],
        ["\xE6\xB7\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x7E"],
        ["\xE6\xBA\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x80"],
        ["\xE6\xBD\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x81"],
        ["\xE7\x9B\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x82"],
        ["\xE7\xB4\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x83"],
        ["\xE5\xB7\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x84"],
        ["\xE9\x81\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x85"],
        ["\xE9\x86\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x86"],
        ["\xE9\xA0\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x87"],
        ["\xE5\x87\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x88"],
        ["\xE5\x88\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x89"],
        ["\xE6\x89\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8A"],
        ["\xE6\x9A\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8B"],
        ["\xE6\x9B\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8C"],
        ["\xE6\xB8\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8D"],
        ["\xE5\xBA\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8E"],
        ["\xE7\xB7\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x8F"],
        ["\xE7\xBD\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x90"],
        ["\xE6\x9B\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x91"],
        ["\xE8\x96\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x92"],
        ["\xE8\x97\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x93"],
        ["\xE8\xAB\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x94"],
        ["\xE5\x8A\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x95"],
        ["\xE5\x8F\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x96"],
        ["\xE5\xA5\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x97"],
        ["\xE5\xBA\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x98"],
        ["\xE5\xBE\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x99"],
        ["\xE6\x81\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9A"],
        ["\xE9\x8B\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9B"],
        ["\xE9\x99\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9C"],
        ["\xE5\x82\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9D"],
        ["\xE5\x84\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9E"],
        ["\xE5\x8B\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\x9F"],
        ["\xE5\x8C\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA0"],
        ["\xE5\x8D\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA1"],
        ["\xE5\x8F\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA2"],
        ["\xE5\x93\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA3"],
        ["\xE5\x95\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA4"],
        ["\xE5\x94\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA5"],
        ["\xE5\x98\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA6"],
        ["\xE5\xA5\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA7"],
        ["\xE5\xA6\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA8"],
        ["\xE5\xA8\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xA9"],
        ["\xE5\xAE\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAA"],
        ["\xE5\xB0\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAB"],
        ["\xE5\xB0\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAC"],
        ["\xE5\xB0\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAD"],
        ["\xE5\xB0\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAE"],
        ["\xE5\xBA\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xAF"],
        ["\xE5\xBA\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB0"],
        ["\xE5\xBB\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB1"],
        ["\xE5\xBD\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB2"],
        ["\xE6\x89\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB3"],
        ["\xE6\x8A\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB4"],
        ["\xE6\x8B\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB5"],
        ["\xE6\x8E\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB6"],
        ["\xE6\x8D\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB7"],
        ["\xE6\x98\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB8"],
        ["\xE6\x98\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xB9"],
        ["\xE6\x98\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBA"],
        ["\xE6\x99\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBB"],
        ["\xE6\x9D\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBC"],
        ["\xE6\xA2\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBD"],
        ["\xE6\xA8\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBE"],
        ["\xE6\xA8\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xBF"],
        ["\xE6\xB2\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC0"],
        ["\xE6\xB6\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC1"],
        ["\xE6\xB8\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC2"],
        ["\xE6\xB9\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC3"],
        ["\xE7\x84\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC4"],
        ["\xE7\x84\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC5"],
        ["\xE7\x85\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC6"],
        ["\xE7\x97\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC7"],
        ["\xE7\x9C\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC8"],
        ["\xE7\xA1\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xC9"],
        ["\xE7\xA4\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCA"],
        ["\xE7\xA5\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCB"],
        ["\xE7\xA7\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCC"],
        ["\xE7\xAB\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCD"],
        ["\xE7\xAC\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCE"],
        ["\xE7\xB2\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xCF"],
        ["\xE7\xB4\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD0"],
        ["\xE8\x82\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD1"],
        ["\xE8\x8F\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD2"],
        ["\xE8\x92\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD3"],
        ["\xE8\x95\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD4"],
        ["\xE8\xA1\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD5"],
        ["\xE8\xA3\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD6"],
        ["\xE8\xA8\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD7"],
        ["\xE8\xA8\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD8"],
        ["\xE8\xA9\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xD9"],
        ["\xE8\xA9\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDA"],
        ["\xE8\xB1\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDB"],
        ["\xE8\xB3\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDC"],
        ["\xE9\x86\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDD"],
        ["\xE9\x89\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDE"],
        ["\xE9\x8D\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xDF"],
        ["\xE9\x90\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE0"],
        ["\xE9\x9A\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE1"],
        ["\xE9\x9E\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE2"],
        ["\xE4\xB8\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE3"],
        ["\xE4\xB8\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE4"],
        ["\xE4\xB8\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE5"],
        ["\xE4\xB9\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE6"],
        ["\xE5\x86\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE7"],
        ["\xE5\x89\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE8"],
        ["\xE5\x9F\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xE9"],
        ["\xE5\xA0\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEA"],
        ["\xE5\xA3\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEB"],
        ["\xE5\xAC\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEC"],
        ["\xE5\xB8\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xED"],
        ["\xE6\x83\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEE"],
        ["\xE6\x93\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xEF"],
        ["\xE6\x9D\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF0"],
        ["\xE6\x9D\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF1"],
        ["\xE6\xB5\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF2"],
        ["\xE7\x8A\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF3"],
        ["\xE7\x95\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF4"],
        ["\xE7\xA9\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF5"],
        ["\xE8\x92\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF6"],
        ["\xE8\xAD\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF7"],
        ["\xE9\x86\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF8"],
        ["\xE9\x8C\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xF9"],
        ["\xE5\x98\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xFA"],
        ["\xE5\x9F\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xFB"],
        ["\xE9\xA3\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x8F\xFC"],
        ["\xE6\x8B\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x40"],
        ["\xE6\xA4\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x41"],
        ["\xE6\xAE\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x42"],
        ["\xE7\x87\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x43"],
        ["\xE7\xB9\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x44"],
        ["\xE8\x81\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x45"],
        ["\xE8\x89\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x46"],
        ["\xE8\xA7\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x47"],
        ["\xE9\xA3\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x48"],
        ["\xE8\x9D\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x49"],
        ["\xE8\xBE\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4A"],
        ["\xE5\xB0\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4B"],
        ["\xE4\xBC\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4C"],
        ["\xE4\xBF\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4D"],
        ["\xE4\xBE\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4E"],
        ["\xE5\x94\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x4F"],
        ["\xE5\xA8\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x50"],
        ["\xE5\xAF\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x51"],
        ["\xE5\xAF\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x52"],
        ["\xE5\xBF\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x53"],
        ["\xE6\x85\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x54"],
        ["\xE6\x8C\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x55"],
        ["\xE6\x96\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x56"],
        ["\xE6\x99\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x57"],
        ["\xE6\xA3\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x58"],
        ["\xE6\xA6\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x59"],
        ["\xE6\xB5\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5A"],
        ["\xE6\xB7\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5B"],
        ["\xE7\x94\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5C"],
        ["\xE7\x96\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5D"],
        ["\xE7\x9C\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5E"],
        ["\xE7\xA5\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x5F"],
        ["\xE7\xA7\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x60"],
        ["\xE7\xB4\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x61"],
        ["\xE8\x87\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x62"],
        ["\xE8\x8A\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x63"],
        ["\xE8\x96\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x64"],
        ["\xE8\xA6\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x65"],
        ["\xE8\xA8\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x66"],
        ["\xE8\xBA\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x67"],
        ["\xE8\xBE\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x68"],
        ["\xE9\x80\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x69"],
        ["\xE9\x87\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6A"],
        ["\xE9\x9C\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6B"],
        ["\xE4\xBA\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6C"],
        ["\xE4\xBB\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6D"],
        ["\xE5\x88\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6E"],
        ["\xE5\xA1\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x6F"],
        ["\xE5\xA3\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x70"],
        ["\xE5\xB0\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x71"],
        ["\xE7\x94\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x72"],
        ["\xE5\xB0\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x73"],
        ["\xE8\x85\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x74"],
        ["\xE8\xA8\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x75"],
        ["\xE8\xBF\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x76"],
        ["\xE9\x99\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x77"],
        ["\xE9\x9D\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x78"],
        ["\xE7\xAC\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x79"],
        ["\xE8\xAB\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7A"],
        ["\xE9\xA0\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7B"],
        ["\xE9\x85\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7C"],
        ["\xE5\x9B\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7D"],
        ["\xE5\x8E\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x7E"],
        ["\xE9\x80\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x80"],
        ["\xE5\x90\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x81"],
        ["\xE5\x9E\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x82"],
        ["\xE5\xB8\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x83"],
        ["\xE6\x8E\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x84"],
        ["\xE6\xB0\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x85"],
        ["\xE7\x82\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x86"],
        ["\xE7\x9D\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],
        ["\xE7\xB2\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x88"],
        ["\xE7\xBF\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x89"],
        ["\xE8\xA1\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8A"],
        ["\xE9\x81\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8B"],
        ["\xE9\x85\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8C"],
        ["\xE9\x8C\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8D"],
        ["\xE9\x8C\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8E"],
        ["\xE9\x9A\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x8F"],
        ["\xE7\x91\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x90"],
        ["\xE9\xAB\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x91"],
        ["\xE5\xB4\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x92"],
        ["\xE5\xB5\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x93"],
        ["\xE6\x95\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x94"],
        ["\xE6\x9E\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x95"],
        ["\xE8\xB6\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x96"],
        ["\xE9\x9B\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x97"],
        ["\xE6\x8D\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x98"],
        ["\xE6\x9D\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x99"],
        ["\xE6\xA4\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9A"],
        ["\xE8\x8F\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9B"],
        ["\xE9\xA0\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9C"],
        ["\xE9\x9B\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9D"],
        ["\xE8\xA3\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9E"],
        ["\xE6\xBE\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\x9F"],
        ["\xE6\x91\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA0"],
        ["\xE5\xAF\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA1"],
        ["\xE4\xB8\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA2"],
        ["\xE7\x80\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\xE7\x95\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA4"],
        ["\xE6\x98\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA5"],
        ["\xE5\x87\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA6"],
        ["\xE5\x88\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA7"],
        ["\xE5\x8B\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA8"],
        ["\xE5\xA7\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xA9"],
        ["\xE5\xBE\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAA"],
        ["\xE6\x80\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAB"],
        ["\xE6\x88\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAC"],
        ["\xE6\x94\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAD"],
        ["\xE6\x95\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAE"],
        ["\xE6\x98\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xAF"],
        ["\xE6\x99\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB0"],
        ["\xE6\xA3\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB1"],
        ["\xE6\xA0\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB2"],
        ["\xE6\xAD\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB3"],
        ["\xE6\xB8\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB4"],
        ["\xE7\x89\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB5"],
        ["\xE7\x94\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB6"],
        ["\xE7\x9B\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB7"],
        ["\xE7\xB2\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB8"],
        ["\xE8\x81\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xB9"],
        ["\xE5\xA3\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBA"],
        ["\xE8\xA3\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBB"],
        ["\xE8\xA5\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBC"],
        ["\xE8\xAA\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBD"],
        ["\xE8\xAA\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBE"],
        ["\xE8\xAB\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xBF"],
        ["\xE9\x80\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC0"],
        ["\xE9\x86\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC1"],
        ["\xE9\x9D\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC2"],
        ["\xE9\x9D\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC3"],
        ["\xE6\x96\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC4"],
        ["\xE7\xA8\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC5"],
        ["\xE8\x84\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC6"],
        ["\xE9\x9A\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC7"],
        ["\xE5\xB8\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC8"],
        ["\xE6\x83\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xC9"],
        ["\xE6\x88\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCA"],
        ["\xE6\x96\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCB"],
        ["\xE6\x98\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCC"],
        ["\xE6\x9E\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCD"],
        ["\xE7\x9F\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCE"],
        ["\xE7\xA9\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xCF"],
        ["\xE7\xB1\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD0"],
        ["\xE7\xB8\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD1"],
        ["\xE8\x84\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD2"],
        ["\xE8\xB2\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD3"],
        ["\xE8\xB5\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD4"],
        ["\xE8\xB7\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD5"],
        ["\xE8\xB9\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD6"],
        ["\xE7\xA2\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD7"],
        ["\xE5\x88\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD8"],
        ["\xE6\x8B\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xD9"],
        ["\xE6\x8E\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDA"],
        ["\xE6\x91\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDB"],
        ["\xE6\x8A\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDC"],
        ["\xE8\xA8\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDD"],
        ["\xE7\xAA\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDE"],
        ["\xE7\xAF\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xDF"],
        ["\xE8\xAA\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE0"],
        ["\xE9\x9B\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE1"],
        ["\xE7\xB5\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE2"],
        ["\xE8\x88\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE3"],
        ["\xE8\x9D\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE4"],
        ["\xE4\xBB\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE5"],
        ["\xE5\x85\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE6"],
        ["\xE5\x8D\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE7"],
        ["\xE5\x8D\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE8"],
        ["\xE5\xAE\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xE9"],
        ["\xE5\xB0\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEA"],
        ["\xE5\xB0\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEB"],
        ["\xE5\xB7\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEC"],
        ["\xE6\x88\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xED"],
        ["\xE6\x89\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEE"],
        ["\xE6\x92\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xEF"],
        ["\xE6\xA0\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF0"],
        ["\xE6\xA0\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF1"],
        ["\xE6\xB3\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF2"],
        ["\xE6\xB5\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF3"],
        ["\xE6\xB4\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF4"],
        ["\xE6\x9F\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF5"],
        ["\xE6\xBD\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF6"],
        ["\xE7\x85\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF7"],
        ["\xE7\x85\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF8"],
        ["\xE6\x97\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xF9"],
        ["\xE7\xA9\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xFA"],
        ["\xE7\xAE\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xFB"],
        ["\xE7\xB7\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x90\xFC"],
        ["\xE7\xB9\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x40"],
        ["\xE7\xBE\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x41"],
        ["\xE8\x85\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x42"],
        ["\xE8\x88\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x43"],
        ["\xE8\x88\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x44"],
        ["\xE8\x96\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x45"],
        ["\xE8\xA9\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x46"],
        ["\xE8\xB3\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x47"],
        ["\xE8\xB7\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x48"],
        ["\xE9\x81\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x49"],
        ["\xE9\x81\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4A"],
        ["\xE9\x8A\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4B"],
        ["\xE9\x8A\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4C"],
        ["\xE9\x96\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4D"],
        ["\xE9\xAE\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4E"],
        ["\xE5\x89\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x4F"],
        ["\xE5\x96\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x50"],
        ["\xE6\xBC\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x51"],
        ["\xE7\x84\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x52"],
        ["\xE5\x85\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x53"],
        ["\xE7\xA6\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x54"],
        ["\xE7\xB9\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x55"],
        ["\xE8\x86\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x56"],
        ["\xE7\xB3\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x57"],
        ["\xE5\x99\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x58"],
        ["\xE5\xA1\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x59"],
        ["\xE5\xB2\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5A"],
        ["\xE6\x8E\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5B"],
        ["\xE6\x9B\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5C"],
        ["\xE6\x9B\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5D"],
        ["\xE6\xA5\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5E"],
        ["\xE7\x8B\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x5F"],
        ["\xE7\x96\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x60"],
        ["\xE7\x96\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x61"],
        ["\xE7\xA4\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x62"],
        ["\xE7\xA5\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x63"],
        ["\xE7\xA7\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x64"],
        ["\xE7\xB2\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x65"],
        ["\xE7\xB4\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x66"],
        ["\xE7\xB5\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x67"],
        ["\xE8\x98\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x68"],
        ["\xE8\xA8\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x69"],
        ["\xE9\x98\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6A"],
        ["\xE9\x81\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6B"],
        ["\xE9\xBC\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6C"],
        ["\xE5\x83\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6D"],
        ["\xE5\x89\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6E"],
        ["\xE5\x8F\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x6F"],
        ["\xE5\x8F\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x70"],
        ["\xE5\x80\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x71"],
        ["\xE5\x96\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x72"],
        ["\xE5\xA3\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x73"],
        ["\xE5\xA5\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x74"],
        ["\xE7\x88\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x75"],
        ["\xE5\xAE\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x76"],
        ["\xE5\xB1\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x77"],
        ["\xE5\x8C\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x78"],
        ["\xE6\x83\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x79"],
        ["\xE6\x83\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7A"],
        ["\xE6\x8D\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7B"],
        ["\xE6\x8E\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7C"],
        ["\xE6\x8C\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7D"],
        ["\xE6\x8E\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x7E"],
        ["\xE6\x93\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x80"],
        ["\xE6\x97\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x81"],
        ["\xE6\x9B\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x82"],
        ["\xE5\xB7\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x83"],
        ["\xE6\xA7\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x84"],
        ["\xE6\xA7\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x85"],
        ["\xE6\xBC\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x86"],
        ["\xE7\x87\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x87"],
        ["\xE4\xBA\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x88"],
        ["\xE7\x97\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x89"],
        ["\xE7\x9B\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8A"],
        ["\xE7\xAA\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8B"],
        ["\xE7\xB3\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8C"],
        ["\xE7\xB7\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8D"],
        ["\xE7\xB6\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8E"],
        ["\xE8\x81\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x8F"],
        ["\xE8\x8D\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x90"],
        ["\xE8\x8D\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x91"],
        ["\xE8\x91\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x92"],
        ["\xE8\x92\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x93"],
        ["\xE8\x97\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x94"],
        ["\xE8\xA3\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x95"],
        ["\xE8\xB5\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x96"],
        ["\xE9\x80\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x97"],
        ["\xE9\x81\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x98"],
        ["\xE9\x8E\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x99"],
        ["\xE9\x9C\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9A"],
        ["\xE9\xA8\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9B"],
        ["\xE5\x83\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9C"],
        ["\xE5\xA2\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9D"],
        ["\xE6\x86\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9E"],
        ["\xE8\x87\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\x9F"],
        ["\xE8\x94\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA0"],
        ["\xE8\xB4\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA1"],
        ["\xE9\x80\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA2"],
        ["\xE4\xBF\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA3"],
        ["\xE5\x81\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA4"],
        ["\xE5\x89\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA5"],
        ["\xE5\x8D\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA6"],
        ["\xE6\x81\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA7"],
        ["\xE6\x8D\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA8"],
        ["\xE6\x9D\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xA9"],
        ["\xE6\xB8\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAA"],
        ["\xE8\xB6\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAB"],
        ["\xE9\x80\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAC"],
        ["\xE4\xBF\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAD"],
        ["\xE5\xB1\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAE"],
        ["\xE8\xB3\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xAF"],
        ["\xE6\x97\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB0"],
        ["\xE7\xB6\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB1"],
        ["\xE5\x8D\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB2"],
        ["\xE8\xA2\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB3"],
        ["\xE5\x85\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB4"],
        ["\xE6\x8F\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB5"],
        ["\xE5\xAD\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB6"],
        ["\xE5\xAD\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB7"],
        ["\xE5\xB0\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB8"],
        ["\xE6\x90\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xB9"],
        ["\xE6\x9D\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBA"],
        ["\xE9\x81\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBB"],
        ["\xE4\xBB\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBC"],
        ["\xE5\xA4\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBD"],
        ["\xE5\xA4\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBE"],
        ["\xE6\xB1\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xBF"],
        ["\xE8\xA9\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC0"],
        ["\xE5\x94\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC1"],
        ["\xE5\xA0\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC2"],
        ["\xE5\xA6\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC3"],
        ["\xE6\x83\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC4"],
        ["\xE6\x89\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC5"],
        ["\xE6\x9F\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC6"],
        ["\xE8\x88\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC7"],
        ["\xE6\xA5\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC8"],
        ["\xE9\x99\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xC9"],
        ["\xE9\xA7\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCA"],
        ["\xE9\xA8\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCB"],
        ["\xE4\xBD\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCC"],
        ["\xE5\xA0\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCD"],
        ["\xE5\xAF\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCE"],
        ["\xE8\x80\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xCF"],
        ["\xE5\xB2\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD0"],
        ["\xE5\xB8\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD1"],
        ["\xE5\xBE\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD2"],
        ["\xE6\x80\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD3"],
        ["\xE6\x85\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD4"],
        ["\xE6\x88\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD5"],
        ["\xE6\x9B\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD6"],
        ["\xE6\xB3\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD7"],
        ["\xE6\xBB\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD8"],
        ["\xE8\x83\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xD9"],
        ["\xE8\x85\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDA"],
        ["\xE8\x8B\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDB"],
        ["\xE8\xA2\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDC"],
        ["\xE8\xB2\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDD"],
        ["\xE9\x80\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDE"],
        ["\xE9\x80\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xDF"],
        ["\xE9\x9A\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE0"],
        ["\xE9\xBB\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE1"],
        ["\xE9\xAF\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE2"],
        ["\xE4\xBB\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE3"],
        ["\xE5\x8F\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE4"],
        ["\xE5\xA4\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE5"],
        ["\xE7\xAC\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE6"],
        ["\xE9\x86\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE7"],
        ["\xE9\xA1\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE8"],
        ["\xE9\xB7\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xE9"],
        ["\xE6\xBB\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEA"],
        ["\xE7\x80\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEB"],
        ["\xE5\x8D\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEC"],
        ["\xE5\x95\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xED"],
        ["\xE5\xAE\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEE"],
        ["\xE6\x89\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xEF"],
        ["\xE6\x8A\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF0"],
        ["\xE6\x8B\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF1"],
        ["\xE6\xB2\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF2"],
        ["\xE6\xBF\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF3"],
        ["\xE7\x90\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF4"],
        ["\xE8\xA8\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF5"],
        ["\xE9\x90\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF6"],
        ["\xE6\xBF\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF7"],
        ["\xE8\xAB\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF8"],
        ["\xE8\x8C\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xF9"],
        ["\xE5\x87\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xFA"],
        ["\xE8\x9B\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xFB"],
        ["\xE5\x8F\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x91\xFC"],
        ["\xE5\x8F\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x40"],
        ["\xE4\xBD\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x41"],
        ["\xE9\x81\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x42"],
        ["\xE8\xBE\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x43"],
        ["\xE5\xA5\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x44"],
        ["\xE8\x84\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x45"],
        ["\xE5\xB7\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x46"],
        ["\xE7\xAB\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x47"],
        ["\xE8\xBE\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x48"],
        ["\xE6\xA3\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x49"],
        ["\xE8\xB0\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4A"],
        ["\xE7\x8B\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4B"],
        ["\xE9\xB1\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4C"],
        ["\xE6\xA8\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4D"],
        ["\xE8\xAA\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4E"],
        ["\xE4\xB8\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x4F"],
        ["\xE5\x8D\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x50"],
        ["\xE5\x98\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x51"],
        ["\xE5\x9D\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x52"],
        ["\xE6\x8B\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x53"],
        ["\xE6\x8E\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x54"],
        ["\xE6\x97\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x55"],
        ["\xE6\xAD\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x56"],
        ["\xE6\xB7\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x57"],
        ["\xE6\xB9\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x58"],
        ["\xE7\x82\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x59"],
        ["\xE7\x9F\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5A"],
        ["\xE7\xAB\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5B"],
        ["\xE7\xAE\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5C"],
        ["\xE7\xB6\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5D"],
        ["\xE8\x80\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5E"],
        ["\xE8\x83\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x5F"],
        ["\xE8\x9B\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x60"],
        ["\xE8\xAA\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x61"],
        ["\xE9\x8D\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x62"],
        ["\xE5\x9B\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x63"],
        ["\xE5\xA3\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x64"],
        ["\xE5\xBC\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x65"],
        ["\xE6\x96\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x66"],
        ["\xE6\x9A\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x67"],
        ["\xE6\xAA\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x68"],
        ["\xE6\xAE\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x69"],
        ["\xE7\x94\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6A"],
        ["\xE8\xAB\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6B"],
        ["\xE5\x80\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6C"],
        ["\xE7\x9F\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6D"],
        ["\xE5\x9C\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6E"],
        ["\xE5\xBC\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x6F"],
        ["\xE6\x81\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x70"],
        ["\xE6\x99\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x71"],
        ["\xE6\xB1\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x72"],
        ["\xE7\x97\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x73"],
        ["\xE7\xA8\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x74"],
        ["\xE7\xBD\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x75"],
        ["\xE8\x87\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x76"],
        ["\xE8\x9C\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x77"],
        ["\xE9\x81\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x78"],
        ["\xE9\xA6\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x79"],
        ["\xE7\xAF\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7A"],
        ["\xE7\x95\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7B"],
        ["\xE7\xAB\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7C"],
        ["\xE7\xAD\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7D"],
        ["\xE8\x93\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x7E"],
        ["\xE9\x80\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x80"],
        ["\xE7\xA7\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x81"],
        ["\xE7\xAA\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x82"],
        ["\xE8\x8C\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x83"],
        ["\xE5\xAB\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x84"],
        ["\xE7\x9D\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x85"],
        ["\xE4\xB8\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x86"],
        ["\xE4\xBB\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x87"],
        ["\xE5\xAE\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x88"],
        ["\xE5\xBF\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x89"],
        ["\xE6\x8A\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8A"],
        ["\xE6\x98\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8B"],
        ["\xE6\x9F\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8C"],
        ["\xE6\xB3\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8D"],
        ["\xE8\x99\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8E"],
        ["\xE8\xA1\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x8F"],
        ["\xE8\xA8\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x90"],
        ["\xE9\x85\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x91"],
        ["\xE9\x8B\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x92"],
        ["\xE9\xA7\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x93"],
        ["\xE6\xA8\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x94"],
        ["\xE7\x80\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x95"],
        ["\xE7\x8C\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x96"],
        ["\xE8\x8B\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x97"],
        ["\xE8\x91\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x98"],
        ["\xE8\xB2\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x99"],
        ["\xE4\xB8\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9A"],
        ["\xE5\x85\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9B"],
        ["\xE5\x87\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9C"],
        ["\xE5\x96\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9D"],
        ["\xE5\xAF\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9E"],
        ["\xE5\xB8\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\x9F"],
        ["\xE5\xB8\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA0"],
        ["\xE5\xBA\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA1"],
        ["\xE5\xBC\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA2"],
        ["\xE5\xBC\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA3"],
        ["\xE5\xBD\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA4"],
        ["\xE5\xBE\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA5"],
        ["\xE6\x87\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA6"],
        ["\xE6\x8C\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA7"],
        ["\xE6\x9A\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA8"],
        ["\xE6\x9C\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xA9"],
        ["\xE6\xBD\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAA"],
        ["\xE7\x89\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAB"],
        ["\xE7\x94\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAC"],
        ["\xE7\x9C\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAD"],
        ["\xE8\x81\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAE"],
        ["\xE8\x84\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xAF"],
        ["\xE8\x85\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB0"],
        ["\xE8\x9D\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB1"],
        ["\xE8\xAA\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB2"],
        ["\xE8\xAB\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB3"],
        ["\xE8\xB6\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB4"],
        ["\xE8\xB7\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB5"],
        ["\xE9\x8A\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB6"],
        ["\xE9\x95\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB7"],
        ["\xE9\xA0\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB8"],
        ["\xE9\xB3\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xB9"],
        ["\xE5\x8B\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBA"],
        ["\xE6\x8D\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBB"],
        ["\xE7\x9B\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBC"],
        ["\xE6\x9C\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBD"],
        ["\xE6\xB2\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBE"],
        ["\xE7\x8F\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xBF"],
        ["\xE8\xB3\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC0"],
        ["\xE9\x8E\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC1"],
        ["\xE9\x99\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC2"],
        ["\xE6\xB4\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC3"],
        ["\xE5\xA2\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC4"],
        ["\xE6\xA4\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC5"],
        ["\xE6\xA7\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC6"],
        ["\xE8\xBF\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC7"],
        ["\xE9\x8E\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC8"],
        ["\xE7\x97\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xC9"],
        ["\xE9\x80\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCA"],
        ["\xE5\xA1\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCB"],
        ["\xE6\xA0\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCC"],
        ["\xE6\x8E\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCD"],
        ["\xE6\xA7\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCE"],
        ["\xE4\xBD\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xCF"],
        ["\xE6\xBC\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD0"],
        ["\xE6\x9F\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD1"],
        ["\xE8\xBE\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD2"],
        ["\xE8\x94\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD3"],
        ["\xE7\xB6\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD4"],
        ["\xE9\x8D\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD5"],
        ["\xE6\xA4\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD6"],
        ["\xE6\xBD\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD7"],
        ["\xE5\x9D\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD8"],
        ["\xE5\xA3\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xD9"],
        ["\xE5\xAC\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDA"],
        ["\xE7\xB4\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDB"],
        ["\xE7\x88\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDC"],
        ["\xE5\x90\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDD"],
        ["\xE9\x87\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDE"],
        ["\xE9\xB6\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xDF"],
        ["\xE4\xBA\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE0"],
        ["\xE4\xBD\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE1"],
        ["\xE5\x81\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE2"],
        ["\xE5\x81\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE3"],
        ["\xE5\x89\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE4"],
        ["\xE8\xB2\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE5"],
        ["\xE5\x91\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE6"],
        ["\xE5\xA0\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE7"],
        ["\xE5\xAE\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE8"],
        ["\xE5\xB8\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xE9"],
        ["\xE5\xBA\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEA"],
        ["\xE5\xBA\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEB"],
        ["\xE5\xBB\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEC"],
        ["\xE5\xBC\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xED"],
        ["\xE6\x82\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEE"],
        ["\xE6\x8A\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xEF"],
        ["\xE6\x8C\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF0"],
        ["\xE6\x8F\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF1"],
        ["\xE6\xA2\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF2"],
        ["\xE6\xB1\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF3"],
        ["\xE7\xA2\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF4"],
        ["\xE7\xA6\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF5"],
        ["\xE7\xA8\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF6"],
        ["\xE7\xB7\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF7"],
        ["\xE8\x89\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF8"],
        ["\xE8\xA8\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xF9"],
        ["\xE8\xAB\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xFA"],
        ["\xE8\xB9\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xFB"],
        ["\xE9\x80\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x92\xFC"],
        ["\xE9\x82\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x40"],
        ["\xE9\x84\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x41"],
        ["\xE9\x87\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x42"],
        ["\xE9\xBC\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x43"],
        ["\xE6\xB3\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x44"],
        ["\xE6\x91\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x45"],
        ["\xE6\x93\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x46"],
        ["\xE6\x95\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x47"],
        ["\xE6\xBB\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x48"],
        ["\xE7\x9A\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x49"],
        ["\xE7\xAC\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4A"],
        ["\xE9\x81\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4B"],
        ["\xE9\x8F\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4C"],
        ["\xE6\xBA\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4D"],
        ["\xE5\x93\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4E"],
        ["\xE5\xBE\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x4F"],
        ["\xE6\x92\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x50"],
        ["\xE8\xBD\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x51"],
        ["\xE8\xBF\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x52"],
        ["\xE9\x89\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x53"],
        ["\xE5\x85\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x54"],
        ["\xE5\xA1\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x55"],
        ["\xE5\xA4\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x56"],
        ["\xE5\xB1\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x57"],
        ["\xE5\xBA\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x58"],
        ["\xE6\xB7\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x59"],
        ["\xE7\xBA\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5A"],
        ["\xE7\x94\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5B"],
        ["\xE8\xB2\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5C"],
        ["\xE8\xBB\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5D"],
        ["\xE9\xA1\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5E"],
        ["\xE7\x82\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x5F"],
        ["\xE4\xBC\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x60"],
        ["\xE6\xAE\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x61"],
        ["\xE6\xBE\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x62"],
        ["\xE7\x94\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x63"],
        ["\xE9\x9B\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x64"],
        ["\xE5\x85\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x65"],
        ["\xE5\x90\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x66"],
        ["\xE5\xA0\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x67"],
        ["\xE5\xA1\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x68"],
        ["\xE5\xA6\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x69"],
        ["\xE5\xB1\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6A"],
        ["\xE5\xBE\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6B"],
        ["\xE6\x96\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6C"],
        ["\xE6\x9D\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6D"],
        ["\xE6\xB8\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6E"],
        ["\xE7\x99\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x6F"],
        ["\xE8\x8F\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x70"],
        ["\xE8\xB3\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x71"],
        ["\xE9\x80\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x72"],
        ["\xE9\x83\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x73"],
        ["\xE9\x8D\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x74"],
        ["\xE7\xA0\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x75"],
        ["\xE7\xA0\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x76"],
        ["\xE5\x8A\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x77"],
        ["\xE5\xBA\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x78"],
        ["\xE5\x9C\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x79"],
        ["\xE5\xA5\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7A"],
        ["\xE6\x80\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7B"],
        ["\xE5\x80\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7C"],
        ["\xE5\x85\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7D"],
        ["\xE5\x86\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x7E"],
        ["\xE5\x87\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x80"],
        ["\xE5\x88\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x81"],
        ["\xE5\x94\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x82"],
        ["\xE5\xA1\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x83"],
        ["\xE5\xA1\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x84"],
        ["\xE5\xA5\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x85"],
        ["\xE5\xAE\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x86"],
        ["\xE5\xB3\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x87"],
        ["\xE5\xB6\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x88"],
        ["\xE6\x82\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x89"],
        ["\xE6\x8A\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8A"],
        ["\xE6\x90\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8B"],
        ["\xE6\x9D\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8C"],
        ["\xE6\xA1\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8D"],
        ["\xE6\xA2\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8E"],
        ["\xE6\xA3\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x8F"],
        ["\xE7\x9B\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x90"],
        ["\xE6\xB7\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x91"],
        ["\xE6\xB9\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x92"],
        ["\xE6\xB6\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x93"],
        ["\xE7\x81\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x94"],
        ["\xE7\x87\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x95"],
        ["\xE5\xBD\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x96"],
        ["\xE7\x97\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x97"],
        ["\xE7\xA5\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x98"],
        ["\xE7\xAD\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x99"],
        ["\xE7\xAD\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9A"],
        ["\xE7\xAD\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9B"],
        ["\xE7\xB3\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9C"],
        ["\xE7\xB5\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9D"],
        ["\xE5\x88\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9E"],
        ["\xE8\x91\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\x9F"],
        ["\xE8\x95\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA0"],
        ["\xE8\x97\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA1"],
        ["\xE8\xA8\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA2"],
        ["\xE8\xAC\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA3"],
        ["\xE8\xB1\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA4"],
        ["\xE8\xB8\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA5"],
        ["\xE9\x80\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA6"],
        ["\xE9\x80\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA7"],
        ["\xE9\x90\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA8"],
        ["\xE9\x99\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xA9"],
        ["\xE9\xA0\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAA"],
        ["\xE9\xA8\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAB"],
        ["\xE9\x97\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAC"],
        ["\xE5\x83\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAD"],
        ["\xE5\x8B\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAE"],
        ["\xE5\x90\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xAF"],
        ["\xE5\xA0\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB0"],
        ["\xE5\xB0\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB1"],
        ["\xE6\x86\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB2"],
        ["\xE6\x92\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB3"],
        ["\xE6\xB4\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB4"],
        ["\xE7\x9E\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB5"],
        ["\xE7\xAB\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB6"],
        ["\xE8\x83\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB7"],
        ["\xE8\x90\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB8"],
        ["\xE9\x81\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xB9"],
        ["\xE9\x8A\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBA"],
        ["\xE5\xB3\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBB"],
        ["\xE9\xB4\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBC"],
        ["\xE5\x8C\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBD"],
        ["\xE5\xBE\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBE"],
        ["\xE5\xBE\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xBF"],
        ["\xE6\xB6\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC0"],
        ["\xE7\x89\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC1"],
        ["\xE7\x9D\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC2"],
        ["\xE7\xA6\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC3"],
        ["\xE7\xAF\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC4"],
        ["\xE6\xAF\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC5"],
        ["\xE7\x8B\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC6"],
        ["\xE8\xAA\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC7"],
        ["\xE6\xA0\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC8"],
        ["\xE6\xA9\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xC9"],
        ["\xE5\x87\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCA"],
        ["\xE7\xAA\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCB"],
        ["\xE6\xA4\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCC"],
        ["\xE5\xB1\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCD"],
        ["\xE9\xB3\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCE"],
        ["\xE8\x8B\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xCF"],
        ["\xE5\xAF\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD0"],
        ["\xE9\x85\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD1"],
        ["\xE7\x80\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD2"],
        ["\xE5\x99\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD3"],
        ["\xE5\xB1\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD4"],
        ["\xE6\x83\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD5"],
        ["\xE6\x95\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD6"],
        ["\xE6\xB2\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD7"],
        ["\xE8\xB1\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD8"],
        ["\xE9\x81\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xD9"],
        ["\xE9\xA0\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDA"],
        ["\xE5\x91\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDB"],
        ["\xE6\x9B\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDC"],
        ["\xE9\x88\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDD"],
        ["\xE5\xA5\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDE"],
        ["\xE9\x82\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xDF"],
        ["\xE5\x86\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE0"],
        ["\xE4\xB9\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE1"],
        ["\xE5\x87\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE2"],
        ["\xE8\x96\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE3"],
        ["\xE8\xAC\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE4"],
        ["\xE7\x81\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE5"],
        ["\xE6\x8D\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE6"],
        ["\xE9\x8D\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE7"],
        ["\xE6\xA5\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE8"],
        ["\xE9\xA6\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xE9"],
        ["\xE7\xB8\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEA"],
        ["\xE7\x95\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEB"],
        ["\xE5\x8D\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEC"],
        ["\xE6\xA5\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xED"],
        ["\xE8\xBB\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEE"],
        ["\xE9\x9B\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xEF"],
        ["\xE6\xB1\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF0"],
        ["\xE4\xBA\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF1"],
        ["\xE5\xB0\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF2"],
        ["\xE5\xBC\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF3"],
        ["\xE8\xBF\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF4"],
        ["\xE5\x8C\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF5"],
        ["\xE8\xB3\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF6"],
        ["\xE8\x82\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF7"],
        ["\xE8\x99\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF8"],
        ["\xE5\xBB\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xF9"],
        ["\xE6\x97\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xFA"],
        ["\xE4\xB9\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xFB"],
        ["\xE5\x85\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x93\xFC"],
        ["\xE5\xA6\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x40"],
        ["\xE5\xB0\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x41"],
        ["\xE9\x9F\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x42"],
        ["\xE4\xBB\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x43"],
        ["\xE5\xA6\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x44"],
        ["\xE5\xBF\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x45"],
        ["\xE8\xAA\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x46"],
        ["\xE6\xBF\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x47"],
        ["\xE7\xA6\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x48"],
        ["\xE7\xA5\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x49"],
        ["\xE5\xAF\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4A"],
        ["\xE8\x91\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4B"],
        ["\xE7\x8C\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4C"],
        ["\xE7\x86\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4D"],
        ["\xE5\xB9\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4E"],
        ["\xE5\xBF\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x4F"],
        ["\xE6\x8D\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x50"],
        ["\xE6\x92\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x51"],
        ["\xE7\x87\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x52"],
        ["\xE7\xB2\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x53"],
        ["\xE4\xB9\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x54"],
        ["\xE5\xBB\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x55"],
        ["\xE4\xB9\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x56"],
        ["\xE5\x9F\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x57"],
        ["\xE5\x9A\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x58"],
        ["\xE6\x82\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x59"],
        ["\xE6\xBF\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5A"],
        ["\xE7\xB4\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5B"],
        ["\xE8\x83\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5C"],
        ["\xE8\x84\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5D"],
        ["\xE8\x86\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5E"],
        ["\xE8\xBE\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x5F"],
        ["\xE8\xA6\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x60"],
        ["\xE8\x9A\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x61"],
        ["\xE5\xB7\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x62"],
        ["\xE6\x8A\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x63"],
        ["\xE6\x92\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x64"],
        ["\xE8\xA6\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x65"],
        ["\xE6\x9D\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x66"],
        ["\xE6\xB3\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x67"],
        ["\xE6\xB4\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x68"],
        ["\xE7\x90\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x69"],
        ["\xE7\xA0\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6A"],
        ["\xE5\xA9\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6B"],
        ["\xE7\xBD\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6C"],
        ["\xE8\x8A\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6D"],
        ["\xE9\xA6\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6E"],
        ["\xE4\xBF\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x6F"],
        ["\xE5\xBB\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x70"],
        ["\xE6\x8B\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x71"],
        ["\xE6\x8E\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x72"],
        ["\xE6\x95\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x73"],
        ["\xE6\x9D\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x74"],
        ["\xE7\x9B\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x75"],
        ["\xE7\x89\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x76"],
        ["\xE8\x83\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x77"],
        ["\xE8\x82\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x78"],
        ["\xE8\xBC\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x79"],
        ["\xE9\x85\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7A"],
        ["\xE5\x80\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7B"],
        ["\xE5\x9F\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7C"],
        ["\xE5\xAA\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7D"],
        ["\xE6\xA2\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x7E"],
        ["\xE6\xA5\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x80"],
        ["\xE7\x85\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x81"],
        ["\xE7\x8B\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x82"],
        ["\xE8\xB2\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x83"],
        ["\xE5\xA3\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x84"],
        ["\xE8\xB3\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x85"],
        ["\xE9\x99\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x86"],
        ["\xE9\x80\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x87"],
        ["\xE8\x9D\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x88"],
        ["\xE7\xA7\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x89"],
        ["\xE7\x9F\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],
        ["\xE8\x90\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8B"],
        ["\xE4\xBC\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8C"],
        ["\xE5\x89\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8D"],
        ["\xE5\x8D\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8E"],
        ["\xE6\x8B\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x8F"],
        ["\xE6\x9F\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x90"],
        ["\xE6\xB3\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x91"],
        ["\xE7\x99\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x92"],
        ["\xE7\xAE\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x93"],
        ["\xE7\xB2\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x94"],
        ["\xE8\x88\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x95"],
        ["\xE8\x96\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x96"],
        ["\xE8\xBF\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x97"],
        ["\xE6\x9B\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x98"],
        ["\xE6\xBC\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x99"],
        ["\xE7\x88\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9A"],
        ["\xE7\xB8\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9B"],
        ["\xE8\x8E\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9C"],
        ["\xE9\xA7\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9D"],
        ["\xE9\xBA\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9E"],
        ["\xE5\x87\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\x9F"],
        ["\xE7\xAE\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA0"],
        ["\xE7\xA1\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA1"],
        ["\xE7\xAE\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA2"],
        ["\xE8\x82\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA3"],
        ["\xE7\xAD\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA4"],
        ["\xE6\xAB\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA5"],
        ["\xE5\xB9\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA6"],
        ["\xE8\x82\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA7"],
        ["\xE7\x95\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA8"],
        ["\xE7\x95\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xA9"],
        ["\xE5\x85\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAA"],
        ["\xE9\x89\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAB"],
        ["\xE6\xBA\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAC"],
        ["\xE7\x99\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAD"],
        ["\xE9\x86\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAE"],
        ["\xE9\xAB\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xAF"],
        ["\xE4\xBC\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB0"],
        ["\xE7\xBD\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB1"],
        ["\xE6\x8A\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB2"],
        ["\xE7\xAD\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB3"],
        ["\xE9\x96\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB4"],
        ["\xE9\xB3\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB5"],
        ["\xE5\x99\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB6"],
        ["\xE5\xA1\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB7"],
        ["\xE8\x9B\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB8"],
        ["\xE9\x9A\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xB9"],
        ["\xE4\xBC\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBA"],
        ["\xE5\x88\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBB"],
        ["\xE5\x8D\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBC"],
        ["\xE5\x8F\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBD"],
        ["\xE5\x8F\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBE"],
        ["\xE5\xB8\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xBF"],
        ["\xE6\x90\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC0"],
        ["\xE6\x96\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC1"],
        ["\xE6\x9D\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC2"],
        ["\xE6\xB0\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC3"],
        ["\xE6\xB1\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC4"],
        ["\xE7\x89\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC5"],
        ["\xE7\x8A\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC6"],
        ["\xE7\x8F\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC7"],
        ["\xE7\x95\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC8"],
        ["\xE7\xB9\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xC9"],
        ["\xE8\x88\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCA"],
        ["\xE8\x97\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCB"],
        ["\xE8\xB2\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCC"],
        ["\xE7\xAF\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCD"],
        ["\xE9\x87\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCE"],
        ["\xE7\x85\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xCF"],
        ["\xE9\xA0\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD0"],
        ["\xE9\xA3\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD1"],
        ["\xE6\x8C\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD2"],
        ["\xE6\x99\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD3"],
        ["\xE7\x95\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD4"],
        ["\xE7\x9B\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD5"],
        ["\xE7\xA3\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD6"],
        ["\xE8\x95\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD7"],
        ["\xE8\x9B\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD8"],
        ["\xE5\x8C\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xD9"],
        ["\xE5\x8D\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDA"],
        ["\xE5\x90\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDB"],
        ["\xE5\xA6\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDC"],
        ["\xE5\xBA\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDD"],
        ["\xE5\xBD\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDE"],
        ["\xE6\x82\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xDF"],
        ["\xE6\x89\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE0"],
        ["\xE6\x89\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE1"],
        ["\xE6\x8A\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE2"],
        ["\xE6\x96\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE3"],
        ["\xE6\xAF\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE4"],
        ["\xE6\xB3\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE5"],
        ["\xE7\x96\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE6"],
        ["\xE7\x9A\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE7"],
        ["\xE7\xA2\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE8"],
        ["\xE7\xA7\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xE9"],
        ["\xE7\xB7\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEA"],
        ["\xE7\xBD\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEB"],
        ["\xE8\x82\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEC"],
        ["\xE8\xA2\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xED"],
        ["\xE8\xAA\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEE"],
        ["\xE8\xB2\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xEF"],
        ["\xE9\x81\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF0"],
        ["\xE9\x9D\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF1"],
        ["\xE9\xA3\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF2"],
        ["\xE6\xA8\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF3"],
        ["\xE7\xB0\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF4"],
        ["\xE5\x82\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF5"],
        ["\xE5\xB0\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF6"],
        ["\xE5\xBE\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF7"],
        ["\xE6\x9E\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF8"],
        ["\xE6\xAF\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xF9"],
        ["\xE7\x90\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xFA"],
        ["\xE7\x9C\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xFB"],
        ["\xE7\xBE\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x94\xFC"],
        ["\xE9\xBC\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x40"],
        ["\xE6\x9F\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x41"],
        ["\xE7\xA8\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x42"],
        ["\xE5\x8C\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x43"],
        ["\xE7\x96\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x44"],
        ["\xE9\xAB\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x45"],
        ["\xE5\xBD\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x46"],
        ["\xE8\x86\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x47"],
        ["\xE8\x8F\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x48"],
        ["\xE8\x82\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x49"],
        ["\xE5\xBC\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4A"],
        ["\xE5\xBF\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4B"],
        ["\xE7\x95\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4C"],
        ["\xE7\xAD\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4D"],
        ["\xE9\x80\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4E"],
        ["\xE6\xA1\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x4F"],
        ["\xE5\xA7\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x50"],
        ["\xE5\xAA\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x51"],
        ["\xE7\xB4\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x52"],
        ["\xE7\x99\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x53"],
        ["\xE8\xAC\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x54"],
        ["\xE4\xBF\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x55"],
        ["\xE5\xBD\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x56"],
        ["\xE6\xA8\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x57"],
        ["\xE6\xB0\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x58"],
        ["\xE6\xBC\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x59"],
        ["\xE7\x93\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5A"],
        ["\xE7\xA5\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5B"],
        ["\xE8\xA1\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5C"],
        ["\xE8\xA9\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5D"],
        ["\xE8\xB1\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5E"],
        ["\xE5\xBB\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x5F"],
        ["\xE6\x8F\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x60"],
        ["\xE7\x97\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x61"],
        ["\xE7\xA7\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x62"],
        ["\xE8\x8B\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x63"],
        ["\xE9\x8C\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x64"],
        ["\xE9\x8B\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x65"],
        ["\xE8\x92\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x66"],
        ["\xE8\x9B\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x67"],
        ["\xE9\xB0\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x68"],
        ["\xE5\x93\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x69"],
        ["\xE5\xBD\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6A"],
        ["\xE6\x96\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6B"],
        ["\xE6\xB5\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6C"],
        ["\xE7\x80\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6D"],
        ["\xE8\xB2\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6E"],
        ["\xE8\xB3\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x6F"],
        ["\xE9\xA0\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x70"],
        ["\xE6\x95\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x71"],
        ["\xE7\x93\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x72"],
        ["\xE4\xB8\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x73"],
        ["\xE4\xBB\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x74"],
        ["\xE5\x9F\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x75"],
        ["\xE5\xA4\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x76"],
        ["\xE5\xA9\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x77"],
        ["\xE5\xAF\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x78"],
        ["\xE5\x86\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x79"],
        ["\xE5\xB8\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7A"],
        ["\xE5\xBA\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7B"],
        ["\xE6\x80\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7C"],
        ["\xE6\x89\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7D"],
        ["\xE6\x95\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x7E"],
        ["\xE6\x96\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x80"],
        ["\xE6\x99\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x81"],
        ["\xE6\xB5\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x82"],
        ["\xE7\x88\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x83"],
        ["\xE7\xAC\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x84"],
        ["\xE8\x85\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x85"],
        ["\xE8\x86\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x86"],
        ["\xE8\x8A\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x87"],
        ["\xE8\xAD\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x88"],
        ["\xE8\xB2\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x89"],
        ["\xE8\xB3\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8A"],
        ["\xE8\xB5\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8B"],
        ["\xE9\x98\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8C"],
        ["\xE9\x99\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8D"],
        ["\xE4\xBE\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8E"],
        ["\xE6\x92\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x8F"],
        ["\xE6\xAD\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x90"],
        ["\xE8\x88\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x91"],
        ["\xE8\x91\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x92"],
        ["\xE8\x95\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x93"],
        ["\xE9\x83\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x94"],
        ["\xE5\xB0\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x95"],
        ["\xE6\xA5\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x96"],
        ["\xE9\xA2\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x97"],
        ["\xE8\x91\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x98"],
        ["\xE8\x95\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x99"],
        ["\xE4\xBC\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9A"],
        ["\xE5\x89\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9B"],
        ["\xE5\xBE\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9C"],
        ["\xE5\xB9\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9D"],
        ["\xE6\x9C\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9E"],
        ["\xE7\xA6\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\x9F"],
        ["\xE8\x85\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA0"],
        ["\xE8\xA4\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA1"],
        ["\xE8\xA6\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA2"],
        ["\xE6\xB7\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA3"],
        ["\xE5\xBC\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA4"],
        ["\xE6\x89\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA5"],
        ["\xE6\xB2\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA6"],
        ["\xE4\xBB\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA7"],
        ["\xE7\x89\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA8"],
        ["\xE9\xAE\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xA9"],
        ["\xE5\x88\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAA"],
        ["\xE5\x90\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAB"],
        ["\xE5\x99\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAC"],
        ["\xE5\xA2\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAD"],
        ["\xE6\x86\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAE"],
        ["\xE6\x89\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xAF"],
        ["\xE7\x84\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB0"],
        ["\xE5\xA5\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB1"],
        ["\xE7\xB2\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB2"],
        ["\xE7\xB3\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB3"],
        ["\xE7\xB4\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB4"],
        ["\xE9\x9B\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB5"],
        ["\xE6\x96\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB6"],
        ["\xE8\x81\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB7"],
        ["\xE4\xB8\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB8"],
        ["\xE4\xBD\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xB9"],
        ["\xE5\x85\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBA"],
        ["\xE5\xA1\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBB"],
        ["\xE5\xB9\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBC"],
        ["\xE5\xB9\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBD"],
        ["\xE5\xBC\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBE"],
        ["\xE6\x9F\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xBF"],
        ["\xE4\xB8\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC0"],
        ["\xE8\x94\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC1"],
        ["\xE9\x96\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC2"],
        ["\xE9\x99\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC3"],
        ["\xE7\xB1\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC4"],
        ["\xE9\xA0\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC5"],
        ["\xE5\x83\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC6"],
        ["\xE5\xA3\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC7"],
        ["\xE7\x99\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC8"],
        ["\xE7\xA2\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xC9"],
        ["\xE5\x88\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\xE7\x9E\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCB"],
        ["\xE8\x94\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCC"],
        ["\xE7\xAE\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCD"],
        ["\xE5\x81\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCE"],
        ["\xE5\xA4\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xCF"],
        ["\xE7\x89\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD0"],
        ["\xE7\xAF\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD1"],
        ["\xE7\xB7\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD2"],
        ["\xE8\xBE\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD3"],
        ["\xE8\xBF\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD4"],
        ["\xE9\x81\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD5"],
        ["\xE4\xBE\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD6"],
        ["\xE5\x8B\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD7"],
        ["\xE5\xA8\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD8"],
        ["\xE5\xBC\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xD9"],
        ["\xE9\x9E\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDA"],
        ["\xE4\xBF\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDB"],
        ["\xE8\x88\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDC"],
        ["\xE9\x8B\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDD"],
        ["\xE5\x9C\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDE"],
        ["\xE6\x8D\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xDF"],
        ["\xE6\xAD\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE0"],
        ["\xE7\x94\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE1"],
        ["\xE8\xA3\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE2"],
        ["\xE8\xBC\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE3"],
        ["\xE7\xA9\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE4"],
        ["\xE5\x8B\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE5"],
        ["\xE5\xA2\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE6"],
        ["\xE6\x85\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE7"],
        ["\xE6\x88\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE8"],
        ["\xE6\x9A\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xE9"],
        ["\xE6\xAF\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEA"],
        ["\xE7\xB0\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEB"],
        ["\xE8\x8F\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEC"],
        ["\xE5\x80\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xED"],
        ["\xE4\xBF\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEE"],
        ["\xE5\x8C\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xEF"],
        ["\xE5\x91\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF0"],
        ["\xE5\xA0\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF1"],
        ["\xE5\xA5\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF2"],
        ["\xE5\xAE\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF3"],
        ["\xE5\xB3\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF4"],
        ["\xE5\xB3\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF5"],
        ["\xE5\xB4\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF6"],
        ["\xE5\xBA\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF7"],
        ["\xE6\x8A\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF8"],
        ["\xE6\x8D\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xF9"],
        ["\xE6\x94\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xFA"],
        ["\xE6\x96\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xFB"],
        ["\xE6\x9C\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x95\xFC"],
        ["\xE6\xB3\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x40"],
        ["\xE6\xB3\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x41"],
        ["\xE7\x83\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x42"],
        ["\xE7\xA0\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x43"],
        ["\xE7\xB8\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x44"],
        ["\xE8\x83\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x45"],
        ["\xE8\x8A\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x46"],
        ["\xE8\x90\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x47"],
        ["\xE8\x93\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x48"],
        ["\xE8\x9C\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x49"],
        ["\xE8\xA4\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4A"],
        ["\xE8\xA8\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4B"],
        ["\xE8\xB1\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4C"],
        ["\xE9\x82\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4D"],
        ["\xE9\x8B\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4E"],
        ["\xE9\xA3\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x4F"],
        ["\xE9\xB3\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x50"],
        ["\xE9\xB5\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x51"],
        ["\xE4\xB9\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x52"],
        ["\xE4\xBA\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x53"],
        ["\xE5\x82\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x54"],
        ["\xE5\x89\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x55"],
        ["\xE5\x9D\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x56"],
        ["\xE5\xA6\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x57"],
        ["\xE5\xB8\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x58"],
        ["\xE5\xBF\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x59"],
        ["\xE5\xBF\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5A"],
        ["\xE6\x88\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5B"],
        ["\xE6\x9A\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5C"],
        ["\xE6\x9C\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5D"],
        ["\xE6\x9F\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5E"],
        ["\xE6\xA3\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x5F"],
        ["\xE5\x86\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x60"],
        ["\xE7\xB4\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x61"],
        ["\xE8\x82\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x62"],
        ["\xE8\x86\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x63"],
        ["\xE8\xAC\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x64"],
        ["\xE8\xB2\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x65"],
        ["\xE8\xB2\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x66"],
        ["\xE9\x89\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x67"],
        ["\xE9\x98\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x68"],
        ["\xE5\x90\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x69"],
        ["\xE9\xA0\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6A"],
        ["\xE5\x8C\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6B"],
        ["\xE5\x83\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6C"],
        ["\xE5\x8D\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6D"],
        ["\xE5\xA2\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6E"],
        ["\xE6\x92\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x6F"],
        ["\xE6\x9C\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x70"],
        ["\xE7\x89\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x71"],
        ["\xE7\x9D\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x72"],
        ["\xE7\xA9\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x73"],
        ["\xE9\x87\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x74"],
        ["\xE5\x8B\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x75"],
        ["\xE6\xB2\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x76"],
        ["\xE6\xAE\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x77"],
        ["\xE5\xA0\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x78"],
        ["\xE5\xB9\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x79"],
        ["\xE5\xA5\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7A"],
        ["\xE6\x9C\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7B"],
        ["\xE7\xBF\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7C"],
        ["\xE5\x87\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7D"],
        ["\xE7\x9B\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x7E"],
        ["\xE6\x91\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x80"],
        ["\xE7\xA3\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x81"],
        ["\xE9\xAD\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x82"],
        ["\xE9\xBA\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x83"],
        ["\xE5\x9F\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x84"],
        ["\xE5\xA6\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x85"],
        ["\xE6\x98\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x86"],
        ["\xE6\x9E\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x87"],
        ["\xE6\xAF\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x88"],
        ["\xE5\x93\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x89"],
        ["\xE6\xA7\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8A"],
        ["\xE5\xB9\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8B"],
        ["\xE8\x86\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8C"],
        ["\xE6\x9E\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8D"],
        ["\xE9\xAE\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8E"],
        ["\xE6\x9F\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x8F"],
        ["\xE9\xB1\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x90"],
        ["\xE6\xA1\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x91"],
        ["\xE4\xBA\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x92"],
        ["\xE4\xBF\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x93"],
        ["\xE5\x8F\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x94"],
        ["\xE6\x8A\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x95"],
        ["\xE6\x9C\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x96"],
        ["\xE6\xB2\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x97"],
        ["\xE8\xBF\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x98"],
        ["\xE4\xBE\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x99"],
        ["\xE7\xB9\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9A"],
        ["\xE9\xBA\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9B"],
        ["\xE4\xB8\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9C"],
        ["\xE6\x85\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9D"],
        ["\xE6\xBA\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9E"],
        ["\xE6\xBC\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\x9F"],
        ["\xE8\x94\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA0"],
        ["\xE5\x91\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA1"],
        ["\xE6\x9C\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA2"],
        ["\xE9\xAD\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA3"],
        ["\xE5\xB7\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA4"],
        ["\xE7\xAE\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA5"],
        ["\xE5\xB2\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA6"],
        ["\xE5\xAF\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA7"],
        ["\xE8\x9C\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA8"],
        ["\xE6\xB9\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xA9"],
        ["\xE8\x93\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAA"],
        ["\xE7\xA8\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAB"],
        ["\xE8\x84\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAC"],
        ["\xE5\xA6\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAD"],
        ["\xE7\xB2\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAE"],
        ["\xE6\xB0\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xAF"],
        ["\xE7\x9C\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB0"],
        ["\xE5\x8B\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB1"],
        ["\xE5\xA4\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB2"],
        ["\xE7\x84\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB3"],
        ["\xE7\x89\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB4"],
        ["\xE7\x9F\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB5"],
        ["\xE9\x9C\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB6"],
        ["\xE9\xB5\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB7"],
        ["\xE6\xA4\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB8"],
        ["\xE5\xA9\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xB9"],
        ["\xE5\xA8\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBA"],
        ["\xE5\x86\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBB"],
        ["\xE5\x90\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBC"],
        ["\xE5\x91\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBD"],
        ["\xE6\x98\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBE"],
        ["\xE7\x9B\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xBF"],
        ["\xE8\xBF\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC0"],
        ["\xE9\x8A\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC1"],
        ["\xE9\xB3\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC2"],
        ["\xE5\xA7\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC3"],
        ["\xE7\x89\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC4"],
        ["\xE6\xBB\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC5"],
        ["\xE5\x85\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC6"],
        ["\xE6\xA3\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC7"],
        ["\xE7\xB6\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC8"],
        ["\xE7\xB7\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xC9"],
        ["\xE9\x9D\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCA"],
        ["\xE9\xBA\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCB"],
        ["\xE6\x91\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCC"],
        ["\xE6\xA8\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCD"],
        ["\xE8\x8C\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCE"],
        ["\xE5\xA6\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xCF"],
        ["\xE5\xAD\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD0"],
        ["\xE6\xAF\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD1"],
        ["\xE7\x8C\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD2"],
        ["\xE7\x9B\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD3"],
        ["\xE7\xB6\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD4"],
        ["\xE8\x80\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD5"],
        ["\xE8\x92\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD6"],
        ["\xE5\x84\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD7"],
        ["\xE6\x9C\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD8"],
        ["\xE9\xBB\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xD9"],
        ["\xE7\x9B\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDA"],
        ["\xE6\x9D\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDB"],
        ["\xE5\x8B\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDC"],
        ["\xE9\xA4\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDD"],
        ["\xE5\xB0\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDE"],
        ["\xE6\x88\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xDF"],
        ["\xE7\xB1\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE0"],
        ["\xE8\xB2\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE1"],
        ["\xE5\x95\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE2"],
        ["\xE6\x82\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE3"],
        ["\xE7\xB4\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE4"],
        ["\xE9\x96\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE5"],
        ["\xE5\x8C\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE6"],
        ["\xE4\xB9\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE7"],
        ["\xE5\x86\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE8"],
        ["\xE5\xA4\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xE9"],
        ["\xE7\x88\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEA"],
        ["\xE8\x80\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEB"],
        ["\xE9\x87\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEC"],
        ["\xE5\xBC\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xED"],
        ["\xE7\x9F\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEE"],
        ["\xE5\x8E\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xEF"],
        ["\xE5\xBD\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF0"],
        ["\xE7\xB4\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF1"],
        ["\xE8\x96\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF2"],
        ["\xE8\xA8\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF3"],
        ["\xE8\xBA\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF4"],
        ["\xE9\x9D\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF5"],
        ["\xE6\x9F\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF6"],
        ["\xE8\x96\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF7"],
        ["\xE9\x91\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF8"],
        ["\xE6\x84\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xF9"],
        ["\xE6\x84\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xFA"],
        ["\xE6\xB2\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xFB"],
        ["\xE7\x99\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x96\xFC"],
        ["\xE8\xAB\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x40"],
        ["\xE8\xBC\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x41"],
        ["\xE5\x94\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x42"],
        ["\xE4\xBD\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x43"],
        ["\xE5\x84\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x44"],
        ["\xE5\x8B\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x45"],
        ["\xE5\x8F\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x46"],
        ["\xE5\xAE\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x47"],
        ["\xE5\xB9\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x48"],
        ["\xE6\x82\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x49"],
        ["\xE6\x86\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4A"],
        ["\xE6\x8F\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4B"],
        ["\xE6\x9C\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4C"],
        ["\xE6\x9F\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4D"],
        ["\xE6\xB9\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4E"],
        ["\xE6\xB6\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x4F"],
        ["\xE7\x8C\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x50"],
        ["\xE7\x8C\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x51"],
        ["\xE7\x94\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x52"],
        ["\xE7\xA5\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x53"],
        ["\xE8\xA3\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x54"],
        ["\xE8\xAA\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x55"],
        ["\xE9\x81\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x56"],
        ["\xE9\x82\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x57"],
        ["\xE9\x83\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x58"],
        ["\xE9\x9B\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x59"],
        ["\xE8\x9E\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5A"],
        ["\xE5\xA4\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5B"],
        ["\xE4\xBA\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5C"],
        ["\xE4\xBD\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5D"],
        ["\xE4\xB8\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5E"],
        ["\xE8\xAA\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x5F"],
        ["\xE8\xBC\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x60"],
        ["\xE9\xA0\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x61"],
        ["\xE5\x82\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x62"],
        ["\xE5\xB9\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x63"],
        ["\xE5\xA6\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x64"],
        ["\xE5\xAE\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x65"],
        ["\xE5\xBA\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x66"],
        ["\xE6\x8F\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x67"],
        ["\xE6\x8F\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x68"],
        ["\xE6\x93\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x69"],
        ["\xE6\x9B\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6A"],
        ["\xE6\xA5\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6B"],
        ["\xE6\xA7\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6C"],
        ["\xE6\xB4\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6D"],
        ["\xE6\xBA\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6E"],
        ["\xE7\x86\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x6F"],
        ["\xE7\x94\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x70"],
        ["\xE7\xAA\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x71"],
        ["\xE7\xBE\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x72"],
        ["\xE8\x80\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x73"],
        ["\xE8\x91\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x74"],
        ["\xE8\x93\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x75"],
        ["\xE8\xA6\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x76"],
        ["\xE8\xAC\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x77"],
        ["\xE8\xB8\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x78"],
        ["\xE9\x81\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x79"],
        ["\xE9\x99\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7A"],
        ["\xE9\xA4\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7B"],
        ["\xE6\x85\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7C"],
        ["\xE6\x8A\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7D"],
        ["\xE6\xAC\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x7E"],
        ["\xE6\xB2\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x80"],
        ["\xE6\xB5\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x81"],
        ["\xE7\xBF\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x82"],
        ["\xE7\xBF\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x83"],
        ["\xE6\xB7\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x84"],
        ["\xE7\xBE\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x85"],
        ["\xE8\x9E\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x86"],
        ["\xE8\xA3\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x87"],
        ["\xE6\x9D\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x88"],
        ["\xE8\x8E\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x89"],
        ["\xE9\xA0\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8A"],
        ["\xE9\x9B\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8B"],
        ["\xE6\xB4\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8C"],
        ["\xE7\xB5\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8D"],
        ["\xE8\x90\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8E"],
        ["\xE9\x85\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x8F"],
        ["\xE4\xB9\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x90"],
        ["\xE5\x8D\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x91"],
        ["\xE5\xB5\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x92"],
        ["\xE6\xAC\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x93"],
        ["\xE6\xBF\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x94"],
        ["\xE8\x97\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x95"],
        ["\xE8\x98\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x96"],
        ["\xE8\xA6\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x97"],
        ["\xE5\x88\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x98"],
        ["\xE5\x90\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x99"],
        ["\xE5\xB1\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9A"],
        ["\xE6\x9D\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9B"],
        ["\xE6\xA2\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9C"],
        ["\xE7\x90\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9D"],
        ["\xE7\x92\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9E"],
        ["\xE7\x97\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\x9F"],
        ["\xE8\xA3\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA0"],
        ["\xE8\xA3\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA1"],
        ["\xE9\x87\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA2"],
        ["\xE9\x9B\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA3"],
        ["\xE9\x99\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA4"],
        ["\xE5\xBE\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA5"],
        ["\xE7\x8E\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA6"],
        ["\xE7\xAB\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA7"],
        ["\xE8\x91\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA8"],
        ["\xE6\x8E\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xA9"],
        ["\xE7\x95\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAA"],
        ["\xE5\x8A\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAB"],
        ["\xE6\xB5\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAC"],
        ["\xE6\xBA\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAD"],
        ["\xE7\x90\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAE"],
        ["\xE7\x95\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xAF"],
        ["\xE7\xA1\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB0"],
        ["\xE7\xB2\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB1"],
        ["\xE9\x9A\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB2"],
        ["\xE7\xAB\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB3"],
        ["\xE9\xBE\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB4"],
        ["\xE4\xBE\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB5"],
        ["\xE6\x85\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB6"],
        ["\xE6\x97\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB7"],
        ["\xE8\x99\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB8"],
        ["\xE4\xBA\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xB9"],
        ["\xE4\xBA\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBA"],
        ["\xE5\x83\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBB"],
        ["\xE4\xB8\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBC"],
        ["\xE5\x87\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBD"],
        ["\xE5\xAF\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBE"],
        ["\xE6\x96\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xBF"],
        ["\xE6\xA2\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC0"],
        ["\xE6\xB6\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC1"],
        ["\xE7\x8C\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC2"],
        ["\xE7\x99\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC3"],
        ["\xE7\x9E\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC4"],
        ["\xE7\xA8\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC5"],
        ["\xE7\xB3\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC6"],
        ["\xE8\x89\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC7"],
        ["\xE8\xAB\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC8"],
        ["\xE9\x81\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xC9"],
        ["\xE9\x87\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCA"],
        ["\xE9\x99\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCB"],
        ["\xE9\xA0\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCC"],
        ["\xE5\x8A\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCD"],
        ["\xE7\xB7\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCE"],
        ["\xE5\x80\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xCF"],
        ["\xE5\x8E\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD0"],
        ["\xE6\x9E\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD1"],
        ["\xE6\xB7\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD2"],
        ["\xE7\x87\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD3"],
        ["\xE7\x90\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD4"],
        ["\xE8\x87\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD5"],
        ["\xE8\xBC\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD6"],
        ["\xE9\x9A\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD7"],
        ["\xE9\xB1\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD8"],
        ["\xE9\xBA\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xD9"],
        ["\xE7\x91\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDA"],
        ["\xE5\xA1\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDB"],
        ["\xE6\xB6\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDC"],
        ["\xE7\xB4\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDD"],
        ["\xE9\xA1\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDE"],
        ["\xE4\xBB\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xDF"],
        ["\xE4\xBC\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE0"],
        ["\xE4\xBE\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE1"],
        ["\xE5\x86\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE2"],
        ["\xE5\x8A\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE3"],
        ["\xE5\xB6\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE4"],
        ["\xE6\x80\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE5"],
        ["\xE7\x8E\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE6"],
        ["\xE7\xA4\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE7"],
        ["\xE8\x8B\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE8"],
        ["\xE9\x88\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xE9"],
        ["\xE9\x9A\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEA"],
        ["\xE9\x9B\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEB"],
        ["\xE9\x9C\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEC"],
        ["\xE9\xBA\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xED"],
        ["\xE9\xBD\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEE"],
        ["\xE6\x9A\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xEF"],
        ["\xE6\xAD\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF0"],
        ["\xE5\x88\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF1"],
        ["\xE5\x8A\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF2"],
        ["\xE7\x83\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF3"],
        ["\xE8\xA3\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF4"],
        ["\xE5\xBB\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF5"],
        ["\xE6\x81\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF6"],
        ["\xE6\x86\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF7"],
        ["\xE6\xBC\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF8"],
        ["\xE7\x85\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xF9"],
        ["\xE7\xB0\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xFA"],
        ["\xE7\xB7\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xFB"],
        ["\xE8\x81\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x97\xFC"],
        ["\xE8\x93\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x40"],
        ["\xE9\x80\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x41"],
        ["\xE9\x8C\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x42"],
        ["\xE5\x91\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x43"],
        ["\xE9\xAD\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x44"],
        ["\xE6\xAB\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x45"],
        ["\xE7\x82\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x46"],
        ["\xE8\xB3\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x47"],
        ["\xE8\xB7\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x48"],
        ["\xE9\x9C\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x49"],
        ["\xE5\x8A\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4A"],
        ["\xE5\xA9\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4B"],
        ["\xE5\xBB\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4C"],
        ["\xE5\xBC\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4D"],
        ["\xE6\x9C\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4E"],
        ["\xE6\xA5\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x4F"],
        ["\xE6\xA6\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x50"],
        ["\xE6\xB5\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x51"],
        ["\xE6\xBC\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x52"],
        ["\xE7\x89\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x53"],
        ["\xE7\x8B\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x54"],
        ["\xE7\xAF\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x55"],
        ["\xE8\x80\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x56"],
        ["\xE8\x81\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x57"],
        ["\xE8\x9D\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x58"],
        ["\xE9\x83\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x59"],
        ["\xE5\x85\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5A"],
        ["\xE9\xBA\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5B"],
        ["\xE7\xA6\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5C"],
        ["\xE8\x82\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5D"],
        ["\xE9\x8C\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5E"],
        ["\xE8\xAB\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x5F"],
        ["\xE5\x80\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x60"],
        ["\xE5\x92\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x61"],
        ["\xE8\xA9\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x62"],
        ["\xE6\xAD\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x63"],
        ["\xE8\xB3\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x64"],
        ["\xE8\x84\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x65"],
        ["\xE6\x83\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x66"],
        ["\xE6\x9E\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x67"],
        ["\xE9\xB7\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x68"],
        ["\xE4\xBA\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x69"],
        ["\xE4\xBA\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6A"],
        ["\xE9\xB0\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6B"],
        ["\xE8\xA9\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6C"],
        ["\xE8\x97\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6D"],
        ["\xE8\x95\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6E"],
        ["\xE6\xA4\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x6F"],
        ["\xE6\xB9\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x70"],
        ["\xE7\xA2\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x71"],
        ["\xE8\x85\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x72"],
        ["\xE5\xBC\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\x9F"],
        ["\xE4\xB8\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA0"],
        ["\xE4\xB8\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA1"],
        ["\xE4\xB8\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA2"],
        ["\xE4\xB8\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA3"],
        ["\xE4\xB8\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA4"],
        ["\xE4\xB8\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA5"],
        ["\xE4\xB8\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA6"],
        ["\xE4\xB9\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA7"],
        ["\xE4\xB9\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA8"],
        ["\xE4\xB9\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xA9"],
        ["\xE4\xBA\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAA"],
        ["\xE4\xBA\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAB"],
        ["\xE8\xB1\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAC"],
        ["\xE4\xBA\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAD"],
        ["\xE8\x88\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAE"],
        ["\xE5\xBC\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xAF"],
        ["\xE4\xBA\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB0"],
        ["\xE4\xBA\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB1"],
        ["\xE4\xBA\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB2"],
        ["\xE4\xBA\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB3"],
        ["\xE4\xBA\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB4"],
        ["\xE4\xBA\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB5"],
        ["\xE4\xBA\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB6"],
        ["\xE4\xBA\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB7"],
        ["\xE4\xBB\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB8"],
        ["\xE4\xBB\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xB9"],
        ["\xE4\xBB\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBA"],
        ["\xE4\xBB\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBB"],
        ["\xE4\xBB\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBC"],
        ["\xE4\xBB\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBD"],
        ["\xE4\xBB\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBE"],
        ["\xE4\xBB\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xBF"],
        ["\xE4\xBB\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC0"],
        ["\xE4\xBB\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC1"],
        ["\xE4\xBC\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC2"],
        ["\xE4\xBD\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC3"],
        ["\xE4\xBC\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC4"],
        ["\xE4\xBD\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC5"],
        ["\xE4\xBD\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC6"],
        ["\xE4\xBD\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC7"],
        ["\xE4\xBD\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC8"],
        ["\xE4\xBD\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xC9"],
        ["\xE4\xBE\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCA"],
        ["\xE4\xBE\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCB"],
        ["\xE4\xBE\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCC"],
        ["\xE4\xBD\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCD"],
        ["\xE4\xBD\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCE"],
        ["\xE4\xBD\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xCF"],
        ["\xE4\xBE\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD0"],
        ["\xE4\xBD\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD1"],
        ["\xE4\xBE\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD2"],
        ["\xE4\xBE\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD3"],
        ["\xE5\x84\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD4"],
        ["\xE4\xBF\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD5"],
        ["\xE4\xBF\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD6"],
        ["\xE4\xBF\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD7"],
        ["\xE4\xBF\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD8"],
        ["\xE4\xBF\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xD9"],
        ["\xE4\xBF\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDA"],
        ["\xE4\xBF\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDB"],
        ["\xE4\xBF\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDC"],
        ["\xE4\xBF\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDD"],
        ["\xE4\xBF\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDE"],
        ["\xE5\x80\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xDF"],
        ["\xE5\x80\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE0"],
        ["\xE5\x80\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE1"],
        ["\xE5\x80\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE2"],
        ["\xE5\x80\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE3"],
        ["\xE5\x80\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE4"],
        ["\xE4\xBC\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE5"],
        ["\xE4\xBF\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE6"],
        ["\xE5\x80\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE7"],
        ["\xE5\x80\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE8"],
        ["\xE5\x80\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xE9"],
        ["\xE4\xBF\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEA"],
        ["\xE4\xBF\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEB"],
        ["\xE5\x80\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEC"],
        ["\xE5\x80\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xED"],
        ["\xE5\x81\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEE"],
        ["\xE5\x81\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xEF"],
        ["\xE6\x9C\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF0"],
        ["\xE5\x81\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF1"],
        ["\xE5\x81\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF2"],
        ["\xE5\x81\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF3"],
        ["\xE5\x81\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF4"],
        ["\xE5\x81\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF5"],
        ["\xE5\x81\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF6"],
        ["\xE5\x81\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF7"],
        ["\xE5\x82\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF8"],
        ["\xE5\x82\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xF9"],
        ["\xE5\x82\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xFA"],
        ["\xE5\x82\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xFB"],
        ["\xE5\x82\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x98\xFC"],
        ["\xE5\x83\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x40"],
        ["\xE5\x83\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x41"],
        ["\xE5\x82\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x42"],
        ["\xE5\x83\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x43"],
        ["\xE5\x83\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x44"],
        ["\xE5\x83\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x45"],
        ["\xE5\x83\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x46"],
        ["\xE5\x83\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x47"],
        ["\xE5\x83\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x48"],
        ["\xE5\x83\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x49"],
        ["\xE5\x83\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4A"],
        ["\xE5\x83\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4B"],
        ["\xE5\x84\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4C"],
        ["\xE5\x84\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4D"],
        ["\xE5\x84\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4E"],
        ["\xE5\x84\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x4F"],
        ["\xE5\x84\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x50"],
        ["\xE5\x84\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x51"],
        ["\xE5\x84\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x52"],
        ["\xE5\x84\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x53"],
        ["\xE5\x84\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x54"],
        ["\xE5\x84\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x55"],
        ["\xE5\x84\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x56"],
        ["\xE5\x84\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x57"],
        ["\xE5\x84\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x58"],
        ["\xE5\x85\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x59"],
        ["\xE5\x85\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5A"],
        ["\xE5\x85\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5B"],
        ["\xE5\x85\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5C"],
        ["\xE5\x85\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5D"],
        ["\xE7\xAB\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5E"],
        ["\xE5\x85\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x5F"],
        ["\xE5\x85\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x60"],
        ["\xE5\x85\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x61"],
        ["\xE5\x86\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x62"],
        ["\xE5\x86\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x63"],
        ["\xE5\x9B\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x64"],
        ["\xE5\x86\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x65"],
        ["\xE5\x86\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x66"],
        ["\xE5\x86\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x67"],
        ["\xE5\x86\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x68"],
        ["\xE5\x86\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x69"],
        ["\xE5\x86\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6A"],
        ["\xE5\x86\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6B"],
        ["\xE5\x86\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6C"],
        ["\xE5\x86\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6D"],
        ["\xE5\x86\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6E"],
        ["\xE5\x86\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x6F"],
        ["\xE5\x86\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x70"],
        ["\xE5\x86\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x71"],
        ["\xE5\x86\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x72"],
        ["\xE5\x86\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x73"],
        ["\xE5\x86\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x74"],
        ["\xE5\x86\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x75"],
        ["\xE5\x86\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x76"],
        ["\xE5\x86\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x77"],
        ["\xE5\x87\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x78"],
        ["\xE5\x87\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x79"],
        ["\xE5\x87\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7A"],
        ["\xE5\x87\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7B"],
        ["\xE8\x99\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7C"],
        ["\xE5\x87\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7D"],
        ["\xE5\x87\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x7E"],
        ["\xE5\x87\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x80"],
        ["\xE5\x87\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x81"],
        ["\xE5\x87\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x82"],
        ["\xE5\x88\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x83"],
        ["\xE5\x88\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x84"],
        ["\xE5\x88\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x85"],
        ["\xE5\x88\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x86"],
        ["\xE5\x88\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x87"],
        ["\xE5\x88\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x88"],
        ["\xE5\x88\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x89"],
        ["\xE5\x88\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8A"],
        ["\xE5\x88\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8B"],
        ["\xE5\x89\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8C"],
        ["\xE5\x89\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8D"],
        ["\xE5\x89\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8E"],
        ["\xE5\x89\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x8F"],
        ["\xE5\x89\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x90"],
        ["\xE5\x89\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x91"],
        ["\xE5\x89\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x92"],
        ["\xE5\x89\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x93"],
        ["\xE5\x89\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x94"],
        ["\xE5\x89\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x95"],
        ["\xE5\x89\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x96"],
        ["\xE5\x89\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x97"],
        ["\xE5\x8A\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x98"],
        ["\xE5\x8A\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x99"],
        ["\xE5\x8A\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9A"],
        ["\xE5\x89\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9B"],
        ["\xE5\x8A\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9C"],
        ["\xE5\x8A\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9D"],
        ["\xE8\xBE\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9E"],
        ["\xE8\xBE\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\x9F"],
        ["\xE5\x8A\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA0"],
        ["\xE5\x8A\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA1"],
        ["\xE5\x8A\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA2"],
        ["\xE5\x8A\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA3"],
        ["\xE5\x8B\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA4"],
        ["\xE5\x8B\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA5"],
        ["\xE5\x8B\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA6"],
        ["\xE5\x8B\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA7"],
        ["\xE5\x8B\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA8"],
        ["\xE5\x8B\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xA9"],
        ["\xE9\xA3\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAA"],
        ["\xE5\x8B\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAB"],
        ["\xE5\x8B\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAC"],
        ["\xE5\x8B\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAD"],
        ["\xE5\x8B\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAE"],
        ["\xE5\x8B\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xAF"],
        ["\xE5\x8C\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB0"],
        ["\xE5\x8C\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB1"],
        ["\xE7\x94\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB2"],
        ["\xE5\x8C\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB3"],
        ["\xE5\x8C\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB4"],
        ["\xE5\x8C\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB5"],
        ["\xE5\x8C\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB6"],
        ["\xE5\x8C\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB7"],
        ["\xE5\x8C\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB8"],
        ["\xE5\x8C\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xB9"],
        ["\xE5\x8C\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBA"],
        ["\xE5\x8C\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBB"],
        ["\xE5\x8C\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBC"],
        ["\xE5\x8D\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBD"],
        ["\xE5\x8D\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBE"],
        ["\xE5\x8D\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xBF"],
        ["\xE4\xB8\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC0"],
        ["\xE5\x8D\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC1"],
        ["\xE5\x8D\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC2"],
        ["\xE5\x87\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC3"],
        ["\xE5\x8D\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC4"],
        ["\xE5\x8D\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC5"],
        ["\xE5\x8D\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC6"],
        ["\xE5\xA4\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC7"],
        ["\xE5\x8D\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC8"],
        ["\xE5\x8D\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xC9"],
        ["\xE5\x8E\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCA"],
        ["\xE5\x8E\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCB"],
        ["\xE5\x8E\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCC"],
        ["\xE5\x8E\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCD"],
        ["\xE5\x8E\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCE"],
        ["\xE5\x8E\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xCF"],
        ["\xE5\x8E\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD0"],
        ["\xE5\x8E\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD1"],
        ["\xE5\x8F\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD2"],
        ["\xE7\xB0\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD3"],
        ["\xE9\x9B\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD4"],
        ["\xE5\x8F\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD5"],
        ["\xE6\x9B\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD6"],
        ["\xE7\x87\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD7"],
        ["\xE5\x8F\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD8"],
        ["\xE5\x8F\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xD9"],
        ["\xE5\x8F\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDA"],
        ["\xE5\x8F\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDB"],
        ["\xE5\x90\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDC"],
        ["\xE5\x90\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDD"],
        ["\xE5\x91\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDE"],
        ["\xE5\x90\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xDF"],
        ["\xE5\x90\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE0"],
        ["\xE5\x90\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE1"],
        ["\xE5\x90\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE2"],
        ["\xE5\x90\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE3"],
        ["\xE5\x90\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE4"],
        ["\xE5\x90\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE5"],
        ["\xE5\x91\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE6"],
        ["\xE5\x92\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE7"],
        ["\xE5\x91\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE8"],
        ["\xE5\x92\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xE9"],
        ["\xE5\x91\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEA"],
        ["\xE5\x91\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEB"],
        ["\xE5\x91\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEC"],
        ["\xE5\x91\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xED"],
        ["\xE5\x92\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEE"],
        ["\xE5\x91\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xEF"],
        ["\xE5\x92\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF0"],
        ["\xE5\x91\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF1"],
        ["\xE5\x92\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF2"],
        ["\xE5\x92\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF3"],
        ["\xE5\x92\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF4"],
        ["\xE5\x93\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF5"],
        ["\xE5\x92\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF6"],
        ["\xE5\x92\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF7"],
        ["\xE5\x92\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF8"],
        ["\xE5\x92\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xF9"],
        ["\xE5\x93\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xFA"],
        ["\xE5\x93\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xFB"],
        ["\xE5\x92\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x99\xFC"],
        ["\xE5\x92\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x40"],
        ["\xE5\x93\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x41"],
        ["\xE5\x92\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x42"],
        ["\xE5\x92\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x43"],
        ["\xE5\x92\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x44"],
        ["\xE5\x93\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x45"],
        ["\xE5\x93\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x46"],
        ["\xE5\x93\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x47"],
        ["\xE5\x94\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x48"],
        ["\xE5\x94\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x49"],
        ["\xE5\x93\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4A"],
        ["\xE5\x93\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4B"],
        ["\xE5\x93\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4C"],
        ["\xE5\x93\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4D"],
        ["\xE5\x93\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4E"],
        ["\xE5\x94\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x4F"],
        ["\xE5\x95\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x50"],
        ["\xE5\x95\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x51"],
        ["\xE5\x95\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x52"],
        ["\xE5\x94\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x53"],
        ["\xE5\x95\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x54"],
        ["\xE5\x95\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x55"],
        ["\xE5\x95\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x56"],
        ["\xE5\x95\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x57"],
        ["\xE5\x94\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x58"],
        ["\xE5\x94\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x59"],
        ["\xE5\x95\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5A"],
        ["\xE5\x96\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5B"],
        ["\xE5\x96\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5C"],
        ["\xE5\x92\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5D"],
        ["\xE5\x96\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5E"],
        ["\xE5\x96\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x5F"],
        ["\xE5\x95\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x60"],
        ["\xE5\x95\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x61"],
        ["\xE5\x96\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x62"],
        ["\xE5\x96\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x63"],
        ["\xE5\x96\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x64"],
        ["\xE5\x95\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x65"],
        ["\xE5\x96\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x66"],
        ["\xE5\x96\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x67"],
        ["\xE5\x96\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x68"],
        ["\xE5\x96\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x69"],
        ["\xE5\x97\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6A"],
        ["\xE5\x97\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6B"],
        ["\xE5\x97\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6C"],
        ["\xE5\x97\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6D"],
        ["\xE5\x97\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6E"],
        ["\xE5\x97\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x6F"],
        ["\xE5\x97\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x70"],
        ["\xE5\x98\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x71"],
        ["\xE5\x97\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x72"],
        ["\xE5\x98\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x73"],
        ["\xE5\x97\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x74"],
        ["\xE5\x97\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x75"],
        ["\xE5\x98\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x76"],
        ["\xE5\x97\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x77"],
        ["\xE5\x99\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x78"],
        ["\xE5\x99\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x79"],
        ["\xE7\x87\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7A"],
        ["\xE5\x98\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7B"],
        ["\xE5\x98\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7C"],
        ["\xE5\x98\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7D"],
        ["\xE5\x98\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x7E"],
        ["\xE5\x99\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x80"],
        ["\xE5\x99\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x81"],
        ["\xE5\x98\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x82"],
        ["\xE5\x99\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x83"],
        ["\xE5\x99\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x84"],
        ["\xE5\x9A\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x85"],
        ["\xE5\x9A\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x86"],
        ["\xE5\x9A\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x87"],
        ["\xE5\x9A\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x88"],
        ["\xE5\x9A\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x89"],
        ["\xE5\x9A\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8A"],
        ["\xE5\x9A\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8B"],
        ["\xE5\x9A\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8C"],
        ["\xE5\x9A\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8D"],
        ["\xE5\x9A\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8E"],
        ["\xE5\x9B\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x8F"],
        ["\xE5\x9A\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x90"],
        ["\xE5\x9B\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x91"],
        ["\xE5\x9B\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x92"],
        ["\xE5\x9B\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x93"],
        ["\xE5\x9B\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x94"],
        ["\xE5\x9B\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x95"],
        ["\xE5\x9B\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x96"],
        ["\xE5\x9B\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x97"],
        ["\xE5\x9B\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x98"],
        ["\xE5\x9B\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x99"],
        ["\xE5\x9B\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9A"],
        ["\xE5\x9C\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9B"],
        ["\xE5\x9B\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9C"],
        ["\xE5\x9C\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9D"],
        ["\xE5\x9C\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9E"],
        ["\xE5\x9C\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\x9F"],
        ["\xE5\x9C\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA0"],
        ["\xE5\x9C\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA1"],
        ["\xE5\x9C\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA2"],
        ["\xE5\x9C\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA3"],
        ["\xE5\x9C\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA4"],
        ["\xE5\x97\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA5"],
        ["\xE5\x9C\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA6"],
        ["\xE5\x9C\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA7"],
        ["\xE5\x9C\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA8"],
        ["\xE5\x9C\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xA9"],
        ["\xE5\x9D\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAA"],
        ["\xE5\x9C\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAB"],
        ["\xE5\x9D\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAC"],
        ["\xE5\x9D\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAD"],
        ["\xE5\x9D\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],
        ["\xE5\x9F\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xAF"],
        ["\xE5\x9E\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB0"],
        ["\xE5\x9D\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB1"],
        ["\xE5\x9D\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB2"],
        ["\xE5\x9E\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB3"],
        ["\xE5\x9E\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB4"],
        ["\xE5\x9E\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB5"],
        ["\xE5\x9E\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB6"],
        ["\xE5\x9E\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB7"],
        ["\xE5\x9E\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB8"],
        ["\xE5\x9E\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xB9"],
        ["\xE5\x9F\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBA"],
        ["\xE5\x9F\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBB"],
        ["\xE5\x9F\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBC"],
        ["\xE5\x9F\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBD"],
        ["\xE5\x9F\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBE"],
        ["\xE5\xA0\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xBF"],
        ["\xE5\x9F\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC0"],
        ["\xE5\x9F\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC1"],
        ["\xE5\xA0\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC2"],
        ["\xE5\xA0\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC3"],
        ["\xE5\xA0\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC4"],
        ["\xE5\xA1\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC5"],
        ["\xE5\xA0\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC6"],
        ["\xE5\xA1\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC7"],
        ["\xE5\xA1\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC8"],
        ["\xE5\xA1\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xC9"],
        ["\xE6\xAF\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCA"],
        ["\xE5\xA1\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCB"],
        ["\xE5\xA0\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCC"],
        ["\xE5\xA1\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCD"],
        ["\xE5\xA2\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCE"],
        ["\xE5\xA2\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xCF"],
        ["\xE5\xA2\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD0"],
        ["\xE5\xA2\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD1"],
        ["\xE5\xA2\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD2"],
        ["\xE5\xA3\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD3"],
        ["\xE5\xA2\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD4"],
        ["\xE5\xA2\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD5"],
        ["\xE5\xA2\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD6"],
        ["\xE5\xA3\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD7"],
        ["\xE5\xA3\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD8"],
        ["\xE5\xA3\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xD9"],
        ["\xE5\xA3\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDA"],
        ["\xE5\xA3\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDB"],
        ["\xE5\xA3\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDC"],
        ["\xE5\xA3\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDD"],
        ["\xE5\xA3\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDE"],
        ["\xE5\xA3\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xDF"],
        ["\xE5\xA3\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE0"],
        ["\xE5\xA3\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE1"],
        ["\xE5\xA3\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE2"],
        ["\xE5\xA3\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE3"],
        ["\xE5\xA3\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE4"],
        ["\xE5\xA3\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE5"],
        ["\xE5\xA3\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE6"],
        ["\xE5\xA4\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE7"],
        ["\xE5\xA4\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE8"],
        ["\xE5\xA4\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xE9"],
        ["\xE5\xA4\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEA"],
        ["\xE6\xA2\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEB"],
        ["\xE5\xA4\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEC"],
        ["\xE5\xA4\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xED"],
        ["\xE5\xA4\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEE"],
        ["\xE5\xA4\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xEF"],
        ["\xE5\xA4\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF0"],
        ["\xE5\xA4\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF1"],
        ["\xE7\xAB\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF2"],
        ["\xE5\xA5\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF3"],
        ["\xE5\xA5\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF4"],
        ["\xE5\xA5\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF5"],
        ["\xE5\xA5\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF6"],
        ["\xE5\xA5\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF7"],
        ["\xE5\xA5\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF8"],
        ["\xE5\xA5\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xF9"],
        ["\xE5\xA5\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xFA"],
        ["\xE5\xA5\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xFB"],
        ["\xE5\xA5\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9A\xFC"],
        ["\xE5\xA5\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x40"],
        ["\xE5\xA6\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x41"],
        ["\xE5\xA6\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x42"],
        ["\xE4\xBD\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x43"],
        ["\xE4\xBE\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x44"],
        ["\xE5\xA6\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x45"],
        ["\xE5\xA6\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x46"],
        ["\xE5\xA7\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x47"],
        ["\xE5\xA7\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x48"],
        ["\xE5\xA7\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x49"],
        ["\xE5\xA6\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4A"],
        ["\xE5\xA7\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4B"],
        ["\xE5\xA7\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4C"],
        ["\xE5\xA8\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4D"],
        ["\xE5\xA8\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4E"],
        ["\xE5\xA8\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x4F"],
        ["\xE5\xA8\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x50"],
        ["\xE5\xA8\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x51"],
        ["\xE5\xA8\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x52"],
        ["\xE5\xA9\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x53"],
        ["\xE5\xA9\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x54"],
        ["\xE5\xA9\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x55"],
        ["\xE5\xA8\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x56"],
        ["\xE5\xA8\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x57"],
        ["\xE5\xA9\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x58"],
        ["\xE5\xA9\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x59"],
        ["\xE5\xAA\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5A"],
        ["\xE5\xAA\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5B"],
        ["\xE5\xAA\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5C"],
        ["\xE5\xAB\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5D"],
        ["\xE5\xAB\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5E"],
        ["\xE5\xAA\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x5F"],
        ["\xE5\xAB\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x60"],
        ["\xE5\xAB\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x61"],
        ["\xE5\xAB\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x62"],
        ["\xE5\xAB\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x63"],
        ["\xE5\xAB\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x64"],
        ["\xE5\xAB\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x65"],
        ["\xE5\xAB\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x66"],
        ["\xE5\xAC\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x67"],
        ["\xE5\xAC\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x68"],
        ["\xE5\xAC\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x69"],
        ["\xE5\xAC\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6A"],
        ["\xE5\xAB\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6B"],
        ["\xE5\xAC\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6C"],
        ["\xE5\xAC\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6D"],
        ["\xE5\xAC\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6E"],
        ["\xE5\xAD\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x6F"],
        ["\xE5\xAD\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x70"],
        ["\xE5\xAD\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x71"],
        ["\xE5\xAD\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x72"],
        ["\xE5\xAD\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x73"],
        ["\xE5\xAD\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x74"],
        ["\xE5\xAD\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x75"],
        ["\xE5\xAD\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x76"],
        ["\xE5\xAD\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x77"],
        ["\xE5\xAD\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x78"],
        ["\xE5\xAD\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x79"],
        ["\xE5\xAD\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7A"],
        ["\xE5\xAD\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7B"],
        ["\xE6\x96\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7C"],
        ["\xE5\xAD\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7D"],
        ["\xE5\xAE\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x7E"],
        ["\xE5\xAE\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x80"],
        ["\xE5\xAE\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x81"],
        ["\xE5\xAE\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x82"],
        ["\xE5\xAF\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x83"],
        ["\xE5\xAF\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x84"],
        ["\xE5\xAF\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x85"],
        ["\xE5\xAF\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x86"],
        ["\xE5\xAF\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x87"],
        ["\xE5\xAF\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x88"],
        ["\xE5\xAF\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x89"],
        ["\xE5\xAF\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8A"],
        ["\xE5\xAF\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8B"],
        ["\xE5\xAF\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8C"],
        ["\xE5\xAF\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8D"],
        ["\xE5\xAF\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8E"],
        ["\xE5\xAF\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x8F"],
        ["\xE5\xAF\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x90"],
        ["\xE5\xB0\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x91"],
        ["\xE5\xB0\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x92"],
        ["\xE5\xB0\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x93"],
        ["\xE5\xB0\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x94"],
        ["\xE5\xB0\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x95"],
        ["\xE5\xB0\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x96"],
        ["\xE5\xB0\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x97"],
        ["\xE5\xB0\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x98"],
        ["\xE5\xB0\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x99"],
        ["\xE5\xB0\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9A"],
        ["\xE5\xB1\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9B"],
        ["\xE5\xB1\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9C"],
        ["\xE5\xB1\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9D"],
        ["\xE5\xB1\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9E"],
        ["\xE5\xB1\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\x9F"],
        ["\xE5\xB1\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA0"],
        ["\xE5\xAD\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA1"],
        ["\xE5\xB1\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA2"],
        ["\xE5\xB1\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA3"],
        ["\xE4\xB9\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA4"],
        ["\xE5\xB1\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA5"],
        ["\xE5\xB1\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA6"],
        ["\xE5\xB2\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA7"],
        ["\xE5\xB2\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA8"],
        ["\xE5\xB2\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xA9"],
        ["\xE5\xA6\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAA"],
        ["\xE5\xB2\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAB"],
        ["\xE5\xB2\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAC"],
        ["\xE5\xB2\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAD"],
        ["\xE5\xB2\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAE"],
        ["\xE5\xB2\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xAF"],
        ["\xE5\xB3\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB0"],
        ["\xE5\xB2\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB1"],
        ["\xE5\xB3\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB2"],
        ["\xE5\xB3\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB3"],
        ["\xE5\xB3\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB4"],
        ["\xE5\xB3\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB5"],
        ["\xE5\xB3\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB6"],
        ["\xE5\xB3\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB7"],
        ["\xE5\xB6\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB8"],
        ["\xE5\xB3\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xB9"],
        ["\xE5\xB4\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBA"],
        ["\xE5\xB4\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBB"],
        ["\xE5\xB4\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBC"],
        ["\xE5\xB5\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBD"],
        ["\xE5\xB4\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBE"],
        ["\xE5\xB4\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xBF"],
        ["\xE5\xB4\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC0"],
        ["\xE5\xB4\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC1"],
        ["\xE5\xB4\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC2"],
        ["\xE5\xB4\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC3"],
        ["\xE5\xB4\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC4"],
        ["\xE5\xB4\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC5"],
        ["\xE5\xB5\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC6"],
        ["\xE5\xB5\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC7"],
        ["\xE5\xB5\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC8"],
        ["\xE5\xB5\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xC9"],
        ["\xE5\xB5\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCA"],
        ["\xE5\xB5\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCB"],
        ["\xE5\xB5\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCC"],
        ["\xE5\xB6\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCD"],
        ["\xE5\xB6\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCE"],
        ["\xE5\xB6\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xCF"],
        ["\xE5\xB6\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD0"],
        ["\xE5\xB6\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD1"],
        ["\xE5\xB6\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD2"],
        ["\xE5\xB6\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD3"],
        ["\xE5\xB6\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD4"],
        ["\xE5\xB6\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD5"],
        ["\xE5\xB6\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD6"],
        ["\xE5\xB6\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD7"],
        ["\xE5\xB7\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD8"],
        ["\xE5\xB7\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xD9"],
        ["\xE5\xB7\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDA"],
        ["\xE5\xB7\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDB"],
        ["\xE5\xB7\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDC"],
        ["\xE5\xB7\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDD"],
        ["\xE5\xB7\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDE"],
        ["\xE5\xB7\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xDF"],
        ["\xE5\xB7\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE0"],
        ["\xE5\xB8\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE1"],
        ["\xE5\xB8\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE2"],
        ["\xE5\xB8\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE3"],
        ["\xE5\xB8\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE4"],
        ["\xE5\xB8\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE5"],
        ["\xE5\xB8\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE6"],
        ["\xE5\xB8\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE7"],
        ["\xE5\xB9\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE8"],
        ["\xE5\xB9\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xE9"],
        ["\xE5\xB9\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEA"],
        ["\xE5\xB9\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEB"],
        ["\xE5\xB9\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEC"],
        ["\xE5\xB9\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xED"],
        ["\xE5\xB9\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEE"],
        ["\xE5\xB9\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xEF"],
        ["\xE5\xB9\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF0"],
        ["\xE5\xB9\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF1"],
        ["\xE5\xB9\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF2"],
        ["\xE5\xB9\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF3"],
        ["\xE5\xB9\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF4"],
        ["\xE9\xBA\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF5"],
        ["\xE5\xB9\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF6"],
        ["\xE5\xBA\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF7"],
        ["\xE5\xBB\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF8"],
        ["\xE5\xBB\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xF9"],
        ["\xE5\xBB\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xFA"],
        ["\xE5\xBB\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xFB"],
        ["\xE5\xBB\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9B\xFC"],
        ["\xE5\xBB\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x40"],
        ["\xE5\xBB\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x41"],
        ["\xE5\xBB\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x42"],
        ["\xE5\xBB\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x43"],
        ["\xE5\xBB\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x44"],
        ["\xE5\xBB\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x45"],
        ["\xE5\xBB\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x46"],
        ["\xE5\xBB\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x47"],
        ["\xE5\xBB\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x48"],
        ["\xE5\xBB\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x49"],
        ["\xE5\xBB\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4A"],
        ["\xE5\xBB\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4B"],
        ["\xE5\xBB\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4C"],
        ["\xE5\xBB\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4D"],
        ["\xE5\xBB\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4E"],
        ["\xE5\xBB\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x4F"],
        ["\xE5\xBC\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x50"],
        ["\xE5\xBC\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x51"],
        ["\xE5\xBD\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x52"],
        ["\xE5\xBD\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x53"],
        ["\xE5\xBC\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x54"],
        ["\xE5\xBC\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x55"],
        ["\xE5\xBC\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x56"],
        ["\xE5\xBC\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x57"],
        ["\xE5\xBC\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x58"],
        ["\xE5\xBC\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x59"],
        ["\xE5\xBD\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5B"],
        ["\xE5\xBD\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5C"],
        ["\xE5\xBD\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5D"],
        ["\xE5\xBC\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5E"],
        ["\xE5\xBD\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5F"],
        ["\xE5\xBD\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x60"],
        ["\xE5\xBD\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x61"],
        ["\xE5\xBD\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x62"],
        ["\xE5\xBD\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x63"],
        ["\xE5\xBD\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x64"],
        ["\xE5\xBD\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x65"],
        ["\xE5\xBD\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x66"],
        ["\xE5\xBE\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x67"],
        ["\xE5\xBE\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x68"],
        ["\xE5\xBD\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x69"],
        ["\xE5\xBE\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6A"],
        ["\xE5\xBE\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6B"],
        ["\xE5\xBE\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6C"],
        ["\xE5\xBE\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6D"],
        ["\xE5\xBE\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6E"],
        ["\xE5\xBE\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x6F"],
        ["\xE5\xBE\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x70"],
        ["\xE5\xBE\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x71"],
        ["\xE5\xBE\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x72"],
        ["\xE5\xBE\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x73"],
        ["\xE5\xBE\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x74"],
        ["\xE5\xBF\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x75"],
        ["\xE5\xBF\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x76"],
        ["\xE5\xBF\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x77"],
        ["\xE5\xBF\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x78"],
        ["\xE5\xBF\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x79"],
        ["\xE5\xBF\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7A"],
        ["\xE6\x82\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7B"],
        ["\xE5\xBF\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7C"],
        ["\xE6\x80\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7D"],
        ["\xE6\x81\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x7E"],
        ["\xE6\x80\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x80"],
        ["\xE6\x80\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x81"],
        ["\xE6\x80\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x82"],
        ["\xE6\x80\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x83"],
        ["\xE6\x80\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x84"],
        ["\xE6\x80\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x85"],
        ["\xE6\x80\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x86"],
        ["\xE6\x80\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x87"],
        ["\xE6\x80\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x88"],
        ["\xE6\x80\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x89"],
        ["\xE6\x80\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8A"],
        ["\xE6\x81\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8B"],
        ["\xE6\x81\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8C"],
        ["\xE6\x81\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8D"],
        ["\xE6\x81\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8E"],
        ["\xE6\x81\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x8F"],
        ["\xE6\x81\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x90"],
        ["\xE6\x81\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x91"],
        ["\xE6\x81\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x92"],
        ["\xE6\x81\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x93"],
        ["\xE6\x81\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x94"],
        ["\xE6\x81\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x95"],
        ["\xE6\x81\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x96"],
        ["\xE6\x81\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x97"],
        ["\xE6\x81\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x98"],
        ["\xE6\x81\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x99"],
        ["\xE6\x82\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9A"],
        ["\xE6\x82\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9B"],
        ["\xE6\x83\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9C"],
        ["\xE6\x82\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9D"],
        ["\xE6\x82\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9E"],
        ["\xE6\x82\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x9F"],
        ["\xE6\x82\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA0"],
        ["\xE6\x82\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA1"],
        ["\xE6\x82\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA2"],
        ["\xE6\x82\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA3"],
        ["\xE6\x82\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA4"],
        ["\xE6\x82\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA5"],
        ["\xE6\x83\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA6"],
        ["\xE6\x82\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA7"],
        ["\xE6\x83\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA8"],
        ["\xE6\x83\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xA9"],
        ["\xE6\x82\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAA"],
        ["\xE5\xBF\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAB"],
        ["\xE6\x82\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAC"],
        ["\xE6\x83\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAD"],
        ["\xE6\x82\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAE"],
        ["\xE6\x83\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xAF"],
        ["\xE6\x85\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB0"],
        ["\xE6\x84\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB1"],
        ["\xE6\x84\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB2"],
        ["\xE6\x83\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB3"],
        ["\xE6\x83\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB4"],
        ["\xE6\x84\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB5"],
        ["\xE6\x83\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB6"],
        ["\xE6\x83\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB7"],
        ["\xE6\x84\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB8"],
        ["\xE6\x84\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xB9"],
        ["\xE6\x83\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBA"],
        ["\xE6\x83\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBB"],
        ["\xE6\x84\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBC"],
        ["\xE6\x84\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBD"],
        ["\xE6\x85\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBE"],
        ["\xE6\x84\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xBF"],
        ["\xE6\x84\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC0"],
        ["\xE6\x84\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC1"],
        ["\xE6\x85\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC2"],
        ["\xE6\x84\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC3"],
        ["\xE6\x84\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC4"],
        ["\xE6\x84\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC5"],
        ["\xE6\x84\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC6"],
        ["\xE6\x84\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC7"],
        ["\xE6\x85\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC8"],
        ["\xE6\x85\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xC9"],
        ["\xE6\x85\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCA"],
        ["\xE6\x85\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCB"],
        ["\xE6\x85\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCC"],
        ["\xE6\x85\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCD"],
        ["\xE6\x85\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCE"],
        ["\xE6\x85\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xCF"],
        ["\xE6\x85\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD0"],
        ["\xE6\x85\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD1"],
        ["\xE6\x85\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD2"],
        ["\xE6\x85\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD3"],
        ["\xE6\x85\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD4"],
        ["\xE6\x85\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD5"],
        ["\xE6\x85\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD6"],
        ["\xE6\x85\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD7"],
        ["\xE6\x86\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD8"],
        ["\xE6\x86\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xD9"],
        ["\xE6\x86\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDA"],
        ["\xE6\x86\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDB"],
        ["\xE6\x86\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDC"],
        ["\xE6\x86\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDD"],
        ["\xE6\x86\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDE"],
        ["\xE6\x86\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xDF"],
        ["\xE6\x86\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE0"],
        ["\xE6\x86\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE1"],
        ["\xE6\x87\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE2"],
        ["\xE6\x87\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE3"],
        ["\xE6\x87\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE4"],
        ["\xE6\x87\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE5"],
        ["\xE6\x87\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE6"],
        ["\xE6\x87\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE7"],
        ["\xE6\x87\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE8"],
        ["\xE6\x86\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xE9"],
        ["\xE6\x87\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEA"],
        ["\xE7\xBD\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEB"],
        ["\xE6\x87\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEC"],
        ["\xE6\x87\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xED"],
        ["\xE6\x87\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEE"],
        ["\xE6\x87\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xEF"],
        ["\xE6\x87\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF0"],
        ["\xE6\x87\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF1"],
        ["\xE6\x87\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF2"],
        ["\xE6\x87\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF3"],
        ["\xE6\x87\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF4"],
        ["\xE6\x87\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF5"],
        ["\xE6\x88\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF6"],
        ["\xE6\x88\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF7"],
        ["\xE6\x88\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF8"],
        ["\xE6\x88\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xF9"],
        ["\xE6\x88\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xFA"],
        ["\xE6\x88\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xFB"],
        ["\xE6\x88\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\xFC"],
        ["\xE6\x88\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x40"],
        ["\xE6\x88\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x41"],
        ["\xE6\x88\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x42"],
        ["\xE6\x88\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x43"],
        ["\xE6\x88\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x44"],
        ["\xE6\x88\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x45"],
        ["\xE6\x88\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x46"],
        ["\xE6\x89\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x47"],
        ["\xE6\x89\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x48"],
        ["\xE6\x89\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x49"],
        ["\xE6\x89\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4A"],
        ["\xE6\x89\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4B"],
        ["\xE6\x89\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4C"],
        ["\xE6\x89\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4D"],
        ["\xE6\x89\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4E"],
        ["\xE6\x8A\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x4F"],
        ["\xE6\x8A\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x50"],
        ["\xE6\x89\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x51"],
        ["\xE6\x8A\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x52"],
        ["\xE6\x8A\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x53"],
        ["\xE6\x8A\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x54"],
        ["\xE6\x8B\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x55"],
        ["\xE6\x8A\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x56"],
        ["\xE6\x8A\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x57"],
        ["\xE6\x8B\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x58"],
        ["\xE6\x8B\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x59"],
        ["\xE6\x8A\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5A"],
        ["\xE6\x8B\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5B"],
        ["\xE6\x8B\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5C"],
        ["\xE6\x8B\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5D"],
        ["\xE6\x93\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5E"],
        ["\xE6\x8B\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x5F"],
        ["\xE6\x8B\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x60"],
        ["\xE6\x8B\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x61"],
        ["\xE6\x8B\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x62"],
        ["\xE6\x8B\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x63"],
        ["\xE6\x8B\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x64"],
        ["\xE6\x8A\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x65"],
        ["\xE6\x8B\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x66"],
        ["\xE6\x8C\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x67"],
        ["\xE6\x8B\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x68"],
        ["\xE6\x8B\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x69"],
        ["\xE6\x8C\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6A"],
        ["\xE6\x8C\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6B"],
        ["\xE6\x8C\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6C"],
        ["\xE6\x8B\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6D"],
        ["\xE6\x8B\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6E"],
        ["\xE6\x8D\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x6F"],
        ["\xE6\x8C\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x70"],
        ["\xE6\x8D\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x71"],
        ["\xE6\x90\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x72"],
        ["\xE6\x8D\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x73"],
        ["\xE6\x8E\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x74"],
        ["\xE6\x8E\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x75"],
        ["\xE6\x8E\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x76"],
        ["\xE6\x8E\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x77"],
        ["\xE6\x8D\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x78"],
        ["\xE6\x8E\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x79"],
        ["\xE6\x8E\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7A"],
        ["\xE6\x8E\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7B"],
        ["\xE6\x8E\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7C"],
        ["\xE6\x8E\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7D"],
        ["\xE6\x8D\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x7E"],
        ["\xE6\x8D\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x80"],
        ["\xE6\x8E\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x81"],
        ["\xE6\x8F\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x82"],
        ["\xE6\x8F\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x83"],
        ["\xE6\x8F\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x84"],
        ["\xE6\x8F\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x85"],
        ["\xE6\x8F\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x86"],
        ["\xE6\x8F\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x87"],
        ["\xE6\x8F\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x88"],
        ["\xE6\x8F\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x89"],
        ["\xE6\x90\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8A"],
        ["\xE6\x90\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8B"],
        ["\xE6\x90\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8C"],
        ["\xE6\x90\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8D"],
        ["\xE6\x90\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8E"],
        ["\xE6\x90\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x8F"],
        ["\xE6\x94\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x90"],
        ["\xE6\x90\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x91"],
        ["\xE6\x90\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x92"],
        ["\xE6\x90\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x93"],
        ["\xE6\x91\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x94"],
        ["\xE6\x91\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x95"],
        ["\xE6\x91\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x96"],
        ["\xE6\x91\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x97"],
        ["\xE6\x94\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x98"],
        ["\xE6\x92\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x99"],
        ["\xE6\x92\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9A"],
        ["\xE6\x92\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9B"],
        ["\xE6\x92\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9C"],
        ["\xE6\x92\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9D"],
        ["\xE6\x92\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9E"],
        ["\xE6\x93\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\x9F"],
        ["\xE6\x93\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA0"],
        ["\xE6\x93\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA1"],
        ["\xE6\x93\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA2"],
        ["\xE6\x92\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA3"],
        ["\xE6\x93\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA4"],
        ["\xE6\x93\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA5"],
        ["\xE6\x93\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA6"],
        ["\xE6\x93\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA7"],
        ["\xE8\x88\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA8"],
        ["\xE6\x93\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xA9"],
        ["\xE6\x93\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAA"],
        ["\xE6\x8A\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAB"],
        ["\xE6\x93\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAC"],
        ["\xE6\x93\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAD"],
        ["\xE6\x94\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAE"],
        ["\xE6\x93\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xAF"],
        ["\xE6\x93\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB0"],
        ["\xE6\x93\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB1"],
        ["\xE6\x93\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB2"],
        ["\xE6\x94\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB3"],
        ["\xE6\x93\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB4"],
        ["\xE6\x94\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB5"],
        ["\xE6\x94\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB6"],
        ["\xE6\x94\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB7"],
        ["\xE6\x94\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB8"],
        ["\xE6\x94\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xB9"],
        ["\xE6\x94\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBA"],
        ["\xE6\x94\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBB"],
        ["\xE6\x94\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBC"],
        ["\xE6\x94\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBD"],
        ["\xE6\x94\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBE"],
        ["\xE6\x94\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xBF"],
        ["\xE7\x95\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC0"],
        ["\xE6\x95\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC1"],
        ["\xE6\x95\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC2"],
        ["\xE6\x95\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC3"],
        ["\xE6\x95\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC4"],
        ["\xE6\x95\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC5"],
        ["\xE6\x95\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC6"],
        ["\xE6\x95\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC7"],
        ["\xE6\x95\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC8"],
        ["\xE6\x95\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xC9"],
        ["\xE6\x96\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCA"],
        ["\xE6\x96\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCB"],
        ["\xE8\xAE\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCC"],
        ["\xE6\x96\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCD"],
        ["\xE6\x96\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCE"],
        ["\xE6\x96\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xCF"],
        ["\xE6\x96\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD0"],
        ["\xE6\x97\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD1"],
        ["\xE6\x97\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD2"],
        ["\xE6\x97\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD3"],
        ["\xE6\x97\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD4"],
        ["\xE6\x97\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD5"],
        ["\xE6\x97\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD6"],
        ["\xE6\x97\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD7"],
        ["\xE6\x97\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD8"],
        ["\xE6\x97\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xD9"],
        ["\xE6\x97\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDA"],
        ["\xE6\x97\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDB"],
        ["\xE6\x9D\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDC"],
        ["\xE6\x98\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDD"],
        ["\xE6\x98\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDE"],
        ["\xE6\x97\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xDF"],
        ["\xE6\x9D\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE0"],
        ["\xE6\x98\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE1"],
        ["\xE6\x98\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE2"],
        ["\xE6\x98\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE3"],
        ["\xE6\x98\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE4"],
        ["\xE6\x99\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE5"],
        ["\xE6\x99\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE6"],
        ["\xE6\x99\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE7"],
        ["\xE6\x99\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE8"],
        ["\xE6\x99\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xE9"],
        ["\xE6\x99\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEA"],
        ["\xE6\x99\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEB"],
        ["\xE6\x99\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEC"],
        ["\xE6\x99\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xED"],
        ["\xE6\x99\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEE"],
        ["\xE6\x99\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xEF"],
        ["\xE6\x99\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF0"],
        ["\xE6\x9A\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF1"],
        ["\xE6\x9A\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF2"],
        ["\xE6\x9A\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF3"],
        ["\xE6\x9A\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF4"],
        ["\xE6\x9A\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF5"],
        ["\xE6\x9A\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF6"],
        ["\xE6\x9A\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF7"],
        ["\xE6\x9B\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF8"],
        ["\xE6\x9A\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xF9"],
        ["\xE6\x9B\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xFA"],
        ["\xE6\x9A\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xFB"],
        ["\xE6\x9A\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9D\xFC"],
        ["\xE6\x9B\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x40"],
        ["\xE6\x9A\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x41"],
        ["\xE6\x9B\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x42"],
        ["\xE6\x9B\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x43"],
        ["\xE6\x9B\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x44"],
        ["\xE6\x98\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x45"],
        ["\xE6\x9B\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x46"],
        ["\xE6\x9B\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x47"],
        ["\xE6\x9B\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x48"],
        ["\xE6\x9B\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x49"],
        ["\xE6\x9B\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4A"],
        ["\xE6\x9C\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4B"],
        ["\xE6\x9C\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4C"],
        ["\xE6\x9C\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4D"],
        ["\xE6\x9C\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4E"],
        ["\xE6\x9C\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x4F"],
        ["\xE9\x9C\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x50"],
        ["\xE6\x9C\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x51"],
        ["\xE6\x9C\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x52"],
        ["\xE6\x9C\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x53"],
        ["\xE6\x9D\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x54"],
        ["\xE6\x9C\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x55"],
        ["\xE6\x9C\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x56"],
        ["\xE6\x9D\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x57"],
        ["\xE6\x9D\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x58"],
        ["\xE6\x9D\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x59"],
        ["\xE6\x9D\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5A"],
        ["\xE6\x9D\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5B"],
        ["\xE6\x9D\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5C"],
        ["\xE6\x9E\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5D"],
        ["\xE6\x9D\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5E"],
        ["\xE6\x9E\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x5F"],
        ["\xE6\x9D\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x60"],
        ["\xE6\x9D\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x61"],
        ["\xE6\x9E\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x62"],
        ["\xE6\x9E\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x63"],
        ["\xE6\x9E\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x64"],
        ["\xE6\x9E\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x65"],
        ["\xE6\x9E\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x66"],
        ["\xE6\x9E\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x67"],
        ["\xE6\x9F\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x68"],
        ["\xE6\x9E\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x69"],
        ["\xE6\x9F\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6A"],
        ["\xE6\x9E\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6B"],
        ["\xE6\x9F\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6C"],
        ["\xE6\x9E\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6D"],
        ["\xE6\x9F\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6E"],
        ["\xE6\x9F\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x6F"],
        ["\xE6\x9F\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x70"],
        ["\xE6\x9F\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x71"],
        ["\xE6\x9F\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x72"],
        ["\xE6\x9E\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x73"],
        ["\xE6\x9F\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x74"],
        ["\xE6\x9F\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x75"],
        ["\xE6\x9F\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x76"],
        ["\xE6\xAA\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x77"],
        ["\xE6\xA0\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x78"],
        ["\xE6\xA1\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x79"],
        ["\xE6\xA0\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7A"],
        ["\xE6\xA1\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7B"],
        ["\xE6\xA1\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7C"],
        ["\xE6\xA0\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7D"],
        ["\xE6\xA1\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x7E"],
        ["\xE6\xA2\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x80"],
        ["\xE6\xA0\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x81"],
        ["\xE6\xA1\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x82"],
        ["\xE6\xA1\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x83"],
        ["\xE6\xA1\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x84"],
        ["\xE6\xA1\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x85"],
        ["\xE6\xA2\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x86"],
        ["\xE6\xA2\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x87"],
        ["\xE6\xA2\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x88"],
        ["\xE6\xA2\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x89"],
        ["\xE6\xA2\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8A"],
        ["\xE6\xA2\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8B"],
        ["\xE6\xA2\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8C"],
        ["\xE6\xAA\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8D"],
        ["\xE6\xA2\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8E"],
        ["\xE6\xA1\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x8F"],
        ["\xE6\xA2\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x90"],
        ["\xE6\xA2\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x91"],
        ["\xE6\xA2\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x92"],
        ["\xE6\xA4\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x93"],
        ["\xE6\xA2\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x94"],
        ["\xE6\xA1\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x95"],
        ["\xE6\xA4\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x96"],
        ["\xE6\xA3\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x97"],
        ["\xE6\xA4\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x98"],
        ["\xE6\xA3\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x99"],
        ["\xE6\xA4\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9A"],
        ["\xE6\xA4\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9B"],
        ["\xE6\xA3\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9C"],
        ["\xE6\xA4\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9D"],
        ["\xE6\xA3\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9E"],
        ["\xE6\xA3\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\x9F"],
        ["\xE6\xA3\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA0"],
        ["\xE6\xA3\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA1"],
        ["\xE6\xA4\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA2"],
        ["\xE6\xA4\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA3"],
        ["\xE6\xA4\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA4"],
        ["\xE6\xA3\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA5"],
        ["\xE6\xA3\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA6"],
        ["\xE6\xA4\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA7"],
        ["\xE6\xA3\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA8"],
        ["\xE6\xA3\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xA9"],
        ["\xE6\xA3\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAA"],
        ["\xE6\xA4\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAB"],
        ["\xE6\xA4\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAC"],
        ["\xE6\xA4\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAD"],
        ["\xE6\xA4\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAE"],
        ["\xE6\xA4\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xAF"],
        ["\xE6\xA3\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB0"],
        ["\xE6\xA5\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB1"],
        ["\xE6\xA5\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB2"],
        ["\xE6\xA5\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB3"],
        ["\xE6\xA5\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB4"],
        ["\xE6\xA5\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB5"],
        ["\xE6\xA5\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB6"],
        ["\xE6\xA5\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB7"],
        ["\xE6\xA5\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB8"],
        ["\xE6\xA4\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xB9"],
        ["\xE6\xA5\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBA"],
        ["\xE6\xA4\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBB"],
        ["\xE6\xA5\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBC"],
        ["\xE6\xA4\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBD"],
        ["\xE6\xA5\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBE"],
        ["\xE6\xA5\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xBF"],
        ["\xE6\xA5\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC0"],
        ["\xE6\xA6\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC1"],
        ["\xE6\xA5\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC2"],
        ["\xE6\xA6\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC3"],
        ["\xE6\xA6\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC4"],
        ["\xE6\xA7\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC5"],
        ["\xE6\xA6\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC6"],
        ["\xE6\xA7\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC7"],
        ["\xE6\xA7\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC8"],
        ["\xE6\xA6\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xC9"],
        ["\xE6\xA7\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCA"],
        ["\xE5\xAF\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCB"],
        ["\xE6\xA7\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCC"],
        ["\xE6\xA7\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCD"],
        ["\xE6\xA6\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCE"],
        ["\xE6\xA7\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xCF"],
        ["\xE6\xA6\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD0"],
        ["\xE6\xA8\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD1"],
        ["\xE6\xA6\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD2"],
        ["\xE6\xA6\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD3"],
        ["\xE6\xA6\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD4"],
        ["\xE6\xA6\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD5"],
        ["\xE6\xA6\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD6"],
        ["\xE6\xA7\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD7"],
        ["\xE6\xA7\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD8"],
        ["\xE6\xA8\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xD9"],
        ["\xE6\xA8\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDA"],
        ["\xE6\xA7\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDB"],
        ["\xE6\xAC\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDC"],
        ["\xE6\xA7\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDD"],
        ["\xE6\xA7\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDE"],
        ["\xE6\xA7\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xDF"],
        ["\xE6\xA8\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE0"],
        ["\xE6\xA6\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE1"],
        ["\xE6\xA8\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE2"],
        ["\xE6\xA7\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE3"],
        ["\xE6\xA8\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE4"],
        ["\xE6\xA7\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE5"],
        ["\xE6\xA8\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE6"],
        ["\xE6\xA8\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE7"],
        ["\xE6\xAB\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE8"],
        ["\xE6\xA8\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xE9"],
        ["\xE6\xA8\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEA"],
        ["\xE6\xA9\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEB"],
        ["\xE6\xA8\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEC"],
        ["\xE6\xA9\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xED"],
        ["\xE6\xA8\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEE"],
        ["\xE6\xA9\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xEF"],
        ["\xE6\xA9\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF0"],
        ["\xE6\xA9\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF1"],
        ["\xE6\xA9\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF2"],
        ["\xE6\xA9\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF3"],
        ["\xE6\xA9\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF4"],
        ["\xE6\xA8\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF5"],
        ["\xE6\xA8\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF6"],
        ["\xE6\xAA\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF7"],
        ["\xE6\xAA\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF8"],
        ["\xE6\xAA\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xF9"],
        ["\xE6\xAA\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xFA"],
        ["\xE6\xAA\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xFB"],
        ["\xE6\xAA\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9E\xFC"],
        ["\xE6\xAA\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x40"],
        ["\xE8\x98\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x41"],
        ["\xE6\xAA\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x42"],
        ["\xE6\xAB\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x43"],
        ["\xE6\xAB\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x44"],
        ["\xE6\xAA\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x45"],
        ["\xE6\xAA\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x46"],
        ["\xE6\xAA\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x47"],
        ["\xE6\xAB\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x48"],
        ["\xE6\xAB\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x49"],
        ["\xE6\xAB\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4A"],
        ["\xE6\xAA\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4B"],
        ["\xE6\xAB\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4C"],
        ["\xE6\xAB\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4D"],
        ["\xE6\xAB\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4E"],
        ["\xE6\xAC\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x4F"],
        ["\xE8\x98\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x50"],
        ["\xE6\xAB\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x51"],
        ["\xE6\xAC\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x52"],
        ["\xE6\xAC\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x53"],
        ["\xE9\xAC\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x54"],
        ["\xE6\xAC\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x55"],
        ["\xE6\xAC\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x56"],
        ["\xE6\xAC\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x57"],
        ["\xE7\x9B\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x58"],
        ["\xE6\xAC\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x59"],
        ["\xE9\xA3\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5A"],
        ["\xE6\xAD\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5B"],
        ["\xE6\xAD\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5C"],
        ["\xE6\xAD\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5D"],
        ["\xE6\xAD\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5E"],
        ["\xE6\xAD\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x5F"],
        ["\xE6\xAD\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x60"],
        ["\xE6\xAD\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x61"],
        ["\xE6\xAD\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x62"],
        ["\xE6\xAD\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x63"],
        ["\xE6\xAD\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x64"],
        ["\xE6\xAD\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x65"],
        ["\xE6\xAD\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x66"],
        ["\xE6\xAE\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x67"],
        ["\xE6\xAE\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x68"],
        ["\xE6\xAE\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x69"],
        ["\xE6\xAE\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6A"],
        ["\xE6\xAE\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6B"],
        ["\xE6\xAE\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6C"],
        ["\xE6\xAE\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6D"],
        ["\xE6\xAE\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6E"],
        ["\xE6\xAE\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x6F"],
        ["\xE6\xAE\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x70"],
        ["\xE6\xAE\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x71"],
        ["\xE6\xAE\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x72"],
        ["\xE6\xAE\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x73"],
        ["\xE6\xAE\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x74"],
        ["\xE6\xAE\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x75"],
        ["\xE6\xAE\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x76"],
        ["\xE6\xAF\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x77"],
        ["\xE6\xAF\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x78"],
        ["\xE6\xAF\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x79"],
        ["\xE6\xAF\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7A"],
        ["\xE6\xAF\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7B"],
        ["\xE6\xAF\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7C"],
        ["\xE6\xAF\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7D"],
        ["\xE6\xAF\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x7E"],
        ["\xE9\xBA\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x80"],
        ["\xE6\xB0\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x81"],
        ["\xE6\xB0\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x82"],
        ["\xE6\xB0\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x83"],
        ["\xE6\xB0\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x84"],
        ["\xE6\xB0\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x85"],
        ["\xE6\xB0\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x86"],
        ["\xE6\xB1\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x87"],
        ["\xE6\xB1\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x88"],
        ["\xE6\xB1\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x89"],
        ["\xE6\xB1\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8A"],
        ["\xE6\xB2\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8B"],
        ["\xE6\xB2\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8C"],
        ["\xE6\xB2\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8D"],
        ["\xE6\xB2\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8E"],
        ["\xE6\xB2\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x8F"],
        ["\xE6\xB1\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x90"],
        ["\xE6\xB1\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x91"],
        ["\xE6\xB1\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x92"],
        ["\xE6\xB2\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x93"],
        ["\xE6\xB2\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x94"],
        ["\xE6\xB3\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x95"],
        ["\xE6\xB3\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x96"],
        ["\xE6\xB3\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x97"],
        ["\xE6\xB2\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x98"],
        ["\xE6\xB3\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x99"],
        ["\xE6\xB3\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9A"],
        ["\xE6\xB3\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9B"],
        ["\xE6\xB2\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9C"],
        ["\xE6\xB2\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],
        ["\xE6\xB2\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9E"],
        ["\xE6\xB2\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\x9F"],
        ["\xE6\xB3\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA0"],
        ["\xE6\xB3\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\xE6\xB3\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\xE6\xB3\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\xE6\xB4\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA4"],
        ["\xE8\xA1\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA5"],
        ["\xE6\xB4\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\xE6\xB4\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\xE6\xB4\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA8"],
        ["\xE6\xB4\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\xE6\xB4\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\xE6\xB4\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\xE6\xB4\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\xE6\xB4\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAD"],
        ["\xE6\xB4\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\xE6\xB5\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\xE6\xB6\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB0"],
        ["\xE6\xB5\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB1"],
        ["\xE6\xB5\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB2"],
        ["\xE6\xB5\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB3"],
        ["\xE6\xB5\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\xE6\xB6\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\xE6\xB6\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\xE6\xBF\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\xE6\xB6\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB8"],
        ["\xE6\xB7\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\xE6\xB8\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\xE6\xB8\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBB"],
        ["\xE6\xB6\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\xE6\xB7\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBD"],
        ["\xE6\xB7\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBE"],
        ["\xE6\xB6\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xBF"],
        ["\xE6\xB7\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\xE6\xB7\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\xE6\xB7\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\xE6\xB7\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC3"],
        ["\xE6\xB7\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\xE6\xB7\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC5"],
        ["\xE6\xB7\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\xE6\xB7\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC7"],
        ["\xE6\xB7\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\xE6\xB7\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xC9"],
        ["\xE6\xB7\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\xE6\xB7\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\xE6\xB7\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\xE6\xB8\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\xE6\xB9\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\xE6\xB8\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\xE6\xB8\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD0"],
        ["\xE6\xB9\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\xE6\xB9\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\xE6\xB8\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\xE6\xB8\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\xE6\xB9\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\xE6\xB8\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\xE6\xB9\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\xE6\xB9\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\xE6\xB8\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xD9"],
        ["\xE6\xB9\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDA"],
        ["\xE6\xB8\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDB"],
        ["\xE6\xB9\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDC"],
        ["\xE6\xB8\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDD"],
        ["\xE6\xBB\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDE"],
        ["\xE6\xB8\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xDF"],
        ["\xE6\xB8\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE0"],
        ["\xE6\xBA\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE1"],
        ["\xE6\xBA\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE2"],
        ["\xE6\xBA\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE3"],
        ["\xE6\xBB\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE4"],
        ["\xE6\xBA\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE5"],
        ["\xE6\xBB\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE6"],
        ["\xE6\xBA\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE7"],
        ["\xE6\xBA\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE8"],
        ["\xE6\xBB\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xE9"],
        ["\xE6\xBA\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEA"],
        ["\xE6\xBB\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEB"],
        ["\xE6\xBB\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEC"],
        ["\xE6\xBA\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xED"],
        ["\xE6\xBA\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEE"],
        ["\xE6\xBB\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xEF"],
        ["\xE6\xBA\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF0"],
        ["\xE6\xBD\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF1"],
        ["\xE6\xBC\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF2"],
        ["\xE7\x81\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF3"],
        ["\xE6\xBB\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF4"],
        ["\xE6\xBB\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF5"],
        ["\xE6\xBB\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF6"],
        ["\xE6\xBC\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF7"],
        ["\xE6\xBB\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF8"],
        ["\xE6\xBC\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xF9"],
        ["\xE6\xBB\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xFA"],
        ["\xE6\xBC\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xFB"],
        ["\xE6\xBB\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9F\xFC"],
        ["\xE6\xBC\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x40"],
        ["\xE6\xBC\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\xE6\xBB\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x42"],
        ["\xE6\xBE\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x43"],
        ["\xE6\xBD\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x44"],
        ["\xE6\xBD\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x45"],
        ["\xE6\xBE\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x46"],
        ["\xE6\xBE\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x47"],
        ["\xE6\xBD\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x48"],
        ["\xE6\xBD\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x49"],
        ["\xE6\xBF\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\xE6\xBD\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\xE6\xBE\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\xE6\xBD\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\xE6\xBD\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\xE6\xBE\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\xE6\xBE\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\xE6\xBF\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x51"],
        ["\xE6\xBD\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x52"],
        ["\xE6\xBE\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x53"],
        ["\xE6\xBE\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x54"],
        ["\xE6\xBE\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x55"],
        ["\xE6\xBE\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x56"],
        ["\xE6\xBE\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\xE6\xBF\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\xE6\xBE\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xE6\xBF\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\xE6\xBF\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\xE6\xBF\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\xE6\xBF\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\xE6\xBF\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\xE6\xBF\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\xE6\xBF\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\xE6\xBF\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\xE7\x80\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\xE7\x80\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xE6\xBF\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\xE7\x80\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\xE7\x80\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\xE7\x80\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\xE6\xBF\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xE7\x80\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xE7\x80\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6A"],
        ["\xE6\xBD\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\xE7\x80\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\xE7\x80\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\xE7\x80\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xE7\x80\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\xE7\x80\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\xE7\x80\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\xE7\x81\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\xE7\x81\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\xE7\x82\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xE7\x82\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xE7\x82\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xE7\x83\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\xE7\x82\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xE7\x82\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xE7\x82\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\xE7\x82\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\xE7\x83\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\xE7\x83\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\xE7\x83\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\xE7\x83\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x80"],
        ["\xE7\x84\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x81"],
        ["\xE7\x83\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x82"],
        ["\xE7\x84\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\xE7\x84\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\xE7\x85\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\xE7\x85\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x86"],
        ["\xE7\x86\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x87"],
        ["\xE7\x85\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x88"],
        ["\xE7\x85\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x89"],
        ["\xE7\x85\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8A"],
        ["\xE7\x85\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8B"],
        ["\xE7\x85\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8C"],
        ["\xE7\x86\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8D"],
        ["\xE7\x87\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8E"],
        ["\xE7\x86\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x8F"],
        ["\xE7\x86\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x90"],
        ["\xE7\x86\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x91"],
        ["\xE7\x86\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x92"],
        ["\xE7\x87\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x93"],
        ["\xE7\x86\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x94"],
        ["\xE7\x86\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x95"],
        ["\xE7\x87\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x96"],
        ["\xE7\x87\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x97"],
        ["\xE7\x87\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x98"],
        ["\xE7\x87\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x99"],
        ["\xE7\x87\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9A"],
        ["\xE7\x87\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9B"],
        ["\xE7\x87\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9C"],
        ["\xE7\x87\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9D"],
        ["\xE7\x87\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9E"],
        ["\xE7\x87\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\x9F"],
        ["\xE7\x87\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA0"],
        ["\xE7\x88\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE7\x88\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE7\x88\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE7\x88\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE7\x88\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE7\x88\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE7\x88\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE7\x88\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE7\x88\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE7\x88\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE7\x88\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE7\x89\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE7\x89\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE7\x89\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE7\x89\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE7\x89\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE7\x89\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE7\x8A\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE7\x8A\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE7\x8A\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE7\x8A\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE7\x8A\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE7\x8A\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE7\x8A\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE7\x8A\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE7\x8A\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE7\x8B\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE7\x8B\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE7\x8B\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE7\x8B\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE7\x8B\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE7\x8B\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE7\x8B\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE7\x8B\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE7\x8B\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE7\x8B\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE5\x80\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE7\x8C\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE7\x8C\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE7\x8C\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE7\x8C\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE7\x8C\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE7\x8C\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE7\x8C\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE7\x8C\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE7\x8C\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE7\x8C\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE7\x8D\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE7\x8D\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE9\xBB\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE7\x8D\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE7\x8D\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE7\x8D\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE7\x8D\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE7\x8D\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE7\x8D\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE7\x8D\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE7\x8D\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE7\x8F\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE7\x8E\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE7\x8F\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE7\x8E\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE7\x8F\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE7\x8F\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE7\x8F\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE7\x8F\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE7\x92\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE7\x90\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE7\x91\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE7\x90\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE7\x8F\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE7\x90\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE7\x90\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE7\x91\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE7\x90\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE7\x91\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE7\x91\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE7\x91\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE7\x91\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE7\x91\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE7\x91\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE7\x91\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE7\x91\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE7\x91\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE7\x91\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE7\x92\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE7\x92\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE7\x92\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE7\x93\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE7\x93\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE7\x93\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE7\x8F\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE7\x93\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x40"],
        ["\xE7\x93\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\xE7\x93\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\xE7\x93\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\xE7\x93\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\xE7\x93\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\xE7\x93\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\xE7\x93\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x47"],
        ["\xE7\x93\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x48"],
        ["\xE7\x93\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x49"],
        ["\xE7\x94\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4A"],
        ["\xE7\x94\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4B"],
        ["\xE7\x94\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4C"],
        ["\xE7\x94\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4D"],
        ["\xE7\x94\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4E"],
        ["\xE7\x94\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x4F"],
        ["\xE7\x94\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x50"],
        ["\xE7\x94\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x51"],
        ["\xE7\x94\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x52"],
        ["\xE7\x94\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x53"],
        ["\xE7\x94\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x54"],
        ["\xE7\x94\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x55"],
        ["\xE7\x95\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x56"],
        ["\xE7\x95\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x57"],
        ["\xE7\x95\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x58"],
        ["\xE7\x95\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x59"],
        ["\xE7\x95\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5A"],
        ["\xE7\x95\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5B"],
        ["\xE7\x95\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5C"],
        ["\xE7\x95\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5D"],
        ["\xE7\x95\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5E"],
        ["\xE7\x95\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x5F"],
        ["\xE7\x95\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x60"],
        ["\xE7\x95\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x61"],
        ["\xE7\x95\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x62"],
        ["\xE7\x95\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x63"],
        ["\xE7\x96\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x64"],
        ["\xE7\x96\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x65"],
        ["\xE7\x95\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x66"],
        ["\xE7\x96\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x67"],
        ["\xE7\x96\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x68"],
        ["\xE7\x96\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x69"],
        ["\xE7\x96\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6A"],
        ["\xE7\x96\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6B"],
        ["\xE7\x96\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6C"],
        ["\xE7\x96\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6D"],
        ["\xE7\x96\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6E"],
        ["\xE7\x97\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x6F"],
        ["\xE7\x96\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x70"],
        ["\xE7\x97\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x71"],
        ["\xE7\x96\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x72"],
        ["\xE7\x96\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x73"],
        ["\xE7\x96\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x74"],
        ["\xE7\x96\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x75"],
        ["\xE7\x96\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x76"],
        ["\xE7\x97\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x77"],
        ["\xE7\x97\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x78"],
        ["\xE7\x97\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x79"],
        ["\xE7\x97\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7A"],
        ["\xE7\x97\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7B"],
        ["\xE7\x97\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7C"],
        ["\xE7\x97\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7D"],
        ["\xE7\x97\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x7E"],
        ["\xE7\x97\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x80"],
        ["\xE7\x98\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x81"],
        ["\xE7\x97\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x82"],
        ["\xE7\x97\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x83"],
        ["\xE7\x97\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x84"],
        ["\xE7\x97\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x85"],
        ["\xE7\x98\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x86"],
        ["\xE7\x98\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x87"],
        ["\xE7\x98\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x88"],
        ["\xE7\x98\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x89"],
        ["\xE7\x98\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8A"],
        ["\xE7\x98\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8B"],
        ["\xE7\x98\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8C"],
        ["\xE7\x98\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8D"],
        ["\xE7\x98\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8E"],
        ["\xE7\x98\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x8F"],
        ["\xE7\x98\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x90"],
        ["\xE7\x98\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x91"],
        ["\xE7\x99\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x92"],
        ["\xE7\x99\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x93"],
        ["\xE7\x99\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x94"],
        ["\xE7\x99\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x95"],
        ["\xE7\x99\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x96"],
        ["\xE7\x99\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x97"],
        ["\xE7\x99\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x98"],
        ["\xE7\x99\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x99"],
        ["\xE7\x99\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9A"],
        ["\xE7\x99\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9B"],
        ["\xE7\x99\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9C"],
        ["\xE7\x99\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9D"],
        ["\xE7\x99\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9E"],
        ["\xE7\x99\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\x9F"],
        ["\xE7\x99\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA0"],
        ["\xE7\x99\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE7\x99\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE7\x9A\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE7\x9A\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE7\x9A\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE7\x9A\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE7\x9A\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE7\x9A\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE7\x9A\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE7\x9A\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE7\x9A\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE7\x9A\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE7\x9A\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE7\x9A\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE7\x9A\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE7\x9A\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE7\x9B\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE7\x9B\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE7\x9B\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE7\x9B\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE7\x9B\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE7\x9B\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE7\x9B\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE7\x9B\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE7\x9B\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE8\x98\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE7\x9B\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE7\x9C\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE7\x9C\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE7\x9C\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE7\x9C\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE7\x9C\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE7\x9C\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE7\x9C\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE7\x9C\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE7\x9C\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE7\x9C\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE7\x9C\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE7\x9D\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE7\x9D\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE7\x9D\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE7\x9D\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE7\x9D\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE7\x9D\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE7\x9D\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE7\x9D\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE7\x9D\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE7\x9E\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE7\x9E\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE7\x9E\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE7\x9E\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE7\x9E\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE7\x9E\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE7\x9E\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE7\x9E\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE7\x9E\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE7\x9E\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE7\x9E\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE7\x9E\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE7\x9F\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE7\x9F\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE7\x9F\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE7\x9F\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE7\x9F\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE7\x9F\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE7\x9F\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE7\x9F\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE7\xA0\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE7\xA0\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xE7\xA4\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE7\xA0\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xE7\xA4\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE7\xA1\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE7\xA2\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE7\xA1\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE7\xA2\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE7\xA1\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE7\xA2\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE7\xA2\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE7\xA2\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE7\xA2\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE7\xA2\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE7\xA2\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE7\xA3\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE7\xA3\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE7\xA3\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE7\xA3\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE7\xA2\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE7\xA2\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE7\xA3\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE7\xA3\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE7\xA3\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE7\xA3\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x40"],
        ["\xE7\xA3\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x41"],
        ["\xE7\xA3\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x42"],
        ["\xE7\xA3\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x43"],
        ["\xE7\xA4\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x44"],
        ["\xE7\xA4\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x45"],
        ["\xE7\xA4\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x46"],
        ["\xE7\xA4\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x47"],
        ["\xE7\xA4\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x48"],
        ["\xE7\xA4\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x49"],
        ["\xE7\xA5\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xE7\xA5\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xE7\xA5\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xE7\xA5\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\xE7\xA5\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\xE7\xA5\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\xE7\xA5\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\xE7\xA5\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x51"],
        ["\xE7\xA5\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x52"],
        ["\xE7\xA6\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x53"],
        ["\xE7\xA6\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x54"],
        ["\xE7\xA6\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x55"],
        ["\xE9\xBD\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x56"],
        ["\xE7\xA6\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\xE7\xA6\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x58"],
        ["\xE7\xA6\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\xE7\xA6\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\xE7\xA6\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xE7\xA7\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\xE7\xA7\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\xE7\xA7\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\xE7\xA7\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\xE7\xA7\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\xE7\xA7\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\xE7\xA8\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\xE7\xA8\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\xE7\xA8\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\xE7\xA8\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\xE7\xA8\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\xE7\xA8\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\xE7\xA6\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\xE7\xA8\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\xE7\xA8\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\xE7\xA8\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\xE7\xA8\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\xE7\xA9\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\xE7\xA9\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\xE7\xA9\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xE7\xA9\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE7\xA9\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE7\xA9\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE9\xBE\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE7\xA9\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE7\xA9\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE7\xA9\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE7\xAA\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE7\xAA\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE7\xAA\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE7\xAA\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE7\xAA\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE7\xAA\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xE7\xAB\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE7\xAA\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE7\xAA\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE7\xAB\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xE7\xAB\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xE7\xAA\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xE9\x82\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x84"],
        ["\xE7\xAB\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x85"],
        ["\xE7\xAB\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x86"],
        ["\xE7\xAB\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x87"],
        ["\xE7\xAB\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x88"],
        ["\xE7\xAB\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x89"],
        ["\xE7\xAB\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A"],
        ["\xE7\xAB\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\xE7\xAB\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C"],
        ["\xE7\xAB\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8D"],
        ["\xE7\xAB\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E"],
        ["\xE7\xAB\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F"],
        ["\xE7\xAB\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x90"],
        ["\xE7\xAB\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x91"],
        ["\xE7\xAB\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x92"],
        ["\xE7\xAC\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x93"],
        ["\xE7\xAC\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x94"],
        ["\xE7\xAC\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x95"],
        ["\xE7\xAC\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x96"],
        ["\xE7\xAC\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x97"],
        ["\xE7\xAC\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x98"],
        ["\xE7\xAC\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x99"],
        ["\xE7\xAC\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9A"],
        ["\xE7\xAC\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\xE7\xAC\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\xE7\xAC\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D"],
        ["\xE7\xAD\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9E"],
        ["\xE7\xAD\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\x9F"],
        ["\xE7\xAC\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\xE7\xAD\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE7\xAC\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE7\xAD\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE7\xAD\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE7\xAD\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE7\xAD\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE7\xAD\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE7\xAD\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE7\xAD\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE7\xAD\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE7\xAD\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE7\xAD\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE7\xAE\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE7\xAE\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE7\xAE\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE7\xAE\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE7\xAE\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE7\xAE\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE7\xAE\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE7\xAE\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE7\xAE\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE7\xAD\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE7\xAE\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE7\xAF\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE7\xAF\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE7\xAF\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE7\xAF\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE7\xAE\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE7\xAF\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE7\xAF\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE7\xAF\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE7\xB0\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE7\xB0\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE7\xAF\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE7\xAF\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE7\xB1\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE7\xB0\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE7\xB0\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE7\xB0\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE7\xAF\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE7\xAF\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE7\xB0\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE7\xB0\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE7\xAF\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE7\xB0\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE7\xB0\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE7\xB0\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE7\xB0\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE7\xB0\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE7\xB0\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE7\xB0\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE7\xB1\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE7\xB1\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE7\xB1\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE7\xB1\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE7\xB1\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE7\xB1\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE7\xB1\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE7\xB1\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE7\xB1\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE7\xB1\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE7\xB1\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE7\xB1\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE7\xB1\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE7\xB2\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE7\xB2\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE7\xB2\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE7\xB2\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE7\xB2\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE7\xB2\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE7\xB2\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE7\xB2\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE7\xB2\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE7\xB2\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE7\xB2\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE7\xB2\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE7\xB2\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE7\xB2\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE7\xB3\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE7\xB3\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE7\xB3\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE7\xB3\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE7\xB3\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE7\xB3\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE7\xB3\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE9\xAC\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE7\xB3\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE7\xB3\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE7\xB3\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE7\xB3\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE7\xB3\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE7\xB4\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE7\xB4\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x40"],
        ["\xE7\xB4\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\xE7\xB4\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\xE7\xB4\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\xE7\xB5\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\xE7\xB5\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\xE7\xB4\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\xE7\xB4\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\xE7\xB4\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\xE7\xB4\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\xE7\xB5\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xE7\xB5\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xE7\xB5\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xE7\xB5\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xE7\xB5\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xE7\xB5\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xE7\xB5\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xE7\xB5\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x51"],
        ["\xE7\xB5\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x52"],
        ["\xE7\xB6\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x53"],
        ["\xE7\xB6\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x54"],
        ["\xE7\xB5\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x55"],
        ["\xE7\xB6\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x56"],
        ["\xE7\xB5\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\xE7\xB6\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x58"],
        ["\xE7\xB6\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\xE7\xB6\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xE7\xB6\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\xE7\xB6\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\xE7\xB7\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\xE7\xB6\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\xE7\xB6\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xE7\xB8\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xE7\xB6\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xE7\xB6\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\xE7\xB7\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xE7\xB6\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\xE7\xB6\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\xE7\xB6\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\xE7\xB7\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\xE7\xB7\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xE7\xB7\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xE7\xB7\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\xE7\xB7\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\xE7\xB7\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\xE7\xB7\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\xE7\xB8\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\xE7\xB8\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\xE7\xB8\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\xE7\xB8\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xE7\xB8\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xE7\xB8\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\xE7\xB8\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\xE7\xB8\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\xE7\xB8\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\xE7\xB8\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\xE7\xB9\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xE7\xB9\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xE7\xB8\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\xE7\xB8\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\xE7\xB8\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\xE7\xB9\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\xE7\xB8\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\xE7\xB8\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\xE7\xB8\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x81"],
        ["\xE7\xB9\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x82"],
        ["\xE7\xB9\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x83"],
        ["\xE7\xB9\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x84"],
        ["\xE7\xB9\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x85"],
        ["\xE7\xB9\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x86"],
        ["\xE7\xB9\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x87"],
        ["\xE7\xB9\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x88"],
        ["\xE7\xB9\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x89"],
        ["\xE7\xB9\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A"],
        ["\xE7\xB9\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\xE7\xB9\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C"],
        ["\xE7\xBA\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D"],
        ["\xE7\xB7\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E"],
        ["\xE7\xB9\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F"],
        ["\xE8\xBE\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x90"],
        ["\xE7\xB9\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x91"],
        ["\xE7\xBA\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x92"],
        ["\xE7\xBA\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x93"],
        ["\xE7\xBA\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x94"],
        ["\xE7\xBA\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x95"],
        ["\xE7\xBA\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x96"],
        ["\xE7\xBA\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x97"],
        ["\xE7\xBA\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x98"],
        ["\xE7\xBA\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x99"],
        ["\xE7\xBA\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A"],
        ["\xE7\xBA\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\xE7\xBA\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\xE7\xBC\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D"],
        ["\xE7\xBC\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E"],
        ["\xE7\xBD\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F"],
        ["\xE7\xBD\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\xE7\xBD\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE7\xBD\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE7\xBD\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE7\xBD\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE7\xBD\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE7\xBD\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE7\xBD\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE7\xBD\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE7\xBD\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE7\xBD\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE7\xBD\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE7\xBD\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE7\xBD\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE7\xBE\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE7\xBE\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE7\xBE\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE7\xBE\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE7\xBE\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE7\xBE\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE7\xBE\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE7\xBE\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE7\xBE\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE7\xBE\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE7\xBE\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE7\xBE\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE7\xBE\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE7\xBE\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE7\xBE\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE7\xBE\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE7\xBE\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE8\xAD\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE7\xBF\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE7\xBF\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE7\xBF\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE7\xBF\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE7\xBF\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE7\xBF\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE7\xBF\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE7\xBF\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE7\xBF\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE7\xBF\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE9\xA3\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE8\x80\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE8\x80\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE8\x80\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE8\x80\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE8\x80\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE8\x80\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE8\x80\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE8\x80\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE8\x80\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE8\x80\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE8\x80\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE8\x81\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE8\x81\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE8\x81\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE8\x81\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE8\x81\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE8\x81\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE8\x81\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE8\x81\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE8\x81\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE8\x81\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE8\x81\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE8\x81\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE8\x81\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE8\x81\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE8\x81\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE8\x82\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE8\x82\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE8\x82\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE8\x82\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE8\x82\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE8\x82\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE8\x82\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE5\x86\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE8\x82\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE8\x83\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE8\x83\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE8\x83\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE8\x83\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE8\x83\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE8\x83\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE8\x83\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE8\x84\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE8\x83\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE8\x83\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE8\x84\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE8\x84\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE8\x84\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE8\x84\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE8\x85\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE9\x9A\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x40"],
        ["\xE8\x85\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x41"],
        ["\xE8\x84\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x42"],
        ["\xE8\x85\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x43"],
        ["\xE8\x85\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x44"],
        ["\xE8\x83\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x45"],
        ["\xE8\x85\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x46"],
        ["\xE8\x85\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x47"],
        ["\xE8\x85\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x48"],
        ["\xE8\x85\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x49"],
        ["\xE8\x85\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\xE8\x86\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xE8\x86\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\xE8\x86\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\xE8\x86\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\xE8\x86\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xE8\x86\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xE8\x86\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x51"],
        ["\xE8\x86\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x52"],
        ["\xE8\x86\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x53"],
        ["\xE8\x85\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x54"],
        ["\xE8\x86\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x55"],
        ["\xE8\x86\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x56"],
        ["\xE8\x86\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\xE8\x86\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x58"],
        ["\xE8\x86\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\xE8\x86\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\xE8\x86\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xE8\x87\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xE8\x87\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xE8\x86\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xE8\x87\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\xE8\x87\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xE8\x87\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\xE8\x87\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\xE8\x87\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\xE8\x87\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\xE8\x87\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\xE8\x87\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\xE8\x87\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\xE8\x87\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xE8\x87\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xE8\x87\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xE8\x87\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xE8\x88\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\xE8\x88\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\xE8\x88\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\xE8\x88\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xE8\x88\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\xE8\x88\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\xE8\x88\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\xE8\x88\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xE8\x88\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xE8\x88\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\xE8\x88\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\xE8\x88\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\xE8\x89\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\xE8\x89\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\xE8\x89\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xE8\x89\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\xE8\x89\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\xE8\x89\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\xE8\x89\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xE8\x89\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\xE8\x89\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x81"],
        ["\xE8\x89\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x82"],
        ["\xE8\x89\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x83"],
        ["\xE8\x88\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x84"],
        ["\xE8\x89\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x85"],
        ["\xE8\x89\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x86"],
        ["\xE8\x89\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x87"],
        ["\xE8\x89\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x88"],
        ["\xE8\x8A\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x89"],
        ["\xE8\x8A\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8A"],
        ["\xE8\x8A\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\xE8\x8A\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C"],
        ["\xE8\x8A\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D"],
        ["\xE8\x8A\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8E"],
        ["\xE8\x8B\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F"],
        ["\xE8\x8B\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x90"],
        ["\xE8\x8B\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x91"],
        ["\xE8\x8B\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x92"],
        ["\xE8\x8B\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x93"],
        ["\xE8\x8B\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x94"],
        ["\xE8\x8B\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x95"],
        ["\xE8\x8E\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x96"],
        ["\xE8\x8C\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x97"],
        ["\xE8\x8B\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x98"],
        ["\xE8\x8B\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x99"],
        ["\xE8\x8B\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A"],
        ["\xE8\x8C\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\xE8\x8B\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\xE8\x8C\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9D"],
        ["\xE8\x8B\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9E"],
        ["\xE8\x8C\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F"],
        ["\xE8\x8C\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\xE8\x8C\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE8\x8C\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE8\x8C\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE8\x8D\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE8\x8C\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE8\x8D\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE8\x8D\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE8\x8C\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE8\x8C\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE8\x8C\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE8\x8C\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE8\x8E\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE8\x8E\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE8\x8E\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE8\x8E\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE8\x8E\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE8\x8E\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE8\x8C\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE8\x8E\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE8\x8E\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE8\x8E\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE8\x8D\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE8\x8E\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE8\x8D\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE8\x8D\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE8\x8E\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE8\x8E\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE8\x8E\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE8\x8F\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE8\x90\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE8\x8F\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE8\x8F\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE8\x8F\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE8\x90\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE8\x8F\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE8\x90\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE8\x8F\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE8\x8F\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE8\x90\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE8\x8F\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE8\x8F\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE8\x90\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE8\x90\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE8\x90\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE8\x8E\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE8\x90\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE8\x94\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE8\x8F\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE8\x91\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE8\x90\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE8\x90\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE8\x95\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE8\x92\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE8\x91\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE8\x91\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE8\x92\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE8\x91\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE8\x92\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE8\x91\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE8\x91\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE8\x90\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE8\x91\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE8\x91\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE8\x90\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE8\x93\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE8\x91\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE8\x92\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE8\x92\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE8\x92\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE8\x93\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE8\x93\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE8\x92\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE8\x93\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE8\x93\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE8\x93\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE8\x93\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE8\x93\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE8\x92\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE8\x94\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE8\x93\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE8\x93\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE8\x94\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE8\x94\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE8\x94\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE8\x94\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE8\x94\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE8\x94\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE8\x93\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE8\x95\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE8\x95\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE8\x95\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE8\x95\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE8\x95\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x40"],
        ["\xE8\x98\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x41"],
        ["\xE8\x95\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x42"],
        ["\xE8\x95\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x43"],
        ["\xE8\x96\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x44"],
        ["\xE8\x96\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x45"],
        ["\xE8\x96\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x46"],
        ["\xE8\x96\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x47"],
        ["\xE8\x96\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x48"],
        ["\xE8\x96\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x49"],
        ["\xE8\x95\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xE8\x96\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\xE8\x96\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\xE8\x97\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\xE8\x96\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\xE8\x96\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\xE8\x95\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xE8\x95\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x51"],
        ["\xE8\x96\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x52"],
        ["\xE8\x97\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x53"],
        ["\xE8\x96\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x54"],
        ["\xE8\x97\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x55"],
        ["\xE8\x96\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x56"],
        ["\xE8\x97\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\xE8\x97\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x58"],
        ["\xE8\x97\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\xE8\x97\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\xE8\x97\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\xE8\x97\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\xE8\x98\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\xE8\x98\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\xE8\x98\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\xE8\x97\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\xE8\x97\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\xE8\x98\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xE8\x98\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\xE8\x98\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xE8\x98\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\xE8\x98\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\xE8\x99\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\xE4\xB9\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\xE8\x99\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\xE8\x99\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xE8\x99\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xE8\x99\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xE8\x9A\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\xE8\x9A\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\xE8\x9A\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\xE8\x9A\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\xE8\x9A\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\xE8\x9A\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\xE8\x9A\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\xE8\x9A\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\xE8\x9B\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xE8\x9B\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\xE8\x9A\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\xE8\x9B\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\xE8\xA0\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xE8\x9A\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\xE8\x9B\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\xE8\x9B\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\xE8\x9B\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\xE8\x9B\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\xE8\x9B\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\xE8\x9B\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x81"],
        ["\xE8\x9B\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x82"],
        ["\xE8\x9C\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x83"],
        ["\xE8\x9C\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x84"],
        ["\xE8\x9C\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x85"],
        ["\xE8\x9C\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x86"],
        ["\xE8\x9C\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x87"],
        ["\xE8\x9B\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x88"],
        ["\xE8\x9C\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x89"],
        ["\xE8\x9C\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A"],
        ["\xE8\x9C\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\xE8\x9B\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C"],
        ["\xE8\x9C\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D"],
        ["\xE8\x9C\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E"],
        ["\xE8\x9C\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F"],
        ["\xE8\x9C\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x90"],
        ["\xE8\x9C\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x91"],
        ["\xE8\x9C\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x92"],
        ["\xE8\x9C\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x93"],
        ["\xE8\x9C\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x94"],
        ["\xE8\x9D\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x95"],
        ["\xE8\x9D\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x96"],
        ["\xE8\x9D\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x97"],
        ["\xE8\x9D\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x98"],
        ["\xE8\x9D\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x99"],
        ["\xE8\x9D\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A"],
        ["\xE8\x9D\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\xE8\x9D\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\xE8\x9D\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D"],
        ["\xE8\x9D\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E"],
        ["\xE8\x9D\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F"],
        ["\xE8\x9D\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\xE8\x9D\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE8\xA0\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xE8\x9E\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xE8\x9E\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xE8\x9E\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xE8\x9E\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xE8\x9F\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xE8\x9E\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xE8\x9F\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xE8\x9F\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xE9\x9B\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE8\x9E\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xE8\x9F\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xE8\x9E\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xE8\x9F\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xE8\x9F\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE8\x9E\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xE8\x9F\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE8\x9F\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xE8\x9F\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xE8\xA0\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xE8\xA0\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xE8\x9F\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xE8\x9F\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xE8\x9F\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xE8\xA0\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xE8\x9F\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xE8\xA0\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xE8\xA0\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xE8\xA0\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xE8\xA0\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xE8\xA0\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE8\xA0\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE8\xA0\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE8\xA0\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE8\xA0\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE8\xA0\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE8\xA1\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE8\xA1\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE8\xA1\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE8\xA1\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE8\xA1\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xE8\xA1\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xE8\xA1\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xE8\xA2\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xE8\xA1\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xE8\xA2\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xE8\xA1\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE8\xA1\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE8\xA2\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE8\xA1\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE8\xA2\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE8\xA2\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE8\xA2\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE8\xA2\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE8\xA2\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE8\xA2\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE8\xA2\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xE8\xA2\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xE8\xA2\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xE8\xA2\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xE8\xA2\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xE8\xA3\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xE8\xA3\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE8\xA3\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xE8\xA3\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE8\xA3\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE8\xA3\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE8\xA3\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE8\xA4\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE8\xA3\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE8\xA3\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE8\xA3\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE8\xA3\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xE8\xA4\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xE8\xA4\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xE8\xA4\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xE8\xA4\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xE8\xA5\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE8\xA4\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE8\xA4\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE8\xA4\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE8\xA4\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE8\xA5\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE8\xA5\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE8\xA4\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE8\xA4\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE8\xA4\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE8\xA5\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE8\xA4\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xE8\xA5\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xE8\xA5\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xE8\xA5\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x40"],
        ["\xE8\xA5\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\xE8\xA5\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\xE8\xA5\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\xE8\xA5\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\xE8\xA5\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\xE8\xA5\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\xE8\xA5\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\xE8\xA6\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\xE8\xA6\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\xE8\xA6\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xE8\xA6\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\xE8\xA6\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\xE8\xA6\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\xE8\xA6\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\xE8\xA6\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\xE8\xA6\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\xE8\xA6\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x51"],
        ["\xE8\xA6\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x52"],
        ["\xE8\xA6\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x53"],
        ["\xE8\xA6\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x54"],
        ["\xE8\xA6\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x55"],
        ["\xE8\xA7\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x56"],
        ["\xE8\xA7\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\xE8\xA7\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x58"],
        ["\xE8\xA7\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\xE8\xA7\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\xE8\xA7\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\xE8\xA7\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\xE8\xA8\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\xE8\xA8\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5E"],
        ["\xE8\xA8\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\xE8\xA8\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\xE8\xA8\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\xE8\xA8\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],
        ["\xE8\xA8\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\xE8\xA8\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],
        ["\xE8\xA9\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],
        ["\xE8\xA9\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],
        ["\xE8\xA9\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],
        ["\xE8\xA9\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\xE8\xA9\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],
        ["\xE8\xA9\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],
        ["\xE8\xA9\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\xE8\xA9\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],
        ["\xE8\xA9\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],
        ["\xE8\xAA\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],
        ["\xE8\xAA\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\xE8\xAA\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],
        ["\xE8\xAA\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],
        ["\xE8\xAA\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],
        ["\xE8\xAA\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],
        ["\xE8\xAA\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],
        ["\xE8\xAA\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],
        ["\xE8\xAA\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],
        ["\xE8\xAA\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],
        ["\xE8\xAB\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\xE8\xAB\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],
        ["\xE8\xAB\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\xE8\xAB\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],
        ["\xE8\xAB\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],
        ["\xE8\xAB\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],
        ["\xE8\xAB\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],
        ["\xE8\xAB\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],
        ["\xE8\xAB\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x81"],
        ["\xE8\xAC\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x82"],
        ["\xE8\xAB\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x83"],
        ["\xE8\xAB\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x84"],
        ["\xE8\xAB\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x85"],
        ["\xE8\xAB\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x86"],
        ["\xE8\xAB\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x87"],
        ["\xE8\xAC\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x88"],
        ["\xE8\xAC\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x89"],
        ["\xE8\xAC\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A"],
        ["\xE8\xAB\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],
        ["\xE8\xAC\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C"],
        ["\xE8\xAC\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D"],
        ["\xE8\xAC\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E"],
        ["\xE8\xAC\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F"],
        ["\xE8\xAC\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x90"],
        ["\xE9\x9E\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x91"],
        ["\xE8\xAC\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x92"],
        ["\xE8\xAC\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x93"],
        ["\xE8\xAC\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x94"],
        ["\xE8\xAC\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x95"],
        ["\xE8\xAD\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x96"],
        ["\xE8\xAD\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x97"],
        ["\xE8\xAD\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x98"],
        ["\xE8\xAD\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x99"],
        ["\xE8\xAD\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A"],
        ["\xE8\xAD\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],
        ["\xE8\xAD\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],
        ["\xE8\xAD\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D"],
        ["\xE8\xAD\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E"],
        ["\xE8\xAD\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F"],
        ["\xE8\xAD\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],
        ["\xE8\xAD\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xE8\xAD\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xE8\xAD\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xE8\xAE\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xE8\xAE\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xE8\xAE\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xE8\xAE\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xE8\xAE\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xE8\xAE\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xE8\xAE\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xE8\xAE\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xE8\xB0\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE8\xB1\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xE8\xB0\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE8\xB1\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xE8\xB1\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xE8\xB1\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xE8\xB1\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xE8\xB1\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xE8\xB1\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xE8\xB1\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xE8\xB1\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xE8\xB1\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xE8\xB2\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xE8\xB2\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xE8\xB2\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xE8\xB2\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xE8\xB2\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xE8\xB2\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xE8\xB2\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xE8\xB1\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xE8\xB2\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xE6\x88\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xE8\xB2\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xE8\xB2\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xE8\xB2\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xE8\xB2\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xE8\xB2\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xE8\xB2\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xE8\xB2\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xE8\xB3\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xE8\xB3\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xE8\xB3\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xE8\xB3\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xE8\xB3\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xE8\xB3\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xE8\xB3\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xE8\xB3\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE8\xB4\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE8\xB4\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE8\xB4\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xE8\xB4\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xE8\xB4\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xE8\xB4\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xE8\xB4\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xE9\xBD\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE8\xB4\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE8\xB3\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xE8\xB4\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xE8\xB4\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xE8\xB5\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xE8\xB5\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xE8\xB5\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xE8\xB5\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xE8\xB6\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xE8\xB6\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xE8\xB7\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xE8\xB6\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xE8\xB6\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xE8\xB7\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xE8\xB7\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xE8\xB7\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xE8\xB7\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xE8\xB7\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xE8\xB7\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xE8\xB7\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xE8\xB7\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xE8\xB7\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xE8\xB7\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE8\xB7\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xE8\xB8\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xE8\xB8\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xE8\xB7\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xE8\xB8\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xE8\xB8\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xE8\xB8\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE8\xB8\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xE8\xB9\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xE8\xB8\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xE8\xB8\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xE8\xB8\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xE8\xB9\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xE8\xB9\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x40"],
        ["\xE8\xB9\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x41"],
        ["\xE8\xB9\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x42"],
        ["\xE8\xB9\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x43"],
        ["\xE8\xB9\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x44"],
        ["\xE8\xB9\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x45"],
        ["\xE8\xB9\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x46"],
        ["\xE8\xB9\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x47"],
        ["\xE8\xB8\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x48"],
        ["\xE8\xB9\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x49"],
        ["\xE8\xB9\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],
        ["\xE8\xB9\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],
        ["\xE8\xB9\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],
        ["\xE8\xB9\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],
        ["\xE8\xBA\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],
        ["\xE8\xBA\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],
        ["\xE8\xBA\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],
        ["\xE8\xBA\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x51"],
        ["\xE8\xBA\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x52"],
        ["\xE8\xBA\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x53"],
        ["\xE8\xBA\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x54"],
        ["\xE8\xBA\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x55"],
        ["\xE8\xBA\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x56"],
        ["\xE8\xBA\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],
        ["\xE8\xBA\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x58"],
        ["\xE8\xBA\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],
        ["\xE8\xBA\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],
        ["\xE8\xBA\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],
        ["\xE8\xBB\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],
        ["\xE8\xBA\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],
        ["\xE8\xBA\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\xE8\xBB\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],
        ["\xE8\xBB\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],
        ["\xE8\xBB\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],
        ["\xE8\xBB\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],
        ["\xE8\xBB\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],
        ["\xE8\xBB\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],
        ["\xE8\xBB\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],
        ["\xE8\xBB\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],
        ["\xE8\xBB\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xE8\xBC\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xE8\xBC\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xE8\xBC\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xE8\xBC\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xE8\xBC\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],
        ["\xE8\xBC\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],
        ["\xE8\xBC\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],
        ["\xE8\xBC\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],
        ["\xE8\xBC\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],
        ["\xE8\xBC\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],
        ["\xE8\xBC\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],
        ["\xE8\xBC\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],
        ["\xE8\xBC\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\xE8\xBC\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],
        ["\xE8\xBD\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\xE8\xBD\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],
        ["\xE8\xBC\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],
        ["\xE8\xBD\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\xE8\xBD\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],
        ["\xE8\xBD\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\xE8\xBD\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],
        ["\xE8\xBD\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],
        ["\xE8\xBD\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],
        ["\xE8\xBD\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\xE8\xBD\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x81"],
        ["\xE8\xBD\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x82"],
        ["\xE8\xBE\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x83"],
        ["\xE8\xBE\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x84"],
        ["\xE8\xBE\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x85"],
        ["\xE8\xBE\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x86"],
        ["\xE8\xBE\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x87"],
        ["\xE8\xBE\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x88"],
        ["\xE8\xBF\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x89"],
        ["\xE8\xBF\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A"],
        ["\xE8\xBF\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\xE8\xBF\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C"],
        ["\xE8\xBF\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D"],
        ["\xE9\x82\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E"],
        ["\xE8\xBF\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F"],
        ["\xE9\x80\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x90"],
        ["\xE8\xBF\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x91"],
        ["\xE8\xBF\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x92"],
        ["\xE9\x80\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x93"],
        ["\xE9\x80\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x94"],
        ["\xE9\x80\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x95"],
        ["\xE9\x80\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x96"],
        ["\xE9\x80\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x97"],
        ["\xE9\x80\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x98"],
        ["\xE9\x80\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x99"],
        ["\xE9\x80\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A"],
        ["\xE9\x80\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],
        ["\xE9\x80\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\xE9\x80\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D"],
        ["\xE8\xBF\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E"],
        ["\xE9\x81\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F"],
        ["\xE9\x81\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],
        ["\xE9\x81\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xE9\x81\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xE9\x80\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xE9\x81\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xE9\x80\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xE9\x81\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xE9\x81\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xE9\x81\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xE9\x81\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xE9\x81\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xE9\x81\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xE9\x9A\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xE9\x81\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xE9\x82\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xE9\x81\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xE9\x82\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE9\x82\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xE9\x82\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xE9\x82\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xE9\x82\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xE9\x82\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xE9\x82\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xE9\x82\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xE9\x82\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xE9\x83\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xE9\x83\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xE6\x89\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xE9\x83\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xE9\x84\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xE9\x84\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xE9\x84\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xE9\x84\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE9\x84\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE9\x85\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE9\x85\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE9\x85\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE9\x85\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE9\x85\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE9\x85\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE9\x85\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE9\x85\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE9\x86\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xE9\x86\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xE9\x86\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xE9\x86\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xE9\x86\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xE9\x86\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xE9\x86\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xE9\x86\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xE9\x86\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xE9\x86\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xE9\x87\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xE9\x87\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xE9\x87\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xE9\x87\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xE9\x87\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xE9\x87\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xE9\x87\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xE9\x87\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xE9\x87\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xE9\x87\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xE9\x87\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xE9\x87\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xE9\x88\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xE9\x87\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xE9\x88\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xE9\x88\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xE9\x88\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xE9\x88\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xE9\x89\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xE9\x89\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xE9\x89\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xE9\x89\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xE9\x89\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xE9\x89\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xE9\x8A\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xE9\x88\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xE9\x89\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xE9\x89\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xE9\x8A\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xE9\x8A\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xE9\x8A\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xE9\x8A\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xE9\x89\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xE9\x8B\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xE9\x8A\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xE9\x8A\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xE9\x8B\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xE9\x8C\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xE9\x8B\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xE9\x8D\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xE9\x8C\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xE9\x8C\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x40"],
        ["\xE9\x8C\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x41"],
        ["\xE9\x8C\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x42"],
        ["\xE9\x8C\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x43"],
        ["\xE9\x8C\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x44"],
        ["\xE9\x8C\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x45"],
        ["\xE9\x8C\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x46"],
        ["\xE9\x8D\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x47"],
        ["\xE9\x8D\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x48"],
        ["\xE9\x8D\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x49"],
        ["\xE9\x8D\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],
        ["\xE9\x8D\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],
        ["\xE9\x8E\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],
        ["\xE9\x8E\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],
        ["\xE9\x8E\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],
        ["\xE9\x8E\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],
        ["\xE9\x8E\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],
        ["\xE9\x8F\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x51"],
        ["\xE9\x8F\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x52"],
        ["\xE9\x8F\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x53"],
        ["\xE9\x8F\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x54"],
        ["\xE9\x8F\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x55"],
        ["\xE9\x8F\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x56"],
        ["\xE9\x8F\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],
        ["\xE9\x8F\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x58"],
        ["\xE9\x8F\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],
        ["\xE9\x8F\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],
        ["\xE9\x90\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],
        ["\xE9\x90\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],
        ["\xE9\x90\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\xE9\x90\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],
        ["\xE9\x90\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],
        ["\xE9\x90\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],
        ["\xE9\x90\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],
        ["\xE9\x90\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],
        ["\xE9\x90\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],
        ["\xE9\x90\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xE9\x90\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],
        ["\xE9\x91\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],
        ["\xE9\x91\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],
        ["\xE9\x91\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],
        ["\xE9\x91\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],
        ["\xE9\x91\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],
        ["\xE9\x91\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],
        ["\xE9\x91\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],
        ["\xE9\x91\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],
        ["\xE9\x88\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xE9\x91\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],
        ["\xE9\x91\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],
        ["\xE9\x91\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],
        ["\xE9\x91\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],
        ["\xE9\x91\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],
        ["\xE9\x91\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],
        ["\xE9\x91\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xE9\x92\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],
        ["\xE9\x91\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],
        ["\xE9\x96\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],
        ["\xE9\x96\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xE9\x96\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],
        ["\xE9\x96\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],
        ["\xE9\x96\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],
        ["\xE9\x96\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],
        ["\xE9\x96\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],
        ["\xE9\x96\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],
        ["\xE9\x96\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x81"],
        ["\xE9\x96\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x82"],
        ["\xE9\x96\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\xE9\x96\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\xE9\x96\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x85"],
        ["\xE9\x96\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x86"],
        ["\xE9\x96\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\xE9\x97\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\xE6\xBF\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x89"],
        ["\xE9\x97\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A"],
        ["\xE9\x97\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],
        ["\xE9\x97\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\xE9\x97\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D"],
        ["\xE9\x97\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E"],
        ["\xE9\x97\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F"],
        ["\xE9\x97\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x90"],
        ["\xE9\x97\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x91"],
        ["\xE9\x97\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x92"],
        ["\xE9\x97\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x93"],
        ["\xE9\x98\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x94"],
        ["\xE9\x98\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x95"],
        ["\xE9\x98\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x96"],
        ["\xE9\x98\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\xE9\x99\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x98"],
        ["\xE9\x99\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x99"],
        ["\xE9\x99\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A"],
        ["\xE9\x99\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],
        ["\xE9\x99\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xE9\x99\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D"],
        ["\xE9\x99\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E"],
        ["\xE9\x99\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F"],
        ["\xE9\x99\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],
        ["\xE9\x99\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xE9\x99\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xE9\x99\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xE9\x9A\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xE9\x9A\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xE9\x9A\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xE9\x9A\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xE9\x9A\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xE9\x9A\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xE9\x9A\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE9\x9A\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE9\x9A\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xE9\x9A\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xE9\x9A\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE9\x9A\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xE9\x9A\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xE9\x9B\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xE9\x9B\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE9\x9B\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xE9\x9B\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xE8\xA5\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xE9\x9B\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xE9\x9C\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xE9\x9B\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE9\x9B\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xE9\x9C\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xE9\x9C\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xE9\x9C\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xE9\x9C\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xE9\x9C\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xE9\x9C\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xE9\x9C\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xE9\x9C\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xE9\x9C\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xE9\x9C\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xE9\x9C\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xE9\x9C\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xE9\x9C\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xE9\x9C\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xE9\x9C\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xE9\x9D\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xE9\x9D\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xE9\x9D\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xE9\x9D\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xE9\x9D\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xE9\x9D\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xE9\x9D\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xE9\x9D\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xE9\x9D\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xE9\x9D\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xE5\x8B\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xE9\x9D\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xE9\x9D\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xE9\x9D\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xE9\x9E\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xE9\x9D\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE9\x9E\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE9\x9D\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE9\x9E\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE9\x9E\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xE9\x9E\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xE9\x9E\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xE9\x9E\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xE9\x9E\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xE9\x9E\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xE9\x9E\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xE9\x9E\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xE9\x9E\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xE9\x9F\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xE9\x9F\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xE9\x9F\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xE9\x9F\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xE9\x9F\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xE9\x9F\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xE9\xBD\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE9\x9F\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE7\xAB\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xE9\x9F\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xE9\x9F\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xE9\xA0\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xE9\xA0\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xE9\xA0\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xE9\xA0\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xE9\xA0\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xE9\xA0\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xE9\xA0\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xE9\xA1\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xE9\xA1\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xE9\xA1\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE9\xA1\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE9\xA1\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE9\xA1\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xE9\xA1\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x40"],
        ["\xE9\xA1\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x41"],
        ["\xE9\xA1\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x42"],
        ["\xE9\xA2\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x43"],
        ["\xE9\xA2\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x44"],
        ["\xE9\xA2\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x45"],
        ["\xE9\xA2\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x46"],
        ["\xE9\xA3\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x47"],
        ["\xE9\xA3\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x48"],
        ["\xE9\xA3\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x49"],
        ["\xE9\xA3\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\xE9\xA3\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],
        ["\xE9\xA4\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],
        ["\xE9\xA4\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],
        ["\xE9\xA4\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\xE9\xA4\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],
        ["\xE9\xA4\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],
        ["\xE9\xA4\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x51"],
        ["\xE9\xA4\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x52"],
        ["\xE9\xA4\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x53"],
        ["\xE9\xA4\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x54"],
        ["\xE9\xA4\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x55"],
        ["\xE9\xA4\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x56"],
        ["\xE9\xA4\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],
        ["\xE9\xA4\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x58"],
        ["\xE9\xA4\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\xE9\xA5\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],
        ["\xE9\xA5\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],
        ["\xE9\xA5\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],
        ["\xE9\xA5\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],
        ["\xE9\xA5\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],
        ["\xE9\xA5\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],
        ["\xE9\xA5\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],
        ["\xE9\xA5\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],
        ["\xE9\xA5\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],
        ["\xE9\xA6\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xE9\xA6\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],
        ["\xE9\xA6\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],
        ["\xE9\xA6\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],
        ["\xE9\xA6\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],
        ["\xE9\xA6\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],
        ["\xE9\xA7\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],
        ["\xE9\xA7\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\xE9\xA7\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],
        ["\xE9\xA7\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xE9\xA7\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\xE9\xA7\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],
        ["\xE9\xA7\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],
        ["\xE9\xA7\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],
        ["\xE9\xA7\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],
        ["\xE9\xA7\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\xE9\xA7\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],
        ["\xE9\xA8\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],
        ["\xE9\xA8\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],
        ["\xE9\xA8\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],
        ["\xE9\xA7\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],
        ["\xE9\xA8\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],
        ["\xE9\xA8\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],
        ["\xE9\xA8\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],
        ["\xE9\xA9\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],
        ["\xE9\xA9\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],
        ["\xE9\xA9\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\xE9\xA9\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],
        ["\xE9\xA8\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],
        ["\xE9\xA9\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x81"],
        ["\xE9\xA9\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x82"],
        ["\xE9\xA9\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x83"],
        ["\xE9\xA9\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x84"],
        ["\xE9\xA9\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x85"],
        ["\xE9\xA9\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x86"],
        ["\xE9\xA9\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x87"],
        ["\xE9\xA9\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x88"],
        ["\xE9\xA9\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x89"],
        ["\xE9\xA9\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A"],
        ["\xE9\xA9\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],
        ["\xE9\xAA\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C"],
        ["\xE9\xAA\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D"],
        ["\xE9\xAA\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E"],
        ["\xE9\xAB\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F"],
        ["\xE9\xAB\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x90"],
        ["\xE9\xAB\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x91"],
        ["\xE9\xAB\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x92"],
        ["\xE9\xAB\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x93"],
        ["\xE9\xAB\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x94"],
        ["\xE9\xAB\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x95"],
        ["\xE9\xAB\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x96"],
        ["\xE9\xAB\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x97"],
        ["\xE9\xAB\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x98"],
        ["\xE9\xAB\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x99"],
        ["\xE9\xAB\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A"],
        ["\xE9\xAB\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],
        ["\xE9\xAB\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],
        ["\xE9\xAB\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D"],
        ["\xE9\xAB\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E"],
        ["\xE9\xAB\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F"],
        ["\xE9\xAC\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],
        ["\xE9\xAC\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xE9\xAC\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xE9\xAC\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xE9\xAC\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xE9\xAC\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xE9\xAC\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xE9\xAC\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xE9\xAC\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xE9\xAC\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xE9\xAC\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xE9\xAC\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xE9\xAC\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xE9\xAC\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xE9\xAD\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xE9\xAD\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xE9\xAD\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xE9\xAD\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xE9\xAD\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xE9\xAD\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xE9\xAD\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xE9\xAD\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xE9\xAE\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xE9\xAE\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xE9\xAE\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xE9\xAE\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xE9\xAE\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xE9\xAE\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xE9\xAE\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xE9\xAE\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xE9\xAE\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xE9\xAF\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xE9\xAF\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xE9\xAE\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xE9\xAF\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xE9\xAF\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xE9\xAF\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xE9\xAF\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xE9\xAF\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xE9\xAF\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xE9\xAF\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xE9\xAF\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xE9\xAF\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xE9\xB0\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xE9\xAF\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xE9\xAF\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xE9\xAF\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xE9\xB0\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xE9\xB0\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xE9\xB0\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xE9\xB0\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xE9\xB0\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xE9\xB0\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xE9\xB0\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xE9\xB0\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xE9\xB0\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xE9\xB0\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xE9\xB0\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xE9\xB0\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xE9\xB0\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xE9\xB0\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xE9\xB0\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xE9\xB0\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xE9\xB1\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xE9\xB0\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xE9\xB1\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xE9\xB0\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xE9\xB1\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xE9\xB1\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xE9\xB1\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xE9\xB1\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xE9\xB1\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xE9\xB3\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xE9\xB3\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xE9\xB3\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xE9\xB4\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xE9\xB4\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xE9\xB3\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xE9\xB4\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xE9\xB4\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xE9\xB4\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xE9\xB4\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xE9\xB6\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xE9\xB4\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE9\xB4\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xE9\xB5\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xE9\xB4\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xE9\xB4\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xE9\xB5\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xE9\xB4\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xE9\xB4\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xE9\xB5\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xE9\xB5\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xE9\xB5\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x40"],
        ["\xE9\xB5\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x41"],
        ["\xE9\xB5\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x42"],
        ["\xE9\xB5\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x43"],
        ["\xE9\xB5\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x44"],
        ["\xE9\xB5\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x45"],
        ["\xE9\xB5\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x46"],
        ["\xE9\xB6\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x47"],
        ["\xE9\xB6\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x48"],
        ["\xE9\xB6\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x49"],
        ["\xE9\xB5\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4A"],
        ["\xE9\xB5\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4B"],
        ["\xE9\xB6\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4C"],
        ["\xE9\xB6\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4D"],
        ["\xE9\xB6\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4E"],
        ["\xE9\xB6\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x4F"],
        ["\xE9\xB7\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x50"],
        ["\xE9\xB7\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x51"],
        ["\xE9\xB6\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x52"],
        ["\xE9\xB6\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x53"],
        ["\xE9\xB6\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x54"],
        ["\xE9\xB7\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x55"],
        ["\xE9\xB7\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x56"],
        ["\xE9\xB7\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x57"],
        ["\xE9\xB7\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x58"],
        ["\xE9\xB7\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x59"],
        ["\xE9\xB7\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5A"],
        ["\xE9\xB7\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5B"],
        ["\xE9\xB7\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5C"],
        ["\xE9\xB7\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5D"],
        ["\xE9\xB7\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5E"],
        ["\xE9\xB8\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x5F"],
        ["\xE9\xB8\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x60"],
        ["\xE9\xB8\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x61"],
        ["\xE9\xB9\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x62"],
        ["\xE9\xB9\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x63"],
        ["\xE9\xB9\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x64"],
        ["\xE9\xBA\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x65"],
        ["\xE9\xBA\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x66"],
        ["\xE9\xBA\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x67"],
        ["\xE9\xBA\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x68"],
        ["\xE9\xBA\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x69"],
        ["\xE9\xBA\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6A"],
        ["\xE9\xBA\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6B"],
        ["\xE9\xBA\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6C"],
        ["\xE9\xBA\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6D"],
        ["\xE9\xBA\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6E"],
        ["\xE9\xBA\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x6F"],
        ["\xE9\xBA\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x70"],
        ["\xE9\xBA\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x71"],
        ["\xE9\x9D\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x72"],
        ["\xE9\xBB\x8C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x73"],
        ["\xE9\xBB\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x74"],
        ["\xE9\xBB\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x75"],
        ["\xE9\xBB\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x76"],
        ["\xE9\xBB\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x77"],
        ["\xE9\xBB\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x78"],
        ["\xE9\xBB\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x79"],
        ["\xE9\xBB\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7A"],
        ["\xE9\xBB\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7B"],
        ["\xE9\xBB\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7C"],
        ["\xE9\xBB\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7D"],
        ["\xE9\xBB\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x7E"],
        ["\xE9\xBB\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x80"],
        ["\xE9\xBB\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x81"],
        ["\xE9\xBB\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x82"],
        ["\xE9\xBB\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x83"],
        ["\xE9\xBB\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x84"],
        ["\xE9\xBB\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x85"],
        ["\xE9\xBB\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x86"],
        ["\xE9\xBC\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x87"],
        ["\xE9\xBC\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x88"],
        ["\xE7\x9A\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x89"],
        ["\xE9\xBC\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8A"],
        ["\xE9\xBC\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8B"],
        ["\xE9\xBC\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8C"],
        ["\xE9\xBC\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8D"],
        ["\xE9\xBD\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8E"],
        ["\xE9\xBD\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x8F"],
        ["\xE9\xBD\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x90"],
        ["\xE9\xBD\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x91"],
        ["\xE9\xBD\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x92"],
        ["\xE9\xBD\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x93"],
        ["\xE9\xBD\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x94"],
        ["\xE9\xBD\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x95"],
        ["\xE9\xBD\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x96"],
        ["\xE9\xBD\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x97"],
        ["\xE9\xBD\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x98"],
        ["\xE9\xBD\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x99"],
        ["\xE9\xBD\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9A"],
        ["\xE9\xBD\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9B"],
        ["\xE9\xBE\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9C"],
        ["\xE9\xBE\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9D"],
        ["\xE9\xBE\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9E"],
        ["\xE5\xA0\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\x9F"],
        ["\xE6\xA7\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA0"],
        ["\xE9\x81\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],
        ["\xE7\x91\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],
        ["\xE5\x87\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],
        ["\xE7\x86\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],
        ["\xE2\x85\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x40"],
        ["\xE2\x85\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x41"],
        ["\xE2\x85\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x42"],
        ["\xE2\x85\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x43"],
        ["\xE2\x85\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x44"],
        ["\xE2\x85\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x45"],
        ["\xE2\x85\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x46"],
        ["\xE2\x85\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x47"],
        ["\xE2\x85\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x48"],
        ["\xE2\x85\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x49"],
        ["\xEF\xBF\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x55"],
        ["\xEF\xBC\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x56"],
        ["\xEF\xBC\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x57"],
        ["\xE7\xBA\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x5C"],
        ["\xE8\xA4\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x5D"],
        ["\xE9\x8D\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x5E"],
        ["\xE9\x8A\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x5F"],
        ["\xE8\x93\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x60"],
        ["\xE4\xBF\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x61"],
        ["\xE7\x82\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x62"],
        ["\xE6\x98\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x63"],
        ["\xE6\xA3\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x64"],
        ["\xE9\x8B\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x65"],
        ["\xE6\x9B\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x66"],
        ["\xE5\xBD\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x67"],
        ["\xE4\xB8\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x68"],
        ["\xE4\xBB\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x69"],
        ["\xE4\xBB\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x6A"],
        ["\xE4\xBC\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x6B"],
        ["\xE4\xBC\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x6C"],
        ["\xE4\xBC\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x6D"],
        ["\xE4\xBD\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x6E"],
        ["\xE4\xBE\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x6F"],
        ["\xE4\xBE\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x70"],
        ["\xE4\xBE\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x71"],
        ["\xE4\xBE\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x72"],
        ["\xE4\xBF\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x73"],
        ["\xE5\x81\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x74"],
        ["\xE5\x80\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x75"],
        ["\xE4\xBF\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x76"],
        ["\xE5\x80\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x77"],
        ["\xE5\x81\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x78"],
        ["\xE5\x81\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x79"],
        ["\xE5\x81\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x7A"],
        ["\xE5\x82\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x7B"],
        ["\xE5\x83\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x7C"],
        ["\xE5\x83\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x7D"],
        ["\xE5\x85\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x7E"],
        ["\xE5\x85\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x80"],
        ["\xE5\x86\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x81"],
        ["\xE5\x86\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x82"],
        ["\xE5\x87\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x83"],
        ["\xE5\x88\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x84"],
        ["\xE5\x8A\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x85"],
        ["\xE5\x8A\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x86"],
        ["\xE5\x8B\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x87"],
        ["\xE5\x8B\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x88"],
        ["\xE5\x8C\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x89"],
        ["\xE5\x8C\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x8A"],
        ["\xE5\x8C\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x8B"],
        ["\xE5\x8D\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x8C"],
        ["\xE5\x8E\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x8D"],
        ["\xE5\x8E\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x8E"],
        ["\xE5\x8F\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x8F"],
        ["\xEF\xA8\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x90"],
        ["\xE5\x92\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x91"],
        ["\xE5\x92\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x92"],
        ["\xE5\x92\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x93"],
        ["\xE5\x93\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x94"],
        ["\xE5\x96\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x95"],
        ["\xE5\x9D\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x96"],
        ["\xE5\x9D\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x97"],
        ["\xE5\x9E\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x98"],
        ["\xE5\x9F\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x99"],
        ["\xE5\x9F\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x9A"],
        ["\xEF\xA8\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x9B"],
        ["\xEF\xA8\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x9C"],
        ["\xE5\xA2\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x9D"],
        ["\xE5\xA2\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x9E"],
        ["\xE5\xA4\x8B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x9F"],
        ["\xE5\xA5\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA0"],
        ["\xE5\xA5\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA1"],
        ["\xE5\xA5\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA2"],
        ["\xE5\xA5\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA3"],
        ["\xE5\xA6\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA4"],
        ["\xE5\xA6\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA5"],
        ["\xE5\xAD\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA6"],
        ["\xE5\xAF\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA7"],
        ["\xE7\x94\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA8"],
        ["\xE5\xAF\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xA9"],
        ["\xE5\xAF\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xAA"],
        ["\xE5\xB0\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xAB"],
        ["\xE5\xB2\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xAC"],
        ["\xE5\xB2\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xAD"],
        ["\xE5\xB3\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xAE"],
        ["\xE5\xB4\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xAF"],
        ["\xE5\xB5\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB0"],
        ["\xEF\xA8\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB1"],
        ["\xE5\xB5\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB2"],
        ["\xE5\xB5\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB3"],
        ["\xE5\xB6\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB4"],
        ["\xE5\xB6\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB5"],
        ["\xE5\xB7\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB6"],
        ["\xE5\xBC\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB7"],
        ["\xE5\xBC\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB8"],
        ["\xE5\xBD\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xB9"],
        ["\xE5\xBE\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xBA"],
        ["\xE5\xBF\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xBB"],
        ["\xE6\x81\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xBC"],
        ["\xE6\x82\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xBD"],
        ["\xE6\x82\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xBE"],
        ["\xE6\x83\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xBF"],
        ["\xE6\x83\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC0"],
        ["\xE6\x84\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC1"],
        ["\xE6\x83\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC2"],
        ["\xE6\x84\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC3"],
        ["\xE6\x84\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC4"],
        ["\xE6\x84\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC5"],
        ["\xE6\x86\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC6"],
        ["\xE6\x88\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC7"],
        ["\xE6\x8A\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC8"],
        ["\xE6\x8F\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xC9"],
        ["\xE6\x91\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xCA"],
        ["\xE6\x92\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xCB"],
        ["\xE6\x93\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xCC"],
        ["\xE6\x95\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xCD"],
        ["\xE6\x98\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xCE"],
        ["\xE6\x98\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xCF"],
        ["\xE6\x98\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD0"],
        ["\xE6\x98\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD1"],
        ["\xE6\x98\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD2"],
        ["\xE6\x98\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD3"],
        ["\xE6\x98\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD4"],
        ["\xE6\x99\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD5"],
        ["\xE6\x99\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD6"],
        ["\xE6\x99\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD7"],
        ["\xEF\xA8\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD8"],
        ["\xE6\x99\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xD9"],
        ["\xE6\x9A\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xDA"],
        ["\xE6\x9A\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xDB"],
        ["\xE6\x9A\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xDC"],
        ["\xE6\x9A\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xDD"],
        ["\xE6\x9B\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xDE"],
        ["\xE6\x9C\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xDF"],
        ["\xEF\xA4\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE0"],
        ["\xE6\x9D\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE1"],
        ["\xE6\x9E\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE2"],
        ["\xE6\xA1\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE3"],
        ["\xE6\x9F\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE4"],
        ["\xE6\xA0\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE5"],
        ["\xE6\xA1\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE6"],
        ["\xE6\xA3\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE7"],
        ["\xEF\xA8\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE8"],
        ["\xE6\xA5\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xE9"],
        ["\xEF\xA8\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xEA"],
        ["\xE6\xA6\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xEB"],
        ["\xE6\xA7\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xEC"],
        ["\xE6\xA8\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xED"],
        ["\xE6\xA9\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xEE"],
        ["\xE6\xA9\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xEF"],
        ["\xE6\xA9\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF0"],
        ["\xE6\xA9\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF1"],
        ["\xE6\xAB\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF2"],
        ["\xE6\xAB\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF3"],
        ["\xE6\xAF\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF4"],
        ["\xE6\xB0\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF5"],
        ["\xE6\xB1\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF6"],
        ["\xE6\xB2\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF7"],
        ["\xE6\xB1\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF8"],
        ["\xE6\xB3\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xF9"],
        ["\xE6\xB4\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xFA"],
        ["\xE6\xB6\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xFB"],
        ["\xE6\xB5\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\xFC"],
        ["\xE6\xB6\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x40"],
        ["\xE6\xB6\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x41"],
        ["\xE6\xB7\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x42"],
        ["\xE6\xB7\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x43"],
        ["\xE6\xB7\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x44"],
        ["\xE6\xB7\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x45"],
        ["\xE6\xB8\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x46"],
        ["\xE6\xB9\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x47"],
        ["\xE6\xB8\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x48"],
        ["\xE6\xB8\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x49"],
        ["\xE6\xBA\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x4A"],
        ["\xE6\xBE\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x4B"],
        ["\xE6\xBE\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x4C"],
        ["\xE6\xBF\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x4D"],
        ["\xE7\x80\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x4E"],
        ["\xE7\x80\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x4F"],
        ["\xE7\x80\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x50"],
        ["\xE7\x82\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x51"],
        ["\xE7\x82\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x52"],
        ["\xE7\x84\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x53"],
        ["\xE7\x84\x84",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x54"],
        ["\xE7\x85\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x55"],
        ["\xE7\x85\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x56"],
        ["\xE7\x85\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x57"],
        ["\xEF\xA8\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x58"],
        ["\xE7\x87\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x59"],
        ["\xE7\x87\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x5A"],
        ["\xE7\x8A\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x5B"],
        ["\xE7\x8A\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x5C"],
        ["\xE7\x8C\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x5D"],
        ["\xEF\xA8\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x5E"],
        ["\xE7\x8D\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x5F"],
        ["\xE7\x8E\xBD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x60"],
        ["\xE7\x8F\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x61"],
        ["\xE7\x8F\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x62"],
        ["\xE7\x8F\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x63"],
        ["\xE7\x8F\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x64"],
        ["\xE7\x90\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x65"],
        ["\xE7\x8F\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x66"],
        ["\xE7\x90\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x67"],
        ["\xE7\x90\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x68"],
        ["\xE7\x90\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x69"],
        ["\xE7\x90\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x6A"],
        ["\xE7\x91\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x6B"],
        ["\xE7\x92\x89",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x6C"],
        ["\xE7\x92\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x6D"],
        ["\xE7\x94\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x6E"],
        ["\xE7\x95\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x6F"],
        ["\xE7\x9A\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x70"],
        ["\xE7\x9A\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x71"],
        ["\xE7\x9A\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x72"],
        ["\xE7\x9A\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x73"],
        ["\xE7\x9A\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x74"],
        ["\xEF\xA8\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x75"],
        ["\xE7\x9D\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x76"],
        ["\xE5\x8A\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x77"],
        ["\xE7\xA0\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x78"],
        ["\xE7\xA1\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x79"],
        ["\xE7\xA1\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x7A"],
        ["\xE7\xA1\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x7B"],
        ["\xE7\xA4\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x7C"],
        ["\xEF\xA8\x98",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x7D"],
        ["\xEF\xA8\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x7E"],
        ["\xEF\xA8\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x80"],
        ["\xE7\xA6\x94",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x81"],
        ["\xEF\xA8\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x82"],
        ["\xE7\xA6\x9B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x83"],
        ["\xE7\xAB\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x84"],
        ["\xE7\xAB\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x85"],
        ["\xEF\xA8\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x86"],
        ["\xE7\xAB\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x87"],
        ["\xE7\xAE\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x88"],
        ["\xEF\xA8\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x89"],
        ["\xE7\xB5\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x8A"],
        ["\xE7\xB5\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x8B"],
        ["\xE7\xB6\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x8C"],
        ["\xE7\xB6\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x8D"],
        ["\xE7\xB7\x96",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x8E"],
        ["\xE7\xB9\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x8F"],
        ["\xE7\xBD\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x90"],
        ["\xE7\xBE\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x91"],
        ["\xEF\xA8\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x92"],
        ["\xE8\x8C\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x93"],
        ["\xE8\x8D\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x94"],
        ["\xE8\x8D\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x95"],
        ["\xE8\x8F\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x96"],
        ["\xE8\x8F\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x97"],
        ["\xE8\x91\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x98"],
        ["\xE8\x92\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x99"],
        ["\xE8\x95\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x9A"],
        ["\xE8\x95\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x9B"],
        ["\xE8\x95\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x9C"],
        ["\xEF\xA8\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x9D"],
        ["\xE8\x96\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x9E"],
        ["\xEF\xA8\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\x9F"],
        ["\xEF\xA8\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA0"],
        ["\xE8\xA0\x87",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA1"],
        ["\xE8\xA3\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA2"],
        ["\xE8\xA8\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA3"],
        ["\xE8\xA8\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA4"],
        ["\xE8\xA9\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA5"],
        ["\xE8\xAA\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA6"],
        ["\xE8\xAA\xBE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA7"],
        ["\xE8\xAB\x9F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA8"],
        ["\xEF\xA8\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xA9"],
        ["\xE8\xAB\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xAA"],
        ["\xE8\xAD\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xAB"],
        ["\xE8\xAD\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xAC"],
        ["\xE8\xB3\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xAD"],
        ["\xE8\xB3\xB4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xAE"],
        ["\xE8\xB4\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xAF"],
        ["\xE8\xB5\xB6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB0"],
        ["\xEF\xA8\xA3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB1"],
        ["\xE8\xBB\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB2"],
        ["\xEF\xA8\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB3"],
        ["\xEF\xA8\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB4"],
        ["\xE9\x81\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB5"],
        ["\xE9\x83\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB6"],
        ["\xEF\xA8\xA6",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB7"],
        ["\xE9\x84\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB8"],
        ["\xE9\x84\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xB9"],
        ["\xE9\x87\x9A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xBA"],
        ["\xE9\x87\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xBB"],
        ["\xE9\x87\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xBC"],
        ["\xE9\x87\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xBD"],
        ["\xE9\x87\xAE",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xBE"],
        ["\xE9\x87\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xBF"],
        ["\xE9\x87\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC0"],
        ["\xE9\x88\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC1"],
        ["\xE9\x88\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC2"],
        ["\xE9\x88\x8A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC3"],
        ["\xE9\x88\xBA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC4"],
        ["\xE9\x89\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC5"],
        ["\xE9\x88\xBC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC6"],
        ["\xE9\x89\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC7"],
        ["\xE9\x89\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC8"],
        ["\xE9\x89\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xC9"],
        ["\xE9\x88\xB9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xCA"],
        ["\xE9\x89\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xCB"],
        ["\xE9\x8A\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xCC"],
        ["\xE9\x89\xB7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xCD"],
        ["\xE9\x89\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xCE"],
        ["\xE9\x8B\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xCF"],
        ["\xE9\x8B\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD0"],
        ["\xE9\x8B\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD1"],
        ["\xE9\x8B\x90",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD2"],
        ["\xEF\xA8\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD3"],
        ["\xE9\x8B\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD4"],
        ["\xE9\x8B\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD5"],
        ["\xE9\x8B\x93",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD6"],
        ["\xE9\x8C\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD7"],
        ["\xE9\x8C\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD8"],
        ["\xE9\x8B\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xD9"],
        ["\xEF\xA8\xA8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xDA"],
        ["\xE9\x8C\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xDB"],
        ["\xE9\x8B\xBF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xDC"],
        ["\xE9\x8C\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xDD"],
        ["\xE9\x8C\x82",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xDE"],
        ["\xE9\x8D\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xDF"],
        ["\xE9\x8D\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE0"],
        ["\xE9\x8E\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE1"],
        ["\xE9\x8F\x86",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE2"],
        ["\xE9\x8F\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE3"],
        ["\xE9\x8F\xB8",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE4"],
        ["\xE9\x90\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE5"],
        ["\xE9\x91\x85",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE6"],
        ["\xE9\x91\x88",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE7"],
        ["\xE9\x96\x92",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE8"],
        ["\xEF\xA7\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xE9"],
        ["\xEF\xA8\xA9",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xEA"],
        ["\xE9\x9A\x9D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xEB"],
        ["\xE9\x9A\xAF",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xEC"],
        ["\xE9\x9C\xB3",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xED"],
        ["\xE9\x9C\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xEE"],
        ["\xE9\x9D\x83",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xEF"],
        ["\xE9\x9D\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF0"],
        ["\xE9\x9D\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF1"],
        ["\xE9\x9D\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF2"],
        ["\xE9\x9D\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF3"],
        ["\xE9\xA1\x97",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF4"],
        ["\xE9\xA1\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF5"],
        ["\xEF\xA8\xAA",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF6"],
        ["\xEF\xA8\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF7"],
        ["\xE9\xA4\xA7",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF8"],
        ["\xEF\xA8\xAC",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xF9"],
        ["\xE9\xA6\x9E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xFA"],
        ["\xE9\xA9\x8E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xFB"],
        ["\xE9\xAB\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFB\xFC"],
        ["\xE9\xAB\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x40"],
        ["\xE9\xAD\xB5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x41"],
        ["\xE9\xAD\xB2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x42"],
        ["\xE9\xAE\x8F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x43"],
        ["\xE9\xAE\xB1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x44"],
        ["\xE9\xAE\xBB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x45"],
        ["\xE9\xB0\x80",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x46"],
        ["\xE9\xB5\xB0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x47"],
        ["\xE9\xB5\xAB",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x48"],
        ["\xEF\xA8\xAD",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x49"],
        ["\xE9\xB8\x99",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x4A"],
        ["\xE9\xBB\x91",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFC\x4B"],
        ["\xE5\xBD\x81",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x9C\x5A"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
