/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import org.mortbay.http.HttpContext;
import org.mortbay.http.NCSARequestLog;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.Server;
import org.openqa.selenium.server.ClasspathResourceLocator;
import org.openqa.selenium.server.FsResourceLocator;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.ProxyHandler;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.SingleEntryAsyncQueue;
import org.openqa.selenium.server.StaticContentHandler;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.SeleniumHTMLRunnerResultsHandler;
import org.openqa.selenium.server.htmlrunner.SingleTestSuiteResourceHandler;

public class SeleniumServer {
    private Server server;
    private SeleniumDriverResourceHandler driver;
    private SeleniumHTMLRunnerResultsHandler postResultsHandler;
    private StaticContentHandler staticContentHandler;
    private int port;
    private boolean multiWindow = false;
    private Thread shutDownHook;
    private static ProxyHandler customProxyHandler;
    private static String debugURL;
    private static boolean debugMode;
    private static boolean alwaysProxy;
    private static boolean proxyInjectionMode;
    private static File firefoxProfileTemplate;
    public static final int DEFAULT_PORT = 4444;
    private static int portDriversShouldContact;
    private static PrintStream logOut;
    private static String logOutFileName;
    private static String forcedBrowserMode;
    public static final int DEFAULT_TIMEOUT = 1800;
    public static int timeoutInSeconds;
    private static Boolean reusingBrowserSessions;
    private static String dontInjectRegex;
    private static boolean FORCE_PROXY_CHAIN;

    public static void main(String[] args) throws Exception {
        int port = SeleniumServer.getDefaultPort();
        boolean interactive = false;
        boolean htmlSuite = false;
        boolean multiWindow = false;
        File userExtensions = null;
        boolean proxyInjectionModeArg = false;
        int portDriversShouldContactArg = 0;
        boolean userJsInjection = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-help".equalsIgnoreCase(arg)) {
                SeleniumServer.usage(null);
                System.exit(1);
                continue;
            }
            if ("-defaultBrowserString".equalsIgnoreCase(arg)) {
                SeleniumServer.usage("-defaultBrowserString has been renamed -forcedBrowserMode");
                continue;
            }
            if ("-forcedBrowserMode".equalsIgnoreCase(arg)) {
                ++i;
                while (i < args.length) {
                    forcedBrowserMode = forcedBrowserMode == null ? "" : forcedBrowserMode + " ";
                    forcedBrowserMode = forcedBrowserMode + args[i];
                    ++i;
                }
                SeleniumServer.log("\"" + forcedBrowserMode + "\" will be used as the browser " + "mode for all sessions, no matter what is passed to getNewBrowserSession.");
                continue;
            }
            if ("-log".equalsIgnoreCase(arg)) {
                SeleniumServer.setLogOut(SeleniumServer.getArg(args, ++i));
                continue;
            }
            if ("-port".equalsIgnoreCase(arg)) {
                port = Integer.parseInt(SeleniumServer.getArg(args, ++i));
                continue;
            }
            if ("-multiWindow".equalsIgnoreCase(arg)) {
                multiWindow = true;
                continue;
            }
            if ("-alwaysProxy".equalsIgnoreCase(arg)) {
                alwaysProxy = true;
                continue;
            }
            if ("-proxyInjectionMode".equalsIgnoreCase(arg)) {
                proxyInjectionModeArg = true;
                continue;
            }
            if ("-portDriversShouldContact".equalsIgnoreCase(arg)) {
                portDriversShouldContactArg = Integer.parseInt(SeleniumServer.getArg(args, ++i));
                continue;
            }
            if ("-noBrowserSessionReuse".equalsIgnoreCase(arg)) {
                reusingBrowserSessions = Boolean.FALSE;
                continue;
            }
            if ("-browserSessionReuse".equalsIgnoreCase(arg)) {
                reusingBrowserSessions = Boolean.TRUE;
                continue;
            }
            if ("-firefoxProfileTemplate".equalsIgnoreCase(arg)) {
                if ((firefoxProfileTemplate = new File(SeleniumServer.getArg(args, ++i))).exists()) continue;
                System.err.println("Firefox profile template doesn't exist: " + firefoxProfileTemplate.getAbsolutePath());
                System.exit(1);
                continue;
            }
            if ("-dontInjectRegex".equalsIgnoreCase(arg)) {
                dontInjectRegex = SeleniumServer.getArg(args, ++i);
                continue;
            }
            if ("-debug".equalsIgnoreCase(arg)) {
                SeleniumServer.setDebugMode(true);
                continue;
            }
            if ("-debugURL".equalsIgnoreCase(arg)) {
                debugURL = SeleniumServer.getArg(args, ++i);
                continue;
            }
            if ("-timeout".equalsIgnoreCase(arg)) {
                timeoutInSeconds = Integer.parseInt(SeleniumServer.getArg(args, ++i));
                continue;
            }
            if ("-userJsInjection".equalsIgnoreCase(arg)) {
                userJsInjection = true;
                if (InjectionHelper.addUserJsInjectionFile(SeleniumServer.getArg(args, ++i))) continue;
                SeleniumServer.usage(null);
                System.exit(1);
                continue;
            }
            if ("-userContentTransformation".equalsIgnoreCase(arg)) {
                if (InjectionHelper.addUserContentTransformation(SeleniumServer.getArg(args, ++i), SeleniumServer.getArg(args, ++i))) continue;
                SeleniumServer.usage(null);
                System.exit(1);
                continue;
            }
            if ("-userExtensions".equalsIgnoreCase(arg)) {
                if (!(userExtensions = new File(SeleniumServer.getArg(args, ++i))).exists()) {
                    System.err.println("User Extensions file doesn't exist: " + userExtensions.getAbsolutePath());
                    System.exit(1);
                }
                if ("user-extensions.js".equalsIgnoreCase(userExtensions.getName())) continue;
                System.err.println("User extensions file MUST be called \"user-extensions.js\": " + userExtensions.getAbsolutePath());
                System.exit(1);
                continue;
            }
            if ("-htmlSuite".equalsIgnoreCase(arg)) {
                try {
                    System.setProperty("htmlSuite.browserString", args[++i]);
                    System.setProperty("htmlSuite.startURL", args[++i]);
                    System.setProperty("htmlSuite.suiteFilePath", args[++i]);
                    System.setProperty("htmlSuite.resultFilePath", args[++i]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("Not enough command line arguments for -htmlSuite");
                    System.err.println("-htmlSuite requires you to specify:");
                    System.err.println("* browserString (e.g. \"*firefox\")");
                    System.err.println("* startURL (e.g. \"http://www.google.com\")");
                    System.err.println("* suiteFile (e.g. \"c:\\absolute\\path\\to\\my\\HTMLSuite.html\")");
                    System.err.println("* resultFile (e.g. \"c:\\absolute\\path\\to\\my\\results.html\")");
                    System.exit(1);
                }
                htmlSuite = true;
                continue;
            }
            if ("-interactive".equalsIgnoreCase(arg)) {
                timeoutInSeconds = Integer.MAX_VALUE;
                interactive = true;
                continue;
            }
            if (arg.startsWith("-D")) {
                SeleniumServer.setSystemProperty(arg);
                continue;
            }
            SeleniumServer.usage("unrecognized argument " + arg);
            System.exit(1);
        }
        if (userJsInjection && !proxyInjectionModeArg) {
            System.err.println("User js injection can only be used w/ -proxyInjectionMode");
            System.exit(1);
        }
        if (portDriversShouldContactArg == 0) {
            portDriversShouldContactArg = port;
        }
        System.setProperty("org.mortbay.http.HttpRequest.maxFormContentSize", "0");
        final SeleniumServer seleniumProxy = new SeleniumServer(port);
        seleniumProxy.multiWindow = multiWindow;
        SeleniumServer.checkArgsSanity(port, interactive, htmlSuite, proxyInjectionModeArg, portDriversShouldContactArg, seleniumProxy);
        Thread jetty = new Thread(new Runnable(){

            public void run() {
                try {
                    seleniumProxy.start();
                }
                catch (Exception e) {
                    System.err.println("jetty run exception seen:");
                    e.printStackTrace();
                }
            }
        });
        if (interactive) {
            jetty.setDaemon(true);
        }
        seleniumProxy.start();
        if (userExtensions != null) {
            seleniumProxy.addNewStaticContent(userExtensions.getParentFile());
        }
        if (htmlSuite) {
            SeleniumServer.runHtmlSuite(seleniumProxy);
            return;
        }
        if (interactive) {
            String userInput;
            AsyncExecute.sleepTight(500L);
            System.out.println("Entering interactive mode... type Selenium commands here (e.g: cmd=open&1=http://www.yahoo.com)");
            BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
            final String[] lastSessionId = new String[]{""};
            while ((userInput = stdIn.readLine()) != null) {
                boolean newBrowserSession;
                if ("exit".equals(userInput) || "quit".equals(userInput)) {
                    System.out.println("Stopping...");
                    seleniumProxy.stop();
                    System.exit(0);
                }
                if ("".equals(userInput)) continue;
                if (!userInput.startsWith("cmd=") && !userInput.startsWith("commandResult=")) {
                    System.err.println("ERROR -  Invalid command: \"" + userInput + "\"");
                    continue;
                }
                boolean bl = newBrowserSession = userInput.indexOf("getNewBrowserSession") != -1;
                if (userInput.indexOf("sessionId") == -1 && !newBrowserSession) {
                    userInput = userInput + "&sessionId=" + lastSessionId[0];
                }
                final URL url = new URL("http://localhost:" + port + "/selenium-server/driver?" + userInput);
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        block4: {
                            try {
                                SeleniumServer.log("---> Requesting " + url.toString());
                                URLConnection conn = url.openConnection();
                                conn.connect();
                                InputStream is = conn.getInputStream();
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                byte[] buffer = new byte[2048];
                                int length = -1;
                                while ((length = is.read(buffer)) != -1) {
                                    out.write(buffer, 0, length);
                                }
                                is.close();
                                String output = out.toString();
                                if (newBrowserSession && output.startsWith("OK,")) {
                                    lastSessionId[0] = output.substring(3);
                                }
                            }
                            catch (IOException e) {
                                System.err.println(e.getMessage());
                                if (!SeleniumServer.isDebugMode()) break block4;
                                e.printStackTrace();
                            }
                        }
                    }
                });
                t.start();
            }
        }
    }

    private static void setLogOut(String logFileName) {
        logOutFileName = logFileName;
        try {
            logOut = new PrintStream(logFileName);
        }
        catch (FileNotFoundException e) {
            System.err.println("could not write to " + logFileName);
            Runtime.getRuntime().halt(-1);
        }
    }

    private static void checkArgsSanity(int port, boolean interactive, boolean htmlSuite, boolean proxyInjectionModeArg, int portDriversShouldContactArg, SeleniumServer seleniumProxy) throws Exception {
        if (interactive && htmlSuite) {
            System.err.println("You can't use -interactive and -htmlSuite on the same line!");
            System.exit(1);
        }
        SingleEntryAsyncQueue.setDefaultTimeout(timeoutInSeconds);
        seleniumProxy.setProxyInjectionMode(proxyInjectionModeArg);
        if (!SeleniumServer.isProxyInjectionMode() && (InjectionHelper.userContentTransformationsExist() || InjectionHelper.userJsInjectionsExist())) {
            SeleniumServer.usage("-userJsInjection and -userContentTransformation are only valid in combination with -proxyInjectionMode");
            System.exit(1);
        }
        if (!SeleniumServer.isProxyInjectionMode() && SeleniumServer.reusingBrowserSessions()) {
            SeleniumServer.usage("-reusingBrowserSessions only valid in combination with -proxyInjectionMode (because of the need for multiple domain support, which only -proxyInjectionMode provides).");
            System.exit(1);
        }
        if (SeleniumServer.reusingBrowserSessions()) {
            SeleniumServer.log("Will recycle browser sessions when possible.");
        }
    }

    private static String getArg(String[] args, int i) {
        if (i >= args.length) {
            SeleniumServer.usage("expected at least one more argument");
            System.exit(-1);
        }
        return args[i];
    }

    private static void proxyInjectionSpeech() {
        SeleniumServer.log("The selenium server will execute in proxyInjection mode.");
    }

    private static void setSystemProperty(String arg) {
        if (arg.indexOf(61) == -1) {
            SeleniumServer.usage("poorly formatted Java property setting (I expect to see '=') " + arg);
            System.exit(1);
        }
        String property = arg.replaceFirst("-D", "").replaceFirst("=.*", "");
        String value = arg.replaceFirst("[^=]*=", "");
        System.err.println("Setting system property " + property + " to " + value);
        System.setProperty(property, value);
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.err.println(msg + ":");
        }
        String INDENT = "  ";
        String INDENT2X = INDENT + INDENT;
        SeleniumServer.printWrappedErrorLine("", "Usage: java -jar selenium-server.jar [-interactive] [options]\n");
        SeleniumServer.printWrappedErrorLine(INDENT, "-port <nnnn>: the port number the selenium server should use (default 4444)");
        SeleniumServer.printWrappedErrorLine(INDENT, "-timeout <nnnn>: an integer number of seconds before we should give up");
        SeleniumServer.printWrappedErrorLine(INDENT, "-interactive: puts you into interactive mode.  See the tutorial for more details");
        SeleniumServer.printWrappedErrorLine(INDENT, "-multiWindow: puts you into a mode where the test web site executes in a separate window, and selenium supports frames");
        SeleniumServer.printWrappedErrorLine(INDENT, "-forcedBrowserMode <browser>: sets the browser mode (e.g. \"*iexplore\" for all sessions, no matter what is passed to getNewBrowserSession");
        SeleniumServer.printWrappedErrorLine(INDENT, "-userExtensions <file>: indicates a JavaScript file that will be loaded into selenium");
        SeleniumServer.printWrappedErrorLine(INDENT, "-browserSessionReuse: stops re-initialization and spawning of the browser between tests");
        SeleniumServer.printWrappedErrorLine(INDENT, "-alwaysProxy: By default, we proxy as little as we can; set this flag to force all browser traffic through the proxy");
        SeleniumServer.printWrappedErrorLine(INDENT, "-firefoxProfileTemplate <dir>: normally, we generate a fresh empty Firefox profile every time we launch.  You can specify a directory to make us copy your profile directory instead.");
        SeleniumServer.printWrappedErrorLine(INDENT, "-debug: puts you into debug mode, with more trace information and diagnostics");
        SeleniumServer.printWrappedErrorLine(INDENT, "-htmlSuite <browser> <startURL> <suiteFile> <resultFile>: Run a single HTML Selenese (Selenium Core) suite and then exit immediately, using the specified browser (e.g. \"*firefox\") on the specified URL (e.g. \"http://www.google.com\").  You need to specify the absolute path to the HTML test suite as well as the path to the HTML results file we'll generate.");
        SeleniumServer.printWrappedErrorLine(INDENT, "-proxyInjectionMode: puts you into proxy injection mode, a mode where the selenium server acts as a proxy server for all content going to the test application.  Under this mode, multiple domains can be visited, and the following additional flags are supported:\n");
        SeleniumServer.printWrappedErrorLine(INDENT2X, "-dontInjectRegex <regex>: an optional regular expression that proxy injection mode can use to know when to bypss injection");
        SeleniumServer.printWrappedErrorLine(INDENT2X, "-userJsInjection <file>: specifies a JavaScript file which will then be injected into all pages");
        SeleniumServer.printWrappedErrorLine(INDENT2X, "-userContentTransformation <regex> <replacement>: a regular expression which is matched against all test HTML content; the second is a string which will replace matches.  These flags can be used any number of times.  A simple example of how this could be useful: if you add \"-userContentTransformation https http\" then all \"https\" strings in the HTML of the test application will be changed to be \"http\".");
    }

    private static void printWrappedErrorLine(String prefix, String msg) {
        SeleniumServer.printWrappedErrorLine(prefix, msg, true);
    }

    private static void printWrappedErrorLine(String prefix, String msg, boolean first) {
        int defaultWrap;
        int wrap;
        System.err.print(prefix);
        if (!first) {
            System.err.print("  ");
        }
        if ((wrap = (defaultWrap = 70) - prefix.length()) > msg.length()) {
            System.err.println(msg);
            return;
        }
        String lineRaw = msg.substring(0, wrap);
        int spaceIndex = lineRaw.lastIndexOf(32);
        if (spaceIndex == -1) {
            spaceIndex = lineRaw.length();
        }
        String line = lineRaw.substring(0, spaceIndex);
        System.err.println(line);
        SeleniumServer.printWrappedErrorLine(prefix, msg.substring(spaceIndex + 1), false);
    }

    public SeleniumServer(int port, boolean slowResources, boolean multiWindow) throws Exception {
        this.port = port;
        if (portDriversShouldContact == 0) {
            SeleniumServer.setPortDriversShouldContact(port);
        }
        if (logOut == null && System.getProperty("selenium.log") != null) {
            SeleniumServer.setLogOut(System.getProperty("selenium.log"));
        }
        this.multiWindow = multiWindow;
        this.server = new Server();
        if (logOut != null) {
            NCSARequestLog log = new NCSARequestLog();
            log.setFilename(logOutFileName + ".jetty");
            log.setRetainDays(3);
            log.setExtended(true);
            log.setAppend(true);
            this.server.setRequestLog(log);
        }
        SocketListener socketListener = new SocketListener();
        socketListener.setMaxIdleTimeMs(60000);
        socketListener.setPort(port);
        this.server.addListener(socketListener);
        this.configServer();
        this.assembleHandlers(slowResources);
    }

    public SeleniumServer(int port, boolean slowResources) throws Exception {
        this(port, slowResources, false);
    }

    private void assembleHandlers(boolean slowResources) {
        HttpContext root = new HttpContext();
        root.setContextPath("/");
        if (customProxyHandler == null) {
            root.addHandler(new ProxyHandler());
        } else {
            root.addHandler(customProxyHandler);
        }
        this.server.addContext(root);
        HttpContext context = new HttpContext();
        context.setContextPath("/selenium-server");
        context.setMimeMapping("xhtml", "application/xhtml+xml");
        this.staticContentHandler = new StaticContentHandler(slowResources);
        String overrideJavascriptDir = System.getProperty("selenium.javascript.dir");
        if (overrideJavascriptDir != null) {
            this.staticContentHandler.addStaticContent(new FsResourceLocator(new File(overrideJavascriptDir)));
        }
        this.staticContentHandler.addStaticContent(new ClasspathResourceLocator());
        if (logOutFileName == null) {
            logOutFileName = System.getProperty("selenium.log.fileName");
        }
        if (logOutFileName != null) {
            SeleniumServer.setLogOut(logOutFileName);
        }
        context.addHandler(this.staticContentHandler);
        context.addHandler(new SingleTestSuiteResourceHandler());
        this.postResultsHandler = new SeleniumHTMLRunnerResultsHandler();
        context.addHandler(this.postResultsHandler);
        HttpContext driverContext = new HttpContext();
        driverContext.setContextPath("/selenium-server/driver");
        this.driver = new SeleniumDriverResourceHandler(this);
        context.addHandler(this.driver);
        this.server.addContext(context);
        this.server.addContext(driverContext);
    }

    private void configServer() {
        if (SeleniumServer.getForcedBrowserMode() == null) {
            if (null != System.getProperty("selenium.defaultBrowserString")) {
                System.err.println("The selenium.defaultBrowserString property is no longer supported; use selenium.forcedBrowserMode instead.");
                System.exit(-1);
            }
            SeleniumServer.setForcedBrowserMode(System.getProperty("selenium.forcedBrowserMode"));
        }
        if (!SeleniumServer.isProxyInjectionMode() && System.getProperty("selenium.proxyInjectionMode") != null) {
            this.setProxyInjectionMode("true".equals(System.getProperty("selenium.proxyInjectionMode")));
        }
        if (!SeleniumServer.isDebugMode() && System.getProperty("selenium.debugMode") != null) {
            SeleniumServer.setDebugMode("true".equals(System.getProperty("selenium.debugMode")));
        }
    }

    public SeleniumServer(int port) throws Exception {
        this(port, SeleniumServer.slowResourceProperty());
    }

    public SeleniumServer() throws Exception {
        this(SeleniumServer.getDefaultPort(), SeleniumServer.slowResourceProperty());
    }

    public static int getDefaultPort() {
        String portString = System.getProperty("selenium.port", "4444");
        return Integer.parseInt(portString);
    }

    public static File getFirefoxProfileTemplate() {
        return firefoxProfileTemplate;
    }

    private static boolean slowResourceProperty() {
        return "true".equals(System.getProperty("slowResources"));
    }

    public void addNewStaticContent(File directory) {
        this.staticContentHandler.addStaticContent(new FsResourceLocator(directory));
    }

    public void handleHTMLRunnerResults(HTMLResultsListener listener) {
        this.postResultsHandler.addListener(listener);
    }

    public void start() throws Exception {
        System.setProperty("org.mortbay.http.HttpRequest.maxFormContentSize", "0");
        this.server.start();
        this.shutDownHook = new Thread(new ShutDownHook(this));
        this.shutDownHook.setName("SeleniumServerShutDownHook");
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    public static boolean isForceProxyChain() {
        return FORCE_PROXY_CHAIN;
    }

    public static void setForceProxyChain(boolean force) {
        FORCE_PROXY_CHAIN = force;
    }

    public static void setCustomProxyHandler(ProxyHandler customProxyHandler) {
        SeleniumServer.customProxyHandler = customProxyHandler;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.driver.stopAllBrowsers();
            try {
                if (this.shutDownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isMultiWindow() {
        return this.multiWindow;
    }

    public Server getServer() {
        return this.server;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        return this.staticContentHandler.getResource(path).getInputStream();
    }

    public void registerBrowserLauncher(String sessionId, BrowserLauncher launcher) {
        this.driver.registerBrowserLauncher(sessionId, launcher);
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean debugMode) {
        SeleniumServer.debugMode = debugMode;
        if (debugMode) {
            SeleniumServer.log("Selenium server running in debug mode.");
            System.err.println("Standard error test.");
        }
    }

    public static boolean isProxyInjectionMode() {
        return proxyInjectionMode;
    }

    public static void setAlwaysProxy(boolean alwaysProxy) {
        SeleniumServer.alwaysProxy = alwaysProxy;
    }

    public static boolean isAlwaysProxy() {
        return alwaysProxy;
    }

    public static int getPortDriversShouldContact() {
        return portDriversShouldContact;
    }

    private static void setPortDriversShouldContact(int port) {
        portDriversShouldContact = port;
    }

    public void setProxyInjectionMode(boolean proxyInjectionMode) {
        if (proxyInjectionMode) {
            SeleniumServer.proxyInjectionSpeech();
        }
        SeleniumServer.proxyInjectionMode = proxyInjectionMode;
    }

    public static String getForcedBrowserMode() {
        return forcedBrowserMode;
    }

    public static int getTimeoutInSeconds() {
        return timeoutInSeconds;
    }

    public static void setForcedBrowserMode(String s) {
        forcedBrowserMode = s;
    }

    public static void setDontInjectRegex(String dontInjectRegex) {
        SeleniumServer.dontInjectRegex = dontInjectRegex;
    }

    public static boolean reusingBrowserSessions() {
        if (reusingBrowserSessions == null) {
            reusingBrowserSessions = Boolean.FALSE;
        }
        return reusingBrowserSessions;
    }

    public static boolean shouldInject(String path) {
        if (dontInjectRegex == null) {
            return true;
        }
        return !path.matches(dontInjectRegex);
    }

    public static String getDebugURL() {
        return debugURL;
    }

    private static String getRequiredSystemProperty(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            SeleniumServer.usage("expected property " + name + " to be defined");
            System.exit(1);
        }
        return value;
    }

    private static void runHtmlSuite(SeleniumServer seleniumProxy) {
        String result = null;
        try {
            String suiteFilePath = SeleniumServer.getRequiredSystemProperty("htmlSuite.suiteFilePath");
            File suiteFile = new File(suiteFilePath);
            if (!suiteFile.exists()) {
                SeleniumServer.usage("Can't find HTML Suite file:" + suiteFile.getAbsolutePath());
                System.exit(1);
            }
            seleniumProxy.addNewStaticContent(suiteFile.getParentFile());
            String startURL = SeleniumServer.getRequiredSystemProperty("htmlSuite.startURL");
            HTMLLauncher launcher = new HTMLLauncher(seleniumProxy);
            String resultFilePath = SeleniumServer.getRequiredSystemProperty("htmlSuite.resultFilePath");
            File resultFile = new File(resultFilePath);
            resultFile.createNewFile();
            if (!resultFile.canWrite()) {
                SeleniumServer.usage("can't write to result file " + resultFilePath);
                System.exit(1);
            }
            if (!"PASSED".equals(result = launcher.runHTMLSuite(SeleniumServer.getRequiredSystemProperty("htmlSuite.browserString"), startURL, suiteFile, resultFile, timeoutInSeconds, seleniumProxy.isMultiWindow()))) {
                System.err.println("Tests failed, see result file for details: " + resultFile.getAbsolutePath());
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.err.println("HTML suite exception seen:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void log(String logMessages) {
        PrintStream out;
        PrintStream printStream = out = logOut != null ? logOut : System.out;
        if (logMessages.endsWith("\n")) {
            out.print(logMessages);
        } else {
            out.println(logMessages);
        }
    }

    public static void setReusingBrowserSessions(boolean reusingBrowserSessions) {
        SeleniumServer.reusingBrowserSessions = reusingBrowserSessions;
    }

    static {
        debugURL = "";
        debugMode = false;
        alwaysProxy = false;
        proxyInjectionMode = false;
        firefoxProfileTemplate = null;
        portDriversShouldContact = 0;
        logOut = null;
        logOutFileName = null;
        forcedBrowserMode = null;
        timeoutInSeconds = 1800;
        reusingBrowserSessions = null;
        dontInjectRegex = null;
        FORCE_PROXY_CHAIN = false;
    }

    private class ShutDownHook
    implements Runnable {
        SeleniumServer selenium;

        ShutDownHook(SeleniumServer selenium) {
            this.selenium = selenium;
        }

        public void run() {
            System.out.println("Shutting down...");
            this.selenium.stop();
        }
    }
}

