/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.syntaxgraph.feature;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.value.AddressValue;
import org.maltparser.core.syntaxgraph.SyntaxGraphException;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.TokenNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DGraphAddressFunction
extends AddressFunction {
    private AddressFunction addressFunction;
    private String subFunctionName;
    private DGraphSubFunction subFunction;

    public DGraphAddressFunction(String subFunctionName) {
        this.setSubFunctionName(subFunctionName);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 1) {
            throw new SyntaxGraphException("Could not initialize NodeAddressFunction: number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof AddressFunction)) {
            throw new SyntaxGraphException("Could not initialize NodeAddressFunction: the second argument is not an addres function. ");
        }
        this.setAddressFunction((AddressFunction)arguments[0]);
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{AddressFunction.class};
        return paramTypes;
    }

    @Override
    public void update() throws MaltChainedException {
        AddressValue a = this.addressFunction.getAddressValue();
        if (a.getAddress() == null) {
            this.address.setAddress(null);
        } else {
            DependencyNode node = (DependencyNode)a.getAddress();
            if (this.subFunction == DGraphSubFunction.HEAD && !node.isRoot()) {
                this.address.setAddress(node.getHead());
            } else if (this.subFunction == DGraphSubFunction.LDEP) {
                this.address.setAddress(node.getLeftmostDependent());
            } else if (this.subFunction == DGraphSubFunction.RDEP) {
                this.address.setAddress(node.getRightmostDependent());
            } else if (this.subFunction == DGraphSubFunction.RDEP2) {
                if (!node.isRoot()) {
                    this.address.setAddress(node.getRightmostDependent());
                } else {
                    this.address.setAddress(null);
                }
            } else if (this.subFunction == DGraphSubFunction.LSIB) {
                this.address.setAddress(node.getSameSideLeftSibling());
            } else if (this.subFunction == DGraphSubFunction.RSIB) {
                this.address.setAddress(node.getSameSideRightSibling());
            } else if (node instanceof TokenNode && this.subFunction == DGraphSubFunction.PRED) {
                this.address.setAddress(((TokenNode)node).getPredecessor());
            } else if (node instanceof TokenNode && this.subFunction == DGraphSubFunction.SUCC) {
                this.address.setAddress(((TokenNode)node).getSuccessor());
            } else if (this.subFunction == DGraphSubFunction.ANC) {
                this.address.setAddress(node.getAncestor());
            } else if (this.subFunction == DGraphSubFunction.PANC) {
                this.address.setAddress(node.getProperAncestor());
            } else if (this.subFunction == DGraphSubFunction.LDESC) {
                this.address.setAddress(node.getLeftmostDescendant());
            } else if (this.subFunction == DGraphSubFunction.PLDESC) {
                this.address.setAddress(node.getLeftmostProperDescendant());
            } else if (this.subFunction == DGraphSubFunction.RDESC) {
                this.address.setAddress(node.getRightmostDescendant());
            } else if (this.subFunction == DGraphSubFunction.PRDESC) {
                this.address.setAddress(node.getRightmostProperDescendant());
            } else {
                this.address.setAddress(null);
            }
        }
    }

    @Override
    public void update(Object[] arguments) throws MaltChainedException {
        this.update();
    }

    public AddressFunction getAddressFunction() {
        return this.addressFunction;
    }

    public void setAddressFunction(AddressFunction addressFunction) {
        this.addressFunction = addressFunction;
    }

    public String getSubFunctionName() {
        return this.subFunctionName;
    }

    public void setSubFunctionName(String subFunctionName) {
        this.subFunctionName = subFunctionName;
        this.subFunction = DGraphSubFunction.valueOf(subFunctionName.toUpperCase());
    }

    public DGraphSubFunction getSubFunction() {
        return this.subFunction;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!this.addressFunction.equals(((DGraphAddressFunction)obj).getAddressFunction())) {
            return false;
        }
        return this.subFunction.equals((Object)((DGraphAddressFunction)obj).getSubFunction());
    }

    @Override
    public String toString() {
        return this.subFunctionName + "(" + this.addressFunction.toString() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DGraphSubFunction {
        HEAD,
        LDEP,
        RDEP,
        RDEP2,
        LSIB,
        RSIB,
        PRED,
        SUCC,
        ANC,
        PANC,
        LDESC,
        PLDESC,
        RDESC,
        PRDESC;

    }
}

