/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collections;
import org.apache.sis.internal.metadata.RecordSchemaSIS;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.quality.DefaultAbsoluteExternalPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultQuantitativeResult;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.DefaultRecord;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.util.InternationalString;
import org.opengis.util.RecordType;

public final class TransformationAccuracy
extends Static {
    private static final InternationalString TRANSFORMATION_ACCURACY = Vocabulary.formatInternational((short)103);
    private static final RecordType TYPE = RecordSchemaSIS.INSTANCE.createRecordType("Real", Collections.singletonMap(Vocabulary.formatInternational((short)111), Double.class));
    private static final WeakValueHashMap<Double, PositionalAccuracy> CACHE = new WeakValueHashMap(Double.class);

    private TransformationAccuracy() {
    }

    public static PositionalAccuracy create(Double d) {
        PositionalAccuracy positionalAccuracy = CACHE.get(d);
        if (positionalAccuracy == null) {
            DefaultRecord defaultRecord = new DefaultRecord(TYPE);
            defaultRecord.setAll(d);
            DefaultQuantitativeResult defaultQuantitativeResult = new DefaultQuantitativeResult();
            defaultQuantitativeResult.setValues(Collections.singletonList(defaultRecord));
            defaultQuantitativeResult.setValueUnit(Units.METRE);
            defaultQuantitativeResult.setValueType(TYPE);
            DefaultAbsoluteExternalPositionalAccuracy defaultAbsoluteExternalPositionalAccuracy = new DefaultAbsoluteExternalPositionalAccuracy(defaultQuantitativeResult);
            defaultAbsoluteExternalPositionalAccuracy.setNamesOfMeasure(Collections.singleton(TRANSFORMATION_ACCURACY));
            defaultAbsoluteExternalPositionalAccuracy.setEvaluationMethodType(EvaluationMethodType.DIRECT_EXTERNAL);
            defaultAbsoluteExternalPositionalAccuracy.freeze();
            positionalAccuracy = CACHE.putIfAbsent(d, defaultAbsoluteExternalPositionalAccuracy);
            if (positionalAccuracy == null) {
                positionalAccuracy = defaultAbsoluteExternalPositionalAccuracy;
            }
        }
        return positionalAccuracy;
    }
}

