#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Fixup includes.
#   - Move to uuconfig.h.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrcP/uuid/copy.c	Sun Jan 14 15:29:17 2024
+++ ulib/uuid/copy.c	Sun Jan 14 15:44:23 2024
@@ -32,8 +32,8 @@
  * %End-Header%
  */
 
-#include "config.h"
-#include "uuidP.h"
+#include "uuconfig.h"
+#include "uuid/uuidP.h"
 
 void myuuid_copy(myuuid_t dst, const myuuid_t src)
 {

