use strict; use warnings;
BEGIN {
  unless(eval q{ use 5.008; 1}) {
    print "Perl 5.008 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.21.
use strict;
use warnings;

use 5.008;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "WebSocket client for AnyEvent",
  "AUTHOR" => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "AnyEvent-WebSocket-Client",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008",
  "NAME" => "AnyEvent::WebSocket::Client",
  "PM" => {
    "lib/AnyEvent/WebSocket/Client.pm" => "\$(INST_LIB)/AnyEvent/WebSocket/Client.pm",
    "lib/AnyEvent/WebSocket/Connection.pm" => "\$(INST_LIB)/AnyEvent/WebSocket/Connection.pm",
    "lib/AnyEvent/WebSocket/Message.pm" => "\$(INST_LIB)/AnyEvent/WebSocket/Message.pm"
  },
  "PREREQ_PM" => {
    "AnyEvent" => "7.13",
    "Moo" => "2.0",
    "PerlX::Maybe" => "0.003",
    "Protocol::WebSocket" => "0.20",
    "URI" => "1.53",
    "URI::ws" => 0
  },
  "TEST_REQUIRES" => {
    "Protocol::WebSocket" => "0.20",
    "Test2::API" => "1.302015",
    "Test2::Require" => "0.000060",
    "Test2::Require::Module" => "0.000060",
    "Test2::V0" => "0.000060"
  },
  "VERSION" => "0.41",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "AnyEvent" => "7.13",
  "Moo" => "2.0",
  "PerlX::Maybe" => "0.003",
  "Protocol::WebSocket" => "0.20",
  "Test2::API" => "1.302015",
  "Test2::Require" => "0.000060",
  "Test2::Require::Module" => "0.000060",
  "Test2::V0" => "0.000060",
  "URI" => "1.53",
  "URI::ws" => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.033
if (can_use('Crypt::Random::Source')) {
requires('Crypt::Random::Source', '0.08')
}



unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.033
sub _add_prereq {
  my ($mm_key, $module, $version_or_range) = @_;
  $version_or_range ||= 0;
  warn "$module already exists in $mm_key (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $WriteMakefileArgs{$mm_key}{$module}
      and $WriteMakefileArgs{$mm_key}{$module} ne '0'
      and $WriteMakefileArgs{$mm_key}{$module} ne $version_or_range;
  warn "$module already exists in FallbackPrereqs (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $FallbackPrereqs{$module} and $FallbackPrereqs{$module} ne '0'
        and $FallbackPrereqs{$module} ne $version_or_range;
  $WriteMakefileArgs{$mm_key}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub can_use {
  my ($module, $version) = @_;
  return 0 if not eval "require $module; 1";
  return 1 if not defined $version or eval "$module->VERSION($version); 1";
  return 0;
}

sub requires { goto &runtime_requires }

sub runtime_requires {
  my ($module, $version_or_range) = @_;
  _add_prereq(PREREQ_PM => $module, $version_or_range);
}
