#!/usr/bin/env perl

use v5.14;
use warnings FATAL => qw(all);

package Term::Table2;

use Test2::V0 -target => 'Term::Table2';
use Test2::Mock;

my @header;
my $mockThis = Test2::Mock->new(
  class    => $CLASS,
  override => [
    _maxColumnWidth => sub { return 1 },
    _prepareRow     => sub { return \@header },
    _setLineFormat  => sub { return },
  ]
);
my $table = bless(
  {
    'columnWidth' => [0, 0, 2],
    'pad'         => 1,
    'pageHeight'  => 9,
    'tableWidth'  => 5,
  },
  $CLASS,
);

subtest 'Success' => sub {
  my $expected;

  @header                     = ('line');
  $table->{'broadRow'}        = WRAP;
  $table->{':separatingLine'} = '+-----+';
  $expected                   = {
    ':headerLines'    => ['+-----+', 'line', '+-----+'],
    ':linesPerPage'   => 8,
    ':linesPerRow'    => 2,
    ':separatingLine' => '+-----+',
    'broadRow'        => WRAP,
    'columnWidth'     => [1, 1, 2],
    'currentRow'      => 0,
    'pad'             => [1, 1, 1],
    'pageHeight'      => 9,
    'tableWidth'      => 5,
  };
  is($table->_init(), $expected, 'Wrapped rows, header exists');

  @header                     = ();
  $table->{'broadRow'}        = CUT;
  $table->{':separatingLine'} = '+---+';
  delete($table->{'pageHeight'});
  delete($table->{'tableWidth'});
  $expected                   = {
    ':headerLines'    => [],
    ':linesPerPage'   => BIG_INT + 1,
    ':linesPerRow'    => 1,
    ':separatingLine' => '+---+',
    'broadRow'        => CUT,
    'columnWidth'     => [1, 1, 2],
    'currentRow'      => 0,
    'pad'             => [1, 1, 1],
    'pageHeight'      => BIG_INT,
    'tableWidth'      => BIG_INT,
  };
  is($table->_init(), $expected, 'Unwrapped rows, no header');
};

subtest 'Failure' => sub {
  $table->{'pageHeight'}      = 9;
  $table->{'tableWidth'}      = 5;

  $table->{'pad'}             = [4, 4, 4];
  like(dies{$table->_init()}, qr/is lower than the width of the narrowest possible column/, 'Table is not wide enough');

  @header                     = ('line');
  $table->{'broadRow'}        = WRAP;
  $table->{'pad'}             = [1, 1, 1];
  $table->{'pageHeight'}      = 1;
  $table->{':separatingLine'} = '+-----+';
  like(dies{$table->_init()}, qr/is lower than the minimum possible page height/, 'Page is not high enough');
};

done_testing();