#| -*-Scheme-*-

$Header: /scheme/users/cph/src/compiler/etc/RCS/comcmp.scm,v 1.3 1991/11/04 20:36:02 cph Exp $

Copyright (c) 1989-91 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Compiled code binary comparison program

(declare (usual-integrations))

(if (unassigned? compiled-code-block/bytes-per-object)
    (set! compiled-code-block/bytes-per-object 4))

(define comcmp:ignore-debugging-info? true)

(define (compare-com-files f1 f2 #!optional verbose?)
  (let ((quiet? (or (default-object? verbose?) (not verbose?)))
	(memoizations '()))

    (define (compare-blocks b1 b2)
      (memoize! b1 b2
	(lambda ()
	  (let ((l1 (system-vector-length b1))
		(l2 (system-vector-length b2)))
	    (if (not (= l1 l2))
		`(length ,l1 ,l2)
		(or (compare-code-sections b1 b2)
		    (compare-constant-sections b1 b2)))))))

    (define (memoize! b1 b2 do-it)
      (let ((entry (assq b1 memoizations))
	    (if-not-found
	     (lambda ()
	       (let ((result (do-it)))
		 (let ((entry (assq b1 memoizations)))
		   (if entry
		       (let ((entry* (assq b2 (cdr entry))))
			 (if entry*
			     (set-cdr! entry* result)
			     (set-cdr! entry
				       (cons (cons b2 result) (cdr entry)))))
		       (set! memoizations
			     (cons (list b1 (cons b2 result))
				   memoizations))))
		 result))))
	(if entry
	    (let ((entry (assq b2 (cdr entry))))
	      (if entry
		  (cdr entry)
		  (if-not-found)))
	    (if-not-found))))

    (define (compare-code-sections b1 b2)
      (let ((s1 (compiled-code-block/code-start b1))
	    (s2 (compiled-code-block/code-start b2))
	    (e1 (compiled-code-block/code-end b1))
	    (e2 (compiled-code-block/code-end b2)))
	(cond ((not (= s1 s2))
	       `(code-start ,s1 ,s2))
	      ((not (= e1 e2))
	       `(code-end ,e1 ,e2))
	      ((not (bit-string=? (read-code b1 s1 e1)
				  (read-code b2 s2 e2)))
	       `(code))
	      (else
	       false))))

    (define (read-code b s e)
      (let ((bs (bit-string-allocate (* addressing-granularity (- e s)))))
	(read-bits! b (* addressing-granularity s) bs)
	bs))

    (define addressing-granularity 8)

    (define (compare-constant-sections b1 b2)
      ;; Kludge!
      (if comcmp:ignore-debugging-info?
	  (begin
	    (set-compiled-code-block/debugging-info! b1 '())
	    (set-compiled-code-block/debugging-info! b2 '())))

      (let ((s1 (compiled-code-block/constants-start b1))
	    (s2 (compiled-code-block/constants-start b2))
	    (e1 (compiled-code-block/constants-end b1))
	    (e2 (compiled-code-block/constants-end b2)))
	(cond ((not (= s1 s2))
	       `(constant-start ,s1 ,s2))
	      ((not (= e1 e2))
	       `(constant-end ,e1 ,e2))
	      (else
	       (let loop ((s s1) (e e1) (diffs '()))
		 (cond ((<= s e)
			(let ((diff
			       (compare-constants
				s
				(system-vector-ref b1 s)
				(system-vector-ref b2 s))))
			  (cond ((not diff)
				 (loop (1+ s) e diffs))
				((eq? (car diff) 'CONSTANTS)
				 (loop (1+ s)
				       e
				       (if (member (cadr diff) diffs)
					   diffs
					   (cons (cadr diff) diffs))))
				(else
				 diff))))
		       ((null? diffs)
			false)
		       (else
			(cons 'CONSTANTS (reverse! diffs)))))))))

    (define (compare-constants s c1 c2)
      (and (not (equal? c1 c2))
	   (let ((differ
		  (lambda ()
		    `(CONSTANTS (,s ,c1 ,c2)))))
	     (cond ((compiled-code-block? c1)
		    (if (compiled-code-block? c2)
			(compare-blocks c1 c2)
			(differ)))
		   ((compiled-code-address? c1)
		    (if (and (compiled-code-address? c2)
			     (= (compiled-entry/offset c1)
				(compiled-entry/offset c2)))
			(compare-blocks (compiled-entry/block c1)
					(compiled-entry/block c2))
			(differ)))
		   ((quotation? c1)
		    (if (quotation? c2)
			(compare-constants s
					   (quotation-expression c1)
					   (quotation-expression c2))
			(differ)))
		   ((lambda? c1)
		    (if (lambda? c2)
			(lambda-components c1
			  (lambda (name required optional rest auxiliary
					declarations body)
			    (lambda-components c1
			      (lambda (name* required* optional* rest*
					     auxiliary* declarations* body*)
				(if (and (eqv? name name*)
					 (equal? required required*)
					 (equal? optional optional*)
					 (eqv? rest rest*)
					 (equal? auxiliary auxiliary*)
					 (equal? declarations declarations*))
				    (compare-constants s body body*)
				    (differ))))))
			(differ)))
		   (else
		    (differ))))))

    (let ((s1 (fasload f1 quiet?))
	  (s2 (fasload f2 quiet?))
	  (dbg-info-vector?
	   (access dbg-info-vector?
		   (->environment '(RUNTIME COMPILER-INFO))))
	  (dbg-info-vector/blocks-vector
	   (access dbg-info-vector/blocks-vector
		   (->environment '(RUNTIME COMPILER-INFO)))))
      (if (and (comment? s1) (dbg-info-vector? (comment-text s1)))
	  (if (and (comment? s2) (dbg-info-vector? (comment-text s2)))
	      (let ((v1 (dbg-info-vector/blocks-vector (comment-text s1)))
		    (v2 (dbg-info-vector/blocks-vector (comment-text s2))))
		(let ((e1 (vector-length v1))
		      (e2 (vector-length v2)))
		  (if (= e1 e2)
		      (compare-blocks (vector-ref v1 0) (vector-ref v2 0))
		      `(number-of-blocks ,e1 ,e2))))
	      '(block-structure))
	  (if (and (comment? s2) (dbg-info-vector? (comment-text s2)))
	      '(block-structure)
	      (compare-blocks (compiled-code-address->block s1)
			      (compiled-code-address->block s2)))))))

(define (show-differences f1 f2)
  (define (->name f)
    (enough-namestring (merge-pathnames f)))

  (let ((result (compare-com-files f1 f2)))
    (if (pair? result)
	(begin
	  (newline)
	  (for-each display
		    (list "*** Files " (->name f1)
			  " and " (->name f2)
			  " differ: "))
	  (if (eq? 'CONSTANTS (car result))
	      (begin
		(display "***")
		(newline)
		(display "(constants")
		(for-each (lambda (c)
			    (newline)
			    (display "  ")
			    (write c))
			  (cdr result))
		(display ")"))
	      (begin
		(write result)
		(display " ***")))))))