	
.386
.model tiny
	.data
	extrn _Free:dword
	extrn _Ext_Stack_Pointer:dword
	extrn _utility_table:dword
	public _C_Stack_Segment
_C_Stack_Segment dd 0
	public _C_Stack_Pointer
_C_Stack_Pointer dd 0
	public _C_Frame_Pointer
_C_Frame_Pointer dd 0
	public _i387_presence
_i387_presence dd 0
	extrn _Registers:dword
	.code
	public _i386_interface_initialize
_i386_interface_initialize:
	push	ebp
	mov	ebp,esp
	xor	eax,eax		; No 387 available
	
	smsw		cx
	mov	edx,012H
	and	ecx,edx
	cmp	ecx,edx
	jne	i386_initialize_no_fp
	inc	eax			; 387 available
	sub	esp,4
	fclex
	fnstcw	word ptr -2[ebp]
	; On Unix, set rounding mode to round-to-even, precision control to
	; double, mask the inexact result exception, and unmask the other exceptions.
	; On DOS, set rounding mode to round-to-even, precision control to
	; double and and mask all exceptions.
	and	word ptr -2[ebp],0f0e0H
	or	word ptr -2[ebp],0023fH
	fldcw	word ptr -2[ebp]
i386_initialize_no_fp:
	mov	_i387_presence,eax
	leave
	ret
	public _C_to_interface
_C_to_interface:
	push	ebp			; Link according
	mov	ebp,esp		;  to C's conventions
	push	edi			; Save callee-saves
	push	esi			;  registers
	push	ebx
	mov	edx,dword ptr 8[ebp]	; Entry point
							; Preserve frame ptr
	mov	_C_Frame_Pointer,ebp
							; Preserve stack ptr
	mov	_C_Stack_Pointer,esp
							; Register block = %esi
	mov	ax,ss		; Obtain stack segment
							; and preserve it
	mov	_C_Stack_Segment,eax
	lea	esi,dword ptr _Registers
	jmp	_interface_to_scheme
	public _asm_trampoline_to_interface
_asm_trampoline_to_interface:
	public trampoline_to_interface
trampoline_to_interface:
	pop	ecx			; trampoline storage
	jmp	scheme_to_interface
	public _asm_scheme_to_interface_call
_asm_scheme_to_interface_call:
	public scheme_to_interface_call
scheme_to_interface_call:
	pop	ecx			; arg1 = ret. add
	add	ecx,4		; Skip format info
	public _asm_scheme_to_interface
_asm_scheme_to_interface:
	public scheme_to_interface
scheme_to_interface:
	mov	_Ext_Stack_Pointer,esp
	mov	_Free,edi
	mov	edi,_C_Stack_Segment ; Swap stack segments
	mov	ss,di
	mov	esp,_C_Stack_Pointer
	mov	ebp,_C_Frame_Pointer
	push	dword ptr 36[esi] ; Utility args
	push	ebx
	push	edx
	push	ecx
	xor	ecx,ecx
	mov	cl,al
	mov	eax,dword ptr _utility_table[ecx*4]
	call	eax
	public scheme_to_interface_return
scheme_to_interface_return:
	add	esp,16		; Pop utility args
	mov	edx,dword ptr 4[eax]
	mov	eax,dword ptr [eax]
	jmp	eax				; Invoke handler
	public _interface_to_scheme
_interface_to_scheme:
	mov	edi,_Free		; Free pointer = %edi
							; Value/dynamic link
	mov	eax,dword ptr 8[esi]
	mov	ebp,67108863	; = %ebp
	mov	esp,_Ext_Stack_Pointer
	mov	bx,ds		; Swap stack segments
	mov	ss,bx
	mov	ecx,eax		; Preserve if used
	and	ecx,ebp		; Restore potential
							;  dynamic link
	mov	dword ptr 16[esi],ecx
	jmp	edx
	public _interface_to_C
_interface_to_C:
	cmp	_i387_presence,0
	je	interface_to_C_proceed
	ffree	st(0)					; Free floating "regs"
	ffree	st(1)
	ffree	st(2)
	ffree	st(3)
	ffree	st(4)
	ffree	st(5)
	ffree	st(6)
interface_to_C_proceed:
	mov	eax,edx		; Set up result
	pop	ebx			; Restore callee-saves
	pop	esi			;  registers
	pop	edi
	leave
	ret
	
	
	public _asm_interrupt_procedure
_asm_interrupt_procedure:
	mov	al,01aH
	jmp	scheme_to_interface_call
	public _asm_interrupt_continuation
_asm_interrupt_continuation:
	mov	al,01bH
	jmp	scheme_to_interface_call
	public _asm_interrupt_closure
_asm_interrupt_closure:
	mov	al,018H
	jmp	scheme_to_interface
	public _asm_interrupt_dlink
_asm_interrupt_dlink:
	mov	edx,dword ptr 16[esi]
	mov	al,019H
	jmp	scheme_to_interface_call
	public _asm_short_primitive_apply
_asm_short_primitive_apply:
	pop	edx			; offset pointer
	mov	ecx,dword ptr [edx]	; offset
							; Primitive object
	mov	ecx,dword ptr [edx] [ecx]
							; Merge
	jmp	_asm_primitive_apply
	public _asm_primitive_apply
_asm_primitive_apply:
	mov	al,012H
	jmp	scheme_to_interface
	public _asm_primitive_lexpr_apply
_asm_primitive_lexpr_apply:
	mov	al,013H
	jmp	scheme_to_interface
	public _asm_error
_asm_error:
	mov	al,015H
	jmp	scheme_to_interface
	public _asm_link
_asm_link:
	mov	al,017H
	jmp	scheme_to_interface_call
	public _asm_assignment_trap
_asm_assignment_trap:
	mov	al,01dH
	jmp	scheme_to_interface_call
	public _asm_reference_trap
_asm_reference_trap:
	mov	al,01fH
	jmp	scheme_to_interface_call
	public _asm_safe_reference_trap
_asm_safe_reference_trap:
	mov	al,020H
	jmp	scheme_to_interface_call
	public _asm_primitive_error
_asm_primitive_error:
	mov	al,036H
	jmp	scheme_to_interface_call
	public _asm_sc_apply
_asm_sc_apply:
	mov	eax,ecx		; Copy for type code
	mov	ebx,ecx		; Copy for address
	shr	eax,26	; Select type code
	and	ebx,ebp		; Select datum
	cmp	al,40
	jne	asm_sc_apply_generic
	movsx	eax,byte ptr -4[ebx]	; Extract frame size
	cmp	edx,eax		; Compare to nargs+1
	jne	asm_sc_apply_generic
	jmp	ebx				; Invoke
	public asm_sc_apply_generic
asm_sc_apply_generic:
	mov	eax,014H
	jmp	scheme_to_interface	
	public _asm_sc_apply_size_1
_asm_sc_apply_size_1:
	mov	eax,ecx		; Copy for type code
	mov	ebx,ecx		; Copy for address
	shr	eax,26	; Select type code
	and	ebx,ebp		; Select datum
	cmp	al,40
	jne	asm_sc_apply_generic_1
	cmp	byte ptr -4[ebx],1	; Compare frame size
	jne	asm_sc_apply_generic_1	; to nargs+1
	jmp	ebx
asm_sc_apply_generic_1:
	mov	edx,1
	mov	al,014H
	jmp	scheme_to_interface
	public _asm_sc_apply_size_2
_asm_sc_apply_size_2:
	mov	eax,ecx		; Copy for type code
	mov	ebx,ecx		; Copy for address
	shr	eax,26	; Select type code
	and	ebx,ebp		; Select datum
	cmp	al,40
	jne	asm_sc_apply_generic_2
	cmp	byte ptr -4[ebx],2	; Compare frame size
	jne	asm_sc_apply_generic_2	; to nargs+1
	jmp	ebx
asm_sc_apply_generic_2:
	mov	edx,2
	mov	al,014H
	jmp	scheme_to_interface
	public _asm_sc_apply_size_3
_asm_sc_apply_size_3:
	mov	eax,ecx		; Copy for type code
	mov	ebx,ecx		; Copy for address
	shr	eax,26	; Select type code
	and	ebx,ebp		; Select datum
	cmp	al,40
	jne	asm_sc_apply_generic_3
	cmp	byte ptr -4[ebx],3	; Compare frame size
	jne	asm_sc_apply_generic_3	; to nargs+1
	jmp	ebx
asm_sc_apply_generic_3:
	mov	edx,3
	mov	al,014H
	jmp	scheme_to_interface
	public _asm_sc_apply_size_4
_asm_sc_apply_size_4:
	mov	eax,ecx		; Copy for type code
	mov	ebx,ecx		; Copy for address
	shr	eax,26	; Select type code
	and	ebx,ebp		; Select datum
	cmp	al,40
	jne	asm_sc_apply_generic_4
	cmp	byte ptr -4[ebx],4	; Compare frame size
	jne	asm_sc_apply_generic_4	; to nargs+1
	jmp	ebx
asm_sc_apply_generic_4:
	mov	edx,4
	mov	al,014H
	jmp	scheme_to_interface
	public _asm_sc_apply_size_5
_asm_sc_apply_size_5:
	mov	eax,ecx		; Copy for type code
	mov	ebx,ecx		; Copy for address
	shr	eax,26	; Select type code
	and	ebx,ebp		; Select datum
	cmp	al,40
	jne	asm_sc_apply_generic_5
	cmp	byte ptr -4[ebx],5	; Compare frame size
	jne	asm_sc_apply_generic_5	; to nargs+1
	jmp	ebx
asm_sc_apply_generic_5:
	mov	edx,5
	mov	al,014H
	jmp	scheme_to_interface
	public _asm_sc_apply_size_6
_asm_sc_apply_size_6:
	mov	eax,ecx		; Copy for type code
	mov	ebx,ecx		; Copy for address
	shr	eax,26	; Select type code
	and	ebx,ebp		; Select datum
	cmp	al,40
	jne	asm_sc_apply_generic_6
	cmp	byte ptr -4[ebx],6	; Compare frame size
	jne	asm_sc_apply_generic_6	; to nargs+1
	jmp	ebx
asm_sc_apply_generic_6:
	mov	edx,6
	mov	al,014H
	jmp	scheme_to_interface
	public _asm_sc_apply_size_7
_asm_sc_apply_size_7:
	mov	eax,ecx		; Copy for type code
	mov	ebx,ecx		; Copy for address
	shr	eax,26	; Select type code
	and	ebx,ebp		; Select datum
	cmp	al,40
	jne	asm_sc_apply_generic_7
	cmp	byte ptr -4[ebx],7	; Compare frame size
	jne	asm_sc_apply_generic_7	; to nargs+1
	jmp	ebx
asm_sc_apply_generic_7:
	mov	edx,7
	mov	al,014H
	jmp	scheme_to_interface
	public _asm_sc_apply_size_8
_asm_sc_apply_size_8:
	mov	eax,ecx		; Copy for type code
	mov	ebx,ecx		; Copy for address
	shr	eax,26	; Select type code
	and	ebx,ebp		; Select datum
	cmp	al,40
	jne	asm_sc_apply_generic_8
	cmp	byte ptr -4[ebx],8	; Compare frame size
	jne	asm_sc_apply_generic_8	; to nargs+1
	jmp	ebx
asm_sc_apply_generic_8:
	mov	edx,8
	mov	al,014H
	jmp	scheme_to_interface
asm_generic_flonum_result:
	mov	dword ptr [edi],-1677721598
	mov	eax,edi
	fstp	qword ptr 4[edi]			; fstpd
	or	eax,402653184
	and	dword ptr [esp],ebp
	add	edi,12
	mov	dword ptr 8[esi],eax
	ret
asm_generic_fixnum_result:
	and	dword ptr [esp],ebp
	or	al,26
	ror	eax,6
	mov	dword ptr 8[esi],eax
	ret
asm_generic_return_sharp_t:
	and	dword ptr [esp],ebp
	mov	dword ptr 8[esi],536870912
	ret
asm_generic_return_sharp_f:
	and	dword ptr [esp],ebp
	mov	dword ptr 8[esi],0
	ret
	public _asm_generic_divide
_asm_generic_divide:
	pop	edx
	pop	ebx
	mov	eax,edx
	mov	ecx,ebx
	shr	eax,26
	shr	ecx,26
	cmp	al,26
	je	asm_generic_divide_fix
	cmp	al,6
	jne	asm_generic_divide_fail
	cmp	cl,6
	je	asm_generic_divide_flo_flo
	cmp	cl,26
	jne	asm_generic_divide_fail
	mov	ecx,ebx
	shl	ecx,6
	je	asm_generic_divide_fail
	and	edx,ebp
	sar	ecx,6
	fld	qword ptr 4[edx]			; fldd
	mov	dword ptr [edi],ecx
	fidiv	dword ptr [edi]
	jmp	asm_generic_flonum_result
asm_generic_divide_fix:
	cmp	cl,6
	jne	asm_generic_divide_fail
	mov	ecx,edx
	shl	ecx,6
	je	asm_generic_divide_fail
	and	ebx,ebp
	sar	ecx,6
	fld	qword ptr 4[ebx]			; fldd
	mov	dword ptr [edi],ecx
	fidivr	dword ptr [edi]
	jmp	asm_generic_flonum_result
asm_generic_divide_flo_flo:
	mov	ecx,ebx
	and	ecx,ebp
	fld	qword ptr 4[ecx]			; fldd
	ftst
	fstsw	ax
	sahf
	je	asm_generic_divide_by_zero
	and	edx,ebp
	fdivr	qword ptr 4[edx]
	jmp	asm_generic_flonum_result	
asm_generic_divide_by_zero:
	fstp	st(0)					; Pop second arg
asm_generic_divide_fail:
	push	ebx
	push	edx
	mov	al,023H
	jmp	scheme_to_interface
	public _asm_generic_decrement
_asm_generic_decrement:
	pop	edx
	mov	eax,edx
	shr	eax,26
	cmp	al,26
	je	asm_generic_decrement_fix
	cmp	al,6
	jne	asm_generic_decrement_fail
	and	edx,ebp
	fld1
	fsubr	qword ptr 4[edx]
	jmp	asm_generic_flonum_result
asm_generic_decrement_fix:
	mov	eax,edx
	shl	eax,6
	sub	eax,64
	jno	asm_generic_fixnum_result
asm_generic_decrement_fail:
	push	edx
	mov	al,022H
	jmp	scheme_to_interface
	public _asm_generic_increment
_asm_generic_increment:
	pop	edx
	mov	eax,edx
	shr	eax,26
	cmp	al,26
	je	asm_generic_increment_fix
	cmp	al,6
	jne	asm_generic_increment_fail
	and	edx,ebp
	fld1
	fadd	qword ptr 4[edx]
	jmp	asm_generic_flonum_result
asm_generic_increment_fix:
	mov	eax,edx
	shl	eax,6
	add	eax,64
	jno	asm_generic_fixnum_result
asm_generic_increment_fail:
	push	edx
	mov	al,026H
	jmp	scheme_to_interface
	public _asm_generic_negative
_asm_generic_negative:
	pop	edx
	mov	eax,edx
	shr	eax,26
	cmp	al,26
	je	asm_generic_negative_fix
	cmp	al,6
	jne	asm_generic_negative_fail
	and	edx,ebp
	fld	qword ptr 4[edx]
	ftst
	fstsw	ax
	fstp	st(0)
	sahf
	jb	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_negative_fix:
	mov	eax,edx
	shl	eax,6
	cmp	eax,0
	jl	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_negative_fail:
	push	edx
	mov	al,02aH
	jmp	scheme_to_interface
	public _asm_generic_positive
_asm_generic_positive:
	pop	edx
	mov	eax,edx
	shr	eax,26
	cmp	al,26
	je	asm_generic_positive_fix
	cmp	al,6
	jne	asm_generic_positive_fail
	and	edx,ebp
	fld	qword ptr 4[edx]
	ftst
	fstsw	ax
	fstp	st(0)
	sahf
	ja	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_positive_fix:
	mov	eax,edx
	shl	eax,6
	cmp	eax,0
	jg	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_positive_fail:
	push	edx
	mov	al,02cH
	jmp	scheme_to_interface
	public _asm_generic_zero
_asm_generic_zero:
	pop	edx
	mov	eax,edx
	shr	eax,26
	cmp	al,26
	je	asm_generic_zero_fix
	cmp	al,6
	jne	asm_generic_zero_fail
	and	edx,ebp
	fld	qword ptr 4[edx]
	ftst
	fstsw	ax
	fstp	st(0)
	sahf
	je	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_zero_fix:
	mov	eax,edx
	shl	eax,6
	cmp	eax,0
	je	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_zero_fail:
	push	edx
	mov	al,02dH
	jmp	scheme_to_interface
	public _asm_generic_add
_asm_generic_add:
	pop	edx
	pop	ebx
	mov	eax,edx
	mov	ecx,ebx
	shr	eax,26
	shr	ecx,26
	cmp	al,26
	je	asm_generic_add_fix
	cmp	al,6
	jne	asm_generic_add_fail
	cmp	cl,6
	je	asm_generic_add_flo_flo
	cmp	cl,26
	jne	asm_generic_add_fail
	shl	ebx,6
	and	edx,ebp
	sar	ebx,6
	fld	qword ptr 4[edx]			; fldd
	mov	dword ptr [edi],ebx
	fiadd	dword ptr [edi]				; fisubl
	jmp	asm_generic_flonum_result
asm_generic_add_fix:
	cmp	cl,6
	je	asm_generic_add_fix_flo
	cmp	cl,26
	jne	asm_generic_add_fail
	mov	eax,edx
	mov	ecx,ebx
	shl	eax,6
	shl	ecx,6
	add	eax,ecx		; subl
	jno	asm_generic_fixnum_result
asm_generic_add_fail:
	push	ebx
	push	edx
	mov	al,02bH
	jmp	scheme_to_interface
asm_generic_add_flo_flo:
	and	edx,ebp
	and	ebx,ebp
	fld	qword ptr 4[edx]			; fldd
	fadd	qword ptr 4[ebx]			; fsubl
	jmp	asm_generic_flonum_result	
asm_generic_add_fix_flo:
	shl	edx,6
	and	ebx,ebp
	sar	edx,6
	fld	qword ptr 4[ebx]			; fldd
	mov	dword ptr [edi],edx
	fiadd	dword ptr [edi]			; fisubrl
	jmp	asm_generic_flonum_result
	public _asm_generic_subtract
_asm_generic_subtract:
	pop	edx
	pop	ebx
	mov	eax,edx
	mov	ecx,ebx
	shr	eax,26
	shr	ecx,26
	cmp	al,26
	je	asm_generic_subtract_fix
	cmp	al,6
	jne	asm_generic_subtract_fail
	cmp	cl,6
	je	asm_generic_subtract_flo_flo
	cmp	cl,26
	jne	asm_generic_subtract_fail
	shl	ebx,6
	and	edx,ebp
	sar	ebx,6
	fld	qword ptr 4[edx]			; fldd
	mov	dword ptr [edi],ebx
	fisub	dword ptr [edi]				; fisubl
	jmp	asm_generic_flonum_result
asm_generic_subtract_fix:
	cmp	cl,6
	je	asm_generic_subtract_fix_flo
	cmp	cl,26
	jne	asm_generic_subtract_fail
	mov	eax,edx
	mov	ecx,ebx
	shl	eax,6
	shl	ecx,6
	sub	eax,ecx		; subl
	jno	asm_generic_fixnum_result
asm_generic_subtract_fail:
	push	ebx
	push	edx
	mov	al,028H
	jmp	scheme_to_interface
asm_generic_subtract_flo_flo:
	and	edx,ebp
	and	ebx,ebp
	fld	qword ptr 4[edx]			; fldd
	fsub	qword ptr 4[ebx]			; fsubl
	jmp	asm_generic_flonum_result	
asm_generic_subtract_fix_flo:
	shl	edx,6
	and	ebx,ebp
	sar	edx,6
	fld	qword ptr 4[ebx]			; fldd
	mov	dword ptr [edi],edx
	fisubr	dword ptr [edi]			; fisubrl
	jmp	asm_generic_flonum_result
	public _asm_generic_multiply
_asm_generic_multiply:
	pop	edx
	pop	ebx
	mov	eax,edx
	mov	ecx,ebx
	shr	eax,26
	shr	ecx,26
	cmp	al,26
	je	asm_generic_multiply_fix
	cmp	al,6
	jne	asm_generic_multiply_fail
	cmp	cl,6
	je	asm_generic_multiply_flo_flo
	cmp	cl,26
	jne	asm_generic_multiply_fail
	shl	ebx,6
	and	edx,ebp
	sar	ebx,6
	fld	qword ptr 4[edx]			; fldd
	mov	dword ptr [edi],ebx
	fimul	dword ptr [edi]				; fisubl
	jmp	asm_generic_flonum_result
asm_generic_multiply_fix:
	cmp	cl,6
	je	asm_generic_multiply_fix_flo
	cmp	cl,26
	jne	asm_generic_multiply_fail
	mov	eax,edx
	mov	ecx,ebx
	shl	eax,6
	shl	ecx,6
	imul	eax,ecx		; subl
	jno	asm_generic_fixnum_result
asm_generic_multiply_fail:
	push	ebx
	push	edx
	mov	al,029H
	jmp	scheme_to_interface
asm_generic_multiply_flo_flo:
	and	edx,ebp
	and	ebx,ebp
	fld	qword ptr 4[edx]			; fldd
	fmul	qword ptr 4[ebx]			; fsubl
	jmp	asm_generic_flonum_result	
asm_generic_multiply_fix_flo:
	shl	edx,6
	and	ebx,ebp
	sar	edx,6
	fld	qword ptr 4[ebx]			; fldd
	mov	dword ptr [edi],edx
	fimul	dword ptr [edi]			; fisubrl
	jmp	asm_generic_flonum_result
	public _asm_generic_equal
_asm_generic_equal:
	pop	edx
	pop	ebx
	mov	eax,edx
	mov	ecx,ebx
	shr	eax,26
	shr	ecx,26
	cmp	al,26
	je	asm_generic_equal_fix
	cmp	al,6
	jne	asm_generic_equal_fail
	cmp	cl,6
	je	asm_generic_equal_flo_flo
	cmp	cl,26
	jne	asm_generic_equal_fail
	shl	ebx,6
	and	edx,ebp
	sar	ebx,6
	fld	qword ptr 4[edx]			; fldd
	mov	dword ptr [edi],ebx
	ficomp	dword ptr [edi]
	fstsw	ax
	sahf
	je	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_equal_fix:
	cmp	cl,6
	je	asm_generic_equal_fix_flo
	cmp	cl,26
	jne	asm_generic_equal_fail
	shl	edx,6
	shl	ebx,6
	cmp	edx,ebx
	je	asm_generic_return_sharp_t	
	jmp	asm_generic_return_sharp_f
asm_generic_equal_flo_flo:
	and	edx,ebp
	and	ebx,ebp
	fld	qword ptr 4[edx]			; fldd
	fcomp	qword ptr 4[ebx]
	fstsw	ax
	sahf
	je	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_equal_fix_flo:
	shl	edx,6
	and	ebx,ebp
	sar	edx,6
	mov	dword ptr [edi],edx
	fild	dword ptr [edi]
	fcomp	qword ptr 4[ebx]
	fstsw	ax
	sahf
	je	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_equal_fail:
	push	ebx
	push	edx
	mov	al,024H
	jmp	scheme_to_interface
	public _asm_generic_greater
_asm_generic_greater:
	pop	edx
	pop	ebx
	mov	eax,edx
	mov	ecx,ebx
	shr	eax,26
	shr	ecx,26
	cmp	al,26
	je	asm_generic_greater_fix
	cmp	al,6
	jne	asm_generic_greater_fail
	cmp	cl,6
	je	asm_generic_greater_flo_flo
	cmp	cl,26
	jne	asm_generic_greater_fail
	shl	ebx,6
	and	edx,ebp
	sar	ebx,6
	fld	qword ptr 4[edx]			; fldd
	mov	dword ptr [edi],ebx
	ficomp	dword ptr [edi]
	fstsw	ax
	sahf
	ja	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_greater_fix:
	cmp	cl,6
	je	asm_generic_greater_fix_flo
	cmp	cl,26
	jne	asm_generic_greater_fail
	shl	edx,6
	shl	ebx,6
	cmp	edx,ebx
	jg	asm_generic_return_sharp_t	
	jmp	asm_generic_return_sharp_f
asm_generic_greater_flo_flo:
	and	edx,ebp
	and	ebx,ebp
	fld	qword ptr 4[edx]			; fldd
	fcomp	qword ptr 4[ebx]
	fstsw	ax
	sahf
	ja	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_greater_fix_flo:
	shl	edx,6
	and	ebx,ebp
	sar	edx,6
	mov	dword ptr [edi],edx
	fild	dword ptr [edi]
	fcomp	qword ptr 4[ebx]
	fstsw	ax
	sahf
	ja	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_greater_fail:
	push	ebx
	push	edx
	mov	al,025H
	jmp	scheme_to_interface
	public _asm_generic_less
_asm_generic_less:
	pop	edx
	pop	ebx
	mov	eax,edx
	mov	ecx,ebx
	shr	eax,26
	shr	ecx,26
	cmp	al,26
	je	asm_generic_less_fix
	cmp	al,6
	jne	asm_generic_less_fail
	cmp	cl,6
	je	asm_generic_less_flo_flo
	cmp	cl,26
	jne	asm_generic_less_fail
	shl	ebx,6
	and	edx,ebp
	sar	ebx,6
	fld	qword ptr 4[edx]			; fldd
	mov	dword ptr [edi],ebx
	ficomp	dword ptr [edi]
	fstsw	ax
	sahf
	jb	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_less_fix:
	cmp	cl,6
	je	asm_generic_less_fix_flo
	cmp	cl,26
	jne	asm_generic_less_fail
	shl	edx,6
	shl	ebx,6
	cmp	edx,ebx
	jl	asm_generic_return_sharp_t	
	jmp	asm_generic_return_sharp_f
asm_generic_less_flo_flo:
	and	edx,ebp
	and	ebx,ebp
	fld	qword ptr 4[edx]			; fldd
	fcomp	qword ptr 4[ebx]
	fstsw	ax
	sahf
	jb	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_less_fix_flo:
	shl	edx,6
	and	ebx,ebp
	sar	edx,6
	mov	dword ptr [edi],edx
	fild	dword ptr [edi]
	fcomp	qword ptr 4[ebx]
	fstsw	ax
	sahf
	jb	asm_generic_return_sharp_t
	jmp	asm_generic_return_sharp_f
asm_generic_less_fail:
	push	ebx
	push	edx
	mov	al,027H
	jmp	scheme_to_interface
	public _asm_generic_quotient
_asm_generic_quotient:
	mov	al,037H
	jmp	scheme_to_interface
	public _asm_generic_remainder
_asm_generic_remainder:
	mov	al,038H
	jmp	scheme_to_interface
	public _asm_generic_modulo
_asm_generic_modulo:
	mov	al,039H
	jmp	scheme_to_interface
	public _asm_nofp_decrement
_asm_nofp_decrement:
	mov	al,022H
	jmp	scheme_to_interface
	public _asm_nofp_divide
_asm_nofp_divide:
	mov	al,023H
	jmp	scheme_to_interface
	public _asm_nofp_equal
_asm_nofp_equal:
	mov	al,024H
	jmp	scheme_to_interface
	public _asm_nofp_greater
_asm_nofp_greater:
	mov	al,025H
	jmp	scheme_to_interface
	public _asm_nofp_increment
_asm_nofp_increment:
	mov	al,026H
	jmp	scheme_to_interface
	public _asm_nofp_less
_asm_nofp_less:
	mov	al,027H
	jmp	scheme_to_interface
	public _asm_nofp_subtract
_asm_nofp_subtract:
	mov	al,028H
	jmp	scheme_to_interface
	public _asm_nofp_multiply
_asm_nofp_multiply:
	mov	al,029H
	jmp	scheme_to_interface
	public _asm_nofp_negative
_asm_nofp_negative:
	mov	al,02aH
	jmp	scheme_to_interface
	public _asm_nofp_add
_asm_nofp_add:
	mov	al,02bH
	jmp	scheme_to_interface
	public _asm_nofp_positive
_asm_nofp_positive:
	mov	al,02cH
	jmp	scheme_to_interface
	public _asm_nofp_zero
_asm_nofp_zero:
	mov	al,02dH
	jmp	scheme_to_interface
	public _asm_nofp_quotient
_asm_nofp_quotient:
	mov	al,037H
	jmp	scheme_to_interface
	public _asm_nofp_remainder
_asm_nofp_remainder:
	mov	al,038H
	jmp	scheme_to_interface
	public _asm_nofp_modulo
_asm_nofp_modulo:
	mov	al,039H
	jmp	scheme_to_interface
end
