     NAME
          gsc - Gambit Scheme compiler

     SYNTAX
          gsc prog [options]

     DESCRIPTION
          Gsc is the Gambit Scheme compiler.  When invoked, it will
          compile the Scheme program prog.scm and produce the object
          file prog.O.

     OPTIONS
          These options are accepted by gsc.

          verbose   Generate a trace of the compiler's actions on
                    standard output.

          report    Produce global variable usage report on standard
                    output.  Each global variable used in the program
                    is listed with 4 flags that indicate if the global
                    variable is defined, referenced, mutated and
                    called.

          expansion Show the source code after expansion by the front
                    end.

          pvm       Produce a listing of the PVM code for the program
                    on prog.pvm.

          asm       Produce the assembly language output file
                    prog.asm.

          stats     Generate code to gather runtime statistics on the
                    program.  The statistics will be output on the
                    profile file (see the glk command).

          debug     Generate code that includes information to aid
                    debugging with gsi.

     NON-STANDARD SPECIAL FORMS
          In addition to the standard Scheme special forms, the
          compiler accepts the following forms which can appear
          anywhere a define special form can appear:

          (##declare decl...)
                            See below for the list of accepted
                            declarations.  The scope of the
                            declaration extends to the end of the body
                            it is in or to the end of the program if
                            it is at toplevel.

          (##include "prog.scm")
                            Read the expressions contained in the
                            given file and splice them into the
                            program.

          (##define-macro (name parm...) body)
                            Define the name as a macro special form
                            which expands into body.  The scope of the
                            declaration extends to the end of the body
                            it is in or to the end of the program if
                            it is at toplevel (unless it is redefined
                            before).

     DECLARATIONS
          The following declarations are accepted by the compiler:

          (dialect)         Use the given dialect's semantics.
                            Dialect can be: ieee-scheme, r4rs-scheme
                            or multilisp.

          ([not] lambda-lift)
                            Lambda-lift (or don't lambda-lift)
                            procedures.

          (strategy)        Select block compilation or separate
                            compilation.  In block compilation, the
                            compiler can assume that all references to
                            the global variables defined in the
                            current program are located in the program
                            itself.  Strategy can be: block or
                            separate.

          ([not] standard-bindings var...)
                            The given global variables are known (or
                            not known) to be equal to the value
                            defined for them in the dialect (all
                            variables defined in the standard if none
                            specified).

          ([not] extended-bindings var...)
                            The given global variables are known (or
                            not known) to be equal to the value
                            defined for them in the runtime system
                            (all variables defined in the runtime if
                            none specified).

          ([not] safe)      Generate (or don't generate) code that
                            will prevent fatal runtime errors.  Note
                            that in `safe' mode certain semantic
                            errors will not be checked as long as they
                            can't crash the system.  For example the
                            primitive `char=?' could disregard the
                            type of its arguments in `safe' (as well
                            as `not safe') mode.

          ([not] intr-checks)
                            Generate (or don't generate) interrupt
                            checks.  Interrupt checks are used to
                            signal the need for a garbage collection
                            on a multiprocessor system, to catch user
                            interrupts and also to check for stack
                            overflows.  Interrupt checking should not
                            be turned off casually.

          (futures method)  Use the given method to implement futures.
                            Method can be: off (future = identity),
                            delay (future = delay), eager (create a
                            task for the body of every future), lazy
                            (create a task for a future's continuation
                            only when it must be moved to another
                            processor), and eager-inline (like eager
                            when there are no tasks waiting on the
                            processor, otherwise like identity).

          (number-type prim...)
                            Numeric arguments and result of specified
                            primitives are known to be of the given
                            type (all primitives if none specified).
                            Number-type can be: generic or fixnum.

     DEFAULT DECLARATION
          The default declarations used by the compiler are:

               (ieee-scheme)
               (lambda-lift)
               (separate)
               (not standard-bindings)
               (not extended-bindings)
               (not safe)
               (intr-checks)
               (futures lazy)
               (generic)

          These declarations are compatible with the ieee-scheme
          standard.  Typically used declarations that enhance
          performance (at the cost of violating the ieee-scheme
          standard) are: (standard-bindings) and (fixnum).

     DIAGNOSTICS
          The diagnostic messages produced by gsc are printed on the
          standard output file.
