(##declare
  (extended-bindings)
  (not safe)
  (not autotouch)
  (block)
  (fixnum))

;------------------------------------------------------------------------------

(set! open-input-file* ##open-input-file)

(set! pp-expression
  (lambda (expr port)
    (##newline port)
    (##pp expr port)))

(let ((v ##argv))
  (let ((n (vector-length v)))
    (if (< n 2)

      (##format ##stdout "Usage: gsc file [pvm] [verbose] [report] [expansion] [asm] [stats] [debug]~%")

      (let ((args (cddr (vector->list v))))
        (let ((x (member "intr-latency" args)))
          (let ((i (if (and x (pair? (cdr x)) (integer? (string->number (cadr x))))
                     (string->number (cadr x))
                     20)))
            (set! intr-timer-interval i)
            (apply cf (vector-ref v 1) 'm68000 (map string->symbol args))))))))

;------------------------------------------------------------------------------
