/* libz.h zilla library 5aug
 * modified
 * 12nov
 * 7sep
 * 10feb        parseargs
 */
 
#ifndef LIBZ_H
#define LIBZ_H

#ifndef THEUSUAL_H
# include <theusual.h>
#endif

/*extern*/
#if !Eansiincludes
extern char *malloc();
#endif

/*compat*/

/* types */
#if Eunix
  typedef long Ztime_t;         /* type for internal time */
#endif
#if Emac
  typedef unsigned int4 Ztime_t;
#endif

/* prototypes */
char *Zsalloc Zproto((char *));
bool Zalignedon Zproto((char *,int));
proc Zbeep Zproto((Zvoid));
int4 Zparseargs Zproto((int,char **,...));
proc Zdelay Zproto((int4 secs));
#define Zqargs0 Zparseargs

/* prototypes for string lib, if not mapping onto libc */
#ifndef str_len
extern char *str_index Zproto((char *,Dchar));
bool str_eq Zproto((char *,char *));
int4 str_len Zproto((char *));
char *str_cpy Zproto((char *to,char *frm));
char *str_cat Zproto((char *dst,char *add));
#endif /*str_len*/

/* these are never mapped onto libz */
extern char *str_rindex Zproto((char *,Dchar));
char *str_end Zproto((char *));
bool str_any Zproto((char *set,char *str));
char *str_alloc Zproto((char *));
int str_prefix Zproto((char *sub,char *str));

FILE *Zfopenext Zproto((char *name,char *ext,char *mode,char *errmsg));
int Zopenext Zproto((char *name,char *ext,char *mode,char *errmsg));
char *Zmktemp Zproto((char *template));  /* side effects its arg */
char *Zuniqnam Zproto((char *prefix));

char *Zpathop Zproto((char *,Dchar));
char *Zpathdelext Zproto((char *path));
char *Zpathgetext Zproto((char *path));
char *Zpathgetname Zproto((char *path));
char *Zpathgetpath Zproto((char *path));

Ztime_t Zfilemodtime Zproto((char *));
Ztime_t Zfileacctime Zproto((char *));
proc Zfilesettimes Zproto((char *,Ztime_t,Ztime_t));
bool Zfileversion(Zvoid);
bool Zversion Zproto((char *,char *));
#define version Zversion
/*#define quit Zquit*/
#define openext Zopenext
#define fopenext Zfopenext

/* may cause trouble? */
proc usage Zproto((void));

#if (Eansi&&Estdarg)
  proc Zerror Zproto((char *msg,...));
  proc Zfail Zproto((char *,...));
  proc Zcodeerror Zproto((char *,...));
  proc Zwarning Zproto((char *,...));
  proc Zquit Zproto((int,char *,...));
#else
  proc Zerror Zproto((/*...*/));
  proc Zfail Zproto((/*...*/));
  proc Zcodeerror Zproto((/*...*/));
  proc Zwarning Zproto((/*...*/));
  proc Zquit Zproto((int,char *,...));
#endif

/*unsigned int4 Zdateint Zproto((void));  renamed to curtime! */
/*proc Zdatestr Zproto((unsigned int4,char *)) replaced by timestring */
Ztime_t Zcurtime Zproto((void));
char *Ztimestring Zproto((Ztime_t));
int4 Zparsetime Zproto((char *));
proc Znap();	/* delay for about 1/60 sec. -where is this?/ */

long Zfilesize Zproto((char *path));
long Zifilesize Zproto((int filedes));
#if Eunix
long Zfilesizeext Zproto((char *path,char *ext,char *errmsg));
#endif
bool Zfiledirp Zproto((char *path));
proc Zzerofile Zproto((char *,int4));

function *Zshowactivehook Zproto((function *));	/*rtns old*/
proc Zshowactivity Zproto((void));
int Zio_typeahead Zproto((void));
int Zio_getcif Zproto((void));

#if Eunix
int Zglob Zproto((char *,char **,int));
#endif

#if Emac
/* what is the difference between these and BlockMove?? */
# define Zbzero(adr,len)		memset(adr,0,len)
# define Zbset(adr,len,val)	memset(adr,val,len)
# define Zbcopy(src,dst,len)	memcpy(dst,src,len)
# define Zmemcmp : foo
#endif

#if (Ebsd|EsysV)
# define Zbzero(adr,len)	bzero(adr,len)
/*# define Zbset(adr,len,val)	no such! */
# define Zbcopy(src,dst,len)	bcopy(src,dst,len)
# define Zmemcmp(a,b,n)         memcmp(a,b,n)
# if (Eansiincludes&&!Egcc)
#   include <bstring.h>
# else
    proc bcopy Zproto((Zconst Zunspec src,Zunspec dst,int len));
    proc bzero Zproto((Zunspec b,int len));
# endif
#endif

proc Zbyteswap_long Zproto((char *));
proc Zbyteswap Zproto((char *));

#endif         /*LIBZ_H*/
