#include "../xt/xt.h"
#include <X11/Xaw/Porthole.h>

static SYMDESCR Panner_Syms[] = {
    { "slider-x",       XawPRSliderX },
    { "slider-y",       XawPRSliderY },
    { "slider-width",   XawPRSliderWidth },
    { "slider-height",  XawPRSliderHeight },
    { "canvas-width",   XawPRCanvasWidth },
    { "canvas-height",  XawPRCanvasHeight },
    { 0, 0 }
};

static Object S_Porthole_ReportCallback (x) XtArgVal x; {
   Object ret = Null;
    XawPannerReport *p = (XawPannerReport *)x;
    GC_Node;

    GC_Link (ret);
    ret = Cons (Make_Integer (p->canvas_height), ret);
    ret = Cons (Make_Integer (p->canvas_width), ret);
    ret = Cons (Make_Integer (p->slider_height), ret);
    ret = Cons (Make_Integer (p->slider_width), ret);
    ret = Cons (Make_Integer (p->slider_y), ret);
    ret = Cons (Make_Integer (p->slider_x), ret);
    ret = Cons (Bits_To_Symbols ((unsigned long)p->changed, 1, Panner_Syms),
	ret);
    GC_Unlink;
    return ret;
}

init_porthole () {
    XtResourceList r = 0;
    Define_Class ("porthole", portholeWidgetClass, r, 0);
    Define_Callback ("porthole", "reportCallback", 1);
    Define_Converter_To_Scheme ("porthole-reportCallback", S_Porthole_ReportCallback);
}
