;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 2))))

(defun eqv (a1 a2) (eql a1 a2))
(defun memv (a l) (member a l))
(defun memq (a l) (member a l :test #'eq))
(defun member-equal (a l) (member a l :test #'equal))
(defun assv (a l) (assoc a l))
(defun assq (a l) (assoc a l :test #'eq))
(defun assoc-equal (a l) (assoc a l :test #'equal))
(defun delv (a l) (delete a l))
(defun delq (a l) (delete a l :test #'eq))
(defun delete-equal (a l) (delete a l :test #'equal)) 

(defun genbase ()
    (cons '&base nil))

(defun extendbase (i v)
    (rplacd *init-base* (cons (cons i v) (cdr *init-base*))))
    
(defun removefrombase (i)
    (let ((pr (assq i (cdr (setq tempbase *init-base*)))))
      (if (null pr)
	  nil
	  (rplacd tempbase (delete pr (cdr tempbase))))))

(defun base-identifiers ()
	(mapcar 'car (cdr *init-base*)))

(defun lookupinbase (i)
    (let ((pr (baselocation i)))
      (if (eq (cdr pr) 'unassigned)
	  (raise (list 'SE%base '|Unbound base identifier:| i))
	  (cdr pr))))

(defun baselocation (i)
	(assq i (cdr *init-base*)))

(defun guaranteedlookup (id)
    (let ((pr (baselocation id)))
      (cond
	(pr pr)
	(t (extendbase id 'unassigned)
	   (baselocation id)))))
	
	      
(defun scheme-reset ()
    (rplacd 
      (baselocation 'scheme-top-level)
      (global-binding 'global-scheme-top-level))
    (reset))




