;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 2))))

(proclaim
  '(special ??? **location** core-names table-*at table-*gs
	    application-declared-semantics scheme-id-declared-semantics
	    table-*gr host-macs =temp=))

(defun andmap (f l)
  (if l
      (and (funcall f (car l))
           (andmap f (cdr l)))
      t))
 
(defun unique-list (l)
  (if (null l)
      t
      (and (not (memq (car l) (cdr l)))
           (unique-list (cdr l)))))

(defun tag-vars-length (l)
    (let ((x (imrdc l)))
      (if (and (andmap 'symbolp x)
             (if (symbolp =temp=)
                 (not (memq =temp= x))
                 (null =temp=))
             (unique-list x))
	  (if =temp=
	      (list '*rla (cons =temp= x) (length x))
	      (list '*la l (length l)))
	  (raise (list 'SE%comp '|compile:|
                     '|Formal arguments must all be unique symbols:| l)))))

(defun imrdc (l)
    (cond ((atom l)	(setq =temp= l) nil)
	  (t		(cons (car l) (imrdc (cdr l))))))

(defun cdr-assq (a l)
    (cond ((null l)		nil)
	  ((eq (cdar l) a)	(car l))
	  (t			(cdr-assq a (cdr l)))))

(setq table-*at `((*at . 1)))
(setq table-*gs `((*gs . ,(guaranteedlookup 'scheme-directory))))
(setq table-*gr `((*gr . ,(guaranteedlookup 'scheme-directory))))

;(declare (special columns))

(defun make-table (rows columns)
    (cons
      (cons rows columns)
      (reverse
	(mapnum (function (lambda (row) (make-col row columns))) rows))))

;(declare (special row))

(defun make-col (row columns)
    (reverse
      (mapnum (function (lambda (col) (make-entry row col)))
	      columns)))

(defun make-entry (i j)
    (let ((box (cons i j)))
	 (cons (cons '*lr box) (cons '*ls box))))

(defun mapnum (f i)
    (if (minusp i)
	nil
	(cons (apply f (list i)) (mapnum f (1- i)))))

(defvar lexical-table (make-table 4 4))

(defun local-ref-table-lookup (opcode args)
    (let ((rows	   (caar lexical-table))
	  (columns (cdar lexical-table))
	  (array   (cdr lexical-table))
	  (m	   (car args))
	  (n	   (cdr args)))
      (declare (fixnum rows columns m n))
      (if (and (or (< m rows) (= m rows))
	       (or (< n columns) (= n columns)))
	  (cond ((eq opcode '*lr)
		    (car (nth n (nth m array))))
		((eq opcode '*ls)
		    (cdr (nth n (nth m array)))))
	  (cons opcode args))))

(defun table-lookup (table opcode args)
    (let ((pair (cdr-assq args table)))
      (if (null pair)
	  (let ((newpair (cons opcode args)))
	       (nconc table (list newpair))
	       newpair)
	  pair)))

(eval-when (compile load)
(defmacro access-system-function (l)
    `(let ((p (getl ,l '(constant-system-function system-function))))
	  (if p (cadr p) nil)))

(defmacro access-scheme-primitive (l)
    `(let ((p (getl ,l '(constant-primitive scheme-primitive))))
	  (if p (cadr p) nil)))


(defmacro one (l)     `(car ,l))
(defmacro two (l)     `(cadr ,l))
(defmacro three (l)   `(caddr ,l))
(defmacro four (l)    `(cadddr ,l))
(defmacro la-body (l) `(cdddr ,l))
(defmacro extend (a b)`(cons ,b ,a))
(defmacro &arity (l)  `(car ,l))
(defmacro &class (l)  `(caddr ,l))
(defmacro &name (l)   `(cdddr ,l))

;;; Expression type predicates.  One for each type of expression

(defmacro quoted? (l)
    `(let ((temp ,l)) (and (consp temp) (eq (car temp) 'quote))))

(defun constant? (x)
    (or (and (atom x) (or (null x)
			  (eq x t)
			  (numberp x)
			  (stringp x)
			  (characterp x)))
	(proc? x)
	(quoted? x)))

(defmacro identifier? (l)  `(atom ,l))
(defmacro lambda? (l)	   `(and (consp ,l) (eq (car ,l) '#!lambda)))
(defmacro if? (l)	   `(and (consp ,l) (eq (car ,l) '#!if)))
(defmacro set? (l)	   `(and (consp ,l) (eq (car ,l) '#!set!)))
(defmacro scheme-id? (l)   `(and (consp ,l) (eq (car ,l) '#!scheme-id)))
(defmacro app? (l)	   `(and (consp ,l) (eq (car ,l) '#!application)))

(defmacro host-mac-exp? (l)
    `(and (atom (car ,l)) (memq  (car ,l) host-macs)))

(defmacro beta-transform? (l)
    `(let ((exp ,l))
       (cond ((atom exp)	nil)
	     ((atom (car exp))	(if (symbolp (car exp))
				    (get (car exp) 'beta-transform)
				    nil))
	     (t			(eq (car (car exp)) '&transform)))))
		
(defmacro application? (l) 't)

;;; code sequence construction
(defmacro inst (l)
    (let ((num-args (length l)))
      (declare (fixnum num-args))
      (cond ((= num-args 1) (warn "not enough args to inst " l))
	    ((= num-args 2) `(mk-inst ,(cadr l) nil))
	    ((= num-args 3) `(mk-inst . ,(cdr l)))
	    (t (warn "too many args to inst " l)))))

(defun mk-inst (opcode args)
    (cond ((eq opcode '*at)
	   (if (zerop args)
	       '(*ti . 0)
	       (table-lookup table-*at opcode args)))
	  ((eq opcode '*lr) (local-ref-table-lookup opcode args))
	  ((eq opcode '*ls) (local-ref-table-lookup opcode args))
	  ((eq opcode '*gr) (table-lookup table-*gr opcode args))
	  ((eq opcode '*gs) (table-lookup table-*gs opcode args))
	  ((eq opcode '*pu) '(*pu))
	  ((eq opcode '*re) '(*re))
	  (t (cons opcode args))))

(defun emit (inst code)
	`(,inst . ,code))

;;; environment access

(defun lookup (i env)
	(try-rib-m i env 0))

(defun try-rib-m (i e m)
    (cond ((null e) nil)
	  ((setq =temp=
	     (cond ((not (atom (one e))) (try-n i (one e) 0))
		   ((eq i (one e)) 0)
		   (t nil)))
	   (cons m =temp=))
	  (t (try-rib-m i (cdr e) (1+ m)))))

(defun try-n (i r n)
    (cond ((null r)		nil)
	  ((eq i (one r))	n)
	  (t			(try-n i (cdr r) (1+ n)))))

(defun emit-fake-lambda (p primitive)
    (let ((numargs (car p)))
      (declare (fixnum numargs))
      ;;; this 'car' is a KLUDGE, because I am too lazy to restructure
      ;;; e-identifier.   --brooks
      (car
	(cond
	  ((= numargs 0)
	   (e-exp `(#!lambda () (#!application (,primitive))) nil nil))
	  ((= numargs 1)
	   (e-exp `(#!lambda (x) (#!application (,primitive (#!scheme-id x))))
	     nil nil))
	  ((= numargs 2)
	   (e-exp
	     `(#!lambda (x y)
		(#!application (,primitive (#!scheme-id x) (#!scheme-id y))))
	     nil nil))
	  ((= numargs 3)
	   (e-exp
	     `(#!lambda (x y z)
		(#!application
		  (,primitive
		    (#!scheme-id x)
		    (#!scheme-id y)
		    (#!scheme-id z))))
	     nil nil))
	  (t (raise (list 'SE%comp '|compile:|
		      '|no primitive has this many arguments| numargs)))))))

(defun primop (exp env)
    (and (atom exp)
	 (not (numberp exp))
	 (not (lookup exp env))
	 (access-scheme-primitive exp)))

;;; compilation routines

(defun compile (exp)
	(e-exp exp nil (emit (inst (list '*re)) nil)))

;;; argument compiler

(defun a-args (a r c)
    (if (null a)
	c
	(a-args (cdr a) r (t-exp (car a) r (emit (inst (list '*pu)) c)))))

(defun macro-expand (exp env)
    ;;; compile is a primitive so vsm regs they must be bound
    ;;; before macro expansion so that they are not "overwritten"
    ;;; upon completion of macro expansion.	This is especially 
    ;;; true of **fnv**.  If it is not rebound, macro expansion 
    ;;; termination will leave nil in **fnv**.  This will cause 
    ;;; an error on the next fluid lookup, which will in turn 
    ;;; reset **fnv** to something reasonable. 
    ;;; -- gsb 12/27/83
    ;;; forget fluids--jg 5/88
    (setq fal nil)
    (let
      ((ans
	 (newnames
	   (lexpand2
	     (copy-no-constant-no-quote
		 (vsm-help
		   '((*pr &ms . apply) (*re))
		   '((((*pr &ms . result))) nil)
		   nil
		   (list (list (tag-frees (copy-no-constant exp) nil)))
		   (if (atom (car exp))
		       (caddr (get (car exp) 'beta-transform))
		       (caddar exp)))))
	   nil)))
      (setq fal nil)
      ans))

;;; expression compiler for tail-recursive expressions
(defun e-exp (exp env code)
      (cond ((constant? exp) (standard-e-constant exp env code))
	    ((identifier? exp) (effected-e-identifier exp env code))
	    ((scheme-id? exp) (standard-e-identifier (cadr exp) env code))
	    ((beta-transform? exp) (e-macro exp env code))
	    ((host-mac-exp? exp) (e-exp (host-mac-dispatch exp) env code))
	    ((lambda? exp) (e-lambda exp env code))
	    ((if? exp) (e-if exp env code))
	    ((set? exp) (e-set exp env code))
	    ((app? exp) (standard-e-application (cadr exp) env code))
	    ((application? exp) (effected-e-application exp env code))
	    (t ???)))

(defun standard-e-constant (exp env code)        ;;; constants are always tidy
    (emit
      (cond ((or (atom exp) (proc? exp)) (inst (list '*co exp)))
	    ((quoted? exp) (inst (list '*co (two exp))))
	    (t (raise (list 'SE%comp '|compile:| '|Bad constant| exp))))
      code))

(defun run-semantics (exp env semantic-fn)
    (setq **comp-env** (cons (flatten-comp-env env) **comp-env**))
    (let ((ans (vsm-help
		       '((*pr &ms . apply) (*re))
		       '((((*pr &ms . result))) nil)
		       nil
		       (list (list exp))
		       semantic-fn)))
 	 (setq **comp-env** (cdr **comp-env**))
	 ans))

; primitives and system functions as global references need special handling
; they cannot be rebound at the top level

(defun effected-e-identifier (exp env code)
    (if scheme-id-declared-semantics
	(e-exp (run-semantics exp env scheme-id-declared-semantics) env code)
	(standard-e-identifier exp env code)))

(defun standard-e-identifier (exp env code)
  (if (or (null exp) (not (symbolp exp)))
      (raise (list 'SE%comp '|compile:| '|Identifier must be a symbol:| exp)))
  (let ((m-n (lookup exp env))) ;lookup returns dotted-pair
    (emit
     (if m-n
	 (inst (list '*lr m-n))
	 (let ((pair (getl exp '(constant-primitive scheme-constant
				scheme-primitive
				constant-system-function system-function))))
	   (if pair (cond ((eq (cadr pair) 'unassigned-constant)
			   (inst (list '*co `(&unassigned-constant . ,exp))))
			  ((eq (car pair) 'constant-primitive)
			   (emit-fake-lambda (cadr pair) exp))
			  ((eq (car pair) 'scheme-primitive)
			   (emit-fake-lambda (cadr pair) exp))
			  ((eq (car pair) 'system-function)
			   (inst (list '*co `(&sys . ,(cadr pair)))))
			  ((eq (car pair) 'constant-system-function)
			   (inst (list '*co `(&sys . ,(cadr pair)))))
			  (t (inst (list '*co (cadr pair)))))
	       (inst (list '*gr (guaranteedlookup exp))))))
     code)))
	
(defun e-lambda (exp env code)
    (let ((tag$vars$length (tag-vars-length (two exp))) (body (cddr exp)))
      (let ((vars (cadr tag$vars$length)))
	(emit
	  (inst (list (car tag$vars$length)
		      `(,(caddr tag$vars$length) ,vars
		         ,@(e-stmnts
				body
		       		(if (null vars)
			   	    env
			   	    (extend env vars))
			        (emit (inst (list '*re)) nil)))))
	  code))))
	      
(defun e-if (e r c)
    (if (not (or (= (length e) 3) (= (length e) 4)))
        (raise (list 'SE%comp '|compile:| '|wrong number of forms to if:| e)))
    (t-exp
      (two e) r
      (emit
	(inst (list '*if `(,(e-exp (three e) r c) . ,(e-exp (four e) r c))))
	nil)))

(defun e-set (exp env code)
    (if (not (= (length exp) 3))
        (raise (list 'SE%comp '|compile:|
		     '|wrong number of forms to set!:| exp)))
    (if (or (not (symbolp (two exp))) (null (two exp)))
	(raise (list 'SE%comp '|compile:| '|identifier must be a symbol:| exp)))
    (t-exp
      (three exp)
      env
      (emit (let ((m-n (lookup (two exp) env)))
	      (if m-n
		  (inst (list '*ls m-n))
		  (inst (list '*gs (progn
				     (remprop (two exp) 'scheme-primitive)
				     (remprop (two exp) 'system-function)
				     (guaranteedlookup (two exp)))))))
	    code)))

(defun e-stmnts (stmnts env code)
    (if (null (cdr stmnts))
	(e-exp (car stmnts) env code)
	(t-exp (car stmnts) env (e-stmnts (cdr stmnts) env code))))

(defun standard-e-application (exp env code)
    (let* ((args (cdr exp))
	   (len-args (length args))
	   (fcn (beta-expand (car exp)))
	   (prim (primop fcn env)))
      (declare (fixnum len-args))
      (cond
	((and prim (not (baselocation fcn)))
	 (if (/= (&arity prim) len-args)
	     (raise (list 'SE%comp '|compile:|
			  '|Wrong number of args to primitive:| exp)))
	 (p-exp prim args env code))
	((lambda? fcn)
	 (let* ((tag$vars$length (tag-vars-length (cadr fcn)))
		(tag (car tag$vars$length))
		(vars (cadr tag$vars$length))
		(len (caddr tag$vars$length)))
	   (cond
	     ((or (and (eq tag '*la) (/= len len-args))
		  (and (eq tag '*rla) (< len-args len)))
	      (raise (list 'SE%comp '|compile:|
		       '|Wrong number of actual parameters:| exp)))
	     ((null vars) (e-stmnts (cddr fcn) env code))
	     (t (a-args args env
		  (emit
		    (inst (list (if (eq '*la tag) '*le '*rle)
			        vars))
		    (e-stmnts (cddr fcn) (extend env vars) code)))))))
	(t (a-args args env
	     (t-exp fcn env (emit (inst (list '*at len-args)) nil)))))))

(defun effected-e-application (e r c)
    (if application-declared-semantics
	(e-exp (run-semantics e r application-declared-semantics) r c)
	(standard-e-application e r c)))

(defun e-macro (exp env code)
      (e-exp (macro-expand exp env) env code))

;;; expression compiler for non-tail-recursive  expressions
;;; (ie. expressions which must be made tidy.)

(defun t-exp (exp env code)
      (cond ((constant? exp) (standard-e-constant exp env code))
	    ((identifier? exp) (effected-t-identifier exp env code))
	    ((scheme-id? exp) (standard-e-identifier (cadr exp) env code))
	    ((beta-transform? exp) (t-macro exp env code))
	    ((host-mac-exp? exp) (t-exp (host-mac-dispatch exp) env code))
	    ((lambda? exp) (e-lambda exp env code))
	    ((if? exp) (t-if exp env code))
	    ((set? exp) (e-set exp env code))
	    ((app? exp) (standard-t-application (cadr exp) env code))
	    ((application? exp) (effected-t-application exp env code))
	    (t ???)))

(defun effected-t-identifier (exp env code)
    (if scheme-id-declared-semantics
	(t-exp (run-semantics exp env scheme-id-declared-semantics) env code)
	(standard-e-identifier exp env code)))

(defun t-if (exp env code)
    (if (not (or (= (length exp) 3) (= (length exp) 4)))
	(raise (list 'SE%comp '|compile:| '|wrong number of forms to if:| exp)))
    (t-exp
      (two exp)
      env
      (emit
	(inst (list '*if
		    `(,(t-exp (three exp) env code) .
		      ,(t-exp (four exp) env code))))
	nil)))

(defun t-stmnts (stmnts env code)
    (if (null (cdr stmnts))
	(t-exp (car stmnts) env code)
	(t-exp (car stmnts) env (t-stmnts (cdr stmnts) env code))))

(defun standard-t-application (exp env code)
    (let* ((args (cdr exp))
	   (len-args (length args))
	   (fcn (beta-expand (car exp)))
	   (prim (primop fcn env)))
      (declare (fixnum len-args))
      (cond
	((and prim (not (baselocation fcn)))
	 (if (/= (&arity prim) len-args)
	     (raise (list 'SE%comp '|compile:|
			  '|Wrong number of args to primitive:| exp)))
	 (p-exp prim args env code))
	((lambda? fcn)
	 (let* ((tag$vars$length (tag-vars-length (cadr fcn)))
		(tag (car tag$vars$length))
		(vars (cadr tag$vars$length))
		(len (caddr tag$vars$length)))
	   (cond
	     ((or (and (eq tag '*la) (/= len len-args))
		  (and (eq tag '*rla) (< len-args len)))
	      (raise (list 'SE%comp '|compile:|
		       '|Wrong number of actual parameters:| exp)))
	     ((null vars) (t-stmnts (cddr fcn) env code))
	     (t (emit
		  (inst (list '*sa code))
		  (a-args args env
		    (emit
		      (inst (list (if (eq '*la tag) '*le '*rle)
			          vars))
		      (e-stmnts
			(cddr fcn)
			(extend env vars)
			(emit (inst (list '*re)) nil)))))))))
	(t (emit
	     (inst (list '*sa code))
	     (a-args args env
	       (t-exp fcn env
		 (emit (inst (list '*at len-args)) nil))))))))

(defun effected-t-application (exp r code)
    (if application-declared-semantics
	(t-exp (run-semantics exp r application-declared-semantics) r code)
	(standard-t-application exp r code)))

(defun t-macro (exp env code)
    (t-exp (macro-expand exp env) env code))

;;; primitive expression compiler

(defun p-exp (prim args env code)
    (a-args (cdr args) env (t-exp (car args) env (emit (cdr prim) code))))

)
