;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 0))))

;           Virtual Scheme Machine for Scheme 88
(proclaim
  '(special =env= =class= =temp= =temp1= =temp2= unprintable-symbols
	    *toplevel-continuation* *initial-env* *toplevel-function*))

; Main Registers

(proclaim
  '(special **ticks** **try-cont** **try-failure** **try-success**))

; Debugging registers

(proclaim
  '(special *error* *error-data* *error-res* *error-args*))

(eval-when (compile load)
(defmacro mk-continuation (a b c d)
    `(if (eq (caar (setq =temp2= ,a)) '*re)
	 ,d
         (cons (cons =temp2= (cons ,b ,c))
	       ,d)))

(defmacro mk-save-continuation (a b c d)
    `(cons (cons ,a (cons ,b ,c))
	   ,d))

(defmacro &frame (l)	`(car ,l))
(defmacro &pc (l)	`(car ,l))
(defmacro &args (l)	`(cadr ,l))
(defmacro &env (l)	`(cddr ,l))
(defmacro &cont (l)	`(cdr ,l))
(defmacro top-stack ()	'(car **args**))
(defmacro 2nd-stack ()	'(cadr **args**))
(defmacro 3rd-stack ()	'(caddr **args**))
(defmacro 4th-stack ()	'(cadddr **args**))

; S-code interpreter

(defun vsm (**pc** **cont** **env** **args** **result**)
    (prog (=opcode= =frame= =funtype= =n= =rib-loc= =pair= =op= =opargs=
	    =inst= =rib= =rib-depth= =offset=)
   (go redirected-pc-loop)
   
 loop
   (setq **pc** (cdr **pc**))
 redirected-pc-loop
   (if	(or (null **ticks**) (plusp (setq **ticks** (1- **ticks**))))
	(go opcode-dispatch))
   (setq **args**
     (list
       (cons '&cont
	 (mk-continuation **pc** **args** **env** **cont**))
       **result**))
   (setq **result** **try-failure**)
 try-return
   (setq **cont** **try-cont**)
   (setq **ticks** nil)
   (setq =opargs= 2)
   (go *application)
   
 %exit-try
   (if	(null **ticks**)
	(scherror "Sorry, no try running"))
   (setq **ticks** 1)
   (go loop)

 %try
   (cond 
     (**ticks** (scherror "Sorry, can't nest trys"))
     ((or (not (integerp (setq =temp= (2nd-stack))))
	  (and (not (zerop =temp=)) (not (plusp =temp=))))
      (raise (list 'SE%vsm '|illegal ticks for try:| =temp=)))
     ((zerop =temp=) ; this is just for efficiency
      (setq **cont**
        (mk-continuation
	  (cdr **pc**) (cddddr **args**) **env** **cont**))
      (setq =temp= (list **result** (top-stack)))
      (setq **result** (4th-stack))
      (setq **args** =temp=)
      (setq =opargs= 2))
     (t (setq **ticks** (1+ =temp=))
	(setq **try-success** (3rd-stack))
        (setq **try-failure** (4th-stack))
	(setq **try-cont**
          (mk-continuation
	    (cdr **pc**) (cddddr **args**) **env** **cont**))
	(setq **cont** nil)
	(setq **args** (list (top-stack)))
	(setq =opargs= 1)))
   (go *application)

 %C
   (setq **cont** 
      (mk-continuation (cdr **pc**) **args** **env** **cont**))
   (setq **args** (list (cons '&cont **cont**)))
   (setq =opargs= 1)
   (go *application)

 %partial-cont
   (let ((first **result**) (second (top-stack)))
      (if (not (and (eq '&cont (car first)) (eq '&cont (car second))))
	  (scherror "Arguments to partial-cont must be continuations"))
      (setq **result** (cons '&cont (copy-cont (cdr first) (cdr second))))
      (go pop1))

 %append-cont
   (let ((first **result**) (second (top-stack)))
      (if (not (and (eq '&cont (car first)) (eq '&cont (car second))))
          (scherror "Both arguments to append-cont must be continuations"))
      (setq **result** (cons '&cont (append (cdr first) (cdr second))))
      (go pop1))

 %T
   (setq **cont** nil)
   (setq =opargs= 1)
   (go *application)

 apply-continuation
   (if	(not (= =opargs= 1))
	(go wrong-number-of-args-to-continuation))
   (setq **cont** (if **cont**
		      (append (cdr **result**) **cont**)
		      (cdr **result**)))
   (setq **result** (top-stack))
 *restore
   (cond
     (**cont**
       (setq =frame= (&frame **cont**))
       (setq **cont** (&cont **cont**))
       (setq **pc** (&pc =frame=))
       (setq **args** (&args =frame=))
       (setq **env** (&env =frame=))
       (go redirected-pc-loop))
     ((null **ticks**)
      (setq **pc** '((*at . 1)))
      (setq **env** *initial-env*)
      (setq **args** (list **result**))
      (setq **result** *toplevel-function*)
      (go redirected-pc-loop))
     (t (setq **args** (list **result** (- **ticks** 2)))
	(setq **result** **try-success**)
	(go try-return)))

 %apply
   (setq **cont**
     (mk-continuation (cdr **pc**) (cdr **args**) **env** **cont**))
   (setq **args** (properargs (top-stack)))
   (if	(null **args**)
	(go *thunk-invocation))
   (setq =opargs= (length **args**))
   (go *application)

 *application-tail (setq =opargs= (cdr =inst=))
 *application
   (if	(not (consp **result**))
	(go bad-function))
   (setq =funtype= (car **result**))
   (cond ((eq =funtype= '&closure) (go apply-closure))
	 ((eq =funtype= '&rest-closure) (go apply-rest-closure))
	 ((eq =funtype= '&sys) (go system-call))
	 ((eq =funtype= '&cont) (go apply-continuation))
	 ((eq =funtype= '&vector) (go apply-vector))
	 (t (go bad-function)))

 %execute
   (setq **cont**
      (mk-continuation (cdr **pc**) **args** **env** **cont**))
   (setq **pc** **result**)
   (setq **env** nil)
   (go redirected-pc-loop)

 *thunk-invocation
   (if	(not (consp **result**))
	(go bad-function))
   (setq =funtype= (car **result**))
   (cond ((eq =funtype= '&closure) (go apply-thunk))
	 ((eq =funtype= '&rest-closure) (go apply-rest-thunk))
	 ((eq =funtype= '&sys) (go system-call))
	 ((eq =funtype= '&cont) (go apply-continuation))
	 ((eq =funtype= '&vector) (go apply-vector))
	 (t (go bad-function)))

 opcode-dispatch
 (setq =inst= (car **pc**))
   (setq =opcode= (car =inst=))
   (cond
     ((eq =opcode= '*pu) (go *push))
     ((eq =opcode= '*lr) (go *local-lookup))
     ((eq =opcode= '*pr) (go *primitive))
     ((eq =opcode= '*at) (go *application-tail))
     ((eq =opcode= '*ti) (go *thunk-invocation))
     ((eq =opcode= '*co) (go *constant))
     ((eq =opcode= '*if) (go *if-tail))
     ((eq =opcode= '*le) (go *let-lambda))
     ((eq =opcode= '*sa) (go *save))
     ((eq =opcode= '*re) (if (numberp **ticks**)
			     (setq **ticks** (1+ **ticks**)))
			     (go *restore))
     ((eq =opcode= '*la) (go *lambda))
     ((eq =opcode= '*gr) (go *global-lookup))
     ((eq =opcode= '*ls) (go *local-set))
     ((eq =opcode= '*rla) (go *rest-lambda))
     ((eq =opcode= '*rle) (go *rest-let-lambda))
     ((eq =opcode= '*gs) (go *global-set))
     ((eq =opcode= '*ra) (go *result->args))
     (t (go bad-vsm-opcode)))

 *constant
   (setq =opargs= (cdr =inst=))
   (if	(and (consp =opargs=) (eq (car =opargs=) '&unassigned-constant))
	(rplacd =inst= (setq **result** (lookup-constant (cdr =opargs=))))
	(setq **result** =opargs=))
   (go loop)

 *lambda
   (setq **result** (cons '&closure (cons (cdr =inst=) **env**)))
   (go loop)

 *rest-lambda
   (setq **result** (cons '&rest-closure (cons (cdr =inst=) **env**)))
   (go loop)

 *if-tail
   (setq **pc** (if **result**
		    (cadr =inst=)
		    (cddr =inst=)))
   (go redirected-pc-loop)

 *result->args
   (setq **args** **result**)
   (go loop)

 *let-lambda
   (setq **args** (copy-list **args**))
   (setq **env** (cons (cons **args** (cdr =inst=)) **env**))
   (setq **args** nil)
   (go loop)

 *rest-let-lambda
   (setq **args** (copy-list **args**))
   (setq **env**
     (cons
       (cons  ;;; this nthcdr should not need to be done!
	 (cons (nthcdr (length (cdr (cdr =inst=))) **args**) **args**)
	 (cdr =inst=))
       **env**))
   (go loop)

 apply-thunk
   (if	(not (zerop (caadr **result**)))
	(go wrong-number-of-args-to-closure))
   (setq **env** (cddr **result**))
   (setq **pc** (cddadr **result**))
   (go redirected-pc-loop)

 apply-closure
   (if	(not (= =opargs= (caadr **result**)))
	(go wrong-number-of-args-to-closure))
   (setq **args** (copy-list **args**))
   (setq **env**
     (cons (cons **args** (cadadr **result**)) (cddr **result**)))
   (setq **pc** (cddadr **result**))
   (setq **args** nil)
   (go redirected-pc-loop)

 apply-rest-thunk
   (if	(not (zerop (caadr **result**)))
	(go wrong-number-of-args-to-closure))
   (setq **env**
     (cons (cons (cons nil nil) (cadadr **result**)) (cddr **result**)))
   (setq **pc** (cddadr **result**))
   (go redirected-pc-loop)

 apply-rest-closure
   (if	(< =opargs= (caadr **result**))
	(go wrong-number-of-args-to-closure))
   (setq **args** (copy-list **args**))
   (setq **env**
     (cons
       (cons 
	 (cons (nthcdr (caadr **result**) **args**) **args**)
	 (cadadr **result**))
       (cddr **result**)))
   (setq **pc** (cddadr **result**))
   (setq **args** nil)
   (go redirected-pc-loop)
    
 system-call
   (setq **result** (apply (cdr **result**) **args**))
   (setq **args** nil)
   (go *restore)

 apply-vector
   (if	(not (= =opargs= 1))
	(go wrong-number-args-to-vector))
   (setq **result** (vactor-ref **result** (top-stack)))
   (setq **args** nil)
   (go *restore)

 *push
   (setq **args** (cons **result** **args**))
   (go loop)

 *save
   (setq **cont**
     (mk-save-continuation (cdr =inst=) **args** **env** **cont**))
   (setq **args** nil)
   (go loop)

 *local-set
   (setq =rib-depth= (cadr =inst=))
   (setq =offset= (cddr =inst=))
   (setq =temp=
     (cond ((= 0 =rib-depth=) (caar **env**))
	   ((= 1 =rib-depth=) (caadr **env**))
	   ((= 2 =rib-depth=) (caaddr **env**))
	   (t (car (nth =rib-depth= **env**)))))
   (cond ((= 0 =offset=) =temp=)
	 ((= 1 =offset=) (setq =temp= (cdr =temp=)))
	 ((= 2 =offset=) (setq =temp= (cddr =temp=)))
	 (t (setq =temp= (nthcdr =offset= =temp=))))
   (rplaca =temp= **result**)
   (go loop)

 *global-set
   (setq =opargs= (cdr =inst=))
   (cond
     ((eq (cdr =opargs=) 'unassigned)
      (setq =temp= (global-namespacetype (car =opargs=)))
      (cond
	((or (not =temp=) (eq =temp= 'base-identifier)
	     (eq =temp= 'scheme-primitive) (eq =temp= 'system-function))
	 (rplacd =opargs= **result**)
	 (cond ((memq =temp= '(scheme-primitive system-function))
		(remprop (car =opargs=) =temp=))))
	((and (eq =temp= 'constant)
	      (setq =pair=
		(getl (car =opargs=)
		      '(scheme-constant constant-primitive
			 constant-system-function)))
	      (eq (cadr =pair=) 'unassigned-constant))
	 (rplaca (cdr =pair=) **result**))
	(t (setq *error* =opargs=)
	   (scherror (concatenate 'string (symbol-name (car =opargs=))
				  " already declared as a "
				  (symbol-name =temp=)))))
      (go loop)))
   (rplacd =opargs= **result**)
   (cond  ((lookupinbase 'scheme-global-note)
	   (standardprint "[Redefining ") (standardprint (car =opargs=))
	   (standardprint "]") (new-line schpoport)))
   (go loop)
    
 *local-lookup
   (setq =rib-depth= (cadr =inst=))
   (setq =offset= (cddr =inst=))
   (setq =temp=
      (cond ((= 0 =rib-depth=) (caar **env**))
	    ((= 1 =rib-depth=) (caadr **env**))
	    ((= 2 =rib-depth=) (caaddr **env**))
	    (t (car (nth =rib-depth= **env**)))))
   (cond ((= 0 =offset=) =temp=)
	 ((= 1 =offset=) (setq =temp= (cdr =temp=)))
	 ((= 2 =offset=) (setq =temp= (cddr =temp=)))
	 (t (setq =temp= (nthcdr  =offset= =temp=))))
   (setq **result** (car =temp=))
   (go loop)

 *global-lookup
   (setq =opargs= (cdr =inst=))
   (cond
     ((eq (cdr =opargs=) 'unassigned)
      (setq *error-data* (car =opargs=))
      (setq *error* **cont**)
      (scherror "Unassigned identifier:"))
     (t (setq **result** (cdr =opargs=))))
   (go loop)

 *primitive (setq =opargs= (cdr =inst=))

; Scheme primitives

; Scheme primitives take their arguments from the top of **args**,
; popping them off and leaving the result in **result**

; When apply-primitive is called, the top two elements of the =opargs=
; are the class and name of the primitive

 *primitive-apply
   (setq =class= (car =opargs=))
   (setq =op= (cdr =opargs=))
   (cond ((eq =class= '&se) (go &select))
	 ((eq =class= '&ls) (go &list))
	 ((eq =class= '&pr) (go &predicate))
	 ((eq =class= '&tp) (go &type))
	 ((eq =class= '&no) (go &numeric))
	 ((eq =class= '&s4) (go &select-four))
	 ((eq =class= '&ve) (go &vector))
	 ((eq =class= '&np) (go &npred))
	 ((eq =class= '&ch) (go &character))
	 ((eq =class= '&st) (go &string))
	 ((eq =class= '&cr) (go &coerce))
	 ((eq =class= '&io) (go &input/output))
	 ((eq =class= '&si) (go &system-interface))
	 ((eq =class= '&tr) (go &transcendental))
	 ((eq =class= '&ms) (go &misc))
	 (t (go bad-class)))

 &select
   (cond ((eq =op= 'car) (go %car))
	 ((eq =op= 'cdr) (go %cdr))
	 ((eq =op= 'caaar) (go %caaar))
	 ((eq =op= 'caadr) (go %caadr))
	 ((eq =op= 'caar) (go %caar))
	 ((eq =op= 'cadar) (go %cadar))
	 ((eq =op= 'caddr) (go %caddr))
	 ((eq =op= 'cadr) (go %cadr))
	 ((eq =op= 'cdaar) (go %cdaar))
	 ((eq =op= 'cdadr) (go %cdadr))
	 ((eq =op= 'cdar) (go %cdar))
	 ((eq =op= 'cddar) (go %cddar))
	 ((eq =op= 'cdddr) (go %cdddr))
	 ((eq =op= 'cddr) (go %cddr)))

 &list
   (cond ((eq =op= 'cons) (go %cons))
	 ((eq =op= 'set-car!) (go %set-car!))
	 ((eq =op= 'set-cdr!) (go %set-cdr!))
	 ((eq =op= 'copy-no-constant) (go %copy-no-constant))
	 ((eq =op= 'delete) (go %delete))
	 ((eq =op= 'delq) (go %delq))
	 ((eq =op= 'delv) (go %delv))
	 ((eq =op= 'last-pair) (go %last-pair))
	 ((eq =op= 'length) (go %length))
	 ((eq =op= 'member) (go %member))
	 ((eq =op= 'nth) (go %nth))
	 ((eq =op= 'list-ref) (go %list-ref))
	 ((eq =op= 'list-tail) (go %list-tail))
	 ((eq =op= 'reverse) (go %reverse))
	 ((eq =op= 'reverse!) (go %reverse!))
	 ((eq =op= 'transpose) (go %transpose)))

 &predicate
   (cond ((eq =op= 'null?) (go %null?))
	 ((eq =op= 'eq?) (go %eq?))
	 ((eq =op= 'eqv?) (go %eqv?))
	 ((eq =op= 'equal?) (go %equal?))
	 ((eq =op= 'memv) (go %memv))
	 ((eq =op= 'memq) (go %memq))
	 ((eq =op= 'assv) (go %assv))
	 ((eq =op= 'assoc) (go %assoc))
	 ((eq =op= 'assq) (go %assq))
	 ((eq =op= 'port?) (go %port?))
	 (t (go bad-op)))

 &type
  (cond ((eq =op= 'atom?) (go %atom?))
	((eq =op= 'boolean?) (go %boolean?))
	((eq =op= 'number?) (go %number?))
	((eq =op= 'rational?) (go %rational?))
	((eq =op= 'char?) (go %char?))
	((eq =op= 'string?) (go %string?))
	((eq =op= 'proc?) (go %proc?))
	((eq =op= 'integer?) (go %integer?))
	((eq =op= 'real?) (go %real?))
	((eq =op= 'complex?) (go %complex?))
	((eq =op= 'pair?) (go %pair?))
	((eq =op= 'ref?) (go %ref?))
	((eq =op= 'symbol?) (go %symbol?))
	((eq =op= 'syntactic-extension?) (go %syntactic-extension?))
	((eq =op= 'scheme-constant?) (go %scheme-constant?))
	(t (go bad-op)))

 &numeric
   (cond ((eq =op= 'add1) (go %add1))
	 ((eq =op= 'sub1) (go %sub1))
	 ((eq =op= '+) (go %+))
	 ((eq =op= '*) (go %*))
	 ((eq =op= '-) (go %-))
	 ((eq =op= 'minus) (go %minus))
	 ((eq =op= '/) (go %/))
	 ((eq =op= 'abs) (go %abs))
	 ((eq =op= 'factorial) (go %factorial))
	 ((eq =op= 'floor) (go %floor))
	 ((eq =op= 'ceiling) (go %ceiling))
	 ((eq =op= 'truncate) (go %truncate))
	 ((eq =op= 'round) (go %round))
	 ((eq =op= 'float) (go %float))
	 ((eq =op= 'quotient) (go %quotient))
	 ((eq =op= 'mod) (go %mod))
	 ((eq =op= 'remainder) (go %remainder))
	 ((eq =op= 'random) (go %random))
	 ((eq =op= 'sqrt) (go %sqrt))
	 ((eq =op= 'numerator) (go %numerator))
	 ((eq =op= 'denominator) (go %denominator))
	 ((eq =op= 'real-part) (go %real-part))
	 ((eq =op= 'imag-part) (go %imag-part))
	 ((eq =op= 'make-rect) (go %make-rect))
	 ((eq =op= 'make-polar) (go %make-polar))
	 ((eq =op= 'angle) (go %angle))
	 (t (go bad-op)))

 &select-four
   (cond ((eq =op= 'caaaar) (go %caaaar))
	 ((eq =op= 'caaadr) (go %caaadr))
	 ((eq =op= 'caadar) (go %caadar))
	 ((eq =op= 'caaddr) (go %caaddr))
	 ((eq =op= 'cadaar) (go %cadaar))
	 ((eq =op= 'cadadr) (go %cadadr))
	 ((eq =op= 'caddar) (go %caddar))
	 ((eq =op= 'cadddr) (go %cadddr))
	 ((eq =op= 'cdaaar) (go %cdaaar))
	 ((eq =op= 'cdaadr) (go %cdaadr))
	 ((eq =op= 'cdadar) (go %cdadar))
	 ((eq =op= 'cdaddr) (go %cdaddr))
	 ((eq =op= 'cddaar) (go %cddaar))
	 ((eq =op= 'cddadr) (go %cddadr))
	 ((eq =op= 'cdddar) (go %cdddar))
	 ((eq =op= 'cddddr) (go %cddddr)))
	  
 &vector
   (cond ((eq =op= 'vector-ref) (go %vector-ref))
	 ((eq =op= 'vector-set!) (go %vector-set!))
	 ((eq =op= 'primitive-make-vector) (go %primitive-make-vector))
	 ((eq =op= 'vector-length) (go %vector-length))
	 ((eq =op= 'vector->list) (go %vector->list))
	 ((eq =op= 'list->vector) (go %list->vector))
	 ((eq =op= 'vector-fill!) (go %vector-fill!))
	 ((eq =op= 'vector?) (go %vector?)))

 &npred
   (cond ((eq =op= '=0) (go %=0))
	 ((eq =op= '=) (go %=))
	 ((eq =op= '<) (go %<))
	 ((eq =op= '>) (go %>))
	 ((eq =op= '>0) (go %>0))
	 ((eq =op= '<0) (go %<0))
	 ((eq =op= '<=) (go %<=))
	 ((eq =op= '>=) (go %>=))
	 ((eq =op= 'even?) (go %even?))
	 ((eq =op= 'odd?) (go %odd?))
	 (t (go bad-op)))

 &character
   (cond ((eq =op= 'char=?) (go %char=?))
	 ((eq =op= 'char<?) (go %char<?))
	 ((eq =op= 'char>?) (go %char>?))
	 ((eq =op= 'char<=?) (go %char<=?))
	 ((eq =op= 'char>=?) (go %char>=?))
	 ((eq =op= 'char-ci=?) (go %char-ci=?))
	 ((eq =op= 'char-ci<?) (go %char-ci<?))
	 ((eq =op= 'char-ci>?) (go %char-ci>?))
	 ((eq =op= 'char-ci<=?) (go %char-ci<=?))
	 ((eq =op= 'char-ci>=?) (go %char-ci>=?))
	 ((eq =op= 'char-alpha?) (go %char-alpha?))
	 ((eq =op= 'char-num?) (go %char-num?))
	 ((eq =op= 'char-ws?) (go %char-ws?))
	 ((eq =op= 'char-up?) (go %char-up?))
	 ((eq =op= 'char-lo?) (go %char-lo?))
	 ((eq =op= 'charup) (go %charup))
	 ((eq =op= 'chardown) (go %chardown)))

 &string
   (cond ((eq =op= 'str=?) (go %str=?))
	 ((eq =op= 'str<?) (go %str<?))
	 ((eq =op= 'str>?) (go %str>?))
	 ((eq =op= 'str<=?) (go %str<=?))
	 ((eq =op= 'str>=?) (go %str>=?))
	 ((eq =op= 'str-ci=?) (go %str-ci=?))
	 ((eq =op= 'str-ci<?) (go %str-ci<?))
	 ((eq =op= 'str-ci>?) (go %str-ci>?))
	 ((eq =op= 'str-ci<=?) (go %str-ci<=?))
	 ((eq =op= 'str-ci>=?) (go %str-ci>=?))
	 ((eq =op= 'str-ref) (go %str-ref))
	 ((eq =op= 'substring) (go %substring))
	 ((eq =op= 'str-set!) (go %str-set!))
	 ((eq =op= 'prim-make-str) (go %prim-make-str))
	 ((eq =op= 'str-append) (go %str-append))
	 ((eq =op= 'str-copy) (go %str-copy))
	 ((eq =op= 'str-fill!) (go %str-fill!))
	 ((eq =op= 'str-up) (go %str-up))
	 ((eq =op= 'str-down) (go %str-down))
	 ((eq =op= 'str-cap) (go %str-cap))
	 ((eq =op= 'sym<?) (go %sym<?))
	 ((eq =op= 'sym>?) (go %sym>?)))

 &coerce
   (cond ((eq =op= 'ascii->symbol) (go %ascii->symbol))
	 ((eq =op= 'symbol->ascii) (go %symbol->ascii))
	 ((eq =op= 'symbol->string) (go %symbol->string))
	 ((eq =op= 'string->symbol) (go %string->symbol))
	 ((eq =op= 'string->uninterned) (go %string->uninterned))
	 ((eq =op= 'char->int) (go %char->int))
	 ((eq =op= 'int->char) (go %int->char))
	 ((eq =op= 'string->list) (go %string->list))
	 ((eq =op= 'list->string) (go %list->string))
	 ((eq =op= 'rational) (go %rational))
	 ((eq =op= 'rationalize) (go %rationalize))
	 ((eq =op= 'string->number) (go %string->number)))

 &input/output
   (cond  ((eq =op= 'close) (go %close))
	  ((eq =op= 'file-exists?) (go %file-exists?))
	  ((eq =op= 'open-input-file) (go %open-input-file))
	  ((eq =op= 'open-output-file) (go %open-output-file))
	  ((eq =op= 'open-append-file) (go %open-append-file))
	  ((eq =op= 'print-length) (go %print-length))
	  ((eq =op= 'prompt-read) (go %prompt-read))
	  ((eq =op= 'eof-object?) (go %eof-obj?))
	  ((eq =op= 'curr-in-port) (go %curr-in-port))
	  ((eq =op= 'curr-out-port) (go %curr-out-port)))

 &system-interface
   (cond  ((eq =op= 'compile) (go %compile))
	  ((eq =op= 'mkmac-match?) (go %mkmac-match?))
	  ((eq =op= 'add-to-syntax-table) (go %add-to-syntax-table))
	  ((eq =op= 'beta-expand) (go %beta-expand))
	  ((eq =op= 'expand-once) (go %expand-once))
;	  ((eq =op= 'pp-exp) (go %pp-exp))
	  ((eq =op= 'copying-intern*) (go %copying-intern*))
	  ((eq =op= 'beta-tag) (go %beta-tag))
	  ((eq =op= 'exit) (go %exit))
	  ((eq =op= 'reset) (go %reset))
	  ((eq =op= 'declare-constant) (go %declare-constant))
	  ((eq =op= 'undeclare-constant) (go %undeclare-constant))
	  ((eq =op= 'function-alias) (go %function-alias))
	  ((eq =op= 'gc) (go %gc))
	  ((eq =op= 'top-level-ids) (go %top-level-ids))
	  ((eq =op= 'scheme-constants) (go %scheme-constants))
	  ((eq =op= 'beta-transforms) (go %beta-transforms))
	  ((eq =op= 'base-identifiers) (go %base-identifiers))
	  ((eq =op= 'scheme-primitives) (go %scheme-primitives))
	  ((eq =op= 'system-functions) (go %system-functions))
	  ((eq =op= 'reify) (go %reify))
	  ((eq =op= 'global-namespace-type) (go %global-namespace-type))
	  ((eq =op= 'import) (go %import))
	  ((eq =op= 'lisp-eval) (go %lisp-eval))
	  ((eq =op= 'make-printable) (go %make-printable))
	  ((eq =op= 'make-unprintable) (go %make-unprintable))
	  ((eq =op= 'remove-from-namespace) (go %remove-from-namespace))
	  ((eq =op= 'scheme-reset) (go %scheme-reset))
	  ((eq =op= 'transcript-off) (go %transcript-off))
	  ((eq =op= 'transcript-on) (go %transcript-on))
;	  ((eq =op= 'add-mkmac-name) (go %add-mkmac-name))
;	  ((eq =op= 'remove-mkmac-name) (go %remove-mkmac-name))
	  ((eq =op= 'set-lexical-semantics) (go %set-lexical-semantics))
	  ((eq =op= 'set-application-semantics)
	   (go %set-application-semantics))
	  ((eq =op= 'set-literal-semantics) (go %set-literal-semantics))
	  ((eq =op= 'scoped?) (go %scoped?))
	  (t (go bad-op)))

 &transcendental
  (cond  ((eq =op= 'arccos) (go %arccos))
	 ((eq =op= 'arcsin) (go %arcsin))
	 ((eq =op= 'arctan) (go %arctan)) ; 1-Mar-85
	 ((eq =op= 'atan) (go %atan))
	 ((eq =op= 'cos) (go %cos))
	 ((eq =op= 'exp) (go %exp))
	 ((eq =op= 'expt) (go %expt))
	 ((eq =op= 'log) (go %log))
	 ((eq =op= 'sin) (go %sin))
	 ((eq =op= 'tan) (go %tan))
	 ((eq =op= 'arccos) (go %arccos))
	 ((eq =op= 'arcsin) (go %arcsin))
	 ((eq =op= 'arctan) (go %arctan))
	 ((eq =op= 'cosh) (go %cosh))
	 ((eq =op= 'sinh) (go %sinh))
	 ((eq =op= 'tanh) (go %tanh))
	 ((eq =op= 'arccosh) (go %arccosh))
	 ((eq =op= 'arcsinh) (go %arcsinh))
	 ((eq =op= 'arctanh) (go %arctanh))
	 (t (go bad-op)))
  
 &misc
   (cond
     ((eq =op= 'C) (go %C))
     ((eq =op= 'append-cont) (go %append-cont))
     ((eq =op= 'partial-cont) (go %partial-cont))
     ((eq =op= 'T) (go %T))
     ((eq =op= 'try) (go %try))
     ((eq =op= 'exit-try) (go %exit-try))
     ((eq =op= 'execute) (go %execute))
     ((eq =op= 'apply) (go %apply))
     ((eq =op= 'result) (go %result))
     ((eq =op= 'deref) (go %deref))
     ((eq =op= 'explode) (go %explode))
     ((eq =op= 'genbase) (go %genbase))
     ((eq =op= 'gensym) (go %gensym))
     ((eq =op= 'getprop) (go %getprop))
     ((eq =op= 'global-binding) (go %global-binding))
     ((eq =op= 'implode) (go %implode))
     ((eq =op= 'proplist) (go %proplist))
     ((eq =op= 'putprop) (go %putprop))
     ((eq =op= 'ref) (go %ref))
     ((eq =op= 'remprop) (go %remprop))
     ((eq =op= 'set-ref!) (go %set-ref!))
     ((eq =op= 'subst) (go %subst))
     ((eq =op= 'swap-ref!) (go %swap-ref!))
     (t (go bad-op)))


 %car (setq **result** (if (and (consp **result**)
                                (not (assq (car **result**)
                                           (lookupinbase 'unprintables))))
			   (progn (setq **result** (car **result**))
				  (go loop))
			   (raise (list 'SE%vsm '|Bad argument to car:|
					 **result**))))
 %cdr (setq **result** (if (and (consp **result**)
                                (not (assq (car **result**)
                                           (lookupinbase 'unprintables))))
			   (progn (setq **result** (cdr **result**))
				  (go loop))
			   (raise (list 'SE%vsm '|Bad argument to cdr:|
					**result**))))
 %caaar (setq **result** (caar **result**)) (go %car)
 %caadr (setq **result** (cadr **result**)) (go %car)
 %caar (setq **result** (car **result**)) (go %car)
 %cadar (setq **result** (cdar **result**)) (go %car)
 %caddr (setq **result** (cddr **result**)) (go %car)
 %cadr (setq **result** (cdr **result**)) (go %car)
 %cdaar (setq **result** (caar **result**)) (go %cdr)
 %cdadr (setq **result** (cadr **result**)) (go %cdr)
 %cdar (setq **result** (car **result**)) (go %cdr)
 %cddar (setq **result** (cdar **result**)) (go %cdr)
 %cdddr (setq **result** (cddr **result**)) (go %cdr)
 %cddr (setq **result** (cdr **result**)) (go %cdr)
 %caaaar (setq **result** (caaar **result**)) (go %car)
 %caaadr (setq **result** (caadr **result**)) (go %car)
 %caadar (setq **result** (cadar **result**)) (go %car)
 %caaddr (setq **result** (caddr **result**)) (go %car)
 %cadaar (setq **result** (cdaar **result**)) (go %car)
 %cadadr (setq **result** (cdadr **result**)) (go %car)
 %caddar (setq **result** (cddar **result**)) (go %car)
 %cadddr (setq **result** (cdddr **result**)) (go %car)
 %cdaaar (setq **result** (caaar **result**)) (go %cdr)
 %cdaadr (setq **result** (caadr **result**)) (go %cdr)
 %cdadar (setq **result** (cadar **result**)) (go %cdr)
 %cdaddr (setq **result** (caddr **result**)) (go %cdr)
 %cddaar (setq **result** (cdaar **result**)) (go %cdr)
 %cddadr (setq **result** (cdadr **result**)) (go %cdr)
 %cdddar (setq **result** (cddar **result**)) (go %cdr)
 %cddddr (setq **result** (cdddr **result**)) (go %cdr)
 %cons (setq **result** (cons **result** (top-stack))) (go pop1)
; %set-car!!
;   (if	(not (consp **result**))
;	(raise (list 'SE%vsm '|Bad argument to set-car!:| **result**)))
;   (setq **result** (rplaca **result** (top-stack))) (go pop1)
 %set-car!
   (if	(consp **result**)
	(if (assq (car **result**) (lookupinbase 'unprintables))
	    (raise (list 'SE%vsm '|Illegal argument to set-car! :|
			 **result**))
	    (progn (setq **result** (rplaca **result** (top-stack)))
		   (go pop1)))
	(raise (list 'SE%vsm '|Bad argument to set-car!:| **result**)))
 %set-cdr!
   (if	(consp **result**)
	(if (proc? **result**)
	    (raise (list 'SE%vsm '|Illegal argument to set-cdr! :|
			 **result**))
	    (progn (setq **result** (rplacd **result** (top-stack)))
		   (go pop1)))
 	(raise (list 'SE%vsm '|Bad argument to set-cdr! :| **result**)))

 %copy-no-constant (setq **result** (copy-no-constant **result**)) (go loop)
 %delete (setq **result** (delete-equal **result** (top-stack))) (go pop1)
 %delq (setq **result** (delq **result** (top-stack))) (go pop1)
 %delv (setq **result** (delv **result** (top-stack))) (go pop1)
 %last-pair (setq **result** (last **result**)) (go loop)
 %length (setq **result** (length **result**)) (go loop)
 %member (setq **result** (member-equal **result** (top-stack))) (go pop1)
 %nth (setq **result** (nth (1- **result**) (top-stack))) (go pop1)
 %list-ref (setq **result** (nth (top-stack) **result**)) (go pop1)
 %list-tail (setq **result** (nthcdr (top-stack) **result**)) (go pop1)
 %reverse (setq **result** (reverse **result**)) (go loop)
 %reverse! (setq **result** (nreverse **result**)) (go loop)
 %transpose (setq **result** (transpose **result**)) (go loop)
 %null? (setq **result** (null **result**)) (go loop)
 %eq? (setq **result** (eq **result** (top-stack))) (go pop1)
 %eqv? (setq **result** (eqv **result** (top-stack))) (go pop1)
 %equal? (setq **result** (or (equal **result** (top-stack))
			      (vactor-equal? **result** (top-stack))))
         (go pop1)
 %memv (setq **result** (memv **result** (top-stack))) (go pop1)
 %memq (setq **result** (memq **result** (top-stack))) (go pop1)
 %assv (setq **result** (assv **result** (top-stack))) (go pop1)
 %assoc (setq **result** (assoc-equal **result** (top-stack))) (go pop1)
 %assq (setq **result** (assq **result** (top-stack))) (go pop1)
 %port? (setq **result** (port? **result**)) (go loop)
 %atom? (setq **result** (atom **result**)) (go loop)
 %boolean? (setq **result** (or (eq t **result**) (null **result**))) (go loop)
 %number? (setq **result** (numberp **result**)) (go loop)
 %rational? (setq **result** (rationalp **result**)) (go loop)
 %char? (setq **result** (characterp **result**)) (go loop)
 %string? (setq **result** (stringp **result**)) (go loop)
 %proc? (setq **result** (proc? **result**)) (go loop)
 %integer? (setq **result** (integerp **result**)) (go loop)
 %real? (setq **result** (or (rationalp **result**)
			     (floatp **result**))) (go loop)
 %complex? (setq **result** (or (floatp **result**)
				(complexp **result**)
				(rationalp **result**))) (go loop)
 %pair?
   (setq **result**
     (and (consp **result**)
	  (not (memq (car **result**) unprintable-symbols))))
   (go loop)
 %ref?
   (setq **result** (and (consp **result**) (eq '&ref (car **result**))))
   (go loop)
 %symbol? (setq **result** (and (symbolp **result**)
				(not (member **result** (list t nil)))))
   (go loop)
 %syntactic-extension?
   (setq **result** (syntactic-extension? **result**)) (go loop)
 %scheme-constant? (setq **result** (scheme-constant? **result**)) (go loop)
 %add1 (setq **result** (1+ **result**)) (go loop)
 %sub1 (setq **result** (1- **result**)) (go loop)
 %+ (setq **result** (+ **result** (top-stack))) (go pop1)
 %* (setq **result** (* **result** (top-stack))) (go pop1)
 %- (setq **result** (- **result** (top-stack))) (go pop1)
 %minus (setq **result** (- **result**)) (go loop)
 %/ (setq **result** (/ **result** (top-stack))) (go pop1)
 %abs (setq **result** (abs **result**)) (go loop)
 %factorial (setq **result** (fact **result**)) (go loop)
 %floor (setq **result** (floor **result**)) (go loop)
 %ceiling (setq **result** (ceiling **result**)) (go loop)
 %truncate (setq **result** (truncate **result**)) (go loop)
 %round (setq **result** (round **result**)) (go loop)
 %float (setq **result** (float **result**)) (go loop)
 %quotient (setq **result** (quotient **result** (top-stack))) (go pop1)
 %mod (setq **result** (mod **result** (top-stack))) (go pop1)
 %remainder (setq **result** (rem **result** (top-stack))) (go pop1)
 %random (setq **result** (random **result**)) (go loop)
 %sqrt (setq **result** (sqrt **result**)) (go loop)
 %numerator (setq **result** (numerator **result**)) (go loop)
 %denominator (setq **result** (denominator **result**)) (go loop)
 %real-part (setq **result** (realpart **result**)) (go loop)
 %imag-part (setq **result** (imagpart **result**)) (go loop)
 %make-rect (setq **result** (complex **result** (top-stack))) (go pop1)
 %make-polar (setq **result** (* **result** (cis (top-stack)))) (go pop1)
 %angle (setq **result** (phase **result**)) (go loop)

 %vector? (setq **result** (vactor? **result**)) (go loop)
 %list->vector (setq **result** (list->vactor **result**)) (go loop)
 %vector->list (setq **result** (vactor->list **result**)) (go loop)
 %vector-ref (setq **result** (vactor-ref **result** (top-stack))) (go pop1)
 %vector-set!
   (setq **result** (vactor-set! **result** (top-stack) (2nd-stack)))
   (go pop2)
 %vector-length (setq **result** (vactor-length **result**)) (go loop)
 %vector-fill!
   (setq **result** (vactor-fill! **result** (top-stack))) (go pop1)
 %primitive-make-vector (setq **result** (make-vactor **result**)) (go loop)

 %=0 (setq **result** (and (numberp **result**) (zerop **result**))) (go loop)
 %= (setq **result** (= **result** (top-stack))) (go pop1)
 %< (setq **result** (< **result** (top-stack))) (go pop1)
 %> (setq **result** (> **result** (top-stack))) (go pop1)
 %>0 (setq **result** (plusp **result**)) (go loop)
 %<0 (setq **result** (minusp **result**)) (go loop)
 %>= (setq **result** (>= **result** (top-stack))) (go pop1)
 %<= (setq **result** (<= **result** (top-stack))) (go pop1)
 %even? (setq **result** (evenp **result**)) (go loop)
 %odd? (setq **result** (oddp **result**)) (go loop)

 %char=? (setq **result** (char= **result** (top-stack))) (go pop1)
 %char>? (setq **result** (char> **result** (top-stack))) (go pop1)
 %char<? (setq **result** (char< **result** (top-stack))) (go pop1)
 %char>=? (setq **result** (char>= **result** (top-stack))) (go pop1)
 %char<=? (setq **result** (char<= **result** (top-stack))) (go pop1)
 %char-ci=? (setq **result** (char-equal **result** (top-stack))) (go pop1)
 %char-ci>? (setq **result** (char-greaterp **result** (top-stack))) (go pop1)
 %char-ci<? (setq **result** (char-lessp **result** (top-stack))) (go pop1)
 %char-ci>=? (setq **result** (char-not-lessp **result** (top-stack))) (go pop1)
 %char-ci<=? (setq **result** (char-not-greaterp **result** (top-stack))) (go pop1)
 %char-alpha? (setq **result** (alpha-char-p **result**)) (go loop)
 %char-num? (setq **result** (digit-char-p **result**)) (go loop)
 %char-ws? (setq **result** (memq **result** '(#\Space #\Tab #\Newline #\Page #\Backspace))) (go loop)
 %char-up? (setq **result** (upper-case-p **result**)) (go loop)
 %char-lo? (setq **result** (lower-case-p **result**)) (go loop)
 %charup (setq **result** (char-upcase **result**)) (go loop)
 %chardown (setq **result** (char-downcase **result**)) (go loop)

 %str=? (setq **result** (string= **result** (top-stack))) (go pop1)
 %str<? (setq **result** (string< **result** (top-stack))) (go pop1)
 %str>? (setq **result** (string> **result** (top-stack))) (go pop1)
 %str<=? (setq **result** (string<= **result** (top-stack))) (go pop1)
 %str>=? (setq **result** (string>= **result** (top-stack))) (go pop1)
 %str-ci=? (setq **result** (string-equal **result** (top-stack))) (go pop1)
 %str-ci<? (setq **result** (string-lessp **result** (top-stack))) (go pop1)
 %str-ci>? (setq **result** (string-greaterp **result** (top-stack))) (go pop1)
 %str-ci<=? (setq **result** (string-not-greaterp **result** (top-stack))) (go pop1)
 %str-ci>=? (setq **result** (string-not-lessp **result** (top-stack))) (go pop1)
 %str-ref (setq **result** (char **result** (top-stack))) (go pop1)
 %substring
   (setq **result** (subseq **result** (top-stack) (2nd-stack))) (go pop2)
 %str-set! (setq **result** (setf (char **result** (top-stack)) (2nd-stack)))
   (go pop2)
 %prim-make-str (setq **result** (if (null (cdr **result**))
				     (make-string (car **result**))
				     (make-string (car **result**)
					:initial-element (cadr **result**))))
   (go loop)
 %str-append (setq **result** (concatenate 'string **result** (top-stack)))
   (go pop1)
 %str-copy (setq **result** (copy-seq **result**)) (go loop)
 %str-fill! (setq **result** (fill **result** (top-stack))) (go pop1)
 %str-up (setq **result** (string-upcase **result**)) (go loop)
 %str-down (setq **result** (string-downcase **result**)) (go loop)
 %str-cap (setq **result** (string-capitalize **result**)) (go loop)
 %sym<? (setq **result** (symbol<? **result** (top-stack))) (go pop1)
 %sym>? (setq **result** (symbol>? **result** (top-stack))) (go pop1)

 %string->symbol (setq **result** (intern **result**)) (go loop)
 %symbol->string (setq **result** (string-downcase (symbol-name **result**)))
   (go loop)
 %ascii->symbol (setq **result** (ascii->symbol **result**)) (go loop)
 %symbol->ascii (setq **result** (symbol->ascii **result**)) (go loop)
 %char->int (setq **result** (char-int **result**)) (go loop)
 %int->char (setq **result** (int-char **result**)) (go loop)
 %string->uninterned (setq **result** (make-symbol **result**)) (go loop)
 %string->list (setq **result** (coerce **result** 'list)) (go loop)
 %list->string (setq **result** (coerce **result** 'string)) (go loop)
 %rational (setq **result** (rational **result**)) (go loop)
 %rationalize (setq **result** (rationalize **result**)) (go loop)
 %string->number
	(let ((*read-base*
		 (case (top-stack)
		       ('B 2) ('O 8) ('D 10) ('X 16)
		       (else (raise (list 'SE%vsm
					  '|Bad radix for string->number :|
					  (top-stack)))))))
	     (setq =temp= (multiple-value-list
				(read-from-string **result**)))
	     (cond ((not (numberp (car =temp=)))
				(raise (list 'SE%vsm
					     '|String does not represent a number in string->number:|
					     **result**)))
		   ((< (cadr =temp=) (length **result**))
				(raise (list 'SE%vsm
					     '|String not consumed in string->number :|
					     **result**)))
		   (t (setq **result** (car =temp=)))))
	(go pop1)
 %close (setq **result** (schclose **result**)) (go loop)
 %file-exists?
   (setq **result** (probe-file (if (stringp **result**)
				    **result**
				    (string-downcase (symbol-name **result**)))))
   (go loop)
 %open-input-file
   (setq **result** (open-input-file (if (stringp **result**)
					 **result**
				         (string-downcase (symbol-name **result**)))))
   (go loop)
 %open-output-file
   (setq **result** (open-output-file (if (stringp **result**)
					  **result**
					  (string-downcase (symbol-name **result**)))))
   (go loop)
 %open-append-file
   (setq **result** (open-append-file (if (stringp **result**)
					  **result**
					  (string-downcase (symbol-name **result**)))))
   (go loop)
 %print-length (setq **result** (length (princ-to-string **result**))) (go loop)
 %prompt-read (setq **result** (prompt-read **result**)) (go loop)
 %eof-obj? (setq **result** (eq **result** (eof))) (go loop)
 %curr-in-port (setq **result** (standard-input)) (go loop)
 %curr-out-port (setq **result** (standard-output)) (go loop)

 %compile (setq **result** (compile **result**)) (go loop)
 %mkmac-match?
   (setq **result** (mkmac-match? **result** (top-stack) (2nd-stack)))
   (go pop2)
 %declare-constant (declare-constant **result**) (go loop)
 %undeclare-constant (undeclare-constant **result**) (go loop)
 %exit (bye)
 %add-to-syntax-table
   (setq **result** (add-to-syntax-table **result** (top-stack))) (go pop1)
 %beta-expand (setq **result** (beta-expand **result**)) (go loop)
 %expand-once (setq **result** (expand-once **result**)) (go loop)
; %pp-exp ($prpr **result**) (setq **result** (terpri)) (go loop); ??jg??
 %copying-intern* (setq **result** (copying-intern* **result**)) (go loop)
 %beta-tag (setq **result** (tag-frees **result** nil)) (go loop)
 %function-alias
   (setq **result** (function-alias **result** (top-stack))) (go pop1)
 %gc (setq **result** (gbc (cond ((eq **result** 3) t)
				 ((eq **result** 2) 'foo)
				 (t nil)))) (go loop)
 %top-level-ids (setq **result** (top-level-assigned-identifiers)) (go loop)
 %scheme-constants (setq **result** (symbols-bound-to-constants)) (go loop)
 %beta-transforms (setq **result** (beta-transforms)) (go loop)
 %base-identifiers (setq **result** (base-identifiers))  (go loop)
 %scheme-primitives (setq **result** (scheme-primitives)) (go loop)
 %system-functions (setq **result** (system-functions)) (go loop)
 %reify (setq **result** (reify **result**)) (go loop)
 %global-namespace-type
   (setq **result** (global-namespacetype **result**)) (go loop)
 %import (setq **result** (schimport **result**)) (go loop)
 %lisp-eval (setq **result** (eval **result**)) (go loop)
 %make-printable (setq **result** (make-printable **result**)) (go loop)
 %make-unprintable
   (setq **result** (make-unprintable **result** (top-stack))) (go pop1)
 %remove-from-namespace
   (setq **result** (remove-from-namespace **result**)) (go loop)
 %reset (setq **result** (reset)) (go loop)
 %scheme-reset (setq **result** (scheme-reset)) (go loop)
 %transcript-off (setq **result** (transcript-off)) (go loop)
 %transcript-on (setq **result**
		      (transcript-on (if (stringp **result**)
					 **result**
					 (symbol-name **result**))))
   (go loop)
; %add-mkmac-name (setq **result** (add-mkmac-name **result**)) (go loop)
; %remove-mkmac-name (setq **result** (remove-mkmac-name **result**))
   (go loop)
 %set-lexical-semantics
   (set-lexical-semantics **result**) (setq **result** t) (go loop)
 %set-application-semantics
   (set-application-semantics **result**) (setq **result** t) (go loop)
 %set-literal-semantics
   (set-literal-semantics **result**) (setq **result** t) (go loop)
 %scoped? (setq **result** (memq **result** (car **comp-env**))) (go loop)
 %arccos (setq **result** (acos **result**)) (go loop)
 %arcsin (setq **result** (asin **result**)) (go loop)
 %arctan (setq **result** (atan **result** 1)) (go loop) ; 1-Mar-85
 %atan (setq **result** (atan **result** (top-stack))) (go pop1)	     
 %cos (setq **result** (cos **result**)) (go loop)
 %exp (setq **result** (exp **result**)) (go loop)
 %expt (setq **result** (expt **result** (top-stack))) (go pop1)
 %log (setq **result** (log **result**)) (go loop)
 %sin (setq **result** (sin **result**)) (go loop)
 %tan (setq **result** (tan **result**)) (go loop)
 %cosh (setq **result** (cosh **result**)) (go loop)
 %sinh (setq **result** (sinh **result**)) (go loop)
 %tanh (setq **result** (tanh **result**)) (go loop)
 %arccosh (setq **result** (acosh **result**)) (go loop)
 %arcsinh (setq **result** (asinh **result**)) (go loop)
 %arctanh (setq **result** (atanh **result**)) (go loop)
 %result (return **result**)
 %deref (setq **result** (cdr **result**)) (go loop)
 %explode (setq **result** (string-downcase (explode **result**))) (go loop)
 %genbase (setq **result** (genbase)) (go loop);
 %gensym (setq **result** (gensym (if (or (numberp **result**)
					  (stringp **result**))
				      **result**
				      (symbol-name **result**))))
         (go loop)
 %getprop (setq **result** (get **result** (top-stack))) (go pop1)
 %global-binding (setq **result** (global-binding **result**)) (go loop)
 %implode (setq **result** (implode **result**)) (go loop)
 %proplist (setq **result** (plist **result**)) (go loop)
 %putprop
   (setq **result** (putprop **result** (top-stack) (2nd-stack))) (go pop2)
 %ref (setq **result** (cons '&ref **result**)) (go loop)
 %remprop (setq **result** (remprop **result** (top-stack))) (go pop1)
 %set-ref! (setq **result** (rplacd **result** (top-stack))) (go pop1)
 %subst
   (setq **result** (subst **result** (top-stack) (2nd-stack))) (go pop2)
 %swap-ref! (setq =temp= (cdr **result**))
            (rplacd **result** (top-stack))
	    (setq **result** =temp=)
	    (go pop1)

 pop1 (setq **args** (cdr **args**)) (go loop)
 pop2 (setq **args** (cddr **args**)) (go loop)
 pop3 (setq **args** (cdddr **args**)) (go loop)

 bad-class (setq *error* =class=) (scherror "Bad primitive class")
 bad-op (setq *error* =op=) (scherror "Bad primitive op")
 bad-vsm-opcode (setq *error* =opcode=) (scherror "Bad vsm opcode")

 bad-function
   (setq *error* **cont**)
   (setq *error-args* **args**)
   (setq *error-data* **result**)
   (scherror "Bad function")

 wrong-number-of-args-to-closure
   (setq *error* **cont**)
   (setq *error-res* **result**)
   (setq *error-data* **args**)
   (scherror "Wrong number of arguments to closure")

 wrong-number-args-to-vector
   (setq *error* **result**)
   (setq *error-data* **args**)
   (scherror "Wrong number of arguments to vector")

 wrong-number-of-args-to-continuation
   (setq *error* **cont**)
   (setq *error-data* **args**)
   (scherror "Wrong number of arguments to continuation")))

(defun properargs (l)
    (if	(proc? l)
	(raise (list 'SE%vsm '|Illegal argument to apply:| l))
	(good-args l l)))

(defun good-args (l args)
    (cond
      ((consp l) (cons (car l) (good-args (cdr l) args)))
      ((null l)  nil)
      (t         (raise (list 'SE%vsm '|Illegal argument to apply:| args)))))

(defun copy-cont (k1 k2)
      (cond
	 ((eq k1 k2) nil)
	 ((null k1)  (scherror "Error 53 (partial-cont)"))
	 (t          (cons (car k1) (copy-cont (cdr k1) k2)))))

)
