;;; Interfaces and packages for the NetBSD specific parts of scsh.
;;; Copyright (c) 1994 by Olin Shivers.
;;; Copyright (c) 1994 by Brian D. Carlstrom.

(define-interface netbsd-fdflags-extras-interface
  (export open/shlock
	  open/exlock
	  open/async
	  open/fsync
	  fcntl/get-owner
	  fcntl/set-owner))

(define-interface netbsd-errno-extras-interface
  (export errno/deadlk
	  errno/notblk	  
	  errno/txtbsy
	  errno/wouldblock
	  errno/inprogress
	  errno/already
	  errno/notsock
	  errno/destaddrreq
	  errno/msgsize
	  errno/prototype
	  errno/noprotoopt
	  errno/protonosupport
	  errno/socktnosupport
	  errno/opnotsupp
	  errno/pfnosupport
	  errno/afnosupport
	  errno/addrinuse
	  errno/addrnotavail
	  errno/netdown
	  errno/netunreach
	  errno/netreset
	  errno/connaborted
	  errno/connreset
	  errno/nobufs
	  errno/isconn
	  errno/notconn
	  errno/shutdown
	  errno/toomanyrefs
	  errno/timedout
	  errno/connrefused
	  errno/loop
	  errno/hostdown
	  errno/hostunreach
	  errno/proclim
	  errno/users
	  errno/dquot
	  errno/stale
	  errno/remote
	  errno/badrpc
	  errno/rpcmismatch
	  errno/progunavail
	  errno/progmismatch
	  errno/nolck
	  errno/ftype 
	  errno/auth
	  errno/needauth
	  errno/last))

(define-interface netbsd-signals-extras-interface
  (export signal/trap
	  signal/emt
	  signal/bus
	  signal/sys
	  signal/urg
	  signal/cld
	  signal/io
	  signal/xcpu
	  signal/xfsz
	  signal/vtalrm
	  signal/prof
	  signal/winch
	  signal/info))

(define-interface netbsd-network-extras-interface
  (export socket/debug
	  socket/accept-connect
	  socket/reuse-address
	  socket/keep-alive
	  socket/dont-route
	  socket/broadcast
	  socket/use-loop-back
	  socket/linger
	  socket/oob-inline
	  socket/reuse-port		;netbsd
;	  socket/use-privileged
;	  socket/cant-signal
	  socket/send-buffer
	  socket/receive-buffer
	  socket/send-low-water
	  socket/receive-low-water
	  socket/send-timeout
	  socket/receive-timeout
	  socket/error
	  socket/type
;;; all ip/* but ip/options and ip/time-to-live netbsd only
	  ip/options
	  ip/header-included
	  ip/type-of-service
	  ip/time-to-live		
	  ip/receive-options	
	  ip/response-options	
	  ip/destination-address	
	  ip/ret-options		
	  ip/multicast-if		
	  ip/multicast-ttl	
	  ip/multicast-loop	
	  ip/add-membership	
	  ip/drop-membership	
	  tcp/no-delay
	  tcp/max-segment
	  message/eor
	  message/trunc
	  message/ctrunc
	  message/wait-all
	  message/dont-wait))

(define-interface netbsd-extras-interface
  (compound-interface netbsd-errno-extras-interface
		      netbsd-fdflags-extras-interface
		      netbsd-network-extras-interface
		      netbsd-signals-extras-interface))

(define-interface netbsd-defs-interface
  (compound-interface netbsd-extras-interface
		      sockets-network-interface
		      posix-errno-interface
		      posix-fdflags-interface
		      posix-signals-interface))

(define-structure netbsd-defs netbsd-defs-interface
  (open scheme bitwise)
  (files enumconst fdflags errno signals netconst))
