;;; Flags for open(2) and fcntl(2).
;;; Copyright (c) 1993 by Olin Shivers.
;;; Copyright (c) 1994 by Brian D. Carlstrom.

(define-syntax define-open-flags
  (syntax-rules ()
    ((define-errnos form ...)
     (begin (define-enum-constant "open" . form) ...))))

(define-open-flags
  (read			#o000)
  (write		#o001)
  (read+write		#o002)
  (append		#o00010)
  (create		#o01000)
  (exclusive		#o04000)
  (no-control-tty	#o20000000)
  (nonblocking		#o4000000)
  (truncate		#o2000)
;;; Not POSIX.
  (no-delay		#o0004)
  (sync			#o100000)
;  (blkinuse     	#o10000)
;  (blkandset    	(bitwise-ior #o10000 #o20000)) 
  (termio		#o10000000)
  )

(define open/access-mask
  (bitwise-ior open/read
	       (bitwise-ior open/write open/read+write)))

(define fcntl/close-on-exec 1)
(define	fcntl/dupfd 0)
(define	fcntl/get-fd-flags 1)
(define	fcntl/set-fd-flags 2)
(define	fcntl/get-file-flags 3)
(define	fcntl/set-file-flags 4)
(define	fcntl/get-record-lock 7)
(define	fcntl/set-record-lock 8)
(define	fcntl/record-lock 9)
(define	lock/read 1)
(define	lock/write 2)
(define	lock/release 3)
