;;; Interfaces and packages for the machine specific parts of scsh for Ultrix.
;;; Copyright (c) 1994 by Olin Shivers.
;;; Copyright (c) 1994 by Brian D. Carlstrom.

(define-interface ultrix-fdflags-extras-interface
  (export open/no-delay
	  open/sync
;	  open/bklinuse
;	  open/bklandset
	  open/termio
	  ))

(define-interface ultrix-errno-extras-interface
  (export errno/addrinuse
	  errno/addrnotavail
	  errno/afnosupport
	  errno/align
	  errno/already
	  errno/connaborted
	  errno/connrefused
	  errno/connreset
	  errno/destaddrreq
	  errno/dquot
	  errno/hostdown
	  errno/hostunreach
	  errno/idrm
	  errno/inprogress
	  errno/isconn
	  errno/loop
	  errno/msgsize
	  errno/netdown
	  errno/netreset
	  errno/netunreach
	  errno/nobufs
	  errno/nomsg
	  errno/noprotoopt
	  errno/notblk
	  errno/notconn
	  errno/notsock
	  errno/opnotsupp
	  errno/pfnosupport
	  errno/proclim
	  errno/protonosupport
	  errno/prototype
	  errno/remote
	  errno/shutdown
	  errno/socktnosupport
	  errno/stale
	  errno/timedout
	  errno/toomanyrefs
	  errno/users
	  errno/wouldblock
	  errno/xtbsy
	  errno/active		
	  errno/noactive		
	  errno/noresources		
	  errno/nosystem		
	  errno/nodust		
	  errno/dupnoconn		
	  errno/dupnodisconn		
	  errno/dupnotcntd		
	  errno/dupnotidle		
	  errno/dupnotwait		
	  errno/dupnotrun		
	  errno/dupbadopcode		
	  errno/dupintransit		
	  errno/duptoomanycpus	
	  ))

(define-interface ultrix-signals-extras-interface
  (export signal/cld
	  signal/iot
	  signal/trap
	  signal/emt
	  signal/io  
	  signal/urg
	  signal/xcpu
	  signal/xfsz
	  signal/vtalrm
	  signal/prof 
	  signal/winch
	  signal/lost	
	  ))

(define-interface ultrix-network-extras-interface
  (export socket/debug
	  socket/accept-connect
	  socket/reuse-address
	  socket/keep-alive
	  socket/dont-route
	  socket/broadcast
	  socket/use-loop-back
	  socket/linger
	  socket/oob-inline
;	  socket/use-privileged
;	  socket/cant-signal
	  socket/send-buffer
	  socket/receive-buffer
	  socket/send-low-water
	  socket/receive-low-water
	  socket/send-timeout
	  socket/receive-timeout
	  socket/error
	  socket/type
	  ip/options
;	  ip/time-to-live
	  tcp/no-delay
	  tcp/max-segment))

(define-interface ultrix-extras-interface
  (compound-interface ultrix-errno-extras-interface
		      ultrix-fdflags-extras-interface
		      ultrix-network-extras-interface
		      ultrix-signals-extras-interface))

(define-interface ultrix-defs-interface
  (compound-interface ultrix-extras-interface
		      sockets-network-interface
		      posix-errno-interface
		      posix-fdflags-interface
		      posix-signals-interface))

(define-structure ultrix-defs ultrix-defs-interface
  (open scheme bitwise)
  (files enumconst fdflags errno signals netconst))
