/* SCHEME->C */

/*              Copyright 1989 Digital Equipment Corporation
 *                         All Rights Reserved
 *
 * Permission to use, copy, and modify this software and its documentation is
 * hereby granted only under the following terms and conditions.  Both the
 * above copyright notice and this permission notice must appear in all copies
 * of the software, derivative works or modified versions, and any portions
 * thereof, and both notices must appear in supporting documentation.
 *
 * Users of this software agree to the terms and conditions set forth herein,
 * and hereby grant back to Digital a non-exclusive, unrestricted, royalty-free
 * right and license under any changes, enhancements or extensions made to the
 * core functions of the software, including but not limited to those affording
 * compatibility with other hardware or software environments, but excluding
 * applications which incorporate this software.  Users further agree to use
 * their best efforts to return to Digital any such changes, enhancements or
 * extensions that they make and inform Digital of noteworthy uses of this
 * software.  Correspondence should be provided to Digital at:
 * 
 *                       Director of Licensing
 *                       Western Research Laboratory
 *                       Digital Equipment Corporation
 *                       250 University Avenue
 *                       Palo Alto, California  94301  
 * 
 * This software may be distributed (but not offered for sale or transferred
 * for compensation) to third parties, provided such third parties agree to
 * abide by the terms and conditions of this notice.  
 * 
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
*/

/* During critical sections in the Scheme system, signals may not be acted
   upon.  As one such critical section is in CONS, a cheap signal masking
   mechanism is required which is implemented as follows.

   A critical section is entered by invoking MUTEXON:
*/

#define MUTEXON  sc_mutex = 1

extern int sc_mutex;	/* Mutual exclusion flag */

/* The code in the critical section is then executed the section is exited by
   invoking MUTEXOFF:
*/

#define MUTEXOFF  if (sc_mutex = sc_pendingsignals)  \
		     sc_sendpendingsignals()

extern int  sc_pendingsignals; 
extern      sc_sendpendingsignals();

/* Signals that are caught by a Scheme->C program enter through the following
   procedure.  If the Scheme system is not in a critical section, then the
   user's signal handler will be directly called.  Otherwise, the signal
   will be defered until the critical section is exited.
*/

extern void  sc_onsignal1();

/* During garbage collection, signals are blocked by calling:

	sc_gcinprogress( 1 )

   at the start of collection, and enabled by calling

	sc_gcinprogress( 0 )

   at the end of collection.
*/

extern int  sc_collecting;	/* Boolean indicating GC in progress */

extern	sc_gcinprogress();

/* Arithmetic traps are enabled by the following function. */

extern  sc_mathtraps();
