;;;; "Init.scm", Scheme initialization code for SCM.
;;; Copyright (C) 1991 Aubrey Jaffer.
;;; See the file `COPYING' for terms applying to this program.

;;; (library-vicinity) should be defined to be the pathname of the
;;; directory where files of Scheme library functions reside.

(define library-vicinity
  (let ((library-path
	 (or (and (memq 'getenv *features*)
		  (getenv "SCHEME_LIBRARY_PATH"))
	     (case (software-type)
	       ((UNIX) "/usr/lib/scheme/")
	       ((VMS) "lib$scheme:")
	       ((MSDOS) "C:\\SCMLIB\\")
	       (else "")))))

    (lambda () library-path)))

;;; program-vicinity is here in case the Scheme Library cannot be found.
(define program-vicinity
  (let ((*vicinity-suffix*
	 (case (software-type)
	   ((UNIX)	'(#\/))
	   ((VMS)	'(#\: #\]))
	   ((MSDOS)	'(#\\)))))
    (lambda ()
      (let loop ((i (- (string-length *load-pathname*) 1)))
	(cond ((negative? i) "")
	      ((memv (string-ref *load-pathname* i)
		     *vicinity-suffix*)
	       (substring *load-pathname* 0 (+ i 1)))
	      (else (loop (- i 1))))))))

(define in-vicinity string-append)

(cond ((try-load (in-vicinity (library-vicinity) "require.scm")))
      (else
       (write *load-pathname*)
       (display ": WARNING: Couldn't find require.scm in (library-vicinity)")
       (write (library-vicinity))
       (newline)))

;;; DO NOT MOVE!  This has to be done after "require.scm" is loaded.
(set! load
      (lambda (file)
	(cond ((> (verbose) 0)
	       (display ";loading ")
	       (write file)
	       (newline)))
	(or (try-load file)
	    ;;HERE is where the suffix gets specified
	    (try-load (string-append file ".scm"))
	    (error "LOAD couldn't find file " file))
	(cond ((> (verbose) 0)
	       (display ";done loading ")
	       (write file)
	       (newline)))))

;;; This is the vicinity where this file resides.
(define implementation-vicinity
  (let ((vic (program-vicinity)))
    (lambda () vic)))

(define (terms)
  (list-file (in-vicinity (implementation-vicinity) "COPYING")))

(define (list-file file)
  (call-with-input-file file
    (lambda (inport)
      (do ((c (read-char inport) (read-char inport)))
	  ((eof-object? c))
	(write-char c)))))

(if (= (length (program-arguments)) 1) (verbose 1))

;;; This loads the user's initialization file or program arguments.
(or
 (member "-no-init-file" (program-arguments))
 (try-load (in-vicinity (or (getenv "HOME") (user-vicinity))
			"ScmInit.scm"))
 (for-each load (cdr (program-arguments))))
