;;; FORMAT conformance test
;;; Version 1.1

(require 'format)

(define fails 0)
(define ok 0)

(define (test format-args out-str)
  (display "Testing ")
  (write format-args)
  (display " ... ")
  (let ((format-out (apply format `(#f ,@format-args))))
    (if (string=? out-str format-out)
	(begin
	  (display "ok.")
	  (set! ok (+ ok 1)))
	(begin
	  (display "returns ")
	  (write format-out)
	  (display " instead of ")
	  (write out-str)
	  (set! fails (+ fails 1)))))
  (newline))
	
; type test

(test '("abc") "abc")
(test '("~a" 10) "10")
(test '("~a" -1.2) "-1.2")
(test '("~a" a) "a")
(test '("~a" #t) "#t")
(test '("~a" #f) "#f")
(test '("~a" "abc") "abc")
(test '("~a" #(1 2 3)) "#(1 2 3)")
(test '("~a" ()) "()")			; MIT and T scheme return #f
(test '("~a" (a)) "(a)")
(test '("~a" (a b)) "(a b)")
(test '("~a" (a (b c) d)) "(a (b c) d)")
(test '("~a" (a . b)) "(a . b)")	; doesn't work for T
(test '("~a" (a (b c . d))) "(a (b . (c . d)))") ; still ugly 
(test `("~a" ,display) "#[procedure]")
(test `("~a" ,(current-input-port)) "#[input-port]")
(test `("~a" ,(current-output-port)) "#[output-port]")

; # argument test

(test '("~a ~a" 10 20) "10 20")
(test '("~a abc ~a def" 10 20) "10 abc 20 def")

; escape test

(test '("~s" "abc") "\"abc\"")
;(test '("~s" #\ ) "#\\ ")
(test '("~d" 100) "100")
(test '("~x" 100) "64")			; SCI does a `#x'-prefix
(test '("~o" 100) "144")		; SCI does a `#o'-prefix
(test '("~b" 100) "1100100")		; SCI does a `#b'-prefix
(test '("~c" #\a) "a")
(test '("test~p" 1) "test")
(test '("test~p" 2) "tests")
(test '("~~~~") "~~")
(test '("~%") "
")
(test '("~3%") "


")
(test '("~|") "")
(test '("~_~_~_") "   ")
(test '("~3_") "   ")
(test '("~t") "	")
(test '("~3t") "			")
(test '("~a ~? ~a" 10 "~a ~a" 20 30 40) "10 20 30 40")

; field test

(test '("~10a" "abc") "       abc")
(test '("~10a" "0123456789abc") "0123456789abc")
(test '("~-10a" "abc") "abc       ")
(test '("~-10a" "0123456789abc") "0123456789abc")
(test '("~10.3a" "abcdef") "       abc")
(test '("~-10.3a" "abcdef") "abc       ")
(test '("~10.-3a" "abcdef") "abc       ")
(test '("~010a" 120) "0000000120")
(test '("~-010a" 120) "120       ")

; uppercase test

(test '("~A" abc) "ABC")
(test '("~A" #t) "#T")
(test '("~A" "abc") "abc")
(test '("TEST~P" 2) "TESTS")
(test '("~x" 255) "ff")
(test '("~X" 255) "FF")
(test '("~S" abc) "ABC")

; slashify test

(test '("~s" "abc \\ abc") "\"abc \\\\ abc\"")
(test '("~a" "abc \\ abc") "abc \\ abc")
(test '("~s" "abc \" abc") "\"abc \\\" abc\"")
(test '("~a" "abc \" abc") "abc \" abc")
(test '("~s" #\ ) "#\\ ")
(test '("~S" #\ ) "#\\ ")
;(test '("~s" #\newline) "#\newline")
;(test '("~S" #\newline) "#\NEWLINE")
(test '("~s" #\	) "#\\	")
(test '("~S" #\	) "#\\	")
(test '("~s" #\a) "#\\a")
(test '("~S" #\a) "#\\a")
(test `("~S" ,display) "#[PROCEDURE]")

(format #t "~%~a Tests completed. (~a failure~p)~2%" (+ ok fails) fails fails)
