;;;; Template for configuration of *features* for Scheme
;;; Copyright (C) 1991, 1992 Aubrey Jaffer.

;;; (software-type) should be set to the generic operating system type.
;;; UNIX, VMS, MACOS, AMIGA and MSDOS are supported.

(define (software-type) 'UNIX)

;;; *features* should be set to a list of symbols describing features
;;; of this implementation.  Suggestions for features are:

(define *features*
      '(
	rev4-report			;conforms to
;	rev3-report			;conforms to
	ieee-p1178			;conforms to
;	sicp				;runs code from Structure and
					;Interpretation of Computer
					;Programs by Abelson and Sussman.
	rev4-optional-procedures
	rev3-procedures
	rev2-procedures
	multiarg/and-
	multiarg-apply
;	rationalize
;	delay				;has delay and force
;	i/o-redirection			;with-input-from-file
					;with-output-from-file
;	char-ready?			;has
;	transcript			;transcript-on and transcript-off
;	macro				;has r4rs high level macros
		
;	eval				;slib:eval is single argument eval.
;	record				;has user defined data structures
;	values				;proposed multiple values
;	ieee-floating-point		;conforms to
	full-continuation		;can return multiple times

;	sort
;	queue				;queues
;	pretty-print
;	format
;	compiler			;has (compiler)
;	ed				;(ed) is editor
	system				;posix (system <string>)
	getenv				;posix (getenv <string>)
	tmpnam				;posix (tmpnam)
	program-arguments		;returns list of strings (argv)
;	Xwindows			;X support
;	curses				;screen management package
;	termcap				;terminal description package
;	terminfo			;sysV terminal description
	))

;;; (OUTPUT-PORT-WIDTH <port>)
(define (output-port-width . arg) 79)

;;; FORCE-OUTPUT flushes any pending output on optional arg output port
;;; use this definition if your system doesn't have such a procedure.
(define (force-output . arg) #t)

;;; MOST-POSITIVE-FIXNUM is used in modular.scm
(define most-positive-fixnum #x0FFFFFFF)

;;; If your implementation provides eval SLIB:EVAL is single argument
;;; eval using the top-level (user) environment.  SLIB:EVAL! is the
;;; same but doesn't neccessarily return a value.
;(define slib:eval eval)
;(define slib:eval! slib:eval)

;;; If your implementation provides R4RS macros:
;(define macro:eval! slib:eval!)
;(define macro:eval slib:eval)
;(define macro:load load)

;;; define an error procedure for the library
;(define slib:error error)

;;; define these as appropriate for your system.
(define slib:tab (integer->char 9))
(define slib:form-feed (integer->char 12))

;;; Define these if your implementation's syntax can support it and if
;;; they are not already defined.

;(define (1+ n) (+ n 1))
;(define (-1+ n) (+ n -1))
;(define 1- -1+)

;;; (implementation-vicinity) should be defined to be the pathname of
;;; the directory where any auxillary files to your Scheme
;;; implementation reside.

(define (implementation-vicinity)
  (case (software-type)
    ((UNIX)	 "/usr/src/scheme/")
    ((VMS)	"scheme$src:")
    ((MSDOS)	"C:\\scheme\\")))

;;; (library-vicinity) should be defined to be the pathname of the
;;; directory where files of Scheme library functions reside.

(define library-vicinity
  (let ((library-path
	 (if (memq 'getenv *features*)
	     (or (getenv "SCHEME_LIBRARY_PATH") "")
;;; Uses this path if your scheme does not support GETENV.
	     (case (software-type)
	       ((UNIX) "/usr/lib/scheme/")
	       ((VMS) "lib$scheme:")
	       ((MSDOS) "C:\\SLIB\\")
	       (else "")))))

    (lambda () library-path)))

(define scheme-file-suffix
  (case (software-type)
    ((NOSVE) (lambda () "_scm"))
    (else (lambda () ".scm"))))

(define in-vicinity string-append)

(load (in-vicinity (library-vicinity) "require" (scheme-file-suffix)))
