;; FILE		"oop.scm"
;; IMPLEMENTS	Yet Another Scheme Object System
;; AUTHOR	Kenneth Dickey
;; DATE		1992 March 1
;; LAST UPDATED	1992 March 4
;; SEE ALSO	"oop.doc"

;; REQUIRES	R4RS Syntax System


;; INSTANCES

; (define-predicate instance?)
; (define (make-instance dispatcher)
;    (object
; 	((instance?  self) #t)
;       ((dispatcher self) dispatcher)
; )  )

;  If you can't make this native, you can redefine the WRITE and
; DISPLAY routines to use PRINT (see "oop.doc") to hide the
; (instance . #[proc]) output.

(define make-instance 'bogus)  ;; defined below
(define instance?     'bogus)
(define instance-dispatcher 'bogus)

(let ( (instance-tag (list 'instance)) )  ;; Make a unique tag.  Nothing else
					  ;; is EQ? to this tag.
  (set! MAKE-INSTANCE
     (lambda (dispatcher) (cons instance-tag dispatcher)))

  (set! INSTANCE?
     (lambda (obj) (and (pair? obj) (eq? (car obj) instance-tag))))

  (set! INSTANCE-DISPATCHER cdr)
)

;; DEFINE-OPERATION

(define-syntax DEFINE-OPERATION
  (syntax-rules ()
    ((define-operation (<name> <inst> <arg> ...) <exp1> <exp2> ...)
     ;;=>
     (define <name>
       (letrec ( (self
                  (lambda (<inst> <arg> ...)
		   (cond
		     ((and (instance? <inst>) 
		           ((instance-dispatcher <inst>) self))
		      => (lambda (method) (method <inst> <arg> ...))
                     )
		     (else <exp1> <exp2> ...)
            ) ) )  )
        self)
  ))
  ((define-operation (<name> <inst> <arg> ...) ) ;; no body
   ;;=>
   (define <name>
     (letrec ( (self
                (lambda (<inst> <arg> ...)
		   (cond
		       ((and (instance? <inst>) 
		             ((instance-dispatcher <inst>) self))
		        => (lambda (method) (method <inst> <arg> ...))
                       )
		       (else (slib:error "Operation not handled"
					 '<name> <inst>))
              ) ) )  )
        self)
  ))
) )


;; DEFINE-PREDICATE

(define-syntax DEFINE-PREDICATE
  (syntax-rules ()
    ((define-predicate <name>)
     ;;=>
     (define-operation (<name> obj) #f)
    )
) )


;; OBJECT

(define-syntax OBJECT
  (syntax-rules ()
    ((object ((<name> <self> <arg> ...) <exp1> <exp2> ...) ...)
    ;;=>
     (make-instance
       (lambda (op)
	 (cond
           ((assq op (list 
                      (cons <name>
		             (lambda (<self> <arg> ...) <exp1> <exp2> ...))
                      ...
                     )
            ) => cdr
           )
           (else #f)
         )
    )) )
) )



;; OBJECT with MULTIPLE INHERITANCE  {First Found Rule}

(define-syntax OBJECT-WITH-ANCESTORS
  (syntax-rules ()
    ((object-with-ancestors ( (<ancestor1> <init1>) ... ) <operation> ...)
    ;;=>
     (let ( (<ancestor1> <init1>) ...  )
      (let ( (child (object <operation> ...)) )
       (make-instance
         (lambda (op) 
            (or ((instance-dispatcher child) op)
	        ((instance-dispatcher <ancestor1>) op) ...
       ) )  )
    )))
) )


;; OPERATE-AS  {a.k.a. send-to-super}

; used in operations/methods

(define-syntax OPERATE-AS
  (syntax-rules ()
   ((operate-as <component> <op> <composit> <arg> ...)
   ;;=>
    (((instance-dispatcher <component>) <op>) <composit> <arg> ...)
  ))
)


;;			--- E O F ---
