;;;; "process.scm",  Multi-Processing for Scheme
;;; Copyright (C) 1992 Aubrey Jaffer.

;;;;STILL NOT WORKING

;  (add-process! proc)					procedure
;
;Adds proc, which must be a procedure (or continuation) capable of
;accepting accepting one argument, to the process:queue.  The value
;returned is unspecified.  The argument to proc should be ignored.  If
;proc returns the process is killed.
;
;  (process:schedule!)					procedure
;
;Saves the current process on process:queue and runs the next process
;from process:queue.  The value returned is unspecified.
;
;  (kill-process!)					procedure
;
;Kills the current process and runs the next process from
;process:queue.  If there are no more processes on process:queue
;(quit) is called.
;
;;;;----------------------------------------------------------------------

(require 'full-continuation)
(require 'queue)

(define (add-process! thunk1)
  (cond ((procedure? thunk1)
	 (defer-ints)
	 (enqueue! process:queue thunk1)
	 (allow-ints))
	(else (slib:error "add-process!: wrong type argument " thunk1))))

(define (process:schedule!)
  (defer-ints)
  (cond ((queue-empty? process:queue) (allow-ints)
				      'still-running)
	(else (call-with-current-continuation
	       (lambda (cont)
		 (enqueue! process:queue cont)
		 (let ((proc (dequeue! process:queue)))
		   (allow-ints)
		   (proc 'run))
		 (kill-process!))))))

(define (kill-process!)
  (defer-ints)
  (cond ((queue-empty? process:queue) (allow-ints)
				      (quit))
	(else (let ((proc (dequeue! process:queue)))
		(allow-ints)
		(proc 'run))
	      (kill-process!))))

(define ints-disabled #f)
(define alarm-deferred #f)

(define (defer-ints) (set! ints-disabled #t))

(define (allow-ints)
  (set! ints-disabled #f)
  (cond (alarm-deferred
	  (set! alarm-deferred #f)
	  (alarm-interrupt))))

;;; Make THE process queue.
(define process:queue (make-queue))

(define (alarm-interrupt)
  (alarm 1)
  (if ints-disabled (set! alarm-deferred #t)
      (process:schedule!)))
