;;;; Implementation of VICINITY and MODULES for Scheme
;;; Copyright (C) 1991, 1992 Aubrey Jaffer.

;;;; WARNING: this code redefines LOAD.

(define (user-vicinity)
  (case (software-type)
    ((VMS)	"[.]")
    (else	"")))

(define program-vicinity
  (let ((*vicinity-suffix*
	 (case (software-type)
	   ((NOSVE)	'(#\: #\.))
	   ((AMIGA)	'(#\: #\/))
	   ((UNIX)	'(#\/))
	   ((VMS)	'(#\: #\]))
	   ((MSDOS ATARIST)	'(#\\))
	   ((MACOS THINKC)	'(#\:)))))
    (lambda ()
      (let loop ((i (- (string-length *load-pathname*) 1)))
	(cond ((negative? i) "")
	      ((memv (string-ref *load-pathname* i)
		     *vicinity-suffix*)
	       (substring *load-pathname* 0 (+ i 1)))
	      (else (loop (- i 1))))))))

(define sub-vicinity
  (case (software-type)
    ((VMS)
     (lambda
      (vic name)
      (let ((l (string-length vic)))
	(if (or (zero? (string-length vic))
		(not (char=? #\] (string-ref vic (- l 1)))))
	    (string-append vic "[" name "]")
	    (string-append (substring vic 0 (- l 1))
			   "." name "]")))))
    (else
     (let ((*vicinity-suffix*
	    (case (software-type)
	      ((NOSVE)	".")
	      ((UNIX AMIGA) "/")
	      ((MSDOS ATARIST)	"\\"))))
       (lambda (vic name)
	 (string-append vic name *vicinity-suffix*))))))

(define in-vicinity string-append)

(define (make-vicinity <pathname>) <pathname>)

(define *catalog*
  (map
   (lambda (p)
     (cons (car p)
	   (if (pair? (cdr p))
	       (cons 
		(cadr p)
		(in-vicinity (library-vicinity) (cddr p) (scheme-file-suffix)))
	       (in-vicinity (library-vicinity) (cdr p) (scheme-file-suffix)))))
   '(
     (rev4-optional-procedures	.	"sc4opt")
     (rev3-procedures		.	"sc3")
     (rev2-procedures		.	"sc2")
     (multiarg/and-		.	"mularg")
     (multiarg-apply		.	"mulapply")
     (rationalize		.	"ratize")
     (alist			.	"alist")
     (hash			.	"hash")
     (hash-table		.	"hashtab")
     (logical			.	"logical")
     (random			.	"random")
     (random-inexact		.	"randinex")
     (modular			.	"modular")
     (prime			.	"prime")
     (charplot			.	"charplot")
     (sort			.	"sort")
     (common-list-functions	.	"comlist")
     (format			.	"format")
     (generic-write		.	"genwrite")
     (pretty-print		.	"pp")
     (pprint-file		.	"ppfile")
     (pretty-print-to-string	.	"pp2str")
     (object->string		.	"obj2str")
     (stdio			.	"stdio")
     (debug			.	"debug")
     (eval			.	"eval")
     (record			.	"record")
     (promise			.	"promise")
     (synchk			.	"synchk")
     (sc-macro			.	"sc-macro")
     (macro			.	"sc-macro")
     (oop		macro	.	"oop")
     (values			.	"values")
     (queue			.	"queue")
     (priority-queue		.	"priorque")
     (process			.	"process")
     (test			.	"test")
     )))

(define *load-pathname* #f)

(define load				;WARNING: redefining LOAD
  (let ((*old-load* load))
    (lambda (<pathname> . extra)
      (let ((old-load-pathname *load-pathname*))
	(set! *load-pathname* <pathname>)
	(apply *old-load* <pathname> extra)
	(require:provide <pathname>)
	(set! *load-pathname* old-load-pathname)))))

;;;; MODULES

(define *modules* '())

(define (require:provided? feature)
  (if (symbol? feature)
      (if (memq feature *features*) #t
	  (let ((path (cdr (or (assq feature *catalog*) '(#f . #f)))))
	    (and path (member path *modules*) #t)))
      (and (member feature *modules*) #t)))

(define (require:require feature)
  (if (symbol? feature)
      (or (memq feature *features*)
	  (let ((path (cdr (or (assq feature *catalog*) '(#f . #f)))))
	    (cond ((not path)
		   (newline)
		   (display ";required feature not supported: ")
		   (display feature)
		   (newline)
		   (slib:error ";required feature not supported: " feature))
		  ((member (if (pair? path) (cdr path) path) *modules*))
		  ((pair? path)
		   (require (car path))
		   (macro:load (cdr path))
		   (require:provide feature))
		  (else
		   (load path)
		   (require:provide feature)))))
      (or (member feature *modules*)
	  (begin (load feature)
		 (require:provide feature))))
  #t)

(define (require:provide feature)
  (if (symbol? feature)
      (if (not (memq feature *features*))
	  (set! *features* (cons feature *features*)))
      (if (not (member feature *modules*))
	  (set! *modules* (cons feature *modules*)))))

(require:provide 'vicinity)

(define provide require:provide)
(define provided? require:provided?)
(define require require:require)

(if (inexact? (string->number "0.0")) (provide 'inexact))
(if (rational? (string->number "1/19")) (provide 'rational))
(if (real? (string->number "0.0")) (provide 'real))
(if (complex? (string->number "1+i")) (provide 'complex))
(if (exact? (string->number "9999999999999999999999999999999"))
    (provide 'bignum))
