; "fluidlet.scm", FLUID-LET for Scheme
; Copyright (c) 1992, Dorai Sitaram

;   (fluid-let ((<variable> <init>) ...)		syntax
;	   <expression>  <expression> ...)

;The <init>s are evaluated in the current environment (in some
;unspecified order), the current values of the <variable>s are saved,
;the results are assigned to the <variable>s, the <expression>s are
;evaluated sequentially in the current environment, the <variable>s
;are restored to their original values, and the value of the last
;<expression> is returned.

;The syntax of this special form is similar to that of `let', but
;`fluid-let' temporarily rebinds existing <variable>s.  Unlike `let',
;`fluid-let' creates no new bindings; instead it *assigns* the values
;of each <init> to the binding (determined by the rules of lexical
;scoping) of its corresponding <variable>.

;--- dorai@cs.rice.edu

(require 'rev4-optional-procedures)
(require 'common-list-functions)
(require 'dynamic-wind)
(require 'macro)

(define list-set! (lambda (s i v) (set-car! (list-tail s i) v)))

(define-syntax fluid-let
  (syntax-rules ()
    ((fluid-let ((x v) ...) . body)
     (let ((%x-names (list 'x ...))
	   (%x-values (list x ...))
	   (%fluid-x-values (list v ...)))
       (dynamic-wind
	 (lambda ()
           (set! x (list-ref %fluid-x-values
		       (position 'x %x-names)))
           ...)
	 (lambda () . body)
	 (lambda ()
           (let ((%x-position (position 'x %x-names)))
             (list-set! %fluid-x-values %x-position x)
	     (set! x (list-ref %x-values %x-position)))
	   ...))))))

;--- end of file
